// services/network/public/mojom/structured_headers.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/structured_headers.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/structured_headers.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool StructuredHeadersItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const StructuredHeadersItem_Data* object = static_cast<const StructuredHeadersItem_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case StructuredHeadersItem_Tag::kNullValue: {

      return true;
    }
    case StructuredHeadersItem_Tag::kIntegerValue: {

      return true;
    }
    case StructuredHeadersItem_Tag::kDecimalValue: {

      return true;
    }
    case StructuredHeadersItem_Tag::kStringValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_value, 4, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& string_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_string_value, validation_context,
                                             &string_value_validate_params)) {
        return false;
      }
      return true;
    }
    case StructuredHeadersItem_Tag::kTokenValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_token_value, 5, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& token_value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_token_value, validation_context,
                                             &token_value_validate_params)) {
        return false;
      }
      return true;
    }
    case StructuredHeadersItem_Tag::kByteSequenceValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_byte_sequence_value, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_byte_sequence_value, validation_context))
        return false;
      return true;
    }
    case StructuredHeadersItem_Tag::kBooleanValue: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in StructuredHeadersItem");
      return false;
    }
  }
}


// static
bool StructuredHeadersParameter_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StructuredHeadersParameter_Data* object =
      static_cast<const StructuredHeadersParameter_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->item, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->item, validation_context))
    return false;

  return true;
}

StructuredHeadersParameter_Data::StructuredHeadersParameter_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StructuredHeadersParameterizedItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StructuredHeadersParameterizedItem_Data* object =
      static_cast<const StructuredHeadersParameterizedItem_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->item, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->item, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parameters, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parameters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parameters, validation_context,
                                         &parameters_validate_params)) {
    return false;
  }

  return true;
}

StructuredHeadersParameterizedItem_Data::StructuredHeadersParameterizedItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StructuredHeadersParameterizedMember_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StructuredHeadersParameterizedMember_Data* object =
      static_cast<const StructuredHeadersParameterizedMember_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->member, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& member_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->member, validation_context,
                                         &member_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parameters, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parameters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parameters, validation_context,
                                         &parameters_validate_params)) {
    return false;
  }

  return true;
}

StructuredHeadersParameterizedMember_Data::StructuredHeadersParameterizedMember_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StructuredHeadersDictionaryMember_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StructuredHeadersDictionaryMember_Data* object =
      static_cast<const StructuredHeadersDictionaryMember_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

StructuredHeadersDictionaryMember_Data::StructuredHeadersDictionaryMember_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StructuredHeadersDictionary_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StructuredHeadersDictionary_Data* object =
      static_cast<const StructuredHeadersDictionary_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->members, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& members_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->members, validation_context,
                                         &members_validate_params)) {
    return false;
  }

  return true;
}

StructuredHeadersDictionary_Data::StructuredHeadersDictionary_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network