// services/network/public/mojom/link_header.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/link_header.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/link_header.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/link_header.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/request_priority.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT LinkHeader {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LinkHeader, T>::value>;
  using DataView = LinkHeaderDataView;
  using Data_ = internal::LinkHeader_Data;

  template <typename... Args>
  static LinkHeaderPtr New(Args&&... args) {
    return LinkHeaderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LinkHeaderPtr From(const U& u) {
    return mojo::TypeConverter<LinkHeaderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LinkHeader>::Convert(*this);
  }


  LinkHeader();

  LinkHeader(
      const ::blink::KURL& href,
      LinkRelAttribute rel,
      LinkAsAttribute as,
      CrossOriginAttribute cross_origin,
      ::network::mojom::blink::FetchPriorityAttribute fetch_priority,
      const WTF::String& mime_type);


  ~LinkHeader();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LinkHeaderPtr>
  LinkHeaderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LinkHeader::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LinkHeader::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LinkHeader_UnserializedMessageContext<
            UserType, LinkHeader::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LinkHeader::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LinkHeader::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LinkHeader_UnserializedMessageContext<
            UserType, LinkHeader::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LinkHeader::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL href;
  
  LinkRelAttribute rel;
  
  LinkAsAttribute as;
  
  CrossOriginAttribute cross_origin;
  
  ::network::mojom::blink::FetchPriorityAttribute fetch_priority;
  
  WTF::String mime_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LinkHeader::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LinkHeaderPtr LinkHeader::Clone() const {
  return New(
      mojo::Clone(href),
      mojo::Clone(rel),
      mojo::Clone(as),
      mojo::Clone(cross_origin),
      mojo::Clone(fetch_priority),
      mojo::Clone(mime_type)
  );
}

template <typename T, LinkHeader::EnableIfSame<T>*>
bool LinkHeader::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->href, other_struct.href))
    return false;
  if (!mojo::Equals(this->rel, other_struct.rel))
    return false;
  if (!mojo::Equals(this->as, other_struct.as))
    return false;
  if (!mojo::Equals(this->cross_origin, other_struct.cross_origin))
    return false;
  if (!mojo::Equals(this->fetch_priority, other_struct.fetch_priority))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  return true;
}

template <typename T, LinkHeader::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.href < rhs.href)
    return true;
  if (rhs.href < lhs.href)
    return false;
  if (lhs.rel < rhs.rel)
    return true;
  if (rhs.rel < lhs.rel)
    return false;
  if (lhs.as < rhs.as)
    return true;
  if (rhs.as < lhs.as)
    return false;
  if (lhs.cross_origin < rhs.cross_origin)
    return true;
  if (rhs.cross_origin < lhs.cross_origin)
    return false;
  if (lhs.fetch_priority < rhs.fetch_priority)
    return true;
  if (rhs.fetch_priority < lhs.fetch_priority)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::LinkHeader::DataView,
                                         ::network::mojom::blink::LinkHeaderPtr> {
  static bool IsNull(const ::network::mojom::blink::LinkHeaderPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::LinkHeaderPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::LinkHeader::href)& href(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->href;
  }

  static decltype(::network::mojom::blink::LinkHeader::rel) rel(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->rel;
  }

  static decltype(::network::mojom::blink::LinkHeader::as) as(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->as;
  }

  static decltype(::network::mojom::blink::LinkHeader::cross_origin) cross_origin(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->cross_origin;
  }

  static decltype(::network::mojom::blink::LinkHeader::fetch_priority) fetch_priority(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->fetch_priority;
  }

  static const decltype(::network::mojom::blink::LinkHeader::mime_type)& mime_type(
      const ::network::mojom::blink::LinkHeaderPtr& input) {
    return input->mime_type;
  }

  static bool Read(::network::mojom::blink::LinkHeader::DataView input, ::network::mojom::blink::LinkHeaderPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_BLINK_H_