// services/network/public/mojom/host_resolver.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/host_resolver.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/host_resolver.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* OptionalSecureDnsModeToStringHelper(OptionalSecureDnsMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OptionalSecureDnsMode::NO_OVERRIDE:
      return "NO_OVERRIDE";
    case OptionalSecureDnsMode::OFF:
      return "OFF";
    case OptionalSecureDnsMode::AUTOMATIC:
      return "AUTOMATIC";
    case OptionalSecureDnsMode::SECURE:
      return "SECURE";
    default:
      return nullptr;
  }
}

std::string OptionalSecureDnsModeToString(OptionalSecureDnsMode value) {
  const char *str = OptionalSecureDnsModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OptionalSecureDnsMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OptionalSecureDnsMode value) {
  return os << OptionalSecureDnsModeToString(value);
}

NOINLINE static const char* SecureDnsModeToStringHelper(SecureDnsMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SecureDnsMode::OFF:
      return "OFF";
    case SecureDnsMode::AUTOMATIC:
      return "AUTOMATIC";
    case SecureDnsMode::SECURE:
      return "SECURE";
    default:
      return nullptr;
  }
}

std::string SecureDnsModeToString(SecureDnsMode value) {
  const char *str = SecureDnsModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SecureDnsMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SecureDnsMode value) {
  return os << SecureDnsModeToString(value);
}

NOINLINE static const char* SecureDnsPolicyToStringHelper(SecureDnsPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SecureDnsPolicy::ALLOW:
      return "ALLOW";
    case SecureDnsPolicy::DISABLE:
      return "DISABLE";
    default:
      return nullptr;
  }
}

std::string SecureDnsPolicyToString(SecureDnsPolicy value) {
  const char *str = SecureDnsPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SecureDnsPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SecureDnsPolicy value) {
  return os << SecureDnsPolicyToString(value);
}

NOINLINE static const char* DnsQueryTypeToStringHelper(DnsQueryType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DnsQueryType::UNSPECIFIED:
      return "UNSPECIFIED";
    case DnsQueryType::A:
      return "A";
    case DnsQueryType::AAAA:
      return "AAAA";
    case DnsQueryType::TXT:
      return "TXT";
    case DnsQueryType::PTR:
      return "PTR";
    case DnsQueryType::SRV:
      return "SRV";
    case DnsQueryType::HTTPS:
      return "HTTPS";
    default:
      return nullptr;
  }
}

std::string DnsQueryTypeToString(DnsQueryType value) {
  const char *str = DnsQueryTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DnsQueryType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DnsQueryType value) {
  return os << DnsQueryTypeToString(value);
}

NOINLINE static const char* DnsConfigOverrides_TristateToStringHelper(DnsConfigOverrides_Tristate value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DnsConfigOverrides_Tristate::NO_OVERRIDE:
      return "NO_OVERRIDE";
    case DnsConfigOverrides_Tristate::TRISTATE_TRUE:
      return "TRISTATE_TRUE";
    case DnsConfigOverrides_Tristate::TRISTATE_FALSE:
      return "TRISTATE_FALSE";
    default:
      return nullptr;
  }
}

std::string DnsConfigOverrides_TristateToString(DnsConfigOverrides_Tristate value) {
  const char *str = DnsConfigOverrides_TristateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DnsConfigOverrides_Tristate value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DnsConfigOverrides_Tristate value) {
  return os << DnsConfigOverrides_TristateToString(value);
}

NOINLINE static const char* ResolveHostParameters_SourceToStringHelper(ResolveHostParameters_Source value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolveHostParameters_Source::ANY:
      return "ANY";
    case ResolveHostParameters_Source::SYSTEM:
      return "SYSTEM";
    case ResolveHostParameters_Source::DNS:
      return "DNS";
    case ResolveHostParameters_Source::MULTICAST_DNS:
      return "MULTICAST_DNS";
    case ResolveHostParameters_Source::LOCAL_ONLY:
      return "LOCAL_ONLY";
    default:
      return nullptr;
  }
}

std::string ResolveHostParameters_SourceToString(ResolveHostParameters_Source value) {
  const char *str = ResolveHostParameters_SourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolveHostParameters_Source value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Source value) {
  return os << ResolveHostParameters_SourceToString(value);
}

NOINLINE static const char* ResolveHostParameters_CacheUsageToStringHelper(ResolveHostParameters_CacheUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolveHostParameters_CacheUsage::ALLOWED:
      return "ALLOWED";
    case ResolveHostParameters_CacheUsage::STALE_ALLOWED:
      return "STALE_ALLOWED";
    case ResolveHostParameters_CacheUsage::DISALLOWED:
      return "DISALLOWED";
    default:
      return nullptr;
  }
}

std::string ResolveHostParameters_CacheUsageToString(ResolveHostParameters_CacheUsage value) {
  const char *str = ResolveHostParameters_CacheUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolveHostParameters_CacheUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolveHostParameters_CacheUsage value) {
  return os << ResolveHostParameters_CacheUsageToString(value);
}

NOINLINE static const char* ResolveHostParameters_PurposeToStringHelper(ResolveHostParameters_Purpose value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResolveHostParameters_Purpose::kUnspecified:
      return "kUnspecified";
    case ResolveHostParameters_Purpose::kPreconnect:
      return "kPreconnect";
    default:
      return nullptr;
  }
}

std::string ResolveHostParameters_PurposeToString(ResolveHostParameters_Purpose value) {
  const char *str = ResolveHostParameters_PurposeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResolveHostParameters_Purpose value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Purpose value) {
  return os << ResolveHostParameters_PurposeToString(value);
}

NOINLINE static const char* MdnsListenClient_UpdateTypeToStringHelper(MdnsListenClient_UpdateType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MdnsListenClient_UpdateType::ADDED:
      return "ADDED";
    case MdnsListenClient_UpdateType::CHANGED:
      return "CHANGED";
    case MdnsListenClient_UpdateType::REMOVED:
      return "REMOVED";
    default:
      return nullptr;
  }
}

std::string MdnsListenClient_UpdateTypeToString(MdnsListenClient_UpdateType value) {
  const char *str = MdnsListenClient_UpdateTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MdnsListenClient_UpdateType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MdnsListenClient_UpdateType value) {
  return os << MdnsListenClient_UpdateTypeToString(value);
}

namespace internal {
// static
bool HostResolverHost_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const HostResolverHost_Data* object = static_cast<const HostResolverHost_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case HostResolverHost_Tag::kSchemeHostPort: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scheme_host_port, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scheme_host_port, validation_context))
        return false;
      return true;
    }
    case HostResolverHost_Tag::kHostPortPair: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_host_port_pair, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_host_port_pair, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in HostResolverHost");
      return false;
    }
  }
}


// static
bool DnsOverHttpsServerConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsOverHttpsServerConfig_Data* object =
      static_cast<const DnsOverHttpsServerConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_template, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& server_template_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->server_template, validation_context,
                                         &server_template_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  return true;
}

DnsOverHttpsServerConfig_Data::DnsOverHttpsServerConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsOverHttpsConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsOverHttpsConfig_Data* object =
      static_cast<const DnsOverHttpsConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->servers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& servers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->servers, validation_context,
                                         &servers_validate_params)) {
    return false;
  }

  return true;
}

DnsOverHttpsConfig_Data::DnsOverHttpsConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigOverrides_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsConfigOverrides_Data* object =
      static_cast<const DnsConfigOverrides_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& nameservers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nameservers, validation_context,
                                         &nameservers_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->search, validation_context,
                                         &search_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->append_to_multi_label_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fallback_period, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->rotate, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->use_local_ipv6, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dns_over_https_config, validation_context))
    return false;


  if (!::network::mojom::internal::OptionalSecureDnsMode_Data
        ::Validate(object->secure_dns_mode, validation_context))
    return false;


  if (!::network::mojom::internal::DnsConfigOverrides_Tristate_Data
        ::Validate(object->allow_dns_over_https_upgrade, validation_context))
    return false;

  return true;
}

DnsConfigOverrides_Data::DnsConfigOverrides_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveHostParameters_Data* object =
      static_cast<const ResolveHostParameters_Data*>(data);


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->dns_query_type, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->initial_priority, validation_context))
    return false;


  if (!::network::mojom::internal::ResolveHostParameters_Source_Data
        ::Validate(object->source, validation_context))
    return false;


  if (!::network::mojom::internal::ResolveHostParameters_CacheUsage_Data
        ::Validate(object->cache_usage, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->control_handle,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::SecureDnsPolicy_Data
        ::Validate(object->secure_dns_policy, validation_context))
    return false;


  if (!::network::mojom::internal::ResolveHostParameters_Purpose_Data
        ::Validate(object->purpose, validation_context))
    return false;

  return true;
}

ResolveHostParameters_Data::ResolveHostParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostHandle_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveHostHandle_Cancel_Params_Data* object =
      static_cast<const ResolveHostHandle_Cancel_Params_Data*>(data);

  return true;
}

ResolveHostHandle_Cancel_Params_Data::ResolveHostHandle_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveHostClient_OnComplete_Params_Data* object =
      static_cast<const ResolveHostClient_OnComplete_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolve_error_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resolve_error_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->resolved_addresses, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& endpoint_results_with_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->endpoint_results_with_metadata, validation_context,
                                         &endpoint_results_with_metadata_validate_params)) {
    return false;
  }

  return true;
}

ResolveHostClient_OnComplete_Params_Data::ResolveHostClient_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnTextResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveHostClient_OnTextResults_Params_Data* object =
      static_cast<const ResolveHostClient_OnTextResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_results, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->text_results, validation_context,
                                         &text_results_validate_params)) {
    return false;
  }

  return true;
}

ResolveHostClient_OnTextResults_Params_Data::ResolveHostClient_OnTextResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResolveHostClient_OnHostnameResults_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolveHostClient_OnHostnameResults_Params_Data* object =
      static_cast<const ResolveHostClient_OnHostnameResults_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hosts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hosts, validation_context,
                                         &hosts_validate_params)) {
    return false;
  }

  return true;
}

ResolveHostClient_OnHostnameResults_Params_Data::ResolveHostClient_OnHostnameResults_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnAddressResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MdnsListenClient_OnAddressResult_Params_Data* object =
      static_cast<const MdnsListenClient_OnAddressResult_Params_Data*>(data);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoint, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->endpoint, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnAddressResult_Params_Data::MdnsListenClient_OnAddressResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnTextResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MdnsListenClient_OnTextResult_Params_Data* object =
      static_cast<const MdnsListenClient_OnTextResult_Params_Data*>(data);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_records, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_records_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->text_records, validation_context,
                                         &text_records_validate_params)) {
    return false;
  }

  return true;
}

MdnsListenClient_OnTextResult_Params_Data::MdnsListenClient_OnTextResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnHostnameResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MdnsListenClient_OnHostnameResult_Params_Data* object =
      static_cast<const MdnsListenClient_OnHostnameResult_Params_Data*>(data);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnHostnameResult_Params_Data::MdnsListenClient_OnHostnameResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MdnsListenClient_OnUnhandledResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MdnsListenClient_OnUnhandledResult_Params_Data* object =
      static_cast<const MdnsListenClient_OnUnhandledResult_Params_Data*>(data);


  if (!::network::mojom::internal::MdnsListenClient_UpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  return true;
}

MdnsListenClient_OnUnhandledResult_Params_Data::MdnsListenClient_OnUnhandledResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_ResolveHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HostResolver_ResolveHost_Params_Data* object =
      static_cast<const HostResolver_ResolveHost_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->host, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->optional_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HostResolver_ResolveHost_Params_Data::HostResolver_ResolveHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_MdnsListen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HostResolver_MdnsListen_Params_Data* object =
      static_cast<const HostResolver_MdnsListen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;


  if (!::network::mojom::internal::DnsQueryType_Data
        ::Validate(object->query_type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

HostResolver_MdnsListen_Params_Data::HostResolver_MdnsListen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HostResolver_MdnsListen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HostResolver_MdnsListen_ResponseParams_Data* object =
      static_cast<const HostResolver_MdnsListen_ResponseParams_Data*>(data);

  return true;
}

HostResolver_MdnsListen_ResponseParams_Data::HostResolver_MdnsListen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data* object =
      static_cast<const DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data*>(data);

  return true;
}

DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data::DnsConfigChangeManagerClient_OnDnsConfigChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DnsConfigChangeManager_RequestNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DnsConfigChangeManager_RequestNotifications_Params_Data* object =
      static_cast<const DnsConfigChangeManager_RequestNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DnsConfigChangeManager_RequestNotifications_Params_Data::DnsConfigChangeManager_RequestNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::OptionalSecureDnsMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::OptionalSecureDnsMode value) {
  return std::move(context).WriteString(::network::mojom::OptionalSecureDnsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SecureDnsMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SecureDnsMode value) {
  return std::move(context).WriteString(::network::mojom::SecureDnsModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SecureDnsPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SecureDnsPolicy value) {
  return std::move(context).WriteString(::network::mojom::SecureDnsPolicyToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DnsQueryType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DnsQueryType value) {
  return std::move(context).WriteString(::network::mojom::DnsQueryTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DnsConfigOverrides_Tristate>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DnsConfigOverrides_Tristate value) {
  return std::move(context).WriteString(::network::mojom::DnsConfigOverrides_TristateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolveHostParameters_Source>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Source value) {
  return std::move(context).WriteString(::network::mojom::ResolveHostParameters_SourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolveHostParameters_CacheUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_CacheUsage value) {
  return std::move(context).WriteString(::network::mojom::ResolveHostParameters_CacheUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ResolveHostParameters_Purpose>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Purpose value) {
  return std::move(context).WriteString(::network::mojom::ResolveHostParameters_PurposeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::MdnsListenClient_UpdateType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::MdnsListenClient_UpdateType value) {
  return std::move(context).WriteString(::network::mojom::MdnsListenClient_UpdateTypeToString(value));
}

} // namespace perfetto