// services/device/public/mojom/battery_status.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_BATTERY_STATUS_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_BATTERY_STATUS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/battery_status.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/battery_status.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/battery_status.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace device::mojom {





class  BatteryStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatteryStatus, T>::value>;
  using DataView = BatteryStatusDataView;
  using Data_ = internal::BatteryStatus_Data;

  template <typename... Args>
  static BatteryStatusPtr New(Args&&... args) {
    return BatteryStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatteryStatusPtr From(const U& u) {
    return mojo::TypeConverter<BatteryStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatteryStatus>::Convert(*this);
  }


  BatteryStatus();

  BatteryStatus(
      bool charging,
      double charging_time,
      double discharging_time,
      double level);


  ~BatteryStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatteryStatusPtr>
  BatteryStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatteryStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatteryStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatteryStatus_UnserializedMessageContext<
            UserType, BatteryStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatteryStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatteryStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatteryStatus_UnserializedMessageContext<
            UserType, BatteryStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatteryStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool charging;
  
  double charging_time;
  
  double discharging_time;
  
  double level;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatteryStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
BatteryStatusPtr BatteryStatus::Clone() const {
  return New(
      mojo::Clone(charging),
      mojo::Clone(charging_time),
      mojo::Clone(discharging_time),
      mojo::Clone(level)
  );
}

template <typename T, BatteryStatus::EnableIfSame<T>*>
bool BatteryStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->charging, other_struct.charging))
    return false;
  if (!mojo::Equals(this->charging_time, other_struct.charging_time))
    return false;
  if (!mojo::Equals(this->discharging_time, other_struct.discharging_time))
    return false;
  if (!mojo::Equals(this->level, other_struct.level))
    return false;
  return true;
}

template <typename T, BatteryStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.charging < rhs.charging)
    return true;
  if (rhs.charging < lhs.charging)
    return false;
  if (lhs.charging_time < rhs.charging_time)
    return true;
  if (rhs.charging_time < lhs.charging_time)
    return false;
  if (lhs.discharging_time < rhs.discharging_time)
    return true;
  if (rhs.discharging_time < lhs.discharging_time)
    return false;
  if (lhs.level < rhs.level)
    return true;
  if (rhs.level < lhs.level)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::BatteryStatus::DataView,
                                         ::device::mojom::BatteryStatusPtr> {
  static bool IsNull(const ::device::mojom::BatteryStatusPtr& input) { return !input; }
  static void SetToNull(::device::mojom::BatteryStatusPtr* output) { output->reset(); }

  static decltype(::device::mojom::BatteryStatus::charging) charging(
      const ::device::mojom::BatteryStatusPtr& input) {
    return input->charging;
  }

  static decltype(::device::mojom::BatteryStatus::charging_time) charging_time(
      const ::device::mojom::BatteryStatusPtr& input) {
    return input->charging_time;
  }

  static decltype(::device::mojom::BatteryStatus::discharging_time) discharging_time(
      const ::device::mojom::BatteryStatusPtr& input) {
    return input->discharging_time;
  }

  static decltype(::device::mojom::BatteryStatus::level) level(
      const ::device::mojom::BatteryStatusPtr& input) {
    return input->level;
  }

  static bool Read(::device::mojom::BatteryStatus::DataView input, ::device::mojom::BatteryStatusPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_BATTERY_STATUS_MOJOM_H_