// mojo/public/mojom/base/big_buffer.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_INTERNAL_H_
#define MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace mojo_base::mojom {
namespace internal {
class BigBufferSharedMemoryRegion_Data;
class BigBuffer_Data;

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJO_BASE_MOJOM_SHARED) BigBuffer_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  BigBuffer_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~BigBuffer_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<BigBuffer_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class BigBuffer_Tag : uint32_t {

    
    kBytes,
    
    kSharedMemory,
    
    kInvalidBuffer,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> f_bytes;
    mojo::internal::Pointer<internal::BigBufferSharedMemoryRegion_Data> f_shared_memory;
    uint8_t f_invalid_buffer : 1;
    uint64_t unknown;
  };

  uint32_t size;
  BigBuffer_Tag tag;
  Union_ data;
};
static_assert(sizeof(BigBuffer_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(BigBuffer_Data)");
class COMPONENT_EXPORT(MOJO_BASE_MOJOM_SHARED) BigBufferSharedMemoryRegion_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data buffer_handle;
  uint32_t size;

 private:
  friend class mojo::internal::MessageFragment<BigBufferSharedMemoryRegion_Data>;

  BigBufferSharedMemoryRegion_Data();
  ~BigBufferSharedMemoryRegion_Data() = delete;
};
static_assert(sizeof(BigBufferSharedMemoryRegion_Data) == 16,
              "Bad sizeof(BigBufferSharedMemoryRegion_Data)");
// Used by BigBufferSharedMemoryRegion::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BigBufferSharedMemoryRegion_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BigBufferSharedMemoryRegion_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BigBufferSharedMemoryRegion_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<BigBufferSharedMemoryRegion_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BigBufferSharedMemoryRegion_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // mojo_base::mojom

#endif  // MOJO_PUBLIC_MOJOM_BASE_BIG_BUFFER_MOJOM_SHARED_INTERNAL_H_