// media/mojo/mojom/renderer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  Renderer_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data client;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Interface_Data>> streams;
  mojo::internal::Pointer<internal::MediaUrlParams_Data> media_url_params;

 private:
  friend class mojo::internal::MessageFragment<Renderer_Initialize_Params_Data>;

  Renderer_Initialize_Params_Data();
  ~Renderer_Initialize_Params_Data() = delete;
};
static_assert(sizeof(Renderer_Initialize_Params_Data) == 32,
              "Bad sizeof(Renderer_Initialize_Params_Data)");
class  Renderer_Initialize_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_Initialize_ResponseParams_Data>;

  Renderer_Initialize_ResponseParams_Data();
  ~Renderer_Initialize_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_Initialize_ResponseParams_Data) == 16,
              "Bad sizeof(Renderer_Initialize_ResponseParams_Data)");
class  Renderer_Flush_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_Flush_Params_Data>;

  Renderer_Flush_Params_Data();
  ~Renderer_Flush_Params_Data() = delete;
};
static_assert(sizeof(Renderer_Flush_Params_Data) == 8,
              "Bad sizeof(Renderer_Flush_Params_Data)");
class  Renderer_Flush_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Renderer_Flush_ResponseParams_Data>;

  Renderer_Flush_ResponseParams_Data();
  ~Renderer_Flush_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_Flush_ResponseParams_Data) == 8,
              "Bad sizeof(Renderer_Flush_ResponseParams_Data)");
class  Renderer_StartPlayingFrom_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time;

 private:
  friend class mojo::internal::MessageFragment<Renderer_StartPlayingFrom_Params_Data>;

  Renderer_StartPlayingFrom_Params_Data();
  ~Renderer_StartPlayingFrom_Params_Data() = delete;
};
static_assert(sizeof(Renderer_StartPlayingFrom_Params_Data) == 16,
              "Bad sizeof(Renderer_StartPlayingFrom_Params_Data)");
class  Renderer_SetPlaybackRate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double playback_rate;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetPlaybackRate_Params_Data>;

  Renderer_SetPlaybackRate_Params_Data();
  ~Renderer_SetPlaybackRate_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetPlaybackRate_Params_Data) == 16,
              "Bad sizeof(Renderer_SetPlaybackRate_Params_Data)");
class  Renderer_SetVolume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float volume;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetVolume_Params_Data>;

  Renderer_SetVolume_Params_Data();
  ~Renderer_SetVolume_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetVolume_Params_Data) == 16,
              "Bad sizeof(Renderer_SetVolume_Params_Data)");
class  Renderer_SetCdm_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> cdm_id;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetCdm_Params_Data>;

  Renderer_SetCdm_Params_Data();
  ~Renderer_SetCdm_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetCdm_Params_Data) == 16,
              "Bad sizeof(Renderer_SetCdm_Params_Data)");
class  Renderer_SetCdm_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetCdm_ResponseParams_Data>;

  Renderer_SetCdm_ResponseParams_Data();
  ~Renderer_SetCdm_ResponseParams_Data() = delete;
};
static_assert(sizeof(Renderer_SetCdm_ResponseParams_Data) == 16,
              "Bad sizeof(Renderer_SetCdm_ResponseParams_Data)");
class  Renderer_SetLatencyHint_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> latency_hint;

 private:
  friend class mojo::internal::MessageFragment<Renderer_SetLatencyHint_Params_Data>;

  Renderer_SetLatencyHint_Params_Data();
  ~Renderer_SetLatencyHint_Params_Data() = delete;
};
static_assert(sizeof(Renderer_SetLatencyHint_Params_Data) == 16,
              "Bad sizeof(Renderer_SetLatencyHint_Params_Data)");
class  RendererClient_OnTimeUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> max_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> capture_time;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnTimeUpdate_Params_Data>;

  RendererClient_OnTimeUpdate_Params_Data();
  ~RendererClient_OnTimeUpdate_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnTimeUpdate_Params_Data) == 32,
              "Bad sizeof(RendererClient_OnTimeUpdate_Params_Data)");
class  RendererClient_OnBufferingStateChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t state;
  int32_t reason;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnBufferingStateChange_Params_Data>;

  RendererClient_OnBufferingStateChange_Params_Data();
  ~RendererClient_OnBufferingStateChange_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnBufferingStateChange_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnBufferingStateChange_Params_Data)");
class  RendererClient_OnEnded_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnEnded_Params_Data>;

  RendererClient_OnEnded_Params_Data();
  ~RendererClient_OnEnded_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnEnded_Params_Data) == 8,
              "Bad sizeof(RendererClient_OnEnded_Params_Data)");
class  RendererClient_OnError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PipelineStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnError_Params_Data>;

  RendererClient_OnError_Params_Data();
  ~RendererClient_OnError_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnError_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnError_Params_Data)");
class  RendererClient_OnAudioConfigChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioDecoderConfig_Data> config;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnAudioConfigChange_Params_Data>;

  RendererClient_OnAudioConfigChange_Params_Data();
  ~RendererClient_OnAudioConfigChange_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnAudioConfigChange_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnAudioConfigChange_Params_Data)");
class  RendererClient_OnVideoConfigChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::VideoDecoderConfig_Data> config;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnVideoConfigChange_Params_Data>;

  RendererClient_OnVideoConfigChange_Params_Data();
  ~RendererClient_OnVideoConfigChange_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnVideoConfigChange_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnVideoConfigChange_Params_Data)");
class  RendererClient_OnVideoNaturalSizeChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnVideoNaturalSizeChange_Params_Data>;

  RendererClient_OnVideoNaturalSizeChange_Params_Data();
  ~RendererClient_OnVideoNaturalSizeChange_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnVideoNaturalSizeChange_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnVideoNaturalSizeChange_Params_Data)");
class  RendererClient_OnVideoOpacityChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t opaque : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnVideoOpacityChange_Params_Data>;

  RendererClient_OnVideoOpacityChange_Params_Data();
  ~RendererClient_OnVideoOpacityChange_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnVideoOpacityChange_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnVideoOpacityChange_Params_Data)");
class  RendererClient_OnStatisticsUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::PipelineStatistics_Data> stats;

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnStatisticsUpdate_Params_Data>;

  RendererClient_OnStatisticsUpdate_Params_Data();
  ~RendererClient_OnStatisticsUpdate_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnStatisticsUpdate_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnStatisticsUpdate_Params_Data)");
class  RendererClient_OnWaiting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t reason;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<RendererClient_OnWaiting_Params_Data>;

  RendererClient_OnWaiting_Params_Data();
  ~RendererClient_OnWaiting_Params_Data() = delete;
};
static_assert(sizeof(RendererClient_OnWaiting_Params_Data) == 16,
              "Bad sizeof(RendererClient_OnWaiting_Params_Data)");

}  // namespace internal


class Renderer_Initialize_ParamsDataView {
 public:
  Renderer_Initialize_ParamsDataView() = default;

  Renderer_Initialize_ParamsDataView(
      internal::Renderer_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::media::mojom::RendererClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetStreamsDataView(
      mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>, UserType>(),
    "Attempting to read the optional `streams` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStreams` instead "
    "of `ReadStreams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->streams.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>>(
        pointer, output, message_);
  }
  inline void GetMediaUrlParamsDataView(
      MediaUrlParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaUrlParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::MediaUrlParamsDataView, UserType>(),
    "Attempting to read the optional `media_url_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaUrlParams` instead "
    "of `ReadMediaUrlParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_url_params.Get();
    return mojo::internal::Deserialize<::media::mojom::MediaUrlParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_Initialize_ResponseParamsDataView {
 public:
  Renderer_Initialize_ResponseParamsDataView() = default;

  Renderer_Initialize_ResponseParamsDataView(
      internal::Renderer_Initialize_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Renderer_Initialize_ResponseParams_Data* data_ = nullptr;
};


class Renderer_Flush_ParamsDataView {
 public:
  Renderer_Flush_ParamsDataView() = default;

  Renderer_Flush_ParamsDataView(
      internal::Renderer_Flush_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_Flush_Params_Data* data_ = nullptr;
};


class Renderer_Flush_ResponseParamsDataView {
 public:
  Renderer_Flush_ResponseParamsDataView() = default;

  Renderer_Flush_ResponseParamsDataView(
      internal::Renderer_Flush_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Renderer_Flush_ResponseParams_Data* data_ = nullptr;
};


class Renderer_StartPlayingFrom_ParamsDataView {
 public:
  Renderer_StartPlayingFrom_ParamsDataView() = default;

  Renderer_StartPlayingFrom_ParamsDataView(
      internal::Renderer_StartPlayingFrom_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_StartPlayingFrom_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetPlaybackRate_ParamsDataView {
 public:
  Renderer_SetPlaybackRate_ParamsDataView() = default;

  Renderer_SetPlaybackRate_ParamsDataView(
      internal::Renderer_SetPlaybackRate_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double playback_rate() const {
    return data_->playback_rate;
  }
 private:
  internal::Renderer_SetPlaybackRate_Params_Data* data_ = nullptr;
};


class Renderer_SetVolume_ParamsDataView {
 public:
  Renderer_SetVolume_ParamsDataView() = default;

  Renderer_SetVolume_ParamsDataView(
      internal::Renderer_SetVolume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float volume() const {
    return data_->volume;
  }
 private:
  internal::Renderer_SetVolume_Params_Data* data_ = nullptr;
};


class Renderer_SetCdm_ParamsDataView {
 public:
  Renderer_SetCdm_ParamsDataView() = default;

  Renderer_SetCdm_ParamsDataView(
      internal::Renderer_SetCdm_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCdmIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCdmId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `cdm_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCdmId` instead "
    "of `ReadCdmId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cdm_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetCdm_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Renderer_SetCdm_ResponseParamsDataView {
 public:
  Renderer_SetCdm_ResponseParamsDataView() = default;

  Renderer_SetCdm_ResponseParamsDataView(
      internal::Renderer_SetCdm_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Renderer_SetCdm_ResponseParams_Data* data_ = nullptr;
};


class Renderer_SetLatencyHint_ParamsDataView {
 public:
  Renderer_SetLatencyHint_ParamsDataView() = default;

  Renderer_SetLatencyHint_ParamsDataView(
      internal::Renderer_SetLatencyHint_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLatencyHintDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatencyHint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `latency_hint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLatencyHint` instead "
    "of `ReadLatencyHint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->latency_hint.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::Renderer_SetLatencyHint_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnTimeUpdate_ParamsDataView {
 public:
  RendererClient_OnTimeUpdate_ParamsDataView() = default;

  RendererClient_OnTimeUpdate_ParamsDataView(
      internal::RendererClient_OnTimeUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetMaxTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxTime(UserType* output) {
    
    auto* pointer = data_->max_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCaptureTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureTime(UserType* output) {
    
    auto* pointer = data_->capture_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnTimeUpdate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnBufferingStateChange_ParamsDataView {
 public:
  RendererClient_OnBufferingStateChange_ParamsDataView() = default;

  RendererClient_OnBufferingStateChange_ParamsDataView(
      internal::RendererClient_OnBufferingStateChange_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::media::mojom::BufferingState>(
        data_value, output);
  }
  ::media::mojom::BufferingState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BufferingState>(data_->state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::BufferingStateChangeReason>(
        data_value, output);
  }
  ::media::mojom::BufferingStateChangeReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BufferingStateChangeReason>(data_->reason));
  }
 private:
  internal::RendererClient_OnBufferingStateChange_Params_Data* data_ = nullptr;
};


class RendererClient_OnEnded_ParamsDataView {
 public:
  RendererClient_OnEnded_ParamsDataView() = default;

  RendererClient_OnEnded_ParamsDataView(
      internal::RendererClient_OnEnded_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RendererClient_OnEnded_Params_Data* data_ = nullptr;
};


class RendererClient_OnError_ParamsDataView {
 public:
  RendererClient_OnError_ParamsDataView() = default;

  RendererClient_OnError_ParamsDataView(
      internal::RendererClient_OnError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      ::media::mojom::PipelineStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::media::mojom::PipelineStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnAudioConfigChange_ParamsDataView {
 public:
  RendererClient_OnAudioConfigChange_ParamsDataView() = default;

  RendererClient_OnAudioConfigChange_ParamsDataView(
      internal::RendererClient_OnAudioConfigChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::AudioDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnAudioConfigChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnVideoConfigChange_ParamsDataView {
 public:
  RendererClient_OnVideoConfigChange_ParamsDataView() = default;

  RendererClient_OnVideoConfigChange_ParamsDataView(
      internal::RendererClient_OnVideoConfigChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigDataView(
      ::media::mojom::VideoDecoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoDecoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnVideoConfigChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnVideoNaturalSizeChange_ParamsDataView {
 public:
  RendererClient_OnVideoNaturalSizeChange_ParamsDataView() = default;

  RendererClient_OnVideoNaturalSizeChange_ParamsDataView(
      internal::RendererClient_OnVideoNaturalSizeChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnVideoNaturalSizeChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnVideoOpacityChange_ParamsDataView {
 public:
  RendererClient_OnVideoOpacityChange_ParamsDataView() = default;

  RendererClient_OnVideoOpacityChange_ParamsDataView(
      internal::RendererClient_OnVideoOpacityChange_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool opaque() const {
    return data_->opaque;
  }
 private:
  internal::RendererClient_OnVideoOpacityChange_Params_Data* data_ = nullptr;
};


class RendererClient_OnStatisticsUpdate_ParamsDataView {
 public:
  RendererClient_OnStatisticsUpdate_ParamsDataView() = default;

  RendererClient_OnStatisticsUpdate_ParamsDataView(
      internal::RendererClient_OnStatisticsUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatsDataView(
      ::media::mojom::PipelineStatisticsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStats(UserType* output) {
    
    auto* pointer = data_->stats.Get();
    return mojo::internal::Deserialize<::media::mojom::PipelineStatisticsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererClient_OnStatisticsUpdate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererClient_OnWaiting_ParamsDataView {
 public:
  RendererClient_OnWaiting_ParamsDataView() = default;

  RendererClient_OnWaiting_ParamsDataView(
      internal::RendererClient_OnWaiting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::media::mojom::WaitingReason>(
        data_value, output);
  }
  ::media::mojom::WaitingReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::WaitingReason>(data_->reason));
  }
 private:
  internal::RendererClient_OnWaiting_Params_Data* data_ = nullptr;
};

inline void Renderer_Initialize_ParamsDataView::GetStreamsDataView(
    mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>* output) {
  auto pointer = data_->streams.Get();
  *output = mojo::ArrayDataView<mojo::InterfacePtrDataView<::media::mojom::DemuxerStreamInterfaceBase>>(pointer, message_);
}
inline void Renderer_Initialize_ParamsDataView::GetMediaUrlParamsDataView(
    MediaUrlParamsDataView* output) {
  auto pointer = data_->media_url_params.Get();
  *output = MediaUrlParamsDataView(pointer, message_);
}








inline void Renderer_StartPlayingFrom_ParamsDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}






inline void Renderer_SetCdm_ParamsDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->cdm_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




inline void Renderer_SetLatencyHint_ParamsDataView::GetLatencyHintDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->latency_hint.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void RendererClient_OnTimeUpdate_ParamsDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void RendererClient_OnTimeUpdate_ParamsDataView::GetMaxTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->max_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void RendererClient_OnTimeUpdate_ParamsDataView::GetCaptureTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->capture_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}






inline void RendererClient_OnError_ParamsDataView::GetStatusDataView(
    ::media::mojom::PipelineStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::media::mojom::PipelineStatusDataView(pointer, message_);
}


inline void RendererClient_OnAudioConfigChange_ParamsDataView::GetConfigDataView(
    ::media::mojom::AudioDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::AudioDecoderConfigDataView(pointer, message_);
}


inline void RendererClient_OnVideoConfigChange_ParamsDataView::GetConfigDataView(
    ::media::mojom::VideoDecoderConfigDataView* output) {
  auto pointer = data_->config.Get();
  *output = ::media::mojom::VideoDecoderConfigDataView(pointer, message_);
}


inline void RendererClient_OnVideoNaturalSizeChange_ParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}




inline void RendererClient_OnStatisticsUpdate_ParamsDataView::GetStatsDataView(
    ::media::mojom::PipelineStatisticsDataView* output) {
  auto pointer = data_->stats.Get();
  *output = ::media::mojom::PipelineStatisticsDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_PARAMS_DATA_H_