// media/mojo/mojom/demuxer_stream.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/demuxer_stream.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/demuxer_stream.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool DemuxerStream_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DemuxerStream_Initialize_Params_Data* object =
      static_cast<const DemuxerStream_Initialize_Params_Data*>(data);

  return true;
}

DemuxerStream_Initialize_Params_Data::DemuxerStream_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DemuxerStream_Initialize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DemuxerStream_Initialize_ResponseParams_Data* object =
      static_cast<const DemuxerStream_Initialize_ResponseParams_Data*>(data);


  if (!::media::mojom::internal::DemuxerStream_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pipe, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pipe,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->audio_config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->video_config, validation_context))
    return false;

  return true;
}

DemuxerStream_Initialize_ResponseParams_Data::DemuxerStream_Initialize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DemuxerStream_Read_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DemuxerStream_Read_Params_Data* object =
      static_cast<const DemuxerStream_Read_Params_Data*>(data);

  return true;
}

DemuxerStream_Read_Params_Data::DemuxerStream_Read_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DemuxerStream_Read_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DemuxerStream_Read_ResponseParams_Data* object =
      static_cast<const DemuxerStream_Read_ResponseParams_Data*>(data);


  if (!::media::mojom::internal::DemuxerStream_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->batch_buffers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& batch_buffers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->batch_buffers, validation_context,
                                         &batch_buffers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->audio_config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->video_config, validation_context))
    return false;

  return true;
}

DemuxerStream_Read_ResponseParams_Data::DemuxerStream_Read_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DemuxerStream_EnableBitstreamConverter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DemuxerStream_EnableBitstreamConverter_Params_Data* object =
      static_cast<const DemuxerStream_EnableBitstreamConverter_Params_Data*>(data);

  return true;
}

DemuxerStream_EnableBitstreamConverter_Params_Data::DemuxerStream_EnableBitstreamConverter_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media