// extensions/common/mojom/service_worker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/service_worker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/service_worker.mojom-params-data.h"
#include "extensions/common/mojom/service_worker.mojom-shared-message-ids.h"

#include "extensions/common/mojom/service_worker.mojom-import-headers.h"
#include "extensions/common/mojom/service_worker.mojom-test-utils.h"


namespace extensions::mojom {
const char ServiceWorker::Name_[] = "extensions.mojom.ServiceWorker";

ServiceWorker::IPCStableHashFunction ServiceWorker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorker>(message.name())) {
    case messages::ServiceWorker::kUpdatePermissions: {
      return &ServiceWorker::UpdatePermissions_Sym::IPCStableHash;
    }
    case messages::ServiceWorker::kDispatchOnConnect: {
      return &ServiceWorker::DispatchOnConnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorker>(message.name())) {
      case messages::ServiceWorker::kUpdatePermissions:
            return "Receive extensions::mojom::ServiceWorker::UpdatePermissions";
      case messages::ServiceWorker::kDispatchOnConnect:
            return "Receive extensions::mojom::ServiceWorker::DispatchOnConnect";
    }
  } else {
    switch (static_cast<messages::ServiceWorker>(message.name())) {
      case messages::ServiceWorker::kUpdatePermissions:
            return "Receive reply extensions::mojom::ServiceWorker::UpdatePermissions";
      case messages::ServiceWorker::kDispatchOnConnect:
            return "Receive reply extensions::mojom::ServiceWorker::DispatchOnConnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorker::UpdatePermissions_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::ServiceWorker::UpdatePermissions");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorker::DispatchOnConnect_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::ServiceWorker::DispatchOnConnect");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorker_DispatchOnConnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorker_DispatchOnConnect_ForwardToCallback(
      ServiceWorker::DispatchOnConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorker_DispatchOnConnect_ForwardToCallback(const ServiceWorker_DispatchOnConnect_ForwardToCallback&) = delete;
  ServiceWorker_DispatchOnConnect_ForwardToCallback& operator=(const ServiceWorker_DispatchOnConnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorker::DispatchOnConnectCallback callback_;
};

ServiceWorkerProxy::ServiceWorkerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerProxy::UpdatePermissions(
    ::extensions::PermissionSet in_active_permissions, ::extensions::PermissionSet in_withheld_permissions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorker::UpdatePermissions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_permissions"), in_active_permissions,
                        "<value of type ::extensions::PermissionSet>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("withheld_permissions"), in_withheld_permissions,
                        "<value of type ::extensions::PermissionSet>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kUpdatePermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorker_UpdatePermissions_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->active_permissions)::BaseType> active_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_active_permissions, active_permissions_fragment);
  params->active_permissions.Set(
      active_permissions_fragment.is_null() ? nullptr : active_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->active_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null active_permissions in ServiceWorker.UpdatePermissions request");
  mojo::internal::MessageFragment<
      typename decltype(params->withheld_permissions)::BaseType> withheld_permissions_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
      in_withheld_permissions, withheld_permissions_fragment);
  params->withheld_permissions.Set(
      withheld_permissions_fragment.is_null() ? nullptr : withheld_permissions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->withheld_permissions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null withheld_permissions in ServiceWorker.UpdatePermissions request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("UpdatePermissions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerProxy::DispatchOnConnect(
    const ::extensions::PortId& in_port_id, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, ::extensions::mojom::TabConnectionInfoPtr in_tab_info, ::extensions::mojom::ExternalConnectionInfoPtr in_external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> in_port_host, DispatchOnConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorker::DispatchOnConnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_info"), in_tab_info,
                        "<value of type ::extensions::mojom::TabConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("external_connection_info"), in_external_connection_info,
                        "<value of type ::extensions::mojom::ExternalConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchOnConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorker_DispatchOnConnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
      in_port_id, port_id_fragment);
  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->port_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null port_id in ServiceWorker.DispatchOnConnect request");
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
      in_channel_type, &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_channel_name, channel_name_fragment);
  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->channel_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null channel_name in ServiceWorker.DispatchOnConnect request");
  mojo::internal::MessageFragment<
      typename decltype(params->tab_info)::BaseType> tab_info_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::TabConnectionInfoDataView>(
      in_tab_info, tab_info_fragment);
  params->tab_info.Set(
      tab_info_fragment.is_null() ? nullptr : tab_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tab_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_info in ServiceWorker.DispatchOnConnect request");
  mojo::internal::MessageFragment<
      typename decltype(params->external_connection_info)::BaseType> external_connection_info_fragment(
          params.message());
  mojo::internal::Serialize<::extensions::mojom::ExternalConnectionInfoDataView>(
      in_external_connection_info, external_connection_info_fragment);
  params->external_connection_info.Set(
      external_connection_info_fragment.is_null() ? nullptr : external_connection_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->external_connection_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null external_connection_info in ServiceWorker.DispatchOnConnect request");
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedRequestDataView>(
      in_port, &params->port, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->port),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid port in ServiceWorker.DispatchOnConnect request");
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedPtrInfoDataView>(
      in_port_host, &params->port_host, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->port_host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid port_host in ServiceWorker.DispatchOnConnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchOnConnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorker_DispatchOnConnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorker_DispatchOnConnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorker::DispatchOnConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorker_DispatchOnConnect_ProxyToResponder> proxy(
        new ServiceWorker_DispatchOnConnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorker_DispatchOnConnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorker_DispatchOnConnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorker_DispatchOnConnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ServiceWorker::DispatchOnConnectCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ServiceWorker_DispatchOnConnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorker_DispatchOnConnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorker_DispatchOnConnect_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ServiceWorker.1
  bool success = true;
  bool p_success{};
  ServiceWorker_DispatchOnConnect_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorker::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void ServiceWorker_DispatchOnConnect_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::ServiceWorker::DispatchOnConnect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorker::kDispatchOnConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorker_DispatchOnConnect_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorker::Name_);
  message.set_method_name("DispatchOnConnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerStubDispatch::Accept(
    ServiceWorker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorker>(message->header()->name)) {
    case messages::ServiceWorker::kUpdatePermissions: {
      DCHECK(message->is_serialized());
      internal::ServiceWorker_UpdatePermissions_Params_Data* params =
          reinterpret_cast<internal::ServiceWorker_UpdatePermissions_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ServiceWorker.0
      bool success = true;
      ::extensions::PermissionSet p_active_permissions{};
      ::extensions::PermissionSet p_withheld_permissions{};
      ServiceWorker_UpdatePermissions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActivePermissions(&p_active_permissions))
        success = false;
      if (success && !input_data_view.ReadWithheldPermissions(&p_withheld_permissions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePermissions(        
        std::move(p_active_permissions), 
        std::move(p_withheld_permissions));
      return true;
    }
    case messages::ServiceWorker::kDispatchOnConnect: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerStubDispatch::AcceptWithResponder(
    ServiceWorker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorker>(message->header()->name)) {
    case messages::ServiceWorker::kUpdatePermissions: {
      break;
    }
    case messages::ServiceWorker::kDispatchOnConnect: {
      internal::ServiceWorker_DispatchOnConnect_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorker_DispatchOnConnect_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ServiceWorker.1
      bool success = true;
      ::extensions::PortId p_port_id{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::mojom::TabConnectionInfoPtr p_tab_info{};
      ::extensions::mojom::ExternalConnectionInfoPtr p_external_connection_info{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> p_port_host{};
      ServiceWorker_DispatchOnConnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadTabInfo(&p_tab_info))
        success = false;
      if (success && !input_data_view.ReadExternalConnectionInfo(&p_external_connection_info))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorker::Name_, 1, false);
        return false;
      }
      ServiceWorker::DispatchOnConnectCallback callback =
          ServiceWorker_DispatchOnConnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchOnConnect(        
        std::move(p_port_id), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_tab_info), 
        std::move(p_external_connection_info), 
        std::move(p_port), 
        std::move(p_port_host), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceWorkerValidationInfo[] = {
    {base::to_underlying(messages::ServiceWorker::kUpdatePermissions),
     { &internal::ServiceWorker_UpdatePermissions_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ServiceWorker::kDispatchOnConnect),
     { &internal::ServiceWorker_DispatchOnConnect_Params_Data::Validate,
      &internal::ServiceWorker_DispatchOnConnect_ResponseParams_Data::Validate}},
};

bool ServiceWorkerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::ServiceWorker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceWorkerValidationInfo);
}

bool ServiceWorkerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::ServiceWorker::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceWorkerValidationInfo);

}


}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void ServiceWorkerInterceptorForTesting::UpdatePermissions(::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions) {
  GetForwardingInterface()->UpdatePermissions(
    std::move(active_permissions)
    , 
    std::move(withheld_permissions)
    );
}
void ServiceWorkerInterceptorForTesting::DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) {
  GetForwardingInterface()->DispatchOnConnect(
    std::move(port_id)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(tab_info)
    , 
    std::move(external_connection_info)
    , 
    std::move(port)
    , 
    std::move(port_host)
    , std::move(callback));
}
ServiceWorkerAsyncWaiter::ServiceWorkerAsyncWaiter(
    ServiceWorker* proxy) : proxy_(proxy) {}

ServiceWorkerAsyncWaiter::~ServiceWorkerAsyncWaiter() = default;

void ServiceWorkerAsyncWaiter::DispatchOnConnect(
    const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, bool* out_success) {
  base::RunLoop loop;
  proxy_->DispatchOnConnect(
      std::move(port_id),
      std::move(channel_type),
      std::move(channel_name),
      std::move(tab_info),
      std::move(external_connection_info),
      std::move(port),
      std::move(port_host),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ServiceWorkerAsyncWaiter::DispatchOnConnect(
    const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host) {
  bool async_wait_result;
  DispatchOnConnect(std::move(port_id),std::move(channel_type),std::move(channel_name),std::move(tab_info),std::move(external_connection_info),std::move(port),std::move(port_host),&async_wait_result);
  return async_wait_result;
}






}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif