// content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_SHARED_STORAGE_HOST_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_SHARED_STORAGE_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_storage.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace auction_worklet::mojom {

class AuctionSharedStorageHostProxy;

template <typename ImplRefTraits>
class AuctionSharedStorageHostStub;

class AuctionSharedStorageHostRequestValidator;


class CONTENT_EXPORT AuctionSharedStorageHost
    : public AuctionSharedStorageHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AuctionSharedStorageHostInterfaceBase;
  using Proxy_ = AuctionSharedStorageHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuctionSharedStorageHostStub<ImplRefTraits>;

  using RequestValidator_ = AuctionSharedStorageHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSharedStorageUpdateMinVersion = 0,
    kSharedStorageBatchUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SharedStorageUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SharedStorageBatchUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AuctionSharedStorageHost() = default;

  
  virtual void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, AuctionWorkletFunction source_auction_worklet_function) = 0;

  
  virtual void SharedStorageBatchUpdate(std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, AuctionWorkletFunction source_auction_worklet_function) = 0;
};



class CONTENT_EXPORT AuctionSharedStorageHostProxy
    : public AuctionSharedStorageHost {
 public:
  using InterfaceType = AuctionSharedStorageHost;

  explicit AuctionSharedStorageHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SharedStorageUpdate(::network::mojom::SharedStorageModifierMethodWithOptionsPtr method_with_options, AuctionWorkletFunction source_auction_worklet_function) final;
  
  void SharedStorageBatchUpdate(std::vector<::network::mojom::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::std::string>& with_lock, AuctionWorkletFunction source_auction_worklet_function) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT AuctionSharedStorageHostStubDispatch {
 public:
  static bool Accept(AuctionSharedStorageHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AuctionSharedStorageHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AuctionSharedStorageHost>>
class AuctionSharedStorageHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuctionSharedStorageHostStub() = default;
  ~AuctionSharedStorageHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionSharedStorageHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuctionSharedStorageHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AuctionSharedStorageHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // auction_worklet::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_AUCTION_SHARED_STORAGE_HOST_MOJOM_H_