// content/public/common/resource_usage_reporter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_
#define CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/public/common/resource_usage_reporter.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace content::mojom {
class ResourceTypeStatDataView;

class ResourceTypeStatsDataView;

class ResourceUsageDataDataView;



}  // content::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceTypeStatsDataView> {
  using Data = ::content::mojom::internal::ResourceTypeStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::ResourceUsageDataDataView> {
  using Data = ::content::mojom::internal::ResourceUsageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {
// Interface base classes. They are used for type safety check.
class ResourceUsageReporterInterfaceBase {};

using ResourceUsageReporterPtrDataView =
    mojo::InterfacePtrDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterRequestDataView =
    mojo::InterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResourceUsageReporterInterfaceBase>;
using ResourceUsageReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResourceUsageReporterInterfaceBase>;


class ResourceTypeStatDataView {
 public:
  ResourceTypeStatDataView() = default;

  ResourceTypeStatDataView(
      internal::ResourceTypeStat_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t count() const {
    return data_->count;
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t live_size() const {
    return data_->live_size;
  }
  uint64_t decoded_size() const {
    return data_->decoded_size;
  }
 private:
  internal::ResourceTypeStat_Data* data_ = nullptr;
};


class ResourceTypeStatsDataView {
 public:
  ResourceTypeStatsDataView() = default;

  ResourceTypeStatsDataView(
      internal::ResourceTypeStats_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImagesDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImages(UserType* output) {
    
    auto* pointer = data_->images.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetCssStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCssStyleSheets(UserType* output) {
    
    auto* pointer = data_->css_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetScriptsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScripts(UserType* output) {
    
    auto* pointer = data_->scripts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetXslStyleSheetsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXslStyleSheets(UserType* output) {
    
    auto* pointer = data_->xsl_style_sheets.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetFontsDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFonts(UserType* output) {
    
    auto* pointer = data_->fonts.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
  inline void GetOtherDataView(
      ResourceTypeStatDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOther(UserType* output) {
    
    auto* pointer = data_->other.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceTypeStats_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceUsageDataDataView {
 public:
  ResourceUsageDataDataView() = default;

  ResourceUsageDataDataView(
      internal::ResourceUsageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool reports_v8_stats() const {
    return data_->reports_v8_stats;
  }
  uint64_t v8_bytes_allocated() const {
    return data_->v8_bytes_allocated;
  }
  uint64_t v8_bytes_used() const {
    return data_->v8_bytes_used;
  }
  inline void GetWebCacheStatsDataView(
      ResourceTypeStatsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebCacheStats(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::ResourceTypeStatsDataView, UserType>(),
    "Attempting to read the optional `web_cache_stats` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebCacheStats` instead "
    "of `ReadWebCacheStats if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_cache_stats.Get();
    return mojo::internal::Deserialize<::content::mojom::ResourceTypeStatsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceUsageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // content::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceTypeStatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceTypeStat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->count = Traits::count(input);
    fragment->size = Traits::size(input);
    fragment->live_size = Traits::live_size(input);
    fragment->decoded_size = Traits::decoded_size(input);
  }

  static bool Deserialize(::content::mojom::internal::ResourceTypeStat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceTypeStatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceTypeStatsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceTypeStatsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceTypeStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::images(input)) in_images = Traits::images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->images)::BaseType> images_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_images, images_fragment);
    fragment->images.Set(
        images_fragment.is_null() ? nullptr : images_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->images.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images in ResourceTypeStats struct");
    decltype(Traits::css_style_sheets(input)) in_css_style_sheets = Traits::css_style_sheets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->css_style_sheets)::BaseType> css_style_sheets_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_css_style_sheets, css_style_sheets_fragment);
    fragment->css_style_sheets.Set(
        css_style_sheets_fragment.is_null() ? nullptr : css_style_sheets_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->css_style_sheets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null css_style_sheets in ResourceTypeStats struct");
    decltype(Traits::scripts(input)) in_scripts = Traits::scripts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scripts)::BaseType> scripts_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_scripts, scripts_fragment);
    fragment->scripts.Set(
        scripts_fragment.is_null() ? nullptr : scripts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scripts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scripts in ResourceTypeStats struct");
    decltype(Traits::xsl_style_sheets(input)) in_xsl_style_sheets = Traits::xsl_style_sheets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->xsl_style_sheets)::BaseType> xsl_style_sheets_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_xsl_style_sheets, xsl_style_sheets_fragment);
    fragment->xsl_style_sheets.Set(
        xsl_style_sheets_fragment.is_null() ? nullptr : xsl_style_sheets_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->xsl_style_sheets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null xsl_style_sheets in ResourceTypeStats struct");
    decltype(Traits::fonts(input)) in_fonts = Traits::fonts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fonts)::BaseType> fonts_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_fonts, fonts_fragment);
    fragment->fonts.Set(
        fonts_fragment.is_null() ? nullptr : fonts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fonts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fonts in ResourceTypeStats struct");
    decltype(Traits::other(input)) in_other = Traits::other(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->other)::BaseType> other_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatDataView>(
        in_other, other_fragment);
    fragment->other.Set(
        other_fragment.is_null() ? nullptr : other_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->other.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null other in ResourceTypeStats struct");
  }

  static bool Deserialize(::content::mojom::internal::ResourceTypeStats_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceTypeStatsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ResourceUsageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::ResourceUsageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::ResourceUsageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->reports_v8_stats = Traits::reports_v8_stats(input);
    fragment->v8_bytes_allocated = Traits::v8_bytes_allocated(input);
    fragment->v8_bytes_used = Traits::v8_bytes_used(input);
    decltype(Traits::web_cache_stats(input)) in_web_cache_stats = Traits::web_cache_stats(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_cache_stats)::BaseType> web_cache_stats_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::ResourceTypeStatsDataView>(
        in_web_cache_stats, web_cache_stats_fragment);
    fragment->web_cache_stats.Set(
        web_cache_stats_fragment.is_null() ? nullptr : web_cache_stats_fragment.data());
  }

  static bool Deserialize(::content::mojom::internal::ResourceUsageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::ResourceUsageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {



inline void ResourceTypeStatsDataView::GetImagesDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->images.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}
inline void ResourceTypeStatsDataView::GetCssStyleSheetsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->css_style_sheets.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}
inline void ResourceTypeStatsDataView::GetScriptsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->scripts.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}
inline void ResourceTypeStatsDataView::GetXslStyleSheetsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->xsl_style_sheets.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}
inline void ResourceTypeStatsDataView::GetFontsDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->fonts.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}
inline void ResourceTypeStatsDataView::GetOtherDataView(
    ResourceTypeStatDataView* output) {
  auto pointer = data_->other.Get();
  *output = ResourceTypeStatDataView(pointer, message_);
}


inline void ResourceUsageDataDataView::GetWebCacheStatsDataView(
    ResourceTypeStatsDataView* output) {
  auto pointer = data_->web_cache_stats.Get();
  *output = ResourceTypeStatsDataView(pointer, message_);
}



}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CONTENT_PUBLIC_COMMON_RESOURCE_USAGE_REPORTER_MOJOM_SHARED_H_