// content/common/child_process.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_
#define CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/child_process.mojom-features.h"  // IWYU pragma: export
#include "content/common/child_process.mojom-shared.h"  // IWYU pragma: export
#include "content/common/child_process.mojom-forward.h"  // IWYU pragma: export
#include "ipc/ipc.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom-forward.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-forward.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-forward.h"
#include "services/tracing/public/mojom/system_tracing_service.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace content::mojom {

class ChildProcessHostProxy;

template <typename ImplRefTraits>
class ChildProcessHostStub;

class ChildProcessHostRequestValidator;
class ChildProcessHostResponseValidator;


class CONTENT_EXPORT ChildProcessHost
    : public ChildProcessHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildProcessHostInterfaceBase;
  using Proxy_ = ChildProcessHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildProcessHostStub<ImplRefTraits>;

  using RequestValidator_ = ChildProcessHostRequestValidator;
  using ResponseValidator_ = ChildProcessHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPingMinVersion = 0,
    kBindHostReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Ping_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindHostReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildProcessHost() = default;


  using PingCallback = base::OnceCallback<void()>;
  
  virtual void Ping(PingCallback callback) = 0;

  
  virtual void BindHostReceiver(::mojo::GenericPendingReceiver receiver) = 0;
};

class ChildProcessProxy;

template <typename ImplRefTraits>
class ChildProcessStub;

class ChildProcessRequestValidator;


class CONTENT_EXPORT ChildProcess
    : public ChildProcessInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChildProcessInterfaceBase;
  using Proxy_ = ChildProcessProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChildProcessStub<ImplRefTraits>;

  using RequestValidator_ = ChildProcessRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kProcessShutdownMinVersion = 0,
    kGetBackgroundTracingAgentProviderMinVersion = 0,
    kEnableSystemTracingServiceMinVersion = 0,
    kCrashHungProcessMinVersion = 0,
    kBindServiceInterfaceMinVersion = 0,
    kBindReceiverMinVersion = 0,
    kSetPseudonymizationSaltMinVersion = 0,
    kSetBatterySaverModeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ProcessShutdown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetBackgroundTracingAgentProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableSystemTracingService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CrashHungProcess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindServiceInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPseudonymizationSalt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBatterySaverMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChildProcess() = default;

  
  virtual void ProcessShutdown() = 0;

  
  virtual void GetBackgroundTracingAgentProvider(::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> receiver) = 0;

  
  virtual void EnableSystemTracingService(::mojo::PendingRemote<::tracing::mojom::SystemTracingService> remote) = 0;

  
  virtual void CrashHungProcess() = 0;

  
  virtual void BindServiceInterface(::mojo::GenericPendingReceiver receiver) = 0;

  
  virtual void BindReceiver(::mojo::GenericPendingReceiver receiver) = 0;

  
  virtual void SetPseudonymizationSalt(uint32_t salt) = 0;

  
  virtual void SetBatterySaverMode(bool battery_saver_mode_enabled) = 0;
};



class CONTENT_EXPORT ChildProcessHostProxy
    : public ChildProcessHost {
 public:
  using InterfaceType = ChildProcessHost;

  explicit ChildProcessHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Ping(PingCallback callback) final;
  
  void BindHostReceiver(::mojo::GenericPendingReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT ChildProcessProxy
    : public ChildProcess {
 public:
  using InterfaceType = ChildProcess;

  explicit ChildProcessProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ProcessShutdown() final;
  
  void GetBackgroundTracingAgentProvider(::mojo::PendingReceiver<::tracing::mojom::BackgroundTracingAgentProvider> receiver) final;
  
  void EnableSystemTracingService(::mojo::PendingRemote<::tracing::mojom::SystemTracingService> remote) final;
  
  void CrashHungProcess() final;
  
  void BindServiceInterface(::mojo::GenericPendingReceiver receiver) final;
  
  void BindReceiver(::mojo::GenericPendingReceiver receiver) final;
  
  void SetPseudonymizationSalt(uint32_t salt) final;
  
  void SetBatterySaverMode(bool battery_saver_mode_enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT ChildProcessHostStubDispatch {
 public:
  static bool Accept(ChildProcessHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildProcessHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildProcessHost>>
class ChildProcessHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildProcessHostStub() = default;
  ~ChildProcessHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ChildProcessStubDispatch {
 public:
  static bool Accept(ChildProcess* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChildProcess* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChildProcess>>
class ChildProcessStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChildProcessStub() = default;
  ~ChildProcessStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChildProcessStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT ChildProcessHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT ChildProcessRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT ChildProcessHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // content::mojom

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_CHILD_PROCESS_MOJOM_H_