// Copyright 2026 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/extensions/api/generated_api_registration.h"

#include "build/build_config.h"
#include "build/chromeos_buildflags.h"

#include "chrome/browser/extensions/api/enterprise_hardware_platform/enterprise_hardware_platform_api.h"
#include "chrome/browser/extensions/api/webrtc_logging_private/webrtc_logging_private_api.h"

#include "extensions/browser/extension_function_registry.h"

namespace extensions {
namespace api {

// static
void ChromeGeneratedFunctionRegistry::RegisterAll(ExtensionFunctionRegistry* registry) {
  constexpr ExtensionFunctionRegistry::FactoryEntry kEntries[] = {
    {
      &NewExtensionFunction<EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction>,
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::static_function_name(),
      EnterpriseHardwarePlatformGetHardwarePlatformInfoFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetMetaDataFunction>,
      WebrtcLoggingPrivateSetMetaDataFunction::static_function_name(),
      WebrtcLoggingPrivateSetMetaDataFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartFunction>,
      WebrtcLoggingPrivateStartFunction::static_function_name(),
      WebrtcLoggingPrivateStartFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateSetUploadOnRenderCloseFunction>,
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::static_function_name(),
      WebrtcLoggingPrivateSetUploadOnRenderCloseFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopFunction>,
      WebrtcLoggingPrivateStopFunction::static_function_name(),
      WebrtcLoggingPrivateStopFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStoreFunction>,
      WebrtcLoggingPrivateStoreFunction::static_function_name(),
      WebrtcLoggingPrivateStoreFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadStoredFunction>,
      WebrtcLoggingPrivateUploadStoredFunction::static_function_name(),
      WebrtcLoggingPrivateUploadStoredFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateUploadFunction>,
      WebrtcLoggingPrivateUploadFunction::static_function_name(),
      WebrtcLoggingPrivateUploadFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateDiscardFunction>,
      WebrtcLoggingPrivateDiscardFunction::static_function_name(),
      WebrtcLoggingPrivateDiscardFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartRtpDumpFunction>,
      WebrtcLoggingPrivateStartRtpDumpFunction::static_function_name(),
      WebrtcLoggingPrivateStartRtpDumpFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopRtpDumpFunction>,
      WebrtcLoggingPrivateStopRtpDumpFunction::static_function_name(),
      WebrtcLoggingPrivateStopRtpDumpFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::static_function_name(),
      WebrtcLoggingPrivateStartAudioDebugRecordingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStopAudioDebugRecordingsFunction>,
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::static_function_name(),
      WebrtcLoggingPrivateStopAudioDebugRecordingsFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateStartEventLoggingFunction>,
      WebrtcLoggingPrivateStartEventLoggingFunction::static_function_name(),
      WebrtcLoggingPrivateStartEventLoggingFunction::static_histogram_value(),
    },
    {
      &NewExtensionFunction<WebrtcLoggingPrivateGetLogsDirectoryFunction>,
      WebrtcLoggingPrivateGetLogsDirectoryFunction::static_function_name(),
      WebrtcLoggingPrivateGetLogsDirectoryFunction::static_histogram_value(),
    },
  };
  for (const auto& entry : kEntries) {
      registry->Register(entry);
  }
}

}  // namespace api
}  // namespace extensions
