// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A6__F20

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_32_F_T_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1201)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xed71fa76u, 0x31c26b79u, 0, 83 }, // ed71fa7631c26b79 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x52411e45u, 0xcf685945u, 0, 16 }, // 52411e45cf685945 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0x6673cd74u, 0xda76f09cu, 0, 33 }, // 6673cd74da76f09c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0x79ce2ae1u, 0xaa18b5ecu, 0, 50 }, // 79ce2ae1aa18b5ec = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0xe6f86ec7u, 0xdcb06ba2u, 0, 133 }, // e6f86ec7dcb06ba2 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0xa13ecd62u, 0x47b2f9c9u, 318, 83 }, // a13ecd6247b2f9c9 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x5a02265au, 0x0f54002cu, 318, 202 }, // 5a02265a0f54002c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x499ecd42u, 0x03e3a16au, 318, 16 }, // 499ecd4203e3a16a = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0xe3966efcu, 0xaf622abbu, 318, 116 }, // e3966efcaf622abb = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xad049e53u, 0x266d8258u, 318, 33 }, // ad049e53266d8258 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0x3fb63774u, 0xdc643050u, 318, 167 }, // 3fb63774dc643050 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x75b86f29u, 0x3462d2b2u, 318, 50 }, // 75b86f293462d2b2 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0x0bcf5c7cu, 0xbb05e9ddu, 318, 133 }, // 0bcf5c7cbb05e9dd = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0x7b71b977u, 0xca16b233u, 67, 83 }, // 7b71b977ca16b233 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x89177856u, 0xef2c67c4u, 67, 202 }, // 89177856ef2c67c4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x3b172ee6u, 0x75b395e5u, 67, 16 }, // 3b172ee675b395e5 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0x04605257u, 0xbbcc99b4u, 67, 33 }, // 04605257bbcc99b4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0xe6399c01u, 0x3a31724cu, 67, 50 }, // e6399c013a31724c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0x27539951u, 0xfbe510deu, 67, 133 }, // 27539951fbe510de = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_32_F_T_0_0___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1201
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1201_mod0
{{ 4, 8, 8,12, 6, 6,12, 8,12,12},
 {12,18,12, 8,10, 9, 9, 9,11,11},
 { 6, 3, 9,11,11, 7, 7,11, 9, 5},
 { 3, 3, 2, 9, 7,11, 5, 7, 9,14},
 { 7, 2, 0, 9,11, 7, 9,13,13,13},
 {11, 1, 1,17,13,17,16,13,13, 5},
 {11, 0, 1,17,17,16,13,13,11, 7},
 {17, 3,17,17,15,13,13,13,13,13},
 {15, 2,15,13,13,13,13,13,13,13},
 {13, 1,13,13,13,13,13,13,13,13}}
// End of GPU gfx1201_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A6__F20 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 3;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 3;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = 32
// PADDED_HEAD = False
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 32 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

