/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2025, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"conditional\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"empty\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enforced\0"
	"enum\0"
	"error\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"indent\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_exists\0"
	"json_object\0"
	"json_objectagg\0"
	"json_query\0"
	"json_scalar\0"
	"json_serialize\0"
	"json_table\0"
	"json_value\0"
	"keep\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"merge_action\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"nested\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"objects\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"omit\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"path\0"
	"period\0"
	"placing\0"
	"plan\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"quotes\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"source\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"string\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"system_user\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"target\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unconditional\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"virtual\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	517,
	531,
	540,
	551,
	562,
	574,
	582,
	591,
	602,
	607,
	612,
	619,
	625,
	629,
	634,
	642,
	658,
	671,
	684,
	699,
	712,
	730,
	743,
	750,
	756,
	761,
	770,
	774,
	785,
	789,
	797,
	805,
	813,
	822,
	833,
	842,
	850,
	857,
	867,
	878,
	886,
	892,
	897,
	904,
	915,
	923,
	931,
	940,
	943,
	952,
	959,
	966,
	971,
	976,
	981,
	987,
	994,
	1003,
	1013,
	1017,
	1026,
	1031,
	1037,
	1044,
	1050,
	1057,
	1065,
	1075,
	1085,
	1093,
	1100,
	1108,
	1119,
	1129,
	1138,
	1146,
	1152,
	1159,
	1165,
	1172,
	1181,
	1187,
	1193,
	1203,
	1207,
	1213,
	1221,
	1228,
	1236,
	1243,
	1248,
	1253,
	1262,
	1272,
	1282,
	1289,
	1295,
	1303,
	1312,
	1318,
	1327,
	1334,
	1342,
	1349,
	1356,
	1361,
	1366,
	1375,
	1378,
	1384,
	1394,
	1404,
	1413,
	1420,
	1423,
	1431,
	1441,
	1451,
	1458,
	1464,
	1472,
	1480,
	1489,
	1499,
	1506,
	1512,
	1518,
	1524,
	1536,
	1543,
	1551,
	1555,
	1563,
	1573,
	1582,
	1587,
	1595,
	1598,
	1605,
	1615,
	1620,
	1625,
	1636,
	1650,
	1662,
	1674,
	1689,
	1700,
	1712,
	1727,
	1738,
	1749,
	1754,
	1758,
	1763,
	1769,
	1778,
	1784,
	1789,
	1797,
	1805,
	1815,
	1821,
	1826,
	1832,
	1837,
	1843,
	1850,
	1855,
	1861,
	1871,
	1886,
	1895,
	1900,
	1907,
	1914,
	1922,
	1928,
	1936,
	1949,
	1958,
	1964,
	1977,
	1984,
	1991,
	2000,
	2005,
	2011,
	2016,
	2021,
	2027,
	2036,
	2044,
	2050,
	2057,
	2061,
	2066,
	2070,
	2074,
	2079,
	2084,
	2087,
	2092,
	2102,
	2113,
	2117,
	2125,
	2132,
	2140,
	2147,
	2152,
	2159,
	2165,
	2173,
	2180,
	2188,
	2191,
	2195,
	2202,
	2207,
	2211,
	2216,
	2219,
	2224,
	2233,
	2240,
	2248,
	2251,
	2257,
	2268,
	2275,
	2279,
	2285,
	2290,
	2299,
	2307,
	2318,
	2324,
	2330,
	2339,
	2349,
	2356,
	2364,
	2374,
	2382,
	2391,
	2396,
	2403,
	2411,
	2416,
	2422,
	2429,
	2438,
	2448,
	2458,
	2466,
	2475,
	2484,
	2492,
	2498,
	2509,
	2520,
	2530,
	2541,
	2549,
	2561,
	2567,
	2574,
	2580,
	2585,
	2590,
	2599,
	2609,
	2613,
	2624,
	2636,
	2644,
	2652,
	2661,
	2669,
	2676,
	2687,
	2695,
	2703,
	2709,
	2717,
	2726,
	2733,
	2743,
	2751,
	2758,
	2764,
	2769,
	2778,
	2785,
	2793,
	2802,
	2806,
	2811,
	2816,
	2826,
	2833,
	2840,
	2848,
	2855,
	2862,
	2869,
	2878,
	2885,
	2894,
	2904,
	2917,
	2924,
	2932,
	2945,
	2949,
	2955,
	2960,
	2966,
	2971,
	2979,
	2986,
	2991,
	3000,
	3009,
	3014,
	3021,
	3025,
	3032,
	3043,
	3049,
	3059,
	3070,
	3076,
	3083,
	3091,
	3098,
	3105,
	3112,
	3118,
	3131,
	3141,
	3149,
	3159,
	3165,
	3172,
	3184,
	3190,
	3197,
	3209,
	3220,
	3227,
	3232,
	3241,
	3251,
	3256,
	3261,
	3266,
	3271,
	3281,
	3284,
	3293,
	3305,
	3315,
	3321,
	3329,
	3334,
	3339,
	3348,
	3356,
	3361,
	3367,
	3375,
	3385,
	3397,
	3411,
	3423,
	3429,
	3436,
	3444,
	3453,
	3462,
	3468,
	3475,
	3480,
	3486,
	3493,
	3499,
	3508,
	3518,
	3524,
	3531,
	3539,
	3548,
	3556,
	3564,
	3572,
	3577,
	3583,
	3591,
	3600,
	3605,
	3611,
	3622,
	3629,
	3634,
	3641,
	3649,
	3654,
	3662,
	3668,
	3672,
	3686,
	3696,
	3707,
	3717,
	3727,
	3741,
	3750,
	3756,
	3764,
	3777,
	3786,
	3791,
	3795,
};

#define SCANKEYWORDS_NUM_KEYWORDS 494

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[989] = {
		80,    32767, 734,   447,   183,   170,   93,    32767,
		0,     173,   53,    224,   -72,   -78,   0,     578,
		163,   32767, 32767, 0,     32767, 0,     49,    0,
		32767, 0,     32767, 32767, 214,   32767, -103,  32767,
		32767, -109,  0,     63,    -233,  32767, -234,  146,
		32767, 32767, 344,   32767, 32767, 0,     40,    8,
		0,     321,   32767, 262,   527,   32767, -45,   -38,
		98,    217,   -343,  264,   32767, 184,   32767, 643,
		32767, 182,   32767, 32767, 32767, 32767, 32767, 326,
		0,     0,     0,     300,   477,   32767, 371,   32767,
		110,   275,   149,   32767, 32767, 116,   32767, 439,
		183,   32767, -150,  130,   289,   32767, 392,   32767,
		261,   471,   281,   335,   411,   32767, 32767, -372,
		32767, 0,     0,     32767, 32767, 0,     121,   435,
		-329,  32767, 9,     37,    34,    32767, 32767, 32767,
		32767, 32767, 187,   32767, 0,     32767, 182,   401,
		53,    32767, 48,    32767, 32767, 0,     540,   527,
		137,   32767, 289,   151,   31,    32767, 32767, -145,
		429,   0,     288,   -340,  32767, 301,   0,     32767,
		32767, 0,     32767, 32767, 32767, 469,   -139,  454,
		32767, 32767, 226,   -466,  32767, 32767, 0,     412,
		326,   32767, 250,   -73,   0,     282,   294,   -348,
		32767, -385,  446,   32767, 0,     862,   32767, -392,
		79,    168,   32767, 343,   0,     156,   32767, -47,
		-6,    32767, 32767, 324,   32767, 0,     0,     393,
		32767, 449,   354,   357,   37,    90,    207,   32767,
		46,    32767, 32767, 505,   127,   221,   167,   32767,
		28,    32767, 0,     119,   282,   32767, 32767, 0,
		32767, 297,   437,   32767, 609,   0,     286,   32767,
		32767, 100,   371,   32767, 32767, -674,  484,   734,
		32767, 334,   335,   32767, -214,  0,     85,    252,
		32767, 84,    32767, 8,     160,   428,   186,   0,
		32767, 462,   23,    121,   32767, 32767, 0,     220,
		32767, 259,   32767, 32767, 32767, -169,  435,   32767,
		-631,  32767, 32767, -223,  32767, 185,   32767, -300,
		432,   493,   32767, 32767, 191,   356,   110,   101,
		32767, 522,   32767, 32767, 0,     240,   561,   469,
		0,     229,   248,   751,   32767, 32767, 32767, 0,
		32767, 32767, 32767, 401,   32767, 32767, 270,   32767,
		32767, 470,   337,   0,     -351,  0,     245,   18,
		24,    32767, -125,  0,     32767, 114,   0,     146,
		32767, 333,   467,   0,     -65,   193,   32767, 180,
		0,     -196,  229,   32767, 324,   387,   32767, 418,
		100,   32767, 32767, 0,     32767, 32767, 30,    -359,
		32767, 107,   164,   32767, 457,   32767, 265,   32767,
		-116,  5,     -47,   32767, -223,  413,   355,   32767,
		237,   0,     0,     -210,  32767, 698,   264,   283,
		36,    0,     32767, 133,   504,   -8,    32767, 0,
		176,   32767, 0,     32767, 32767, 0,     198,   32767,
		-413,  225,   32767, -91,   32767, 205,   0,     482,
		445,   32767, 0,     391,   -76,   32767, 32767, 515,
		312,   32767, 0,     306,   32767, -239,  32767, 69,
		402,   0,     300,   32767, 32767, 4,     32767, -204,
		319,   440,   32767, 68,    32767, 83,    203,   25,
		32767, 32767, 32767, 32767, 236,   110,   215,   123,
		32767, 288,   142,   -131,  247,   32767, 32767, 32767,
		32767, 10,    32767, 454,   49,    230,   43,    0,
		271,   32767, 450,   337,   32767, 222,   86,    479,
		32767, 32767, 44,    -59,   0,     -300,  32767, -306,
		32767, 32767, 153,   -188,  0,     32767, 32767, 242,
		681,   32767, 32767, -158,  32767, 436,   284,   117,
		238,   0,     32767, 0,     32767, -314,  0,     32767,
		32767, 116,   -475,  32767, 482,   32767, 20,    32767,
		-671,  32767, 471,   359,   0,     -419,  216,   32767,
		92,    541,   -15,   32767, 459,   460,   -104,  32767,
		442,   354,   0,     227,   -341,  411,   312,   32767,
		-163,  -19,   0,     571,   32767, 32767, 32767, 207,
		236,   402,   0,     32767, 9,     414,   32767, 272,
		88,    168,   32767, 32767, -128,  32767, 32767, 32767,
		460,   -289,  32767, 32767, 0,     32767, 183,   -104,
		32767, 32767, 32767, 179,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 304,   226,   0,     81,
		32767, 141,   32767, -96,   -6,    230,   39,    395,
		-237,  32767, 0,     -70,   -122,  349,   107,   276,
		0,     770,   270,   159,   32767, 101,   86,    118,
		-407,  32767, 427,   5,     234,   254,   32767, 0,
		218,   32767, 0,     32767, 32767, 32767, 150,   78,
		32767, -53,   32767, 128,   32767, 405,   -223,  32767,
		370,   -31,   32767, 216,   2,     45,    32767, 32767,
		32767, 379,   98,    360,   240,   32767, 212,   260,
		32767, -316,  391,   32767, -54,   0,     7,     0,
		363,   0,     438,   0,     206,   0,     317,   32767,
		-290,  32767, 167,   32767, 159,   419,   32767, 421,
		204,   0,     251,   32767, 32767, 32767, 485,   0,
		32767, -41,   341,   464,   376,   -27,   313,   0,
		32767, 198,   32767, -129,  439,   491,   32767, 32767,
		0,     -178,  0,     32767, -339,  226,   32767, 543,
		32767, 311,   0,     0,     -120,  0,     0,     0,
		-245,  32767, 0,     32767, -121,  32767, -148,  32767,
		423,   239,   32767, 32767, 217,   189,   32767, 0,
		0,     -202,  0,     32767, 0,     284,   0,     32767,
		79,    175,   -41,   61,    244,   0,     0,     32767,
		32767, 32767, 32767, 0,     32767, 550,   160,   145,
		32767, 32767, 470,   32767, 172,   -282,  89,    32767,
		32767, -98,   0,     32767, 0,     0,     188,   100,
		386,   32767, 32767, 32767, 472,   32767, 300,   32767,
		32767, 0,     32767, -235,  32767, -170,  32767, 0,
		0,     0,     0,     32767, 141,   -71,   0,     0,
		32767, 32767, 0,     32767, 32767, 489,   474,   0,
		177,   0,     -255,  184,   266,   32767, 0,     32767,
		32767, 32767, 32767, 356,   338,   237,   32767, 0,
		32767, 89,    388,   0,     0,     32767, 255,   41,
		32767, -14,   287,   32767, -163,  244,   -355,  -161,
		-1,    406,   506,   0,     475,   119,   305,   32767,
		360,   0,     280,   32767, 32767, 32767, -108,  249,
		374,   32767, 32767, 0,     123,   0,     32767, 32767,
		420,   316,   0,     32767, 32767, -549,  0,     136,
		21,    32767, 133,   32767, 0,     32767, 0,     -9,
		-483,  110,   32767, 74,    0,     32767, 32767, 32767,
		32767, 0,     0,     32767, 103,   32767, 32767, 315,
		0,     -390,  0,     32767, 32767, 150,   0,     -58,
		32767, -270,  76,    0,     79,    275,   0,     0,
		-100,  0,     0,     785,   0,     243,   0,     32767,
		32767, -223,  595,   217,   -108,  0,     231,   0,
		-342,  32767, 32767, 32767, -24,   32767, 32767, 32767,
		147,   0,     32767, 135,   0,     32767, 300,   32767,
		-3,    32767, 0,     32767, 32767, 88,    0,     32767,
		407,   60,    -186,  169,   32767, 0,     0,     234,
		179,   290,   0,     32767, 32767, 295,   330,   -2,
		32767, -22,   32767, 32767, 0,     96,    157,   0,
		0,     0,     314,   473,   32767, 32767, 0,     32767,
		32767, 410,   426,   328,   32767, 32767, 213,   32767,
		0,     32767, 166,   298,   32767, 0,     0,     32767,
		19,    32767, 81,    0,     32767
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 989] + h[b % 989];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
