/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gnome-session-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_mode,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        guint arg_toplevel_xid,
        const gchar *arg_reason,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_id,
        const gchar *arg_client_startup_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.SessionManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusSessionManager
 * @title: PhoshDBusSessionManager
 * @short_description: Generated C code for the org.gnome.SessionManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link> D-Bus interface in C.
 */

enum
{
  PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_ADDED,
  PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_REMOVED,
};

static unsigned PHOSH_DBUS__SESSION_MANAGER_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.gnome.SessionManager ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_logout_IN_ARG_mode =
{
  {
    -1,
    (gchar *) "mode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_logout_IN_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_logout_IN_ARG_mode.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_logout =
{
  {
    -1,
    (gchar *) "Logout",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_logout_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-logout",
  FALSE
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_shutdown =
{
  {
    -1,
    (gchar *) "Shutdown",
    NULL,
    NULL,
    NULL
  },
  "handle-shutdown",
  FALSE
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_reboot =
{
  {
    -1,
    (gchar *) "Reboot",
    NULL,
    NULL,
    NULL
  },
  "handle-reboot",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_inhibit_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_inhibit_IN_ARG_toplevel_xid =
{
  {
    -1,
    (gchar *) "toplevel_xid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_inhibit_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_inhibit_IN_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_inhibit_IN_ARG_app_id.parent_struct,
  &_phosh_dbus_session_manager_method_info_inhibit_IN_ARG_toplevel_xid.parent_struct,
  &_phosh_dbus_session_manager_method_info_inhibit_IN_ARG_reason.parent_struct,
  &_phosh_dbus_session_manager_method_info_inhibit_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_inhibit_OUT_ARG_inhibit_cookie =
{
  {
    -1,
    (gchar *) "inhibit_cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_inhibit_OUT_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_inhibit_OUT_ARG_inhibit_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_inhibit_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_inhibit_OUT_ARG_pointers,
    NULL
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_uninhibit_IN_ARG_inhibit_cookie =
{
  {
    -1,
    (gchar *) "inhibit_cookie",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_uninhibit_IN_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_uninhibit_IN_ARG_inhibit_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_uninhibit =
{
  {
    -1,
    (gchar *) "Uninhibit",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_uninhibit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-uninhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_can_shutdown_OUT_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_can_shutdown_OUT_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_can_shutdown_OUT_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_can_shutdown =
{
  {
    -1,
    (gchar *) "CanShutdown",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_can_shutdown_OUT_ARG_pointers,
    NULL
  },
  "handle-can-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_is_inhibited_IN_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_is_inhibited_IN_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_is_inhibited_IN_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_is_inhibited_OUT_ARG_unnamed_arg1 =
{
  {
    -1,
    (gchar *) "unnamed_arg1",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_is_inhibited_OUT_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_is_inhibited_OUT_ARG_unnamed_arg1.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_is_inhibited =
{
  {
    -1,
    (gchar *) "IsInhibited",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_is_inhibited_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_is_inhibited_OUT_ARG_pointers,
    NULL
  },
  "handle-is-inhibited",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_register_client_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_register_client_IN_ARG_client_startup_id =
{
  {
    -1,
    (gchar *) "client_startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_register_client_IN_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_register_client_IN_ARG_app_id.parent_struct,
  &_phosh_dbus_session_manager_method_info_register_client_IN_ARG_client_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_method_info_register_client_OUT_ARG_client_id =
{
  {
    -1,
    (gchar *) "client_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_method_info_register_client_OUT_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_register_client_OUT_ARG_client_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_session_manager_method_info_register_client =
{
  {
    -1,
    (gchar *) "RegisterClient",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_register_client_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_session_manager_method_info_register_client_OUT_ARG_pointers,
    NULL
  },
  "handle-register-client",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_session_manager_method_info_pointers[] =
{
  &_phosh_dbus_session_manager_method_info_logout.parent_struct,
  &_phosh_dbus_session_manager_method_info_shutdown.parent_struct,
  &_phosh_dbus_session_manager_method_info_reboot.parent_struct,
  &_phosh_dbus_session_manager_method_info_inhibit.parent_struct,
  &_phosh_dbus_session_manager_method_info_uninhibit.parent_struct,
  &_phosh_dbus_session_manager_method_info_can_shutdown.parent_struct,
  &_phosh_dbus_session_manager_method_info_is_inhibited.parent_struct,
  &_phosh_dbus_session_manager_method_info_register_client.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_signal_info_inhibitor_added_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_signal_info_inhibitor_added_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_signal_info_inhibitor_added_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_session_manager_signal_info_inhibitor_added =
{
  {
    -1,
    (gchar *) "InhibitorAdded",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_signal_info_inhibitor_added_ARG_pointers,
    NULL
  },
  "inhibitor-added"
};

static const _ExtendedGDBusArgInfo _phosh_dbus_session_manager_signal_info_inhibitor_removed_ARG_unnamed_arg0 =
{
  {
    -1,
    (gchar *) "unnamed_arg0",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_session_manager_signal_info_inhibitor_removed_ARG_pointers[] =
{
  &_phosh_dbus_session_manager_signal_info_inhibitor_removed_ARG_unnamed_arg0.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_dbus_session_manager_signal_info_inhibitor_removed =
{
  {
    -1,
    (gchar *) "InhibitorRemoved",
    (GDBusArgInfo **) &_phosh_dbus_session_manager_signal_info_inhibitor_removed_ARG_pointers,
    NULL
  },
  "inhibitor-removed"
};

static const GDBusSignalInfo * const _phosh_dbus_session_manager_signal_info_pointers[] =
{
  &_phosh_dbus_session_manager_signal_info_inhibitor_added.parent_struct,
  &_phosh_dbus_session_manager_signal_info_inhibitor_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _phosh_dbus_session_manager_property_info_session_is_active =
{
  {
    -1,
    (gchar *) "SessionIsActive",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-is-active",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _phosh_dbus_session_manager_property_info_pointers[] =
{
  &_phosh_dbus_session_manager_property_info_session_is_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_session_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.SessionManager",
    (GDBusMethodInfo **) &_phosh_dbus_session_manager_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_dbus_session_manager_signal_info_pointers,
    (GDBusPropertyInfo **) &_phosh_dbus_session_manager_property_info_pointers,
    NULL
  },
  "session-manager",
};


/**
 * phosh_dbus_session_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_session_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct;
}

/**
 * phosh_dbus_session_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusSessionManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_session_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "session-is-active");
  return property_id_begin - 1;
}


inline static void
phosh_dbus_session_manager_signal_marshal_inhibitor_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_signal_marshal_inhibitor_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_logout (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_reboot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_inhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_uninhibit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_can_shutdown (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_is_inhibited (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_session_manager_method_marshal_register_client (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusSessionManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 */

/**
 * PhoshDBusSessionManagerIface:
 * @parent_iface: The parent interface.
 * @handle_can_shutdown: Handler for the #PhoshDBusSessionManager::handle-can-shutdown signal.
 * @handle_inhibit: Handler for the #PhoshDBusSessionManager::handle-inhibit signal.
 * @handle_is_inhibited: Handler for the #PhoshDBusSessionManager::handle-is-inhibited signal.
 * @handle_logout: Handler for the #PhoshDBusSessionManager::handle-logout signal.
 * @handle_reboot: Handler for the #PhoshDBusSessionManager::handle-reboot signal.
 * @handle_register_client: Handler for the #PhoshDBusSessionManager::handle-register-client signal.
 * @handle_shutdown: Handler for the #PhoshDBusSessionManager::handle-shutdown signal.
 * @handle_uninhibit: Handler for the #PhoshDBusSessionManager::handle-uninhibit signal.
 * @get_session_is_active: Getter for the #PhoshDBusSessionManager:session-is-active property.
 * @inhibitor_added: Handler for the #PhoshDBusSessionManager::inhibitor-added signal.
 * @inhibitor_removed: Handler for the #PhoshDBusSessionManager::inhibitor-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 */

typedef PhoshDBusSessionManagerIface PhoshDBusSessionManagerInterface;
G_DEFINE_INTERFACE (PhoshDBusSessionManager, phosh_dbus_session_manager, G_TYPE_OBJECT)

static void
phosh_dbus_session_manager_default_init (PhoshDBusSessionManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusSessionManager::handle-logout:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_mode: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_logout() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-logout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_logout),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_logout,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * PhoshDBusSessionManager::handle-shutdown:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PhoshDBusSessionManager::handle-reboot:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_reboot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reboot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_reboot),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_reboot,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PhoshDBusSessionManager::handle-inhibit:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_toplevel_xid: Argument passed by remote caller.
   * @arg_reason: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_inhibit,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT);

  /**
   * PhoshDBusSessionManager::handle-uninhibit:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_inhibit_cookie: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_uninhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_uninhibit),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_uninhibit,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * PhoshDBusSessionManager::handle-can-shutdown:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_can_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_can_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_can_shutdown,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PhoshDBusSessionManager::handle-is-inhibited:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_unnamed_arg0: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_is_inhibited() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-is-inhibited",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_is_inhibited),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_is_inhibited,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * PhoshDBusSessionManager::handle-register-client:
   * @object: A #PhoshDBusSessionManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_client_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_session_manager_complete_register_client() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, handle_register_client),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_session_manager_method_marshal_register_client,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshDBusSessionManager::inhibitor-added:
   * @object: A #PhoshDBusSessionManager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorAdded">"InhibitorAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__SESSION_MANAGER_SIGNALS[PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_ADDED] =
    g_signal_new ("inhibitor-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, inhibitor_added),
      NULL,
      NULL,
      phosh_dbus_session_manager_signal_marshal_inhibitor_added,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * PhoshDBusSessionManager::inhibitor-removed:
   * @object: A #PhoshDBusSessionManager.
   * @arg_unnamed_arg0: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorRemoved">"InhibitorRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_DBUS__SESSION_MANAGER_SIGNALS[PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_REMOVED] =
    g_signal_new ("inhibitor-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshDBusSessionManagerIface, inhibitor_removed),
      NULL,
      NULL,
      phosh_dbus_session_manager_signal_marshal_inhibitor_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * PhoshDBusSessionManager:session-is-active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-SessionManager.SessionIsActive">"SessionIsActive"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("session-is-active", "SessionIsActive", "SessionIsActive", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * phosh_dbus_session_manager_get_session_is_active: (skip)
 * @object: A #PhoshDBusSessionManager.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-SessionManager.SessionIsActive">"SessionIsActive"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
phosh_dbus_session_manager_get_session_is_active (PhoshDBusSessionManager *object)
{
  g_return_val_if_fail (PHOSH_DBUS_IS_SESSION_MANAGER (object), FALSE);

  return PHOSH_DBUS_SESSION_MANAGER_GET_IFACE (object)->get_session_is_active (object);
}

/**
 * phosh_dbus_session_manager_set_session_is_active: (skip)
 * @object: A #PhoshDBusSessionManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-SessionManager.SessionIsActive">"SessionIsActive"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
phosh_dbus_session_manager_set_session_is_active (PhoshDBusSessionManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "session-is-active", value, NULL);
}

/**
 * phosh_dbus_session_manager_emit_inhibitor_added:
 * @object: A #PhoshDBusSessionManager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorAdded">"InhibitorAdded"</link> D-Bus signal.
 */
void
phosh_dbus_session_manager_emit_inhibitor_added (
    PhoshDBusSessionManager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit (object, PHOSH_DBUS__SESSION_MANAGER_SIGNALS[PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_ADDED], 0, arg_unnamed_arg0);
}

/**
 * phosh_dbus_session_manager_emit_inhibitor_removed:
 * @object: A #PhoshDBusSessionManager.
 * @arg_unnamed_arg0: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-SessionManager.InhibitorRemoved">"InhibitorRemoved"</link> D-Bus signal.
 */
void
phosh_dbus_session_manager_emit_inhibitor_removed (
    PhoshDBusSessionManager *object,
    const gchar *arg_unnamed_arg0)
{
  g_signal_emit (object, PHOSH_DBUS__SESSION_MANAGER_SIGNALS[PHOSH_DBUS__SESSION_MANAGER_INHIBITOR_REMOVED], 0, arg_unnamed_arg0);
}

/**
 * phosh_dbus_session_manager_call_logout:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_logout_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_logout_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_logout (
    PhoshDBusSessionManager *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_logout_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_logout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_logout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_logout_finish (
    PhoshDBusSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_logout_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_mode: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_logout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_logout_sync (
    PhoshDBusSessionManager *proxy,
    guint arg_mode,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(u)",
                   arg_mode),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_shutdown:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_shutdown_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_shutdown (
    PhoshDBusSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_shutdown_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_shutdown_finish (
    PhoshDBusSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_shutdown_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_shutdown_sync (
    PhoshDBusSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_reboot:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_reboot_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_reboot_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_reboot (
    PhoshDBusSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_reboot_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_reboot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_reboot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_reboot_finish (
    PhoshDBusSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_reboot_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_reboot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_reboot_sync (
    PhoshDBusSessionManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reboot",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_inhibit:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_toplevel_xid: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_inhibit_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_inhibit (
    PhoshDBusSessionManager *proxy,
    const gchar *arg_app_id,
    guint arg_toplevel_xid,
    const gchar *arg_reason,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(susu)",
                   arg_app_id,
                   arg_toplevel_xid,
                   arg_reason,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_inhibit_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @out_inhibit_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_inhibit_finish (
    PhoshDBusSessionManager *proxy,
    guint *out_inhibit_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_inhibit_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_inhibit_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_toplevel_xid: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_inhibit_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_inhibit_sync (
    PhoshDBusSessionManager *proxy,
    const gchar *arg_app_id,
    guint arg_toplevel_xid,
    const gchar *arg_reason,
    guint arg_flags,
    guint *out_inhibit_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(susu)",
                   arg_app_id,
                   arg_toplevel_xid,
                   arg_reason,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_inhibit_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_uninhibit:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_inhibit_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_uninhibit_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_uninhibit_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_uninhibit (
    PhoshDBusSessionManager *proxy,
    guint arg_inhibit_cookie,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Uninhibit",
    g_variant_new ("(u)",
                   arg_inhibit_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_uninhibit_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_uninhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_uninhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_uninhibit_finish (
    PhoshDBusSessionManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_uninhibit_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_inhibit_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_uninhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_uninhibit_sync (
    PhoshDBusSessionManager *proxy,
    guint arg_inhibit_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Uninhibit",
    g_variant_new ("(u)",
                   arg_inhibit_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_can_shutdown:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_can_shutdown_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_can_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_can_shutdown (
    PhoshDBusSessionManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_can_shutdown_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_can_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_can_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_can_shutdown_finish (
    PhoshDBusSessionManager *proxy,
    gboolean *out_unnamed_arg0,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_can_shutdown_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @out_unnamed_arg0: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_can_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_can_shutdown_sync (
    PhoshDBusSessionManager *proxy,
    gboolean *out_unnamed_arg0,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg0);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_is_inhibited:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_is_inhibited_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_is_inhibited_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_is_inhibited (
    PhoshDBusSessionManager *proxy,
    guint arg_unnamed_arg0,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "IsInhibited",
    g_variant_new ("(u)",
                   arg_unnamed_arg0),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_is_inhibited_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_is_inhibited().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_is_inhibited().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_is_inhibited_finish (
    PhoshDBusSessionManager *proxy,
    gboolean *out_unnamed_arg1,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_is_inhibited_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_unnamed_arg0: Argument to pass with the method invocation.
 * @out_unnamed_arg1: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_is_inhibited() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_is_inhibited_sync (
    PhoshDBusSessionManager *proxy,
    guint arg_unnamed_arg0,
    gboolean *out_unnamed_arg1,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "IsInhibited",
    g_variant_new ("(u)",
                   arg_unnamed_arg0),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_unnamed_arg1);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_register_client:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_call_register_client_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_call_register_client_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_session_manager_call_register_client (
    PhoshDBusSessionManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_session_manager_call_register_client_finish:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_call_register_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_session_manager_call_register_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_register_client_finish (
    PhoshDBusSessionManager *proxy,
    gchar **out_client_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_call_register_client_sync:
 * @proxy: A #PhoshDBusSessionManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_call_register_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_session_manager_call_register_client_sync (
    PhoshDBusSessionManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    gchar **out_client_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_session_manager_complete_logout:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Logout">Logout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_logout (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_dbus_session_manager_complete_shutdown:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Shutdown">Shutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_shutdown (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_dbus_session_manager_complete_reboot:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Reboot">Reboot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_reboot (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_dbus_session_manager_complete_inhibit:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @inhibit_cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_inhibit (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint inhibit_cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   inhibit_cookie));
}

/**
 * phosh_dbus_session_manager_complete_uninhibit:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.Uninhibit">Uninhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_uninhibit (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_dbus_session_manager_complete_can_shutdown:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg0: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.CanShutdown">CanShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_can_shutdown (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean unnamed_arg0)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   unnamed_arg0));
}

/**
 * phosh_dbus_session_manager_complete_is_inhibited:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @unnamed_arg1: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.IsInhibited">IsInhibited()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_is_inhibited (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean unnamed_arg1)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   unnamed_arg1));
}

/**
 * phosh_dbus_session_manager_complete_register_client:
 * @object: A #PhoshDBusSessionManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @client_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-SessionManager.RegisterClient">RegisterClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_session_manager_complete_register_client (
    PhoshDBusSessionManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *client_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   client_id));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusSessionManagerProxy:
 *
 * The #PhoshDBusSessionManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusSessionManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusSessionManagerProxy.
 */

struct _PhoshDBusSessionManagerProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_session_manager_proxy_iface_init (PhoshDBusSessionManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusSessionManagerProxy, phosh_dbus_session_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusSessionManagerProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SESSION_MANAGER, phosh_dbus_session_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusSessionManagerProxy, phosh_dbus_session_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SESSION_MANAGER, phosh_dbus_session_manager_proxy_iface_init))

#endif
static void
phosh_dbus_session_manager_proxy_finalize (GObject *object)
{
  PhoshDBusSessionManagerProxy *proxy = PHOSH_DBUS_SESSION_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_session_manager_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_session_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _phosh_dbus_session_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
phosh_dbus_session_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.SessionManager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
phosh_dbus_session_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _phosh_dbus_session_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.SessionManager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) phosh_dbus_session_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
phosh_dbus_session_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_SESSION_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_SESSION_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_session_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusSessionManagerProxy *proxy = PHOSH_DBUS_SESSION_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
phosh_dbus_session_manager_proxy_get_session_is_active (PhoshDBusSessionManager *object)
{
  PhoshDBusSessionManagerProxy *proxy = PHOSH_DBUS_SESSION_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionIsActive");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
phosh_dbus_session_manager_proxy_init (PhoshDBusSessionManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_session_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_SESSION_MANAGER_PROXY, PhoshDBusSessionManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_session_manager_interface_info ());
}

static void
phosh_dbus_session_manager_proxy_class_init (PhoshDBusSessionManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_session_manager_proxy_finalize;
  gobject_class->get_property = phosh_dbus_session_manager_proxy_get_property;
  gobject_class->set_property = phosh_dbus_session_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_session_manager_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_session_manager_proxy_g_properties_changed;

  phosh_dbus_session_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusSessionManagerProxyPrivate));
#endif
}

static void
phosh_dbus_session_manager_proxy_iface_init (PhoshDBusSessionManagerIface *iface)
{
  iface->get_session_is_active = phosh_dbus_session_manager_proxy_get_session_is_active;
}

/**
 * phosh_dbus_session_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_session_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_SESSION_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
}

/**
 * phosh_dbus_session_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_session_manager_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusSessionManager *
phosh_dbus_session_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_SESSION_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_session_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusSessionManager *
phosh_dbus_session_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_SESSION_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_SESSION_MANAGER (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_session_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_session_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_session_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_session_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_session_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_SESSION_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
}

/**
 * phosh_dbus_session_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_session_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_session_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusSessionManager *
phosh_dbus_session_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_SESSION_MANAGER (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_session_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_session_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_session_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusSessionManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusSessionManager *
phosh_dbus_session_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_SESSION_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.SessionManager", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_SESSION_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusSessionManagerSkeleton:
 *
 * The #PhoshDBusSessionManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusSessionManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusSessionManagerSkeleton.
 */

struct _PhoshDBusSessionManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_session_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_SESSION_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_SESSION_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_session_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_session_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_session_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_session_manager_skeleton_vtable =
{
  _phosh_dbus_session_manager_skeleton_handle_method_call,
  _phosh_dbus_session_manager_skeleton_handle_get_property,
  _phosh_dbus_session_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_session_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_session_manager_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_session_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_session_manager_skeleton_vtable;
}

static GVariant *
phosh_dbus_session_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_session_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_session_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_session_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_session_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _phosh_dbus_session_manager_emit_changed (gpointer user_data);

static void
phosh_dbus_session_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _phosh_dbus_session_manager_emit_changed (skeleton);
}

static void
_phosh_dbus_session_manager_on_signal_inhibitor_added (
    PhoshDBusSessionManager *object,
    const gchar *arg_unnamed_arg0)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "InhibitorAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_dbus_session_manager_on_signal_inhibitor_removed (
    PhoshDBusSessionManager *object,
    const gchar *arg_unnamed_arg0)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_unnamed_arg0));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.SessionManager", "InhibitorRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_dbus_session_manager_skeleton_iface_init (PhoshDBusSessionManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusSessionManagerSkeleton, phosh_dbus_session_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusSessionManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SESSION_MANAGER, phosh_dbus_session_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusSessionManagerSkeleton, phosh_dbus_session_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SESSION_MANAGER, phosh_dbus_session_manager_skeleton_iface_init))

#endif
static void
phosh_dbus_session_manager_skeleton_finalize (GObject *object)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_session_manager_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_session_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_phosh_dbus_session_manager_emit_changed (gpointer user_data)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.SessionManager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_phosh_dbus_session_manager_schedule_emit_changed (PhoshDBusSessionManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
phosh_dbus_session_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _phosh_dbus_session_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _phosh_dbus_session_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
phosh_dbus_session_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _phosh_dbus_session_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _phosh_dbus_session_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
phosh_dbus_session_manager_skeleton_init (PhoshDBusSessionManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_session_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_SESSION_MANAGER_SKELETON, PhoshDBusSessionManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
}

static gboolean 
phosh_dbus_session_manager_skeleton_get_session_is_active (PhoshDBusSessionManager *object)
{
  PhoshDBusSessionManagerSkeleton *skeleton = PHOSH_DBUS_SESSION_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
phosh_dbus_session_manager_skeleton_class_init (PhoshDBusSessionManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_session_manager_skeleton_finalize;
  gobject_class->get_property = phosh_dbus_session_manager_skeleton_get_property;
  gobject_class->set_property = phosh_dbus_session_manager_skeleton_set_property;
  gobject_class->notify       = phosh_dbus_session_manager_skeleton_notify;


  phosh_dbus_session_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_session_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_session_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_session_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_session_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusSessionManagerSkeletonPrivate));
#endif
}

static void
phosh_dbus_session_manager_skeleton_iface_init (PhoshDBusSessionManagerIface *iface)
{
  iface->inhibitor_added = _phosh_dbus_session_manager_on_signal_inhibitor_added;
  iface->inhibitor_removed = _phosh_dbus_session_manager_on_signal_inhibitor_removed;
  iface->get_session_is_active = phosh_dbus_session_manager_skeleton_get_session_is_active;
}

/**
 * phosh_dbus_session_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-SessionManager.top_of_page">org.gnome.SessionManager</link>.
 *
 * Returns: (transfer full) (type PhoshDBusSessionManagerSkeleton): The skeleton object.
 */
PhoshDBusSessionManager *
phosh_dbus_session_manager_skeleton_new (void)
{
  return PHOSH_DBUS_SESSION_MANAGER (g_object_new (PHOSH_DBUS_TYPE_SESSION_MANAGER_SKELETON, NULL));
}

