/* RawSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RawSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _graw_processor_unref0(var) ((var == NULL) ? NULL : (var = (graw_processor_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))

static gpointer raw_file_format_driver_parent_class = NULL;
static RawFileFormatDriver* raw_file_format_driver_instance;
static RawFileFormatDriver* raw_file_format_driver_instance = NULL;
static gpointer raw_file_format_properties_parent_class = NULL;
static gchar** raw_file_format_properties_known_extensions;
static gint raw_file_format_properties_known_extensions_length1;
static gchar** raw_file_format_properties_known_extensions = NULL;
static gint raw_file_format_properties_known_extensions_length1 = 0;
static gint _raw_file_format_properties_known_extensions_size_ = 0;
static gchar** raw_file_format_properties_known_mime_types;
static gint raw_file_format_properties_known_mime_types_length1;
static gchar** raw_file_format_properties_known_mime_types = NULL;
static gint raw_file_format_properties_known_mime_types_length1 = 0;
static gint _raw_file_format_properties_known_mime_types_size_ = 0;
static RawFileFormatProperties* raw_file_format_properties_instance;
static RawFileFormatProperties* raw_file_format_properties_instance = NULL;
static gpointer raw_sniffer_parent_class = NULL;
static gpointer raw_reader_parent_class = NULL;

static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                            const gchar* filepath);
static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                             const gchar* filepath);
static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                              GFile* file,
                                                              PhotoFileSnifferOptions options);
static void raw_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType raw_file_format_driver_get_type_once (void);
static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                              gint* result_length1);
static gchar** _vala_array_dup20 (gchar** self,
                           gssize length);
static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                        gint* result_length1);
static gchar** _vala_array_dup21 (gchar** self,
                           gssize length);
static void raw_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType raw_file_format_properties_get_type_once (void);
static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base,
                                                  GError** error);
static GType raw_sniffer_get_type_once (void);
static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base,
                                              GError** error);
static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base,
                                          GError** error);
static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base,
                                        Dimensions* full,
                                        Dimensions* scaled,
                                        GError** error);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static GType raw_reader_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
raw_file_format_driver_init (void)
{
	RawFileFormatDriver* _tmp0_;
	_tmp0_ = raw_file_format_driver_new ();
	_photo_file_format_driver_unref0 (raw_file_format_driver_instance);
	raw_file_format_driver_instance = _tmp0_;
	raw_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

RawFileFormatDriver*
raw_file_format_driver_get_instance (void)
{
	RawFileFormatDriver* _tmp0_;
	RawFileFormatDriver* _tmp1_;
	RawFileFormatDriver* result;
	_tmp0_ = raw_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	RawFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (RawFileFormatDriver*) base;
	_tmp0_ = raw_file_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	RawFileFormatDriver * self;
	RawReader* _tmp0_;
	PhotoFileReader* result;
	self = (RawFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = raw_reader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static PhotoMetadata*
raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (RawFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

static gboolean
raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	gboolean result;
	self = (RawFileFormatDriver*) base;
	result = FALSE;
	return result;
}

static gboolean
raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	RawFileFormatDriver * self;
	gboolean result;
	self = (RawFileFormatDriver*) base;
	result = FALSE;
	return result;
}

static PhotoFileWriter*
raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                           const gchar* filepath)
{
	RawFileFormatDriver * self;
	PhotoFileWriter* result;
	self = (RawFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileMetadataWriter*
raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                    const gchar* filepath)
{
	RawFileFormatDriver * self;
	PhotoFileMetadataWriter* result;
	self = (RawFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	result = NULL;
	return result;
}

static PhotoFileSniffer*
raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                            GFile* file,
                                            PhotoFileSnifferOptions options)
{
	RawFileFormatDriver * self;
	RawSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (RawFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = raw_sniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

RawFileFormatDriver*
raw_file_format_driver_construct (GType object_type)
{
	RawFileFormatDriver* self = NULL;
	self = (RawFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

RawFileFormatDriver*
raw_file_format_driver_new (void)
{
	return raw_file_format_driver_construct (TYPE_RAW_FILE_FORMAT_DRIVER);
}

static void
raw_file_format_driver_class_init (RawFileFormatDriverClass * klass,
                                   gpointer klass_data)
{
	raw_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = raw_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_create_metadata;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) raw_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) raw_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) raw_file_format_driver_real_create_sniffer;
}

static void
raw_file_format_driver_instance_init (RawFileFormatDriver * self,
                                      gpointer klass)
{
}

static void
raw_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	RawFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (raw_file_format_driver_parent_class)->finalize (obj);
}

static GType
raw_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatDriver), 0, (GInstanceInitFunc) raw_file_format_driver_instance_init, NULL };
	GType raw_file_format_driver_type_id;
	raw_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "RawFileFormatDriver", &g_define_type_info, 0);
	return raw_file_format_driver_type_id;
}

GType
raw_file_format_driver_get_type (void)
{
	static volatile gsize raw_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&raw_file_format_driver_type_id__once)) {
		GType raw_file_format_driver_type_id;
		raw_file_format_driver_type_id = raw_file_format_driver_get_type_once ();
		g_once_init_leave (&raw_file_format_driver_type_id__once, raw_file_format_driver_type_id);
	}
	return raw_file_format_driver_type_id__once;
}

void
raw_file_format_properties_init (void)
{
	RawFileFormatProperties* _tmp0_;
	_tmp0_ = raw_file_format_properties_new ();
	_photo_file_format_properties_unref0 (raw_file_format_properties_instance);
	raw_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

RawFileFormatProperties*
raw_file_format_properties_get_instance (void)
{
	RawFileFormatProperties* _tmp0_;
	RawFileFormatProperties* _tmp1_;
	RawFileFormatProperties* result;
	_tmp0_ = raw_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	PhotoFileFormat result;
	self = (RawFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_RAW;
	return result;
}

static gchar*
raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (RawFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("RAW"));
	result = _tmp0_;
	return result;
}

static PhotoFileFormatFlags
raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (RawFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (RawFileFormatProperties*) base;
	_tmp0_ = g_strdup ("raw");
	result = _tmp0_;
	return result;
}

static gchar**
_vala_array_dup20 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                      gint* result_length1)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (RawFileFormatProperties*) base;
	_tmp0_ = raw_file_format_properties_known_extensions;
	_tmp0__length1 = raw_file_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup20 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (RawFileFormatProperties*) base;
	_tmp0_ = raw_file_format_properties_known_mime_types;
	_tmp0__length1 = raw_file_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup21 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                gint* result_length1)
{
	RawFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (RawFileFormatProperties*) base;
	_tmp0_ = raw_file_format_properties_known_mime_types;
	_tmp0__length1 = raw_file_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup21 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

RawFileFormatProperties*
raw_file_format_properties_construct (GType object_type)
{
	RawFileFormatProperties* self = NULL;
	self = (RawFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

RawFileFormatProperties*
raw_file_format_properties_new (void)
{
	return raw_file_format_properties_construct (TYPE_RAW_FILE_FORMAT_PROPERTIES);
}

static void
raw_file_format_properties_class_init (RawFileFormatPropertiesClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar** _tmp88_;
	raw_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = raw_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) raw_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) raw_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) raw_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("3fr");
	_tmp1_ = g_strdup ("arw");
	_tmp2_ = g_strdup ("srf");
	_tmp3_ = g_strdup ("sr2");
	_tmp4_ = g_strdup ("bay");
	_tmp5_ = g_strdup ("crw");
	_tmp6_ = g_strdup ("cr2");
	_tmp7_ = g_strdup ("cap");
	_tmp8_ = g_strdup ("iiq");
	_tmp9_ = g_strdup ("eip");
	_tmp10_ = g_strdup ("dcs");
	_tmp11_ = g_strdup ("dcr");
	_tmp12_ = g_strdup ("drf");
	_tmp13_ = g_strdup ("k25");
	_tmp14_ = g_strdup ("kdc");
	_tmp15_ = g_strdup ("dng");
	_tmp16_ = g_strdup ("erf");
	_tmp17_ = g_strdup ("fff");
	_tmp18_ = g_strdup ("mef");
	_tmp19_ = g_strdup ("mos");
	_tmp20_ = g_strdup ("mrw");
	_tmp21_ = g_strdup ("nef");
	_tmp22_ = g_strdup ("nrw");
	_tmp23_ = g_strdup ("orf");
	_tmp24_ = g_strdup ("ptx");
	_tmp25_ = g_strdup ("pef");
	_tmp26_ = g_strdup ("pxn");
	_tmp27_ = g_strdup ("r3d");
	_tmp28_ = g_strdup ("raf");
	_tmp29_ = g_strdup ("raw");
	_tmp30_ = g_strdup ("rw2");
	_tmp31_ = g_strdup ("raw");
	_tmp32_ = g_strdup ("rwl");
	_tmp33_ = g_strdup ("rwz");
	_tmp34_ = g_strdup ("x3f");
	_tmp35_ = g_strdup ("srw");
	_tmp36_ = g_new0 (gchar*, 36 + 1);
	_tmp36_[0] = _tmp0_;
	_tmp36_[1] = _tmp1_;
	_tmp36_[2] = _tmp2_;
	_tmp36_[3] = _tmp3_;
	_tmp36_[4] = _tmp4_;
	_tmp36_[5] = _tmp5_;
	_tmp36_[6] = _tmp6_;
	_tmp36_[7] = _tmp7_;
	_tmp36_[8] = _tmp8_;
	_tmp36_[9] = _tmp9_;
	_tmp36_[10] = _tmp10_;
	_tmp36_[11] = _tmp11_;
	_tmp36_[12] = _tmp12_;
	_tmp36_[13] = _tmp13_;
	_tmp36_[14] = _tmp14_;
	_tmp36_[15] = _tmp15_;
	_tmp36_[16] = _tmp16_;
	_tmp36_[17] = _tmp17_;
	_tmp36_[18] = _tmp18_;
	_tmp36_[19] = _tmp19_;
	_tmp36_[20] = _tmp20_;
	_tmp36_[21] = _tmp21_;
	_tmp36_[22] = _tmp22_;
	_tmp36_[23] = _tmp23_;
	_tmp36_[24] = _tmp24_;
	_tmp36_[25] = _tmp25_;
	_tmp36_[26] = _tmp26_;
	_tmp36_[27] = _tmp27_;
	_tmp36_[28] = _tmp28_;
	_tmp36_[29] = _tmp29_;
	_tmp36_[30] = _tmp30_;
	_tmp36_[31] = _tmp31_;
	_tmp36_[32] = _tmp32_;
	_tmp36_[33] = _tmp33_;
	_tmp36_[34] = _tmp34_;
	_tmp36_[35] = _tmp35_;
	raw_file_format_properties_known_extensions = _tmp36_;
	raw_file_format_properties_known_extensions_length1 = 36;
	_raw_file_format_properties_known_extensions_size_ = raw_file_format_properties_known_extensions_length1;
	_tmp37_ = g_strdup ("image/x-dcraw");
	_tmp38_ = g_strdup ("image/x-canon-cr2");
	_tmp39_ = g_strdup ("image/x-canon-crw");
	_tmp40_ = g_strdup ("image/x-fuji-raf");
	_tmp41_ = g_strdup ("image/x-adobe-dng");
	_tmp42_ = g_strdup ("image/x-panasonic-raw");
	_tmp43_ = g_strdup ("image/x-raw");
	_tmp44_ = g_strdup ("image/x-minolta-mrw");
	_tmp45_ = g_strdup ("image/x-nikon-nef");
	_tmp46_ = g_strdup ("image/x-olympus-orf");
	_tmp47_ = g_strdup ("image/x-pentax-pef");
	_tmp48_ = g_strdup ("image/x-sony-arw");
	_tmp49_ = g_strdup ("image/x-sony-srf");
	_tmp50_ = g_strdup ("image/x-sony-sr2");
	_tmp51_ = g_strdup ("image/x-samsung-raw");
	_tmp52_ = g_strdup ("image/x-3fr");
	_tmp53_ = g_strdup ("image/x-arw");
	_tmp54_ = g_strdup ("image/x-srf");
	_tmp55_ = g_strdup ("image/x-sr2");
	_tmp56_ = g_strdup ("image/x-bay");
	_tmp57_ = g_strdup ("image/x-crw");
	_tmp58_ = g_strdup ("image/x-cr2");
	_tmp59_ = g_strdup ("image/x-cap");
	_tmp60_ = g_strdup ("image/x-iiq");
	_tmp61_ = g_strdup ("image/x-eip");
	_tmp62_ = g_strdup ("image/x-dcs");
	_tmp63_ = g_strdup ("image/x-dcr");
	_tmp64_ = g_strdup ("image/x-drf");
	_tmp65_ = g_strdup ("image/x-k25");
	_tmp66_ = g_strdup ("image/x-kdc");
	_tmp67_ = g_strdup ("image/x-dng");
	_tmp68_ = g_strdup ("image/x-erf");
	_tmp69_ = g_strdup ("image/x-fff");
	_tmp70_ = g_strdup ("image/x-mef");
	_tmp71_ = g_strdup ("image/x-mos");
	_tmp72_ = g_strdup ("image/x-mrw");
	_tmp73_ = g_strdup ("image/x-nef");
	_tmp74_ = g_strdup ("image/x-nrw");
	_tmp75_ = g_strdup ("image/x-orf");
	_tmp76_ = g_strdup ("image/x-ptx");
	_tmp77_ = g_strdup ("image/x-pef");
	_tmp78_ = g_strdup ("image/x-pxn");
	_tmp79_ = g_strdup ("image/x-r3d");
	_tmp80_ = g_strdup ("image/x-raf");
	_tmp81_ = g_strdup ("image/x-raw");
	_tmp82_ = g_strdup ("image/x-rw2");
	_tmp83_ = g_strdup ("image/x-raw");
	_tmp84_ = g_strdup ("image/x-rwl");
	_tmp85_ = g_strdup ("image/x-rwz");
	_tmp86_ = g_strdup ("image/x-x3f");
	_tmp87_ = g_strdup ("image/x-srw");
	_tmp88_ = g_new0 (gchar*, 51 + 1);
	_tmp88_[0] = _tmp37_;
	_tmp88_[1] = _tmp38_;
	_tmp88_[2] = _tmp39_;
	_tmp88_[3] = _tmp40_;
	_tmp88_[4] = _tmp41_;
	_tmp88_[5] = _tmp42_;
	_tmp88_[6] = _tmp43_;
	_tmp88_[7] = _tmp44_;
	_tmp88_[8] = _tmp45_;
	_tmp88_[9] = _tmp46_;
	_tmp88_[10] = _tmp47_;
	_tmp88_[11] = _tmp48_;
	_tmp88_[12] = _tmp49_;
	_tmp88_[13] = _tmp50_;
	_tmp88_[14] = _tmp51_;
	_tmp88_[15] = _tmp52_;
	_tmp88_[16] = _tmp53_;
	_tmp88_[17] = _tmp54_;
	_tmp88_[18] = _tmp55_;
	_tmp88_[19] = _tmp56_;
	_tmp88_[20] = _tmp57_;
	_tmp88_[21] = _tmp58_;
	_tmp88_[22] = _tmp59_;
	_tmp88_[23] = _tmp60_;
	_tmp88_[24] = _tmp61_;
	_tmp88_[25] = _tmp62_;
	_tmp88_[26] = _tmp63_;
	_tmp88_[27] = _tmp64_;
	_tmp88_[28] = _tmp65_;
	_tmp88_[29] = _tmp66_;
	_tmp88_[30] = _tmp67_;
	_tmp88_[31] = _tmp68_;
	_tmp88_[32] = _tmp69_;
	_tmp88_[33] = _tmp70_;
	_tmp88_[34] = _tmp71_;
	_tmp88_[35] = _tmp72_;
	_tmp88_[36] = _tmp73_;
	_tmp88_[37] = _tmp74_;
	_tmp88_[38] = _tmp75_;
	_tmp88_[39] = _tmp76_;
	_tmp88_[40] = _tmp77_;
	_tmp88_[41] = _tmp78_;
	_tmp88_[42] = _tmp79_;
	_tmp88_[43] = _tmp80_;
	_tmp88_[44] = _tmp81_;
	_tmp88_[45] = _tmp82_;
	_tmp88_[46] = _tmp83_;
	_tmp88_[47] = _tmp84_;
	_tmp88_[48] = _tmp85_;
	_tmp88_[49] = _tmp86_;
	_tmp88_[50] = _tmp87_;
	raw_file_format_properties_known_mime_types = _tmp88_;
	raw_file_format_properties_known_mime_types_length1 = 51;
	_raw_file_format_properties_known_mime_types_size_ = raw_file_format_properties_known_mime_types_length1;
}

static void
raw_file_format_properties_instance_init (RawFileFormatProperties * self,
                                          gpointer klass)
{
}

static void
raw_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	RawFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (raw_file_format_properties_parent_class)->finalize (obj);
}

static GType
raw_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatProperties), 0, (GInstanceInitFunc) raw_file_format_properties_instance_init, NULL };
	GType raw_file_format_properties_type_id;
	raw_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "RawFileFormatProperties", &g_define_type_info, 0);
	return raw_file_format_properties_type_id;
}

GType
raw_file_format_properties_get_type (void)
{
	static volatile gsize raw_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&raw_file_format_properties_type_id__once)) {
		GType raw_file_format_properties_type_id;
		raw_file_format_properties_type_id = raw_file_format_properties_get_type_once ();
		g_once_init_leave (&raw_file_format_properties_type_id__once, raw_file_format_properties_type_id);
	}
	return raw_file_format_properties_type_id__once;
}

RawSniffer*
raw_sniffer_construct (GType object_type,
                       GFile* file,
                       PhotoFileSnifferOptions options)
{
	RawSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (RawSniffer*) photo_file_sniffer_construct (object_type, file, options);
	return self;
}

RawSniffer*
raw_sniffer_new (GFile* file,
                 PhotoFileSnifferOptions options)
{
	return raw_sniffer_construct (TYPE_RAW_SNIFFER, file, options);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static DetectedPhotoInformation*
raw_sniffer_real_sniff (PhotoFileSniffer* base,
                        GError** error)
{
	RawSniffer * self;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp0_;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	DetectedPhotoInformation* _tmp14_;
	GRawProcessor* _tmp15_;
	GRawProcessor* _tmp16_;
	DetectedPhotoInformation* _tmp17_;
	DetectedPhotoInformation* _tmp18_;
	DetectedPhotoInformation* _tmp19_;
	RawReader* reader = NULL;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	RawReader* _tmp23_;
	RawReader* _tmp24_;
	DetectedPhotoInformation* _tmp30_;
	PhotoMetadata* _tmp31_;
	DetectedPhotoInformation* _tmp59_;
	gchar* _tmp60_;
	DetectedPhotoInformation* _tmp61_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (RawSniffer*) base;
	_tmp0_ = detected_photo_information_new ();
	detected = _tmp0_;
	_tmp1_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp1_;
	_tmp2_ = processor;
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
	_tmp4_ = _tmp3_;
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
	{
		GRawProcessor* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRawProcessor* _tmp9_;
		GRawProcessor* _tmp10_;
		_tmp5_ = processor;
		_tmp6_ = ((PhotoFileSniffer*) self)->file;
		_tmp7_ = g_file_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		graw_processor_open_file (_tmp5_, _tmp8_, &_inner_error0_);
		_g_free0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				goto __catch0_graw_exception;
			}
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp9_ = processor;
		graw_processor_unpack (_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				goto __catch0_graw_exception;
			}
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = processor;
		graw_processor_adjust_sizes_info_only (_tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GRAW_EXCEPTION) {
				goto __catch0_graw_exception;
			}
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_graw_exception:
	{
		GError* exception = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		exception = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = exception;
		if (g_error_matches (_tmp11_, GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE)) {
			result = NULL;
			_g_error_free0 (exception);
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			return result;
		}
		_tmp12_ = exception;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_inner_error0_ = _tmp13_;
		_g_error_free0 (exception);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		_detected_photo_information_unref0 (detected);
		return NULL;
	}
	_tmp14_ = detected;
	_tmp15_ = processor;
	_tmp16_ = processor;
	dimensions_init (&_tmp14_->image_dim, (gint) graw_processor_get_sizes (_tmp15_).iwidth, (gint) graw_processor_get_sizes (_tmp16_).iheight);
	_tmp17_ = detected;
	_tmp17_->colorspace = GDK_COLORSPACE_RGB;
	_tmp18_ = detected;
	_tmp18_->channels = 3;
	_tmp19_ = detected;
	_tmp19_->bits_per_channel = 8;
	_tmp20_ = ((PhotoFileSniffer*) self)->file;
	_tmp21_ = g_file_get_path (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = raw_reader_new (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	reader = _tmp24_;
	{
		PhotoMetadata* _tmp25_ = NULL;
		RawReader* _tmp26_;
		PhotoMetadata* _tmp27_;
		DetectedPhotoInformation* _tmp28_;
		PhotoMetadata* _tmp29_;
		_tmp26_ = reader;
		_tmp27_ = photo_file_reader_read_metadata ((PhotoFileReader*) _tmp26_, &_inner_error0_);
		_tmp25_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp28_ = detected;
		_tmp29_ = _tmp25_;
		_tmp25_ = NULL;
		_media_metadata_unref0 (_tmp28_->metadata);
		_tmp28_->metadata = _tmp29_;
		_media_metadata_unref0 (_tmp25_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (reader);
		_graw_processor_unref0 (processor);
		_detected_photo_information_unref0 (detected);
		return NULL;
	}
	_tmp30_ = detected;
	_tmp31_ = _tmp30_->metadata;
	if (_tmp31_ != NULL) {
		guint8* flattened_sans_thumbnail = NULL;
		DetectedPhotoInformation* _tmp32_;
		PhotoMetadata* _tmp33_;
		gint _tmp34_ = 0;
		guint8* _tmp35_;
		gint flattened_sans_thumbnail_length1;
		gint _flattened_sans_thumbnail_size_;
		gboolean _tmp36_ = FALSE;
		guint8* _tmp37_;
		gint _tmp37__length1;
		guint8* flattened_thumbnail = NULL;
		DetectedPhotoInformation* _tmp43_;
		PhotoMetadata* _tmp44_;
		gint _tmp45_ = 0;
		guint8* _tmp46_;
		gint flattened_thumbnail_length1;
		gint _flattened_thumbnail_size_;
		gboolean _tmp47_ = FALSE;
		guint8* _tmp48_;
		gint _tmp48__length1;
		_tmp32_ = detected;
		_tmp33_ = _tmp32_->metadata;
		_tmp35_ = photo_metadata_flatten_exif (_tmp33_, FALSE, &_tmp34_);
		flattened_sans_thumbnail = _tmp35_;
		flattened_sans_thumbnail_length1 = _tmp34_;
		_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
		_tmp37_ = flattened_sans_thumbnail;
		_tmp37__length1 = flattened_sans_thumbnail_length1;
		if (_tmp37_ != NULL) {
			guint8* _tmp38_;
			gint _tmp38__length1;
			_tmp38_ = flattened_sans_thumbnail;
			_tmp38__length1 = flattened_sans_thumbnail_length1;
			_tmp36_ = _tmp38__length1 > 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			DetectedPhotoInformation* _tmp39_;
			guint8* _tmp40_;
			gint _tmp40__length1;
			guint8* _tmp41_;
			gint _tmp41__length1;
			gchar* _tmp42_;
			_tmp39_ = detected;
			_tmp40_ = flattened_sans_thumbnail;
			_tmp40__length1 = flattened_sans_thumbnail_length1;
			_tmp41_ = flattened_sans_thumbnail;
			_tmp41__length1 = flattened_sans_thumbnail_length1;
			_tmp42_ = md5_binary (_tmp40_, (gsize) _tmp41__length1);
			_g_free0 (_tmp39_->exif_md5);
			_tmp39_->exif_md5 = _tmp42_;
		}
		_tmp43_ = detected;
		_tmp44_ = _tmp43_->metadata;
		_tmp46_ = photo_metadata_flatten_exif_preview (_tmp44_, &_tmp45_);
		flattened_thumbnail = _tmp46_;
		flattened_thumbnail_length1 = _tmp45_;
		_flattened_thumbnail_size_ = flattened_thumbnail_length1;
		_tmp48_ = flattened_thumbnail;
		_tmp48__length1 = flattened_thumbnail_length1;
		if (_tmp48_ != NULL) {
			guint8* _tmp49_;
			gint _tmp49__length1;
			_tmp49_ = flattened_thumbnail;
			_tmp49__length1 = flattened_thumbnail_length1;
			_tmp47_ = _tmp49__length1 > 0;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			DetectedPhotoInformation* _tmp50_;
			guint8* _tmp51_;
			gint _tmp51__length1;
			guint8* _tmp52_;
			gint _tmp52__length1;
			gchar* _tmp53_;
			_tmp50_ = detected;
			_tmp51_ = flattened_thumbnail;
			_tmp51__length1 = flattened_thumbnail_length1;
			_tmp52_ = flattened_thumbnail;
			_tmp52__length1 = flattened_thumbnail_length1;
			_tmp53_ = md5_binary (_tmp51_, (gsize) _tmp52__length1);
			_g_free0 (_tmp50_->thumbnail_md5);
			_tmp50_->thumbnail_md5 = _tmp53_;
		}
		flattened_thumbnail = (g_free (flattened_thumbnail), NULL);
		flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
	}
	if (((PhotoFileSniffer*) self)->calc_md5) {
		gchar* _tmp54_ = NULL;
		GFile* _tmp55_;
		gchar* _tmp56_;
		DetectedPhotoInformation* _tmp57_;
		gchar* _tmp58_;
		_tmp55_ = ((PhotoFileSniffer*) self)->file;
		_tmp56_ = md5_file (_tmp55_, &_inner_error0_);
		_tmp54_ = _tmp56_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (reader);
			_graw_processor_unref0 (processor);
			_detected_photo_information_unref0 (detected);
			return NULL;
		}
		_tmp57_ = detected;
		_tmp58_ = _tmp54_;
		_tmp54_ = NULL;
		_g_free0 (_tmp57_->md5);
		_tmp57_->md5 = _tmp58_;
		_g_free0 (_tmp54_);
	}
	_tmp59_ = detected;
	_tmp60_ = g_strdup ("raw");
	_g_free0 (_tmp59_->format_name);
	_tmp59_->format_name = _tmp60_;
	_tmp61_ = detected;
	_tmp61_->file_format = PHOTO_FILE_FORMAT_RAW;
	result = detected;
	_photo_file_adapter_unref0 (reader);
	_graw_processor_unref0 (processor);
	return result;
}

static void
raw_sniffer_class_init (RawSnifferClass * klass,
                        gpointer klass_data)
{
	raw_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) raw_sniffer_real_sniff;
}

static void
raw_sniffer_instance_init (RawSniffer * self,
                           gpointer klass)
{
}

static GType
raw_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawSniffer), 0, (GInstanceInitFunc) raw_sniffer_instance_init, NULL };
	GType raw_sniffer_type_id;
	raw_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "RawSniffer", &g_define_type_info, 0);
	return raw_sniffer_type_id;
}

GType
raw_sniffer_get_type (void)
{
	static volatile gsize raw_sniffer_type_id__once = 0;
	if (g_once_init_enter (&raw_sniffer_type_id__once)) {
		GType raw_sniffer_type_id;
		raw_sniffer_type_id = raw_sniffer_get_type_once ();
		g_once_init_leave (&raw_sniffer_type_id__once, raw_sniffer_type_id);
	}
	return raw_sniffer_type_id__once;
}

RawReader*
raw_reader_construct (GType object_type,
                      const gchar* filepath)
{
	RawReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (RawReader*) photo_file_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_RAW);
	return self;
}

RawReader*
raw_reader_new (const gchar* filepath)
{
	return raw_reader_construct (TYPE_RAW_READER, filepath);
}

static PhotoMetadata*
raw_reader_real_read_metadata (PhotoFileReader* base,
                               GError** error)
{
	RawReader * self;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = (RawReader*) base;
	_tmp0_ = photo_metadata_new ();
	metadata = _tmp0_;
	_tmp1_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	media_metadata_read_from_file ((MediaMetadata*) metadata, _tmp2_, &_inner_error0_);
	_g_object_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = metadata;
	return result;
}

static GdkPixbuf*
raw_reader_real_unscaled_read (PhotoFileReader* base,
                               GError** error)
{
	RawReader * self;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp0_;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	GRawProcessor* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GRawProcessor* _tmp8_;
	GRawProcessor* _tmp9_;
	GRawProcessedImage* _tmp10_ = NULL;
	GRawProcessor* _tmp11_;
	GRawProcessedImage* _tmp12_;
	GdkPixbuf* _tmp13_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (RawReader*) base;
	_tmp0_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp0_;
	_tmp1_ = processor;
	graw_processor_configure_for_rgb_display (_tmp1_, FALSE);
	_tmp2_ = processor;
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
	_tmp4_ = _tmp3_;
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
	_tmp5_ = processor;
	_tmp6_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp7_ = _tmp6_;
	graw_processor_open_file (_tmp5_, _tmp7_, &_inner_error0_);
	_g_free0 (_tmp7_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp8_ = processor;
	graw_processor_unpack (_tmp8_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp9_ = processor;
	graw_processor_process (_tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp11_ = processor;
	_tmp12_ = graw_processor_make_mem_image (_tmp11_, &_inner_error0_);
	_tmp10_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp13_ = graw_processed_image_get_pixbuf_copy (_tmp10_);
	result = _tmp13_;
	_graw_processed_image_unref0 (_tmp10_);
	_graw_processor_unref0 (processor);
	return result;
}

static GdkPixbuf*
raw_reader_real_scaled_read (PhotoFileReader* base,
                             Dimensions* full,
                             Dimensions* scaled,
                             GError** error)
{
	RawReader * self;
	gdouble width_proportion = 0.0;
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	gdouble height_proportion = 0.0;
	Dimensions _tmp2_;
	Dimensions _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean half_size = FALSE;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp5_;
	GRawProcessor* _tmp6_;
	GRawProcessor* _tmp7_;
	libraw_output_params_t* _tmp8_;
	libraw_output_params_t* _tmp9_;
	GRawProcessor* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GRawProcessor* _tmp13_;
	GRawProcessor* _tmp14_;
	GRawProcessedImage* image = NULL;
	GRawProcessor* _tmp15_;
	GRawProcessedImage* _tmp16_;
	GRawProcessedImage* _tmp17_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_;
	Dimensions _tmp20_;
	GdkPixbuf* _tmp21_;
	GdkPixbuf* _tmp22_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (RawReader*) base;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_tmp0_ = *scaled;
	_tmp1_ = *full;
	width_proportion = ((gdouble) _tmp0_.width) / ((gdouble) _tmp1_.width);
	_tmp2_ = *scaled;
	_tmp3_ = *full;
	height_proportion = ((gdouble) _tmp2_.height) / ((gdouble) _tmp3_.height);
	if (width_proportion < 0.5) {
		_tmp4_ = height_proportion < 0.5;
	} else {
		_tmp4_ = FALSE;
	}
	half_size = _tmp4_;
	_tmp5_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
	processor = _tmp5_;
	_tmp6_ = processor;
	graw_processor_configure_for_rgb_display (_tmp6_, half_size);
	_tmp7_ = processor;
	_tmp8_ = graw_processor_get_output_params (_tmp7_);
	_tmp9_ = _tmp8_;
	(*_tmp9_).user_flip = (gint) GRAW_FLIP_NONE;
	_tmp10_ = processor;
	_tmp11_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp12_ = _tmp11_;
	graw_processor_open_file (_tmp10_, _tmp12_, &_inner_error0_);
	_g_free0 (_tmp12_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp13_ = processor;
	graw_processor_unpack (_tmp13_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp14_ = processor;
	graw_processor_process (_tmp14_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp15_ = processor;
	_tmp16_ = graw_processor_make_mem_image (_tmp15_, &_inner_error0_);
	image = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_graw_processor_unref0 (processor);
		return NULL;
	}
	_tmp17_ = image;
	_tmp18_ = graw_processed_image_get_pixbuf_copy (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = *scaled;
	_tmp21_ = resize_pixbuf (_tmp19_, &_tmp20_, GDK_INTERP_BILINEAR);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp19_);
	result = _tmp22_;
	_graw_processed_image_unref0 (image);
	_graw_processor_unref0 (processor);
	return result;
}

static void
raw_reader_class_init (RawReaderClass * klass,
                       gpointer klass_data)
{
	raw_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) raw_reader_real_read_metadata;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) raw_reader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) raw_reader_real_scaled_read;
}

static void
raw_reader_instance_init (RawReader * self,
                          gpointer klass)
{
}

static GType
raw_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RawReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawReader), 0, (GInstanceInitFunc) raw_reader_instance_init, NULL };
	GType raw_reader_type_id;
	raw_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "RawReader", &g_define_type_info, 0);
	return raw_reader_type_id;
}

GType
raw_reader_get_type (void)
{
	static volatile gsize raw_reader_type_id__once = 0;
	if (g_once_init_enter (&raw_reader_type_id__once)) {
		GType raw_reader_type_id;
		raw_reader_type_id = raw_reader_get_type_once ();
		g_once_init_leave (&raw_reader_type_id__once, raw_reader_type_id);
	}
	return raw_reader_type_id__once;
}

RawDeveloper*
raw_developer_as_array (gint* result_length1)
{
	RawDeveloper* _tmp0_;
	RawDeveloper* _tmp1_;
	gint _tmp1__length1;
	RawDeveloper* result;
	_tmp0_ = g_new0 (RawDeveloper, 3);
	_tmp0_[0] = RAW_DEVELOPER_SHOTWELL;
	_tmp0_[1] = RAW_DEVELOPER_CAMERA;
	_tmp0_[2] = RAW_DEVELOPER_EMBEDDED;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
raw_developer_to_string (RawDeveloper self)
{
	gchar* result;
	switch (self) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SHOTWELL");
			result = _tmp0_;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("CAMERA");
			result = _tmp1_;
			return result;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("EMBEDDED");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

RawDeveloper
raw_developer_from_string (const gchar* value)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	RawDeveloper result;
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = value;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("SHOTWELL")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_SHOTWELL;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("CAMERA")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_CAMERA;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("EMBEDDED")))) {
		switch (0) {
			default:
			{
				result = RAW_DEVELOPER_EMBEDDED;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

gchar*
raw_developer_get_label (RawDeveloper self)
{
	gchar* result;
	switch (self) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Photos"));
			result = _tmp0_;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		case RAW_DEVELOPER_EMBEDDED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Camera"));
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gboolean
raw_developer_is_equivalent (RawDeveloper self,
                             RawDeveloper d)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (self == d) {
		result = TRUE;
		return result;
	}
	if (self == RAW_DEVELOPER_CAMERA) {
		_tmp1_ = d == RAW_DEVELOPER_EMBEDDED;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self == RAW_DEVELOPER_EMBEDDED) {
			_tmp2_ = d == RAW_DEVELOPER_CAMERA;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

BackingPhotoRow*
raw_developer_create_backing_row_for_development (RawDeveloper self,
                                                  const gchar* raw_filepath,
                                                  const gchar* camera_development_filename,
                                                  GError** error)
{
	BackingPhotoRow* ns = NULL;
	BackingPhotoRow* _tmp0_;
	GFile* master = NULL;
	GFile* _tmp1_;
	gchar* name = NULL;
	gchar* ext = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* basename = NULL;
	gboolean c = FALSE;
	GFile* new_back = NULL;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	BackingPhotoRow* _tmp32_;
	BackingPhotoRow* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (raw_filepath != NULL, NULL);
	_tmp0_ = backing_photo_row_new ();
	ns = _tmp0_;
	_tmp1_ = g_file_new_for_path (raw_filepath);
	master = _tmp1_;
	_tmp2_ = master;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	disassemble_filename (_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (name);
	name = _tmp5_;
	_g_free0 (ext);
	ext = _tmp6_;
	_g_free0 (_tmp4_);
	if (camera_development_filename == NULL) {
		gchar* _tmp7_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		if (self != RAW_DEVELOPER_CAMERA) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = raw_developer_to_string (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("_", _tmp11_, NULL);
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		} else {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			_g_free0 (_tmp7_);
			_tmp7_ = _tmp13_;
		}
		_tmp14_ = name;
		_tmp15_ = g_strconcat (_tmp14_, "_", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = ext;
		_tmp18_ = g_strconcat (_tmp16_, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, _tmp7_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ".jpg", NULL);
		_g_free0 (basename);
		basename = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp7_);
	} else {
		gchar* _tmp23_;
		_tmp23_ = g_strdup (camera_development_filename);
		_g_free0 (basename);
		basename = _tmp23_;
	}
	_tmp24_ = master;
	_tmp25_ = g_file_get_parent (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = basename;
	_tmp29_ = generate_unique_file (_tmp26_, _tmp27_, &_tmp28_, &_inner_error0_);
	c = _tmp28_;
	_tmp30_ = _tmp29_;
	_g_object_unref0 (_tmp26_);
	new_back = _tmp30_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (master);
		_backing_photo_row_unref0 (ns);
		return NULL;
	}
	_tmp31_ = new_back;
	claim_file (_tmp31_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (new_back);
		_g_free0 (basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (master);
		_backing_photo_row_unref0 (ns);
		return NULL;
	}
	_tmp32_ = ns;
	_tmp32_->file_format = PHOTO_FILE_FORMAT_JFIF;
	_tmp33_ = ns;
	_tmp34_ = new_back;
	_tmp35_ = g_file_get_path (_tmp34_);
	_g_free0 (_tmp33_->filepath);
	_tmp33_->filepath = _tmp35_;
	result = ns;
	_g_object_unref0 (new_back);
	_g_free0 (basename);
	_g_free0 (ext);
	_g_free0 (name);
	_g_object_unref0 (master);
	return result;
}

static GType
raw_developer_get_type_once (void)
{
	static const GEnumValue values[] = {{RAW_DEVELOPER_SHOTWELL, "RAW_DEVELOPER_SHOTWELL", "shotwell"}, {RAW_DEVELOPER_CAMERA, "RAW_DEVELOPER_CAMERA", "camera"}, {RAW_DEVELOPER_EMBEDDED, "RAW_DEVELOPER_EMBEDDED", "embedded"}, {0, NULL, NULL}};
	GType raw_developer_type_id;
	raw_developer_type_id = g_enum_register_static ("RawDeveloper", values);
	return raw_developer_type_id;
}

GType
raw_developer_get_type (void)
{
	static volatile gsize raw_developer_type_id__once = 0;
	if (g_once_init_enter (&raw_developer_type_id__once)) {
		GType raw_developer_type_id;
		raw_developer_type_id = raw_developer_get_type_once ();
		g_once_init_leave (&raw_developer_type_id__once, raw_developer_type_id);
	}
	return raw_developer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

