/* TombstoneTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TombstoneTable.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecTombstoneRow ParamSpecTombstoneRow;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _tombstone_row_unref0(var) ((var == NULL) ? NULL : (var = (tombstone_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecTombstoneRow {
	GParamSpec parent_instance;
};

static gpointer tombstone_row_parent_class = NULL;
static gpointer tombstone_table_parent_class = NULL;
static TombstoneTable* tombstone_table_instance;
static TombstoneTable* tombstone_table_instance = NULL;

static void tombstone_row_finalize (TombstoneRow * obj);
static GType tombstone_row_get_type_once (void);
static TombstoneTable* tombstone_table_new (void);
static TombstoneTable* tombstone_table_construct (GType object_type);
static void tombstone_table_finalize (DatabaseTable * obj);
static GType tombstone_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
tombstone_id_init (TombstoneID *self,
                   gint64 id)
{
	memset (self, 0, sizeof (TombstoneID));
	(*self).id = id;
}

gboolean
tombstone_id_is_invalid (TombstoneID *self)
{
	gboolean result;
	result = (*self).id == TOMBSTONE_ID_INVALID;
	return result;
}

gboolean
tombstone_id_is_valid (TombstoneID *self)
{
	gboolean result;
	result = (*self).id != TOMBSTONE_ID_INVALID;
	return result;
}

TombstoneID*
tombstone_id_dup (const TombstoneID* self)
{
	TombstoneID* dup;
	dup = g_new0 (TombstoneID, 1);
	memcpy (dup, self, sizeof (TombstoneID));
	return dup;
}

void
tombstone_id_free (TombstoneID* self)
{
	g_free (self);
}

static GType
tombstone_id_get_type_once (void)
{
	GType tombstone_id_type_id;
	tombstone_id_type_id = g_boxed_type_register_static ("TombstoneID", (GBoxedCopyFunc) tombstone_id_dup, (GBoxedFreeFunc) tombstone_id_free);
	return tombstone_id_type_id;
}

GType
tombstone_id_get_type (void)
{
	static volatile gsize tombstone_id_type_id__once = 0;
	if (g_once_init_enter (&tombstone_id_type_id__once)) {
		GType tombstone_id_type_id;
		tombstone_id_type_id = tombstone_id_get_type_once ();
		g_once_init_leave (&tombstone_id_type_id__once, tombstone_id_type_id);
	}
	return tombstone_id_type_id__once;
}

TombstoneRow*
tombstone_row_construct (GType object_type)
{
	TombstoneRow* self = NULL;
	self = (TombstoneRow*) g_type_create_instance (object_type);
	return self;
}

TombstoneRow*
tombstone_row_new (void)
{
	return tombstone_row_construct (TYPE_TOMBSTONE_ROW);
}

static void
value_tombstone_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_tombstone_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tombstone_row_unref (value->data[0].v_pointer);
	}
}

static void
value_tombstone_row_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tombstone_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_tombstone_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_tombstone_row_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TombstoneRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tombstone_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_tombstone_row_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	TombstoneRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tombstone_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_tombstone_row (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecTombstoneRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TOMBSTONE_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_tombstone_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_tombstone_row (GValue* value,
                         gpointer v_object)
{
	TombstoneRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tombstone_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tombstone_row_unref (old);
	}
}

void
value_take_tombstone_row (GValue* value,
                          gpointer v_object)
{
	TombstoneRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOMBSTONE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOMBSTONE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tombstone_row_unref (old);
	}
}

static void
tombstone_row_class_init (TombstoneRowClass * klass,
                          gpointer klass_data)
{
	tombstone_row_parent_class = g_type_class_peek_parent (klass);
	((TombstoneRowClass *) klass)->finalize = tombstone_row_finalize;
}

static void
tombstone_row_instance_init (TombstoneRow * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
tombstone_row_finalize (TombstoneRow * obj)
{
	TombstoneRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_ROW, TombstoneRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filepath);
	_g_free0 (self->md5);
}

static GType
tombstone_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_tombstone_row_init, value_tombstone_row_free_value, value_tombstone_row_copy_value, value_tombstone_row_peek_pointer, "p", value_tombstone_row_collect_value, "p", value_tombstone_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TombstoneRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneRow), 0, (GInstanceInitFunc) tombstone_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tombstone_row_type_id;
	tombstone_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TombstoneRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tombstone_row_type_id;
}

GType
tombstone_row_get_type (void)
{
	static volatile gsize tombstone_row_type_id__once = 0;
	if (g_once_init_enter (&tombstone_row_type_id__once)) {
		GType tombstone_row_type_id;
		tombstone_row_type_id = tombstone_row_get_type_once ();
		g_once_init_leave (&tombstone_row_type_id__once, tombstone_row_type_id);
	}
	return tombstone_row_type_id__once;
}

gpointer
tombstone_row_ref (gpointer instance)
{
	TombstoneRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tombstone_row_unref (gpointer instance)
{
	TombstoneRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TOMBSTONE_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static TombstoneTable*
tombstone_table_construct (GType object_type)
{
	TombstoneTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	self = (TombstoneTable*) database_table_construct (object_type);
	database_table_set_table_name ((DatabaseTable*) self, "TombstoneTable");
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "CREATE TABLE IF NOT EXISTS " "TombstoneTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT NOT NULL, " "filesize INTEGER, " "md5 TEXT, " "time_created INTEGER, " "reason INTEGER DEFAULT 0 " ")");
	stmt = _tmp0_;
	_tmp1_ = stmt;
	res = sqlite3_step (_tmp1_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create TombstoneTable", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static TombstoneTable*
tombstone_table_new (void)
{
	return tombstone_table_construct (TYPE_TOMBSTONE_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

TombstoneTable*
tombstone_table_get_instance (void)
{
	TombstoneTable* _tmp0_;
	TombstoneTable* _tmp2_;
	TombstoneTable* _tmp3_;
	TombstoneTable* result;
	_tmp0_ = tombstone_table_instance;
	if (_tmp0_ == NULL) {
		TombstoneTable* _tmp1_;
		_tmp1_ = tombstone_table_new ();
		_database_table_unref0 (tombstone_table_instance);
		tombstone_table_instance = _tmp1_;
	}
	_tmp2_ = tombstone_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

TombstoneRow*
tombstone_table_add (TombstoneTable* self,
                     const gchar* filepath,
                     gint64 filesize,
                     const gchar* md5,
                     TombstoneReason reason,
                     GError** error)
{
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3_stmt* _tmp4_;
	sqlite3_stmt* _tmp5_;
	gint res = 0;
	sqlite3_stmt* _tmp6_;
	TombstoneRow* row = NULL;
	TombstoneRow* _tmp7_;
	TombstoneRow* _tmp8_;
	sqlite3* _tmp9_;
	TombstoneRow* _tmp10_;
	gchar* _tmp11_;
	TombstoneRow* _tmp12_;
	TombstoneRow* _tmp13_;
	gchar* _tmp14_;
	TombstoneRow* _tmp15_;
	TombstoneRow* _tmp16_;
	GError* _inner_error0_ = NULL;
	TombstoneRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = database_table_create_stmt ((DatabaseTable*) self, "INSERT INTO TombstoneTable " "(filepath, filesize, md5, time_created, reason) " "VALUES (?, ?, ?, ?, ?)");
	stmt = _tmp0_;
	time_created = now_sec ();
	_tmp1_ = stmt;
	database_table_bind_text (_tmp1_, 1, filepath);
	_tmp2_ = stmt;
	database_table_bind_int64 (_tmp2_, 2, filesize);
	_tmp3_ = stmt;
	database_table_bind_text (_tmp3_, 3, md5);
	_tmp4_ = stmt;
	database_table_bind_int64 (_tmp4_, 4, time_created);
	_tmp5_ = stmt;
	database_table_bind_int (_tmp5_, 5, tombstone_reason_serialize (reason));
	_tmp6_ = stmt;
	res = sqlite3_step (_tmp6_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("TombstoneTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp7_ = tombstone_row_new ();
	row = _tmp7_;
	_tmp8_ = row;
	_tmp9_ = database_table_db;
	tombstone_id_init (&_tmp8_->id, sqlite3_last_insert_rowid (_tmp9_));
	_tmp10_ = row;
	_tmp11_ = g_strdup (filepath);
	_g_free0 (_tmp10_->filepath);
	_tmp10_->filepath = _tmp11_;
	_tmp12_ = row;
	_tmp12_->filesize = filesize;
	_tmp13_ = row;
	_tmp14_ = g_strdup (md5);
	_g_free0 (_tmp13_->md5);
	_tmp13_->md5 = _tmp14_;
	_tmp15_ = row;
	_tmp15_->time_created = time_created;
	_tmp16_ = row;
	_tmp16_->reason = reason;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gpointer
_tombstone_row_ref0 (gpointer self)
{
	return self ? tombstone_row_ref (self) : NULL;
}

TombstoneRow**
tombstone_table_fetch_all (TombstoneTable* self,
                           gint* result_length1,
                           GError** error)
{
	gint row_count = 0;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp1_;
	TombstoneRow** rows = NULL;
	TombstoneRow** _tmp2_;
	gint rows_length1;
	gint _rows_size_;
	gint index = 0;
	TombstoneRow** _tmp26_;
	gint _tmp26__length1;
	GError* _inner_error0_ = NULL;
	TombstoneRow** result;
	g_return_val_if_fail (self != NULL, NULL);
	row_count = database_table_get_row_count ((DatabaseTable*) self);
	if (row_count == 0) {
		TombstoneRow** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp0__length1;
		}
		result = _tmp0_;
		return result;
	}
	_tmp1_ = database_table_create_stmt ((DatabaseTable*) self, "SELECT id, filepath, filesize, md5, time_created, reason " "FROM TombstoneTable");
	stmt = _tmp1_;
	_tmp2_ = g_new0 (TombstoneRow*, row_count + 1);
	rows = _tmp2_;
	rows_length1 = row_count;
	_rows_size_ = rows_length1;
	index = 0;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gint res = 0;
			sqlite3_stmt* _tmp4_;
			TombstoneRow* row = NULL;
			TombstoneRow* _tmp5_;
			TombstoneRow* _tmp6_;
			sqlite3_stmt* _tmp7_;
			TombstoneRow* _tmp8_;
			sqlite3_stmt* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			TombstoneRow* _tmp12_;
			sqlite3_stmt* _tmp13_;
			TombstoneRow* _tmp14_;
			sqlite3_stmt* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			TombstoneRow* _tmp18_;
			sqlite3_stmt* _tmp19_;
			TombstoneRow* _tmp20_;
			sqlite3_stmt* _tmp21_;
			TombstoneRow** _tmp22_;
			gint _tmp22__length1;
			gint _tmp23_;
			TombstoneRow* _tmp24_;
			TombstoneRow* _tmp25_;
			if (!_tmp3_) {
			}
			_tmp3_ = FALSE;
			_tmp4_ = stmt;
			res = sqlite3_step (_tmp4_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("TombstoneTable.fetch_all", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) tombstone_row_unref), NULL);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp5_ = tombstone_row_new ();
			row = _tmp5_;
			_tmp6_ = row;
			_tmp7_ = stmt;
			tombstone_id_init (&_tmp6_->id, sqlite3_column_int64 (_tmp7_, 0));
			_tmp8_ = row;
			_tmp9_ = stmt;
			_tmp10_ = (const gchar*) sqlite3_column_text (_tmp9_, 1);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_tmp8_->filepath);
			_tmp8_->filepath = _tmp11_;
			_tmp12_ = row;
			_tmp13_ = stmt;
			_tmp12_->filesize = sqlite3_column_int64 (_tmp13_, 2);
			_tmp14_ = row;
			_tmp15_ = stmt;
			_tmp16_ = (const gchar*) sqlite3_column_text (_tmp15_, 3);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (_tmp14_->md5);
			_tmp14_->md5 = _tmp17_;
			_tmp18_ = row;
			_tmp19_ = stmt;
			_tmp18_->time_created = sqlite3_column_int64 (_tmp19_, 4);
			_tmp20_ = row;
			_tmp21_ = stmt;
			_tmp20_->reason = tombstone_reason_unserialize (sqlite3_column_int (_tmp21_, 5));
			_tmp22_ = rows;
			_tmp22__length1 = rows_length1;
			_tmp23_ = index;
			index = _tmp23_ + 1;
			_tmp24_ = row;
			_tmp25_ = _tombstone_row_ref0 (_tmp24_);
			_tombstone_row_unref0 (_tmp22_[_tmp23_]);
			_tmp22_[_tmp23_] = _tmp25_;
			_tombstone_row_unref0 (row);
		}
	}
	_vala_assert (index == row_count, "index == row_count");
	_tmp26_ = rows;
	_tmp26__length1 = rows_length1;
	if (result_length1) {
		*result_length1 = _tmp26__length1;
	}
	result = _tmp26_;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
tombstone_table_update_file (TombstoneTable* self,
                             TombstoneID* tombstone_id,
                             const gchar* filepath,
                             GError** error)
{
	TombstoneID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tombstone_id != NULL);
	g_return_if_fail (filepath != NULL);
	_tmp0_ = *tombstone_id;
	database_table_update_text_by_id_2 ((DatabaseTable*) self, _tmp0_.id, "filepath", filepath, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
tombstone_table_remove (TombstoneTable* self,
                        TombstoneID* tombstone_id,
                        GError** error)
{
	TombstoneID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tombstone_id != NULL);
	_tmp0_ = *tombstone_id;
	database_table_delete_by_id ((DatabaseTable*) self, _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
tombstone_table_class_init (TombstoneTableClass * klass,
                            gpointer klass_data)
{
	tombstone_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = tombstone_table_finalize;
}

static void
tombstone_table_instance_init (TombstoneTable * self,
                               gpointer klass)
{
}

static void
tombstone_table_finalize (DatabaseTable * obj)
{
	TombstoneTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOMBSTONE_TABLE, TombstoneTable);
	DATABASE_TABLE_CLASS (tombstone_table_parent_class)->finalize (obj);
}

static GType
tombstone_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TombstoneTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tombstone_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TombstoneTable), 0, (GInstanceInitFunc) tombstone_table_instance_init, NULL };
	GType tombstone_table_type_id;
	tombstone_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "TombstoneTable", &g_define_type_info, 0);
	return tombstone_table_type_id;
}

GType
tombstone_table_get_type (void)
{
	static volatile gsize tombstone_table_type_id__once = 0;
	if (g_once_init_enter (&tombstone_table_type_id__once)) {
		GType tombstone_table_type_id;
		tombstone_table_type_id = tombstone_table_get_type_once ();
		g_once_init_leave (&tombstone_table_type_id__once, tombstone_table_type_id);
	}
	return tombstone_table_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

