/* SourceInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceInterfaces.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* See the note in MediaInterfaces.vala for some thoughts on the theory of expanding Photos'*/
/* features via interfaces rather than class heirarchies.*/
/* Indexable DataSources provide raw strings that may be searched against (and, in the future,*/
/* indexed) for free-text search queries.  DataSources implementing Indexable must prepare and*/
/* store (i.e. cache) these strings using prepare_indexable_string(s), as preparing the strings*/
/* for each call is expensive.*/
/**/
/* When the indexable string has changed, the object should fire an alteration of*/
/* "indexable:keywords".  The prepare methods will not do this.*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

static GType indexable_get_type_once (void);

const gchar*
indexable_get_indexable_keywords (Indexable* self)
{
	IndexableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = INDEXABLE_GET_INTERFACE (self);
	if (_iface_->get_indexable_keywords) {
		return _iface_->get_indexable_keywords (self);
	}
	return NULL;
}

gchar*
indexable_prepare_indexable_string (const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	if (is_string_empty (str)) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_utf8_strdown (str, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_remove_diacritics (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
indexable_prepare_indexable_strings (gchar** strs,
                                     gint strs_length1)
{
	gboolean _tmp0_ = FALSE;
	GString* builder = NULL;
	GString* _tmp1_;
	gint ctr = 0;
	const gchar* _tmp10_ = NULL;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp15_;
	gchar* result;
	if (strs == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = strs_length1 == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	ctr = 0;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			const gchar* _tmp4_;
			if (!_tmp2_) {
				gint _tmp3_;
				ctr = ctr + 1;
				_tmp3_ = ctr;
				if (!(_tmp3_ < strs_length1)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = strs[ctr];
			if (!is_string_empty (_tmp4_)) {
				GString* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp5_ = builder;
				_tmp6_ = strs[ctr];
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
				_tmp8_ = _tmp7_;
				g_string_append (_tmp5_, _tmp8_);
				_g_free0 (_tmp8_);
				if (ctr < (strs_length1 - 1)) {
					GString* _tmp9_;
					_tmp9_ = builder;
					g_string_append_c (_tmp9_, ' ');
				}
			}
		}
	}
	_tmp11_ = builder;
	_tmp12_ = _tmp11_->str;
	if (!is_string_empty (_tmp12_)) {
		GString* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = builder;
		_tmp14_ = _tmp13_->str;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp15_ = g_strdup (_tmp10_);
	result = _tmp15_;
	_g_string_free0 (builder);
	return result;
}

static void
indexable_default_init (IndexableIface * iface,
                        gpointer iface_data)
{
}

static GType
indexable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IndexableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indexable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType indexable_type_id;
	indexable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Indexable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (indexable_type_id, TYPE_DATA_SOURCE);
	return indexable_type_id;
}

GType
indexable_get_type (void)
{
	static volatile gsize indexable_type_id__once = 0;
	if (g_once_init_enter (&indexable_type_id__once)) {
		GType indexable_type_id;
		indexable_type_id = indexable_get_type_once ();
		g_once_init_leave (&indexable_type_id__once, indexable_type_id);
	}
	return indexable_type_id__once;
}

