/* Style.c generated by valac 0.56.18, the Vala compiler
 * generated from Style.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <libxml/tree.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
typedef struct _StylePrivate StylePrivate;

#define TYPE_LINK_TYPE (link_type_get_type ())
#define LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_TYPE, LinkType))
#define IS_LINK_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_TYPE))
#define LINK_TYPE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LINK_TYPE, LinkTypeIface))

typedef struct _LinkType LinkType;
typedef struct _LinkTypeIface LinkTypeIface;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_LINK_DASH (link_dash_get_type ())
#define LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_DASH, LinkDash))
#define LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_DASH, LinkDashClass))
#define IS_LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_DASH))
#define IS_LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_DASH))
#define LINK_DASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_DASH, LinkDashClass))

typedef struct _LinkDash LinkDash;
typedef struct _LinkDashClass LinkDashClass;

#define TYPE_NODE_BORDER (node_border_get_type ())
#define NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BORDER, NodeBorder))
#define IS_NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BORDER))
#define NODE_BORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NODE_BORDER, NodeBorderIface))

typedef struct _NodeBorder NodeBorder;
typedef struct _NodeBorderIface NodeBorderIface;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _LinkDashPrivate LinkDashPrivate;

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;
typedef struct _ParamSpecStyle ParamSpecStyle;

struct _Style {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StylePrivate * priv;
};

struct _StyleClass {
	GTypeClass parent_class;
	void (*finalize) (Style *self);
};

struct _LinkTypeIface {
	GTypeInterface parent_iface;
	gchar* (*name) (LinkType* self);
	gchar* (*display_name) (LinkType* self);
	gchar* (*icon_name) (LinkType* self);
	void (*draw) (LinkType* self, cairo_t* ctx, Node* from_node, Node* to_node, gdouble from_x, gdouble from_y, gdouble to_x, gdouble to_y, gdouble* fx, gdouble* fy, gdouble* tx, gdouble* ty);
};

struct _NodeBorderIface {
	GTypeInterface parent_iface;
	gchar* (*name) (NodeBorder* self);
	gchar* (*display_name) (NodeBorder* self);
	gchar* (*icon_name) (NodeBorder* self);
	gboolean (*is_fillable) (NodeBorder* self);
	void (*draw_border) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
	void (*draw_fill) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
};

struct _StylePrivate {
	gboolean _template;
	gint* _branch_margin;
	gint* _branch_radius;
	LinkType* _link_type;
	gint* _link_width;
	gboolean* _link_arrow;
	LinkDash* _link_dash;
	NodeBorder* _node_border;
	gint* _node_borderwidth;
	gboolean* _node_fill;
	gint* _node_margin;
	gint* _node_padding;
	PangoFontDescription* _node_font;
	gint* _node_width;
	gboolean* _node_markup;
	LinkDash* _connection_dash;
	gint* _connection_line_width;
	gchar* _connection_arrow;
	gint* _connection_padding;
	PangoFontDescription* _connection_font;
	gint* _connection_title_width;
	PangoFontDescription* _callout_font;
	gint* _callout_padding;
	gint* _callout_ptr_width;
	gint* _callout_ptr_length;
};

struct _LinkDash {
	GObject parent_instance;
	LinkDashPrivate * priv;
	gchar* name;
	gchar* display_name;
	gdouble* pattern;
	gint pattern_length1;
};

struct _LinkDashClass {
	GObjectClass parent_class;
};

struct _ParamSpecStyle {
	GParamSpec parent_instance;
};

static gint Style_private_offset;
static gpointer style_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType link_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkType, g_object_unref)
VALA_EXTERN GType link_dash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkDash, g_object_unref)
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_border_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBorder, g_object_unref)
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN Style* style_new (void);
VALA_EXTERN Style* style_construct (GType object_type);
VALA_EXTERN void style_set_node_font (Style* self,
                          PangoFontDescription* value);
VALA_EXTERN PangoFontDescription* style_get_node_font (Style* self);
VALA_EXTERN void style_set_connection_font (Style* self,
                                PangoFontDescription* value);
VALA_EXTERN PangoFontDescription* style_get_connection_font (Style* self);
VALA_EXTERN void style_set_callout_font (Style* self,
                             PangoFontDescription* value);
VALA_EXTERN PangoFontDescription* style_get_callout_font (Style* self);
VALA_EXTERN Style* style_new_templated (void);
VALA_EXTERN Style* style_construct_templated (GType object_type);
VALA_EXTERN gboolean style_is_fillable (Style* self);
VALA_EXTERN gboolean* style_get_node_fill (Style* self);
VALA_EXTERN NodeBorder* style_get_node_border (Style* self);
VALA_EXTERN gboolean node_border_is_fillable (NodeBorder* self);
VALA_EXTERN void style_clear_template (Style* self);
VALA_EXTERN void style_set_branch_margin (Style* self,
                              gint* value);
VALA_EXTERN void style_set_branch_radius (Style* self,
                              gint* value);
VALA_EXTERN void style_set_link_type (Style* self,
                          LinkType* value);
VALA_EXTERN void style_set_link_width (Style* self,
                           gint* value);
VALA_EXTERN void style_set_link_arrow (Style* self,
                           gboolean* value);
VALA_EXTERN void style_set_link_dash (Style* self,
                          LinkDash* value);
VALA_EXTERN void style_set_node_border (Style* self,
                            NodeBorder* value);
VALA_EXTERN void style_set_node_borderwidth (Style* self,
                                 gint* value);
VALA_EXTERN void style_set_node_fill (Style* self,
                          gboolean* value);
VALA_EXTERN void style_set_node_margin (Style* self,
                            gint* value);
VALA_EXTERN void style_set_node_padding (Style* self,
                             gint* value);
VALA_EXTERN void style_set_node_width (Style* self,
                           gint* value);
VALA_EXTERN void style_set_node_markup (Style* self,
                            gboolean* value);
VALA_EXTERN void style_set_connection_dash (Style* self,
                                LinkDash* value);
VALA_EXTERN void style_set_connection_line_width (Style* self,
                                      gint* value);
VALA_EXTERN void style_set_connection_arrow (Style* self,
                                 const gchar* value);
VALA_EXTERN void style_set_connection_padding (Style* self,
                                   gint* value);
VALA_EXTERN void style_set_connection_title_width (Style* self,
                                       gint* value);
VALA_EXTERN void style_set_callout_padding (Style* self,
                                gint* value);
VALA_EXTERN void style_set_callout_ptr_width (Style* self,
                                  gint* value);
VALA_EXTERN void style_set_callout_ptr_length (Style* self,
                                   gint* value);
VALA_EXTERN gboolean style_copy (Style* self,
                     Style* s);
VALA_EXTERN gint* style_get_branch_margin (Style* self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
VALA_EXTERN gint* style_get_branch_radius (Style* self);
VALA_EXTERN LinkType* style_get_link_type (Style* self);
VALA_EXTERN gint* style_get_link_width (Style* self);
VALA_EXTERN gboolean* style_get_link_arrow (Style* self);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
VALA_EXTERN LinkDash* style_get_link_dash (Style* self);
VALA_EXTERN gint* style_get_node_borderwidth (Style* self);
VALA_EXTERN gint* style_get_node_margin (Style* self);
VALA_EXTERN gint* style_get_node_padding (Style* self);
VALA_EXTERN gint* style_get_node_width (Style* self);
VALA_EXTERN gboolean* style_get_node_markup (Style* self);
VALA_EXTERN LinkDash* style_get_connection_dash (Style* self);
VALA_EXTERN gint* style_get_connection_line_width (Style* self);
VALA_EXTERN const gchar* style_get_connection_arrow (Style* self);
VALA_EXTERN gint* style_get_connection_padding (Style* self);
VALA_EXTERN gint* style_get_connection_title_width (Style* self);
VALA_EXTERN gint* style_get_callout_padding (Style* self);
VALA_EXTERN gint* style_get_callout_ptr_width (Style* self);
VALA_EXTERN gint* style_get_callout_ptr_length (Style* self);
VALA_EXTERN gchar* style_to_string (Style* self);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gchar* link_type_name (LinkType* self);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gchar* node_border_name (NodeBorder* self);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void style_load_node (Style* self,
                      xmlNode* node);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN LinkType* styles_get_link_type (Styles* self,
                                const gchar* name);
VALA_EXTERN LinkDash* styles_get_link_dash (Styles* self,
                                const gchar* name);
VALA_EXTERN NodeBorder* styles_get_node_border (Styles* self,
                                    const gchar* name);
VALA_EXTERN void style_load_connection (Style* self,
                            xmlNode* node);
VALA_EXTERN void style_load_callout (Style* self,
                         xmlNode* node);
VALA_EXTERN void style_save_node_in_node (Style* self,
                              xmlNode* n);
VALA_EXTERN void style_save_node (Style* self,
                      xmlNode* parent);
VALA_EXTERN void style_save_connection_in_node (Style* self,
                                    xmlNode* n);
VALA_EXTERN void style_save_connection (Style* self,
                            xmlNode* parent);
VALA_EXTERN void style_save_callout_in_node (Style* self,
                                 xmlNode* n);
VALA_EXTERN void style_save_callout (Style* self,
                         xmlNode* parent);
VALA_EXTERN void style_draw_link (Style* self,
                      cairo_t* ctx,
                      Node* from_node,
                      Node* to_node,
                      gboolean force_straight_link_type,
                      gdouble from_x,
                      gdouble from_y,
                      gdouble to_x1,
                      gdouble to_y1,
                      gdouble to_x2,
                      gdouble to_y2,
                      gdouble* tailx,
                      gdouble* taily,
                      gdouble* tipx,
                      gdouble* tipy);
VALA_EXTERN void link_dash_set_context (LinkDash* self,
                            cairo_t* ctx,
                            gint line_width);
VALA_EXTERN void link_type_draw (LinkType* self,
                     cairo_t* ctx,
                     Node* from_node,
                     Node* to_node,
                     gdouble from_x,
                     gdouble from_y,
                     gdouble to_x,
                     gdouble to_y,
                     gdouble* fx,
                     gdouble* fy,
                     gdouble* tx,
                     gdouble* ty);
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN void style_draw_node_border (Style* self,
                             cairo_t* ctx,
                             gdouble x,
                             gdouble y,
                             gdouble w,
                             gdouble h,
                             NodeSide s);
VALA_EXTERN void node_border_draw_border (NodeBorder* self,
                              cairo_t* ctx,
                              gdouble x,
                              gdouble y,
                              gdouble w,
                              gdouble h,
                              NodeSide s,
                              gint padding);
VALA_EXTERN void style_draw_node_fill (Style* self,
                           cairo_t* ctx,
                           gdouble x,
                           gdouble y,
                           gdouble w,
                           gdouble h,
                           NodeSide s);
VALA_EXTERN void node_border_draw_fill (NodeBorder* self,
                            cairo_t* ctx,
                            gdouble x,
                            gdouble y,
                            gdouble w,
                            gdouble h,
                            NodeSide s,
                            gint padding);
VALA_EXTERN void style_draw_connection (Style* self,
                            cairo_t* ctx);
static gint* _int_dup (gint* self);
static gboolean* _bool_dup (gboolean* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void style_finalize (Style * obj);
static GType style_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
style_get_instance_private (Style* self)
{
	return G_STRUCT_MEMBER_P (self, Style_private_offset);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

Style*
style_construct (GType object_type)
{
	Style* self = NULL;
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoFontDescription* _tmp11_;
	self = (Style*) g_type_create_instance (object_type);
	self->priv->_template = FALSE;
	_tmp0_ = pango_font_description_new ();
	_tmp1_ = _tmp0_;
	style_set_node_font (self, _tmp1_);
	__vala_PangoFontDescription_free0 (_tmp1_);
	_tmp2_ = self->priv->_node_font;
	pango_font_description_set_family (_tmp2_, "Sans");
	_tmp3_ = self->priv->_node_font;
	pango_font_description_set_size (_tmp3_, 11 * PANGO_SCALE);
	_tmp4_ = pango_font_description_new ();
	_tmp5_ = _tmp4_;
	style_set_connection_font (self, _tmp5_);
	__vala_PangoFontDescription_free0 (_tmp5_);
	_tmp6_ = self->priv->_connection_font;
	pango_font_description_set_family (_tmp6_, "Sans");
	_tmp7_ = self->priv->_connection_font;
	pango_font_description_set_size (_tmp7_, 10 * PANGO_SCALE);
	_tmp8_ = pango_font_description_new ();
	_tmp9_ = _tmp8_;
	style_set_callout_font (self, _tmp9_);
	__vala_PangoFontDescription_free0 (_tmp9_);
	_tmp10_ = self->priv->_callout_font;
	pango_font_description_set_family (_tmp10_, "Sans");
	_tmp11_ = self->priv->_callout_font;
	pango_font_description_set_size (_tmp11_, 12 * PANGO_SCALE);
	return self;
}

Style*
style_new (void)
{
	return style_construct (TYPE_STYLE);
}

Style*
style_construct_templated (GType object_type)
{
	Style* self = NULL;
	self = (Style*) g_type_create_instance (object_type);
	self->priv->_template = TRUE;
	return self;
}

Style*
style_new_templated (void)
{
	return style_construct_templated (TYPE_STYLE);
}

gboolean
style_is_fillable (Style* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_node_fill;
	if (*_tmp1_) {
		NodeBorder* _tmp2_;
		_tmp2_ = self->priv->_node_border;
		_tmp0_ = node_border_is_fillable (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
style_clear_template (Style* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_template) {
		style_set_branch_margin (self, NULL);
		style_set_branch_radius (self, NULL);
		style_set_link_type (self, NULL);
		style_set_link_width (self, NULL);
		style_set_link_arrow (self, NULL);
		style_set_link_dash (self, NULL);
		style_set_node_border (self, NULL);
		style_set_node_borderwidth (self, NULL);
		style_set_node_fill (self, NULL);
		style_set_node_margin (self, NULL);
		style_set_node_padding (self, NULL);
		style_set_node_font (self, NULL);
		style_set_node_width (self, NULL);
		style_set_node_markup (self, NULL);
		style_set_connection_dash (self, NULL);
		style_set_connection_line_width (self, NULL);
		style_set_connection_arrow (self, NULL);
		style_set_connection_padding (self, NULL);
		style_set_connection_font (self, NULL);
		style_set_connection_title_width (self, NULL);
		style_set_callout_font (self, NULL);
		style_set_callout_padding (self, NULL);
		style_set_callout_ptr_width (self, NULL);
		style_set_callout_ptr_length (self, NULL);
	}
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

gboolean
style_copy (Style* self,
            Style* s)
{
	gboolean changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	LinkType* _tmp14_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gint* _tmp20_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean* _tmp26_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	LinkDash* _tmp32_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	NodeBorder* _tmp38_;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gint* _tmp44_;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean* _tmp50_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gint* _tmp56_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gint* _tmp62_;
	gboolean _tmp66_ = FALSE;
	PangoFontDescription* _tmp67_;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gint* _tmp73_;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	gboolean* _tmp79_;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_ = FALSE;
	LinkDash* _tmp85_;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp90_ = FALSE;
	gint* _tmp91_;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	const gchar* _tmp97_;
	gboolean _tmp101_ = FALSE;
	gboolean _tmp102_ = FALSE;
	gint* _tmp103_;
	gboolean _tmp107_ = FALSE;
	PangoFontDescription* _tmp108_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_ = FALSE;
	gint* _tmp114_;
	gboolean _tmp118_ = FALSE;
	PangoFontDescription* _tmp119_;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gint* _tmp125_;
	gboolean _tmp129_ = FALSE;
	gboolean _tmp130_ = FALSE;
	gint* _tmp131_;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_ = FALSE;
	gint* _tmp137_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	changed = FALSE;
	_tmp2_ = s->priv->_branch_margin;
	if (_tmp2_ != NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !s->priv->_template;
	}
	if (_tmp1_) {
		gint* _tmp3_;
		gint* _tmp4_;
		_tmp3_ = self->priv->_branch_margin;
		_tmp4_ = s->priv->_branch_margin;
		_tmp0_ = _int_equal (_tmp3_, _tmp4_) != TRUE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint* _tmp5_;
		changed = TRUE;
		_tmp5_ = s->priv->_branch_margin;
		style_set_branch_margin (self, _tmp5_);
	}
	_tmp8_ = s->priv->_branch_radius;
	if (_tmp8_ != NULL) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = !s->priv->_template;
	}
	if (_tmp7_) {
		gint* _tmp9_;
		gint* _tmp10_;
		_tmp9_ = self->priv->_branch_radius;
		_tmp10_ = s->priv->_branch_radius;
		_tmp6_ = _int_equal (_tmp9_, _tmp10_) != TRUE;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint* _tmp11_;
		changed = TRUE;
		_tmp11_ = s->priv->_branch_radius;
		style_set_branch_radius (self, _tmp11_);
	}
	_tmp14_ = s->priv->_link_type;
	if (_tmp14_ != NULL) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = !s->priv->_template;
	}
	if (_tmp13_) {
		LinkType* _tmp15_;
		LinkType* _tmp16_;
		_tmp15_ = self->priv->_link_type;
		_tmp16_ = s->priv->_link_type;
		_tmp12_ = _tmp15_ != _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		LinkType* _tmp17_;
		changed = TRUE;
		_tmp17_ = s->priv->_link_type;
		style_set_link_type (self, _tmp17_);
	}
	_tmp20_ = s->priv->_link_width;
	if (_tmp20_ != NULL) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = !s->priv->_template;
	}
	if (_tmp19_) {
		gint* _tmp21_;
		gint* _tmp22_;
		_tmp21_ = self->priv->_link_width;
		_tmp22_ = s->priv->_link_width;
		_tmp18_ = _int_equal (_tmp21_, _tmp22_) != TRUE;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gint* _tmp23_;
		changed = TRUE;
		_tmp23_ = s->priv->_link_width;
		style_set_link_width (self, _tmp23_);
	}
	_tmp26_ = s->priv->_link_arrow;
	if (_tmp26_ != NULL) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = !s->priv->_template;
	}
	if (_tmp25_) {
		gboolean* _tmp27_;
		gboolean* _tmp28_;
		_tmp27_ = self->priv->_link_arrow;
		_tmp28_ = s->priv->_link_arrow;
		_tmp24_ = _bool_equal (_tmp27_, _tmp28_) != TRUE;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gboolean* _tmp29_;
		changed = TRUE;
		_tmp29_ = s->priv->_link_arrow;
		style_set_link_arrow (self, _tmp29_);
	}
	_tmp32_ = s->priv->_link_dash;
	if (_tmp32_ != NULL) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = !s->priv->_template;
	}
	if (_tmp31_) {
		LinkDash* _tmp33_;
		LinkDash* _tmp34_;
		_tmp33_ = self->priv->_link_dash;
		_tmp34_ = s->priv->_link_dash;
		_tmp30_ = _tmp33_ != _tmp34_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		LinkDash* _tmp35_;
		changed = TRUE;
		_tmp35_ = s->priv->_link_dash;
		style_set_link_dash (self, _tmp35_);
	}
	_tmp38_ = s->priv->_node_border;
	if (_tmp38_ != NULL) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = !s->priv->_template;
	}
	if (_tmp37_) {
		NodeBorder* _tmp39_;
		NodeBorder* _tmp40_;
		_tmp39_ = self->priv->_node_border;
		_tmp40_ = s->priv->_node_border;
		_tmp36_ = _tmp39_ != _tmp40_;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		NodeBorder* _tmp41_;
		changed = TRUE;
		_tmp41_ = s->priv->_node_border;
		style_set_node_border (self, _tmp41_);
	}
	_tmp44_ = s->priv->_node_borderwidth;
	if (_tmp44_ != NULL) {
		_tmp43_ = TRUE;
	} else {
		_tmp43_ = !s->priv->_template;
	}
	if (_tmp43_) {
		gint* _tmp45_;
		gint* _tmp46_;
		_tmp45_ = self->priv->_node_borderwidth;
		_tmp46_ = s->priv->_node_borderwidth;
		_tmp42_ = _int_equal (_tmp45_, _tmp46_) != TRUE;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		gint* _tmp47_;
		changed = TRUE;
		_tmp47_ = s->priv->_node_borderwidth;
		style_set_node_borderwidth (self, _tmp47_);
	}
	_tmp50_ = s->priv->_node_fill;
	if (_tmp50_ != NULL) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = !s->priv->_template;
	}
	if (_tmp49_) {
		gboolean* _tmp51_;
		gboolean* _tmp52_;
		_tmp51_ = self->priv->_node_fill;
		_tmp52_ = s->priv->_node_fill;
		_tmp48_ = _bool_equal (_tmp51_, _tmp52_) != TRUE;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gboolean* _tmp53_;
		changed = TRUE;
		_tmp53_ = s->priv->_node_fill;
		style_set_node_fill (self, _tmp53_);
	}
	_tmp56_ = s->priv->_node_margin;
	if (_tmp56_ != NULL) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = !s->priv->_template;
	}
	if (_tmp55_) {
		gint* _tmp57_;
		gint* _tmp58_;
		_tmp57_ = self->priv->_node_margin;
		_tmp58_ = s->priv->_node_margin;
		_tmp54_ = _int_equal (_tmp57_, _tmp58_) != TRUE;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		gint* _tmp59_;
		changed = TRUE;
		_tmp59_ = s->priv->_node_margin;
		style_set_node_margin (self, _tmp59_);
	}
	_tmp62_ = s->priv->_node_padding;
	if (_tmp62_ != NULL) {
		_tmp61_ = TRUE;
	} else {
		_tmp61_ = !s->priv->_template;
	}
	if (_tmp61_) {
		gint* _tmp63_;
		gint* _tmp64_;
		_tmp63_ = self->priv->_node_padding;
		_tmp64_ = s->priv->_node_padding;
		_tmp60_ = _int_equal (_tmp63_, _tmp64_) != TRUE;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		gint* _tmp65_;
		changed = TRUE;
		_tmp65_ = s->priv->_node_padding;
		style_set_node_padding (self, _tmp65_);
	}
	_tmp67_ = s->priv->_node_font;
	if (_tmp67_ != NULL) {
		_tmp66_ = TRUE;
	} else {
		_tmp66_ = !s->priv->_template;
	}
	if (_tmp66_) {
		PangoFontDescription* _tmp68_;
		PangoFontDescription* _tmp69_;
		PangoFontDescription* _tmp70_;
		changed = TRUE;
		_tmp68_ = s->priv->_node_font;
		_tmp69_ = pango_font_description_copy (_tmp68_);
		_tmp70_ = _tmp69_;
		style_set_node_font (self, _tmp70_);
		__vala_PangoFontDescription_free0 (_tmp70_);
	}
	_tmp73_ = s->priv->_node_width;
	if (_tmp73_ != NULL) {
		_tmp72_ = TRUE;
	} else {
		_tmp72_ = !s->priv->_template;
	}
	if (_tmp72_) {
		gint* _tmp74_;
		gint* _tmp75_;
		_tmp74_ = self->priv->_node_width;
		_tmp75_ = s->priv->_node_width;
		_tmp71_ = _int_equal (_tmp74_, _tmp75_) != TRUE;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gint* _tmp76_;
		changed = TRUE;
		_tmp76_ = s->priv->_node_width;
		style_set_node_width (self, _tmp76_);
	}
	_tmp79_ = s->priv->_node_markup;
	if (_tmp79_ != NULL) {
		_tmp78_ = TRUE;
	} else {
		_tmp78_ = !s->priv->_template;
	}
	if (_tmp78_) {
		gboolean* _tmp80_;
		gboolean* _tmp81_;
		_tmp80_ = self->priv->_node_markup;
		_tmp81_ = s->priv->_node_markup;
		_tmp77_ = _bool_equal (_tmp80_, _tmp81_) != TRUE;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		gboolean* _tmp82_;
		changed = TRUE;
		_tmp82_ = s->priv->_node_markup;
		style_set_node_markup (self, _tmp82_);
	}
	_tmp85_ = s->priv->_connection_dash;
	if (_tmp85_ != NULL) {
		_tmp84_ = TRUE;
	} else {
		_tmp84_ = !s->priv->_template;
	}
	if (_tmp84_) {
		LinkDash* _tmp86_;
		LinkDash* _tmp87_;
		_tmp86_ = self->priv->_connection_dash;
		_tmp87_ = s->priv->_connection_dash;
		_tmp83_ = _tmp86_ != _tmp87_;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		LinkDash* _tmp88_;
		changed = TRUE;
		_tmp88_ = s->priv->_connection_dash;
		style_set_connection_dash (self, _tmp88_);
	}
	_tmp91_ = s->priv->_connection_line_width;
	if (_tmp91_ != NULL) {
		_tmp90_ = TRUE;
	} else {
		_tmp90_ = !s->priv->_template;
	}
	if (_tmp90_) {
		gint* _tmp92_;
		gint* _tmp93_;
		_tmp92_ = self->priv->_connection_line_width;
		_tmp93_ = s->priv->_connection_line_width;
		_tmp89_ = _int_equal (_tmp92_, _tmp93_) != TRUE;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		gint* _tmp94_;
		changed = TRUE;
		_tmp94_ = s->priv->_connection_line_width;
		style_set_connection_line_width (self, _tmp94_);
	}
	_tmp97_ = s->priv->_connection_arrow;
	if (_tmp97_ != NULL) {
		_tmp96_ = TRUE;
	} else {
		_tmp96_ = !s->priv->_template;
	}
	if (_tmp96_) {
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		_tmp98_ = self->priv->_connection_arrow;
		_tmp99_ = s->priv->_connection_arrow;
		_tmp95_ = g_strcmp0 (_tmp98_, _tmp99_) != 0;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		const gchar* _tmp100_;
		changed = TRUE;
		_tmp100_ = s->priv->_connection_arrow;
		style_set_connection_arrow (self, _tmp100_);
	}
	_tmp103_ = s->priv->_connection_padding;
	if (_tmp103_ != NULL) {
		_tmp102_ = TRUE;
	} else {
		_tmp102_ = !s->priv->_template;
	}
	if (_tmp102_) {
		gint* _tmp104_;
		gint* _tmp105_;
		_tmp104_ = self->priv->_connection_padding;
		_tmp105_ = s->priv->_connection_padding;
		_tmp101_ = _int_equal (_tmp104_, _tmp105_) != TRUE;
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		gint* _tmp106_;
		changed = TRUE;
		_tmp106_ = s->priv->_connection_padding;
		style_set_connection_padding (self, _tmp106_);
	}
	_tmp108_ = s->priv->_connection_font;
	if (_tmp108_ != NULL) {
		_tmp107_ = TRUE;
	} else {
		_tmp107_ = !s->priv->_template;
	}
	if (_tmp107_) {
		PangoFontDescription* _tmp109_;
		PangoFontDescription* _tmp110_;
		PangoFontDescription* _tmp111_;
		changed = TRUE;
		_tmp109_ = s->priv->_connection_font;
		_tmp110_ = pango_font_description_copy (_tmp109_);
		_tmp111_ = _tmp110_;
		style_set_connection_font (self, _tmp111_);
		__vala_PangoFontDescription_free0 (_tmp111_);
	}
	_tmp114_ = s->priv->_connection_title_width;
	if (_tmp114_ != NULL) {
		_tmp113_ = TRUE;
	} else {
		_tmp113_ = !s->priv->_template;
	}
	if (_tmp113_) {
		gint* _tmp115_;
		gint* _tmp116_;
		_tmp115_ = self->priv->_connection_title_width;
		_tmp116_ = s->priv->_connection_title_width;
		_tmp112_ = _int_equal (_tmp115_, _tmp116_) != TRUE;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		gint* _tmp117_;
		changed = TRUE;
		_tmp117_ = s->priv->_connection_title_width;
		style_set_connection_title_width (self, _tmp117_);
	}
	_tmp119_ = s->priv->_callout_font;
	if (_tmp119_ != NULL) {
		_tmp118_ = TRUE;
	} else {
		_tmp118_ = !s->priv->_template;
	}
	if (_tmp118_) {
		PangoFontDescription* _tmp120_;
		PangoFontDescription* _tmp121_;
		PangoFontDescription* _tmp122_;
		changed = TRUE;
		_tmp120_ = s->priv->_callout_font;
		_tmp121_ = pango_font_description_copy (_tmp120_);
		_tmp122_ = _tmp121_;
		style_set_callout_font (self, _tmp122_);
		__vala_PangoFontDescription_free0 (_tmp122_);
	}
	_tmp125_ = s->priv->_callout_padding;
	if (_tmp125_ != NULL) {
		_tmp124_ = TRUE;
	} else {
		_tmp124_ = !s->priv->_template;
	}
	if (_tmp124_) {
		gint* _tmp126_;
		gint* _tmp127_;
		_tmp126_ = self->priv->_callout_padding;
		_tmp127_ = s->priv->_callout_padding;
		_tmp123_ = _int_equal (_tmp126_, _tmp127_) != TRUE;
	} else {
		_tmp123_ = FALSE;
	}
	if (_tmp123_) {
		gint* _tmp128_;
		changed = TRUE;
		_tmp128_ = s->priv->_callout_padding;
		style_set_callout_padding (self, _tmp128_);
	}
	_tmp131_ = s->priv->_callout_ptr_width;
	if (_tmp131_ != NULL) {
		_tmp130_ = TRUE;
	} else {
		_tmp130_ = !s->priv->_template;
	}
	if (_tmp130_) {
		gint* _tmp132_;
		gint* _tmp133_;
		_tmp132_ = self->priv->_callout_ptr_width;
		_tmp133_ = s->priv->_callout_ptr_width;
		_tmp129_ = _int_equal (_tmp132_, _tmp133_) != TRUE;
	} else {
		_tmp129_ = FALSE;
	}
	if (_tmp129_) {
		gint* _tmp134_;
		changed = TRUE;
		_tmp134_ = s->priv->_callout_ptr_width;
		style_set_callout_ptr_width (self, _tmp134_);
	}
	_tmp137_ = s->priv->_callout_ptr_length;
	if (_tmp137_ != NULL) {
		_tmp136_ = TRUE;
	} else {
		_tmp136_ = !s->priv->_template;
	}
	if (_tmp136_) {
		gint* _tmp138_;
		gint* _tmp139_;
		_tmp138_ = self->priv->_callout_ptr_length;
		_tmp139_ = s->priv->_callout_ptr_length;
		_tmp135_ = _int_equal (_tmp138_, _tmp139_) != TRUE;
	} else {
		_tmp135_ = FALSE;
	}
	if (_tmp135_) {
		gint* _tmp140_;
		changed = TRUE;
		_tmp140_ = s->priv->_callout_ptr_length;
		style_set_callout_ptr_length (self, _tmp140_);
	}
	result = changed;
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add27 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
style_to_string (Style* self)
{
	gchar** arr = NULL;
	gchar** _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gint* _tmp1_;
	gint* _tmp4_;
	LinkType* _tmp7_;
	gint* _tmp12_;
	gboolean* _tmp15_;
	LinkDash* _tmp20_;
	NodeBorder* _tmp24_;
	gint* _tmp29_;
	gboolean* _tmp32_;
	gint* _tmp37_;
	gint* _tmp40_;
	PangoFontDescription* _tmp43_;
	gint* _tmp45_;
	gboolean* _tmp48_;
	LinkDash* _tmp53_;
	gint* _tmp57_;
	const gchar* _tmp60_;
	gint* _tmp63_;
	PangoFontDescription* _tmp66_;
	gint* _tmp68_;
	PangoFontDescription* _tmp71_;
	gint* _tmp73_;
	gint* _tmp76_;
	gint* _tmp79_;
	gchar** _tmp82_;
	gint _tmp82__length1;
	gchar* _tmp83_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp0_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	_tmp1_ = self->priv->_branch_margin;
	if (_tmp1_ != NULL) {
		gint* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_branch_margin;
		_tmp3_ = g_strdup_printf ("bmargin[%d]", *_tmp2_);
		_vala_array_add4 (&arr, &arr_length1, &_arr_size_, _tmp3_);
	}
	_tmp4_ = self->priv->_branch_radius;
	if (_tmp4_ != NULL) {
		gint* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->_branch_radius;
		_tmp6_ = g_strdup_printf ("bradius[%d]", *_tmp5_);
		_vala_array_add5 (&arr, &arr_length1, &_arr_size_, _tmp6_);
	}
	_tmp7_ = self->priv->_link_type;
	if (_tmp7_ != NULL) {
		LinkType* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = self->priv->_link_type;
		_tmp9_ = link_type_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("ltype[%s]", _tmp10_);
		_vala_array_add6 (&arr, &arr_length1, &_arr_size_, _tmp11_);
		_g_free0 (_tmp10_);
	}
	_tmp12_ = self->priv->_link_width;
	if (_tmp12_ != NULL) {
		gint* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = self->priv->_link_width;
		_tmp14_ = g_strdup_printf ("lwidth[%d]", *_tmp13_);
		_vala_array_add7 (&arr, &arr_length1, &_arr_size_, _tmp14_);
	}
	_tmp15_ = self->priv->_link_arrow;
	if (_tmp15_ != NULL) {
		gboolean* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = self->priv->_link_arrow;
		_tmp17_ = bool_to_string (*_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("larrow[%s]", _tmp18_);
		_vala_array_add8 (&arr, &arr_length1, &_arr_size_, _tmp19_);
		_g_free0 (_tmp18_);
	}
	_tmp20_ = self->priv->_link_dash;
	if (_tmp20_ != NULL) {
		LinkDash* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = self->priv->_link_dash;
		_tmp22_ = _tmp21_->name;
		_tmp23_ = g_strdup_printf ("ldash[%s]", _tmp22_);
		_vala_array_add9 (&arr, &arr_length1, &_arr_size_, _tmp23_);
	}
	_tmp24_ = self->priv->_node_border;
	if (_tmp24_ != NULL) {
		NodeBorder* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp25_ = self->priv->_node_border;
		_tmp26_ = node_border_name (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("nborder[%s]", _tmp27_);
		_vala_array_add10 (&arr, &arr_length1, &_arr_size_, _tmp28_);
		_g_free0 (_tmp27_);
	}
	_tmp29_ = self->priv->_node_borderwidth;
	if (_tmp29_ != NULL) {
		gint* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = self->priv->_node_borderwidth;
		_tmp31_ = g_strdup_printf ("nbwidth[%d]", *_tmp30_);
		_vala_array_add11 (&arr, &arr_length1, &_arr_size_, _tmp31_);
	}
	_tmp32_ = self->priv->_node_fill;
	if (_tmp32_ != NULL) {
		gboolean* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp33_ = self->priv->_node_fill;
		_tmp34_ = bool_to_string (*_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("nfill[%s]", _tmp35_);
		_vala_array_add12 (&arr, &arr_length1, &_arr_size_, _tmp36_);
		_g_free0 (_tmp35_);
	}
	_tmp37_ = self->priv->_node_margin;
	if (_tmp37_ != NULL) {
		gint* _tmp38_;
		gchar* _tmp39_;
		_tmp38_ = self->priv->_node_margin;
		_tmp39_ = g_strdup_printf ("nmargin[%d]", *_tmp38_);
		_vala_array_add13 (&arr, &arr_length1, &_arr_size_, _tmp39_);
	}
	_tmp40_ = self->priv->_node_padding;
	if (_tmp40_ != NULL) {
		gint* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = self->priv->_node_padding;
		_tmp42_ = g_strdup_printf ("npad[%d]", *_tmp41_);
		_vala_array_add14 (&arr, &arr_length1, &_arr_size_, _tmp42_);
	}
	_tmp43_ = self->priv->_node_font;
	if (_tmp43_ != NULL) {
		gchar* _tmp44_;
		_tmp44_ = g_strdup ("nfont");
		_vala_array_add15 (&arr, &arr_length1, &_arr_size_, _tmp44_);
	}
	_tmp45_ = self->priv->_node_width;
	if (_tmp45_ != NULL) {
		gint* _tmp46_;
		gchar* _tmp47_;
		_tmp46_ = self->priv->_node_width;
		_tmp47_ = g_strdup_printf ("nwidth[%d]", *_tmp46_);
		_vala_array_add16 (&arr, &arr_length1, &_arr_size_, _tmp47_);
	}
	_tmp48_ = self->priv->_node_markup;
	if (_tmp48_ != NULL) {
		gboolean* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp49_ = self->priv->_node_markup;
		_tmp50_ = bool_to_string (*_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strdup_printf ("nmarkup[%s]", _tmp51_);
		_vala_array_add17 (&arr, &arr_length1, &_arr_size_, _tmp52_);
		_g_free0 (_tmp51_);
	}
	_tmp53_ = self->priv->_connection_dash;
	if (_tmp53_ != NULL) {
		LinkDash* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		_tmp54_ = self->priv->_connection_dash;
		_tmp55_ = _tmp54_->name;
		_tmp56_ = g_strdup_printf ("cdash[%s]", _tmp55_);
		_vala_array_add18 (&arr, &arr_length1, &_arr_size_, _tmp56_);
	}
	_tmp57_ = self->priv->_connection_line_width;
	if (_tmp57_ != NULL) {
		gint* _tmp58_;
		gchar* _tmp59_;
		_tmp58_ = self->priv->_connection_line_width;
		_tmp59_ = g_strdup_printf ("clwidth[%d]", *_tmp58_);
		_vala_array_add19 (&arr, &arr_length1, &_arr_size_, _tmp59_);
	}
	_tmp60_ = self->priv->_connection_arrow;
	if (_tmp60_ != NULL) {
		const gchar* _tmp61_;
		gchar* _tmp62_;
		_tmp61_ = self->priv->_connection_arrow;
		_tmp62_ = g_strdup_printf ("carrow[%s]", _tmp61_);
		_vala_array_add20 (&arr, &arr_length1, &_arr_size_, _tmp62_);
	}
	_tmp63_ = self->priv->_connection_padding;
	if (_tmp63_ != NULL) {
		gint* _tmp64_;
		gchar* _tmp65_;
		_tmp64_ = self->priv->_connection_padding;
		_tmp65_ = g_strdup_printf ("cpad[%d]", *_tmp64_);
		_vala_array_add21 (&arr, &arr_length1, &_arr_size_, _tmp65_);
	}
	_tmp66_ = self->priv->_connection_font;
	if (_tmp66_ != NULL) {
		gchar* _tmp67_;
		_tmp67_ = g_strdup ("cfont");
		_vala_array_add22 (&arr, &arr_length1, &_arr_size_, _tmp67_);
	}
	_tmp68_ = self->priv->_connection_title_width;
	if (_tmp68_ != NULL) {
		gint* _tmp69_;
		gchar* _tmp70_;
		_tmp69_ = self->priv->_connection_title_width;
		_tmp70_ = g_strdup_printf ("ctwidth[%d]", *_tmp69_);
		_vala_array_add23 (&arr, &arr_length1, &_arr_size_, _tmp70_);
	}
	_tmp71_ = self->priv->_callout_font;
	if (_tmp71_ != NULL) {
		gchar* _tmp72_;
		_tmp72_ = g_strdup ("ofont");
		_vala_array_add24 (&arr, &arr_length1, &_arr_size_, _tmp72_);
	}
	_tmp73_ = self->priv->_callout_padding;
	if (_tmp73_ != NULL) {
		gint* _tmp74_;
		gchar* _tmp75_;
		_tmp74_ = self->priv->_callout_padding;
		_tmp75_ = g_strdup_printf ("opad[%d]", *_tmp74_);
		_vala_array_add25 (&arr, &arr_length1, &_arr_size_, _tmp75_);
	}
	_tmp76_ = self->priv->_callout_ptr_width;
	if (_tmp76_ != NULL) {
		gint* _tmp77_;
		gchar* _tmp78_;
		_tmp77_ = self->priv->_callout_ptr_width;
		_tmp78_ = g_strdup_printf ("opw[%d]", *_tmp77_);
		_vala_array_add26 (&arr, &arr_length1, &_arr_size_, _tmp78_);
	}
	_tmp79_ = self->priv->_callout_ptr_length;
	if (_tmp79_ != NULL) {
		gint* _tmp80_;
		gchar* _tmp81_;
		_tmp80_ = self->priv->_callout_ptr_length;
		_tmp81_ = g_strdup_printf ("opl[%d]", *_tmp80_);
		_vala_array_add27 (&arr, &arr_length1, &_arr_size_, _tmp81_);
	}
	_tmp82_ = arr;
	_tmp82__length1 = arr_length1;
	_tmp83_ = _vala_g_strjoinv ("+", _tmp82_, (gint) _tmp82__length1);
	result = _tmp83_;
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

void
style_load_node (Style* self,
                 xmlNode* node)
{
	gchar* bm = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* br = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* lt = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* lw = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* la = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* ld = NULL;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* nb = NULL;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* nw = NULL;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* nbw = NULL;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* nlf = NULL;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* nm = NULL;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* np = NULL;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* nf = NULL;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* nmu = NULL;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "branchmargin");
	bm = _tmp0_;
	_tmp1_ = bm;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_;
		_tmp2_ = bm;
		_tmp3_ = atoi (_tmp2_);
		style_set_branch_margin (self, &_tmp3_);
	}
	_tmp4_ = (gchar*) xmlGetProp (node, (xmlChar*) "branchradius");
	br = _tmp4_;
	_tmp5_ = br;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gint _tmp7_;
		_tmp6_ = br;
		_tmp7_ = atoi (_tmp6_);
		style_set_branch_radius (self, &_tmp7_);
	}
	_tmp8_ = (gchar*) xmlGetProp (node, (xmlChar*) "linktype");
	lt = _tmp8_;
	_tmp9_ = lt;
	if (_tmp9_ != NULL) {
		Styles* _tmp10_;
		const gchar* _tmp11_;
		LinkType* _tmp12_;
		LinkType* _tmp13_;
		_tmp10_ = style_inspector_styles;
		_tmp11_ = lt;
		_tmp12_ = styles_get_link_type (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		style_set_link_type (self, _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	_tmp14_ = (gchar*) xmlGetProp (node, (xmlChar*) "linkwidth");
	lw = _tmp14_;
	_tmp15_ = lw;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gint _tmp17_;
		_tmp16_ = lw;
		_tmp17_ = atoi (_tmp16_);
		style_set_link_width (self, &_tmp17_);
	}
	_tmp18_ = (gchar*) xmlGetProp (node, (xmlChar*) "linkarrow");
	la = _tmp18_;
	_tmp19_ = la;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = la;
		_tmp21_ = bool_parse (_tmp20_);
		style_set_link_arrow (self, &_tmp21_);
	}
	_tmp22_ = (gchar*) xmlGetProp (node, (xmlChar*) "linkdash");
	ld = _tmp22_;
	_tmp23_ = ld;
	if (_tmp23_ != NULL) {
		Styles* _tmp24_;
		const gchar* _tmp25_;
		LinkDash* _tmp26_;
		LinkDash* _tmp27_;
		_tmp24_ = style_inspector_styles;
		_tmp25_ = ld;
		_tmp26_ = styles_get_link_dash (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		style_set_link_dash (self, _tmp27_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp28_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodeborder");
	nb = _tmp28_;
	_tmp29_ = nb;
	if (_tmp29_ != NULL) {
		Styles* _tmp30_;
		const gchar* _tmp31_;
		NodeBorder* _tmp32_;
		NodeBorder* _tmp33_;
		_tmp30_ = style_inspector_styles;
		_tmp31_ = nb;
		_tmp32_ = styles_get_node_border (_tmp30_, _tmp31_);
		_tmp33_ = _tmp32_;
		style_set_node_border (self, _tmp33_);
		_g_object_unref0 (_tmp33_);
	}
	_tmp34_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodewidth");
	nw = _tmp34_;
	_tmp35_ = nw;
	if (_tmp35_ != NULL) {
		const gchar* _tmp36_;
		gint _tmp37_;
		_tmp36_ = nw;
		_tmp37_ = atoi (_tmp36_);
		style_set_node_width (self, &_tmp37_);
	}
	_tmp38_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodeborderwidth");
	nbw = _tmp38_;
	_tmp39_ = nbw;
	if (_tmp39_ != NULL) {
		const gchar* _tmp40_;
		gint _tmp41_;
		_tmp40_ = nbw;
		_tmp41_ = atoi (_tmp40_);
		style_set_node_borderwidth (self, &_tmp41_);
	}
	_tmp42_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodefill");
	nlf = _tmp42_;
	_tmp43_ = nlf;
	if (_tmp43_ != NULL) {
		const gchar* _tmp44_;
		gboolean _tmp45_;
		_tmp44_ = nlf;
		_tmp45_ = bool_parse (_tmp44_);
		style_set_node_fill (self, &_tmp45_);
	}
	_tmp46_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodemargin");
	nm = _tmp46_;
	_tmp47_ = nm;
	if (_tmp47_ != NULL) {
		const gchar* _tmp48_;
		gint _tmp49_;
		_tmp48_ = nm;
		_tmp49_ = atoi (_tmp48_);
		style_set_node_margin (self, &_tmp49_);
	}
	_tmp50_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodepadding");
	np = _tmp50_;
	_tmp51_ = np;
	if (_tmp51_ != NULL) {
		const gchar* _tmp52_;
		gint _tmp53_;
		_tmp52_ = np;
		_tmp53_ = atoi (_tmp52_);
		style_set_node_padding (self, &_tmp53_);
	}
	_tmp54_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodefont");
	nf = _tmp54_;
	_tmp55_ = nf;
	if (_tmp55_ != NULL) {
		const gchar* _tmp56_;
		PangoFontDescription* _tmp57_;
		PangoFontDescription* _tmp58_;
		_tmp56_ = nf;
		_tmp57_ = pango_font_description_from_string (_tmp56_);
		_tmp58_ = _tmp57_;
		style_set_node_font (self, _tmp58_);
		__vala_PangoFontDescription_free0 (_tmp58_);
	}
	_tmp59_ = (gchar*) xmlGetProp (node, (xmlChar*) "nodemarkup");
	nmu = _tmp59_;
	_tmp60_ = nmu;
	if (_tmp60_ != NULL) {
		const gchar* _tmp61_;
		gboolean _tmp62_;
		_tmp61_ = nmu;
		_tmp62_ = bool_parse (_tmp61_);
		style_set_node_markup (self, &_tmp62_);
	}
	_g_free0 (nmu);
	_g_free0 (nf);
	_g_free0 (np);
	_g_free0 (nm);
	_g_free0 (nlf);
	_g_free0 (nbw);
	_g_free0 (nw);
	_g_free0 (nb);
	_g_free0 (ld);
	_g_free0 (la);
	_g_free0 (lw);
	_g_free0 (lt);
	_g_free0 (br);
	_g_free0 (bm);
}

void
style_load_connection (Style* self,
                       xmlNode* node)
{
	gchar* d = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* lw = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp9_;
	gchar* a = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* p = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* f = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* tw = NULL;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectiondash");
	d = _tmp0_;
	_tmp1_ = d;
	if (_tmp1_ != NULL) {
		Styles* _tmp2_;
		const gchar* _tmp3_;
		LinkDash* _tmp4_;
		LinkDash* _tmp5_;
		_tmp2_ = style_inspector_styles;
		_tmp3_ = d;
		_tmp4_ = styles_get_link_dash (_tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		style_set_connection_dash (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectionlwidth");
	lw = _tmp6_;
	_tmp7_ = lw;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		_tmp8_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectionwidth");
		_g_free0 (lw);
		lw = _tmp8_;
	}
	_tmp9_ = lw;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		gint _tmp11_;
		_tmp10_ = lw;
		_tmp11_ = atoi (_tmp10_);
		style_set_connection_line_width (self, &_tmp11_);
	}
	_tmp12_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectionarrow");
	a = _tmp12_;
	_tmp13_ = a;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = a;
		style_set_connection_arrow (self, _tmp14_);
	}
	_tmp15_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectionpadding");
	p = _tmp15_;
	_tmp16_ = p;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		gint _tmp18_;
		_tmp17_ = p;
		_tmp18_ = atoi (_tmp17_);
		style_set_connection_padding (self, &_tmp18_);
	}
	_tmp19_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectionfont");
	f = _tmp19_;
	_tmp20_ = f;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		PangoFontDescription* _tmp22_;
		PangoFontDescription* _tmp23_;
		_tmp21_ = f;
		_tmp22_ = pango_font_description_from_string (_tmp21_);
		_tmp23_ = _tmp22_;
		style_set_connection_font (self, _tmp23_);
		__vala_PangoFontDescription_free0 (_tmp23_);
	}
	_tmp24_ = (gchar*) xmlGetProp (node, (xmlChar*) "connectiontwidth");
	tw = _tmp24_;
	_tmp25_ = tw;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		gint _tmp27_;
		_tmp26_ = tw;
		_tmp27_ = atoi (_tmp26_);
		style_set_connection_title_width (self, &_tmp27_);
	}
	_g_free0 (tw);
	_g_free0 (f);
	_g_free0 (p);
	_g_free0 (a);
	_g_free0 (lw);
	_g_free0 (d);
}

void
style_load_callout (Style* self,
                    xmlNode* node)
{
	gchar* f = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* p = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* pw = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* pl = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "calloutfont");
	f = _tmp0_;
	_tmp1_ = f;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		PangoFontDescription* _tmp3_;
		PangoFontDescription* _tmp4_;
		_tmp2_ = f;
		_tmp3_ = pango_font_description_from_string (_tmp2_);
		_tmp4_ = _tmp3_;
		style_set_callout_font (self, _tmp4_);
		__vala_PangoFontDescription_free0 (_tmp4_);
	}
	_tmp5_ = (gchar*) xmlGetProp (node, (xmlChar*) "calloutpadding");
	p = _tmp5_;
	_tmp6_ = p;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		gint _tmp8_;
		_tmp7_ = p;
		_tmp8_ = atoi (_tmp7_);
		style_set_callout_padding (self, &_tmp8_);
	}
	_tmp9_ = (gchar*) xmlGetProp (node, (xmlChar*) "calloutptrwidth");
	pw = _tmp9_;
	_tmp10_ = pw;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		gint _tmp12_;
		_tmp11_ = pw;
		_tmp12_ = atoi (_tmp11_);
		style_set_callout_ptr_width (self, &_tmp12_);
	}
	_tmp13_ = (gchar*) xmlGetProp (node, (xmlChar*) "calloutptrlength");
	pl = _tmp13_;
	_tmp14_ = pl;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gint _tmp16_;
		_tmp15_ = pl;
		_tmp16_ = atoi (_tmp15_);
		style_set_callout_ptr_length (self, &_tmp16_);
	}
	_g_free0 (pl);
	_g_free0 (pw);
	_g_free0 (p);
	_g_free0 (f);
}

void
style_save_node_in_node (Style* self,
                         xmlNode* n)
{
	gint* _tmp0_;
	gint* _tmp4_;
	LinkType* _tmp8_;
	gint* _tmp12_;
	gboolean* _tmp16_;
	LinkDash* _tmp20_;
	NodeBorder* _tmp23_;
	gint* _tmp27_;
	gint* _tmp31_;
	gboolean* _tmp35_;
	gint* _tmp39_;
	gint* _tmp43_;
	PangoFontDescription* _tmp47_;
	gboolean* _tmp51_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_branch_margin;
	if (_tmp0_ != NULL) {
		gint* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_branch_margin;
		_tmp2_ = g_strdup_printf ("%i", *_tmp1_);
		_tmp3_ = _tmp2_;
		xmlSetProp (n, (xmlChar*) "branchmargin", (xmlChar*) _tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = self->priv->_branch_radius;
	if (_tmp4_ != NULL) {
		gint* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->_branch_radius;
		_tmp6_ = g_strdup_printf ("%i", *_tmp5_);
		_tmp7_ = _tmp6_;
		xmlSetProp (n, (xmlChar*) "branchradius", (xmlChar*) _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = self->priv->_link_type;
	if (_tmp8_ != NULL) {
		LinkType* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->priv->_link_type;
		_tmp10_ = link_type_name (_tmp9_);
		_tmp11_ = _tmp10_;
		xmlSetProp (n, (xmlChar*) "linktype", (xmlChar*) _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = self->priv->_link_width;
	if (_tmp12_ != NULL) {
		gint* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = self->priv->_link_width;
		_tmp14_ = g_strdup_printf ("%i", *_tmp13_);
		_tmp15_ = _tmp14_;
		xmlSetProp (n, (xmlChar*) "linkwidth", (xmlChar*) _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->_link_arrow;
	if (_tmp16_ != NULL) {
		gboolean* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = self->priv->_link_arrow;
		_tmp18_ = bool_to_string (*_tmp17_);
		_tmp19_ = _tmp18_;
		xmlSetProp (n, (xmlChar*) "linkarrow", (xmlChar*) _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->_link_dash;
	if (_tmp20_ != NULL) {
		LinkDash* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = self->priv->_link_dash;
		_tmp22_ = _tmp21_->name;
		xmlSetProp (n, (xmlChar*) "linkdash", (xmlChar*) _tmp22_);
	}
	_tmp23_ = self->priv->_node_border;
	if (_tmp23_ != NULL) {
		NodeBorder* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp24_ = self->priv->_node_border;
		_tmp25_ = node_border_name (_tmp24_);
		_tmp26_ = _tmp25_;
		xmlSetProp (n, (xmlChar*) "nodeborder", (xmlChar*) _tmp26_);
		_g_free0 (_tmp26_);
	}
	_tmp27_ = self->priv->_node_width;
	if (_tmp27_ != NULL) {
		gint* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = self->priv->_node_width;
		_tmp29_ = g_strdup_printf ("%i", *_tmp28_);
		_tmp30_ = _tmp29_;
		xmlSetProp (n, (xmlChar*) "nodewidth", (xmlChar*) _tmp30_);
		_g_free0 (_tmp30_);
	}
	_tmp31_ = self->priv->_node_borderwidth;
	if (_tmp31_ != NULL) {
		gint* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp32_ = self->priv->_node_borderwidth;
		_tmp33_ = g_strdup_printf ("%i", *_tmp32_);
		_tmp34_ = _tmp33_;
		xmlSetProp (n, (xmlChar*) "nodeborderwidth", (xmlChar*) _tmp34_);
		_g_free0 (_tmp34_);
	}
	_tmp35_ = self->priv->_node_fill;
	if (_tmp35_ != NULL) {
		gboolean* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp36_ = self->priv->_node_fill;
		_tmp37_ = bool_to_string (*_tmp36_);
		_tmp38_ = _tmp37_;
		xmlSetProp (n, (xmlChar*) "nodefill", (xmlChar*) _tmp38_);
		_g_free0 (_tmp38_);
	}
	_tmp39_ = self->priv->_node_margin;
	if (_tmp39_ != NULL) {
		gint* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = self->priv->_node_margin;
		_tmp41_ = g_strdup_printf ("%i", *_tmp40_);
		_tmp42_ = _tmp41_;
		xmlSetProp (n, (xmlChar*) "nodemargin", (xmlChar*) _tmp42_);
		_g_free0 (_tmp42_);
	}
	_tmp43_ = self->priv->_node_padding;
	if (_tmp43_ != NULL) {
		gint* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp44_ = self->priv->_node_padding;
		_tmp45_ = g_strdup_printf ("%i", *_tmp44_);
		_tmp46_ = _tmp45_;
		xmlSetProp (n, (xmlChar*) "nodepadding", (xmlChar*) _tmp46_);
		_g_free0 (_tmp46_);
	}
	_tmp47_ = self->priv->_node_font;
	if (_tmp47_ != NULL) {
		PangoFontDescription* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp48_ = self->priv->_node_font;
		_tmp49_ = pango_font_description_to_string (_tmp48_);
		_tmp50_ = _tmp49_;
		xmlSetProp (n, (xmlChar*) "nodefont", (xmlChar*) _tmp50_);
		_g_free0 (_tmp50_);
	}
	_tmp51_ = self->priv->_node_markup;
	if (_tmp51_ != NULL) {
		gboolean* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp52_ = self->priv->_node_markup;
		_tmp53_ = bool_to_string (*_tmp52_);
		_tmp54_ = _tmp53_;
		xmlSetProp (n, (xmlChar*) "nodemarkup", (xmlChar*) _tmp54_);
		_g_free0 (_tmp54_);
	}
}

void
style_save_node (Style* self,
                 xmlNode* parent)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "style");
	n = _tmp0_;
	style_save_node_in_node (self, n);
	xmlAddChild (parent, n);
}

void
style_save_connection_in_node (Style* self,
                               xmlNode* n)
{
	LinkDash* _tmp0_;
	gint* _tmp3_;
	const gchar* _tmp7_;
	gint* _tmp9_;
	PangoFontDescription* _tmp13_;
	gint* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_connection_dash;
	if (_tmp0_ != NULL) {
		LinkDash* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->_connection_dash;
		_tmp2_ = _tmp1_->name;
		xmlSetProp (n, (xmlChar*) "connectiondash", (xmlChar*) _tmp2_);
	}
	_tmp3_ = self->priv->_connection_line_width;
	if (_tmp3_ != NULL) {
		gint* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->_connection_line_width;
		_tmp5_ = g_strdup_printf ("%i", *_tmp4_);
		_tmp6_ = _tmp5_;
		xmlSetProp (n, (xmlChar*) "connectionlwidth", (xmlChar*) _tmp6_);
		_g_free0 (_tmp6_);
	}
	_tmp7_ = self->priv->_connection_arrow;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = self->priv->_connection_arrow;
		xmlSetProp (n, (xmlChar*) "connectionarrow", (xmlChar*) _tmp8_);
	}
	_tmp9_ = self->priv->_connection_padding;
	if (_tmp9_ != NULL) {
		gint* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->_connection_padding;
		_tmp11_ = g_strdup_printf ("%i", *_tmp10_);
		_tmp12_ = _tmp11_;
		xmlSetProp (n, (xmlChar*) "connectionpadding", (xmlChar*) _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = self->priv->_connection_font;
	if (_tmp13_ != NULL) {
		PangoFontDescription* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->priv->_connection_font;
		_tmp15_ = pango_font_description_to_string (_tmp14_);
		_tmp16_ = _tmp15_;
		xmlSetProp (n, (xmlChar*) "connectionfont", (xmlChar*) _tmp16_);
		_g_free0 (_tmp16_);
	}
	_tmp17_ = self->priv->_connection_title_width;
	if (_tmp17_ != NULL) {
		gint* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = self->priv->_connection_title_width;
		_tmp19_ = g_strdup_printf ("%i", *_tmp18_);
		_tmp20_ = _tmp19_;
		xmlSetProp (n, (xmlChar*) "connectiontwidth", (xmlChar*) _tmp20_);
		_g_free0 (_tmp20_);
	}
}

void
style_save_connection (Style* self,
                       xmlNode* parent)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "style");
	n = _tmp0_;
	style_save_connection_in_node (self, n);
	xmlAddChild (parent, n);
}

void
style_save_callout_in_node (Style* self,
                            xmlNode* n)
{
	PangoFontDescription* _tmp0_;
	gint* _tmp4_;
	gint* _tmp8_;
	gint* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_callout_font;
	if (_tmp0_ != NULL) {
		PangoFontDescription* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_callout_font;
		_tmp2_ = pango_font_description_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		xmlSetProp (n, (xmlChar*) "calloutfont", (xmlChar*) _tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = self->priv->_callout_padding;
	if (_tmp4_ != NULL) {
		gint* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->_callout_padding;
		_tmp6_ = g_strdup_printf ("%i", *_tmp5_);
		_tmp7_ = _tmp6_;
		xmlSetProp (n, (xmlChar*) "calloutpadding", (xmlChar*) _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = self->priv->_callout_ptr_width;
	if (_tmp8_ != NULL) {
		gint* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->priv->_callout_ptr_width;
		_tmp10_ = g_strdup_printf ("%i", *_tmp9_);
		_tmp11_ = _tmp10_;
		xmlSetProp (n, (xmlChar*) "calloutptrwidth", (xmlChar*) _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = self->priv->_callout_ptr_length;
	if (_tmp12_ != NULL) {
		gint* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = self->priv->_callout_ptr_length;
		_tmp14_ = g_strdup_printf ("%i", *_tmp13_);
		_tmp15_ = _tmp14_;
		xmlSetProp (n, (xmlChar*) "calloutptrlength", (xmlChar*) _tmp15_);
		_g_free0 (_tmp15_);
	}
}

void
style_save_callout (Style* self,
                    xmlNode* parent)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "style");
	n = _tmp0_;
	style_save_callout_in_node (self, n);
	xmlAddChild (parent, n);
}

void
style_draw_link (Style* self,
                 cairo_t* ctx,
                 Node* from_node,
                 Node* to_node,
                 gboolean force_straight_link_type,
                 gdouble from_x,
                 gdouble from_y,
                 gdouble to_x1,
                 gdouble to_y1,
                 gdouble to_x2,
                 gdouble to_y2,
                 gdouble* tailx,
                 gdouble* taily,
                 gdouble* tipx,
                 gdouble* tipy)
{
	gdouble _vala_tailx = 0.0;
	gdouble _vala_taily = 0.0;
	gdouble _vala_tipx = 0.0;
	gdouble _vala_tipy = 0.0;
	gint* _tmp0_;
	LinkDash* _tmp1_;
	gint* _tmp2_;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (from_node != NULL);
	g_return_if_fail (to_node != NULL);
	cairo_save (ctx);
	_tmp0_ = self->priv->_link_width;
	cairo_set_line_width (ctx, *_tmp0_);
	_tmp1_ = self->priv->_link_dash;
	_tmp2_ = self->priv->_link_width;
	link_dash_set_context (_tmp1_, ctx, *_tmp2_);
	if (force_straight_link_type) {
		LinkType* straight = NULL;
		Styles* _tmp3_;
		LinkType* _tmp4_;
		LinkType* _tmp5_;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		gdouble _tmp9_ = 0.0;
		_tmp3_ = style_inspector_styles;
		_tmp4_ = styles_get_link_type (_tmp3_, "straight");
		straight = _tmp4_;
		_tmp5_ = straight;
		link_type_draw (_tmp5_, ctx, from_node, to_node, from_x, from_y, to_x1, to_y1, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
		_vala_tailx = _tmp6_;
		_vala_taily = _tmp7_;
		_vala_tipx = _tmp8_;
		_vala_tipy = _tmp9_;
		_g_object_unref0 (straight);
	} else {
		Style* _tmp10_;
		Style* _tmp11_;
		LinkType* _tmp12_;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp10_ = node_get_style (from_node);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_->priv->_link_type;
		link_type_draw (_tmp12_, ctx, from_node, to_node, from_x, from_y, to_x1, to_y1, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
		_vala_tailx = _tmp13_;
		_vala_taily = _tmp14_;
		_vala_tipx = _tmp15_;
		_vala_tipy = _tmp16_;
	}
	if (to_x1 != to_x2) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = to_y1 != to_y2;
	}
	if (_tmp17_) {
		cairo_move_to (ctx, to_x1, to_y1);
		cairo_line_to (ctx, to_x2, to_y2);
		cairo_stroke (ctx);
	}
	cairo_restore (ctx);
	if (tailx) {
		*tailx = _vala_tailx;
	}
	if (taily) {
		*taily = _vala_taily;
	}
	if (tipx) {
		*tipx = _vala_tipx;
	}
	if (tipy) {
		*tipy = _vala_tipy;
	}
}

void
style_draw_node_border (Style* self,
                        cairo_t* ctx,
                        gdouble x,
                        gdouble y,
                        gdouble w,
                        gdouble h,
                        NodeSide s)
{
	gint* _tmp0_;
	NodeBorder* _tmp1_;
	gint* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	cairo_save (ctx);
	_tmp0_ = self->priv->_node_borderwidth;
	cairo_set_line_width (ctx, *_tmp0_);
	_tmp1_ = self->priv->_node_border;
	_tmp2_ = self->priv->_node_padding;
	node_border_draw_border (_tmp1_, ctx, x, y, w, h, s, *_tmp2_);
	cairo_restore (ctx);
}

void
style_draw_node_fill (Style* self,
                      cairo_t* ctx,
                      gdouble x,
                      gdouble y,
                      gdouble w,
                      gdouble h,
                      NodeSide s)
{
	NodeBorder* _tmp0_;
	gint* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->_node_border;
	_tmp1_ = self->priv->_node_padding;
	node_border_draw_fill (_tmp0_, ctx, x, y, w, h, s, *_tmp1_);
}

void
style_draw_connection (Style* self,
                       cairo_t* ctx)
{
	gint* _tmp0_;
	LinkDash* _tmp1_;
	gint* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->_connection_line_width;
	cairo_set_line_width (ctx, *_tmp0_);
	_tmp1_ = self->priv->_connection_dash;
	_tmp2_ = self->priv->_connection_line_width;
	link_dash_set_context (_tmp1_, ctx, *_tmp2_);
}

gint*
style_get_branch_margin (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_branch_margin;
	result = _tmp0_;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

void
style_set_branch_margin (Style* self,
                         gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_branch_margin);
	self->priv->_branch_margin = _tmp0_;
}

gint*
style_get_branch_radius (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_branch_radius;
	result = _tmp0_;
	return result;
}

void
style_set_branch_radius (Style* self,
                         gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_branch_radius);
	self->priv->_branch_radius = _tmp0_;
}

LinkType*
style_get_link_type (Style* self)
{
	LinkType* result;
	LinkType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_link_type;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
style_set_link_type (Style* self,
                     LinkType* value)
{
	LinkType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_link_type);
	self->priv->_link_type = _tmp0_;
}

gint*
style_get_link_width (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_link_width;
	result = _tmp0_;
	return result;
}

void
style_set_link_width (Style* self,
                      gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_link_width);
	self->priv->_link_width = _tmp0_;
}

gboolean*
style_get_link_arrow (Style* self)
{
	gboolean* result;
	gboolean* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_link_arrow;
	result = _tmp0_;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

void
style_set_link_arrow (Style* self,
                      gboolean* value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (value);
	_g_free0 (self->priv->_link_arrow);
	self->priv->_link_arrow = _tmp0_;
}

LinkDash*
style_get_link_dash (Style* self)
{
	LinkDash* result;
	LinkDash* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_link_dash;
	result = _tmp0_;
	return result;
}

void
style_set_link_dash (Style* self,
                     LinkDash* value)
{
	LinkDash* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_link_dash);
	self->priv->_link_dash = _tmp0_;
}

NodeBorder*
style_get_node_border (Style* self)
{
	NodeBorder* result;
	NodeBorder* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_border;
	result = _tmp0_;
	return result;
}

void
style_set_node_border (Style* self,
                       NodeBorder* value)
{
	NodeBorder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_node_border);
	self->priv->_node_border = _tmp0_;
}

gint*
style_get_node_borderwidth (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_borderwidth;
	result = _tmp0_;
	return result;
}

void
style_set_node_borderwidth (Style* self,
                            gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_node_borderwidth);
	self->priv->_node_borderwidth = _tmp0_;
}

gboolean*
style_get_node_fill (Style* self)
{
	gboolean* result;
	gboolean* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_fill;
	result = _tmp0_;
	return result;
}

void
style_set_node_fill (Style* self,
                     gboolean* value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (value);
	_g_free0 (self->priv->_node_fill);
	self->priv->_node_fill = _tmp0_;
}

gint*
style_get_node_margin (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_margin;
	result = _tmp0_;
	return result;
}

void
style_set_node_margin (Style* self,
                       gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_node_margin);
	self->priv->_node_margin = _tmp0_;
}

gint*
style_get_node_padding (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_padding;
	result = _tmp0_;
	return result;
}

void
style_set_node_padding (Style* self,
                        gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_node_padding);
	self->priv->_node_padding = _tmp0_;
}

PangoFontDescription*
style_get_node_font (Style* self)
{
	PangoFontDescription* result;
	PangoFontDescription* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_font;
	result = _tmp0_;
	return result;
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

void
style_set_node_font (Style* self,
                     PangoFontDescription* value)
{
	PangoFontDescription* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __vala_PangoFontDescription_copy0 (value);
	__vala_PangoFontDescription_free0 (self->priv->_node_font);
	self->priv->_node_font = _tmp0_;
}

gint*
style_get_node_width (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_width;
	result = _tmp0_;
	return result;
}

void
style_set_node_width (Style* self,
                      gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_node_width);
	self->priv->_node_width = _tmp0_;
}

gboolean*
style_get_node_markup (Style* self)
{
	gboolean* result;
	gboolean* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node_markup;
	result = _tmp0_;
	return result;
}

void
style_set_node_markup (Style* self,
                       gboolean* value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (value);
	_g_free0 (self->priv->_node_markup);
	self->priv->_node_markup = _tmp0_;
}

LinkDash*
style_get_connection_dash (Style* self)
{
	LinkDash* result;
	LinkDash* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_dash;
	result = _tmp0_;
	return result;
}

void
style_set_connection_dash (Style* self,
                           LinkDash* value)
{
	LinkDash* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_connection_dash);
	self->priv->_connection_dash = _tmp0_;
}

gint*
style_get_connection_line_width (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_line_width;
	result = _tmp0_;
	return result;
}

void
style_set_connection_line_width (Style* self,
                                 gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_connection_line_width);
	self->priv->_connection_line_width = _tmp0_;
}

const gchar*
style_get_connection_arrow (Style* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_arrow;
	result = _tmp0_;
	return result;
}

void
style_set_connection_arrow (Style* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_connection_arrow);
	self->priv->_connection_arrow = _tmp0_;
}

gint*
style_get_connection_padding (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_padding;
	result = _tmp0_;
	return result;
}

void
style_set_connection_padding (Style* self,
                              gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_connection_padding);
	self->priv->_connection_padding = _tmp0_;
}

PangoFontDescription*
style_get_connection_font (Style* self)
{
	PangoFontDescription* result;
	PangoFontDescription* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_font;
	result = _tmp0_;
	return result;
}

void
style_set_connection_font (Style* self,
                           PangoFontDescription* value)
{
	PangoFontDescription* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __vala_PangoFontDescription_copy0 (value);
	__vala_PangoFontDescription_free0 (self->priv->_connection_font);
	self->priv->_connection_font = _tmp0_;
}

gint*
style_get_connection_title_width (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection_title_width;
	result = _tmp0_;
	return result;
}

void
style_set_connection_title_width (Style* self,
                                  gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_connection_title_width);
	self->priv->_connection_title_width = _tmp0_;
}

PangoFontDescription*
style_get_callout_font (Style* self)
{
	PangoFontDescription* result;
	PangoFontDescription* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_callout_font;
	result = _tmp0_;
	return result;
}

void
style_set_callout_font (Style* self,
                        PangoFontDescription* value)
{
	PangoFontDescription* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __vala_PangoFontDescription_copy0 (value);
	__vala_PangoFontDescription_free0 (self->priv->_callout_font);
	self->priv->_callout_font = _tmp0_;
}

gint*
style_get_callout_padding (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_callout_padding;
	result = _tmp0_;
	return result;
}

void
style_set_callout_padding (Style* self,
                           gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_callout_padding);
	self->priv->_callout_padding = _tmp0_;
}

gint*
style_get_callout_ptr_width (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_callout_ptr_width;
	result = _tmp0_;
	return result;
}

void
style_set_callout_ptr_width (Style* self,
                             gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_callout_ptr_width);
	self->priv->_callout_ptr_width = _tmp0_;
}

gint*
style_get_callout_ptr_length (Style* self)
{
	gint* result;
	gint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_callout_ptr_length;
	result = _tmp0_;
	return result;
}

void
style_set_callout_ptr_length (Style* self,
                              gint* value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (value);
	_g_free0 (self->priv->_callout_ptr_length);
	self->priv->_callout_ptr_length = _tmp0_;
}

static void
value_style_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_style_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		style_unref (value->data[0].v_pointer);
	}
}

static void
value_style_copy_value (const GValue* src_value,
                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = style_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_style_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_style_collect_value (GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Style * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = style_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_style_lcopy_value (const GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	Style ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = style_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_style (const gchar* name,
                  const gchar* nick,
                  const gchar* blurb,
                  GType object_type,
                  GParamFlags flags)
{
	ParamSpecStyle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STYLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_style (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STYLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_style (GValue* value,
                 gpointer v_object)
{
	Style * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		style_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		style_unref (old);
	}
}

void
value_take_style (GValue* value,
                  gpointer v_object)
{
	Style * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STYLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STYLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		style_unref (old);
	}
}

static void
style_class_init (StyleClass * klass,
                  gpointer klass_data)
{
	style_parent_class = g_type_class_peek_parent (klass);
	((StyleClass *) klass)->finalize = style_finalize;
	g_type_class_adjust_private_offset (klass, &Style_private_offset);
}

static void
style_instance_init (Style * self,
                     gpointer klass)
{
	self->priv = style_get_instance_private (self);
	self->priv->_branch_margin = NULL;
	self->priv->_branch_radius = NULL;
	self->priv->_link_type = NULL;
	self->priv->_link_width = NULL;
	self->priv->_link_arrow = NULL;
	self->priv->_link_dash = NULL;
	self->priv->_node_border = NULL;
	self->priv->_node_borderwidth = NULL;
	self->priv->_node_fill = NULL;
	self->priv->_node_margin = NULL;
	self->priv->_node_padding = NULL;
	self->priv->_node_font = NULL;
	self->priv->_node_width = NULL;
	self->priv->_node_markup = NULL;
	self->priv->_connection_dash = NULL;
	self->priv->_connection_line_width = NULL;
	self->priv->_connection_arrow = NULL;
	self->priv->_connection_padding = NULL;
	self->priv->_connection_font = NULL;
	self->priv->_connection_title_width = NULL;
	self->priv->_callout_font = NULL;
	self->priv->_callout_padding = NULL;
	self->priv->_callout_ptr_width = NULL;
	self->priv->_callout_ptr_length = NULL;
	self->ref_count = 1;
}

static void
style_finalize (Style * obj)
{
	Style * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STYLE, Style);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_branch_margin);
	_g_free0 (self->priv->_branch_radius);
	_g_object_unref0 (self->priv->_link_type);
	_g_free0 (self->priv->_link_width);
	_g_free0 (self->priv->_link_arrow);
	_g_object_unref0 (self->priv->_link_dash);
	_g_object_unref0 (self->priv->_node_border);
	_g_free0 (self->priv->_node_borderwidth);
	_g_free0 (self->priv->_node_fill);
	_g_free0 (self->priv->_node_margin);
	_g_free0 (self->priv->_node_padding);
	__vala_PangoFontDescription_free0 (self->priv->_node_font);
	_g_free0 (self->priv->_node_width);
	_g_free0 (self->priv->_node_markup);
	_g_object_unref0 (self->priv->_connection_dash);
	_g_free0 (self->priv->_connection_line_width);
	_g_free0 (self->priv->_connection_arrow);
	_g_free0 (self->priv->_connection_padding);
	__vala_PangoFontDescription_free0 (self->priv->_connection_font);
	_g_free0 (self->priv->_connection_title_width);
	__vala_PangoFontDescription_free0 (self->priv->_callout_font);
	_g_free0 (self->priv->_callout_padding);
	_g_free0 (self->priv->_callout_ptr_width);
	_g_free0 (self->priv->_callout_ptr_length);
}

static GType
style_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_style_init, value_style_free_value, value_style_copy_value, value_style_peek_pointer, "p", value_style_collect_value, "p", value_style_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (StyleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) style_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Style), 0, (GInstanceInitFunc) style_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType style_type_id;
	style_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Style", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Style_private_offset = g_type_add_instance_private (style_type_id, sizeof (StylePrivate));
	return style_type_id;
}

GType
style_get_type (void)
{
	static volatile gsize style_type_id__once = 0;
	if (g_once_init_enter (&style_type_id__once)) {
		GType style_type_id;
		style_type_id = style_get_type_once ();
		g_once_init_leave (&style_type_id__once, style_type_id);
	}
	return style_type_id__once;
}

gpointer
style_ref (gpointer instance)
{
	Style * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
style_unref (gpointer instance)
{
	Style * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STYLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

