/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 41;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 40,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 37,
  Feature_IsNotISA3_1Bit = 39,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 20,
  Feature_IsNotISAFutureBit = 18,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 31,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_NoP8VectorBit = 30,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 32,
  Feature_NoP10VectorBit = 33,
  Feature_HasP10VectorBit = 36,
  Feature_HasHTMBit = 34,
  Feature_IsPPC32Bit = 38,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 35,
  Feature_MMABit = 19,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (!Subtarget->hasP8Vector())
    Features.set(Feature_NoP8VectorBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasP10Vector())
    Features.set(Feature_HasP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_In32BitMode,
  GIFBS_In64BitMode,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_IsNotISA3_1,
  GIFBS_NotAIX,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasFPU_IsISA3_1,
  GIFBS_HasP10Vector_PrefixInstrs,
  GIFBS_HasP8Altivec_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_HasVSX_IsISA3_1,
  GIFBS_In64BitMode_IsISA3_0,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
  GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
  GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
  GIFBS_IsISAFuture_MMA_PrefixInstrs,
  GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
  GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
  GIFBS_HasVSX_IsBigEndian_IsISA3_1_IsPPC32,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_IsNotISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasFPUBit, Feature_IsISA3_1Bit, },
  {Feature_HasP10VectorBit, Feature_PrefixInstrsBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_HasVSXBit, Feature_IsISA3_1Bit, },
  {Feature_In64BitModeBit, Feature_IsISA3_0Bit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsBigEndianBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsISA3_0Bit, Feature_IsLittleEndianBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, Feature_NoP9VectorBit, },
  {Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_1Bit, Feature_IsPPC32Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_0Bit, Feature_IsPPC64Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsPPC64Bit, Feature_NoP9VectorBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_Msk2Imm = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_Msk4Imm,
  GICXXPred_I64_Predicate_Msk8Imm,
  GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
  GICXXPred_I64_Predicate_imm32SExt16,
  GICXXPred_I64_Predicate_imm64SExt16,
  GICXXPred_I64_Predicate_imm64ZExt32,
  GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
  GICXXPred_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
  }
  case GICXXPred_I64_Predicate_imm32SExt16: {
    
      // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int32_t)Imm == (short)Imm;
    
    llvm_unreachable("imm32SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64SExt16: {
    
      // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int64_t)Imm == (short)Imm;
    
    llvm_unreachable("imm64SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64ZExt32: {
    
      // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
      // zero extended field.
      return isUInt<32>(Imm);
    
    llvm_unreachable("imm64ZExt32 should have returned");
  }
  case GICXXPred_I64_Predicate_immNonAllOneAnyExt8: {
    
      return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));
    
  }
  case GICXXPred_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("PPCInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool PPCInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("PPCInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(274), /*)*//*default:*//*Label 82*/ GIMT_Encode4(97181),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(902),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(1219),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(1660),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(1942),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(2098),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(2254),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(2416), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(2578),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(3212),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(3846), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ GIMT_Encode4(5350), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 11*/ GIMT_Encode4(6317), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ GIMT_Encode4(8594),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ GIMT_Encode4(8866),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 14*/ GIMT_Encode4(9113),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 15*/ GIMT_Encode4(9241), GIMT_Encode4(0),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 16*/ GIMT_Encode4(9369), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 17*/ GIMT_Encode4(9389), GIMT_Encode4(0),
    /*TargetOpcode::G_BRCOND*//*Label 18*/ GIMT_Encode4(9514), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 19*/ GIMT_Encode4(9577),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 20*/ GIMT_Encode4(35305), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 21*/ GIMT_Encode4(37995),
    /*TargetOpcode::G_TRUNC*//*Label 22*/ GIMT_Encode4(38181),
    /*TargetOpcode::G_CONSTANT*//*Label 23*/ GIMT_Encode4(38367), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 24*/ GIMT_Encode4(38519), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 25*/ GIMT_Encode4(38725),
    /*TargetOpcode::G_SHL*//*Label 26*/ GIMT_Encode4(38911),
    /*TargetOpcode::G_LSHR*//*Label 27*/ GIMT_Encode4(39261),
    /*TargetOpcode::G_ASHR*//*Label 28*/ GIMT_Encode4(39611), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTL*//*Label 29*/ GIMT_Encode4(39975),
    /*TargetOpcode::G_ICMP*//*Label 30*/ GIMT_Encode4(40283),
    /*TargetOpcode::G_FCMP*//*Label 31*/ GIMT_Encode4(44285), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 32*/ GIMT_Encode4(47860), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 33*/ GIMT_Encode4(48957),
    /*TargetOpcode::G_SMULH*//*Label 34*/ GIMT_Encode4(49087),
    /*TargetOpcode::G_UADDSAT*//*Label 35*/ GIMT_Encode4(49217),
    /*TargetOpcode::G_SADDSAT*//*Label 36*/ GIMT_Encode4(49319),
    /*TargetOpcode::G_USUBSAT*//*Label 37*/ GIMT_Encode4(49421),
    /*TargetOpcode::G_SSUBSAT*//*Label 38*/ GIMT_Encode4(49523), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 39*/ GIMT_Encode4(49625),
    /*TargetOpcode::G_FSUB*//*Label 40*/ GIMT_Encode4(49920),
    /*TargetOpcode::G_FMUL*//*Label 41*/ GIMT_Encode4(50215),
    /*TargetOpcode::G_FMA*//*Label 42*/ GIMT_Encode4(50565), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 43*/ GIMT_Encode4(51146), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 44*/ GIMT_Encode4(51416),
    /*TargetOpcode::G_FPEXT*//*Label 45*/ GIMT_Encode4(53806),
    /*TargetOpcode::G_FPTRUNC*//*Label 46*/ GIMT_Encode4(53967),
    /*TargetOpcode::G_FPTOSI*//*Label 47*/ GIMT_Encode4(54124),
    /*TargetOpcode::G_FPTOUI*//*Label 48*/ GIMT_Encode4(54384),
    /*TargetOpcode::G_SITOFP*//*Label 49*/ GIMT_Encode4(54644),
    /*TargetOpcode::G_UITOFP*//*Label 50*/ GIMT_Encode4(54888),
    /*TargetOpcode::G_FABS*//*Label 51*/ GIMT_Encode4(55132),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 52*/ GIMT_Encode4(55421), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 53*/ GIMT_Encode4(55731),
    /*TargetOpcode::G_FMAXNUM*//*Label 54*/ GIMT_Encode4(55811),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 55*/ GIMT_Encode4(55891),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 56*/ GIMT_Encode4(56030), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 57*/ GIMT_Encode4(56169),
    /*TargetOpcode::G_SMAX*//*Label 58*/ GIMT_Encode4(56343),
    /*TargetOpcode::G_UMIN*//*Label 59*/ GIMT_Encode4(56517),
    /*TargetOpcode::G_UMAX*//*Label 60*/ GIMT_Encode4(56691), GIMT_Encode4(0),
    /*TargetOpcode::G_LROUND*//*Label 61*/ GIMT_Encode4(56865),
    /*TargetOpcode::G_LLROUND*//*Label 62*/ GIMT_Encode4(57027),
    /*TargetOpcode::G_BR*//*Label 63*/ GIMT_Encode4(57189), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 64*/ GIMT_Encode4(57205), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 65*/ GIMT_Encode4(57323), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 66*/ GIMT_Encode4(57501), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 67*/ GIMT_Encode4(57673),
    /*TargetOpcode::G_BSWAP*//*Label 68*/ GIMT_Encode4(57845),
    /*TargetOpcode::G_BITREVERSE*//*Label 69*/ GIMT_Encode4(58103),
    /*TargetOpcode::G_FCEIL*//*Label 70*/ GIMT_Encode4(94109), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 71*/ GIMT_Encode4(94381),
    /*TargetOpcode::G_FFLOOR*//*Label 72*/ GIMT_Encode4(94598),
    /*TargetOpcode::G_FRINT*//*Label 73*/ GIMT_Encode4(94870),
    /*TargetOpcode::G_FNEARBYINT*//*Label 74*/ GIMT_Encode4(95079), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 75*/ GIMT_Encode4(95313),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 76*/ GIMT_Encode4(95583),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 77*/ GIMT_Encode4(95853),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 78*/ GIMT_Encode4(96123), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 79*/ GIMT_Encode4(96393),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 80*/ GIMT_Encode4(96951), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 81*/ GIMT_Encode4(97168),
    // Label 0: @902
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 91*/ GIMT_Encode4(1218),
    /*GILLT_s1*//*Label 83*/ GIMT_Encode4(945),
    /*GILLT_s32*//*Label 84*/ GIMT_Encode4(968),
    /*GILLT_s64*//*Label 85*/ GIMT_Encode4(1028),
    /*GILLT_s128*//*Label 86*/ GIMT_Encode4(1088),
    /*GILLT_v2s64*//*Label 87*/ GIMT_Encode4(1114),
    /*GILLT_v4s32*//*Label 88*/ GIMT_Encode4(1140),
    /*GILLT_v8s16*//*Label 89*/ GIMT_Encode4(1166),
    /*GILLT_v16s8*//*Label 90*/ GIMT_Encode4(1192),
    // Label 83: @945
    GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(967), // Rule ID 3616 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (add:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3616,
      GIR_Done,
    // Label 92: @967
    GIM_Reject,
    // Label 84: @968
    GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1027),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1014), // Rule ID 104 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 104,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1014
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1026), // Rule ID 196 //
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD4),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 196,
        GIR_Done,
      // Label 95: @1026
      GIM_Reject,
    // Label 93: @1027
    GIM_Reject,
    // Label 85: @1028
    GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1087),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1074), // Rule ID 656 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 656,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1074
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1086), // Rule ID 652 //
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 652,
        GIR_Done,
      // Label 98: @1086
      GIM_Reject,
    // Label 96: @1087
    GIM_Reject,
    // Label 86: @1088
    GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1113), // Rule ID 467 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUQM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 467,
      GIR_Done,
    // Label 99: @1113
    GIM_Reject,
    // Label 87: @1114
    GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1139), // Rule ID 466 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUDM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 466,
      GIR_Done,
    // Label 100: @1139
    GIM_Reject,
    // Label 88: @1140
    GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1165), // Rule ID 300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUWM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 300,
      GIR_Done,
    // Label 101: @1165
    GIM_Reject,
    // Label 89: @1166
    GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1191), // Rule ID 299 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUHM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 299,
      GIR_Done,
    // Label 102: @1191
    GIM_Reject,
    // Label 90: @1192
    GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1217), // Rule ID 298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUBM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 298,
      GIR_Done,
    // Label 103: @1217
    GIM_Reject,
    // Label 91: @1218
    GIM_Reject,
    // Label 1: @1219
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 112*/ GIMT_Encode4(1659),
    /*GILLT_s1*//*Label 104*/ GIMT_Encode4(1262),
    /*GILLT_s32*//*Label 105*/ GIMT_Encode4(1285),
    /*GILLT_s64*//*Label 106*/ GIMT_Encode4(1370),
    /*GILLT_s128*//*Label 107*/ GIMT_Encode4(1455),
    /*GILLT_v2s64*//*Label 108*/ GIMT_Encode4(1481),
    /*GILLT_v4s32*//*Label 109*/ GIMT_Encode4(1544),
    /*GILLT_v8s16*//*Label 110*/ GIMT_Encode4(1607),
    /*GILLT_v16s8*//*Label 111*/ GIMT_Encode4(1633),
    // Label 104: @1262
    GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1284), // Rule ID 3617 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (sub:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3617,
      GIR_Done,
    // Label 113: @1284
    GIM_Reject,
    // Label 105: @1285
    GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1369),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1318), // Rule ID 208 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$RA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$RA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 208,
        GIR_EraseRootFromParent_Done,
      // Label 115: @1318
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1352), // Rule ID 1200 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm, i32:{ *:[i32] }:$in)  =>  (SUBFIC:{ *:[i32] }:{ *:[i32] } ?:{ *:[i32] }:$in, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1200,
        GIR_EraseRootFromParent_Done,
      // Label 116: @1352
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1368), // Rule ID 206 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$RB, i32:{ *:[i32] }:$RA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 206,
        GIR_EraseRootFromParent_Done,
      // Label 117: @1368
      GIM_Reject,
    // Label 114: @1369
    GIM_Reject,
    // Label 106: @1370
    GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1454),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1403), // Rule ID 662 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$RA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$RA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 662,
        GIR_EraseRootFromParent_Done,
      // Label 119: @1403
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1437), // Rule ID 1522 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm, i64:{ *:[i64] }:$in)  =>  (SUBFIC8:{ *:[i64] }:{ *:[i32] } ?:{ *:[i64] }:$in, (imm:{ *:[i64] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1522,
        GIR_EraseRootFromParent_Done,
      // Label 120: @1437
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1453), // Rule ID 661 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$RB, i64:{ *:[i64] }:$RA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 661,
        GIR_EraseRootFromParent_Done,
      // Label 121: @1453
      GIM_Reject,
    // Label 118: @1454
    GIM_Reject,
    // Label 107: @1455
    GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1480), // Rule ID 472 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUQM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 472,
      GIR_Done,
    // Label 122: @1480
    GIM_Reject,
    // Label 108: @1481
    GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1543),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1527), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 539,
        GIR_EraseRootFromParent_Done,
      // Label 124: @1527
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1542), // Rule ID 471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUDM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 471,
        GIR_Done,
      // Label 125: @1542
      GIM_Reject,
    // Label 123: @1543
    GIM_Reject,
    // Label 109: @1544
    GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1606),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1590), // Rule ID 538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 538,
        GIR_EraseRootFromParent_Done,
      // Label 127: @1590
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1605), // Rule ID 370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUWM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 128: @1605
      GIM_Reject,
    // Label 126: @1606
    GIM_Reject,
    // Label 110: @1607
    GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1632), // Rule ID 369 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUHM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 369,
      GIR_Done,
    // Label 129: @1632
    GIM_Reject,
    // Label 111: @1633
    GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1658), // Rule ID 368 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUBM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 368,
      GIR_Done,
    // Label 130: @1658
    GIM_Reject,
    // Label 112: @1659
    GIM_Reject,
    // Label 2: @1660
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(7), /*)*//*default:*//*Label 137*/ GIMT_Encode4(1941),
    /*GILLT_s1*//*Label 131*/ GIMT_Encode4(1699),
    /*GILLT_s32*//*Label 132*/ GIMT_Encode4(1722),
    /*GILLT_s64*//*Label 133*/ GIMT_Encode4(1782), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 134*/ GIMT_Encode4(1842),
    /*GILLT_v4s32*//*Label 135*/ GIMT_Encode4(1868),
    /*GILLT_v8s16*//*Label 136*/ GIMT_Encode4(1894),
    // Label 131: @1699
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(1721), // Rule ID 3618 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (mul:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRAND:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3618,
      GIR_Done,
    // Label 138: @1721
    GIM_Reject,
    // Label 132: @1722
    GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(1781),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(1768), // Rule ID 108 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 108,
        GIR_EraseRootFromParent_Done,
      // Label 140: @1768
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(1780), // Rule ID 205 //
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 205,
        GIR_Done,
      // Label 141: @1780
      GIM_Reject,
    // Label 139: @1781
    GIM_Reject,
    // Label 133: @1782
    GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(1841),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(1828), // Rule ID 696 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 696,
        GIR_EraseRootFromParent_Done,
      // Label 143: @1828
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(1840), // Rule ID 695 //
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 695,
        GIR_Done,
      // Label 144: @1840
      GIM_Reject,
    // Label 142: @1841
    GIM_Reject,
    // Label 134: @1842
    GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(1867), // Rule ID 1112 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULLD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1112,
      GIR_Done,
    // Label 145: @1867
    GIM_Reject,
    // Label 135: @1868
    GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(1893), // Rule ID 458 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULUWM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 458,
      GIR_Done,
    // Label 146: @1893
    GIM_Reject,
    // Label 136: @1894
    GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(1940), // Rule ID 1278 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, (V_SET0H:{ *:[v8i16] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::V_SET0H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
      GIR_RootToRootCopy, /*OpIdx*/1, // vA
      GIR_RootToRootCopy, /*OpIdx*/2, // vB
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1278,
      GIR_EraseRootFromParent_Done,
    // Label 147: @1940
    GIM_Reject,
    // Label 137: @1941
    GIM_Reject,
    // Label 3: @1942
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 153*/ GIMT_Encode4(2097),
    /*GILLT_s32*//*Label 148*/ GIMT_Encode4(1973),
    /*GILLT_s64*//*Label 149*/ GIMT_Encode4(1996),
    /*GILLT_s128*//*Label 150*/ GIMT_Encode4(2019),
    /*GILLT_v2s64*//*Label 151*/ GIMT_Encode4(2045),
    /*GILLT_v4s32*//*Label 152*/ GIMT_Encode4(2071),
    // Label 148: @1973
    GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(1995), // Rule ID 199 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 199,
      GIR_Done,
    // Label 154: @1995
    GIM_Reject,
    // Label 149: @1996
    GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2018), // Rule ID 687 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 687,
      GIR_Done,
    // Label 155: @2018
    GIM_Reject,
    // Label 150: @2019
    GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2044), // Rule ID 1136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1136,
      GIR_Done,
    // Label 156: @2044
    GIM_Reject,
    // Label 151: @2045
    GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2070), // Rule ID 1123 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1123,
      GIR_Done,
    // Label 157: @2070
    GIM_Reject,
    // Label 152: @2071
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2096), // Rule ID 1121 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1121,
      GIR_Done,
    // Label 158: @2096
    GIM_Reject,
    // Label 153: @2097
    GIM_Reject,
    // Label 4: @2098
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 164*/ GIMT_Encode4(2253),
    /*GILLT_s32*//*Label 159*/ GIMT_Encode4(2129),
    /*GILLT_s64*//*Label 160*/ GIMT_Encode4(2152),
    /*GILLT_s128*//*Label 161*/ GIMT_Encode4(2175),
    /*GILLT_v2s64*//*Label 162*/ GIMT_Encode4(2201),
    /*GILLT_v4s32*//*Label 163*/ GIMT_Encode4(2227),
    // Label 159: @2129
    GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2151), // Rule ID 200 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 200,
      GIR_Done,
    // Label 165: @2151
    GIM_Reject,
    // Label 160: @2152
    GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2174), // Rule ID 688 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 688,
      GIR_Done,
    // Label 166: @2174
    GIM_Reject,
    // Label 161: @2175
    GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2200), // Rule ID 1137 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1137,
      GIR_Done,
    // Label 167: @2200
    GIM_Reject,
    // Label 162: @2201
    GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2226), // Rule ID 1124 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1124,
      GIR_Done,
    // Label 168: @2226
    GIM_Reject,
    // Label 163: @2227
    GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2252), // Rule ID 1122 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1122,
      GIR_Done,
    // Label 169: @2252
    GIM_Reject,
    // Label 164: @2253
    GIM_Reject,
    // Label 5: @2254
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 175*/ GIMT_Encode4(2415),
    /*GILLT_s32*//*Label 170*/ GIMT_Encode4(2285),
    /*GILLT_s64*//*Label 171*/ GIMT_Encode4(2311),
    /*GILLT_s128*//*Label 172*/ GIMT_Encode4(2337),
    /*GILLT_v2s64*//*Label 173*/ GIMT_Encode4(2363),
    /*GILLT_v4s32*//*Label 174*/ GIMT_Encode4(2389),
    // Label 170: @2285
    GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2310), // Rule ID 194 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 194,
      GIR_Done,
    // Label 176: @2310
    GIM_Reject,
    // Label 171: @2311
    GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2336), // Rule ID 692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 177: @2336
    GIM_Reject,
    // Label 172: @2337
    GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2362), // Rule ID 1146 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1146,
      GIR_Done,
    // Label 178: @2362
    GIM_Reject,
    // Label 173: @2363
    GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2388), // Rule ID 1119 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1119,
      GIR_Done,
    // Label 179: @2388
    GIM_Reject,
    // Label 174: @2389
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2414), // Rule ID 1117 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1117,
      GIR_Done,
    // Label 180: @2414
    GIM_Reject,
    // Label 175: @2415
    GIM_Reject,
    // Label 6: @2416
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 186*/ GIMT_Encode4(2577),
    /*GILLT_s32*//*Label 181*/ GIMT_Encode4(2447),
    /*GILLT_s64*//*Label 182*/ GIMT_Encode4(2473),
    /*GILLT_s128*//*Label 183*/ GIMT_Encode4(2499),
    /*GILLT_v2s64*//*Label 184*/ GIMT_Encode4(2525),
    /*GILLT_v4s32*//*Label 185*/ GIMT_Encode4(2551),
    // Label 181: @2447
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2472), // Rule ID 195 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 195,
      GIR_Done,
    // Label 187: @2472
    GIM_Reject,
    // Label 182: @2473
    GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2498), // Rule ID 693 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 188: @2498
    GIM_Reject,
    // Label 183: @2499
    GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2524), // Rule ID 1147 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1147,
      GIR_Done,
    // Label 189: @2524
    GIM_Reject,
    // Label 184: @2525
    GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(2550), // Rule ID 1120 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1120,
      GIR_Done,
    // Label 190: @2550
    GIM_Reject,
    // Label 185: @2551
    GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2576), // Rule ID 1118 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1118,
      GIR_Done,
    // Label 191: @2576
    GIM_Reject,
    // Label 186: @2577
    GIM_Reject,
    // Label 7: @2578
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 196*/ GIMT_Encode4(3211),
    /*GILLT_s1*//*Label 192*/ GIMT_Encode4(2613),
    /*GILLT_s32*//*Label 193*/ GIMT_Encode4(2722),
    /*GILLT_s64*//*Label 194*/ GIMT_Encode4(2831), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 195*/ GIMT_Encode4(2940),
    // Label 192: @2613
    GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(2721),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(2668), // Rule ID 4864 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4864,
        GIR_EraseRootFromParent_Done,
      // Label 198: @2668
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(2708), // Rule ID 179 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 179,
        GIR_EraseRootFromParent_Done,
      // Label 199: @2708
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(2720), // Rule ID 172 //
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 200: @2720
      GIM_Reject,
    // Label 197: @2721
    GIM_Reject,
    // Label 193: @2722
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(2830),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(2777), // Rule ID 4858 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4858,
        GIR_EraseRootFromParent_Done,
      // Label 202: @2777
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(2817), // Rule ID 120 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 120,
        GIR_EraseRootFromParent_Done,
      // Label 203: @2817
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(2829), // Rule ID 119 //
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 119,
        GIR_Done,
      // Label 204: @2829
      GIM_Reject,
    // Label 201: @2830
    GIM_Reject,
    // Label 194: @2831
    GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(2939),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(2886), // Rule ID 4871 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4871,
        GIR_EraseRootFromParent_Done,
      // Label 206: @2886
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(2926), // Rule ID 640 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 640,
        GIR_EraseRootFromParent_Done,
      // Label 207: @2926
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(2938), // Rule ID 639 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 639,
        GIR_Done,
      // Label 208: @2938
      GIM_Reject,
    // Label 205: @2939
    GIM_Reject,
    // Label 195: @2940
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3210),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3006), // Rule ID 4879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4879,
        GIR_EraseRootFromParent_Done,
      // Label 210: @3006
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3061), // Rule ID 923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 923,
        GIR_EraseRootFromParent_Done,
      // Label 211: @3061
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3080), // Rule ID 922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 922,
        GIR_Done,
      // Label 212: @3080
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(3135), // Rule ID 4867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4867,
        GIR_EraseRootFromParent_Done,
      // Label 213: @3135
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3190), // Rule ID 309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 309,
        GIR_EraseRootFromParent_Done,
      // Label 214: @3190
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3209), // Rule ID 308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 308,
        GIR_Done,
      // Label 215: @3209
      GIM_Reject,
    // Label 209: @3210
    GIM_Reject,
    // Label 196: @3211
    GIM_Reject,
    // Label 8: @3212
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 220*/ GIMT_Encode4(3845),
    /*GILLT_s1*//*Label 216*/ GIMT_Encode4(3247),
    /*GILLT_s32*//*Label 217*/ GIMT_Encode4(3356),
    /*GILLT_s64*//*Label 218*/ GIMT_Encode4(3465), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 219*/ GIMT_Encode4(3574),
    // Label 216: @3247
    GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3355),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3302), // Rule ID 4865 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4865,
        GIR_EraseRootFromParent_Done,
      // Label 222: @3302
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3342), // Rule ID 180 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 180,
        GIR_EraseRootFromParent_Done,
      // Label 223: @3342
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3354), // Rule ID 174 //
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CROR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 224: @3354
      GIM_Reject,
    // Label 221: @3355
    GIM_Reject,
    // Label 217: @3356
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3464),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3411), // Rule ID 4859 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4859,
        GIR_EraseRootFromParent_Done,
      // Label 226: @3411
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3451), // Rule ID 123 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 123,
        GIR_EraseRootFromParent_Done,
      // Label 227: @3451
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3463), // Rule ID 121 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 121,
        GIR_Done,
      // Label 228: @3463
      GIM_Reject,
    // Label 225: @3464
    GIM_Reject,
    // Label 218: @3465
    GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3573),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3520), // Rule ID 4872 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4872,
        GIR_EraseRootFromParent_Done,
      // Label 230: @3520
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3560), // Rule ID 643 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 643,
        GIR_EraseRootFromParent_Done,
      // Label 231: @3560
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3572), // Rule ID 641 //
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 641,
        GIR_Done,
      // Label 232: @3572
      GIM_Reject,
    // Label 229: @3573
    GIM_Reject,
    // Label 219: @3574
    GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3844),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3640), // Rule ID 4882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4882,
        GIR_EraseRootFromParent_Done,
      // Label 234: @3640
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3695), // Rule ID 936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 936,
        GIR_EraseRootFromParent_Done,
      // Label 235: @3695
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3714), // Rule ID 925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 925,
        GIR_Done,
      // Label 236: @3714
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3769), // Rule ID 4870 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4870,
        GIR_EraseRootFromParent_Done,
      // Label 237: @3769
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3824), // Rule ID 486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VORC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 486,
        GIR_EraseRootFromParent_Done,
      // Label 238: @3824
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3843), // Rule ID 383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 239: @3843
      GIM_Reject,
    // Label 233: @3844
    GIM_Reject,
    // Label 220: @3845
    GIM_Reject,
    // Label 9: @3846
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 244*/ GIMT_Encode4(5349),
    /*GILLT_s1*//*Label 240*/ GIMT_Encode4(3881),
    /*GILLT_s32*//*Label 241*/ GIMT_Encode4(4152),
    /*GILLT_s64*//*Label 242*/ GIMT_Encode4(4407), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 243*/ GIMT_Encode4(4662),
    // Label 240: @3881
    GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4151),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(3938), // Rule ID 173 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i1] } (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRNAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 173,
        GIR_EraseRootFromParent_Done,
      // Label 246: @3938
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(3980), // Rule ID 176 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i1] } (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CRNOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRNOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 176,
        GIR_EraseRootFromParent_Done,
      // Label 247: @3980
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4020), // Rule ID 4862 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRB)  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_RootToRootCopy, /*OpIdx*/2, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4862,
        GIR_EraseRootFromParent_Done,
      // Label 248: @4020
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4062), // Rule ID 177 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB), -1:{ *:[i1] })  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 177,
        GIR_EraseRootFromParent_Done,
      // Label 249: @4062
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4102), // Rule ID 4863 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] }))  =>  (CREQV:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CREQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRA
        GIR_RootToRootCopy, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4863,
        GIR_EraseRootFromParent_Done,
      // Label 250: @4102
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4120), // Rule ID 178 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } i1:{ *:[i1] }:$CRA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRNOT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // CRA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 178,
        GIR_EraseRootFromParent_Done,
      // Label 251: @4120
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4138), // Rule ID 2887 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$in, -1:{ *:[i1] })  =>  (CRNOT:{ *:[i1] } ?:{ *:[i1] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRNOT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2887,
        GIR_EraseRootFromParent_Done,
      // Label 252: @4138
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4150), // Rule ID 175 //
        // (xor:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRXOR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 253: @4150
      GIM_Reject,
    // Label 245: @4151
    GIM_Reject,
    // Label 241: @4152
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4406),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4209), // Rule ID 118 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NAND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 118,
        GIR_EraseRootFromParent_Done,
      // Label 255: @4209
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4251), // Rule ID 122 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 122,
        GIR_EraseRootFromParent_Done,
      // Label 256: @4251
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4291), // Rule ID 4860 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }), i32:{ *:[i32] }:$RB)  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4860,
        GIR_EraseRootFromParent_Done,
      // Label 257: @4291
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(4333), // Rule ID 124 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB), -1:{ *:[i32] })  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 124,
        GIR_EraseRootFromParent_Done,
      // Label 258: @4333
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4373), // Rule ID 4861 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, -1:{ *:[i32] }))  =>  (EQV:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4861,
        GIR_EraseRootFromParent_Done,
      // Label 259: @4373
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(4393), // Rule ID 1196 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } ?:{ *:[i32] }:$in, ?:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1196,
        GIR_EraseRootFromParent_Done,
      // Label 260: @4393
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(4405), // Rule ID 125 //
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (XOR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 261: @4405
      GIM_Reject,
    // Label 254: @4406
    GIM_Reject,
    // Label 242: @4407
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(4661),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(4464), // Rule ID 638 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NAND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NAND8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 638,
        GIR_EraseRootFromParent_Done,
      // Label 263: @4464
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(4506), // Rule ID 642 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NOR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 642,
        GIR_EraseRootFromParent_Done,
      // Label 264: @4506
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(4546), // Rule ID 4873 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }), i64:{ *:[i64] }:$RB)  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4873,
        GIR_EraseRootFromParent_Done,
      // Label 265: @4546
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(4588), // Rule ID 644 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB), -1:{ *:[i64] })  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 644,
        GIR_EraseRootFromParent_Done,
      // Label 266: @4588
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(4628), // Rule ID 4874 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, -1:{ *:[i64] }))  =>  (EQV8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::EQV8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RST
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4874,
        GIR_EraseRootFromParent_Done,
      // Label 267: @4628
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(4648), // Rule ID 1508 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$in, -1:{ *:[i64] })  =>  (NOR8:{ *:[i64] } ?:{ *:[i64] }:$in, ?:{ *:[i64] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NOR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootToRootCopy, /*OpIdx*/1, // in
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1508,
        GIR_EraseRootFromParent_Done,
      // Label 268: @4648
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(4660), // Rule ID 645 //
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (XOR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XOR8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 645,
        GIR_Done,
      // Label 269: @4660
      GIM_Reject,
    // Label 262: @4661
    GIM_Reject,
    // Label 243: @4662
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5348),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(4730), // Rule ID 934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLNAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 934,
        GIR_EraseRootFromParent_Done,
      // Label 271: @4730
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(4787), // Rule ID 924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 924,
        GIR_EraseRootFromParent_Done,
      // Label 272: @4787
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(4842), // Rule ID 4880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XB)  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4880,
        GIR_EraseRootFromParent_Done,
      // Label 273: @4842
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(4899), // Rule ID 933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB), immAllOnesV:{ *:[v4i32] })  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 933,
        GIR_EraseRootFromParent_Done,
      // Label 274: @4899
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(4954), // Rule ID 4881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, immAllOnesV:{ *:[v4i32] }))  =>  (XXLEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XA
        GIR_RootToRootCopy, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4881,
        GIR_EraseRootFromParent_Done,
      // Label 275: @4954
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(4991), // Rule ID 1569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, immAllOnesV:{ *:[v4i32] })  =>  (XXLNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // A
        GIR_RootToRootCopy, /*OpIdx*/1, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1569,
        GIR_EraseRootFromParent_Done,
      // Label 276: @4991
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5010), // Rule ID 926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLXOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 926,
        GIR_Done,
      // Label 277: @5010
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5067), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 485,
        GIR_EraseRootFromParent_Done,
      // Label 278: @5067
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5124), // Rule ID 382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 382,
        GIR_EraseRootFromParent_Done,
      // Label 279: @5124
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(5179), // Rule ID 4868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VB)  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4868,
        GIR_EraseRootFromParent_Done,
      // Label 280: @5179
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(5236), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB), immAllOnesV:{ *:[v4i32] })  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 484,
        GIR_EraseRootFromParent_Done,
      // Label 281: @5236
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(5291), // Rule ID 4869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, immAllOnesV:{ *:[v4i32] }))  =>  (VEQV:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VA
        GIR_RootToRootCopy, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4869,
        GIR_EraseRootFromParent_Done,
      // Label 282: @5291
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(5328), // Rule ID 1365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })  =>  (VNOR:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1365,
        GIR_EraseRootFromParent_Done,
      // Label 283: @5328
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(5347), // Rule ID 384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VXOR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VXOR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 384,
        GIR_Done,
      // Label 284: @5347
      GIM_Reject,
    // Label 270: @5348
    GIM_Reject,
    // Label 244: @5349
    GIM_Reject,
    // Label 10: @5350
    GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(5650),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(5493), // Rule ID 2111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXPERMDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2111,
        GIR_EraseRootFromParent_Done,
      // Label 286: @5493
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(5615), // Rule ID 2114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$A, i64:{ *:[i64] }:$B)  =>  (XXPERMDI:{ *:[v2i64] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$B), sub_64:{ *:[i32] }), (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXPERMDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2114,
        GIR_EraseRootFromParent_Done,
      // Label 287: @5615
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(5630), // Rule ID 2857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rB, i64:{ *:[i64] }:$rA)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRDD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2857,
        GIR_Done,
      // Label 288: @5630
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(5649), // Rule ID 2861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian),
        // (build_vector:{ *:[v2i64] } i64:{ *:[i64] }:$rA, i64:{ *:[i64] }:$rB)  =>  (MTVSRDD:{ *:[v2i64] } ?:{ *:[i64] }:$rB, ?:{ *:[i64] }:$rA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRDD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // rB
        GIR_RootToRootCopy, /*OpIdx*/1, // rA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2861,
        GIR_EraseRootFromParent_Done,
      // Label 289: @5649
      GIM_Reject,
    // Label 285: @5650
    GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(6175),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(5715), // Rule ID 2025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt5NonZero),
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_immSExt5NonZero>>:$A)  =>  (VSPLTISW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSPLTISW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2025,
        GIR_EraseRootFromParent_Done,
      // Label 291: @5715
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(5766), // Rule ID 3358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i32immNonAllOneNonZero),
        // MIs[1] Operand 1
        // No operand predicates
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A, (imm:{ *:[i32] })<<P:Predicate_i32immNonAllOneNonZero>>:$A)  =>  (XXSPLTIW:{ *:[v4i32] } (imm:{ *:[i32] }):$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSPLTIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3358,
        GIR_EraseRootFromParent_Done,
      // Label 292: @5766
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(5902), // Rule ID 1717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[2] A
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[3] A
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/4, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_FPTRUNC),
        // MIs[4] A
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (build_vector:{ *:[v4f32] } (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A), (fpround:{ *:[f32] } f64:{ *:[f64] }:$A))  =>  (XXSPLTW:{ *:[v4f32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (XSCVDPSP:{ *:[f64] } f64:{ *:[f64] }:$A), sub_64:{ *:[i32] }), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSP),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1717,
        GIR_EraseRootFromParent_Done,
      // Label 293: @5902
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(5960), // Rule ID 1718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$A)  =>  (XXSPLTW:{ *:[v4f32] } (XSCVDPSPN:{ *:[v4f32] } ?:{ *:[f32] }:$A), 0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSPN),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1718,
        GIR_EraseRootFromParent_Done,
      // Label 294: @5960
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(6049), // Rule ID 2113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRWZ),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2113,
        GIR_EraseRootFromParent_Done,
      // Label 295: @6049
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(6138), // Rule ID 2116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (XXSPLTW:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[v4i32] } 1:{ *:[i64] }, (MTVSRWZ:{ *:[f64] } ?:{ *:[i32] }:$A), sub_64:{ *:[i32] }), 1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::MTVSRWZ),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(PPC::VSFRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSPLTW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2116,
        GIR_EraseRootFromParent_Done,
      // Label 296: @6138
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(6174), // Rule ID 2247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] A
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A, i32:{ *:[i32] }:$A)  =>  (MTVSRWS:{ *:[v4i32] } ?:{ *:[i32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2247,
        GIR_EraseRootFromParent_Done,
      // Label 297: @6174
      GIM_Reject,
    // Label 290: @6175
    GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(6316), // Rule ID 2248 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immNonAllOneAnyExt8),
      // MIs[1] Operand 1
      // No operand predicates
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] A
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A, (imm:{ *:[i32] })<<P:Predicate_immNonAllOneAnyExt8>>:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXSPLTIB:{ *:[v4i32] } (imm:{ *:[i32] }):$A), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXSPLTIB),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 2248,
      GIR_EraseRootFromParent_Done,
    // Label 298: @6316
    GIM_Reject,
    // Label 11: @6317
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(8), /*)*//*default:*//*Label 306*/ GIMT_Encode4(8593),
    /*GILLT_s32*//*Label 299*/ GIMT_Encode4(6356),
    /*GILLT_s64*//*Label 300*/ GIMT_Encode4(6429),
    /*GILLT_s128*//*Label 301*/ GIMT_Encode4(6477),
    /*GILLT_v2s64*//*Label 302*/ GIMT_Encode4(6881),
    /*GILLT_v4s32*//*Label 303*/ GIMT_Encode4(7443),
    /*GILLT_v8s16*//*Label 304*/ GIMT_Encode4(7994),
    /*GILLT_v16s8*//*Label 305*/ GIMT_Encode4(8322),
    // Label 299: @6356
    GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(6428), // Rule ID 2011 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (bitconvert:{ *:[i32] } f32:{ *:[f32] }:$A)  =>  (MFVSRWZ:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f64] } (XSCVDPSPN:{ *:[v4i32] } ?:{ *:[f32] }:$A), sub_64:{ *:[i32] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSPN),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // A
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_64),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(PPC::VSRCRegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRWZ),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2011,
      GIR_EraseRootFromParent_Done,
    // Label 307: @6428
    GIM_Reject,
    // Label 300: @6429
    GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(6476),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(6456), // Rule ID 2013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (bitconvert:{ *:[i64] } f64:{ *:[f64] }:$A)  =>  (MFVSRD:{ *:[i64] } ?:{ *:[f64] }:$A)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2013,
        GIR_Done,
      // Label 309: @6456
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(6475), // Rule ID 2014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (bitconvert:{ *:[f64] } i64:{ *:[i64] }:$S)  =>  (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$S)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2014,
        GIR_Done,
      // Label 310: @6475
      GIM_Reject,
    // Label 308: @6476
    GIM_Reject,
    // Label 301: @6477
    GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(6534), // Rule ID 1917 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (bitconvert:{ *:[v1i128] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1917,
      GIR_EraseRootFromParent_Done,
    // Label 311: @6534
    GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(6560), // Rule ID 1604 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v1i128] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1604,
      GIR_Done,
    // Label 312: @6560
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(6592), // Rule ID 1319 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1319,
      GIR_EraseRootFromParent_Done,
    // Label 313: @6592
    GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6624), // Rule ID 1320 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1320,
      GIR_EraseRootFromParent_Done,
    // Label 314: @6624
    GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6656), // Rule ID 1321 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1321,
      GIR_EraseRootFromParent_Done,
    // Label 315: @6656
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6688), // Rule ID 1322 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1322,
      GIR_EraseRootFromParent_Done,
    // Label 316: @6688
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6720), // Rule ID 1323 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v1i128] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v1i128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1323,
      GIR_EraseRootFromParent_Done,
    // Label 317: @6720
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(6752), // Rule ID 1324 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1324,
      GIR_EraseRootFromParent_Done,
    // Label 318: @6752
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(6784), // Rule ID 1325 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1325,
      GIR_EraseRootFromParent_Done,
    // Label 319: @6784
    GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(6816), // Rule ID 1326 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1326,
      GIR_EraseRootFromParent_Done,
    // Label 320: @6816
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(6848), // Rule ID 1327 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1327,
      GIR_EraseRootFromParent_Done,
    // Label 321: @6848
    GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(6880), // Rule ID 1328 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[f128] } VRRC:{ *:[v2f64] }:$src)  =>  VRRC:{ *:[f128] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1328,
      GIR_EraseRootFromParent_Done,
    // Label 322: @6880
    GIM_Reject,
    // Label 302: @6881
    GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(6938), // Rule ID 1918 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (bitconvert:{ *:[v2i64] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1918,
      GIR_EraseRootFromParent_Done,
    // Label 323: @6938
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(6964), // Rule ID 1585 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1585,
      GIR_Done,
    // Label 324: @6964
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(6990), // Rule ID 1586 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1586,
      GIR_Done,
    // Label 325: @6990
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(7016), // Rule ID 1587 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1587,
      GIR_Done,
    // Label 326: @7016
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(7042), // Rule ID 1588 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1588,
      GIR_Done,
    // Label 327: @7042
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(7068), // Rule ID 1593 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4f32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1593,
      GIR_Done,
    // Label 328: @7068
    GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(7094), // Rule ID 1594 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v4i32] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1594,
      GIR_Done,
    // Label 329: @7094
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(7120), // Rule ID 1595 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1595,
      GIR_Done,
    // Label 330: @7120
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(7146), // Rule ID 1596 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1596,
      GIR_Done,
    // Label 331: @7146
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(7172), // Rule ID 1601 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 332: @7172
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(7198), // Rule ID 1602 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 333: @7198
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7224), // Rule ID 1603 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } v1i128:{ *:[v1i128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } ?:{ *:[v1i128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 334: @7224
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7250), // Rule ID 1605 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1605,
      GIR_Done,
    // Label 335: @7250
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7282), // Rule ID 1314 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1314,
      GIR_EraseRootFromParent_Done,
    // Label 336: @7282
    GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7314), // Rule ID 1315 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1315,
      GIR_EraseRootFromParent_Done,
    // Label 337: @7314
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(7346), // Rule ID 1316 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1316,
      GIR_EraseRootFromParent_Done,
    // Label 338: @7346
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(7378), // Rule ID 1317 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1317,
      GIR_EraseRootFromParent_Done,
    // Label 339: @7378
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(7410), // Rule ID 1318 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2i64] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1318,
      GIR_EraseRootFromParent_Done,
    // Label 340: @7410
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(7442), // Rule ID 1333 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v2f64] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1333,
      GIR_EraseRootFromParent_Done,
    // Label 341: @7442
    GIM_Reject,
    // Label 303: @7443
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(7479), // Rule ID 935 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (bitconvert:{ *:[v4i32] } immAllOnesV:{ *:[v16i8] })  =>  (XXLEQVOnes:{ *:[v4i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 935,
      GIR_EraseRootFromParent_Done,
    // Label 342: @7479
    GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(7505), // Rule ID 1589 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1589,
      GIR_Done,
    // Label 343: @7505
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(7531), // Rule ID 1590 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1590,
      GIR_Done,
    // Label 344: @7531
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(7557), // Rule ID 1597 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1597,
      GIR_Done,
    // Label 345: @7557
    GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(7583), // Rule ID 1598 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1598,
      GIR_Done,
    // Label 346: @7583
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(7609), // Rule ID 1606 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1606,
      GIR_Done,
    // Label 347: @7609
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(7641), // Rule ID 1304 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1304,
      GIR_EraseRootFromParent_Done,
    // Label 348: @7641
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(7673), // Rule ID 1305 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1305,
      GIR_EraseRootFromParent_Done,
    // Label 349: @7673
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(7705), // Rule ID 1306 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1306,
      GIR_EraseRootFromParent_Done,
    // Label 350: @7705
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(7737), // Rule ID 1307 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1307,
      GIR_EraseRootFromParent_Done,
    // Label 351: @7737
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(7769), // Rule ID 1308 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1308,
      GIR_EraseRootFromParent_Done,
    // Label 352: @7769
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(7801), // Rule ID 1309 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1309,
      GIR_EraseRootFromParent_Done,
    // Label 353: @7801
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(7833), // Rule ID 1310 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1310,
      GIR_EraseRootFromParent_Done,
    // Label 354: @7833
    GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(7865), // Rule ID 1311 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1311,
      GIR_EraseRootFromParent_Done,
    // Label 355: @7865
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(7897), // Rule ID 1312 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1312,
      GIR_EraseRootFromParent_Done,
    // Label 356: @7897
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(7929), // Rule ID 1313 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1313,
      GIR_EraseRootFromParent_Done,
    // Label 357: @7929
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(7961), // Rule ID 1331 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4i32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1331,
      GIR_EraseRootFromParent_Done,
    // Label 358: @7961
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(7993), // Rule ID 1332 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v4f32] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1332,
      GIR_EraseRootFromParent_Done,
    // Label 359: @7993
    GIM_Reject,
    // Label 304: @7994
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(8051), // Rule ID 1919 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
      GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (bitconvert:{ *:[v8i16] } immAllOnesV:{ *:[v16i8] })  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXLEQVOnes:{ *:[v4i32] }), VSRC:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLEQVOnes),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
      // GIR_Coverage, 1919,
      GIR_EraseRootFromParent_Done,
    // Label 360: @8051
    GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(8077), // Rule ID 1591 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1591,
      GIR_Done,
    // Label 361: @8077
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(8103), // Rule ID 1599 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1599,
      GIR_Done,
    // Label 362: @8103
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(8129), // Rule ID 1607 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1607,
      GIR_Done,
    // Label 363: @8129
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(8161), // Rule ID 1299 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v16i8] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1299,
      GIR_EraseRootFromParent_Done,
    // Label 364: @8161
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(8193), // Rule ID 1300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1300,
      GIR_EraseRootFromParent_Done,
    // Label 365: @8193
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(8225), // Rule ID 1301 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1301,
      GIR_EraseRootFromParent_Done,
    // Label 366: @8225
    GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(8257), // Rule ID 1302 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1302,
      GIR_EraseRootFromParent_Done,
    // Label 367: @8257
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(8289), // Rule ID 1303 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1303,
      GIR_EraseRootFromParent_Done,
    // Label 368: @8289
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(8321), // Rule ID 1330 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v8i16] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1330,
      GIR_EraseRootFromParent_Done,
    // Label 369: @8321
    GIM_Reject,
    // Label 305: @8322
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(8348), // Rule ID 1592 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2f64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1592,
      GIR_Done,
    // Label 370: @8348
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(8374), // Rule ID 1600 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[v2i64] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1600,
      GIR_Done,
    // Label 371: @8374
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(8400), // Rule ID 1608 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } f128:{ *:[f128] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } ?:{ *:[f128] }:$A, VRRC:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1608,
      GIR_Done,
    // Label 372: @8400
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(8432), // Rule ID 1294 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v8i16] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1294,
      GIR_EraseRootFromParent_Done,
    // Label 373: @8432
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(8464), // Rule ID 1295 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4i32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1295,
      GIR_EraseRootFromParent_Done,
    // Label 374: @8464
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(8496), // Rule ID 1296 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v4f32] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1296,
      GIR_EraseRootFromParent_Done,
    // Label 375: @8496
    GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(8528), // Rule ID 1297 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v2i64] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1297,
      GIR_EraseRootFromParent_Done,
    // Label 376: @8528
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(8560), // Rule ID 1298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[v1i128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1298,
      GIR_EraseRootFromParent_Done,
    // Label 377: @8560
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(8592), // Rule ID 1329 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (bitconvert:{ *:[v16i8] } VRRC:{ *:[f128] }:$src)  =>  VRRC:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
      // GIR_Coverage, 1329,
      GIR_EraseRootFromParent_Done,
    // Label 378: @8592
    GIM_Reject,
    // Label 306: @8593
    GIM_Reject,
    // Label 12: @8594
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 384*/ GIMT_Encode4(8865),
    /*GILLT_s32*//*Label 379*/ GIMT_Encode4(8625),
    /*GILLT_s64*//*Label 380*/ GIMT_Encode4(8715),
    /*GILLT_s128*//*Label 381*/ GIMT_Encode4(8763),
    /*GILLT_v2s64*//*Label 382*/ GIMT_Encode4(8794),
    /*GILLT_v4s32*//*Label 383*/ GIMT_Encode4(8817),
    // Label 379: @8625
    GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(8714),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(8694), // Rule ID 1695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPIZ:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSRDPIZ),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
        // GIR_Coverage, 1695,
        GIR_EraseRootFromParent_Done,
      // Label 386: @8694
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(8713), // Rule ID 147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (ftrunc:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRIZS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIZS),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 387: @8713
      GIM_Reject,
    // Label 385: @8714
    GIM_Reject,
    // Label 380: @8715
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(8762),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(8742), // Rule ID 905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPIZ:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRDPIZ),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 905,
        GIR_Done,
      // Label 389: @8742
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(8761), // Rule ID 145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (ftrunc:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIZD:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIZD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 390: @8761
      GIM_Reject,
    // Label 388: @8762
    GIM_Reject,
    // Label 381: @8763
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(8793), // Rule ID 2144 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (ftrunc:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 1:{ *:[i32] }, ?:{ *:[f128] }:$vB, 1:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSRQPI),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VRT]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_RootToRootCopy, /*OpIdx*/1, // vB
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2144,
      GIR_EraseRootFromParent_Done,
    // Label 391: @8793
    GIM_Reject,
    // Label 382: @8794
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(8816), // Rule ID 913 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (ftrunc:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPIZ:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRDPIZ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 913,
      GIR_Done,
    // Label 392: @8816
    GIM_Reject,
    // Label 383: @8817
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(8864),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(8844), // Rule ID 921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSPIZ),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 921,
        GIR_Done,
      // Label 394: @8844
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(8863), // Rule ID 1404 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (ftrunc:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$vA)  =>  (VRFIZ:{ *:[v4f32] } ?:{ *:[v4f32] }:$vA)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VRFIZ),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1404,
        GIR_Done,
      // Label 395: @8863
      GIM_Reject,
    // Label 393: @8864
    GIM_Reject,
    // Label 384: @8865
    GIM_Reject,
    // Label 13: @8866
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 401*/ GIMT_Encode4(9112),
    /*GILLT_s32*//*Label 396*/ GIMT_Encode4(8897),
    /*GILLT_s64*//*Label 397*/ GIMT_Encode4(8987),
    /*GILLT_s128*//*Label 398*/ GIMT_Encode4(9035),
    /*GILLT_v2s64*//*Label 399*/ GIMT_Encode4(9066),
    /*GILLT_v4s32*//*Label 400*/ GIMT_Encode4(9089),
    // Label 396: @8897
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(8986),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(8966), // Rule ID 1689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$S)  =>  (COPY_TO_REGCLASS:{ *:[f32] } (XSRDPI:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, VSFRC:{ *:[i32] })), VSSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSRDPI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSSRCRegClassID),
        // GIR_Coverage, 1689,
        GIR_EraseRootFromParent_Done,
      // Label 403: @8966
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(8985), // Rule ID 139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (fround:{ *:[f32] } f32:{ *:[f32] }:$RB)  =>  (FRINS:{ *:[f32] } f32:{ *:[f32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRINS),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 139,
        GIR_Done,
      // Label 404: @8985
      GIM_Reject,
    // Label 402: @8986
    GIM_Reject,
    // Label 397: @8987
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(9034),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(9014), // Rule ID 899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$XB)  =>  (XSRDPI:{ *:[f64] } f64:{ *:[f64] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XSRDPI),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 899,
        GIR_Done,
      // Label 406: @9014
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(9033), // Rule ID 137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (fround:{ *:[f64] } f64:{ *:[f64] }:$RB)  =>  (FRIND:{ *:[f64] } f64:{ *:[f64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::FRIND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 407: @9033
      GIM_Reject,
    // Label 405: @9034
    GIM_Reject,
    // Label 398: @9035
    GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(9065), // Rule ID 2142 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (fround:{ *:[f128] } f128:{ *:[f128] }:$vB)  =>  (XSRQPI:{ *:[f128] } 0:{ *:[i32] }, ?:{ *:[f128] }:$vB, 0:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSRQPI),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VRT]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // vB
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2142,
      GIR_EraseRootFromParent_Done,
    // Label 408: @9065
    GIM_Reject,
    // Label 399: @9066
    GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(9088), // Rule ID 907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (fround:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)  =>  (XVRDPI:{ *:[v2f64] } v2f64:{ *:[v2f64] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRDPI),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 409: @9088
    GIM_Reject,
    // Label 400: @9089
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(9111), // Rule ID 915 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
      // (fround:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)  =>  (XVRSPI:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XVRSPI),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 915,
      GIR_Done,
    // Label 410: @9111
    GIM_Reject,
    // Label 401: @9112
    GIM_Reject,
    // Label 14: @9113
    GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(9240),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 414*/ GIMT_Encode4(9239),
      /*GILLT_s32*//*Label 412*/ GIMT_Encode4(9140),
      /*GILLT_s64*//*Label 413*/ GIMT_Encode4(9198),
      // Label 412: @9140
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(9197), // Rule ID 2016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (lrint:{ *:[i64] } f32:{ *:[f32] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, F8RC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2016,
        GIR_EraseRootFromParent_Done,
      // Label 415: @9197
      GIM_Reject,
      // Label 413: @9198
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(9238), // Rule ID 2015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (lrint:{ *:[i64] } f64:{ *:[f64] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } ?:{ *:[f64] }:$S))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2015,
        GIR_EraseRootFromParent_Done,
      // Label 416: @9238
      GIM_Reject,
      // Label 414: @9239
      GIM_Reject,
    // Label 411: @9240
    GIM_Reject,
    // Label 15: @9241
    GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(9368),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_SwitchType, /*MI*/0, /*Op*/1, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 420*/ GIMT_Encode4(9367),
      /*GILLT_s32*//*Label 418*/ GIMT_Encode4(9268),
      /*GILLT_s64*//*Label 419*/ GIMT_Encode4(9326),
      // Label 418: @9268
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(9325), // Rule ID 2018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (llrint:{ *:[i64] } f32:{ *:[f32] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f32] }:$S, F8RC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2018,
        GIR_EraseRootFromParent_Done,
      // Label 421: @9325
      GIM_Reject,
      // Label 419: @9326
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(9366), // Rule ID 2017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDirectMove_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (llrint:{ *:[i64] } f64:{ *:[f64] }:$S)  =>  (MFVSRD:{ *:[i64] } (FCTID:{ *:[f64] } ?:{ *:[f64] }:$S))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // S
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2017,
        GIR_EraseRootFromParent_Done,
      // Label 422: @9366
      GIM_Reject,
      // Label 420: @9367
      GIM_Reject,
    // Label 417: @9368
    GIM_Reject,
    // Label 16: @9369
    GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(9388), // Rule ID 632 //
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (readcyclecounter:{ *:[i64] })  =>  (MFTB8:{ *:[i64] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MFTB8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 632,
      GIR_Done,
    // Label 423: @9388
    GIM_Reject,
    // Label 17: @9389
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 426*/ GIMT_Encode4(9464),
    /*GILLT_s32*//*Label 424*/ GIMT_Encode4(9408),
    /*GILLT_s64*//*Label 425*/ GIMT_Encode4(9436),
    // Label 424: @9408
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(9435), // Rule ID 1254 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i32] }, (timm:{ *:[i32] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1254,
      GIR_EraseRootFromParent_Done,
    // Label 427: @9435
    GIM_Reject,
    // Label 425: @9436
    GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(9463), // Rule ID 1253 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/0, 7,
      // MIs[0] Operand 1
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      // (atomic_fence 7:{ *:[i64] }, (timm:{ *:[i64] }))  =>  (SYNC 0:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1253,
      GIR_EraseRootFromParent_Done,
    // Label 428: @9463
    GIM_Reject,
    // Label 426: @9464
    GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(9513),
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckIsImm, /*MI*/0, /*Op*/1,
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(9495), // Rule ID 1255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1255,
        GIR_EraseRootFromParent_Done,
      // Label 430: @9495
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(9512), // Rule ID 1256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        // (atomic_fence (timm:{ *:[iPTR] }), (timm:{ *:[iPTR] }))  =>  (MSYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1256,
        GIR_EraseRootFromParent_Done,
      // Label 431: @9512
      GIM_Reject,
    // Label 429: @9513
    GIM_Reject,
    // Label 18: @9514
    GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(9576),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s1,
      GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(9563), // Rule ID 17 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (brcond (xor:{ *:[i1] } i1:{ *:[i1] }:$BI, -1:{ *:[i1] }), (bb:{ *:[Other] }):$BD)  =>  (BCn i1:{ *:[i1] }:$BI, (bb:{ *:[Other] }):$BD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::BCn),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // BI
        GIR_RootToRootCopy, /*OpIdx*/1, // BD
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17,
        GIR_EraseRootFromParent_Done,
      // Label 433: @9563
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(9575), // Rule ID 16 //
        // (brcond i1:{ *:[i1] }:$BI, (bb:{ *:[Other] }):$BD)  =>  (BC i1:{ *:[i1] }:$BI, (bb:{ *:[Other] }):$BD)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::BC),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16,
        GIR_Done,
      // Label 434: @9575
      GIM_Reject,
    // Label 432: @9576
    GIM_Reject,
    // Label 19: @9577
    GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(9698),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(9612), // Rule ID 1155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxsetaccz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9994:{ *:[iPTR] })  =>  (XXSETACCZ:{ *:[v512i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSETACCZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1155,
        GIR_EraseRootFromParent_Done,
      // Label 436: @9612
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(9639), // Rule ID 1156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxsetaccz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9994:{ *:[iPTR] })  =>  (XXSETACCZW:{ *:[v512i1] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSETACCZW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1156,
        GIR_EraseRootFromParent_Done,
      // Label 437: @9639
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(9663), // Rule ID 4847 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mfmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9926:{ *:[iPTR] })  =>  (MFMSR:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFMSR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4847,
        GIR_EraseRootFromParent_Done,
      // Label 438: @9663
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(9697), // Rule ID 4848 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mftbu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9928:{ *:[iPTR] })  =>  (MFTB:{ *:[i32] } 269:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(269),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4848,
        GIR_EraseRootFromParent_Done,
      // Label 439: @9697
      GIM_Reject,
    // Label 435: @9698
    GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(13211),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(9742), // Rule ID 1737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9901:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XB)  =>  (XSRSQRTEDP:{ *:[f64] } ?:{ *:[f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSRSQRTEDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1737,
        GIR_EraseRootFromParent_Done,
      // Label 441: @9742
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(9778), // Rule ID 1928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrtes),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9902:{ *:[iPTR] }, vssrc:{ *:[f32] }:$XB)  =>  (XSRSQRTESP:{ *:[f32] } ?:{ *:[f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSRSQRTESP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1928,
        GIR_EraseRootFromParent_Done,
      // Label 442: @9778
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(9810), // Rule ID 866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10087:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSP:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVDPSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 866,
        GIR_EraseRootFromParent_Done,
      // Label 443: @9810
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(9842), // Rule ID 869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpsxws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10088:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPSXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVDPSXWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 869,
        GIR_EraseRootFromParent_Done,
      // Label 444: @9842
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(9874), // Rule ID 872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvdpuxws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10089:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCVDPUXWS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVDPUXWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 872,
        GIR_EraseRootFromParent_Done,
      // Label 445: @9874
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(9906), // Rule ID 873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10092:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPDP:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSPDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 873,
        GIR_EraseRootFromParent_Done,
      // Label 446: @9906
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(9938), // Rule ID 874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspsxds),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10094:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPSXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSPSXDS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 874,
        GIR_EraseRootFromParent_Done,
      // Label 447: @9938
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(9970), // Rule ID 877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspuxds),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10095:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPUXDS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSPUXDS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 877,
        GIR_EraseRootFromParent_Done,
      // Label 448: @9970
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(10002), // Rule ID 882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsxdsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10096:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVSXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSXDSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 882,
        GIR_EraseRootFromParent_Done,
      // Label 449: @10002
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(10034), // Rule ID 887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvuxdsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10098:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XB)  =>  (XVCVUXDSP:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVUXDSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 887,
        GIR_EraseRootFromParent_Done,
      // Label 450: @10034
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(10066), // Rule ID 890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsxwdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10097:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVSXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSXWDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 890,
        GIR_EraseRootFromParent_Done,
      // Label 451: @10066
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(10098), // Rule ID 891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvuxwdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10099:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XB)  =>  (XVCVUXWDP:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVUXWDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 891,
        GIR_EraseRootFromParent_Done,
      // Label 452: @10098
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(10130), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_sqrtf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 10023:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSSQRTQPO:{ *:[f128] } f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSSQRTQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 999,
        GIR_EraseRootFromParent_Done,
      // Label 453: @10130
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(10162), // Rule ID 1006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_truncf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 10050:{ *:[iPTR] }, f128:{ *:[f128] }:$RB)  =>  (XSCVQPDPO:{ *:[f64] } f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVQPDPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1006,
        GIR_EraseRootFromParent_Done,
      // Label 454: @10162
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(10194), // Rule ID 1015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvsphp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10093:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCVSPHP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVSPHP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1015,
        GIR_EraseRootFromParent_Done,
      // Label 455: @10194
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(10226), // Rule ID 1019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxexpdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10121:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXEXPDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVXEXPDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1019,
        GIR_EraseRootFromParent_Done,
      // Label 456: @10226
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(10258), // Rule ID 1020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxexpsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10122:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXEXPSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVXEXPSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1020,
        GIR_EraseRootFromParent_Done,
      // Label 457: @10258
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(10290), // Rule ID 1021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxsigdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10123:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB)  =>  (XVXSIGDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVXSIGDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1021,
        GIR_EraseRootFromParent_Done,
      // Label 458: @10290
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(10322), // Rule ID 1022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvxsigsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10124:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB)  =>  (XVXSIGSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVXSIGSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1022,
        GIR_EraseRootFromParent_Done,
      // Label 459: @10322
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(10377), // Rule ID 1645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtsqrtdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10117:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTDP:{ *:[i32] } ?:{ *:[v2f64] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTSQRTDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        // GIR_Coverage, 1645,
        GIR_EraseRootFromParent_Done,
      // Label 460: @10377
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(10432), // Rule ID 1646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtsqrtsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10118:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTSQRTSP:{ *:[i32] } ?:{ *:[v4f32] }:$A), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTSQRTSP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        // GIR_Coverage, 1646,
        GIR_EraseRootFromParent_Done,
      // Label 461: @10432
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(10464), // Rule ID 1647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvresp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10110:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVRESP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1647,
        GIR_EraseRootFromParent_Done,
      // Label 462: @10464
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(10496), // Rule ID 1648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvredp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10109:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVREDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVREDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1648,
        GIR_EraseRootFromParent_Done,
      // Label 463: @10496
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(10528), // Rule ID 1649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvrsqrtesp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10113:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A)  =>  (XVRSQRTESP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVRSQRTESP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1649,
        GIR_EraseRootFromParent_Done,
      // Label 464: @10528
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(10560), // Rule ID 1650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvrsqrtedp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10112:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A)  =>  (XVRSQRTEDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVRSQRTEDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1650,
        GIR_EraseRootFromParent_Done,
      // Label 465: @10560
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(10592), // Rule ID 1736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fre),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9899:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSREDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSREDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1736,
        GIR_EraseRootFromParent_Done,
      // Label 466: @10592
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(10624), // Rule ID 1738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9894:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSNABSDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSNABSDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1738,
        GIR_EraseRootFromParent_Done,
      // Label 467: @10624
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(10656), // Rule ID 1739 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9895:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSNABSDPs:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSNABSDPs),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1739,
        GIR_EraseRootFromParent_Done,
      // Label 468: @10656
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(10688), // Rule ID 1923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fres),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9900:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (XSRESP:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSRESP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1923,
        GIR_EraseRootFromParent_Done,
      // Label 469: @10688
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(10769), // Rule ID 1924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_extract_exp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9879:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (EXTRACT_SUBREG:{ *:[i32] } (XSXEXPDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] })), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSXEXPDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::G8RCRegClassID),
        // GIR_Coverage, 1924,
        GIR_EraseRootFromParent_Done,
      // Label 470: @10769
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(10820), // Rule ID 1925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_extract_sig),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9880:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSXSIGDP:{ *:[i64] } (COPY_TO_REGCLASS:{ *:[f64] } ?:{ *:[f64] }:$A, VSFRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSXSIGDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1925,
        GIR_EraseRootFromParent_Done,
      // Label 471: @10820
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(10871), // Rule ID 2138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvhpsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10090:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A)  =>  (XVCVHPSP:{ *:[v4f32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCVHPSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2138,
        GIR_EraseRootFromParent_Done,
      // Label 472: @10871
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(10951), // Rule ID 2152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_scalar_extract_expq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10014:{ *:[iPTR] }, f128:{ *:[f128] }:$vA)  =>  (MFVSRD:{ *:[i64] } (EXTRACT_SUBREG:{ *:[f64] } (XSXEXPQP:{ *:[v2i64] } ?:{ *:[f128] }:$vA), sub_64:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(PPC::XSXEXPQP),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // vA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_64),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(PPC::VFRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(PPC::VRRCRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2152,
        GIR_EraseRootFromParent_Done,
      // Label 473: @10951
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(10994), // Rule ID 1085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9548:{ *:[iPTR] }, (imm:{ *:[i64] }):$D)  =>  (MTVSRBMI:{ *:[v16i8] } (imm:{ *:[i64] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRBMI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1085,
        GIR_EraseRootFromParent_Done,
      // Label 474: @10994
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(11027), // Rule ID 4805 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9901:{ *:[iPTR] }, f8rc:{ *:[f64] }:$frB)  =>  (FRSQRTE:{ *:[f64] } ?:{ *:[f64] }:$frB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FRSQRTE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // frB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4805,
        GIR_EraseRootFromParent_Done,
      // Label 475: @11027
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(11060), // Rule ID 4806 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_frsqrtes),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9902:{ *:[iPTR] }, f4rc:{ *:[f32] }:$frB)  =>  (FRSQRTES:{ *:[f32] } ?:{ *:[f32] }:$frB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FRSQRTES),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // frB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4806,
        GIR_EraseRootFromParent_Done,
      // Label 476: @11060
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(11089), // Rule ID 73 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_popcntb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10009:{ *:[iPTR] }, i32:{ *:[i32] }:$RST)  =>  (POPCNTB:{ *:[i32] } i32:{ *:[i32] }:$RST)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::POPCNTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73,
        GIR_EraseRootFromParent_Done,
      // Label 477: @11089
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(11121), // Rule ID 318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexptefp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9655:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VEXPTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPTEFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 318,
        GIR_EraseRootFromParent_Done,
      // Label 478: @11121
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(11153), // Rule ID 319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vlogefp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9693:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VLOGEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VLOGEFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 319,
        GIR_EraseRootFromParent_Done,
      // Label 479: @11153
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(11185), // Rule ID 360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrefp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9761:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VREFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VREFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 360,
        GIR_EraseRootFromParent_Done,
      // Label 480: @11185
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(11217), // Rule ID 361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfim),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9762:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIM:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRFIM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 361,
        GIR_EraseRootFromParent_Done,
      // Label 481: @11217
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(11249), // Rule ID 362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfin),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9763:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIN:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRFIN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 362,
        GIR_EraseRootFromParent_Done,
      // Label 482: @11249
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(11281), // Rule ID 363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfip),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9764:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRFIP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 363,
        GIR_EraseRootFromParent_Done,
      // Label 483: @11281
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(11313), // Rule ID 364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrfiz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9765:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRFIZ:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRFIZ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 364,
        GIR_EraseRootFromParent_Done,
      // Label 484: @11313
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(11345), // Rule ID 365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrsqrtefp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9776:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB)  =>  (VRSQRTEFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRSQRTEFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 365,
        GIR_EraseRootFromParent_Done,
      // Label 485: @11345
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(11377), // Rule ID 416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhpx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9818:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKHPX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 416,
        GIR_EraseRootFromParent_Done,
      // Label 486: @11377
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(11409), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9819:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKHSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKHSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 417,
        GIR_EraseRootFromParent_Done,
      // Label 487: @11409
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(11441), // Rule ID 418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9820:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKHSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKHSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 418,
        GIR_EraseRootFromParent_Done,
      // Label 488: @11441
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(11473), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklpx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9822:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLPX:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKLPX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 419,
        GIR_EraseRootFromParent_Done,
      // Label 489: @11473
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(11505), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9823:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VUPKLSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKLSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 420,
        GIR_EraseRootFromParent_Done,
      // Label 490: @11505
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(11537), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9824:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VUPKLSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKLSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 421,
        GIR_EraseRootFromParent_Done,
      // Label 491: @11537
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(11569), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupkhsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9821:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKHSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKHSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 501,
        GIR_EraseRootFromParent_Done,
      // Label 492: @11569
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(11601), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vupklsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9825:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VUPKLSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VUPKLSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 502,
        GIR_EraseRootFromParent_Done,
      // Label 493: @11601
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(11633), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vgbbd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9675:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VGBBD:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VGBBD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 503,
        GIR_EraseRootFromParent_Done,
      // Label 494: @11633
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(11665), // Rule ID 511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vsbox),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9530:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA)  =>  (VSBOX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSBOX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 511,
        GIR_EraseRootFromParent_Done,
      // Label 495: @11665
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(11697), // Rule ID 527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclzlsbb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9585:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCLZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCLZLSBB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 527,
        GIR_EraseRootFromParent_Done,
      // Label 496: @11697
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(11729), // Rule ID 528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctzlsbb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9643:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VCTZLSBB:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTZLSBB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 528,
        GIR_EraseRootFromParent_Done,
      // Label 497: @11729
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(11761), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsb2w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9670:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2W:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSB2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 533,
        GIR_EraseRootFromParent_Done,
      // Label 498: @11761
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(11793), // Rule ID 534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsh2w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9673:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2W:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSH2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 534,
        GIR_EraseRootFromParent_Done,
      // Label 499: @11793
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(11825), // Rule ID 535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsb2d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9669:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTSB2D:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSB2D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 535,
        GIR_EraseRootFromParent_Done,
      // Label 500: @11825
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(11857), // Rule ID 536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsh2d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9672:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTSH2D:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSH2D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 536,
        GIR_EraseRootFromParent_Done,
      // Label 501: @11857
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(11889), // Rule ID 537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsw2d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9674:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTSW2D:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSW2D),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 537,
        GIR_EraseRootFromParent_Done,
      // Label 502: @11889
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(11921), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9760:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VPRTYBW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPRTYBW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 540,
        GIR_EraseRootFromParent_Done,
      // Label 503: @11921
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(11953), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9758:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VPRTYBD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPRTYBD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 541,
        GIR_EraseRootFromParent_Done,
      // Label 504: @11953
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(11985), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vprtybq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9759:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VPRTYBQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPRTYBQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 542,
        GIR_EraseRootFromParent_Done,
      // Label 505: @11985
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(12014), // Rule ID 686 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_popcntb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10009:{ *:[iPTR] }, i64:{ *:[i64] }:$RST)  =>  (POPCNTB8:{ *:[i64] } i64:{ *:[i64] }:$RST)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::POPCNTB8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 686,
        GIR_EraseRootFromParent_Done,
      // Label 506: @12014
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(12046), // Rule ID 1050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstribr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9797:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBR:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSTRIBR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1050,
        GIR_EraseRootFromParent_Done,
      // Label 507: @12046
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(12078), // Rule ID 1051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstribl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9795:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VSTRIBL:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSTRIBL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1051,
        GIR_EraseRootFromParent_Done,
      // Label 508: @12078
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(12110), // Rule ID 1052 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstrihr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9801:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHR:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSTRIHR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1052,
        GIR_EraseRootFromParent_Done,
      // Label 509: @12110
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(12142), // Rule ID 1053 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vstrihl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9799:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VSTRIHL:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSTRIHL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1053,
        GIR_EraseRootFromParent_Done,
      // Label 510: @12142
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(12174), // Rule ID 1070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9664:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXTRACTBM:{ *:[i32] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTBM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1070,
        GIR_EraseRootFromParent_Done,
      // Label 511: @12174
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(12206), // Rule ID 1071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextracthm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9666:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXTRACTHM:{ *:[i32] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1071,
        GIR_EraseRootFromParent_Done,
      // Label 512: @12206
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(12238), // Rule ID 1072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractwm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9668:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXTRACTWM:{ *:[i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTWM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1072,
        GIR_EraseRootFromParent_Done,
      // Label 513: @12238
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(12270), // Rule ID 1073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9665:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTRACTDM:{ *:[i32] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1073,
        GIR_EraseRootFromParent_Done,
      // Label 514: @12270
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(12302), // Rule ID 1074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextractqm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9667:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXTRACTQM:{ *:[i32] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTRACTQM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1074,
        GIR_EraseRootFromParent_Done,
      // Label 515: @12302
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(12334), // Rule ID 1075 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9650:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB)  =>  (VEXPANDBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPANDBM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1075,
        GIR_EraseRootFromParent_Done,
      // Label 516: @12334
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(12366), // Rule ID 1076 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandhm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9652:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB)  =>  (VEXPANDHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPANDHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1076,
        GIR_EraseRootFromParent_Done,
      // Label 517: @12366
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(12398), // Rule ID 1077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandwm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9654:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VEXPANDWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPANDWM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1077,
        GIR_EraseRootFromParent_Done,
      // Label 518: @12398
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(12430), // Rule ID 1078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpanddm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9651:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXPANDDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPANDDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1078,
        GIR_EraseRootFromParent_Done,
      // Label 519: @12430
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(12462), // Rule ID 1079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vexpandqm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9653:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB)  =>  (VEXPANDQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXPANDQM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1079,
        GIR_EraseRootFromParent_Done,
      // Label 520: @12462
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(12494), // Rule ID 1080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9548:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRBM:{ *:[v16i8] } i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRBM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1080,
        GIR_EraseRootFromParent_Done,
      // Label 521: @12494
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(12526), // Rule ID 1081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrhm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9550:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRHM:{ *:[v8i16] } i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1081,
        GIR_EraseRootFromParent_Done,
      // Label 522: @12526
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(12558), // Rule ID 1082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrwm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9552:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRWM:{ *:[v4i32] } i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRWM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1082,
        GIR_EraseRootFromParent_Done,
      // Label 523: @12558
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(12590), // Rule ID 1083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9549:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRDM:{ *:[v2i64] } i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1083,
        GIR_EraseRootFromParent_Done,
      // Label 524: @12590
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(12622), // Rule ID 1084 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mtvsrqm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9551:{ *:[iPTR] }, i64:{ *:[i64] }:$VB)  =>  (MTVSRQM:{ *:[v1i128] } i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSRQM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1084,
        GIR_EraseRootFromParent_Done,
      // Label 525: @12622
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(12654), // Rule ID 1148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextsd2q),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9671:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VEXTSD2Q:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTSD2Q),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1148,
        GIR_EraseRootFromParent_Done,
      // Label 526: @12654
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(12686), // Rule ID 1153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxmfacc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9992:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$AT)  =>  (XXMFACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$AT)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXMFACC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[ATo]
        GIR_RootToRootCopy, /*OpIdx*/2, // AT
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1153,
        GIR_EraseRootFromParent_Done,
      // Label 527: @12686
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(12718), // Rule ID 1154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xxmtacc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9993:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi)  =>  (XXMTACC:{ *:[v512i1] } v512i1:{ *:[v512i1] }:$ATi)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXMTACC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1154,
        GIR_EraseRootFromParent_Done,
      // Label 528: @12718
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(12747), // Rule ID 1269 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fre),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9899:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FRE:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FRE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1269,
        GIR_EraseRootFromParent_Done,
      // Label 529: @12747
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(12776), // Rule ID 1270 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fres),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9900:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FRES:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FRES),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1270,
        GIR_EraseRootFromParent_Done,
      // Label 530: @12776
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(12805), // Rule ID 1271 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9894:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FNABSD:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FNABSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1271,
        GIR_EraseRootFromParent_Done,
      // Label 531: @12805
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(12834), // Rule ID 1272 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnabss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9895:{ *:[iPTR] }, f32:{ *:[f32] }:$A)  =>  (FNABSS:{ *:[f32] } ?:{ *:[f32] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FNABSS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1272,
        GIR_EraseRootFromParent_Done,
      // Label 532: @12834
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(12906), // Rule ID 3340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvspbf16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 10091:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVSPBF16:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVCVSPBF16),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3340,
        GIR_EraseRootFromParent_Done,
      // Label 533: @12906
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(12978), // Rule ID 3341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcvbf16spn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 10086:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XVCVBF16SPN:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] })), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVCVBF16SPN),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3341,
        GIR_EraseRootFromParent_Done,
      // Label 534: @12978
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(13007), // Rule ID 4839 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fcfid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9881:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVSXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVSXDDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4839,
        GIR_EraseRootFromParent_Done,
      // Label 535: @13007
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(13036), // Rule ID 4840 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fcfud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9882:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVUXDDP:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVUXDDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4840,
        GIR_EraseRootFromParent_Done,
      // Label 536: @13036
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(13065), // Rule ID 4841 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9883:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTID:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FCTID),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4841,
        GIR_EraseRootFromParent_Done,
      // Label 537: @13065
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(13094), // Rule ID 4842 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctidz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9884:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSXDS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4842,
        GIR_EraseRootFromParent_Done,
      // Label 538: @13094
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(13123), // Rule ID 4843 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctiw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9885:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (FCTIW:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FCTIW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4843,
        GIR_EraseRootFromParent_Done,
      // Label 539: @13123
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(13152), // Rule ID 4844 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctiwz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9886:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPSXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVDPSXWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4844,
        GIR_EraseRootFromParent_Done,
      // Label 540: @13152
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(13181), // Rule ID 4845 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctudz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9887:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXDS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVDPUXDS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4845,
        GIR_EraseRootFromParent_Done,
      // Label 541: @13181
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(13210), // Rule ID 4846 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fctuwz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9888:{ *:[iPTR] }, f64:{ *:[f64] }:$A)  =>  (XSCVDPUXWS:{ *:[f64] } ?:{ *:[f64] }:$A)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSCVDPUXWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4846,
        GIR_EraseRootFromParent_Done,
      // Label 542: @13210
      GIM_Reject,
    // Label 440: @13211
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(21409),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(13290), // Rule ID 2154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxextractuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 10130:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXEXTRACTUW:{ *:[f64] } ?:{ *:[v2i64] }:$A, (imm:{ *:[i32] }):$IMM), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXEXTRACTUW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        // GIR_Coverage, 2154,
        GIR_EraseRootFromParent_Done,
      // Label 544: @13290
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(13327), // Rule ID 1023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtstdcsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 10120:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCSP:{ *:[v4i32] } (timm:{ *:[i32] }):$DCMX, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVTSTDCSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/3, // DCMX
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1023,
        GIR_EraseRootFromParent_Done,
      // Label 545: @13327
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(13364), // Rule ID 1024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtstdcdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] DCMX
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 10119:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XB, (timm:{ *:[i32] }):$DCMX)  =>  (XVTSTDCDP:{ *:[v2i64] } (timm:{ *:[i32] }):$DCMX, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVTSTDCDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/3, // DCMX
        GIR_RootToRootCopy, /*OpIdx*/2, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1024,
        GIR_EraseRootFromParent_Done,
      // Label 546: @13364
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(13409), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xsmaxdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 10072:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMAXDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMAXDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 892,
        GIR_EraseRootFromParent_Done,
      // Label 547: @13409
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(13454), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xsmindp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 10073:{ *:[iPTR] }, vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)  =>  (XSMINDP:{ *:[f64] } vsfrc:{ *:[f64] }:$XA, vsfrc:{ *:[f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMINDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 893,
        GIR_EraseRootFromParent_Done,
      // Label 548: @13454
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(13499), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmaxdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10104:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMAXDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVMAXDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 894,
        GIR_EraseRootFromParent_Done,
      // Label 549: @13499
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(13544), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmindp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10106:{ *:[iPTR] }, vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)  =>  (XVMINDP:{ *:[v2f64] } vsrc:{ *:[v2f64] }:$XA, vsrc:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVMINDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 895,
        GIR_EraseRootFromParent_Done,
      // Label 550: @13544
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(13589), // Rule ID 896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvmaxsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10105:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMAXSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVMAXSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 896,
        GIR_EraseRootFromParent_Done,
      // Label 551: @13589
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(13634), // Rule ID 897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvminsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10107:{ *:[iPTR] }, vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)  =>  (XVMINSP:{ *:[v4f32] } vsrc:{ *:[v4f32] }:$XA, vsrc:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVMINSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 897,
        GIR_EraseRootFromParent_Done,
      // Label 552: @13634
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(13671), // Rule ID 821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpeqdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10074:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPEQDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPEQDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 821,
        GIR_EraseRootFromParent_Done,
      // Label 553: @13671
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(13708), // Rule ID 823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpeqsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10076:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPEQSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPEQSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 823,
        GIR_EraseRootFromParent_Done,
      // Label 554: @13708
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(13745), // Rule ID 825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgedp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10078:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGEDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPGEDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 825,
        GIR_EraseRootFromParent_Done,
      // Label 555: @13745
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(13782), // Rule ID 827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgesp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10080:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGESP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPGESP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 827,
        GIR_EraseRootFromParent_Done,
      // Label 556: @13782
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(13819), // Rule ID 829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgtdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10082:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)  =>  (XVCMPGTDP:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$XA, v2f64:{ *:[v2f64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPGTDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 829,
        GIR_EraseRootFromParent_Done,
      // Label 557: @13819
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(13856), // Rule ID 831 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvcmpgtsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10084:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)  =>  (XVCMPGTSP:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$XA, v4f32:{ *:[v4f32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVCMPGTSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 831,
        GIR_EraseRootFromParent_Done,
      // Label 558: @13856
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(13893), // Rule ID 995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_addf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9519:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSADDQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 995,
        GIR_EraseRootFromParent_Done,
      // Label 559: @13893
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(13930), // Rule ID 996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 10001:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSMULQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMULQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 996,
        GIR_EraseRootFromParent_Done,
      // Label 560: @13930
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(13967), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_subf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 10032:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSSUBQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 997,
        GIR_EraseRootFromParent_Done,
      // Label 561: @13967
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(14004), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9875:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)  =>  (XSDIVQPO:{ *:[f128] } f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSDIVQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 998,
        GIR_EraseRootFromParent_Done,
      // Label 562: @14004
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(14041), // Rule ID 1017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xviexpdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10102:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)  =>  (XVIEXPDP:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVIEXPDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1017,
        GIR_EraseRootFromParent_Done,
      // Label 563: @14041
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(14078), // Rule ID 1018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xviexpsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10103:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XVIEXPSP:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVIEXPSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1018,
        GIR_EraseRootFromParent_Done,
      // Label 564: @14078
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(14115), // Rule ID 1641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvdivsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 10101:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (XVDIVSP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVDIVSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1641,
        GIR_EraseRootFromParent_Done,
      // Label 565: @14115
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(14152), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvdivdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 10100:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (XVDIVDP:{ *:[v2f64] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVDIVDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1642,
        GIR_EraseRootFromParent_Done,
      // Label 566: @14152
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(14214), // Rule ID 1643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtdivdp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10114:{ *:[iPTR] }, v2f64:{ *:[v2f64] }:$A, v2f64:{ *:[v2f64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVDP:{ *:[i32] } ?:{ *:[v2f64] }:$A, ?:{ *:[v2f64] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTDIVDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        // GIR_Coverage, 1643,
        GIR_EraseRootFromParent_Done,
      // Label 567: @14214
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(14276), // Rule ID 1644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtdivsp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10115:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (XVTDIVSP:{ *:[i32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B), GPRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTDIVSP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        // GIR_Coverage, 1644,
        GIR_EraseRootFromParent_Done,
      // Label 568: @14276
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(14313), // Rule ID 1888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxleqv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10136:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B)  =>  (XXLEQV:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLEQV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1888,
        GIR_EraseRootFromParent_Done,
      // Label 569: @14313
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(14392), // Rule ID 1926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_insert_exp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9910:{ *:[iPTR] }, f64:{ *:[f64] }:$A, i64:{ *:[i64] }:$B)  =>  (COPY_TO_REGCLASS:{ *:[f64] } (XSIEXPDP:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[i64] } ?:{ *:[f64] }:$A, G8RC:{ *:[i32] }), ?:{ *:[i64] }:$B), F8RC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XSIEXPDP),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::F8RCRegClassID),
        // GIR_Coverage, 1926,
        GIR_EraseRootFromParent_Done,
      // Label 570: @14392
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(14448), // Rule ID 2151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_scalar_insert_exp_qp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 10015:{ *:[iPTR] }, f128:{ *:[f128] }:$vA, i64:{ *:[i64] }:$vB)  =>  (XSIEXPQP:{ *:[f128] } ?:{ *:[f128] }:$vA, (MTVSRD:{ *:[f64] } ?:{ *:[i64] }:$vB))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::MTVSRD),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // vB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSIEXPQP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2151,
        GIR_EraseRootFromParent_Done,
      // Label 571: @14448
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(14536), // Rule ID 3330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtlsbb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRRCRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 1,
        // (intrinsic_wo_chain:{ *:[i32] } 10116:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 1:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_lt:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTLSBB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_lt),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::CRRCRegClassID),
        // GIR_Coverage, 3330,
        GIR_EraseRootFromParent_Done,
      // Label 572: @14536
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(14624), // Rule ID 3331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xvtlsbb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRRCRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[i32] } 10116:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XB, 0:{ *:[i32] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (XVTLSBB:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] })), sub_eq:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XVTLSBB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_eq),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::CRRCRegClassID),
        // GIR_Coverage, 3331,
        GIR_EraseRootFromParent_Done,
      // Label 573: @14624
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(14667), // Rule ID 314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfsx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9579:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFSX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCFSX_0),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 314,
        GIR_EraseRootFromParent_Done,
      // Label 574: @14667
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(14710), // Rule ID 315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctuxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9641:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTUXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTUXS_0),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 315,
        GIR_EraseRootFromParent_Done,
      // Label 575: @14710
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(14753), // Rule ID 316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfux),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9581:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, 0:{ *:[i32] })  =>  (VCFUX_0:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCFUX_0),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 316,
        GIR_EraseRootFromParent_Done,
      // Label 576: @14753
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(14796), // Rule ID 317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctsxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] Operand 3
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/3, GIMT_Encode8(0),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9640:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, 0:{ *:[i32] })  =>  (VCTSXS_0:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTSXS_0),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 317,
        GIR_EraseRootFromParent_Done,
      // Label 577: @14796
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(14867), // Rule ID 3326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 10131:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXGENPCVBM:{ *:[v4i32] } ?:{ *:[v16i8] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVBM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3326,
        GIR_EraseRootFromParent_Done,
      // Label 578: @14867
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(14938), // Rule ID 3327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvhm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 10133:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXGENPCVHM:{ *:[v4i32] } ?:{ *:[v8i16] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVHM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3327,
        GIR_EraseRootFromParent_Done,
      // Label 579: @14938
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(15009), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvwm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 10134:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (XXGENPCVWM:{ *:[v4i32] } ?:{ *:[v4i32] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVWM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3328,
        GIR_EraseRootFromParent_Done,
      // Label 580: @15009
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(15080), // Rule ID 3329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxgenpcvdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i64] } 10132:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (XXGENPCVDM:{ *:[v4i32] } ?:{ *:[v2i64] }:$VRB, (imm:{ *:[i32] }):$IMM), VRRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXGENPCVDM),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // VRB
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/1, // IMM
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VRRCRegClassID),
        // GIR_Coverage, 3329,
        GIR_EraseRootFromParent_Done,
      // Label 581: @15080
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(15117), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfsx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 9579:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFSX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCFSX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 310,
        GIR_EraseRootFromParent_Done,
      // Label 582: @15117
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(15154), // Rule ID 311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfux),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4f32] } 9581:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCFUX:{ *:[v4f32] } (timm:{ *:[i32] }):$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCFUX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 311,
        GIR_EraseRootFromParent_Done,
      // Label 583: @15154
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(15191), // Rule ID 312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctsxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9640:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTSXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTSXS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 312,
        GIR_EraseRootFromParent_Done,
      // Label 584: @15191
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(15228), // Rule ID 313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctuxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9641:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VCTUXS:{ *:[v4i32] } (timm:{ *:[i32] }):$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTUXS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 313,
        GIR_EraseRootFromParent_Done,
      // Label 585: @15228
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(15265), // Rule ID 1086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9636:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBB:{ *:[i64] } v16i8:{ *:[v16i8] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCNTMBB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootToRootCopy, /*OpIdx*/3, // MP
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1086,
        GIR_EraseRootFromParent_Done,
      // Label 586: @15265
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(15302), // Rule ID 1087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9638:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBH:{ *:[i64] } v8i16:{ *:[v8i16] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCNTMBH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootToRootCopy, /*OpIdx*/3, // MP
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1087,
        GIR_EraseRootFromParent_Done,
      // Label 587: @15302
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(15339), // Rule ID 1088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9639:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBW:{ *:[i64] } v4i32:{ *:[v4i32] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCNTMBW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootToRootCopy, /*OpIdx*/3, // MP
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1088,
        GIR_EraseRootFromParent_Done,
      // Label 588: @15339
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(15376), // Rule ID 1089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcntmbd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] MP
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9637:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)  =>  (VCNTMBD:{ *:[i64] } v2i64:{ *:[v2i64] }:$VB, (timm:{ *:[i32] }):$MP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCNTMBD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootToRootCopy, /*OpIdx*/3, // MP
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1089,
        GIR_EraseRootFromParent_Done,
      // Label 589: @15376
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(15413), // Rule ID 1103 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vgnb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] N
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[i64] } 9676:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)  =>  (VGNB:{ *:[i64] } v1i128:{ *:[v1i128] }:$VB, (timm:{ *:[i32] }):$N)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VGNB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootToRootCopy, /*OpIdx*/3, // N
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1103,
        GIR_EraseRootFromParent_Done,
      // Label 590: @15413
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(15458), // Rule ID 201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divwe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9876:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWE:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DIVWE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 201,
        GIR_EraseRootFromParent_Done,
      // Label 591: @15458
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(15503), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divweu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9877:{ *:[iPTR] }, gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)  =>  (DIVWEU:{ *:[i32] } gprc:{ *:[i32] }:$RA, gprc:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DIVWEU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 202,
        GIR_EraseRootFromParent_Done,
      // Label 592: @15503
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(15548), // Rule ID 683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBPERMD),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bpermd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9839:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)  =>  (BPERMD:{ *:[i64] } g8rc:{ *:[i64] }:$RST, g8rc:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::BPERMD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 683,
        GIR_EraseRootFromParent_Done,
      // Label 593: @15548
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(15593), // Rule ID 689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divde),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9873:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDE:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DIVDE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 689,
        GIR_EraseRootFromParent_Done,
      // Label 594: @15593
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(15638), // Rule ID 694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasExtDiv),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_divdeu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9874:{ *:[iPTR] }, g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)  =>  (DIVDEU:{ *:[i64] } g8rc:{ *:[i64] }:$RA, g8rc:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DIVDEU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 694,
        GIR_EraseRootFromParent_Done,
      // Label 595: @15638
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(15704), // Rule ID 1547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpeqb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9843:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPEQB:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::CMPEQB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SETB8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1547,
        GIR_EraseRootFromParent_Done,
      // Label 596: @15704
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(15770), // Rule ID 1548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_setb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10020:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (SETB8:{ *:[i64] } (CMPD:{ *:[i32] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::CMPD),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SETB8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1548,
        GIR_EraseRootFromParent_Done,
      // Label 597: @15770
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(15815), // Rule ID 1552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10002:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULHD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1552,
        GIR_EraseRootFromParent_Done,
      // Label 598: @15815
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(15860), // Rule ID 1553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhdu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10003:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (MULHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULHDU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1553,
        GIR_EraseRootFromParent_Done,
      // Label 599: @15860
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(15902), // Rule ID 1556 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9842:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b)  =>  (CMPB8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CMPB8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1556,
        GIR_EraseRootFromParent_Done,
      // Label 600: @15902
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(15944), // Rule ID 4825 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10004:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHW:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULHW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4825,
        GIR_EraseRootFromParent_Done,
      // Label 601: @15944
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(15986), // Rule ID 4826 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mulhwu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 10005:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (MULHWU:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULHWU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4826,
        GIR_EraseRootFromParent_Done,
      // Label 602: @15986
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(16028), // Rule ID 4827 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cmpb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 9842:{ *:[iPTR] }, gprc:{ *:[i32] }:$a, gprc:{ *:[i32] }:$b)  =>  (CMPB:{ *:[i32] } ?:{ *:[i32] }:$a, ?:{ *:[i32] }:$b)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CMPB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4827,
        GIR_EraseRootFromParent_Done,
      // Label 603: @16028
      GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(16065), // Rule ID 301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddcuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9562:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDCUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 301,
        GIR_EraseRootFromParent_Done,
      // Label 604: @16065
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(16102), // Rule ID 302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddsbs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9565:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDSBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 302,
        GIR_EraseRootFromParent_Done,
      // Label 605: @16102
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(16139), // Rule ID 303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddshs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9566:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDSHS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 303,
        GIR_EraseRootFromParent_Done,
      // Label 606: @16139
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(16176), // Rule ID 304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddsws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9567:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDSWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 304,
        GIR_EraseRootFromParent_Done,
      // Label 607: @16176
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(16213), // Rule ID 305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddubs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9568:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDUBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 305,
        GIR_EraseRootFromParent_Done,
      // Label 608: @16213
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(16250), // Rule ID 306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vadduhs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9569:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDUHS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 306,
        GIR_EraseRootFromParent_Done,
      // Label 609: @16250
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(16287), // Rule ID 307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vadduws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9570:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDUWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 307,
        GIR_EraseRootFromParent_Done,
      // Label 610: @16287
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(16324), // Rule ID 320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9571:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 320,
        GIR_EraseRootFromParent_Done,
      // Label 611: @16324
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(16361), // Rule ID 321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9572:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 321,
        GIR_EraseRootFromParent_Done,
      // Label 612: @16361
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(16398), // Rule ID 322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9573:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 322,
        GIR_EraseRootFromParent_Done,
      // Label 613: @16398
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(16435), // Rule ID 323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavgub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9574:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VAVGUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 323,
        GIR_EraseRootFromParent_Done,
      // Label 614: @16435
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(16472), // Rule ID 324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavguh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9575:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VAVGUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 324,
        GIR_EraseRootFromParent_Done,
      // Label 615: @16472
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(16509), // Rule ID 325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vavguw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9576:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAVGUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VAVGUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 325,
        GIR_EraseRootFromParent_Done,
      // Label 616: @16509
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(16546), // Rule ID 326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxfp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9695:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMAXFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 326,
        GIR_EraseRootFromParent_Done,
      // Label 617: @16546
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(16583), // Rule ID 327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9696:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 327,
        GIR_EraseRootFromParent_Done,
      // Label 618: @16583
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(16620), // Rule ID 328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9698:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 328,
        GIR_EraseRootFromParent_Done,
      // Label 619: @16620
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(16657), // Rule ID 329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9699:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 329,
        GIR_EraseRootFromParent_Done,
      // Label 620: @16657
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(16694), // Rule ID 330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9700:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMAXUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 330,
        GIR_EraseRootFromParent_Done,
      // Label 621: @16694
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(16731), // Rule ID 331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxuh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9702:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMAXUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 331,
        GIR_EraseRootFromParent_Done,
      // Label 622: @16731
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(16768), // Rule ID 332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9703:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMAXUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 332,
        GIR_EraseRootFromParent_Done,
      // Label 623: @16768
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(16805), // Rule ID 333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminfp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9706:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)  =>  (VMINFP:{ *:[v4f32] } v4f32:{ *:[v4f32] }:$VA, v4f32:{ *:[v4f32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 333,
        GIR_EraseRootFromParent_Done,
      // Label 624: @16805
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(16842), // Rule ID 334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9707:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINSB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 334,
        GIR_EraseRootFromParent_Done,
      // Label 625: @16842
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(16879), // Rule ID 335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9709:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINSH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 335,
        GIR_EraseRootFromParent_Done,
      // Label 626: @16879
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(16916), // Rule ID 336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9710:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 336,
        GIR_EraseRootFromParent_Done,
      // Label 627: @16916
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(16953), // Rule ID 337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9711:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMINUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 337,
        GIR_EraseRootFromParent_Done,
      // Label 628: @16953
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(16990), // Rule ID 338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminuh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9713:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMINUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 338,
        GIR_EraseRootFromParent_Done,
      // Label 629: @16990
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(17027), // Rule ID 339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9714:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMINUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 339,
        GIR_EraseRootFromParent_Done,
      // Label 630: @17027
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(17064), // Rule ID 352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9724:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULESB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULESB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 352,
        GIR_EraseRootFromParent_Done,
      // Label 631: @17064
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(17101), // Rule ID 353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9726:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULESH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULESH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 353,
        GIR_EraseRootFromParent_Done,
      // Label 632: @17101
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(17138), // Rule ID 354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9728:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULEUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULEUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 354,
        GIR_EraseRootFromParent_Done,
      // Label 633: @17138
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(17175), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleuh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9730:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULEUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULEUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 355,
        GIR_EraseRootFromParent_Done,
      // Label 634: @17175
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(17212), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9736:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOSB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 356,
        GIR_EraseRootFromParent_Done,
      // Label 635: @17212
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(17249), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9738:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOSH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 357,
        GIR_EraseRootFromParent_Done,
      // Label 636: @17249
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(17286), // Rule ID 358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuloub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9740:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VMULOUB:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 358,
        GIR_EraseRootFromParent_Done,
      // Label 637: @17286
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(17323), // Rule ID 359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulouh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9742:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VMULOUH:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 359,
        GIR_EraseRootFromParent_Done,
      // Label 638: @17323
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(17360), // Rule ID 366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubcuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9804:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBCUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBCUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 366,
        GIR_EraseRootFromParent_Done,
      // Label 639: @17360
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(17397), // Rule ID 371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubsbs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9807:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBSBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBSBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 371,
        GIR_EraseRootFromParent_Done,
      // Label 640: @17397
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(17434), // Rule ID 372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubshs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9808:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBSHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBSHS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 372,
        GIR_EraseRootFromParent_Done,
      // Label 641: @17434
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(17471), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubsws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9809:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBSWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 373,
        GIR_EraseRootFromParent_Done,
      // Label 642: @17471
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(17508), // Rule ID 374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsububs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9810:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBUBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 374,
        GIR_EraseRootFromParent_Done,
      // Label 643: @17508
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(17545), // Rule ID 375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubuhs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9811:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBUHS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 375,
        GIR_EraseRootFromParent_Done,
      // Label 644: @17545
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(17582), // Rule ID 376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubuws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9812:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBUWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 376,
        GIR_EraseRootFromParent_Done,
      // Label 645: @17582
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(17619), // Rule ID 385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9766:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 385,
        GIR_EraseRootFromParent_Done,
      // Label 646: @17619
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(17656), // Rule ID 386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9770:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VRLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 386,
        GIR_EraseRootFromParent_Done,
      // Label 647: @17656
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(17693), // Rule ID 387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9773:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 387,
        GIR_EraseRootFromParent_Done,
      // Label 648: @17693
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(17730), // Rule ID 388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9778:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 388,
        GIR_EraseRootFromParent_Done,
      // Label 649: @17730
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(17767), // Rule ID 389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslo),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9782:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 389,
        GIR_EraseRootFromParent_Done,
      // Label 650: @17767
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(17804), // Rule ID 390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9779:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 390,
        GIR_EraseRootFromParent_Done,
      // Label 651: @17804
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(17841), // Rule ID 391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9781:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSLH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 391,
        GIR_EraseRootFromParent_Done,
      // Label 652: @17841
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(17878), // Rule ID 392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9784:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSLW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 392,
        GIR_EraseRootFromParent_Done,
      // Label 653: @17878
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(17915), // Rule ID 396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9785:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSR:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 396,
        GIR_EraseRootFromParent_Done,
      // Label 654: @17915
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(17952), // Rule ID 397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsro),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9792:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRO:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 397,
        GIR_EraseRootFromParent_Done,
      // Label 655: @17952
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(17989), // Rule ID 398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrab),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9786:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRAB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 398,
        GIR_EraseRootFromParent_Done,
      // Label 656: @17989
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(18026), // Rule ID 399 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrah),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9787:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRAH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 399,
        GIR_EraseRootFromParent_Done,
      // Label 657: @18026
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(18063), // Rule ID 400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsraw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9788:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 400,
        GIR_EraseRootFromParent_Done,
      // Label 658: @18063
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(18100), // Rule ID 401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9789:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 401,
        GIR_EraseRootFromParent_Done,
      // Label 659: @18100
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(18137), // Rule ID 402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9791:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSRH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 402,
        GIR_EraseRootFromParent_Done,
      // Label 660: @18137
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(18174), // Rule ID 403 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9794:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSRW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 403,
        GIR_EraseRootFromParent_Done,
      // Label 661: @18174
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(18211), // Rule ID 407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkpx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9748:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKPX:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKPX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 407,
        GIR_EraseRootFromParent_Done,
      // Label 662: @18211
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(18248), // Rule ID 454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9727:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULESW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULESW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 454,
        GIR_EraseRootFromParent_Done,
      // Label 663: @18248
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(18285), // Rule ID 455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9731:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULEUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULEUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 455,
        GIR_EraseRootFromParent_Done,
      // Label 664: @18285
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(18322), // Rule ID 456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9739:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOSW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 456,
        GIR_EraseRootFromParent_Done,
      // Label 665: @18322
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(18359), // Rule ID 457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulouw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9743:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULOUW:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 457,
        GIR_EraseRootFromParent_Done,
      // Label 666: @18359
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(18396), // Rule ID 459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxsd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9697:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 459,
        GIR_EraseRootFromParent_Done,
      // Label 667: @18396
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(18433), // Rule ID 460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaxud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9701:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMAXUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMAXUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 460,
        GIR_EraseRootFromParent_Done,
      // Label 668: @18433
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(18470), // Rule ID 461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminsd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9708:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 461,
        GIR_EraseRootFromParent_Done,
      // Label 669: @18470
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(18507), // Rule ID 462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vminud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9712:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMINUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMINUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 462,
        GIR_EraseRootFromParent_Done,
      // Label 670: @18507
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(18544), // Rule ID 465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrld),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9767:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 465,
        GIR_EraseRootFromParent_Done,
      // Label 671: @18544
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(18581), // Rule ID 469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddcuq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9561:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDCUQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 469,
        GIR_EraseRootFromParent_Done,
      // Label 672: @18581
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(18618), // Rule ID 474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubcuq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9803:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBCUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBCUQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 474,
        GIR_EraseRootFromParent_Done,
      // Label 673: @18618
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(18655), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9526:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VPMSUMB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPMSUMB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 493,
        GIR_EraseRootFromParent_Done,
      // Label 674: @18655
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(18692), // Rule ID 494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9528:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPMSUMH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPMSUMH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 494,
        GIR_EraseRootFromParent_Done,
      // Label 675: @18692
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(18729), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9529:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPMSUMW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPMSUMW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 495,
        GIR_EraseRootFromParent_Done,
      // Label 676: @18729
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(18766), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpmsumd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9527:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPMSUMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPMSUMD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 496,
        GIR_EraseRootFromParent_Done,
      // Label 677: @18766
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(18803), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vbpermq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9578:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMQ:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VBPERMQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 504,
        GIR_EraseRootFromParent_Done,
      // Label 678: @18803
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(18840), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vcipher),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9520:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCIPHER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 507,
        GIR_EraseRootFromParent_Done,
      // Label 679: @18840
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(18877), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vcipherlast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9521:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCIPHERLAST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 508,
        GIR_EraseRootFromParent_Done,
      // Label 680: @18877
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(18914), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vncipher),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9522:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHER:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNCIPHER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 509,
        GIR_EraseRootFromParent_Done,
      // Label 681: @18914
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(18951), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vncipherlast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9523:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VNCIPHERLAST:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNCIPHERLAST),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 510,
        GIR_EraseRootFromParent_Done,
      // Label 682: @18951
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(18988), // Rule ID 543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vbpermd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9577:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VBPERMD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VBPERMD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 543,
        GIR_EraseRootFromParent_Done,
      // Label 683: @18988
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(19025), // Rule ID 544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlwnm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9775:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VRLWNM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLWNM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 544,
        GIR_EraseRootFromParent_Done,
      // Label 684: @19025
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(19062), // Rule ID 546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrldnm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9769:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VRLDNM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLDNM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 546,
        GIR_EraseRootFromParent_Done,
      // Label 685: @19062
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(19099), // Rule ID 548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vslv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9783:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSLV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 548,
        GIR_EraseRootFromParent_Done,
      // Label 686: @19099
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(19136), // Rule ID 549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrv),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9793:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSRV:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 549,
        GIR_EraseRootFromParent_Done,
      // Label 687: @19136
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(19173), // Rule ID 550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsdub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9558:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VABSDUB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VABSDUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 550,
        GIR_EraseRootFromParent_Done,
      // Label 688: @19173
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(19210), // Rule ID 551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsduh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9559:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VABSDUH:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VABSDUH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 551,
        GIR_EraseRootFromParent_Done,
      // Label 689: @19210
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(19247), // Rule ID 552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vabsduw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9560:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VABSDUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VABSDUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 552,
        GIR_EraseRootFromParent_Done,
      // Label 690: @19247
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(19284), // Rule ID 1098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpdepd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9745:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPDEPD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPDEPD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1098,
        GIR_EraseRootFromParent_Done,
      // Label 691: @19284
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(19321), // Rule ID 1099 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpextd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9747:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VPEXTD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPEXTD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1099,
        GIR_EraseRootFromParent_Done,
      // Label 692: @19321
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(19358), // Rule ID 1100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_pdepd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10007:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PDEPD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PDEPD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1100,
        GIR_EraseRootFromParent_Done,
      // Label 693: @19358
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(19395), // Rule ID 1101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_pextd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 10008:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (PEXTD:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PEXTD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1101,
        GIR_EraseRootFromParent_Done,
      // Label 694: @19395
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(19432), // Rule ID 1102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vcfuged),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9580:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCFUGED:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCFUGED),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1102,
        GIR_EraseRootFromParent_Done,
      // Label 695: @19432
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(19469), // Rule ID 1104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cfuged),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9841:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CFUGED:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CFUGED),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1104,
        GIR_EraseRootFromParent_Done,
      // Label 696: @19469
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(19506), // Rule ID 1106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclzdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9584:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCLZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCLZDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1106,
        GIR_EraseRootFromParent_Done,
      // Label 697: @19506
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(19543), // Rule ID 1107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vctzdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9642:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VCTZDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCTZDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1107,
        GIR_EraseRootFromParent_Done,
      // Label 698: @19543
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(19580), // Rule ID 1108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cntlzdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9846:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTLZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CNTLZDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1108,
        GIR_EraseRootFromParent_Done,
      // Label 699: @19580
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(19617), // Rule ID 1109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_cnttzdm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9847:{ *:[iPTR] }, i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (CNTTZDM:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CNTTZDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1109,
        GIR_EraseRootFromParent_Done,
      // Label 700: @19617
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(19654), // Rule ID 1110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclrlb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9582:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRLB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCLRLB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1110,
        GIR_EraseRootFromParent_Done,
      // Label 701: @19654
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(19691), // Rule ID 1111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vclrrb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9583:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VCLRRB:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VCLRRB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1111,
        GIR_EraseRootFromParent_Done,
      // Label 702: @19691
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(19728), // Rule ID 1125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9646:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVESW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVESW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1125,
        GIR_EraseRootFromParent_Done,
      // Label 703: @19728
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(19765), // Rule ID 1126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9649:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVEUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVEUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1126,
        GIR_EraseRootFromParent_Done,
      // Label 704: @19765
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(19802), // Rule ID 1127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9644:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVESD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVESD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1127,
        GIR_EraseRootFromParent_Done,
      // Label 705: @19802
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(19839), // Rule ID 1128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9647:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVEUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVEUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1128,
        GIR_EraseRootFromParent_Done,
      // Label 706: @19839
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(19876), // Rule ID 1131 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulesd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9725:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULESD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULESD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1131,
        GIR_EraseRootFromParent_Done,
      // Label 707: @19876
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(19913), // Rule ID 1132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuleud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9729:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULEUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULEUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1132,
        GIR_EraseRootFromParent_Done,
      // Label 708: @19913
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(19950), // Rule ID 1133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulosd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9737:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOSD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1133,
        GIR_EraseRootFromParent_Done,
      // Label 709: @19950
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(19987), // Rule ID 1134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmuloud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9741:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULOUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULOUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1134,
        GIR_EraseRootFromParent_Done,
      // Label 710: @19987
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(20024), // Rule ID 1138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdivesq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9645:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVESQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVESQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1138,
        GIR_EraseRootFromParent_Done,
      // Label 711: @20024
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(20061), // Rule ID 1139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vdiveuq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9648:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVEUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VDIVEUQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1139,
        GIR_EraseRootFromParent_Done,
      // Label 712: @20061
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(20098), // Rule ID 1149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlqnm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9772:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VRLQNM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLQNM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1149,
        GIR_EraseRootFromParent_Done,
      // Label 713: @20098
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(20135), // Rule ID 3322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9733:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHSW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULHSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3322,
        GIR_EraseRootFromParent_Done,
      // Label 714: @20135
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(20172), // Rule ID 3323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhuw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9735:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)  =>  (VMULHUW:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULHUW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3323,
        GIR_EraseRootFromParent_Done,
      // Label 715: @20172
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(20209), // Rule ID 3324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhsd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9732:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHSD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULHSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3324,
        GIR_EraseRootFromParent_Done,
      // Label 716: @20209
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(20246), // Rule ID 3325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmulhud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9734:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$vA, v2i64:{ *:[v2i64] }:$vB)  =>  (VMULHUD:{ *:[v2i64] } ?:{ *:[v2i64] }:$vA, ?:{ *:[v2i64] }:$vB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMULHUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3325,
        GIR_EraseRootFromParent_Done,
      // Label 717: @20246
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(20321), // Rule ID 3490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9987:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3490,
        GIR_EraseRootFromParent_Done,
      // Label 718: @20321
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(20396), // Rule ID 3492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9989:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3492,
        GIR_EraseRootFromParent_Done,
      // Label 719: @20396
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(20471), // Rule ID 3494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2s),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9985:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2S),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3494,
        GIR_EraseRootFromParent_Done,
      // Label 720: @20471
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(20546), // Rule ID 3496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9987:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3496,
        GIR_EraseRootFromParent_Done,
      // Label 721: @20546
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(20621), // Rule ID 3498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9989:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3498,
        GIR_EraseRootFromParent_Done,
      // Label 722: @20621
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(20696), // Rule ID 3500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2s),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9985:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3500,
        GIR_EraseRootFromParent_Done,
      // Label 723: @20696
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(20771), // Rule ID 3502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9968:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3502,
        GIR_EraseRootFromParent_Done,
      // Label 724: @20771
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(20846), // Rule ID 3507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9968:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3507,
        GIR_EraseRootFromParent_Done,
      // Label 725: @20846
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(20921), // Rule ID 3512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9973:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3512,
        GIR_EraseRootFromParent_Done,
      // Label 726: @20921
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(20977), // Rule ID 3517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9978:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3517,
        GIR_EraseRootFromParent_Done,
      // Label 727: @20977
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(21052), // Rule ID 3522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9963:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3522,
        GIR_EraseRootFromParent_Done,
      // Label 728: @21052
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(21127), // Rule ID 3527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9983:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3527,
        GIR_EraseRootFromParent_Done,
      // Label 729: @21127
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(21202), // Rule ID 3530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9973:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3530,
        GIR_EraseRootFromParent_Done,
      // Label 730: @21202
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(21258), // Rule ID 3535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9978:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3535,
        GIR_EraseRootFromParent_Done,
      // Label 731: @21258
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(21333), // Rule ID 3540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9963:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3540,
        GIR_EraseRootFromParent_Done,
      // Label 732: @21333
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(21408), // Rule ID 3545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9983:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3545,
        GIR_EraseRootFromParent_Done,
      // Label 733: @21408
      GIM_Reject,
    // Label 543: @21409
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(27845),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(21475), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmaf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s128,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[f128] } 9891:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, (fneg:{ *:[f128] } f128:{ *:[f128] }:$RSTi))  =>  (XSMSUBQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMSUBQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RSTi
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1001,
        GIR_EraseRootFromParent_Done,
      // Label 735: @21475
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(21528), // Rule ID 2153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxinsertw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 10135:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v2i64:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)  =>  (XXINSERTW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v2i64] }:$B, (imm:{ *:[i32] }):$IMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXINSERTW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // IMM
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2153,
        GIR_EraseRootFromParent_Done,
      // Label 736: @21528
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(21570), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmaf128_round_to_odd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f128] } 9891:{ *:[iPTR] }, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB, f128:{ *:[f128] }:$RSTi)  =>  (XSMADDQPO:{ *:[f128] } f128:{ *:[f128] }:$RSTi, f128:{ *:[f128] }:$RA, f128:{ *:[f128] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMADDQPO),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/4, // RSTi
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1000,
        GIR_EraseRootFromParent_Done,
      // Label 737: @21570
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(21612), // Rule ID 1734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9892:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSMSUBMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMSUBMDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1734,
        GIR_EraseRootFromParent_Done,
      // Label 738: @21612
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(21654), // Rule ID 1735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSFRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9896:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (XSNMADDMDP:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSNMADDMDP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1735,
        GIR_EraseRootFromParent_Done,
      // Label 739: @21654
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(21696), // Rule ID 1921 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsubs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9893:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSMSUBMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSMSUBMSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1921,
        GIR_EraseRootFromParent_Done,
      // Label 740: @21696
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(21738), // Rule ID 1922 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Vector_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadds),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9897:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (XSNMADDMSP:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XSNMADDMSP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1922,
        GIR_EraseRootFromParent_Done,
      // Label 741: @21738
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(21780), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vshasigmaw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9532:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSHASIGMAW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // ST
        GIR_RootToRootCopy, /*OpIdx*/4, // SIX
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 505,
        GIR_EraseRootFromParent_Done,
      // Label 742: @21780
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(21822), // Rule ID 506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Crypto),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vshasigmad),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] ST
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // MIs[0] SIX
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9531:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)  =>  (VSHASIGMAD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, (timm:{ *:[i32] }):$ST, (timm:{ *:[i32] }):$SIX)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSHASIGMAD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // ST
        GIR_RootToRootCopy, /*OpIdx*/4, // SIX
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 506,
        GIR_EraseRootFromParent_Done,
      // Label 743: @21822
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(21864), // Rule ID 1048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsldbi),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9780:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSLDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSLDBI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VRA
        GIR_RootToRootCopy, /*OpIdx*/3, // VRB
        GIR_RootToRootCopy, /*OpIdx*/4, // SD
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1048,
        GIR_EraseRootFromParent_Done,
      // Label 744: @21864
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(21906), // Rule ID 1049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsrdbi),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] SD
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9790:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)  =>  (VSRDBI:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VRA, v16i8:{ *:[v16i8] }:$VRB, (timm:{ *:[i32] }):$SD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSRDBI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // VRA
        GIR_RootToRootCopy, /*OpIdx*/3, // VRB
        GIR_RootToRootCopy, /*OpIdx*/4, // SD
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1049,
        GIR_EraseRootFromParent_Done,
      // Label 745: @21906
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(21948), // Rule ID 1054 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 9688:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, (timm:{ *:[i32] }):$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/4, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1054,
        GIR_EraseRootFromParent_Done,
      // Label 746: @21948
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(21990), // Rule ID 1055 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] VA
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 9681:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VB, (timm:{ *:[i32] }):$VA)  =>  (VINSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, (timm:{ *:[i32] }):$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/4, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1055,
        GIR_EraseRootFromParent_Done,
      // Label 747: @21990
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(22035), // Rule ID 1433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bcdadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9835:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDADD_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::BCDADD_rec),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootToRootCopy, /*OpIdx*/4, // PS
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CR6*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1433,
        GIR_EraseRootFromParent_Done,
      // Label 748: @22035
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(22080), // Rule ID 1434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_bcdsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // MIs[0] PS
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i8] } 9837:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$vA, v16i8:{ *:[v16i8] }:$vB, (timm:{ *:[i32] }):$PS)  =>  (BCDSUB_rec:{ *:[v16i8] }:{ *:[i32] } ?:{ *:[v16i8] }:$vA, ?:{ *:[v16i8] }:$vB, ?:{ *:[i32] }:$PS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::BCDSUB_rec),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_RootToRootCopy, /*OpIdx*/3, // vB
        GIR_RootToRootCopy, /*OpIdx*/4, // PS
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CR6*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1434,
        GIR_EraseRootFromParent_Done,
      // Label 749: @22080
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(22134), // Rule ID 1549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddhd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9919:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHD:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MADDHD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootToRootCopy, /*OpIdx*/4, // c
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1549,
        GIR_EraseRootFromParent_Done,
      // Label 750: @22134
      GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(22188), // Rule ID 1550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddhdu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9920:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDHDU:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MADDHDU),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootToRootCopy, /*OpIdx*/4, // c
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1550,
        GIR_EraseRootFromParent_Done,
      // Label 751: @22188
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(22242), // Rule ID 1551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_maddld),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 9921:{ *:[iPTR] }, g8rc:{ *:[i64] }:$a, g8rc:{ *:[i64] }:$b, g8rc:{ *:[i64] }:$c)  =>  (MADDLD8:{ *:[i64] } ?:{ *:[i64] }:$a, ?:{ *:[i64] }:$b, ?:{ *:[i64] }:$c)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MADDLD8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootToRootCopy, /*OpIdx*/4, // c
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1551,
        GIR_EraseRootFromParent_Done,
      // Label 752: @22242
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(22293), // Rule ID 4804 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fsel),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9903:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FRA, f8rc:{ *:[f64] }:$FRC, f8rc:{ *:[f64] }:$FRB)  =>  (FSELD:{ *:[f64] } ?:{ *:[f64] }:$FRA, ?:{ *:[f64] }:$FRC, ?:{ *:[f64] }:$FRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FSELD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // FRA
        GIR_RootToRootCopy, /*OpIdx*/3, // FRC
        GIR_RootToRootCopy, /*OpIdx*/4, // FRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4804,
        GIR_EraseRootFromParent_Done,
      // Label 753: @22293
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(22335), // Rule ID 293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmladduhm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9715:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)  =>  (VMLADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v8i16:{ *:[v8i16] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 293,
        GIR_EraseRootFromParent_Done,
      // Label 754: @22335
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(22377), // Rule ID 294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vperm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9746:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)  =>  (VPERM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v16i8:{ *:[v16i8] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPERM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 294,
        GIR_EraseRootFromParent_Done,
      // Label 755: @22377
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(22419), // Rule ID 295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsel),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9777:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VSEL:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 295,
        GIR_EraseRootFromParent_Done,
      // Label 756: @22419
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(22461), // Rule ID 346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsummbm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9717:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMMBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMMBM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 346,
        GIR_EraseRootFromParent_Done,
      // Label 757: @22461
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(22503), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumshm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9718:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMSHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMSHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 347,
        GIR_EraseRootFromParent_Done,
      // Label 758: @22503
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(22545), // Rule ID 348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumubm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9720:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUBM:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMUBM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 348,
        GIR_EraseRootFromParent_Done,
      // Label 759: @22545
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(22587), // Rule ID 349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumuhm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9722:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)  =>  (VMSUMUHM:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, v4i32:{ *:[v4i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMUHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 349,
        GIR_EraseRootFromParent_Done,
      // Label 760: @22587
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(22629), // Rule ID 468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddeuqm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9564:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDEUQM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 468,
        GIR_EraseRootFromParent_Done,
      // Label 761: @22629
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(22671), // Rule ID 470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vaddecuq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9563:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VADDECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VADDECUQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 470,
        GIR_EraseRootFromParent_Done,
      // Label 762: @22671
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(22713), // Rule ID 473 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubeuqm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9806:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBEUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBEUQM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 473,
        GIR_EraseRootFromParent_Done,
      // Label 763: @22713
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(22755), // Rule ID 475 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsubecuq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9805:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VSUBECUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$RA, v1i128:{ *:[v1i128] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUBECUQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 475,
        GIR_EraseRootFromParent_Done,
      // Label 764: @22755
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(22797), // Rule ID 512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumudm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9721:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMUDM:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMUDM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 512,
        GIR_EraseRootFromParent_Done,
      // Label 765: @22797
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(22839), // Rule ID 545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlwmi),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9774:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)  =>  (VRLWMI:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB, v4i32:{ *:[v4i32] }:$VDi)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLWMI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootToRootCopy, /*OpIdx*/4, // VDi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 545,
        GIR_EraseRootFromParent_Done,
      // Label 766: @22839
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(22881), // Rule ID 547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrldmi),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9768:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)  =>  (VRLDMI:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB, v2i64:{ *:[v2i64] }:$VDi)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLDMI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootToRootCopy, /*OpIdx*/4, // VDi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 547,
        GIR_EraseRootFromParent_Done,
      // Label 767: @22881
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(22923), // Rule ID 1056 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9679:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSBVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1056,
        GIR_EraseRootFromParent_Done,
      // Label 768: @22923
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(22965), // Rule ID 1057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9680:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VINSBVRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, v16i8:{ *:[v16i8] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSBVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1057,
        GIR_EraseRootFromParent_Done,
      // Label 769: @22965
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(23007), // Rule ID 1058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9686:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSHVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1058,
        GIR_EraseRootFromParent_Done,
      // Label 770: @23007
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(23049), // Rule ID 1059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9687:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VINSHVRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSHVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1059,
        GIR_EraseRootFromParent_Done,
      // Label 771: @23049
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(23091), // Rule ID 1060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9691:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSWVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1060,
        GIR_EraseRootFromParent_Done,
      // Label 772: @23091
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(23133), // Rule ID 1061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9692:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VINSWVRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSWVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1061,
        GIR_EraseRootFromParent_Done,
      // Label 773: @23133
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(23175), // Rule ID 1062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsblx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9677:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBLX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSBLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1062,
        GIR_EraseRootFromParent_Done,
      // Label 774: @23175
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(23217), // Rule ID 1063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsbrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9678:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSBRX:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSBRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1063,
        GIR_EraseRootFromParent_Done,
      // Label 775: @23217
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(23259), // Rule ID 1064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9684:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHLX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSHLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1064,
        GIR_EraseRootFromParent_Done,
      // Label 776: @23259
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(23301), // Rule ID 1065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinshrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 9685:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSHRX:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSHRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1065,
        GIR_EraseRootFromParent_Done,
      // Label 777: @23301
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(23343), // Rule ID 1066 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9689:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWLX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSWLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1066,
        GIR_EraseRootFromParent_Done,
      // Label 778: @23343
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(23385), // Rule ID 1067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinswrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 9690:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)  =>  (VINSWRX:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VDi, i32:{ *:[i32] }:$VA, i32:{ *:[i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSWRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1067,
        GIR_EraseRootFromParent_Done,
      // Label 779: @23385
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(23427), // Rule ID 1068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsdlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9682:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSDLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1068,
        GIR_EraseRootFromParent_Done,
      // Label 780: @23427
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(23469), // Rule ID 1069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vinsdrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9683:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)  =>  (VINSDRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VDi, i64:{ *:[i64] }:$VA, i64:{ *:[i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VINSDRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VDi
        GIR_RootToRootCopy, /*OpIdx*/3, // VA
        GIR_RootToRootCopy, /*OpIdx*/4, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1069,
        GIR_EraseRootFromParent_Done,
      // Label 781: @23469
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(23511), // Rule ID 1090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextdubvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9658:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVLX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUBVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1090,
        GIR_EraseRootFromParent_Done,
      // Label 782: @23511
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(23553), // Rule ID 1091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextdubvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9659:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUBVRX:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$RA, v16i8:{ *:[v16i8] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUBVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1091,
        GIR_EraseRootFromParent_Done,
      // Label 783: @23553
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(23595), // Rule ID 1092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduhvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9660:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVLX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUHVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1092,
        GIR_EraseRootFromParent_Done,
      // Label 784: @23595
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(23637), // Rule ID 1093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduhvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9661:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUHVRX:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$RA, v8i16:{ *:[v8i16] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUHVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1093,
        GIR_EraseRootFromParent_Done,
      // Label 785: @23637
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(23679), // Rule ID 1094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduwvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9662:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVLX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUWVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1094,
        GIR_EraseRootFromParent_Done,
      // Label 786: @23679
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(23721), // Rule ID 1095 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextduwvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9663:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDUWVRX:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$RA, v4i32:{ *:[v4i32] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDUWVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1095,
        GIR_EraseRootFromParent_Done,
      // Label 787: @23721
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(23763), // Rule ID 1096 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextddvlx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9656:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVLX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDDVLX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1096,
        GIR_EraseRootFromParent_Done,
      // Label 788: @23763
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(23805), // Rule ID 1097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vextddvrx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 9657:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)  =>  (VEXTDDVRX:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, i32:{ *:[i32] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VEXTDDVRX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1097,
        GIR_EraseRootFromParent_Done,
      // Label 789: @23805
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(23847), // Rule ID 1135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmsumcud),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9716:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)  =>  (VMSUMCUD:{ *:[v1i128] } v2i64:{ *:[v2i64] }:$RA, v2i64:{ *:[v2i64] }:$RB, v1i128:{ *:[v1i128] }:$RC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMSUMCUD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/3, // RB
        GIR_RootToRootCopy, /*OpIdx*/4, // RC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1135,
        GIR_EraseRootFromParent_Done,
      // Label 790: @23847
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(23889), // Rule ID 1150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vrlqmi),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s128,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s128,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i128] } 9771:{ *:[iPTR] }, v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)  =>  (VRLQMI:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB, v1i128:{ *:[v1i128] }:$VDi)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VRLQMI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootToRootCopy, /*OpIdx*/4, // VDi
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1150,
        GIR_EraseRootFromParent_Done,
      // Label 791: @23889
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(23928), // Rule ID 1265 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9892:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FMSUB:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FMSUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1265,
        GIR_EraseRootFromParent_Done,
      // Label 792: @23928
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(23967), // Rule ID 1266 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fmsubs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9893:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FMSUBS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FMSUBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1266,
        GIR_EraseRootFromParent_Done,
      // Label 793: @23967
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(24006), // Rule ID 1267 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 9896:{ *:[iPTR] }, f64:{ *:[f64] }:$A, f64:{ *:[f64] }:$B, f64:{ *:[f64] }:$C)  =>  (FNMADD:{ *:[f64] } ?:{ *:[f64] }:$A, ?:{ *:[f64] }:$B, ?:{ *:[f64] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FNMADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1267,
        GIR_EraseRootFromParent_Done,
      // Label 794: @24006
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(24045), // Rule ID 1268 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fnmadds),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F4RCRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 9897:{ *:[iPTR] }, f32:{ *:[f32] }:$A, f32:{ *:[f32] }:$B, f32:{ *:[f32] }:$C)  =>  (FNMADDS:{ *:[f32] } ?:{ *:[f32] }:$A, ?:{ *:[f32] }:$B, ?:{ *:[f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FNMADDS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1268,
        GIR_EraseRootFromParent_Done,
      // Label 795: @24045
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(24087), // Rule ID 1370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vmaddfp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9694:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VMADDFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMADDFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1370,
        GIR_EraseRootFromParent_Done,
      // Label 796: @24087
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(24129), // Rule ID 1371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vnmsubfp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 9744:{ *:[iPTR] }, v4f32:{ *:[v4f32] }:$A, v4f32:{ *:[v4f32] }:$B, v4f32:{ *:[v4f32] }:$C)  =>  (VNMSUBFP:{ *:[v4f32] } ?:{ *:[v4f32] }:$A, ?:{ *:[v4f32] }:$B, ?:{ *:[v4f32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNMSUBFP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1371,
        GIR_EraseRootFromParent_Done,
      // Label 797: @24129
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(24228), // Rule ID 1566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX_IsLittleEndian),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9524:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, (XXLNOR:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$c, VSRC:{ *:[i32] })))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // c
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXLNOR),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1566,
        GIR_EraseRootFromParent_Done,
      // Label 798: @24228
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(24270), // Rule ID 1567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX_IsBigEndian),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9524:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootToRootCopy, /*OpIdx*/4, // c
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1567,
        GIR_EraseRootFromParent_Done,
      // Label 799: @24270
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(24312), // Rule ID 1568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec_HasVSX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_crypto_vpermxor_be),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 9525:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$a, v16i8:{ *:[v16i8] }:$b, v16i8:{ *:[v16i8] }:$c)  =>  (VPERMXOR:{ *:[v16i8] } ?:{ *:[v16i8] }:$a, ?:{ *:[v16i8] }:$b, ?:{ *:[v16i8] }:$c)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPERMXOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_RootToRootCopy, /*OpIdx*/3, // b
        GIR_RootToRootCopy, /*OpIdx*/4, // c
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1568,
        GIR_EraseRootFromParent_Done,
      // Label 800: @24312
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(24432), // Rule ID 3408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 10125:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXBLENDVB:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVB),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        // GIR_Coverage, 3408,
        GIR_EraseRootFromParent_Done,
      // Label 801: @24432
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(24552), // Rule ID 3409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 10127:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$A, v8i16:{ *:[v8i16] }:$B, v8i16:{ *:[v8i16] }:$C)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (XXBLENDVH:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v8i16] }:$C, VSRC:{ *:[i32] })), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVH),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        // GIR_Coverage, 3409,
        GIR_EraseRootFromParent_Done,
      // Label 802: @24552
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(24594), // Rule ID 3410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 10128:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$A, v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C)  =>  (XXBLENDVW:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3410,
        GIR_EraseRootFromParent_Done,
      // Label 803: @24594
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(24636), // Rule ID 3411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxblendvd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 10126:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$A, v2i64:{ *:[v2i64] }:$B, v2i64:{ *:[v2i64] }:$C)  =>  (XXBLENDVD:{ *:[v2i64] } ?:{ *:[v2i64] }:$A, ?:{ *:[v2i64] }:$B, ?:{ *:[v2i64] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXBLENDVD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // A
        GIR_RootToRootCopy, /*OpIdx*/3, // B
        GIR_RootToRootCopy, /*OpIdx*/4, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3411,
        GIR_EraseRootFromParent_Done,
      // Label 804: @24636
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(24716), // Rule ID 3491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9988:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3491,
        GIR_EraseRootFromParent_Done,
      // Label 805: @24716
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(24796), // Rule ID 3493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9990:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3493,
        GIR_EraseRootFromParent_Done,
      // Label 806: @24796
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(24876), // Rule ID 3495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9986:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3495,
        GIR_EraseRootFromParent_Done,
      // Label 807: @24876
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(24956), // Rule ID 3497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi4ger8pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9988:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI4GER8WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3497,
        GIR_EraseRootFromParent_Done,
      // Label 808: @24956
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(25036), // Rule ID 3499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9990:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3499,
        GIR_EraseRootFromParent_Done,
      // Label 809: @25036
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(25116), // Rule ID 3501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9986:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2SWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3501,
        GIR_EraseRootFromParent_Done,
      // Label 810: @25116
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(25196), // Rule ID 3503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9972:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3503,
        GIR_EraseRootFromParent_Done,
      // Label 811: @25196
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(25276), // Rule ID 3504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9971:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2PN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3504,
        GIR_EraseRootFromParent_Done,
      // Label 812: @25276
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(25356), // Rule ID 3505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9970:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2NP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3505,
        GIR_EraseRootFromParent_Done,
      // Label 813: @25356
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(25436), // Rule ID 3506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9969:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2NN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3506,
        GIR_EraseRootFromParent_Done,
      // Label 814: @25436
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(25516), // Rule ID 3508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9972:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3508,
        GIR_EraseRootFromParent_Done,
      // Label 815: @25516
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(25596), // Rule ID 3509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9971:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3509,
        GIR_EraseRootFromParent_Done,
      // Label 816: @25596
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(25676), // Rule ID 3510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9970:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3510,
        GIR_EraseRootFromParent_Done,
      // Label 817: @25676
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(25756), // Rule ID 3511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9969:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF16GER2WNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3511,
        GIR_EraseRootFromParent_Done,
      // Label 818: @25756
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(25836), // Rule ID 3513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9977:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3513,
        GIR_EraseRootFromParent_Done,
      // Label 819: @25836
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(25916), // Rule ID 3514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9976:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3514,
        GIR_EraseRootFromParent_Done,
      // Label 820: @25916
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(25996), // Rule ID 3515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9975:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3515,
        GIR_EraseRootFromParent_Done,
      // Label 821: @25996
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(26076), // Rule ID 3516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9974:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3516,
        GIR_EraseRootFromParent_Done,
      // Label 822: @26076
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(26137), // Rule ID 3518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9982:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3518,
        GIR_EraseRootFromParent_Done,
      // Label 823: @26137
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(26198), // Rule ID 3519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9981:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3519,
        GIR_EraseRootFromParent_Done,
      // Label 824: @26198
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(26259), // Rule ID 3520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9980:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3520,
        GIR_EraseRootFromParent_Done,
      // Label 825: @26259
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(26320), // Rule ID 3521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9979:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3521,
        GIR_EraseRootFromParent_Done,
      // Label 826: @26320
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(26400), // Rule ID 3523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9967:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3523,
        GIR_EraseRootFromParent_Done,
      // Label 827: @26400
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(26480), // Rule ID 3524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9966:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2PN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3524,
        GIR_EraseRootFromParent_Done,
      // Label 828: @26480
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(26560), // Rule ID 3525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9965:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2NP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3525,
        GIR_EraseRootFromParent_Done,
      // Label 829: @26560
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(26640), // Rule ID 3526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9964:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2NN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3526,
        GIR_EraseRootFromParent_Done,
      // Label 830: @26640
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(26720), // Rule ID 3528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9984:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3528,
        GIR_EraseRootFromParent_Done,
      // Label 831: @26720
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(26800), // Rule ID 3529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9991:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4SPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3529,
        GIR_EraseRootFromParent_Done,
      // Label 832: @26800
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(26880), // Rule ID 3531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9977:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3531,
        GIR_EraseRootFromParent_Done,
      // Label 833: @26880
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(26960), // Rule ID 3532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9976:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3532,
        GIR_EraseRootFromParent_Done,
      // Label 834: @26960
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(27040), // Rule ID 3533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9975:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3533,
        GIR_EraseRootFromParent_Done,
      // Label 835: @27040
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(27120), // Rule ID 3534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf32gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9974:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF32GERWNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3534,
        GIR_EraseRootFromParent_Done,
      // Label 836: @27120
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(27181), // Rule ID 3536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9982:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3536,
        GIR_EraseRootFromParent_Done,
      // Label 837: @27181
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(27242), // Rule ID 3537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9981:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3537,
        GIR_EraseRootFromParent_Done,
      // Label 838: @27242
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(27303), // Rule ID 3538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9980:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3538,
        GIR_EraseRootFromParent_Done,
      // Label 839: @27303
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(27364), // Rule ID 3539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvf64gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9979:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVF64GERWNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3539,
        GIR_EraseRootFromParent_Done,
      // Label 840: @27364
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(27444), // Rule ID 3541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9967:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3541,
        GIR_EraseRootFromParent_Done,
      // Label 841: @27444
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(27524), // Rule ID 3542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9966:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3542,
        GIR_EraseRootFromParent_Done,
      // Label 842: @27524
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(27604), // Rule ID 3543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9965:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3543,
        GIR_EraseRootFromParent_Done,
      // Label 843: @27604
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(27684), // Rule ID 3544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvbf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9964:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVBF16GER2WNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3544,
        GIR_EraseRootFromParent_Done,
      // Label 844: @27684
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(27764), // Rule ID 3546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9984:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3546,
        GIR_EraseRootFromParent_Done,
      // Label 845: @27764
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(27844), // Rule ID 3547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_xvi8ger4spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        // (intrinsic_wo_chain:{ *:[v512i1] } 9991:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB)  =>  (XVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XVI8GER4WSPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3547,
        GIR_EraseRootFromParent_Done,
      // Label 846: @27844
      GIM_Reject,
    // Label 734: @27845
    GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(28442),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(27966), // Rule ID 3559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9944:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GER:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3559,
        GIR_EraseRootFromParent_Done,
      // Label 848: @27966
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(28060), // Rule ID 3564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9949:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GER:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GER),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3564,
        GIR_EraseRootFromParent_Done,
      // Label 849: @28060
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(28173), // Rule ID 3588 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9944:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3588,
        GIR_EraseRootFromParent_Done,
      // Label 850: @28173
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(28267), // Rule ID 3593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64ger),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9949:{ *:[iPTR] }, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERW:{ *:[v512i1] } ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3593,
        GIR_EraseRootFromParent_Done,
      // Label 851: @28267
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(28314), // Rule ID 1105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxeval),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] IMM
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v2i64] } 10129:{ *:[iPTR] }, v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)  =>  (XXEVAL:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$XA, v2i64:{ *:[v2i64] }:$XB, v2i64:{ *:[v2i64] }:$XC, (timm:{ *:[i32] }):$IMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_RootToRootCopy, /*OpIdx*/3, // XB
        GIR_RootToRootCopy, /*OpIdx*/4, // XC
        GIR_RootToRootCopy, /*OpIdx*/5, // IMM
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1105,
        GIR_EraseRootFromParent_Done,
      // Label 852: @28314
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(28441), // Rule ID 3407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_vsx_xxpermx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // MIs[0] D
        GIM_CheckIsImm, /*MI*/0, /*Op*/5,
        // (intrinsic_wo_chain:{ *:[v16i8] } 10137:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$A, v16i8:{ *:[v16i8] }:$B, v16i8:{ *:[v16i8] }:$C, (timm:{ *:[i32] }):$D)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (XXPERMX:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$A, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$B, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$C, VSRC:{ *:[i32] }), ?:{ *:[i32] }:$D), VSRC:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/4, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // B
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // A
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::XXPERMX),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/5, // D
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::VSRCRegClassID),
        // GIR_Coverage, 3407,
        GIR_EraseRootFromParent_Done,
      // Label 853: @28441
      GIM_Reject,
    // Label 847: @28442
    GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(31759),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/7,
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(28581), // Rule ID 3548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9958:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3548,
        GIR_EraseRootFromParent_Done,
      // Label 855: @28581
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(28712), // Rule ID 3550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9960:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3550,
        GIR_EraseRootFromParent_Done,
      // Label 856: @28712
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(28843), // Rule ID 3552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2s),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9956:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2S:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2S),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3552,
        GIR_EraseRootFromParent_Done,
      // Label 857: @28843
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(28974), // Rule ID 3554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9939:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3554,
        GIR_EraseRootFromParent_Done,
      // Label 858: @28974
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29105), // Rule ID 3569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9934:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3569,
        GIR_EraseRootFromParent_Done,
      // Label 859: @29105
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(29236), // Rule ID 3574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9954:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3574,
        GIR_EraseRootFromParent_Done,
      // Label 860: @29236
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29367), // Rule ID 3577 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9958:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3577,
        GIR_EraseRootFromParent_Done,
      // Label 861: @29367
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(29498), // Rule ID 3579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9960:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3579,
        GIR_EraseRootFromParent_Done,
      // Label 862: @29498
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29629), // Rule ID 3581 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2s),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9956:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SW:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3581,
        GIR_EraseRootFromParent_Done,
      // Label 863: @29629
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(29760), // Rule ID 3583 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9939:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3583,
        GIR_EraseRootFromParent_Done,
      // Label 864: @29760
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(29891), // Rule ID 3598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9934:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3598,
        GIR_EraseRootFromParent_Done,
      // Label 865: @29891
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(30022), // Rule ID 3603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/5, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/6, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9954:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2W:{ *:[v512i1] } (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/3, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2W),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3603,
        GIR_EraseRootFromParent_Done,
      // Label 866: @30022
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(30140), // Rule ID 3560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9948:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3560,
        GIR_EraseRootFromParent_Done,
      // Label 867: @30140
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(30258), // Rule ID 3561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9947:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3561,
        GIR_EraseRootFromParent_Done,
      // Label 868: @30258
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(30376), // Rule ID 3562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9946:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3562,
        GIR_EraseRootFromParent_Done,
      // Label 869: @30376
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(30494), // Rule ID 3563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9945:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3563,
        GIR_EraseRootFromParent_Done,
      // Label 870: @30494
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(30593), // Rule ID 3565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9953:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3565,
        GIR_EraseRootFromParent_Done,
      // Label 871: @30593
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(30692), // Rule ID 3566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9952:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3566,
        GIR_EraseRootFromParent_Done,
      // Label 872: @30692
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(30791), // Rule ID 3567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9951:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3567,
        GIR_EraseRootFromParent_Done,
      // Label 873: @30791
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(30890), // Rule ID 3568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9950:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3568,
        GIR_EraseRootFromParent_Done,
      // Label 874: @30890
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(31008), // Rule ID 3589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9948:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3589,
        GIR_EraseRootFromParent_Done,
      // Label 875: @31008
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(31126), // Rule ID 3590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9947:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3590,
        GIR_EraseRootFromParent_Done,
      // Label 876: @31126
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(31244), // Rule ID 3591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9946:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3591,
        GIR_EraseRootFromParent_Done,
      // Label 877: @31244
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(31362), // Rule ID 3592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf32gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9945:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)  =>  (PMXVF32GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF32GERWNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3592,
        GIR_EraseRootFromParent_Done,
      // Label 878: @31362
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(31461), // Rule ID 3594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9953:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3594,
        GIR_EraseRootFromParent_Done,
      // Label 879: @31461
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(31560), // Rule ID 3595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gerpn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9952:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3595,
        GIR_EraseRootFromParent_Done,
      // Label 880: @31560
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(31659), // Rule ID 3596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9951:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3596,
        GIR_EraseRootFromParent_Done,
      // Label 881: @31659
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(31758), // Rule ID 3597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf64gernn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v256s1,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9950:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v256i1:{ *:[v256i1] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)  =>  (PMXVF64GERWNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, ?:{ *:[v256i1] }:$XA, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$YMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF64GERWNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_RootToRootCopy, /*OpIdx*/3, // XA
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3597,
        GIR_EraseRootFromParent_Done,
      // Label 882: @31758
      GIM_Reject,
    // Label 854: @31759
    GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(35304),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/8,
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(31903), // Rule ID 3549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9959:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3549,
        GIR_EraseRootFromParent_Done,
      // Label 884: @31903
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(32039), // Rule ID 3551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9961:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3551,
        GIR_EraseRootFromParent_Done,
      // Label 885: @32039
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(32175), // Rule ID 3553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9957:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3553,
        GIR_EraseRootFromParent_Done,
      // Label 886: @32175
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(32311), // Rule ID 3555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9943:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3555,
        GIR_EraseRootFromParent_Done,
      // Label 887: @32311
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(32447), // Rule ID 3556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9942:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2PN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3556,
        GIR_EraseRootFromParent_Done,
      // Label 888: @32447
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(32583), // Rule ID 3557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9941:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2NP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3557,
        GIR_EraseRootFromParent_Done,
      // Label 889: @32583
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(32719), // Rule ID 3558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9940:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2NN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3558,
        GIR_EraseRootFromParent_Done,
      // Label 890: @32719
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(32855), // Rule ID 3570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9938:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3570,
        GIR_EraseRootFromParent_Done,
      // Label 891: @32855
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(32991), // Rule ID 3571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9937:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2PN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2PN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3571,
        GIR_EraseRootFromParent_Done,
      // Label 892: @32991
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(33127), // Rule ID 3572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9936:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2NP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3572,
        GIR_EraseRootFromParent_Done,
      // Label 893: @33127
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(33263), // Rule ID 3573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9935:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2NN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2NN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3573,
        GIR_EraseRootFromParent_Done,
      // Label 894: @33263
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(33399), // Rule ID 3575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9962:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4SPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4SPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3575,
        GIR_EraseRootFromParent_Done,
      // Label 895: @33399
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(33535), // Rule ID 3576 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9955:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2PP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2PP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3576,
        GIR_EraseRootFromParent_Done,
      // Label 896: @33535
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(33671), // Rule ID 3578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi4ger8pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk8Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9959:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)  =>  (PMXVI4GER8WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk8Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI4GER8WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3578,
        GIR_EraseRootFromParent_Done,
      // Label 897: @33671
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(33807), // Rule ID 3580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9961:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)  =>  (PMXVI8GER4WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3580,
        GIR_EraseRootFromParent_Done,
      // Label 898: @33807
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(33943), // Rule ID 3582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9957:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2SWPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2SWPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3582,
        GIR_EraseRootFromParent_Done,
      // Label 899: @33943
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(34079), // Rule ID 3584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9943:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3584,
        GIR_EraseRootFromParent_Done,
      // Label 900: @34079
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(34215), // Rule ID 3585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9942:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3585,
        GIR_EraseRootFromParent_Done,
      // Label 901: @34215
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(34351), // Rule ID 3586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9941:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3586,
        GIR_EraseRootFromParent_Done,
      // Label 902: @34351
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(34487), // Rule ID 3587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9940:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVF16GER2WNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3587,
        GIR_EraseRootFromParent_Done,
      // Label 903: @34487
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(34623), // Rule ID 3599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9938:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3599,
        GIR_EraseRootFromParent_Done,
      // Label 904: @34623
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(34759), // Rule ID 3600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2pn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9937:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WPN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WPN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3600,
        GIR_EraseRootFromParent_Done,
      // Label 905: @34759
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(34895), // Rule ID 3601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2np),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9936:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WNP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3601,
        GIR_EraseRootFromParent_Done,
      // Label 906: @34895
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(35031), // Rule ID 3602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvbf16ger2nn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9935:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVBF16GER2WNN:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVBF16GER2WNN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3602,
        GIR_EraseRootFromParent_Done,
      // Label 907: @35031
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(35167), // Rule ID 3604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi8ger4spp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::WACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9962:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI8GER4WSPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI8GER4WSPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3604,
        GIR_EraseRootFromParent_Done,
      // Label 908: @35167
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(35303), // Rule ID 3605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISAFuture_MMA_PrefixInstrs),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mma_pmxvi16ger2pp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v512s1,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/5, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/6, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/7, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::ACCRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/5, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/6, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk4Imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/7, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_Msk2Imm),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[v512i1] } 9955:{ *:[iPTR] }, v512i1:{ *:[v512i1] }:$ATi, v16i8:{ *:[v16i8] }:$XA, v16i8:{ *:[v16i8] }:$XB, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)  =>  (PMXVI16GER2WPP:{ *:[v512i1] } ?:{ *:[v512i1] }:$ATi, (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XA, VSRC:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v4i32] } ?:{ *:[v16i8] }:$XB, VSRC:{ *:[i32] }), (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$XMSK, (imm:{ *:[i32] })<<P:Predicate_Msk4Imm>>:$YMSK, (imm:{ *:[i32] })<<P:Predicate_Msk2Imm>>:$PMSK)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // XB
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // XA
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PMXVI16GER2WPP),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[AT]
        GIR_RootToRootCopy, /*OpIdx*/2, // ATi
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // XMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // YMSK
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // PMSK
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3605,
        GIR_EraseRootFromParent_Done,
      // Label 909: @35303
      GIM_Reject,
    // Label 883: @35304
    GIM_Reject,
    // Label 20: @35305
    GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(35644),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(35332), // Rule ID 103 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_eieio),
        // (intrinsic_void 9878:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PseudoEIEIO),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 103,
        GIR_EraseRootFromParent_Done,
      // Label 911: @35332
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(35357), // Rule ID 1184 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_sync),
        // (intrinsic_void 10033:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1184,
        GIR_EraseRootFromParent_Done,
      // Label 912: @35357
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(35382), // Rule ID 1185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_iospace_sync),
        // (intrinsic_void 9913:{ *:[iPTR] })  =>  (SYNC 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1185,
        GIR_EraseRootFromParent_Done,
      // Label 913: @35382
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(35407), // Rule ID 1186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_lwsync),
        // (intrinsic_void 9918:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1186,
        GIR_EraseRootFromParent_Done,
      // Label 914: @35407
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(35432), // Rule ID 1187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_iospace_lwsync),
        // (intrinsic_void 9912:{ *:[iPTR] })  =>  (SYNC 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SYNC),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1187,
        GIR_EraseRootFromParent_Done,
      // Label 915: @35432
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(35454), // Rule ID 1188 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_sync),
        // (intrinsic_void 10033:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1188,
        GIR_EraseRootFromParent_Done,
      // Label 916: @35454
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(35476), // Rule ID 1189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_iospace_sync),
        // (intrinsic_void 9913:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1189,
        GIR_EraseRootFromParent_Done,
      // Label 917: @35476
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(35498), // Rule ID 1190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_lwsync),
        // (intrinsic_void 9918:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1190,
        GIR_EraseRootFromParent_Done,
      // Label 918: @35498
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(35520), // Rule ID 1191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasOnlyMSYNC),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_iospace_lwsync),
        // (intrinsic_void 9912:{ *:[iPTR] })  =>  (MSYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MSYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1191,
        GIR_EraseRootFromParent_Done,
      // Label 919: @35520
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(35539), // Rule ID 1192 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_eieio),
        // (intrinsic_void 9878:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PseudoEIEIO),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1192,
        GIR_EraseRootFromParent_Done,
      // Label 920: @35539
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(35558), // Rule ID 1193 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_iospace_eieio),
        // (intrinsic_void 9911:{ *:[iPTR] })  =>  (PseudoEIEIO)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PseudoEIEIO),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1193,
        GIR_EraseRootFromParent_Done,
      // Label 921: @35558
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(35580), // Rule ID 1219 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_fence),
        // (intrinsic_void 9889:{ *:[iPTR] })  =>  (FENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::FENCE),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::RM*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1219,
        GIR_EraseRootFromParent_Done,
      // Label 922: @35580
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(35602), // Rule ID 1273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsAIX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dssall),
        // (intrinsic_void 9534:{ *:[iPTR] })  =>  (NOP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NOP),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1273,
        GIR_EraseRootFromParent_Done,
      // Label 923: @35602
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(35624), // Rule ID 1274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotAIX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dssall),
        // (intrinsic_void 9534:{ *:[iPTR] })  =>  (DSSALL)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSSALL),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1274,
        GIR_EraseRootFromParent_Done,
      // Label 924: @35624
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(35643), // Rule ID 4807 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_isync),
        // (intrinsic_void 9914:{ *:[iPTR] })  =>  (ISYNC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ISYNC),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4807,
        GIR_EraseRootFromParent_Done,
      // Label 925: @35643
      GIM_Reject,
    // Label 910: @35644
    GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(36406),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(35691), // Rule ID 266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dss),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9533:{ *:[iPTR] }, (imm:{ *:[i32] }):$STRM)  =>  (DSS (imm:{ *:[i32] }):$STRM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSS),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 266,
        GIR_EraseRootFromParent_Done,
      // Label 927: @35691
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(35717), // Rule ID 190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtfsb0),
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 9995:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB0 (timm:{ *:[i32] }):$FM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTFSB0),
        GIR_RootToRootCopy, /*OpIdx*/1, // FM
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::RM*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 190,
        GIR_EraseRootFromParent_Done,
      // Label 928: @35717
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(35743), // Rule ID 191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtfsb1),
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 9996:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM)  =>  (MTFSB1 (timm:{ *:[i32] }):$FM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTFSB1),
        GIR_RootToRootCopy, /*OpIdx*/1, // FM
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::RM*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 191,
        GIR_EraseRootFromParent_Done,
      // Label 929: @35743
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(35770), // Rule ID 275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_mfvscr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v8i16] } 9546:{ *:[iPTR] })  =>  (MFVSCR:{ *:[v8i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFVSCR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 275,
        GIR_EraseRootFromParent_Done,
      // Label 930: @35770
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(35794), // Rule ID 1220 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_readflm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_w_chain:{ *:[f64] } 10010:{ *:[iPTR] })  =>  (MFFS:{ *:[f64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFFS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1220,
        GIR_EraseRootFromParent_Done,
      // Label 931: @35794
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(35822), // Rule ID 1221 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mffsl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_w_chain:{ *:[f64] } 9925:{ *:[iPTR] })  =>  (MFFSL:{ *:[f64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFFSL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1221,
        GIR_EraseRootFromParent_Done,
      // Label 932: @35822
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(35886), // Rule ID 1557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_darn32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 9855:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (DARN:{ *:[i64] } 0:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::DARN),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/1, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(PPC::sub_32),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(PPC::GPRCRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(PPC::G8RCRegClassID),
        // GIR_Coverage, 1557,
        GIR_EraseRootFromParent_Done,
      // Label 933: @35886
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(35920), // Rule ID 1558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_darn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9854:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DARN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1558,
        GIR_EraseRootFromParent_Done,
      // Label 934: @35920
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(35954), // Rule ID 1559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_darnraw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9856:{ *:[iPTR] })  =>  (DARN:{ *:[i64] } 2:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DARN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1559,
        GIR_EraseRootFromParent_Done,
      // Label 935: @35954
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(35985), // Rule ID 2871 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_tcheck),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 10040:{ *:[iPTR] })  =>  (TCHECK_RET:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::TCHECK_RET),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[out]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2871,
        GIR_EraseRootFromParent_Done,
      // Label 936: @35985
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(36026), // Rule ID 2875 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_get_texasr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9905:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 130:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(130),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2875,
        GIR_EraseRootFromParent_Done,
      // Label 937: @36026
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(36067), // Rule ID 2876 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_get_texasru),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9906:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 131:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(131),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2876,
        GIR_EraseRootFromParent_Done,
      // Label 938: @36067
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(36108), // Rule ID 2877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_get_tfhar),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9907:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(128),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2877,
        GIR_EraseRootFromParent_Done,
      // Label 939: @36108
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(36149), // Rule ID 2878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_get_tfiar),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 9908:{ *:[iPTR] })  =>  (MFSPR8:{ *:[i64] } 129:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(129),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2878,
        GIR_EraseRootFromParent_Done,
      // Label 940: @36149
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(36180), // Rule ID 4851 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_void 9999:{ *:[iPTR] }, gprc:{ *:[i32] }:$RS)  =>  (MTMSR ?:{ *:[i32] }:$RS, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTMSR),
        GIR_RootToRootCopy, /*OpIdx*/1, // RS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4851,
        GIR_EraseRootFromParent_Done,
      // Label 941: @36180
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(36207), // Rule ID 186 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::set_loop_iterations),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        // (intrinsic_void 313:{ *:[iPTR] }, i32:{ *:[i32] }:$RST)  =>  (MTCTRloop:{ *:[i32] } i32:{ *:[i32] }:$RST)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTCTRloop),
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CTR*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 186,
        GIR_EraseRootFromParent_Done,
      // Label 942: @36207
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(36230), // Rule ID 276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_mtvscr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
        // (intrinsic_void 9547:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VB)  =>  (MTVSCR v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTVSCR),
        GIR_RootToRootCopy, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 276,
        GIR_EraseRootFromParent_Done,
      // Label 943: @36230
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(36257), // Rule ID 630 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::set_loop_iterations),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 313:{ *:[iPTR] }, i64:{ *:[i64] }:$RST)  =>  (MTCTR8loop:{ *:[i64] } i64:{ *:[i64] }:$RST)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTCTR8loop),
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CTR8*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 630,
        GIR_EraseRootFromParent_Done,
      // Label 944: @36257
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(36294), // Rule ID 2879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_set_texasr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 10016:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 130:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR8),
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(130),
        GIR_RootToRootCopy, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2879,
        GIR_EraseRootFromParent_Done,
      // Label 945: @36294
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(36331), // Rule ID 2880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_set_texasru),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 10017:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 131:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR8),
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(131),
        GIR_RootToRootCopy, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2880,
        GIR_EraseRootFromParent_Done,
      // Label 946: @36331
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(36368), // Rule ID 2881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_set_tfhar),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 10018:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 128:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR8),
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(128),
        GIR_RootToRootCopy, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2881,
        GIR_EraseRootFromParent_Done,
      // Label 947: @36368
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(36405), // Rule ID 2882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasHTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_set_tfiar),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        // (intrinsic_void 10019:{ *:[iPTR] }, i64:{ *:[i64] }:$V)  =>  (MTSPR8 129:{ *:[i32] }, ?:{ *:[i64] }:$V)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR8),
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(129),
        GIR_RootToRootCopy, /*OpIdx*/1, // V
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2882,
        GIR_EraseRootFromParent_Done,
      // Label 948: @36405
      GIM_Reject,
    // Label 926: @36406
    GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(36851),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(36445), // Rule ID 1161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtfsfi),
        // MIs[0] BF
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] U
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 9998:{ *:[iPTR] }, (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)  =>  (MTFSFIb (timm:{ *:[i32] }):$BF, (timm:{ *:[i32] }):$U)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTFSFIb),
        GIR_RootToRootCopy, /*OpIdx*/1, // BF
        GIR_RootToRootCopy, /*OpIdx*/2, // U
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::RM*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1161,
        GIR_EraseRootFromParent_Done,
      // Label 950: @36445
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(36490), // Rule ID 12 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_setrnd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[f64] } 10022:{ *:[iPTR] }, (imm:{ *:[i32] }):$RND)  =>  (SETRNDi:{ *:[f64] } (imm:{ *:[i32] }):$RND)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SETRNDi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // RND
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12,
        GIR_EraseRootFromParent_Done,
      // Label 951: @36490
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(36535), // Rule ID 187 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::loop_decrement),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i1] } 215:{ *:[iPTR] }, (imm:{ *:[i32] }):$stride)  =>  (DecreaseCTRloop:{ *:[i1] }:{ *:[i32] } (imm:{ *:[i32] }):$stride)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DecreaseCTRloop),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 187,
        GIR_EraseRootFromParent_Done,
      // Label 952: @36535
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(36580), // Rule ID 631 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::loop_decrement),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[i1] } 215:{ *:[iPTR] }, (imm:{ *:[i64] }):$stride)  =>  (DecreaseCTR8loop:{ *:[i1] }:{ *:[i64] } (imm:{ *:[i64] }):$stride)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DecreaseCTR8loop),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rT]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // stride
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 631,
        GIR_EraseRootFromParent_Done,
      // Label 953: @36580
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(36613), // Rule ID 1162 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_fixed_addr_ld),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // MIs[0] imm
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 9890:{ *:[iPTR] }, (timm:{ *:[i32] }):$imm)  =>  (PPCLdFixedAddr:{ *:[i32] } (timm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::PPCLdFixedAddr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rT]
        GIR_RootToRootCopy, /*OpIdx*/2, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1162,
        GIR_EraseRootFromParent_Done,
      // Label 954: @36613
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(36646), // Rule ID 1562 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mfspr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i64] } 9927:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR)  =>  (MFSPR8:{ *:[i64] } ?:{ *:[i32] }:$SPR)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // SPR
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1562,
        GIR_EraseRootFromParent_Done,
      // Label 955: @36646
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(36679), // Rule ID 4849 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_mfspr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 9927:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR)  =>  (MFSPR:{ *:[i32] } ?:{ *:[i32] }:$SPR)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MFSPR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // SPR
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4849,
        GIR_EraseRootFromParent_Done,
      // Label 956: @36679
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(36712), // Rule ID 1563 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtspr),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
        // (intrinsic_void 10000:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR, g8rc:{ *:[i64] }:$RT)  =>  (MTSPR8 ?:{ *:[i32] }:$SPR, ?:{ *:[i64] }:$RT)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR8),
        GIR_RootToRootCopy, /*OpIdx*/1, // SPR
        GIR_RootToRootCopy, /*OpIdx*/2, // RT
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1563,
        GIR_EraseRootFromParent_Done,
      // Label 957: @36712
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(36745), // Rule ID 4850 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtspr),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] SPR
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_void 10000:{ *:[iPTR] }, (timm:{ *:[i32] }):$SPR, gprc:{ *:[i32] }:$RT)  =>  (MTSPR ?:{ *:[i32] }:$SPR, ?:{ *:[i32] }:$RT)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTSPR),
        GIR_RootToRootCopy, /*OpIdx*/1, // SPR
        GIR_RootToRootCopy, /*OpIdx*/2, // RT
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4850,
        GIR_EraseRootFromParent_Done,
      // Label 958: @36745
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(36776), // Rule ID 192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPU),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_mtfsf),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] FM
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 9997:{ *:[iPTR] }, (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$RT)  =>  (MTFSFb (timm:{ *:[i32] }):$FM, f64:{ *:[f64] }:$RT)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MTFSFb),
        GIR_RootToRootCopy, /*OpIdx*/1, // FM
        GIR_RootToRootCopy, /*OpIdx*/2, // RT
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::RM*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 192,
        GIR_EraseRootFromParent_Done,
      // Label 959: @36776
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(36813), // Rule ID 13 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_setrnd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
        // (intrinsic_w_chain:{ *:[f64] } 10022:{ *:[iPTR] }, gprc:{ *:[i32] }:$in)  =>  (SETRND:{ *:[f64] } gprc:{ *:[i32] }:$in)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SETRND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // in
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13,
        GIR_EraseRootFromParent_Done,
      // Label 960: @36813
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(36850), // Rule ID 14 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_setflm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(PPC::F8RCRegClassID),
        // (intrinsic_w_chain:{ *:[f64] } 10021:{ *:[iPTR] }, f8rc:{ *:[f64] }:$FLM)  =>  (SETFLM:{ *:[f64] } f8rc:{ *:[f64] }:$FLM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SETFLM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[FRT]
        GIR_RootToRootCopy, /*OpIdx*/2, // FLM
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14,
        GIR_EraseRootFromParent_Done,
      // Label 961: @36850
      GIM_Reject,
    // Label 949: @36851
    GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(37778),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(36909), // Rule ID 267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dst),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9535:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DST),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 267,
        GIR_EraseRootFromParent_Done,
      // Label 963: @36909
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(36959), // Rule ID 268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dstt),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9538:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTT),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 268,
        GIR_EraseRootFromParent_Done,
      // Label 964: @36959
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(37009), // Rule ID 269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dstst),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9536:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTST),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 269,
        GIR_EraseRootFromParent_Done,
      // Label 965: @37009
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(37059), // Rule ID 270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dststt),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9537:{ *:[iPTR] }, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT (imm:{ *:[i32] }):$STRM, i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTSTT),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 270,
        GIR_EraseRootFromParent_Done,
      // Label 966: @37059
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(37109), // Rule ID 271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dst),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9535:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DST64),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 271,
        GIR_EraseRootFromParent_Done,
      // Label 967: @37109
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(37159), // Rule ID 272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dstt),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9538:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTT64),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 272,
        GIR_EraseRootFromParent_Done,
      // Label 968: @37159
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(37209), // Rule ID 273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dstst),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9536:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTST64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTST64),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 273,
        GIR_EraseRootFromParent_Done,
      // Label 969: @37209
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(37259), // Rule ID 274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::ppc_altivec_dststt),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        // MIs[0] RA
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_void 9537:{ *:[iPTR] }, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB, (imm:{ *:[i32] }):$STRM)  =>  (DSTSTT64 (imm:{ *:[i32] }):$STRM, i64:{ *:[i64] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::DSTSTT64),
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // STRM
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_RootToRootCopy, /*OpIdx*/2, // RB
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 274,
        GIR_EraseRootFromParent_Done,
      // Label 970: @37259
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(37296), // Rule ID 377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsumsws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 9817:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUMSWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUMSWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 377,
        GIR_EraseRootFromParent_Done,
      // Label 971: @37296
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(37333), // Rule ID 378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsum2sws),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 9813:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM2SWS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUM2SWS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 378,
        GIR_EraseRootFromParent_Done,
      // Label 972: @37333
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(37370), // Rule ID 379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsum4sbs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 9814:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4SBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUM4SBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 379,
        GIR_EraseRootFromParent_Done,
      // Label 973: @37370
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(37407), // Rule ID 380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsum4shs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 9815:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4SHS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUM4SHS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 380,
        GIR_EraseRootFromParent_Done,
      // Label 974: @37407
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(37444), // Rule ID 381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vsum4ubs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v4i32] } 9816:{ *:[iPTR] }, v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUM4UBS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VSUM4UBS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 381,
        GIR_EraseRootFromParent_Done,
      // Label 975: @37444
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(37481), // Rule ID 408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkshss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v16i8] } 9751:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKSHSS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKSHSS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 408,
        GIR_EraseRootFromParent_Done,
      // Label 976: @37481
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(37518), // Rule ID 409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkshus),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v16i8] } 9752:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKSHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKSHUS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 409,
        GIR_EraseRootFromParent_Done,
      // Label 977: @37518
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(37555), // Rule ID 410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkswss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v8i16] } 9753:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKSWSS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKSWSS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 410,
        GIR_EraseRootFromParent_Done,
      // Label 978: @37555
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(37592), // Rule ID 411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkswus),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v8i16] } 9754:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKSWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKSWUS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 411,
        GIR_EraseRootFromParent_Done,
      // Label 979: @37592
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(37629), // Rule ID 412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkuhus),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v16i8] } 9756:{ *:[iPTR] }, v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VPKUHUS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKUHUS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 412,
        GIR_EraseRootFromParent_Done,
      // Label 980: @37629
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(37666), // Rule ID 413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpkuwus),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (intrinsic_w_chain:{ *:[v8i16] } 9757:{ *:[iPTR] }, v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VPKUWUS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VPKUWUS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_RootToRootCopy, /*OpIdx*/3, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 413,
        GIR_EraseRootFromParent_Done,
      // Label 981: @37666
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(37703), // Rule ID 497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::ppc_altivec_vpksdss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VR