/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 87;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 16;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 78,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 13,
  Feature_NoV5TBit = 67,
  Feature_HasV5TEBit = 11,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 9,
  Feature_HasV6MBit = 28,
  Feature_HasV8MBaselineBit = 35,
  Feature_HasV8_1MMainlineBit = 41,
  Feature_HasMVEIntBit = 65,
  Feature_HasMVEFloatBit = 66,
  Feature_HasCDEBit = 86,
  Feature_HasFPRegsBit = 42,
  Feature_HasFPRegs16Bit = 43,
  Feature_HasNoFPRegs16Bit = 77,
  Feature_HasFPRegs64Bit = 52,
  Feature_HasV6T2Bit = 8,
  Feature_HasV6KBit = 18,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 56,
  Feature_PreV8Bit = 19,
  Feature_HasV8_1aBit = 80,
  Feature_HasV8_3aBit = 81,
  Feature_NoVFPBit = 22,
  Feature_HasVFP2Bit = 21,
  Feature_HasVFP3Bit = 53,
  Feature_HasVFP4Bit = 50,
  Feature_HasDPVFPBit = 44,
  Feature_HasFPARMv8Bit = 47,
  Feature_HasNEONBit = 54,
  Feature_HasSHA2Bit = 63,
  Feature_HasAESBit = 55,
  Feature_HasDotProdBit = 57,
  Feature_HasCRCBit = 14,
  Feature_HasLOBBit = 40,
  Feature_HasFP16Bit = 62,
  Feature_HasFullFP16Bit = 46,
  Feature_HasBF16Bit = 64,
  Feature_HasMatMulInt8Bit = 58,
  Feature_HasDivideInThumbBit = 37,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 36,
  Feature_HasDBBit = 15,
  Feature_HasV7ClrexBit = 17,
  Feature_HasAcquireReleaseBit = 16,
  Feature_HasMPBit = 2,
  Feature_Has8MSecExtBit = 29,
  Feature_HasZCZBit = 59,
  Feature_UseNEONForFPBit = 84,
  Feature_DontUseNEONForFPBit = 45,
  Feature_IsThumbBit = 26,
  Feature_IsThumb1OnlyBit = 27,
  Feature_IsThumb2Bit = 34,
  Feature_IsNotMClassBit = 38,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPTPIDRURWBit = 70,
  Feature_IsReadTPTPIDRUROBit = 71,
  Feature_IsReadTPTPIDRPRWBit = 72,
  Feature_IsReadTPSoftBit = 20,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 39,
  Feature_DontUseMovtBit = 23,
  Feature_UseMovtInPicBit = 24,
  Feature_DontUseMovtInPicBit = 25,
  Feature_UseFPVMLxBit = 49,
  Feature_SLSBLRMitigationBit = 69,
  Feature_NoSLSBLRMitigationBit = 68,
  Feature_UseMulOpsBit = 10,
  Feature_UseFusedMACBit = 51,
  Feature_HasFastVGETLNi32Bit = 60,
  Feature_HasSlowVGETLNi32Bit = 82,
  Feature_HasFastVDUP32Bit = 61,
  Feature_HasSlowVDUP32Bit = 83,
  Feature_UseVMOVSRBit = 48,
  Feature_DontUseVMOVSRBit = 85,
  Feature_IsLEBit = 76,
  Feature_IsBEBit = 79,
  Feature_GenExecuteOnlyBit = 33,
  Feature_DontGenExecuteOnlyBit = 32,
  Feature_GenT1ExecuteOnlyBit = 75,
  Feature_SignRetAddrBit = 74,
  Feature_NoSignRetAddrBit = 73,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features.set(Feature_NoHonorSignDependentRoundingBit);
  if (Subtarget->hasV4TOps())
    Features.set(Feature_HasV4TBit);
  if (!Subtarget->hasV4TOps())
    Features.set(Feature_NoV4TBit);
  if (Subtarget->hasV5TOps())
    Features.set(Feature_HasV5TBit);
  if (!Subtarget->hasV5TOps())
    Features.set(Feature_NoV5TBit);
  if (Subtarget->hasV5TEOps())
    Features.set(Feature_HasV5TEBit);
  if (Subtarget->hasV6Ops())
    Features.set(Feature_HasV6Bit);
  if (!Subtarget->hasV6Ops())
    Features.set(Feature_NoV6Bit);
  if (Subtarget->hasV6MOps())
    Features.set(Feature_HasV6MBit);
  if (Subtarget->hasV8MBaselineOps())
    Features.set(Feature_HasV8MBaselineBit);
  if (Subtarget->hasV8_1MMainlineOps())
    Features.set(Feature_HasV8_1MMainlineBit);
  if (Subtarget->hasMVEIntegerOps())
    Features.set(Feature_HasMVEIntBit);
  if (Subtarget->hasMVEFloatOps())
    Features.set(Feature_HasMVEFloatBit);
  if (Subtarget->hasCDEOps())
    Features.set(Feature_HasCDEBit);
  if (Subtarget->hasFPRegs())
    Features.set(Feature_HasFPRegsBit);
  if (Subtarget->hasFPRegs16())
    Features.set(Feature_HasFPRegs16Bit);
  if (!Subtarget->hasFPRegs16())
    Features.set(Feature_HasNoFPRegs16Bit);
  if (Subtarget->hasFPRegs64())
    Features.set(Feature_HasFPRegs64Bit);
  if (Subtarget->hasV6T2Ops())
    Features.set(Feature_HasV6T2Bit);
  if (Subtarget->hasV6KOps())
    Features.set(Feature_HasV6KBit);
  if (Subtarget->hasV7Ops())
    Features.set(Feature_HasV7Bit);
  if (Subtarget->hasV8Ops())
    Features.set(Feature_HasV8Bit);
  if (!Subtarget->hasV8Ops())
    Features.set(Feature_PreV8Bit);
  if (Subtarget->hasV8_1aOps())
    Features.set(Feature_HasV8_1aBit);
  if (Subtarget->hasV8_3aOps())
    Features.set(Feature_HasV8_3aBit);
  if (!Subtarget->hasVFP2Base())
    Features.set(Feature_NoVFPBit);
  if (Subtarget->hasVFP2Base())
    Features.set(Feature_HasVFP2Bit);
  if (Subtarget->hasVFP3Base())
    Features.set(Feature_HasVFP3Bit);
  if (Subtarget->hasVFP4Base())
    Features.set(Feature_HasVFP4Bit);
  if (Subtarget->hasFP64())
    Features.set(Feature_HasDPVFPBit);
  if (Subtarget->hasFPARMv8Base())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLOB())
    Features.set(Feature_HasLOBBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasDivideInThumbMode())
    Features.set(Feature_HasDivideInThumbBit);
  if (Subtarget->hasDivideInARMMode())
    Features.set(Feature_HasDivideInARMBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDataBarrier())
    Features.set(Feature_HasDBBit);
  if (Subtarget->hasV7Clrex())
    Features.set(Feature_HasV7ClrexBit);
  if (Subtarget->hasAcquireRelease())
    Features.set(Feature_HasAcquireReleaseBit);
  if (Subtarget->hasMPExtension())
    Features.set(Feature_HasMPBit);
  if (Subtarget->has8MSecExt())
    Features.set(Feature_Has8MSecExtBit);
  if (Subtarget->hasZeroCycleZeroing())
    Features.set(Feature_HasZCZBit);
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseNEONForFPBit);
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseNEONForFPBit);
  if (Subtarget->isThumb())
    Features.set(Feature_IsThumbBit);
  if (Subtarget->isThumb1Only())
    Features.set(Feature_IsThumb1OnlyBit);
  if (Subtarget->isThumb2())
    Features.set(Feature_IsThumb2Bit);
  if (!Subtarget->isMClass())
    Features.set(Feature_IsNotMClassBit);
  if (!Subtarget->isThumb())
    Features.set(Feature_IsARMBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (!Subtarget->isTargetWindows())
    Features.set(Feature_IsNotWindowsBit);
  if (Subtarget->isReadTPTPIDRURW())
    Features.set(Feature_IsReadTPTPIDRURWBit);
  if (Subtarget->isReadTPTPIDRURO())
    Features.set(Feature_IsReadTPTPIDRUROBit);
  if (Subtarget->isReadTPTPIDRPRW())
    Features.set(Feature_IsReadTPTPIDRPRWBit);
  if (Subtarget->isReadTPSoft())
    Features.set(Feature_IsReadTPSoftBit);
  if (Subtarget->useNaClTrap())
    Features.set(Feature_UseNaClTrapBit);
  if (!Subtarget->useNaClTrap())
    Features.set(Feature_DontUseNaClTrapBit);
  if (Subtarget->useMulOps())
    Features.set(Feature_UseMulOpsBit);
  if (TM.Options.AllowFPOpFusion ==  FPOpFusion::Fast && Subtarget->useFPVFMx())
    Features.set(Feature_UseFusedMACBit);
  if (!Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasFastVGETLNi32Bit);
  if (Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasSlowVGETLNi32Bit);
  if (!Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasFastVDUP32Bit);
  if (Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasSlowVDUP32Bit);
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseVMOVSRBit);
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseVMOVSRBit);
  if (Subtarget->genExecuteOnly())
    Features.set(Feature_GenExecuteOnlyBit);
  if (!Subtarget->genExecuteOnly())
    Features.set(Feature_DontGenExecuteOnlyBit);
  if (Subtarget->genExecuteOnly() && Subtarget->isThumb1Only() && !Subtarget->hasV8MBaselineOps())
    Features.set(Feature_GenT1ExecuteOnlyBit);
  return Features;
}

void ARMInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const ARMSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (Subtarget->useMovt())
    Features.set(Feature_UseMovtBit);
  if (!Subtarget->useMovt())
    Features.set(Feature_DontUseMovtBit);
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_UseMovtInPicBit);
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_DontUseMovtInPicBit);
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features.set(Feature_UseFPVMLxBit);
  if ( MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (MF->getDataLayout().isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (MF->getDataLayout().isBigEndian())
    Features.set(Feature_IsBEBit);
  if ( MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_SignRetAddrBit);
  if ( !MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_NoSignRetAddrBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_DontUseNaClTrap_IsARM,
  GIFBS_DontUseVMOVSR_HasNEON,
  GIFBS_Has8MSecExt_IsThumb,
  GIFBS_HasAES_HasV8,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasCRC_IsARM,
  GIFBS_HasCRC_IsThumb2,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPARMv8_HasNEON,
  GIFBS_HasFPRegs_HasFastVGETLNi32,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_HasV8_1MMainline,
  GIFBS_HasMVEInt_IsBE,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasV8_3a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasNEON_UseNEONForFP,
  GIFBS_HasSHA2_HasV8,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5T_IsThumb,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV5T,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsARM_UseNaClTrap,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_NoV5T,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_DontUseMovt_GenExecuteOnly_IsThumb1Only,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFPARMv8_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_HasV8_3a,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasLOB_HasV8_1MMainline_IsThumb2,
  GIFBS_HasNEON_UseFPVMLx_UseNEONForFP,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_HasVFP4_UseFusedMAC_UseNEONForFP,
  GIFBS_IsARM_NoV6_UseMulOps,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_DontUseNaClTrapBit, Feature_IsARMBit, },
  {Feature_DontUseVMOVSRBit, Feature_HasNEONBit, },
  {Feature_Has8MSecExtBit, Feature_IsThumbBit, },
  {Feature_HasAESBit, Feature_HasV8Bit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasCRCBit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_IsThumb2Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_HasFastVGETLNi32Bit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsBEBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_UseNEONForFPBit, },
  {Feature_HasSHA2Bit, Feature_HasV8Bit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TBit, Feature_IsThumbBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV5TBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsARMBit, Feature_UseNaClTrapBit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_NoV5TBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_DontUseMovtBit, Feature_GenExecuteOnlyBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFPARMv8Bit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasLOBBit, Feature_HasV8_1MMainlineBit, Feature_IsThumb2Bit, },
  {Feature_HasNEONBit, Feature_UseFPVMLxBit, Feature_UseNEONForFPBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasVFP4Bit, Feature_UseFusedMACBit, Feature_UseNEONForFPBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_bf_inv_mask_imm = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_vfp_f32imm,
  GICXXPred_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_bf_inv_mask_imm: {
    
        // There's better methods of implementing this check. IntImmLeaf<> would be
        // equivalent and have less boilerplate but we need a test for C++
        // predicates and this one causes new rules to be imported into GlobalISel
        // without requiring additional features first.
        const auto &MO = MI.getOperand(1);
        if (!MO.isCImm())
          return false;
        return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
      
    llvm_unreachable("bf_inv_mask_imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f32imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f32imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f64imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f64imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex8 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex16,
  GICXXPred_I64_Predicate_VectorIndex32,
  GICXXPred_I64_Predicate_VectorIndex64,
  GICXXPred_I64_Predicate_asr_imm,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_32,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_239,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm0_255_expr,
  GICXXPred_I64_Predicate_imm0_4095,
  GICXXPred_I64_Predicate_imm0_65535,
  GICXXPred_I64_Predicate_imm0_65535_expr,
  GICXXPred_I64_Predicate_imm0_65535_neg,
  GICXXPred_I64_Predicate_imm1_7,
  GICXXPred_I64_Predicate_imm1_15,
  GICXXPred_I64_Predicate_imm1_16,
  GICXXPred_I64_Predicate_imm1_31,
  GICXXPred_I64_Predicate_imm8,
  GICXXPred_I64_Predicate_imm8_255,
  GICXXPred_I64_Predicate_imm8_or_16,
  GICXXPred_I64_Predicate_imm16,
  GICXXPred_I64_Predicate_imm16_31,
  GICXXPred_I64_Predicate_imm24b,
  GICXXPred_I64_Predicate_imm32,
  GICXXPred_I64_Predicate_imm256_510,
  GICXXPred_I64_Predicate_imm_3b,
  GICXXPred_I64_Predicate_imm_4b,
  GICXXPred_I64_Predicate_imm_6b,
  GICXXPred_I64_Predicate_imm_7b,
  GICXXPred_I64_Predicate_imm_9b,
  GICXXPred_I64_Predicate_imm_11b,
  GICXXPred_I64_Predicate_imm_12b,
  GICXXPred_I64_Predicate_imm_13b,
  GICXXPred_I64_Predicate_imm_even,
  GICXXPred_I64_Predicate_imm_odd,
  GICXXPred_I64_Predicate_long_shift,
  GICXXPred_I64_Predicate_mod_imm,
  GICXXPred_I64_Predicate_mod_imm_not,
  GICXXPred_I64_Predicate_pkh_asr_amt,
  GICXXPred_I64_Predicate_pkh_lsl_amt,
  GICXXPred_I64_Predicate_shr_imm8,
  GICXXPred_I64_Predicate_shr_imm16,
  GICXXPred_I64_Predicate_shr_imm32,
  GICXXPred_I64_Predicate_shr_imm64,
  GICXXPred_I64_Predicate_t2_so_imm,
  GICXXPred_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex8: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex16: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex32: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex64: {
    
      return ((uint64_t)Imm) < 1;
    
  }
  case GICXXPred_I64_Predicate_asr_imm: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return Imm >= 0 && Imm < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return Imm >= 0 && Imm < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return Imm >= 0 && Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_32: {
    
      return Imm >= 0 && Imm < 33;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return Imm >= 0 && Imm < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
  }
  case GICXXPred_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_255_expr: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_4095: {
    
      return Imm >= 0 && Imm < 4096;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_expr: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_neg: {
    
      return -Imm >= 0 && -Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
  }
  case GICXXPred_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_imm1_16: {
    
        return Imm > 0 && Imm <= 16;
      
  }
  case GICXXPred_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_imm8: {
     return Imm == 8; 
  }
  case GICXXPred_I64_Predicate_imm8_255: {
    
      return Imm >= 8 && Imm < 256;
    
  }
  case GICXXPred_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
  }
  case GICXXPred_I64_Predicate_imm16: {
     return Imm == 16; 
  }
  case GICXXPred_I64_Predicate_imm16_31: {
    
      return (int32_t)Imm >= 16 && (int32_t)Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm24b: {
    
      return Imm >= 0 && Imm <= 0xffffff;
    
  }
  case GICXXPred_I64_Predicate_imm32: {
     return Imm == 32; 
  }
  case GICXXPred_I64_Predicate_imm256_510: {
    
      return Imm >= 256 && Imm < 511;
    
  }
  case GICXXPred_I64_Predicate_imm_3b: {
    { return Imm >= 0 && Imm < (1 << 3); }
    llvm_unreachable("imm_3b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_4b: {
    { return Imm >= 0 && Imm < (1 << 4); }
    llvm_unreachable("imm_4b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_6b: {
    { return Imm >= 0 && Imm < (1 << 6); }
    llvm_unreachable("imm_6b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_7b: {
    { return Imm >= 0 && Imm < (1 << 7); }
    llvm_unreachable("imm_7b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_9b: {
    { return Imm >= 0 && Imm < (1 << 9); }
    llvm_unreachable("imm_9b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_11b: {
    { return Imm >= 0 && Imm < (1 << 11); }
    llvm_unreachable("imm_11b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_12b: {
    { return Imm >= 0 && Imm < (1 << 12); }
    llvm_unreachable("imm_12b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_13b: {
    { return Imm >= 0 && Imm < (1 << 13); }
    llvm_unreachable("imm_13b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
  }
  case GICXXPred_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
  }
  case GICXXPred_I64_Predicate_long_shift: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_mod_imm: {
    
        return ARM_AM::getSOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_mod_imm_not: {
    
        return ARM_AM::getSOImmVal(~(uint32_t)Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
  }
  case GICXXPred_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
  }
  case GICXXPred_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
  }
  case GICXXPred_I64_Predicate_t2_so_imm: {
    
        return ARM_AM::getT2SOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_t2_so_imm_neg: {
    
      return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_arm_i32imm = GICXXPred_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_arm_i32imm: {
    
      if (Subtarget->useMovt())
        return true;
      if (ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue()))
        return true;
      return ARM_AM::isSOImmTwoPartValNeg(Imm.getZExtValue());
    
    llvm_unreachable("arm_i32imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("ARMInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderInvertedImm,
  GICR_renderVFPF32Imm,
  GICR_renderVFPF64Imm,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &ARMInstructionSelector::renderInvertedImm,
  &ARMInstructionSelector::renderVFPF32Imm,
  &ARMInstructionSelector::renderVFPF64Imm,
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool ARMInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("ARMInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(293), /*)*//*default:*//*Label 76*/ GIMT_Encode4(126069),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(978),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(6603),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(9751),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(10621),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(10717), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(10813),
    /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(13773),
    /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(19504), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(21077), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(21503), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(31951),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(32243), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 12*/ GIMT_Encode4(32502), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 13*/ GIMT_Encode4(32523),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 14*/ GIMT_Encode4(88245), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 15*/ GIMT_Encode4(95907),
    /*TargetOpcode::G_TRUNC*//*Label 16*/ GIMT_Encode4(96065),
    /*TargetOpcode::G_CONSTANT*//*Label 17*/ GIMT_Encode4(96223),
    /*TargetOpcode::G_FCONSTANT*//*Label 18*/ GIMT_Encode4(96503), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 19*/ GIMT_Encode4(96599), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 20*/ GIMT_Encode4(96757),
    /*TargetOpcode::G_SHL*//*Label 21*/ GIMT_Encode4(96915),
    /*TargetOpcode::G_LSHR*//*Label 22*/ GIMT_Encode4(97026),
    /*TargetOpcode::G_ASHR*//*Label 23*/ GIMT_Encode4(97082), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 24*/ GIMT_Encode4(97311), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 25*/ GIMT_Encode4(97593),
    /*TargetOpcode::G_SMULH*//*Label 26*/ GIMT_Encode4(97835),
    /*TargetOpcode::G_UADDSAT*//*Label 27*/ GIMT_Encode4(98198),
    /*TargetOpcode::G_SADDSAT*//*Label 28*/ GIMT_Encode4(98837),
    /*TargetOpcode::G_USUBSAT*//*Label 29*/ GIMT_Encode4(100131),
    /*TargetOpcode::G_SSUBSAT*//*Label 30*/ GIMT_Encode4(100770), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 31*/ GIMT_Encode4(101784),
    /*TargetOpcode::G_FSUB*//*Label 32*/ GIMT_Encode4(104096),
    /*TargetOpcode::G_FMUL*//*Label 33*/ GIMT_Encode4(105760),
    /*TargetOpcode::G_FMA*//*Label 34*/ GIMT_Encode4(106740), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 35*/ GIMT_Encode4(108555), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 36*/ GIMT_Encode4(108720),
    /*TargetOpcode::G_FPEXT*//*Label 37*/ GIMT_Encode4(110261),
    /*TargetOpcode::G_FPTRUNC*//*Label 38*/ GIMT_Encode4(110491),
    /*TargetOpcode::G_FPTOSI*//*Label 39*/ GIMT_Encode4(110763),
    /*TargetOpcode::G_FPTOUI*//*Label 40*/ GIMT_Encode4(112093),
    /*TargetOpcode::G_SITOFP*//*Label 41*/ GIMT_Encode4(113423),
    /*TargetOpcode::G_UITOFP*//*Label 42*/ GIMT_Encode4(114067),
    /*TargetOpcode::G_FABS*//*Label 43*/ GIMT_Encode4(114711), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 44*/ GIMT_Encode4(115481),
    /*TargetOpcode::G_FMAXNUM*//*Label 45*/ GIMT_Encode4(116069), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 46*/ GIMT_Encode4(116657),
    /*TargetOpcode::G_FMAXIMUM*//*Label 47*/ GIMT_Encode4(117373),
    /*TargetOpcode::G_GET_FPENV*//*Label 48*/ GIMT_Encode4(118089),
    /*TargetOpcode::G_SET_FPENV*//*Label 49*/ GIMT_Encode4(118122),
    /*TargetOpcode::G_RESET_FPENV*//*Label 50*/ GIMT_Encode4(118158),
    /*TargetOpcode::G_GET_FPMODE*//*Label 51*/ GIMT_Encode4(118223), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 52*/ GIMT_Encode4(118256),
    /*TargetOpcode::G_SMAX*//*Label 53*/ GIMT_Encode4(118793),
    /*TargetOpcode::G_UMIN*//*Label 54*/ GIMT_Encode4(119330),
    /*TargetOpcode::G_UMAX*//*Label 55*/ GIMT_Encode4(120245),
    /*TargetOpcode::G_ABS*//*Label 56*/ GIMT_Encode4(121160), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 57*/ GIMT_Encode4(121625), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 58*/ GIMT_Encode4(121698),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 59*/ GIMT_Encode4(121998), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 60*/ GIMT_Encode4(122153), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 61*/ GIMT_Encode4(122708),
    /*TargetOpcode::G_BSWAP*//*Label 62*/ GIMT_Encode4(122816),
    /*TargetOpcode::G_BITREVERSE*//*Label 63*/ GIMT_Encode4(123102),
    /*TargetOpcode::G_FCEIL*//*Label 64*/ GIMT_Encode4(123528), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 65*/ GIMT_Encode4(123787),
    /*TargetOpcode::G_FFLOOR*//*Label 66*/ GIMT_Encode4(123925),
    /*TargetOpcode::G_FRINT*//*Label 67*/ GIMT_Encode4(124184),
    /*TargetOpcode::G_FNEARBYINT*//*Label 68*/ GIMT_Encode4(124476), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 69*/ GIMT_Encode4(124614),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 70*/ GIMT_Encode4(124660), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_ADD*//*Label 71*/ GIMT_Encode4(124747), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 72*/ GIMT_Encode4(124923),
    /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 73*/ GIMT_Encode4(125203),
    /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 74*/ GIMT_Encode4(125492),
    /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 75*/ GIMT_Encode4(125773),
    // Label 0: @978
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 86*/ GIMT_Encode4(6602),
    /*GILLT_s32*//*Label 77*/ GIMT_Encode4(1049),
    /*GILLT_s64*//*Label 78*/ GIMT_Encode4(3129), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 79*/ GIMT_Encode4(3176),
    /*GILLT_v2s64*//*Label 80*/ GIMT_Encode4(3361), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 81*/ GIMT_Encode4(4072),
    /*GILLT_v4s32*//*Label 82*/ GIMT_Encode4(4257), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 83*/ GIMT_Encode4(5211),
    /*GILLT_v8s16*//*Label 84*/ GIMT_Encode4(5396), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 85*/ GIMT_Encode4(6350),
    // Label 77: @1049
    GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(3128),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1135), // Rule ID 5787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5787,
        GIR_EraseRootFromParent_Done,
      // Label 88: @1135
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1210), // Rule ID 5788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5788,
        GIR_EraseRootFromParent_Done,
      // Label 89: @1210
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1285), // Rule ID 5822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5822,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1285
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1360), // Rule ID 5823 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5823,
        GIR_EraseRootFromParent_Done,
      // Label 91: @1360
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1435), // Rule ID 2015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2015,
        GIR_EraseRootFromParent_Done,
      // Label 92: @1435
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1510), // Rule ID 2016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2016,
        GIR_EraseRootFromParent_Done,
      // Label 93: @1510
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1585), // Rule ID 2237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2237,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1585
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1660), // Rule ID 2238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2238,
        GIR_EraseRootFromParent_Done,
      // Label 95: @1660
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1770), // Rule ID 5566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5566,
        GIR_EraseRootFromParent_Done,
      // Label 96: @1770
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1880), // Rule ID 5603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5603,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1880
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1990), // Rule ID 192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 192,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1990
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(2100), // Rule ID 529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 529,
        GIR_EraseRootFromParent_Done,
      // Label 99: @2100
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2157), // Rule ID 72 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72,
        GIR_EraseRootFromParent_Done,
      // Label 100: @2157
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2214), // Rule ID 415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 415,
        GIR_EraseRootFromParent_Done,
      // Label 101: @2214
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2265), // Rule ID 416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri12),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 416,
        GIR_EraseRootFromParent_Done,
      // Label 102: @2265
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(2341), // Rule ID 171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 171,
        GIR_EraseRootFromParent_Done,
      // Label 103: @2341
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(2417), // Rule ID 172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 172,
        GIR_EraseRootFromParent_Done,
      // Label 104: @2417
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2487), // Rule ID 511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 511,
        GIR_EraseRootFromParent_Done,
      // Label 105: @2487
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2557), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 180,
        GIR_EraseRootFromParent_Done,
      // Label 106: @2557
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2627), // Rule ID 517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 517,
        GIR_EraseRootFromParent_Done,
      // Label 107: @2627
      GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(2703), // Rule ID 5560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5560,
        GIR_EraseRootFromParent_Done,
      // Label 108: @2703
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(2779), // Rule ID 5561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5561,
        GIR_EraseRootFromParent_Done,
      // Label 109: @2779
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(2849), // Rule ID 5598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5598,
        GIR_EraseRootFromParent_Done,
      // Label 110: @2849
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(2919), // Rule ID 5562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5562,
        GIR_EraseRootFromParent_Done,
      // Label 111: @2919
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2989), // Rule ID 5599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5599,
        GIR_EraseRootFromParent_Done,
      // Label 112: @2989
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(3035), // Rule ID 73 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73,
        GIR_EraseRootFromParent_Done,
      // Label 113: @3035
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(3081), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 417,
        GIR_EraseRootFromParent_Done,
      // Label 114: @3081
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(3127), // Rule ID 5580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5580,
        GIR_EraseRootFromParent_Done,
      // Label 115: @3127
      GIM_Reject,
    // Label 87: @3128
    GIM_Reject,
    // Label 78: @3129
    GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(3175), // Rule ID 779 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv1i64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 779,
      GIR_EraseRootFromParent_Done,
    // Label 116: @3175
    GIM_Reject,
    // Label 79: @3176
    GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(3360),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(3257), // Rule ID 5649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5649,
        GIR_EraseRootFromParent_Done,
      // Label 118: @3257
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(3323), // Rule ID 906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 906,
        GIR_EraseRootFromParent_Done,
      // Label 119: @3323
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(3359), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 775,
        GIR_EraseRootFromParent_Done,
      // Label 120: @3359
      GIM_Reject,
    // Label 117: @3360
    GIM_Reject,
    // Label 80: @3361
    GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(4071),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(3444), // Rule ID 799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 799,
        GIR_EraseRootFromParent_Done,
      // Label 122: @3444
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(3512), // Rule ID 798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 798,
        GIR_EraseRootFromParent_Done,
      // Label 123: @3512
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(3580), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 787,
        GIR_EraseRootFromParent_Done,
      // Label 124: @3580
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(3648), // Rule ID 797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 797,
        GIR_EraseRootFromParent_Done,
      // Label 125: @3648
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(3716), // Rule ID 796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 796,
        GIR_EraseRootFromParent_Done,
      // Label 126: @3716
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(3769), // Rule ID 5628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5628,
        GIR_EraseRootFromParent_Done,
      // Label 127: @3769
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(3822), // Rule ID 5622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5622,
        GIR_EraseRootFromParent_Done,
      // Label 128: @3822
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(3875), // Rule ID 5627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5627,
        GIR_EraseRootFromParent_Done,
      // Label 129: @3875
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(3928), // Rule ID 808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 808,
        GIR_EraseRootFromParent_Done,
      // Label 130: @3928
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(3981), // Rule ID 802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 802,
        GIR_EraseRootFromParent_Done,
      // Label 131: @3981
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(4034), // Rule ID 807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 807,
        GIR_EraseRootFromParent_Done,
      // Label 132: @4034
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(4070), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 780,
        GIR_EraseRootFromParent_Done,
      // Label 133: @4070
      GIM_Reject,
    // Label 121: @4071
    GIM_Reject,
    // Label 81: @4072
    GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(4256),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(4153), // Rule ID 5648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5648,
        GIR_EraseRootFromParent_Done,
      // Label 135: @4153
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(4219), // Rule ID 905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 905,
        GIR_EraseRootFromParent_Done,
      // Label 136: @4219
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(4255), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 774,
        GIR_EraseRootFromParent_Done,
      // Label 137: @4255
      GIM_Reject,
    // Label 134: @4256
    GIM_Reject,
    // Label 82: @4257
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(5210),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(4340), // Rule ID 795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 795,
        GIR_EraseRootFromParent_Done,
      // Label 139: @4340
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(4412), // Rule ID 794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 794,
        GIR_EraseRootFromParent_Done,
      // Label 140: @4412
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(4484), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 786,
        GIR_EraseRootFromParent_Done,
      // Label 141: @4484
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(4556), // Rule ID 793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 793,
        GIR_EraseRootFromParent_Done,
      // Label 142: @4556
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(4628), // Rule ID 792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 792,
        GIR_EraseRootFromParent_Done,
      // Label 143: @4628
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(4698), // Rule ID 5652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5652,
        GIR_EraseRootFromParent_Done,
      // Label 144: @4698
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(4755), // Rule ID 5626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5626,
        GIR_EraseRootFromParent_Done,
      // Label 145: @4755
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(4812), // Rule ID 5621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5621,
        GIR_EraseRootFromParent_Done,
      // Label 146: @4812
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(4869), // Rule ID 5625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5625,
        GIR_EraseRootFromParent_Done,
      // Label 147: @4869
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(4939), // Rule ID 909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 909,
        GIR_EraseRootFromParent_Done,
      // Label 148: @4939
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(4996), // Rule ID 806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 806,
        GIR_EraseRootFromParent_Done,
      // Label 149: @4996
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(5053), // Rule ID 801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 801,
        GIR_EraseRootFromParent_Done,
      // Label 150: @5053
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(5110), // Rule ID 805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 805,
        GIR_EraseRootFromParent_Done,
      // Label 151: @5110
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(5150), // Rule ID 778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 778,
        GIR_EraseRootFromParent_Done,
      // Label 152: @5150
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(5209), // Rule ID 3593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3593,
        GIR_EraseRootFromParent_Done,
      // Label 153: @5209
      GIM_Reject,
    // Label 138: @5210
    GIM_Reject,
    // Label 83: @5211
    GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(5395),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(5292), // Rule ID 5647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5647,
        GIR_EraseRootFromParent_Done,
      // Label 155: @5292
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(5358), // Rule ID 904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 904,
        GIR_EraseRootFromParent_Done,
      // Label 156: @5358
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(5394), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 773,
        GIR_EraseRootFromParent_Done,
      // Label 157: @5394
      GIM_Reject,
    // Label 154: @5395
    GIM_Reject,
    // Label 84: @5396
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(6349),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(5479), // Rule ID 791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 791,
        GIR_EraseRootFromParent_Done,
      // Label 159: @5479
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(5551), // Rule ID 790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 790,
        GIR_EraseRootFromParent_Done,
      // Label 160: @5551
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(5623), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 785,
        GIR_EraseRootFromParent_Done,
      // Label 161: @5623
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(5695), // Rule ID 789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 789,
        GIR_EraseRootFromParent_Done,
      // Label 162: @5695
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(5767), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 788,
        GIR_EraseRootFromParent_Done,
      // Label 163: @5767
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(5837), // Rule ID 5651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5651,
        GIR_EraseRootFromParent_Done,
      // Label 164: @5837
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(5894), // Rule ID 5624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5624,
        GIR_EraseRootFromParent_Done,
      // Label 165: @5894
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(5951), // Rule ID 5620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5620,
        GIR_EraseRootFromParent_Done,
      // Label 166: @5951
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(6008), // Rule ID 5623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5623,
        GIR_EraseRootFromParent_Done,
      // Label 167: @6008
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(6078), // Rule ID 908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 908,
        GIR_EraseRootFromParent_Done,
      // Label 168: @6078
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(6135), // Rule ID 804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 804,
        GIR_EraseRootFromParent_Done,
      // Label 169: @6135
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(6192), // Rule ID 800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 800,
        GIR_EraseRootFromParent_Done,
      // Label 170: @6192
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(6249), // Rule ID 803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 803,
        GIR_EraseRootFromParent_Done,
      // Label 171: @6249
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(6289), // Rule ID 777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 777,
        GIR_EraseRootFromParent_Done,
      // Label 172: @6289
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(6348), // Rule ID 3589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3589,
        GIR_EraseRootFromParent_Done,
      // Label 173: @6348
      GIM_Reject,
    // Label 158: @6349
    GIM_Reject,
    // Label 85: @6350
    GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(6601),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(6431), // Rule ID 5650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5650,
        GIR_EraseRootFromParent_Done,
      // Label 175: @6431
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(6501), // Rule ID 907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 907,
        GIR_EraseRootFromParent_Done,
      // Label 176: @6501
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(6541), // Rule ID 776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 776,
        GIR_EraseRootFromParent_Done,
      // Label 177: @6541
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(6600), // Rule ID 3585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3585,
        GIR_EraseRootFromParent_Done,
      // Label 178: @6600
      GIM_Reject,
    // Label 174: @6601
    GIM_Reject,
    // Label 86: @6602
    GIM_Reject,
    // Label 1: @6603
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 188*/ GIMT_Encode4(9750),
    /*GILLT_s32*//*Label 179*/ GIMT_Encode4(6674),
    /*GILLT_s64*//*Label 180*/ GIMT_Encode4(7198), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 181*/ GIMT_Encode4(7245),
    /*GILLT_v2s64*//*Label 182*/ GIMT_Encode4(7360), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 183*/ GIMT_Encode4(7912),
    /*GILLT_v4s32*//*Label 184*/ GIMT_Encode4(8027), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 185*/ GIMT_Encode4(8740),
    /*GILLT_v8s16*//*Label 186*/ GIMT_Encode4(8855), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 187*/ GIMT_Encode4(9568),
    // Label 179: @6674
    GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(7197),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(6742), // Rule ID 96 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::RSBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 96,
        GIR_EraseRootFromParent_Done,
      // Label 190: @6742
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(6799), // Rule ID 435 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2RSBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 435,
        GIR_EraseRootFromParent_Done,
      // Label 191: @6799
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(6856), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 76,
        GIR_EraseRootFromParent_Done,
      // Label 192: @6856
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(6913), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 419,
        GIR_EraseRootFromParent_Done,
      // Label 193: @6913
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(6964), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri12),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 420,
        GIR_EraseRootFromParent_Done,
      // Label 194: @6964
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(7034), // Rule ID 173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 173,
        GIR_EraseRootFromParent_Done,
      // Label 195: @7034
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(7104), // Rule ID 512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 512,
        GIR_EraseRootFromParent_Done,
      // Label 196: @7104
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(7150), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 77,
        GIR_EraseRootFromParent_Done,
      // Label 197: @7150
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(7196), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 421,
        GIR_EraseRootFromParent_Done,
      // Label 198: @7196
      GIM_Reject,
    // Label 189: @7197
    GIM_Reject,
    // Label 180: @7198
    GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(7244), // Rule ID 983 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv1i64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 983,
      GIR_EraseRootFromParent_Done,
    // Label 199: @7244
    GIM_Reject,
    // Label 181: @7245
    GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(7359),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(7326), // Rule ID 934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 934,
        GIR_EraseRootFromParent_Done,
      // Label 201: @7326
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(7358), // Rule ID 979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 979,
        GIR_EraseRootFromParent_Done,
      // Label 202: @7358
      GIM_Reject,
    // Label 200: @7359
    GIM_Reject,
    // Label 182: @7360
    GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(7911),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(7443), // Rule ID 1003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1003,
        GIR_EraseRootFromParent_Done,
      // Label 204: @7443
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(7511), // Rule ID 1002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1002,
        GIR_EraseRootFromParent_Done,
      // Label 205: @7511
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(7579), // Rule ID 991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 991,
        GIR_EraseRootFromParent_Done,
      // Label 206: @7579
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(7647), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1001,
        GIR_EraseRootFromParent_Done,
      // Label 207: @7647
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(7715), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1000,
        GIR_EraseRootFromParent_Done,
      // Label 208: @7715
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(7768), // Rule ID 1012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1012,
        GIR_EraseRootFromParent_Done,
      // Label 209: @7768
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(7821), // Rule ID 1006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1006,
        GIR_EraseRootFromParent_Done,
      // Label 210: @7821
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(7874), // Rule ID 1011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1011,
        GIR_EraseRootFromParent_Done,
      // Label 211: @7874
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(7910), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 984,
        GIR_EraseRootFromParent_Done,
      // Label 212: @7910
      GIM_Reject,
    // Label 203: @7911
    GIM_Reject,
    // Label 183: @7912
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(8026),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(7993), // Rule ID 933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 933,
        GIR_EraseRootFromParent_Done,
      // Label 214: @7993
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(8025), // Rule ID 978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 978,
        GIR_EraseRootFromParent_Done,
      // Label 215: @8025
      GIM_Reject,
    // Label 213: @8026
    GIM_Reject,
    // Label 184: @8027
    GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(8739),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(8110), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 999,
        GIR_EraseRootFromParent_Done,
      // Label 217: @8110
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(8182), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 998,
        GIR_EraseRootFromParent_Done,
      // Label 218: @8182
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(8254), // Rule ID 990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 990,
        GIR_EraseRootFromParent_Done,
      // Label 219: @8254
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(8326), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 997,
        GIR_EraseRootFromParent_Done,
      // Label 220: @8326
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(8398), // Rule ID 996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 996,
        GIR_EraseRootFromParent_Done,
      // Label 221: @8398
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(8468), // Rule ID 937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 937,
        GIR_EraseRootFromParent_Done,
      // Label 222: @8468
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(8525), // Rule ID 1010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1010,
        GIR_EraseRootFromParent_Done,
      // Label 223: @8525
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(8582), // Rule ID 1005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1005,
        GIR_EraseRootFromParent_Done,
      // Label 224: @8582
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(8639), // Rule ID 1009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1009,
        GIR_EraseRootFromParent_Done,
      // Label 225: @8639
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(8679), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 982,
        GIR_EraseRootFromParent_Done,
      // Label 226: @8679
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(8738), // Rule ID 3605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3605,
        GIR_EraseRootFromParent_Done,
      // Label 227: @8738
      GIM_Reject,
    // Label 216: @8739
    GIM_Reject,
    // Label 185: @8740
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(8854),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(8821), // Rule ID 932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 932,
        GIR_EraseRootFromParent_Done,
      // Label 229: @8821
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(8853), // Rule ID 977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 977,
        GIR_EraseRootFromParent_Done,
      // Label 230: @8853
      GIM_Reject,
    // Label 228: @8854
    GIM_Reject,
    // Label 186: @8855
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(9567),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(8938), // Rule ID 995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 995,
        GIR_EraseRootFromParent_Done,
      // Label 232: @8938
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(9010), // Rule ID 994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 994,
        GIR_EraseRootFromParent_Done,
      // Label 233: @9010
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(9082), // Rule ID 989 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 989,
        GIR_EraseRootFromParent_Done,
      // Label 234: @9082
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(9154), // Rule ID 993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 993,
        GIR_EraseRootFromParent_Done,
      // Label 235: @9154
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(9226), // Rule ID 992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 992,
        GIR_EraseRootFromParent_Done,
      // Label 236: @9226
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(9296), // Rule ID 936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 936,
        GIR_EraseRootFromParent_Done,
      // Label 237: @9296
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(9353), // Rule ID 1008 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1008,
        GIR_EraseRootFromParent_Done,
      // Label 238: @9353
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(9410), // Rule ID 1004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1004,
        GIR_EraseRootFromParent_Done,
      // Label 239: @9410
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(9467), // Rule ID 1007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1007,
        GIR_EraseRootFromParent_Done,
      // Label 240: @9467
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(9507), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 981,
        GIR_EraseRootFromParent_Done,
      // Label 241: @9507
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(9566), // Rule ID 3601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3601,
        GIR_EraseRootFromParent_Done,
      // Label 242: @9566
      GIM_Reject,
    // Label 231: @9567
    GIM_Reject,
    // Label 187: @9568
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(9749),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(9649), // Rule ID 935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 935,
        GIR_EraseRootFromParent_Done,
      // Label 244: @9649
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(9689), // Rule ID 980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 980,
        GIR_EraseRootFromParent_Done,
      // Label 245: @9689
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(9748), // Rule ID 3597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3597,
        GIR_EraseRootFromParent_Done,
      // Label 246: @9748
      GIM_Reject,
    // Label 243: @9749
    GIM_Reject,
    // Label 188: @9750
    GIM_Reject,
    // Label 2: @9751
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 254*/ GIMT_Encode4(10620),
    /*GILLT_s32*//*Label 247*/ GIMT_Encode4(9822), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 248*/ GIMT_Encode4(10143), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 249*/ GIMT_Encode4(10190),
    /*GILLT_v4s32*//*Label 250*/ GIMT_Encode4(10237), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 251*/ GIMT_Encode4(10349),
    /*GILLT_v8s16*//*Label 252*/ GIMT_Encode4(10396), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 253*/ GIMT_Encode4(10508),
    // Label 247: @9822
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(10142),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(9921), // Rule ID 186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 186,
        GIR_EraseRootFromParent_Done,
      // Label 256: @9921
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(10009), // Rule ID 523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 523,
        GIR_EraseRootFromParent_Done,
      // Label 257: @10009
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(10055), // Rule ID 169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MUL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 169,
        GIR_EraseRootFromParent_Done,
      // Label 258: @10055
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(10101), // Rule ID 170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MULv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 170,
        GIR_EraseRootFromParent_Done,
      // Label 259: @10101
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(10141), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MUL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 510,
        GIR_EraseRootFromParent_Done,
      // Label 260: @10141
      GIM_Reject,
    // Label 255: @10142
    GIM_Reject,
    // Label 248: @10143
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(10189), // Rule ID 854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv2i32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 854,
      GIR_EraseRootFromParent_Done,
    // Label 261: @10189
    GIM_Reject,
    // Label 249: @10190
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(10236), // Rule ID 853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 853,
      GIR_EraseRootFromParent_Done,
    // Label 262: @10236
    GIM_Reject,
    // Label 250: @10237
    GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(10348),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(10288), // Rule ID 857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 857,
        GIR_EraseRootFromParent_Done,
      // Label 264: @10288
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(10347), // Rule ID 3563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VMULi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3563,
        GIR_EraseRootFromParent_Done,
      // Label 265: @10347
      GIM_Reject,
    // Label 263: @10348
    GIM_Reject,
    // Label 251: @10349
    GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(10395), // Rule ID 852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 852,
      GIR_EraseRootFromParent_Done,
    // Label 266: @10395
    GIM_Reject,
    // Label 252: @10396
    GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(10507),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(10447), // Rule ID 856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 856,
        GIR_EraseRootFromParent_Done,
      // Label 268: @10447
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(10506), // Rule ID 3559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VMULi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3559,
        GIR_EraseRootFromParent_Done,
      // Label 269: @10506
      GIM_Reject,
    // Label 267: @10507
    GIM_Reject,
    // Label 253: @10508
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(10619),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(10559), // Rule ID 855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 855,
        GIR_EraseRootFromParent_Done,
      // Label 271: @10559
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(10618), // Rule ID 3555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VMULi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3555,
        GIR_EraseRootFromParent_Done,
      // Label 272: @10618
      GIM_Reject,
    // Label 270: @10619
    GIM_Reject,
    // Label 254: @10620
    GIM_Reject,
    // Label 3: @10621
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(10716),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(10675), // Rule ID 195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 195,
        GIR_EraseRootFromParent_Done,
      // Label 274: @10675
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(10715), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 540,
        GIR_EraseRootFromParent_Done,
      // Label 275: @10715
      GIM_Reject,
    // Label 273: @10716
    GIM_Reject,
    // Label 4: @10717
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(10812),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(10771), // Rule ID 196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 196,
        GIR_EraseRootFromParent_Done,
      // Label 277: @10771
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(10811), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 541,
        GIR_EraseRootFromParent_Done,
      // Label 278: @10811
      GIM_Reject,
    // Label 276: @10812
    GIM_Reject,
    // Label 5: @10813
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 292*/ GIMT_Encode4(13772),
    /*GILLT_s32*//*Label 279*/ GIMT_Encode4(10884),
    /*GILLT_s64*//*Label 280*/ GIMT_Encode4(12688),
    /*GILLT_v2s1*//*Label 281*/ GIMT_Encode4(12735),
    /*GILLT_v2s32*//*Label 282*/ GIMT_Encode4(12847),
    /*GILLT_v2s64*//*Label 283*/ GIMT_Encode4(12894),
    /*GILLT_v4s1*//*Label 284*/ GIMT_Encode4(13006),
    /*GILLT_v4s16*//*Label 285*/ GIMT_Encode4(13118),
    /*GILLT_v4s32*//*Label 286*/ GIMT_Encode4(13165), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 287*/ GIMT_Encode4(13277),
    /*GILLT_v8s8*//*Label 288*/ GIMT_Encode4(13389),
    /*GILLT_v8s16*//*Label 289*/ GIMT_Encode4(13436), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 290*/ GIMT_Encode4(13548),
    /*GILLT_v16s8*//*Label 291*/ GIMT_Encode4(13660),
    // Label 279: @10884
    GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(12687),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(10968), // Rule ID 1879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1879,
        GIR_EraseRootFromParent_Done,
      // Label 294: @10968
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(11041), // Rule ID 2119 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2119,
        GIR_EraseRootFromParent_Done,
      // Label 295: @11041
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(11089), // Rule ID 2012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2012,
        GIR_EraseRootFromParent_Done,
      // Label 296: @11089
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(11137), // Rule ID 2013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2013,
        GIR_EraseRootFromParent_Done,
      // Label 297: @11137
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(11185), // Rule ID 2014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2014,
        GIR_EraseRootFromParent_Done,
      // Label 298: @11185
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(11233), // Rule ID 2234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2234,
        GIR_EraseRootFromParent_Done,
      // Label 299: @11233
      GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(11281), // Rule ID 2235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2235,
        GIR_EraseRootFromParent_Done,
      // Label 300: @11281
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(11329), // Rule ID 2236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2236,
        GIR_EraseRootFromParent_Done,
      // Label 301: @11329
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(11406), // Rule ID 5556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5556,
        GIR_EraseRootFromParent_Done,
      // Label 302: @11406
      GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(11483), // Rule ID 5589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5589,
        GIR_EraseRootFromParent_Done,
      // Label 303: @11483
      GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(11560), // Rule ID 5555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5555,
        GIR_EraseRootFromParent_Done,
      // Label 304: @11560
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(11637), // Rule ID 5588 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5588,
        GIR_EraseRootFromParent_Done,
      // Label 305: @11637
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(11714), // Rule ID 5554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5554,
        GIR_EraseRootFromParent_Done,
      // Label 306: @11714
      GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(11791), // Rule ID 5587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5587,
        GIR_EraseRootFromParent_Done,
      // Label 307: @11791
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(11868), // Rule ID 159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 159,
        GIR_EraseRootFromParent_Done,
      // Label 308: @11868
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(11945), // Rule ID 498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 498,
        GIR_EraseRootFromParent_Done,
      // Label 309: @11945
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(12016), // Rule ID 5557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5557,
        GIR_EraseRootFromParent_Done,
      // Label 310: @12016
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(12087), // Rule ID 5590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5590,
        GIR_EraseRootFromParent_Done,
      // Label 311: @12087
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(12158), // Rule ID 160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 160,
        GIR_EraseRootFromParent_Done,
      // Label 312: @12158
      GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(12229), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 499,
        GIR_EraseRootFromParent_Done,
      // Label 313: @12229
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(12274), // Rule ID 352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 352,
        GIR_EraseRootFromParent_Done,
      // Label 314: @12274
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(12319), // Rule ID 353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 353,
        GIR_EraseRootFromParent_Done,
      // Label 315: @12319
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(12378), // Rule ID 1918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm_not),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>><<X:imm_not_XFORM>>:$imm)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm_not_XFORM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderInvertedImm), // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1918,
        GIR_EraseRootFromParent_Done,
      // Label 316: @12378
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(12435), // Rule ID 147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 147,
        GIR_EraseRootFromParent_Done,
      // Label 317: @12435
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(12492), // Rule ID 489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 489,
        GIR_EraseRootFromParent_Done,
      // Label 318: @12492
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(12543), // Rule ID 163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BFC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 163,
        GIR_EraseRootFromParent_Done,
      // Label 319: @12543
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(12594), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BFC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 501,
        GIR_EraseRootFromParent_Done,
      // Label 320: @12594
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(12640), // Rule ID 148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 148,
        GIR_EraseRootFromParent_Done,
      // Label 321: @12640
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(12686), // Rule ID 490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 490,
        GIR_EraseRootFromParent_Done,
      // Label 322: @12686
      GIM_Reject,
    // Label 293: @12687
    GIM_Reject,
    // Label 280: @12688
    GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(12734), // Rule ID 2523 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VANDd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2523,
      GIR_EraseRootFromParent_Done,
    // Label 323: @12734
    GIM_Reject,
    // Label 281: @12735
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(12846), // Rule ID 1850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1850,
      GIR_EraseRootFromParent_Done,
    // Label 324: @12846
    GIM_Reject,
    // Label 282: @12847
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(12893), // Rule ID 1150 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1150,
      GIR_EraseRootFromParent_Done,
    // Label 325: @12893
    GIM_Reject,
    // Label 283: @12894
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(13005),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(12945), // Rule ID 2526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VANDq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2526,
        GIR_EraseRootFromParent_Done,
      // Label 327: @12945
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(13004), // Rule ID 3467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3467,
        GIR_EraseRootFromParent_Done,
      // Label 328: @13004
      GIM_Reject,
    // Label 326: @13005
    GIM_Reject,
    // Label 284: @13006
    GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(13117), // Rule ID 1851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1851,
      GIR_EraseRootFromParent_Done,
    // Label 329: @13117
    GIM_Reject,
    // Label 285: @13118
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(13164), // Rule ID 2522 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VANDd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2522,
      GIR_EraseRootFromParent_Done,
    // Label 330: @13164
    GIM_Reject,
    // Label 286: @13165
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(13276),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(13216), // Rule ID 1151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1151,
        GIR_EraseRootFromParent_Done,
      // Label 332: @13216
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(13275), // Rule ID 3463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3463,
        GIR_EraseRootFromParent_Done,
      // Label 333: @13275
      GIM_Reject,
    // Label 331: @13276
    GIM_Reject,
    // Label 287: @13277
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(13388), // Rule ID 1852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1852,
      GIR_EraseRootFromParent_Done,
    // Label 334: @13388
    GIM_Reject,
    // Label 288: @13389
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(13435), // Rule ID 2521 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VANDd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2521,
      GIR_EraseRootFromParent_Done,
    // Label 335: @13435
    GIM_Reject,
    // Label 289: @13436
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(13547),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(13487), // Rule ID 2525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VANDq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2525,
        GIR_EraseRootFromParent_Done,
      // Label 337: @13487
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(13546), // Rule ID 3459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3459,
        GIR_EraseRootFromParent_Done,
      // Label 338: @13546
      GIM_Reject,
    // Label 336: @13547
    GIM_Reject,
    // Label 290: @13548
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(13659), // Rule ID 1853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1853,
      GIR_EraseRootFromParent_Done,
    // Label 339: @13659
    GIM_Reject,
    // Label 291: @13660
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(13771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(13711), // Rule ID 2524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VANDq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2524,
        GIR_EraseRootFromParent_Done,
      // Label 341: @13711
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(13770), // Rule ID 3455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3455,
        GIR_EraseRootFromParent_Done,
      // Label 342: @13770
      GIM_Reject,
    // Label 340: @13771
    GIM_Reject,
    // Label 292: @13772
    GIM_Reject,
    // Label 6: @13773
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 356*/ GIMT_Encode4(19503),
    /*GILLT_s32*//*Label 343*/ GIMT_Encode4(13844),
    /*GILLT_s64*//*Label 344*/ GIMT_Encode4(18419),
    /*GILLT_v2s1*//*Label 345*/ GIMT_Encode4(18466),
    /*GILLT_v2s32*//*Label 346*/ GIMT_Encode4(18578),
    /*GILLT_v2s64*//*Label 347*/ GIMT_Encode4(18625),
    /*GILLT_v4s1*//*Label 348*/ GIMT_Encode4(18737),
    /*GILLT_v4s16*//*Label 349*/ GIMT_Encode4(18849),
    /*GILLT_v4s32*//*Label 350*/ GIMT_Encode4(18896), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 351*/ GIMT_Encode4(19008),
    /*GILLT_v8s8*//*Label 352*/ GIMT_Encode4(19120),
    /*GILLT_v8s16*//*Label 353*/ GIMT_Encode4(19167), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 354*/ GIMT_Encode4(19279),
    /*GILLT_v16s8*//*Label 355*/ GIMT_Encode4(19391),
    // Label 343: @13844
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(18418),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(13982), // Rule ID 5772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5772,
        GIR_EraseRootFromParent_Done,
      // Label 358: @13982
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(14109), // Rule ID 5814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5814,
        GIR_EraseRootFromParent_Done,
      // Label 359: @14109
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(14236), // Rule ID 1938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1938,
        GIR_EraseRootFromParent_Done,
      // Label 360: @14236
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(14363), // Rule ID 2203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2203,
        GIR_EraseRootFromParent_Done,
      // Label 361: @14363
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(14496), // Rule ID 5570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5570,
        GIR_EraseRootFromParent_Done,
      // Label 362: @14496
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(14629), // Rule ID 5607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5607,
        GIR_EraseRootFromParent_Done,
      // Label 363: @14629
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(14762), // Rule ID 5777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5777,
        GIR_EraseRootFromParent_Done,
      // Label 364: @14762
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(14895), // Rule ID 5819 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5819,
        GIR_EraseRootFromParent_Done,
      // Label 365: @14895
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(15028), // Rule ID 5569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5569,
        GIR_EraseRootFromParent_Done,
      // Label 366: @15028
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(15161), // Rule ID 5606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5606,
        GIR_EraseRootFromParent_Done,
      // Label 367: @15161
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(15294), // Rule ID 203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 203,
        GIR_EraseRootFromParent_Done,
      // Label 368: @15294
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(15427), // Rule ID 548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 548,
        GIR_EraseRootFromParent_Done,
      // Label 369: @15427
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(15560), // Rule ID 1943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1943,
        GIR_EraseRootFromParent_Done,
      // Label 370: @15560
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(15693), // Rule ID 2208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2208,
        GIR_EraseRootFromParent_Done,
      // Label 371: @15693
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(15826), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 202,
        GIR_EraseRootFromParent_Done,
      // Label 372: @15826
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(15959), // Rule ID 547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 547,
        GIR_EraseRootFromParent_Done,
      // Label 373: @15959
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(16064), // Rule ID 1939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1939,
        GIR_EraseRootFromParent_Done,
      // Label 374: @16064
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(16169), // Rule ID 2204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2204,
        GIR_EraseRootFromParent_Done,
      // Label 375: @16169
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(16274), // Rule ID 5773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5773,
        GIR_EraseRootFromParent_Done,
      // Label 376: @16274
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(16379), // Rule ID 5815 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5815,
        GIR_EraseRootFromParent_Done,
      // Label 377: @16379
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(16485), // Rule ID 1942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1942,
        GIR_EraseRootFromParent_Done,
      // Label 378: @16485
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(16591), // Rule ID 2207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2207,
        GIR_EraseRootFromParent_Done,
      // Label 379: @16591
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(16697), // Rule ID 1941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1941,
        GIR_EraseRootFromParent_Done,
      // Label 380: @16697
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(16803), // Rule ID 2206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2206,
        GIR_EraseRootFromParent_Done,
      // Label 381: @16803
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(16909), // Rule ID 1940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1940,
        GIR_EraseRootFromParent_Done,
      // Label 382: @16909
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(17015), // Rule ID 2205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2205,
        GIR_EraseRootFromParent_Done,
      // Label 383: @17015
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(17121), // Rule ID 5776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5776,
        GIR_EraseRootFromParent_Done,
      // Label 384: @17121
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(17227), // Rule ID 5818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5818,
        GIR_EraseRootFromParent_Done,
      // Label 385: @17227
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(17333), // Rule ID 5775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5775,
        GIR_EraseRootFromParent_Done,
      // Label 386: @17333
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(17439), // Rule ID 5817 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5817,
        GIR_EraseRootFromParent_Done,
      // Label 387: @17439
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(17545), // Rule ID 5774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5774,
        GIR_EraseRootFromParent_Done,
      // Label 388: @17545
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(17651), // Rule ID 5816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5816,
        GIR_EraseRootFromParent_Done,
      // Label 389: @17651
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(17728), // Rule ID 5594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5594,
        GIR_EraseRootFromParent_Done,
      // Label 390: @17728
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(17805), // Rule ID 5593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5593,
        GIR_EraseRootFromParent_Done,
      // Label 391: @17805
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(17882), // Rule ID 5592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5592,
        GIR_EraseRootFromParent_Done,
      // Label 392: @17882
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(17959), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 504,
        GIR_EraseRootFromParent_Done,
      // Label 393: @17959
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(18030), // Rule ID 5595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5595,
        GIR_EraseRootFromParent_Done,
      // Label 394: @18030
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(18101), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 505,
        GIR_EraseRootFromParent_Done,
      // Label 395: @18101
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(18156), // Rule ID 1872 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MOVTi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1872,
        GIR_EraseRootFromParent_Done,
      // Label 396: @18156
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(18211), // Rule ID 2101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MOVTi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2101,
        GIR_EraseRootFromParent_Done,
      // Label 397: @18211
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(18268), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 398: @18268
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(18325), // Rule ID 492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 492,
        GIR_EraseRootFromParent_Done,
      // Label 399: @18325
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(18371), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 400: @18371
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(18417), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 493,
        GIR_EraseRootFromParent_Done,
      // Label 401: @18417
      GIM_Reject,
    // Label 357: @18418
    GIM_Reject,
    // Label 344: @18419
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(18465), // Rule ID 2529 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VORRd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2529,
      GIR_EraseRootFromParent_Done,
    // Label 402: @18465
    GIM_Reject,
    // Label 345: @18466
    GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(18577), // Rule ID 1858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1858,
      GIR_EraseRootFromParent_Done,
    // Label 403: @18577
    GIM_Reject,
    // Label 346: @18578
    GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(18624), // Rule ID 1154 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1154,
      GIR_EraseRootFromParent_Done,
    // Label 404: @18624
    GIM_Reject,
    // Label 347: @18625
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(18736),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(18676), // Rule ID 2532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VORRq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2532,
        GIR_EraseRootFromParent_Done,
      // Label 406: @18676
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(18735), // Rule ID 3481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3481,
        GIR_EraseRootFromParent_Done,
      // Label 407: @18735
      GIM_Reject,
    // Label 405: @18736
    GIM_Reject,
    // Label 348: @18737
    GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(18848), // Rule ID 1859 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1859,
      GIR_EraseRootFromParent_Done,
    // Label 408: @18848
    GIM_Reject,
    // Label 349: @18849
    GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(18895), // Rule ID 2528 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VORRd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2528,
      GIR_EraseRootFromParent_Done,
    // Label 409: @18895
    GIM_Reject,
    // Label 350: @18896
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(19007),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(18947), // Rule ID 1155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1155,
        GIR_EraseRootFromParent_Done,
      // Label 411: @18947
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(19006), // Rule ID 3477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3477,
        GIR_EraseRootFromParent_Done,
      // Label 412: @19006
      GIM_Reject,
    // Label 410: @19007
    GIM_Reject,
    // Label 351: @19008
    GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(19119), // Rule ID 1860 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1860,
      GIR_EraseRootFromParent_Done,
    // Label 413: @19119
    GIM_Reject,
    // Label 352: @19120
    GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(19166), // Rule ID 2527 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VORRd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2527,
      GIR_EraseRootFromParent_Done,
    // Label 414: @19166
    GIM_Reject,
    // Label 353: @19167
    GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(19278),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(19218), // Rule ID 2531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VORRq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2531,
        GIR_EraseRootFromParent_Done,
      // Label 416: @19218
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(19277), // Rule ID 3473 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3473,
        GIR_EraseRootFromParent_Done,
      // Label 417: @19277
      GIM_Reject,
    // Label 415: @19278
    GIM_Reject,
    // Label 354: @19279
    GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(19390), // Rule ID 1861 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1861,
      GIR_EraseRootFromParent_Done,
    // Label 418: @19390
    GIM_Reject,
    // Label 355: @19391
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(19502),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(19442), // Rule ID 2530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VORRq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2530,
        GIR_EraseRootFromParent_Done,
      // Label 420: @19442
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(19501), // Rule ID 3469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3469,
        GIR_EraseRootFromParent_Done,
      // Label 421: @19501
      GIM_Reject,
    // Label 419: @19502
    GIM_Reject,
    // Label 356: @19503
    GIM_Reject,
    // Label 7: @19504
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 435*/ GIMT_Encode4(21076),
    /*GILLT_s32*//*Label 422*/ GIMT_Encode4(19575),
    /*GILLT_s64*//*Label 423*/ GIMT_Encode4(19992),
    /*GILLT_v2s1*//*Label 424*/ GIMT_Encode4(20039),
    /*GILLT_v2s32*//*Label 425*/ GIMT_Encode4(20151),
    /*GILLT_v2s64*//*Label 426*/ GIMT_Encode4(20198),
    /*GILLT_v4s1*//*Label 427*/ GIMT_Encode4(20310),
    /*GILLT_v4s16*//*Label 428*/ GIMT_Encode4(20422),
    /*GILLT_v4s32*//*Label 429*/ GIMT_Encode4(20469), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 430*/ GIMT_Encode4(20581),
    /*GILLT_v8s8*//*Label 431*/ GIMT_Encode4(20693),
    /*GILLT_v8s16*//*Label 432*/ GIMT_Encode4(20740), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 433*/ GIMT_Encode4(20852),
    /*GILLT_v16s8*//*Label 434*/ GIMT_Encode4(20964),
    // Label 422: @19575
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(19991),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(19641), // Rule ID 5597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5597,
        GIR_EraseRootFromParent_Done,
      // Label 437: @19641
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(19696), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 507,
        GIR_EraseRootFromParent_Done,
      // Label 438: @19696
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(19740), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 508,
        GIR_EraseRootFromParent_Done,
      // Label 439: @19740
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(19784), // Rule ID 165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVNr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 165,
        GIR_EraseRootFromParent_Done,
      // Label 440: @19784
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(19841), // Rule ID 155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 155,
        GIR_EraseRootFromParent_Done,
      // Label 441: @19841
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(19898), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 495,
        GIR_EraseRootFromParent_Done,
      // Label 442: @19898
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(19944), // Rule ID 156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 156,
        GIR_EraseRootFromParent_Done,
      // Label 443: @19944
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(19990), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 496,
        GIR_EraseRootFromParent_Done,
      // Label 444: @19990
      GIM_Reject,
    // Label 436: @19991
    GIM_Reject,
    // Label 423: @19992
    GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(20038), // Rule ID 2535 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VEORd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2535,
      GIR_EraseRootFromParent_Done,
    // Label 445: @20038
    GIM_Reject,
    // Label 424: @20039
    GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(20150), // Rule ID 1854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1854,
      GIR_EraseRootFromParent_Done,
    // Label 446: @20150
    GIM_Reject,
    // Label 425: @20151
    GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(20197), // Rule ID 1152 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1152,
      GIR_EraseRootFromParent_Done,
    // Label 447: @20197
    GIM_Reject,
    // Label 426: @20198
    GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(20309),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(20249), // Rule ID 2538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VEORq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2538,
        GIR_EraseRootFromParent_Done,
      // Label 449: @20249
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(20308), // Rule ID 3495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3495,
        GIR_EraseRootFromParent_Done,
      // Label 450: @20308
      GIM_Reject,
    // Label 448: @20309
    GIM_Reject,
    // Label 427: @20310
    GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(20421), // Rule ID 1855 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1855,
      GIR_EraseRootFromParent_Done,
    // Label 451: @20421
    GIM_Reject,
    // Label 428: @20422
    GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(20468), // Rule ID 2534 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VEORd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2534,
      GIR_EraseRootFromParent_Done,
    // Label 452: @20468
    GIM_Reject,
    // Label 429: @20469
    GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(20580),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(20520), // Rule ID 1153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1153,
        GIR_EraseRootFromParent_Done,
      // Label 454: @20520
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(20579), // Rule ID 3491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3491,
        GIR_EraseRootFromParent_Done,
      // Label 455: @20579
      GIM_Reject,
    // Label 453: @20580
    GIM_Reject,
    // Label 430: @20581
    GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(20692), // Rule ID 1856 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1856,
      GIR_EraseRootFromParent_Done,
    // Label 456: @20692
    GIM_Reject,
    // Label 431: @20693
    GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(20739), // Rule ID 2533 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VEORd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2533,
      GIR_EraseRootFromParent_Done,
    // Label 457: @20739
    GIM_Reject,
    // Label 432: @20740
    GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(20851),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(20791), // Rule ID 2537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VEORq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2537,
        GIR_EraseRootFromParent_Done,
      // Label 459: @20791
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(20850), // Rule ID 3487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3487,
        GIR_EraseRootFromParent_Done,
      // Label 460: @20850
      GIM_Reject,
    // Label 458: @20851
    GIM_Reject,
    // Label 433: @20852
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(20963), // Rule ID 1857 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1857,
      GIR_EraseRootFromParent_Done,
    // Label 461: @20963
    GIM_Reject,
    // Label 434: @20964
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(21075),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(21015), // Rule ID 2536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VEORq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2536,
        GIR_EraseRootFromParent_Done,
      // Label 463: @21015
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(21074), // Rule ID 3483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3483,
        GIR_EraseRootFromParent_Done,
      // Label 464: @21074
      GIM_Reject,
    // Label 462: @21075
    GIM_Reject,
    // Label 435: @21076
    GIM_Reject,
    // Label 8: @21077
    GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(21502),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(5), GIMT_Encode2(16), /*)*//*default:*//*Label 470*/ GIMT_Encode4(21501),
      /*GILLT_v2s64*//*Label 466*/ GIMT_Encode4(21140), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v4s32*//*Label 467*/ GIMT_Encode4(21198), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v8s16*//*Label 468*/ GIMT_Encode4(21301), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v16s8*//*Label 469*/ GIMT_Encode4(21443),
      // Label 466: @21140
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(21197), // Rule ID 3116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Dn, DPR:{ *:[v1i64] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v2i64] } QPR:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        // GIR_Coverage, 3116,
        GIR_EraseRootFromParent_Done,
      // Label 471: @21197
      GIM_Reject,
      // Label 467: @21198
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(21300),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(21260), // Rule ID 3117 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4i32] } DPR:{ *:[v2i32] }:$Dn, DPR:{ *:[v2i32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4i32] } QPR:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3117,
          GIR_EraseRootFromParent_Done,
        // Label 473: @21260
        GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(21299), // Rule ID 3120 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4f32] } DPR:{ *:[v2f32] }:$Dn, DPR:{ *:[v2f32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4f32] } QPR:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3120,
          GIR_EraseRootFromParent_Done,
        // Label 474: @21299
        GIM_Reject,
      // Label 472: @21300
      GIM_Reject,
      // Label 468: @21301
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(21442),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(21363), // Rule ID 3118 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8i16] } DPR:{ *:[v4i16] }:$Dn, DPR:{ *:[v4i16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8i16] } QPR:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3118,
          GIR_EraseRootFromParent_Done,
        // Label 476: @21363
        GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(21402), // Rule ID 3121 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8f16] } DPR:{ *:[v4f16] }:$Dn, DPR:{ *:[v4f16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8f16] } QPR:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3121,
          GIR_EraseRootFromParent_Done,
        // Label 477: @21402
        GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(21441), // Rule ID 3122 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8bf16] } DPR:{ *:[v4bf16] }:$Dn, DPR:{ *:[v4bf16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8bf16] } QPR:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4bf16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3122,
          GIR_EraseRootFromParent_Done,
        // Label 478: @21441
        GIM_Reject,
      // Label 475: @21442
      GIM_Reject,
      // Label 469: @21443
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(21500), // Rule ID 3119 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v16i8] } DPR:{ *:[v8i8] }:$Dn, DPR:{ *:[v8i8] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v16i8] } QPR:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        // GIR_Coverage, 3119,
        GIR_EraseRootFromParent_Done,
      // Label 479: @21500
      GIM_Reject,
      // Label 470: @21501
      GIM_Reject,
    // Label 465: @21502
    GIM_Reject,
    // Label 9: @21503
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 489*/ GIMT_Encode4(31950),
    /*GILLT_s32*//*Label 480*/ GIMT_Encode4(21574),
    /*GILLT_s64*//*Label 481*/ GIMT_Encode4(21722), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 482*/ GIMT_Encode4(22615),
    /*GILLT_v2s64*//*Label 483*/ GIMT_Encode4(23508), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 484*/ GIMT_Encode4(25345),
    /*GILLT_v4s32*//*Label 485*/ GIMT_Encode4(26509), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 486*/ GIMT_Encode4(28346),
    /*GILLT_v8s16*//*Label 487*/ GIMT_Encode4(28830), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 488*/ GIMT_Encode4(30938),
    // Label 480: @21574
    GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(21721),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(21616), // Rule ID 706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // Sn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 706,
        GIR_EraseRootFromParent_Done,
      // Label 491: @21616
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(21650), // Rule ID 707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs_UseVMOVSR),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVSR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rt
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 707,
        GIR_EraseRootFromParent_Done,
      // Label 492: @21650
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(21720), // Rule ID 2736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseVMOVSR_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$a)  =>  (EXTRACT_SUBREG:{ *:[f32] } (VMOVDRR:{ *:[f64] } GPR:{ *:[i32] }:$a, GPR:{ *:[i32] }:$a), ssub_0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::VMOVDRR),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPR_VFP2RegClassID),
        // GIR_Coverage, 2736,
        GIR_EraseRootFromParent_Done,
      // Label 493: @21720
      GIM_Reject,
    // Label 490: @21721
    GIM_Reject,
    // Label 481: @21722
    GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(21754), // Rule ID 2738 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2738,
      GIR_EraseRootFromParent_Done,
    // Label 494: @21754
    GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(21786), // Rule ID 2739 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2739,
      GIR_EraseRootFromParent_Done,
    // Label 495: @21786
    GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(21818), // Rule ID 2754 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2754,
      GIR_EraseRootFromParent_Done,
    // Label 496: @21818
    GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(21850), // Rule ID 2755 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2755,
      GIR_EraseRootFromParent_Done,
    // Label 497: @21850
    GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(21882), // Rule ID 2756 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2756,
      GIR_EraseRootFromParent_Done,
    // Label 498: @21882
    GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(21914), // Rule ID 2757 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2757,
      GIR_EraseRootFromParent_Done,
    // Label 499: @21914
    GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(21946), // Rule ID 2758 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2758,
      GIR_EraseRootFromParent_Done,
    // Label 500: @21946
    GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(21978), // Rule ID 2759 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2759,
      GIR_EraseRootFromParent_Done,
    // Label 501: @21978
    GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(22010), // Rule ID 2760 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2760,
      GIR_EraseRootFromParent_Done,
    // Label 502: @22010
    GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(22042), // Rule ID 2761 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2761,
      GIR_EraseRootFromParent_Done,
    // Label 503: @22042
    GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(22074), // Rule ID 2762 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2762,
      GIR_EraseRootFromParent_Done,
    // Label 504: @22074
    GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(22106), // Rule ID 2763 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2763,
      GIR_EraseRootFromParent_Done,
    // Label 505: @22106
    GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(22138), // Rule ID 2764 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2764,
      GIR_EraseRootFromParent_Done,
    // Label 506: @22138
    GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(22170), // Rule ID 2765 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2765,
      GIR_EraseRootFromParent_Done,
    // Label 507: @22170
    GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(22207), // Rule ID 2846 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2846,
      GIR_EraseRootFromParent_Done,
    // Label 508: @22207
    GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(22244), // Rule ID 2847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2847,
      GIR_EraseRootFromParent_Done,
    // Label 509: @22244
    GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(22281), // Rule ID 2848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2848,
      GIR_EraseRootFromParent_Done,
    // Label 510: @22281
    GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(22318), // Rule ID 2849 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2849,
      GIR_EraseRootFromParent_Done,
    // Label 511: @22318
    GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(22355), // Rule ID 2850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2850,
      GIR_EraseRootFromParent_Done,
    // Label 512: @22355
    GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(22392), // Rule ID 2851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2851,
      GIR_EraseRootFromParent_Done,
    // Label 513: @22392
    GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(22429), // Rule ID 2852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2852,
      GIR_EraseRootFromParent_Done,
    // Label 514: @22429
    GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(22466), // Rule ID 2853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2853,
      GIR_EraseRootFromParent_Done,
    // Label 515: @22466
    GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(22503), // Rule ID 2854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2854,
      GIR_EraseRootFromParent_Done,
    // Label 516: @22503
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(22540), // Rule ID 2855 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2855,
      GIR_EraseRootFromParent_Done,
    // Label 517: @22540
    GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(22577), // Rule ID 2856 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2856,
      GIR_EraseRootFromParent_Done,
    // Label 518: @22577
    GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(22614), // Rule ID 2857 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2857,
      GIR_EraseRootFromParent_Done,
    // Label 519: @22614
    GIM_Reject,
    // Label 482: @22615
    GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(22647), // Rule ID 2740 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2740,
      GIR_EraseRootFromParent_Done,
    // Label 520: @22647
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(22679), // Rule ID 2741 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2741,
      GIR_EraseRootFromParent_Done,
    // Label 521: @22679
    GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(22711), // Rule ID 2766 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2766,
      GIR_EraseRootFromParent_Done,
    // Label 522: @22711
    GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(22743), // Rule ID 2767 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2767,
      GIR_EraseRootFromParent_Done,
    // Label 523: @22743
    GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(22775), // Rule ID 2768 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2768,
      GIR_EraseRootFromParent_Done,
    // Label 524: @22775
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(22807), // Rule ID 2769 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2769,
      GIR_EraseRootFromParent_Done,
    // Label 525: @22807
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(22839), // Rule ID 2770 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2770,
      GIR_EraseRootFromParent_Done,
    // Label 526: @22839
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(22871), // Rule ID 2771 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2771,
      GIR_EraseRootFromParent_Done,
    // Label 527: @22871
    GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(22903), // Rule ID 2772 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2772,
      GIR_EraseRootFromParent_Done,
    // Label 528: @22903
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(22935), // Rule ID 2773 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2773,
      GIR_EraseRootFromParent_Done,
    // Label 529: @22935
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(22967), // Rule ID 2774 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2774,
      GIR_EraseRootFromParent_Done,
    // Label 530: @22967
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(22999), // Rule ID 2775 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2775,
      GIR_EraseRootFromParent_Done,
    // Label 531: @22999
    GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(23031), // Rule ID 2776 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2776,
      GIR_EraseRootFromParent_Done,
    // Label 532: @23031
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(23063), // Rule ID 2777 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2777,
      GIR_EraseRootFromParent_Done,
    // Label 533: @23063
    GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(23100), // Rule ID 2858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2858,
      GIR_EraseRootFromParent_Done,
    // Label 534: @23100
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(23137), // Rule ID 2859 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2859,
      GIR_EraseRootFromParent_Done,
    // Label 535: @23137
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(23174), // Rule ID 2860 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2860,
      GIR_EraseRootFromParent_Done,
    // Label 536: @23174
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(23211), // Rule ID 2861 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2861,
      GIR_EraseRootFromParent_Done,
    // Label 537: @23211
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(23248), // Rule ID 2862 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2862,
      GIR_EraseRootFromParent_Done,
    // Label 538: @23248
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(23285), // Rule ID 2863 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2863,
      GIR_EraseRootFromParent_Done,
    // Label 539: @23285
    GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(23322), // Rule ID 2864 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2864,
      GIR_EraseRootFromParent_Done,
    // Label 540: @23322
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(23359), // Rule ID 2865 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2865,
      GIR_EraseRootFromParent_Done,
    // Label 541: @23359
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(23396), // Rule ID 2866 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2866,
      GIR_EraseRootFromParent_Done,
    // Label 542: @23396
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(23433), // Rule ID 2867 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2867,
      GIR_EraseRootFromParent_Done,
    // Label 543: @23433
    GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(23470), // Rule ID 2868 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2868,
      GIR_EraseRootFromParent_Done,
    // Label 544: @23470
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(23507), // Rule ID 2869 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2869,
      GIR_EraseRootFromParent_Done,
    // Label 545: @23507
    GIM_Reject,
    // Label 483: @23508
    GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(23540), // Rule ID 2746 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2746,
      GIR_EraseRootFromParent_Done,
    // Label 546: @23540
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(23572), // Rule ID 2747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2747,
      GIR_EraseRootFromParent_Done,
    // Label 547: @23572
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(23604), // Rule ID 2800 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2800,
      GIR_EraseRootFromParent_Done,
    // Label 548: @23604
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(23636), // Rule ID 2801 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2801,
      GIR_EraseRootFromParent_Done,
    // Label 549: @23636
    GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(23668), // Rule ID 2802 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2802,
      GIR_EraseRootFromParent_Done,
    // Label 550: @23668
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(23700), // Rule ID 2803 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2803,
      GIR_EraseRootFromParent_Done,
    // Label 551: @23700
    GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(23732), // Rule ID 2804 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2804,
      GIR_EraseRootFromParent_Done,
    // Label 552: @23732
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(23764), // Rule ID 2805 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2805,
      GIR_EraseRootFromParent_Done,
    // Label 553: @23764
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(23796), // Rule ID 2806 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2806,
      GIR_EraseRootFromParent_Done,
    // Label 554: @23796
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(23828), // Rule ID 2807 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2807,
      GIR_EraseRootFromParent_Done,
    // Label 555: @23828
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(23860), // Rule ID 2808 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2808,
      GIR_EraseRootFromParent_Done,
    // Label 556: @23860
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(23892), // Rule ID 2809 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2809,
      GIR_EraseRootFromParent_Done,
    // Label 557: @23892
    GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(23924), // Rule ID 2810 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2810,
      GIR_EraseRootFromParent_Done,
    // Label 558: @23924
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(23956), // Rule ID 2811 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2811,
      GIR_EraseRootFromParent_Done,
    // Label 559: @23956
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(23993), // Rule ID 2892 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2892,
      GIR_EraseRootFromParent_Done,
    // Label 560: @23993
    GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(24030), // Rule ID 2893 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2893,
      GIR_EraseRootFromParent_Done,
    // Label 561: @24030
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(24067), // Rule ID 2894 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2894,
      GIR_EraseRootFromParent_Done,
    // Label 562: @24067
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(24104), // Rule ID 2895 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2895,
      GIR_EraseRootFromParent_Done,
    // Label 563: @24104
    GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(24141), // Rule ID 2896 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2896,
      GIR_EraseRootFromParent_Done,
    // Label 564: @24141
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(24178), // Rule ID 2897 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2897,
      GIR_EraseRootFromParent_Done,
    // Label 565: @24178
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(24215), // Rule ID 2898 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2898,
      GIR_EraseRootFromParent_Done,
    // Label 566: @24215
    GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(24252), // Rule ID 2899 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2899,
      GIR_EraseRootFromParent_Done,
    // Label 567: @24252
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(24289), // Rule ID 2900 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2900,
      GIR_EraseRootFromParent_Done,
    // Label 568: @24289
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(24326), // Rule ID 2901 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2901,
      GIR_EraseRootFromParent_Done,
    // Label 569: @24326
    GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(24363), // Rule ID 2902 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2902,
      GIR_EraseRootFromParent_Done,
    // Label 570: @24363
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(24400), // Rule ID 2903 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2903,
      GIR_EraseRootFromParent_Done,
    // Label 571: @24400
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(24432), // Rule ID 5400 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5400,
      GIR_EraseRootFromParent_Done,
    // Label 572: @24432
    GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(24464), // Rule ID 5401 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5401,
      GIR_EraseRootFromParent_Done,
    // Label 573: @24464
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(24496), // Rule ID 5406 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5406,
      GIR_EraseRootFromParent_Done,
    // Label 574: @24496
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(24528), // Rule ID 5407 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5407,
      GIR_EraseRootFromParent_Done,
    // Label 575: @24528
    GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(24560), // Rule ID 5408 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5408,
      GIR_EraseRootFromParent_Done,
    // Label 576: @24560
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(24592), // Rule ID 5409 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5409,
      GIR_EraseRootFromParent_Done,
    // Label 577: @24592
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(24624), // Rule ID 5410 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5410,
      GIR_EraseRootFromParent_Done,
    // Label 578: @24624
    GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(24656), // Rule ID 5411 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5411,
      GIR_EraseRootFromParent_Done,
    // Label 579: @24656
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(24688), // Rule ID 5412 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5412,
      GIR_EraseRootFromParent_Done,
    // Label 580: @24688
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(24720), // Rule ID 5413 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5413,
      GIR_EraseRootFromParent_Done,
    // Label 581: @24720
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(24752), // Rule ID 5414 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5414,
      GIR_EraseRootFromParent_Done,
    // Label 582: @24752
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(24784), // Rule ID 5415 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5415,
      GIR_EraseRootFromParent_Done,
    // Label 583: @24784
    GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(24840), // Rule ID 5442 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5442,
      GIR_EraseRootFromParent_Done,
    // Label 584: @24840
    GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(24896), // Rule ID 5443 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5443,
      GIR_EraseRootFromParent_Done,
    // Label 585: @24896
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(24952), // Rule ID 5444 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5444,
      GIR_EraseRootFromParent_Done,
    // Label 586: @24952
    GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(25008), // Rule ID 5445 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5445,
      GIR_EraseRootFromParent_Done,
    // Label 587: @25008
    GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(25064), // Rule ID 5446 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5446,
      GIR_EraseRootFromParent_Done,
    // Label 588: @25064
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(25120), // Rule ID 5447 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5447,
      GIR_EraseRootFromParent_Done,
    // Label 589: @25120
    GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(25176), // Rule ID 5448 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5448,
      GIR_EraseRootFromParent_Done,
    // Label 590: @25176
    GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(25232), // Rule ID 5449 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5449,
      GIR_EraseRootFromParent_Done,
    // Label 591: @25232
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(25288), // Rule ID 5450 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5450,
      GIR_EraseRootFromParent_Done,
    // Label 592: @25288
    GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(25344), // Rule ID 5451 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5451,
      GIR_EraseRootFromParent_Done,
    // Label 593: @25344
    GIM_Reject,
    // Label 484: @25345
    GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(25377), // Rule ID 2742 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2742,
      GIR_EraseRootFromParent_Done,
    // Label 594: @25377
    GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(25409), // Rule ID 2743 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2743,
      GIR_EraseRootFromParent_Done,
    // Label 595: @25409
    GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(25441), // Rule ID 2744 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2744,
      GIR_EraseRootFromParent_Done,
    // Label 596: @25441
    GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(25473), // Rule ID 2745 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2745,
      GIR_EraseRootFromParent_Done,
    // Label 597: @25473
    GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(25505), // Rule ID 2778 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2778,
      GIR_EraseRootFromParent_Done,
    // Label 598: @25505
    GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(25537), // Rule ID 2779 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2779,
      GIR_EraseRootFromParent_Done,
    // Label 599: @25537
    GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(25569), // Rule ID 2780 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2780,
      GIR_EraseRootFromParent_Done,
    // Label 600: @25569
    GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(25601), // Rule ID 2781 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2781,
      GIR_EraseRootFromParent_Done,
    // Label 601: @25601
    GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(25633), // Rule ID 2782 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2782,
      GIR_EraseRootFromParent_Done,
    // Label 602: @25633
    GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(25665), // Rule ID 2783 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2783,
      GIR_EraseRootFromParent_Done,
    // Label 603: @25665
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(25697), // Rule ID 2784 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2784,
      GIR_EraseRootFromParent_Done,
    // Label 604: @25697
    GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(25729), // Rule ID 2785 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2785,
      GIR_EraseRootFromParent_Done,
    // Label 605: @25729
    GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(25761), // Rule ID 2786 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2786,
      GIR_EraseRootFromParent_Done,
    // Label 606: @25761
    GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(25793), // Rule ID 2787 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2787,
      GIR_EraseRootFromParent_Done,
    // Label 607: @25793
    GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(25825), // Rule ID 2788 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2788,
      GIR_EraseRootFromParent_Done,
    // Label 608: @25825
    GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(25857), // Rule ID 2789 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2789,
      GIR_EraseRootFromParent_Done,
    // Label 609: @25857
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(25889), // Rule ID 2790 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2790,
      GIR_EraseRootFromParent_Done,
    // Label 610: @25889
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(25921), // Rule ID 2791 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2791,
      GIR_EraseRootFromParent_Done,
    // Label 611: @25921
    GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(25953), // Rule ID 2792 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2792,
      GIR_EraseRootFromParent_Done,
    // Label 612: @25953
    GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(25990), // Rule ID 2870 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2870,
      GIR_EraseRootFromParent_Done,
    // Label 613: @25990
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(26027), // Rule ID 2871 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2871,
      GIR_EraseRootFromParent_Done,
    // Label 614: @26027
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(26064), // Rule ID 2872 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2872,
      GIR_EraseRootFromParent_Done,
    // Label 615: @26064
    GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(26101), // Rule ID 2873 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2873,
      GIR_EraseRootFromParent_Done,
    // Label 616: @26101
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(26138), // Rule ID 2874 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2874,
      GIR_EraseRootFromParent_Done,
    // Label 617: @26138
    GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(26175), // Rule ID 2875 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2875,
      GIR_EraseRootFromParent_Done,
    // Label 618: @26175
    GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(26212), // Rule ID 2876 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4bf16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2876,
      GIR_EraseRootFromParent_Done,
    // Label 619: @26212
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(26249), // Rule ID 2877 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2877,
      GIR_EraseRootFromParent_Done,
    // Label 620: @26249
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(26286), // Rule ID 2878 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4bf16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2878,
      GIR_EraseRootFromParent_Done,
    // Label 621: @26286
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(26323), // Rule ID 2879 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4bf16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2879,
      GIR_EraseRootFromParent_Done,
    // Label 622: @26323
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(26360), // Rule ID 2880 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2880,
      GIR_EraseRootFromParent_Done,
    // Label 623: @26360
    GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(26397), // Rule ID 2881 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2881,
      GIR_EraseRootFromParent_Done,
    // Label 624: @26397
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(26434), // Rule ID 2882 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2882,
      GIR_EraseRootFromParent_Done,
    // Label 625: @26434
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(26471), // Rule ID 2883 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2883,
      GIR_EraseRootFromParent_Done,
    // Label 626: @26471
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(26508), // Rule ID 2884 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2884,
      GIR_EraseRootFromParent_Done,
    // Label 627: @26508
    GIM_Reject,
    // Label 485: @26509
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(26541), // Rule ID 2748 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2748,
      GIR_EraseRootFromParent_Done,
    // Label 628: @26541
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(26573), // Rule ID 2749 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2749,
      GIR_EraseRootFromParent_Done,
    // Label 629: @26573
    GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(26605), // Rule ID 2812 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2812,
      GIR_EraseRootFromParent_Done,
    // Label 630: @26605
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(26637), // Rule ID 2813 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2813,
      GIR_EraseRootFromParent_Done,
    // Label 631: @26637
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(26669), // Rule ID 2814 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2814,
      GIR_EraseRootFromParent_Done,
    // Label 632: @26669
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(26701), // Rule ID 2815 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2815,
      GIR_EraseRootFromParent_Done,
    // Label 633: @26701
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(26733), // Rule ID 2816 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2816,
      GIR_EraseRootFromParent_Done,
    // Label 634: @26733
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(26765), // Rule ID 2817 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2817,
      GIR_EraseRootFromParent_Done,
    // Label 635: @26765
    GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(26797), // Rule ID 2818 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2818,
      GIR_EraseRootFromParent_Done,
    // Label 636: @26797
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(26829), // Rule ID 2819 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2819,
      GIR_EraseRootFromParent_Done,
    // Label 637: @26829
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(26861), // Rule ID 2820 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2820,
      GIR_EraseRootFromParent_Done,
    // Label 638: @26861
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(26893), // Rule ID 2821 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2821,
      GIR_EraseRootFromParent_Done,
    // Label 639: @26893
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(26925), // Rule ID 2822 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2822,
      GIR_EraseRootFromParent_Done,
    // Label 640: @26925
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(26957), // Rule ID 2823 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2823,
      GIR_EraseRootFromParent_Done,
    // Label 641: @26957
    GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(26994), // Rule ID 2904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2904,
      GIR_EraseRootFromParent_Done,
    // Label 642: @26994
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(27031), // Rule ID 2905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2905,
      GIR_EraseRootFromParent_Done,
    // Label 643: @27031
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(27068), // Rule ID 2906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2906,
      GIR_EraseRootFromParent_Done,
    // Label 644: @27068
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(27105), // Rule ID 2907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2907,
      GIR_EraseRootFromParent_Done,
    // Label 645: @27105
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(27142), // Rule ID 2908 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2908,
      GIR_EraseRootFromParent_Done,
    // Label 646: @27142
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(27179), // Rule ID 2909 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2909,
      GIR_EraseRootFromParent_Done,
    // Label 647: @27179
    GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(27216), // Rule ID 2910 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2910,
      GIR_EraseRootFromParent_Done,
    // Label 648: @27216
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(27253), // Rule ID 2911 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2911,
      GIR_EraseRootFromParent_Done,
    // Label 649: @27253
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(27290), // Rule ID 2912 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2912,
      GIR_EraseRootFromParent_Done,
    // Label 650: @27290
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(27327), // Rule ID 2913 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2913,
      GIR_EraseRootFromParent_Done,
    // Label 651: @27327
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(27364), // Rule ID 2914 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2914,
      GIR_EraseRootFromParent_Done,
    // Label 652: @27364
    GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(27401), // Rule ID 2915 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2915,
      GIR_EraseRootFromParent_Done,
    // Label 653: @27401
    GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(27433), // Rule ID 5402 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5402,
      GIR_EraseRootFromParent_Done,
    // Label 654: @27433
    GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(27465), // Rule ID 5403 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5403,
      GIR_EraseRootFromParent_Done,
    // Label 655: @27465
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(27497), // Rule ID 5416 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5416,
      GIR_EraseRootFromParent_Done,
    // Label 656: @27497
    GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(27529), // Rule ID 5417 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5417,
      GIR_EraseRootFromParent_Done,
    // Label 657: @27529
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(27561), // Rule ID 5418 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5418,
      GIR_EraseRootFromParent_Done,
    // Label 658: @27561
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(27593), // Rule ID 5419 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5419,
      GIR_EraseRootFromParent_Done,
    // Label 659: @27593
    GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(27625), // Rule ID 5420 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5420,
      GIR_EraseRootFromParent_Done,
    // Label 660: @27625
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(27657), // Rule ID 5421 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5421,
      GIR_EraseRootFromParent_Done,
    // Label 661: @27657
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(27689), // Rule ID 5422 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5422,
      GIR_EraseRootFromParent_Done,
    // Label 662: @27689
    GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(27721), // Rule ID 5423 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5423,
      GIR_EraseRootFromParent_Done,
    // Label 663: @27721
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(27753), // Rule ID 5424 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5424,
      GIR_EraseRootFromParent_Done,
    // Label 664: @27753
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(27785), // Rule ID 5425 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5425,
      GIR_EraseRootFromParent_Done,
    // Label 665: @27785
    GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(27841), // Rule ID 5452 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5452,
      GIR_EraseRootFromParent_Done,
    // Label 666: @27841
    GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(27897), // Rule ID 5453 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5453,
      GIR_EraseRootFromParent_Done,
    // Label 667: @27897
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(27953), // Rule ID 5454 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5454,
      GIR_EraseRootFromParent_Done,
    // Label 668: @27953
    GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(28009), // Rule ID 5455 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5455,
      GIR_EraseRootFromParent_Done,
    // Label 669: @28009
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(28065), // Rule ID 5456 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5456,
      GIR_EraseRootFromParent_Done,
    // Label 670: @28065
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(28121), // Rule ID 5457 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5457,
      GIR_EraseRootFromParent_Done,
    // Label 671: @28121
    GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(28177), // Rule ID 5458 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5458,
      GIR_EraseRootFromParent_Done,
    // Label 672: @28177
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(28233), // Rule ID 5459 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5459,
      GIR_EraseRootFromParent_Done,
    // Label 673: @28233
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(28289), // Rule ID 5460 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5460,
      GIR_EraseRootFromParent_Done,
    // Label 674: @28289
    GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(28345), // Rule ID 5461 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5461,
      GIR_EraseRootFromParent_Done,
    // Label 675: @28345
    GIM_Reject,
    // Label 486: @28346
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(28378), // Rule ID 2793 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2793,
      GIR_EraseRootFromParent_Done,
    // Label 676: @28378
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(28410), // Rule ID 2794 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2794,
      GIR_EraseRootFromParent_Done,
    // Label 677: @28410
    GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(28442), // Rule ID 2795 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2795,
      GIR_EraseRootFromParent_Done,
    // Label 678: @28442
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(28474), // Rule ID 2796 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2796,
      GIR_EraseRootFromParent_Done,
    // Label 679: @28474
    GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(28506), // Rule ID 2797 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2797,
      GIR_EraseRootFromParent_Done,
    // Label 680: @28506
    GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(28538), // Rule ID 2798 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2798,
      GIR_EraseRootFromParent_Done,
    // Label 681: @28538
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(28570), // Rule ID 2799 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2799,
      GIR_EraseRootFromParent_Done,
    // Label 682: @28570
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(28607), // Rule ID 2885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2885,
      GIR_EraseRootFromParent_Done,
    // Label 683: @28607
    GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(28644), // Rule ID 2886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2886,
      GIR_EraseRootFromParent_Done,
    // Label 684: @28644
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(28681), // Rule ID 2887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2887,
      GIR_EraseRootFromParent_Done,
    // Label 685: @28681
    GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(28718), // Rule ID 2888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2888,
      GIR_EraseRootFromParent_Done,
    // Label 686: @28718
    GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(28755), // Rule ID 2889 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2889,
      GIR_EraseRootFromParent_Done,
    // Label 687: @28755
    GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(28792), // Rule ID 2890 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2890,
      GIR_EraseRootFromParent_Done,
    // Label 688: @28792
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(28829), // Rule ID 2891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2891,
      GIR_EraseRootFromParent_Done,
    // Label 689: @28829
    GIM_Reject,
    // Label 487: @28830
    GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(28862), // Rule ID 2750 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2750,
      GIR_EraseRootFromParent_Done,
    // Label 690: @28862
    GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(28894), // Rule ID 2751 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2751,
      GIR_EraseRootFromParent_Done,
    // Label 691: @28894
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(28926), // Rule ID 2752 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2752,
      GIR_EraseRootFromParent_Done,
    // Label 692: @28926
    GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(28958), // Rule ID 2753 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2753,
      GIR_EraseRootFromParent_Done,
    // Label 693: @28958
    GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(28990), // Rule ID 2824 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2824,
      GIR_EraseRootFromParent_Done,
    // Label 694: @28990
    GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(29022), // Rule ID 2825 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2825,
      GIR_EraseRootFromParent_Done,
    // Label 695: @29022
    GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(29054), // Rule ID 2826 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2826,
      GIR_EraseRootFromParent_Done,
    // Label 696: @29054
    GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(29086), // Rule ID 2827 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2827,
      GIR_EraseRootFromParent_Done,
    // Label 697: @29086
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(29118), // Rule ID 2828 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2828,
      GIR_EraseRootFromParent_Done,
    // Label 698: @29118
    GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(29150), // Rule ID 2829 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2829,
      GIR_EraseRootFromParent_Done,
    // Label 699: @29150
    GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(29182), // Rule ID 2830 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2830,
      GIR_EraseRootFromParent_Done,
    // Label 700: @29182
    GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(29214), // Rule ID 2831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2831,
      GIR_EraseRootFromParent_Done,
    // Label 701: @29214
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(29246), // Rule ID 2832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2832,
      GIR_EraseRootFromParent_Done,
    // Label 702: @29246
    GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(29278), // Rule ID 2833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8bf16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2833,
      GIR_EraseRootFromParent_Done,
    // Label 703: @29278
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(29310), // Rule ID 2834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2834,
      GIR_EraseRootFromParent_Done,
    // Label 704: @29310
    GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(29342), // Rule ID 2835 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2835,
      GIR_EraseRootFromParent_Done,
    // Label 705: @29342
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(29374), // Rule ID 2836 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2836,
      GIR_EraseRootFromParent_Done,
    // Label 706: @29374
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(29406), // Rule ID 2837 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2837,
      GIR_EraseRootFromParent_Done,
    // Label 707: @29406
    GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(29438), // Rule ID 2838 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2838,
      GIR_EraseRootFromParent_Done,
    // Label 708: @29438
    GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(29475), // Rule ID 2916 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2916,
      GIR_EraseRootFromParent_Done,
    // Label 709: @29475
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(29512), // Rule ID 2917 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2917,
      GIR_EraseRootFromParent_Done,
    // Label 710: @29512
    GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(29549), // Rule ID 2918 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2918,
      GIR_EraseRootFromParent_Done,
    // Label 711: @29549
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(29586), // Rule ID 2919 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2919,
      GIR_EraseRootFromParent_Done,
    // Label 712: @29586
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(29623), // Rule ID 2920 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2920,
      GIR_EraseRootFromParent_Done,
    // Label 713: @29623
    GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(29660), // Rule ID 2921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2921,
      GIR_EraseRootFromParent_Done,
    // Label 714: @29660
    GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(29697), // Rule ID 2922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8bf16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2922,
      GIR_EraseRootFromParent_Done,
    // Label 715: @29697
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(29734), // Rule ID 2923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2923,
      GIR_EraseRootFromParent_Done,
    // Label 716: @29734
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(29771), // Rule ID 2924 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8bf16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2924,
      GIR_EraseRootFromParent_Done,
    // Label 717: @29771
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(29808), // Rule ID 2925 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8bf16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2925,
      GIR_EraseRootFromParent_Done,
    // Label 718: @29808
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(29845), // Rule ID 2926 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2926,
      GIR_EraseRootFromParent_Done,
    // Label 719: @29845
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(29882), // Rule ID 2927 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2927,
      GIR_EraseRootFromParent_Done,
    // Label 720: @29882
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(29919), // Rule ID 2928 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2928,
      GIR_EraseRootFromParent_Done,
    // Label 721: @29919
    GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(29956), // Rule ID 2929 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2929,
      GIR_EraseRootFromParent_Done,
    // Label 722: @29956
    GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(29993), // Rule ID 2930 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2930,
      GIR_EraseRootFromParent_Done,
    // Label 723: @29993
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(30025), // Rule ID 5404 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5404,
      GIR_EraseRootFromParent_Done,
    // Label 724: @30025
    GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(30057), // Rule ID 5405 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5405,
      GIR_EraseRootFromParent_Done,
    // Label 725: @30057
    GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(30089), // Rule ID 5426 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5426,
      GIR_EraseRootFromParent_Done,
    // Label 726: @30089
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(30121), // Rule ID 5427 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5427,
      GIR_EraseRootFromParent_Done,
    // Label 727: @30121
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(30153), // Rule ID 5428 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5428,
      GIR_EraseRootFromParent_Done,
    // Label 728: @30153
    GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(30185), // Rule ID 5429 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5429,
      GIR_EraseRootFromParent_Done,
    // Label 729: @30185
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(30217), // Rule ID 5430 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5430,
      GIR_EraseRootFromParent_Done,
    // Label 730: @30217
    GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(30249), // Rule ID 5431 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5431,
      GIR_EraseRootFromParent_Done,
    // Label 731: @30249
    GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(30281), // Rule ID 5432 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5432,
      GIR_EraseRootFromParent_Done,
    // Label 732: @30281
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(30313), // Rule ID 5433 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5433,
      GIR_EraseRootFromParent_Done,
    // Label 733: @30313
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(30345), // Rule ID 5434 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5434,
      GIR_EraseRootFromParent_Done,
    // Label 734: @30345
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(30377), // Rule ID 5435 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5435,
      GIR_EraseRootFromParent_Done,
    // Label 735: @30377
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(30433), // Rule ID 5462 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5462,
      GIR_EraseRootFromParent_Done,
    // Label 736: @30433
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(30489), // Rule ID 5463 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5463,
      GIR_EraseRootFromParent_Done,
    // Label 737: @30489
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(30545), // Rule ID 5464 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5464,
      GIR_EraseRootFromParent_Done,
    // Label 738: @30545
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(30601), // Rule ID 5465 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5465,
      GIR_EraseRootFromParent_Done,
    // Label 739: @30601
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(30657), // Rule ID 5466 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5466,
      GIR_EraseRootFromParent_Done,
    // Label 740: @30657
    GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(30713), // Rule ID 5467 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5467,
      GIR_EraseRootFromParent_Done,
    // Label 741: @30713
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(30769), // Rule ID 5468 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5468,
      GIR_EraseRootFromParent_Done,
    // Label 742: @30769
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(30825), // Rule ID 5469 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5469,
      GIR_EraseRootFromParent_Done,
    // Label 743: @30825
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(30881), // Rule ID 5470 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5470,
      GIR_EraseRootFromParent_Done,
    // Label 744: @30881
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(30937), // Rule ID 5471 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5471,
      GIR_EraseRootFromParent_Done,
    // Label 745: @30937
    GIM_Reject,
    // Label 488: @30938
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(30970), // Rule ID 2839 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2839,
      GIR_EraseRootFromParent_Done,
    // Label 746: @30970
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(31002), // Rule ID 2840 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2840,
      GIR_EraseRootFromParent_Done,
    // Label 747: @31002
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(31034), // Rule ID 2841 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2841,
      GIR_EraseRootFromParent_Done,
    // Label 748: @31034
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(31066), // Rule ID 2842 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2842,
      GIR_EraseRootFromParent_Done,
    // Label 749: @31066
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(31098), // Rule ID 2843 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2843,
      GIR_EraseRootFromParent_Done,
    // Label 750: @31098
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(31130), // Rule ID 2844 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2844,
      GIR_EraseRootFromParent_Done,
    // Label 751: @31130
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(31162), // Rule ID 2845 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2845,
      GIR_EraseRootFromParent_Done,
    // Label 752: @31162
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(31199), // Rule ID 2931 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2931,
      GIR_EraseRootFromParent_Done,
    // Label 753: @31199
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(31236), // Rule ID 2932 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2932,
      GIR_EraseRootFromParent_Done,
    // Label 754: @31236
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(31273), // Rule ID 2933 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2933,
      GIR_EraseRootFromParent_Done,
    // Label 755: @31273
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(31310), // Rule ID 2934 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2934,
      GIR_EraseRootFromParent_Done,
    // Label 756: @31310
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(31347), // Rule ID 2935 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2935,
      GIR_EraseRootFromParent_Done,
    // Label 757: @31347
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(31384), // Rule ID 2936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8bf16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2936,
      GIR_EraseRootFromParent_Done,
    // Label 758: @31384
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(31421), // Rule ID 2937 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2937,
      GIR_EraseRootFromParent_Done,
    // Label 759: @31421
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(31453), // Rule ID 5436 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5436,
      GIR_EraseRootFromParent_Done,
    // Label 760: @31453
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(31485), // Rule ID 5437 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5437,
      GIR_EraseRootFromParent_Done,
    // Label 761: @31485
    GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(31517), // Rule ID 5438 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5438,
      GIR_EraseRootFromParent_Done,
    // Label 762: @31517
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(31549), // Rule ID 5439 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5439,
      GIR_EraseRootFromParent_Done,
    // Label 763: @31549
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(31581), // Rule ID 5440 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5440,
      GIR_EraseRootFromParent_Done,
    // Label 764: @31581
    GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(31613), // Rule ID 5441 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5441,
      GIR_EraseRootFromParent_Done,
    // Label 765: @31613
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(31669), // Rule ID 5472 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5472,
      GIR_EraseRootFromParent_Done,
    // Label 766: @31669
    GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(31725), // Rule ID 5473 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5473,
      GIR_EraseRootFromParent_Done,
    // Label 767: @31725
    GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(31781), // Rule ID 5474 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5474,
      GIR_EraseRootFromParent_Done,
    // Label 768: @31781
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(31837), // Rule ID 5475 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5475,
      GIR_EraseRootFromParent_Done,
    // Label 769: @31837
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(31893), // Rule ID 5476 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5476,
      GIR_EraseRootFromParent_Done,
    // Label 770: @31893
    GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(31949), // Rule ID 5477 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5477,
      GIR_EraseRootFromParent_Done,
    // Label 771: @31949
    GIM_Reject,
    // Label 489: @31950
    GIM_Reject,
    // Label 10: @31951
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 777*/ GIMT_Encode4(32242),
    /*GILLT_s16*//*Label 772*/ GIMT_Encode4(32014),
    /*GILLT_s32*//*Label 773*/ GIMT_Encode4(32052),
    /*GILLT_s64*//*Label 774*/ GIMT_Encode4(32090), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 775*/ GIMT_Encode4(32128), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 776*/ GIMT_Encode4(32185),
    // Label 772: @32014
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(32051), // Rule ID 682 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (ftrunc:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTZH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZH),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 682,
      GIR_EraseRootFromParent_Done,
    // Label 778: @32051
    GIM_Reject,
    // Label 773: @32052
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(32089), // Rule ID 683 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (ftrunc:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTZS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZS),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 683,
      GIR_EraseRootFromParent_Done,
    // Label 779: @32089
    GIM_Reject,
    // Label 774: @32090
    GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(32127), // Rule ID 684 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (ftrunc:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTZD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZD),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Dd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Dm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 684,
      GIR_EraseRootFromParent_Done,
    // Label 780: @32127
    GIM_Reject,
    // Label 775: @32128
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(32184), // Rule ID 4097 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32Z:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32Z),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4097,
      GIR_EraseRootFromParent_Done,
    // Label 781: @32184
    GIM_Reject,
    // Label 776: @32185
    GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(32241), // Rule ID 4085 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16Z:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16Z),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4085,
      GIR_EraseRootFromParent_Done,
    // Label 782: @32241
    GIM_Reject,
    // Label 777: @32242
    GIM_Reject,
    // Label 11: @32243
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 788*/ GIMT_Encode4(32501),
    /*GILLT_s16*//*Label 783*/ GIMT_Encode4(32306),
    /*GILLT_s32*//*Label 784*/ GIMT_Encode4(32333),
    /*GILLT_s64*//*Label 785*/ GIMT_Encode4(32360), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 786*/ GIMT_Encode4(32387), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 787*/ GIMT_Encode4(32444),
    // Label 783: @32306
    GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(32332), // Rule ID 691 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (fround:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTAH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAH),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 691,
      GIR_Done,
    // Label 789: @32332
    GIM_Reject,
    // Label 784: @32333
    GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(32359), // Rule ID 692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (fround:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTAS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAS),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 692,
      GIR_Done,
    // Label 790: @32359
    GIM_Reject,
    // Label 785: @32360
    GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(32386), // Rule ID 693 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (fround:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTAD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 791: @32386
    GIM_Reject,
    // Label 786: @32387
    GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(32443), // Rule ID 4095 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32A:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32A),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4095,
      GIR_EraseRootFromParent_Done,
    // Label 792: @32443
    GIM_Reject,
    // Label 787: @32444
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(32500), // Rule ID 4083 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16A:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16A),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4083,
      GIR_EraseRootFromParent_Done,
    // Label 793: @32500
    GIM_Reject,
    // Label 788: @32501
    GIM_Reject,
    // Label 12: @32502
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(32522), // Rule ID 5538 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      // MIs[0] Operand 0
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
      // (atomic_fence (timm:{ *:[i32] }), 0:{ *:[i32] })  =>  (MEMBARRIER)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::MEMBARRIER),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5538,
      GIR_EraseRootFromParent_Done,
    // Label 794: @32522
    GIM_Reject,
    // Label 13: @32523
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(38325),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(32579), // Rule ID 1880 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3614:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1880,
        GIR_EraseRootFromParent_Done,
      // Label 796: @32579
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(32627), // Rule ID 2117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3614:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2117,
        GIR_EraseRootFromParent_Done,
      // Label 797: @32627
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(32663), // Rule ID 694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f16] } 3500:{ *:[iPTR] }, HPR:{ *:[f16] }:$Sm)  =>  (VRINTNH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 694,
        GIR_EraseRootFromParent_Done,
      // Label 798: @32663
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(32699), // Rule ID 695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3500:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 695,
        GIR_EraseRootFromParent_Done,
      // Label 799: @32699
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(32735), // Rule ID 696 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 3500:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Dd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 696,
        GIR_EraseRootFromParent_Done,
      // Label 800: @32735
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(32780), // Rule ID 710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3615:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOSIRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 710,
        GIR_EraseRootFromParent_Done,
      // Label 801: @32780
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(32825), // Rule ID 711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3615:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOSIRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 711,
        GIR_EraseRootFromParent_Done,
      // Label 802: @32825
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(32870), // Rule ID 712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3616:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOUIRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 712,
        GIR_EraseRootFromParent_Done,
      // Label 803: @32870
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(32915), // Rule ID 713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3616:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOUIRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 713,
        GIR_EraseRootFromParent_Done,
      // Label 804: @32915
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(32960), // Rule ID 1261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3466:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1261,
        GIR_EraseRootFromParent_Done,
      // Label 805: @32960
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(33005), // Rule ID 1262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3466:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1262,
        GIR_EraseRootFromParent_Done,
      // Label 806: @33005
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(33050), // Rule ID 1263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3466:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1263,
        GIR_EraseRootFromParent_Done,
      // Label 807: @33050
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(33095), // Rule ID 1264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3466:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1264,
        GIR_EraseRootFromParent_Done,
      // Label 808: @33095
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(33140), // Rule ID 1265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3466:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1265,
        GIR_EraseRootFromParent_Done,
      // Label 809: @33140
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(33185), // Rule ID 1266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3466:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1266,
        GIR_EraseRootFromParent_Done,
      // Label 810: @33185
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(33230), // Rule ID 1267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3467:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1267,
        GIR_EraseRootFromParent_Done,
      // Label 811: @33230
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(33275), // Rule ID 1268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3467:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1268,
        GIR_EraseRootFromParent_Done,
      // Label 812: @33275
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(33320), // Rule ID 1269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3467:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1269,
        GIR_EraseRootFromParent_Done,
      // Label 813: @33320
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(33365), // Rule ID 1270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3467:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1270,
        GIR_EraseRootFromParent_Done,
      // Label 814: @33365
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(33410), // Rule ID 1271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3467:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1271,
        GIR_EraseRootFromParent_Done,
      // Label 815: @33410
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(33455), // Rule ID 1272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3467:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1272,
        GIR_EraseRootFromParent_Done,
      // Label 816: @33455
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(33500), // Rule ID 1301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3494:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1301,
        GIR_EraseRootFromParent_Done,
      // Label 817: @33500
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(33545), // Rule ID 1302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3494:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1302,
        GIR_EraseRootFromParent_Done,
      // Label 818: @33545
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(33590), // Rule ID 1303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3494:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEfd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1303,
        GIR_EraseRootFromParent_Done,
      // Label 819: @33590
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(33635), // Rule ID 1304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3494:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEfq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1304,
        GIR_EraseRootFromParent_Done,
      // Label 820: @33635
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(33680), // Rule ID 1305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3494:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEhd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1305,
        GIR_EraseRootFromParent_Done,
      // Label 821: @33680
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(33725), // Rule ID 1306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3494:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEhq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1306,
        GIR_EraseRootFromParent_Done,
      // Label 822: @33725
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(33770), // Rule ID 1311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3507:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1311,
        GIR_EraseRootFromParent_Done,
      // Label 823: @33770
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(33815), // Rule ID 1312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3507:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1312,
        GIR_EraseRootFromParent_Done,
      // Label 824: @33815
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(33860), // Rule ID 1313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3507:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1313,
        GIR_EraseRootFromParent_Done,
      // Label 825: @33860
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(33905), // Rule ID 1314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3507:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1314,
        GIR_EraseRootFromParent_Done,
      // Label 826: @33905
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(33950), // Rule ID 1315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3507:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1315,
        GIR_EraseRootFromParent_Done,
      // Label 827: @33950
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(33995), // Rule ID 1316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3507:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1316,
        GIR_EraseRootFromParent_Done,
      // Label 828: @33995
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(34040), // Rule ID 1537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3472:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1537,
        GIR_EraseRootFromParent_Done,
      // Label 829: @34040
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(34085), // Rule ID 1538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3472:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1538,
        GIR_EraseRootFromParent_Done,
      // Label 830: @34085
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(34130), // Rule ID 1539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3472:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1539,
        GIR_EraseRootFromParent_Done,
      // Label 831: @34130
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(34175), // Rule ID 1540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3472:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1540,
        GIR_EraseRootFromParent_Done,
      // Label 832: @34175
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(34220), // Rule ID 1541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3472:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1541,
        GIR_EraseRootFromParent_Done,
      // Label 833: @34220
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(34265), // Rule ID 1542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3472:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1542,
        GIR_EraseRootFromParent_Done,
      // Label 834: @34265
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(34310), // Rule ID 1553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3478:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1553,
        GIR_EraseRootFromParent_Done,
      // Label 835: @34310
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(34355), // Rule ID 1554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3478:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1554,
        GIR_EraseRootFromParent_Done,
      // Label 836: @34355
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(34400), // Rule ID 1555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3478:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1555,
        GIR_EraseRootFromParent_Done,
      // Label 837: @34400
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(34445), // Rule ID 1556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3478:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1556,
        GIR_EraseRootFromParent_Done,
      // Label 838: @34445
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(34490), // Rule ID 1557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3478:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1557,
        GIR_EraseRootFromParent_Done,
      // Label 839: @34490
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(34535), // Rule ID 1558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3478:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1558,
        GIR_EraseRootFromParent_Done,
      // Label 840: @34535
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(34580), // Rule ID 1559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3419:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1559,
        GIR_EraseRootFromParent_Done,
      // Label 841: @34580
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(34625), // Rule ID 1560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3419:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1560,
        GIR_EraseRootFromParent_Done,
      // Label 842: @34625
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(34670), // Rule ID 1561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3419:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1561,
        GIR_EraseRootFromParent_Done,
      // Label 843: @34670
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(34715), // Rule ID 1562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3419:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1562,
        GIR_EraseRootFromParent_Done,
      // Label 844: @34715
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(34760), // Rule ID 1563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3419:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1563,
        GIR_EraseRootFromParent_Done,
      // Label 845: @34760
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(34805), // Rule ID 1564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3419:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1564,
        GIR_EraseRootFromParent_Done,
      // Label 846: @34805
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(34850), // Rule ID 1608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3475:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1608,
        GIR_EraseRootFromParent_Done,
      // Label 847: @34850
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(34895), // Rule ID 1609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3475:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1609,
        GIR_EraseRootFromParent_Done,
      // Label 848: @34895
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(34940), // Rule ID 1610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3475:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1610,
        GIR_EraseRootFromParent_Done,
      // Label 849: @34940
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(34985), // Rule ID 1611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3477:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1611,
        GIR_EraseRootFromParent_Done,
      // Label 850: @34985
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(35030), // Rule ID 1612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3477:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1612,
        GIR_EraseRootFromParent_Done,
      // Label 851: @35030
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(35075), // Rule ID 1613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3477:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1613,
        GIR_EraseRootFromParent_Done,
      // Label 852: @35075
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(35120), // Rule ID 1614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3476:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1614,
        GIR_EraseRootFromParent_Done,
      // Label 853: @35120
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(35165), // Rule ID 1615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3476:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1615,
        GIR_EraseRootFromParent_Done,
      // Label 854: @35165
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(35210), // Rule ID 1616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3476:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1616,
        GIR_EraseRootFromParent_Done,
      // Label 855: @35210
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(35246), // Rule ID 1639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3420:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1639,
        GIR_EraseRootFromParent_Done,
      // Label 856: @35246
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(35282), // Rule ID 1640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3420:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1640,
        GIR_EraseRootFromParent_Done,
      // Label 857: @35282
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(35318), // Rule ID 1641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3421:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1641,
        GIR_EraseRootFromParent_Done,
      // Label 858: @35318
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(35354), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3421:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1642,
        GIR_EraseRootFromParent_Done,
      // Label 859: @35354
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(35390), // Rule ID 1643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3420:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1643,
        GIR_EraseRootFromParent_Done,
      // Label 860: @35390
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(35426), // Rule ID 1644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3420:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1644,
        GIR_EraseRootFromParent_Done,
      // Label 861: @35426
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(35462), // Rule ID 1645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3421:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1645,
        GIR_EraseRootFromParent_Done,
      // Label 862: @35462
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(35498), // Rule ID 1646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3421:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1646,
        GIR_EraseRootFromParent_Done,
      // Label 863: @35498
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(35534), // Rule ID 1647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3432:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1647,
        GIR_EraseRootFromParent_Done,
      // Label 864: @35534
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(35570), // Rule ID 1648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3432:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1648,
        GIR_EraseRootFromParent_Done,
      // Label 865: @35570
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(35606), // Rule ID 1649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3433:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1649,
        GIR_EraseRootFromParent_Done,
      // Label 866: @35606
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(35642), // Rule ID 1650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3433:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1650,
        GIR_EraseRootFromParent_Done,
      // Label 867: @35642
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(35678), // Rule ID 1651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3432:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1651,
        GIR_EraseRootFromParent_Done,
      // Label 868: @35678
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(35714), // Rule ID 1652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3432:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1652,
        GIR_EraseRootFromParent_Done,
      // Label 869: @35714
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(35750), // Rule ID 1653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3433:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1653,
        GIR_EraseRootFromParent_Done,
      // Label 870: @35750
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(35786), // Rule ID 1654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3433:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1654,
        GIR_EraseRootFromParent_Done,
      // Label 871: @35786
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(35822), // Rule ID 1655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3434:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1655,
        GIR_EraseRootFromParent_Done,
      // Label 872: @35822
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(35858), // Rule ID 1656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3434:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1656,
        GIR_EraseRootFromParent_Done,
      // Label 873: @35858
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(35894), // Rule ID 1657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3435:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1657,
        GIR_EraseRootFromParent_Done,
      // Label 874: @35894
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(35930), // Rule ID 1658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3435:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1658,
        GIR_EraseRootFromParent_Done,
      // Label 875: @35930
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(35966), // Rule ID 1659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3434:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1659,
        GIR_EraseRootFromParent_Done,
      // Label 876: @35966
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(36002), // Rule ID 1660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3434:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1660,
        GIR_EraseRootFromParent_Done,
      // Label 877: @36002
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(36038), // Rule ID 1661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3435:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1661,
        GIR_EraseRootFromParent_Done,
      // Label 878: @36038
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(36074), // Rule ID 1662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3435:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1662,
        GIR_EraseRootFromParent_Done,
      // Label 879: @36074
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(36110), // Rule ID 1663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3430:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1663,
        GIR_EraseRootFromParent_Done,
      // Label 880: @36110
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(36146), // Rule ID 1664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3430:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1664,
        GIR_EraseRootFromParent_Done,
      // Label 881: @36146
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(36182), // Rule ID 1665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3431:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1665,
        GIR_EraseRootFromParent_Done,
      // Label 882: @36182
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(36218), // Rule ID 1666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3431:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1666,
        GIR_EraseRootFromParent_Done,
      // Label 883: @36218
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(36254), // Rule ID 1667 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3430:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1667,
        GIR_EraseRootFromParent_Done,
      // Label 884: @36254
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(36290), // Rule ID 1668 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3430:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1668,
        GIR_EraseRootFromParent_Done,
      // Label 885: @36290
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(36326), // Rule ID 1669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3431:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1669,
        GIR_EraseRootFromParent_Done,
      // Label 886: @36326
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(36362), // Rule ID 1670 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3431:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1670,
        GIR_EraseRootFromParent_Done,
      // Label 887: @36362
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(36407), // Rule ID 1687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2hf),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3426:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTf2h:{ *:[v4i16] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2h),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1687,
        GIR_EraseRootFromParent_Done,
      // Label 888: @36407
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(36452), // Rule ID 1688 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvthf2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3429:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCVTh2f:{ *:[v4f32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTh2f),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1688,
        GIR_EraseRootFromParent_Done,
      // Label 889: @36452
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(36488), // Rule ID 1710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3500:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTNNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1710,
        GIR_EraseRootFromParent_Done,
      // Label 890: @36488
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(36524), // Rule ID 1711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3500:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTNNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1711,
        GIR_EraseRootFromParent_Done,
      // Label 891: @36524
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(36560), // Rule ID 1712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3500:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTNNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1712,
        GIR_EraseRootFromParent_Done,
      // Label 892: @36560
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(36596), // Rule ID 1713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3500:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTNNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1713,
        GIR_EraseRootFromParent_Done,
      // Label 893: @36596
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(36632), // Rule ID 1714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3502:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTXNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1714,
        GIR_EraseRootFromParent_Done,
      // Label 894: @36632
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(36668), // Rule ID 1715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3502:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTXNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1715,
        GIR_EraseRootFromParent_Done,
      // Label 895: @36668
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(36704), // Rule ID 1716 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3502:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTXNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1716,
        GIR_EraseRootFromParent_Done,
      // Label 896: @36704
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(36740), // Rule ID 1717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3502:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTXNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1717,
        GIR_EraseRootFromParent_Done,
      // Label 897: @36740
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(36776), // Rule ID 1718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3498:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTANDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1718,
        GIR_EraseRootFromParent_Done,
      // Label 898: @36776
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(36812), // Rule ID 1719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3498:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTANQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1719,
        GIR_EraseRootFromParent_Done,
      // Label 899: @36812
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(36848), // Rule ID 1720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3498:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTANDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1720,
        GIR_EraseRootFromParent_Done,
      // Label 900: @36848
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(36884), // Rule ID 1721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3498:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTANQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1721,
        GIR_EraseRootFromParent_Done,
      // Label 901: @36884
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(36920), // Rule ID 1722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3503:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTZNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1722,
        GIR_EraseRootFromParent_Done,
      // Label 902: @36920
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(36956), // Rule ID 1723 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3503:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTZNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1723,
        GIR_EraseRootFromParent_Done,
      // Label 903: @36956
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(36992), // Rule ID 1724 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3503:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTZNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1724,
        GIR_EraseRootFromParent_Done,
      // Label 904: @36992
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(37028), // Rule ID 1725 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3503:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTZNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1725,
        GIR_EraseRootFromParent_Done,
      // Label 905: @37028
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(37064), // Rule ID 1726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3499:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTMNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1726,
        GIR_EraseRootFromParent_Done,
      // Label 906: @37064
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(37100), // Rule ID 1727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3499:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTMNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1727,
        GIR_EraseRootFromParent_Done,
      // Label 907: @37100
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(37136), // Rule ID 1728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3499:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTMNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1728,
        GIR_EraseRootFromParent_Done,
      // Label 908: @37136
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(37172), // Rule ID 1729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3499:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTMNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1729,
        GIR_EraseRootFromParent_Done,
      // Label 909: @37172
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(37208), // Rule ID 1730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3501:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTPNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1730,
        GIR_EraseRootFromParent_Done,
      // Label 910: @37208
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(37244), // Rule ID 1731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3501:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTPNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1731,
        GIR_EraseRootFromParent_Done,
      // Label 911: @37244
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(37280), // Rule ID 1732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3501:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTPNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1732,
        GIR_EraseRootFromParent_Done,
      // Label 912: @37280
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(37316), // Rule ID 1733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3501:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTPNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1733,
        GIR_EraseRootFromParent_Done,
      // Label 913: @37316
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(37352), // Rule ID 1736 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3389:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESIMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::AESIMC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1736,
        GIR_EraseRootFromParent_Done,
      // Label 914: @37352
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(37388), // Rule ID 1737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_aesmc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3390:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::AESMC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1737,
        GIR_EraseRootFromParent_Done,
      // Label 915: @37388
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(37436), // Rule ID 1875 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_sxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3589:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (SXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1875,
        GIR_EraseRootFromParent_Done,
      // Label 916: @37436
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(37484), // Rule ID 2106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_sxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3589:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2106,
        GIR_EraseRootFromParent_Done,
      // Label 917: @37484
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(37548), // Rule ID 3763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3271:{ *:[iPTR] }, MQPR:{ *:[v16i8] }:$val)  =>  (MVE_VCLSs8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3763,
        GIR_EraseRootFromParent_Done,
      // Label 918: @37548
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(37612), // Rule ID 3765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3271:{ *:[iPTR] }, MQPR:{ *:[v8i16] }:$val)  =>  (MVE_VCLSs16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3765,
        GIR_EraseRootFromParent_Done,
      // Label 919: @37612
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(37676), // Rule ID 3767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3271:{ *:[iPTR] }, MQPR:{ *:[v4i32] }:$val)  =>  (MVE_VCLSs32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3767,
        GIR_EraseRootFromParent_Done,
      // Label 920: @37676
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(37740), // Rule ID 4079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3353:{ *:[iPTR] }, MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16N:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16N),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4079,
        GIR_EraseRootFromParent_Done,
      // Label 921: @37740
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(37804), // Rule ID 4091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3353:{ *:[iPTR] }, MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32N:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32N),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4091,
        GIR_EraseRootFromParent_Done,
      // Label 922: @37804
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(37855), // Rule ID 4981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i1] } 3279:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP8:{ *:[v16i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4981,
        GIR_EraseRootFromParent_Done,
      // Label 923: @37855
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(37906), // Rule ID 4983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i1] } 3276:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP16:{ *:[v8i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4983,
        GIR_EraseRootFromParent_Done,
      // Label 924: @37906
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(37957), // Rule ID 4985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i1] } 3277:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP32:{ *:[v4i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4985,
        GIR_EraseRootFromParent_Done,
      // Label 925: @37957
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(38008), // Rule ID 4987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i1] } 3278:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP64:{ *:[v2i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4987,
        GIR_EraseRootFromParent_Done,
      // Label 926: @38008
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(38054), // Rule ID 617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_tt),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3161:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 617,
        GIR_EraseRootFromParent_Done,
      // Label 927: @38054
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(38100), // Rule ID 618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_ttt),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3164:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 618,
        GIR_EraseRootFromParent_Done,
      // Label 928: @38100
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(38146), // Rule ID 619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_tta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3162:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 619,
        GIR_EraseRootFromParent_Done,
      // Label 929: @38146
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(38192), // Rule ID 620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_ttat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3163:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTAT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 620,
        GIR_EraseRootFromParent_Done,
      // Label 930: @38192
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(38324), // Rule ID 2711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_sha1h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3397:{ *:[iPTR] }, i32:{ *:[i32] }:$Rn)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f32] } (SHA1H:{ *:[v16i8] } (SUBREG_TO_REG:{ *:[v16i8] } 0:{ *:[i64] }, (COPY_TO_REGCLASS:{ *:[f32] } i32:{ *:[i32] }:$Rn, SPR:{ *:[i32] }), ssub_0:{ *:[i32] })), ssub_0:{ *:[i32] }), GPR:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/17,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::DPair_with_ssub_0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(ARM::SHA1H),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(ARM::MQPRRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::GPRRegClassID),
        // GIR_Coverage, 2711,
        GIR_EraseRootFromParent_Done,
      // Label 931: @38324
      GIM_Reject,
    // Label 795: @38325
    GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(58791),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(38390), // Rule ID 2124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtab16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3613:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTAB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/3, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2124,
        GIR_EraseRootFromParent_Done,
      // Label 933: @38390
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(38489), // Rule ID 1912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[i32] } 3608:{ *:[iPTR] }, (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft), (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::USAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shft
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1912,
        GIR_EraseRootFromParent_Done,
      // Label 934: @38489
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(38588), // Rule ID 2161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[i32] } 3608:{ *:[iPTR] }, (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft), (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (t2USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2USAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shft
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2161,
        GIR_EraseRootFromParent_Done,
      // Label 935: @38588
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(38672), // Rule ID 5547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn), GPRnopc:{ *:[i32] }:$Rm)  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::QDADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/3, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5547,
        GIR_EraseRootFromParent_Done,
      // Label 936: @38672
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(38756), // Rule ID 5804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Rm)  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2QDADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/3, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5804,
        GIR_EraseRootFromParent_Done,
      // Label 937: @38756
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(38840), // Rule ID 109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDADD:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::QDADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 109,
        GIR_EraseRootFromParent_Done,
      // Label 938: @38840
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(38924), // Rule ID 110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3536:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rn))  =>  (QDSUB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::QDSUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 110,
        GIR_EraseRootFromParent_Done,
      // Label 939: @38924
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(39008), // Rule ID 2139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDADD:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2QDADD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2139,
        GIR_EraseRootFromParent_Done,
      // Label 940: @39008
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(39092), // Rule ID 2140 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qsub),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::arm_qadd),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Rn
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3536:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm, (intrinsic_wo_chain:{ *:[i32] } 3531:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rn))  =>  (t2QDSUB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2QDSUB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2140,
        GIR_EraseRootFromParent_Done,
      // Label 941: @39092
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(39163), // Rule ID 4173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3287:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16a:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs16f16a),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4173,
        GIR_EraseRootFromParent_Done,
      // Label 942: @39163
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(39234), // Rule ID 4175 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3291:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16n:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs16f16n),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4175,
        GIR_EraseRootFromParent_Done,
      // Label 943: @39234
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(39305), // Rule ID 4177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3293:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16p:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs16f16p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4177,
        GIR_EraseRootFromParent_Done,
      // Label 944: @39305
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(39376), // Rule ID 4179 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3289:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTs16f16m:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs16f16m),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4179,
        GIR_EraseRootFromParent_Done,
      // Label 945: @39376
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(39447), // Rule ID 4181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3287:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16a:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu16f16a),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4181,
        GIR_EraseRootFromParent_Done,
      // Label 946: @39447
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(39518), // Rule ID 4183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3291:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16n:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu16f16n),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4183,
        GIR_EraseRootFromParent_Done,
      // Label 947: @39518
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(39589), // Rule ID 4185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3293:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16p:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu16f16p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4185,
        GIR_EraseRootFromParent_Done,
      // Label 948: @39589
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(39660), // Rule ID 4187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3289:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v8f16] }:$in)  =>  (MVE_VCVTu16f16m:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu16f16m),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4187,
        GIR_EraseRootFromParent_Done,
      // Label 949: @39660
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(39731), // Rule ID 4189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3287:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32a:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs32f32a),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4189,
        GIR_EraseRootFromParent_Done,
      // Label 950: @39731
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(39802), // Rule ID 4191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3291:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32n:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs32f32n),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4191,
        GIR_EraseRootFromParent_Done,
      // Label 951: @39802
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(39873), // Rule ID 4193 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3293:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32p:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs32f32p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4193,
        GIR_EraseRootFromParent_Done,
      // Label 952: @39873
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(39944), // Rule ID 4195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3289:{ *:[iPTR] }, 0:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTs32f32m:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTs32f32m),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4195,
        GIR_EraseRootFromParent_Done,
      // Label 953: @39944
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(40015), // Rule ID 4197 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3287:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTu32f32a:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu32f32a),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4197,
        GIR_EraseRootFromParent_Done,
      // Label 954: @40015
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(40086), // Rule ID 4199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3291:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTu32f32n:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu32f32n),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4199,
        GIR_EraseRootFromParent_Done,
      // Label 955: @40086
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(40157), // Rule ID 4201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3293:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTu32f32p:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu32f32p),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4201,
        GIR_EraseRootFromParent_Done,
      // Label 956: @40157
      GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(40228), // Rule ID 4203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvtm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3289:{ *:[iPTR] }, 1:{ *:[i32] }, MQPR:{ *:[v4f32] }:$in)  =>  (MVE_VCVTu32f32m:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$in)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTu32f32m),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/3, // in
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4203,
        GIR_EraseRootFromParent_Done,
      // Label 957: @40228
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(40299), // Rule ID 4647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvt_widen),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3285:{ *:[iPTR] }, MQPR:{ *:[v8f16] }:$Qm, 0:{ *:[i32] })  =>  (MVE_VCVTf32f16bh:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$Qm)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTf32f16bh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Qm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4647,
        GIR_EraseRootFromParent_Done,
      // Label 958: @40299
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(40370), // Rule ID 4653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcvt_widen),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3285:{ *:[iPTR] }, MQPR:{ *:[v8f16] }:$Qm, 1:{ *:[i32] })  =>  (MVE_VCVTf32f16th:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$Qm)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCVTf32f16th),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Qm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4653,
        GIR_EraseRootFromParent_Done,
      // Label 959: @40370
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(40438), // Rule ID 1905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3608:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::USAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1905,
        GIR_EraseRootFromParent_Done,
      // Label 960: @40438
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(40503), // Rule ID 1909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_15),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3609:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPRnopc:{ *:[i32] }:$a)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::USAT16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1909,
        GIR_EraseRootFromParent_Done,
      // Label 961: @40503
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(40571), // Rule ID 2156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3608:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (t2USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPR:{ *:[i32] }:$a, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2USAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2156,
        GIR_EraseRootFromParent_Done,
      // Label 962: @40571
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(40636), // Rule ID 2158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_15),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 3609:{ *:[iPTR] }, GPR:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos)  =>  (t2USAT16:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$pos, GPR:{ *:[i32] }:$a)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2USAT16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pos
        GIR_RootToRootCopy, /*OpIdx*/2, // a
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2158,
        GIR_EraseRootFromParent_Done,
      // Label 963: @40636
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(40717), // Rule ID 4043 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vqshlu_imm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_7),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v16i8] } 3346:{ *:[iPTR] }, MQPR:{ *:[v16i8] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_7>>:$imm)  =>  (MVE_VQSHLU_imms8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_7>>:$imm)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VQSHLU_imms8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4043,
        GIR_EraseRootFromParent_Done,
      // Label 964: @40717
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(40798), // Rule ID 4045 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vqshlu_imm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_15),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v8i16] } 3346:{ *:[iPTR] }, MQPR:{ *:[v8i16] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$imm)  =>  (MVE_VQSHLU_imms16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_15>>:$imm)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VQSHLU_imms16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4045,
        GIR_EraseRootFromParent_Done,
      // Label 965: @40798
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(40879), // Rule ID 4047 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vqshlu_imm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3346:{ *:[iPTR] }, MQPR:{ *:[v4i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$imm)  =>  (MVE_VQSHLU_imms32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$imm)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VQSHLU_imms32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4047,
        GIR_EraseRootFromParent_Done,
      // Label 966: @40879
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(40940), // Rule ID 1671 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 3424:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsd:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2xsd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1671,
        GIR_EraseRootFromParent_Done,
      // Label 967: @40940
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(41001), // Rule ID 1672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2i32] } 3425:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xud:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2xud),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1672,
        GIR_EraseRootFromParent_Done,
      // Label 968: @41001
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(41062), // Rule ID 1673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxs2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 3427:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxs2fd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1673,
        GIR_EraseRootFromParent_Done,
      // Label 969: @41062
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(41123), // Rule ID 1674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxu2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v2f32] } 3428:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fd:{ *:[v2f32] } DPR:{ *:[v2i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxu2fd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1674,
        GIR_EraseRootFromParent_Done,
      // Label 970: @41123
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(41184), // Rule ID 1675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 3424:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xsd:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTh2xsd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1675,
        GIR_EraseRootFromParent_Done,
      // Label 971: @41184
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(41245), // Rule ID 1676 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i16] } 3425:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTh2xud:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTh2xud),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1676,
        GIR_EraseRootFromParent_Done,
      // Label 972: @41245
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(41306), // Rule ID 1677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxs2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 3427:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxs2hd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1677,
        GIR_EraseRootFromParent_Done,
      // Label 973: @41306
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(41367), // Rule ID 1678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxu2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4f16] } 3428:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2hd:{ *:[v4f16] } DPR:{ *:[v4i16] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxu2hd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1678,
        GIR_EraseRootFromParent_Done,
      // Label 974: @41367
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(41428), // Rule ID 1679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3424:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xsq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2xsq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1679,
        GIR_EraseRootFromParent_Done,
      // Label 975: @41428
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(41489), // Rule ID 1680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4i32] } 3425:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTf2xuq:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2xuq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1680,
        GIR_EraseRootFromParent_Done,
      // Label 976: @41489
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(41550), // Rule ID 1681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxs2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3427:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxs2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxs2fq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1681,
        GIR_EraseRootFromParent_Done,
      // Label 977: @41550
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(41611), // Rule ID 1682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfxu2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_wo_chain:{ *:[v4f32] } 3428:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)  =>  (VCVTxu2fq:{ *:[v4f32] } QPR:{ *:[v4i32] }:$Vm, (imm:{ *:[i32] }):$SIMM)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTxu2fq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // SIMM
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1682,
        GIR_EraseRootFromParent_Done,
      // Label 978: @41611
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(41672), // Rule ID 1683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2fxs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        