/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 8),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 17,
  Feature_HasMips4_32Bit = 27,
  Feature_NotMips4_32Bit = 28,
  Feature_HasMips4_32r2Bit = 18,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 29,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 22,
  Feature_IsPTR64bitBit = 24,
  Feature_HasMips64Bit = 25,
  Feature_HasMips64r2Bit = 23,
  Feature_HasMips64r6Bit = 30,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 31,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 26,
  Feature_NotCnMipsBit = 8,
  Feature_IsSym32Bit = 38,
  Feature_IsSym64Bit = 39,
  Feature_IsN64Bit = 40,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 37,
  Feature_NoNaNsFPMathBit = 21,
  Feature_UseAbsBit = 14,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 35,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 42,
  Feature_IsBEBit = 43,
  Feature_IsNotNaClBit = 19,
  Feature_HasEVABit = 36,
  Feature_HasMSABit = 34,
  Feature_HasMadd4Bit = 20,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 41,
  Feature_IsFP64bitBit = 16,
  Feature_NotFP64bitBit = 15,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 32,
  Feature_HasDSPR2Bit = 33,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasMips2())
    Features.set(Feature_HasMips2Bit);
  if (Subtarget->hasMips3())
    Features.set(Feature_HasMips3Bit);
  if (Subtarget->hasMips4_32())
    Features.set(Feature_HasMips4_32Bit);
  if (!Subtarget->hasMips4_32())
    Features.set(Feature_NotMips4_32Bit);
  if (Subtarget->hasMips4_32r2())
    Features.set(Feature_HasMips4_32r2Bit);
  if (Subtarget->hasMips32())
    Features.set(Feature_HasMips32Bit);
  if (Subtarget->hasMips32r2())
    Features.set(Feature_HasMips32r2Bit);
  if (Subtarget->hasMips32r6())
    Features.set(Feature_HasMips32r6Bit);
  if (!Subtarget->hasMips32r6())
    Features.set(Feature_NotMips32r6Bit);
  if (Subtarget->isGP64bit())
    Features.set(Feature_IsGP64bitBit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsPTR64bitBit);
  if (Subtarget->hasMips64())
    Features.set(Feature_HasMips64Bit);
  if (Subtarget->hasMips64r2())
    Features.set(Feature_HasMips64r2Bit);
  if (Subtarget->hasMips64r6())
    Features.set(Feature_HasMips64r6Bit);
  if (!Subtarget->hasMips64r6())
    Features.set(Feature_NotMips64r6Bit);
  if (Subtarget->inMips16Mode())
    Features.set(Feature_InMips16ModeBit);
  if (!Subtarget->inMips16Mode())
    Features.set(Feature_NotInMips16ModeBit);
  if (Subtarget->hasCnMips())
    Features.set(Feature_HasCnMipsBit);
  if (!Subtarget->hasCnMips())
    Features.set(Feature_NotCnMipsBit);
  if (Subtarget->hasSym32())
    Features.set(Feature_IsSym32Bit);
  if (!Subtarget->hasSym32())
    Features.set(Feature_IsSym64Bit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsN64Bit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_RelocNotPICBit);
  if (TM.isPositionIndependent())
    Features.set(Feature_RelocPICBit);
  if (TM.Options.NoNaNsFPMath)
    Features.set(Feature_NoNaNsFPMathBit);
  if (Subtarget->inAbs2008Mode() ||TM.Options.NoNaNsFPMath)
    Features.set(Feature_UseAbsBit);
  if (Subtarget->hasStandardEncoding())
    Features.set(Feature_HasStdEncBit);
  if (!Subtarget->hasDSP())
    Features.set(Feature_NotDSPBit);
  if (Subtarget->inMicroMipsMode())
    Features.set(Feature_InMicroMipsBit);
  if (!Subtarget->inMicroMipsMode())
    Features.set(Feature_NotInMicroMipsBit);
  if (Subtarget->isLittle())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittle())
    Features.set(Feature_IsBEBit);
  if (!Subtarget->isTargetNaCl())
    Features.set(Feature_IsNotNaClBit);
  if (Subtarget->hasEVA())
    Features.set(Feature_HasEVABit);
  if (Subtarget->hasMSA())
    Features.set(Feature_HasMSABit);
  if (!Subtarget->disableMadd4())
    Features.set(Feature_HasMadd4Bit);
  if (Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_UseIndirectJumpsHazardBit);
  if (!Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_NoIndirectJumpGuardsBit);
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features.set(Feature_AllowFPOpFusionBit);
  if (Subtarget->isFP64bit())
    Features.set(Feature_IsFP64bitBit);
  if (!Subtarget->isFP64bit())
    Features.set(Feature_NotFP64bitBit);
  if (!Subtarget->useSoftFloat())
    Features.set(Feature_IsNotSoftFloatBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDSPR2())
    Features.set(Feature_HasDSPR2Bit);
  return Features;
}

void MipsInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const MipsSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat_UseAbs,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode,
  GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips64r6,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_UseAbs,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_UseAbsBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMips16ModeBit, },
  {Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_immLi16 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_immSExt6,
  GICXXPred_I64_Predicate_immSExt10,
  GICXXPred_I64_Predicate_immSExtAddiur2,
  GICXXPred_I64_Predicate_immSExtAddius5,
  GICXXPred_I64_Predicate_immZExt1,
  GICXXPred_I64_Predicate_immZExt1Ptr,
  GICXXPred_I64_Predicate_immZExt2,
  GICXXPred_I64_Predicate_immZExt2Lsa,
  GICXXPred_I64_Predicate_immZExt2Ptr,
  GICXXPred_I64_Predicate_immZExt2Shift,
  GICXXPred_I64_Predicate_immZExt3,
  GICXXPred_I64_Predicate_immZExt3Ptr,
  GICXXPred_I64_Predicate_immZExt4,
  GICXXPred_I64_Predicate_immZExt4Ptr,
  GICXXPred_I64_Predicate_immZExt5,
  GICXXPred_I64_Predicate_immZExt5_64,
  GICXXPred_I64_Predicate_immZExt6,
  GICXXPred_I64_Predicate_immZExt8,
  GICXXPred_I64_Predicate_immZExt10,
  GICXXPred_I64_Predicate_immZExtAndi16,
  GICXXPred_I64_Predicate_immi32Cst7,
  GICXXPred_I64_Predicate_immi32Cst15,
  GICXXPred_I64_Predicate_immi32Cst31,
  GICXXPred_I64_Predicate_timmSExt6,
  GICXXPred_I64_Predicate_timmZExt1,
  GICXXPred_I64_Predicate_timmZExt1Ptr,
  GICXXPred_I64_Predicate_timmZExt2,
  GICXXPred_I64_Predicate_timmZExt2Ptr,
  GICXXPred_I64_Predicate_timmZExt3,
  GICXXPred_I64_Predicate_timmZExt3Ptr,
  GICXXPred_I64_Predicate_timmZExt4,
  GICXXPred_I64_Predicate_timmZExt4Ptr,
  GICXXPred_I64_Predicate_timmZExt5,
  GICXXPred_I64_Predicate_timmZExt6,
  GICXXPred_I64_Predicate_timmZExt8,
  GICXXPred_I64_Predicate_timmZExt10,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
  }
  case GICXXPred_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                               ((Imm % 4 == 0) &&
                                                Imm < 28 && Imm > 0);
  }
  case GICXXPred_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
  }
  case GICXXPred_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
  }
  case GICXXPred_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
  }
  case GICXXPred_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
  }
  case GICXXPred_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
                Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
                Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
  }
  case GICXXPred_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
  }
  case GICXXPred_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
  }
  case GICXXPred_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
  }
  case GICXXPred_I64_Predicate_timmSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_timmZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_timmZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt10: {
    return isUInt<10>(Imm);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_imm32SExt16 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_imm32ZExt16,
};
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_imm32SExt16: {
     return isInt<16>(Imm.getSExtValue()); 
  }
  case GICXXPred_APInt_Predicate_imm32ZExt16: {
    
      return (uint32_t)Imm.getZExtValue() == (unsigned short)Imm.getZExtValue();
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("MipsInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void MipsInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("MipsInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(47), GIMT_Encode2(230), /*)*//*default:*//*Label 58*/ GIMT_Encode4(73125),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(742),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(2248),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(3041),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(3579),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(3885),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(4191),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(4497), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(4803),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5447),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(5913), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_MERGE_VALUES*//*Label 10*/ GIMT_Encode4(6974),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 11*/ GIMT_Encode4(7058), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 12*/ GIMT_Encode4(7465), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_LOAD*//*Label 13*/ GIMT_Encode4(12033),
    /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ GIMT_Encode4(12106),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ GIMT_Encode4(12182), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 16*/ GIMT_Encode4(12258),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 17*/ GIMT_Encode4(31399), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 18*/ GIMT_Encode4(37431),
    /*TargetOpcode::G_TRUNC*//*Label 19*/ GIMT_Encode4(37508),
    /*TargetOpcode::G_CONSTANT*//*Label 20*/ GIMT_Encode4(37582), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 21*/ GIMT_Encode4(37658), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 22*/ GIMT_Encode4(39090),
    /*TargetOpcode::G_SHL*//*Label 23*/ GIMT_Encode4(39321),
    /*TargetOpcode::G_LSHR*//*Label 24*/ GIMT_Encode4(41390),
    /*TargetOpcode::G_ASHR*//*Label 25*/ GIMT_Encode4(43459), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 26*/ GIMT_Encode4(45476), GIMT_Encode4(0),
    /*TargetOpcode::G_ICMP*//*Label 27*/ GIMT_Encode4(45810),
    /*TargetOpcode::G_FCMP*//*Label 28*/ GIMT_Encode4(48833),
    /*TargetOpcode::G_SELECT*//*Label 29*/ GIMT_Encode4(50964), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 30*/ GIMT_Encode4(64896),
    /*TargetOpcode::G_SMULH*//*Label 31*/ GIMT_Encode4(65018), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 32*/ GIMT_Encode4(65140),
    /*TargetOpcode::G_FSUB*//*Label 33*/ GIMT_Encode4(66198),
    /*TargetOpcode::G_FMUL*//*Label 34*/ GIMT_Encode4(66906),
    /*TargetOpcode::G_FMA*//*Label 35*/ GIMT_Encode4(67476), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 36*/ GIMT_Encode4(67598), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FEXP2*//*Label 37*/ GIMT_Encode4(67944), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FLOG2*//*Label 38*/ GIMT_Encode4(68030), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 39*/ GIMT_Encode4(68116),
    /*TargetOpcode::G_FPEXT*//*Label 40*/ GIMT_Encode4(69635),
    /*TargetOpcode::G_FPTRUNC*//*Label 41*/ GIMT_Encode4(69837),
    /*TargetOpcode::G_FPTOSI*//*Label 42*/ GIMT_Encode4(70018),
    /*TargetOpcode::G_FPTOUI*//*Label 43*/ GIMT_Encode4(70104),
    /*TargetOpcode::G_SITOFP*//*Label 44*/ GIMT_Encode4(70190),
    /*TargetOpcode::G_UITOFP*//*Label 45*/ GIMT_Encode4(70475),
    /*TargetOpcode::G_FABS*//*Label 46*/ GIMT_Encode4(70561), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 47*/ GIMT_Encode4(70827),
    /*TargetOpcode::G_SMAX*//*Label 48*/ GIMT_Encode4(71019),
    /*TargetOpcode::G_UMIN*//*Label 49*/ GIMT_Encode4(71211),
    /*TargetOpcode::G_UMAX*//*Label 50*/ GIMT_Encode4(71403), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 51*/ GIMT_Encode4(71595), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 52*/ GIMT_Encode4(71725), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 53*/ GIMT_Encode4(71790), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 54*/ GIMT_Encode4(72355),
    /*TargetOpcode::G_BSWAP*//*Label 55*/ GIMT_Encode4(72585), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 56*/ GIMT_Encode4(72773), GIMT_Encode4(0),
    /*TargetOpcode::G_FRINT*//*Label 57*/ GIMT_Encode4(73039),
    // Label 0: @742
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 67*/ GIMT_Encode4(2247),
    /*GILLT_s32*//*Label 59*/ GIMT_Encode4(785),
    /*GILLT_s64*//*Label 60*/ GIMT_Encode4(1269),
    /*GILLT_v2s16*//*Label 61*/ GIMT_Encode4(1463),
    /*GILLT_v2s64*//*Label 62*/ GIMT_Encode4(1499),
    /*GILLT_v4s8*//*Label 63*/ GIMT_Encode4(1677),
    /*GILLT_v4s32*//*Label 64*/ GIMT_Encode4(1713),
    /*GILLT_v8s16*//*Label 65*/ GIMT_Encode4(1891),
    /*GILLT_v16s8*//*Label 66*/ GIMT_Encode4(2069),
    // Label 59: @785
    GIM_Try, /*On fail goto*//*Label 68*/ GIMT_Encode4(1268),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 69*/ GIMT_Encode4(877), // Rule ID 2366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2366,
        GIR_Done,
      // Label 69: @877
      GIM_Try, /*On fail goto*//*Label 70*/ GIMT_Encode4(956), // Rule ID 834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LSA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 834,
        GIR_Done,
      // Label 70: @956
      GIM_Try, /*On fail goto*//*Label 71*/ GIMT_Encode4(1008), // Rule ID 40 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm16)  =>  (ADDiu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDiu),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 71: @1008
      GIM_Try, /*On fail goto*//*Label 72*/ GIMT_Encode4(1060), // Rule ID 2135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddiur2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDIUR2_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2135,
        GIR_Done,
      // Label 72: @1060
      GIM_Try, /*On fail goto*//*Label 73*/ GIMT_Encode4(1112), // Rule ID 2136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddius5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDIUS5_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2136,
        GIR_Done,
      // Label 73: @1112
      GIM_Try, /*On fail goto*//*Label 74*/ GIMT_Encode4(1143), // Rule ID 1208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1208,
        GIR_Done,
      // Label 74: @1143
      GIM_Try, /*On fail goto*//*Label 75*/ GIMT_Encode4(1174), // Rule ID 46 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 75: @1174
      GIM_Try, /*On fail goto*//*Label 76*/ GIMT_Encode4(1205), // Rule ID 1060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1060,
        GIR_Done,
      // Label 76: @1205
      GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(1236), // Rule ID 1072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1072,
        GIR_Done,
      // Label 77: @1236
      GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(1267), // Rule ID 1795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AdduRxRyRz16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1795,
        GIR_Done,
      // Label 78: @1267
      GIM_Reject,
    // Label 68: @1268
    GIM_Reject,
    // Label 60: @1269
    GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(1462),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(1361), // Rule ID 2367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2367,
        GIR_Done,
      // Label 80: @1361
      GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1435), // Rule ID 835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DLSA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 835,
        GIR_Done,
      // Label 81: @1435
      GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1461), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DADDu),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 202,
        GIR_Done,
      // Label 82: @1461
      GIM_Reject,
    // Label 79: @1462
    GIM_Reject,
    // Label 61: @1463
    GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1498), // Rule ID 1894 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1894,
      GIR_Done,
    // Label 83: @1498
    GIM_Reject,
    // Label 62: @1499
    GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1676),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1583), // Rule ID 2371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2371,
        GIR_Done,
      // Label 85: @1583
      GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1649), // Rule ID 843 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 843,
        GIR_Done,
      // Label 86: @1649
      GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1675), // Rule ID 510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_D),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 510,
        GIR_Done,
      // Label 87: @1675
      GIM_Reject,
    // Label 84: @1676
    GIM_Reject,
    // Label 63: @1677
    GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1712), // Rule ID 1900 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1900,
      GIR_Done,
    // Label 88: @1712
    GIM_Reject,
    // Label 64: @1713
    GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1890),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1797), // Rule ID 2370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2370,
        GIR_Done,
      // Label 90: @1797
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1863), // Rule ID 842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 842,
        GIR_Done,
      // Label 91: @1863
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1889), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_W),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 509,
        GIR_Done,
      // Label 92: @1889
      GIM_Reject,
    // Label 89: @1890
    GIM_Reject,
    // Label 65: @1891
    GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(2068),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1975), // Rule ID 2369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2369,
        GIR_Done,
      // Label 94: @1975
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(2041), // Rule ID 841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 841,
        GIR_Done,
      // Label 95: @2041
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(2067), // Rule ID 508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_H),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 508,
        GIR_Done,
      // Label 96: @2067
      GIM_Reject,
    // Label 93: @2068
    GIM_Reject,
    // Label 66: @2069
    GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(2246),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(2153), // Rule ID 2368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2368,
        GIR_Done,
      // Label 98: @2153
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(2219), // Rule ID 840 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 840,
        GIR_Done,
      // Label 99: @2219
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2245), // Rule ID 507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_B),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 507,
        GIR_Done,
      // Label 100: @2245
      GIM_Reject,
    // Label 97: @2246
    GIM_Reject,
    // Label 67: @2247
    GIM_Reject,
    // Label 1: @2248
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 109*/ GIMT_Encode4(3040),
    /*GILLT_s32*//*Label 101*/ GIMT_Encode4(2291),
    /*GILLT_s64*//*Label 102*/ GIMT_Encode4(2500),
    /*GILLT_v2s16*//*Label 103*/ GIMT_Encode4(2540),
    /*GILLT_v2s64*//*Label 104*/ GIMT_Encode4(2576),
    /*GILLT_v4s8*//*Label 105*/ GIMT_Encode4(2683),
    /*GILLT_v4s32*//*Label 106*/ GIMT_Encode4(2719),
    /*GILLT_v8s16*//*Label 107*/ GIMT_Encode4(2826),
    /*GILLT_v16s8*//*Label 108*/ GIMT_Encode4(2933),
    // Label 101: @2291
    GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(2499),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(2343), // Rule ID 1794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NegRxRy16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rx]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // r
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1794,
        GIR_Done,
      // Label 111: @2343
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2374), // Rule ID 1210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1210,
        GIR_Done,
      // Label 112: @2374
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(2405), // Rule ID 47 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 47,
        GIR_Done,
      // Label 113: @2405
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(2436), // Rule ID 1064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1064,
        GIR_Done,
      // Label 114: @2436
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2467), // Rule ID 1073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 115: @2467
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2498), // Rule ID 1799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SubuRxRyRz16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1799,
        GIR_Done,
      // Label 116: @2498
      GIM_Reject,
    // Label 110: @2499
    GIM_Reject,
    // Label 102: @2500
    GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2539), // Rule ID 203 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSUBu),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 203,
      GIR_Done,
    // Label 117: @2539
    GIM_Reject,
    // Label 103: @2540
    GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2575), // Rule ID 1896 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1896,
      GIR_Done,
    // Label 118: @2575
    GIM_Reject,
    // Label 104: @2576
    GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2682),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2660), // Rule ID 899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBV_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 899,
        GIR_Done,
      // Label 120: @2660
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2681), // Rule ID 1028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_D),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1028,
        GIR_Done,
      // Label 121: @2681
      GIM_Reject,
    // Label 119: @2682
    GIM_Reject,
    // Label 105: @2683
    GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2718), // Rule ID 1902 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1902,
      GIR_Done,
    // Label 122: @2718
    GIM_Reject,
    // Label 106: @2719
    GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2825),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2803), // Rule ID 898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBV_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 898,
        GIR_Done,
      // Label 124: @2803
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2824), // Rule ID 1027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_W),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1027,
        GIR_Done,
      // Label 125: @2824
      GIM_Reject,
    // Label 123: @2825
    GIM_Reject,
    // Label 107: @2826
    GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2932),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2910), // Rule ID 897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBV_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 897,
        GIR_Done,
      // Label 127: @2910
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2931), // Rule ID 1026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_H),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1026,
        GIR_Done,
      // Label 128: @2931
      GIM_Reject,
    // Label 126: @2932
    GIM_Reject,
    // Label 108: @2933
    GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(3039),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(3017), // Rule ID 896 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBV_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 896,
        GIR_Done,
      // Label 130: @3017
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(3038), // Rule ID 1025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_B),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1025,
        GIR_Done,
      // Label 131: @3038
      GIM_Reject,
    // Label 129: @3039
    GIM_Reject,
    // Label 109: @3040
    GIM_Reject,
    // Label 2: @3041
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 139*/ GIMT_Encode4(3578),
    /*GILLT_s32*//*Label 132*/ GIMT_Encode4(3084),
    /*GILLT_s64*//*Label 133*/ GIMT_Encode4(3290),
    /*GILLT_v2s16*//*Label 134*/ GIMT_Encode4(3382),
    /*GILLT_v2s64*//*Label 135*/ GIMT_Encode4(3418), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 136*/ GIMT_Encode4(3458),
    /*GILLT_v8s16*//*Label 137*/ GIMT_Encode4(3498),
    /*GILLT_v16s8*//*Label 138*/ GIMT_Encode4(3538),
    // Label 132: @3084
    GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(3289),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(3140), // Rule ID 48 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 141: @3140
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(3171), // Rule ID 332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 332,
        GIR_Done,
      // Label 142: @3171
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(3214), // Rule ID 1074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MM),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 143: @3214
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(3245), // Rule ID 1179 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1179,
        GIR_Done,
      // Label 144: @3245
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(3288), // Rule ID 1797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MultRxRyRz16),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1797,
        GIR_Done,
      // Label 145: @3288
      GIM_Reject,
    // Label 140: @3289
    GIM_Reject,
    // Label 133: @3290
    GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(3381),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(3364), // Rule ID 274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P0), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P1), GIMT_Encode2(RegState::Dead),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P2), GIMT_Encode2(RegState::Dead),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 274,
        GIR_Done,
      // Label 147: @3364
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3380), // Rule ID 347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
        // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL_R6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 347,
        GIR_Done,
      // Label 148: @3380
      GIM_Reject,
    // Label 146: @3381
    GIM_Reject,
    // Label 134: @3382
    GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3417), // Rule ID 1898 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
      GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag21), GIMT_Encode2(RegState::Dead),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1898,
      GIR_Done,
    // Label 149: @3417
    GIM_Reject,
    // Label 135: @3418
    GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(3457), // Rule ID 907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 907,
      GIR_Done,
    // Label 150: @3457
    GIM_Reject,
    // Label 136: @3458
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3497), // Rule ID 906 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_W),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 906,
      GIR_Done,
    // Label 151: @3497
    GIM_Reject,
    // Label 137: @3498
    GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(3537), // Rule ID 905 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_H),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 905,
      GIR_Done,
    // Label 152: @3537
    GIM_Reject,
    // Label 138: @3538
    GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3577), // Rule ID 904 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_B),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 904,
      GIR_Done,
    // Label 153: @3577
    GIM_Reject,
    // Label 139: @3578
    GIM_Reject,
    // Label 3: @3579
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 160*/ GIMT_Encode4(3884),
    /*GILLT_s32*//*Label 154*/ GIMT_Encode4(3622),
    /*GILLT_s64*//*Label 155*/ GIMT_Encode4(3684), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 156*/ GIMT_Encode4(3724), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 157*/ GIMT_Encode4(3764),
    /*GILLT_v8s16*//*Label 158*/ GIMT_Encode4(3804),
    /*GILLT_v16s8*//*Label 159*/ GIMT_Encode4(3844),
    // Label 154: @3622
    GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3683),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3666), // Rule ID 326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 326,
        GIR_Done,
      // Label 162: @3666
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3682), // Rule ID 1172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1172,
        GIR_Done,
      // Label 163: @3682
      GIM_Reject,
    // Label 161: @3683
    GIM_Reject,
    // Label 155: @3684
    GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3723), // Rule ID 341 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIV),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 341,
      GIR_Done,
    // Label 164: @3723
    GIM_Reject,
    // Label 156: @3724
    GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3763), // Rule ID 647 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 647,
      GIR_Done,
    // Label 165: @3763
    GIM_Reject,
    // Label 157: @3764
    GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3803), // Rule ID 646 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_W),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 646,
      GIR_Done,
    // Label 166: @3803
    GIM_Reject,
    // Label 158: @3804
    GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3843), // Rule ID 645 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_H),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 645,
      GIR_Done,
    // Label 167: @3843
    GIM_Reject,
    // Label 159: @3844
    GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3883), // Rule ID 644 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_B),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 644,
      GIR_Done,
    // Label 168: @3883
    GIM_Reject,
    // Label 160: @3884
    GIM_Reject,
    // Label 4: @3885
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 175*/ GIMT_Encode4(4190),
    /*GILLT_s32*//*Label 169*/ GIMT_Encode4(3928),
    /*GILLT_s64*//*Label 170*/ GIMT_Encode4(3990), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 171*/ GIMT_Encode4(4030), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 172*/ GIMT_Encode4(4070),
    /*GILLT_v8s16*//*Label 173*/ GIMT_Encode4(4110),
    /*GILLT_v16s8*//*Label 174*/ GIMT_Encode4(4150),
    // Label 169: @3928
    GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(3989),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(3972), // Rule ID 327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 327,
        GIR_Done,
      // Label 177: @3972
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(3988), // Rule ID 1173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1173,
        GIR_Done,
      // Label 178: @3988
      GIM_Reject,
    // Label 176: @3989
    GIM_Reject,
    // Label 170: @3990
    GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(4029), // Rule ID 342 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIVU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 342,
      GIR_Done,
    // Label 179: @4029
    GIM_Reject,
    // Label 171: @4030
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(4069), // Rule ID 651 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 651,
      GIR_Done,
    // Label 180: @4069
    GIM_Reject,
    // Label 172: @4070
    GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(4109), // Rule ID 650 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_W),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 650,
      GIR_Done,
    // Label 181: @4109
    GIM_Reject,
    // Label 173: @4110
    GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(4149), // Rule ID 649 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_H),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 649,
      GIR_Done,
    // Label 182: @4149
    GIM_Reject,
    // Label 174: @4150
    GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(4189), // Rule ID 648 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_B),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 648,
      GIR_Done,
    // Label 183: @4189
    GIM_Reject,
    // Label 175: @4190
    GIM_Reject,
    // Label 5: @4191
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 190*/ GIMT_Encode4(4496),
    /*GILLT_s32*//*Label 184*/ GIMT_Encode4(4234),
    /*GILLT_s64*//*Label 185*/ GIMT_Encode4(4296), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 186*/ GIMT_Encode4(4336), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 187*/ GIMT_Encode4(4376),
    /*GILLT_v8s16*//*Label 188*/ GIMT_Encode4(4416),
    /*GILLT_v16s8*//*Label 189*/ GIMT_Encode4(4456),
    // Label 184: @4234
    GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(4295),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(4278), // Rule ID 328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 328,
        GIR_Done,
      // Label 192: @4278
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(4294), // Rule ID 1177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1177,
        GIR_Done,
      // Label 193: @4294
      GIM_Reject,
    // Label 191: @4295
    GIM_Reject,
    // Label 185: @4296
    GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(4335), // Rule ID 343 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMOD),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 343,
      GIR_Done,
    // Label 194: @4335
    GIM_Reject,
    // Label 186: @4336
    GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(4375), // Rule ID 887 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 887,
      GIR_Done,
    // Label 195: @4375
    GIM_Reject,
    // Label 187: @4376
    GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(4415), // Rule ID 886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_W),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 886,
      GIR_Done,
    // Label 196: @4415
    GIM_Reject,
    // Label 188: @4416
    GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(4455), // Rule ID 885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_H),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 885,
      GIR_Done,
    // Label 197: @4455
    GIM_Reject,
    // Label 189: @4456
    GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(4495), // Rule ID 884 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_B),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 884,
      GIR_Done,
    // Label 198: @4495
    GIM_Reject,
    // Label 190: @4496
    GIM_Reject,
    // Label 6: @4497
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 205*/ GIMT_Encode4(4802),
    /*GILLT_s32*//*Label 199*/ GIMT_Encode4(4540),
    /*GILLT_s64*//*Label 200*/ GIMT_Encode4(4602), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 201*/ GIMT_Encode4(4642), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 202*/ GIMT_Encode4(4682),
    /*GILLT_v8s16*//*Label 203*/ GIMT_Encode4(4722),
    /*GILLT_v16s8*//*Label 204*/ GIMT_Encode4(4762),
    // Label 199: @4540
    GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4601),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(4584), // Rule ID 329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 329,
        GIR_Done,
      // Label 207: @4584
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(4600), // Rule ID 1178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1178,
        GIR_Done,
      // Label 208: @4600
      GIM_Reject,
    // Label 206: @4601
    GIM_Reject,
    // Label 200: @4602
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(4641), // Rule ID 344 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMODU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 344,
      GIR_Done,
    // Label 209: @4641
    GIM_Reject,
    // Label 201: @4642
    GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(4681), // Rule ID 891 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 891,
      GIR_Done,
    // Label 210: @4681
    GIM_Reject,
    // Label 202: @4682
    GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(4721), // Rule ID 890 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_W),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 890,
      GIR_Done,
    // Label 211: @4721
    GIM_Reject,
    // Label 203: @4722
    GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4761), // Rule ID 889 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_H),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 889,
      GIR_Done,
    // Label 212: @4761
    GIM_Reject,
    // Label 204: @4762
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4801), // Rule ID 888 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_B),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 888,
      GIR_Done,
    // Label 213: @4801
    GIM_Reject,
    // Label 205: @4802
    GIM_Reject,
    // Label 7: @4803
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 220*/ GIMT_Encode4(5446),
    /*GILLT_s32*//*Label 214*/ GIMT_Encode4(4846),
    /*GILLT_s64*//*Label 215*/ GIMT_Encode4(5172), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 216*/ GIMT_Encode4(5286), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 217*/ GIMT_Encode4(5326),
    /*GILLT_v8s16*//*Label 218*/ GIMT_Encode4(5366),
    /*GILLT_v16s8*//*Label 219*/ GIMT_Encode4(5406),
    // Label 214: @4846
    GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(5171),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(4911), // Rule ID 41 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ANDi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ANDi),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 222: @4911
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(4963), // Rule ID 2138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2138,
        GIR_Done,
      // Label 223: @4963
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(5015), // Rule ID 2297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MMR6),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2297,
        GIR_Done,
      // Label 224: @5015
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(5046), // Rule ID 51 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 51,
        GIR_Done,
      // Label 225: @5046
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(5077), // Rule ID 1061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND16_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1061,
        GIR_Done,
      // Label 226: @5077
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(5108), // Rule ID 1077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 227: @5108
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(5139), // Rule ID 1170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1170,
        GIR_Done,
      // Label 228: @5139
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(5170), // Rule ID 1796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AndRxRxRy16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1796,
        GIR_Done,
      // Label 229: @5170
      GIM_Reject,
    // Label 221: @5171
    GIM_Reject,
    // Label 215: @5172
    GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(5285),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(5258), // Rule ID 269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BADDu),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 269,
        GIR_Done,
      // Label 231: @5258
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(5284), // Rule ID 206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND64),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 206,
        GIR_Done,
      // Label 232: @5284
      GIM_Reject,
    // Label 230: @5285
    GIM_Reject,
    // Label 216: @5286
    GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(5325), // Rule ID 518 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_D_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 518,
      GIR_Done,
    // Label 233: @5325
    GIM_Reject,
    // Label 217: @5326
    GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(5365), // Rule ID 517 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_W_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 517,
      GIR_Done,
    // Label 234: @5365
    GIM_Reject,
    // Label 218: @5366
    GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(5405), // Rule ID 516 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_H_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 516,
      GIR_Done,
    // Label 235: @5405
    GIM_Reject,
    // Label 219: @5406
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(5445), // Rule ID 515 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 515,
      GIR_Done,
    // Label 236: @5445
    GIM_Reject,
    // Label 220: @5446
    GIM_Reject,
    // Label 8: @5447
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 243*/ GIMT_Encode4(5912),
    /*GILLT_s32*//*Label 237*/ GIMT_Encode4(5490),
    /*GILLT_s64*//*Label 238*/ GIMT_Encode4(5712), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 239*/ GIMT_Encode4(5752), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 240*/ GIMT_Encode4(5792),
    /*GILLT_v8s16*//*Label 241*/ GIMT_Encode4(5832),
    /*GILLT_v16s8*//*Label 242*/ GIMT_Encode4(5872),
    // Label 237: @5490
    GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(5711),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(5555), // Rule ID 42 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ORi),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 245: @5555
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(5586), // Rule ID 52 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 52,
        GIR_Done,
      // Label 246: @5586
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(5617), // Rule ID 1063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR16_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1063,
        GIR_Done,
      // Label 247: @5617
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(5648), // Rule ID 1078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 248: @5648
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(5679), // Rule ID 1183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1183,
        GIR_Done,
      // Label 249: @5679
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(5710), // Rule ID 1798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OrRxRxRy16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1798,
        GIR_Done,
      // Label 250: @5710
      GIM_Reject,
    // Label 244: @5711
    GIM_Reject,
    // Label 238: @5712
    GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(5751), // Rule ID 207 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR64),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 207,
      GIR_Done,
    // Label 251: @5751
    GIM_Reject,
    // Label 239: @5752
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5791), // Rule ID 924 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_D_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 924,
      GIR_Done,
    // Label 252: @5791
    GIM_Reject,
    // Label 240: @5792
    GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5831), // Rule ID 923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_W_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 923,
      GIR_Done,
    // Label 253: @5831
    GIM_Reject,
    // Label 241: @5832
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5871), // Rule ID 922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_H_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 922,
      GIR_Done,
    // Label 254: @5871
    GIM_Reject,
    // Label 242: @5872
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5911), // Rule ID 921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 921,
      GIR_Done,
    // Label 255: @5911
    GIM_Reject,
    // Label 243: @5912
    GIM_Reject,
    // Label 9: @5913
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 262*/ GIMT_Encode4(6973),
    /*GILLT_s32*//*Label 256*/ GIMT_Encode4(5956),
    /*GILLT_s64*//*Label 257*/ GIMT_Encode4(6706), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 258*/ GIMT_Encode4(6813), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 259*/ GIMT_Encode4(6853),
    /*GILLT_v8s16*//*Label 260*/ GIMT_Encode4(6893),
    /*GILLT_v16s8*//*Label 261*/ GIMT_Encode4(6933),
    // Label 256: @5956
    GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(6705),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(6035), // Rule ID 54 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 54,
        GIR_Done,
      // Label 264: @6035
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(6101), // Rule ID 1080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1080,
        GIR_Done,
      // Label 265: @6101
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(6167), // Rule ID 1182 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1182,
        GIR_Done,
      // Label 266: @6167
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(6206), // Rule ID 1209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1209,
        GIR_Done,
      // Label 267: @6206
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(6245), // Rule ID 1062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1062,
        GIR_Done,
      // Label 268: @6245
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(6290), // Rule ID 1397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1397,
        GIR_Done,
      // Label 269: @6290
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(6329), // Rule ID 1793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NotRxRy16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rx]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // r
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1793,
        GIR_Done,
      // Label 270: @6329
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(6368), // Rule ID 2133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2133,
        GIR_Done,
      // Label 271: @6368
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(6413), // Rule ID 2134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2134,
        GIR_Done,
      // Label 272: @6413
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(6452), // Rule ID 2300 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2300,
        GIR_Done,
      // Label 273: @6452
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(6497), // Rule ID 2301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2301,
        GIR_Done,
      // Label 274: @6497
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(6549), // Rule ID 43 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (XORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XORi),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 275: @6549
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(6580), // Rule ID 53 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 53,
        GIR_Done,
      // Label 276: @6580
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(6611), // Rule ID 1065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR16_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1065,
        GIR_Done,
      // Label 277: @6611
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(6642), // Rule ID 1079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 278: @6642
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(6673), // Rule ID 1186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MMR6),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1186,
        GIR_Done,
      // Label 279: @6673
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(6704), // Rule ID 1800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XorRxRxRy16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1800,
        GIR_Done,
      // Label 280: @6704
      GIM_Reject,
    // Label 263: @6705
    GIM_Reject,
    // Label 257: @6706
    GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(6812),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(6785), // Rule ID 209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NOR64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 209,
        GIR_Done,
      // Label 282: @6785
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(6811), // Rule ID 208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR64),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 283: @6811
      GIM_Reject,
    // Label 281: @6812
    GIM_Reject,
    // Label 258: @6813
    GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6852), // Rule ID 1040 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_D_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1040,
      GIR_Done,
    // Label 284: @6852
    GIM_Reject,
    // Label 259: @6853
    GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(6892), // Rule ID 1039 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_W_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1039,
      GIR_Done,
    // Label 285: @6892
    GIM_Reject,
    // Label 260: @6893
    GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(6932), // Rule ID 1038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_H_PSEUDO),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1038,
      GIR_Done,
    // Label 286: @6932
    GIM_Reject,
    // Label 261: @6933
    GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(6972), // Rule ID 1037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1037,
      GIR_Done,
    // Label 287: @6972
    GIM_Reject,
    // Label 262: @6973
    GIM_Reject,
    // Label 10: @6974
    GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(7057),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(7025), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::AFGR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 289: @7025
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(7056), // Rule ID 181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64_64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64_64),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 290: @7056
      GIM_Reject,
    // Label 288: @7057
    GIM_Reject,
    // Label 11: @7058
    GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(7150),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(7114), // Rule ID 719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rs)  =>  (FILL_D:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 719,
        GIR_Done,
      // Label 292: @7114
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(7149), // Rule ID 721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs, FGR64:{ *:[f64] }:$fs)  =>  (FILL_FD_PSEUDO:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_FD_PSEUDO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 721,
        GIR_Done,
      // Label 293: @7149
      GIM_Reject,
    // Label 291: @7150
    GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(7262),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(7216), // Rule ID 718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] rs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_W:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 718,
        GIR_Done,
      // Label 295: @7216
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(7261), // Rule ID 720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
        // MIs[0] fs
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
        // (build_vector:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs)  =>  (FILL_FW_PSEUDO:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_FW_PSEUDO),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // fs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 720,
        GIR_Done,
      // Label 296: @7261
      GIM_Reject,
    // Label 294: @7262
    GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(7343), // Rule ID 717 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/9,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_H:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_H),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 717,
      GIR_Done,
    // Label 297: @7343
    GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(7464), // Rule ID 716 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
      // MIs[0] rs
      GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
      // (build_vector:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_B:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FILL_B),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 716,
      GIR_Done,
    // Label 298: @7464
    GIM_Reject,
    // Label 12: @7465
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 307*/ GIMT_Encode4(12032),
    /*GILLT_s32*//*Label 299*/ GIMT_Encode4(7508),
    /*GILLT_s64*//*Label 300*/ GIMT_Encode4(7821),
    /*GILLT_v2s16*//*Label 301*/ GIMT_Encode4(7884),
    /*GILLT_v2s64*//*Label 302*/ GIMT_Encode4(7948),
    /*GILLT_v4s8*//*Label 303*/ GIMT_Encode4(9141),
    /*GILLT_v4s32*//*Label 304*/ GIMT_Encode4(9205),
    /*GILLT_v8s16*//*Label 305*/ GIMT_Encode4(10338),
    /*GILLT_v16s8*//*Label 306*/ GIMT_Encode4(11317),
    // Label 299: @7508
    GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(7538), // Rule ID 135 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 135,
      GIR_Done,
    // Label 308: @7538
    GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(7568), // Rule ID 136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 136,
      GIR_Done,
    // Label 309: @7568
    GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(7598), // Rule ID 1160 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1160,
      GIR_Done,
    // Label 310: @7598
    GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(7628), // Rule ID 1161 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1161,
      GIR_Done,
    // Label 311: @7628
    GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(7658), // Rule ID 1175 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MMR6),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1175,
      GIR_Done,
    // Label 312: @7658
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(7688), // Rule ID 1176 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MMR6),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1176,
      GIR_Done,
    // Label 313: @7688
    GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(7721), // Rule ID 1881 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1881,
      GIR_Done,
    // Label 314: @7721
    GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(7754), // Rule ID 1882 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
      // GIR_Coverage, 1882,
      GIR_Done,
    // Label 315: @7754
    GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(7787), // Rule ID 1885 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1885,
      GIR_Done,
    // Label 316: @7787
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(7820), // Rule ID 1886 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
      // GIR_Coverage, 1886,
      GIR_Done,
    // Label 317: @7820
    GIM_Reject,
    // Label 300: @7821
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(7883),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(7856), // Rule ID 137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMTC1),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 137,
        GIR_Done,
      // Label 319: @7856
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(7882), // Rule ID 138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
        // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMFC1),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 138,
        GIR_Done,
      // Label 320: @7882
      GIM_Reject,
    // Label 318: @7883
    GIM_Reject,
    // Label 301: @7884
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(7947),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(7922), // Rule ID 1883 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1883,
        GIR_Done,
      // Label 322: @7922
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(7946), // Rule ID 1887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1887,
        GIR_Done,
      // Label 323: @7946
      GIM_Reject,
    // Label 321: @7947
    GIM_Reject,
    // Label 302: @7948
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(7976), // Rule ID 1968 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1968,
      GIR_Done,
    // Label 324: @7976
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(8004), // Rule ID 1971 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1971,
      GIR_Done,
    // Label 325: @8004
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(8032), // Rule ID 1988 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1988,
      GIR_Done,
    // Label 326: @8032
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(8060), // Rule ID 1989 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1989,
      GIR_Done,
    // Label 327: @8060
    GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(8088), // Rule ID 1990 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1990,
      GIR_Done,
    // Label 328: @8088
    GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(8116), // Rule ID 1991 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1991,
      GIR_Done,
    // Label 329: @8116
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(8144), // Rule ID 1992 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1992,
      GIR_Done,
    // Label 330: @8144
    GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(8172), // Rule ID 1998 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1998,
      GIR_Done,
    // Label 331: @8172
    GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(8200), // Rule ID 1999 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 1999,
      GIR_Done,
    // Label 332: @8200
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(8228), // Rule ID 2000 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2000,
      GIR_Done,
    // Label 333: @8228
    GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(8256), // Rule ID 2001 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2001,
      GIR_Done,
    // Label 334: @8256
    GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(8284), // Rule ID 2002 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      // GIR_Coverage, 2002,
      GIR_Done,
    // Label 335: @8284
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(8402), // Rule ID 2007 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 336: @8402
    GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(8520), // Rule ID 2008 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2008,
      GIR_Done,
    // Label 337: @8520
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(8594), // Rule ID 2012 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2012,
      GIR_Done,
    // Label 338: @8594
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(8668), // Rule ID 2013 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2013,
      GIR_Done,
    // Label 339: @8668
    GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(8742), // Rule ID 2017 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2017,
      GIR_Done,
    // Label 340: @8742
    GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(8816), // Rule ID 2018 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2018,
      GIR_Done,
    // Label 341: @8816
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(8897), // Rule ID 2022 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2022,
      GIR_Done,
    // Label 342: @8897
    GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(8978), // Rule ID 2023 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2023,
      GIR_Done,
    // Label 343: @8978
    GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(9059), // Rule ID 2027 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2027,
      GIR_Done,
    // Label 344: @9059
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(9140), // Rule ID 2028 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2028,
      GIR_Done,
    // Label 345: @9140
    GIM_Reject,
    // Label 303: @9141
    GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(9204),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(9179), // Rule ID 1884 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1884,
        GIR_Done,
      // Label 347: @9179
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(9203), // Rule ID 1888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
        // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        // GIR_Coverage, 1888,
        GIR_Done,
      // Label 348: @9203
      GIM_Reject,
    // Label 346: @9204
    GIM_Reject,
    // Label 304: @9205
    GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(9233), // Rule ID 1967 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1967,
      GIR_Done,
    // Label 349: @9233
    GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(9261), // Rule ID 1970 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1970,
      GIR_Done,
    // Label 350: @9261
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(9289), // Rule ID 1983 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1983,
      GIR_Done,
    // Label 351: @9289
    GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(9317), // Rule ID 1984 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1984,
      GIR_Done,
    // Label 352: @9317
    GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(9345), // Rule ID 1985 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1985,
      GIR_Done,
    // Label 353: @9345
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(9373), // Rule ID 1986 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1986,
      GIR_Done,
    // Label 354: @9373
    GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(9401), // Rule ID 1987 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1987,
      GIR_Done,
    // Label 355: @9401
    GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(9429), // Rule ID 1993 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1993,
      GIR_Done,
    // Label 356: @9429
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(9457), // Rule ID 1994 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1994,
      GIR_Done,
    // Label 357: @9457
    GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(9485), // Rule ID 1995 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1995,
      GIR_Done,
    // Label 358: @9485
    GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(9513), // Rule ID 1996 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1996,
      GIR_Done,
    // Label 359: @9513
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(9541), // Rule ID 1997 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      // GIR_Coverage, 1997,
      GIR_Done,
    // Label 360: @9541
    GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(9615), // Rule ID 2005 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2005,
      GIR_Done,
    // Label 361: @9615
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(9689), // Rule ID 2006 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2006,
      GIR_Done,
    // Label 362: @9689
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(9770), // Rule ID 2010 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2010,
      GIR_Done,
    // Label 363: @9770
    GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(9851), // Rule ID 2011 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2011,
      GIR_Done,
    // Label 364: @9851
    GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(9932), // Rule ID 2015 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2015,
      GIR_Done,
    // Label 365: @9932
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(10013), // Rule ID 2016 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2016,
      GIR_Done,
    // Label 366: @10013
    GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(10094), // Rule ID 2032 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2032,
      GIR_Done,
    // Label 367: @10094
    GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(10175), // Rule ID 2033 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2033,
      GIR_Done,
    // Label 368: @10175
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(10256), // Rule ID 2037 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2037,
      GIR_Done,
    // Label 369: @10256
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(10337), // Rule ID 2038 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2038,
      GIR_Done,
    // Label 370: @10337
    GIM_Reject,
    // Label 305: @10338
    GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(10366), // Rule ID 1966 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1966,
      GIR_Done,
    // Label 371: @10366
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(10394), // Rule ID 1969 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1969,
      GIR_Done,
    // Label 372: @10394
    GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(10422), // Rule ID 1978 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1978,
      GIR_Done,
    // Label 373: @10422
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(10450), // Rule ID 1979 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1979,
      GIR_Done,
    // Label 374: @10450
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(10478), // Rule ID 1980 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1980,
      GIR_Done,
    // Label 375: @10478
    GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(10506), // Rule ID 1981 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1981,
      GIR_Done,
    // Label 376: @10506
    GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(10534), // Rule ID 1982 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      // GIR_Coverage, 1982,
      GIR_Done,
    // Label 377: @10534
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(10615), // Rule ID 2003 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2003,
      GIR_Done,
    // Label 378: @10615
    GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(10696), // Rule ID 2004 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2004,
      GIR_Done,
    // Label 379: @10696
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(10777), // Rule ID 2020 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2020,
      GIR_Done,
    // Label 380: @10777
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(10858), // Rule ID 2021 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2021,
      GIR_Done,
    // Label 381: @10858
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(10939), // Rule ID 2025 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2025,
      GIR_Done,
    // Label 382: @10939
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(11020), // Rule ID 2026 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2026,
      GIR_Done,
    // Label 383: @11020
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(11094), // Rule ID 2030 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2030,
      GIR_Done,
    // Label 384: @11094
    GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(11168), // Rule ID 2031 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2031,
      GIR_Done,
    // Label 385: @11168
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(11242), // Rule ID 2035 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2035,
      GIR_Done,
    // Label 386: @11242
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(11316), // Rule ID 2036 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2036,
      GIR_Done,
    // Label 387: @11316
    GIM_Reject,
    // Label 306: @11317
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(11345), // Rule ID 1972 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1972,
      GIR_Done,
    // Label 388: @11345
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(11373), // Rule ID 1973 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1973,
      GIR_Done,
    // Label 389: @11373
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(11401), // Rule ID 1974 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1974,
      GIR_Done,
    // Label 390: @11401
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(11429), // Rule ID 1975 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1975,
      GIR_Done,
    // Label 391: @11429
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(11457), // Rule ID 1976 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1976,
      GIR_Done,
    // Label 392: @11457
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(11485), // Rule ID 1977 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      // GIR_Coverage, 1977,
      GIR_Done,
    // Label 393: @11485
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(11566), // Rule ID 2009 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2009,
      GIR_Done,
    // Label 394: @11566
    GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(11647), // Rule ID 2014 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2014,
      GIR_Done,
    // Label 395: @11647
    GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(11721), // Rule ID 2019 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2019,
      GIR_Done,
    // Label 396: @11721
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(11795), // Rule ID 2024 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2024,
      GIR_Done,
    // Label 397: @11795
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(11913), // Rule ID 2029 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2029,
      GIR_Done,
    // Label 398: @11913
    GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(12031), // Rule ID 2034 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 2034,
      GIR_Done,
    // Label 399: @12031
    GIM_Reject,
    // Label 307: @12032
    GIM_Reject,
    // Label 13: @12033
    GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(12105), // Rule ID 1957 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LWX),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1957,
      GIR_Done,
    // Label 400: @12105
    GIM_Reject,
    // Label 14: @12106
    GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(12181), // Rule ID 1956 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LHX),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1956,
      GIR_Done,
    // Label 401: @12181
    GIM_Reject,
    // Label 15: @12182
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(12257), // Rule ID 1955 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckIsSafeToFold, /*InsnID*/1,
      // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LBUX),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1955,
      GIR_Done,
    // Label 402: @12257
    GIM_Reject,
    // Label 16: @12258
    GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(14891),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(12322), // Rule ID 428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7405:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPL_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 428,
        GIR_Done,
      // Label 404: @12322
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(12378), // Rule ID 429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7404:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPL_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 429,
        GIR_Done,
      // Label 405: @12378
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(12434), // Rule ID 1288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7404:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPL_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1288,
        GIR_Done,
      // Label 406: @12434
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(12490), // Rule ID 1289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7405:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPL_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1289,
        GIR_Done,
      // Label 407: @12490
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(12538), // Rule ID 362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7402:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 362,
        GIR_Done,
      // Label 408: @12538
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(12586), // Rule ID 369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7384:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 369,
        GIR_Done,
      // Label 409: @12586
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(12634), // Rule ID 370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7385:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 370,
        GIR_Done,
      // Label 410: @12634
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(12682), // Rule ID 371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7386:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 371,
        GIR_Done,
      // Label 411: @12682
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(12730), // Rule ID 372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7388:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 372,
        GIR_Done,
      // Label 412: @12730
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(12778), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7387:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 413: @12778
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(12826), // Rule ID 374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7389:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 374,
        GIR_Done,
      // Label 414: @12826
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(12874), // Rule ID 375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7390:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 375,
        GIR_Done,
      // Label 415: @12874
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(12922), // Rule ID 376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7392:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 376,
        GIR_Done,
      // Label 416: @12922
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(12970), // Rule ID 377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7391:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 377,
        GIR_Done,
      // Label 417: @12970
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(13018), // Rule ID 378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7393:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 378,
        GIR_Done,
      // Label 418: @13018
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(13066), // Rule ID 426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6958:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BITREV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 426,
        GIR_Done,
      // Label 419: @13066
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(13114), // Rule ID 430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7405:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 430,
        GIR_Done,
      // Label 420: @13114
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(13162), // Rule ID 431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7404:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 431,
        GIR_Done,
      // Label 421: @13162
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(13210), // Rule ID 680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7110:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FCLASS_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 680,
        GIR_Done,
      // Label 422: @13210
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(13258), // Rule ID 681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7109:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FCLASS_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 681,
        GIR_Done,
      // Label 423: @13258
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(13306), // Rule ID 704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7136:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 704,
        GIR_Done,
      // Label 424: @13306
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(13354), // Rule ID 705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7135:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 705,
        GIR_Done,
      // Label 425: @13354
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(13402), // Rule ID 706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7138:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 706,
        GIR_Done,
      // Label 426: @13402
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(13450), // Rule ID 707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7137:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 707,
        GIR_Done,
      // Label 427: @13450
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(13498), // Rule ID 712 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7144:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FFQL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 712,
        GIR_Done,
      // Label 428: @13498
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(13546), // Rule ID 713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7143:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FFQL_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 713,
        GIR_Done,
      // Label 429: @13546
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(13594), // Rule ID 714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7146:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FFQR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 714,
        GIR_Done,
      // Label 430: @13594
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(13642), // Rule ID 715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7145:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FFQR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 715,
        GIR_Done,
      // Label 431: @13642
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(13690), // Rule ID 740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7168:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FRCP_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 740,
        GIR_Done,
      // Label 432: @13690
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(13738), // Rule ID 741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7167:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FRCP_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 741,
        GIR_Done,
      // Label 433: @13738
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(13786), // Rule ID 742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7172:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 742,
        GIR_Done,
      // Label 434: @13786
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(13834), // Rule ID 743 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7171:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 743,
        GIR_Done,
      // Label 435: @13834
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(13882), // Rule ID 770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7200:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 770,
        GIR_Done,
      // Label 436: @13882
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(13930), // Rule ID 771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7199:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 771,
        GIR_Done,
      // Label 437: @13930
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(13978), // Rule ID 772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7202:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 772,
        GIR_Done,
      // Label 438: @13978
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(14026), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7201:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 773,
        GIR_Done,
      // Label 439: @14026
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(14074), // Rule ID 908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7357:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NLOC_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 908,
        GIR_Done,
      // Label 440: @14074
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(14122), // Rule ID 909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7359:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NLOC_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 909,
        GIR_Done,
      // Label 441: @14122
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(14170), // Rule ID 910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7360:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NLOC_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 910,
        GIR_Done,
      // Label 442: @14170
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(14218), // Rule ID 911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7358:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::NLOC_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 911,
        GIR_Done,
      // Label 443: @14218
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(14266), // Rule ID 1251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7384:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1251,
        GIR_Done,
      // Label 444: @14266
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(14314), // Rule ID 1252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7385:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1252,
        GIR_Done,
      // Label 445: @14314
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(14362), // Rule ID 1253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7386:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1253,
        GIR_Done,
      // Label 446: @14362
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(14410), // Rule ID 1254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7387:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1254,
        GIR_Done,
      // Label 447: @14410
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(14458), // Rule ID 1255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7388:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1255,
        GIR_Done,
      // Label 448: @14458
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(14506), // Rule ID 1256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7389:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1256,
        GIR_Done,
      // Label 449: @14506
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(14554), // Rule ID 1257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7390:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1257,
        GIR_Done,
      // Label 450: @14554
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(14602), // Rule ID 1258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7391:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1258,
        GIR_Done,
      // Label 451: @14602
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(14650), // Rule ID 1259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7392:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1259,
        GIR_Done,
      // Label 452: @14650
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(14698), // Rule ID 1260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7393:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1260,
        GIR_Done,
      // Label 453: @14698
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(14746), // Rule ID 1286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7402:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1286,
        GIR_Done,
      // Label 454: @14746
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(14794), // Rule ID 1290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7404:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1290,
        GIR_Done,
      // Label 455: @14794
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(14842), // Rule ID 1291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7405:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1291,
        GIR_Done,
      // Label 456: @14842
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(14890), // Rule ID 1301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6958:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BITREV_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1301,
        GIR_Done,
      // Label 457: @14890
      GIM_Reject,
    // Label 403: @14891
    GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(27994),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(14959), // Rule ID 938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7406:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 938,
        GIR_Done,
      // Label 459: @14959
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(15019), // Rule ID 939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7408:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 939,
        GIR_Done,
      // Label 460: @15019
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(15079), // Rule ID 940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7409:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 940,
        GIR_Done,
      // Label 461: @15079
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(15139), // Rule ID 941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7407:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 462: @15139
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(15199), // Rule ID 942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7410:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 463: @15199
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(15259), // Rule ID 943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7412:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 464: @15259
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(15319), // Rule ID 944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7413:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 465: @15319
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(15379), // Rule ID 945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7411:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SAT_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 466: @15379
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(15439), // Rule ID 985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7465:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRARI_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 985,
        GIR_Done,
      // Label 467: @15439
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(15499), // Rule ID 986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7467:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRARI_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 986,
        GIR_Done,
      // Label 468: @15499
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(15559), // Rule ID 987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7468:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRARI_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 987,
        GIR_Done,
      // Label 469: @15559
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(15619), // Rule ID 988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7466:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRARI_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 988,
        GIR_Done,
      // Label 470: @15619
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(15679), // Rule ID 1001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7481:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLRI_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1001,
        GIR_Done,
      // Label 471: @15679
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(15739), // Rule ID 1002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7483:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLRI_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1002,
        GIR_Done,
      // Label 472: @15739
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(15799), // Rule ID 1003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7484:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLRI_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1003,
        GIR_Done,
      // Label 473: @15799
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(15859), // Rule ID 1004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] m
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7482:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLRI_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // m
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1004,
        GIR_Done,
      // Label 474: @15859
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(15928), // Rule ID 385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7424:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 385,
        GIR_Done,
      // Label 475: @15928
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(15997), // Rule ID 389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7426:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 389,
        GIR_Done,
      // Label 476: @15997
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(16066), // Rule ID 480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7425:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 480,
        GIR_Done,
      // Label 477: @16066
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(16135), // Rule ID 1245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7424:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1245,
        GIR_Done,
      // Label 478: @16135
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(16204), // Rule ID 1249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 7426:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1249,
        GIR_Done,
      // Label 479: @16204
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(16273), // Rule ID 1324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7425:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1324,
        GIR_Done,
      // Label 480: @16273
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(16337), // Rule ID 1911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7422:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1911,
        GIR_Done,
      // Label 481: @16337
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(16401), // Rule ID 1912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v2i16] } 7427:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRL_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1912,
        GIR_Done,
      // Label 482: @16401
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(16465), // Rule ID 1917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7423:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRA_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1917,
        GIR_Done,
      // Label 483: @16465
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(16529), // Rule ID 1918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[v4i8] } 7428:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRL_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1918,
        GIR_Done,
      // Label 484: @16529
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(16593), // Rule ID 355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6894:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 355,
        GIR_Done,
      // Label 485: @16593
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(16657), // Rule ID 356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7517:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 356,
        GIR_Done,
      // Label 486: @16657
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(16721), // Rule ID 357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6872:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 357,
        GIR_Done,
      // Label 487: @16721
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(16785), // Rule ID 358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7492:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 358,
        GIR_Done,
      // Label 488: @16785
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(16846), // Rule ID 361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7322:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODSUB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 361,
        GIR_Done,
      // Label 489: @16846
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(16907), // Rule ID 365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7398:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 365,
        GIR_Done,
      // Label 490: @16907
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(16968), // Rule ID 366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7397:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 366,
        GIR_Done,
      // Label 491: @16968
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(17029), // Rule ID 380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7428:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 380,
        GIR_Done,
      // Label 492: @17029
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(17090), // Rule ID 384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7422:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 384,
        GIR_Done,
      // Label 493: @17090
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(17151), // Rule ID 386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7424:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 386,
        GIR_Done,
      // Label 494: @17151
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(17212), // Rule ID 390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7426:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 390,
        GIR_Done,
      // Label 495: @17212
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(17273), // Rule ID 427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7369:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 427,
        GIR_Done,
      // Label 496: @17273
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(17334), // Rule ID 451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6895:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 451,
        GIR_Done,
      // Label 497: @17334
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(17395), // Rule ID 452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6896:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 452,
        GIR_Done,
      // Label 498: @17395
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(17456), // Rule ID 453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7518:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 453,
        GIR_Done,
      // Label 499: @17456
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(17517), // Rule ID 454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7519:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 454,
        GIR_Done,
      // Label 500: @17517
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(17578), // Rule ID 455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6874:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 455,
        GIR_Done,
      // Label 501: @17578
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(17639), // Rule ID 456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6875:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 456,
        GIR_Done,
      // Label 502: @17639
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(17700), // Rule ID 457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7494:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 457,
        GIR_Done,
      // Label 503: @17700
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(17761), // Rule ID 458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7495:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 458,
        GIR_Done,
      // Label 504: @17761
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(17822), // Rule ID 459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6877:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 459,
        GIR_Done,
      // Label 505: @17822
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(17883), // Rule ID 460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6876:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 460,
        GIR_Done,
      // Label 506: @17883
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(17944), // Rule ID 461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7497:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 461,
        GIR_Done,
      // Label 507: @17944
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(18005), // Rule ID 462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7496:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 462,
        GIR_Done,
      // Label 508: @18005
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(18066), // Rule ID 479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7423:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 479,
        GIR_Done,
      // Label 509: @18066
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(18127), // Rule ID 481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7425:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 481,
        GIR_Done,
      // Label 510: @18127
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(18188), // Rule ID 482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7427:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 482,
        GIR_Done,
      // Label 511: @18188
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(18249), // Rule ID 491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6867:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADD_A_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 491,
        GIR_Done,
      // Label 512: @18249
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(18310), // Rule ID 492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6869:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADD_A_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 492,
        GIR_Done,
      // Label 513: @18310
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(18371), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6870:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADD_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 493,
        GIR_Done,
      // Label 514: @18371
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(18432), // Rule ID 494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6868:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADD_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 494,
        GIR_Done,
      // Label 515: @18432
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(18493), // Rule ID 495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6878:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 495,
        GIR_Done,
      // Label 516: @18493
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(18554), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6880:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 496,
        GIR_Done,
      // Label 517: @18554
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(18615), // Rule ID 497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6881:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 497,
        GIR_Done,
      // Label 518: @18615
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(18676), // Rule ID 498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6879:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 498,
        GIR_Done,
      // Label 519: @18676
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(18737), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6882:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 499,
        GIR_Done,
      // Label 520: @18737
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(18798), // Rule ID 500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6884:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 500,
        GIR_Done,
      // Label 521: @18798
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(18859), // Rule ID 501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6885:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 501,
        GIR_Done,
      // Label 522: @18859
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(18920), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6883:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 502,
        GIR_Done,
      // Label 523: @18920
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(18981), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6886:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 503,
        GIR_Done,
      // Label 524: @18981
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(19042), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6888:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 504,
        GIR_Done,
      // Label 525: @19042
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(19103), // Rule ID 505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6889:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 505,
        GIR_Done,
      // Label 526: @19103
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(19164), // Rule ID 506 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6887:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 506,
        GIR_Done,
      // Label 527: @19164
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(19225), // Rule ID 520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6909:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 520,
        GIR_Done,
      // Label 528: @19225
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(19286), // Rule ID 521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6911:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 521,
        GIR_Done,
      // Label 529: @19286
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(19347), // Rule ID 522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6912:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 522,
        GIR_Done,
      // Label 530: @19347
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(19408), // Rule ID 523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6910:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 523,
        GIR_Done,
      // Label 531: @19408
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(19469), // Rule ID 524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6913:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 524,
        GIR_Done,
      // Label 532: @19469
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(19530), // Rule ID 525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6915:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 525,
        GIR_Done,
      // Label 533: @19530
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(19591), // Rule ID 526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6916:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 526,
        GIR_Done,
      // Label 534: @19591
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(19652), // Rule ID 527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6914:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 527,
        GIR_Done,
      // Label 535: @19652
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(19713), // Rule ID 528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6917:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 528,
        GIR_Done,
      // Label 536: @19713
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(19774), // Rule ID 529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6919:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 529,
        GIR_Done,
      // Label 537: @19774
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(19835), // Rule ID 530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6920:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 530,
        GIR_Done,
      // Label 538: @19835
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(19896), // Rule ID 531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6918:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 531,
        GIR_Done,
      // Label 539: @19896
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(19957), // Rule ID 532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6921:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 532,
        GIR_Done,
      // Label 540: @19957
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(20018), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6923:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 533,
        GIR_Done,
      // Label 541: @20018
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(20079), // Rule ID 534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6924:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 534,
        GIR_Done,
      // Label 542: @20079
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(20140), // Rule ID 535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6922:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVE_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 535,
        GIR_Done,
      // Label 543: @20140
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(20201), // Rule ID 536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6925:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 536,
        GIR_Done,
      // Label 544: @20201
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(20262), // Rule ID 537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6927:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 537,
        GIR_Done,
      // Label 545: @20262
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(20323), // Rule ID 538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6928:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 538,
        GIR_Done,
      // Label 546: @20323
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(20384), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6926:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 539,
        GIR_Done,
      // Label 547: @20384
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(20445), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6929:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 540,
        GIR_Done,
      // Label 548: @20445
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(20506), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6931:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 541,
        GIR_Done,
      // Label 549: @20506
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(20567), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6932:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 542,
        GIR_Done,
      // Label 550: @20567
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(20628), // Rule ID 543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6930:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AVER_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 543,
        GIR_Done,
      // Label 551: @20628
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(20689), // Rule ID 652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7064:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 652,
        GIR_Done,
      // Label 552: @20689
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(20750), // Rule ID 653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7065:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 653,
        GIR_Done,
      // Label 553: @20750
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(20811), // Rule ID 654 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7063:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 654,
        GIR_Done,
      // Label 554: @20811
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(20872), // Rule ID 655 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7067:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 655,
        GIR_Done,
      // Label 555: @20872
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(20933), // Rule ID 656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7068:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 656,
        GIR_Done,
      // Label 556: @20933
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(20994), // Rule ID 657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7066:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 657,
        GIR_Done,
      // Label 557: @20994
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(21055), // Rule ID 672 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7106:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FCAF_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 672,
        GIR_Done,
      // Label 558: @21055
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(21116), // Rule ID 673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7105:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FCAF_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 673,
        GIR_Done,
      // Label 559: @21116
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(21177), // Rule ID 698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 7131:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXDO_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 698,
        GIR_Done,
      // Label 560: @21177
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(21238), // Rule ID 699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7132:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FEXDO_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 699,
        GIR_Done,
      // Label 561: @21238
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(21299), // Rule ID 726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7158:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMAX_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 726,
        GIR_Done,
      // Label 562: @21299
      GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(21360), // Rule ID 727 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7157:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMAX_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 727,
        GIR_Done,
      // Label 563: @21360
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(21421), // Rule ID 728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7156:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 728,
        GIR_Done,
      // Label 564: @21421
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(21482), // Rule ID 729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7155:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 729,
        GIR_Done,
      // Label 565: @21482
      GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(21543), // Rule ID 730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7162:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMIN_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 730,
        GIR_Done,
      // Label 566: @21543
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(21604), // Rule ID 731 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7161:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMIN_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 731,
        GIR_Done,
      // Label 567: @21604
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(21665), // Rule ID 732 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 7160:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 732,
        GIR_Done,
      // Label 568: @21665
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(21726), // Rule ID 733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 7159:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 733,
        GIR_Done,
      // Label 569: @21726
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(21787), // Rule ID 744 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7174:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSAF_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 744,
        GIR_Done,
      // Label 570: @21787
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(21848), // Rule ID 745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7173:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSAF_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 745,
        GIR_Done,
      // Label 571: @21848
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(21909), // Rule ID 746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7176:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSEQ_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 746,
        GIR_Done,
      // Label 572: @21909
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(21970), // Rule ID 747 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7175:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSEQ_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 747,
        GIR_Done,
      // Label 573: @21970
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(22031), // Rule ID 748 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7178:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSLE_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 748,
        GIR_Done,
      // Label 574: @22031
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(22092), // Rule ID 749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7177:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSLE_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 749,
        GIR_Done,
      // Label 575: @22092
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(22153), // Rule ID 750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7180:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSLT_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 750,
        GIR_Done,
      // Label 576: @22153
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(22214), // Rule ID 751 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7179:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSLT_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 751,
        GIR_Done,
      // Label 577: @22214
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(22275), // Rule ID 752 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7182:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSNE_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 752,
        GIR_Done,
      // Label 578: @22275
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(22336), // Rule ID 753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7181:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSNE_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 753,
        GIR_Done,
      // Label 579: @22336
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(22397), // Rule ID 754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7184:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSOR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 754,
        GIR_Done,
      // Label 580: @22397
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(22458), // Rule ID 755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7183:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSOR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 755,
        GIR_Done,
      // Label 581: @22458
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(22519), // Rule ID 760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7190:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 760,
        GIR_Done,
      // Label 582: @22519
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(22580), // Rule ID 761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7189:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 761,
        GIR_Done,
      // Label 583: @22580
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(22641), // Rule ID 762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7192:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSULE_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 762,
        GIR_Done,
      // Label 584: @22641
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(22702), // Rule ID 763 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7191:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSULE_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 763,
        GIR_Done,
      // Label 585: @22702
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(22763), // Rule ID 764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7194:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSULT_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 764,
        GIR_Done,
      // Label 586: @22763
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(22824), // Rule ID 765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7193:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSULT_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 765,
        GIR_Done,
      // Label 587: @22824
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(22885), // Rule ID 766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7196:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUN_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 766,
        GIR_Done,
      // Label 588: @22885
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(22946), // Rule ID 767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7195:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUN_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 767,
        GIR_Done,
      // Label 589: @22946
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(23007), // Rule ID 768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7198:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUNE_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 768,
        GIR_Done,
      // Label 590: @23007
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(23068), // Rule ID 769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7197:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FSUNE_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 769,
        GIR_Done,
      // Label 591: @23068
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(23129), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7203:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTQ_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 774,
        GIR_Done,
      // Label 592: @23129
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(23190), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7204:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::FTQ_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 775,
        GIR_Done,
      // Label 593: @23190
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(23251), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7210:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 780,
        GIR_Done,
      // Label 594: @23251
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(23312), // Rule ID 781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7211:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 781,
        GIR_Done,
      // Label 595: @23312
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(23373), // Rule ID 782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7209:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 782,
        GIR_Done,
      // Label 596: @23373
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(23434), // Rule ID 783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7213:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 783,
        GIR_Done,
      // Label 597: @23434
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(23495), // Rule ID 784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7214:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 784,
        GIR_Done,
      // Label 598: @23495
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(23556), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7212:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HADD_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 785,
        GIR_Done,
      // Label 599: @23556
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(23617), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7216:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 786,
        GIR_Done,
      // Label 600: @23617
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(23678), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7217:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 787,
        GIR_Done,
      // Label 601: @23678
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(23739), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7215:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 788,
        GIR_Done,
      // Label 602: @23739
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(23800), // Rule ID 789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7219:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 789,
        GIR_Done,
      // Label 603: @23800
      GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(23861), // Rule ID 790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7220:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 790,
        GIR_Done,
      // Label 604: @23861
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(23922), // Rule ID 791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7218:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 791,
        GIR_Done,
      // Label 605: @23922
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(23983), // Rule ID 844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7274:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MAX_A_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 844,
        GIR_Done,
      // Label 606: @23983
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(24044), // Rule ID 845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7276:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MAX_A_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 845,
        GIR_Done,
      // Label 607: @24044
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(24105), // Rule ID 846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7277:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MAX_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 846,
        GIR_Done,
      // Label 608: @24105
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(24166), // Rule ID 847 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7275:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MAX_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 847,
        GIR_Done,
      // Label 609: @24166
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(24227), // Rule ID 864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7294:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MIN_A_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 864,
        GIR_Done,
      // Label 610: @24227
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(24288), // Rule ID 865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7296:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MIN_A_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 865,
        GIR_Done,
      // Label 611: @24288
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(24349), // Rule ID 866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7297:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MIN_A_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 866,
        GIR_Done,
      // Label 612: @24349
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(24410), // Rule ID 867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7295:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MIN_A_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 867,
        GIR_Done,
      // Label 613: @24410
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(24471), // Rule ID 900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7336:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 900,
        GIR_Done,
      // Label 614: @24471
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(24532), // Rule ID 901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7337:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 901,
        GIR_Done,
      // Label 615: @24532
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(24593), // Rule ID 902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7347:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 902,
        GIR_Done,
      // Label 616: @24593
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(24654), // Rule ID 903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7348:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 903,
        GIR_Done,
      // Label 617: @24654
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(24715), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7461:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRAR_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 981,
        GIR_Done,
      // Label 618: @24715
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(24776), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7463:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRAR_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 982,
        GIR_Done,
      // Label 619: @24776
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(24837), // Rule ID 983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7464:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRAR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 983,
        GIR_Done,
      // Label 620: @24837
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(24898), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7462:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRAR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 984,
        GIR_Done,
      // Label 621: @24898
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(24959), // Rule ID 997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7477:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLR_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 997,
        GIR_Done,
      // Label 622: @24959
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(25020), // Rule ID 998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7479:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLR_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 998,
        GIR_Done,
      // Label 623: @25020
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(25081), // Rule ID 999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7480:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 999,
        GIR_Done,
      // Label 624: @25081
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(25142), // Rule ID 1000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7478:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1000,
        GIR_Done,
      // Label 625: @25142
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(25203), // Rule ID 1009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7498:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1009,
        GIR_Done,
      // Label 626: @25203
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(25264), // Rule ID 1010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7500:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1010,
        GIR_Done,
      // Label 627: @25264
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(25325), // Rule ID 1011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7501:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1011,
        GIR_Done,
      // Label 628: @25325
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(25386), // Rule ID 1012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7499:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1012,
        GIR_Done,
      // Label 629: @25386
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(25447), // Rule ID 1013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7502:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1013,
        GIR_Done,
      // Label 630: @25447
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(25508), // Rule ID 1014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7504:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1014,
        GIR_Done,
      // Label 631: @25508
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(25569), // Rule ID 1015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7505:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1015,
        GIR_Done,
      // Label 632: @25569
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(25630), // Rule ID 1016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7503:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1016,
        GIR_Done,
      // Label 633: @25630
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(25691), // Rule ID 1017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7506:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1017,
        GIR_Done,
      // Label 634: @25691
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(25752), // Rule ID 1018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7508:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1018,
        GIR_Done,
      // Label 635: @25752
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(25813), // Rule ID 1019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7509:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1019,
        GIR_Done,
      // Label 636: @25813
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(25874), // Rule ID 1020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7507:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1020,
        GIR_Done,
      // Label 637: @25874
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(25935), // Rule ID 1021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7510:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1021,
        GIR_Done,
      // Label 638: @25935
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(25996), // Rule ID 1022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7512:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1022,
        GIR_Done,
      // Label 639: @25996
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(26057), // Rule ID 1023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7513:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1023,
        GIR_Done,
      // Label 640: @26057
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(26118), // Rule ID 1024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7511:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1024,
        GIR_Done,
      // Label 641: @26118
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(26182), // Rule ID 1223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6872:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1223,
        GIR_Done,
      // Label 642: @26182
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(26246), // Rule ID 1225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6894:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1225,
        GIR_Done,
      // Label 643: @26246
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(26307), // Rule ID 1246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7422:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1246,
        GIR_Done,
      // Label 644: @26307
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(26368), // Rule ID 1247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7424:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1247,
        GIR_Done,
      // Label 645: @26368
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(26429), // Rule ID 1248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7426:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1248,
        GIR_Done,
      // Label 646: @26429
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(26490), // Rule ID 1250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7428:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1250,
        GIR_Done,
      // Label 647: @26490
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(26554), // Rule ID 1261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7492:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1261,
        GIR_Done,
      // Label 648: @26554
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(26618), // Rule ID 1263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7517:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1263,
        GIR_Done,
      // Label 649: @26618
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(26679), // Rule ID 1273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7397:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1273,
        GIR_Done,
      // Label 650: @26679
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(26740), // Rule ID 1274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7398:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1274,
        GIR_Done,
      // Label 651: @26740
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(26801), // Rule ID 1293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7369:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1293,
        GIR_Done,
      // Label 652: @26801
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(26862), // Rule ID 1299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7322:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODSUB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1299,
        GIR_Done,
      // Label 653: @26862
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(26923), // Rule ID 1312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6874:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1312,
        GIR_Done,
      // Label 654: @26923
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(26984), // Rule ID 1313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6875:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 655: @26984
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(27045), // Rule ID 1314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6877:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 656: @27045
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(27106), // Rule ID 1315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 6876:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 657: @27106
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(27167), // Rule ID 1318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6895:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1318,
        GIR_Done,
      // Label 658: @27167
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(27228), // Rule ID 1319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6896:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1319,
        GIR_Done,
      // Label 659: @27228
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(27289), // Rule ID 1325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7423:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1325,
        GIR_Done,
      // Label 660: @27289
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(27350), // Rule ID 1326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7425:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1326,
        GIR_Done,
      // Label 661: @27350
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(27411), // Rule ID 1331 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7427:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1331,
        GIR_Done,
      // Label 662: @27411
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(27472), // Rule ID 1332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7494:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1332,
        GIR_Done,
      // Label 663: @27472
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(27533), // Rule ID 1333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7495:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1333,
        GIR_Done,
      // Label 664: @27533
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(27594), // Rule ID 1334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7497:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1334,
        GIR_Done,
      // Label 665: @27594
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(27655), // Rule ID 1335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 7496:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1335,
        GIR_Done,
      // Label 666: @27655
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(27716), // Rule ID 1338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7518:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1338,
        GIR_Done,
      // Label 667: @27716
      GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(27777), // Rule ID 1339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7519:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1339,
        GIR_Done,
      // Label 668: @27777
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(27831), // Rule ID 1893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 6871:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1893,
        GIR_Done,
      // Label 669: @27831
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(27885), // Rule ID 1895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7491:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1895,
        GIR_Done,
      // Label 670: @27885
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(27939), // Rule ID 1899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 6892:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1899,
        GIR_Done,
      // Label 671: @27939
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(27993), // Rule ID 1901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i8] } 7515:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1901,
        GIR_Done,
      // Label 672: @27993
      GIM_Reject,
    // Label 458: @27994
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(31398),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(28075), // Rule ID 477 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7395:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 477,
        GIR_Done,
      // Label 674: @28075
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(28148), // Rule ID 478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7396:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 478,
        GIR_Done,
      // Label 675: @28148
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(28221), // Rule ID 483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 6908:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::APPEND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 483,
        GIR_Done,
      // Label 676: @28221
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(28294), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[i32] } 6933:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BALIGN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 484,
        GIR_Done,
      // Label 677: @28294
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(28367), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7401:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PREPEND),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 485,
        GIR_Done,
      // Label 678: @28367
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(28440), // Rule ID 953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7433:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLDI_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 953,
        GIR_Done,
      // Label 679: @28440
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(28513), // Rule ID 954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7435:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLDI_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 954,
        GIR_Done,
      // Label 680: @28513
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(28586), // Rule ID 955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7436:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLDI_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 955,
        GIR_Done,
      // Label 681: @28586
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(28659), // Rule ID 956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // MIs[0] n
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt1),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7434:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$n)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLDI_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // n
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 956,
        GIR_Done,
      // Label 682: @28659
      GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(28732), // Rule ID 1349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7395:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1349,
        GIR_Done,
      // Label 683: @28732
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(28805), // Rule ID 1350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[v2i16] } 7396:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1350,
        GIR_Done,
      // Label 684: @28805
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(28878), // Rule ID 1351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 7401:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PREPEND_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1351,
        GIR_Done,
      // Label 685: @28878
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(28951), // Rule ID 1352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] sa
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
        // (intrinsic_wo_chain:{ *:[i32] } 6908:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::APPEND_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // sa
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1352,
        GIR_Done,
      // Label 686: @28951
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(29029), // Rule ID 1327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] bp
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_wo_chain:{ *:[i32] } 6933:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BALIGN_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1327,
        GIR_Done,
      // Label 687: @29029
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(29103), // Rule ID 552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6942:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSL_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 552,
        GIR_Done,
      // Label 688: @29103
      GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(29177), // Rule ID 553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6944:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSL_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 553,
        GIR_Done,
      // Label 689: @29177
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(29251), // Rule ID 554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6945:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 554,
        GIR_Done,
      // Label 690: @29251
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(29325), // Rule ID 555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6943:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSL_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 555,
        GIR_Done,
      // Label 691: @29325
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(29399), // Rule ID 560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 6950:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSR_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 560,
        GIR_Done,
      // Label 692: @29399
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(29473), // Rule ID 561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 6952:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSR_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 561,
        GIR_Done,
      // Label 693: @29473
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(29547), // Rule ID 562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 6953:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSR_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 562,
        GIR_Done,
      // Label 694: @29547
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(29621), // Rule ID 563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 6951:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BINSR_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 563,
        GIR_Done,
      // Label 695: @29621
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(29695), // Rule ID 658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7071:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 658,
        GIR_Done,
      // Label 696: @29695
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(29769), // Rule ID 659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7072:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 659,
        GIR_Done,
      // Label 697: @29769
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(29843), // Rule ID 660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7070:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 660,
        GIR_Done,
      // Label 698: @29843
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(29917), // Rule ID 661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7074:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 661,
        GIR_Done,
      // Label 699: @29917
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(29991), // Rule ID 662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7075:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 662,
        GIR_Done,
      // Label 700: @29991
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(30065), // Rule ID 663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7073:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 663,
        GIR_Done,
      // Label 701: @30065
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(30139), // Rule ID 664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7091:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 664,
        GIR_Done,
      // Label 702: @30139
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(30213), // Rule ID 665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7092:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 665,
        GIR_Done,
      // Label 703: @30213
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(30287), // Rule ID 666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7090:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 666,
        GIR_Done,
      // Label 704: @30287
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(30361), // Rule ID 667 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7094:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 667,
        GIR_Done,
      // Label 705: @30361
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(30435), // Rule ID 668 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7095:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 668,
        GIR_Done,
      // Label 706: @30435
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(30509), // Rule ID 669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7093:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 669,
        GIR_Done,
      // Label 707: @30509
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(30583), // Rule ID 836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7261:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 836,
        GIR_Done,
      // Label 708: @30583
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(30657), // Rule ID 837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7262:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 837,
        GIR_Done,
      // Label 709: @30657
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(30731), // Rule ID 838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7263:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 838,
        GIR_Done,
      // Label 710: @30731
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(30805), // Rule ID 839 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7264:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 839,
        GIR_Done,
      // Label 711: @30805
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(30879), // Rule ID 892 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7325:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 892,
        GIR_Done,
      // Label 712: @30879
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(30953), // Rule ID 893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7326:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 893,
        GIR_Done,
      // Label 713: @30953
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(31027), // Rule ID 894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7327:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUBR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 894,
        GIR_Done,
      // Label 714: @31027
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(31101), // Rule ID 895 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msubr_q_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7328:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUBR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MSUBR_Q_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 895,
        GIR_Done,
      // Label 715: @31101
      GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(31175), // Rule ID 949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_b),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 7429:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLD_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 949,
        GIR_Done,
      // Label 716: @31175
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(31249), // Rule ID 950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_h),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 7431:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLD_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 950,
        GIR_Done,
      // Label 717: @31249
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(31323), // Rule ID 951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 7432:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLD_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 951,
        GIR_Done,
      // Label 718: @31323
      GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(31397), // Rule ID 952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sld_d),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/0, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/4, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 7430:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SLD_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLD_D),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // wd_in
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/4, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 952,
        GIR_Done,
      // Label 719: @31397
      GIM_Reject,
    // Label 673: @31398
    GIM_Reject,
    // Label 17: @31399
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(31438), // Rule ID 354 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bposge32),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (intrinsic_w_chain:{ *:[i32] } 6976:{ *:[iPTR] })  =>  (BPOSGE32_PSEUDO:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BPOSGE32_PSEUDO),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 354,
      GIR_Done,
    // Label 720: @31438
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(32631),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(31497), // Rule ID 441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_w_chain:{ *:[i32] } 7403:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (RDDSP:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::RDDSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 441,
        GIR_Done,
      // Label 722: @31497
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(31543), // Rule ID 1287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_rddsp),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_w_chain:{ *:[i32] } 7403:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (RDDSP_MM:{ *:[i32] } (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::RDDSP_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1287,
        GIR_Done,
      // Label 723: @31543
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(31594), // Rule ID 442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_NotInMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt10),
        // (intrinsic_void 7532:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt10>>:$mask)  =>  (WRDSP GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::WRDSP),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 442,
        GIR_Done,
      // Label 724: @31594
      GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(31640), // Rule ID 1298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_wrdsp),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // MIs[0] mask
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 7532:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] })<<P:Predicate_timmZExt7>>:$mask)  =>  (WRDSP_MM GPR32Opnd:{ *:[i32] }:$rt, (timm:{ *:[i32] }):$mask)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::WRDSP_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1298,
        GIR_Done,
      // Label 725: @31640
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(31695), // Rule ID 363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6864:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ABSQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 363,
        GIR_Done,
      // Label 726: @31695
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(31750), // Rule ID 364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6866:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ABSQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 364,
        GIR_Done,
      // Label 727: @31750
      GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(31805), // Rule ID 450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 6865:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ABSQ_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 450,
        GIR_Done,
      // Label 728: @31805
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(31860), // Rule ID 1230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6864:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (ABSQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1230,
        GIR_Done,
      // Label 729: @31860
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(31915), // Rule ID 1231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6866:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (ABSQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1231,
        GIR_Done,
      // Label 730: @31915
      GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(31970), // Rule ID 1311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_absq_s_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 6865:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (ABSQ_S_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ABSQ_S_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1311,
        GIR_Done,
      // Label 731: @31970
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(32025), // Rule ID 417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7042:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 417,
        GIR_Done,
      // Label 732: @32025
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(32080), // Rule ID 418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7044:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 418,
        GIR_Done,
      // Label 733: @32080
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(32135), // Rule ID 419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7043:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 419,
        GIR_Done,
      // Label 734: @32135
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(32190), // Rule ID 423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7033:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 423,
        GIR_Done,
      // Label 735: @32190
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(32245), // Rule ID 424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7035:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 424,
        GIR_Done,
      // Label 736: @32245
      GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(32300), // Rule ID 425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7034:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 425,
        GIR_Done,
      // Label 737: @32300
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(32355), // Rule ID 1302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_eq_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7033:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_EQ_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_EQ_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1302,
        GIR_Done,
      // Label 738: @32355
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(32410), // Rule ID 1303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_lt_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7035:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LT_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_LT_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1303,
        GIR_Done,
      // Label 739: @32410
      GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(32465), // Rule ID 1304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmp_le_ph),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7034:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (CMP_LE_PH_MM DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMP_LE_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1304,
        GIR_Done,
      // Label 740: @32465
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(32520), // Rule ID 1308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7042:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_EQ_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_EQ_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1308,
        GIR_Done,
      // Label 741: @32520
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(32575), // Rule ID 1309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7044:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LT_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_LT_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1309,
        GIR_Done,
      // Label 742: @32575
      GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(32630), // Rule ID 1310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::mips_cmpu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_void 7043:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPU_LE_QB_MM DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPU_LE_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1310,
        GIR_Done,
      // Label 743: @32630
      GIM_Reject,
    // Label 721: @32631
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(37430),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(32716), // Rule ID 382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7420:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHLL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 382,
        GIR_Done,
      // Label 745: @32716
      GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(32793), // Rule ID 387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 7421:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHLL_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 387,
        GIR_Done,
      // Label 746: @32793
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(32870), // Rule ID 1239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7420:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHLL_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1239,
        GIR_Done,
      // Label 747: @32870
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(32947), // Rule ID 1244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[i32] } 7421:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHLL_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_S_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1244,
        GIR_Done,
      // Label 748: @32947
      GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(33014), // Rule ID 1910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v2i16] } 7418:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHLL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1910,
        GIR_Done,
      // Label 749: @33014
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(33081), // Rule ID 1916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (intrinsic_w_chain:{ *:[v4i8] } 7419:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHLL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLL_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1916,
        GIR_Done,
      // Label 750: @33081
      GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(33149), // Rule ID 359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6873:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 359,
        GIR_Done,
      // Label 751: @33149
      GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(33217), // Rule ID 360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7493:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 360,
        GIR_Done,
      // Label 752: @33217
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(33285), // Rule ID 367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7399:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 367,
        GIR_Done,
      // Label 753: @33285
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(33353), // Rule ID 368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7400:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 368,
        GIR_Done,
      // Label 754: @33353
      GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(33421), // Rule ID 379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7419:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 379,
        GIR_Done,
      // Label 755: @33421
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(33489), // Rule ID 381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7418:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 381,
        GIR_Done,
      // Label 756: @33489
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(33557), // Rule ID 383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7420:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 383,
        GIR_Done,
      // Label 757: @33557
      GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(33625), // Rule ID 388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7421:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHLLV_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs_sa
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 388,
        GIR_Done,
      // Label 758: @33625
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(33693), // Rule ID 391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7341:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 391,
        GIR_Done,
      // Label 759: @33693
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(33761), // Rule ID 392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7342:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 392,
        GIR_Done,
      // Label 760: @33761
      GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(33829), // Rule ID 393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7339:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 393,
        GIR_Done,
      // Label 761: @33829
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(33897), // Rule ID 394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7340:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 394,
        GIR_Done,
      // Label 762: @33897
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(33965), // Rule ID 395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7343:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 395,
        GIR_Done,
      // Label 763: @33965
      GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(34030), // Rule ID 420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7039:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 420,
        GIR_Done,
      // Label 764: @34030
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(34095), // Rule ID 421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7041:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 421,
        GIR_Done,
      // Label 765: @34095
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(34160), // Rule ID 422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7040:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 422,
        GIR_Done,
      // Label 766: @34160
      GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(34225), // Rule ID 432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7383:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PICK_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 432,
        GIR_Done,
      // Label 767: @34225
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(34290), // Rule ID 433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7382:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PICK_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 433,
        GIR_Done,
      // Label 768: @34290
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(34355), // Rule ID 437 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7241:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::INSV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 437,
        GIR_Done,
      // Label 769: @34355
      GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(34423), // Rule ID 443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6891:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 443,
        GIR_Done,
      // Label 770: @34423
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(34491), // Rule ID 444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6893:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 444,
        GIR_Done,
      // Label 771: @34491
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(34559), // Rule ID 445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7514:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 445,
        GIR_Done,
      // Label 772: @34559
      GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(34627), // Rule ID 446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7516:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 446,
        GIR_Done,
      // Label 773: @34627
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(34695), // Rule ID 447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7036:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 447,
        GIR_Done,
      // Label 774: @34695
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(34763), // Rule ID 448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7038:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 448,
        GIR_Done,
      // Label 775: @34763
      GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(34831), // Rule ID 449 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7037:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 449,
        GIR_Done,
      // Label 776: @34831
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(34899), // Rule ID 463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7338:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 463,
        GIR_Done,
      // Label 777: @34899
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(34967), // Rule ID 464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7346:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 464,
        GIR_Done,
      // Label 778: @34967
      GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(35035), // Rule ID 465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7344:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 465,
        GIR_Done,
      // Label 779: @35035
      GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(35103), // Rule ID 466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7345:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 466,
        GIR_Done,
      // Label 780: @35103
      GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(35168), // Rule ID 476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7394:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 476,
        GIR_Done,
      // Label 781: @35168
      GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(35236), // Rule ID 1224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6873:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1224,
        GIR_Done,
      // Label 782: @35236
      GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(35301), // Rule ID 1232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_insv),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7241:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)  =>  (INSV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::INSV_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1232,
        GIR_Done,
      // Label 783: @35301
      GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(35369), // Rule ID 1240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7418:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1240,
        GIR_Done,
      // Label 784: @35369
      GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(35437), // Rule ID 1241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7420:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1241,
        GIR_Done,
      // Label 785: @35437
      GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(35505), // Rule ID 1242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7419:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1242,
        GIR_Done,
      // Label 786: @35505
      GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(35573), // Rule ID 1243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shll_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7421:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHLLV_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SHLLV_S_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rt
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rs
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1243,
        GIR_Done,
      // Label 787: @35573
      GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(35641), // Rule ID 1262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7493:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQ_S_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1262,
        GIR_Done,
      // Label 788: @35641
      GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(35709), // Rule ID 1268 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7339:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1268,
        GIR_Done,
      // Label 789: @35709
      GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(35777), // Rule ID 1269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleq_s_w_phr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7340:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEQ_S_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEQ_S_W_PHR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1269,
        GIR_Done,
      // Label 790: @35777
      GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(35845), // Rule ID 1270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbl),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7341:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1270,
        GIR_Done,
      // Label 791: @35845
      GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(35913), // Rule ID 1271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_muleu_s_ph_qbr),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7342:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULEU_S_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULEU_S_PH_QBR_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1271,
        GIR_Done,
      // Label 792: @35913
      GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(35981), // Rule ID 1272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7343:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_RS_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1272,
        GIR_Done,
      // Label 793: @35981
      GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(36049), // Rule ID 1275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrqu_s_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7400:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQU_S_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQU_S_QB_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1275,
        GIR_Done,
      // Label 794: @36049
      GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(36117), // Rule ID 1276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_rs_ph_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7399:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_RS_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_RS_PH_W_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag22*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1276,
        GIR_Done,
      // Label 795: @36117
      GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(36182), // Rule ID 1294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7382:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PICK_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PICK_PH_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1294,
        GIR_Done,
      // Label 796: @36182
      GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(36247), // Rule ID 1295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_pick_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7383:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PICK_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PICK_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1295,
        GIR_Done,
      // Label 797: @36247
      GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(36312), // Rule ID 1305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7039:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_EQ_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_EQ_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1305,
        GIR_Done,
      // Label 798: @36312
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(36377), // Rule ID 1306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7041:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LT_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LT_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1306,
        GIR_Done,
      // Label 799: @36377
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(36442), // Rule ID 1307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7040:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGU_LE_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGU_LE_QB_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1307,
        GIR_Done,
      // Label 800: @36442
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(36510), // Rule ID 1316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6891:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1316,
        GIR_Done,
      // Label 801: @36510
      GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(36578), // Rule ID 1317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 6893:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1317,
        GIR_Done,
      // Label 802: @36578
      GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(36646), // Rule ID 1328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_eq_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7036:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_EQ_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_EQ_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1328,
        GIR_Done,
      // Label 803: @36646
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(36714), // Rule ID 1329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_lt_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7038:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LT_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LT_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1329,
        GIR_Done,
      // Label 804: @36714
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(36782), // Rule ID 1330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_cmpgdu_le_qb),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v4s8,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7037:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (CMPGDU_LE_QB_MMR2:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::CMPGDU_LE_QB_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCCond*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1330,
        GIR_Done,
      // Label 805: @36782
      GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(36850), // Rule ID 1336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7514:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1336,
        GIR_Done,
      // Label 806: @36850
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(36918), // Rule ID 1337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7516:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBU_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1337,
        GIR_Done,
      // Label 807: @36918
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(36986), // Rule ID 1344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7338:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MUL_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_S_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1344,
        GIR_Done,
      // Label 808: @36986
      GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(37054), // Rule ID 1345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_rs_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7344:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_RS_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_RS_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1345,
        GIR_Done,
      // Label 809: @37054
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(37122), // Rule ID 1346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7345:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (MULQ_S_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1346,
        GIR_Done,
      // Label 810: @37122
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(37190), // Rule ID 1347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulq_s_w),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 7346:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MULQ_S_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULQ_S_W_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1347,
        GIR_Done,
      // Label 811: @37190
      GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(37255), // Rule ID 1348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_qb_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v4s8,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v4i8] } 7394:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECR_QB_PH_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::PRECR_QB_PH_MMR2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // rt
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1348,
        GIR_Done,
      // Label 812: @37255
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(37313), // Rule ID 1897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_ph),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_v2s16,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
        // (intrinsic_w_chain:{ *:[v2i16] } 7335:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag21*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1897,
        GIR_Done,
      // Label 813: @37313
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(37371), // Rule ID 1903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addsc),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6890:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDSC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDSC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPCarry*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1903,
        GIR_Done,
      // Label 814: @37371
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(37429), // Rule ID 1905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addwc),
        GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/0, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 6905:{ *:[iPTR] }, i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)  =>  (ADDWC:{ *:[i32] } i32:{ *:[i32] }:$a, i32:{ *:[i32] }:$b)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDWC),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // a
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/3, // b
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1905,
        GIR_Done,
      // Label 815: @37429
      GIM_Reject,
    // Label 744: @37430
    GIM_Reject,
    // Label 18: @37431
    GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(37507), // Rule ID 1578 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1578,
      GIR_Done,
    // Label 816: @37507
    GIM_Reject,
    // Label 19: @37508
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(37581), // Rule ID 1573 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      // (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$src)  =>  (SLL:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$src, sub_32:{ *:[i32] }), 0:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL),
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      // GIR_Coverage, 1573,
      GIR_Done,
    // Label 817: @37581
    GIM_Reject,
    // Label 20: @37582
    GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(37657),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(37624), // Rule ID 2128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immLi16),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm  =>  (LI16_MM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_immLi16>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LI16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2128,
        GIR_Done,
      // Label 819: @37624
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(37656), // Rule ID 1821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // MIs[0] Operand 1
        // No operand predicates
        // (imm:{ *:[i32] }):$imm  =>  (LwConstant32:{ *:[i32] } (imm:{ *:[i32] }):$imm, -1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::LwConstant32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rx]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1821,
        GIR_Done,
      // Label 820: @37656
      GIM_Reject,
    // Label 818: @37657
    GIM_Reject,
    // Label 21: @37658
    GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(39089),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(37788), // Rule ID 1612 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRA:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRA),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1612,
        GIR_Done,
      // Label 822: @37788
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(37900), // Rule ID 1610 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1610,
        GIR_Done,
      // Label 823: @37900
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(38012), // Rule ID 1608 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLL:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm5), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SLL),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/2, /*OldInsnID*/2, // imm5
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1608,
        GIR_Done,
      // Label 824: @38012
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(38116), // Rule ID 1603 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (ADDu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::ADDu),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1603,
        GIR_Done,
      // Label 825: @38116
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(38220), // Rule ID 1613 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sra:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRAV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRAV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1613,
        GIR_Done,
      // Label 826: @38220
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(38324), // Rule ID 1611 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SRLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SRLV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1611,
        GIR_Done,
      // Label 827: @38324
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(38431), // Rule ID 1788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (mul:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MUL_R6:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1788,
        GIR_Done,
      // Label 828: @38431
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(38538), // Rule ID 1789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::DIV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1789,
        GIR_Done,
      // Label 829: @38538
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(38642), // Rule ID 1609 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SLLV:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SLLV),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 830: @38642
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(38749), // Rule ID 1791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (srem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MOD:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MOD),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1791,
        GIR_Done,
      // Label 831: @38749
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(38853), // Rule ID 1604 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (sub:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (SUBu:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::SUBu),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1604,
        GIR_Done,
      // Label 832: @38853
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(38960), // Rule ID 1790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (DIVU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::DIVU),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1790,
        GIR_Done,
      // Label 833: @38960
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(39067), // Rule ID 1792 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sext:{ *:[i64] } (urem:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2))  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), (MODU:{ *:[i32] } GPR32:{ *:[i32] }:$src, GPR32:{ *:[i32] }:$src2), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(Mips::MODU),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(Mips::GPR32RegClassID),
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1792,
        GIR_Done,
      // Label 834: @39067
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(39088), // Rule ID 1580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL64_32),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1580,
        GIR_Done,
      // Label 835: @39088
      GIM_Reject,
    // Label 821: @39089
    GIM_Reject,
    // Label 22: @39090
    GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(39320),
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(39170), // Rule ID 280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }))  =>  (SEQ:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SEQ),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 280,
        GIR_Done,
      // Label 837: @39170
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(39232), // Rule ID 282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
        // MIs[1] Operand 1
        GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (zext:{ *:[i64] } (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }))  =>  (SNE:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SNE),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 282,
        GIR_Done,
      // Label 838: @39232
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(39319),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(39287), // Rule ID 1579 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DSRL:{ *:[i64] } (DSLL64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::DSLL64_32),
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSRL),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
          GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 1579,
          GIR_Done,
        // Label 840: @39287
        GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(39318), // Rule ID 1581 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips),
          // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (DEXT64_32:{ *:[i64] } GPR32:{ *:[i32] }:$src, 0:{ *:[i32] }, 32:{ *:[i32] })
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DEXT64_32),
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rt]
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
          GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
          GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          // GIR_Coverage, 1581,
          GIR_Done,
        // Label 841: @39318
        GIM_Reject,
      // Label 839: @39319
      GIM_Reject,
    // Label 836: @39320
    GIM_Reject,
    // Label 23: @39321
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 848*/ GIMT_Encode4(41389),
    /*GILLT_s32*//*Label 842*/ GIMT_Encode4(39364),
    /*GILLT_s64*//*Label 843*/ GIMT_Encode4(39680), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 844*/ GIMT_Encode4(39843), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 845*/ GIMT_Encode4(39883),
    /*GILLT_v8s16*//*Label 846*/ GIMT_Encode4(40193),
    /*GILLT_v16s8*//*Label 847*/ GIMT_Encode4(40647),
    // Label 842: @39364
    GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(39679),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(39429), // Rule ID 55 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SLL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 55,
        GIR_Done,
      // Label 850: @39429
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(39481), // Rule ID 1803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SllX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SllX16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rx]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1803,
        GIR_Done,
      // Label 851: @39481
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(39533), // Rule ID 2140 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Shift),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SLL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2140,
        GIR_Done,
      // Label 852: @39533
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(39585), // Rule ID 2141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SLL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2141,
        GIR_Done,
      // Label 853: @39585
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(39616), // Rule ID 61 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SLLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLLV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61,
        GIR_Done,
      // Label 854: @39616
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(39647), // Rule ID 1806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (shl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SllvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SllvRxRy16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1806,
        GIR_Done,
      // Label 855: @39647
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(39678), // Rule ID 2142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SLLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLLV_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2142,
        GIR_Done,
      // Label 856: @39678
      GIM_Reject,
    // Label 849: @39679
    GIM_Reject,
    // Label 843: @39680
    GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(39842),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(39745), // Rule ID 210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt6),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSLL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSLL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 210,
        GIR_Done,
      // Label 858: @39745
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(39820), // Rule ID 1574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (shl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSLLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSLLV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1574,
        GIR_Done,
      // Label 859: @39820
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(39841), // Rule ID 216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSLLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSLLV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 216,
        GIR_Done,
      // Label 860: @39841
      GIM_Reject,
    // Label 857: @39842
    GIM_Reject,
    // Label 844: @39843
    GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(39882), // Rule ID 960 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (shl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SLL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 960,
      GIR_Done,
    // Label 861: @39882
    GIM_Reject,
    // Label 845: @39883
    GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(40192),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(40033), // Rule ID 2432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2432,
        GIR_Done,
      // Label 863: @40033
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(40165), // Rule ID 2043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (shl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SLL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2043,
        GIR_Done,
      // Label 864: @40165
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(40191), // Rule ID 959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (shl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SLL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_W),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 959,
        GIR_Done,
      // Label 865: @40191
      GIM_Reject,
    // Label 862: @40192
    GIM_Reject,
    // Label 846: @40193
    GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(40646),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(40415), // Rule ID 2431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2431,
        GIR_Done,
      // Label 867: @40415
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(40619), // Rule ID 2042 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (shl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SLL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2042,
        GIR_Done,
      // Label 868: @40619
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(40645), // Rule ID 958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (shl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SLL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_H),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 958,
        GIR_Done,
      // Label 869: @40645
      GIM_Reject,
    // Label 866: @40646
    GIM_Reject,
    // Label 847: @40647
    GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(41388),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(41013), // Rule ID 2430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (shl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>), v16i8:{ *:[v16i8] }:$wt))  =>  (SLL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2430,
        GIR_Done,
      // Label 871: @41013
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(41361), // Rule ID 2041 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/17,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/9, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/10, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/11, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/12, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/13, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/14, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/15, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/16, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/11, /*MI*/2, /*OpIdx*/9, // MIs[11]
        GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/11, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[11] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/12, /*MI*/2, /*OpIdx*/10, // MIs[12]
        GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/12, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[12] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/13, /*MI*/2, /*OpIdx*/11, // MIs[13]
        GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/13, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[13] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/14, /*MI*/2, /*OpIdx*/12, // MIs[14]
        GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/14, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[14] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/15, /*MI*/2, /*OpIdx*/13, // MIs[15]
        GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/15, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[15] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/16, /*MI*/2, /*OpIdx*/14, // MIs[16]
        GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/16, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[16] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/17, /*MI*/2, /*OpIdx*/15, // MIs[17]
        GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/17, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[17] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/18, /*MI*/2, /*OpIdx*/16, // MIs[18]
        GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/18, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst7),
        // MIs[18] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        GIM_CheckIsSafeToFold, /*InsnID*/11,
        GIM_CheckIsSafeToFold, /*InsnID*/12,
        GIM_CheckIsSafeToFold, /*InsnID*/13,
        GIM_CheckIsSafeToFold, /*InsnID*/14,
        GIM_CheckIsSafeToFold, /*InsnID*/15,
        GIM_CheckIsSafeToFold, /*InsnID*/16,
        GIM_CheckIsSafeToFold, /*InsnID*/17,
        GIM_CheckIsSafeToFold, /*InsnID*/18,
        // (shl:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, (and:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$wt, (build_vector:{ *:[v16i8] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst7>>)))  =>  (SLL_B:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$ws, v16i8:{ *:[v16i8] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_B),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2041,
        GIR_Done,
      // Label 872: @41361
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(41387), // Rule ID 957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
        // (shl:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SLL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SLL_B),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 957,
        GIR_Done,
      // Label 873: @41387
      GIM_Reject,
    // Label 870: @41388
    GIM_Reject,
    // Label 848: @41389
    GIM_Reject,
    // Label 24: @41390
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 880*/ GIMT_Encode4(43458),
    /*GILLT_s32*//*Label 874*/ GIMT_Encode4(41433),
    /*GILLT_s64*//*Label 875*/ GIMT_Encode4(41749), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 876*/ GIMT_Encode4(41912), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 877*/ GIMT_Encode4(41952),
    /*GILLT_v8s16*//*Label 878*/ GIMT_Encode4(42262),
    /*GILLT_v16s8*//*Label 879*/ GIMT_Encode4(42716),
    // Label 874: @41433
    GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(41748),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(41498), // Rule ID 57 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$shamt)  =>  (SRL:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 57,
        GIR_Done,
      // Label 882: @41498
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(41550), // Rule ID 1804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SrlX16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$in, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SrlX16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rx]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1804,
        GIR_Done,
      // Label 883: @41550
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(41602), // Rule ID 2143 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Shift),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)  =>  (SRL16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt2Shift>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL16_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2143,
        GIR_Done,
      // Label 884: @41602
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(41654), // Rule ID 2144 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)  =>  (SRL_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_MM),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2144,
        GIR_Done,
      // Label 885: @41654
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(41685), // Rule ID 63 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (srl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SRLV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63,
        GIR_Done,
      // Label 886: @41685
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(41716), // Rule ID 1808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
        // (srl:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)  =>  (SrlvRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, CPU16Regs:{ *:[i32] }:$ra)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SrlvRxRy16),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1808,
        GIR_Done,
      // Label 887: @41716
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(41747), // Rule ID 2145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (srl:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)  =>  (SRLV_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRLV_MM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2145,
        GIR_Done,
      // Label 888: @41747
      GIM_Reject,
    // Label 881: @41748
    GIM_Reject,
    // Label 875: @41749
    GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(41911),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(41814), // Rule ID 212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt6),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt6>>:$shamt)  =>  (DSRL:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSRL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 212,
        GIR_Done,
      // Label 890: @41814
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(41889), // Rule ID 1575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (srl:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (trunc:{ *:[i32] } GPR64:{ *:[i64] }:$rs))  =>  (DSRLV:{ *:[i64] } GPR64:{ *:[i64] }:$rt, (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$rs, sub_32:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // rs
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(Mips::GPR64RegClassID),
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSRLV),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rt
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 1575,
        GIR_Done,
      // Label 891: @41889
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(41910), // Rule ID 220 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
        // (srl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (DSRLV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSRLV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 220,
        GIR_Done,
      // Label 892: @41910
      GIM_Reject,
    // Label 889: @41911
    GIM_Reject,
    // Label 876: @41912
    GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(41951), // Rule ID 992 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
      // (srl:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_D),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 992,
      GIR_Done,
    // Label 893: @41951
    GIM_Reject,
    // Label 877: @41952
    GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(42261),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(42102), // Rule ID 2448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (srl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>), v4i32:{ *:[v4i32] }:$wt))  =>  (SRL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2448,
        GIR_Done,
      // Label 895: @42102
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(42234), // Rule ID 2051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/5,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst31),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (srl:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$wt, (build_vector:{ *:[v4i32] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst31>>)))  =>  (SRL_W:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$ws, v4i32:{ *:[v4i32] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_W),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2051,
        GIR_Done,
      // Label 896: @42234
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(42260), // Rule ID 991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
        // (srl:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_W),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 991,
        GIR_Done,
      // Label 897: @42260
      GIM_Reject,
    // Label 894: @42261
    GIM_Reject,
    // Label 878: @42262
    GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(42715),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(42484), // Rule ID 2447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (srl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>), v8i16:{ *:[v8i16] }:$wt))  =>  (SRL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2447,
        GIR_Done,
      // Label 899: @42484
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(42688), // Rule ID 2050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/9,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/4, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/5, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/6, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/7, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/8, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/5, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[5] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/4, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/6, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[6] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/5, // MIs[7]
        GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/7, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[7] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/6, // MIs[8]
        GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/8, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[8] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/9, /*MI*/2, /*OpIdx*/7, // MIs[9]
        GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/9, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[9] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/10, /*MI*/2, /*OpIdx*/8, // MIs[10]
        GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/10, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immi32Cst15),
        // MIs[10] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        GIM_CheckIsSafeToFold, /*InsnID*/7,
        GIM_CheckIsSafeToFold, /*InsnID*/8,
        GIM_CheckIsSafeToFold, /*InsnID*/9,
        GIM_CheckIsSafeToFold, /*InsnID*/10,
        // (srl:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, (and:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$wt, (build_vector:{ *:[v8i16] } (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>, (imm:{ *:[i32] })<<P:Predicate_immi32Cst15>>)))  =>  (SRL_H:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$ws, v8i16:{ *:[v8i16] }:$wt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_H),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[wd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // ws
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // wt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2050,
        GIR_Done,
      // Label 900: @42688
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(42714), // Rule ID 990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
        // (srl:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SRL_H),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 990,
        GIR_Done,
      // Label 901: @42714
      GIM_Reject,
    // Label 898: @42715
    GIM_Reject,
    // Label 879: @42716
    GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(43457),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(43082), // Rule ID 2446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
        GIM_R