﻿#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include "libretro.h"

/*
 ********************************
 * VERSION: 2.0
 ********************************
 *
 * - 2.0: Add support for core options v2 interface
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_VIDEO_LABEL_AR "فيديو"
#define CATEGORY_VIDEO_INFO_0_AR "تغيير إعدادات إخراج الفيديو."
#define CATEGORY_AUDIO_LABEL_AR "نظام تشغيل الصوت"
#define CATEGORY_AUDIO_INFO_0_AR "تغيير إعدادات إخراج الصوت."
#define CATEGORY_MODE7_LABEL_AR NULL
#define CATEGORY_MODE7_INFO_0_AR NULL
#define CATEGORY_HACK_LABEL_AR NULL
#define CATEGORY_HACK_INFO_0_AR NULL
#define CATEGORY_OVERCLOCK_LABEL_AR NULL
#define CATEGORY_OVERCLOCK_INFO_0_AR NULL
#define CATEGORY_SGB_LABEL_AR "سوبر غيم بوي"
#define CATEGORY_SGB_INFO_0_AR NULL
#define CATEGORY_LIGHTGUN_LABEL_AR NULL
#define CATEGORY_LIGHTGUN_INFO_0_AR NULL
#define BSNES_ASPECT_RATIO_LABEL_AR NULL
#define BSNES_ASPECT_RATIO_INFO_0_AR NULL
#define OPTION_VAL_AUTO_AR "تلقائي"
#define OPTION_VAL_1_1_AR NULL
#define OPTION_VAL_4_3_AR NULL
#define OPTION_VAL_NTSC_AR NULL
#define OPTION_VAL_PAL_AR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_AR NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_AR NULL
#define OPTION_VAL_0_AR NULL
#define OPTION_VAL_8_AR NULL
#define OPTION_VAL_12_AR NULL
#define OPTION_VAL_16_AR NULL
#define BSNES_BLUR_EMULATION_LABEL_AR NULL
#define BSNES_BLUR_EMULATION_INFO_0_AR NULL
#define BSNES_VIDEO_FILTER_LABEL_AR "الفلتر"
#define BSNES_VIDEO_FILTER_INFO_0_AR NULL
#define OPTION_VAL_NONE_AR "لاشيء"
#define OPTION_VAL_NTSC_RF_AR NULL
#define OPTION_VAL_NTSC_COMPOSITE_AR NULL
#define OPTION_VAL_NTSC_S_VIDEO_AR NULL
#define OPTION_VAL_NTSC_RGB_AR NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_AR NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_AR NULL
#define OPTION_VAL_0_O4_AR NULL
#define OPTION_VAL_10_AR NULL
#define OPTION_VAL_20_AR NULL
#define OPTION_VAL_30_AR NULL
#define OPTION_VAL_40_AR NULL
#define OPTION_VAL_50_AR NULL
#define OPTION_VAL_60_AR NULL
#define OPTION_VAL_70_AR NULL
#define OPTION_VAL_80_AR NULL
#define OPTION_VAL_90_AR NULL
#define OPTION_VAL_100_AR NULL
#define BSNES_VIDEO_SATURATION_LABEL_AR NULL
#define BSNES_VIDEO_SATURATION_INFO_0_AR NULL
#define OPTION_VAL_110_AR NULL
#define OPTION_VAL_120_AR NULL
#define OPTION_VAL_130_AR NULL
#define OPTION_VAL_140_AR NULL
#define OPTION_VAL_150_AR NULL
#define OPTION_VAL_160_AR NULL
#define OPTION_VAL_170_AR NULL
#define OPTION_VAL_180_AR NULL
#define OPTION_VAL_190_AR NULL
#define OPTION_VAL_200_AR NULL
#define BSNES_VIDEO_GAMMA_LABEL_AR NULL
#define BSNES_VIDEO_GAMMA_INFO_0_AR NULL
#define OPTION_VAL_100_O6_AR NULL
#define OPTION_VAL_150_O6_AR NULL
#define BSNES_PPU_FAST_LABEL_AR NULL
#define BSNES_PPU_FAST_LABEL_CAT_AR NULL
#define BSNES_PPU_FAST_INFO_0_AR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_AR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_AR NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_AR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_AR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_AR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_AR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_AR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_AR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_AR NULL
#define BSNES_DSP_FAST_LABEL_AR NULL
#define BSNES_DSP_FAST_LABEL_CAT_AR NULL
#define BSNES_DSP_FAST_INFO_0_AR NULL
#define BSNES_DSP_CUBIC_LABEL_AR NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_AR NULL
#define BSNES_DSP_CUBIC_INFO_0_AR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_AR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_AR NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_AR NULL
#define BSNES_MODE7_SCALE_LABEL_AR NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_AR "مقياس"
#define BSNES_MODE7_SCALE_INFO_0_AR NULL
#define OPTION_VAL_1X_AR NULL
#define OPTION_VAL_2X_AR NULL
#define OPTION_VAL_3X_AR NULL
#define OPTION_VAL_4X_AR NULL
#define OPTION_VAL_5X_AR NULL
#define OPTION_VAL_6X_AR NULL
#define OPTION_VAL_7X_AR NULL
#define OPTION_VAL_8X_AR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_AR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_AR NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_AR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_AR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_AR NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_AR NULL
#define BSNES_MODE7_MOSAIC_LABEL_AR NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_AR NULL
#define BSNES_MODE7_MOSAIC_INFO_0_AR NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_AR NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_AR NULL
#define OPTION_VAL_1_AR NULL
#define OPTION_VAL_2_AR NULL
#define OPTION_VAL_3_AR NULL
#define OPTION_VAL_4_AR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_AR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_AR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_AR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_AR NULL
#define BSNES_HOTFIXES_LABEL_AR NULL
#define BSNES_HOTFIXES_INFO_0_AR NULL
#define BSNES_ENTROPY_LABEL_AR NULL
#define BSNES_ENTROPY_INFO_0_AR NULL
#define OPTION_VAL_LOW_AR NULL
#define OPTION_VAL_HIGH_AR NULL
#define BSNES_CPU_FASTMATH_LABEL_AR NULL
#define BSNES_CPU_FASTMATH_INFO_0_AR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_AR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_AR NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_AR NULL
#define OPTION_VAL_210_AR NULL
#define OPTION_VAL_220_AR NULL
#define OPTION_VAL_230_AR NULL
#define OPTION_VAL_240_AR NULL
#define OPTION_VAL_250_AR NULL
#define OPTION_VAL_260_AR NULL
#define OPTION_VAL_270_AR NULL
#define OPTION_VAL_280_AR NULL
#define OPTION_VAL_290_AR NULL
#define OPTION_VAL_300_AR NULL
#define OPTION_VAL_310_AR NULL
#define OPTION_VAL_320_AR NULL
#define OPTION_VAL_330_AR NULL
#define OPTION_VAL_340_AR NULL
#define OPTION_VAL_350_AR NULL
#define OPTION_VAL_360_AR NULL
#define OPTION_VAL_370_AR NULL
#define OPTION_VAL_380_AR NULL
#define OPTION_VAL_390_AR NULL
#define OPTION_VAL_400_AR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_AR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_AR NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_AR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_AR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_AR NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_AR NULL
#define OPTION_VAL_410_AR NULL
#define OPTION_VAL_420_AR NULL
#define OPTION_VAL_430_AR NULL
#define OPTION_VAL_440_AR NULL
#define OPTION_VAL_450_AR NULL
#define OPTION_VAL_460_AR NULL
#define OPTION_VAL_470_AR NULL
#define OPTION_VAL_480_AR NULL
#define OPTION_VAL_490_AR NULL
#define OPTION_VAL_500_AR NULL
#define OPTION_VAL_510_AR NULL
#define OPTION_VAL_520_AR NULL
#define OPTION_VAL_530_AR NULL
#define OPTION_VAL_540_AR NULL
#define OPTION_VAL_550_AR NULL
#define OPTION_VAL_560_AR NULL
#define OPTION_VAL_570_AR NULL
#define OPTION_VAL_580_AR NULL
#define OPTION_VAL_590_AR NULL
#define OPTION_VAL_600_AR NULL
#define OPTION_VAL_610_AR NULL
#define OPTION_VAL_620_AR NULL
#define OPTION_VAL_630_AR NULL
#define OPTION_VAL_640_AR NULL
#define OPTION_VAL_650_AR NULL
#define OPTION_VAL_660_AR NULL
#define OPTION_VAL_670_AR NULL
#define OPTION_VAL_680_AR NULL
#define OPTION_VAL_690_AR NULL
#define OPTION_VAL_700_AR NULL
#define OPTION_VAL_710_AR NULL
#define OPTION_VAL_720_AR NULL
#define OPTION_VAL_730_AR NULL
#define OPTION_VAL_740_AR NULL
#define OPTION_VAL_750_AR NULL
#define OPTION_VAL_760_AR NULL
#define OPTION_VAL_770_AR NULL
#define OPTION_VAL_780_AR NULL
#define OPTION_VAL_790_AR NULL
#define OPTION_VAL_800_AR NULL
#define BSNES_SGB_BIOS_LABEL_AR NULL
#define BSNES_SGB_BIOS_INFO_0_AR NULL
#define OPTION_VAL_SGB1_SFC_AR NULL
#define OPTION_VAL_SGB2_SFC_AR NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_AR NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_AR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_AR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_AR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_AR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_AR NULL

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_AR,
      CATEGORY_VIDEO_INFO_0_AR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AR,
      CATEGORY_AUDIO_INFO_0_AR
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_AR,
      CATEGORY_MODE7_INFO_0_AR
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_AR,
      CATEGORY_HACK_INFO_0_AR
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_AR,
      CATEGORY_OVERCLOCK_INFO_0_AR
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_AR,
      CATEGORY_SGB_INFO_0_AR
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_AR,
      CATEGORY_LIGHTGUN_INFO_0_AR
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_AR,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_AR,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_AR },
         { "1:1",  OPTION_VAL_1_1_AR },
         { "4:3",  OPTION_VAL_4_3_AR },
         { "NTSC", OPTION_VAL_NTSC_AR },
         { "PAL",  OPTION_VAL_PAL_AR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_AR,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_AR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_AR },
         { "8",  OPTION_VAL_8_AR },
         { "12", OPTION_VAL_12_AR },
         { "16", OPTION_VAL_16_AR },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_AR,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_AR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_AR,
      BSNES_VIDEO_FILTER_LABEL_AR,
      BSNES_VIDEO_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_AR },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_AR },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_AR },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_AR },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_AR },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_AR,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_AR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_AR },
         { "10", OPTION_VAL_10_AR },
         { "20", OPTION_VAL_20_AR },
         { "30", OPTION_VAL_30_AR },
         { "40", OPTION_VAL_40_AR },
         { "50", OPTION_VAL_50_AR },
         { "60", OPTION_VAL_60_AR },
         { "70", OPTION_VAL_70_AR },
         { "80", OPTION_VAL_80_AR },
         { "90", OPTION_VAL_90_AR },
         { "100", OPTION_VAL_100_AR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_AR,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_AR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_AR },
         { "10", OPTION_VAL_10_AR },
         { "20", OPTION_VAL_20_AR },
         { "30", OPTION_VAL_30_AR },
         { "40", OPTION_VAL_40_AR },
         { "50", OPTION_VAL_50_AR },
         { "60", OPTION_VAL_60_AR },
         { "70", OPTION_VAL_70_AR },
         { "80", OPTION_VAL_80_AR },
         { "90", OPTION_VAL_90_AR },
         { "100", OPTION_VAL_100_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_AR,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_AR,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_O6_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_AR,
      BSNES_PPU_FAST_LABEL_CAT_AR,
      BSNES_PPU_FAST_INFO_0_AR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_AR,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_AR,
      BSNES_PPU_DEINTERLACE_INFO_0_AR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_AR,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_AR,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_AR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_AR,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_AR,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_AR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_AR,
      BSNES_DSP_FAST_LABEL_CAT_AR,
      BSNES_DSP_FAST_INFO_0_AR,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_AR,
      BSNES_DSP_CUBIC_LABEL_CAT_AR,
      BSNES_DSP_CUBIC_INFO_0_AR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_AR,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_AR,
      BSNES_DSP_ECHO_SHADOW_INFO_0_AR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_AR,
      BSNES_MODE7_SCALE_LABEL_CAT_AR,
      BSNES_MODE7_SCALE_INFO_0_AR,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_AR  },
         { "2x", OPTION_VAL_2X_AR  },
         { "3x", OPTION_VAL_3X_AR  },
         { "4x", OPTION_VAL_4X_AR  },
         { "5x", OPTION_VAL_5X_AR },
         { "6x", OPTION_VAL_6X_AR },
         { "7x", OPTION_VAL_7X_AR },
         { "8x", OPTION_VAL_8X_AR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_AR,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_AR,
      BSNES_MODE7_PERSPECTIVE_INFO_0_AR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_AR,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_AR,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_AR,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_AR,
      BSNES_MODE7_MOSAIC_LABEL_CAT_AR,
      BSNES_MODE7_MOSAIC_INFO_0_AR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_AR,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_AR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_AR  },
         { "2",   OPTION_VAL_2_AR },
         { "3",   OPTION_VAL_3_AR },
         { "4",   OPTION_VAL_4_AR },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_AR,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_AR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_AR,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_AR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_AR,
      NULL,
      BSNES_HOTFIXES_INFO_0_AR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_AR,
      NULL,
      BSNES_ENTROPY_INFO_0_AR,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_AR },
         { "High", OPTION_VAL_HIGH_AR },
         { "None", OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_AR,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_AR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_AR,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_AR,
      BSNES_CPU_OVERCLOCK_INFO_0_AR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AR  },
         { "20",  OPTION_VAL_20_AR  },
         { "30",  OPTION_VAL_30_AR  },
         { "40",  OPTION_VAL_40_AR  },
         { "50",  OPTION_VAL_50_AR  },
         { "60",  OPTION_VAL_60_AR  },
         { "70",  OPTION_VAL_70_AR  },
         { "80",  OPTION_VAL_80_AR  },
         { "90",  OPTION_VAL_90_AR  },
         { "100", OPTION_VAL_100_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { "210", OPTION_VAL_210_AR },
         { "220", OPTION_VAL_220_AR },
         { "230", OPTION_VAL_230_AR },
         { "240", OPTION_VAL_240_AR },
         { "250", OPTION_VAL_250_AR },
         { "260", OPTION_VAL_260_AR },
         { "270", OPTION_VAL_270_AR },
         { "280", OPTION_VAL_280_AR },
         { "290", OPTION_VAL_290_AR },
         { "300", OPTION_VAL_300_AR },
         { "310", OPTION_VAL_310_AR },
         { "320", OPTION_VAL_320_AR },
         { "330", OPTION_VAL_330_AR },
         { "340", OPTION_VAL_340_AR },
         { "350", OPTION_VAL_350_AR },
         { "360", OPTION_VAL_360_AR },
         { "370", OPTION_VAL_370_AR },
         { "380", OPTION_VAL_380_AR },
         { "390", OPTION_VAL_390_AR },
         { "400", OPTION_VAL_400_AR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_AR,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_AR,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_AR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AR  },
         { "20",  OPTION_VAL_20_AR  },
         { "30",  OPTION_VAL_30_AR  },
         { "40",  OPTION_VAL_40_AR  },
         { "50",  OPTION_VAL_50_AR  },
         { "60",  OPTION_VAL_60_AR  },
         { "70",  OPTION_VAL_70_AR  },
         { "80",  OPTION_VAL_80_AR  },
         { "90",  OPTION_VAL_90_AR  },
         { "100", OPTION_VAL_100_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { "210", OPTION_VAL_210_AR },
         { "220", OPTION_VAL_220_AR },
         { "230", OPTION_VAL_230_AR },
         { "240", OPTION_VAL_240_AR },
         { "250", OPTION_VAL_250_AR },
         { "260", OPTION_VAL_260_AR },
         { "270", OPTION_VAL_270_AR },
         { "280", OPTION_VAL_280_AR },
         { "290", OPTION_VAL_290_AR },
         { "300", OPTION_VAL_300_AR },
         { "310", OPTION_VAL_310_AR },
         { "320", OPTION_VAL_320_AR },
         { "330", OPTION_VAL_330_AR },
         { "340", OPTION_VAL_340_AR },
         { "350", OPTION_VAL_350_AR },
         { "360", OPTION_VAL_360_AR },
         { "370", OPTION_VAL_370_AR },
         { "380", OPTION_VAL_380_AR },
         { "390", OPTION_VAL_390_AR },
         { "400", OPTION_VAL_400_AR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_AR,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_AR,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_AR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AR  },
         { "20",  OPTION_VAL_20_AR  },
         { "30",  OPTION_VAL_30_AR  },
         { "40",  OPTION_VAL_40_AR  },
         { "50",  OPTION_VAL_50_AR  },
         { "60",  OPTION_VAL_60_AR  },
         { "70",  OPTION_VAL_70_AR  },
         { "80",  OPTION_VAL_80_AR  },
         { "90",  OPTION_VAL_90_AR  },
         { "100", OPTION_VAL_100_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { "210", OPTION_VAL_210_AR },
         { "220", OPTION_VAL_220_AR },
         { "230", OPTION_VAL_230_AR },
         { "240", OPTION_VAL_240_AR },
         { "250", OPTION_VAL_250_AR },
         { "260", OPTION_VAL_260_AR },
         { "270", OPTION_VAL_270_AR },
         { "280", OPTION_VAL_280_AR },
         { "290", OPTION_VAL_290_AR },
         { "300", OPTION_VAL_300_AR },
         { "310", OPTION_VAL_310_AR },
         { "320", OPTION_VAL_320_AR },
         { "330", OPTION_VAL_330_AR },
         { "340", OPTION_VAL_340_AR },
         { "350", OPTION_VAL_350_AR },
         { "360", OPTION_VAL_360_AR },
         { "370", OPTION_VAL_370_AR },
         { "380", OPTION_VAL_380_AR },
         { "390", OPTION_VAL_390_AR },
         { "400", OPTION_VAL_400_AR },
         { "410", OPTION_VAL_410_AR },
         { "420", OPTION_VAL_420_AR },
         { "430", OPTION_VAL_430_AR },
         { "440", OPTION_VAL_440_AR },
         { "450", OPTION_VAL_450_AR },
         { "460", OPTION_VAL_460_AR },
         { "470", OPTION_VAL_470_AR },
         { "480", OPTION_VAL_480_AR },
         { "490", OPTION_VAL_490_AR },
         { "500", OPTION_VAL_500_AR },
         { "510", OPTION_VAL_510_AR },
         { "520", OPTION_VAL_520_AR },
         { "530", OPTION_VAL_530_AR },
         { "540", OPTION_VAL_540_AR },
         { "550", OPTION_VAL_550_AR },
         { "560", OPTION_VAL_560_AR },
         { "570", OPTION_VAL_570_AR },
         { "580", OPTION_VAL_580_AR },
         { "590", OPTION_VAL_590_AR },
         { "600", OPTION_VAL_600_AR },
         { "610", OPTION_VAL_610_AR },
         { "620", OPTION_VAL_620_AR },
         { "630", OPTION_VAL_630_AR },
         { "640", OPTION_VAL_640_AR },
         { "650", OPTION_VAL_650_AR },
         { "660", OPTION_VAL_660_AR },
         { "670", OPTION_VAL_670_AR },
         { "680", OPTION_VAL_680_AR },
         { "690", OPTION_VAL_690_AR },
         { "700", OPTION_VAL_700_AR },
         { "710", OPTION_VAL_710_AR },
         { "720", OPTION_VAL_720_AR },
         { "730", OPTION_VAL_730_AR },
         { "740", OPTION_VAL_740_AR },
         { "750", OPTION_VAL_750_AR },
         { "760", OPTION_VAL_760_AR },
         { "770", OPTION_VAL_770_AR },
         { "780", OPTION_VAL_780_AR },
         { "790", OPTION_VAL_790_AR },
         { "800", OPTION_VAL_800_AR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_AR,
      NULL,
      BSNES_SGB_BIOS_INFO_0_AR,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_AR   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_AR },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_AR,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_AR,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_AR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_AR,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_AR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_AR,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_VIDEO_LABEL_AST "Videu"
#define CATEGORY_VIDEO_INFO_0_AST NULL
#define CATEGORY_AUDIO_LABEL_AST "Audiu"
#define CATEGORY_AUDIO_INFO_0_AST NULL
#define CATEGORY_MODE7_LABEL_AST NULL
#define CATEGORY_MODE7_INFO_0_AST NULL
#define CATEGORY_HACK_LABEL_AST NULL
#define CATEGORY_HACK_INFO_0_AST NULL
#define CATEGORY_OVERCLOCK_LABEL_AST NULL
#define CATEGORY_OVERCLOCK_INFO_0_AST NULL
#define CATEGORY_SGB_LABEL_AST NULL
#define CATEGORY_SGB_INFO_0_AST NULL
#define CATEGORY_LIGHTGUN_LABEL_AST NULL
#define CATEGORY_LIGHTGUN_INFO_0_AST NULL
#define BSNES_ASPECT_RATIO_LABEL_AST NULL
#define BSNES_ASPECT_RATIO_INFO_0_AST NULL
#define OPTION_VAL_AUTO_AST NULL
#define OPTION_VAL_1_1_AST NULL
#define OPTION_VAL_4_3_AST NULL
#define OPTION_VAL_NTSC_AST NULL
#define OPTION_VAL_PAL_AST NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_AST NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_AST NULL
#define OPTION_VAL_0_AST NULL
#define OPTION_VAL_8_AST NULL
#define OPTION_VAL_12_AST NULL
#define OPTION_VAL_16_AST NULL
#define BSNES_BLUR_EMULATION_LABEL_AST NULL
#define BSNES_BLUR_EMULATION_INFO_0_AST NULL
#define BSNES_VIDEO_FILTER_LABEL_AST NULL
#define BSNES_VIDEO_FILTER_INFO_0_AST NULL
#define OPTION_VAL_NONE_AST NULL
#define OPTION_VAL_NTSC_RF_AST NULL
#define OPTION_VAL_NTSC_COMPOSITE_AST "NTSC (videu compuestu)"
#define OPTION_VAL_NTSC_S_VIDEO_AST NULL
#define OPTION_VAL_NTSC_RGB_AST NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_AST NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_AST NULL
#define OPTION_VAL_0_O4_AST NULL
#define OPTION_VAL_10_AST NULL
#define OPTION_VAL_20_AST NULL
#define OPTION_VAL_30_AST NULL
#define OPTION_VAL_40_AST NULL
#define OPTION_VAL_50_AST NULL
#define OPTION_VAL_60_AST NULL
#define OPTION_VAL_70_AST NULL
#define OPTION_VAL_80_AST NULL
#define OPTION_VAL_90_AST NULL
#define OPTION_VAL_100_AST "100% (Por defeutu)"
#define BSNES_VIDEO_SATURATION_LABEL_AST NULL
#define BSNES_VIDEO_SATURATION_INFO_0_AST NULL
#define OPTION_VAL_110_AST NULL
#define OPTION_VAL_120_AST NULL
#define OPTION_VAL_130_AST NULL
#define OPTION_VAL_140_AST NULL
#define OPTION_VAL_150_AST NULL
#define OPTION_VAL_160_AST NULL
#define OPTION_VAL_170_AST NULL
#define OPTION_VAL_180_AST NULL
#define OPTION_VAL_190_AST NULL
#define OPTION_VAL_200_AST NULL
#define BSNES_VIDEO_GAMMA_LABEL_AST NULL
#define BSNES_VIDEO_GAMMA_INFO_0_AST NULL
#define OPTION_VAL_100_O6_AST NULL
#define OPTION_VAL_150_O6_AST "150% (por defeutu)"
#define BSNES_PPU_FAST_LABEL_AST NULL
#define BSNES_PPU_FAST_LABEL_CAT_AST NULL
#define BSNES_PPU_FAST_INFO_0_AST NULL
#define BSNES_PPU_DEINTERLACE_LABEL_AST NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_AST NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_AST NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_AST NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_AST NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_AST NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_AST NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_AST NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_AST NULL
#define BSNES_DSP_FAST_LABEL_AST NULL
#define BSNES_DSP_FAST_LABEL_CAT_AST NULL
#define BSNES_DSP_FAST_INFO_0_AST NULL
#define BSNES_DSP_CUBIC_LABEL_AST NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_AST NULL
#define BSNES_DSP_CUBIC_INFO_0_AST NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_AST NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_AST NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_AST NULL
#define BSNES_MODE7_SCALE_LABEL_AST NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_AST NULL
#define BSNES_MODE7_SCALE_INFO_0_AST NULL
#define OPTION_VAL_1X_AST "240p (x1)"
#define OPTION_VAL_2X_AST "480p (x2)"
#define OPTION_VAL_3X_AST "720p (x3)"
#define OPTION_VAL_4X_AST "960p (x4)"
#define OPTION_VAL_5X_AST "1200p (x5)"
#define OPTION_VAL_6X_AST "1440p (x6)"
#define OPTION_VAL_7X_AST "1680p (x7)"
#define OPTION_VAL_8X_AST "1920p (x8)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_AST NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_AST "Correición de la perspeutiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_AST NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_AST NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_AST NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_AST NULL
#define BSNES_MODE7_MOSAIC_LABEL_AST NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_AST NULL
#define BSNES_MODE7_MOSAIC_INFO_0_AST NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_AST NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_AST NULL
#define OPTION_VAL_1_AST "1 fotograma"
#define OPTION_VAL_2_AST "2 fotogrames"
#define OPTION_VAL_3_AST "3 fotogrames"
#define OPTION_VAL_4_AST "4 fotogrames"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_AST NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_AST NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_AST NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_AST NULL
#define BSNES_HOTFIXES_LABEL_AST NULL
#define BSNES_HOTFIXES_INFO_0_AST NULL
#define BSNES_ENTROPY_LABEL_AST NULL
#define BSNES_ENTROPY_INFO_0_AST NULL
#define OPTION_VAL_LOW_AST NULL
#define OPTION_VAL_HIGH_AST NULL
#define BSNES_CPU_FASTMATH_LABEL_AST NULL
#define BSNES_CPU_FASTMATH_INFO_0_AST NULL
#define BSNES_CPU_OVERCLOCK_LABEL_AST NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_AST NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_AST NULL
#define OPTION_VAL_210_AST NULL
#define OPTION_VAL_220_AST NULL
#define OPTION_VAL_230_AST NULL
#define OPTION_VAL_240_AST NULL
#define OPTION_VAL_250_AST NULL
#define OPTION_VAL_260_AST NULL
#define OPTION_VAL_270_AST NULL
#define OPTION_VAL_280_AST NULL
#define OPTION_VAL_290_AST NULL
#define OPTION_VAL_300_AST NULL
#define OPTION_VAL_310_AST NULL
#define OPTION_VAL_320_AST NULL
#define OPTION_VAL_330_AST NULL
#define OPTION_VAL_340_AST NULL
#define OPTION_VAL_350_AST NULL
#define OPTION_VAL_360_AST NULL
#define OPTION_VAL_370_AST NULL
#define OPTION_VAL_380_AST NULL
#define OPTION_VAL_390_AST NULL
#define OPTION_VAL_400_AST NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_AST NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_AST "Coprocesador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_AST NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_AST NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_AST NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_AST NULL
#define OPTION_VAL_410_AST NULL
#define OPTION_VAL_420_AST NULL
#define OPTION_VAL_430_AST NULL
#define OPTION_VAL_440_AST NULL
#define OPTION_VAL_450_AST NULL
#define OPTION_VAL_460_AST NULL
#define OPTION_VAL_470_AST NULL
#define OPTION_VAL_480_AST NULL
#define OPTION_VAL_490_AST NULL
#define OPTION_VAL_500_AST NULL
#define OPTION_VAL_510_AST NULL
#define OPTION_VAL_520_AST NULL
#define OPTION_VAL_530_AST NULL
#define OPTION_VAL_540_AST NULL
#define OPTION_VAL_550_AST NULL
#define OPTION_VAL_560_AST NULL
#define OPTION_VAL_570_AST NULL
#define OPTION_VAL_580_AST NULL
#define OPTION_VAL_590_AST NULL
#define OPTION_VAL_600_AST NULL
#define OPTION_VAL_610_AST NULL
#define OPTION_VAL_620_AST NULL
#define OPTION_VAL_630_AST NULL
#define OPTION_VAL_640_AST NULL
#define OPTION_VAL_650_AST NULL
#define OPTION_VAL_660_AST NULL
#define OPTION_VAL_670_AST NULL
#define OPTION_VAL_680_AST NULL
#define OPTION_VAL_690_AST NULL
#define OPTION_VAL_700_AST NULL
#define OPTION_VAL_710_AST NULL
#define OPTION_VAL_720_AST NULL
#define OPTION_VAL_730_AST NULL
#define OPTION_VAL_740_AST NULL
#define OPTION_VAL_750_AST NULL
#define OPTION_VAL_760_AST NULL
#define OPTION_VAL_770_AST NULL
#define OPTION_VAL_780_AST NULL
#define OPTION_VAL_790_AST NULL
#define OPTION_VAL_800_AST NULL
#define BSNES_SGB_BIOS_LABEL_AST NULL
#define BSNES_SGB_BIOS_INFO_0_AST NULL
#define OPTION_VAL_SGB1_SFC_AST NULL
#define OPTION_VAL_SGB2_SFC_AST NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_AST NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_AST NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_AST NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_AST NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_AST NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_AST NULL

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_AST,
      CATEGORY_VIDEO_INFO_0_AST
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_AST,
      CATEGORY_AUDIO_INFO_0_AST
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_AST,
      CATEGORY_MODE7_INFO_0_AST
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_AST,
      CATEGORY_HACK_INFO_0_AST
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_AST,
      CATEGORY_OVERCLOCK_INFO_0_AST
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_AST,
      CATEGORY_SGB_INFO_0_AST
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_AST,
      CATEGORY_LIGHTGUN_INFO_0_AST
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_AST,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_AST,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_AST },
         { "1:1",  OPTION_VAL_1_1_AST },
         { "4:3",  OPTION_VAL_4_3_AST },
         { "NTSC", OPTION_VAL_NTSC_AST },
         { "PAL",  OPTION_VAL_PAL_AST },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_AST,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_AST,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_AST },
         { "8",  OPTION_VAL_8_AST },
         { "12", OPTION_VAL_12_AST },
         { "16", OPTION_VAL_16_AST },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_AST,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_AST,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_AST,
      BSNES_VIDEO_FILTER_LABEL_AST,
      BSNES_VIDEO_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_AST },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_AST },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_AST },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_AST },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_AST },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_AST,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_AST,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_AST },
         { "10", OPTION_VAL_10_AST },
         { "20", OPTION_VAL_20_AST },
         { "30", OPTION_VAL_30_AST },
         { "40", OPTION_VAL_40_AST },
         { "50", OPTION_VAL_50_AST },
         { "60", OPTION_VAL_60_AST },
         { "70", OPTION_VAL_70_AST },
         { "80", OPTION_VAL_80_AST },
         { "90", OPTION_VAL_90_AST },
         { "100", OPTION_VAL_100_AST },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_AST,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_AST,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_AST },
         { "10", OPTION_VAL_10_AST },
         { "20", OPTION_VAL_20_AST },
         { "30", OPTION_VAL_30_AST },
         { "40", OPTION_VAL_40_AST },
         { "50", OPTION_VAL_50_AST },
         { "60", OPTION_VAL_60_AST },
         { "70", OPTION_VAL_70_AST },
         { "80", OPTION_VAL_80_AST },
         { "90", OPTION_VAL_90_AST },
         { "100", OPTION_VAL_100_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_AST,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_AST,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_O6_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_AST,
      BSNES_PPU_FAST_LABEL_CAT_AST,
      BSNES_PPU_FAST_INFO_0_AST,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_AST,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_AST,
      BSNES_PPU_DEINTERLACE_INFO_0_AST,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_AST,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_AST,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_AST,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_AST,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_AST,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_AST,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_AST,
      BSNES_DSP_FAST_LABEL_CAT_AST,
      BSNES_DSP_FAST_INFO_0_AST,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_AST,
      BSNES_DSP_CUBIC_LABEL_CAT_AST,
      BSNES_DSP_CUBIC_INFO_0_AST,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_AST,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_AST,
      BSNES_DSP_ECHO_SHADOW_INFO_0_AST,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_AST,
      BSNES_MODE7_SCALE_LABEL_CAT_AST,
      BSNES_MODE7_SCALE_INFO_0_AST,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_AST  },
         { "2x", OPTION_VAL_2X_AST  },
         { "3x", OPTION_VAL_3X_AST  },
         { "4x", OPTION_VAL_4X_AST  },
         { "5x", OPTION_VAL_5X_AST },
         { "6x", OPTION_VAL_6X_AST },
         { "7x", OPTION_VAL_7X_AST },
         { "8x", OPTION_VAL_8X_AST },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_AST,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_AST,
      BSNES_MODE7_PERSPECTIVE_INFO_0_AST,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_AST,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_AST,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_AST,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_AST,
      BSNES_MODE7_MOSAIC_LABEL_CAT_AST,
      BSNES_MODE7_MOSAIC_INFO_0_AST,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_AST,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_AST,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_AST  },
         { "2",   OPTION_VAL_2_AST },
         { "3",   OPTION_VAL_3_AST },
         { "4",   OPTION_VAL_4_AST },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_AST,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_AST,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_AST,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_AST,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_AST,
      NULL,
      BSNES_HOTFIXES_INFO_0_AST,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_AST,
      NULL,
      BSNES_ENTROPY_INFO_0_AST,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_AST },
         { "High", OPTION_VAL_HIGH_AST },
         { "None", OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_AST,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_AST,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_AST,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_AST,
      BSNES_CPU_OVERCLOCK_INFO_0_AST,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AST  },
         { "20",  OPTION_VAL_20_AST  },
         { "30",  OPTION_VAL_30_AST  },
         { "40",  OPTION_VAL_40_AST  },
         { "50",  OPTION_VAL_50_AST  },
         { "60",  OPTION_VAL_60_AST  },
         { "70",  OPTION_VAL_70_AST  },
         { "80",  OPTION_VAL_80_AST  },
         { "90",  OPTION_VAL_90_AST  },
         { "100", OPTION_VAL_100_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { "210", OPTION_VAL_210_AST },
         { "220", OPTION_VAL_220_AST },
         { "230", OPTION_VAL_230_AST },
         { "240", OPTION_VAL_240_AST },
         { "250", OPTION_VAL_250_AST },
         { "260", OPTION_VAL_260_AST },
         { "270", OPTION_VAL_270_AST },
         { "280", OPTION_VAL_280_AST },
         { "290", OPTION_VAL_290_AST },
         { "300", OPTION_VAL_300_AST },
         { "310", OPTION_VAL_310_AST },
         { "320", OPTION_VAL_320_AST },
         { "330", OPTION_VAL_330_AST },
         { "340", OPTION_VAL_340_AST },
         { "350", OPTION_VAL_350_AST },
         { "360", OPTION_VAL_360_AST },
         { "370", OPTION_VAL_370_AST },
         { "380", OPTION_VAL_380_AST },
         { "390", OPTION_VAL_390_AST },
         { "400", OPTION_VAL_400_AST },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_AST,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_AST,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_AST,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AST  },
         { "20",  OPTION_VAL_20_AST  },
         { "30",  OPTION_VAL_30_AST  },
         { "40",  OPTION_VAL_40_AST  },
         { "50",  OPTION_VAL_50_AST  },
         { "60",  OPTION_VAL_60_AST  },
         { "70",  OPTION_VAL_70_AST  },
         { "80",  OPTION_VAL_80_AST  },
         { "90",  OPTION_VAL_90_AST  },
         { "100", OPTION_VAL_100_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { "210", OPTION_VAL_210_AST },
         { "220", OPTION_VAL_220_AST },
         { "230", OPTION_VAL_230_AST },
         { "240", OPTION_VAL_240_AST },
         { "250", OPTION_VAL_250_AST },
         { "260", OPTION_VAL_260_AST },
         { "270", OPTION_VAL_270_AST },
         { "280", OPTION_VAL_280_AST },
         { "290", OPTION_VAL_290_AST },
         { "300", OPTION_VAL_300_AST },
         { "310", OPTION_VAL_310_AST },
         { "320", OPTION_VAL_320_AST },
         { "330", OPTION_VAL_330_AST },
         { "340", OPTION_VAL_340_AST },
         { "350", OPTION_VAL_350_AST },
         { "360", OPTION_VAL_360_AST },
         { "370", OPTION_VAL_370_AST },
         { "380", OPTION_VAL_380_AST },
         { "390", OPTION_VAL_390_AST },
         { "400", OPTION_VAL_400_AST },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_AST,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_AST,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_AST,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_AST  },
         { "20",  OPTION_VAL_20_AST  },
         { "30",  OPTION_VAL_30_AST  },
         { "40",  OPTION_VAL_40_AST  },
         { "50",  OPTION_VAL_50_AST  },
         { "60",  OPTION_VAL_60_AST  },
         { "70",  OPTION_VAL_70_AST  },
         { "80",  OPTION_VAL_80_AST  },
         { "90",  OPTION_VAL_90_AST  },
         { "100", OPTION_VAL_100_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { "210", OPTION_VAL_210_AST },
         { "220", OPTION_VAL_220_AST },
         { "230", OPTION_VAL_230_AST },
         { "240", OPTION_VAL_240_AST },
         { "250", OPTION_VAL_250_AST },
         { "260", OPTION_VAL_260_AST },
         { "270", OPTION_VAL_270_AST },
         { "280", OPTION_VAL_280_AST },
         { "290", OPTION_VAL_290_AST },
         { "300", OPTION_VAL_300_AST },
         { "310", OPTION_VAL_310_AST },
         { "320", OPTION_VAL_320_AST },
         { "330", OPTION_VAL_330_AST },
         { "340", OPTION_VAL_340_AST },
         { "350", OPTION_VAL_350_AST },
         { "360", OPTION_VAL_360_AST },
         { "370", OPTION_VAL_370_AST },
         { "380", OPTION_VAL_380_AST },
         { "390", OPTION_VAL_390_AST },
         { "400", OPTION_VAL_400_AST },
         { "410", OPTION_VAL_410_AST },
         { "420", OPTION_VAL_420_AST },
         { "430", OPTION_VAL_430_AST },
         { "440", OPTION_VAL_440_AST },
         { "450", OPTION_VAL_450_AST },
         { "460", OPTION_VAL_460_AST },
         { "470", OPTION_VAL_470_AST },
         { "480", OPTION_VAL_480_AST },
         { "490", OPTION_VAL_490_AST },
         { "500", OPTION_VAL_500_AST },
         { "510", OPTION_VAL_510_AST },
         { "520", OPTION_VAL_520_AST },
         { "530", OPTION_VAL_530_AST },
         { "540", OPTION_VAL_540_AST },
         { "550", OPTION_VAL_550_AST },
         { "560", OPTION_VAL_560_AST },
         { "570", OPTION_VAL_570_AST },
         { "580", OPTION_VAL_580_AST },
         { "590", OPTION_VAL_590_AST },
         { "600", OPTION_VAL_600_AST },
         { "610", OPTION_VAL_610_AST },
         { "620", OPTION_VAL_620_AST },
         { "630", OPTION_VAL_630_AST },
         { "640", OPTION_VAL_640_AST },
         { "650", OPTION_VAL_650_AST },
         { "660", OPTION_VAL_660_AST },
         { "670", OPTION_VAL_670_AST },
         { "680", OPTION_VAL_680_AST },
         { "690", OPTION_VAL_690_AST },
         { "700", OPTION_VAL_700_AST },
         { "710", OPTION_VAL_710_AST },
         { "720", OPTION_VAL_720_AST },
         { "730", OPTION_VAL_730_AST },
         { "740", OPTION_VAL_740_AST },
         { "750", OPTION_VAL_750_AST },
         { "760", OPTION_VAL_760_AST },
         { "770", OPTION_VAL_770_AST },
         { "780", OPTION_VAL_780_AST },
         { "790", OPTION_VAL_790_AST },
         { "800", OPTION_VAL_800_AST },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_AST,
      NULL,
      BSNES_SGB_BIOS_INFO_0_AST,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_AST   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_AST },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_AST,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_AST,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_AST,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_AST,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_AST,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_AST,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_BE */

#define CATEGORY_VIDEO_LABEL_BE "Відэа"
#define CATEGORY_VIDEO_INFO_0_BE "Змяніць налады вываду відэа."
#define CATEGORY_AUDIO_LABEL_BE "Аўдыя"
#define CATEGORY_AUDIO_INFO_0_BE "Змяніць налады вываду гуку."
#define CATEGORY_MODE7_LABEL_BE NULL
#define CATEGORY_MODE7_INFO_0_BE "Налады эмуляцыі графічнага рэжыму Mode 7."
#define CATEGORY_HACK_LABEL_BE "Паляпшэнні і хакі эмуляцыі"
#define CATEGORY_HACK_INFO_0_BE "Уключэнне выпраўленняў, паляпшэнняў і хакаў эмуляцыі."
#define CATEGORY_OVERCLOCK_LABEL_BE "Разгон/запавольванне"
#define CATEGORY_OVERCLOCK_INFO_0_BE "Налада хуткасці абсталявання якое эмулюецца."
#define CATEGORY_SGB_LABEL_BE NULL
#define CATEGORY_SGB_INFO_0_BE "Налады эмуляцыі Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_BE "Светлавы пісталет"
#define CATEGORY_LIGHTGUN_INFO_0_BE "Налады (сэнсарнага) светлавога пісталета."
#define BSNES_ASPECT_RATIO_LABEL_BE "Пераважныя суадносіны бакоў"
#define BSNES_ASPECT_RATIO_INFO_0_BE "Выбар пераважных суадносін бакоў кантэнту. Ужываецца толькі пры выбары рэжыму суадносін бакоў 'Налада ядра' у наладах відэа RetroArch."
#define OPTION_VAL_AUTO_BE "Аўта"
#define OPTION_VAL_1_1_BE "1:1 PAR (рыхтык да пікселя)"
#define OPTION_VAL_4_3_BE NULL
#define OPTION_VAL_NTSC_BE NULL
#define OPTION_VAL_PAL_BE NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_BE "Кадраванне па вертыкалі"
#define BSNES_PPU_OVERSCAN_V_INFO_0_BE "Прыбраць N радкоў зверху ды знізу экрана для імітавання рамкі тэлевізара эпохі SNES."
#define OPTION_VAL_0_BE "0 радкоў"
#define OPTION_VAL_8_BE "8 радкоў"
#define OPTION_VAL_12_BE "12 радкоў"
#define OPTION_VAL_16_BE "16 радкоў"
#define BSNES_BLUR_EMULATION_LABEL_BE "Эмуляцыя размыцця"
#define BSNES_BLUR_EMULATION_INFO_0_BE "Імітуе абмежаванае па гарызанталі раздзяленне стандартных ТБ, размываючы гарызантальна прылеглыя пікселі. Патрабуецца для эмуляцыі эфекту празрыстасці ў некаторых гульнях."
#define BSNES_VIDEO_FILTER_LABEL_BE "Фільтр"
#define BSNES_VIDEO_FILTER_INFO_0_BE "Выбар паміж адсутнасцю фільтрацыі і NTSC-фільтрамі Blargg'а, якія імітуюць відэасігналы па RF, кампазіце, S-Video ці RGB"
#define OPTION_VAL_NONE_BE "Няма"
#define OPTION_VAL_NTSC_RF_BE NULL
#define OPTION_VAL_NTSC_COMPOSITE_BE "NTSC (кампазітны)"
#define OPTION_VAL_NTSC_S_VIDEO_BE NULL
#define OPTION_VAL_NTSC_RGB_BE NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_BE "Рэгуляванне колеру - яркасць"
#define BSNES_VIDEO_LUMINANCE_INFO_0_BE "Рэгуляваць яркасць"
#define OPTION_VAL_0_O4_BE "0 %"
#define OPTION_VAL_10_BE "10 %"
#define OPTION_VAL_20_BE "20 %"
#define OPTION_VAL_30_BE "30 %"
#define OPTION_VAL_40_BE "40 %"
#define OPTION_VAL_50_BE "50 %"
#define OPTION_VAL_60_BE "60 %"
#define OPTION_VAL_70_BE "70 %"
#define OPTION_VAL_80_BE "80 %"
#define OPTION_VAL_90_BE "90 %"
#define OPTION_VAL_100_BE "100 % (прадвызначана)"
#define BSNES_VIDEO_SATURATION_LABEL_BE "Рэгуляванне колеру - насычанасць"
#define BSNES_VIDEO_SATURATION_INFO_0_BE "Рэгуляваць насычанасць"
#define OPTION_VAL_110_BE "110 %"
#define OPTION_VAL_120_BE "120 %"
#define OPTION_VAL_130_BE "130 %"
#define OPTION_VAL_140_BE "140 %"
#define OPTION_VAL_150_BE "150 %"
#define OPTION_VAL_160_BE "160 %"
#define OPTION_VAL_170_BE "170 %"
#define OPTION_VAL_180_BE "180 %"
#define OPTION_VAL_190_BE "190 %"
#define OPTION_VAL_200_BE "200 %"
#define BSNES_VIDEO_GAMMA_LABEL_BE "Рэгуляванне колеру - гама"
#define BSNES_VIDEO_GAMMA_INFO_0_BE "Рэгуляваць гаму"
#define OPTION_VAL_100_O6_BE "100 %"
#define OPTION_VAL_150_O6_BE "150 % (прадвызначана)"
#define BSNES_PPU_FAST_LABEL_BE "PPU (Відэа) - Хуткі рэжым"
#define BSNES_PPU_FAST_LABEL_CAT_BE "PPU - Хуткі рэжым"
#define BSNES_PPU_FAST_INFO_0_BE "Паскарае эмуляцыю PPU, але нязначна змяншае дакладнасць. Рэкамендуецца пакідаць опцыю уключанай. Патрабуецца для працы налад 'Дэінтэрлейсінгу', 'Без абмежавання спрайтаў' і 'HD Mode 7'."
#define BSNES_PPU_DEINTERLACE_LABEL_BE "PPU (Відэа) - Дэінтэрлейсінг"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_BE "PPU - Дэінтэрлейсінг"
#define BSNES_PPU_DEINTERLACE_INFO_0_BE "Прыбірае празрадковасць у гульнях, запускаючы рэндэрынг ў 480p. Рэкамендуецца пакідаць уключаным, паколькі практычна не ўплывае на прадукцыйнасць."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_BE "PPU (Відэа) - Без абмежавання спрайтаў"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_BE "PPU - Без абмежавання спрайтаў"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_BE "Прыбірае любыя абмежаванні на колькасць адначасова паказаных на экране спрайтаў. Можа выклікаць памылкі ў некаторых гульнях."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_BE "PPU (Відэа) - Без блакавання VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_BE "PPU - Без блакавання VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_BE "Імітацыя памылкі старых версій ZSNES і Snes9x пры якой не эмулявалася блакіроўка VRAM. Дадзеная памылка патрабуецца для правільнай адмалёўкі графікі ў некаторых ранніх ROM хаках. Уключэнне налады вельмі пагаршае дакладнасць і змяншае хуткасць PPU, таму гэта рэкамендуецца рабіць толькі пры запуску гульняў, несумяшчальных з дадзеным ядром."
#define BSNES_DSP_FAST_LABEL_BE "DSP (Аўдыё) - Хуткі рэжым"
#define BSNES_DSP_FAST_LABEL_CAT_BE "DSP - Хуткі рэжым"
#define BSNES_DSP_FAST_INFO_0_BE "Уключае паскарэнне эмуляцыі DSP, але нязначна зніжае дакладнасць. Рэкамендуецца пакідаць наладу ўключанай."
#define BSNES_DSP_CUBIC_LABEL_BE "DSP (Аўдыё) - Кубічная інтэрпаляцыя"
#define BSNES_DSP_CUBIC_LABEL_CAT_BE "DSP - Кубічная інтэрпаляцыя"
#define BSNES_DSP_CUBIC_INFO_0_BE "Ужываць да гуку кубічную інтэрпаляцыю для больш выяўленых верхніх частот."
#define BSNES_DSP_ECHO_SHADOW_LABEL_BE "DSP (Аўдыё) - Echo Shadow RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_BE NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_BE "Эмулюе памылку ZSNES пры якой echo RAM апрацоўвалася незалежна ад APU RAM. Неабходна для правільнай працы шматлікіх ранніх ROM хакаў Super Mario World. Настройка вельмі моцна змяншае дакладнасць і павінна ўключацца толькі па неабходнасці."
#define BSNES_MODE7_SCALE_LABEL_BE "HD Mode 7 - Маштаб"
#define BSNES_MODE7_SCALE_LABEL_CAT_BE "Маштаб"
#define BSNES_MODE7_SCALE_INFO_0_BE "Падвышае гарызантальнае і вертыкальнае раздзяленне графікі Mode 7 у гульнях з падтрымкай дадзенага рэжыму."
#define OPTION_VAL_1X_BE "240p (x1)"
#define OPTION_VAL_2X_BE "480p (x2)"
#define OPTION_VAL_3X_BE "720p (x3)"
#define OPTION_VAL_4X_BE "960p (x4)"
#define OPTION_VAL_5X_BE "1200p (x5)"
#define OPTION_VAL_6X_BE "1440p (x6)"
#define OPTION_VAL_7X_BE "1680p (x7)"
#define OPTION_VAL_8X_BE "1920p (x8)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_BE "HD Mode 7 - Карэкцыя перспектывы"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_BE "Карэкцыя перспектывы"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_BE "Выпраўляе перспектывы ў гульнях, якія выкарыстоўваюць Mode 7 шляхам абыходу абмежаванняў пры аперацыях SNES з цэлымі лікамі."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_BE "HD Mode 7 - Суперсэмплінг"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_BE "Суперсэмплінг"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_BE "Уключае суперсэмплінг графікі Mode 7 у гульнях з падтрымкай дадзенага рэжыму. У камбінацыі са зменай маштабу Mode 7 забяспечвае эфект, падобны са згладжваннем."
#define BSNES_MODE7_MOSAIC_LABEL_BE "HD Mode 7 - HD->SD Мазаіка"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_BE "HD->SD Мазаіка"
#define BSNES_MODE7_MOSAIC_INFO_0_BE "Адлюстроўваць эфект мазаікі нават пры апскейлінгу графікі ў Mode 7."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_BE "Убудаванае забяганне"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_BE "Эмуляцыя сістэмы з апярэджаннем і наступным адкатам для памяншэння затрымкі ўводу. Высокія сістэмныя патрабаванні."
#define OPTION_VAL_1_BE "1 кадр"
#define OPTION_VAL_2_BE "2 кадры"
#define OPTION_VAL_3_BE "3 кадры"
#define OPTION_VAL_4_BE "4 кадры"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_BE "Супрацэсар - Хуткі рэжым"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_BE "Уключае паскарэнне эмуляцыі супрацэсараў, але нязначна зніжае дакладнасць. Рэкамендуецца пакінуць наладу ўключанай."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_BE "Супрацэсары - Аддаваць перавагу HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_BE "Пры ўключэнні наладкі выкарыстоўваецца менш дакладная HLE-эмуляцыя. Калі адключана, HLE будзе выкарыстоўвацца толькі пры адсутнасці LLE-прашыўкі."
#define BSNES_HOTFIXES_LABEL_BE "Выпраўленні"
#define BSNES_HOTFIXES_INFO_0_BE "Нават камерцыйнае праграмнае забеспячэнне можа мець памылкі. Дадзеная опцыя выпраўляе некаторыя крытычныя багі, якія маюць месца на рэальным абсталяванні."
#define BSNES_ENTROPY_LABEL_BE "Энтрапія (рандамізацыя)"
#define BSNES_ENTROPY_INFO_0_BE "Ступень рандамізацыі памяці і рэгістраў. Калі адключана, пры запуску памяць і рэгістры прымаюць пастаянныя значэнні. Нізкая рандамізацыя найбольш дакладна прайгравае паводзіны рэальнай сістэмы. Высокая рандамізуе максімальна."
#define OPTION_VAL_LOW_BE "Нізкая"
#define OPTION_VAL_HIGH_BE "Высокая"
#define BSNES_CPU_FASTMATH_LABEL_BE "Паскарэнне вылічэнняў CPU"
#define BSNES_CPU_FASTMATH_INFO_0_BE "Забяспечвае неадкладныя вынікі вылічэнняў. Аперацыі складання і дзялення на рэальнай SNES займаюць вызначаны час. Састарэлыя эмулятары не імітавалі гэтыя затрымкі і таму раннія ROM хакі не чакаюць завяршэння матэматычных аперацый і патрабуюць уключэнні дадзенай налады."
#define BSNES_CPU_OVERCLOCK_LABEL_BE "Разгон - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_BE NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_BE "Разгон або запаволенне CPU. Устаноўка значэння вышэй за 100% дазваляе зменшыць час загрузак і пазбавіцца запаволення ў гульнях. Выкарыстоўвайце з асцярожнасцю з прычыны выяўлення іншых памылак ці збояў."
#define OPTION_VAL_210_BE "210 %"
#define OPTION_VAL_220_BE "220 %"
#define OPTION_VAL_230_BE "230 %"
#define OPTION_VAL_240_BE "240 %"
#define OPTION_VAL_250_BE "250 %"
#define OPTION_VAL_260_BE "260 %"
#define OPTION_VAL_270_BE "270 %"
#define OPTION_VAL_280_BE "280 %"
#define OPTION_VAL_290_BE "290 %"
#define OPTION_VAL_300_BE "300 %"
#define OPTION_VAL_310_BE "310 %"
#define OPTION_VAL_320_BE "320 %"
#define OPTION_VAL_330_BE "330 %"
#define OPTION_VAL_340_BE "340 %"
#define OPTION_VAL_350_BE "350 %"
#define OPTION_VAL_360_BE "360 %"
#define OPTION_VAL_370_BE "370 %"
#define OPTION_VAL_380_BE "380 %"
#define OPTION_VAL_390_BE "390 %"
#define OPTION_VAL_400_BE "400 %"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_BE "Разгон - Супрацэсара SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_BE "Супрацэсар SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_BE "Разгон або запаволенне чыпа Super Accelerator (SA-1). Устаноўка значэння вышэй за 100% паляпшае прадукцыйнасць у гульнях з падтрымкай чыпа SA-1. Выкарыстоўвайце з асцярожнасцю з прычыны выяўлення іншых памылак ці збояў."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_BE "Разгон - Супрацэсара SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_BE "Супрацэсар SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_BE "Разгон або запаволенне чыпа SuperFX. Устаноўка значэння вышэй за 100% паляпшае прадукцыйнасць у гульнях з падтрымкай чыпа SuperFX. Выкарыстоўвайце з асцярожнасцю з прычыны выяўлення іншых памылак ці збояў."
#define OPTION_VAL_410_BE "410 %"
#define OPTION_VAL_420_BE "420 %"
#define OPTION_VAL_430_BE "430 %"
#define OPTION_VAL_440_BE "440 %"
#define OPTION_VAL_450_BE "450 %"
#define OPTION_VAL_460_BE "460 %"
#define OPTION_VAL_470_BE "470 %"
#define OPTION_VAL_480_BE "480 %"
#define OPTION_VAL_490_BE "490 %"
#define OPTION_VAL_500_BE "500 %"
#define OPTION_VAL_510_BE "510 %"
#define OPTION_VAL_520_BE "520 %"
#define OPTION_VAL_530_BE "530 %"
#define OPTION_VAL_540_BE "540 %"
#define OPTION_VAL_550_BE "550 %"
#define OPTION_VAL_560_BE "560 %"
#define OPTION_VAL_570_BE "570 %"
#define OPTION_VAL_580_BE "580 %"
#define OPTION_VAL_590_BE "590 %"
#define OPTION_VAL_600_BE "600 %"
#define OPTION_VAL_610_BE "610 %"
#define OPTION_VAL_620_BE "620 %"
#define OPTION_VAL_630_BE "630 %"
#define OPTION_VAL_640_BE "640 %"
#define OPTION_VAL_650_BE "650 %"
#define OPTION_VAL_660_BE "660 %"
#define OPTION_VAL_670_BE "670 %"
#define OPTION_VAL_680_BE "680 %"
#define OPTION_VAL_690_BE "690 %"
#define OPTION_VAL_700_BE "700 %"
#define OPTION_VAL_710_BE "710 %"
#define OPTION_VAL_720_BE "720 %"
#define OPTION_VAL_730_BE "730 %"
#define OPTION_VAL_740_BE "740 %"
#define OPTION_VAL_750_BE "750 %"
#define OPTION_VAL_760_BE "760 %"
#define OPTION_VAL_770_BE "770 %"
#define OPTION_VAL_780_BE "780 %"
#define OPTION_VAL_790_BE "790 %"
#define OPTION_VAL_800_BE "800 %"
#define BSNES_SGB_BIOS_LABEL_BE "Выбар BIOS Super Game Boy (патрабуецца перазапуск)"
#define BSNES_SGB_BIOS_INFO_0_BE "Ўстаноўка BIOS, які выкарыстоўваецца для сумяшчальных гульняў Super Game Boy."
#define OPTION_VAL_SGB1_SFC_BE NULL
#define OPTION_VAL_SGB2_SFC_BE NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_BE "Хаваць рамку SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_BE "Схаваць рамку пры запуску гульняў Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_BE "Сэнсарны светлавы пісталет"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_BE "Уключыць эмуляцыю Super Scope з дапамогай сэнсарнага экрана прылады."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_BE "Памяняць кнопкі куркоў Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_BE "Змяняе месцамі кнопкі трыгера і паказальніка Super Scope для сэнсарнага светлавога пісталета."

struct retro_core_option_v2_category option_cats_be[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_BE,
      CATEGORY_VIDEO_INFO_0_BE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_BE,
      CATEGORY_AUDIO_INFO_0_BE
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_BE,
      CATEGORY_MODE7_INFO_0_BE
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_BE,
      CATEGORY_HACK_INFO_0_BE
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_BE,
      CATEGORY_OVERCLOCK_INFO_0_BE
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_BE,
      CATEGORY_SGB_INFO_0_BE
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_BE,
      CATEGORY_LIGHTGUN_INFO_0_BE
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_be[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_BE,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_BE,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_BE },
         { "1:1",  OPTION_VAL_1_1_BE },
         { "4:3",  OPTION_VAL_4_3_BE },
         { "NTSC", OPTION_VAL_NTSC_BE },
         { "PAL",  OPTION_VAL_PAL_BE },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_BE,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_BE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_BE },
         { "8",  OPTION_VAL_8_BE },
         { "12", OPTION_VAL_12_BE },
         { "16", OPTION_VAL_16_BE },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_BE,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_BE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_BE,
      BSNES_VIDEO_FILTER_LABEL_BE,
      BSNES_VIDEO_FILTER_INFO_0_BE,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_BE },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_BE },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_BE },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_BE },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_BE },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_BE,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_BE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_BE },
         { "10", OPTION_VAL_10_BE },
         { "20", OPTION_VAL_20_BE },
         { "30", OPTION_VAL_30_BE },
         { "40", OPTION_VAL_40_BE },
         { "50", OPTION_VAL_50_BE },
         { "60", OPTION_VAL_60_BE },
         { "70", OPTION_VAL_70_BE },
         { "80", OPTION_VAL_80_BE },
         { "90", OPTION_VAL_90_BE },
         { "100", OPTION_VAL_100_BE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_BE,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_BE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_BE },
         { "10", OPTION_VAL_10_BE },
         { "20", OPTION_VAL_20_BE },
         { "30", OPTION_VAL_30_BE },
         { "40", OPTION_VAL_40_BE },
         { "50", OPTION_VAL_50_BE },
         { "60", OPTION_VAL_60_BE },
         { "70", OPTION_VAL_70_BE },
         { "80", OPTION_VAL_80_BE },
         { "90", OPTION_VAL_90_BE },
         { "100", OPTION_VAL_100_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_BE,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_BE,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_O6_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_BE,
      BSNES_PPU_FAST_LABEL_CAT_BE,
      BSNES_PPU_FAST_INFO_0_BE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_BE,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_BE,
      BSNES_PPU_DEINTERLACE_INFO_0_BE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_BE,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_BE,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_BE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_BE,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_BE,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_BE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_BE,
      BSNES_DSP_FAST_LABEL_CAT_BE,
      BSNES_DSP_FAST_INFO_0_BE,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_BE,
      BSNES_DSP_CUBIC_LABEL_CAT_BE,
      BSNES_DSP_CUBIC_INFO_0_BE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_BE,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_BE,
      BSNES_DSP_ECHO_SHADOW_INFO_0_BE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_BE,
      BSNES_MODE7_SCALE_LABEL_CAT_BE,
      BSNES_MODE7_SCALE_INFO_0_BE,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_BE  },
         { "2x", OPTION_VAL_2X_BE  },
         { "3x", OPTION_VAL_3X_BE  },
         { "4x", OPTION_VAL_4X_BE  },
         { "5x", OPTION_VAL_5X_BE },
         { "6x", OPTION_VAL_6X_BE },
         { "7x", OPTION_VAL_7X_BE },
         { "8x", OPTION_VAL_8X_BE },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_BE,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_BE,
      BSNES_MODE7_PERSPECTIVE_INFO_0_BE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_BE,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_BE,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_BE,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_BE,
      BSNES_MODE7_MOSAIC_LABEL_CAT_BE,
      BSNES_MODE7_MOSAIC_INFO_0_BE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_BE,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_BE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_BE  },
         { "2",   OPTION_VAL_2_BE },
         { "3",   OPTION_VAL_3_BE },
         { "4",   OPTION_VAL_4_BE },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_BE,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_BE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_BE,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_BE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_BE,
      NULL,
      BSNES_HOTFIXES_INFO_0_BE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_BE,
      NULL,
      BSNES_ENTROPY_INFO_0_BE,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_BE },
         { "High", OPTION_VAL_HIGH_BE },
         { "None", OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_BE,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_BE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_BE,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_BE,
      BSNES_CPU_OVERCLOCK_INFO_0_BE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BE  },
         { "20",  OPTION_VAL_20_BE  },
         { "30",  OPTION_VAL_30_BE  },
         { "40",  OPTION_VAL_40_BE  },
         { "50",  OPTION_VAL_50_BE  },
         { "60",  OPTION_VAL_60_BE  },
         { "70",  OPTION_VAL_70_BE  },
         { "80",  OPTION_VAL_80_BE  },
         { "90",  OPTION_VAL_90_BE  },
         { "100", OPTION_VAL_100_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { "210", OPTION_VAL_210_BE },
         { "220", OPTION_VAL_220_BE },
         { "230", OPTION_VAL_230_BE },
         { "240", OPTION_VAL_240_BE },
         { "250", OPTION_VAL_250_BE },
         { "260", OPTION_VAL_260_BE },
         { "270", OPTION_VAL_270_BE },
         { "280", OPTION_VAL_280_BE },
         { "290", OPTION_VAL_290_BE },
         { "300", OPTION_VAL_300_BE },
         { "310", OPTION_VAL_310_BE },
         { "320", OPTION_VAL_320_BE },
         { "330", OPTION_VAL_330_BE },
         { "340", OPTION_VAL_340_BE },
         { "350", OPTION_VAL_350_BE },
         { "360", OPTION_VAL_360_BE },
         { "370", OPTION_VAL_370_BE },
         { "380", OPTION_VAL_380_BE },
         { "390", OPTION_VAL_390_BE },
         { "400", OPTION_VAL_400_BE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_BE,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_BE,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_BE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BE  },
         { "20",  OPTION_VAL_20_BE  },
         { "30",  OPTION_VAL_30_BE  },
         { "40",  OPTION_VAL_40_BE  },
         { "50",  OPTION_VAL_50_BE  },
         { "60",  OPTION_VAL_60_BE  },
         { "70",  OPTION_VAL_70_BE  },
         { "80",  OPTION_VAL_80_BE  },
         { "90",  OPTION_VAL_90_BE  },
         { "100", OPTION_VAL_100_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { "210", OPTION_VAL_210_BE },
         { "220", OPTION_VAL_220_BE },
         { "230", OPTION_VAL_230_BE },
         { "240", OPTION_VAL_240_BE },
         { "250", OPTION_VAL_250_BE },
         { "260", OPTION_VAL_260_BE },
         { "270", OPTION_VAL_270_BE },
         { "280", OPTION_VAL_280_BE },
         { "290", OPTION_VAL_290_BE },
         { "300", OPTION_VAL_300_BE },
         { "310", OPTION_VAL_310_BE },
         { "320", OPTION_VAL_320_BE },
         { "330", OPTION_VAL_330_BE },
         { "340", OPTION_VAL_340_BE },
         { "350", OPTION_VAL_350_BE },
         { "360", OPTION_VAL_360_BE },
         { "370", OPTION_VAL_370_BE },
         { "380", OPTION_VAL_380_BE },
         { "390", OPTION_VAL_390_BE },
         { "400", OPTION_VAL_400_BE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_BE,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_BE,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_BE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BE  },
         { "20",  OPTION_VAL_20_BE  },
         { "30",  OPTION_VAL_30_BE  },
         { "40",  OPTION_VAL_40_BE  },
         { "50",  OPTION_VAL_50_BE  },
         { "60",  OPTION_VAL_60_BE  },
         { "70",  OPTION_VAL_70_BE  },
         { "80",  OPTION_VAL_80_BE  },
         { "90",  OPTION_VAL_90_BE  },
         { "100", OPTION_VAL_100_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { "210", OPTION_VAL_210_BE },
         { "220", OPTION_VAL_220_BE },
         { "230", OPTION_VAL_230_BE },
         { "240", OPTION_VAL_240_BE },
         { "250", OPTION_VAL_250_BE },
         { "260", OPTION_VAL_260_BE },
         { "270", OPTION_VAL_270_BE },
         { "280", OPTION_VAL_280_BE },
         { "290", OPTION_VAL_290_BE },
         { "300", OPTION_VAL_300_BE },
         { "310", OPTION_VAL_310_BE },
         { "320", OPTION_VAL_320_BE },
         { "330", OPTION_VAL_330_BE },
         { "340", OPTION_VAL_340_BE },
         { "350", OPTION_VAL_350_BE },
         { "360", OPTION_VAL_360_BE },
         { "370", OPTION_VAL_370_BE },
         { "380", OPTION_VAL_380_BE },
         { "390", OPTION_VAL_390_BE },
         { "400", OPTION_VAL_400_BE },
         { "410", OPTION_VAL_410_BE },
         { "420", OPTION_VAL_420_BE },
         { "430", OPTION_VAL_430_BE },
         { "440", OPTION_VAL_440_BE },
         { "450", OPTION_VAL_450_BE },
         { "460", OPTION_VAL_460_BE },
         { "470", OPTION_VAL_470_BE },
         { "480", OPTION_VAL_480_BE },
         { "490", OPTION_VAL_490_BE },
         { "500", OPTION_VAL_500_BE },
         { "510", OPTION_VAL_510_BE },
         { "520", OPTION_VAL_520_BE },
         { "530", OPTION_VAL_530_BE },
         { "540", OPTION_VAL_540_BE },
         { "550", OPTION_VAL_550_BE },
         { "560", OPTION_VAL_560_BE },
         { "570", OPTION_VAL_570_BE },
         { "580", OPTION_VAL_580_BE },
         { "590", OPTION_VAL_590_BE },
         { "600", OPTION_VAL_600_BE },
         { "610", OPTION_VAL_610_BE },
         { "620", OPTION_VAL_620_BE },
         { "630", OPTION_VAL_630_BE },
         { "640", OPTION_VAL_640_BE },
         { "650", OPTION_VAL_650_BE },
         { "660", OPTION_VAL_660_BE },
         { "670", OPTION_VAL_670_BE },
         { "680", OPTION_VAL_680_BE },
         { "690", OPTION_VAL_690_BE },
         { "700", OPTION_VAL_700_BE },
         { "710", OPTION_VAL_710_BE },
         { "720", OPTION_VAL_720_BE },
         { "730", OPTION_VAL_730_BE },
         { "740", OPTION_VAL_740_BE },
         { "750", OPTION_VAL_750_BE },
         { "760", OPTION_VAL_760_BE },
         { "770", OPTION_VAL_770_BE },
         { "780", OPTION_VAL_780_BE },
         { "790", OPTION_VAL_790_BE },
         { "800", OPTION_VAL_800_BE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_BE,
      NULL,
      BSNES_SGB_BIOS_INFO_0_BE,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_BE   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_BE },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_BE,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_BE,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_BE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_BE,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_BE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_BE,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_be = {
   option_cats_be,
   option_defs_be
};

/* RETRO_LANGUAGE_BG */

#define CATEGORY_VIDEO_LABEL_BG "Видео"
#define CATEGORY_VIDEO_INFO_0_BG NULL
#define CATEGORY_AUDIO_LABEL_BG "Звук"
#define CATEGORY_AUDIO_INFO_0_BG NULL
#define CATEGORY_MODE7_LABEL_BG NULL
#define CATEGORY_MODE7_INFO_0_BG NULL
#define CATEGORY_HACK_LABEL_BG NULL
#define CATEGORY_HACK_INFO_0_BG NULL
#define CATEGORY_OVERCLOCK_LABEL_BG NULL
#define CATEGORY_OVERCLOCK_INFO_0_BG NULL
#define CATEGORY_SGB_LABEL_BG NULL
#define CATEGORY_SGB_INFO_0_BG NULL
#define CATEGORY_LIGHTGUN_LABEL_BG NULL
#define CATEGORY_LIGHTGUN_INFO_0_BG NULL
#define BSNES_ASPECT_RATIO_LABEL_BG NULL
#define BSNES_ASPECT_RATIO_INFO_0_BG NULL
#define OPTION_VAL_AUTO_BG NULL
#define OPTION_VAL_1_1_BG NULL
#define OPTION_VAL_4_3_BG NULL
#define OPTION_VAL_NTSC_BG NULL
#define OPTION_VAL_PAL_BG NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_BG NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_BG NULL
#define OPTION_VAL_0_BG NULL
#define OPTION_VAL_8_BG NULL
#define OPTION_VAL_12_BG NULL
#define OPTION_VAL_16_BG NULL
#define BSNES_BLUR_EMULATION_LABEL_BG NULL
#define BSNES_BLUR_EMULATION_INFO_0_BG NULL
#define BSNES_VIDEO_FILTER_LABEL_BG NULL
#define BSNES_VIDEO_FILTER_INFO_0_BG NULL
#define OPTION_VAL_NONE_BG NULL
#define OPTION_VAL_NTSC_RF_BG NULL
#define OPTION_VAL_NTSC_COMPOSITE_BG NULL
#define OPTION_VAL_NTSC_S_VIDEO_BG NULL
#define OPTION_VAL_NTSC_RGB_BG NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_BG NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_BG NULL
#define OPTION_VAL_0_O4_BG NULL
#define OPTION_VAL_10_BG NULL
#define OPTION_VAL_20_BG NULL
#define OPTION_VAL_30_BG NULL
#define OPTION_VAL_40_BG NULL
#define OPTION_VAL_50_BG NULL
#define OPTION_VAL_60_BG NULL
#define OPTION_VAL_70_BG NULL
#define OPTION_VAL_80_BG NULL
#define OPTION_VAL_90_BG NULL
#define OPTION_VAL_100_BG NULL
#define BSNES_VIDEO_SATURATION_LABEL_BG NULL
#define BSNES_VIDEO_SATURATION_INFO_0_BG NULL
#define OPTION_VAL_110_BG NULL
#define OPTION_VAL_120_BG NULL
#define OPTION_VAL_130_BG NULL
#define OPTION_VAL_140_BG NULL
#define OPTION_VAL_150_BG NULL
#define OPTION_VAL_160_BG NULL
#define OPTION_VAL_170_BG NULL
#define OPTION_VAL_180_BG NULL
#define OPTION_VAL_190_BG NULL
#define OPTION_VAL_200_BG NULL
#define BSNES_VIDEO_GAMMA_LABEL_BG NULL
#define BSNES_VIDEO_GAMMA_INFO_0_BG NULL
#define OPTION_VAL_100_O6_BG NULL
#define OPTION_VAL_150_O6_BG NULL
#define BSNES_PPU_FAST_LABEL_BG NULL
#define BSNES_PPU_FAST_LABEL_CAT_BG NULL
#define BSNES_PPU_FAST_INFO_0_BG NULL
#define BSNES_PPU_DEINTERLACE_LABEL_BG NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_BG NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_BG NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_BG NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_BG NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_BG NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_BG NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_BG NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_BG NULL
#define BSNES_DSP_FAST_LABEL_BG NULL
#define BSNES_DSP_FAST_LABEL_CAT_BG NULL
#define BSNES_DSP_FAST_INFO_0_BG NULL
#define BSNES_DSP_CUBIC_LABEL_BG NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_BG NULL
#define BSNES_DSP_CUBIC_INFO_0_BG NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_BG NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_BG NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_BG NULL
#define BSNES_MODE7_SCALE_LABEL_BG NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_BG NULL
#define BSNES_MODE7_SCALE_INFO_0_BG NULL
#define OPTION_VAL_1X_BG NULL
#define OPTION_VAL_2X_BG NULL
#define OPTION_VAL_3X_BG NULL
#define OPTION_VAL_4X_BG NULL
#define OPTION_VAL_5X_BG NULL
#define OPTION_VAL_6X_BG NULL
#define OPTION_VAL_7X_BG NULL
#define OPTION_VAL_8X_BG NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_BG NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_BG NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_BG NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_BG NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_BG NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_BG NULL
#define BSNES_MODE7_MOSAIC_LABEL_BG NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_BG NULL
#define BSNES_MODE7_MOSAIC_INFO_0_BG NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_BG NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_BG NULL
#define OPTION_VAL_1_BG NULL
#define OPTION_VAL_2_BG NULL
#define OPTION_VAL_3_BG NULL
#define OPTION_VAL_4_BG NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_BG NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_BG NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_BG NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_BG NULL
#define BSNES_HOTFIXES_LABEL_BG NULL
#define BSNES_HOTFIXES_INFO_0_BG NULL
#define BSNES_ENTROPY_LABEL_BG NULL
#define BSNES_ENTROPY_INFO_0_BG NULL
#define OPTION_VAL_LOW_BG NULL
#define OPTION_VAL_HIGH_BG NULL
#define BSNES_CPU_FASTMATH_LABEL_BG NULL
#define BSNES_CPU_FASTMATH_INFO_0_BG NULL
#define BSNES_CPU_OVERCLOCK_LABEL_BG NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_BG NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_BG NULL
#define OPTION_VAL_210_BG NULL
#define OPTION_VAL_220_BG NULL
#define OPTION_VAL_230_BG NULL
#define OPTION_VAL_240_BG NULL
#define OPTION_VAL_250_BG NULL
#define OPTION_VAL_260_BG NULL
#define OPTION_VAL_270_BG NULL
#define OPTION_VAL_280_BG NULL
#define OPTION_VAL_290_BG NULL
#define OPTION_VAL_300_BG NULL
#define OPTION_VAL_310_BG NULL
#define OPTION_VAL_320_BG NULL
#define OPTION_VAL_330_BG NULL
#define OPTION_VAL_340_BG NULL
#define OPTION_VAL_350_BG NULL
#define OPTION_VAL_360_BG NULL
#define OPTION_VAL_370_BG NULL
#define OPTION_VAL_380_BG NULL
#define OPTION_VAL_390_BG NULL
#define OPTION_VAL_400_BG NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_BG NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_BG NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_BG NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_BG NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_BG NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_BG NULL
#define OPTION_VAL_410_BG NULL
#define OPTION_VAL_420_BG NULL
#define OPTION_VAL_430_BG NULL
#define OPTION_VAL_440_BG NULL
#define OPTION_VAL_450_BG NULL
#define OPTION_VAL_460_BG NULL
#define OPTION_VAL_470_BG NULL
#define OPTION_VAL_480_BG NULL
#define OPTION_VAL_490_BG NULL
#define OPTION_VAL_500_BG NULL
#define OPTION_VAL_510_BG NULL
#define OPTION_VAL_520_BG NULL
#define OPTION_VAL_530_BG NULL
#define OPTION_VAL_540_BG NULL
#define OPTION_VAL_550_BG NULL
#define OPTION_VAL_560_BG NULL
#define OPTION_VAL_570_BG NULL
#define OPTION_VAL_580_BG NULL
#define OPTION_VAL_590_BG NULL
#define OPTION_VAL_600_BG NULL
#define OPTION_VAL_610_BG NULL
#define OPTION_VAL_620_BG NULL
#define OPTION_VAL_630_BG NULL
#define OPTION_VAL_640_BG NULL
#define OPTION_VAL_650_BG NULL
#define OPTION_VAL_660_BG NULL
#define OPTION_VAL_670_BG NULL
#define OPTION_VAL_680_BG NULL
#define OPTION_VAL_690_BG NULL
#define OPTION_VAL_700_BG NULL
#define OPTION_VAL_710_BG NULL
#define OPTION_VAL_720_BG NULL
#define OPTION_VAL_730_BG NULL
#define OPTION_VAL_740_BG NULL
#define OPTION_VAL_750_BG NULL
#define OPTION_VAL_760_BG NULL
#define OPTION_VAL_770_BG NULL
#define OPTION_VAL_780_BG NULL
#define OPTION_VAL_790_BG NULL
#define OPTION_VAL_800_BG NULL
#define BSNES_SGB_BIOS_LABEL_BG NULL
#define BSNES_SGB_BIOS_INFO_0_BG NULL
#define OPTION_VAL_SGB1_SFC_BG NULL
#define OPTION_VAL_SGB2_SFC_BG NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_BG NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_BG NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_BG NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_BG NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_BG NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_BG NULL

struct retro_core_option_v2_category option_cats_bg[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_BG,
      CATEGORY_VIDEO_INFO_0_BG
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_BG,
      CATEGORY_AUDIO_INFO_0_BG
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_BG,
      CATEGORY_MODE7_INFO_0_BG
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_BG,
      CATEGORY_HACK_INFO_0_BG
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_BG,
      CATEGORY_OVERCLOCK_INFO_0_BG
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_BG,
      CATEGORY_SGB_INFO_0_BG
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_BG,
      CATEGORY_LIGHTGUN_INFO_0_BG
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_bg[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_BG,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_BG,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_BG },
         { "1:1",  OPTION_VAL_1_1_BG },
         { "4:3",  OPTION_VAL_4_3_BG },
         { "NTSC", OPTION_VAL_NTSC_BG },
         { "PAL",  OPTION_VAL_PAL_BG },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_BG,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_BG,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_BG },
         { "8",  OPTION_VAL_8_BG },
         { "12", OPTION_VAL_12_BG },
         { "16", OPTION_VAL_16_BG },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_BG,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_BG,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_BG,
      BSNES_VIDEO_FILTER_LABEL_BG,
      BSNES_VIDEO_FILTER_INFO_0_BG,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_BG },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_BG },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_BG },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_BG },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_BG },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_BG,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_BG,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_BG },
         { "10", OPTION_VAL_10_BG },
         { "20", OPTION_VAL_20_BG },
         { "30", OPTION_VAL_30_BG },
         { "40", OPTION_VAL_40_BG },
         { "50", OPTION_VAL_50_BG },
         { "60", OPTION_VAL_60_BG },
         { "70", OPTION_VAL_70_BG },
         { "80", OPTION_VAL_80_BG },
         { "90", OPTION_VAL_90_BG },
         { "100", OPTION_VAL_100_BG },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_BG,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_BG,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_BG },
         { "10", OPTION_VAL_10_BG },
         { "20", OPTION_VAL_20_BG },
         { "30", OPTION_VAL_30_BG },
         { "40", OPTION_VAL_40_BG },
         { "50", OPTION_VAL_50_BG },
         { "60", OPTION_VAL_60_BG },
         { "70", OPTION_VAL_70_BG },
         { "80", OPTION_VAL_80_BG },
         { "90", OPTION_VAL_90_BG },
         { "100", OPTION_VAL_100_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_BG,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_BG,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_O6_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_BG,
      BSNES_PPU_FAST_LABEL_CAT_BG,
      BSNES_PPU_FAST_INFO_0_BG,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_BG,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_BG,
      BSNES_PPU_DEINTERLACE_INFO_0_BG,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_BG,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_BG,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_BG,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_BG,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_BG,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_BG,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_BG,
      BSNES_DSP_FAST_LABEL_CAT_BG,
      BSNES_DSP_FAST_INFO_0_BG,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_BG,
      BSNES_DSP_CUBIC_LABEL_CAT_BG,
      BSNES_DSP_CUBIC_INFO_0_BG,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_BG,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_BG,
      BSNES_DSP_ECHO_SHADOW_INFO_0_BG,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_BG,
      BSNES_MODE7_SCALE_LABEL_CAT_BG,
      BSNES_MODE7_SCALE_INFO_0_BG,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_BG  },
         { "2x", OPTION_VAL_2X_BG  },
         { "3x", OPTION_VAL_3X_BG  },
         { "4x", OPTION_VAL_4X_BG  },
         { "5x", OPTION_VAL_5X_BG },
         { "6x", OPTION_VAL_6X_BG },
         { "7x", OPTION_VAL_7X_BG },
         { "8x", OPTION_VAL_8X_BG },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_BG,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_BG,
      BSNES_MODE7_PERSPECTIVE_INFO_0_BG,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_BG,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_BG,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_BG,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_BG,
      BSNES_MODE7_MOSAIC_LABEL_CAT_BG,
      BSNES_MODE7_MOSAIC_INFO_0_BG,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_BG,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_BG,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_BG  },
         { "2",   OPTION_VAL_2_BG },
         { "3",   OPTION_VAL_3_BG },
         { "4",   OPTION_VAL_4_BG },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_BG,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_BG,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_BG,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_BG,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_BG,
      NULL,
      BSNES_HOTFIXES_INFO_0_BG,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_BG,
      NULL,
      BSNES_ENTROPY_INFO_0_BG,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_BG },
         { "High", OPTION_VAL_HIGH_BG },
         { "None", OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_BG,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_BG,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_BG,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_BG,
      BSNES_CPU_OVERCLOCK_INFO_0_BG,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BG  },
         { "20",  OPTION_VAL_20_BG  },
         { "30",  OPTION_VAL_30_BG  },
         { "40",  OPTION_VAL_40_BG  },
         { "50",  OPTION_VAL_50_BG  },
         { "60",  OPTION_VAL_60_BG  },
         { "70",  OPTION_VAL_70_BG  },
         { "80",  OPTION_VAL_80_BG  },
         { "90",  OPTION_VAL_90_BG  },
         { "100", OPTION_VAL_100_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { "210", OPTION_VAL_210_BG },
         { "220", OPTION_VAL_220_BG },
         { "230", OPTION_VAL_230_BG },
         { "240", OPTION_VAL_240_BG },
         { "250", OPTION_VAL_250_BG },
         { "260", OPTION_VAL_260_BG },
         { "270", OPTION_VAL_270_BG },
         { "280", OPTION_VAL_280_BG },
         { "290", OPTION_VAL_290_BG },
         { "300", OPTION_VAL_300_BG },
         { "310", OPTION_VAL_310_BG },
         { "320", OPTION_VAL_320_BG },
         { "330", OPTION_VAL_330_BG },
         { "340", OPTION_VAL_340_BG },
         { "350", OPTION_VAL_350_BG },
         { "360", OPTION_VAL_360_BG },
         { "370", OPTION_VAL_370_BG },
         { "380", OPTION_VAL_380_BG },
         { "390", OPTION_VAL_390_BG },
         { "400", OPTION_VAL_400_BG },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_BG,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_BG,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_BG,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BG  },
         { "20",  OPTION_VAL_20_BG  },
         { "30",  OPTION_VAL_30_BG  },
         { "40",  OPTION_VAL_40_BG  },
         { "50",  OPTION_VAL_50_BG  },
         { "60",  OPTION_VAL_60_BG  },
         { "70",  OPTION_VAL_70_BG  },
         { "80",  OPTION_VAL_80_BG  },
         { "90",  OPTION_VAL_90_BG  },
         { "100", OPTION_VAL_100_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { "210", OPTION_VAL_210_BG },
         { "220", OPTION_VAL_220_BG },
         { "230", OPTION_VAL_230_BG },
         { "240", OPTION_VAL_240_BG },
         { "250", OPTION_VAL_250_BG },
         { "260", OPTION_VAL_260_BG },
         { "270", OPTION_VAL_270_BG },
         { "280", OPTION_VAL_280_BG },
         { "290", OPTION_VAL_290_BG },
         { "300", OPTION_VAL_300_BG },
         { "310", OPTION_VAL_310_BG },
         { "320", OPTION_VAL_320_BG },
         { "330", OPTION_VAL_330_BG },
         { "340", OPTION_VAL_340_BG },
         { "350", OPTION_VAL_350_BG },
         { "360", OPTION_VAL_360_BG },
         { "370", OPTION_VAL_370_BG },
         { "380", OPTION_VAL_380_BG },
         { "390", OPTION_VAL_390_BG },
         { "400", OPTION_VAL_400_BG },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_BG,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_BG,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_BG,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_BG  },
         { "20",  OPTION_VAL_20_BG  },
         { "30",  OPTION_VAL_30_BG  },
         { "40",  OPTION_VAL_40_BG  },
         { "50",  OPTION_VAL_50_BG  },
         { "60",  OPTION_VAL_60_BG  },
         { "70",  OPTION_VAL_70_BG  },
         { "80",  OPTION_VAL_80_BG  },
         { "90",  OPTION_VAL_90_BG  },
         { "100", OPTION_VAL_100_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { "210", OPTION_VAL_210_BG },
         { "220", OPTION_VAL_220_BG },
         { "230", OPTION_VAL_230_BG },
         { "240", OPTION_VAL_240_BG },
         { "250", OPTION_VAL_250_BG },
         { "260", OPTION_VAL_260_BG },
         { "270", OPTION_VAL_270_BG },
         { "280", OPTION_VAL_280_BG },
         { "290", OPTION_VAL_290_BG },
         { "300", OPTION_VAL_300_BG },
         { "310", OPTION_VAL_310_BG },
         { "320", OPTION_VAL_320_BG },
         { "330", OPTION_VAL_330_BG },
         { "340", OPTION_VAL_340_BG },
         { "350", OPTION_VAL_350_BG },
         { "360", OPTION_VAL_360_BG },
         { "370", OPTION_VAL_370_BG },
         { "380", OPTION_VAL_380_BG },
         { "390", OPTION_VAL_390_BG },
         { "400", OPTION_VAL_400_BG },
         { "410", OPTION_VAL_410_BG },
         { "420", OPTION_VAL_420_BG },
         { "430", OPTION_VAL_430_BG },
         { "440", OPTION_VAL_440_BG },
         { "450", OPTION_VAL_450_BG },
         { "460", OPTION_VAL_460_BG },
         { "470", OPTION_VAL_470_BG },
         { "480", OPTION_VAL_480_BG },
         { "490", OPTION_VAL_490_BG },
         { "500", OPTION_VAL_500_BG },
         { "510", OPTION_VAL_510_BG },
         { "520", OPTION_VAL_520_BG },
         { "530", OPTION_VAL_530_BG },
         { "540", OPTION_VAL_540_BG },
         { "550", OPTION_VAL_550_BG },
         { "560", OPTION_VAL_560_BG },
         { "570", OPTION_VAL_570_BG },
         { "580", OPTION_VAL_580_BG },
         { "590", OPTION_VAL_590_BG },
         { "600", OPTION_VAL_600_BG },
         { "610", OPTION_VAL_610_BG },
         { "620", OPTION_VAL_620_BG },
         { "630", OPTION_VAL_630_BG },
         { "640", OPTION_VAL_640_BG },
         { "650", OPTION_VAL_650_BG },
         { "660", OPTION_VAL_660_BG },
         { "670", OPTION_VAL_670_BG },
         { "680", OPTION_VAL_680_BG },
         { "690", OPTION_VAL_690_BG },
         { "700", OPTION_VAL_700_BG },
         { "710", OPTION_VAL_710_BG },
         { "720", OPTION_VAL_720_BG },
         { "730", OPTION_VAL_730_BG },
         { "740", OPTION_VAL_740_BG },
         { "750", OPTION_VAL_750_BG },
         { "760", OPTION_VAL_760_BG },
         { "770", OPTION_VAL_770_BG },
         { "780", OPTION_VAL_780_BG },
         { "790", OPTION_VAL_790_BG },
         { "800", OPTION_VAL_800_BG },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_BG,
      NULL,
      BSNES_SGB_BIOS_INFO_0_BG,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_BG   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_BG },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_BG,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_BG,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_BG,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_BG,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_BG,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_BG,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_bg = {
   option_cats_bg,
   option_defs_bg
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_VIDEO_LABEL_CA "Vídeo"
#define CATEGORY_VIDEO_INFO_0_CA "Canvia les opcions de sortida de vídeo."
#define CATEGORY_AUDIO_LABEL_CA "Àudio"
#define CATEGORY_AUDIO_INFO_0_CA "Canvia les opcions de sortida de l'àudio."
#define CATEGORY_MODE7_LABEL_CA "Mode HD 7"
#define CATEGORY_MODE7_INFO_0_CA "Canvia la configuració relativa a l'emulació dels gràfics en Mode 7."
#define CATEGORY_HACK_LABEL_CA "Correccions de l'emulació i optimitzacions"
#define CATEGORY_HACK_INFO_0_CA "Aplica correccions de l'emulació, optimitzacions i revisions."
#define CATEGORY_OVERCLOCK_LABEL_CA "Augmentar/Disminuir velocitat de la CPU"
#define CATEGORY_OVERCLOCK_INFO_0_CA "Canvia la velocitat d'emulació del maquinari."
#define CATEGORY_SGB_LABEL_CA NULL
#define CATEGORY_SGB_INFO_0_CA "Canvia la configuració relativa a l'emulació de Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_CA "Pistola de llum"
#define CATEGORY_LIGHTGUN_INFO_0_CA "Canvia (pantalla tàctil) la configuració de la pistola de llum."
#define BSNES_ASPECT_RATIO_LABEL_CA "Relació d'aspecte preferida"
#define BSNES_ASPECT_RATIO_INFO_0_CA "Escull la relació d'aspecte preferida. Aquesta relació d'aspecte només s'aplicarà si la relació d'aspecte a RetroArch està fixada a 'Core provided' en la configuració de vídeo."
#define OPTION_VAL_AUTO_CA "Automàtic"
#define OPTION_VAL_1_1_CA "1:1 PAR (Píxel perfecte)"
#define OPTION_VAL_4_3_CA NULL
#define OPTION_VAL_NTSC_CA NULL
#define OPTION_VAL_PAL_CA NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_CA "Retallar sobreescombrat vertical"
#define BSNES_PPU_OVERSCAN_V_INFO_0_CA "Elimina una quantitat concreta de línies de la part superior i inferior de la pantalla per emular el marc d'una televisió de l'època de la SNES."
#define OPTION_VAL_0_CA "0 Línies"
#define OPTION_VAL_8_CA "8 Línies"
#define OPTION_VAL_12_CA "12 Línies"
#define OPTION_VAL_16_CA "16 Línies"
#define BSNES_BLUR_EMULATION_LABEL_CA "Emular el difuminat"
#define BSNES_BLUR_EMULATION_INFO_0_CA "Simula la limitació de resolució horitzontal d'un televisor SD difuminant els píxels que estiguin adjacents horitzontalment. Certs jocs necessiten aquest efecte per simular la transparencia."
#define BSNES_VIDEO_FILTER_LABEL_CA "Filtre"
#define BSNES_VIDEO_FILTER_INFO_0_CA "Selecciona entre cap filtre i el filtre NTSC de blargg amb opcions per RF, Composició, S-Video o RGB"
#define OPTION_VAL_NONE_CA "Cap"
#define OPTION_VAL_NTSC_RF_CA NULL
#define OPTION_VAL_NTSC_COMPOSITE_CA "NTSC (Composició)"
#define OPTION_VAL_NTSC_S_VIDEO_CA NULL
#define OPTION_VAL_NTSC_RGB_CA NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_CA "Ajust de color - Brillantor"
#define BSNES_VIDEO_LUMINANCE_INFO_0_CA "Ajustar brillantor"
#define OPTION_VAL_0_O4_CA NULL
#define OPTION_VAL_10_CA NULL
#define OPTION_VAL_20_CA NULL
#define OPTION_VAL_30_CA NULL
#define OPTION_VAL_40_CA NULL
#define OPTION_VAL_50_CA NULL
#define OPTION_VAL_60_CA NULL
#define OPTION_VAL_70_CA NULL
#define OPTION_VAL_80_CA NULL
#define OPTION_VAL_90_CA NULL
#define OPTION_VAL_100_CA "100% (Per defecte)"
#define BSNES_VIDEO_SATURATION_LABEL_CA "Ajust de color - Saturació"
#define BSNES_VIDEO_SATURATION_INFO_0_CA "Ajustar saturació"
#define OPTION_VAL_110_CA NULL
#define OPTION_VAL_120_CA NULL
#define OPTION_VAL_130_CA NULL
#define OPTION_VAL_140_CA NULL
#define OPTION_VAL_150_CA NULL
#define OPTION_VAL_160_CA NULL
#define OPTION_VAL_170_CA NULL
#define OPTION_VAL_180_CA NULL
#define OPTION_VAL_190_CA NULL
#define OPTION_VAL_200_CA NULL
#define BSNES_VIDEO_GAMMA_LABEL_CA "Ajust de color - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_CA "Ajustar el factor Gamma"
#define OPTION_VAL_100_O6_CA NULL
#define OPTION_VAL_150_O6_CA "150% (Per defecte)"
#define BSNES_PPU_FAST_LABEL_CA "PPU (Vídeo) - Mode ràpid"
#define BSNES_PPU_FAST_LABEL_CAT_CA "PPU - Mode ràpid"
#define BSNES_PPU_FAST_INFO_0_CA "Activa l'emulació ràpida de la PPU a costa d'una reducció de la precisió. Es recomana deixar-ho activat. NOTA: Això ha d'estar activat perquè funcionin les opcions de desentrellaçament, desactivar límit de sprites i Mode 7 en alta resolució."
#define BSNES_PPU_DEINTERLACE_LABEL_CA "PPU (Vídeo) - Desentrellaçament"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_CA "Desentrellaçament PPU"
#define BSNES_PPU_DEINTERLACE_INFO_0_CA "Desentrellaça tots els jocs renderitzant-los internament a 480p. No hi ha quasi cap afectació al rendiment, així que és recomanable deixar aquesta opció activada."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CA "PPU (Vídeo) - Sense límit de fotogrames"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CA "Sense límit de fotogrames - PPU"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CA "Elimina tots els límits en el nombre de sprites que es poden mostrar en pantalla de manera simultània. Pot provocar problemes en alguns jocs."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CA "PPU (Vídeo) - Eliminar bloqueig de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CA "PPU - Eliminar el bloqueig de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CA "Simula un error en versions anteriors de ZSNES i Snes9x en què no s'emulava el bloqueig de memòria VRAM. Alguns romhacks antics necessiten aquest error per funcionar i es mostraran incorrectament a nivell gràfic si no s'activa aquesta opció. És molt inexacta i afecta a la velocitat de la PPU, així que et recomanem mantenir-la desactivada a no ser que necessitis jugar a un joc que sigui incompatible amb aquest nucli sense aquesta opció."
#define BSNES_DSP_FAST_LABEL_CA "DSP (Àudio) - Mode ràpid"
#define BSNES_DSP_FAST_LABEL_CAT_CA "DSP - Mode ràpid"
#define BSNES_DSP_FAST_INFO_0_CA "Habilita l'emulació ràpida del DSP a costa d'una petita reducció de la precisió. Es recomana deixar aquesta opció activada."
#define BSNES_DSP_CUBIC_LABEL_CA "DSP (Àudio) - Interpolació cúbica"
#define BSNES_DSP_CUBIC_LABEL_CAT_CA "DSP - Interpolació cúbica"
#define BSNES_DSP_CUBIC_INFO_0_CA "Aplica interpolació cúbica al so, conservant més rang de freqüències agudes."
#define BSNES_DSP_ECHO_SHADOW_LABEL_CA "DSP (Àudio) - Duplicació de RAM per ecos"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CA "DSP - Duplicació de memòria RAM per eco"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_CA "Simula un error a ZSNES en el qual la memòria RAM per a ecos era tractada com una part independent de la RAM de la APU. Alguns romhacks antics de Super Mario Wolrd depenen d'aquest error per a funcionar. Aquesta opció és molt inestable i no s'ha d'activar a no ser que sigui imprescindible."
#define BSNES_MODE7_SCALE_LABEL_CA "Mode 7 HD - Escala"
#define BSNES_MODE7_SCALE_LABEL_CAT_CA "Escala"
#define BSNES_MODE7_SCALE_INFO_0_CA "Augmenta la resolució horitzontal i vertical dels gràfics en el Mode 7 per certs jocs."
#define OPTION_VAL_1X_CA NULL
#define OPTION_VAL_2X_CA NULL
#define OPTION_VAL_3X_CA NULL
#define OPTION_VAL_4X_CA NULL
#define OPTION_VAL_5X_CA NULL
#define OPTION_VAL_6X_CA NULL
#define OPTION_VAL_7X_CA NULL
#define OPTION_VAL_8X_CA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CA "Mode HD 7 - Correcció de la perspectiva"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CA "Correcció de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_CA "Corregeix la perspectiva dels gràfics en el Mode 7 que s'utilitza en certs jocs, corregint les limitacions dels càlculs amb nombres enters que fa la SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CA "Mode HD 7 - Sobremostreig"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CA "Sobre mostreig"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_CA "Sobremostreig els gràfics en Mode 7 que fan servir certs jocs. Combinat amb un factor d'escala alt del Mode 7, produeix un efecte similar al suavitzat de vores."
#define BSNES_MODE7_MOSAIC_LABEL_CA "Mode HD 7 - HD -> Mosaic SD"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_CA "HD -> Mosaic SD"
#define BSNES_MODE7_MOSAIC_INFO_0_CA "Mostra l'efecte de mosaic dels gràfics en el mode 7 si augmenta l'escala."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_CA "Reducció predictiva de la latència interna"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_CA "Simula el sistema per avançat i després executa'l per reduir la latència d'entrada. Aquesta opció té requisits de sistema molt alts."
#define OPTION_VAL_1_CA "1 fotograma"
#define OPTION_VAL_2_CA "2 fotogrames"
#define OPTION_VAL_3_CA "3 fotogrames"
#define OPTION_VAL_4_CA "4 fotogrames"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CA "Coprocessadors - Mode ràpid"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CA "Habilitat l'emulació ràpida dels coprocessadors a costa d'una petita reducció de la precisió. Es recomana deixar aquesta opció activada."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_CA "Coprocessadors - HLE preferit"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CA "Quan aquesta opció està activada, es farà servir una emulació d'alt nivell amb menys precisió si està disponible. En cas contrari, només es farà servir l'emulació d'alt nivell quan no es trobi dins del firmware."
#define BSNES_HOTFIXES_LABEL_CA "Correccions"
#define BSNES_HOTFIXES_INFO_0_CA "A vegades, els programes comercials també poden contenir errors. Aquesta opció corregeix certs problemes que també passen en el maquinari real."
#define BSNES_ENTROPY_LABEL_CA "Entropía (aleatori)"
#define BSNES_ENTROPY_INFO_0_CA "Selecciona el nivell d'aleatoritat de la memòria i els registres. Si selecciones 'cap', tota la memòria els registres s'iniciaran al principi amb uns valors constants. Si selecciones 'baixa', ofereix la representació més fidel al sistema real. Si selecciones 'alta' produeix uns valors que son el més aleatoris possibles."
#define OPTION_VAL_LOW_CA "Baix"
#define OPTION_VAL_HIGH_CA "Alt"
#define BSNES_CPU_FASTMATH_LABEL_CA "Acceleració càlculs matemàtics a la CPU"
#define BSNES_CPU_FASTMATH_INFO_0_CA "Produeix els resultats de la computació de forma inmediata. Les multiplicacions i quocients amb la CPU tarden un temps a fer-se a una SNES real. Els emuladors més antics simulaven aquests retards, així que alguns romhacks antics necessiten aquesta correcció per funcionar correctament."
#define BSNES_CPU_OVERCLOCK_LABEL_CA "Augmentar velocitat de la CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_CA "CPU760%"
#define BSNES_CPU_OVERCLOCK_INFO_0_CA "Augmentar o disminuir la velocitat de la CPU. Un valor més alt que el 100% pot reduir els temps de càrrega i entorpiments. Fes servir-ho amb precaució perquè també pot provocar bloquejos o altres problemes en alguns jocs."
#define OPTION_VAL_210_CA NULL
#define OPTION_VAL_220_CA NULL
#define OPTION_VAL_230_CA NULL
#define OPTION_VAL_240_CA NULL
#define OPTION_VAL_250_CA NULL
#define OPTION_VAL_260_CA NULL
#define OPTION_VAL_270_CA NULL
#define OPTION_VAL_280_CA NULL
#define OPTION_VAL_290_CA NULL
#define OPTION_VAL_300_CA NULL
#define OPTION_VAL_310_CA NULL
#define OPTION_VAL_320_CA NULL
#define OPTION_VAL_330_CA NULL
#define OPTION_VAL_340_CA NULL
#define OPTION_VAL_350_CA NULL
#define OPTION_VAL_360_CA NULL
#define OPTION_VAL_370_CA NULL
#define OPTION_VAL_380_CA NULL
#define OPTION_VAL_390_CA NULL
#define OPTION_VAL_400_CA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CA "Augmentar velocitat - Coprocessador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CA "Coprocessador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_CA "Augmentar o disminuir la velocitat del Super Accelerator (SA-1) Un valor més alt que el 100% pot millorar el rendiment en jocs que tinguin suport de Super Accelerator (SA-1). Fes servir-ho amb precaució perquè també pot provocar bloquejos o altres problemes en alguns jocs."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CA "Augmentar velocitat - Coprocessador SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CA "Coprocessador SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_CA "Augmentar o disminuir la velocitat del coprocessador SuperFX. Un valor més alt que el 100% pot millorar el rendiment en jocs que tinguin suport de SuperFX. Fes servir-ho amb precaució perquè també pot provocar bloquejos o altres problemes en alguns jocs."
#define OPTION_VAL_410_CA NULL
#define OPTION_VAL_420_CA NULL
#define OPTION_VAL_430_CA NULL
#define OPTION_VAL_440_CA NULL
#define OPTION_VAL_450_CA NULL
#define OPTION_VAL_460_CA NULL
#define OPTION_VAL_470_CA NULL
#define OPTION_VAL_480_CA NULL
#define OPTION_VAL_490_CA NULL
#define OPTION_VAL_500_CA NULL
#define OPTION_VAL_510_CA NULL
#define OPTION_VAL_520_CA NULL
#define OPTION_VAL_530_CA NULL
#define OPTION_VAL_540_CA NULL
#define OPTION_VAL_550_CA NULL
#define OPTION_VAL_560_CA NULL
#define OPTION_VAL_570_CA NULL
#define OPTION_VAL_580_CA NULL
#define OPTION_VAL_590_CA NULL
#define OPTION_VAL_600_CA NULL
#define OPTION_VAL_610_CA NULL
#define OPTION_VAL_620_CA NULL
#define OPTION_VAL_630_CA NULL
#define OPTION_VAL_640_CA NULL
#define OPTION_VAL_650_CA NULL
#define OPTION_VAL_660_CA NULL
#define OPTION_VAL_670_CA NULL
#define OPTION_VAL_680_CA NULL
#define OPTION_VAL_690_CA NULL
#define OPTION_VAL_700_CA NULL
#define OPTION_VAL_710_CA NULL
#define OPTION_VAL_720_CA NULL
#define OPTION_VAL_730_CA NULL
#define OPTION_VAL_740_CA NULL
#define OPTION_VAL_750_CA NULL
#define OPTION_VAL_760_CA NULL
#define OPTION_VAL_770_CA NULL
#define OPTION_VAL_780_CA NULL
#define OPTION_VAL_790_CA NULL
#define OPTION_VAL_800_CA NULL
#define BSNES_SGB_BIOS_LABEL_CA "BIOS de la Super Game Boy preferida (Es requereix reinici)"
#define BSNES_SGB_BIOS_INFO_0_CA "Selecciona la BIOS preferida de Super Game Boy que s'utilitzarà amb els jocs compatibles."
#define OPTION_VAL_SGB1_SFC_CA NULL
#define OPTION_VAL_SGB2_SFC_CA NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_CA "Amaga vora SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_CA "Amaga la vora en jugar a jocs de Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CA "Simular la pistola de llum amb la pantalla tàctil"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CA "Activa l'entrada de Super Scope per dispositius tàctils."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CA "Inverteix gatells del Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CA "Inverteix els botons de gatell i ratolí del Super Scope a la pantalla tàctil."

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CA,
      CATEGORY_VIDEO_INFO_0_CA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CA,
      CATEGORY_AUDIO_INFO_0_CA
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_CA,
      CATEGORY_MODE7_INFO_0_CA
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_CA,
      CATEGORY_HACK_INFO_0_CA
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_CA,
      CATEGORY_OVERCLOCK_INFO_0_CA
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_CA,
      CATEGORY_SGB_INFO_0_CA
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_CA,
      CATEGORY_LIGHTGUN_INFO_0_CA
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_CA,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_CA,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_CA },
         { "1:1",  OPTION_VAL_1_1_CA },
         { "4:3",  OPTION_VAL_4_3_CA },
         { "NTSC", OPTION_VAL_NTSC_CA },
         { "PAL",  OPTION_VAL_PAL_CA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_CA,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_CA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_CA },
         { "8",  OPTION_VAL_8_CA },
         { "12", OPTION_VAL_12_CA },
         { "16", OPTION_VAL_16_CA },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_CA,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_CA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_CA,
      BSNES_VIDEO_FILTER_LABEL_CA,
      BSNES_VIDEO_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_CA },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_CA },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_CA },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_CA },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_CA },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_CA,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_CA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CA },
         { "10", OPTION_VAL_10_CA },
         { "20", OPTION_VAL_20_CA },
         { "30", OPTION_VAL_30_CA },
         { "40", OPTION_VAL_40_CA },
         { "50", OPTION_VAL_50_CA },
         { "60", OPTION_VAL_60_CA },
         { "70", OPTION_VAL_70_CA },
         { "80", OPTION_VAL_80_CA },
         { "90", OPTION_VAL_90_CA },
         { "100", OPTION_VAL_100_CA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_CA,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_CA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CA },
         { "10", OPTION_VAL_10_CA },
         { "20", OPTION_VAL_20_CA },
         { "30", OPTION_VAL_30_CA },
         { "40", OPTION_VAL_40_CA },
         { "50", OPTION_VAL_50_CA },
         { "60", OPTION_VAL_60_CA },
         { "70", OPTION_VAL_70_CA },
         { "80", OPTION_VAL_80_CA },
         { "90", OPTION_VAL_90_CA },
         { "100", OPTION_VAL_100_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_CA,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_CA,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_O6_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_CA,
      BSNES_PPU_FAST_LABEL_CAT_CA,
      BSNES_PPU_FAST_INFO_0_CA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_CA,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_CA,
      BSNES_PPU_DEINTERLACE_INFO_0_CA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CA,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CA,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CA,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CA,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_CA,
      BSNES_DSP_FAST_LABEL_CAT_CA,
      BSNES_DSP_FAST_INFO_0_CA,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_CA,
      BSNES_DSP_CUBIC_LABEL_CAT_CA,
      BSNES_DSP_CUBIC_INFO_0_CA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_CA,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CA,
      BSNES_DSP_ECHO_SHADOW_INFO_0_CA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_CA,
      BSNES_MODE7_SCALE_LABEL_CAT_CA,
      BSNES_MODE7_SCALE_INFO_0_CA,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_CA  },
         { "2x", OPTION_VAL_2X_CA  },
         { "3x", OPTION_VAL_3X_CA  },
         { "4x", OPTION_VAL_4X_CA  },
         { "5x", OPTION_VAL_5X_CA },
         { "6x", OPTION_VAL_6X_CA },
         { "7x", OPTION_VAL_7X_CA },
         { "8x", OPTION_VAL_8X_CA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_CA,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CA,
      BSNES_MODE7_PERSPECTIVE_INFO_0_CA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_CA,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CA,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_CA,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_CA,
      BSNES_MODE7_MOSAIC_LABEL_CAT_CA,
      BSNES_MODE7_MOSAIC_INFO_0_CA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_CA,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_CA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_CA  },
         { "2",   OPTION_VAL_2_CA },
         { "3",   OPTION_VAL_3_CA },
         { "4",   OPTION_VAL_4_CA },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CA,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_CA,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_CA,
      NULL,
      BSNES_HOTFIXES_INFO_0_CA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_CA,
      NULL,
      BSNES_ENTROPY_INFO_0_CA,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_CA },
         { "High", OPTION_VAL_HIGH_CA },
         { "None", OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_CA,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_CA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_CA,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_CA,
      BSNES_CPU_OVERCLOCK_INFO_0_CA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CA  },
         { "20",  OPTION_VAL_20_CA  },
         { "30",  OPTION_VAL_30_CA  },
         { "40",  OPTION_VAL_40_CA  },
         { "50",  OPTION_VAL_50_CA  },
         { "60",  OPTION_VAL_60_CA  },
         { "70",  OPTION_VAL_70_CA  },
         { "80",  OPTION_VAL_80_CA  },
         { "90",  OPTION_VAL_90_CA  },
         { "100", OPTION_VAL_100_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { "210", OPTION_VAL_210_CA },
         { "220", OPTION_VAL_220_CA },
         { "230", OPTION_VAL_230_CA },
         { "240", OPTION_VAL_240_CA },
         { "250", OPTION_VAL_250_CA },
         { "260", OPTION_VAL_260_CA },
         { "270", OPTION_VAL_270_CA },
         { "280", OPTION_VAL_280_CA },
         { "290", OPTION_VAL_290_CA },
         { "300", OPTION_VAL_300_CA },
         { "310", OPTION_VAL_310_CA },
         { "320", OPTION_VAL_320_CA },
         { "330", OPTION_VAL_330_CA },
         { "340", OPTION_VAL_340_CA },
         { "350", OPTION_VAL_350_CA },
         { "360", OPTION_VAL_360_CA },
         { "370", OPTION_VAL_370_CA },
         { "380", OPTION_VAL_380_CA },
         { "390", OPTION_VAL_390_CA },
         { "400", OPTION_VAL_400_CA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CA,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CA,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_CA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CA  },
         { "20",  OPTION_VAL_20_CA  },
         { "30",  OPTION_VAL_30_CA  },
         { "40",  OPTION_VAL_40_CA  },
         { "50",  OPTION_VAL_50_CA  },
         { "60",  OPTION_VAL_60_CA  },
         { "70",  OPTION_VAL_70_CA  },
         { "80",  OPTION_VAL_80_CA  },
         { "90",  OPTION_VAL_90_CA  },
         { "100", OPTION_VAL_100_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { "210", OPTION_VAL_210_CA },
         { "220", OPTION_VAL_220_CA },
         { "230", OPTION_VAL_230_CA },
         { "240", OPTION_VAL_240_CA },
         { "250", OPTION_VAL_250_CA },
         { "260", OPTION_VAL_260_CA },
         { "270", OPTION_VAL_270_CA },
         { "280", OPTION_VAL_280_CA },
         { "290", OPTION_VAL_290_CA },
         { "300", OPTION_VAL_300_CA },
         { "310", OPTION_VAL_310_CA },
         { "320", OPTION_VAL_320_CA },
         { "330", OPTION_VAL_330_CA },
         { "340", OPTION_VAL_340_CA },
         { "350", OPTION_VAL_350_CA },
         { "360", OPTION_VAL_360_CA },
         { "370", OPTION_VAL_370_CA },
         { "380", OPTION_VAL_380_CA },
         { "390", OPTION_VAL_390_CA },
         { "400", OPTION_VAL_400_CA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CA,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CA,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_CA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CA  },
         { "20",  OPTION_VAL_20_CA  },
         { "30",  OPTION_VAL_30_CA  },
         { "40",  OPTION_VAL_40_CA  },
         { "50",  OPTION_VAL_50_CA  },
         { "60",  OPTION_VAL_60_CA  },
         { "70",  OPTION_VAL_70_CA  },
         { "80",  OPTION_VAL_80_CA  },
         { "90",  OPTION_VAL_90_CA  },
         { "100", OPTION_VAL_100_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { "210", OPTION_VAL_210_CA },
         { "220", OPTION_VAL_220_CA },
         { "230", OPTION_VAL_230_CA },
         { "240", OPTION_VAL_240_CA },
         { "250", OPTION_VAL_250_CA },
         { "260", OPTION_VAL_260_CA },
         { "270", OPTION_VAL_270_CA },
         { "280", OPTION_VAL_280_CA },
         { "290", OPTION_VAL_290_CA },
         { "300", OPTION_VAL_300_CA },
         { "310", OPTION_VAL_310_CA },
         { "320", OPTION_VAL_320_CA },
         { "330", OPTION_VAL_330_CA },
         { "340", OPTION_VAL_340_CA },
         { "350", OPTION_VAL_350_CA },
         { "360", OPTION_VAL_360_CA },
         { "370", OPTION_VAL_370_CA },
         { "380", OPTION_VAL_380_CA },
         { "390", OPTION_VAL_390_CA },
         { "400", OPTION_VAL_400_CA },
         { "410", OPTION_VAL_410_CA },
         { "420", OPTION_VAL_420_CA },
         { "430", OPTION_VAL_430_CA },
         { "440", OPTION_VAL_440_CA },
         { "450", OPTION_VAL_450_CA },
         { "460", OPTION_VAL_460_CA },
         { "470", OPTION_VAL_470_CA },
         { "480", OPTION_VAL_480_CA },
         { "490", OPTION_VAL_490_CA },
         { "500", OPTION_VAL_500_CA },
         { "510", OPTION_VAL_510_CA },
         { "520", OPTION_VAL_520_CA },
         { "530", OPTION_VAL_530_CA },
         { "540", OPTION_VAL_540_CA },
         { "550", OPTION_VAL_550_CA },
         { "560", OPTION_VAL_560_CA },
         { "570", OPTION_VAL_570_CA },
         { "580", OPTION_VAL_580_CA },
         { "590", OPTION_VAL_590_CA },
         { "600", OPTION_VAL_600_CA },
         { "610", OPTION_VAL_610_CA },
         { "620", OPTION_VAL_620_CA },
         { "630", OPTION_VAL_630_CA },
         { "640", OPTION_VAL_640_CA },
         { "650", OPTION_VAL_650_CA },
         { "660", OPTION_VAL_660_CA },
         { "670", OPTION_VAL_670_CA },
         { "680", OPTION_VAL_680_CA },
         { "690", OPTION_VAL_690_CA },
         { "700", OPTION_VAL_700_CA },
         { "710", OPTION_VAL_710_CA },
         { "720", OPTION_VAL_720_CA },
         { "730", OPTION_VAL_730_CA },
         { "740", OPTION_VAL_740_CA },
         { "750", OPTION_VAL_750_CA },
         { "760", OPTION_VAL_760_CA },
         { "770", OPTION_VAL_770_CA },
         { "780", OPTION_VAL_780_CA },
         { "790", OPTION_VAL_790_CA },
         { "800", OPTION_VAL_800_CA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_CA,
      NULL,
      BSNES_SGB_BIOS_INFO_0_CA,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_CA   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_CA },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_CA,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_CA,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CA,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CA,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_VIDEO_LABEL_CHS "视频"
#define CATEGORY_VIDEO_INFO_0_CHS "更改视频输出设置。"
#define CATEGORY_AUDIO_LABEL_CHS "音频"
#define CATEGORY_AUDIO_INFO_0_CHS "更改音频输出设置。"
#define CATEGORY_MODE7_LABEL_CHS "HD 模式 7"
#define CATEGORY_MODE7_INFO_0_CHS "更改关于模式 7 图形模拟的设置。"
#define CATEGORY_HACK_LABEL_CHS "模拟破解与增强"
#define CATEGORY_HACK_INFO_0_CHS "应用模拟破解、增强功能和热修复。"
#define CATEGORY_OVERCLOCK_LABEL_CHS "超频/降频"
#define CATEGORY_OVERCLOCK_INFO_0_CHS "更改模拟硬件的速度。"
#define CATEGORY_SGB_LABEL_CHS NULL
#define CATEGORY_SGB_INFO_0_CHS "更改关于 Super Game Boy 模拟的设置。"
#define CATEGORY_LIGHTGUN_LABEL_CHS "光枪"
#define CATEGORY_LIGHTGUN_INFO_0_CHS "更改（触摸屏）光枪设置。"
#define BSNES_ASPECT_RATIO_LABEL_CHS "首选宽高比"
#define BSNES_ASPECT_RATIO_INFO_0_CHS "选择首选的内容宽高比。此设置仅在 RetroArch 的宽高比设置为“核心提供”时生效。"
#define OPTION_VAL_AUTO_CHS "自动"
#define OPTION_VAL_1_1_CHS "1:1 像素宽高比（像素完美）"
#define OPTION_VAL_4_3_CHS "4:3 显示宽高比"
#define OPTION_VAL_NTSC_CHS NULL
#define OPTION_VAL_PAL_CHS NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_CHS "裁剪垂直过扫描"
#define BSNES_PPU_OVERSCAN_V_INFO_0_CHS "从屏幕顶部和底部移除 N 行，以模拟 SNES 时代的电视边框。"
#define OPTION_VAL_0_CHS "0 行"
#define OPTION_VAL_8_CHS "8 行"
#define OPTION_VAL_12_CHS "12 行"
#define OPTION_VAL_16_CHS "16 行"
#define BSNES_BLUR_EMULATION_LABEL_CHS "模糊模拟"
#define BSNES_BLUR_EMULATION_INFO_0_CHS "通过将水平相邻的像素模糊在一起，模拟标准清晰度电视 (SDTV) 有限的水平分辨率。某些游戏依赖此效果来实现透明效果。"
#define BSNES_VIDEO_FILTER_LABEL_CHS "滤镜"
#define BSNES_VIDEO_FILTER_INFO_0_CHS "选择无滤镜或 blargg 的 NTSC 滤镜，并可选择 RF、复合、S-Video 或 RGB 模式。"
#define OPTION_VAL_NONE_CHS "无"
#define OPTION_VAL_NTSC_RF_CHS "NTSC（RF）"
#define OPTION_VAL_NTSC_COMPOSITE_CHS "NTSC（复合）"
#define OPTION_VAL_NTSC_S_VIDEO_CHS "NTSC（S-视频）"
#define OPTION_VAL_NTSC_RGB_CHS "NTSC（RGB）"
#define BSNES_VIDEO_LUMINANCE_LABEL_CHS "色彩调整 - 亮度"
#define BSNES_VIDEO_LUMINANCE_INFO_0_CHS "调整亮度"
#define OPTION_VAL_0_O4_CHS NULL
#define OPTION_VAL_10_CHS NULL
#define OPTION_VAL_20_CHS NULL
#define OPTION_VAL_30_CHS NULL
#define OPTION_VAL_40_CHS NULL
#define OPTION_VAL_50_CHS NULL
#define OPTION_VAL_60_CHS NULL
#define OPTION_VAL_70_CHS NULL
#define OPTION_VAL_80_CHS NULL
#define OPTION_VAL_90_CHS NULL
#define OPTION_VAL_100_CHS "100%（默认）"
#define BSNES_VIDEO_SATURATION_LABEL_CHS "色彩调整 - 饱和度"
#define BSNES_VIDEO_SATURATION_INFO_0_CHS "调整饱和度"
#define OPTION_VAL_110_CHS NULL
#define OPTION_VAL_120_CHS NULL
#define OPTION_VAL_130_CHS NULL
#define OPTION_VAL_140_CHS NULL
#define OPTION_VAL_150_CHS NULL
#define OPTION_VAL_160_CHS NULL
#define OPTION_VAL_170_CHS NULL
#define OPTION_VAL_180_CHS NULL
#define OPTION_VAL_190_CHS NULL
#define OPTION_VAL_200_CHS NULL
#define BSNES_VIDEO_GAMMA_LABEL_CHS "色彩调整 - 伽马值"
#define BSNES_VIDEO_GAMMA_INFO_0_CHS "调整伽马值"
#define OPTION_VAL_100_O6_CHS NULL
#define OPTION_VAL_150_O6_CHS "150%（默认）"
#define BSNES_PPU_FAST_LABEL_CHS "PPU（视频） - 快速模式"
#define BSNES_PPU_FAST_LABEL_CAT_CHS "PPU - 快速模式"
#define BSNES_PPU_FAST_INFO_0_CHS "在牺牲少量精度的前提下，实现更快的 PPU 模拟。建议保持开启。注意：必须开启此选项，“去隔行”、“无精灵限制”和“HD 模式 7”选项才能正常工作。"
#define BSNES_PPU_DEINTERLACE_LABEL_CHS "PPU（视频）- 去隔行"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_CHS "PPU - 去隔行"
#define BSNES_PPU_DEINTERLACE_INFO_0_CHS "通过内部以 480p 渲染来对所有游戏进行去隔行处理。性能损耗几乎可以忽略不计，因此建议保持开启。"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CHS "PPU（视频）- 无精灵限制"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CHS "PPU - 无精灵限制"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CHS "移除屏幕上可同时绘制的精灵数量限制。可能会导致某些游戏出现问题。"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CHS "PPU（视频）- 无 VRAM 阻塞"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CHS "PPU - 无 VRAM 阻塞"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CHS "模拟 ZSNES 和 Snes9x 旧版本中的一个错误，其中未模拟 VRAM 阻塞。一些较老的 ROM 破解依赖于此行为，如果未启用，图形将渲染错误。此选项极不准确且会损害 PPU 速度，因此除非需要玩与该核心不兼容的游戏，否则建议禁用。"
#define BSNES_DSP_FAST_LABEL_CHS "DSP（音频）- 快速模式"
#define BSNES_DSP_FAST_LABEL_CAT_CHS "DSP - 快速模式"
#define BSNES_DSP_FAST_INFO_0_CHS "在牺牲少量精度的前提下，实现更快的 DSP 模拟。建议保持开启。"
#define BSNES_DSP_CUBIC_LABEL_CHS "DSP（音频）- 三次插值"
#define BSNES_DSP_CUBIC_LABEL_CAT_CHS "DSP - 三次插值"
#define BSNES_DSP_CUBIC_INFO_0_CHS "对声音应用三次插值，保留更多高频部分。"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CHS "DSP（音频）- 回声影子 RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CHS "DSP - 回声影子 RAM"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_CHS "模拟 ZSNES 中的一个错误，其中回声 RAM 被视为与 APU RAM 分开。许多为《超级马力欧世界》设计的较老 ROM 破解依赖于此行为，如果没有此选项，游戏将会崩溃。此选项极不准确，除非必要，否则不应启用。"
#define BSNES_MODE7_SCALE_LABEL_CHS "HD 模式 7 - 缩放"
#define BSNES_MODE7_SCALE_LABEL_CAT_CHS "缩放"
#define BSNES_MODE7_SCALE_INFO_0_CHS "提高某些游戏中使用的 HD 模式 7 图形的水平和垂直分辨率。"
#define OPTION_VAL_1X_CHS "240p（1x）"
#define OPTION_VAL_2X_CHS "480p（2x）"
#define OPTION_VAL_3X_CHS "720p（3x）"
#define OPTION_VAL_4X_CHS "960p（4x）"
#define OPTION_VAL_5X_CHS "1200p（5x）"
#define OPTION_VAL_6X_CHS "1440p（6x）"
#define OPTION_VAL_7X_CHS "1680p（7x）"
#define OPTION_VAL_8X_CHS "1920p（8x）"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CHS "高清模式 7 - 透视校正"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CHS "透视修正"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_CHS "通过绕过 SNES 使用的整数数学运算的一些限制，校正某些游戏中使用的 高清模式 7 图形的透视效果。"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CHS "高清模式 7 - 超采样"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CHS "超采样"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_CHS "对某些游戏中使用的模式 7 图形进行超采样。结合更高的模式 7 缩放倍数，可产生类似抗锯齿的效果。"
#define BSNES_MODE7_MOSAIC_LABEL_CHS "高清模式 7 - HD->SD 马赛克"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_CHS "HD->SD 马赛克"
#define BSNES_MODE7_MOSAIC_INFO_0_CHS "即使在放大时，也显示模式 7 图形的马赛克效果。"
#define BSNES_RUN_AHEAD_FRAMES_LABEL_CHS "内部预运行"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_CHS "模拟系统提前运行并回滚，以减少输入延迟。此功能对系统要求非常高。"
#define OPTION_VAL_1_CHS "1 帧"
#define OPTION_VAL_2_CHS "2 帧"
#define OPTION_VAL_3_CHS "3 帧"
#define OPTION_VAL_4_CHS "4 帧"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CHS "协处理器 - 快速模式"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CHS "以轻微降低精度为代价，启用更快的协处理器模拟。建议保持开启。"
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_CHS "协处理器 - 优先使用 HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CHS "当此选项启用时，只要可用，将始终使用精度较低的 HLE 模拟。如果禁用，则仅在缺少 LLE 固件时才使用 HLE。"
#define BSNES_HOTFIXES_LABEL_CHS "热修复"
#define BSNES_HOTFIXES_INFO_0_CHS "即使是商业授权并正式发布的软件，有时也会带有错误。此选项将修正即使在真实硬件上也会出现的某些问题。"
#define BSNES_ENTROPY_LABEL_CHS "熵（随机化）"
#define BSNES_ENTROPY_INFO_0_CHS "选择内存和寄存器的随机化级别。如果设为“无”，所有内存和寄存器在启动时都将初始化为固定值。低随机化能最准确地模拟真实系统。高随机化则尽可能地进行随机化。"
#define OPTION_VAL_LOW_CHS "低"
#define OPTION_VAL_HIGH_CHS "高"
#define BSNES_CPU_FASTMATH_LABEL_CHS "CPU 快速数学"
#define BSNES_CPU_FASTMATH_INFO_0_CHS "立即提供计算结果。在真实的 SNES 上，CPU 的乘法和除法运算需要时间才能完成。较旧的模拟器并未模拟这些延迟，因此一些较老的 ROM 破解程序不会等待数学运算完成，而需要此破解。"
#define BSNES_CPU_OVERCLOCK_LABEL_CHS "超频 - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_CHS NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_CHS "对 CPU 进行超频或降频。将此值设置为高于 100% 可能会缩短加载时间并消除卡顿。请谨慎使用，因为它也可能导致某些游戏崩溃或出现其他问题。"
#define OPTION_VAL_210_CHS NULL
#define OPTION_VAL_220_CHS NULL
#define OPTION_VAL_230_CHS NULL
#define OPTION_VAL_240_CHS NULL
#define OPTION_VAL_250_CHS NULL
#define OPTION_VAL_260_CHS NULL
#define OPTION_VAL_270_CHS NULL
#define OPTION_VAL_280_CHS NULL
#define OPTION_VAL_290_CHS NULL
#define OPTION_VAL_300_CHS NULL
#define OPTION_VAL_310_CHS NULL
#define OPTION_VAL_320_CHS NULL
#define OPTION_VAL_330_CHS NULL
#define OPTION_VAL_340_CHS NULL
#define OPTION_VAL_350_CHS NULL
#define OPTION_VAL_360_CHS NULL
#define OPTION_VAL_370_CHS NULL
#define OPTION_VAL_380_CHS NULL
#define OPTION_VAL_390_CHS NULL
#define OPTION_VAL_400_CHS NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CHS "超频 - SA-1 协处理器"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CHS "SA-1 协处理器"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_CHS "对超级加速器 1 (SA-1) 芯片进行超频或降频。将此值设置为高于 100% 可能会提升支持 SA-1 芯片的游戏性能。请谨慎使用，因为它也可能导致某些游戏崩溃或出现其他问题。"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CHS "超频 - SuperFX 协处理器"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CHS "SuperFX 协处理器"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_CHS "对 SuperFX 协处理器进行超频或降频。将此值设置为高于 100% 可能会提升支持 SuperFX 的游戏的性能。请谨慎使用，因为它也可能导致某些游戏崩溃或出现其他问题。"
#define OPTION_VAL_410_CHS NULL
#define OPTION_VAL_420_CHS NULL
#define OPTION_VAL_430_CHS NULL
#define OPTION_VAL_440_CHS NULL
#define OPTION_VAL_450_CHS NULL
#define OPTION_VAL_460_CHS NULL
#define OPTION_VAL_470_CHS NULL
#define OPTION_VAL_480_CHS NULL
#define OPTION_VAL_490_CHS NULL
#define OPTION_VAL_500_CHS NULL
#define OPTION_VAL_510_CHS NULL
#define OPTION_VAL_520_CHS NULL
#define OPTION_VAL_530_CHS NULL
#define OPTION_VAL_540_CHS NULL
#define OPTION_VAL_550_CHS NULL
#define OPTION_VAL_560_CHS NULL
#define OPTION_VAL_570_CHS NULL
#define OPTION_VAL_580_CHS NULL
#define OPTION_VAL_590_CHS NULL
#define OPTION_VAL_600_CHS NULL
#define OPTION_VAL_610_CHS NULL
#define OPTION_VAL_620_CHS NULL
#define OPTION_VAL_630_CHS NULL
#define OPTION_VAL_640_CHS NULL
#define OPTION_VAL_650_CHS NULL
#define OPTION_VAL_660_CHS NULL
#define OPTION_VAL_670_CHS NULL
#define OPTION_VAL_680_CHS NULL
#define OPTION_VAL_690_CHS NULL
#define OPTION_VAL_700_CHS NULL
#define OPTION_VAL_710_CHS NULL
#define OPTION_VAL_720_CHS NULL
#define OPTION_VAL_730_CHS NULL
#define OPTION_VAL_740_CHS NULL
#define OPTION_VAL_750_CHS NULL
#define OPTION_VAL_760_CHS NULL
#define OPTION_VAL_770_CHS NULL
#define OPTION_VAL_780_CHS NULL
#define OPTION_VAL_790_CHS NULL
#define OPTION_VAL_800_CHS NULL
#define BSNES_SGB_BIOS_LABEL_CHS "首选 Super Game Boy BIOS（需要重启）"
#define BSNES_SGB_BIOS_INFO_0_CHS "选择用于兼容游戏的首选 Super Game Boy BIOS。"
#define OPTION_VAL_SGB1_SFC_CHS "超级游戏男孩（SGB1.sfc）"
#define OPTION_VAL_SGB2_SFC_CHS "超级游戏男孩 2 (SGB2.sfc)"
#define BSNES_HIDE_SGB_BORDER_LABEL_CHS "隐藏 SGB 边框"
#define BSNES_HIDE_SGB_BORDER_INFO_0_CHS "在游玩超级游戏男孩游戏时隐藏边框。"
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CHS "触摸屏光枪"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CHS "为触摸屏设备启用 Super Scope 输入。"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CHS "Super Scope 反向扳机按钮"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CHS "使用触摸屏光枪时，反转 Super Scope 的扳机键和光标键。"

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHS,
      CATEGORY_VIDEO_INFO_0_CHS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHS,
      CATEGORY_AUDIO_INFO_0_CHS
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_CHS,
      CATEGORY_MODE7_INFO_0_CHS
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_CHS,
      CATEGORY_HACK_INFO_0_CHS
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_CHS,
      CATEGORY_OVERCLOCK_INFO_0_CHS
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_CHS,
      CATEGORY_SGB_INFO_0_CHS
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_CHS,
      CATEGORY_LIGHTGUN_INFO_0_CHS
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_CHS,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_CHS,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_CHS },
         { "1:1",  OPTION_VAL_1_1_CHS },
         { "4:3",  OPTION_VAL_4_3_CHS },
         { "NTSC", OPTION_VAL_NTSC_CHS },
         { "PAL",  OPTION_VAL_PAL_CHS },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_CHS,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_CHS },
         { "8",  OPTION_VAL_8_CHS },
         { "12", OPTION_VAL_12_CHS },
         { "16", OPTION_VAL_16_CHS },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_CHS,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_CHS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_CHS,
      BSNES_VIDEO_FILTER_LABEL_CHS,
      BSNES_VIDEO_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_CHS },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_CHS },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_CHS },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_CHS },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_CHS },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_CHS,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CHS },
         { "10", OPTION_VAL_10_CHS },
         { "20", OPTION_VAL_20_CHS },
         { "30", OPTION_VAL_30_CHS },
         { "40", OPTION_VAL_40_CHS },
         { "50", OPTION_VAL_50_CHS },
         { "60", OPTION_VAL_60_CHS },
         { "70", OPTION_VAL_70_CHS },
         { "80", OPTION_VAL_80_CHS },
         { "90", OPTION_VAL_90_CHS },
         { "100", OPTION_VAL_100_CHS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_CHS,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CHS },
         { "10", OPTION_VAL_10_CHS },
         { "20", OPTION_VAL_20_CHS },
         { "30", OPTION_VAL_30_CHS },
         { "40", OPTION_VAL_40_CHS },
         { "50", OPTION_VAL_50_CHS },
         { "60", OPTION_VAL_60_CHS },
         { "70", OPTION_VAL_70_CHS },
         { "80", OPTION_VAL_80_CHS },
         { "90", OPTION_VAL_90_CHS },
         { "100", OPTION_VAL_100_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_CHS,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_CHS,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_O6_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_CHS,
      BSNES_PPU_FAST_LABEL_CAT_CHS,
      BSNES_PPU_FAST_INFO_0_CHS,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_CHS,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_CHS,
      BSNES_PPU_DEINTERLACE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CHS,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CHS,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CHS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CHS,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CHS,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_CHS,
      BSNES_DSP_FAST_LABEL_CAT_CHS,
      BSNES_DSP_FAST_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_CHS,
      BSNES_DSP_CUBIC_LABEL_CAT_CHS,
      BSNES_DSP_CUBIC_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_CHS,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CHS,
      BSNES_DSP_ECHO_SHADOW_INFO_0_CHS,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_CHS,
      BSNES_MODE7_SCALE_LABEL_CAT_CHS,
      BSNES_MODE7_SCALE_INFO_0_CHS,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_CHS  },
         { "2x", OPTION_VAL_2X_CHS  },
         { "3x", OPTION_VAL_3X_CHS  },
         { "4x", OPTION_VAL_4X_CHS  },
         { "5x", OPTION_VAL_5X_CHS },
         { "6x", OPTION_VAL_6X_CHS },
         { "7x", OPTION_VAL_7X_CHS },
         { "8x", OPTION_VAL_8X_CHS },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_CHS,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CHS,
      BSNES_MODE7_PERSPECTIVE_INFO_0_CHS,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_CHS,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CHS,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_CHS,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_CHS,
      BSNES_MODE7_MOSAIC_LABEL_CAT_CHS,
      BSNES_MODE7_MOSAIC_INFO_0_CHS,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_CHS,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_CHS  },
         { "2",   OPTION_VAL_2_CHS },
         { "3",   OPTION_VAL_3_CHS },
         { "4",   OPTION_VAL_4_CHS },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CHS,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_CHS,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_CHS,
      NULL,
      BSNES_HOTFIXES_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_CHS,
      NULL,
      BSNES_ENTROPY_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_CHS },
         { "High", OPTION_VAL_HIGH_CHS },
         { "None", OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_CHS,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_CHS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_CHS,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_CHS,
      BSNES_CPU_OVERCLOCK_INFO_0_CHS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHS  },
         { "20",  OPTION_VAL_20_CHS  },
         { "30",  OPTION_VAL_30_CHS  },
         { "40",  OPTION_VAL_40_CHS  },
         { "50",  OPTION_VAL_50_CHS  },
         { "60",  OPTION_VAL_60_CHS  },
         { "70",  OPTION_VAL_70_CHS  },
         { "80",  OPTION_VAL_80_CHS  },
         { "90",  OPTION_VAL_90_CHS  },
         { "100", OPTION_VAL_100_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { "210", OPTION_VAL_210_CHS },
         { "220", OPTION_VAL_220_CHS },
         { "230", OPTION_VAL_230_CHS },
         { "240", OPTION_VAL_240_CHS },
         { "250", OPTION_VAL_250_CHS },
         { "260", OPTION_VAL_260_CHS },
         { "270", OPTION_VAL_270_CHS },
         { "280", OPTION_VAL_280_CHS },
         { "290", OPTION_VAL_290_CHS },
         { "300", OPTION_VAL_300_CHS },
         { "310", OPTION_VAL_310_CHS },
         { "320", OPTION_VAL_320_CHS },
         { "330", OPTION_VAL_330_CHS },
         { "340", OPTION_VAL_340_CHS },
         { "350", OPTION_VAL_350_CHS },
         { "360", OPTION_VAL_360_CHS },
         { "370", OPTION_VAL_370_CHS },
         { "380", OPTION_VAL_380_CHS },
         { "390", OPTION_VAL_390_CHS },
         { "400", OPTION_VAL_400_CHS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CHS,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CHS,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_CHS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHS  },
         { "20",  OPTION_VAL_20_CHS  },
         { "30",  OPTION_VAL_30_CHS  },
         { "40",  OPTION_VAL_40_CHS  },
         { "50",  OPTION_VAL_50_CHS  },
         { "60",  OPTION_VAL_60_CHS  },
         { "70",  OPTION_VAL_70_CHS  },
         { "80",  OPTION_VAL_80_CHS  },
         { "90",  OPTION_VAL_90_CHS  },
         { "100", OPTION_VAL_100_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { "210", OPTION_VAL_210_CHS },
         { "220", OPTION_VAL_220_CHS },
         { "230", OPTION_VAL_230_CHS },
         { "240", OPTION_VAL_240_CHS },
         { "250", OPTION_VAL_250_CHS },
         { "260", OPTION_VAL_260_CHS },
         { "270", OPTION_VAL_270_CHS },
         { "280", OPTION_VAL_280_CHS },
         { "290", OPTION_VAL_290_CHS },
         { "300", OPTION_VAL_300_CHS },
         { "310", OPTION_VAL_310_CHS },
         { "320", OPTION_VAL_320_CHS },
         { "330", OPTION_VAL_330_CHS },
         { "340", OPTION_VAL_340_CHS },
         { "350", OPTION_VAL_350_CHS },
         { "360", OPTION_VAL_360_CHS },
         { "370", OPTION_VAL_370_CHS },
         { "380", OPTION_VAL_380_CHS },
         { "390", OPTION_VAL_390_CHS },
         { "400", OPTION_VAL_400_CHS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CHS,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CHS,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_CHS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHS  },
         { "20",  OPTION_VAL_20_CHS  },
         { "30",  OPTION_VAL_30_CHS  },
         { "40",  OPTION_VAL_40_CHS  },
         { "50",  OPTION_VAL_50_CHS  },
         { "60",  OPTION_VAL_60_CHS  },
         { "70",  OPTION_VAL_70_CHS  },
         { "80",  OPTION_VAL_80_CHS  },
         { "90",  OPTION_VAL_90_CHS  },
         { "100", OPTION_VAL_100_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { "210", OPTION_VAL_210_CHS },
         { "220", OPTION_VAL_220_CHS },
         { "230", OPTION_VAL_230_CHS },
         { "240", OPTION_VAL_240_CHS },
         { "250", OPTION_VAL_250_CHS },
         { "260", OPTION_VAL_260_CHS },
         { "270", OPTION_VAL_270_CHS },
         { "280", OPTION_VAL_280_CHS },
         { "290", OPTION_VAL_290_CHS },
         { "300", OPTION_VAL_300_CHS },
         { "310", OPTION_VAL_310_CHS },
         { "320", OPTION_VAL_320_CHS },
         { "330", OPTION_VAL_330_CHS },
         { "340", OPTION_VAL_340_CHS },
         { "350", OPTION_VAL_350_CHS },
         { "360", OPTION_VAL_360_CHS },
         { "370", OPTION_VAL_370_CHS },
         { "380", OPTION_VAL_380_CHS },
         { "390", OPTION_VAL_390_CHS },
         { "400", OPTION_VAL_400_CHS },
         { "410", OPTION_VAL_410_CHS },
         { "420", OPTION_VAL_420_CHS },
         { "430", OPTION_VAL_430_CHS },
         { "440", OPTION_VAL_440_CHS },
         { "450", OPTION_VAL_450_CHS },
         { "460", OPTION_VAL_460_CHS },
         { "470", OPTION_VAL_470_CHS },
         { "480", OPTION_VAL_480_CHS },
         { "490", OPTION_VAL_490_CHS },
         { "500", OPTION_VAL_500_CHS },
         { "510", OPTION_VAL_510_CHS },
         { "520", OPTION_VAL_520_CHS },
         { "530", OPTION_VAL_530_CHS },
         { "540", OPTION_VAL_540_CHS },
         { "550", OPTION_VAL_550_CHS },
         { "560", OPTION_VAL_560_CHS },
         { "570", OPTION_VAL_570_CHS },
         { "580", OPTION_VAL_580_CHS },
         { "590", OPTION_VAL_590_CHS },
         { "600", OPTION_VAL_600_CHS },
         { "610", OPTION_VAL_610_CHS },
         { "620", OPTION_VAL_620_CHS },
         { "630", OPTION_VAL_630_CHS },
         { "640", OPTION_VAL_640_CHS },
         { "650", OPTION_VAL_650_CHS },
         { "660", OPTION_VAL_660_CHS },
         { "670", OPTION_VAL_670_CHS },
         { "680", OPTION_VAL_680_CHS },
         { "690", OPTION_VAL_690_CHS },
         { "700", OPTION_VAL_700_CHS },
         { "710", OPTION_VAL_710_CHS },
         { "720", OPTION_VAL_720_CHS },
         { "730", OPTION_VAL_730_CHS },
         { "740", OPTION_VAL_740_CHS },
         { "750", OPTION_VAL_750_CHS },
         { "760", OPTION_VAL_760_CHS },
         { "770", OPTION_VAL_770_CHS },
         { "780", OPTION_VAL_780_CHS },
         { "790", OPTION_VAL_790_CHS },
         { "800", OPTION_VAL_800_CHS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_CHS,
      NULL,
      BSNES_SGB_BIOS_INFO_0_CHS,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_CHS   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_CHS },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_CHS,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_CHS,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CHS,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CHS,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CHS,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CHS,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_VIDEO_LABEL_CHT "顯示"
#define CATEGORY_VIDEO_INFO_0_CHT "變更影像輸出的設定。"
#define CATEGORY_AUDIO_LABEL_CHT "音效"
#define CATEGORY_AUDIO_INFO_0_CHT "變更音效相關的設定。"
#define CATEGORY_MODE7_LABEL_CHT NULL
#define CATEGORY_MODE7_INFO_0_CHT NULL
#define CATEGORY_HACK_LABEL_CHT NULL
#define CATEGORY_HACK_INFO_0_CHT NULL
#define CATEGORY_OVERCLOCK_LABEL_CHT NULL
#define CATEGORY_OVERCLOCK_INFO_0_CHT NULL
#define CATEGORY_SGB_LABEL_CHT "Super Game Boy 介面卡"
#define CATEGORY_SGB_INFO_0_CHT NULL
#define CATEGORY_LIGHTGUN_LABEL_CHT "光線槍"
#define CATEGORY_LIGHTGUN_INFO_0_CHT NULL
#define BSNES_ASPECT_RATIO_LABEL_CHT NULL
#define BSNES_ASPECT_RATIO_INFO_0_CHT "設定畫面的寬高比, 僅限「設定/顯示/縮放」選項中, 設定「寬高比」為<核心參數>時使用。"
#define OPTION_VAL_AUTO_CHT "自動"
#define OPTION_VAL_1_1_CHT NULL
#define OPTION_VAL_4_3_CHT NULL
#define OPTION_VAL_NTSC_CHT NULL
#define OPTION_VAL_PAL_CHT NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_CHT "裁剪垂直過度掃描"
#define BSNES_PPU_OVERSCAN_V_INFO_0_CHT NULL
#define OPTION_VAL_0_CHT NULL
#define OPTION_VAL_8_CHT NULL
#define OPTION_VAL_12_CHT NULL
#define OPTION_VAL_16_CHT NULL
#define BSNES_BLUR_EMULATION_LABEL_CHT NULL
#define BSNES_BLUR_EMULATION_INFO_0_CHT NULL
#define BSNES_VIDEO_FILTER_LABEL_CHT "過濾器"
#define BSNES_VIDEO_FILTER_INFO_0_CHT NULL
#define OPTION_VAL_NONE_CHT "無"
#define OPTION_VAL_NTSC_RF_CHT NULL
#define OPTION_VAL_NTSC_COMPOSITE_CHT NULL
#define OPTION_VAL_NTSC_S_VIDEO_CHT NULL
#define OPTION_VAL_NTSC_RGB_CHT NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_CHT NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_CHT NULL
#define OPTION_VAL_0_O4_CHT NULL
#define OPTION_VAL_10_CHT NULL
#define OPTION_VAL_20_CHT NULL
#define OPTION_VAL_30_CHT NULL
#define OPTION_VAL_40_CHT NULL
#define OPTION_VAL_50_CHT NULL
#define OPTION_VAL_60_CHT NULL
#define OPTION_VAL_70_CHT NULL
#define OPTION_VAL_80_CHT NULL
#define OPTION_VAL_90_CHT NULL
#define OPTION_VAL_100_CHT "100% (預設)"
#define BSNES_VIDEO_SATURATION_LABEL_CHT NULL
#define BSNES_VIDEO_SATURATION_INFO_0_CHT NULL
#define OPTION_VAL_110_CHT NULL
#define OPTION_VAL_120_CHT NULL
#define OPTION_VAL_130_CHT NULL
#define OPTION_VAL_140_CHT NULL
#define OPTION_VAL_150_CHT NULL
#define OPTION_VAL_160_CHT NULL
#define OPTION_VAL_170_CHT NULL
#define OPTION_VAL_180_CHT NULL
#define OPTION_VAL_190_CHT NULL
#define OPTION_VAL_200_CHT NULL
#define BSNES_VIDEO_GAMMA_LABEL_CHT NULL
#define BSNES_VIDEO_GAMMA_INFO_0_CHT NULL
#define OPTION_VAL_100_O6_CHT NULL
#define OPTION_VAL_150_O6_CHT NULL
#define BSNES_PPU_FAST_LABEL_CHT NULL
#define BSNES_PPU_FAST_LABEL_CAT_CHT NULL
#define BSNES_PPU_FAST_INFO_0_CHT NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CHT NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_CHT NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_CHT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CHT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CHT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CHT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CHT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CHT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CHT NULL
#define BSNES_DSP_FAST_LABEL_CHT NULL
#define BSNES_DSP_FAST_LABEL_CAT_CHT NULL
#define BSNES_DSP_FAST_INFO_0_CHT NULL
#define BSNES_DSP_CUBIC_LABEL_CHT NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_CHT NULL
#define BSNES_DSP_CUBIC_INFO_0_CHT NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CHT NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CHT NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_CHT NULL
#define BSNES_MODE7_SCALE_LABEL_CHT NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_CHT "縮放"
#define BSNES_MODE7_SCALE_INFO_0_CHT NULL
#define OPTION_VAL_1X_CHT "240p (1倍)"
#define OPTION_VAL_2X_CHT "480p (2倍)"
#define OPTION_VAL_3X_CHT "720p (3倍)"
#define OPTION_VAL_4X_CHT "960p (4倍)"
#define OPTION_VAL_5X_CHT "1200p (5倍)"
#define OPTION_VAL_6X_CHT "1440p (6倍)"
#define OPTION_VAL_7X_CHT "1680p (7倍)"
#define OPTION_VAL_8X_CHT "1920p (8倍)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CHT NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CHT NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_CHT NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CHT NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CHT NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_CHT NULL
#define BSNES_MODE7_MOSAIC_LABEL_CHT NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_CHT NULL
#define BSNES_MODE7_MOSAIC_INFO_0_CHT NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_CHT NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_CHT NULL
#define OPTION_VAL_1_CHT "1幀數"
#define OPTION_VAL_2_CHT "2幀數"
#define OPTION_VAL_3_CHT "3幀數"
#define OPTION_VAL_4_CHT "4幀數"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CHT NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CHT NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_CHT NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CHT NULL
#define BSNES_HOTFIXES_LABEL_CHT NULL
#define BSNES_HOTFIXES_INFO_0_CHT NULL
#define BSNES_ENTROPY_LABEL_CHT NULL
#define BSNES_ENTROPY_INFO_0_CHT NULL
#define OPTION_VAL_LOW_CHT "低"
#define OPTION_VAL_HIGH_CHT "高"
#define BSNES_CPU_FASTMATH_LABEL_CHT NULL
#define BSNES_CPU_FASTMATH_INFO_0_CHT NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CHT "CPU 超頻中"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_CHT NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_CHT NULL
#define OPTION_VAL_210_CHT NULL
#define OPTION_VAL_220_CHT NULL
#define OPTION_VAL_230_CHT NULL
#define OPTION_VAL_240_CHT NULL
#define OPTION_VAL_250_CHT NULL
#define OPTION_VAL_260_CHT NULL
#define OPTION_VAL_270_CHT NULL
#define OPTION_VAL_280_CHT NULL
#define OPTION_VAL_290_CHT NULL
#define OPTION_VAL_300_CHT NULL
#define OPTION_VAL_310_CHT NULL
#define OPTION_VAL_320_CHT NULL
#define OPTION_VAL_330_CHT NULL
#define OPTION_VAL_340_CHT NULL
#define OPTION_VAL_350_CHT NULL
#define OPTION_VAL_360_CHT NULL
#define OPTION_VAL_370_CHT NULL
#define OPTION_VAL_380_CHT NULL
#define OPTION_VAL_390_CHT NULL
#define OPTION_VAL_400_CHT NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CHT NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CHT NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_CHT NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CHT NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CHT NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_CHT NULL
#define OPTION_VAL_410_CHT NULL
#define OPTION_VAL_420_CHT NULL
#define OPTION_VAL_430_CHT NULL
#define OPTION_VAL_440_CHT NULL
#define OPTION_VAL_450_CHT NULL
#define OPTION_VAL_460_CHT NULL
#define OPTION_VAL_470_CHT NULL
#define OPTION_VAL_480_CHT NULL
#define OPTION_VAL_490_CHT NULL
#define OPTION_VAL_500_CHT NULL
#define OPTION_VAL_510_CHT NULL
#define OPTION_VAL_520_CHT NULL
#define OPTION_VAL_530_CHT NULL
#define OPTION_VAL_540_CHT NULL
#define OPTION_VAL_550_CHT NULL
#define OPTION_VAL_560_CHT NULL
#define OPTION_VAL_570_CHT NULL
#define OPTION_VAL_580_CHT NULL
#define OPTION_VAL_590_CHT NULL
#define OPTION_VAL_600_CHT NULL
#define OPTION_VAL_610_CHT NULL
#define OPTION_VAL_620_CHT NULL
#define OPTION_VAL_630_CHT NULL
#define OPTION_VAL_640_CHT NULL
#define OPTION_VAL_650_CHT NULL
#define OPTION_VAL_660_CHT NULL
#define OPTION_VAL_670_CHT NULL
#define OPTION_VAL_680_CHT NULL
#define OPTION_VAL_690_CHT NULL
#define OPTION_VAL_700_CHT NULL
#define OPTION_VAL_710_CHT NULL
#define OPTION_VAL_720_CHT NULL
#define OPTION_VAL_730_CHT NULL
#define OPTION_VAL_740_CHT NULL
#define OPTION_VAL_750_CHT NULL
#define OPTION_VAL_760_CHT NULL
#define OPTION_VAL_770_CHT NULL
#define OPTION_VAL_780_CHT NULL
#define OPTION_VAL_790_CHT NULL
#define OPTION_VAL_800_CHT NULL
#define BSNES_SGB_BIOS_LABEL_CHT NULL
#define BSNES_SGB_BIOS_INFO_0_CHT NULL
#define OPTION_VAL_SGB1_SFC_CHT "Super Game Boy 介面卡 (SGB1.sfc)"
#define OPTION_VAL_SGB2_SFC_CHT "Super Game Boy 2 介面卡 (SGB2.sfc)"
#define BSNES_HIDE_SGB_BORDER_LABEL_CHT NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_CHT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CHT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CHT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CHT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CHT NULL

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHT,
      CATEGORY_VIDEO_INFO_0_CHT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CHT,
      CATEGORY_AUDIO_INFO_0_CHT
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_CHT,
      CATEGORY_MODE7_INFO_0_CHT
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_CHT,
      CATEGORY_HACK_INFO_0_CHT
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_CHT,
      CATEGORY_OVERCLOCK_INFO_0_CHT
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_CHT,
      CATEGORY_SGB_INFO_0_CHT
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_CHT,
      CATEGORY_LIGHTGUN_INFO_0_CHT
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_CHT,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_CHT,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_CHT },
         { "1:1",  OPTION_VAL_1_1_CHT },
         { "4:3",  OPTION_VAL_4_3_CHT },
         { "NTSC", OPTION_VAL_NTSC_CHT },
         { "PAL",  OPTION_VAL_PAL_CHT },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_CHT,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_CHT },
         { "8",  OPTION_VAL_8_CHT },
         { "12", OPTION_VAL_12_CHT },
         { "16", OPTION_VAL_16_CHT },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_CHT,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_CHT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_CHT,
      BSNES_VIDEO_FILTER_LABEL_CHT,
      BSNES_VIDEO_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_CHT },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_CHT },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_CHT },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_CHT },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_CHT },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_CHT,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CHT },
         { "10", OPTION_VAL_10_CHT },
         { "20", OPTION_VAL_20_CHT },
         { "30", OPTION_VAL_30_CHT },
         { "40", OPTION_VAL_40_CHT },
         { "50", OPTION_VAL_50_CHT },
         { "60", OPTION_VAL_60_CHT },
         { "70", OPTION_VAL_70_CHT },
         { "80", OPTION_VAL_80_CHT },
         { "90", OPTION_VAL_90_CHT },
         { "100", OPTION_VAL_100_CHT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_CHT,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CHT },
         { "10", OPTION_VAL_10_CHT },
         { "20", OPTION_VAL_20_CHT },
         { "30", OPTION_VAL_30_CHT },
         { "40", OPTION_VAL_40_CHT },
         { "50", OPTION_VAL_50_CHT },
         { "60", OPTION_VAL_60_CHT },
         { "70", OPTION_VAL_70_CHT },
         { "80", OPTION_VAL_80_CHT },
         { "90", OPTION_VAL_90_CHT },
         { "100", OPTION_VAL_100_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_CHT,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_CHT,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_O6_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_CHT,
      BSNES_PPU_FAST_LABEL_CAT_CHT,
      BSNES_PPU_FAST_INFO_0_CHT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_CHT,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_CHT,
      BSNES_PPU_DEINTERLACE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CHT,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CHT,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CHT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CHT,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CHT,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_CHT,
      BSNES_DSP_FAST_LABEL_CAT_CHT,
      BSNES_DSP_FAST_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_CHT,
      BSNES_DSP_CUBIC_LABEL_CAT_CHT,
      BSNES_DSP_CUBIC_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_CHT,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CHT,
      BSNES_DSP_ECHO_SHADOW_INFO_0_CHT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_CHT,
      BSNES_MODE7_SCALE_LABEL_CAT_CHT,
      BSNES_MODE7_SCALE_INFO_0_CHT,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_CHT  },
         { "2x", OPTION_VAL_2X_CHT  },
         { "3x", OPTION_VAL_3X_CHT  },
         { "4x", OPTION_VAL_4X_CHT  },
         { "5x", OPTION_VAL_5X_CHT },
         { "6x", OPTION_VAL_6X_CHT },
         { "7x", OPTION_VAL_7X_CHT },
         { "8x", OPTION_VAL_8X_CHT },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_CHT,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CHT,
      BSNES_MODE7_PERSPECTIVE_INFO_0_CHT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_CHT,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CHT,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_CHT,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_CHT,
      BSNES_MODE7_MOSAIC_LABEL_CAT_CHT,
      BSNES_MODE7_MOSAIC_INFO_0_CHT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_CHT,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_CHT  },
         { "2",   OPTION_VAL_2_CHT },
         { "3",   OPTION_VAL_3_CHT },
         { "4",   OPTION_VAL_4_CHT },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CHT,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_CHT,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_CHT,
      NULL,
      BSNES_HOTFIXES_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_CHT,
      NULL,
      BSNES_ENTROPY_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_CHT },
         { "High", OPTION_VAL_HIGH_CHT },
         { "None", OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_CHT,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_CHT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_CHT,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_CHT,
      BSNES_CPU_OVERCLOCK_INFO_0_CHT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHT  },
         { "20",  OPTION_VAL_20_CHT  },
         { "30",  OPTION_VAL_30_CHT  },
         { "40",  OPTION_VAL_40_CHT  },
         { "50",  OPTION_VAL_50_CHT  },
         { "60",  OPTION_VAL_60_CHT  },
         { "70",  OPTION_VAL_70_CHT  },
         { "80",  OPTION_VAL_80_CHT  },
         { "90",  OPTION_VAL_90_CHT  },
         { "100", OPTION_VAL_100_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { "210", OPTION_VAL_210_CHT },
         { "220", OPTION_VAL_220_CHT },
         { "230", OPTION_VAL_230_CHT },
         { "240", OPTION_VAL_240_CHT },
         { "250", OPTION_VAL_250_CHT },
         { "260", OPTION_VAL_260_CHT },
         { "270", OPTION_VAL_270_CHT },
         { "280", OPTION_VAL_280_CHT },
         { "290", OPTION_VAL_290_CHT },
         { "300", OPTION_VAL_300_CHT },
         { "310", OPTION_VAL_310_CHT },
         { "320", OPTION_VAL_320_CHT },
         { "330", OPTION_VAL_330_CHT },
         { "340", OPTION_VAL_340_CHT },
         { "350", OPTION_VAL_350_CHT },
         { "360", OPTION_VAL_360_CHT },
         { "370", OPTION_VAL_370_CHT },
         { "380", OPTION_VAL_380_CHT },
         { "390", OPTION_VAL_390_CHT },
         { "400", OPTION_VAL_400_CHT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CHT,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CHT,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_CHT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHT  },
         { "20",  OPTION_VAL_20_CHT  },
         { "30",  OPTION_VAL_30_CHT  },
         { "40",  OPTION_VAL_40_CHT  },
         { "50",  OPTION_VAL_50_CHT  },
         { "60",  OPTION_VAL_60_CHT  },
         { "70",  OPTION_VAL_70_CHT  },
         { "80",  OPTION_VAL_80_CHT  },
         { "90",  OPTION_VAL_90_CHT  },
         { "100", OPTION_VAL_100_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { "210", OPTION_VAL_210_CHT },
         { "220", OPTION_VAL_220_CHT },
         { "230", OPTION_VAL_230_CHT },
         { "240", OPTION_VAL_240_CHT },
         { "250", OPTION_VAL_250_CHT },
         { "260", OPTION_VAL_260_CHT },
         { "270", OPTION_VAL_270_CHT },
         { "280", OPTION_VAL_280_CHT },
         { "290", OPTION_VAL_290_CHT },
         { "300", OPTION_VAL_300_CHT },
         { "310", OPTION_VAL_310_CHT },
         { "320", OPTION_VAL_320_CHT },
         { "330", OPTION_VAL_330_CHT },
         { "340", OPTION_VAL_340_CHT },
         { "350", OPTION_VAL_350_CHT },
         { "360", OPTION_VAL_360_CHT },
         { "370", OPTION_VAL_370_CHT },
         { "380", OPTION_VAL_380_CHT },
         { "390", OPTION_VAL_390_CHT },
         { "400", OPTION_VAL_400_CHT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CHT,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CHT,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_CHT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CHT  },
         { "20",  OPTION_VAL_20_CHT  },
         { "30",  OPTION_VAL_30_CHT  },
         { "40",  OPTION_VAL_40_CHT  },
         { "50",  OPTION_VAL_50_CHT  },
         { "60",  OPTION_VAL_60_CHT  },
         { "70",  OPTION_VAL_70_CHT  },
         { "80",  OPTION_VAL_80_CHT  },
         { "90",  OPTION_VAL_90_CHT  },
         { "100", OPTION_VAL_100_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { "210", OPTION_VAL_210_CHT },
         { "220", OPTION_VAL_220_CHT },
         { "230", OPTION_VAL_230_CHT },
         { "240", OPTION_VAL_240_CHT },
         { "250", OPTION_VAL_250_CHT },
         { "260", OPTION_VAL_260_CHT },
         { "270", OPTION_VAL_270_CHT },
         { "280", OPTION_VAL_280_CHT },
         { "290", OPTION_VAL_290_CHT },
         { "300", OPTION_VAL_300_CHT },
         { "310", OPTION_VAL_310_CHT },
         { "320", OPTION_VAL_320_CHT },
         { "330", OPTION_VAL_330_CHT },
         { "340", OPTION_VAL_340_CHT },
         { "350", OPTION_VAL_350_CHT },
         { "360", OPTION_VAL_360_CHT },
         { "370", OPTION_VAL_370_CHT },
         { "380", OPTION_VAL_380_CHT },
         { "390", OPTION_VAL_390_CHT },
         { "400", OPTION_VAL_400_CHT },
         { "410", OPTION_VAL_410_CHT },
         { "420", OPTION_VAL_420_CHT },
         { "430", OPTION_VAL_430_CHT },
         { "440", OPTION_VAL_440_CHT },
         { "450", OPTION_VAL_450_CHT },
         { "460", OPTION_VAL_460_CHT },
         { "470", OPTION_VAL_470_CHT },
         { "480", OPTION_VAL_480_CHT },
         { "490", OPTION_VAL_490_CHT },
         { "500", OPTION_VAL_500_CHT },
         { "510", OPTION_VAL_510_CHT },
         { "520", OPTION_VAL_520_CHT },
         { "530", OPTION_VAL_530_CHT },
         { "540", OPTION_VAL_540_CHT },
         { "550", OPTION_VAL_550_CHT },
         { "560", OPTION_VAL_560_CHT },
         { "570", OPTION_VAL_570_CHT },
         { "580", OPTION_VAL_580_CHT },
         { "590", OPTION_VAL_590_CHT },
         { "600", OPTION_VAL_600_CHT },
         { "610", OPTION_VAL_610_CHT },
         { "620", OPTION_VAL_620_CHT },
         { "630", OPTION_VAL_630_CHT },
         { "640", OPTION_VAL_640_CHT },
         { "650", OPTION_VAL_650_CHT },
         { "660", OPTION_VAL_660_CHT },
         { "670", OPTION_VAL_670_CHT },
         { "680", OPTION_VAL_680_CHT },
         { "690", OPTION_VAL_690_CHT },
         { "700", OPTION_VAL_700_CHT },
         { "710", OPTION_VAL_710_CHT },
         { "720", OPTION_VAL_720_CHT },
         { "730", OPTION_VAL_730_CHT },
         { "740", OPTION_VAL_740_CHT },
         { "750", OPTION_VAL_750_CHT },
         { "760", OPTION_VAL_760_CHT },
         { "770", OPTION_VAL_770_CHT },
         { "780", OPTION_VAL_780_CHT },
         { "790", OPTION_VAL_790_CHT },
         { "800", OPTION_VAL_800_CHT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_CHT,
      NULL,
      BSNES_SGB_BIOS_INFO_0_CHT,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_CHT   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_CHT },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_CHT,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_CHT,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CHT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CHT,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CHT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CHT,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_VIDEO_LABEL_CS NULL
#define CATEGORY_VIDEO_INFO_0_CS "Změnit nastavení video výstupu."
#define CATEGORY_AUDIO_LABEL_CS "Zvuk"
#define CATEGORY_AUDIO_INFO_0_CS "Změnit nastavení výstupu zvuku."
#define CATEGORY_MODE7_LABEL_CS NULL
#define CATEGORY_MODE7_INFO_0_CS "Změna nastavení emulace grafiky v režimu 7."
#define CATEGORY_HACK_LABEL_CS "Hacky a vylepšení emulace"
#define CATEGORY_HACK_INFO_0_CS "Použijte emulační hacky, vylepšení a opravy."
#define CATEGORY_OVERCLOCK_LABEL_CS "Přetaktování/Snížení Taktu"
#define CATEGORY_OVERCLOCK_INFO_0_CS "Změna rychlosti emulovaného hardwaru."
#define CATEGORY_SGB_LABEL_CS NULL
#define CATEGORY_SGB_INFO_0_CS "Změna nastavení emulace Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_CS NULL
#define CATEGORY_LIGHTGUN_INFO_0_CS "Změna nastavení (dotykové obrazovky) světelné pistole."
#define BSNES_ASPECT_RATIO_LABEL_CS "Preferovaný Poměr Stran"
#define BSNES_ASPECT_RATIO_INFO_0_CS "Zvolte preferovaný poměr stran obsahu. To se použije pouze v případě, že je poměr stran aplikace RetroArch v nastavení videa nastaven na hodnotu 'Poskytnuté Jádro'."
#define OPTION_VAL_AUTO_CS "Automatické"
#define OPTION_VAL_1_1_CS NULL
#define OPTION_VAL_4_3_CS NULL
#define OPTION_VAL_NTSC_CS NULL
#define OPTION_VAL_PAL_CS NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_CS "Oříznutí Vertikálního Přesahu"
#define BSNES_PPU_OVERSCAN_V_INFO_0_CS "Odstraňte čáry N z horní a dolní části obrazovky, abyste simulovali rámeček televizoru z doby SNES."
#define OPTION_VAL_0_CS "0 řádků"
#define OPTION_VAL_8_CS "8 řádků"
#define OPTION_VAL_12_CS "12 řádků"
#define OPTION_VAL_16_CS "16 řádků"
#define BSNES_BLUR_EMULATION_LABEL_CS "Emulace Rozostření"
#define BSNES_BLUR_EMULATION_INFO_0_CS "Simuluje omezené horizontální rozlišení televizorů SDTV rozmazáním horizontálně sousedících pixelů. Některé hry na tom závisejí, aby napodobily efekt průhlednosti."
#define BSNES_VIDEO_FILTER_LABEL_CS "Filtr"
#define BSNES_VIDEO_FILTER_INFO_0_CS "Vyberte si mezi filtrem bez filtrování a filtrem NTSC společnosti Blargg s možnostmi pro RF, kompozitní, S-Video nebo RGB"
#define OPTION_VAL_NONE_CS "Žádná"
#define OPTION_VAL_NTSC_RF_CS NULL
#define OPTION_VAL_NTSC_COMPOSITE_CS "NTSC (Kompozitní)"
#define OPTION_VAL_NTSC_S_VIDEO_CS NULL
#define OPTION_VAL_NTSC_RGB_CS NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_CS "Úprava barev - Jas"
#define BSNES_VIDEO_LUMINANCE_INFO_0_CS "Nastavení jasu"
#define OPTION_VAL_0_O4_CS NULL
#define OPTION_VAL_10_CS NULL
#define OPTION_VAL_20_CS NULL
#define OPTION_VAL_30_CS NULL
#define OPTION_VAL_40_CS NULL
#define OPTION_VAL_50_CS NULL
#define OPTION_VAL_60_CS NULL
#define OPTION_VAL_70_CS NULL
#define OPTION_VAL_80_CS NULL
#define OPTION_VAL_90_CS NULL
#define OPTION_VAL_100_CS "100% (výchozí)"
#define BSNES_VIDEO_SATURATION_LABEL_CS "Úprava barev - Sytost"
#define BSNES_VIDEO_SATURATION_INFO_0_CS "Nastavení sytosti"
#define OPTION_VAL_110_CS NULL
#define OPTION_VAL_120_CS NULL
#define OPTION_VAL_130_CS NULL
#define OPTION_VAL_140_CS NULL
#define OPTION_VAL_150_CS NULL
#define OPTION_VAL_160_CS NULL
#define OPTION_VAL_170_CS NULL
#define OPTION_VAL_180_CS NULL
#define OPTION_VAL_190_CS NULL
#define OPTION_VAL_200_CS NULL
#define BSNES_VIDEO_GAMMA_LABEL_CS "Úprava barev - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_CS "Nastavení gamma"
#define OPTION_VAL_100_O6_CS NULL
#define OPTION_VAL_150_O6_CS "150 % (výchozí)"
#define BSNES_PPU_FAST_LABEL_CS "PPU (Video) - Rychlý Režim"
#define BSNES_PPU_FAST_LABEL_CAT_CS "PPU - Rychlý Režim"
#define BSNES_PPU_FAST_INFO_0_CS "Umožňuje rychlejší emulaci PPU za cenu menšího snížení přesnosti. Doporučujeme ponechat tuto funkci zapnutou. POZNÁMKA: tato funkce musí být zapnutá, aby fungovaly možnosti \"Odstranění prokladu\", \"Žádný limit spritu\" a \"HD režim 7\"."
#define BSNES_PPU_DEINTERLACE_LABEL_CS "PPU (Video) - Odstranění Prokladu"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_CS "PPU - Odstranění Prokladu"
#define BSNES_PPU_DEINTERLACE_INFO_0_CS "Odstraňte prokládání všech her interním vykreslováním v rozlišení 480p. Snížení výkonu je téměř nulové, takže se doporučuje ponechat tuto funkci zapnutou."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CS "PPU (Video) - Žádný Limit Spritu"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CS "PPU - Žádný Limit Spritu"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CS "Odstranění omezení počtu spritů, které lze současně vykreslit na obrazovku. Může způsobit problémy v některých hrách."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CS "PPU (Video) - Bez Blokování VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CS "PPU - Bez blokování VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CS "Emulace chyb ve starších verzích ZSNES a Snes9x, kdy nebylo emulováno blokování VRAM. Několik starších ROM hacků na toto chování spoléhalo a pokud není povoleno, vykresluje grafiku nesprávně. Tato volba je extrémně nepřesná a poškozuje rychlost PPU, takže ji doporučujeme nechat vypnutou, pokud nepotřebujete hrát hru, která je jinak s tímto jádrem nekompatibilní."
#define BSNES_DSP_FAST_LABEL_CS "DSP (Zvuk) - Rychlý Režim"
#define BSNES_DSP_FAST_LABEL_CAT_CS "DSP - Rychlý Režim"
#define BSNES_DSP_FAST_INFO_0_CS "Umožňuje rychlejší emulaci DSP za cenu menšího snížení přesnosti. Doporučujeme ponechat tuto funkci zapnutou."
#define BSNES_DSP_CUBIC_LABEL_CS "DSP (Zvuk) - Kubická Interpolace"
#define BSNES_DSP_CUBIC_LABEL_CAT_CS "DSP - Kubická Interpolace"
#define BSNES_DSP_CUBIC_INFO_0_CS "Použijte na zvuk kubickou interpolaci, čímž zachováte větší část vysokého rozsahu."
#define BSNES_DSP_ECHO_SHADOW_LABEL_CS "DSP (Zvuk) - Zdvojení p. RAM pro Ozvěny"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CS "DSP - Zdvojení p. RAM pro Ozvěny"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_CS "Emulace chyby v ZSNES, kdy byla echo RAM považována za oddělenou od APU RAM. Mnoho starších ROM hacků pro Super Mario World se na toto chování spoléhalo a bez něj budou padat. Tato volba je extrémně nepřesná a neměla by být povolena, pokud to není nutné."
#define BSNES_MODE7_SCALE_LABEL_CS "Režim HD 7 - Škálování"
#define BSNES_MODE7_SCALE_LABEL_CAT_CS "Škála"
#define BSNES_MODE7_SCALE_INFO_0_CS "Zvyšte horizontální a vertikální rozlišení grafiky režimu 7 používané v některých hrách."
#define OPTION_VAL_1X_CS NULL
#define OPTION_VAL_2X_CS NULL
#define OPTION_VAL_3X_CS NULL
#define OPTION_VAL_4X_CS NULL
#define OPTION_VAL_5X_CS NULL
#define OPTION_VAL_6X_CS NULL
#define OPTION_VAL_7X_CS NULL
#define OPTION_VAL_8X_CS NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CS "Režim HD 7 - Perspektivní Korekce"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CS "Perspektivní Korekce"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_CS "Oprava perspektivy grafiky v režimu Mode 7 používané v některých hrách obejitím některých omezení celočíselné matematiky používané systémem SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CS NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CS "Supervzorkování"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_CS "Supersamplování grafiky režimu 7 používané v některých hrách. V kombinaci s vyššími faktory měřítka režimu 7 vytváří efekt podobný anti-aliasingu."
#define BSNES_MODE7_MOSAIC_LABEL_CS "HD Mód 7 - HD->SD Mozaika"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_CS "HD->SD Mozaika"
#define BSNES_MODE7_MOSAIC_INFO_0_CS "Zobrazení mozaikového efektu grafiky v režimu 7 i při zvýšení jejího měřítka."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_CS "Vnitřní Předběžné Spuštění"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_CS "Simulujte systém předem a vraťte se zpět, abyste snížili vstupní zpoždění. Má velmi vysoké systémové požadavky."
#define OPTION_VAL_1_CS "1 snímek"
#define OPTION_VAL_2_CS "2 snímky"
#define OPTION_VAL_3_CS "3 snímky"
#define OPTION_VAL_4_CS "4 snímky"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CS "Koprocesory - Rychlý Režim"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CS "Umožňuje rychlejší emulaci koprocesorů za cenu menšího snížení přesnosti. Doporučujeme ponechat tuto funkci zapnutou."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_CS "Koprocesory - Preferovat HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CS "Pokud je tato možnost povolena, bude vždy použita méně přesná emulace HLE, pokud je k dispozici. Pokud je tato možnost zakázána, bude HLE použita pouze v případě, že chybí firmware LLE."
#define BSNES_HOTFIXES_LABEL_CS "Horké Opravy"
#define BSNES_HOTFIXES_INFO_0_CS "Dokonce i komerčně licencovaný a oficiálně vydaný software je někdy dodáván s chybami. Tato možnost opraví některé problémy, které se vyskytly i na skutečném hardwaru."
#define BSNES_ENTROPY_LABEL_CS "Entropie (náhodna volba)"
#define BSNES_ENTROPY_INFO_0_CS "Zvolte úroveň náhodné volby paměti a registrů. Pokud je nastavena hodnota žádná, jsou všechny paměti a registry při spuštění inicializovány na konstantní hodnoty. Nízká úroveň náhodné v. poskytuje nejpřesnější reprezentaci skutečného systému. Vysoká náhodná v. co nejvíce."
#define OPTION_VAL_LOW_CS "Nízká"
#define OPTION_VAL_HIGH_CS "Vysoká"
#define BSNES_CPU_FASTMATH_LABEL_CS "Rychlé Výpočty CPU"
#define BSNES_CPU_FASTMATH_INFO_0_CS "Okamžitě poskytněte výsledky výpočtů. Násobení a dělení procesorem trvá na skutečném SNESu dlouho. Starší emulátory tyto prodlevy nesimulovaly, a proto některé starší ROM hacky nečekají na dokončení matematických operací a potřebují tento hack."
#define BSNES_CPU_OVERCLOCK_LABEL_CS "Přetaktování - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_CS NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_CS "Přetaktování nebo snížení taktu procesoru. Nastavení této hodnoty nad 100 % může zkrátit dobu načítání a odstranit zpomalení. Používejte s opatrností, protože může také způsobit pád některých her nebo jiné problémy."
#define OPTION_VAL_210_CS NULL
#define OPTION_VAL_220_CS NULL
#define OPTION_VAL_230_CS NULL
#define OPTION_VAL_240_CS NULL
#define OPTION_VAL_250_CS NULL
#define OPTION_VAL_260_CS NULL
#define OPTION_VAL_270_CS NULL
#define OPTION_VAL_280_CS NULL
#define OPTION_VAL_290_CS NULL
#define OPTION_VAL_300_CS NULL
#define OPTION_VAL_310_CS NULL
#define OPTION_VAL_320_CS NULL
#define OPTION_VAL_330_CS NULL
#define OPTION_VAL_340_CS NULL
#define OPTION_VAL_350_CS NULL
#define OPTION_VAL_360_CS NULL
#define OPTION_VAL_370_CS NULL
#define OPTION_VAL_380_CS NULL
#define OPTION_VAL_390_CS NULL
#define OPTION_VAL_400_CS NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CS "Přetaktování - Koprocesoru SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CS "Koprocesor SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_CS "Přetaktování nebo snížení taktu čipu Super Accelerator 1 (SA-1). Nastavení této hodnoty nad 100 % může zlepšit výkon ve hrách, které podporují čip SA-1. Používejte ji s opatrností, protože může také způsobit pád některých her nebo jiné problémy."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CS "Přetaktování - Koprocesoru SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CS "Koprocesor SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_CS "Přetaktování nebo snížení taktu koprocesoru SuperFX. Nastavení této hodnoty nad 100 % může zlepšit výkon ve hrách, které podporují SuperFX. Používejte jej s opatrností, protože může také způsobit pád některých her nebo jiné problémy."
#define OPTION_VAL_410_CS NULL
#define OPTION_VAL_420_CS NULL
#define OPTION_VAL_430_CS NULL
#define OPTION_VAL_440_CS NULL
#define OPTION_VAL_450_CS NULL
#define OPTION_VAL_460_CS NULL
#define OPTION_VAL_470_CS NULL
#define OPTION_VAL_480_CS NULL
#define OPTION_VAL_490_CS NULL
#define OPTION_VAL_500_CS NULL
#define OPTION_VAL_510_CS NULL
#define OPTION_VAL_520_CS NULL
#define OPTION_VAL_530_CS NULL
#define OPTION_VAL_540_CS NULL
#define OPTION_VAL_550_CS NULL
#define OPTION_VAL_560_CS NULL
#define OPTION_VAL_570_CS NULL
#define OPTION_VAL_580_CS NULL
#define OPTION_VAL_590_CS NULL
#define OPTION_VAL_600_CS NULL
#define OPTION_VAL_610_CS NULL
#define OPTION_VAL_620_CS NULL
#define OPTION_VAL_630_CS NULL
#define OPTION_VAL_640_CS NULL
#define OPTION_VAL_650_CS NULL
#define OPTION_VAL_660_CS NULL
#define OPTION_VAL_670_CS NULL
#define OPTION_VAL_680_CS NULL
#define OPTION_VAL_690_CS NULL
#define OPTION_VAL_700_CS NULL
#define OPTION_VAL_710_CS NULL
#define OPTION_VAL_720_CS NULL
#define OPTION_VAL_730_CS NULL
#define OPTION_VAL_740_CS NULL
#define OPTION_VAL_750_CS NULL
#define OPTION_VAL_760_CS NULL
#define OPTION_VAL_770_CS NULL
#define OPTION_VAL_780_CS NULL
#define OPTION_VAL_790_CS NULL
#define OPTION_VAL_800_CS NULL
#define BSNES_SGB_BIOS_LABEL_CS "Upřednostňovaný systém Super Game Boy BIOS (nutný restart)"
#define BSNES_SGB_BIOS_INFO_0_CS "Vyberte preferovaný systém Super Game Boy BIOS pro použití s kompatibilními tituly."
#define OPTION_VAL_SGB1_SFC_CS NULL
#define OPTION_VAL_SGB2_SFC_CS NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_CS "Skrýt Hranici SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_CS "Skrýt okraj při hraní her pro Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CS "Světelná Pistole s Dotykovou Obrazovkou"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CS "Povolit vstup Super Scope pro dotyková zařízení."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CS "Obrácení Tlačítek Střelby Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CS "Obraťte tlačítka spouště a kurzoru Super Scope pomocí světelné pistole s dotykovou obrazovkou."

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CS,
      CATEGORY_VIDEO_INFO_0_CS
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CS,
      CATEGORY_AUDIO_INFO_0_CS
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_CS,
      CATEGORY_MODE7_INFO_0_CS
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_CS,
      CATEGORY_HACK_INFO_0_CS
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_CS,
      CATEGORY_OVERCLOCK_INFO_0_CS
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_CS,
      CATEGORY_SGB_INFO_0_CS
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_CS,
      CATEGORY_LIGHTGUN_INFO_0_CS
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_CS,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_CS,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_CS },
         { "1:1",  OPTION_VAL_1_1_CS },
         { "4:3",  OPTION_VAL_4_3_CS },
         { "NTSC", OPTION_VAL_NTSC_CS },
         { "PAL",  OPTION_VAL_PAL_CS },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_CS,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_CS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_CS },
         { "8",  OPTION_VAL_8_CS },
         { "12", OPTION_VAL_12_CS },
         { "16", OPTION_VAL_16_CS },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_CS,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_CS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_CS,
      BSNES_VIDEO_FILTER_LABEL_CS,
      BSNES_VIDEO_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_CS },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_CS },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_CS },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_CS },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_CS },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_CS,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_CS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CS },
         { "10", OPTION_VAL_10_CS },
         { "20", OPTION_VAL_20_CS },
         { "30", OPTION_VAL_30_CS },
         { "40", OPTION_VAL_40_CS },
         { "50", OPTION_VAL_50_CS },
         { "60", OPTION_VAL_60_CS },
         { "70", OPTION_VAL_70_CS },
         { "80", OPTION_VAL_80_CS },
         { "90", OPTION_VAL_90_CS },
         { "100", OPTION_VAL_100_CS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_CS,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_CS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CS },
         { "10", OPTION_VAL_10_CS },
         { "20", OPTION_VAL_20_CS },
         { "30", OPTION_VAL_30_CS },
         { "40", OPTION_VAL_40_CS },
         { "50", OPTION_VAL_50_CS },
         { "60", OPTION_VAL_60_CS },
         { "70", OPTION_VAL_70_CS },
         { "80", OPTION_VAL_80_CS },
         { "90", OPTION_VAL_90_CS },
         { "100", OPTION_VAL_100_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_CS,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_CS,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_O6_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_CS,
      BSNES_PPU_FAST_LABEL_CAT_CS,
      BSNES_PPU_FAST_INFO_0_CS,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_CS,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_CS,
      BSNES_PPU_DEINTERLACE_INFO_0_CS,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CS,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CS,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CS,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CS,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CS,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_CS,
      BSNES_DSP_FAST_LABEL_CAT_CS,
      BSNES_DSP_FAST_INFO_0_CS,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_CS,
      BSNES_DSP_CUBIC_LABEL_CAT_CS,
      BSNES_DSP_CUBIC_INFO_0_CS,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_CS,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CS,
      BSNES_DSP_ECHO_SHADOW_INFO_0_CS,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_CS,
      BSNES_MODE7_SCALE_LABEL_CAT_CS,
      BSNES_MODE7_SCALE_INFO_0_CS,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_CS  },
         { "2x", OPTION_VAL_2X_CS  },
         { "3x", OPTION_VAL_3X_CS  },
         { "4x", OPTION_VAL_4X_CS  },
         { "5x", OPTION_VAL_5X_CS },
         { "6x", OPTION_VAL_6X_CS },
         { "7x", OPTION_VAL_7X_CS },
         { "8x", OPTION_VAL_8X_CS },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_CS,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CS,
      BSNES_MODE7_PERSPECTIVE_INFO_0_CS,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_CS,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CS,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_CS,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_CS,
      BSNES_MODE7_MOSAIC_LABEL_CAT_CS,
      BSNES_MODE7_MOSAIC_INFO_0_CS,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_CS,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_CS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_CS  },
         { "2",   OPTION_VAL_2_CS },
         { "3",   OPTION_VAL_3_CS },
         { "4",   OPTION_VAL_4_CS },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CS,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CS,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_CS,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CS,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_CS,
      NULL,
      BSNES_HOTFIXES_INFO_0_CS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_CS,
      NULL,
      BSNES_ENTROPY_INFO_0_CS,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_CS },
         { "High", OPTION_VAL_HIGH_CS },
         { "None", OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_CS,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_CS,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_CS,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_CS,
      BSNES_CPU_OVERCLOCK_INFO_0_CS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CS  },
         { "20",  OPTION_VAL_20_CS  },
         { "30",  OPTION_VAL_30_CS  },
         { "40",  OPTION_VAL_40_CS  },
         { "50",  OPTION_VAL_50_CS  },
         { "60",  OPTION_VAL_60_CS  },
         { "70",  OPTION_VAL_70_CS  },
         { "80",  OPTION_VAL_80_CS  },
         { "90",  OPTION_VAL_90_CS  },
         { "100", OPTION_VAL_100_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { "210", OPTION_VAL_210_CS },
         { "220", OPTION_VAL_220_CS },
         { "230", OPTION_VAL_230_CS },
         { "240", OPTION_VAL_240_CS },
         { "250", OPTION_VAL_250_CS },
         { "260", OPTION_VAL_260_CS },
         { "270", OPTION_VAL_270_CS },
         { "280", OPTION_VAL_280_CS },
         { "290", OPTION_VAL_290_CS },
         { "300", OPTION_VAL_300_CS },
         { "310", OPTION_VAL_310_CS },
         { "320", OPTION_VAL_320_CS },
         { "330", OPTION_VAL_330_CS },
         { "340", OPTION_VAL_340_CS },
         { "350", OPTION_VAL_350_CS },
         { "360", OPTION_VAL_360_CS },
         { "370", OPTION_VAL_370_CS },
         { "380", OPTION_VAL_380_CS },
         { "390", OPTION_VAL_390_CS },
         { "400", OPTION_VAL_400_CS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CS,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CS,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_CS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CS  },
         { "20",  OPTION_VAL_20_CS  },
         { "30",  OPTION_VAL_30_CS  },
         { "40",  OPTION_VAL_40_CS  },
         { "50",  OPTION_VAL_50_CS  },
         { "60",  OPTION_VAL_60_CS  },
         { "70",  OPTION_VAL_70_CS  },
         { "80",  OPTION_VAL_80_CS  },
         { "90",  OPTION_VAL_90_CS  },
         { "100", OPTION_VAL_100_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { "210", OPTION_VAL_210_CS },
         { "220", OPTION_VAL_220_CS },
         { "230", OPTION_VAL_230_CS },
         { "240", OPTION_VAL_240_CS },
         { "250", OPTION_VAL_250_CS },
         { "260", OPTION_VAL_260_CS },
         { "270", OPTION_VAL_270_CS },
         { "280", OPTION_VAL_280_CS },
         { "290", OPTION_VAL_290_CS },
         { "300", OPTION_VAL_300_CS },
         { "310", OPTION_VAL_310_CS },
         { "320", OPTION_VAL_320_CS },
         { "330", OPTION_VAL_330_CS },
         { "340", OPTION_VAL_340_CS },
         { "350", OPTION_VAL_350_CS },
         { "360", OPTION_VAL_360_CS },
         { "370", OPTION_VAL_370_CS },
         { "380", OPTION_VAL_380_CS },
         { "390", OPTION_VAL_390_CS },
         { "400", OPTION_VAL_400_CS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CS,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CS,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_CS,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CS  },
         { "20",  OPTION_VAL_20_CS  },
         { "30",  OPTION_VAL_30_CS  },
         { "40",  OPTION_VAL_40_CS  },
         { "50",  OPTION_VAL_50_CS  },
         { "60",  OPTION_VAL_60_CS  },
         { "70",  OPTION_VAL_70_CS  },
         { "80",  OPTION_VAL_80_CS  },
         { "90",  OPTION_VAL_90_CS  },
         { "100", OPTION_VAL_100_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { "210", OPTION_VAL_210_CS },
         { "220", OPTION_VAL_220_CS },
         { "230", OPTION_VAL_230_CS },
         { "240", OPTION_VAL_240_CS },
         { "250", OPTION_VAL_250_CS },
         { "260", OPTION_VAL_260_CS },
         { "270", OPTION_VAL_270_CS },
         { "280", OPTION_VAL_280_CS },
         { "290", OPTION_VAL_290_CS },
         { "300", OPTION_VAL_300_CS },
         { "310", OPTION_VAL_310_CS },
         { "320", OPTION_VAL_320_CS },
         { "330", OPTION_VAL_330_CS },
         { "340", OPTION_VAL_340_CS },
         { "350", OPTION_VAL_350_CS },
         { "360", OPTION_VAL_360_CS },
         { "370", OPTION_VAL_370_CS },
         { "380", OPTION_VAL_380_CS },
         { "390", OPTION_VAL_390_CS },
         { "400", OPTION_VAL_400_CS },
         { "410", OPTION_VAL_410_CS },
         { "420", OPTION_VAL_420_CS },
         { "430", OPTION_VAL_430_CS },
         { "440", OPTION_VAL_440_CS },
         { "450", OPTION_VAL_450_CS },
         { "460", OPTION_VAL_460_CS },
         { "470", OPTION_VAL_470_CS },
         { "480", OPTION_VAL_480_CS },
         { "490", OPTION_VAL_490_CS },
         { "500", OPTION_VAL_500_CS },
         { "510", OPTION_VAL_510_CS },
         { "520", OPTION_VAL_520_CS },
         { "530", OPTION_VAL_530_CS },
         { "540", OPTION_VAL_540_CS },
         { "550", OPTION_VAL_550_CS },
         { "560", OPTION_VAL_560_CS },
         { "570", OPTION_VAL_570_CS },
         { "580", OPTION_VAL_580_CS },
         { "590", OPTION_VAL_590_CS },
         { "600", OPTION_VAL_600_CS },
         { "610", OPTION_VAL_610_CS },
         { "620", OPTION_VAL_620_CS },
         { "630", OPTION_VAL_630_CS },
         { "640", OPTION_VAL_640_CS },
         { "650", OPTION_VAL_650_CS },
         { "660", OPTION_VAL_660_CS },
         { "670", OPTION_VAL_670_CS },
         { "680", OPTION_VAL_680_CS },
         { "690", OPTION_VAL_690_CS },
         { "700", OPTION_VAL_700_CS },
         { "710", OPTION_VAL_710_CS },
         { "720", OPTION_VAL_720_CS },
         { "730", OPTION_VAL_730_CS },
         { "740", OPTION_VAL_740_CS },
         { "750", OPTION_VAL_750_CS },
         { "760", OPTION_VAL_760_CS },
         { "770", OPTION_VAL_770_CS },
         { "780", OPTION_VAL_780_CS },
         { "790", OPTION_VAL_790_CS },
         { "800", OPTION_VAL_800_CS },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_CS,
      NULL,
      BSNES_SGB_BIOS_INFO_0_CS,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_CS   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_CS },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_CS,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_CS,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CS,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CS,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CS,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CS,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_VIDEO_LABEL_CY NULL
#define CATEGORY_VIDEO_INFO_0_CY NULL
#define CATEGORY_AUDIO_LABEL_CY NULL
#define CATEGORY_AUDIO_INFO_0_CY NULL
#define CATEGORY_MODE7_LABEL_CY NULL
#define CATEGORY_MODE7_INFO_0_CY NULL
#define CATEGORY_HACK_LABEL_CY NULL
#define CATEGORY_HACK_INFO_0_CY NULL
#define CATEGORY_OVERCLOCK_LABEL_CY NULL
#define CATEGORY_OVERCLOCK_INFO_0_CY NULL
#define CATEGORY_SGB_LABEL_CY NULL
#define CATEGORY_SGB_INFO_0_CY NULL
#define CATEGORY_LIGHTGUN_LABEL_CY NULL
#define CATEGORY_LIGHTGUN_INFO_0_CY NULL
#define BSNES_ASPECT_RATIO_LABEL_CY NULL
#define BSNES_ASPECT_RATIO_INFO_0_CY NULL
#define OPTION_VAL_AUTO_CY NULL
#define OPTION_VAL_1_1_CY NULL
#define OPTION_VAL_4_3_CY NULL
#define OPTION_VAL_NTSC_CY NULL
#define OPTION_VAL_PAL_CY NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_CY NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_CY NULL
#define OPTION_VAL_0_CY NULL
#define OPTION_VAL_8_CY NULL
#define OPTION_VAL_12_CY NULL
#define OPTION_VAL_16_CY NULL
#define BSNES_BLUR_EMULATION_LABEL_CY NULL
#define BSNES_BLUR_EMULATION_INFO_0_CY NULL
#define BSNES_VIDEO_FILTER_LABEL_CY NULL
#define BSNES_VIDEO_FILTER_INFO_0_CY NULL
#define OPTION_VAL_NONE_CY "Dim"
#define OPTION_VAL_NTSC_RF_CY NULL
#define OPTION_VAL_NTSC_COMPOSITE_CY NULL
#define OPTION_VAL_NTSC_S_VIDEO_CY NULL
#define OPTION_VAL_NTSC_RGB_CY NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_CY NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_CY NULL
#define OPTION_VAL_0_O4_CY NULL
#define OPTION_VAL_10_CY NULL
#define OPTION_VAL_20_CY NULL
#define OPTION_VAL_30_CY NULL
#define OPTION_VAL_40_CY NULL
#define OPTION_VAL_50_CY NULL
#define OPTION_VAL_60_CY NULL
#define OPTION_VAL_70_CY NULL
#define OPTION_VAL_80_CY NULL
#define OPTION_VAL_90_CY NULL
#define OPTION_VAL_100_CY NULL
#define BSNES_VIDEO_SATURATION_LABEL_CY NULL
#define BSNES_VIDEO_SATURATION_INFO_0_CY NULL
#define OPTION_VAL_110_CY NULL
#define OPTION_VAL_120_CY NULL
#define OPTION_VAL_130_CY NULL
#define OPTION_VAL_140_CY NULL
#define OPTION_VAL_150_CY NULL
#define OPTION_VAL_160_CY NULL
#define OPTION_VAL_170_CY NULL
#define OPTION_VAL_180_CY NULL
#define OPTION_VAL_190_CY NULL
#define OPTION_VAL_200_CY NULL
#define BSNES_VIDEO_GAMMA_LABEL_CY NULL
#define BSNES_VIDEO_GAMMA_INFO_0_CY NULL
#define OPTION_VAL_100_O6_CY NULL
#define OPTION_VAL_150_O6_CY NULL
#define BSNES_PPU_FAST_LABEL_CY NULL
#define BSNES_PPU_FAST_LABEL_CAT_CY NULL
#define BSNES_PPU_FAST_INFO_0_CY NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CY NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_CY NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_CY NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CY NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CY NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CY NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CY NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CY NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CY NULL
#define BSNES_DSP_FAST_LABEL_CY NULL
#define BSNES_DSP_FAST_LABEL_CAT_CY NULL
#define BSNES_DSP_FAST_INFO_0_CY NULL
#define BSNES_DSP_CUBIC_LABEL_CY NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_CY NULL
#define BSNES_DSP_CUBIC_INFO_0_CY NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CY NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CY NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_CY NULL
#define BSNES_MODE7_SCALE_LABEL_CY NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_CY NULL
#define BSNES_MODE7_SCALE_INFO_0_CY NULL
#define OPTION_VAL_1X_CY NULL
#define OPTION_VAL_2X_CY NULL
#define OPTION_VAL_3X_CY NULL
#define OPTION_VAL_4X_CY NULL
#define OPTION_VAL_5X_CY NULL
#define OPTION_VAL_6X_CY NULL
#define OPTION_VAL_7X_CY NULL
#define OPTION_VAL_8X_CY NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CY NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CY NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_CY NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CY NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CY NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_CY NULL
#define BSNES_MODE7_MOSAIC_LABEL_CY NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_CY NULL
#define BSNES_MODE7_MOSAIC_INFO_0_CY NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_CY NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_CY NULL
#define OPTION_VAL_1_CY NULL
#define OPTION_VAL_2_CY NULL
#define OPTION_VAL_3_CY NULL
#define OPTION_VAL_4_CY NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CY NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CY NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_CY NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CY NULL
#define BSNES_HOTFIXES_LABEL_CY NULL
#define BSNES_HOTFIXES_INFO_0_CY NULL
#define BSNES_ENTROPY_LABEL_CY NULL
#define BSNES_ENTROPY_INFO_0_CY NULL
#define OPTION_VAL_LOW_CY NULL
#define OPTION_VAL_HIGH_CY NULL
#define BSNES_CPU_FASTMATH_LABEL_CY NULL
#define BSNES_CPU_FASTMATH_INFO_0_CY NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CY NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_CY NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_CY NULL
#define OPTION_VAL_210_CY NULL
#define OPTION_VAL_220_CY NULL
#define OPTION_VAL_230_CY NULL
#define OPTION_VAL_240_CY NULL
#define OPTION_VAL_250_CY NULL
#define OPTION_VAL_260_CY NULL
#define OPTION_VAL_270_CY NULL
#define OPTION_VAL_280_CY NULL
#define OPTION_VAL_290_CY NULL
#define OPTION_VAL_300_CY NULL
#define OPTION_VAL_310_CY NULL
#define OPTION_VAL_320_CY NULL
#define OPTION_VAL_330_CY NULL
#define OPTION_VAL_340_CY NULL
#define OPTION_VAL_350_CY NULL
#define OPTION_VAL_360_CY NULL
#define OPTION_VAL_370_CY NULL
#define OPTION_VAL_380_CY NULL
#define OPTION_VAL_390_CY NULL
#define OPTION_VAL_400_CY NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CY NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CY NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_CY NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CY NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CY NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_CY NULL
#define OPTION_VAL_410_CY NULL
#define OPTION_VAL_420_CY NULL
#define OPTION_VAL_430_CY NULL
#define OPTION_VAL_440_CY NULL
#define OPTION_VAL_450_CY NULL
#define OPTION_VAL_460_CY NULL
#define OPTION_VAL_470_CY NULL
#define OPTION_VAL_480_CY NULL
#define OPTION_VAL_490_CY NULL
#define OPTION_VAL_500_CY NULL
#define OPTION_VAL_510_CY NULL
#define OPTION_VAL_520_CY NULL
#define OPTION_VAL_530_CY NULL
#define OPTION_VAL_540_CY NULL
#define OPTION_VAL_550_CY NULL
#define OPTION_VAL_560_CY NULL
#define OPTION_VAL_570_CY NULL
#define OPTION_VAL_580_CY NULL
#define OPTION_VAL_590_CY NULL
#define OPTION_VAL_600_CY NULL
#define OPTION_VAL_610_CY NULL
#define OPTION_VAL_620_CY NULL
#define OPTION_VAL_630_CY NULL
#define OPTION_VAL_640_CY NULL
#define OPTION_VAL_650_CY NULL
#define OPTION_VAL_660_CY NULL
#define OPTION_VAL_670_CY NULL
#define OPTION_VAL_680_CY NULL
#define OPTION_VAL_690_CY NULL
#define OPTION_VAL_700_CY NULL
#define OPTION_VAL_710_CY NULL
#define OPTION_VAL_720_CY NULL
#define OPTION_VAL_730_CY NULL
#define OPTION_VAL_740_CY NULL
#define OPTION_VAL_750_CY NULL
#define OPTION_VAL_760_CY NULL
#define OPTION_VAL_770_CY NULL
#define OPTION_VAL_780_CY NULL
#define OPTION_VAL_790_CY NULL
#define OPTION_VAL_800_CY NULL
#define BSNES_SGB_BIOS_LABEL_CY NULL
#define BSNES_SGB_BIOS_INFO_0_CY NULL
#define OPTION_VAL_SGB1_SFC_CY NULL
#define OPTION_VAL_SGB2_SFC_CY NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_CY NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_CY NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CY NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CY NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CY NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CY,
      CATEGORY_VIDEO_INFO_0_CY
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_CY,
      CATEGORY_AUDIO_INFO_0_CY
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_CY,
      CATEGORY_MODE7_INFO_0_CY
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_CY,
      CATEGORY_HACK_INFO_0_CY
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_CY,
      CATEGORY_OVERCLOCK_INFO_0_CY
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_CY,
      CATEGORY_SGB_INFO_0_CY
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_CY,
      CATEGORY_LIGHTGUN_INFO_0_CY
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_CY,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_CY,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_CY },
         { "1:1",  OPTION_VAL_1_1_CY },
         { "4:3",  OPTION_VAL_4_3_CY },
         { "NTSC", OPTION_VAL_NTSC_CY },
         { "PAL",  OPTION_VAL_PAL_CY },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_CY,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_CY,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_CY },
         { "8",  OPTION_VAL_8_CY },
         { "12", OPTION_VAL_12_CY },
         { "16", OPTION_VAL_16_CY },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_CY,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_CY,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_CY,
      BSNES_VIDEO_FILTER_LABEL_CY,
      BSNES_VIDEO_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_CY },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_CY },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_CY },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_CY },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_CY },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_CY,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_CY,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CY },
         { "10", OPTION_VAL_10_CY },
         { "20", OPTION_VAL_20_CY },
         { "30", OPTION_VAL_30_CY },
         { "40", OPTION_VAL_40_CY },
         { "50", OPTION_VAL_50_CY },
         { "60", OPTION_VAL_60_CY },
         { "70", OPTION_VAL_70_CY },
         { "80", OPTION_VAL_80_CY },
         { "90", OPTION_VAL_90_CY },
         { "100", OPTION_VAL_100_CY },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_CY,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_CY,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_CY },
         { "10", OPTION_VAL_10_CY },
         { "20", OPTION_VAL_20_CY },
         { "30", OPTION_VAL_30_CY },
         { "40", OPTION_VAL_40_CY },
         { "50", OPTION_VAL_50_CY },
         { "60", OPTION_VAL_60_CY },
         { "70", OPTION_VAL_70_CY },
         { "80", OPTION_VAL_80_CY },
         { "90", OPTION_VAL_90_CY },
         { "100", OPTION_VAL_100_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_CY,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_CY,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_O6_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_CY,
      BSNES_PPU_FAST_LABEL_CAT_CY,
      BSNES_PPU_FAST_INFO_0_CY,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_CY,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_CY,
      BSNES_PPU_DEINTERLACE_INFO_0_CY,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CY,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_CY,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_CY,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CY,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_CY,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_CY,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_CY,
      BSNES_DSP_FAST_LABEL_CAT_CY,
      BSNES_DSP_FAST_INFO_0_CY,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_CY,
      BSNES_DSP_CUBIC_LABEL_CAT_CY,
      BSNES_DSP_CUBIC_INFO_0_CY,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_CY,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_CY,
      BSNES_DSP_ECHO_SHADOW_INFO_0_CY,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_CY,
      BSNES_MODE7_SCALE_LABEL_CAT_CY,
      BSNES_MODE7_SCALE_INFO_0_CY,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_CY  },
         { "2x", OPTION_VAL_2X_CY  },
         { "3x", OPTION_VAL_3X_CY  },
         { "4x", OPTION_VAL_4X_CY  },
         { "5x", OPTION_VAL_5X_CY },
         { "6x", OPTION_VAL_6X_CY },
         { "7x", OPTION_VAL_7X_CY },
         { "8x", OPTION_VAL_8X_CY },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_CY,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_CY,
      BSNES_MODE7_PERSPECTIVE_INFO_0_CY,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_CY,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_CY,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_CY,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_CY,
      BSNES_MODE7_MOSAIC_LABEL_CAT_CY,
      BSNES_MODE7_MOSAIC_INFO_0_CY,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_CY,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_CY,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_CY  },
         { "2",   OPTION_VAL_2_CY },
         { "3",   OPTION_VAL_3_CY },
         { "4",   OPTION_VAL_4_CY },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_CY,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_CY,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_CY,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_CY,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_CY,
      NULL,
      BSNES_HOTFIXES_INFO_0_CY,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_CY,
      NULL,
      BSNES_ENTROPY_INFO_0_CY,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_CY },
         { "High", OPTION_VAL_HIGH_CY },
         { "None", OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_CY,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_CY,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_CY,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_CY,
      BSNES_CPU_OVERCLOCK_INFO_0_CY,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CY  },
         { "20",  OPTION_VAL_20_CY  },
         { "30",  OPTION_VAL_30_CY  },
         { "40",  OPTION_VAL_40_CY  },
         { "50",  OPTION_VAL_50_CY  },
         { "60",  OPTION_VAL_60_CY  },
         { "70",  OPTION_VAL_70_CY  },
         { "80",  OPTION_VAL_80_CY  },
         { "90",  OPTION_VAL_90_CY  },
         { "100", OPTION_VAL_100_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { "210", OPTION_VAL_210_CY },
         { "220", OPTION_VAL_220_CY },
         { "230", OPTION_VAL_230_CY },
         { "240", OPTION_VAL_240_CY },
         { "250", OPTION_VAL_250_CY },
         { "260", OPTION_VAL_260_CY },
         { "270", OPTION_VAL_270_CY },
         { "280", OPTION_VAL_280_CY },
         { "290", OPTION_VAL_290_CY },
         { "300", OPTION_VAL_300_CY },
         { "310", OPTION_VAL_310_CY },
         { "320", OPTION_VAL_320_CY },
         { "330", OPTION_VAL_330_CY },
         { "340", OPTION_VAL_340_CY },
         { "350", OPTION_VAL_350_CY },
         { "360", OPTION_VAL_360_CY },
         { "370", OPTION_VAL_370_CY },
         { "380", OPTION_VAL_380_CY },
         { "390", OPTION_VAL_390_CY },
         { "400", OPTION_VAL_400_CY },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CY,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_CY,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_CY,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CY  },
         { "20",  OPTION_VAL_20_CY  },
         { "30",  OPTION_VAL_30_CY  },
         { "40",  OPTION_VAL_40_CY  },
         { "50",  OPTION_VAL_50_CY  },
         { "60",  OPTION_VAL_60_CY  },
         { "70",  OPTION_VAL_70_CY  },
         { "80",  OPTION_VAL_80_CY  },
         { "90",  OPTION_VAL_90_CY  },
         { "100", OPTION_VAL_100_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { "210", OPTION_VAL_210_CY },
         { "220", OPTION_VAL_220_CY },
         { "230", OPTION_VAL_230_CY },
         { "240", OPTION_VAL_240_CY },
         { "250", OPTION_VAL_250_CY },
         { "260", OPTION_VAL_260_CY },
         { "270", OPTION_VAL_270_CY },
         { "280", OPTION_VAL_280_CY },
         { "290", OPTION_VAL_290_CY },
         { "300", OPTION_VAL_300_CY },
         { "310", OPTION_VAL_310_CY },
         { "320", OPTION_VAL_320_CY },
         { "330", OPTION_VAL_330_CY },
         { "340", OPTION_VAL_340_CY },
         { "350", OPTION_VAL_350_CY },
         { "360", OPTION_VAL_360_CY },
         { "370", OPTION_VAL_370_CY },
         { "380", OPTION_VAL_380_CY },
         { "390", OPTION_VAL_390_CY },
         { "400", OPTION_VAL_400_CY },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CY,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_CY,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_CY,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_CY  },
         { "20",  OPTION_VAL_20_CY  },
         { "30",  OPTION_VAL_30_CY  },
         { "40",  OPTION_VAL_40_CY  },
         { "50",  OPTION_VAL_50_CY  },
         { "60",  OPTION_VAL_60_CY  },
         { "70",  OPTION_VAL_70_CY  },
         { "80",  OPTION_VAL_80_CY  },
         { "90",  OPTION_VAL_90_CY  },
         { "100", OPTION_VAL_100_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { "210", OPTION_VAL_210_CY },
         { "220", OPTION_VAL_220_CY },
         { "230", OPTION_VAL_230_CY },
         { "240", OPTION_VAL_240_CY },
         { "250", OPTION_VAL_250_CY },
         { "260", OPTION_VAL_260_CY },
         { "270", OPTION_VAL_270_CY },
         { "280", OPTION_VAL_280_CY },
         { "290", OPTION_VAL_290_CY },
         { "300", OPTION_VAL_300_CY },
         { "310", OPTION_VAL_310_CY },
         { "320", OPTION_VAL_320_CY },
         { "330", OPTION_VAL_330_CY },
         { "340", OPTION_VAL_340_CY },
         { "350", OPTION_VAL_350_CY },
         { "360", OPTION_VAL_360_CY },
         { "370", OPTION_VAL_370_CY },
         { "380", OPTION_VAL_380_CY },
         { "390", OPTION_VAL_390_CY },
         { "400", OPTION_VAL_400_CY },
         { "410", OPTION_VAL_410_CY },
         { "420", OPTION_VAL_420_CY },
         { "430", OPTION_VAL_430_CY },
         { "440", OPTION_VAL_440_CY },
         { "450", OPTION_VAL_450_CY },
         { "460", OPTION_VAL_460_CY },
         { "470", OPTION_VAL_470_CY },
         { "480", OPTION_VAL_480_CY },
         { "490", OPTION_VAL_490_CY },
         { "500", OPTION_VAL_500_CY },
         { "510", OPTION_VAL_510_CY },
         { "520", OPTION_VAL_520_CY },
         { "530", OPTION_VAL_530_CY },
         { "540", OPTION_VAL_540_CY },
         { "550", OPTION_VAL_550_CY },
         { "560", OPTION_VAL_560_CY },
         { "570", OPTION_VAL_570_CY },
         { "580", OPTION_VAL_580_CY },
         { "590", OPTION_VAL_590_CY },
         { "600", OPTION_VAL_600_CY },
         { "610", OPTION_VAL_610_CY },
         { "620", OPTION_VAL_620_CY },
         { "630", OPTION_VAL_630_CY },
         { "640", OPTION_VAL_640_CY },
         { "650", OPTION_VAL_650_CY },
         { "660", OPTION_VAL_660_CY },
         { "670", OPTION_VAL_670_CY },
         { "680", OPTION_VAL_680_CY },
         { "690", OPTION_VAL_690_CY },
         { "700", OPTION_VAL_700_CY },
         { "710", OPTION_VAL_710_CY },
         { "720", OPTION_VAL_720_CY },
         { "730", OPTION_VAL_730_CY },
         { "740", OPTION_VAL_740_CY },
         { "750", OPTION_VAL_750_CY },
         { "760", OPTION_VAL_760_CY },
         { "770", OPTION_VAL_770_CY },
         { "780", OPTION_VAL_780_CY },
         { "790", OPTION_VAL_790_CY },
         { "800", OPTION_VAL_800_CY },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_CY,
      NULL,
      BSNES_SGB_BIOS_INFO_0_CY,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_CY   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_CY },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_CY,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_CY,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_CY,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_CY,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_CY,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_CY,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_VIDEO_LABEL_DA NULL
#define CATEGORY_VIDEO_INFO_0_DA "Skift indstillinger for videooutput."
#define CATEGORY_AUDIO_LABEL_DA "Lyd"
#define CATEGORY_AUDIO_INFO_0_DA "Skift indstillinger for lydudgang."
#define CATEGORY_MODE7_LABEL_DA NULL
#define CATEGORY_MODE7_INFO_0_DA NULL
#define CATEGORY_HACK_LABEL_DA NULL
#define CATEGORY_HACK_INFO_0_DA NULL
#define CATEGORY_OVERCLOCK_LABEL_DA NULL
#define CATEGORY_OVERCLOCK_INFO_0_DA NULL
#define CATEGORY_SGB_LABEL_DA NULL
#define CATEGORY_SGB_INFO_0_DA NULL
#define CATEGORY_LIGHTGUN_LABEL_DA NULL
#define CATEGORY_LIGHTGUN_INFO_0_DA NULL
#define BSNES_ASPECT_RATIO_LABEL_DA NULL
#define BSNES_ASPECT_RATIO_INFO_0_DA NULL
#define OPTION_VAL_AUTO_DA NULL
#define OPTION_VAL_1_1_DA NULL
#define OPTION_VAL_4_3_DA NULL
#define OPTION_VAL_NTSC_DA NULL
#define OPTION_VAL_PAL_DA NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_DA NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_DA NULL
#define OPTION_VAL_0_DA NULL
#define OPTION_VAL_8_DA NULL
#define OPTION_VAL_12_DA NULL
#define OPTION_VAL_16_DA NULL
#define BSNES_BLUR_EMULATION_LABEL_DA NULL
#define BSNES_BLUR_EMULATION_INFO_0_DA NULL
#define BSNES_VIDEO_FILTER_LABEL_DA NULL
#define BSNES_VIDEO_FILTER_INFO_0_DA NULL
#define OPTION_VAL_NONE_DA NULL
#define OPTION_VAL_NTSC_RF_DA NULL
#define OPTION_VAL_NTSC_COMPOSITE_DA NULL
#define OPTION_VAL_NTSC_S_VIDEO_DA NULL
#define OPTION_VAL_NTSC_RGB_DA NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_DA NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_DA NULL
#define OPTION_VAL_0_O4_DA NULL
#define OPTION_VAL_10_DA NULL
#define OPTION_VAL_20_DA NULL
#define OPTION_VAL_30_DA NULL
#define OPTION_VAL_40_DA NULL
#define OPTION_VAL_50_DA NULL
#define OPTION_VAL_60_DA NULL
#define OPTION_VAL_70_DA NULL
#define OPTION_VAL_80_DA NULL
#define OPTION_VAL_90_DA NULL
#define OPTION_VAL_100_DA NULL
#define BSNES_VIDEO_SATURATION_LABEL_DA NULL
#define BSNES_VIDEO_SATURATION_INFO_0_DA NULL
#define OPTION_VAL_110_DA NULL
#define OPTION_VAL_120_DA NULL
#define OPTION_VAL_130_DA NULL
#define OPTION_VAL_140_DA NULL
#define OPTION_VAL_150_DA NULL
#define OPTION_VAL_160_DA NULL
#define OPTION_VAL_170_DA NULL
#define OPTION_VAL_180_DA NULL
#define OPTION_VAL_190_DA NULL
#define OPTION_VAL_200_DA NULL
#define BSNES_VIDEO_GAMMA_LABEL_DA NULL
#define BSNES_VIDEO_GAMMA_INFO_0_DA NULL
#define OPTION_VAL_100_O6_DA NULL
#define OPTION_VAL_150_O6_DA NULL
#define BSNES_PPU_FAST_LABEL_DA NULL
#define BSNES_PPU_FAST_LABEL_CAT_DA NULL
#define BSNES_PPU_FAST_INFO_0_DA NULL
#define BSNES_PPU_DEINTERLACE_LABEL_DA NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_DA NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_DA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_DA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_DA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_DA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_DA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_DA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_DA NULL
#define BSNES_DSP_FAST_LABEL_DA NULL
#define BSNES_DSP_FAST_LABEL_CAT_DA NULL
#define BSNES_DSP_FAST_INFO_0_DA NULL
#define BSNES_DSP_CUBIC_LABEL_DA NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_DA NULL
#define BSNES_DSP_CUBIC_INFO_0_DA NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_DA NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_DA NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_DA NULL
#define BSNES_MODE7_SCALE_LABEL_DA NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_DA NULL
#define BSNES_MODE7_SCALE_INFO_0_DA NULL
#define OPTION_VAL_1X_DA NULL
#define OPTION_VAL_2X_DA NULL
#define OPTION_VAL_3X_DA NULL
#define OPTION_VAL_4X_DA NULL
#define OPTION_VAL_5X_DA NULL
#define OPTION_VAL_6X_DA NULL
#define OPTION_VAL_7X_DA NULL
#define OPTION_VAL_8X_DA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_DA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_DA NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_DA NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_DA NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_DA NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_DA NULL
#define BSNES_MODE7_MOSAIC_LABEL_DA NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_DA NULL
#define BSNES_MODE7_MOSAIC_INFO_0_DA NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_DA NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_DA NULL
#define OPTION_VAL_1_DA NULL
#define OPTION_VAL_2_DA NULL
#define OPTION_VAL_3_DA NULL
#define OPTION_VAL_4_DA NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_DA NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_DA NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_DA NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_DA NULL
#define BSNES_HOTFIXES_LABEL_DA NULL
#define BSNES_HOTFIXES_INFO_0_DA NULL
#define BSNES_ENTROPY_LABEL_DA NULL
#define BSNES_ENTROPY_INFO_0_DA NULL
#define OPTION_VAL_LOW_DA NULL
#define OPTION_VAL_HIGH_DA NULL
#define BSNES_CPU_FASTMATH_LABEL_DA NULL
#define BSNES_CPU_FASTMATH_INFO_0_DA NULL
#define BSNES_CPU_OVERCLOCK_LABEL_DA NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_DA NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_DA NULL
#define OPTION_VAL_210_DA NULL
#define OPTION_VAL_220_DA NULL
#define OPTION_VAL_230_DA NULL
#define OPTION_VAL_240_DA NULL
#define OPTION_VAL_250_DA NULL
#define OPTION_VAL_260_DA NULL
#define OPTION_VAL_270_DA NULL
#define OPTION_VAL_280_DA NULL
#define OPTION_VAL_290_DA NULL
#define OPTION_VAL_300_DA NULL
#define OPTION_VAL_310_DA NULL
#define OPTION_VAL_320_DA NULL
#define OPTION_VAL_330_DA NULL
#define OPTION_VAL_340_DA NULL
#define OPTION_VAL_350_DA NULL
#define OPTION_VAL_360_DA NULL
#define OPTION_VAL_370_DA NULL
#define OPTION_VAL_380_DA NULL
#define OPTION_VAL_390_DA NULL
#define OPTION_VAL_400_DA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_DA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_DA NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_DA NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_DA NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_DA NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_DA NULL
#define OPTION_VAL_410_DA NULL
#define OPTION_VAL_420_DA NULL
#define OPTION_VAL_430_DA NULL
#define OPTION_VAL_440_DA NULL
#define OPTION_VAL_450_DA NULL
#define OPTION_VAL_460_DA NULL
#define OPTION_VAL_470_DA NULL
#define OPTION_VAL_480_DA NULL
#define OPTION_VAL_490_DA NULL
#define OPTION_VAL_500_DA NULL
#define OPTION_VAL_510_DA NULL
#define OPTION_VAL_520_DA NULL
#define OPTION_VAL_530_DA NULL
#define OPTION_VAL_540_DA NULL
#define OPTION_VAL_550_DA NULL
#define OPTION_VAL_560_DA NULL
#define OPTION_VAL_570_DA NULL
#define OPTION_VAL_580_DA NULL
#define OPTION_VAL_590_DA NULL
#define OPTION_VAL_600_DA NULL
#define OPTION_VAL_610_DA NULL
#define OPTION_VAL_620_DA NULL
#define OPTION_VAL_630_DA NULL
#define OPTION_VAL_640_DA NULL
#define OPTION_VAL_650_DA NULL
#define OPTION_VAL_660_DA NULL
#define OPTION_VAL_670_DA NULL
#define OPTION_VAL_680_DA NULL
#define OPTION_VAL_690_DA NULL
#define OPTION_VAL_700_DA NULL
#define OPTION_VAL_710_DA NULL
#define OPTION_VAL_720_DA NULL
#define OPTION_VAL_730_DA NULL
#define OPTION_VAL_740_DA NULL
#define OPTION_VAL_750_DA NULL
#define OPTION_VAL_760_DA NULL
#define OPTION_VAL_770_DA NULL
#define OPTION_VAL_780_DA NULL
#define OPTION_VAL_790_DA NULL
#define OPTION_VAL_800_DA NULL
#define BSNES_SGB_BIOS_LABEL_DA NULL
#define BSNES_SGB_BIOS_INFO_0_DA NULL
#define OPTION_VAL_SGB1_SFC_DA NULL
#define OPTION_VAL_SGB2_SFC_DA NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_DA NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_DA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_DA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_DA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_DA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_DA,
      CATEGORY_VIDEO_INFO_0_DA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DA,
      CATEGORY_AUDIO_INFO_0_DA
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_DA,
      CATEGORY_MODE7_INFO_0_DA
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_DA,
      CATEGORY_HACK_INFO_0_DA
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_DA,
      CATEGORY_OVERCLOCK_INFO_0_DA
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_DA,
      CATEGORY_SGB_INFO_0_DA
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_DA,
      CATEGORY_LIGHTGUN_INFO_0_DA
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_DA,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_DA,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_DA },
         { "1:1",  OPTION_VAL_1_1_DA },
         { "4:3",  OPTION_VAL_4_3_DA },
         { "NTSC", OPTION_VAL_NTSC_DA },
         { "PAL",  OPTION_VAL_PAL_DA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_DA,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_DA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_DA },
         { "8",  OPTION_VAL_8_DA },
         { "12", OPTION_VAL_12_DA },
         { "16", OPTION_VAL_16_DA },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_DA,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_DA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_DA,
      BSNES_VIDEO_FILTER_LABEL_DA,
      BSNES_VIDEO_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_DA },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_DA },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_DA },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_DA },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_DA },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_DA,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_DA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_DA },
         { "10", OPTION_VAL_10_DA },
         { "20", OPTION_VAL_20_DA },
         { "30", OPTION_VAL_30_DA },
         { "40", OPTION_VAL_40_DA },
         { "50", OPTION_VAL_50_DA },
         { "60", OPTION_VAL_60_DA },
         { "70", OPTION_VAL_70_DA },
         { "80", OPTION_VAL_80_DA },
         { "90", OPTION_VAL_90_DA },
         { "100", OPTION_VAL_100_DA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_DA,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_DA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_DA },
         { "10", OPTION_VAL_10_DA },
         { "20", OPTION_VAL_20_DA },
         { "30", OPTION_VAL_30_DA },
         { "40", OPTION_VAL_40_DA },
         { "50", OPTION_VAL_50_DA },
         { "60", OPTION_VAL_60_DA },
         { "70", OPTION_VAL_70_DA },
         { "80", OPTION_VAL_80_DA },
         { "90", OPTION_VAL_90_DA },
         { "100", OPTION_VAL_100_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_DA,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_DA,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_O6_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_DA,
      BSNES_PPU_FAST_LABEL_CAT_DA,
      BSNES_PPU_FAST_INFO_0_DA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_DA,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_DA,
      BSNES_PPU_DEINTERLACE_INFO_0_DA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_DA,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_DA,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_DA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_DA,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_DA,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_DA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_DA,
      BSNES_DSP_FAST_LABEL_CAT_DA,
      BSNES_DSP_FAST_INFO_0_DA,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_DA,
      BSNES_DSP_CUBIC_LABEL_CAT_DA,
      BSNES_DSP_CUBIC_INFO_0_DA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_DA,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_DA,
      BSNES_DSP_ECHO_SHADOW_INFO_0_DA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_DA,
      BSNES_MODE7_SCALE_LABEL_CAT_DA,
      BSNES_MODE7_SCALE_INFO_0_DA,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_DA  },
         { "2x", OPTION_VAL_2X_DA  },
         { "3x", OPTION_VAL_3X_DA  },
         { "4x", OPTION_VAL_4X_DA  },
         { "5x", OPTION_VAL_5X_DA },
         { "6x", OPTION_VAL_6X_DA },
         { "7x", OPTION_VAL_7X_DA },
         { "8x", OPTION_VAL_8X_DA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_DA,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_DA,
      BSNES_MODE7_PERSPECTIVE_INFO_0_DA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_DA,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_DA,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_DA,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_DA,
      BSNES_MODE7_MOSAIC_LABEL_CAT_DA,
      BSNES_MODE7_MOSAIC_INFO_0_DA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_DA,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_DA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_DA  },
         { "2",   OPTION_VAL_2_DA },
         { "3",   OPTION_VAL_3_DA },
         { "4",   OPTION_VAL_4_DA },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_DA,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_DA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_DA,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_DA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_DA,
      NULL,
      BSNES_HOTFIXES_INFO_0_DA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_DA,
      NULL,
      BSNES_ENTROPY_INFO_0_DA,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_DA },
         { "High", OPTION_VAL_HIGH_DA },
         { "None", OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_DA,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_DA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_DA,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_DA,
      BSNES_CPU_OVERCLOCK_INFO_0_DA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DA  },
         { "20",  OPTION_VAL_20_DA  },
         { "30",  OPTION_VAL_30_DA  },
         { "40",  OPTION_VAL_40_DA  },
         { "50",  OPTION_VAL_50_DA  },
         { "60",  OPTION_VAL_60_DA  },
         { "70",  OPTION_VAL_70_DA  },
         { "80",  OPTION_VAL_80_DA  },
         { "90",  OPTION_VAL_90_DA  },
         { "100", OPTION_VAL_100_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { "210", OPTION_VAL_210_DA },
         { "220", OPTION_VAL_220_DA },
         { "230", OPTION_VAL_230_DA },
         { "240", OPTION_VAL_240_DA },
         { "250", OPTION_VAL_250_DA },
         { "260", OPTION_VAL_260_DA },
         { "270", OPTION_VAL_270_DA },
         { "280", OPTION_VAL_280_DA },
         { "290", OPTION_VAL_290_DA },
         { "300", OPTION_VAL_300_DA },
         { "310", OPTION_VAL_310_DA },
         { "320", OPTION_VAL_320_DA },
         { "330", OPTION_VAL_330_DA },
         { "340", OPTION_VAL_340_DA },
         { "350", OPTION_VAL_350_DA },
         { "360", OPTION_VAL_360_DA },
         { "370", OPTION_VAL_370_DA },
         { "380", OPTION_VAL_380_DA },
         { "390", OPTION_VAL_390_DA },
         { "400", OPTION_VAL_400_DA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_DA,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_DA,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_DA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DA  },
         { "20",  OPTION_VAL_20_DA  },
         { "30",  OPTION_VAL_30_DA  },
         { "40",  OPTION_VAL_40_DA  },
         { "50",  OPTION_VAL_50_DA  },
         { "60",  OPTION_VAL_60_DA  },
         { "70",  OPTION_VAL_70_DA  },
         { "80",  OPTION_VAL_80_DA  },
         { "90",  OPTION_VAL_90_DA  },
         { "100", OPTION_VAL_100_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { "210", OPTION_VAL_210_DA },
         { "220", OPTION_VAL_220_DA },
         { "230", OPTION_VAL_230_DA },
         { "240", OPTION_VAL_240_DA },
         { "250", OPTION_VAL_250_DA },
         { "260", OPTION_VAL_260_DA },
         { "270", OPTION_VAL_270_DA },
         { "280", OPTION_VAL_280_DA },
         { "290", OPTION_VAL_290_DA },
         { "300", OPTION_VAL_300_DA },
         { "310", OPTION_VAL_310_DA },
         { "320", OPTION_VAL_320_DA },
         { "330", OPTION_VAL_330_DA },
         { "340", OPTION_VAL_340_DA },
         { "350", OPTION_VAL_350_DA },
         { "360", OPTION_VAL_360_DA },
         { "370", OPTION_VAL_370_DA },
         { "380", OPTION_VAL_380_DA },
         { "390", OPTION_VAL_390_DA },
         { "400", OPTION_VAL_400_DA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_DA,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_DA,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_DA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DA  },
         { "20",  OPTION_VAL_20_DA  },
         { "30",  OPTION_VAL_30_DA  },
         { "40",  OPTION_VAL_40_DA  },
         { "50",  OPTION_VAL_50_DA  },
         { "60",  OPTION_VAL_60_DA  },
         { "70",  OPTION_VAL_70_DA  },
         { "80",  OPTION_VAL_80_DA  },
         { "90",  OPTION_VAL_90_DA  },
         { "100", OPTION_VAL_100_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { "210", OPTION_VAL_210_DA },
         { "220", OPTION_VAL_220_DA },
         { "230", OPTION_VAL_230_DA },
         { "240", OPTION_VAL_240_DA },
         { "250", OPTION_VAL_250_DA },
         { "260", OPTION_VAL_260_DA },
         { "270", OPTION_VAL_270_DA },
         { "280", OPTION_VAL_280_DA },
         { "290", OPTION_VAL_290_DA },
         { "300", OPTION_VAL_300_DA },
         { "310", OPTION_VAL_310_DA },
         { "320", OPTION_VAL_320_DA },
         { "330", OPTION_VAL_330_DA },
         { "340", OPTION_VAL_340_DA },
         { "350", OPTION_VAL_350_DA },
         { "360", OPTION_VAL_360_DA },
         { "370", OPTION_VAL_370_DA },
         { "380", OPTION_VAL_380_DA },
         { "390", OPTION_VAL_390_DA },
         { "400", OPTION_VAL_400_DA },
         { "410", OPTION_VAL_410_DA },
         { "420", OPTION_VAL_420_DA },
         { "430", OPTION_VAL_430_DA },
         { "440", OPTION_VAL_440_DA },
         { "450", OPTION_VAL_450_DA },
         { "460", OPTION_VAL_460_DA },
         { "470", OPTION_VAL_470_DA },
         { "480", OPTION_VAL_480_DA },
         { "490", OPTION_VAL_490_DA },
         { "500", OPTION_VAL_500_DA },
         { "510", OPTION_VAL_510_DA },
         { "520", OPTION_VAL_520_DA },
         { "530", OPTION_VAL_530_DA },
         { "540", OPTION_VAL_540_DA },
         { "550", OPTION_VAL_550_DA },
         { "560", OPTION_VAL_560_DA },
         { "570", OPTION_VAL_570_DA },
         { "580", OPTION_VAL_580_DA },
         { "590", OPTION_VAL_590_DA },
         { "600", OPTION_VAL_600_DA },
         { "610", OPTION_VAL_610_DA },
         { "620", OPTION_VAL_620_DA },
         { "630", OPTION_VAL_630_DA },
         { "640", OPTION_VAL_640_DA },
         { "650", OPTION_VAL_650_DA },
         { "660", OPTION_VAL_660_DA },
         { "670", OPTION_VAL_670_DA },
         { "680", OPTION_VAL_680_DA },
         { "690", OPTION_VAL_690_DA },
         { "700", OPTION_VAL_700_DA },
         { "710", OPTION_VAL_710_DA },
         { "720", OPTION_VAL_720_DA },
         { "730", OPTION_VAL_730_DA },
         { "740", OPTION_VAL_740_DA },
         { "750", OPTION_VAL_750_DA },
         { "760", OPTION_VAL_760_DA },
         { "770", OPTION_VAL_770_DA },
         { "780", OPTION_VAL_780_DA },
         { "790", OPTION_VAL_790_DA },
         { "800", OPTION_VAL_800_DA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_DA,
      NULL,
      BSNES_SGB_BIOS_INFO_0_DA,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_DA   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_DA },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_DA,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_DA,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_DA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_DA,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_DA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_DA,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_VIDEO_LABEL_DE NULL
#define CATEGORY_VIDEO_INFO_0_DE "Videoausgabe-Einstellungen ändern."
#define CATEGORY_AUDIO_LABEL_DE NULL
#define CATEGORY_AUDIO_INFO_0_DE "Audioausgabe-Einstellungen ändern."
#define CATEGORY_MODE7_LABEL_DE "HD-Modus 7"
#define CATEGORY_MODE7_INFO_0_DE "Einstellungen für die Emulation von Mode-7-Grafiken ändern."
#define CATEGORY_HACK_LABEL_DE "Emulationshacks und Verbesserungen"
#define CATEGORY_HACK_INFO_0_DE "Emulationshacks, Verbesserungen und Hotfixes anwenden."
#define CATEGORY_OVERCLOCK_LABEL_DE "Über-/Untertaktung"
#define CATEGORY_OVERCLOCK_INFO_0_DE "Die Geschwindigkeit der emulierten Hardware ändern."
#define CATEGORY_SGB_LABEL_DE NULL
#define CATEGORY_SGB_INFO_0_DE "Einstellungen für die Emulation des Super Game Boy ändern."
#define CATEGORY_LIGHTGUN_LABEL_DE "Lightgun"
#define CATEGORY_LIGHTGUN_INFO_0_DE "Einstellungen für (Touchscreen-)Lightgun ändern."
#define BSNES_ASPECT_RATIO_LABEL_DE "Bevorzugtes Seitenverhältnis"
#define BSNES_ASPECT_RATIO_INFO_0_DE "Das bevorzugte Seitenverhältnis des Inhalts auswählen. Dies wird nur angewendet, wenn das Seitenverhältnis von RetroArch in den Videoeinstellungen auf \"Wie von Core vorgesehen\" eingestellt ist."
#define OPTION_VAL_AUTO_DE "Automatisch"
#define OPTION_VAL_1_1_DE "1:1 PAR (Pixel Perfekt)"
#define OPTION_VAL_4_3_DE NULL
#define OPTION_VAL_NTSC_DE NULL
#define OPTION_VAL_PAL_DE NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_DE "Vertikalen Overscan zuschneiden"
#define BSNES_PPU_OVERSCAN_V_INFO_0_DE "N Zeilen oben und unten am Bildschirm entfernen, um die Umrandung eines Fernsehers aus der SNES-Zeit zu simulieren."
#define OPTION_VAL_0_DE "0 Zeilen"
#define OPTION_VAL_8_DE "8 Zeilen"
#define OPTION_VAL_12_DE "12 Zeilen"
#define OPTION_VAL_16_DE "16 Zeilen"
#define BSNES_BLUR_EMULATION_LABEL_DE "Unschärfe-Emulation"
#define BSNES_BLUR_EMULATION_INFO_0_DE "Die begrenzte horizontale Auflösung von SDTVs simulieren, indem horizontal benachbarte Pixel miteinander verwischt werden. Einige Spiele nutzen das, um einen Transparenzeffekt zu simulieren."
#define BSNES_VIDEO_FILTER_LABEL_DE NULL
#define BSNES_VIDEO_FILTER_INFO_0_DE "Wählt zwischen keiner Filterung und blarggs NTSC-Filter mit Optionen für RF, Composite, S-Video oder RGB"
#define OPTION_VAL_NONE_DE "Keine"
#define OPTION_VAL_NTSC_RF_DE NULL
#define OPTION_VAL_NTSC_COMPOSITE_DE NULL
#define OPTION_VAL_NTSC_S_VIDEO_DE NULL
#define OPTION_VAL_NTSC_RGB_DE NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_DE "Farbanpassung - Luminanz"
#define BSNES_VIDEO_LUMINANCE_INFO_0_DE "Luminanz anpassen"
#define OPTION_VAL_0_O4_DE "0 %"
#define OPTION_VAL_10_DE "10 %"
#define OPTION_VAL_20_DE "20 %"
#define OPTION_VAL_30_DE "30 %"
#define OPTION_VAL_40_DE "40 %"
#define OPTION_VAL_50_DE "50 %"
#define OPTION_VAL_60_DE "60 %"
#define OPTION_VAL_70_DE "70 %"
#define OPTION_VAL_80_DE "80 %"
#define OPTION_VAL_90_DE "90 %"
#define OPTION_VAL_100_DE "100 % (Standard)"
#define BSNES_VIDEO_SATURATION_LABEL_DE "Farbanpassung - Sättigung"
#define BSNES_VIDEO_SATURATION_INFO_0_DE "Sättigung anpassen"
#define OPTION_VAL_110_DE "110 %"
#define OPTION_VAL_120_DE "120 %"
#define OPTION_VAL_130_DE "130 %"
#define OPTION_VAL_140_DE "140 %"
#define OPTION_VAL_150_DE "150 %"
#define OPTION_VAL_160_DE "160 %"
#define OPTION_VAL_170_DE "170 %"
#define OPTION_VAL_180_DE "180 %"
#define OPTION_VAL_190_DE "190 %"
#define OPTION_VAL_200_DE "200 %"
#define BSNES_VIDEO_GAMMA_LABEL_DE "Farbanpassung - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_DE "Gamma anpassen"
#define OPTION_VAL_100_O6_DE "100 %"
#define OPTION_VAL_150_O6_DE "150 % (Standard)"
#define BSNES_PPU_FAST_LABEL_DE NULL
#define BSNES_PPU_FAST_LABEL_CAT_DE NULL
#define BSNES_PPU_FAST_INFO_0_DE "Aktiviert eine schnellere Emulation der PPU auf Kosten einer geringfügigen Reduktion der Genauigkeit. Es wird empfohlen, dies angeschaltet zu lassen. HINWEIS: Dies muss für die Optionen 'Deinterlace', 'Ohne Sprite-Begrenzung' und 'HD Modus 7' aktiviert sein."
#define BSNES_PPU_DEINTERLACE_LABEL_DE NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_DE NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_DE "Deinterlacing aller Spiele durch internes Rendern mit 480p. Ein Leistungsverlust ist fast nicht vorhanden, daher wird empfohlen, diese Option aktiviert zu lassen."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_DE "PPU (Video) - Ohne Sprite-Begrenzung"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_DE "PPU - Ohne Sprite-Begrenzung"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_DE "Jegliche Begrenzung der Anzahl von Sprites entfernen, die gleichzeitig auf dem Bildschirm gezeichnet werden können. Kann bei einigen Spielen zu Problemen führen."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_DE "PPU (Video) - Keine VRAM-Blockierung"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_DE "PPU - Keine VRAM Blockierung"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_DE "Emuliert einen Fehler in älteren Versionen von ZSNES und Snes9x, bei dem die VRAM-Blockierung nicht emuliert wurde. Einige ältere ROM-Hacks verlassen sich auf dieses Verhalten und stellen Grafiken falsch dar, wenn diese Option nicht aktiviert ist. Diese Option ist extrem ungenau und beeinträchtigt die PPU-Geschwindigkeit. Daher wird empfohlen, sie deaktiviert zu lassen, es sei denn, man hat ein Spiel, das ansonsten nicht mit diesem Core kompatibel ist."
#define BSNES_DSP_FAST_LABEL_DE "DSP (Audio) - Fast-Mode"
#define BSNES_DSP_FAST_LABEL_CAT_DE "DSP - Fast-Mode"
#define BSNES_DSP_FAST_INFO_0_DE "Schnellere Emulation des DSP aktivieren, auf Kosten einer geringfügigen Verringerung der Genauigkeit. Es wird empfohlen, diese Option aktiviert zu lassen."
#define BSNES_DSP_CUBIC_LABEL_DE "DSP (Audio) - Kubische Interpolation"
#define BSNES_DSP_CUBIC_LABEL_CAT_DE "DSP - Kubische Interpolation"
#define BSNES_DSP_CUBIC_INFO_0_DE "Kubische Interpolation auf den Klang anwenden, um den hohen Bereichs zu erhalten."
#define BSNES_DSP_ECHO_SHADOW_LABEL_DE "DSP (Audio) - Echo-Shadow-RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_DE "DSP - Echo-Shadow-RAM"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_DE "Emuliert einen Fehler in ZSNES, bei dem das Echo-RAM als getrennt vom APU-RAM behandelt wurde. Viele ältere ROM-Hacks für Super Mario World erwarten dieses Verhalten und stürzen ohne diese Option ab. Diese Option ist extrem ungenau und sollte nicht aktiviert werden, wenn sie nicht benötigt wird."
#define BSNES_MODE7_SCALE_LABEL_DE "HD Modus 7 - Skalierung"
#define BSNES_MODE7_SCALE_LABEL_CAT_DE "Skalierung"
#define BSNES_MODE7_SCALE_INFO_0_DE "Die horizontale und vertikale Auflösung der in bestimmten Spielen verwendeten Modi 7 erhöhen."
#define OPTION_VAL_1X_DE "240p (1×)"
#define OPTION_VAL_2X_DE "480p (2×)"
#define OPTION_VAL_3X_DE "720p (3×)"
#define OPTION_VAL_4X_DE "960p (4×)"
#define OPTION_VAL_5X_DE "1200p (5×)"
#define OPTION_VAL_6X_DE "1440p (6×)"
#define OPTION_VAL_7X_DE "1680p (7×)"
#define OPTION_VAL_8X_DE "1920p (8×)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_DE "HD Modus 7 - Perspektivkorrektur"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_DE "Perspektivkorrektur"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_DE "Die Perspektive der Mode-7-Grafiken korrigieren, die in bestimmten Spielen verwendet werden, indem einige Beschränkungen der von SNES verwendeten Integer-Mathematik umgangen werden."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_DE NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_DE NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_DE "Supersampling von Modus-7-Grafiken, das in bestimmten Spielen verwendet wird. In Kombination mit höheren Modus-7-Skalierungsfaktoren entsteht ein Effekt, der dem Anti-Aliasing ähnelt."
#define BSNES_MODE7_MOSAIC_LABEL_DE "HD Mode 7 - HD→SD-Mosaic"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_DE "HD→SD Mosaik"
#define BSNES_MODE7_MOSAIC_INFO_0_DE "Mosaikeffekt von Mode-7-Grafiken auch beim Hochskalieren anzeigen."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_DE "Internes Run-Ahead"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_DE "Das System im Voraus simulieren und zurückgehen, um die Eingabelatenz zu reduzieren. Hat sehr hohe Systemanforderungen."
#define OPTION_VAL_1_DE "1 Frame"
#define OPTION_VAL_2_DE "2 Frames"
#define OPTION_VAL_3_DE "3 Frames"
#define OPTION_VAL_4_DE "4 Frames"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_DE "Coprozessoren - Fast Mode"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_DE "Ermöglicht eine schnellere Emulation der Koprozessoren auf Kosten einer geringfügigen Verringerung der Genauigkeit. Es wird empfohlen, diese Option aktiviert zu lassen."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_DE "Koprozessoren - HLE bevorzugen"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_DE "Wenn diese Option aktiviert ist, wird immer die weniger genaue HLE-Emulation verwendet, sofern sie verfügbar ist. Ist sie deaktiviert, wird HLE nur verwendet, wenn keine LLE-Firmware vorhanden ist."
#define BSNES_HOTFIXES_LABEL_DE NULL
#define BSNES_HOTFIXES_INFO_0_DE "Selbst kommerziell lizenzierte und offiziell freigegebene Software wird manchmal mit Fehlern ausgeliefert. Mit dieser Option werden bestimmte Probleme behoben, die auch auf echter Hardware auftreten."
#define BSNES_ENTROPY_LABEL_DE "Entropie (Randomisierung)"
#define BSNES_ENTROPY_INFO_0_DE "Grad der Randomisierung des Speichers und der Register wählen. Bei der Einstellung „Keine“ werden alle Speicher und Register beim Start auf konstante Werte initialisiert. Niedrige Randomisierung bietet die genaueste Darstellung eines echten Systems. „Hoch\" randomisiert so viel wie möglich."
#define OPTION_VAL_LOW_DE "Niedrig"
#define OPTION_VAL_HIGH_DE "Hoch"
#define BSNES_CPU_FASTMATH_LABEL_DE "CPU Fast-Math"
#define BSNES_CPU_FASTMATH_INFO_0_DE "Sofortige Bereitstellung von Berechnungsergebnissen. CPU-Multiplikationen und -Divisionen benötigen auf einem echten SNES einige Zeit, um abgeschlossen zu werden. Ältere Emulatoren simulieren diese Verzögerungen nicht und deshalb warten einige ältere ROM-Hacks nicht auf das Ende von mathematischen Operationen und benötigen diesen Hack."
#define BSNES_CPU_OVERCLOCK_LABEL_DE "Übertaktung - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_DE "Prozessor"
#define BSNES_CPU_OVERCLOCK_INFO_0_DE "Übertakten oder Heruntertakten der CPU. Wird dieser Wert auf über 100 % eingestellt, können sich Ladezeiten verkürzen und Verlangsamung beseitigen. Doch mit Vorsicht anwenden, da dies auch zum Absturz einiger Spiele oder zu anderen Problemen führen kann."
#define OPTION_VAL_210_DE "210 %"
#define OPTION_VAL_220_DE "220 %"
#define OPTION_VAL_230_DE "230 %"
#define OPTION_VAL_240_DE "240 %"
#define OPTION_VAL_250_DE "250 %"
#define OPTION_VAL_260_DE "260 %"
#define OPTION_VAL_270_DE "270 %"
#define OPTION_VAL_280_DE "280 %"
#define OPTION_VAL_290_DE "290 %"
#define OPTION_VAL_300_DE "300 %"
#define OPTION_VAL_310_DE "310 %"
#define OPTION_VAL_320_DE "320 %"
#define OPTION_VAL_330_DE "330 %"
#define OPTION_VAL_340_DE "340 %"
#define OPTION_VAL_350_DE "350 %"
#define OPTION_VAL_360_DE "360 %"
#define OPTION_VAL_370_DE "370 %"
#define OPTION_VAL_380_DE "380 %"
#define OPTION_VAL_390_DE "390 %"
#define OPTION_VAL_400_DE "400 %"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_DE "Übertaktung - SA-1-Koprozessor"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_DE "SA-1-Koprozessor"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_DE "Übertakten oder Heruntertakten des Chips Super Accelerator 1 (SA-1). Wird dieser Wert auf über 100 % eingestellt, kann sich die Leistung in Spielen, die den SA-1-Chip unterstützen, verbessern. Mit Vorsicht anwenden, da dies bei einigen Spielen zu Abstürzen oder zu weiteren Problemen führen kann."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_DE "Übertaktung - SuperFX-Koprozessor"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_DE "SuperFX-Koprozessor"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_DE "Übertakten oder Heruntertakten des SuperFX-Koprozessors. Wird dieser Wert auf über 100 % eingestellt, kann sich die Leistung in Spielen, die den SuperFX unterstützen, verbessern. Mit Vorsicht anwenden, da dies bei einigen Spielen zu Abstürzen oder zu weiteren Problemen führen kann."
#define OPTION_VAL_410_DE "410 %"
#define OPTION_VAL_420_DE "420 %"
#define OPTION_VAL_430_DE "430 %"
#define OPTION_VAL_440_DE "440 %"
#define OPTION_VAL_450_DE "450 %"
#define OPTION_VAL_460_DE "460 %"
#define OPTION_VAL_470_DE "470 %"
#define OPTION_VAL_480_DE "480 %"
#define OPTION_VAL_490_DE "490 %"
#define OPTION_VAL_500_DE "500 %"
#define OPTION_VAL_510_DE "510 %"
#define OPTION_VAL_520_DE "520 %"
#define OPTION_VAL_530_DE "530 %"
#define OPTION_VAL_540_DE "540 %"
#define OPTION_VAL_550_DE "550 %"
#define OPTION_VAL_560_DE "560 %"
#define OPTION_VAL_570_DE "570 %"
#define OPTION_VAL_580_DE "580 %"
#define OPTION_VAL_590_DE "590 %"
#define OPTION_VAL_600_DE "600 %"
#define OPTION_VAL_610_DE "610 %"
#define OPTION_VAL_620_DE "620 %"
#define OPTION_VAL_630_DE "630 %"
#define OPTION_VAL_640_DE "640 %"
#define OPTION_VAL_650_DE "650 %"
#define OPTION_VAL_660_DE "660 %"
#define OPTION_VAL_670_DE "670 %"
#define OPTION_VAL_680_DE "680 %"
#define OPTION_VAL_690_DE "690 %"
#define OPTION_VAL_700_DE "700 %"
#define OPTION_VAL_710_DE "710 %"
#define OPTION_VAL_720_DE "720 %"
#define OPTION_VAL_730_DE "730 %"
#define OPTION_VAL_740_DE "740 %"
#define OPTION_VAL_750_DE "750 %"
#define OPTION_VAL_760_DE "760 %"
#define OPTION_VAL_770_DE "770 %"
#define OPTION_VAL_780_DE "780 %"
#define OPTION_VAL_790_DE "790 %"
#define OPTION_VAL_800_DE "800 %"
#define BSNES_SGB_BIOS_LABEL_DE "Bevorzugtes Super-Game-Boy-BIOS (Neustart erforderlich)"
#define BSNES_SGB_BIOS_INFO_0_DE "Das bevorzugte Super-Game-Boy-BIOS auswählen, das mit kompatiblen Titeln verwendet werden soll."
#define OPTION_VAL_SGB1_SFC_DE NULL
#define OPTION_VAL_SGB2_SFC_DE NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_DE "SGB-Rand ausblenden"
#define BSNES_HIDE_SGB_BORDER_INFO_0_DE "Den Rand beim Spielen von „Super Game Boy“-Spielen ausblenden."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_DE "Touchscreen-Lightgun"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_DE "Eingabegerät Super Scope für Touchscreen-Geräte akrtivieren."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_DE "Super-Scope-Triggertasten tauschen"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_DE "Bei Super Scope die Auslöser- und Cursortasten für die Touchscreen-Lightgun tauschen."

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_DE,
      CATEGORY_VIDEO_INFO_0_DE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_DE,
      CATEGORY_AUDIO_INFO_0_DE
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_DE,
      CATEGORY_MODE7_INFO_0_DE
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_DE,
      CATEGORY_HACK_INFO_0_DE
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_DE,
      CATEGORY_OVERCLOCK_INFO_0_DE
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_DE,
      CATEGORY_SGB_INFO_0_DE
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_DE,
      CATEGORY_LIGHTGUN_INFO_0_DE
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_DE,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_DE,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_DE },
         { "1:1",  OPTION_VAL_1_1_DE },
         { "4:3",  OPTION_VAL_4_3_DE },
         { "NTSC", OPTION_VAL_NTSC_DE },
         { "PAL",  OPTION_VAL_PAL_DE },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_DE,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_DE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_DE },
         { "8",  OPTION_VAL_8_DE },
         { "12", OPTION_VAL_12_DE },
         { "16", OPTION_VAL_16_DE },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_DE,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_DE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_DE,
      BSNES_VIDEO_FILTER_LABEL_DE,
      BSNES_VIDEO_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_DE },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_DE },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_DE },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_DE },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_DE },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_DE,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_DE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_DE },
         { "10", OPTION_VAL_10_DE },
         { "20", OPTION_VAL_20_DE },
         { "30", OPTION_VAL_30_DE },
         { "40", OPTION_VAL_40_DE },
         { "50", OPTION_VAL_50_DE },
         { "60", OPTION_VAL_60_DE },
         { "70", OPTION_VAL_70_DE },
         { "80", OPTION_VAL_80_DE },
         { "90", OPTION_VAL_90_DE },
         { "100", OPTION_VAL_100_DE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_DE,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_DE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_DE },
         { "10", OPTION_VAL_10_DE },
         { "20", OPTION_VAL_20_DE },
         { "30", OPTION_VAL_30_DE },
         { "40", OPTION_VAL_40_DE },
         { "50", OPTION_VAL_50_DE },
         { "60", OPTION_VAL_60_DE },
         { "70", OPTION_VAL_70_DE },
         { "80", OPTION_VAL_80_DE },
         { "90", OPTION_VAL_90_DE },
         { "100", OPTION_VAL_100_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_DE,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_DE,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_O6_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_DE,
      BSNES_PPU_FAST_LABEL_CAT_DE,
      BSNES_PPU_FAST_INFO_0_DE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_DE,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_DE,
      BSNES_PPU_DEINTERLACE_INFO_0_DE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_DE,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_DE,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_DE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_DE,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_DE,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_DE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_DE,
      BSNES_DSP_FAST_LABEL_CAT_DE,
      BSNES_DSP_FAST_INFO_0_DE,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_DE,
      BSNES_DSP_CUBIC_LABEL_CAT_DE,
      BSNES_DSP_CUBIC_INFO_0_DE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_DE,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_DE,
      BSNES_DSP_ECHO_SHADOW_INFO_0_DE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_DE,
      BSNES_MODE7_SCALE_LABEL_CAT_DE,
      BSNES_MODE7_SCALE_INFO_0_DE,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_DE  },
         { "2x", OPTION_VAL_2X_DE  },
         { "3x", OPTION_VAL_3X_DE  },
         { "4x", OPTION_VAL_4X_DE  },
         { "5x", OPTION_VAL_5X_DE },
         { "6x", OPTION_VAL_6X_DE },
         { "7x", OPTION_VAL_7X_DE },
         { "8x", OPTION_VAL_8X_DE },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_DE,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_DE,
      BSNES_MODE7_PERSPECTIVE_INFO_0_DE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_DE,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_DE,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_DE,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_DE,
      BSNES_MODE7_MOSAIC_LABEL_CAT_DE,
      BSNES_MODE7_MOSAIC_INFO_0_DE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_DE,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_DE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_DE  },
         { "2",   OPTION_VAL_2_DE },
         { "3",   OPTION_VAL_3_DE },
         { "4",   OPTION_VAL_4_DE },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_DE,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_DE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_DE,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_DE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_DE,
      NULL,
      BSNES_HOTFIXES_INFO_0_DE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_DE,
      NULL,
      BSNES_ENTROPY_INFO_0_DE,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_DE },
         { "High", OPTION_VAL_HIGH_DE },
         { "None", OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_DE,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_DE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_DE,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_DE,
      BSNES_CPU_OVERCLOCK_INFO_0_DE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DE  },
         { "20",  OPTION_VAL_20_DE  },
         { "30",  OPTION_VAL_30_DE  },
         { "40",  OPTION_VAL_40_DE  },
         { "50",  OPTION_VAL_50_DE  },
         { "60",  OPTION_VAL_60_DE  },
         { "70",  OPTION_VAL_70_DE  },
         { "80",  OPTION_VAL_80_DE  },
         { "90",  OPTION_VAL_90_DE  },
         { "100", OPTION_VAL_100_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { "210", OPTION_VAL_210_DE },
         { "220", OPTION_VAL_220_DE },
         { "230", OPTION_VAL_230_DE },
         { "240", OPTION_VAL_240_DE },
         { "250", OPTION_VAL_250_DE },
         { "260", OPTION_VAL_260_DE },
         { "270", OPTION_VAL_270_DE },
         { "280", OPTION_VAL_280_DE },
         { "290", OPTION_VAL_290_DE },
         { "300", OPTION_VAL_300_DE },
         { "310", OPTION_VAL_310_DE },
         { "320", OPTION_VAL_320_DE },
         { "330", OPTION_VAL_330_DE },
         { "340", OPTION_VAL_340_DE },
         { "350", OPTION_VAL_350_DE },
         { "360", OPTION_VAL_360_DE },
         { "370", OPTION_VAL_370_DE },
         { "380", OPTION_VAL_380_DE },
         { "390", OPTION_VAL_390_DE },
         { "400", OPTION_VAL_400_DE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_DE,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_DE,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_DE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DE  },
         { "20",  OPTION_VAL_20_DE  },
         { "30",  OPTION_VAL_30_DE  },
         { "40",  OPTION_VAL_40_DE  },
         { "50",  OPTION_VAL_50_DE  },
         { "60",  OPTION_VAL_60_DE  },
         { "70",  OPTION_VAL_70_DE  },
         { "80",  OPTION_VAL_80_DE  },
         { "90",  OPTION_VAL_90_DE  },
         { "100", OPTION_VAL_100_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { "210", OPTION_VAL_210_DE },
         { "220", OPTION_VAL_220_DE },
         { "230", OPTION_VAL_230_DE },
         { "240", OPTION_VAL_240_DE },
         { "250", OPTION_VAL_250_DE },
         { "260", OPTION_VAL_260_DE },
         { "270", OPTION_VAL_270_DE },
         { "280", OPTION_VAL_280_DE },
         { "290", OPTION_VAL_290_DE },
         { "300", OPTION_VAL_300_DE },
         { "310", OPTION_VAL_310_DE },
         { "320", OPTION_VAL_320_DE },
         { "330", OPTION_VAL_330_DE },
         { "340", OPTION_VAL_340_DE },
         { "350", OPTION_VAL_350_DE },
         { "360", OPTION_VAL_360_DE },
         { "370", OPTION_VAL_370_DE },
         { "380", OPTION_VAL_380_DE },
         { "390", OPTION_VAL_390_DE },
         { "400", OPTION_VAL_400_DE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_DE,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_DE,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_DE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_DE  },
         { "20",  OPTION_VAL_20_DE  },
         { "30",  OPTION_VAL_30_DE  },
         { "40",  OPTION_VAL_40_DE  },
         { "50",  OPTION_VAL_50_DE  },
         { "60",  OPTION_VAL_60_DE  },
         { "70",  OPTION_VAL_70_DE  },
         { "80",  OPTION_VAL_80_DE  },
         { "90",  OPTION_VAL_90_DE  },
         { "100", OPTION_VAL_100_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { "210", OPTION_VAL_210_DE },
         { "220", OPTION_VAL_220_DE },
         { "230", OPTION_VAL_230_DE },
         { "240", OPTION_VAL_240_DE },
         { "250", OPTION_VAL_250_DE },
         { "260", OPTION_VAL_260_DE },
         { "270", OPTION_VAL_270_DE },
         { "280", OPTION_VAL_280_DE },
         { "290", OPTION_VAL_290_DE },
         { "300", OPTION_VAL_300_DE },
         { "310", OPTION_VAL_310_DE },
         { "320", OPTION_VAL_320_DE },
         { "330", OPTION_VAL_330_DE },
         { "340", OPTION_VAL_340_DE },
         { "350", OPTION_VAL_350_DE },
         { "360", OPTION_VAL_360_DE },
         { "370", OPTION_VAL_370_DE },
         { "380", OPTION_VAL_380_DE },
         { "390", OPTION_VAL_390_DE },
         { "400", OPTION_VAL_400_DE },
         { "410", OPTION_VAL_410_DE },
         { "420", OPTION_VAL_420_DE },
         { "430", OPTION_VAL_430_DE },
         { "440", OPTION_VAL_440_DE },
         { "450", OPTION_VAL_450_DE },
         { "460", OPTION_VAL_460_DE },
         { "470", OPTION_VAL_470_DE },
         { "480", OPTION_VAL_480_DE },
         { "490", OPTION_VAL_490_DE },
         { "500", OPTION_VAL_500_DE },
         { "510", OPTION_VAL_510_DE },
         { "520", OPTION_VAL_520_DE },
         { "530", OPTION_VAL_530_DE },
         { "540", OPTION_VAL_540_DE },
         { "550", OPTION_VAL_550_DE },
         { "560", OPTION_VAL_560_DE },
         { "570", OPTION_VAL_570_DE },
         { "580", OPTION_VAL_580_DE },
         { "590", OPTION_VAL_590_DE },
         { "600", OPTION_VAL_600_DE },
         { "610", OPTION_VAL_610_DE },
         { "620", OPTION_VAL_620_DE },
         { "630", OPTION_VAL_630_DE },
         { "640", OPTION_VAL_640_DE },
         { "650", OPTION_VAL_650_DE },
         { "660", OPTION_VAL_660_DE },
         { "670", OPTION_VAL_670_DE },
         { "680", OPTION_VAL_680_DE },
         { "690", OPTION_VAL_690_DE },
         { "700", OPTION_VAL_700_DE },
         { "710", OPTION_VAL_710_DE },
         { "720", OPTION_VAL_720_DE },
         { "730", OPTION_VAL_730_DE },
         { "740", OPTION_VAL_740_DE },
         { "750", OPTION_VAL_750_DE },
         { "760", OPTION_VAL_760_DE },
         { "770", OPTION_VAL_770_DE },
         { "780", OPTION_VAL_780_DE },
         { "790", OPTION_VAL_790_DE },
         { "800", OPTION_VAL_800_DE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_DE,
      NULL,
      BSNES_SGB_BIOS_INFO_0_DE,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_DE   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_DE },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_DE,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_DE,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_DE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_DE,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_DE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_DE,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_VIDEO_LABEL_EL "Οδηγός Βίντεο"
#define CATEGORY_VIDEO_INFO_0_EL "Αλλαγή ρυθμίσεων εξόδου βίντεο."
#define CATEGORY_AUDIO_LABEL_EL "Οδηγός Ήχου"
#define CATEGORY_AUDIO_INFO_0_EL "Αλλαγή ρυθμίσεων εξόδου ήχου."
#define CATEGORY_MODE7_LABEL_EL NULL
#define CATEGORY_MODE7_INFO_0_EL NULL
#define CATEGORY_HACK_LABEL_EL NULL
#define CATEGORY_HACK_INFO_0_EL NULL
#define CATEGORY_OVERCLOCK_LABEL_EL NULL
#define CATEGORY_OVERCLOCK_INFO_0_EL NULL
#define CATEGORY_SGB_LABEL_EL NULL
#define CATEGORY_SGB_INFO_0_EL NULL
#define CATEGORY_LIGHTGUN_LABEL_EL NULL
#define CATEGORY_LIGHTGUN_INFO_0_EL NULL
#define BSNES_ASPECT_RATIO_LABEL_EL NULL
#define BSNES_ASPECT_RATIO_INFO_0_EL NULL
#define OPTION_VAL_AUTO_EL "Αυτόματο"
#define OPTION_VAL_1_1_EL NULL
#define OPTION_VAL_4_3_EL NULL
#define OPTION_VAL_NTSC_EL NULL
#define OPTION_VAL_PAL_EL NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_EL NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_EL NULL
#define OPTION_VAL_0_EL NULL
#define OPTION_VAL_8_EL NULL
#define OPTION_VAL_12_EL NULL
#define OPTION_VAL_16_EL NULL
#define BSNES_BLUR_EMULATION_LABEL_EL NULL
#define BSNES_BLUR_EMULATION_INFO_0_EL NULL
#define BSNES_VIDEO_FILTER_LABEL_EL "Φίλτρα"
#define BSNES_VIDEO_FILTER_INFO_0_EL NULL
#define OPTION_VAL_NONE_EL "Κανείς"
#define OPTION_VAL_NTSC_RF_EL NULL
#define OPTION_VAL_NTSC_COMPOSITE_EL NULL
#define OPTION_VAL_NTSC_S_VIDEO_EL NULL
#define OPTION_VAL_NTSC_RGB_EL NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_EL NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_EL NULL
#define OPTION_VAL_0_O4_EL NULL
#define OPTION_VAL_10_EL NULL
#define OPTION_VAL_20_EL NULL
#define OPTION_VAL_30_EL NULL
#define OPTION_VAL_40_EL NULL
#define OPTION_VAL_50_EL NULL
#define OPTION_VAL_60_EL NULL
#define OPTION_VAL_70_EL NULL
#define OPTION_VAL_80_EL "το 80%"
#define OPTION_VAL_90_EL NULL
#define OPTION_VAL_100_EL "100% (Προεπιλογή)"
#define BSNES_VIDEO_SATURATION_LABEL_EL NULL
#define BSNES_VIDEO_SATURATION_INFO_0_EL NULL
#define OPTION_VAL_110_EL NULL
#define OPTION_VAL_120_EL NULL
#define OPTION_VAL_130_EL NULL
#define OPTION_VAL_140_EL NULL
#define OPTION_VAL_150_EL NULL
#define OPTION_VAL_160_EL NULL
#define OPTION_VAL_170_EL NULL
#define OPTION_VAL_180_EL NULL
#define OPTION_VAL_190_EL NULL
#define OPTION_VAL_200_EL NULL
#define BSNES_VIDEO_GAMMA_LABEL_EL NULL
#define BSNES_VIDEO_GAMMA_INFO_0_EL NULL
#define OPTION_VAL_100_O6_EL NULL
#define OPTION_VAL_150_O6_EL NULL
#define BSNES_PPU_FAST_LABEL_EL NULL
#define BSNES_PPU_FAST_LABEL_CAT_EL NULL
#define BSNES_PPU_FAST_INFO_0_EL NULL
#define BSNES_PPU_DEINTERLACE_LABEL_EL NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_EL NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_EL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EL NULL
#define BSNES_DSP_FAST_LABEL_EL NULL
#define BSNES_DSP_FAST_LABEL_CAT_EL NULL
#define BSNES_DSP_FAST_INFO_0_EL NULL
#define BSNES_DSP_CUBIC_LABEL_EL NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_EL NULL
#define BSNES_DSP_CUBIC_INFO_0_EL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_EL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EL NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_EL NULL
#define BSNES_MODE7_SCALE_LABEL_EL NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_EL "Κλίμακα"
#define BSNES_MODE7_SCALE_INFO_0_EL NULL
#define OPTION_VAL_1X_EL NULL
#define OPTION_VAL_2X_EL NULL
#define OPTION_VAL_3X_EL NULL
#define OPTION_VAL_4X_EL NULL
#define OPTION_VAL_5X_EL NULL
#define OPTION_VAL_6X_EL NULL
#define OPTION_VAL_7X_EL NULL
#define OPTION_VAL_8X_EL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_EL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EL NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_EL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_EL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EL NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_EL NULL
#define BSNES_MODE7_MOSAIC_LABEL_EL NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_EL NULL
#define BSNES_MODE7_MOSAIC_INFO_0_EL NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_EL NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_EL NULL
#define OPTION_VAL_1_EL NULL
#define OPTION_VAL_2_EL NULL
#define OPTION_VAL_3_EL NULL
#define OPTION_VAL_4_EL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_EL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EL NULL
#define BSNES_HOTFIXES_LABEL_EL NULL
#define BSNES_HOTFIXES_INFO_0_EL NULL
#define BSNES_ENTROPY_LABEL_EL NULL
#define BSNES_ENTROPY_INFO_0_EL NULL
#define OPTION_VAL_LOW_EL NULL
#define OPTION_VAL_HIGH_EL NULL
#define BSNES_CPU_FASTMATH_LABEL_EL NULL
#define BSNES_CPU_FASTMATH_INFO_0_EL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_EL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_EL NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_EL NULL
#define OPTION_VAL_210_EL NULL
#define OPTION_VAL_220_EL NULL
#define OPTION_VAL_230_EL NULL
#define OPTION_VAL_240_EL NULL
#define OPTION_VAL_250_EL NULL
#define OPTION_VAL_260_EL NULL
#define OPTION_VAL_270_EL NULL
#define OPTION_VAL_280_EL NULL
#define OPTION_VAL_290_EL NULL
#define OPTION_VAL_300_EL NULL
#define OPTION_VAL_310_EL NULL
#define OPTION_VAL_320_EL NULL
#define OPTION_VAL_330_EL NULL
#define OPTION_VAL_340_EL NULL
#define OPTION_VAL_350_EL NULL
#define OPTION_VAL_360_EL NULL
#define OPTION_VAL_370_EL NULL
#define OPTION_VAL_380_EL NULL
#define OPTION_VAL_390_EL NULL
#define OPTION_VAL_400_EL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_EL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EL NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_EL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_EL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EL NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_EL NULL
#define OPTION_VAL_410_EL NULL
#define OPTION_VAL_420_EL NULL
#define OPTION_VAL_430_EL NULL
#define OPTION_VAL_440_EL NULL
#define OPTION_VAL_450_EL NULL
#define OPTION_VAL_460_EL NULL
#define OPTION_VAL_470_EL NULL
#define OPTION_VAL_480_EL NULL
#define OPTION_VAL_490_EL NULL
#define OPTION_VAL_500_EL NULL
#define OPTION_VAL_510_EL NULL
#define OPTION_VAL_520_EL NULL
#define OPTION_VAL_530_EL NULL
#define OPTION_VAL_540_EL NULL
#define OPTION_VAL_550_EL NULL
#define OPTION_VAL_560_EL NULL
#define OPTION_VAL_570_EL NULL
#define OPTION_VAL_580_EL NULL
#define OPTION_VAL_590_EL NULL
#define OPTION_VAL_600_EL NULL
#define OPTION_VAL_610_EL NULL
#define OPTION_VAL_620_EL NULL
#define OPTION_VAL_630_EL NULL
#define OPTION_VAL_640_EL NULL
#define OPTION_VAL_650_EL NULL
#define OPTION_VAL_660_EL NULL
#define OPTION_VAL_670_EL NULL
#define OPTION_VAL_680_EL NULL
#define OPTION_VAL_690_EL NULL
#define OPTION_VAL_700_EL NULL
#define OPTION_VAL_710_EL NULL
#define OPTION_VAL_720_EL NULL
#define OPTION_VAL_730_EL NULL
#define OPTION_VAL_740_EL NULL
#define OPTION_VAL_750_EL NULL
#define OPTION_VAL_760_EL NULL
#define OPTION_VAL_770_EL NULL
#define OPTION_VAL_780_EL NULL
#define OPTION_VAL_790_EL NULL
#define OPTION_VAL_800_EL NULL
#define BSNES_SGB_BIOS_LABEL_EL NULL
#define BSNES_SGB_BIOS_INFO_0_EL NULL
#define OPTION_VAL_SGB1_SFC_EL NULL
#define OPTION_VAL_SGB2_SFC_EL NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_EL NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_EL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EL,
      CATEGORY_VIDEO_INFO_0_EL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EL,
      CATEGORY_AUDIO_INFO_0_EL
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_EL,
      CATEGORY_MODE7_INFO_0_EL
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_EL,
      CATEGORY_HACK_INFO_0_EL
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_EL,
      CATEGORY_OVERCLOCK_INFO_0_EL
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_EL,
      CATEGORY_SGB_INFO_0_EL
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_EL,
      CATEGORY_LIGHTGUN_INFO_0_EL
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_EL,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_EL,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_EL },
         { "1:1",  OPTION_VAL_1_1_EL },
         { "4:3",  OPTION_VAL_4_3_EL },
         { "NTSC", OPTION_VAL_NTSC_EL },
         { "PAL",  OPTION_VAL_PAL_EL },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_EL,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_EL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_EL },
         { "8",  OPTION_VAL_8_EL },
         { "12", OPTION_VAL_12_EL },
         { "16", OPTION_VAL_16_EL },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_EL,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_EL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_EL,
      BSNES_VIDEO_FILTER_LABEL_EL,
      BSNES_VIDEO_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_EL },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_EL },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_EL },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_EL },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_EL },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_EL,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_EL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EL },
         { "10", OPTION_VAL_10_EL },
         { "20", OPTION_VAL_20_EL },
         { "30", OPTION_VAL_30_EL },
         { "40", OPTION_VAL_40_EL },
         { "50", OPTION_VAL_50_EL },
         { "60", OPTION_VAL_60_EL },
         { "70", OPTION_VAL_70_EL },
         { "80", OPTION_VAL_80_EL },
         { "90", OPTION_VAL_90_EL },
         { "100", OPTION_VAL_100_EL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_EL,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_EL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EL },
         { "10", OPTION_VAL_10_EL },
         { "20", OPTION_VAL_20_EL },
         { "30", OPTION_VAL_30_EL },
         { "40", OPTION_VAL_40_EL },
         { "50", OPTION_VAL_50_EL },
         { "60", OPTION_VAL_60_EL },
         { "70", OPTION_VAL_70_EL },
         { "80", OPTION_VAL_80_EL },
         { "90", OPTION_VAL_90_EL },
         { "100", OPTION_VAL_100_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_EL,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_EL,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_O6_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_EL,
      BSNES_PPU_FAST_LABEL_CAT_EL,
      BSNES_PPU_FAST_INFO_0_EL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_EL,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_EL,
      BSNES_PPU_DEINTERLACE_INFO_0_EL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EL,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EL,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EL,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EL,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_EL,
      BSNES_DSP_FAST_LABEL_CAT_EL,
      BSNES_DSP_FAST_INFO_0_EL,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_EL,
      BSNES_DSP_CUBIC_LABEL_CAT_EL,
      BSNES_DSP_CUBIC_INFO_0_EL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_EL,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EL,
      BSNES_DSP_ECHO_SHADOW_INFO_0_EL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_EL,
      BSNES_MODE7_SCALE_LABEL_CAT_EL,
      BSNES_MODE7_SCALE_INFO_0_EL,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_EL  },
         { "2x", OPTION_VAL_2X_EL  },
         { "3x", OPTION_VAL_3X_EL  },
         { "4x", OPTION_VAL_4X_EL  },
         { "5x", OPTION_VAL_5X_EL },
         { "6x", OPTION_VAL_6X_EL },
         { "7x", OPTION_VAL_7X_EL },
         { "8x", OPTION_VAL_8X_EL },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_EL,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EL,
      BSNES_MODE7_PERSPECTIVE_INFO_0_EL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_EL,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EL,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_EL,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_EL,
      BSNES_MODE7_MOSAIC_LABEL_CAT_EL,
      BSNES_MODE7_MOSAIC_INFO_0_EL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_EL,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_EL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_EL  },
         { "2",   OPTION_VAL_2_EL },
         { "3",   OPTION_VAL_3_EL },
         { "4",   OPTION_VAL_4_EL },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EL,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_EL,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_EL,
      NULL,
      BSNES_HOTFIXES_INFO_0_EL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_EL,
      NULL,
      BSNES_ENTROPY_INFO_0_EL,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_EL },
         { "High", OPTION_VAL_HIGH_EL },
         { "None", OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_EL,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_EL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_EL,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_EL,
      BSNES_CPU_OVERCLOCK_INFO_0_EL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EL  },
         { "20",  OPTION_VAL_20_EL  },
         { "30",  OPTION_VAL_30_EL  },
         { "40",  OPTION_VAL_40_EL  },
         { "50",  OPTION_VAL_50_EL  },
         { "60",  OPTION_VAL_60_EL  },
         { "70",  OPTION_VAL_70_EL  },
         { "80",  OPTION_VAL_80_EL  },
         { "90",  OPTION_VAL_90_EL  },
         { "100", OPTION_VAL_100_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { "210", OPTION_VAL_210_EL },
         { "220", OPTION_VAL_220_EL },
         { "230", OPTION_VAL_230_EL },
         { "240", OPTION_VAL_240_EL },
         { "250", OPTION_VAL_250_EL },
         { "260", OPTION_VAL_260_EL },
         { "270", OPTION_VAL_270_EL },
         { "280", OPTION_VAL_280_EL },
         { "290", OPTION_VAL_290_EL },
         { "300", OPTION_VAL_300_EL },
         { "310", OPTION_VAL_310_EL },
         { "320", OPTION_VAL_320_EL },
         { "330", OPTION_VAL_330_EL },
         { "340", OPTION_VAL_340_EL },
         { "350", OPTION_VAL_350_EL },
         { "360", OPTION_VAL_360_EL },
         { "370", OPTION_VAL_370_EL },
         { "380", OPTION_VAL_380_EL },
         { "390", OPTION_VAL_390_EL },
         { "400", OPTION_VAL_400_EL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_EL,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EL,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_EL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EL  },
         { "20",  OPTION_VAL_20_EL  },
         { "30",  OPTION_VAL_30_EL  },
         { "40",  OPTION_VAL_40_EL  },
         { "50",  OPTION_VAL_50_EL  },
         { "60",  OPTION_VAL_60_EL  },
         { "70",  OPTION_VAL_70_EL  },
         { "80",  OPTION_VAL_80_EL  },
         { "90",  OPTION_VAL_90_EL  },
         { "100", OPTION_VAL_100_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { "210", OPTION_VAL_210_EL },
         { "220", OPTION_VAL_220_EL },
         { "230", OPTION_VAL_230_EL },
         { "240", OPTION_VAL_240_EL },
         { "250", OPTION_VAL_250_EL },
         { "260", OPTION_VAL_260_EL },
         { "270", OPTION_VAL_270_EL },
         { "280", OPTION_VAL_280_EL },
         { "290", OPTION_VAL_290_EL },
         { "300", OPTION_VAL_300_EL },
         { "310", OPTION_VAL_310_EL },
         { "320", OPTION_VAL_320_EL },
         { "330", OPTION_VAL_330_EL },
         { "340", OPTION_VAL_340_EL },
         { "350", OPTION_VAL_350_EL },
         { "360", OPTION_VAL_360_EL },
         { "370", OPTION_VAL_370_EL },
         { "380", OPTION_VAL_380_EL },
         { "390", OPTION_VAL_390_EL },
         { "400", OPTION_VAL_400_EL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_EL,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EL,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_EL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EL  },
         { "20",  OPTION_VAL_20_EL  },
         { "30",  OPTION_VAL_30_EL  },
         { "40",  OPTION_VAL_40_EL  },
         { "50",  OPTION_VAL_50_EL  },
         { "60",  OPTION_VAL_60_EL  },
         { "70",  OPTION_VAL_70_EL  },
         { "80",  OPTION_VAL_80_EL  },
         { "90",  OPTION_VAL_90_EL  },
         { "100", OPTION_VAL_100_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { "210", OPTION_VAL_210_EL },
         { "220", OPTION_VAL_220_EL },
         { "230", OPTION_VAL_230_EL },
         { "240", OPTION_VAL_240_EL },
         { "250", OPTION_VAL_250_EL },
         { "260", OPTION_VAL_260_EL },
         { "270", OPTION_VAL_270_EL },
         { "280", OPTION_VAL_280_EL },
         { "290", OPTION_VAL_290_EL },
         { "300", OPTION_VAL_300_EL },
         { "310", OPTION_VAL_310_EL },
         { "320", OPTION_VAL_320_EL },
         { "330", OPTION_VAL_330_EL },
         { "340", OPTION_VAL_340_EL },
         { "350", OPTION_VAL_350_EL },
         { "360", OPTION_VAL_360_EL },
         { "370", OPTION_VAL_370_EL },
         { "380", OPTION_VAL_380_EL },
         { "390", OPTION_VAL_390_EL },
         { "400", OPTION_VAL_400_EL },
         { "410", OPTION_VAL_410_EL },
         { "420", OPTION_VAL_420_EL },
         { "430", OPTION_VAL_430_EL },
         { "440", OPTION_VAL_440_EL },
         { "450", OPTION_VAL_450_EL },
         { "460", OPTION_VAL_460_EL },
         { "470", OPTION_VAL_470_EL },
         { "480", OPTION_VAL_480_EL },
         { "490", OPTION_VAL_490_EL },
         { "500", OPTION_VAL_500_EL },
         { "510", OPTION_VAL_510_EL },
         { "520", OPTION_VAL_520_EL },
         { "530", OPTION_VAL_530_EL },
         { "540", OPTION_VAL_540_EL },
         { "550", OPTION_VAL_550_EL },
         { "560", OPTION_VAL_560_EL },
         { "570", OPTION_VAL_570_EL },
         { "580", OPTION_VAL_580_EL },
         { "590", OPTION_VAL_590_EL },
         { "600", OPTION_VAL_600_EL },
         { "610", OPTION_VAL_610_EL },
         { "620", OPTION_VAL_620_EL },
         { "630", OPTION_VAL_630_EL },
         { "640", OPTION_VAL_640_EL },
         { "650", OPTION_VAL_650_EL },
         { "660", OPTION_VAL_660_EL },
         { "670", OPTION_VAL_670_EL },
         { "680", OPTION_VAL_680_EL },
         { "690", OPTION_VAL_690_EL },
         { "700", OPTION_VAL_700_EL },
         { "710", OPTION_VAL_710_EL },
         { "720", OPTION_VAL_720_EL },
         { "730", OPTION_VAL_730_EL },
         { "740", OPTION_VAL_740_EL },
         { "750", OPTION_VAL_750_EL },
         { "760", OPTION_VAL_760_EL },
         { "770", OPTION_VAL_770_EL },
         { "780", OPTION_VAL_780_EL },
         { "790", OPTION_VAL_790_EL },
         { "800", OPTION_VAL_800_EL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_EL,
      NULL,
      BSNES_SGB_BIOS_INFO_0_EL,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_EL   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_EL },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_EL,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_EL,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EL,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EL,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_el = {
   option_cats_el,
   option_defs_el
};

/* RETRO_LANGUAGE_EN */

#define CATEGORY_VIDEO_LABEL_EN NULL
#define CATEGORY_VIDEO_INFO_0_EN NULL
#define CATEGORY_AUDIO_LABEL_EN NULL
#define CATEGORY_AUDIO_INFO_0_EN NULL
#define CATEGORY_MODE7_LABEL_EN NULL
#define CATEGORY_MODE7_INFO_0_EN NULL
#define CATEGORY_HACK_LABEL_EN NULL
#define CATEGORY_HACK_INFO_0_EN "Apply emulation hacks, enhancements and hot-fixes."
#define CATEGORY_OVERCLOCK_LABEL_EN "Over-/Down-clocking"
#define CATEGORY_OVERCLOCK_INFO_0_EN NULL
#define CATEGORY_SGB_LABEL_EN NULL
#define CATEGORY_SGB_INFO_0_EN NULL
#define CATEGORY_LIGHTGUN_LABEL_EN NULL
#define CATEGORY_LIGHTGUN_INFO_0_EN NULL
#define BSNES_ASPECT_RATIO_LABEL_EN NULL
#define BSNES_ASPECT_RATIO_INFO_0_EN NULL
#define OPTION_VAL_AUTO_EN NULL
#define OPTION_VAL_1_1_EN NULL
#define OPTION_VAL_4_3_EN NULL
#define OPTION_VAL_NTSC_EN NULL
#define OPTION_VAL_PAL_EN NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_EN NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_EN NULL
#define OPTION_VAL_0_EN NULL
#define OPTION_VAL_8_EN NULL
#define OPTION_VAL_12_EN NULL
#define OPTION_VAL_16_EN NULL
#define BSNES_BLUR_EMULATION_LABEL_EN NULL
#define BSNES_BLUR_EMULATION_INFO_0_EN "Simulate the limited horizontal resolution of SD-TVs by blurring together horizontally-adjacent pixels. Some games depend on this to emulate a transparency effect."
#define BSNES_VIDEO_FILTER_LABEL_EN NULL
#define BSNES_VIDEO_FILTER_INFO_0_EN NULL
#define OPTION_VAL_NONE_EN NULL
#define OPTION_VAL_NTSC_RF_EN NULL
#define OPTION_VAL_NTSC_COMPOSITE_EN NULL
#define OPTION_VAL_NTSC_S_VIDEO_EN NULL
#define OPTION_VAL_NTSC_RGB_EN NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_EN "Colour Adjustment - Luminance"
#define BSNES_VIDEO_LUMINANCE_INFO_0_EN NULL
#define OPTION_VAL_0_O4_EN NULL
#define OPTION_VAL_10_EN NULL
#define OPTION_VAL_20_EN NULL
#define OPTION_VAL_30_EN NULL
#define OPTION_VAL_40_EN NULL
#define OPTION_VAL_50_EN NULL
#define OPTION_VAL_60_EN NULL
#define OPTION_VAL_70_EN NULL
#define OPTION_VAL_80_EN NULL
#define OPTION_VAL_90_EN NULL
#define OPTION_VAL_100_EN NULL
#define BSNES_VIDEO_SATURATION_LABEL_EN "Colour Adjustment - Saturation"
#define BSNES_VIDEO_SATURATION_INFO_0_EN NULL
#define OPTION_VAL_110_EN NULL
#define OPTION_VAL_120_EN NULL
#define OPTION_VAL_130_EN NULL
#define OPTION_VAL_140_EN NULL
#define OPTION_VAL_150_EN NULL
#define OPTION_VAL_160_EN NULL
#define OPTION_VAL_170_EN NULL
#define OPTION_VAL_180_EN NULL
#define OPTION_VAL_190_EN NULL
#define OPTION_VAL_200_EN NULL
#define BSNES_VIDEO_GAMMA_LABEL_EN "Colour Adjustment - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_EN NULL
#define OPTION_VAL_100_O6_EN NULL
#define OPTION_VAL_150_O6_EN NULL
#define BSNES_PPU_FAST_LABEL_EN NULL
#define BSNES_PPU_FAST_LABEL_CAT_EN NULL
#define BSNES_PPU_FAST_INFO_0_EN NULL
#define BSNES_PPU_DEINTERLACE_LABEL_EN "PPU (Video) - De-interlace"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_EN "PPU - De-interlace"
#define BSNES_PPU_DEINTERLACE_INFO_0_EN "De-interlace all games by rendering internally at 480p. Performance penalty is almost non-existent, so it is recommended to leave this on."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EN NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EN NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EN NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EN NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EN NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EN "Emulate a bug in older releases of ZSNES and Snes9x, where VRAM blocking was not emulated. A few older ROM hacks relied on this behaviour and will render graphics incorrectly if this is not enabled. This option is extremely inaccurate and hurts PPU speed, so it is recommended to leave it disabled unless you need to play a game that is otherwise incompatible with this core."
#define BSNES_DSP_FAST_LABEL_EN NULL
#define BSNES_DSP_FAST_LABEL_CAT_EN NULL
#define BSNES_DSP_FAST_INFO_0_EN NULL
#define BSNES_DSP_CUBIC_LABEL_EN NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_EN NULL
#define BSNES_DSP_CUBIC_INFO_0_EN NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_EN NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EN NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_EN "Emulate a bug in ZSNES where echo RAM was treated as separate from APU RAM. Many older ROM hacks for Super Mario World relied on this behaviour and will crash without this. This option is extremely inaccurate and should not be enabled unless required."
#define BSNES_MODE7_SCALE_LABEL_EN NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_EN NULL
#define BSNES_MODE7_SCALE_INFO_0_EN NULL
#define OPTION_VAL_1X_EN NULL
#define OPTION_VAL_2X_EN NULL
#define OPTION_VAL_3X_EN NULL
#define OPTION_VAL_4X_EN NULL
#define OPTION_VAL_5X_EN NULL
#define OPTION_VAL_6X_EN NULL
#define OPTION_VAL_7X_EN NULL
#define OPTION_VAL_8X_EN NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_EN NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EN NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_EN "Correct the perspective of the Mode 7 graphics used in certain games by working around some limitations of the integer maths used by the SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_EN "HD Mode 7 - Super-sampling"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EN "Super-sampling"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_EN "Super-sample the Mode 7 graphics used in certain games. Combined with higher Mode 7 scale factors, it produces an effect similar to anti-aliasing."
#define BSNES_MODE7_MOSAIC_LABEL_EN NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_EN NULL
#define BSNES_MODE7_MOSAIC_INFO_0_EN NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_EN NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_EN NULL
#define OPTION_VAL_1_EN NULL
#define OPTION_VAL_2_EN NULL
#define OPTION_VAL_3_EN NULL
#define OPTION_VAL_4_EN NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EN "Co-processors - Fast Mode"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EN "Enable faster emulation of the co-processors at the cost of a minor reduction of accuracy. It is recommended to leave this on."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_EN "Co-processors - Prefer HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EN NULL
#define BSNES_HOTFIXES_LABEL_EN "Hot-fixes"
#define BSNES_HOTFIXES_INFO_0_EN "Even commercially licenced and officially released software is sometimes shipped with bugs. This option will correct certain issues that occurred even on real hardware."
#define BSNES_ENTROPY_LABEL_EN "Entropy (randomisation)"
#define BSNES_ENTROPY_INFO_0_EN "Choose the level of randomisation of the memory and registers. If set to None, all memory and registers are initialised to constant values at start-up. Low randomisation provides the most accurate representation of a real system. High randomises as much as possible."
#define OPTION_VAL_LOW_EN NULL
#define OPTION_VAL_HIGH_EN NULL
#define BSNES_CPU_FASTMATH_LABEL_EN NULL
#define BSNES_CPU_FASTMATH_INFO_0_EN "Provide computation results immediately. CPU multiplication and division take time to complete on a real SNES. Older emulators did not simulate these delays and thus some older ROM hacks do not wait for maths operations to complete and need this hack."
#define BSNES_CPU_OVERCLOCK_LABEL_EN "Over-clocking - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_EN NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_EN "Over-clock or down-clock the CPU. Setting this value above 100% may reduce loading times and remove slowdown. Use with caution as it may also cause some games to crash or exhibit other issues."
#define OPTION_VAL_210_EN NULL
#define OPTION_VAL_220_EN NULL
#define OPTION_VAL_230_EN NULL
#define OPTION_VAL_240_EN NULL
#define OPTION_VAL_250_EN NULL
#define OPTION_VAL_260_EN NULL
#define OPTION_VAL_270_EN NULL
#define OPTION_VAL_280_EN NULL
#define OPTION_VAL_290_EN NULL
#define OPTION_VAL_300_EN NULL
#define OPTION_VAL_310_EN NULL
#define OPTION_VAL_320_EN NULL
#define OPTION_VAL_330_EN NULL
#define OPTION_VAL_340_EN NULL
#define OPTION_VAL_350_EN NULL
#define OPTION_VAL_360_EN NULL
#define OPTION_VAL_370_EN NULL
#define OPTION_VAL_380_EN NULL
#define OPTION_VAL_390_EN NULL
#define OPTION_VAL_400_EN NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_EN "Over-clocking - SA-1 Co-processor"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EN "SA-1 Co-processor"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_EN "Over-clock or down-clock the Super Accelerator 1 (SA-1) chip. Setting this value above 100% may improve performance in games that support the SA-1 chip. Use with caution, as it may also cause some games to crash or exhibit other issues."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_EN "Over-clocking - SuperFX Co-processor"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EN "SuperFX Co-processor"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_EN "Overclock or down-clock the SuperFX co-processor. Setting this value above 100% may improve performance in games that support the SuperFX. Use with caution, as it may also cause some games to crash or exhibit other issues."
#define OPTION_VAL_410_EN NULL
#define OPTION_VAL_420_EN NULL
#define OPTION_VAL_430_EN NULL
#define OPTION_VAL_440_EN NULL
#define OPTION_VAL_450_EN NULL
#define OPTION_VAL_460_EN NULL
#define OPTION_VAL_470_EN NULL
#define OPTION_VAL_480_EN NULL
#define OPTION_VAL_490_EN NULL
#define OPTION_VAL_500_EN NULL
#define OPTION_VAL_510_EN NULL
#define OPTION_VAL_520_EN NULL
#define OPTION_VAL_530_EN NULL
#define OPTION_VAL_540_EN NULL
#define OPTION_VAL_550_EN NULL
#define OPTION_VAL_560_EN NULL
#define OPTION_VAL_570_EN NULL
#define OPTION_VAL_580_EN NULL
#define OPTION_VAL_590_EN NULL
#define OPTION_VAL_600_EN NULL
#define OPTION_VAL_610_EN NULL
#define OPTION_VAL_620_EN NULL
#define OPTION_VAL_630_EN NULL
#define OPTION_VAL_640_EN NULL
#define OPTION_VAL_650_EN NULL
#define OPTION_VAL_660_EN NULL
#define OPTION_VAL_670_EN NULL
#define OPTION_VAL_680_EN NULL
#define OPTION_VAL_690_EN NULL
#define OPTION_VAL_700_EN NULL
#define OPTION_VAL_710_EN NULL
#define OPTION_VAL_720_EN NULL
#define OPTION_VAL_730_EN NULL
#define OPTION_VAL_740_EN NULL
#define OPTION_VAL_750_EN NULL
#define OPTION_VAL_760_EN NULL
#define OPTION_VAL_770_EN NULL
#define OPTION_VAL_780_EN NULL
#define OPTION_VAL_790_EN NULL
#define OPTION_VAL_800_EN NULL
#define BSNES_SGB_BIOS_LABEL_EN NULL
#define BSNES_SGB_BIOS_INFO_0_EN NULL
#define OPTION_VAL_SGB1_SFC_EN NULL
#define OPTION_VAL_SGB2_SFC_EN NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_EN NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_EN NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EN NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EN NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EN NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EN "Reverse the Super Scope trigger and cursor buttons with the touchscreen light-gun."

struct retro_core_option_v2_category option_cats_en[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EN,
      CATEGORY_VIDEO_INFO_0_EN
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EN,
      CATEGORY_AUDIO_INFO_0_EN
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_EN,
      CATEGORY_MODE7_INFO_0_EN
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_EN,
      CATEGORY_HACK_INFO_0_EN
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_EN,
      CATEGORY_OVERCLOCK_INFO_0_EN
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_EN,
      CATEGORY_SGB_INFO_0_EN
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_EN,
      CATEGORY_LIGHTGUN_INFO_0_EN
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_en[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_EN,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_EN,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_EN },
         { "1:1",  OPTION_VAL_1_1_EN },
         { "4:3",  OPTION_VAL_4_3_EN },
         { "NTSC", OPTION_VAL_NTSC_EN },
         { "PAL",  OPTION_VAL_PAL_EN },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_EN,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_EN,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_EN },
         { "8",  OPTION_VAL_8_EN },
         { "12", OPTION_VAL_12_EN },
         { "16", OPTION_VAL_16_EN },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_EN,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_EN,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_EN,
      BSNES_VIDEO_FILTER_LABEL_EN,
      BSNES_VIDEO_FILTER_INFO_0_EN,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_EN },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_EN },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_EN },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_EN },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_EN },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_EN,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_EN,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EN },
         { "10", OPTION_VAL_10_EN },
         { "20", OPTION_VAL_20_EN },
         { "30", OPTION_VAL_30_EN },
         { "40", OPTION_VAL_40_EN },
         { "50", OPTION_VAL_50_EN },
         { "60", OPTION_VAL_60_EN },
         { "70", OPTION_VAL_70_EN },
         { "80", OPTION_VAL_80_EN },
         { "90", OPTION_VAL_90_EN },
         { "100", OPTION_VAL_100_EN },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_EN,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_EN,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EN },
         { "10", OPTION_VAL_10_EN },
         { "20", OPTION_VAL_20_EN },
         { "30", OPTION_VAL_30_EN },
         { "40", OPTION_VAL_40_EN },
         { "50", OPTION_VAL_50_EN },
         { "60", OPTION_VAL_60_EN },
         { "70", OPTION_VAL_70_EN },
         { "80", OPTION_VAL_80_EN },
         { "90", OPTION_VAL_90_EN },
         { "100", OPTION_VAL_100_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_EN,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_EN,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_O6_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_EN,
      BSNES_PPU_FAST_LABEL_CAT_EN,
      BSNES_PPU_FAST_INFO_0_EN,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_EN,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_EN,
      BSNES_PPU_DEINTERLACE_INFO_0_EN,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EN,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EN,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EN,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EN,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EN,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EN,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_EN,
      BSNES_DSP_FAST_LABEL_CAT_EN,
      BSNES_DSP_FAST_INFO_0_EN,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_EN,
      BSNES_DSP_CUBIC_LABEL_CAT_EN,
      BSNES_DSP_CUBIC_INFO_0_EN,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_EN,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EN,
      BSNES_DSP_ECHO_SHADOW_INFO_0_EN,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_EN,
      BSNES_MODE7_SCALE_LABEL_CAT_EN,
      BSNES_MODE7_SCALE_INFO_0_EN,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_EN  },
         { "2x", OPTION_VAL_2X_EN  },
         { "3x", OPTION_VAL_3X_EN  },
         { "4x", OPTION_VAL_4X_EN  },
         { "5x", OPTION_VAL_5X_EN },
         { "6x", OPTION_VAL_6X_EN },
         { "7x", OPTION_VAL_7X_EN },
         { "8x", OPTION_VAL_8X_EN },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_EN,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EN,
      BSNES_MODE7_PERSPECTIVE_INFO_0_EN,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_EN,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EN,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_EN,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_EN,
      BSNES_MODE7_MOSAIC_LABEL_CAT_EN,
      BSNES_MODE7_MOSAIC_INFO_0_EN,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_EN,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_EN,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_EN  },
         { "2",   OPTION_VAL_2_EN },
         { "3",   OPTION_VAL_3_EN },
         { "4",   OPTION_VAL_4_EN },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EN,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EN,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_EN,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EN,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_EN,
      NULL,
      BSNES_HOTFIXES_INFO_0_EN,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_EN,
      NULL,
      BSNES_ENTROPY_INFO_0_EN,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_EN },
         { "High", OPTION_VAL_HIGH_EN },
         { "None", OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_EN,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_EN,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_EN,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_EN,
      BSNES_CPU_OVERCLOCK_INFO_0_EN,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EN  },
         { "20",  OPTION_VAL_20_EN  },
         { "30",  OPTION_VAL_30_EN  },
         { "40",  OPTION_VAL_40_EN  },
         { "50",  OPTION_VAL_50_EN  },
         { "60",  OPTION_VAL_60_EN  },
         { "70",  OPTION_VAL_70_EN  },
         { "80",  OPTION_VAL_80_EN  },
         { "90",  OPTION_VAL_90_EN  },
         { "100", OPTION_VAL_100_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { "210", OPTION_VAL_210_EN },
         { "220", OPTION_VAL_220_EN },
         { "230", OPTION_VAL_230_EN },
         { "240", OPTION_VAL_240_EN },
         { "250", OPTION_VAL_250_EN },
         { "260", OPTION_VAL_260_EN },
         { "270", OPTION_VAL_270_EN },
         { "280", OPTION_VAL_280_EN },
         { "290", OPTION_VAL_290_EN },
         { "300", OPTION_VAL_300_EN },
         { "310", OPTION_VAL_310_EN },
         { "320", OPTION_VAL_320_EN },
         { "330", OPTION_VAL_330_EN },
         { "340", OPTION_VAL_340_EN },
         { "350", OPTION_VAL_350_EN },
         { "360", OPTION_VAL_360_EN },
         { "370", OPTION_VAL_370_EN },
         { "380", OPTION_VAL_380_EN },
         { "390", OPTION_VAL_390_EN },
         { "400", OPTION_VAL_400_EN },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_EN,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EN,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_EN,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EN  },
         { "20",  OPTION_VAL_20_EN  },
         { "30",  OPTION_VAL_30_EN  },
         { "40",  OPTION_VAL_40_EN  },
         { "50",  OPTION_VAL_50_EN  },
         { "60",  OPTION_VAL_60_EN  },
         { "70",  OPTION_VAL_70_EN  },
         { "80",  OPTION_VAL_80_EN  },
         { "90",  OPTION_VAL_90_EN  },
         { "100", OPTION_VAL_100_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { "210", OPTION_VAL_210_EN },
         { "220", OPTION_VAL_220_EN },
         { "230", OPTION_VAL_230_EN },
         { "240", OPTION_VAL_240_EN },
         { "250", OPTION_VAL_250_EN },
         { "260", OPTION_VAL_260_EN },
         { "270", OPTION_VAL_270_EN },
         { "280", OPTION_VAL_280_EN },
         { "290", OPTION_VAL_290_EN },
         { "300", OPTION_VAL_300_EN },
         { "310", OPTION_VAL_310_EN },
         { "320", OPTION_VAL_320_EN },
         { "330", OPTION_VAL_330_EN },
         { "340", OPTION_VAL_340_EN },
         { "350", OPTION_VAL_350_EN },
         { "360", OPTION_VAL_360_EN },
         { "370", OPTION_VAL_370_EN },
         { "380", OPTION_VAL_380_EN },
         { "390", OPTION_VAL_390_EN },
         { "400", OPTION_VAL_400_EN },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_EN,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EN,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_EN,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EN  },
         { "20",  OPTION_VAL_20_EN  },
         { "30",  OPTION_VAL_30_EN  },
         { "40",  OPTION_VAL_40_EN  },
         { "50",  OPTION_VAL_50_EN  },
         { "60",  OPTION_VAL_60_EN  },
         { "70",  OPTION_VAL_70_EN  },
         { "80",  OPTION_VAL_80_EN  },
         { "90",  OPTION_VAL_90_EN  },
         { "100", OPTION_VAL_100_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { "210", OPTION_VAL_210_EN },
         { "220", OPTION_VAL_220_EN },
         { "230", OPTION_VAL_230_EN },
         { "240", OPTION_VAL_240_EN },
         { "250", OPTION_VAL_250_EN },
         { "260", OPTION_VAL_260_EN },
         { "270", OPTION_VAL_270_EN },
         { "280", OPTION_VAL_280_EN },
         { "290", OPTION_VAL_290_EN },
         { "300", OPTION_VAL_300_EN },
         { "310", OPTION_VAL_310_EN },
         { "320", OPTION_VAL_320_EN },
         { "330", OPTION_VAL_330_EN },
         { "340", OPTION_VAL_340_EN },
         { "350", OPTION_VAL_350_EN },
         { "360", OPTION_VAL_360_EN },
         { "370", OPTION_VAL_370_EN },
         { "380", OPTION_VAL_380_EN },
         { "390", OPTION_VAL_390_EN },
         { "400", OPTION_VAL_400_EN },
         { "410", OPTION_VAL_410_EN },
         { "420", OPTION_VAL_420_EN },
         { "430", OPTION_VAL_430_EN },
         { "440", OPTION_VAL_440_EN },
         { "450", OPTION_VAL_450_EN },
         { "460", OPTION_VAL_460_EN },
         { "470", OPTION_VAL_470_EN },
         { "480", OPTION_VAL_480_EN },
         { "490", OPTION_VAL_490_EN },
         { "500", OPTION_VAL_500_EN },
         { "510", OPTION_VAL_510_EN },
         { "520", OPTION_VAL_520_EN },
         { "530", OPTION_VAL_530_EN },
         { "540", OPTION_VAL_540_EN },
         { "550", OPTION_VAL_550_EN },
         { "560", OPTION_VAL_560_EN },
         { "570", OPTION_VAL_570_EN },
         { "580", OPTION_VAL_580_EN },
         { "590", OPTION_VAL_590_EN },
         { "600", OPTION_VAL_600_EN },
         { "610", OPTION_VAL_610_EN },
         { "620", OPTION_VAL_620_EN },
         { "630", OPTION_VAL_630_EN },
         { "640", OPTION_VAL_640_EN },
         { "650", OPTION_VAL_650_EN },
         { "660", OPTION_VAL_660_EN },
         { "670", OPTION_VAL_670_EN },
         { "680", OPTION_VAL_680_EN },
         { "690", OPTION_VAL_690_EN },
         { "700", OPTION_VAL_700_EN },
         { "710", OPTION_VAL_710_EN },
         { "720", OPTION_VAL_720_EN },
         { "730", OPTION_VAL_730_EN },
         { "740", OPTION_VAL_740_EN },
         { "750", OPTION_VAL_750_EN },
         { "760", OPTION_VAL_760_EN },
         { "770", OPTION_VAL_770_EN },
         { "780", OPTION_VAL_780_EN },
         { "790", OPTION_VAL_790_EN },
         { "800", OPTION_VAL_800_EN },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_EN,
      NULL,
      BSNES_SGB_BIOS_INFO_0_EN,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_EN   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_EN },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_EN,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_EN,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EN,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EN,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EN,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EN,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_en = {
   option_cats_en,
   option_defs_en
};

/* RETRO_LANGUAGE_EO */

#define CATEGORY_VIDEO_LABEL_EO "Video Driver"
#define CATEGORY_VIDEO_INFO_0_EO "Adjusts settings for video output."
#define CATEGORY_AUDIO_LABEL_EO "Audio Driver"
#define CATEGORY_AUDIO_INFO_0_EO "Adjusts settings for audio output."
#define CATEGORY_MODE7_LABEL_EO NULL
#define CATEGORY_MODE7_INFO_0_EO NULL
#define CATEGORY_HACK_LABEL_EO NULL
#define CATEGORY_HACK_INFO_0_EO NULL
#define CATEGORY_OVERCLOCK_LABEL_EO NULL
#define CATEGORY_OVERCLOCK_INFO_0_EO NULL
#define CATEGORY_SGB_LABEL_EO NULL
#define CATEGORY_SGB_INFO_0_EO NULL
#define CATEGORY_LIGHTGUN_LABEL_EO NULL
#define CATEGORY_LIGHTGUN_INFO_0_EO NULL
#define BSNES_ASPECT_RATIO_LABEL_EO NULL
#define BSNES_ASPECT_RATIO_INFO_0_EO NULL
#define OPTION_VAL_AUTO_EO NULL
#define OPTION_VAL_1_1_EO NULL
#define OPTION_VAL_4_3_EO NULL
#define OPTION_VAL_NTSC_EO NULL
#define OPTION_VAL_PAL_EO NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_EO NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_EO NULL
#define OPTION_VAL_0_EO NULL
#define OPTION_VAL_8_EO NULL
#define OPTION_VAL_12_EO NULL
#define OPTION_VAL_16_EO NULL
#define BSNES_BLUR_EMULATION_LABEL_EO NULL
#define BSNES_BLUR_EMULATION_INFO_0_EO NULL
#define BSNES_VIDEO_FILTER_LABEL_EO NULL
#define BSNES_VIDEO_FILTER_INFO_0_EO NULL
#define OPTION_VAL_NONE_EO NULL
#define OPTION_VAL_NTSC_RF_EO NULL
#define OPTION_VAL_NTSC_COMPOSITE_EO NULL
#define OPTION_VAL_NTSC_S_VIDEO_EO NULL
#define OPTION_VAL_NTSC_RGB_EO NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_EO NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_EO NULL
#define OPTION_VAL_0_O4_EO NULL
#define OPTION_VAL_10_EO NULL
#define OPTION_VAL_20_EO NULL
#define OPTION_VAL_30_EO NULL
#define OPTION_VAL_40_EO NULL
#define OPTION_VAL_50_EO NULL
#define OPTION_VAL_60_EO NULL
#define OPTION_VAL_70_EO NULL
#define OPTION_VAL_80_EO NULL
#define OPTION_VAL_90_EO NULL
#define OPTION_VAL_100_EO NULL
#define BSNES_VIDEO_SATURATION_LABEL_EO NULL
#define BSNES_VIDEO_SATURATION_INFO_0_EO NULL
#define OPTION_VAL_110_EO NULL
#define OPTION_VAL_120_EO NULL
#define OPTION_VAL_130_EO NULL
#define OPTION_VAL_140_EO NULL
#define OPTION_VAL_150_EO NULL
#define OPTION_VAL_160_EO NULL
#define OPTION_VAL_170_EO NULL
#define OPTION_VAL_180_EO NULL
#define OPTION_VAL_190_EO NULL
#define OPTION_VAL_200_EO NULL
#define BSNES_VIDEO_GAMMA_LABEL_EO NULL
#define BSNES_VIDEO_GAMMA_INFO_0_EO NULL
#define OPTION_VAL_100_O6_EO NULL
#define OPTION_VAL_150_O6_EO NULL
#define BSNES_PPU_FAST_LABEL_EO NULL
#define BSNES_PPU_FAST_LABEL_CAT_EO NULL
#define BSNES_PPU_FAST_INFO_0_EO NULL
#define BSNES_PPU_DEINTERLACE_LABEL_EO NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_EO NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_EO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EO NULL
#define BSNES_DSP_FAST_LABEL_EO NULL
#define BSNES_DSP_FAST_LABEL_CAT_EO NULL
#define BSNES_DSP_FAST_INFO_0_EO NULL
#define BSNES_DSP_CUBIC_LABEL_EO NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_EO NULL
#define BSNES_DSP_CUBIC_INFO_0_EO NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_EO NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EO NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_EO NULL
#define BSNES_MODE7_SCALE_LABEL_EO NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_EO NULL
#define BSNES_MODE7_SCALE_INFO_0_EO NULL
#define OPTION_VAL_1X_EO NULL
#define OPTION_VAL_2X_EO NULL
#define OPTION_VAL_3X_EO NULL
#define OPTION_VAL_4X_EO NULL
#define OPTION_VAL_5X_EO NULL
#define OPTION_VAL_6X_EO NULL
#define OPTION_VAL_7X_EO NULL
#define OPTION_VAL_8X_EO NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_EO NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EO NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_EO NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_EO NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EO NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_EO NULL
#define BSNES_MODE7_MOSAIC_LABEL_EO NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_EO NULL
#define BSNES_MODE7_MOSAIC_INFO_0_EO NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_EO NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_EO NULL
#define OPTION_VAL_1_EO NULL
#define OPTION_VAL_2_EO NULL
#define OPTION_VAL_3_EO NULL
#define OPTION_VAL_4_EO NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EO NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EO NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_EO NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EO NULL
#define BSNES_HOTFIXES_LABEL_EO NULL
#define BSNES_HOTFIXES_INFO_0_EO NULL
#define BSNES_ENTROPY_LABEL_EO NULL
#define BSNES_ENTROPY_INFO_0_EO NULL
#define OPTION_VAL_LOW_EO NULL
#define OPTION_VAL_HIGH_EO NULL
#define BSNES_CPU_FASTMATH_LABEL_EO NULL
#define BSNES_CPU_FASTMATH_INFO_0_EO NULL
#define BSNES_CPU_OVERCLOCK_LABEL_EO NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_EO NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_EO NULL
#define OPTION_VAL_210_EO NULL
#define OPTION_VAL_220_EO NULL
#define OPTION_VAL_230_EO NULL
#define OPTION_VAL_240_EO NULL
#define OPTION_VAL_250_EO NULL
#define OPTION_VAL_260_EO NULL
#define OPTION_VAL_270_EO NULL
#define OPTION_VAL_280_EO NULL
#define OPTION_VAL_290_EO NULL
#define OPTION_VAL_300_EO NULL
#define OPTION_VAL_310_EO NULL
#define OPTION_VAL_320_EO NULL
#define OPTION_VAL_330_EO NULL
#define OPTION_VAL_340_EO NULL
#define OPTION_VAL_350_EO NULL
#define OPTION_VAL_360_EO NULL
#define OPTION_VAL_370_EO NULL
#define OPTION_VAL_380_EO NULL
#define OPTION_VAL_390_EO NULL
#define OPTION_VAL_400_EO NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_EO NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EO NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_EO NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_EO NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EO NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_EO NULL
#define OPTION_VAL_410_EO NULL
#define OPTION_VAL_420_EO NULL
#define OPTION_VAL_430_EO NULL
#define OPTION_VAL_440_EO NULL
#define OPTION_VAL_450_EO NULL
#define OPTION_VAL_460_EO NULL
#define OPTION_VAL_470_EO NULL
#define OPTION_VAL_480_EO NULL
#define OPTION_VAL_490_EO NULL
#define OPTION_VAL_500_EO NULL
#define OPTION_VAL_510_EO NULL
#define OPTION_VAL_520_EO NULL
#define OPTION_VAL_530_EO NULL
#define OPTION_VAL_540_EO NULL
#define OPTION_VAL_550_EO NULL
#define OPTION_VAL_560_EO NULL
#define OPTION_VAL_570_EO NULL
#define OPTION_VAL_580_EO NULL
#define OPTION_VAL_590_EO NULL
#define OPTION_VAL_600_EO NULL
#define OPTION_VAL_610_EO NULL
#define OPTION_VAL_620_EO NULL
#define OPTION_VAL_630_EO NULL
#define OPTION_VAL_640_EO NULL
#define OPTION_VAL_650_EO NULL
#define OPTION_VAL_660_EO NULL
#define OPTION_VAL_670_EO NULL
#define OPTION_VAL_680_EO NULL
#define OPTION_VAL_690_EO NULL
#define OPTION_VAL_700_EO NULL
#define OPTION_VAL_710_EO NULL
#define OPTION_VAL_720_EO NULL
#define OPTION_VAL_730_EO NULL
#define OPTION_VAL_740_EO NULL
#define OPTION_VAL_750_EO NULL
#define OPTION_VAL_760_EO NULL
#define OPTION_VAL_770_EO NULL
#define OPTION_VAL_780_EO NULL
#define OPTION_VAL_790_EO NULL
#define OPTION_VAL_800_EO NULL
#define BSNES_SGB_BIOS_LABEL_EO NULL
#define BSNES_SGB_BIOS_INFO_0_EO NULL
#define OPTION_VAL_SGB1_SFC_EO NULL
#define OPTION_VAL_SGB2_SFC_EO NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_EO NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_EO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EO NULL

struct retro_core_option_v2_category option_cats_eo[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EO,
      CATEGORY_VIDEO_INFO_0_EO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_EO,
      CATEGORY_AUDIO_INFO_0_EO
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_EO,
      CATEGORY_MODE7_INFO_0_EO
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_EO,
      CATEGORY_HACK_INFO_0_EO
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_EO,
      CATEGORY_OVERCLOCK_INFO_0_EO
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_EO,
      CATEGORY_SGB_INFO_0_EO
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_EO,
      CATEGORY_LIGHTGUN_INFO_0_EO
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_eo[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_EO,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_EO,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_EO },
         { "1:1",  OPTION_VAL_1_1_EO },
         { "4:3",  OPTION_VAL_4_3_EO },
         { "NTSC", OPTION_VAL_NTSC_EO },
         { "PAL",  OPTION_VAL_PAL_EO },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_EO,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_EO,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_EO },
         { "8",  OPTION_VAL_8_EO },
         { "12", OPTION_VAL_12_EO },
         { "16", OPTION_VAL_16_EO },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_EO,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_EO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_EO,
      BSNES_VIDEO_FILTER_LABEL_EO,
      BSNES_VIDEO_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_EO },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_EO },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_EO },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_EO },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_EO },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_EO,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_EO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EO },
         { "10", OPTION_VAL_10_EO },
         { "20", OPTION_VAL_20_EO },
         { "30", OPTION_VAL_30_EO },
         { "40", OPTION_VAL_40_EO },
         { "50", OPTION_VAL_50_EO },
         { "60", OPTION_VAL_60_EO },
         { "70", OPTION_VAL_70_EO },
         { "80", OPTION_VAL_80_EO },
         { "90", OPTION_VAL_90_EO },
         { "100", OPTION_VAL_100_EO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_EO,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_EO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_EO },
         { "10", OPTION_VAL_10_EO },
         { "20", OPTION_VAL_20_EO },
         { "30", OPTION_VAL_30_EO },
         { "40", OPTION_VAL_40_EO },
         { "50", OPTION_VAL_50_EO },
         { "60", OPTION_VAL_60_EO },
         { "70", OPTION_VAL_70_EO },
         { "80", OPTION_VAL_80_EO },
         { "90", OPTION_VAL_90_EO },
         { "100", OPTION_VAL_100_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_EO,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_EO,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_O6_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_EO,
      BSNES_PPU_FAST_LABEL_CAT_EO,
      BSNES_PPU_FAST_INFO_0_EO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_EO,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_EO,
      BSNES_PPU_DEINTERLACE_INFO_0_EO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_EO,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_EO,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_EO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_EO,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_EO,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_EO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_EO,
      BSNES_DSP_FAST_LABEL_CAT_EO,
      BSNES_DSP_FAST_INFO_0_EO,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_EO,
      BSNES_DSP_CUBIC_LABEL_CAT_EO,
      BSNES_DSP_CUBIC_INFO_0_EO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_EO,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_EO,
      BSNES_DSP_ECHO_SHADOW_INFO_0_EO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_EO,
      BSNES_MODE7_SCALE_LABEL_CAT_EO,
      BSNES_MODE7_SCALE_INFO_0_EO,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_EO  },
         { "2x", OPTION_VAL_2X_EO  },
         { "3x", OPTION_VAL_3X_EO  },
         { "4x", OPTION_VAL_4X_EO  },
         { "5x", OPTION_VAL_5X_EO },
         { "6x", OPTION_VAL_6X_EO },
         { "7x", OPTION_VAL_7X_EO },
         { "8x", OPTION_VAL_8X_EO },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_EO,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_EO,
      BSNES_MODE7_PERSPECTIVE_INFO_0_EO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_EO,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_EO,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_EO,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_EO,
      BSNES_MODE7_MOSAIC_LABEL_CAT_EO,
      BSNES_MODE7_MOSAIC_INFO_0_EO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_EO,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_EO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_EO  },
         { "2",   OPTION_VAL_2_EO },
         { "3",   OPTION_VAL_3_EO },
         { "4",   OPTION_VAL_4_EO },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_EO,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_EO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_EO,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_EO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_EO,
      NULL,
      BSNES_HOTFIXES_INFO_0_EO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_EO,
      NULL,
      BSNES_ENTROPY_INFO_0_EO,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_EO },
         { "High", OPTION_VAL_HIGH_EO },
         { "None", OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_EO,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_EO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_EO,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_EO,
      BSNES_CPU_OVERCLOCK_INFO_0_EO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EO  },
         { "20",  OPTION_VAL_20_EO  },
         { "30",  OPTION_VAL_30_EO  },
         { "40",  OPTION_VAL_40_EO  },
         { "50",  OPTION_VAL_50_EO  },
         { "60",  OPTION_VAL_60_EO  },
         { "70",  OPTION_VAL_70_EO  },
         { "80",  OPTION_VAL_80_EO  },
         { "90",  OPTION_VAL_90_EO  },
         { "100", OPTION_VAL_100_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { "210", OPTION_VAL_210_EO },
         { "220", OPTION_VAL_220_EO },
         { "230", OPTION_VAL_230_EO },
         { "240", OPTION_VAL_240_EO },
         { "250", OPTION_VAL_250_EO },
         { "260", OPTION_VAL_260_EO },
         { "270", OPTION_VAL_270_EO },
         { "280", OPTION_VAL_280_EO },
         { "290", OPTION_VAL_290_EO },
         { "300", OPTION_VAL_300_EO },
         { "310", OPTION_VAL_310_EO },
         { "320", OPTION_VAL_320_EO },
         { "330", OPTION_VAL_330_EO },
         { "340", OPTION_VAL_340_EO },
         { "350", OPTION_VAL_350_EO },
         { "360", OPTION_VAL_360_EO },
         { "370", OPTION_VAL_370_EO },
         { "380", OPTION_VAL_380_EO },
         { "390", OPTION_VAL_390_EO },
         { "400", OPTION_VAL_400_EO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_EO,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_EO,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_EO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EO  },
         { "20",  OPTION_VAL_20_EO  },
         { "30",  OPTION_VAL_30_EO  },
         { "40",  OPTION_VAL_40_EO  },
         { "50",  OPTION_VAL_50_EO  },
         { "60",  OPTION_VAL_60_EO  },
         { "70",  OPTION_VAL_70_EO  },
         { "80",  OPTION_VAL_80_EO  },
         { "90",  OPTION_VAL_90_EO  },
         { "100", OPTION_VAL_100_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { "210", OPTION_VAL_210_EO },
         { "220", OPTION_VAL_220_EO },
         { "230", OPTION_VAL_230_EO },
         { "240", OPTION_VAL_240_EO },
         { "250", OPTION_VAL_250_EO },
         { "260", OPTION_VAL_260_EO },
         { "270", OPTION_VAL_270_EO },
         { "280", OPTION_VAL_280_EO },
         { "290", OPTION_VAL_290_EO },
         { "300", OPTION_VAL_300_EO },
         { "310", OPTION_VAL_310_EO },
         { "320", OPTION_VAL_320_EO },
         { "330", OPTION_VAL_330_EO },
         { "340", OPTION_VAL_340_EO },
         { "350", OPTION_VAL_350_EO },
         { "360", OPTION_VAL_360_EO },
         { "370", OPTION_VAL_370_EO },
         { "380", OPTION_VAL_380_EO },
         { "390", OPTION_VAL_390_EO },
         { "400", OPTION_VAL_400_EO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_EO,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_EO,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_EO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_EO  },
         { "20",  OPTION_VAL_20_EO  },
         { "30",  OPTION_VAL_30_EO  },
         { "40",  OPTION_VAL_40_EO  },
         { "50",  OPTION_VAL_50_EO  },
         { "60",  OPTION_VAL_60_EO  },
         { "70",  OPTION_VAL_70_EO  },
         { "80",  OPTION_VAL_80_EO  },
         { "90",  OPTION_VAL_90_EO  },
         { "100", OPTION_VAL_100_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { "210", OPTION_VAL_210_EO },
         { "220", OPTION_VAL_220_EO },
         { "230", OPTION_VAL_230_EO },
         { "240", OPTION_VAL_240_EO },
         { "250", OPTION_VAL_250_EO },
         { "260", OPTION_VAL_260_EO },
         { "270", OPTION_VAL_270_EO },
         { "280", OPTION_VAL_280_EO },
         { "290", OPTION_VAL_290_EO },
         { "300", OPTION_VAL_300_EO },
         { "310", OPTION_VAL_310_EO },
         { "320", OPTION_VAL_320_EO },
         { "330", OPTION_VAL_330_EO },
         { "340", OPTION_VAL_340_EO },
         { "350", OPTION_VAL_350_EO },
         { "360", OPTION_VAL_360_EO },
         { "370", OPTION_VAL_370_EO },
         { "380", OPTION_VAL_380_EO },
         { "390", OPTION_VAL_390_EO },
         { "400", OPTION_VAL_400_EO },
         { "410", OPTION_VAL_410_EO },
         { "420", OPTION_VAL_420_EO },
         { "430", OPTION_VAL_430_EO },
         { "440", OPTION_VAL_440_EO },
         { "450", OPTION_VAL_450_EO },
         { "460", OPTION_VAL_460_EO },
         { "470", OPTION_VAL_470_EO },
         { "480", OPTION_VAL_480_EO },
         { "490", OPTION_VAL_490_EO },
         { "500", OPTION_VAL_500_EO },
         { "510", OPTION_VAL_510_EO },
         { "520", OPTION_VAL_520_EO },
         { "530", OPTION_VAL_530_EO },
         { "540", OPTION_VAL_540_EO },
         { "550", OPTION_VAL_550_EO },
         { "560", OPTION_VAL_560_EO },
         { "570", OPTION_VAL_570_EO },
         { "580", OPTION_VAL_580_EO },
         { "590", OPTION_VAL_590_EO },
         { "600", OPTION_VAL_600_EO },
         { "610", OPTION_VAL_610_EO },
         { "620", OPTION_VAL_620_EO },
         { "630", OPTION_VAL_630_EO },
         { "640", OPTION_VAL_640_EO },
         { "650", OPTION_VAL_650_EO },
         { "660", OPTION_VAL_660_EO },
         { "670", OPTION_VAL_670_EO },
         { "680", OPTION_VAL_680_EO },
         { "690", OPTION_VAL_690_EO },
         { "700", OPTION_VAL_700_EO },
         { "710", OPTION_VAL_710_EO },
         { "720", OPTION_VAL_720_EO },
         { "730", OPTION_VAL_730_EO },
         { "740", OPTION_VAL_740_EO },
         { "750", OPTION_VAL_750_EO },
         { "760", OPTION_VAL_760_EO },
         { "770", OPTION_VAL_770_EO },
         { "780", OPTION_VAL_780_EO },
         { "790", OPTION_VAL_790_EO },
         { "800", OPTION_VAL_800_EO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_EO,
      NULL,
      BSNES_SGB_BIOS_INFO_0_EO,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_EO   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_EO },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_EO,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_EO,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_EO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_EO,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_EO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_EO,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_eo = {
   option_cats_eo,
   option_defs_eo
};

/* RETRO_LANGUAGE_ES */

#define CATEGORY_VIDEO_LABEL_ES "Vídeo"
#define CATEGORY_VIDEO_INFO_0_ES "Cambia los ajustes de la salida de vídeo."
#define CATEGORY_AUDIO_LABEL_ES NULL
#define CATEGORY_AUDIO_INFO_0_ES "Cambia los ajustes de la salida de audio."
#define CATEGORY_MODE7_LABEL_ES "Modo 7 en alta definición (HD)"
#define CATEGORY_MODE7_INFO_0_ES "Cambia los ajustes relativos a la emulación de los gráficos en Modo 7."
#define CATEGORY_HACK_LABEL_ES "Arreglos y mejoras de emulación"
#define CATEGORY_HACK_INFO_0_ES "Aplica arreglos, mejoras y revisiones de emulación."
#define CATEGORY_OVERCLOCK_LABEL_ES "Subir/bajar velocidad de CPU"
#define CATEGORY_OVERCLOCK_INFO_0_ES "Cambia la velocidad del hardware emulado."
#define CATEGORY_SGB_LABEL_ES NULL
#define CATEGORY_SGB_INFO_0_ES "Cambia los ajustes relativos a la emulación del Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_ES "Pistola de luz"
#define CATEGORY_LIGHTGUN_INFO_0_ES "Cambia los ajustes de las pistolas de luz (para pantallas táctiles)."
#define BSNES_ASPECT_RATIO_LABEL_ES "Relación de aspecto preferida"
#define BSNES_ASPECT_RATIO_INFO_0_ES "Selecciona la relación de aspecto del contenido. Esta opción solo surtirá efecto cuando la relación de aspecto de RetroArch, en el apartado de ajustes de Vídeo, esté configurada como «Asignada por el núcleo»."
#define OPTION_VAL_AUTO_ES "Selección automática"
#define OPTION_VAL_1_1_ES "PAR 1:1 (píxeles perfectos)"
#define OPTION_VAL_4_3_ES "DAR 4:3"
#define OPTION_VAL_NTSC_ES NULL
#define OPTION_VAL_PAL_ES NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_ES "Recortar sobrebarrido vertical"
#define BSNES_PPU_OVERSCAN_V_INFO_0_ES "Elimina una cantidad concreta de líneas en las partes superior e inferior de la pantalla para simular el marco de un televisor usado en la época de SNES."
#define OPTION_VAL_0_ES "0 líneas"
#define OPTION_VAL_8_ES "8 líneas"
#define OPTION_VAL_12_ES "12 líneas"
#define OPTION_VAL_16_ES "16 líneas"
#define BSNES_BLUR_EMULATION_LABEL_ES "Emular difuminado"
#define BSNES_BLUR_EMULATION_INFO_0_ES "Simula la limitación de la resolución horizontal de un televisor SD difuminando los píxeles que sean adyacentes horizontalmente. Algunos juegos necesitan este efecto para simular un efecto de transparencia."
#define BSNES_VIDEO_FILTER_LABEL_ES "Filtro"
#define BSNES_VIDEO_FILTER_INFO_0_ES "Aplica o no el filtro NTSC de blargg, con opciones para simular una señal RF, de vídeo compuesto, S-Video o RGB."
#define OPTION_VAL_NONE_ES "Ninguna"
#define OPTION_VAL_NTSC_RF_ES NULL
#define OPTION_VAL_NTSC_COMPOSITE_ES "NTSC (Compuesto)"
#define OPTION_VAL_NTSC_S_VIDEO_ES NULL
#define OPTION_VAL_NTSC_RGB_ES NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_ES "Ajuste de color: luminosidad"
#define BSNES_VIDEO_LUMINANCE_INFO_0_ES "Ajustar luminosidad"
#define OPTION_VAL_0_O4_ES "0 %"
#define OPTION_VAL_10_ES "10 %"
#define OPTION_VAL_20_ES "20 %"
#define OPTION_VAL_30_ES "30 %"
#define OPTION_VAL_40_ES "40 %"
#define OPTION_VAL_50_ES "50 %"
#define OPTION_VAL_60_ES "60 %"
#define OPTION_VAL_70_ES "70 %"
#define OPTION_VAL_80_ES "80 %"
#define OPTION_VAL_90_ES "90 %"
#define OPTION_VAL_100_ES "100 % (por defecto)"
#define BSNES_VIDEO_SATURATION_LABEL_ES "Ajuste de color: saturación"
#define BSNES_VIDEO_SATURATION_INFO_0_ES "Ajustar saturación"
#define OPTION_VAL_110_ES "110 %"
#define OPTION_VAL_120_ES "120 %"
#define OPTION_VAL_130_ES "130 %"
#define OPTION_VAL_140_ES "140 %"
#define OPTION_VAL_150_ES "150 %"
#define OPTION_VAL_160_ES "160 %"
#define OPTION_VAL_170_ES "170 %"
#define OPTION_VAL_180_ES "180 %"
#define OPTION_VAL_190_ES "190 %"
#define OPTION_VAL_200_ES "200 %"
#define BSNES_VIDEO_GAMMA_LABEL_ES "Ajuste de color: gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_ES "Ajustar gamma"
#define OPTION_VAL_100_O6_ES "100 %"
#define OPTION_VAL_150_O6_ES "150 % (valor predeterminado)"
#define BSNES_PPU_FAST_LABEL_ES "PPU (vídeo): modo rápido"
#define BSNES_PPU_FAST_LABEL_CAT_ES "PPU: modo rápido"
#define BSNES_PPU_FAST_INFO_0_ES "Habilita una emulación más rápida de la PPU con una leve reducción de precisión. Se recomienda dejar esta opción activada. NOTA: esta opción debe estar activada para que funcionen las opciones «Desentrelazado», «Desactivar límite de sprites» y «Modo 7 en alta definición (HD)»."
#define BSNES_PPU_DEINTERLACE_LABEL_ES "PPU (vídeo): desentrelazado"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_ES "PPU: desentrelazado"
#define BSNES_PPU_DEINTERLACE_INFO_0_ES "Desentrelaza todos los juegos renderizándolos de forma interna a 480p. Apenas afecta al rendimiento, así que se recomienda dejar esta opción activada."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_ES "PPU (vídeo): desactivar límite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_ES "PPU: desactivar límite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_ES "Elimina todos los límites en el número de sprites que se puedan representar de forma simultánea en pantalla. Podría provocar problemas en algunos juegos."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_ES "PPU (vídeo): eliminar bloqueo de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_ES "PPU: eliminar bloqueo de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_ES "Emula un defecto de las versiones antiguas de ZSNES y Snes9x, con las que no se emulaba el bloqueo de VRAM. Algunos «romhacks» antiguos dependían de este comportamiento y mostrarán sus gráficos incorrectamente si no se activa esta opción. Es sumamente inexacta y afecta a la velocidad de la PPU, así que se recomienda mantener esta opción desactivada a menos que necesites jugar a un juego que sea incompatible con este núcleo sin tal opción."
#define BSNES_DSP_FAST_LABEL_ES "DSP (audio): modo rápido"
#define BSNES_DSP_FAST_LABEL_CAT_ES "DSP: modo rápido"
#define BSNES_DSP_FAST_INFO_0_ES "Permite una emulación más rápida de la DSP a cambio de perder precisión. Se recomienda dejar esta opción activada."
#define BSNES_DSP_CUBIC_LABEL_ES "DSP (audio): interpolación cúbica"
#define BSNES_DSP_CUBIC_LABEL_CAT_ES "DSP: interpolación cúbica"
#define BSNES_DSP_CUBIC_INFO_0_ES "Aplica una interpolación cúbica al sonido para conservar un mayor rango de frecuencias agudas."
#define BSNES_DSP_ECHO_SHADOW_LABEL_ES "DSP (audio): duplicación de RAM para ecos"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_ES "DSP: duplicación de RAM para ecos"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_ES "Emula un defecto de ZSNES en el que la RAM para ecos se trataba como una unidad independiente de la RAM de la APU. Muchos «romhacks» antiguos para Super Mario World dependían de este comportamiento y se colgarán si no existe. Esta opción es sumamente inexacta y no debería ser activada a menos que sea imprescindible."
#define BSNES_MODE7_SCALE_LABEL_ES "Modo 7 en alta definición (HD): escalar"
#define BSNES_MODE7_SCALE_LABEL_CAT_ES "Escalar"
#define BSNES_MODE7_SCALE_INFO_0_ES "Aumenta la resolución horizontal y vertical de los gráficos en Modo 7 utilizados por ciertos juegos."
#define OPTION_VAL_1X_ES "240p (x1)"
#define OPTION_VAL_2X_ES "480p (x2)"
#define OPTION_VAL_3X_ES "720p (x3)"
#define OPTION_VAL_4X_ES "960p (x4)"
#define OPTION_VAL_5X_ES "1200p (x5)"
#define OPTION_VAL_6X_ES "1440p (x6)"
#define OPTION_VAL_7X_ES "1680p (x7)"
#define OPTION_VAL_8X_ES "1920p (x8)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_ES "Modo 7 en alta definición: corrección de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_ES "Corrección de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_ES "Corrige la perspectiva de los gráficos en Modo 7 que utilizan ciertos juegos sorteando algunas de las limitaciones de los cálculos con números enteros que utiliza la SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_ES "Modo 7 en HD: supermuestreo"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_ES "Supermuestreo"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_ES "Supermuestrea los gráficos en Modo 7 que utilizan algunos juegos. Si se utiliza con un factor de escala elevado para el Modo 7, producirá un efecto similar al suavizado de bordes."
#define BSNES_MODE7_MOSAIC_LABEL_ES "Modo 7 en alta definición: mosaico de alta a baja definición"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_ES "Mosaico de alta a baja definición"
#define BSNES_MODE7_MOSAIC_INFO_0_ES "Muestra el efecto de mosaico de los gráficos en Modo 7 al aumentar su escala."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_ES "Reducción predictiva de latencia interna"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_ES "Simula el sistema por adelantado y luego ejecuta una reversión para reducir la latencia de entrada. Esta opción tiene requisitos de sistema muy altos."
#define OPTION_VAL_1_ES "1 fotograma"
#define OPTION_VAL_2_ES "2 fotogramas"
#define OPTION_VAL_3_ES "3 fotogramas"
#define OPTION_VAL_4_ES "4 fotogramas"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_ES "Coprocesadores: modo rápido"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_ES "Permite una emulación más rápida de los coprocesadores a cambio de perder precisión. Se recomienda dejar esta opción activada."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_ES "Coprocesadores: preferir emulación de alto nivel (HLE)"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_ES "Al activar esta opción se utilizará una emulación de alto nivel (HLE) menos precisa si es posible. En caso contrario, solo se empleará la emulación de alto nivel cuando no se encuentre el firmware de emulación de bajo nivel (LLE)."
#define BSNES_HOTFIXES_LABEL_ES "Correcciones"
#define BSNES_HOTFIXES_INFO_0_ES "A veces, hasta el software de procedencia oficial y comercial puede incluir fallos. Esta opción corregirá ciertos problemas que ocurren hasta en el hardware real."
#define BSNES_ENTROPY_LABEL_ES "Entropía (aleatorización)"
#define BSNES_ENTROPY_INFO_0_ES "Selecciona el nivel de aleatoriedad de la memoria y los registros. En caso de seleccionar Ninguna, toda la memoria y los registros se iniciarán al arrancar con unos valores constantes. Una aleatorización baja ofrece la representación más fidedigna de un sistema real. La opción Alta producirá unos valores lo más aleatorios posibles."
#define OPTION_VAL_LOW_ES "Baja"
#define OPTION_VAL_HIGH_ES "Alta"
#define BSNES_CPU_FASTMATH_LABEL_ES "Acelerar cálculos matemáticos de la CPU"
#define BSNES_CPU_FASTMATH_INFO_0_ES "Produce los resultados de computación de forma inmediata. Las multiplicaciones y divisiones vía CPU tardan un tiempo en llevarse a cabo en una SNES real. Los emuladores más antiguos no simulaban estos retrasos, por lo que ciertos «romhacks» antiguos no esperan a que se completen los cálculos matemáticos y necesitan esta corrección."
#define BSNES_CPU_OVERCLOCK_LABEL_ES "Velocidad de la CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_ES NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_ES "Aumenta o disminuye la velocidad de la CPU. Un valor superior al 100 % podría reducir los tiempos de carga y las ralentizaciones. Utiliza esta opción con cuidado, ya que también podría provocar cuelgues u otros problemas en algunos juegos."
#define OPTION_VAL_210_ES "210 %"
#define OPTION_VAL_220_ES "220 %"
#define OPTION_VAL_230_ES "230 %"
#define OPTION_VAL_240_ES "240 %"
#define OPTION_VAL_250_ES "250 %"
#define OPTION_VAL_260_ES "260 %"
#define OPTION_VAL_270_ES "270 %"
#define OPTION_VAL_280_ES "280 %"
#define OPTION_VAL_290_ES "290 %"
#define OPTION_VAL_300_ES "300 %"
#define OPTION_VAL_310_ES "310 %"
#define OPTION_VAL_320_ES "320 %"
#define OPTION_VAL_330_ES "330 %"
#define OPTION_VAL_340_ES "340 %"
#define OPTION_VAL_350_ES "350 %"
#define OPTION_VAL_360_ES "360 %"
#define OPTION_VAL_370_ES "370 %"
#define OPTION_VAL_380_ES "380 %"
#define OPTION_VAL_390_ES "390 %"
#define OPTION_VAL_400_ES "400 %"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_ES "Velocidad del coprocesador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_ES "Coprocesador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_ES "Aumenta o disminuye la velocidad del chip Super Accelerator 1 (SA-1). Un valor superior al 100 % podría mejorar el rendimiento en aquellos juegos compatibles con este chip. Utiliza esta opción con cuidado, ya que también podría provocar cuelgues u otros problemas en algunos juegos."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_ES "Velocidad del coprocesador SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_ES "Coprocesador SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_ES "Aumenta o disminuye la velocidad del chip coprocesador SuperFX. Un valor superior al 100 % podría mejorar el rendimiento en aquellos juegos compatibles con este chip. Utiliza esta opción con cuidado, ya que también podría provocar cuelgues u otros problemas en algunos juegos."
#define OPTION_VAL_410_ES "410 %"
#define OPTION_VAL_420_ES "420 %"
#define OPTION_VAL_430_ES "430 %"
#define OPTION_VAL_440_ES "440 %"
#define OPTION_VAL_450_ES "450 %"
#define OPTION_VAL_460_ES "460 %"
#define OPTION_VAL_470_ES "470 %"
#define OPTION_VAL_480_ES "480 %"
#define OPTION_VAL_490_ES "490 %"
#define OPTION_VAL_500_ES "500 %"
#define OPTION_VAL_510_ES "510 %"
#define OPTION_VAL_520_ES "520 %"
#define OPTION_VAL_530_ES "530 %"
#define OPTION_VAL_540_ES "540 %"
#define OPTION_VAL_550_ES "550 %"
#define OPTION_VAL_560_ES "560 %"
#define OPTION_VAL_570_ES "570 %"
#define OPTION_VAL_580_ES "580 %"
#define OPTION_VAL_590_ES "590 %"
#define OPTION_VAL_600_ES "600 %"
#define OPTION_VAL_610_ES "610 %"
#define OPTION_VAL_620_ES "620 %"
#define OPTION_VAL_630_ES "630 %"
#define OPTION_VAL_640_ES "640 %"
#define OPTION_VAL_650_ES "650 %"
#define OPTION_VAL_660_ES "660 %"
#define OPTION_VAL_670_ES "670 %"
#define OPTION_VAL_680_ES "680 %"
#define OPTION_VAL_690_ES "690 %"
#define OPTION_VAL_700_ES "700 %"
#define OPTION_VAL_710_ES "710 %"
#define OPTION_VAL_720_ES "720 %"
#define OPTION_VAL_730_ES "730 %"
#define OPTION_VAL_740_ES "740 %"
#define OPTION_VAL_750_ES "750 %"
#define OPTION_VAL_760_ES "760 %"
#define OPTION_VAL_770_ES "770 %"
#define OPTION_VAL_780_ES "780 %"
#define OPTION_VAL_790_ES "790 %"
#define OPTION_VAL_800_ES "800 %"
#define BSNES_SGB_BIOS_LABEL_ES "BIOS de Super Game Boy preferida (es necesario reiniciar)"
#define BSNES_SGB_BIOS_INFO_0_ES "Selecciona la BIOS de Super Game Boy que se utilizará con los juegos compatibles."
#define OPTION_VAL_SGB1_SFC_ES NULL
#define OPTION_VAL_SGB2_SFC_ES NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_ES "Ocultar borde del Super Game Boy"
#define BSNES_HIDE_SGB_BORDER_INFO_0_ES "Oculta el borde al ejecutar juegos con Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_ES "Usar la pantalla táctil como pistola de luz"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_ES "Permite utilizar los dispositivos táctiles como método de entrada del Super Scope."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_ES "Invertir gatillos del Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_ES "Invierte los botones de gatillo y cursor del Super Scope en la pantalla táctil."

struct retro_core_option_v2_category option_cats_es[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_ES,
      CATEGORY_VIDEO_INFO_0_ES
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_ES,
      CATEGORY_AUDIO_INFO_0_ES
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_ES,
      CATEGORY_MODE7_INFO_0_ES
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_ES,
      CATEGORY_HACK_INFO_0_ES
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_ES,
      CATEGORY_OVERCLOCK_INFO_0_ES
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_ES,
      CATEGORY_SGB_INFO_0_ES
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_ES,
      CATEGORY_LIGHTGUN_INFO_0_ES
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_es[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_ES,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_ES,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_ES },
         { "1:1",  OPTION_VAL_1_1_ES },
         { "4:3",  OPTION_VAL_4_3_ES },
         { "NTSC", OPTION_VAL_NTSC_ES },
         { "PAL",  OPTION_VAL_PAL_ES },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_ES,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_ES,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_ES },
         { "8",  OPTION_VAL_8_ES },
         { "12", OPTION_VAL_12_ES },
         { "16", OPTION_VAL_16_ES },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_ES,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_ES,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_ES,
      BSNES_VIDEO_FILTER_LABEL_ES,
      BSNES_VIDEO_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_ES },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_ES },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_ES },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_ES },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_ES },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_ES,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_ES,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_ES },
         { "10", OPTION_VAL_10_ES },
         { "20", OPTION_VAL_20_ES },
         { "30", OPTION_VAL_30_ES },
         { "40", OPTION_VAL_40_ES },
         { "50", OPTION_VAL_50_ES },
         { "60", OPTION_VAL_60_ES },
         { "70", OPTION_VAL_70_ES },
         { "80", OPTION_VAL_80_ES },
         { "90", OPTION_VAL_90_ES },
         { "100", OPTION_VAL_100_ES },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_ES,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_ES,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_ES },
         { "10", OPTION_VAL_10_ES },
         { "20", OPTION_VAL_20_ES },
         { "30", OPTION_VAL_30_ES },
         { "40", OPTION_VAL_40_ES },
         { "50", OPTION_VAL_50_ES },
         { "60", OPTION_VAL_60_ES },
         { "70", OPTION_VAL_70_ES },
         { "80", OPTION_VAL_80_ES },
         { "90", OPTION_VAL_90_ES },
         { "100", OPTION_VAL_100_ES },
         { "110", OPTION_VAL_110_ES },
         { "120", OPTION_VAL_120_ES },
         { "130", OPTION_VAL_130_ES },
         { "140", OPTION_VAL_140_ES },
         { "150", OPTION_VAL_150_ES },
         { "160", OPTION_VAL_160_ES },
         { "170", OPTION_VAL_170_ES },
         { "180", OPTION_VAL_180_ES },
         { "190", OPTION_VAL_190_ES },
         { "200", OPTION_VAL_200_ES },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_ES,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_ES,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_ES },
         { "110", OPTION_VAL_110_ES },
         { "120", OPTION_VAL_120_ES },
         { "130", OPTION_VAL_130_ES },
         { "140", OPTION_VAL_140_ES },
         { "150", OPTION_VAL_150_O6_ES },
         { "160", OPTION_VAL_160_ES },
         { "170", OPTION_VAL_170_ES },
         { "180", OPTION_VAL_180_ES },
         { "190", OPTION_VAL_190_ES },
         { "200", OPTION_VAL_200_ES },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_ES,
      BSNES_PPU_FAST_LABEL_CAT_ES,
      BSNES_PPU_FAST_INFO_0_ES,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_ES,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_ES,
      BSNES_PPU_DEINTERLACE_INFO_0_ES,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_ES,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_ES,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_ES,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_ES,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_ES,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_ES,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_ES,
      BSNES_DSP_FAST_LABEL_CAT_ES,
      BSNES_DSP_FAST_INFO_0_ES,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_ES,
      BSNES_DSP_CUBIC_LABEL_CAT_ES,
      BSNES_DSP_CUBIC_INFO_0_ES,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_ES,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_ES,
      BSNES_DSP_ECHO_SHADOW_INFO_0_ES,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_ES,
      BSNES_MODE7_SCALE_LABEL_CAT_ES,
      BSNES_MODE7_SCALE_INFO_0_ES,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_ES  },
         { "2x", OPTION_VAL_2X_ES  },
         { "3x", OPTION_VAL_3X_ES  },
         { "4x", OPTION_VAL_4X_ES  },
         { "5x", OPTION_VAL_5X_ES },
         { "6x", OPTION_VAL_6X_ES },
         { "7x", OPTION_VAL_7X_ES },
         { "8x", OPTION_VAL_8X_ES },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_ES,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_ES,
      BSNES_MODE7_PERSPECTIVE_INFO_0_ES,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_ES,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_ES,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_ES,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_ES,
      BSNES_MODE7_MOSAIC_LABEL_CAT_ES,
      BSNES_MODE7_MOSAIC_INFO_0_ES,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_ES,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_ES,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_ES  },
         { "2",   OPTION_VAL_2_ES },
         { "3",   OPTION_VAL_3_ES },
         { "4",   OPTION_VAL_4_ES },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_ES,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_ES,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_ES,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_ES,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_ES,
      NULL,
      BSNES_HOTFIXES_INFO_0_ES,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_ES,
      NULL,
      BSNES_ENTROPY_INFO_0_ES,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_ES },
         { "High", OPTION_VAL_HIGH_ES },
         { "None", OPTION_VAL_NONE_ES },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_ES,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_ES,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_ES,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_ES,
      BSNES_CPU_OVERCLOCK_INFO_0_ES,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ES  },
         { "20",  OPTION_VAL_20_ES  },
         { "30",  OPTION_VAL_30_ES  },
         { "40",  OPTION_VAL_40_ES  },
         { "50",  OPTION_VAL_50_ES  },
         { "60",  OPTION_VAL_60_ES  },
         { "70",  OPTION_VAL_70_ES  },
         { "80",  OPTION_VAL_80_ES  },
         { "90",  OPTION_VAL_90_ES  },
         { "100", OPTION_VAL_100_ES },
         { "110", OPTION_VAL_110_ES },
         { "120", OPTION_VAL_120_ES },
         { "130", OPTION_VAL_130_ES },
         { "140", OPTION_VAL_140_ES },
         { "150", OPTION_VAL_150_ES },
         { "160", OPTION_VAL_160_ES },
         { "170", OPTION_VAL_170_ES },
         { "180", OPTION_VAL_180_ES },
         { "190", OPTION_VAL_190_ES },
         { "200", OPTION_VAL_200_ES },
         { "210", OPTION_VAL_210_ES },
         { "220", OPTION_VAL_220_ES },
         { "230", OPTION_VAL_230_ES },
         { "240", OPTION_VAL_240_ES },
         { "250", OPTION_VAL_250_ES },
         { "260", OPTION_VAL_260_ES },
         { "270", OPTION_VAL_270_ES },
         { "280", OPTION_VAL_280_ES },
         { "290", OPTION_VAL_290_ES },
         { "300", OPTION_VAL_300_ES },
         { "310", OPTION_VAL_310_ES },
         { "320", OPTION_VAL_320_ES },
         { "330", OPTION_VAL_330_ES },
         { "340", OPTION_VAL_340_ES },
         { "350", OPTION_VAL_350_ES },
         { "360", OPTION_VAL_360_ES },
         { "370", OPTION_VAL_370_ES },
         { "380", OPTION_VAL_380_ES },
         { "390", OPTION_VAL_390_ES },
         { "400", OPTION_VAL_400_ES },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_ES,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_ES,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_ES,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ES  },
         { "20",  OPTION_VAL_20_ES  },
         { "30",  OPTION_VAL_30_ES  },
         { "40",  OPTION_VAL_40_ES  },
         { "50",  OPTION_VAL_50_ES  },
         { "60",  OPTION_VAL_60_ES  },
         { "70",  OPTION_VAL_70_ES  },
         { "80",  OPTION_VAL_80_ES  },
         { "90",  OPTION_VAL_90_ES  },
         { "100", OPTION_VAL_100_ES },
         { "110", OPTION_VAL_110_ES },
         { "120", OPTION_VAL_120_ES },
         { "130", OPTION_VAL_130_ES },
         { "140", OPTION_VAL_140_ES },
         { "150", OPTION_VAL_150_ES },
         { "160", OPTION_VAL_160_ES },
         { "170", OPTION_VAL_170_ES },
         { "180", OPTION_VAL_180_ES },
         { "190", OPTION_VAL_190_ES },
         { "200", OPTION_VAL_200_ES },
         { "210", OPTION_VAL_210_ES },
         { "220", OPTION_VAL_220_ES },
         { "230", OPTION_VAL_230_ES },
         { "240", OPTION_VAL_240_ES },
         { "250", OPTION_VAL_250_ES },
         { "260", OPTION_VAL_260_ES },
         { "270", OPTION_VAL_270_ES },
         { "280", OPTION_VAL_280_ES },
         { "290", OPTION_VAL_290_ES },
         { "300", OPTION_VAL_300_ES },
         { "310", OPTION_VAL_310_ES },
         { "320", OPTION_VAL_320_ES },
         { "330", OPTION_VAL_330_ES },
         { "340", OPTION_VAL_340_ES },
         { "350", OPTION_VAL_350_ES },
         { "360", OPTION_VAL_360_ES },
         { "370", OPTION_VAL_370_ES },
         { "380", OPTION_VAL_380_ES },
         { "390", OPTION_VAL_390_ES },
         { "400", OPTION_VAL_400_ES },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_ES,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_ES,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_ES,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ES  },
         { "20",  OPTION_VAL_20_ES  },
         { "30",  OPTION_VAL_30_ES  },
         { "40",  OPTION_VAL_40_ES  },
         { "50",  OPTION_VAL_50_ES  },
         { "60",  OPTION_VAL_60_ES  },
         { "70",  OPTION_VAL_70_ES  },
         { "80",  OPTION_VAL_80_ES  },
         { "90",  OPTION_VAL_90_ES  },
         { "100", OPTION_VAL_100_ES },
         { "110", OPTION_VAL_110_ES },
         { "120", OPTION_VAL_120_ES },
         { "130", OPTION_VAL_130_ES },
         { "140", OPTION_VAL_140_ES },
         { "150", OPTION_VAL_150_ES },
         { "160", OPTION_VAL_160_ES },
         { "170", OPTION_VAL_170_ES },
         { "180", OPTION_VAL_180_ES },
         { "190", OPTION_VAL_190_ES },
         { "200", OPTION_VAL_200_ES },
         { "210", OPTION_VAL_210_ES },
         { "220", OPTION_VAL_220_ES },
         { "230", OPTION_VAL_230_ES },
         { "240", OPTION_VAL_240_ES },
         { "250", OPTION_VAL_250_ES },
         { "260", OPTION_VAL_260_ES },
         { "270", OPTION_VAL_270_ES },
         { "280", OPTION_VAL_280_ES },
         { "290", OPTION_VAL_290_ES },
         { "300", OPTION_VAL_300_ES },
         { "310", OPTION_VAL_310_ES },
         { "320", OPTION_VAL_320_ES },
         { "330", OPTION_VAL_330_ES },
         { "340", OPTION_VAL_340_ES },
         { "350", OPTION_VAL_350_ES },
         { "360", OPTION_VAL_360_ES },
         { "370", OPTION_VAL_370_ES },
         { "380", OPTION_VAL_380_ES },
         { "390", OPTION_VAL_390_ES },
         { "400", OPTION_VAL_400_ES },
         { "410", OPTION_VAL_410_ES },
         { "420", OPTION_VAL_420_ES },
         { "430", OPTION_VAL_430_ES },
         { "440", OPTION_VAL_440_ES },
         { "450", OPTION_VAL_450_ES },
         { "460", OPTION_VAL_460_ES },
         { "470", OPTION_VAL_470_ES },
         { "480", OPTION_VAL_480_ES },
         { "490", OPTION_VAL_490_ES },
         { "500", OPTION_VAL_500_ES },
         { "510", OPTION_VAL_510_ES },
         { "520", OPTION_VAL_520_ES },
         { "530", OPTION_VAL_530_ES },
         { "540", OPTION_VAL_540_ES },
         { "550", OPTION_VAL_550_ES },
         { "560", OPTION_VAL_560_ES },
         { "570", OPTION_VAL_570_ES },
         { "580", OPTION_VAL_580_ES },
         { "590", OPTION_VAL_590_ES },
         { "600", OPTION_VAL_600_ES },
         { "610", OPTION_VAL_610_ES },
         { "620", OPTION_VAL_620_ES },
         { "630", OPTION_VAL_630_ES },
         { "640", OPTION_VAL_640_ES },
         { "650", OPTION_VAL_650_ES },
         { "660", OPTION_VAL_660_ES },
         { "670", OPTION_VAL_670_ES },
         { "680", OPTION_VAL_680_ES },
         { "690", OPTION_VAL_690_ES },
         { "700", OPTION_VAL_700_ES },
         { "710", OPTION_VAL_710_ES },
         { "720", OPTION_VAL_720_ES },
         { "730", OPTION_VAL_730_ES },
         { "740", OPTION_VAL_740_ES },
         { "750", OPTION_VAL_750_ES },
         { "760", OPTION_VAL_760_ES },
         { "770", OPTION_VAL_770_ES },
         { "780", OPTION_VAL_780_ES },
         { "790", OPTION_VAL_790_ES },
         { "800", OPTION_VAL_800_ES },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_ES,
      NULL,
      BSNES_SGB_BIOS_INFO_0_ES,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_ES   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_ES },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_ES,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_ES,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_ES,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_ES,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_ES,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_ES,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_es = {
   option_cats_es,
   option_defs_es
};

/* RETRO_LANGUAGE_FA */

#define CATEGORY_VIDEO_LABEL_FA "ویدیو"
#define CATEGORY_VIDEO_INFO_0_FA "تنظیمات خروجی ویدیو را تغییر دهید."
#define CATEGORY_AUDIO_LABEL_FA "صدا"
#define CATEGORY_AUDIO_INFO_0_FA "تنظیمات خروجی صدا را تغییر دهید."
#define CATEGORY_MODE7_LABEL_FA NULL
#define CATEGORY_MODE7_INFO_0_FA "تنظیمات مربوط به شبیه‌سازی گرافیکی حالت ۷ را تغییر دهید."
#define CATEGORY_HACK_LABEL_FA NULL
#define CATEGORY_HACK_INFO_0_FA NULL
#define CATEGORY_OVERCLOCK_LABEL_FA NULL
#define CATEGORY_OVERCLOCK_INFO_0_FA NULL
#define CATEGORY_SGB_LABEL_FA "سوپر گیم بوی"
#define CATEGORY_SGB_INFO_0_FA NULL
#define CATEGORY_LIGHTGUN_LABEL_FA NULL
#define CATEGORY_LIGHTGUN_INFO_0_FA NULL
#define BSNES_ASPECT_RATIO_LABEL_FA NULL
#define BSNES_ASPECT_RATIO_INFO_0_FA NULL
#define OPTION_VAL_AUTO_FA "خودکار"
#define OPTION_VAL_1_1_FA NULL
#define OPTION_VAL_4_3_FA NULL
#define OPTION_VAL_NTSC_FA NULL
#define OPTION_VAL_PAL_FA NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_FA NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_FA NULL
#define OPTION_VAL_0_FA NULL
#define OPTION_VAL_8_FA NULL
#define OPTION_VAL_12_FA NULL
#define OPTION_VAL_16_FA NULL
#define BSNES_BLUR_EMULATION_LABEL_FA NULL
#define BSNES_BLUR_EMULATION_INFO_0_FA NULL
#define BSNES_VIDEO_FILTER_LABEL_FA "فیلتر"
#define BSNES_VIDEO_FILTER_INFO_0_FA NULL
#define OPTION_VAL_NONE_FA "هیچکدام"
#define OPTION_VAL_NTSC_RF_FA NULL
#define OPTION_VAL_NTSC_COMPOSITE_FA NULL
#define OPTION_VAL_NTSC_S_VIDEO_FA NULL
#define OPTION_VAL_NTSC_RGB_FA NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_FA NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_FA NULL
#define OPTION_VAL_0_O4_FA NULL
#define OPTION_VAL_10_FA NULL
#define OPTION_VAL_20_FA NULL
#define OPTION_VAL_30_FA NULL
#define OPTION_VAL_40_FA NULL
#define OPTION_VAL_50_FA NULL
#define OPTION_VAL_60_FA NULL
#define OPTION_VAL_70_FA NULL
#define OPTION_VAL_80_FA NULL
#define OPTION_VAL_90_FA NULL
#define OPTION_VAL_100_FA NULL
#define BSNES_VIDEO_SATURATION_LABEL_FA NULL
#define BSNES_VIDEO_SATURATION_INFO_0_FA NULL
#define OPTION_VAL_110_FA NULL
#define OPTION_VAL_120_FA NULL
#define OPTION_VAL_130_FA NULL
#define OPTION_VAL_140_FA NULL
#define OPTION_VAL_150_FA NULL
#define OPTION_VAL_160_FA NULL
#define OPTION_VAL_170_FA NULL
#define OPTION_VAL_180_FA NULL
#define OPTION_VAL_190_FA NULL
#define OPTION_VAL_200_FA NULL
#define BSNES_VIDEO_GAMMA_LABEL_FA NULL
#define BSNES_VIDEO_GAMMA_INFO_0_FA NULL
#define OPTION_VAL_100_O6_FA NULL
#define OPTION_VAL_150_O6_FA NULL
#define BSNES_PPU_FAST_LABEL_FA NULL
#define BSNES_PPU_FAST_LABEL_CAT_FA NULL
#define BSNES_PPU_FAST_INFO_0_FA NULL
#define BSNES_PPU_DEINTERLACE_LABEL_FA NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_FA NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_FA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FA NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FA NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FA NULL
#define BSNES_DSP_FAST_LABEL_FA NULL
#define BSNES_DSP_FAST_LABEL_CAT_FA NULL
#define BSNES_DSP_FAST_INFO_0_FA NULL
#define BSNES_DSP_CUBIC_LABEL_FA NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_FA NULL
#define BSNES_DSP_CUBIC_INFO_0_FA NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_FA NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FA NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_FA NULL
#define BSNES_MODE7_SCALE_LABEL_FA NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_FA "مقیاس"
#define BSNES_MODE7_SCALE_INFO_0_FA NULL
#define OPTION_VAL_1X_FA NULL
#define OPTION_VAL_2X_FA NULL
#define OPTION_VAL_3X_FA NULL
#define OPTION_VAL_4X_FA NULL
#define OPTION_VAL_5X_FA NULL
#define OPTION_VAL_6X_FA NULL
#define OPTION_VAL_7X_FA NULL
#define OPTION_VAL_8X_FA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_FA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FA NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_FA NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_FA NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FA NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_FA NULL
#define BSNES_MODE7_MOSAIC_LABEL_FA NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_FA NULL
#define BSNES_MODE7_MOSAIC_INFO_0_FA NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_FA NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_FA NULL
#define OPTION_VAL_1_FA NULL
#define OPTION_VAL_2_FA NULL
#define OPTION_VAL_3_FA NULL
#define OPTION_VAL_4_FA NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FA NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FA NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_FA NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FA NULL
#define BSNES_HOTFIXES_LABEL_FA NULL
#define BSNES_HOTFIXES_INFO_0_FA NULL
#define BSNES_ENTROPY_LABEL_FA NULL
#define BSNES_ENTROPY_INFO_0_FA NULL
#define OPTION_VAL_LOW_FA NULL
#define OPTION_VAL_HIGH_FA NULL
#define BSNES_CPU_FASTMATH_LABEL_FA NULL
#define BSNES_CPU_FASTMATH_INFO_0_FA NULL
#define BSNES_CPU_OVERCLOCK_LABEL_FA NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_FA NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_FA NULL
#define OPTION_VAL_210_FA NULL
#define OPTION_VAL_220_FA NULL
#define OPTION_VAL_230_FA NULL
#define OPTION_VAL_240_FA NULL
#define OPTION_VAL_250_FA NULL
#define OPTION_VAL_260_FA NULL
#define OPTION_VAL_270_FA NULL
#define OPTION_VAL_280_FA NULL
#define OPTION_VAL_290_FA NULL
#define OPTION_VAL_300_FA NULL
#define OPTION_VAL_310_FA NULL
#define OPTION_VAL_320_FA NULL
#define OPTION_VAL_330_FA NULL
#define OPTION_VAL_340_FA NULL
#define OPTION_VAL_350_FA NULL
#define OPTION_VAL_360_FA NULL
#define OPTION_VAL_370_FA NULL
#define OPTION_VAL_380_FA NULL
#define OPTION_VAL_390_FA NULL
#define OPTION_VAL_400_FA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_FA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FA NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_FA NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_FA NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FA NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_FA NULL
#define OPTION_VAL_410_FA NULL
#define OPTION_VAL_420_FA NULL
#define OPTION_VAL_430_FA NULL
#define OPTION_VAL_440_FA NULL
#define OPTION_VAL_450_FA NULL
#define OPTION_VAL_460_FA NULL
#define OPTION_VAL_470_FA NULL
#define OPTION_VAL_480_FA NULL
#define OPTION_VAL_490_FA NULL
#define OPTION_VAL_500_FA NULL
#define OPTION_VAL_510_FA NULL
#define OPTION_VAL_520_FA NULL
#define OPTION_VAL_530_FA NULL
#define OPTION_VAL_540_FA NULL
#define OPTION_VAL_550_FA NULL
#define OPTION_VAL_560_FA NULL
#define OPTION_VAL_570_FA NULL
#define OPTION_VAL_580_FA NULL
#define OPTION_VAL_590_FA NULL
#define OPTION_VAL_600_FA NULL
#define OPTION_VAL_610_FA NULL
#define OPTION_VAL_620_FA NULL
#define OPTION_VAL_630_FA NULL
#define OPTION_VAL_640_FA NULL
#define OPTION_VAL_650_FA NULL
#define OPTION_VAL_660_FA NULL
#define OPTION_VAL_670_FA NULL
#define OPTION_VAL_680_FA NULL
#define OPTION_VAL_690_FA NULL
#define OPTION_VAL_700_FA NULL
#define OPTION_VAL_710_FA NULL
#define OPTION_VAL_720_FA NULL
#define OPTION_VAL_730_FA NULL
#define OPTION_VAL_740_FA NULL
#define OPTION_VAL_750_FA NULL
#define OPTION_VAL_760_FA NULL
#define OPTION_VAL_770_FA NULL
#define OPTION_VAL_780_FA NULL
#define OPTION_VAL_790_FA NULL
#define OPTION_VAL_800_FA NULL
#define BSNES_SGB_BIOS_LABEL_FA NULL
#define BSNES_SGB_BIOS_INFO_0_FA NULL
#define OPTION_VAL_SGB1_SFC_FA NULL
#define OPTION_VAL_SGB2_SFC_FA NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_FA NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_FA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FA NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FA NULL

struct retro_core_option_v2_category option_cats_fa[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_FA,
      CATEGORY_VIDEO_INFO_0_FA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FA,
      CATEGORY_AUDIO_INFO_0_FA
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_FA,
      CATEGORY_MODE7_INFO_0_FA
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_FA,
      CATEGORY_HACK_INFO_0_FA
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_FA,
      CATEGORY_OVERCLOCK_INFO_0_FA
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_FA,
      CATEGORY_SGB_INFO_0_FA
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_FA,
      CATEGORY_LIGHTGUN_INFO_0_FA
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fa[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_FA,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_FA,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_FA },
         { "1:1",  OPTION_VAL_1_1_FA },
         { "4:3",  OPTION_VAL_4_3_FA },
         { "NTSC", OPTION_VAL_NTSC_FA },
         { "PAL",  OPTION_VAL_PAL_FA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_FA,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_FA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_FA },
         { "8",  OPTION_VAL_8_FA },
         { "12", OPTION_VAL_12_FA },
         { "16", OPTION_VAL_16_FA },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_FA,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_FA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_FA,
      BSNES_VIDEO_FILTER_LABEL_FA,
      BSNES_VIDEO_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_FA },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_FA },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_FA },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_FA },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_FA },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_FA,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_FA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FA },
         { "10", OPTION_VAL_10_FA },
         { "20", OPTION_VAL_20_FA },
         { "30", OPTION_VAL_30_FA },
         { "40", OPTION_VAL_40_FA },
         { "50", OPTION_VAL_50_FA },
         { "60", OPTION_VAL_60_FA },
         { "70", OPTION_VAL_70_FA },
         { "80", OPTION_VAL_80_FA },
         { "90", OPTION_VAL_90_FA },
         { "100", OPTION_VAL_100_FA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_FA,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_FA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FA },
         { "10", OPTION_VAL_10_FA },
         { "20", OPTION_VAL_20_FA },
         { "30", OPTION_VAL_30_FA },
         { "40", OPTION_VAL_40_FA },
         { "50", OPTION_VAL_50_FA },
         { "60", OPTION_VAL_60_FA },
         { "70", OPTION_VAL_70_FA },
         { "80", OPTION_VAL_80_FA },
         { "90", OPTION_VAL_90_FA },
         { "100", OPTION_VAL_100_FA },
         { "110", OPTION_VAL_110_FA },
         { "120", OPTION_VAL_120_FA },
         { "130", OPTION_VAL_130_FA },
         { "140", OPTION_VAL_140_FA },
         { "150", OPTION_VAL_150_FA },
         { "160", OPTION_VAL_160_FA },
         { "170", OPTION_VAL_170_FA },
         { "180", OPTION_VAL_180_FA },
         { "190", OPTION_VAL_190_FA },
         { "200", OPTION_VAL_200_FA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_FA,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_FA,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_FA },
         { "110", OPTION_VAL_110_FA },
         { "120", OPTION_VAL_120_FA },
         { "130", OPTION_VAL_130_FA },
         { "140", OPTION_VAL_140_FA },
         { "150", OPTION_VAL_150_O6_FA },
         { "160", OPTION_VAL_160_FA },
         { "170", OPTION_VAL_170_FA },
         { "180", OPTION_VAL_180_FA },
         { "190", OPTION_VAL_190_FA },
         { "200", OPTION_VAL_200_FA },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_FA,
      BSNES_PPU_FAST_LABEL_CAT_FA,
      BSNES_PPU_FAST_INFO_0_FA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_FA,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_FA,
      BSNES_PPU_DEINTERLACE_INFO_0_FA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FA,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FA,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FA,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FA,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_FA,
      BSNES_DSP_FAST_LABEL_CAT_FA,
      BSNES_DSP_FAST_INFO_0_FA,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_FA,
      BSNES_DSP_CUBIC_LABEL_CAT_FA,
      BSNES_DSP_CUBIC_INFO_0_FA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_FA,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FA,
      BSNES_DSP_ECHO_SHADOW_INFO_0_FA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_FA,
      BSNES_MODE7_SCALE_LABEL_CAT_FA,
      BSNES_MODE7_SCALE_INFO_0_FA,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_FA  },
         { "2x", OPTION_VAL_2X_FA  },
         { "3x", OPTION_VAL_3X_FA  },
         { "4x", OPTION_VAL_4X_FA  },
         { "5x", OPTION_VAL_5X_FA },
         { "6x", OPTION_VAL_6X_FA },
         { "7x", OPTION_VAL_7X_FA },
         { "8x", OPTION_VAL_8X_FA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_FA,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FA,
      BSNES_MODE7_PERSPECTIVE_INFO_0_FA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_FA,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FA,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_FA,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_FA,
      BSNES_MODE7_MOSAIC_LABEL_CAT_FA,
      BSNES_MODE7_MOSAIC_INFO_0_FA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_FA,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_FA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_FA  },
         { "2",   OPTION_VAL_2_FA },
         { "3",   OPTION_VAL_3_FA },
         { "4",   OPTION_VAL_4_FA },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FA,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_FA,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_FA,
      NULL,
      BSNES_HOTFIXES_INFO_0_FA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_FA,
      NULL,
      BSNES_ENTROPY_INFO_0_FA,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_FA },
         { "High", OPTION_VAL_HIGH_FA },
         { "None", OPTION_VAL_NONE_FA },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_FA,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_FA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_FA,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_FA,
      BSNES_CPU_OVERCLOCK_INFO_0_FA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FA  },
         { "20",  OPTION_VAL_20_FA  },
         { "30",  OPTION_VAL_30_FA  },
         { "40",  OPTION_VAL_40_FA  },
         { "50",  OPTION_VAL_50_FA  },
         { "60",  OPTION_VAL_60_FA  },
         { "70",  OPTION_VAL_70_FA  },
         { "80",  OPTION_VAL_80_FA  },
         { "90",  OPTION_VAL_90_FA  },
         { "100", OPTION_VAL_100_FA },
         { "110", OPTION_VAL_110_FA },
         { "120", OPTION_VAL_120_FA },
         { "130", OPTION_VAL_130_FA },
         { "140", OPTION_VAL_140_FA },
         { "150", OPTION_VAL_150_FA },
         { "160", OPTION_VAL_160_FA },
         { "170", OPTION_VAL_170_FA },
         { "180", OPTION_VAL_180_FA },
         { "190", OPTION_VAL_190_FA },
         { "200", OPTION_VAL_200_FA },
         { "210", OPTION_VAL_210_FA },
         { "220", OPTION_VAL_220_FA },
         { "230", OPTION_VAL_230_FA },
         { "240", OPTION_VAL_240_FA },
         { "250", OPTION_VAL_250_FA },
         { "260", OPTION_VAL_260_FA },
         { "270", OPTION_VAL_270_FA },
         { "280", OPTION_VAL_280_FA },
         { "290", OPTION_VAL_290_FA },
         { "300", OPTION_VAL_300_FA },
         { "310", OPTION_VAL_310_FA },
         { "320", OPTION_VAL_320_FA },
         { "330", OPTION_VAL_330_FA },
         { "340", OPTION_VAL_340_FA },
         { "350", OPTION_VAL_350_FA },
         { "360", OPTION_VAL_360_FA },
         { "370", OPTION_VAL_370_FA },
         { "380", OPTION_VAL_380_FA },
         { "390", OPTION_VAL_390_FA },
         { "400", OPTION_VAL_400_FA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_FA,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FA,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_FA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FA  },
         { "20",  OPTION_VAL_20_FA  },
         { "30",  OPTION_VAL_30_FA  },
         { "40",  OPTION_VAL_40_FA  },
         { "50",  OPTION_VAL_50_FA  },
         { "60",  OPTION_VAL_60_FA  },
         { "70",  OPTION_VAL_70_FA  },
         { "80",  OPTION_VAL_80_FA  },
         { "90",  OPTION_VAL_90_FA  },
         { "100", OPTION_VAL_100_FA },
         { "110", OPTION_VAL_110_FA },
         { "120", OPTION_VAL_120_FA },
         { "130", OPTION_VAL_130_FA },
         { "140", OPTION_VAL_140_FA },
         { "150", OPTION_VAL_150_FA },
         { "160", OPTION_VAL_160_FA },
         { "170", OPTION_VAL_170_FA },
         { "180", OPTION_VAL_180_FA },
         { "190", OPTION_VAL_190_FA },
         { "200", OPTION_VAL_200_FA },
         { "210", OPTION_VAL_210_FA },
         { "220", OPTION_VAL_220_FA },
         { "230", OPTION_VAL_230_FA },
         { "240", OPTION_VAL_240_FA },
         { "250", OPTION_VAL_250_FA },
         { "260", OPTION_VAL_260_FA },
         { "270", OPTION_VAL_270_FA },
         { "280", OPTION_VAL_280_FA },
         { "290", OPTION_VAL_290_FA },
         { "300", OPTION_VAL_300_FA },
         { "310", OPTION_VAL_310_FA },
         { "320", OPTION_VAL_320_FA },
         { "330", OPTION_VAL_330_FA },
         { "340", OPTION_VAL_340_FA },
         { "350", OPTION_VAL_350_FA },
         { "360", OPTION_VAL_360_FA },
         { "370", OPTION_VAL_370_FA },
         { "380", OPTION_VAL_380_FA },
         { "390", OPTION_VAL_390_FA },
         { "400", OPTION_VAL_400_FA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_FA,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FA,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_FA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FA  },
         { "20",  OPTION_VAL_20_FA  },
         { "30",  OPTION_VAL_30_FA  },
         { "40",  OPTION_VAL_40_FA  },
         { "50",  OPTION_VAL_50_FA  },
         { "60",  OPTION_VAL_60_FA  },
         { "70",  OPTION_VAL_70_FA  },
         { "80",  OPTION_VAL_80_FA  },
         { "90",  OPTION_VAL_90_FA  },
         { "100", OPTION_VAL_100_FA },
         { "110", OPTION_VAL_110_FA },
         { "120", OPTION_VAL_120_FA },
         { "130", OPTION_VAL_130_FA },
         { "140", OPTION_VAL_140_FA },
         { "150", OPTION_VAL_150_FA },
         { "160", OPTION_VAL_160_FA },
         { "170", OPTION_VAL_170_FA },
         { "180", OPTION_VAL_180_FA },
         { "190", OPTION_VAL_190_FA },
         { "200", OPTION_VAL_200_FA },
         { "210", OPTION_VAL_210_FA },
         { "220", OPTION_VAL_220_FA },
         { "230", OPTION_VAL_230_FA },
         { "240", OPTION_VAL_240_FA },
         { "250", OPTION_VAL_250_FA },
         { "260", OPTION_VAL_260_FA },
         { "270", OPTION_VAL_270_FA },
         { "280", OPTION_VAL_280_FA },
         { "290", OPTION_VAL_290_FA },
         { "300", OPTION_VAL_300_FA },
         { "310", OPTION_VAL_310_FA },
         { "320", OPTION_VAL_320_FA },
         { "330", OPTION_VAL_330_FA },
         { "340", OPTION_VAL_340_FA },
         { "350", OPTION_VAL_350_FA },
         { "360", OPTION_VAL_360_FA },
         { "370", OPTION_VAL_370_FA },
         { "380", OPTION_VAL_380_FA },
         { "390", OPTION_VAL_390_FA },
         { "400", OPTION_VAL_400_FA },
         { "410", OPTION_VAL_410_FA },
         { "420", OPTION_VAL_420_FA },
         { "430", OPTION_VAL_430_FA },
         { "440", OPTION_VAL_440_FA },
         { "450", OPTION_VAL_450_FA },
         { "460", OPTION_VAL_460_FA },
         { "470", OPTION_VAL_470_FA },
         { "480", OPTION_VAL_480_FA },
         { "490", OPTION_VAL_490_FA },
         { "500", OPTION_VAL_500_FA },
         { "510", OPTION_VAL_510_FA },
         { "520", OPTION_VAL_520_FA },
         { "530", OPTION_VAL_530_FA },
         { "540", OPTION_VAL_540_FA },
         { "550", OPTION_VAL_550_FA },
         { "560", OPTION_VAL_560_FA },
         { "570", OPTION_VAL_570_FA },
         { "580", OPTION_VAL_580_FA },
         { "590", OPTION_VAL_590_FA },
         { "600", OPTION_VAL_600_FA },
         { "610", OPTION_VAL_610_FA },
         { "620", OPTION_VAL_620_FA },
         { "630", OPTION_VAL_630_FA },
         { "640", OPTION_VAL_640_FA },
         { "650", OPTION_VAL_650_FA },
         { "660", OPTION_VAL_660_FA },
         { "670", OPTION_VAL_670_FA },
         { "680", OPTION_VAL_680_FA },
         { "690", OPTION_VAL_690_FA },
         { "700", OPTION_VAL_700_FA },
         { "710", OPTION_VAL_710_FA },
         { "720", OPTION_VAL_720_FA },
         { "730", OPTION_VAL_730_FA },
         { "740", OPTION_VAL_740_FA },
         { "750", OPTION_VAL_750_FA },
         { "760", OPTION_VAL_760_FA },
         { "770", OPTION_VAL_770_FA },
         { "780", OPTION_VAL_780_FA },
         { "790", OPTION_VAL_790_FA },
         { "800", OPTION_VAL_800_FA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_FA,
      NULL,
      BSNES_SGB_BIOS_INFO_0_FA,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_FA   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_FA },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_FA,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_FA,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FA,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FA,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fa = {
   option_cats_fa,
   option_defs_fa
};

/* RETRO_LANGUAGE_FI */

#define CATEGORY_VIDEO_LABEL_FI NULL
#define CATEGORY_VIDEO_INFO_0_FI "Muuta videon ulostuloasetuksia."
#define CATEGORY_AUDIO_LABEL_FI "Ääni"
#define CATEGORY_AUDIO_INFO_0_FI "Muuta äänen ulostuloasetuksia."
#define CATEGORY_MODE7_LABEL_FI NULL
#define CATEGORY_MODE7_INFO_0_FI "Muuta Mode 7 -grafiikan emulointia koskevia asetuksia."
#define CATEGORY_HACK_LABEL_FI "Emulointikikat ja -parannukset"
#define CATEGORY_HACK_INFO_0_FI "Ota käyttöön emulointikikkoja, -parannuksia ja -korjauksia."
#define CATEGORY_OVERCLOCK_LABEL_FI "Yli-/Alikellotus"
#define CATEGORY_OVERCLOCK_INFO_0_FI "Muuta emuloidun laitteiston nopeutta."
#define CATEGORY_SGB_LABEL_FI NULL
#define CATEGORY_SGB_INFO_0_FI "Muuta Super Game Boy -emulointia koskevia asetuksia."
#define CATEGORY_LIGHTGUN_LABEL_FI "Valoase"
#define CATEGORY_LIGHTGUN_INFO_0_FI NULL
#define BSNES_ASPECT_RATIO_LABEL_FI "Ensisijainen kuvasuhde"
#define BSNES_ASPECT_RATIO_INFO_0_FI NULL
#define OPTION_VAL_AUTO_FI "Automaattinen"
#define OPTION_VAL_1_1_FI NULL
#define OPTION_VAL_4_3_FI NULL
#define OPTION_VAL_NTSC_FI NULL
#define OPTION_VAL_PAL_FI NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_FI NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_FI NULL
#define OPTION_VAL_0_FI NULL
#define OPTION_VAL_8_FI NULL
#define OPTION_VAL_12_FI NULL
#define OPTION_VAL_16_FI NULL
#define BSNES_BLUR_EMULATION_LABEL_FI NULL
#define BSNES_BLUR_EMULATION_INFO_0_FI NULL
#define BSNES_VIDEO_FILTER_LABEL_FI "Suodatin"
#define BSNES_VIDEO_FILTER_INFO_0_FI "Valitse ilman suodatusta tai blarggin NTSC-suodatin, jossa on RF-, komposiitti-, S-Video- tai RGB-vaihtoehdot."
#define OPTION_VAL_NONE_FI "Ei mitään"
#define OPTION_VAL_NTSC_RF_FI NULL
#define OPTION_VAL_NTSC_COMPOSITE_FI "NTSC (komposiitti)"
#define OPTION_VAL_NTSC_S_VIDEO_FI NULL
#define OPTION_VAL_NTSC_RGB_FI NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_FI NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_FI NULL
#define OPTION_VAL_0_O4_FI "0 %"
#define OPTION_VAL_10_FI "10 %"
#define OPTION_VAL_20_FI "20 %"
#define OPTION_VAL_30_FI "30 %"
#define OPTION_VAL_40_FI "40 %"
#define OPTION_VAL_50_FI "50 %"
#define OPTION_VAL_60_FI "60 %"
#define OPTION_VAL_70_FI "70 %"
#define OPTION_VAL_80_FI "80 %"
#define OPTION_VAL_90_FI "90 %"
#define OPTION_VAL_100_FI "100 % (Oletus)"
#define BSNES_VIDEO_SATURATION_LABEL_FI NULL
#define BSNES_VIDEO_SATURATION_INFO_0_FI NULL
#define OPTION_VAL_110_FI "110 %"
#define OPTION_VAL_120_FI "120 %"
#define OPTION_VAL_130_FI "130 %"
#define OPTION_VAL_140_FI "140 %"
#define OPTION_VAL_150_FI "150 %"
#define OPTION_VAL_160_FI "160 %"
#define OPTION_VAL_170_FI "170 %"
#define OPTION_VAL_180_FI "180 %"
#define OPTION_VAL_190_FI "190 %"
#define OPTION_VAL_200_FI "200 %"
#define BSNES_VIDEO_GAMMA_LABEL_FI NULL
#define BSNES_VIDEO_GAMMA_INFO_0_FI NULL
#define OPTION_VAL_100_O6_FI "100 %"
#define OPTION_VAL_150_O6_FI "150 % (Oletus)"
#define BSNES_PPU_FAST_LABEL_FI "PPU (video) - nopea tila"
#define BSNES_PPU_FAST_LABEL_CAT_FI "PPU - nopea tila"
#define BSNES_PPU_FAST_INFO_0_FI NULL
#define BSNES_PPU_DEINTERLACE_LABEL_FI NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_FI NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_FI NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FI NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FI "PPU - Ei sprite rajoitusta"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FI NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FI NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FI NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FI NULL
#define BSNES_DSP_FAST_LABEL_FI NULL
#define BSNES_DSP_FAST_LABEL_CAT_FI NULL
#define BSNES_DSP_FAST_INFO_0_FI NULL
#define BSNES_DSP_CUBIC_LABEL_FI NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_FI NULL
#define BSNES_DSP_CUBIC_INFO_0_FI NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_FI NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FI NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_FI NULL
#define BSNES_MODE7_SCALE_LABEL_FI NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_FI "Skaala"
#define BSNES_MODE7_SCALE_INFO_0_FI NULL
#define OPTION_VAL_1X_FI NULL
#define OPTION_VAL_2X_FI NULL
#define OPTION_VAL_3X_FI NULL
#define OPTION_VAL_4X_FI NULL
#define OPTION_VAL_5X_FI NULL
#define OPTION_VAL_6X_FI NULL
#define OPTION_VAL_7X_FI NULL
#define OPTION_VAL_8X_FI NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_FI NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FI NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_FI NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_FI NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FI NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_FI NULL
#define BSNES_MODE7_MOSAIC_LABEL_FI NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_FI NULL
#define BSNES_MODE7_MOSAIC_INFO_0_FI NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_FI NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_FI NULL
#define OPTION_VAL_1_FI NULL
#define OPTION_VAL_2_FI NULL
#define OPTION_VAL_3_FI NULL
#define OPTION_VAL_4_FI NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FI NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FI NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_FI NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FI NULL
#define BSNES_HOTFIXES_LABEL_FI NULL
#define BSNES_HOTFIXES_INFO_0_FI NULL
#define BSNES_ENTROPY_LABEL_FI "Entropia (satunnaistaminen)"
#define BSNES_ENTROPY_INFO_0_FI NULL
#define OPTION_VAL_LOW_FI "Matala"
#define OPTION_VAL_HIGH_FI "Korkea"
#define BSNES_CPU_FASTMATH_LABEL_FI NULL
#define BSNES_CPU_FASTMATH_INFO_0_FI NULL
#define BSNES_CPU_OVERCLOCK_LABEL_FI NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_FI NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_FI NULL
#define OPTION_VAL_210_FI "210 %"
#define OPTION_VAL_220_FI "220 %"
#define OPTION_VAL_230_FI "230 %"
#define OPTION_VAL_240_FI "240 %"
#define OPTION_VAL_250_FI "250 %"
#define OPTION_VAL_260_FI "260 %"
#define OPTION_VAL_270_FI "270 %"
#define OPTION_VAL_280_FI "280 %"
#define OPTION_VAL_290_FI "290 %"
#define OPTION_VAL_300_FI "300 %"
#define OPTION_VAL_310_FI "310 %"
#define OPTION_VAL_320_FI "320 %"
#define OPTION_VAL_330_FI "330 %"
#define OPTION_VAL_340_FI "340 %"
#define OPTION_VAL_350_FI "350 %"
#define OPTION_VAL_360_FI "360 %"
#define OPTION_VAL_370_FI "370 %"
#define OPTION_VAL_380_FI "380 %"
#define OPTION_VAL_390_FI "390 %"
#define OPTION_VAL_400_FI "400 %"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_FI NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FI "SA-1-apusuoritin"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_FI NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_FI NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FI "SuperFX-apusuoritin"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_FI NULL
#define OPTION_VAL_410_FI "410 %"
#define OPTION_VAL_420_FI "420 %"
#define OPTION_VAL_430_FI "430 %"
#define OPTION_VAL_440_FI "440 %"
#define OPTION_VAL_450_FI "450 %"
#define OPTION_VAL_460_FI "460 %"
#define OPTION_VAL_470_FI "470 %"
#define OPTION_VAL_480_FI "480 %"
#define OPTION_VAL_490_FI "490 %"
#define OPTION_VAL_500_FI "500 %"
#define OPTION_VAL_510_FI "510 %"
#define OPTION_VAL_520_FI "520 %"
#define OPTION_VAL_530_FI "530 %"
#define OPTION_VAL_540_FI "540 %"
#define OPTION_VAL_550_FI "550 %"
#define OPTION_VAL_560_FI "560 %"
#define OPTION_VAL_570_FI "570 %"
#define OPTION_VAL_580_FI "580 %"
#define OPTION_VAL_590_FI "590 %"
#define OPTION_VAL_600_FI "600 %"
#define OPTION_VAL_610_FI "610 %"
#define OPTION_VAL_620_FI "620 %"
#define OPTION_VAL_630_FI "630 %"
#define OPTION_VAL_640_FI "640 %"
#define OPTION_VAL_650_FI "650 %"
#define OPTION_VAL_660_FI "660 %"
#define OPTION_VAL_670_FI "670 %"
#define OPTION_VAL_680_FI "680 %"
#define OPTION_VAL_690_FI "690 %"
#define OPTION_VAL_700_FI "700 %"
#define OPTION_VAL_710_FI "710 %"
#define OPTION_VAL_720_FI "720 %"
#define OPTION_VAL_730_FI "730 %"
#define OPTION_VAL_740_FI "740 %"
#define OPTION_VAL_750_FI "750 %"
#define OPTION_VAL_760_FI "760 %"
#define OPTION_VAL_770_FI "770 %"
#define OPTION_VAL_780_FI "780 %"
#define OPTION_VAL_790_FI "790 %"
#define OPTION_VAL_800_FI "800 %"
#define BSNES_SGB_BIOS_LABEL_FI NULL
#define BSNES_SGB_BIOS_INFO_0_FI NULL
#define OPTION_VAL_SGB1_SFC_FI NULL
#define OPTION_VAL_SGB2_SFC_FI NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_FI NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_FI NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FI "Valoaseet kosketusnäytöllä"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FI "Ota käyttöön Super Scope syöte kosketusnäyttöllä."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FI "Käänteiset Super Scrope liipaisin painikkeet"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FI "Käännä Super Scope liipasin- ja kohdistinpainikkeet kosketusnäytön valoaseelle."

struct retro_core_option_v2_category option_cats_fi[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_FI,
      CATEGORY_VIDEO_INFO_0_FI
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FI,
      CATEGORY_AUDIO_INFO_0_FI
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_FI,
      CATEGORY_MODE7_INFO_0_FI
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_FI,
      CATEGORY_HACK_INFO_0_FI
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_FI,
      CATEGORY_OVERCLOCK_INFO_0_FI
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_FI,
      CATEGORY_SGB_INFO_0_FI
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_FI,
      CATEGORY_LIGHTGUN_INFO_0_FI
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fi[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_FI,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_FI,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_FI },
         { "1:1",  OPTION_VAL_1_1_FI },
         { "4:3",  OPTION_VAL_4_3_FI },
         { "NTSC", OPTION_VAL_NTSC_FI },
         { "PAL",  OPTION_VAL_PAL_FI },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_FI,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_FI,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_FI },
         { "8",  OPTION_VAL_8_FI },
         { "12", OPTION_VAL_12_FI },
         { "16", OPTION_VAL_16_FI },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_FI,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_FI,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_FI,
      BSNES_VIDEO_FILTER_LABEL_FI,
      BSNES_VIDEO_FILTER_INFO_0_FI,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_FI },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_FI },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_FI },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_FI },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_FI },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_FI,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_FI,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FI },
         { "10", OPTION_VAL_10_FI },
         { "20", OPTION_VAL_20_FI },
         { "30", OPTION_VAL_30_FI },
         { "40", OPTION_VAL_40_FI },
         { "50", OPTION_VAL_50_FI },
         { "60", OPTION_VAL_60_FI },
         { "70", OPTION_VAL_70_FI },
         { "80", OPTION_VAL_80_FI },
         { "90", OPTION_VAL_90_FI },
         { "100", OPTION_VAL_100_FI },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_FI,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_FI,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FI },
         { "10", OPTION_VAL_10_FI },
         { "20", OPTION_VAL_20_FI },
         { "30", OPTION_VAL_30_FI },
         { "40", OPTION_VAL_40_FI },
         { "50", OPTION_VAL_50_FI },
         { "60", OPTION_VAL_60_FI },
         { "70", OPTION_VAL_70_FI },
         { "80", OPTION_VAL_80_FI },
         { "90", OPTION_VAL_90_FI },
         { "100", OPTION_VAL_100_FI },
         { "110", OPTION_VAL_110_FI },
         { "120", OPTION_VAL_120_FI },
         { "130", OPTION_VAL_130_FI },
         { "140", OPTION_VAL_140_FI },
         { "150", OPTION_VAL_150_FI },
         { "160", OPTION_VAL_160_FI },
         { "170", OPTION_VAL_170_FI },
         { "180", OPTION_VAL_180_FI },
         { "190", OPTION_VAL_190_FI },
         { "200", OPTION_VAL_200_FI },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_FI,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_FI,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_FI },
         { "110", OPTION_VAL_110_FI },
         { "120", OPTION_VAL_120_FI },
         { "130", OPTION_VAL_130_FI },
         { "140", OPTION_VAL_140_FI },
         { "150", OPTION_VAL_150_O6_FI },
         { "160", OPTION_VAL_160_FI },
         { "170", OPTION_VAL_170_FI },
         { "180", OPTION_VAL_180_FI },
         { "190", OPTION_VAL_190_FI },
         { "200", OPTION_VAL_200_FI },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_FI,
      BSNES_PPU_FAST_LABEL_CAT_FI,
      BSNES_PPU_FAST_INFO_0_FI,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_FI,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_FI,
      BSNES_PPU_DEINTERLACE_INFO_0_FI,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FI,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FI,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FI,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FI,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FI,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FI,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_FI,
      BSNES_DSP_FAST_LABEL_CAT_FI,
      BSNES_DSP_FAST_INFO_0_FI,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_FI,
      BSNES_DSP_CUBIC_LABEL_CAT_FI,
      BSNES_DSP_CUBIC_INFO_0_FI,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_FI,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FI,
      BSNES_DSP_ECHO_SHADOW_INFO_0_FI,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_FI,
      BSNES_MODE7_SCALE_LABEL_CAT_FI,
      BSNES_MODE7_SCALE_INFO_0_FI,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_FI  },
         { "2x", OPTION_VAL_2X_FI  },
         { "3x", OPTION_VAL_3X_FI  },
         { "4x", OPTION_VAL_4X_FI  },
         { "5x", OPTION_VAL_5X_FI },
         { "6x", OPTION_VAL_6X_FI },
         { "7x", OPTION_VAL_7X_FI },
         { "8x", OPTION_VAL_8X_FI },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_FI,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FI,
      BSNES_MODE7_PERSPECTIVE_INFO_0_FI,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_FI,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FI,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_FI,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_FI,
      BSNES_MODE7_MOSAIC_LABEL_CAT_FI,
      BSNES_MODE7_MOSAIC_INFO_0_FI,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_FI,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_FI,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_FI  },
         { "2",   OPTION_VAL_2_FI },
         { "3",   OPTION_VAL_3_FI },
         { "4",   OPTION_VAL_4_FI },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FI,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FI,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_FI,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FI,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_FI,
      NULL,
      BSNES_HOTFIXES_INFO_0_FI,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_FI,
      NULL,
      BSNES_ENTROPY_INFO_0_FI,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_FI },
         { "High", OPTION_VAL_HIGH_FI },
         { "None", OPTION_VAL_NONE_FI },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_FI,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_FI,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_FI,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_FI,
      BSNES_CPU_OVERCLOCK_INFO_0_FI,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FI  },
         { "20",  OPTION_VAL_20_FI  },
         { "30",  OPTION_VAL_30_FI  },
         { "40",  OPTION_VAL_40_FI  },
         { "50",  OPTION_VAL_50_FI  },
         { "60",  OPTION_VAL_60_FI  },
         { "70",  OPTION_VAL_70_FI  },
         { "80",  OPTION_VAL_80_FI  },
         { "90",  OPTION_VAL_90_FI  },
         { "100", OPTION_VAL_100_FI },
         { "110", OPTION_VAL_110_FI },
         { "120", OPTION_VAL_120_FI },
         { "130", OPTION_VAL_130_FI },
         { "140", OPTION_VAL_140_FI },
         { "150", OPTION_VAL_150_FI },
         { "160", OPTION_VAL_160_FI },
         { "170", OPTION_VAL_170_FI },
         { "180", OPTION_VAL_180_FI },
         { "190", OPTION_VAL_190_FI },
         { "200", OPTION_VAL_200_FI },
         { "210", OPTION_VAL_210_FI },
         { "220", OPTION_VAL_220_FI },
         { "230", OPTION_VAL_230_FI },
         { "240", OPTION_VAL_240_FI },
         { "250", OPTION_VAL_250_FI },
         { "260", OPTION_VAL_260_FI },
         { "270", OPTION_VAL_270_FI },
         { "280", OPTION_VAL_280_FI },
         { "290", OPTION_VAL_290_FI },
         { "300", OPTION_VAL_300_FI },
         { "310", OPTION_VAL_310_FI },
         { "320", OPTION_VAL_320_FI },
         { "330", OPTION_VAL_330_FI },
         { "340", OPTION_VAL_340_FI },
         { "350", OPTION_VAL_350_FI },
         { "360", OPTION_VAL_360_FI },
         { "370", OPTION_VAL_370_FI },
         { "380", OPTION_VAL_380_FI },
         { "390", OPTION_VAL_390_FI },
         { "400", OPTION_VAL_400_FI },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_FI,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FI,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_FI,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FI  },
         { "20",  OPTION_VAL_20_FI  },
         { "30",  OPTION_VAL_30_FI  },
         { "40",  OPTION_VAL_40_FI  },
         { "50",  OPTION_VAL_50_FI  },
         { "60",  OPTION_VAL_60_FI  },
         { "70",  OPTION_VAL_70_FI  },
         { "80",  OPTION_VAL_80_FI  },
         { "90",  OPTION_VAL_90_FI  },
         { "100", OPTION_VAL_100_FI },
         { "110", OPTION_VAL_110_FI },
         { "120", OPTION_VAL_120_FI },
         { "130", OPTION_VAL_130_FI },
         { "140", OPTION_VAL_140_FI },
         { "150", OPTION_VAL_150_FI },
         { "160", OPTION_VAL_160_FI },
         { "170", OPTION_VAL_170_FI },
         { "180", OPTION_VAL_180_FI },
         { "190", OPTION_VAL_190_FI },
         { "200", OPTION_VAL_200_FI },
         { "210", OPTION_VAL_210_FI },
         { "220", OPTION_VAL_220_FI },
         { "230", OPTION_VAL_230_FI },
         { "240", OPTION_VAL_240_FI },
         { "250", OPTION_VAL_250_FI },
         { "260", OPTION_VAL_260_FI },
         { "270", OPTION_VAL_270_FI },
         { "280", OPTION_VAL_280_FI },
         { "290", OPTION_VAL_290_FI },
         { "300", OPTION_VAL_300_FI },
         { "310", OPTION_VAL_310_FI },
         { "320", OPTION_VAL_320_FI },
         { "330", OPTION_VAL_330_FI },
         { "340", OPTION_VAL_340_FI },
         { "350", OPTION_VAL_350_FI },
         { "360", OPTION_VAL_360_FI },
         { "370", OPTION_VAL_370_FI },
         { "380", OPTION_VAL_380_FI },
         { "390", OPTION_VAL_390_FI },
         { "400", OPTION_VAL_400_FI },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_FI,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FI,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_FI,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FI  },
         { "20",  OPTION_VAL_20_FI  },
         { "30",  OPTION_VAL_30_FI  },
         { "40",  OPTION_VAL_40_FI  },
         { "50",  OPTION_VAL_50_FI  },
         { "60",  OPTION_VAL_60_FI  },
         { "70",  OPTION_VAL_70_FI  },
         { "80",  OPTION_VAL_80_FI  },
         { "90",  OPTION_VAL_90_FI  },
         { "100", OPTION_VAL_100_FI },
         { "110", OPTION_VAL_110_FI },
         { "120", OPTION_VAL_120_FI },
         { "130", OPTION_VAL_130_FI },
         { "140", OPTION_VAL_140_FI },
         { "150", OPTION_VAL_150_FI },
         { "160", OPTION_VAL_160_FI },
         { "170", OPTION_VAL_170_FI },
         { "180", OPTION_VAL_180_FI },
         { "190", OPTION_VAL_190_FI },
         { "200", OPTION_VAL_200_FI },
         { "210", OPTION_VAL_210_FI },
         { "220", OPTION_VAL_220_FI },
         { "230", OPTION_VAL_230_FI },
         { "240", OPTION_VAL_240_FI },
         { "250", OPTION_VAL_250_FI },
         { "260", OPTION_VAL_260_FI },
         { "270", OPTION_VAL_270_FI },
         { "280", OPTION_VAL_280_FI },
         { "290", OPTION_VAL_290_FI },
         { "300", OPTION_VAL_300_FI },
         { "310", OPTION_VAL_310_FI },
         { "320", OPTION_VAL_320_FI },
         { "330", OPTION_VAL_330_FI },
         { "340", OPTION_VAL_340_FI },
         { "350", OPTION_VAL_350_FI },
         { "360", OPTION_VAL_360_FI },
         { "370", OPTION_VAL_370_FI },
         { "380", OPTION_VAL_380_FI },
         { "390", OPTION_VAL_390_FI },
         { "400", OPTION_VAL_400_FI },
         { "410", OPTION_VAL_410_FI },
         { "420", OPTION_VAL_420_FI },
         { "430", OPTION_VAL_430_FI },
         { "440", OPTION_VAL_440_FI },
         { "450", OPTION_VAL_450_FI },
         { "460", OPTION_VAL_460_FI },
         { "470", OPTION_VAL_470_FI },
         { "480", OPTION_VAL_480_FI },
         { "490", OPTION_VAL_490_FI },
         { "500", OPTION_VAL_500_FI },
         { "510", OPTION_VAL_510_FI },
         { "520", OPTION_VAL_520_FI },
         { "530", OPTION_VAL_530_FI },
         { "540", OPTION_VAL_540_FI },
         { "550", OPTION_VAL_550_FI },
         { "560", OPTION_VAL_560_FI },
         { "570", OPTION_VAL_570_FI },
         { "580", OPTION_VAL_580_FI },
         { "590", OPTION_VAL_590_FI },
         { "600", OPTION_VAL_600_FI },
         { "610", OPTION_VAL_610_FI },
         { "620", OPTION_VAL_620_FI },
         { "630", OPTION_VAL_630_FI },
         { "640", OPTION_VAL_640_FI },
         { "650", OPTION_VAL_650_FI },
         { "660", OPTION_VAL_660_FI },
         { "670", OPTION_VAL_670_FI },
         { "680", OPTION_VAL_680_FI },
         { "690", OPTION_VAL_690_FI },
         { "700", OPTION_VAL_700_FI },
         { "710", OPTION_VAL_710_FI },
         { "720", OPTION_VAL_720_FI },
         { "730", OPTION_VAL_730_FI },
         { "740", OPTION_VAL_740_FI },
         { "750", OPTION_VAL_750_FI },
         { "760", OPTION_VAL_760_FI },
         { "770", OPTION_VAL_770_FI },
         { "780", OPTION_VAL_780_FI },
         { "790", OPTION_VAL_790_FI },
         { "800", OPTION_VAL_800_FI },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_FI,
      NULL,
      BSNES_SGB_BIOS_INFO_0_FI,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_FI   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_FI },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_FI,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_FI,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FI,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FI,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FI,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FI,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fi = {
   option_cats_fi,
   option_defs_fi
};

/* RETRO_LANGUAGE_FR */

#define CATEGORY_VIDEO_LABEL_FR "Vidéo"
#define CATEGORY_VIDEO_INFO_0_FR "Modifier les réglages de sortie vidéo."
#define CATEGORY_AUDIO_LABEL_FR NULL
#define CATEGORY_AUDIO_INFO_0_FR "Modifier les réglages de sortie audio."
#define CATEGORY_MODE7_LABEL_FR "Mode 7 HD"
#define CATEGORY_MODE7_INFO_0_FR "Modifier les réglages concernant l'émulation graphique du Mode 7."
#define CATEGORY_HACK_LABEL_FR "Hacks d'émulation et améliorations"
#define CATEGORY_HACK_INFO_0_FR "Appliquer des hacks, améliorations et correctifs d'émulation."
#define CATEGORY_OVERCLOCK_LABEL_FR "Over/underclocking"
#define CATEGORY_OVERCLOCK_INFO_0_FR "Modifier la vitesse du matériel émulé."
#define CATEGORY_SGB_LABEL_FR NULL
#define CATEGORY_SGB_INFO_0_FR "Modifier les réglages de l'émulation du Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_FR "Pistolet"
#define CATEGORY_LIGHTGUN_INFO_0_FR "Modifier les réglages du pistolet (écran tactile)."
#define BSNES_ASPECT_RATIO_LABEL_FR "Rapport d'aspect préféré"
#define BSNES_ASPECT_RATIO_INFO_0_FR "Choisir le rapport d'aspect préféré pour le contenu. Cela ne s'applique que lorsque le rapport d'aspect de RetroArch est réglé sur 'Fourni par le cœur' (Core provided) dans les paramètres vidéo."
#define OPTION_VAL_AUTO_FR NULL
#define OPTION_VAL_1_1_FR "PAR 1:1 (Pixels entiers)"
#define OPTION_VAL_4_3_FR "4:3 DAR (Rapport d'aspect écran)"
#define OPTION_VAL_NTSC_FR NULL
#define OPTION_VAL_PAL_FR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_FR "Recadrer le surbalayage vertical"
#define BSNES_PPU_OVERSCAN_V_INFO_0_FR "Supprimer N lignes du haut et du bas de l'écran pour simuler le biseau d'une télévision de l'ère SNES."
#define OPTION_VAL_0_FR "0 lignes"
#define OPTION_VAL_8_FR "8 lignes"
#define OPTION_VAL_12_FR "12 lignes"
#define OPTION_VAL_16_FR "16 lignes"
#define BSNES_BLUR_EMULATION_LABEL_FR "Émulation du flou"
#define BSNES_BLUR_EMULATION_INFO_0_FR "Simuler la résolution horizontale limitée des télévisions définition SD en floutant les pixels horizontalement adjacents. Certains jeux dépendent de cela pour émuler un effet de transparence."
#define BSNES_VIDEO_FILTER_LABEL_FR "Filtre"
#define BSNES_VIDEO_FILTER_INFO_0_FR "Choisissez entre aucun filtre et le filtre NTSC de blargg avec des options RF, Composite, S-Vidéo ou RVB"
#define OPTION_VAL_NONE_FR "Aucune"
#define OPTION_VAL_NTSC_RF_FR NULL
#define OPTION_VAL_NTSC_COMPOSITE_FR NULL
#define OPTION_VAL_NTSC_S_VIDEO_FR "NTSC (S-Vidéo)"
#define OPTION_VAL_NTSC_RGB_FR "NTSC (RVB)"
#define BSNES_VIDEO_LUMINANCE_LABEL_FR "Ajustement couleur - Luminance"
#define BSNES_VIDEO_LUMINANCE_INFO_0_FR "Ajuste la luminance"
#define OPTION_VAL_0_O4_FR "0 %"
#define OPTION_VAL_10_FR NULL
#define OPTION_VAL_20_FR NULL
#define OPTION_VAL_30_FR NULL
#define OPTION_VAL_40_FR NULL
#define OPTION_VAL_50_FR NULL
#define OPTION_VAL_60_FR NULL
#define OPTION_VAL_70_FR NULL
#define OPTION_VAL_80_FR NULL
#define OPTION_VAL_90_FR NULL
#define OPTION_VAL_100_FR "100% (par défaut)"
#define BSNES_VIDEO_SATURATION_LABEL_FR "Ajustement couleur - Saturation"
#define BSNES_VIDEO_SATURATION_INFO_0_FR "Ajuste la saturation"
#define OPTION_VAL_110_FR NULL
#define OPTION_VAL_120_FR NULL
#define OPTION_VAL_130_FR NULL
#define OPTION_VAL_140_FR NULL
#define OPTION_VAL_150_FR NULL
#define OPTION_VAL_160_FR NULL
#define OPTION_VAL_170_FR NULL
#define OPTION_VAL_180_FR NULL
#define OPTION_VAL_190_FR NULL
#define OPTION_VAL_200_FR NULL
#define BSNES_VIDEO_GAMMA_LABEL_FR "Ajustement couleur - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_FR "Ajuste le gamma"
#define OPTION_VAL_100_O6_FR "100 %"
#define OPTION_VAL_150_O6_FR "150 % (par défaut)"
#define BSNES_PPU_FAST_LABEL_FR "PPU (vidéo) - mode rapide"
#define BSNES_PPU_FAST_LABEL_CAT_FR "PPU - mode rapide"
#define BSNES_PPU_FAST_INFO_0_FR "Activer l'émulation plus rapide du PPU au prix d'une réduction mineure de la précision. Il est recommandé de laisser cette option activée. REMARQUE : ceci doit être activé pour que les options 'Désentrelacer', 'Aucune limite de sprites' et 'Mode 7 HD' puissent fonctionner."
#define BSNES_PPU_DEINTERLACE_LABEL_FR "PPU (vidéo) - désentrelacer"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_FR "PPU - désentrelacer"
#define BSNES_PPU_DEINTERLACE_INFO_0_FR "Désentrelacer tous les jeux en rendant à 480p en interne. La pénalité de performance est presque inexistante, il est donc recommandé de laisser cette option activée."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FR "PPU (vidéo) - aucune limite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FR "PPU - aucune limite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FR "Supprime toute limite au nombre de sprites qui peuvent être affichés simultanément à l'écran. Peut causer des problèmes avec certains jeux."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FR "PPU (vidéo) - pas de blocage VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FR "PPU - pas de blocage VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FR "Émuler un bug dans les anciennes versions de ZSNES et Snes9x, où le blocage de la VRAM n'était pas émulé. Quelques hacks de ROM plus anciens s'appuyaient sur ce comportement et rendront les graphiques incorrectement si cette option n'est pas activée. Cette option est extrêmement peu précise et nuit à la vitesse du PPU, il est donc recommandé de la laisser désactivée à moins que vous n'ayez besoin de jouer à un jeu qui est par ailleurs incompatible avec ce cœur."
#define BSNES_DSP_FAST_LABEL_FR "DSP (audio) - mode rapide"
#define BSNES_DSP_FAST_LABEL_CAT_FR "DSP - mode rapide"
#define BSNES_DSP_FAST_INFO_0_FR "Activer l'émulation plus rapide du DSP au prix d'une réduction mineure de la précision. Il est recommandé de laisser cette option activée."
#define BSNES_DSP_CUBIC_LABEL_FR "DSP (audio) - interpolation cubique"
#define BSNES_DSP_CUBIC_LABEL_CAT_FR "DSP - interpolation cubique"
#define BSNES_DSP_CUBIC_INFO_0_FR "Appliquer une interpolation cubique sur le son, en conservant une plus grande partie de la gamme des hautes fréquences."
#define BSNES_DSP_ECHO_SHADOW_LABEL_FR "DSP (audio) - RAM de l'Echo séparée"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FR "DSP - RAM de l'Echo séparée"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_FR "Émuler un bug dans ZSNES où la RAM de l'Echo était traitée comme séparée de la RAM de l'APU. Beaucoup de hacks de ROM pour Super Mario World plus anciens s'appuyaient sur ce comportement et planteront sans cela. Cette option est extrêmement peu précise et ne devrait pas être activée sauf si nécessaire."
#define BSNES_MODE7_SCALE_LABEL_FR "Mode 7 HD - échelle"
#define BSNES_MODE7_SCALE_LABEL_CAT_FR "Échelle"
#define BSNES_MODE7_SCALE_INFO_0_FR "Augmenter la résolution horizontale et verticale des graphiques en Mode 7 utilisés dans certains jeux."
#define OPTION_VAL_1X_FR "240p (x1)"
#define OPTION_VAL_2X_FR "480p (x2)"
#define OPTION_VAL_3X_FR "720p (x3)"
#define OPTION_VAL_4X_FR "960p (x4)"
#define OPTION_VAL_5X_FR "1200p (x5)"
#define OPTION_VAL_6X_FR "1440p (x6)"
#define OPTION_VAL_7X_FR "1680p (x7)"
#define OPTION_VAL_8X_FR "1920p (x8)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_FR "Mode 7 HD - correction de la perspective"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FR "Correction de la perspective"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_FR "Corriger la perspective des graphismes en Mode 7 utilisés dans certains jeux en contournant certaines limitations de l'entier mathématique utilisé par la SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_FR "Mode 7 HD - suréchantillonnage"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FR "Suréchantillonnage"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_FR "Les graphismes en Mode 7 utilisés dans certains jeux, combinés avec des facteurs d'échelle de Mode 7 plus élevés, produisent un effet similaire à l'anti-aliasing."
#define BSNES_MODE7_MOSAIC_LABEL_FR "Mode 7 HD - mosaïque HD->SD"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_FR "Mosaïque HD->SD"
#define BSNES_MODE7_MOSAIC_INFO_0_FR "Afficher l'effet de mosaïque des graphismes en Mode 7 même lors de leur agrandissement."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_FR "Exécution en avance interne"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_FR "Simuler le système à l’avance et revenir en arrière pour réduire la latence des entrées. A des exigences système très élevées."
#define OPTION_VAL_1_FR "1 image"
#define OPTION_VAL_2_FR "2 images"
#define OPTION_VAL_3_FR "3 images"
#define OPTION_VAL_4_FR "4 images"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FR "Coprocesseurs - mode rapide"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FR "Activer l'émulation plus rapide des processeurs au prix d'une réduction mineure de la précision. Il est recommandé de laisser cette option activée."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_FR "Coprocesseurs - préférer le mode HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FR "Lorsque cette option est activée, l'émulation en mode HLE moins précise sera toujours utilisée lorsque disponible. Si désactivée, le mode HLE ne sera utilisé que lorsque le firmware LLE est manquant."
#define BSNES_HOTFIXES_LABEL_FR "Correctifs"
#define BSNES_HOTFIXES_INFO_0_FR "Même les logiciels sous licence commerciale et officiellement publiés sont parfois livrés avec des bugs. Cette option corrigera certains problèmes qui se produisaient même sur du matériel réel."
#define BSNES_ENTROPY_LABEL_FR "Entropie (aléatoire)"
#define BSNES_ENTROPY_INFO_0_FR "Choisir le niveau de randomisation de la mémoire et des registres. Si défini sur Aucune, toute la mémoire et tous les registres sont initialisés à des valeurs constantes au démarrage. La faible randomisation fournit la représentation la plus précise d'un système réel. La randomisation élevée est aussi aléatoire que possible."
#define OPTION_VAL_LOW_FR "Faible"
#define OPTION_VAL_HIGH_FR "Élevée"
#define BSNES_CPU_FASTMATH_LABEL_FR "Calculs rapides du processeur"
#define BSNES_CPU_FASTMATH_INFO_0_FR "Fournir les résultats des calculs immédiatement. La multiplication et la division par le processeur prennent du temps pour se terminer sur une SNES réelle. Les émulateurs plus anciens ne simulaient pas ces retards, donc certains hacks de ROM plus anciens n'attendent pas que les opérations mathématiques se terminent et ont besoin de ce hack."
#define BSNES_CPU_OVERCLOCK_LABEL_FR "Overclocking - processeur"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_FR "Processeur"
#define BSNES_CPU_OVERCLOCK_INFO_0_FR "Overclocker ou underclocker le processeur. Définir cette valeur au-dessus de 100 % peut réduire les temps de chargement et supprimer les ralentissements. Utiliser avec précaution, car cela peut également causer le plantage de certains jeux ou exposer d'autres problèmes."
#define OPTION_VAL_210_FR NULL
#define OPTION_VAL_220_FR NULL
#define OPTION_VAL_230_FR NULL
#define OPTION_VAL_240_FR NULL
#define OPTION_VAL_250_FR NULL
#define OPTION_VAL_260_FR NULL
#define OPTION_VAL_270_FR NULL
#define OPTION_VAL_280_FR NULL
#define OPTION_VAL_290_FR NULL
#define OPTION_VAL_300_FR NULL
#define OPTION_VAL_310_FR NULL
#define OPTION_VAL_320_FR NULL
#define OPTION_VAL_330_FR NULL
#define OPTION_VAL_340_FR NULL
#define OPTION_VAL_350_FR NULL
#define OPTION_VAL_360_FR NULL
#define OPTION_VAL_370_FR NULL
#define OPTION_VAL_380_FR NULL
#define OPTION_VAL_390_FR NULL
#define OPTION_VAL_400_FR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_FR "Overclocking - coprocesseur SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FR "Coprocesseur SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_FR "Overclocker ou underclocker la puce Super Accelerator 1 (SA-1). Régler cette valeur au-dessus de 100% peut améliorer les performances dans les jeux qui prennent en charge la puce SA-1. Utiliser avec précaution, car cela peut également causer le plantage de certains jeux ou exposer d'autres problèmes."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_FR "Overclocking - coprocesseur SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FR "Coprocesseur SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_FR "Overclocker ou underclocker le coprocesseur SuperFX. Régler cette valeur au-dessus de 100% peut améliorer les performances dans les jeux qui prennent en charge le SuperFX. Utiliser avec précaution, car cela peut également causer le plantage de certains jeux ou exposer d'autres problèmes."
#define OPTION_VAL_410_FR NULL
#define OPTION_VAL_420_FR NULL
#define OPTION_VAL_430_FR NULL
#define OPTION_VAL_440_FR NULL
#define OPTION_VAL_450_FR NULL
#define OPTION_VAL_460_FR NULL
#define OPTION_VAL_470_FR NULL
#define OPTION_VAL_480_FR NULL
#define OPTION_VAL_490_FR NULL
#define OPTION_VAL_500_FR NULL
#define OPTION_VAL_510_FR NULL
#define OPTION_VAL_520_FR NULL
#define OPTION_VAL_530_FR NULL
#define OPTION_VAL_540_FR NULL
#define OPTION_VAL_550_FR NULL
#define OPTION_VAL_560_FR NULL
#define OPTION_VAL_570_FR NULL
#define OPTION_VAL_580_FR NULL
#define OPTION_VAL_590_FR NULL
#define OPTION_VAL_600_FR NULL
#define OPTION_VAL_610_FR NULL
#define OPTION_VAL_620_FR NULL
#define OPTION_VAL_630_FR NULL
#define OPTION_VAL_640_FR NULL
#define OPTION_VAL_650_FR NULL
#define OPTION_VAL_660_FR NULL
#define OPTION_VAL_670_FR NULL
#define OPTION_VAL_680_FR NULL
#define OPTION_VAL_690_FR NULL
#define OPTION_VAL_700_FR NULL
#define OPTION_VAL_710_FR NULL
#define OPTION_VAL_720_FR NULL
#define OPTION_VAL_730_FR NULL
#define OPTION_VAL_740_FR NULL
#define OPTION_VAL_750_FR NULL
#define OPTION_VAL_760_FR NULL
#define OPTION_VAL_770_FR NULL
#define OPTION_VAL_780_FR NULL
#define OPTION_VAL_790_FR NULL
#define OPTION_VAL_800_FR NULL
#define BSNES_SGB_BIOS_LABEL_FR "BIOS préféré du Super Game Boy (Redémarrage requis)"
#define BSNES_SGB_BIOS_INFO_0_FR "Sélectionner le BIOS préféré du Super Game Boy pour être utilisé avec des titres compatibles."
#define OPTION_VAL_SGB1_SFC_FR NULL
#define OPTION_VAL_SGB2_SFC_FR NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_FR "Masquer la bordure du SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_FR "Masquer la bordure lorsque vous jouez à des jeux Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FR "Pistolet écran tactile"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FR "Activer l'entrée du Super Scope pour les appareils à écran tactile."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FR "Inverser les touches de tir du Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FR "Inverser les touches de tir et du curseur Super Scope avec le pistolet écran tactile."

struct retro_core_option_v2_category option_cats_fr[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_FR,
      CATEGORY_VIDEO_INFO_0_FR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_FR,
      CATEGORY_AUDIO_INFO_0_FR
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_FR,
      CATEGORY_MODE7_INFO_0_FR
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_FR,
      CATEGORY_HACK_INFO_0_FR
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_FR,
      CATEGORY_OVERCLOCK_INFO_0_FR
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_FR,
      CATEGORY_SGB_INFO_0_FR
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_FR,
      CATEGORY_LIGHTGUN_INFO_0_FR
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fr[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_FR,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_FR,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_FR },
         { "1:1",  OPTION_VAL_1_1_FR },
         { "4:3",  OPTION_VAL_4_3_FR },
         { "NTSC", OPTION_VAL_NTSC_FR },
         { "PAL",  OPTION_VAL_PAL_FR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_FR,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_FR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_FR },
         { "8",  OPTION_VAL_8_FR },
         { "12", OPTION_VAL_12_FR },
         { "16", OPTION_VAL_16_FR },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_FR,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_FR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_FR,
      BSNES_VIDEO_FILTER_LABEL_FR,
      BSNES_VIDEO_FILTER_INFO_0_FR,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_FR },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_FR },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_FR },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_FR },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_FR },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_FR,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_FR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FR },
         { "10", OPTION_VAL_10_FR },
         { "20", OPTION_VAL_20_FR },
         { "30", OPTION_VAL_30_FR },
         { "40", OPTION_VAL_40_FR },
         { "50", OPTION_VAL_50_FR },
         { "60", OPTION_VAL_60_FR },
         { "70", OPTION_VAL_70_FR },
         { "80", OPTION_VAL_80_FR },
         { "90", OPTION_VAL_90_FR },
         { "100", OPTION_VAL_100_FR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_FR,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_FR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_FR },
         { "10", OPTION_VAL_10_FR },
         { "20", OPTION_VAL_20_FR },
         { "30", OPTION_VAL_30_FR },
         { "40", OPTION_VAL_40_FR },
         { "50", OPTION_VAL_50_FR },
         { "60", OPTION_VAL_60_FR },
         { "70", OPTION_VAL_70_FR },
         { "80", OPTION_VAL_80_FR },
         { "90", OPTION_VAL_90_FR },
         { "100", OPTION_VAL_100_FR },
         { "110", OPTION_VAL_110_FR },
         { "120", OPTION_VAL_120_FR },
         { "130", OPTION_VAL_130_FR },
         { "140", OPTION_VAL_140_FR },
         { "150", OPTION_VAL_150_FR },
         { "160", OPTION_VAL_160_FR },
         { "170", OPTION_VAL_170_FR },
         { "180", OPTION_VAL_180_FR },
         { "190", OPTION_VAL_190_FR },
         { "200", OPTION_VAL_200_FR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_FR,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_FR,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_FR },
         { "110", OPTION_VAL_110_FR },
         { "120", OPTION_VAL_120_FR },
         { "130", OPTION_VAL_130_FR },
         { "140", OPTION_VAL_140_FR },
         { "150", OPTION_VAL_150_O6_FR },
         { "160", OPTION_VAL_160_FR },
         { "170", OPTION_VAL_170_FR },
         { "180", OPTION_VAL_180_FR },
         { "190", OPTION_VAL_190_FR },
         { "200", OPTION_VAL_200_FR },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_FR,
      BSNES_PPU_FAST_LABEL_CAT_FR,
      BSNES_PPU_FAST_INFO_0_FR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_FR,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_FR,
      BSNES_PPU_DEINTERLACE_INFO_0_FR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_FR,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_FR,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_FR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_FR,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_FR,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_FR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_FR,
      BSNES_DSP_FAST_LABEL_CAT_FR,
      BSNES_DSP_FAST_INFO_0_FR,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_FR,
      BSNES_DSP_CUBIC_LABEL_CAT_FR,
      BSNES_DSP_CUBIC_INFO_0_FR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_FR,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_FR,
      BSNES_DSP_ECHO_SHADOW_INFO_0_FR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_FR,
      BSNES_MODE7_SCALE_LABEL_CAT_FR,
      BSNES_MODE7_SCALE_INFO_0_FR,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_FR  },
         { "2x", OPTION_VAL_2X_FR  },
         { "3x", OPTION_VAL_3X_FR  },
         { "4x", OPTION_VAL_4X_FR  },
         { "5x", OPTION_VAL_5X_FR },
         { "6x", OPTION_VAL_6X_FR },
         { "7x", OPTION_VAL_7X_FR },
         { "8x", OPTION_VAL_8X_FR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_FR,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_FR,
      BSNES_MODE7_PERSPECTIVE_INFO_0_FR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_FR,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_FR,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_FR,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_FR,
      BSNES_MODE7_MOSAIC_LABEL_CAT_FR,
      BSNES_MODE7_MOSAIC_INFO_0_FR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_FR,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_FR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_FR  },
         { "2",   OPTION_VAL_2_FR },
         { "3",   OPTION_VAL_3_FR },
         { "4",   OPTION_VAL_4_FR },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_FR,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_FR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_FR,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_FR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_FR,
      NULL,
      BSNES_HOTFIXES_INFO_0_FR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_FR,
      NULL,
      BSNES_ENTROPY_INFO_0_FR,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_FR },
         { "High", OPTION_VAL_HIGH_FR },
         { "None", OPTION_VAL_NONE_FR },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_FR,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_FR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_FR,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_FR,
      BSNES_CPU_OVERCLOCK_INFO_0_FR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FR  },
         { "20",  OPTION_VAL_20_FR  },
         { "30",  OPTION_VAL_30_FR  },
         { "40",  OPTION_VAL_40_FR  },
         { "50",  OPTION_VAL_50_FR  },
         { "60",  OPTION_VAL_60_FR  },
         { "70",  OPTION_VAL_70_FR  },
         { "80",  OPTION_VAL_80_FR  },
         { "90",  OPTION_VAL_90_FR  },
         { "100", OPTION_VAL_100_FR },
         { "110", OPTION_VAL_110_FR },
         { "120", OPTION_VAL_120_FR },
         { "130", OPTION_VAL_130_FR },
         { "140", OPTION_VAL_140_FR },
         { "150", OPTION_VAL_150_FR },
         { "160", OPTION_VAL_160_FR },
         { "170", OPTION_VAL_170_FR },
         { "180", OPTION_VAL_180_FR },
         { "190", OPTION_VAL_190_FR },
         { "200", OPTION_VAL_200_FR },
         { "210", OPTION_VAL_210_FR },
         { "220", OPTION_VAL_220_FR },
         { "230", OPTION_VAL_230_FR },
         { "240", OPTION_VAL_240_FR },
         { "250", OPTION_VAL_250_FR },
         { "260", OPTION_VAL_260_FR },
         { "270", OPTION_VAL_270_FR },
         { "280", OPTION_VAL_280_FR },
         { "290", OPTION_VAL_290_FR },
         { "300", OPTION_VAL_300_FR },
         { "310", OPTION_VAL_310_FR },
         { "320", OPTION_VAL_320_FR },
         { "330", OPTION_VAL_330_FR },
         { "340", OPTION_VAL_340_FR },
         { "350", OPTION_VAL_350_FR },
         { "360", OPTION_VAL_360_FR },
         { "370", OPTION_VAL_370_FR },
         { "380", OPTION_VAL_380_FR },
         { "390", OPTION_VAL_390_FR },
         { "400", OPTION_VAL_400_FR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_FR,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_FR,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_FR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FR  },
         { "20",  OPTION_VAL_20_FR  },
         { "30",  OPTION_VAL_30_FR  },
         { "40",  OPTION_VAL_40_FR  },
         { "50",  OPTION_VAL_50_FR  },
         { "60",  OPTION_VAL_60_FR  },
         { "70",  OPTION_VAL_70_FR  },
         { "80",  OPTION_VAL_80_FR  },
         { "90",  OPTION_VAL_90_FR  },
         { "100", OPTION_VAL_100_FR },
         { "110", OPTION_VAL_110_FR },
         { "120", OPTION_VAL_120_FR },
         { "130", OPTION_VAL_130_FR },
         { "140", OPTION_VAL_140_FR },
         { "150", OPTION_VAL_150_FR },
         { "160", OPTION_VAL_160_FR },
         { "170", OPTION_VAL_170_FR },
         { "180", OPTION_VAL_180_FR },
         { "190", OPTION_VAL_190_FR },
         { "200", OPTION_VAL_200_FR },
         { "210", OPTION_VAL_210_FR },
         { "220", OPTION_VAL_220_FR },
         { "230", OPTION_VAL_230_FR },
         { "240", OPTION_VAL_240_FR },
         { "250", OPTION_VAL_250_FR },
         { "260", OPTION_VAL_260_FR },
         { "270", OPTION_VAL_270_FR },
         { "280", OPTION_VAL_280_FR },
         { "290", OPTION_VAL_290_FR },
         { "300", OPTION_VAL_300_FR },
         { "310", OPTION_VAL_310_FR },
         { "320", OPTION_VAL_320_FR },
         { "330", OPTION_VAL_330_FR },
         { "340", OPTION_VAL_340_FR },
         { "350", OPTION_VAL_350_FR },
         { "360", OPTION_VAL_360_FR },
         { "370", OPTION_VAL_370_FR },
         { "380", OPTION_VAL_380_FR },
         { "390", OPTION_VAL_390_FR },
         { "400", OPTION_VAL_400_FR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_FR,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_FR,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_FR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_FR  },
         { "20",  OPTION_VAL_20_FR  },
         { "30",  OPTION_VAL_30_FR  },
         { "40",  OPTION_VAL_40_FR  },
         { "50",  OPTION_VAL_50_FR  },
         { "60",  OPTION_VAL_60_FR  },
         { "70",  OPTION_VAL_70_FR  },
         { "80",  OPTION_VAL_80_FR  },
         { "90",  OPTION_VAL_90_FR  },
         { "100", OPTION_VAL_100_FR },
         { "110", OPTION_VAL_110_FR },
         { "120", OPTION_VAL_120_FR },
         { "130", OPTION_VAL_130_FR },
         { "140", OPTION_VAL_140_FR },
         { "150", OPTION_VAL_150_FR },
         { "160", OPTION_VAL_160_FR },
         { "170", OPTION_VAL_170_FR },
         { "180", OPTION_VAL_180_FR },
         { "190", OPTION_VAL_190_FR },
         { "200", OPTION_VAL_200_FR },
         { "210", OPTION_VAL_210_FR },
         { "220", OPTION_VAL_220_FR },
         { "230", OPTION_VAL_230_FR },
         { "240", OPTION_VAL_240_FR },
         { "250", OPTION_VAL_250_FR },
         { "260", OPTION_VAL_260_FR },
         { "270", OPTION_VAL_270_FR },
         { "280", OPTION_VAL_280_FR },
         { "290", OPTION_VAL_290_FR },
         { "300", OPTION_VAL_300_FR },
         { "310", OPTION_VAL_310_FR },
         { "320", OPTION_VAL_320_FR },
         { "330", OPTION_VAL_330_FR },
         { "340", OPTION_VAL_340_FR },
         { "350", OPTION_VAL_350_FR },
         { "360", OPTION_VAL_360_FR },
         { "370", OPTION_VAL_370_FR },
         { "380", OPTION_VAL_380_FR },
         { "390", OPTION_VAL_390_FR },
         { "400", OPTION_VAL_400_FR },
         { "410", OPTION_VAL_410_FR },
         { "420", OPTION_VAL_420_FR },
         { "430", OPTION_VAL_430_FR },
         { "440", OPTION_VAL_440_FR },
         { "450", OPTION_VAL_450_FR },
         { "460", OPTION_VAL_460_FR },
         { "470", OPTION_VAL_470_FR },
         { "480", OPTION_VAL_480_FR },
         { "490", OPTION_VAL_490_FR },
         { "500", OPTION_VAL_500_FR },
         { "510", OPTION_VAL_510_FR },
         { "520", OPTION_VAL_520_FR },
         { "530", OPTION_VAL_530_FR },
         { "540", OPTION_VAL_540_FR },
         { "550", OPTION_VAL_550_FR },
         { "560", OPTION_VAL_560_FR },
         { "570", OPTION_VAL_570_FR },
         { "580", OPTION_VAL_580_FR },
         { "590", OPTION_VAL_590_FR },
         { "600", OPTION_VAL_600_FR },
         { "610", OPTION_VAL_610_FR },
         { "620", OPTION_VAL_620_FR },
         { "630", OPTION_VAL_630_FR },
         { "640", OPTION_VAL_640_FR },
         { "650", OPTION_VAL_650_FR },
         { "660", OPTION_VAL_660_FR },
         { "670", OPTION_VAL_670_FR },
         { "680", OPTION_VAL_680_FR },
         { "690", OPTION_VAL_690_FR },
         { "700", OPTION_VAL_700_FR },
         { "710", OPTION_VAL_710_FR },
         { "720", OPTION_VAL_720_FR },
         { "730", OPTION_VAL_730_FR },
         { "740", OPTION_VAL_740_FR },
         { "750", OPTION_VAL_750_FR },
         { "760", OPTION_VAL_760_FR },
         { "770", OPTION_VAL_770_FR },
         { "780", OPTION_VAL_780_FR },
         { "790", OPTION_VAL_790_FR },
         { "800", OPTION_VAL_800_FR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_FR,
      NULL,
      BSNES_SGB_BIOS_INFO_0_FR,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_FR   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_FR },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_FR,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_FR,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_FR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_FR,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_FR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_FR,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_fr = {
   option_cats_fr,
   option_defs_fr
};

/* RETRO_LANGUAGE_GA */

#define CATEGORY_VIDEO_LABEL_GA "Físeán"
#define CATEGORY_VIDEO_INFO_0_GA "Athraigh socruithe aschuir físe."
#define CATEGORY_AUDIO_LABEL_GA "Fuaim"
#define CATEGORY_AUDIO_INFO_0_GA "Athraigh socruithe aschuir fuaime."
#define CATEGORY_MODE7_LABEL_GA "Mód HD 7"
#define CATEGORY_MODE7_INFO_0_GA "Athraigh socruithe maidir le haithris grafaicí Mód 7."
#define CATEGORY_HACK_LABEL_GA "Cleasanna agus Feabhsuithe Aithrise"
#define CATEGORY_HACK_INFO_0_GA "Cuir cleasanna aithrise, feabhsuithe agus ceartúcháin the i bhfeidhm."
#define CATEGORY_OVERCLOCK_LABEL_GA "Ró-/Síoschlogáil"
#define CATEGORY_OVERCLOCK_INFO_0_GA "Athraigh luas na crua-earraí aithrisithe."
#define CATEGORY_SGB_LABEL_GA NULL
#define CATEGORY_SGB_INFO_0_GA "Athraigh socruithe maidir le haithris an Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_GA "Gunna Solais"
#define CATEGORY_LIGHTGUN_INFO_0_GA "Athraigh socruithe gunna solais (scáileáin tadhaill)."
#define BSNES_ASPECT_RATIO_LABEL_GA "Cóimheas Gné is Fearr"
#define BSNES_ASPECT_RATIO_INFO_0_GA "Roghnaigh an cóimheas gné ábhair is fearr leat. Ní bheidh feidhm ag seo ach amháin nuair a bheidh cóimheas gné RetroArch socraithe go 'Croílár curtha ar fáil' sna socruithe Físeáin."
#define OPTION_VAL_AUTO_GA "Uathoibríoch"
#define OPTION_VAL_1_1_GA "PAR 1:1 (Picteil Foirfe)"
#define OPTION_VAL_4_3_GA NULL
#define OPTION_VAL_NTSC_GA NULL
#define OPTION_VAL_PAL_GA NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_GA "Bearr Ró-scanadh Ingearach"
#define BSNES_PPU_OVERSCAN_V_INFO_0_GA "Bain línte N ó bharr agus bun an scáileáin chun bezel teilifíse ó ré an SNES a insamhladh."
#define OPTION_VAL_0_GA "0 Línte"
#define OPTION_VAL_8_GA "8 Líne"
#define OPTION_VAL_12_GA "12 Líne"
#define OPTION_VAL_16_GA "16 Líne"
#define BSNES_BLUR_EMULATION_LABEL_GA "Aithris Doiléire"
#define BSNES_BLUR_EMULATION_INFO_0_GA "Insamhlaigh an taifeach cothrománach teoranta de theilifíseáin SD trí phicteilíní atá cóngarach go cothrománach a dhoiléiriú le chéile. Braitheann roinnt cluichí ar seo chun éifeacht trédhearcachta a aithris."
#define BSNES_VIDEO_FILTER_LABEL_GA "Scagaire"
#define BSNES_VIDEO_FILTER_INFO_0_GA "Roghnaigh idir gan scagadh agus scagaire NTSC blargg le roghanna do RF, Ilchodach, S-Video, nó RGB"
#define OPTION_VAL_NONE_GA "Dada"
#define OPTION_VAL_NTSC_RF_GA NULL
#define OPTION_VAL_NTSC_COMPOSITE_GA "NTSC (Comhchodach)"
#define OPTION_VAL_NTSC_S_VIDEO_GA NULL
#define OPTION_VAL_NTSC_RGB_GA NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_GA "Coigeartú Datha - Lonrúlacht"
#define BSNES_VIDEO_LUMINANCE_INFO_0_GA "Coigeartaigh an Lonracht"
#define OPTION_VAL_0_O4_GA NULL
#define OPTION_VAL_10_GA NULL
#define OPTION_VAL_20_GA NULL
#define OPTION_VAL_30_GA NULL
#define OPTION_VAL_40_GA NULL
#define OPTION_VAL_50_GA NULL
#define OPTION_VAL_60_GA NULL
#define OPTION_VAL_70_GA NULL
#define OPTION_VAL_80_GA NULL
#define OPTION_VAL_90_GA NULL
#define OPTION_VAL_100_GA "100% (Réamhshocrú)"
#define BSNES_VIDEO_SATURATION_LABEL_GA "Coigeartú Datha - Sáithiú"
#define BSNES_VIDEO_SATURATION_INFO_0_GA "Coigeartaigh Sáithiú"
#define OPTION_VAL_110_GA NULL
#define OPTION_VAL_120_GA NULL
#define OPTION_VAL_130_GA NULL
#define OPTION_VAL_140_GA NULL
#define OPTION_VAL_150_GA NULL
#define OPTION_VAL_160_GA NULL
#define OPTION_VAL_170_GA NULL
#define OPTION_VAL_180_GA NULL
#define OPTION_VAL_190_GA NULL
#define OPTION_VAL_200_GA NULL
#define BSNES_VIDEO_GAMMA_LABEL_GA "Coigeartú Dath - Gama"
#define BSNES_VIDEO_GAMMA_INFO_0_GA "Coigeartaigh Gama"
#define OPTION_VAL_100_O6_GA NULL
#define OPTION_VAL_150_O6_GA "150% (Réamhshocrú)"
#define BSNES_PPU_FAST_LABEL_GA "PPU (Físeán) - Mód Tapa"
#define BSNES_PPU_FAST_LABEL_CAT_GA "PPU - Mód Tapaidh"
#define BSNES_PPU_FAST_INFO_0_GA "Cumasaigh aithris níos tapúla ar an PPU ar chostas laghdú beag ar chruinneas. Moltar é seo a fhágáil ar siúl. TABHAIR FAOI DEARA: ní mór é seo a chumasú chun go n-oibreoidh na roghanna 'Deinterlace', 'No Sprite Limit' agus 'HD Mode 7'."
#define BSNES_PPU_DEINTERLACE_LABEL_GA NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_GA NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_GA "Dí-idircheanglaítear gach cluiche trí rindreáil inmheánach ag 480p. Is ar éigean a bhíonn aon phionós feidhmíochta ann, mar sin moltar é seo a fhágáil ar siúl."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_GA "PPU (Físeán) - Gan Teorainn Sprid"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_GA "PPU - Gan Teorainn Sprid"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_GA "Bain aon teorainn ar líon na sprites is féidir a tharraingt ag an am céanna ar an scáileán. D’fhéadfadh fadhbanna a bheith mar thoradh air sin le roinnt cluichí."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_GA "PPU (Físeán) - Gan aon bhlocáil VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_GA "PPU - Gan aon bhlocáil VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_GA "Déan aithris ar fhabht i leaganacha níos sine de ZSNES agus Snes9x, áit nach ndearnadh aithris ar bhlocáil VRAM. Bhí roinnt sean-hacaí ROM ag brath ar an iompar seo agus rindreálfaidh siad grafaicí go mícheart mura bhfuil sé seo cumasaithe. Tá an rogha seo thar a bheith míchruinn agus déanann sé dochar do luas an PPU, mar sin moltar é a fhágáil díchumasaithe mura gá duit cluiche a imirt nach bhfuil comhoiriúnach leis an gcroílár seo ar shlí eile."
#define BSNES_DSP_FAST_LABEL_GA "DSP (Fuaim) - Mód Tapa"
#define BSNES_DSP_FAST_LABEL_CAT_GA "DSP - Mód Tapa"
#define BSNES_DSP_FAST_INFO_0_GA "Cumasaigh aithris níos tapúla ar an DSP ar chostas laghdú beag ar chruinneas. Moltar é seo a fhágáil ar siúl."
#define BSNES_DSP_CUBIC_LABEL_GA "DSP (Fuaim) - Idirshuíomh Ciúbach"
#define BSNES_DSP_CUBIC_LABEL_CAT_GA "DSP - Idirshuíomh Ciúbach"
#define BSNES_DSP_CUBIC_INFO_0_GA "Cuir idirshuíomh ciúbach i bhfeidhm ar an fhuaim, ag caomhnú níos mó den raon ard."
#define BSNES_DSP_ECHO_SHADOW_LABEL_GA "DSP (Fuaim) - RAM Macalla Scáth"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_GA "DSP - Macalla Scáth RAM"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_GA "Déan aithris ar fhabht i ZSNES inar caitheadh ​​le RAM macalla mar rud ar leithligh ó RAM APU. Bhí go leor sean-hacaí ROM do Super Mario World ag brath ar an iompar seo agus tuairteálfaidh siad gan é seo. Tá an rogha seo thar a bheith míchruinn agus níor cheart é a chumasú mura bhfuil gá leis."
#define BSNES_MODE7_SCALE_LABEL_GA "Mód HD 7 - Scála"
#define BSNES_MODE7_SCALE_LABEL_CAT_GA "Scála"
#define BSNES_MODE7_SCALE_INFO_0_GA "Méadaigh taifeach cothrománach agus ingearach na ngrafaicí Mód 7 a úsáidtear i gcluichí áirithe."
#define OPTION_VAL_1X_GA NULL
#define OPTION_VAL_2X_GA NULL
#define OPTION_VAL_3X_GA NULL
#define OPTION_VAL_4X_GA NULL
#define OPTION_VAL_5X_GA NULL
#define OPTION_VAL_6X_GA NULL
#define OPTION_VAL_7X_GA NULL
#define OPTION_VAL_8X_GA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_GA "Mód HD 7 - Ceartú Peirspictíochta"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_GA "Ceartú Peirspictíochta"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_GA "Ceartaigh peirspictíocht na ngrafaicí Mód 7 a úsáidtear i gcluichí áirithe trí roinnt teorainneacha a bhaineann leis an matamaitic slánuimhreach a úsáideann an SNES a sheachaint."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_GA "Mód HD 7 - Supersampláil"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_GA "Super-sampláil"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_GA "Sár-shampla de na grafaicí Mód 7 a úsáidtear i gcluichí áirithe. I dteannta fachtóirí scála Mód 7 níos airde, tá éifeacht cosúil le frith-ailiasú mar thoradh air."
#define BSNES_MODE7_MOSAIC_LABEL_GA "Mód HD 7 - HD->SD Mósáic"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_GA "Mósáic HD->SD"
#define BSNES_MODE7_MOSAIC_INFO_0_GA "Taispeáin éifeacht mhósáice grafaicí Mód 7 fiú agus iad á n-uas-scálú."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_GA "Rith Chun Tosaigh Inmheánach"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_GA "Insamhlaigh an córas roimh ré agus rolladh siar chun moill ionchuir a laghdú. Tá riachtanais chórais an-ard aige."
#define OPTION_VAL_1_GA "1 fráma"
#define OPTION_VAL_2_GA "2 fhráma"
#define OPTION_VAL_3_GA "3 fhráma"
#define OPTION_VAL_4_GA "4 fhráma"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_GA "Comhphróiseálaithe - Mód Tapa"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_GA "Cumasaigh aithris níos tapúla ar na comhphróiseálaithe ar chostas laghdú beag ar chruinneas. Moltar é seo a fhágáil ar siúl."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_GA "Comhphróiseálaithe - Is fearr HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_GA "Nuair a bhíonn an rogha seo cumasaithe, úsáidfear aithris HLE nach bhfuil chomh cruinn i gcónaí nuair a bhíonn sé ar fáil. Mura bhfuil sé cumasaithe, ní úsáidfear HLE ach amháin nuair a bhíonn dochtearraí LLE ar iarraidh."
#define BSNES_HOTFIXES_LABEL_GA "Socruithe Te"
#define BSNES_HOTFIXES_INFO_0_GA "Bíonn fabhtanna ag baint le bogearraí atá ceadúnaithe go tráchtála agus a scaoiltear go hoifigiúil fiú. Ceartóidh an rogha seo fadhbanna áirithe a tharla fiú ar chrua-earraí fíor."
#define BSNES_ENTROPY_LABEL_GA "Eintreapacht (randamú)"
#define BSNES_ENTROPY_INFO_0_GA "Roghnaigh leibhéal randamaithe na cuimhne agus na gclár. Mura socraítear é seo, déantar luachanna tairiseacha a thosú ar an gcuimhne agus na cláir go léir ag an am tosaithe. Soláthraíonn randamú íseal an léiriú is cruinne ar chóras fíor. Déanann ard randamú a oiread agus is féidir."
#define OPTION_VAL_LOW_GA "Íseal"
#define OPTION_VAL_HIGH_GA "Ard"
#define BSNES_CPU_FASTMATH_LABEL_GA "Matamaitic Thapa LAP"
#define BSNES_CPU_FASTMATH_INFO_0_GA "Cuir torthaí ríomhaireachta ar fáil láithreach. Tógann sé tamall le hiolrú agus roinnt LAP a chríochnú ar SNES fíor. Níor insamhladh sean-aithriseoirí na moilleanna seo agus dá bhrí sin ní fhanann roinnt sean-hacanna ROM go dtí go gcríochnófar oibríochtaí matamaitice agus teastaíonn an haca seo uathu."
#define BSNES_CPU_OVERCLOCK_LABEL_GA "Róchlogáil - LAP"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_GA "LAP"
#define BSNES_CPU_OVERCLOCK_INFO_0_GA "Róchlogáil nó ísliúchlogáil an LAP. Má shocraítear an luach seo os cionn 100%, d’fhéadfadh sé amanna lódála a laghdú agus moill a bhaint. Bí cúramach mar d’fhéadfadh sé go dtitfeadh roinnt cluichí nó go dtaispeánfadh sé fadhbanna eile."
#define OPTION_VAL_210_GA NULL
#define OPTION_VAL_220_GA NULL
#define OPTION_VAL_230_GA NULL
#define OPTION_VAL_240_GA NULL
#define OPTION_VAL_250_GA NULL
#define OPTION_VAL_260_GA NULL
#define OPTION_VAL_270_GA NULL
#define OPTION_VAL_280_GA NULL
#define OPTION_VAL_290_GA NULL
#define OPTION_VAL_300_GA NULL
#define OPTION_VAL_310_GA NULL
#define OPTION_VAL_320_GA NULL
#define OPTION_VAL_330_GA NULL
#define OPTION_VAL_340_GA NULL
#define OPTION_VAL_350_GA NULL
#define OPTION_VAL_360_GA NULL
#define OPTION_VAL_370_GA NULL
#define OPTION_VAL_380_GA NULL
#define OPTION_VAL_390_GA NULL
#define OPTION_VAL_400_GA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_GA "Róchlogáil - Comhphróiseálaí SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_GA "Comhphróiseálaí SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_GA "Róchlogáil nó síoschlogáil an tslis Super Accelerator 1 (SA-1). Má shocraítear an luach seo os cionn 100%, d’fhéadfadh sé feabhas a chur ar fheidhmíocht i gcluichí a thacaíonn leis an tslis SA-1. Bí cúramach, mar d’fhéadfadh sé tuairteanna a chur ar roinnt cluichí nó fadhbanna eile a thaispeáint dá bharr."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_GA "Róchlogáil - Comhphróiseálaí SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_GA "Comhphróiseálaí SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_GA "Róchlogáil nó síoschlogáil an chomhphróiseálaí SuperFX. Má shocraítear an luach seo os cionn 100%, d’fhéadfadh sé feabhas a chur ar fheidhmíocht i gcluichí a thacaíonn leis an SuperFX. Bí cúramach, mar d’fhéadfadh sé tuairteanna a chur ar roinnt cluichí nó fadhbanna eile a thaispeáint."
#define OPTION_VAL_410_GA NULL
#define OPTION_VAL_420_GA NULL
#define OPTION_VAL_430_GA NULL
#define OPTION_VAL_440_GA NULL
#define OPTION_VAL_450_GA NULL
#define OPTION_VAL_460_GA NULL
#define OPTION_VAL_470_GA NULL
#define OPTION_VAL_480_GA NULL
#define OPTION_VAL_490_GA NULL
#define OPTION_VAL_500_GA NULL
#define OPTION_VAL_510_GA NULL
#define OPTION_VAL_520_GA NULL
#define OPTION_VAL_530_GA NULL
#define OPTION_VAL_540_GA NULL
#define OPTION_VAL_550_GA NULL
#define OPTION_VAL_560_GA NULL
#define OPTION_VAL_570_GA NULL
#define OPTION_VAL_580_GA NULL
#define OPTION_VAL_590_GA NULL
#define OPTION_VAL_600_GA NULL
#define OPTION_VAL_610_GA NULL
#define OPTION_VAL_620_GA NULL
#define OPTION_VAL_630_GA NULL
#define OPTION_VAL_640_GA NULL
#define OPTION_VAL_650_GA NULL
#define OPTION_VAL_660_GA NULL
#define OPTION_VAL_670_GA NULL
#define OPTION_VAL_680_GA NULL
#define OPTION_VAL_690_GA NULL
#define OPTION_VAL_700_GA NULL
#define OPTION_VAL_710_GA NULL
#define OPTION_VAL_720_GA NULL
#define OPTION_VAL_730_GA NULL
#define OPTION_VAL_740_GA NULL
#define OPTION_VAL_750_GA NULL
#define OPTION_VAL_760_GA NULL
#define OPTION_VAL_770_GA NULL
#define OPTION_VAL_780_GA NULL
#define OPTION_VAL_790_GA NULL
#define OPTION_VAL_800_GA NULL
#define BSNES_SGB_BIOS_LABEL_GA "BIOS is fearr leat don Super Game Boy (Atosú Riachtanach)"
#define BSNES_SGB_BIOS_INFO_0_GA "Roghnaigh an BIOS Super Game Boy is fearr leat le húsáid le teidil chomhoiriúnacha."
#define OPTION_VAL_SGB1_SFC_GA NULL
#define OPTION_VAL_SGB2_SFC_GA NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_GA "Folaigh Teorainn SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_GA "Folaigh an teorainn agus tú ag imirt cluichí Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_GA "Gunna Solais Scáileáin Tadhaill"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_GA "Cumasaigh ionchur Super Scope le haghaidh gléasanna tadhaill."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_GA "Cnaipí Truicear Droim ar Ais Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_GA "Droim ar ais na cnaipí truicear agus cúrsóra Super Scope leis an gunna solais ar an scáileán tadhaill."

struct retro_core_option_v2_category option_cats_ga[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_GA,
      CATEGORY_VIDEO_INFO_0_GA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_GA,
      CATEGORY_AUDIO_INFO_0_GA
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_GA,
      CATEGORY_MODE7_INFO_0_GA
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_GA,
      CATEGORY_HACK_INFO_0_GA
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_GA,
      CATEGORY_OVERCLOCK_INFO_0_GA
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_GA,
      CATEGORY_SGB_INFO_0_GA
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_GA,
      CATEGORY_LIGHTGUN_INFO_0_GA
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ga[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_GA,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_GA,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_GA },
         { "1:1",  OPTION_VAL_1_1_GA },
         { "4:3",  OPTION_VAL_4_3_GA },
         { "NTSC", OPTION_VAL_NTSC_GA },
         { "PAL",  OPTION_VAL_PAL_GA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_GA,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_GA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_GA },
         { "8",  OPTION_VAL_8_GA },
         { "12", OPTION_VAL_12_GA },
         { "16", OPTION_VAL_16_GA },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_GA,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_GA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_GA,
      BSNES_VIDEO_FILTER_LABEL_GA,
      BSNES_VIDEO_FILTER_INFO_0_GA,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_GA },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_GA },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_GA },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_GA },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_GA },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_GA,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_GA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_GA },
         { "10", OPTION_VAL_10_GA },
         { "20", OPTION_VAL_20_GA },
         { "30", OPTION_VAL_30_GA },
         { "40", OPTION_VAL_40_GA },
         { "50", OPTION_VAL_50_GA },
         { "60", OPTION_VAL_60_GA },
         { "70", OPTION_VAL_70_GA },
         { "80", OPTION_VAL_80_GA },
         { "90", OPTION_VAL_90_GA },
         { "100", OPTION_VAL_100_GA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_GA,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_GA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_GA },
         { "10", OPTION_VAL_10_GA },
         { "20", OPTION_VAL_20_GA },
         { "30", OPTION_VAL_30_GA },
         { "40", OPTION_VAL_40_GA },
         { "50", OPTION_VAL_50_GA },
         { "60", OPTION_VAL_60_GA },
         { "70", OPTION_VAL_70_GA },
         { "80", OPTION_VAL_80_GA },
         { "90", OPTION_VAL_90_GA },
         { "100", OPTION_VAL_100_GA },
         { "110", OPTION_VAL_110_GA },
         { "120", OPTION_VAL_120_GA },
         { "130", OPTION_VAL_130_GA },
         { "140", OPTION_VAL_140_GA },
         { "150", OPTION_VAL_150_GA },
         { "160", OPTION_VAL_160_GA },
         { "170", OPTION_VAL_170_GA },
         { "180", OPTION_VAL_180_GA },
         { "190", OPTION_VAL_190_GA },
         { "200", OPTION_VAL_200_GA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_GA,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_GA,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_GA },
         { "110", OPTION_VAL_110_GA },
         { "120", OPTION_VAL_120_GA },
         { "130", OPTION_VAL_130_GA },
         { "140", OPTION_VAL_140_GA },
         { "150", OPTION_VAL_150_O6_GA },
         { "160", OPTION_VAL_160_GA },
         { "170", OPTION_VAL_170_GA },
         { "180", OPTION_VAL_180_GA },
         { "190", OPTION_VAL_190_GA },
         { "200", OPTION_VAL_200_GA },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_GA,
      BSNES_PPU_FAST_LABEL_CAT_GA,
      BSNES_PPU_FAST_INFO_0_GA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_GA,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_GA,
      BSNES_PPU_DEINTERLACE_INFO_0_GA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_GA,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_GA,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_GA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_GA,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_GA,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_GA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_GA,
      BSNES_DSP_FAST_LABEL_CAT_GA,
      BSNES_DSP_FAST_INFO_0_GA,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_GA,
      BSNES_DSP_CUBIC_LABEL_CAT_GA,
      BSNES_DSP_CUBIC_INFO_0_GA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_GA,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_GA,
      BSNES_DSP_ECHO_SHADOW_INFO_0_GA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_GA,
      BSNES_MODE7_SCALE_LABEL_CAT_GA,
      BSNES_MODE7_SCALE_INFO_0_GA,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_GA  },
         { "2x", OPTION_VAL_2X_GA  },
         { "3x", OPTION_VAL_3X_GA  },
         { "4x", OPTION_VAL_4X_GA  },
         { "5x", OPTION_VAL_5X_GA },
         { "6x", OPTION_VAL_6X_GA },
         { "7x", OPTION_VAL_7X_GA },
         { "8x", OPTION_VAL_8X_GA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_GA,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_GA,
      BSNES_MODE7_PERSPECTIVE_INFO_0_GA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_GA,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_GA,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_GA,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_GA,
      BSNES_MODE7_MOSAIC_LABEL_CAT_GA,
      BSNES_MODE7_MOSAIC_INFO_0_GA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_GA,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_GA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_GA  },
         { "2",   OPTION_VAL_2_GA },
         { "3",   OPTION_VAL_3_GA },
         { "4",   OPTION_VAL_4_GA },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_GA,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_GA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_GA,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_GA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_GA,
      NULL,
      BSNES_HOTFIXES_INFO_0_GA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_GA,
      NULL,
      BSNES_ENTROPY_INFO_0_GA,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_GA },
         { "High", OPTION_VAL_HIGH_GA },
         { "None", OPTION_VAL_NONE_GA },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_GA,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_GA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_GA,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_GA,
      BSNES_CPU_OVERCLOCK_INFO_0_GA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GA  },
         { "20",  OPTION_VAL_20_GA  },
         { "30",  OPTION_VAL_30_GA  },
         { "40",  OPTION_VAL_40_GA  },
         { "50",  OPTION_VAL_50_GA  },
         { "60",  OPTION_VAL_60_GA  },
         { "70",  OPTION_VAL_70_GA  },
         { "80",  OPTION_VAL_80_GA  },
         { "90",  OPTION_VAL_90_GA  },
         { "100", OPTION_VAL_100_GA },
         { "110", OPTION_VAL_110_GA },
         { "120", OPTION_VAL_120_GA },
         { "130", OPTION_VAL_130_GA },
         { "140", OPTION_VAL_140_GA },
         { "150", OPTION_VAL_150_GA },
         { "160", OPTION_VAL_160_GA },
         { "170", OPTION_VAL_170_GA },
         { "180", OPTION_VAL_180_GA },
         { "190", OPTION_VAL_190_GA },
         { "200", OPTION_VAL_200_GA },
         { "210", OPTION_VAL_210_GA },
         { "220", OPTION_VAL_220_GA },
         { "230", OPTION_VAL_230_GA },
         { "240", OPTION_VAL_240_GA },
         { "250", OPTION_VAL_250_GA },
         { "260", OPTION_VAL_260_GA },
         { "270", OPTION_VAL_270_GA },
         { "280", OPTION_VAL_280_GA },
         { "290", OPTION_VAL_290_GA },
         { "300", OPTION_VAL_300_GA },
         { "310", OPTION_VAL_310_GA },
         { "320", OPTION_VAL_320_GA },
         { "330", OPTION_VAL_330_GA },
         { "340", OPTION_VAL_340_GA },
         { "350", OPTION_VAL_350_GA },
         { "360", OPTION_VAL_360_GA },
         { "370", OPTION_VAL_370_GA },
         { "380", OPTION_VAL_380_GA },
         { "390", OPTION_VAL_390_GA },
         { "400", OPTION_VAL_400_GA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_GA,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_GA,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_GA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GA  },
         { "20",  OPTION_VAL_20_GA  },
         { "30",  OPTION_VAL_30_GA  },
         { "40",  OPTION_VAL_40_GA  },
         { "50",  OPTION_VAL_50_GA  },
         { "60",  OPTION_VAL_60_GA  },
         { "70",  OPTION_VAL_70_GA  },
         { "80",  OPTION_VAL_80_GA  },
         { "90",  OPTION_VAL_90_GA  },
         { "100", OPTION_VAL_100_GA },
         { "110", OPTION_VAL_110_GA },
         { "120", OPTION_VAL_120_GA },
         { "130", OPTION_VAL_130_GA },
         { "140", OPTION_VAL_140_GA },
         { "150", OPTION_VAL_150_GA },
         { "160", OPTION_VAL_160_GA },
         { "170", OPTION_VAL_170_GA },
         { "180", OPTION_VAL_180_GA },
         { "190", OPTION_VAL_190_GA },
         { "200", OPTION_VAL_200_GA },
         { "210", OPTION_VAL_210_GA },
         { "220", OPTION_VAL_220_GA },
         { "230", OPTION_VAL_230_GA },
         { "240", OPTION_VAL_240_GA },
         { "250", OPTION_VAL_250_GA },
         { "260", OPTION_VAL_260_GA },
         { "270", OPTION_VAL_270_GA },
         { "280", OPTION_VAL_280_GA },
         { "290", OPTION_VAL_290_GA },
         { "300", OPTION_VAL_300_GA },
         { "310", OPTION_VAL_310_GA },
         { "320", OPTION_VAL_320_GA },
         { "330", OPTION_VAL_330_GA },
         { "340", OPTION_VAL_340_GA },
         { "350", OPTION_VAL_350_GA },
         { "360", OPTION_VAL_360_GA },
         { "370", OPTION_VAL_370_GA },
         { "380", OPTION_VAL_380_GA },
         { "390", OPTION_VAL_390_GA },
         { "400", OPTION_VAL_400_GA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_GA,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_GA,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_GA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GA  },
         { "20",  OPTION_VAL_20_GA  },
         { "30",  OPTION_VAL_30_GA  },
         { "40",  OPTION_VAL_40_GA  },
         { "50",  OPTION_VAL_50_GA  },
         { "60",  OPTION_VAL_60_GA  },
         { "70",  OPTION_VAL_70_GA  },
         { "80",  OPTION_VAL_80_GA  },
         { "90",  OPTION_VAL_90_GA  },
         { "100", OPTION_VAL_100_GA },
         { "110", OPTION_VAL_110_GA },
         { "120", OPTION_VAL_120_GA },
         { "130", OPTION_VAL_130_GA },
         { "140", OPTION_VAL_140_GA },
         { "150", OPTION_VAL_150_GA },
         { "160", OPTION_VAL_160_GA },
         { "170", OPTION_VAL_170_GA },
         { "180", OPTION_VAL_180_GA },
         { "190", OPTION_VAL_190_GA },
         { "200", OPTION_VAL_200_GA },
         { "210", OPTION_VAL_210_GA },
         { "220", OPTION_VAL_220_GA },
         { "230", OPTION_VAL_230_GA },
         { "240", OPTION_VAL_240_GA },
         { "250", OPTION_VAL_250_GA },
         { "260", OPTION_VAL_260_GA },
         { "270", OPTION_VAL_270_GA },
         { "280", OPTION_VAL_280_GA },
         { "290", OPTION_VAL_290_GA },
         { "300", OPTION_VAL_300_GA },
         { "310", OPTION_VAL_310_GA },
         { "320", OPTION_VAL_320_GA },
         { "330", OPTION_VAL_330_GA },
         { "340", OPTION_VAL_340_GA },
         { "350", OPTION_VAL_350_GA },
         { "360", OPTION_VAL_360_GA },
         { "370", OPTION_VAL_370_GA },
         { "380", OPTION_VAL_380_GA },
         { "390", OPTION_VAL_390_GA },
         { "400", OPTION_VAL_400_GA },
         { "410", OPTION_VAL_410_GA },
         { "420", OPTION_VAL_420_GA },
         { "430", OPTION_VAL_430_GA },
         { "440", OPTION_VAL_440_GA },
         { "450", OPTION_VAL_450_GA },
         { "460", OPTION_VAL_460_GA },
         { "470", OPTION_VAL_470_GA },
         { "480", OPTION_VAL_480_GA },
         { "490", OPTION_VAL_490_GA },
         { "500", OPTION_VAL_500_GA },
         { "510", OPTION_VAL_510_GA },
         { "520", OPTION_VAL_520_GA },
         { "530", OPTION_VAL_530_GA },
         { "540", OPTION_VAL_540_GA },
         { "550", OPTION_VAL_550_GA },
         { "560", OPTION_VAL_560_GA },
         { "570", OPTION_VAL_570_GA },
         { "580", OPTION_VAL_580_GA },
         { "590", OPTION_VAL_590_GA },
         { "600", OPTION_VAL_600_GA },
         { "610", OPTION_VAL_610_GA },
         { "620", OPTION_VAL_620_GA },
         { "630", OPTION_VAL_630_GA },
         { "640", OPTION_VAL_640_GA },
         { "650", OPTION_VAL_650_GA },
         { "660", OPTION_VAL_660_GA },
         { "670", OPTION_VAL_670_GA },
         { "680", OPTION_VAL_680_GA },
         { "690", OPTION_VAL_690_GA },
         { "700", OPTION_VAL_700_GA },
         { "710", OPTION_VAL_710_GA },
         { "720", OPTION_VAL_720_GA },
         { "730", OPTION_VAL_730_GA },
         { "740", OPTION_VAL_740_GA },
         { "750", OPTION_VAL_750_GA },
         { "760", OPTION_VAL_760_GA },
         { "770", OPTION_VAL_770_GA },
         { "780", OPTION_VAL_780_GA },
         { "790", OPTION_VAL_790_GA },
         { "800", OPTION_VAL_800_GA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_GA,
      NULL,
      BSNES_SGB_BIOS_INFO_0_GA,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_GA   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_GA },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_GA,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_GA,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_GA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_GA,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_GA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_GA,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ga = {
   option_cats_ga,
   option_defs_ga
};

/* RETRO_LANGUAGE_GL */

#define CATEGORY_VIDEO_LABEL_GL "Vídeo"
#define CATEGORY_VIDEO_INFO_0_GL "Cambia os axustes da saída de video."
#define CATEGORY_AUDIO_LABEL_GL "Son"
#define CATEGORY_AUDIO_INFO_0_GL "Cambia os axustes da saída de son."
#define CATEGORY_MODE7_LABEL_GL "Modo HD 7"
#define CATEGORY_MODE7_INFO_0_GL "Cambia a configuración relativa á emulación de gráficos do Modo 7."
#define CATEGORY_HACK_LABEL_GL "Trucos e melloras de emulación"
#define CATEGORY_HACK_INFO_0_GL "Aplica trucos, melloras e correccións de emulación."
#define CATEGORY_OVERCLOCK_LABEL_GL "Over/downclocking"
#define CATEGORY_OVERCLOCK_INFO_0_GL "Cambia a velocidade do hardware emulado."
#define CATEGORY_SGB_LABEL_GL NULL
#define CATEGORY_SGB_INFO_0_GL "Cambia a configuración relativa á emulación de Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_GL "Pistola lixeira"
#define CATEGORY_LIGHTGUN_INFO_0_GL "Cambiar a configuración da pistola de luz (pantalla táctil)."
#define BSNES_ASPECT_RATIO_LABEL_GL "Relación de aspecto preferida"
#define BSNES_ASPECT_RATIO_INFO_0_GL "Escolla a relación de aspecto do contido preferida. Isto só se aplicará cando a relación de aspecto de RetroArch estea definida como \"Núcleo proporcionado\" na configuración de vídeo."
#define OPTION_VAL_AUTO_GL NULL
#define OPTION_VAL_1_1_GL "1:1 PAR (Perfecto en pixels)"
#define OPTION_VAL_4_3_GL "4:3 DAR (Relación de Aspecto da Pantalla)"
#define OPTION_VAL_NTSC_GL NULL
#define OPTION_VAL_PAL_GL NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_GL "Recortar Overscan vertical"
#define BSNES_PPU_OVERSCAN_V_INFO_0_GL "Elimina N liñas da parte superior e inferior da pantalla para simular o marco dunha televisión da época de SNES."
#define OPTION_VAL_0_GL "0 liñas"
#define OPTION_VAL_8_GL "8 liñas"
#define OPTION_VAL_12_GL "12 liñas"
#define OPTION_VAL_16_GL "16 liñas"
#define BSNES_BLUR_EMULATION_LABEL_GL "Emulación de desenfoque"
#define BSNES_BLUR_EMULATION_INFO_0_GL "Simula a resolución horizontal limitada dos SDTV difuminando os píxeles adxacentes horizontalmente. Algúns xogos dependen diso para emular un efecto de transparencia."
#define BSNES_VIDEO_FILTER_LABEL_GL "Filtro"
#define BSNES_VIDEO_FILTER_INFO_0_GL "Escolla entre sen filtrado e o filtro NTSC de blargg con opcións para RF, Composite, S-Video ou RGB"
#define OPTION_VAL_NONE_GL "Ningún"
#define OPTION_VAL_NTSC_RF_GL NULL
#define OPTION_VAL_NTSC_COMPOSITE_GL "NTSC (composto)"
#define OPTION_VAL_NTSC_S_VIDEO_GL NULL
#define OPTION_VAL_NTSC_RGB_GL NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_GL "Axuste de Cor - Luminancia"
#define BSNES_VIDEO_LUMINANCE_INFO_0_GL "Axustar a Luminancia"
#define OPTION_VAL_0_O4_GL NULL
#define OPTION_VAL_10_GL NULL
#define OPTION_VAL_20_GL NULL
#define OPTION_VAL_30_GL NULL
#define OPTION_VAL_40_GL NULL
#define OPTION_VAL_50_GL NULL
#define OPTION_VAL_60_GL NULL
#define OPTION_VAL_70_GL NULL
#define OPTION_VAL_80_GL NULL
#define OPTION_VAL_90_GL NULL
#define OPTION_VAL_100_GL "100 % (predeterminado)"
#define BSNES_VIDEO_SATURATION_LABEL_GL "Axuste de Cor - Saturación"
#define BSNES_VIDEO_SATURATION_INFO_0_GL "Axustar a Saturación"
#define OPTION_VAL_110_GL NULL
#define OPTION_VAL_120_GL NULL
#define OPTION_VAL_130_GL NULL
#define OPTION_VAL_140_GL NULL
#define OPTION_VAL_150_GL NULL
#define OPTION_VAL_160_GL NULL
#define OPTION_VAL_170_GL NULL
#define OPTION_VAL_180_GL NULL
#define OPTION_VAL_190_GL NULL
#define OPTION_VAL_200_GL NULL
#define BSNES_VIDEO_GAMMA_LABEL_GL "Axuste de Cor - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_GL "Axustar Gamma"
#define OPTION_VAL_100_O6_GL NULL
#define OPTION_VAL_150_O6_GL "150 % (predeterminado)"
#define BSNES_PPU_FAST_LABEL_GL "PPU (vídeo) - Modo Rápido"
#define BSNES_PPU_FAST_LABEL_CAT_GL "PPU - Modo Rápido"
#define BSNES_PPU_FAST_INFO_0_GL "Permite unha emulación máis rápida da PPU a costa dunha pequena redución da precisión. Recoméndase deixar isto activado. NOTA: isto debe estar activado para que funcionen as opcións \"Desentrelazado\", \"Sen límite de Sprite\" e \"Modo HD 7\"."
#define BSNES_PPU_DEINTERLACE_LABEL_GL "PPU (Video) - Desentrelazado"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_GL "PPU - Desentrelazado"
#define BSNES_PPU_DEINTERLACE_INFO_0_GL "Desentrelaza todos os xogos renderizados internamente a 480p. A penalización de rendemento é case inexistente, polo que se recomenda deixar isto activado."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_GL "PPU (vídeo) - Sen límite de Sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_GL "PPU - Sen límite de Sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_GL "Elimina calquera límite ao número de sprites que se poden debuxar simultaneamente na pantalla. Pode causar problemas con algúns xogos."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_GL "PPU (vídeo) - sen bloqueo de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_GL "PPU - sen bloqueo de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_GL "Emular un erro en versións antigas de ZSNES e Snes9x, onde non se emulou o bloqueo de VRAM. Algúns pirateos de ROM máis antigos confiaron neste comportamento e mostrarán os gráficos de forma incorrecta se non está activado. Esta opción é extremadamente imprecisa e prexudica a velocidade da PPU, polo que recoméndase deixala desactivada a non ser que necesites xogar a un xogo que sexa doutro xeito incompatible con este núcleo."
#define BSNES_DSP_FAST_LABEL_GL "DSP (Audio) - Modo rápido"
#define BSNES_DSP_FAST_LABEL_CAT_GL "DSP - Modo rápido"
#define BSNES_DSP_FAST_INFO_0_GL "Permite unha emulación máis rápida do DSP a costa dunha pequena redución da precisión. Recoméndase deixar isto activado."
#define BSNES_DSP_CUBIC_LABEL_GL "DSP (Audio) - Interpolación cúbica"
#define BSNES_DSP_CUBIC_LABEL_CAT_GL "DSP - Interpolación cúbica"
#define BSNES_DSP_CUBIC_INFO_0_GL "Aplica a interpolación cúbica ao son, conservando máis a gama alta."
#define BSNES_DSP_ECHO_SHADOW_LABEL_GL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_GL NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_GL "Emular un erro en ZSNES onde a RAM de eco foi tratada como separada da RAM da APU. Moitos pirateos de ROM máis antigos para Super Mario World confiaban neste comportamento e fallarán sen iso. Esta opción é moi imprecisa e non debería activarse a non ser que sexa necesario."
#define BSNES_MODE7_SCALE_LABEL_GL "Modo HD 7 - Escala"
#define BSNES_MODE7_SCALE_LABEL_CAT_GL "Escala"
#define BSNES_MODE7_SCALE_INFO_0_GL "Aumenta a resolución horizontal e vertical dos gráficos do Modo 7 usados en determinados xogos."
#define OPTION_VAL_1X_GL NULL
#define OPTION_VAL_2X_GL NULL
#define OPTION_VAL_3X_GL NULL
#define OPTION_VAL_4X_GL NULL
#define OPTION_VAL_5X_GL NULL
#define OPTION_VAL_6X_GL NULL
#define OPTION_VAL_7X_GL NULL
#define OPTION_VAL_8X_GL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_GL "Modo HD 7 - Corrección de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_GL "Corrección de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_GL "Corrixe a perspectiva dos gráficos do Modo 7 utilizados en determinados xogos traballando sobre algunhas limitacións das matemáticas enteiras utilizadas pola SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_GL "Modo HD 7 - Supermostraxe"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_GL "Supermostraxe"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_GL "Mostra os gráficos do Modo 7 usados en determinados xogos. Combinado con factores de escala Modo 7 máis altos, produce un efecto similar ao anti-aliasing."
#define BSNES_MODE7_MOSAIC_LABEL_GL "Modo HD 7 - HD->SD Mosaico"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_GL "HD->SD Mosaico"
#define BSNES_MODE7_MOSAIC_INFO_0_GL "Mostra o efecto de mosaico dos gráficos do Modo 7 mesmo ao escalalos."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_GL "Run-Ahead interno"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_GL "Simula o sistema con antelación e retrocede para reducir a latencia de entrada. Ten requisitos de sistema moi elevados."
#define OPTION_VAL_1_GL "1 fotograma"
#define OPTION_VAL_2_GL "2 fotogramas"
#define OPTION_VAL_3_GL "3 fotogramas"
#define OPTION_VAL_4_GL "4 fotogramas"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_GL "Coprocesadores - Modo rápido"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_GL "Permite unha emulación máis rápida dos coprocesadores a costa dunha pequena redución da precisión. Recoméndase deixar isto activado."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_GL "Coprocesadores - Prefire HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_GL "Cando se habilita esta opción, sempre se utilizará unha emulación HLE menos precisa cando estea dispoñible. Se está desactivado, HLE só se utilizará cando falte o firmware LLE."
#define BSNES_HOTFIXES_LABEL_GL "Correccións rápidas"
#define BSNES_HOTFIXES_INFO_0_GL "Incluso o software con licenza comercial e lanzado oficialmente ás veces se envía con erros. Esta opción corrixirá certos problemas que ocorreron incluso no hardware real."
#define BSNES_ENTROPY_LABEL_GL "Entropía (aleatorización)"
#define BSNES_ENTROPY_INFO_0_GL "Escolla o nivel de aleatorización da memoria e dos rexistros. Se se establece en None, toda a memoria e os rexistros inicialízanse a valores constantes no inicio. A aleatorización baixa proporciona a representación máis precisa dun sistema real. Alto aleatoriza na medida do posible."
#define OPTION_VAL_LOW_GL "Baixo"
#define OPTION_VAL_HIGH_GL "Alto"
#define BSNES_CPU_FASTMATH_LABEL_GL "Matemáticas rápidas de CPU"
#define BSNES_CPU_FASTMATH_INFO_0_GL "Proporcione los resultados del cálculo de inmediato. La multiplicación y división de CPU lleva tiempo completarse en una SNES real. Los emuladores más antiguos no simulaban estos retrasos y, por lo tanto, algunos hacks de ROM más antiguos no esperan a que se completen las operaciones matemáticas y necesitan este hack."
#define BSNES_CPU_OVERCLOCK_LABEL_GL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_GL NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_GL "Overclock ou downclock da CPU. Establecer este valor por encima do 100 % pode reducir os tempos de carga e eliminar a ralentización. Use con precaución, xa que tamén pode provocar que algúns xogos se colapsen ou presenten outros problemas."
#define OPTION_VAL_210_GL NULL
#define OPTION_VAL_220_GL NULL
#define OPTION_VAL_230_GL NULL
#define OPTION_VAL_240_GL NULL
#define OPTION_VAL_250_GL NULL
#define OPTION_VAL_260_GL NULL
#define OPTION_VAL_270_GL NULL
#define OPTION_VAL_280_GL NULL
#define OPTION_VAL_290_GL NULL
#define OPTION_VAL_300_GL NULL
#define OPTION_VAL_310_GL NULL
#define OPTION_VAL_320_GL NULL
#define OPTION_VAL_330_GL NULL
#define OPTION_VAL_340_GL NULL
#define OPTION_VAL_350_GL NULL
#define OPTION_VAL_360_GL NULL
#define OPTION_VAL_370_GL NULL
#define OPTION_VAL_380_GL NULL
#define OPTION_VAL_390_GL NULL
#define OPTION_VAL_400_GL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_GL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_GL NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_GL "Overclock ou downclock do chip Super Accelerator 1 (SA-1). Establecer este valor por encima do 100 % pode mellorar o rendemento nos xogos que admiten o chip SA-1. Úsao con precaución, xa que tamén pode provocar que algúns xogos fallen ou que presenten outros problemas."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_GL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_GL NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_GL "Overclock ou downclock do coprocesador SuperFX. Establecer este valor por encima do 100 % pode mellorar o rendemento nos xogos compatibles con SuperFX. Úsao con precaución, xa que tamén pode provocar que algúns xogos fallen ou que presenten outros problemas."
#define OPTION_VAL_410_GL NULL
#define OPTION_VAL_420_GL NULL
#define OPTION_VAL_430_GL NULL
#define OPTION_VAL_440_GL NULL
#define OPTION_VAL_450_GL NULL
#define OPTION_VAL_460_GL NULL
#define OPTION_VAL_470_GL NULL
#define OPTION_VAL_480_GL NULL
#define OPTION_VAL_490_GL NULL
#define OPTION_VAL_500_GL NULL
#define OPTION_VAL_510_GL NULL
#define OPTION_VAL_520_GL NULL
#define OPTION_VAL_530_GL NULL
#define OPTION_VAL_540_GL NULL
#define OPTION_VAL_550_GL NULL
#define OPTION_VAL_560_GL NULL
#define OPTION_VAL_570_GL NULL
#define OPTION_VAL_580_GL NULL
#define OPTION_VAL_590_GL NULL
#define OPTION_VAL_600_GL NULL
#define OPTION_VAL_610_GL NULL
#define OPTION_VAL_620_GL NULL
#define OPTION_VAL_630_GL NULL
#define OPTION_VAL_640_GL NULL
#define OPTION_VAL_650_GL NULL
#define OPTION_VAL_660_GL NULL
#define OPTION_VAL_670_GL NULL
#define OPTION_VAL_680_GL NULL
#define OPTION_VAL_690_GL NULL
#define OPTION_VAL_700_GL NULL
#define OPTION_VAL_710_GL NULL
#define OPTION_VAL_720_GL NULL
#define OPTION_VAL_730_GL NULL
#define OPTION_VAL_740_GL NULL
#define OPTION_VAL_750_GL NULL
#define OPTION_VAL_760_GL NULL
#define OPTION_VAL_770_GL NULL
#define OPTION_VAL_780_GL NULL
#define OPTION_VAL_790_GL NULL
#define OPTION_VAL_800_GL NULL
#define BSNES_SGB_BIOS_LABEL_GL "BIOS de Super Game Boy preferido (reinicio necesario)"
#define BSNES_SGB_BIOS_INFO_0_GL "Escolle a BIOS de Super Game Boy preferida para usar con títulos compatibles."
#define OPTION_VAL_SGB1_SFC_GL NULL
#define OPTION_VAL_SGB2_SFC_GL NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_GL "Ocultar o bordo SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_GL "Ocultar o marco ao xogar a xogos de Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_GL "Pistola de luz con pantalla táctil"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_GL "Activa a entrada de Super Scope para dispositivos con pantalla táctil."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_GL "Botóns de disparo inverso de Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_GL "Invirte o disparador e os botóns do cursor do Super Scope coa pistola lixeira da pantalla táctil."

struct retro_core_option_v2_category option_cats_gl[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_GL,
      CATEGORY_VIDEO_INFO_0_GL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_GL,
      CATEGORY_AUDIO_INFO_0_GL
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_GL,
      CATEGORY_MODE7_INFO_0_GL
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_GL,
      CATEGORY_HACK_INFO_0_GL
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_GL,
      CATEGORY_OVERCLOCK_INFO_0_GL
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_GL,
      CATEGORY_SGB_INFO_0_GL
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_GL,
      CATEGORY_LIGHTGUN_INFO_0_GL
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_gl[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_GL,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_GL,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_GL },
         { "1:1",  OPTION_VAL_1_1_GL },
         { "4:3",  OPTION_VAL_4_3_GL },
         { "NTSC", OPTION_VAL_NTSC_GL },
         { "PAL",  OPTION_VAL_PAL_GL },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_GL,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_GL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_GL },
         { "8",  OPTION_VAL_8_GL },
         { "12", OPTION_VAL_12_GL },
         { "16", OPTION_VAL_16_GL },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_GL,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_GL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_GL,
      BSNES_VIDEO_FILTER_LABEL_GL,
      BSNES_VIDEO_FILTER_INFO_0_GL,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_GL },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_GL },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_GL },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_GL },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_GL },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_GL,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_GL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_GL },
         { "10", OPTION_VAL_10_GL },
         { "20", OPTION_VAL_20_GL },
         { "30", OPTION_VAL_30_GL },
         { "40", OPTION_VAL_40_GL },
         { "50", OPTION_VAL_50_GL },
         { "60", OPTION_VAL_60_GL },
         { "70", OPTION_VAL_70_GL },
         { "80", OPTION_VAL_80_GL },
         { "90", OPTION_VAL_90_GL },
         { "100", OPTION_VAL_100_GL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_GL,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_GL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_GL },
         { "10", OPTION_VAL_10_GL },
         { "20", OPTION_VAL_20_GL },
         { "30", OPTION_VAL_30_GL },
         { "40", OPTION_VAL_40_GL },
         { "50", OPTION_VAL_50_GL },
         { "60", OPTION_VAL_60_GL },
         { "70", OPTION_VAL_70_GL },
         { "80", OPTION_VAL_80_GL },
         { "90", OPTION_VAL_90_GL },
         { "100", OPTION_VAL_100_GL },
         { "110", OPTION_VAL_110_GL },
         { "120", OPTION_VAL_120_GL },
         { "130", OPTION_VAL_130_GL },
         { "140", OPTION_VAL_140_GL },
         { "150", OPTION_VAL_150_GL },
         { "160", OPTION_VAL_160_GL },
         { "170", OPTION_VAL_170_GL },
         { "180", OPTION_VAL_180_GL },
         { "190", OPTION_VAL_190_GL },
         { "200", OPTION_VAL_200_GL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_GL,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_GL,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_GL },
         { "110", OPTION_VAL_110_GL },
         { "120", OPTION_VAL_120_GL },
         { "130", OPTION_VAL_130_GL },
         { "140", OPTION_VAL_140_GL },
         { "150", OPTION_VAL_150_O6_GL },
         { "160", OPTION_VAL_160_GL },
         { "170", OPTION_VAL_170_GL },
         { "180", OPTION_VAL_180_GL },
         { "190", OPTION_VAL_190_GL },
         { "200", OPTION_VAL_200_GL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_GL,
      BSNES_PPU_FAST_LABEL_CAT_GL,
      BSNES_PPU_FAST_INFO_0_GL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_GL,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_GL,
      BSNES_PPU_DEINTERLACE_INFO_0_GL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_GL,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_GL,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_GL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_GL,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_GL,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_GL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_GL,
      BSNES_DSP_FAST_LABEL_CAT_GL,
      BSNES_DSP_FAST_INFO_0_GL,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_GL,
      BSNES_DSP_CUBIC_LABEL_CAT_GL,
      BSNES_DSP_CUBIC_INFO_0_GL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_GL,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_GL,
      BSNES_DSP_ECHO_SHADOW_INFO_0_GL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_GL,
      BSNES_MODE7_SCALE_LABEL_CAT_GL,
      BSNES_MODE7_SCALE_INFO_0_GL,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_GL  },
         { "2x", OPTION_VAL_2X_GL  },
         { "3x", OPTION_VAL_3X_GL  },
         { "4x", OPTION_VAL_4X_GL  },
         { "5x", OPTION_VAL_5X_GL },
         { "6x", OPTION_VAL_6X_GL },
         { "7x", OPTION_VAL_7X_GL },
         { "8x", OPTION_VAL_8X_GL },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_GL,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_GL,
      BSNES_MODE7_PERSPECTIVE_INFO_0_GL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_GL,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_GL,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_GL,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_GL,
      BSNES_MODE7_MOSAIC_LABEL_CAT_GL,
      BSNES_MODE7_MOSAIC_INFO_0_GL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_GL,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_GL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_GL  },
         { "2",   OPTION_VAL_2_GL },
         { "3",   OPTION_VAL_3_GL },
         { "4",   OPTION_VAL_4_GL },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_GL,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_GL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_GL,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_GL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_GL,
      NULL,
      BSNES_HOTFIXES_INFO_0_GL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_GL,
      NULL,
      BSNES_ENTROPY_INFO_0_GL,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_GL },
         { "High", OPTION_VAL_HIGH_GL },
         { "None", OPTION_VAL_NONE_GL },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_GL,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_GL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_GL,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_GL,
      BSNES_CPU_OVERCLOCK_INFO_0_GL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GL  },
         { "20",  OPTION_VAL_20_GL  },
         { "30",  OPTION_VAL_30_GL  },
         { "40",  OPTION_VAL_40_GL  },
         { "50",  OPTION_VAL_50_GL  },
         { "60",  OPTION_VAL_60_GL  },
         { "70",  OPTION_VAL_70_GL  },
         { "80",  OPTION_VAL_80_GL  },
         { "90",  OPTION_VAL_90_GL  },
         { "100", OPTION_VAL_100_GL },
         { "110", OPTION_VAL_110_GL },
         { "120", OPTION_VAL_120_GL },
         { "130", OPTION_VAL_130_GL },
         { "140", OPTION_VAL_140_GL },
         { "150", OPTION_VAL_150_GL },
         { "160", OPTION_VAL_160_GL },
         { "170", OPTION_VAL_170_GL },
         { "180", OPTION_VAL_180_GL },
         { "190", OPTION_VAL_190_GL },
         { "200", OPTION_VAL_200_GL },
         { "210", OPTION_VAL_210_GL },
         { "220", OPTION_VAL_220_GL },
         { "230", OPTION_VAL_230_GL },
         { "240", OPTION_VAL_240_GL },
         { "250", OPTION_VAL_250_GL },
         { "260", OPTION_VAL_260_GL },
         { "270", OPTION_VAL_270_GL },
         { "280", OPTION_VAL_280_GL },
         { "290", OPTION_VAL_290_GL },
         { "300", OPTION_VAL_300_GL },
         { "310", OPTION_VAL_310_GL },
         { "320", OPTION_VAL_320_GL },
         { "330", OPTION_VAL_330_GL },
         { "340", OPTION_VAL_340_GL },
         { "350", OPTION_VAL_350_GL },
         { "360", OPTION_VAL_360_GL },
         { "370", OPTION_VAL_370_GL },
         { "380", OPTION_VAL_380_GL },
         { "390", OPTION_VAL_390_GL },
         { "400", OPTION_VAL_400_GL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_GL,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_GL,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_GL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GL  },
         { "20",  OPTION_VAL_20_GL  },
         { "30",  OPTION_VAL_30_GL  },
         { "40",  OPTION_VAL_40_GL  },
         { "50",  OPTION_VAL_50_GL  },
         { "60",  OPTION_VAL_60_GL  },
         { "70",  OPTION_VAL_70_GL  },
         { "80",  OPTION_VAL_80_GL  },
         { "90",  OPTION_VAL_90_GL  },
         { "100", OPTION_VAL_100_GL },
         { "110", OPTION_VAL_110_GL },
         { "120", OPTION_VAL_120_GL },
         { "130", OPTION_VAL_130_GL },
         { "140", OPTION_VAL_140_GL },
         { "150", OPTION_VAL_150_GL },
         { "160", OPTION_VAL_160_GL },
         { "170", OPTION_VAL_170_GL },
         { "180", OPTION_VAL_180_GL },
         { "190", OPTION_VAL_190_GL },
         { "200", OPTION_VAL_200_GL },
         { "210", OPTION_VAL_210_GL },
         { "220", OPTION_VAL_220_GL },
         { "230", OPTION_VAL_230_GL },
         { "240", OPTION_VAL_240_GL },
         { "250", OPTION_VAL_250_GL },
         { "260", OPTION_VAL_260_GL },
         { "270", OPTION_VAL_270_GL },
         { "280", OPTION_VAL_280_GL },
         { "290", OPTION_VAL_290_GL },
         { "300", OPTION_VAL_300_GL },
         { "310", OPTION_VAL_310_GL },
         { "320", OPTION_VAL_320_GL },
         { "330", OPTION_VAL_330_GL },
         { "340", OPTION_VAL_340_GL },
         { "350", OPTION_VAL_350_GL },
         { "360", OPTION_VAL_360_GL },
         { "370", OPTION_VAL_370_GL },
         { "380", OPTION_VAL_380_GL },
         { "390", OPTION_VAL_390_GL },
         { "400", OPTION_VAL_400_GL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_GL,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_GL,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_GL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_GL  },
         { "20",  OPTION_VAL_20_GL  },
         { "30",  OPTION_VAL_30_GL  },
         { "40",  OPTION_VAL_40_GL  },
         { "50",  OPTION_VAL_50_GL  },
         { "60",  OPTION_VAL_60_GL  },
         { "70",  OPTION_VAL_70_GL  },
         { "80",  OPTION_VAL_80_GL  },
         { "90",  OPTION_VAL_90_GL  },
         { "100", OPTION_VAL_100_GL },
         { "110", OPTION_VAL_110_GL },
         { "120", OPTION_VAL_120_GL },
         { "130", OPTION_VAL_130_GL },
         { "140", OPTION_VAL_140_GL },
         { "150", OPTION_VAL_150_GL },
         { "160", OPTION_VAL_160_GL },
         { "170", OPTION_VAL_170_GL },
         { "180", OPTION_VAL_180_GL },
         { "190", OPTION_VAL_190_GL },
         { "200", OPTION_VAL_200_GL },
         { "210", OPTION_VAL_210_GL },
         { "220", OPTION_VAL_220_GL },
         { "230", OPTION_VAL_230_GL },
         { "240", OPTION_VAL_240_GL },
         { "250", OPTION_VAL_250_GL },
         { "260", OPTION_VAL_260_GL },
         { "270", OPTION_VAL_270_GL },
         { "280", OPTION_VAL_280_GL },
         { "290", OPTION_VAL_290_GL },
         { "300", OPTION_VAL_300_GL },
         { "310", OPTION_VAL_310_GL },
         { "320", OPTION_VAL_320_GL },
         { "330", OPTION_VAL_330_GL },
         { "340", OPTION_VAL_340_GL },
         { "350", OPTION_VAL_350_GL },
         { "360", OPTION_VAL_360_GL },
         { "370", OPTION_VAL_370_GL },
         { "380", OPTION_VAL_380_GL },
         { "390", OPTION_VAL_390_GL },
         { "400", OPTION_VAL_400_GL },
         { "410", OPTION_VAL_410_GL },
         { "420", OPTION_VAL_420_GL },
         { "430", OPTION_VAL_430_GL },
         { "440", OPTION_VAL_440_GL },
         { "450", OPTION_VAL_450_GL },
         { "460", OPTION_VAL_460_GL },
         { "470", OPTION_VAL_470_GL },
         { "480", OPTION_VAL_480_GL },
         { "490", OPTION_VAL_490_GL },
         { "500", OPTION_VAL_500_GL },
         { "510", OPTION_VAL_510_GL },
         { "520", OPTION_VAL_520_GL },
         { "530", OPTION_VAL_530_GL },
         { "540", OPTION_VAL_540_GL },
         { "550", OPTION_VAL_550_GL },
         { "560", OPTION_VAL_560_GL },
         { "570", OPTION_VAL_570_GL },
         { "580", OPTION_VAL_580_GL },
         { "590", OPTION_VAL_590_GL },
         { "600", OPTION_VAL_600_GL },
         { "610", OPTION_VAL_610_GL },
         { "620", OPTION_VAL_620_GL },
         { "630", OPTION_VAL_630_GL },
         { "640", OPTION_VAL_640_GL },
         { "650", OPTION_VAL_650_GL },
         { "660", OPTION_VAL_660_GL },
         { "670", OPTION_VAL_670_GL },
         { "680", OPTION_VAL_680_GL },
         { "690", OPTION_VAL_690_GL },
         { "700", OPTION_VAL_700_GL },
         { "710", OPTION_VAL_710_GL },
         { "720", OPTION_VAL_720_GL },
         { "730", OPTION_VAL_730_GL },
         { "740", OPTION_VAL_740_GL },
         { "750", OPTION_VAL_750_GL },
         { "760", OPTION_VAL_760_GL },
         { "770", OPTION_VAL_770_GL },
         { "780", OPTION_VAL_780_GL },
         { "790", OPTION_VAL_790_GL },
         { "800", OPTION_VAL_800_GL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_GL,
      NULL,
      BSNES_SGB_BIOS_INFO_0_GL,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_GL   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_GL },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_GL,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_GL,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_GL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_GL,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_GL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_GL,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_gl = {
   option_cats_gl,
   option_defs_gl
};

/* RETRO_LANGUAGE_HE */

#define CATEGORY_VIDEO_LABEL_HE "וידאו"
#define CATEGORY_VIDEO_INFO_0_HE NULL
#define CATEGORY_AUDIO_LABEL_HE "שמע"
#define CATEGORY_AUDIO_INFO_0_HE NULL
#define CATEGORY_MODE7_LABEL_HE NULL
#define CATEGORY_MODE7_INFO_0_HE NULL
#define CATEGORY_HACK_LABEL_HE NULL
#define CATEGORY_HACK_INFO_0_HE NULL
#define CATEGORY_OVERCLOCK_LABEL_HE NULL
#define CATEGORY_OVERCLOCK_INFO_0_HE NULL
#define CATEGORY_SGB_LABEL_HE NULL
#define CATEGORY_SGB_INFO_0_HE NULL
#define CATEGORY_LIGHTGUN_LABEL_HE NULL
#define CATEGORY_LIGHTGUN_INFO_0_HE NULL
#define BSNES_ASPECT_RATIO_LABEL_HE NULL
#define BSNES_ASPECT_RATIO_INFO_0_HE NULL
#define OPTION_VAL_AUTO_HE NULL
#define OPTION_VAL_1_1_HE NULL
#define OPTION_VAL_4_3_HE NULL
#define OPTION_VAL_NTSC_HE NULL
#define OPTION_VAL_PAL_HE NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_HE NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_HE NULL
#define OPTION_VAL_0_HE NULL
#define OPTION_VAL_8_HE NULL
#define OPTION_VAL_12_HE NULL
#define OPTION_VAL_16_HE NULL
#define BSNES_BLUR_EMULATION_LABEL_HE NULL
#define BSNES_BLUR_EMULATION_INFO_0_HE NULL
#define BSNES_VIDEO_FILTER_LABEL_HE NULL
#define BSNES_VIDEO_FILTER_INFO_0_HE NULL
#define OPTION_VAL_NONE_HE NULL
#define OPTION_VAL_NTSC_RF_HE NULL
#define OPTION_VAL_NTSC_COMPOSITE_HE NULL
#define OPTION_VAL_NTSC_S_VIDEO_HE NULL
#define OPTION_VAL_NTSC_RGB_HE NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_HE NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_HE NULL
#define OPTION_VAL_0_O4_HE NULL
#define OPTION_VAL_10_HE NULL
#define OPTION_VAL_20_HE NULL
#define OPTION_VAL_30_HE NULL
#define OPTION_VAL_40_HE NULL
#define OPTION_VAL_50_HE NULL
#define OPTION_VAL_60_HE NULL
#define OPTION_VAL_70_HE NULL
#define OPTION_VAL_80_HE NULL
#define OPTION_VAL_90_HE NULL
#define OPTION_VAL_100_HE NULL
#define BSNES_VIDEO_SATURATION_LABEL_HE NULL
#define BSNES_VIDEO_SATURATION_INFO_0_HE NULL
#define OPTION_VAL_110_HE NULL
#define OPTION_VAL_120_HE NULL
#define OPTION_VAL_130_HE NULL
#define OPTION_VAL_140_HE NULL
#define OPTION_VAL_150_HE NULL
#define OPTION_VAL_160_HE NULL
#define OPTION_VAL_170_HE NULL
#define OPTION_VAL_180_HE NULL
#define OPTION_VAL_190_HE NULL
#define OPTION_VAL_200_HE NULL
#define BSNES_VIDEO_GAMMA_LABEL_HE NULL
#define BSNES_VIDEO_GAMMA_INFO_0_HE NULL
#define OPTION_VAL_100_O6_HE NULL
#define OPTION_VAL_150_O6_HE NULL
#define BSNES_PPU_FAST_LABEL_HE NULL
#define BSNES_PPU_FAST_LABEL_CAT_HE NULL
#define BSNES_PPU_FAST_INFO_0_HE NULL
#define BSNES_PPU_DEINTERLACE_LABEL_HE NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_HE NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_HE NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HE NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HE NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HE NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HE NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HE NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HE NULL
#define BSNES_DSP_FAST_LABEL_HE NULL
#define BSNES_DSP_FAST_LABEL_CAT_HE NULL
#define BSNES_DSP_FAST_INFO_0_HE NULL
#define BSNES_DSP_CUBIC_LABEL_HE NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_HE NULL
#define BSNES_DSP_CUBIC_INFO_0_HE NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_HE NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HE NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_HE NULL
#define BSNES_MODE7_SCALE_LABEL_HE NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_HE NULL
#define BSNES_MODE7_SCALE_INFO_0_HE NULL
#define OPTION_VAL_1X_HE NULL
#define OPTION_VAL_2X_HE NULL
#define OPTION_VAL_3X_HE NULL
#define OPTION_VAL_4X_HE NULL
#define OPTION_VAL_5X_HE NULL
#define OPTION_VAL_6X_HE NULL
#define OPTION_VAL_7X_HE NULL
#define OPTION_VAL_8X_HE NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_HE NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HE NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_HE NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_HE NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HE NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_HE NULL
#define BSNES_MODE7_MOSAIC_LABEL_HE NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_HE NULL
#define BSNES_MODE7_MOSAIC_INFO_0_HE NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_HE NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_HE NULL
#define OPTION_VAL_1_HE NULL
#define OPTION_VAL_2_HE NULL
#define OPTION_VAL_3_HE NULL
#define OPTION_VAL_4_HE NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HE NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HE NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_HE NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HE NULL
#define BSNES_HOTFIXES_LABEL_HE NULL
#define BSNES_HOTFIXES_INFO_0_HE NULL
#define BSNES_ENTROPY_LABEL_HE NULL
#define BSNES_ENTROPY_INFO_0_HE NULL
#define OPTION_VAL_LOW_HE NULL
#define OPTION_VAL_HIGH_HE NULL
#define BSNES_CPU_FASTMATH_LABEL_HE NULL
#define BSNES_CPU_FASTMATH_INFO_0_HE NULL
#define BSNES_CPU_OVERCLOCK_LABEL_HE NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_HE NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_HE NULL
#define OPTION_VAL_210_HE NULL
#define OPTION_VAL_220_HE NULL
#define OPTION_VAL_230_HE NULL
#define OPTION_VAL_240_HE NULL
#define OPTION_VAL_250_HE NULL
#define OPTION_VAL_260_HE NULL
#define OPTION_VAL_270_HE NULL
#define OPTION_VAL_280_HE NULL
#define OPTION_VAL_290_HE NULL
#define OPTION_VAL_300_HE NULL
#define OPTION_VAL_310_HE NULL
#define OPTION_VAL_320_HE NULL
#define OPTION_VAL_330_HE NULL
#define OPTION_VAL_340_HE NULL
#define OPTION_VAL_350_HE NULL
#define OPTION_VAL_360_HE NULL
#define OPTION_VAL_370_HE NULL
#define OPTION_VAL_380_HE NULL
#define OPTION_VAL_390_HE NULL
#define OPTION_VAL_400_HE NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_HE NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HE NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_HE NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_HE NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HE NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_HE NULL
#define OPTION_VAL_410_HE NULL
#define OPTION_VAL_420_HE NULL
#define OPTION_VAL_430_HE NULL
#define OPTION_VAL_440_HE NULL
#define OPTION_VAL_450_HE NULL
#define OPTION_VAL_460_HE NULL
#define OPTION_VAL_470_HE NULL
#define OPTION_VAL_480_HE NULL
#define OPTION_VAL_490_HE NULL
#define OPTION_VAL_500_HE NULL
#define OPTION_VAL_510_HE NULL
#define OPTION_VAL_520_HE NULL
#define OPTION_VAL_530_HE NULL
#define OPTION_VAL_540_HE NULL
#define OPTION_VAL_550_HE NULL
#define OPTION_VAL_560_HE NULL
#define OPTION_VAL_570_HE NULL
#define OPTION_VAL_580_HE NULL
#define OPTION_VAL_590_HE NULL
#define OPTION_VAL_600_HE NULL
#define OPTION_VAL_610_HE NULL
#define OPTION_VAL_620_HE NULL
#define OPTION_VAL_630_HE NULL
#define OPTION_VAL_640_HE NULL
#define OPTION_VAL_650_HE NULL
#define OPTION_VAL_660_HE NULL
#define OPTION_VAL_670_HE NULL
#define OPTION_VAL_680_HE NULL
#define OPTION_VAL_690_HE NULL
#define OPTION_VAL_700_HE NULL
#define OPTION_VAL_710_HE NULL
#define OPTION_VAL_720_HE NULL
#define OPTION_VAL_730_HE NULL
#define OPTION_VAL_740_HE NULL
#define OPTION_VAL_750_HE NULL
#define OPTION_VAL_760_HE NULL
#define OPTION_VAL_770_HE NULL
#define OPTION_VAL_780_HE NULL
#define OPTION_VAL_790_HE NULL
#define OPTION_VAL_800_HE NULL
#define BSNES_SGB_BIOS_LABEL_HE NULL
#define BSNES_SGB_BIOS_INFO_0_HE NULL
#define OPTION_VAL_SGB1_SFC_HE NULL
#define OPTION_VAL_SGB2_SFC_HE NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_HE NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_HE NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HE NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HE NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HE NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HE NULL

struct retro_core_option_v2_category option_cats_he[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_HE,
      CATEGORY_VIDEO_INFO_0_HE
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HE,
      CATEGORY_AUDIO_INFO_0_HE
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_HE,
      CATEGORY_MODE7_INFO_0_HE
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_HE,
      CATEGORY_HACK_INFO_0_HE
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_HE,
      CATEGORY_OVERCLOCK_INFO_0_HE
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_HE,
      CATEGORY_SGB_INFO_0_HE
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_HE,
      CATEGORY_LIGHTGUN_INFO_0_HE
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_he[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_HE,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_HE,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_HE },
         { "1:1",  OPTION_VAL_1_1_HE },
         { "4:3",  OPTION_VAL_4_3_HE },
         { "NTSC", OPTION_VAL_NTSC_HE },
         { "PAL",  OPTION_VAL_PAL_HE },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_HE,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_HE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_HE },
         { "8",  OPTION_VAL_8_HE },
         { "12", OPTION_VAL_12_HE },
         { "16", OPTION_VAL_16_HE },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_HE,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_HE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_HE,
      BSNES_VIDEO_FILTER_LABEL_HE,
      BSNES_VIDEO_FILTER_INFO_0_HE,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_HE },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_HE },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_HE },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_HE },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_HE },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_HE,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_HE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HE },
         { "10", OPTION_VAL_10_HE },
         { "20", OPTION_VAL_20_HE },
         { "30", OPTION_VAL_30_HE },
         { "40", OPTION_VAL_40_HE },
         { "50", OPTION_VAL_50_HE },
         { "60", OPTION_VAL_60_HE },
         { "70", OPTION_VAL_70_HE },
         { "80", OPTION_VAL_80_HE },
         { "90", OPTION_VAL_90_HE },
         { "100", OPTION_VAL_100_HE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_HE,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_HE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HE },
         { "10", OPTION_VAL_10_HE },
         { "20", OPTION_VAL_20_HE },
         { "30", OPTION_VAL_30_HE },
         { "40", OPTION_VAL_40_HE },
         { "50", OPTION_VAL_50_HE },
         { "60", OPTION_VAL_60_HE },
         { "70", OPTION_VAL_70_HE },
         { "80", OPTION_VAL_80_HE },
         { "90", OPTION_VAL_90_HE },
         { "100", OPTION_VAL_100_HE },
         { "110", OPTION_VAL_110_HE },
         { "120", OPTION_VAL_120_HE },
         { "130", OPTION_VAL_130_HE },
         { "140", OPTION_VAL_140_HE },
         { "150", OPTION_VAL_150_HE },
         { "160", OPTION_VAL_160_HE },
         { "170", OPTION_VAL_170_HE },
         { "180", OPTION_VAL_180_HE },
         { "190", OPTION_VAL_190_HE },
         { "200", OPTION_VAL_200_HE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_HE,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_HE,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_HE },
         { "110", OPTION_VAL_110_HE },
         { "120", OPTION_VAL_120_HE },
         { "130", OPTION_VAL_130_HE },
         { "140", OPTION_VAL_140_HE },
         { "150", OPTION_VAL_150_O6_HE },
         { "160", OPTION_VAL_160_HE },
         { "170", OPTION_VAL_170_HE },
         { "180", OPTION_VAL_180_HE },
         { "190", OPTION_VAL_190_HE },
         { "200", OPTION_VAL_200_HE },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_HE,
      BSNES_PPU_FAST_LABEL_CAT_HE,
      BSNES_PPU_FAST_INFO_0_HE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_HE,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_HE,
      BSNES_PPU_DEINTERLACE_INFO_0_HE,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HE,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HE,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HE,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HE,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HE,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_HE,
      BSNES_DSP_FAST_LABEL_CAT_HE,
      BSNES_DSP_FAST_INFO_0_HE,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_HE,
      BSNES_DSP_CUBIC_LABEL_CAT_HE,
      BSNES_DSP_CUBIC_INFO_0_HE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_HE,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HE,
      BSNES_DSP_ECHO_SHADOW_INFO_0_HE,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_HE,
      BSNES_MODE7_SCALE_LABEL_CAT_HE,
      BSNES_MODE7_SCALE_INFO_0_HE,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_HE  },
         { "2x", OPTION_VAL_2X_HE  },
         { "3x", OPTION_VAL_3X_HE  },
         { "4x", OPTION_VAL_4X_HE  },
         { "5x", OPTION_VAL_5X_HE },
         { "6x", OPTION_VAL_6X_HE },
         { "7x", OPTION_VAL_7X_HE },
         { "8x", OPTION_VAL_8X_HE },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_HE,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HE,
      BSNES_MODE7_PERSPECTIVE_INFO_0_HE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_HE,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HE,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_HE,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_HE,
      BSNES_MODE7_MOSAIC_LABEL_CAT_HE,
      BSNES_MODE7_MOSAIC_INFO_0_HE,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_HE,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_HE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_HE  },
         { "2",   OPTION_VAL_2_HE },
         { "3",   OPTION_VAL_3_HE },
         { "4",   OPTION_VAL_4_HE },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HE,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_HE,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HE,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_HE,
      NULL,
      BSNES_HOTFIXES_INFO_0_HE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_HE,
      NULL,
      BSNES_ENTROPY_INFO_0_HE,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_HE },
         { "High", OPTION_VAL_HIGH_HE },
         { "None", OPTION_VAL_NONE_HE },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_HE,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_HE,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_HE,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_HE,
      BSNES_CPU_OVERCLOCK_INFO_0_HE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HE  },
         { "20",  OPTION_VAL_20_HE  },
         { "30",  OPTION_VAL_30_HE  },
         { "40",  OPTION_VAL_40_HE  },
         { "50",  OPTION_VAL_50_HE  },
         { "60",  OPTION_VAL_60_HE  },
         { "70",  OPTION_VAL_70_HE  },
         { "80",  OPTION_VAL_80_HE  },
         { "90",  OPTION_VAL_90_HE  },
         { "100", OPTION_VAL_100_HE },
         { "110", OPTION_VAL_110_HE },
         { "120", OPTION_VAL_120_HE },
         { "130", OPTION_VAL_130_HE },
         { "140", OPTION_VAL_140_HE },
         { "150", OPTION_VAL_150_HE },
         { "160", OPTION_VAL_160_HE },
         { "170", OPTION_VAL_170_HE },
         { "180", OPTION_VAL_180_HE },
         { "190", OPTION_VAL_190_HE },
         { "200", OPTION_VAL_200_HE },
         { "210", OPTION_VAL_210_HE },
         { "220", OPTION_VAL_220_HE },
         { "230", OPTION_VAL_230_HE },
         { "240", OPTION_VAL_240_HE },
         { "250", OPTION_VAL_250_HE },
         { "260", OPTION_VAL_260_HE },
         { "270", OPTION_VAL_270_HE },
         { "280", OPTION_VAL_280_HE },
         { "290", OPTION_VAL_290_HE },
         { "300", OPTION_VAL_300_HE },
         { "310", OPTION_VAL_310_HE },
         { "320", OPTION_VAL_320_HE },
         { "330", OPTION_VAL_330_HE },
         { "340", OPTION_VAL_340_HE },
         { "350", OPTION_VAL_350_HE },
         { "360", OPTION_VAL_360_HE },
         { "370", OPTION_VAL_370_HE },
         { "380", OPTION_VAL_380_HE },
         { "390", OPTION_VAL_390_HE },
         { "400", OPTION_VAL_400_HE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_HE,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HE,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_HE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HE  },
         { "20",  OPTION_VAL_20_HE  },
         { "30",  OPTION_VAL_30_HE  },
         { "40",  OPTION_VAL_40_HE  },
         { "50",  OPTION_VAL_50_HE  },
         { "60",  OPTION_VAL_60_HE  },
         { "70",  OPTION_VAL_70_HE  },
         { "80",  OPTION_VAL_80_HE  },
         { "90",  OPTION_VAL_90_HE  },
         { "100", OPTION_VAL_100_HE },
         { "110", OPTION_VAL_110_HE },
         { "120", OPTION_VAL_120_HE },
         { "130", OPTION_VAL_130_HE },
         { "140", OPTION_VAL_140_HE },
         { "150", OPTION_VAL_150_HE },
         { "160", OPTION_VAL_160_HE },
         { "170", OPTION_VAL_170_HE },
         { "180", OPTION_VAL_180_HE },
         { "190", OPTION_VAL_190_HE },
         { "200", OPTION_VAL_200_HE },
         { "210", OPTION_VAL_210_HE },
         { "220", OPTION_VAL_220_HE },
         { "230", OPTION_VAL_230_HE },
         { "240", OPTION_VAL_240_HE },
         { "250", OPTION_VAL_250_HE },
         { "260", OPTION_VAL_260_HE },
         { "270", OPTION_VAL_270_HE },
         { "280", OPTION_VAL_280_HE },
         { "290", OPTION_VAL_290_HE },
         { "300", OPTION_VAL_300_HE },
         { "310", OPTION_VAL_310_HE },
         { "320", OPTION_VAL_320_HE },
         { "330", OPTION_VAL_330_HE },
         { "340", OPTION_VAL_340_HE },
         { "350", OPTION_VAL_350_HE },
         { "360", OPTION_VAL_360_HE },
         { "370", OPTION_VAL_370_HE },
         { "380", OPTION_VAL_380_HE },
         { "390", OPTION_VAL_390_HE },
         { "400", OPTION_VAL_400_HE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_HE,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HE,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_HE,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HE  },
         { "20",  OPTION_VAL_20_HE  },
         { "30",  OPTION_VAL_30_HE  },
         { "40",  OPTION_VAL_40_HE  },
         { "50",  OPTION_VAL_50_HE  },
         { "60",  OPTION_VAL_60_HE  },
         { "70",  OPTION_VAL_70_HE  },
         { "80",  OPTION_VAL_80_HE  },
         { "90",  OPTION_VAL_90_HE  },
         { "100", OPTION_VAL_100_HE },
         { "110", OPTION_VAL_110_HE },
         { "120", OPTION_VAL_120_HE },
         { "130", OPTION_VAL_130_HE },
         { "140", OPTION_VAL_140_HE },
         { "150", OPTION_VAL_150_HE },
         { "160", OPTION_VAL_160_HE },
         { "170", OPTION_VAL_170_HE },
         { "180", OPTION_VAL_180_HE },
         { "190", OPTION_VAL_190_HE },
         { "200", OPTION_VAL_200_HE },
         { "210", OPTION_VAL_210_HE },
         { "220", OPTION_VAL_220_HE },
         { "230", OPTION_VAL_230_HE },
         { "240", OPTION_VAL_240_HE },
         { "250", OPTION_VAL_250_HE },
         { "260", OPTION_VAL_260_HE },
         { "270", OPTION_VAL_270_HE },
         { "280", OPTION_VAL_280_HE },
         { "290", OPTION_VAL_290_HE },
         { "300", OPTION_VAL_300_HE },
         { "310", OPTION_VAL_310_HE },
         { "320", OPTION_VAL_320_HE },
         { "330", OPTION_VAL_330_HE },
         { "340", OPTION_VAL_340_HE },
         { "350", OPTION_VAL_350_HE },
         { "360", OPTION_VAL_360_HE },
         { "370", OPTION_VAL_370_HE },
         { "380", OPTION_VAL_380_HE },
         { "390", OPTION_VAL_390_HE },
         { "400", OPTION_VAL_400_HE },
         { "410", OPTION_VAL_410_HE },
         { "420", OPTION_VAL_420_HE },
         { "430", OPTION_VAL_430_HE },
         { "440", OPTION_VAL_440_HE },
         { "450", OPTION_VAL_450_HE },
         { "460", OPTION_VAL_460_HE },
         { "470", OPTION_VAL_470_HE },
         { "480", OPTION_VAL_480_HE },
         { "490", OPTION_VAL_490_HE },
         { "500", OPTION_VAL_500_HE },
         { "510", OPTION_VAL_510_HE },
         { "520", OPTION_VAL_520_HE },
         { "530", OPTION_VAL_530_HE },
         { "540", OPTION_VAL_540_HE },
         { "550", OPTION_VAL_550_HE },
         { "560", OPTION_VAL_560_HE },
         { "570", OPTION_VAL_570_HE },
         { "580", OPTION_VAL_580_HE },
         { "590", OPTION_VAL_590_HE },
         { "600", OPTION_VAL_600_HE },
         { "610", OPTION_VAL_610_HE },
         { "620", OPTION_VAL_620_HE },
         { "630", OPTION_VAL_630_HE },
         { "640", OPTION_VAL_640_HE },
         { "650", OPTION_VAL_650_HE },
         { "660", OPTION_VAL_660_HE },
         { "670", OPTION_VAL_670_HE },
         { "680", OPTION_VAL_680_HE },
         { "690", OPTION_VAL_690_HE },
         { "700", OPTION_VAL_700_HE },
         { "710", OPTION_VAL_710_HE },
         { "720", OPTION_VAL_720_HE },
         { "730", OPTION_VAL_730_HE },
         { "740", OPTION_VAL_740_HE },
         { "750", OPTION_VAL_750_HE },
         { "760", OPTION_VAL_760_HE },
         { "770", OPTION_VAL_770_HE },
         { "780", OPTION_VAL_780_HE },
         { "790", OPTION_VAL_790_HE },
         { "800", OPTION_VAL_800_HE },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_HE,
      NULL,
      BSNES_SGB_BIOS_INFO_0_HE,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_HE   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_HE },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_HE,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_HE,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HE,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HE,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HE,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_he = {
   option_cats_he,
   option_defs_he
};

/* RETRO_LANGUAGE_HR */

#define CATEGORY_VIDEO_LABEL_HR NULL
#define CATEGORY_VIDEO_INFO_0_HR NULL
#define CATEGORY_AUDIO_LABEL_HR "Zvuk"
#define CATEGORY_AUDIO_INFO_0_HR NULL
#define CATEGORY_MODE7_LABEL_HR NULL
#define CATEGORY_MODE7_INFO_0_HR NULL
#define CATEGORY_HACK_LABEL_HR NULL
#define CATEGORY_HACK_INFO_0_HR NULL
#define CATEGORY_OVERCLOCK_LABEL_HR NULL
#define CATEGORY_OVERCLOCK_INFO_0_HR NULL
#define CATEGORY_SGB_LABEL_HR NULL
#define CATEGORY_SGB_INFO_0_HR NULL
#define CATEGORY_LIGHTGUN_LABEL_HR NULL
#define CATEGORY_LIGHTGUN_INFO_0_HR NULL
#define BSNES_ASPECT_RATIO_LABEL_HR NULL
#define BSNES_ASPECT_RATIO_INFO_0_HR NULL
#define OPTION_VAL_AUTO_HR NULL
#define OPTION_VAL_1_1_HR NULL
#define OPTION_VAL_4_3_HR NULL
#define OPTION_VAL_NTSC_HR NULL
#define OPTION_VAL_PAL_HR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_HR NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_HR NULL
#define OPTION_VAL_0_HR NULL
#define OPTION_VAL_8_HR NULL
#define OPTION_VAL_12_HR NULL
#define OPTION_VAL_16_HR NULL
#define BSNES_BLUR_EMULATION_LABEL_HR NULL
#define BSNES_BLUR_EMULATION_INFO_0_HR NULL
#define BSNES_VIDEO_FILTER_LABEL_HR NULL
#define BSNES_VIDEO_FILTER_INFO_0_HR NULL
#define OPTION_VAL_NONE_HR "Ništa"
#define OPTION_VAL_NTSC_RF_HR NULL
#define OPTION_VAL_NTSC_COMPOSITE_HR NULL
#define OPTION_VAL_NTSC_S_VIDEO_HR NULL
#define OPTION_VAL_NTSC_RGB_HR NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_HR NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_HR NULL
#define OPTION_VAL_0_O4_HR NULL
#define OPTION_VAL_10_HR NULL
#define OPTION_VAL_20_HR NULL
#define OPTION_VAL_30_HR NULL
#define OPTION_VAL_40_HR NULL
#define OPTION_VAL_50_HR NULL
#define OPTION_VAL_60_HR NULL
#define OPTION_VAL_70_HR NULL
#define OPTION_VAL_80_HR NULL
#define OPTION_VAL_90_HR NULL
#define OPTION_VAL_100_HR NULL
#define BSNES_VIDEO_SATURATION_LABEL_HR NULL
#define BSNES_VIDEO_SATURATION_INFO_0_HR NULL
#define OPTION_VAL_110_HR NULL
#define OPTION_VAL_120_HR NULL
#define OPTION_VAL_130_HR NULL
#define OPTION_VAL_140_HR NULL
#define OPTION_VAL_150_HR NULL
#define OPTION_VAL_160_HR NULL
#define OPTION_VAL_170_HR NULL
#define OPTION_VAL_180_HR NULL
#define OPTION_VAL_190_HR NULL
#define OPTION_VAL_200_HR NULL
#define BSNES_VIDEO_GAMMA_LABEL_HR NULL
#define BSNES_VIDEO_GAMMA_INFO_0_HR NULL
#define OPTION_VAL_100_O6_HR NULL
#define OPTION_VAL_150_O6_HR NULL
#define BSNES_PPU_FAST_LABEL_HR NULL
#define BSNES_PPU_FAST_LABEL_CAT_HR NULL
#define BSNES_PPU_FAST_INFO_0_HR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_HR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_HR NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_HR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HR NULL
#define BSNES_DSP_FAST_LABEL_HR NULL
#define BSNES_DSP_FAST_LABEL_CAT_HR NULL
#define BSNES_DSP_FAST_INFO_0_HR NULL
#define BSNES_DSP_CUBIC_LABEL_HR NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_HR NULL
#define BSNES_DSP_CUBIC_INFO_0_HR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_HR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HR NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_HR NULL
#define BSNES_MODE7_SCALE_LABEL_HR NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_HR NULL
#define BSNES_MODE7_SCALE_INFO_0_HR NULL
#define OPTION_VAL_1X_HR NULL
#define OPTION_VAL_2X_HR NULL
#define OPTION_VAL_3X_HR NULL
#define OPTION_VAL_4X_HR NULL
#define OPTION_VAL_5X_HR NULL
#define OPTION_VAL_6X_HR NULL
#define OPTION_VAL_7X_HR NULL
#define OPTION_VAL_8X_HR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_HR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HR NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_HR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_HR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HR NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_HR NULL
#define BSNES_MODE7_MOSAIC_LABEL_HR NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_HR NULL
#define BSNES_MODE7_MOSAIC_INFO_0_HR NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_HR NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_HR NULL
#define OPTION_VAL_1_HR NULL
#define OPTION_VAL_2_HR NULL
#define OPTION_VAL_3_HR NULL
#define OPTION_VAL_4_HR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_HR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HR NULL
#define BSNES_HOTFIXES_LABEL_HR NULL
#define BSNES_HOTFIXES_INFO_0_HR NULL
#define BSNES_ENTROPY_LABEL_HR NULL
#define BSNES_ENTROPY_INFO_0_HR NULL
#define OPTION_VAL_LOW_HR NULL
#define OPTION_VAL_HIGH_HR NULL
#define BSNES_CPU_FASTMATH_LABEL_HR NULL
#define BSNES_CPU_FASTMATH_INFO_0_HR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_HR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_HR NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_HR NULL
#define OPTION_VAL_210_HR NULL
#define OPTION_VAL_220_HR NULL
#define OPTION_VAL_230_HR NULL
#define OPTION_VAL_240_HR NULL
#define OPTION_VAL_250_HR NULL
#define OPTION_VAL_260_HR NULL
#define OPTION_VAL_270_HR NULL
#define OPTION_VAL_280_HR NULL
#define OPTION_VAL_290_HR NULL
#define OPTION_VAL_300_HR NULL
#define OPTION_VAL_310_HR NULL
#define OPTION_VAL_320_HR NULL
#define OPTION_VAL_330_HR NULL
#define OPTION_VAL_340_HR NULL
#define OPTION_VAL_350_HR NULL
#define OPTION_VAL_360_HR NULL
#define OPTION_VAL_370_HR NULL
#define OPTION_VAL_380_HR NULL
#define OPTION_VAL_390_HR NULL
#define OPTION_VAL_400_HR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_HR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HR NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_HR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_HR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HR NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_HR NULL
#define OPTION_VAL_410_HR NULL
#define OPTION_VAL_420_HR NULL
#define OPTION_VAL_430_HR NULL
#define OPTION_VAL_440_HR NULL
#define OPTION_VAL_450_HR NULL
#define OPTION_VAL_460_HR NULL
#define OPTION_VAL_470_HR NULL
#define OPTION_VAL_480_HR NULL
#define OPTION_VAL_490_HR NULL
#define OPTION_VAL_500_HR NULL
#define OPTION_VAL_510_HR NULL
#define OPTION_VAL_520_HR NULL
#define OPTION_VAL_530_HR NULL
#define OPTION_VAL_540_HR NULL
#define OPTION_VAL_550_HR NULL
#define OPTION_VAL_560_HR NULL
#define OPTION_VAL_570_HR NULL
#define OPTION_VAL_580_HR NULL
#define OPTION_VAL_590_HR NULL
#define OPTION_VAL_600_HR NULL
#define OPTION_VAL_610_HR NULL
#define OPTION_VAL_620_HR NULL
#define OPTION_VAL_630_HR NULL
#define OPTION_VAL_640_HR NULL
#define OPTION_VAL_650_HR NULL
#define OPTION_VAL_660_HR NULL
#define OPTION_VAL_670_HR NULL
#define OPTION_VAL_680_HR NULL
#define OPTION_VAL_690_HR NULL
#define OPTION_VAL_700_HR NULL
#define OPTION_VAL_710_HR NULL
#define OPTION_VAL_720_HR NULL
#define OPTION_VAL_730_HR NULL
#define OPTION_VAL_740_HR NULL
#define OPTION_VAL_750_HR NULL
#define OPTION_VAL_760_HR NULL
#define OPTION_VAL_770_HR NULL
#define OPTION_VAL_780_HR NULL
#define OPTION_VAL_790_HR NULL
#define OPTION_VAL_800_HR NULL
#define BSNES_SGB_BIOS_LABEL_HR NULL
#define BSNES_SGB_BIOS_INFO_0_HR NULL
#define OPTION_VAL_SGB1_SFC_HR NULL
#define OPTION_VAL_SGB2_SFC_HR NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_HR NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_HR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HR NULL

struct retro_core_option_v2_category option_cats_hr[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_HR,
      CATEGORY_VIDEO_INFO_0_HR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HR,
      CATEGORY_AUDIO_INFO_0_HR
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_HR,
      CATEGORY_MODE7_INFO_0_HR
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_HR,
      CATEGORY_HACK_INFO_0_HR
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_HR,
      CATEGORY_OVERCLOCK_INFO_0_HR
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_HR,
      CATEGORY_SGB_INFO_0_HR
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_HR,
      CATEGORY_LIGHTGUN_INFO_0_HR
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_hr[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_HR,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_HR,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_HR },
         { "1:1",  OPTION_VAL_1_1_HR },
         { "4:3",  OPTION_VAL_4_3_HR },
         { "NTSC", OPTION_VAL_NTSC_HR },
         { "PAL",  OPTION_VAL_PAL_HR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_HR,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_HR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_HR },
         { "8",  OPTION_VAL_8_HR },
         { "12", OPTION_VAL_12_HR },
         { "16", OPTION_VAL_16_HR },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_HR,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_HR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_HR,
      BSNES_VIDEO_FILTER_LABEL_HR,
      BSNES_VIDEO_FILTER_INFO_0_HR,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_HR },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_HR },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_HR },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_HR },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_HR },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_HR,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_HR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HR },
         { "10", OPTION_VAL_10_HR },
         { "20", OPTION_VAL_20_HR },
         { "30", OPTION_VAL_30_HR },
         { "40", OPTION_VAL_40_HR },
         { "50", OPTION_VAL_50_HR },
         { "60", OPTION_VAL_60_HR },
         { "70", OPTION_VAL_70_HR },
         { "80", OPTION_VAL_80_HR },
         { "90", OPTION_VAL_90_HR },
         { "100", OPTION_VAL_100_HR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_HR,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_HR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HR },
         { "10", OPTION_VAL_10_HR },
         { "20", OPTION_VAL_20_HR },
         { "30", OPTION_VAL_30_HR },
         { "40", OPTION_VAL_40_HR },
         { "50", OPTION_VAL_50_HR },
         { "60", OPTION_VAL_60_HR },
         { "70", OPTION_VAL_70_HR },
         { "80", OPTION_VAL_80_HR },
         { "90", OPTION_VAL_90_HR },
         { "100", OPTION_VAL_100_HR },
         { "110", OPTION_VAL_110_HR },
         { "120", OPTION_VAL_120_HR },
         { "130", OPTION_VAL_130_HR },
         { "140", OPTION_VAL_140_HR },
         { "150", OPTION_VAL_150_HR },
         { "160", OPTION_VAL_160_HR },
         { "170", OPTION_VAL_170_HR },
         { "180", OPTION_VAL_180_HR },
         { "190", OPTION_VAL_190_HR },
         { "200", OPTION_VAL_200_HR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_HR,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_HR,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_HR },
         { "110", OPTION_VAL_110_HR },
         { "120", OPTION_VAL_120_HR },
         { "130", OPTION_VAL_130_HR },
         { "140", OPTION_VAL_140_HR },
         { "150", OPTION_VAL_150_O6_HR },
         { "160", OPTION_VAL_160_HR },
         { "170", OPTION_VAL_170_HR },
         { "180", OPTION_VAL_180_HR },
         { "190", OPTION_VAL_190_HR },
         { "200", OPTION_VAL_200_HR },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_HR,
      BSNES_PPU_FAST_LABEL_CAT_HR,
      BSNES_PPU_FAST_INFO_0_HR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_HR,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_HR,
      BSNES_PPU_DEINTERLACE_INFO_0_HR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HR,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HR,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HR,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HR,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_HR,
      BSNES_DSP_FAST_LABEL_CAT_HR,
      BSNES_DSP_FAST_INFO_0_HR,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_HR,
      BSNES_DSP_CUBIC_LABEL_CAT_HR,
      BSNES_DSP_CUBIC_INFO_0_HR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_HR,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HR,
      BSNES_DSP_ECHO_SHADOW_INFO_0_HR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_HR,
      BSNES_MODE7_SCALE_LABEL_CAT_HR,
      BSNES_MODE7_SCALE_INFO_0_HR,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_HR  },
         { "2x", OPTION_VAL_2X_HR  },
         { "3x", OPTION_VAL_3X_HR  },
         { "4x", OPTION_VAL_4X_HR  },
         { "5x", OPTION_VAL_5X_HR },
         { "6x", OPTION_VAL_6X_HR },
         { "7x", OPTION_VAL_7X_HR },
         { "8x", OPTION_VAL_8X_HR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_HR,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HR,
      BSNES_MODE7_PERSPECTIVE_INFO_0_HR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_HR,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HR,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_HR,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_HR,
      BSNES_MODE7_MOSAIC_LABEL_CAT_HR,
      BSNES_MODE7_MOSAIC_INFO_0_HR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_HR,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_HR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_HR  },
         { "2",   OPTION_VAL_2_HR },
         { "3",   OPTION_VAL_3_HR },
         { "4",   OPTION_VAL_4_HR },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HR,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_HR,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_HR,
      NULL,
      BSNES_HOTFIXES_INFO_0_HR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_HR,
      NULL,
      BSNES_ENTROPY_INFO_0_HR,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_HR },
         { "High", OPTION_VAL_HIGH_HR },
         { "None", OPTION_VAL_NONE_HR },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_HR,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_HR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_HR,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_HR,
      BSNES_CPU_OVERCLOCK_INFO_0_HR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HR  },
         { "20",  OPTION_VAL_20_HR  },
         { "30",  OPTION_VAL_30_HR  },
         { "40",  OPTION_VAL_40_HR  },
         { "50",  OPTION_VAL_50_HR  },
         { "60",  OPTION_VAL_60_HR  },
         { "70",  OPTION_VAL_70_HR  },
         { "80",  OPTION_VAL_80_HR  },
         { "90",  OPTION_VAL_90_HR  },
         { "100", OPTION_VAL_100_HR },
         { "110", OPTION_VAL_110_HR },
         { "120", OPTION_VAL_120_HR },
         { "130", OPTION_VAL_130_HR },
         { "140", OPTION_VAL_140_HR },
         { "150", OPTION_VAL_150_HR },
         { "160", OPTION_VAL_160_HR },
         { "170", OPTION_VAL_170_HR },
         { "180", OPTION_VAL_180_HR },
         { "190", OPTION_VAL_190_HR },
         { "200", OPTION_VAL_200_HR },
         { "210", OPTION_VAL_210_HR },
         { "220", OPTION_VAL_220_HR },
         { "230", OPTION_VAL_230_HR },
         { "240", OPTION_VAL_240_HR },
         { "250", OPTION_VAL_250_HR },
         { "260", OPTION_VAL_260_HR },
         { "270", OPTION_VAL_270_HR },
         { "280", OPTION_VAL_280_HR },
         { "290", OPTION_VAL_290_HR },
         { "300", OPTION_VAL_300_HR },
         { "310", OPTION_VAL_310_HR },
         { "320", OPTION_VAL_320_HR },
         { "330", OPTION_VAL_330_HR },
         { "340", OPTION_VAL_340_HR },
         { "350", OPTION_VAL_350_HR },
         { "360", OPTION_VAL_360_HR },
         { "370", OPTION_VAL_370_HR },
         { "380", OPTION_VAL_380_HR },
         { "390", OPTION_VAL_390_HR },
         { "400", OPTION_VAL_400_HR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_HR,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HR,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_HR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HR  },
         { "20",  OPTION_VAL_20_HR  },
         { "30",  OPTION_VAL_30_HR  },
         { "40",  OPTION_VAL_40_HR  },
         { "50",  OPTION_VAL_50_HR  },
         { "60",  OPTION_VAL_60_HR  },
         { "70",  OPTION_VAL_70_HR  },
         { "80",  OPTION_VAL_80_HR  },
         { "90",  OPTION_VAL_90_HR  },
         { "100", OPTION_VAL_100_HR },
         { "110", OPTION_VAL_110_HR },
         { "120", OPTION_VAL_120_HR },
         { "130", OPTION_VAL_130_HR },
         { "140", OPTION_VAL_140_HR },
         { "150", OPTION_VAL_150_HR },
         { "160", OPTION_VAL_160_HR },
         { "170", OPTION_VAL_170_HR },
         { "180", OPTION_VAL_180_HR },
         { "190", OPTION_VAL_190_HR },
         { "200", OPTION_VAL_200_HR },
         { "210", OPTION_VAL_210_HR },
         { "220", OPTION_VAL_220_HR },
         { "230", OPTION_VAL_230_HR },
         { "240", OPTION_VAL_240_HR },
         { "250", OPTION_VAL_250_HR },
         { "260", OPTION_VAL_260_HR },
         { "270", OPTION_VAL_270_HR },
         { "280", OPTION_VAL_280_HR },
         { "290", OPTION_VAL_290_HR },
         { "300", OPTION_VAL_300_HR },
         { "310", OPTION_VAL_310_HR },
         { "320", OPTION_VAL_320_HR },
         { "330", OPTION_VAL_330_HR },
         { "340", OPTION_VAL_340_HR },
         { "350", OPTION_VAL_350_HR },
         { "360", OPTION_VAL_360_HR },
         { "370", OPTION_VAL_370_HR },
         { "380", OPTION_VAL_380_HR },
         { "390", OPTION_VAL_390_HR },
         { "400", OPTION_VAL_400_HR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_HR,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HR,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_HR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HR  },
         { "20",  OPTION_VAL_20_HR  },
         { "30",  OPTION_VAL_30_HR  },
         { "40",  OPTION_VAL_40_HR  },
         { "50",  OPTION_VAL_50_HR  },
         { "60",  OPTION_VAL_60_HR  },
         { "70",  OPTION_VAL_70_HR  },
         { "80",  OPTION_VAL_80_HR  },
         { "90",  OPTION_VAL_90_HR  },
         { "100", OPTION_VAL_100_HR },
         { "110", OPTION_VAL_110_HR },
         { "120", OPTION_VAL_120_HR },
         { "130", OPTION_VAL_130_HR },
         { "140", OPTION_VAL_140_HR },
         { "150", OPTION_VAL_150_HR },
         { "160", OPTION_VAL_160_HR },
         { "170", OPTION_VAL_170_HR },
         { "180", OPTION_VAL_180_HR },
         { "190", OPTION_VAL_190_HR },
         { "200", OPTION_VAL_200_HR },
         { "210", OPTION_VAL_210_HR },
         { "220", OPTION_VAL_220_HR },
         { "230", OPTION_VAL_230_HR },
         { "240", OPTION_VAL_240_HR },
         { "250", OPTION_VAL_250_HR },
         { "260", OPTION_VAL_260_HR },
         { "270", OPTION_VAL_270_HR },
         { "280", OPTION_VAL_280_HR },
         { "290", OPTION_VAL_290_HR },
         { "300", OPTION_VAL_300_HR },
         { "310", OPTION_VAL_310_HR },
         { "320", OPTION_VAL_320_HR },
         { "330", OPTION_VAL_330_HR },
         { "340", OPTION_VAL_340_HR },
         { "350", OPTION_VAL_350_HR },
         { "360", OPTION_VAL_360_HR },
         { "370", OPTION_VAL_370_HR },
         { "380", OPTION_VAL_380_HR },
         { "390", OPTION_VAL_390_HR },
         { "400", OPTION_VAL_400_HR },
         { "410", OPTION_VAL_410_HR },
         { "420", OPTION_VAL_420_HR },
         { "430", OPTION_VAL_430_HR },
         { "440", OPTION_VAL_440_HR },
         { "450", OPTION_VAL_450_HR },
         { "460", OPTION_VAL_460_HR },
         { "470", OPTION_VAL_470_HR },
         { "480", OPTION_VAL_480_HR },
         { "490", OPTION_VAL_490_HR },
         { "500", OPTION_VAL_500_HR },
         { "510", OPTION_VAL_510_HR },
         { "520", OPTION_VAL_520_HR },
         { "530", OPTION_VAL_530_HR },
         { "540", OPTION_VAL_540_HR },
         { "550", OPTION_VAL_550_HR },
         { "560", OPTION_VAL_560_HR },
         { "570", OPTION_VAL_570_HR },
         { "580", OPTION_VAL_580_HR },
         { "590", OPTION_VAL_590_HR },
         { "600", OPTION_VAL_600_HR },
         { "610", OPTION_VAL_610_HR },
         { "620", OPTION_VAL_620_HR },
         { "630", OPTION_VAL_630_HR },
         { "640", OPTION_VAL_640_HR },
         { "650", OPTION_VAL_650_HR },
         { "660", OPTION_VAL_660_HR },
         { "670", OPTION_VAL_670_HR },
         { "680", OPTION_VAL_680_HR },
         { "690", OPTION_VAL_690_HR },
         { "700", OPTION_VAL_700_HR },
         { "710", OPTION_VAL_710_HR },
         { "720", OPTION_VAL_720_HR },
         { "730", OPTION_VAL_730_HR },
         { "740", OPTION_VAL_740_HR },
         { "750", OPTION_VAL_750_HR },
         { "760", OPTION_VAL_760_HR },
         { "770", OPTION_VAL_770_HR },
         { "780", OPTION_VAL_780_HR },
         { "790", OPTION_VAL_790_HR },
         { "800", OPTION_VAL_800_HR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_HR,
      NULL,
      BSNES_SGB_BIOS_INFO_0_HR,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_HR   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_HR },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_HR,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_HR,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HR,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HR,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_hr = {
   option_cats_hr,
   option_defs_hr
};

/* RETRO_LANGUAGE_HU */

#define CATEGORY_VIDEO_LABEL_HU "Kép"
#define CATEGORY_VIDEO_INFO_0_HU "A képkimenet beállításai."
#define CATEGORY_AUDIO_LABEL_HU "Hang"
#define CATEGORY_AUDIO_INFO_0_HU "A hangkimenet beállításai."
#define CATEGORY_MODE7_LABEL_HU NULL
#define CATEGORY_MODE7_INFO_0_HU "A Mode 7 grafika emulációs beállításai."
#define CATEGORY_HACK_LABEL_HU "Emulációs trükkök és továbbfejlesztések"
#define CATEGORY_HACK_INFO_0_HU "Az emuláció trükkjei, továbbfejlesztései és gyorsjavításai."
#define CATEGORY_OVERCLOCK_LABEL_HU "Túl/alulhajtás"
#define CATEGORY_OVERCLOCK_INFO_0_HU "Az emulált hardver sebessége."
#define CATEGORY_SGB_LABEL_HU NULL
#define CATEGORY_SGB_INFO_0_HU "A Super Game Boy emulációs beállításai."
#define CATEGORY_LIGHTGUN_LABEL_HU "Fénypisztoly"
#define CATEGORY_LIGHTGUN_INFO_0_HU "A fénypisztoly (érintőképernyős) beállításai."
#define BSNES_ASPECT_RATIO_LABEL_HU "Kívánt képarány"
#define BSNES_ASPECT_RATIO_INFO_0_HU "A tartalom kívánt képaránya. Csak akkor lép életbe, ha a RetroArch saját képarány beállítása \"Mag által meghatározott\" értékre van állítva a kép beállításainál."
#define OPTION_VAL_AUTO_HU "Automatikus"
#define OPTION_VAL_1_1_HU "1:1 pixelarány (pixelpontos)"
#define OPTION_VAL_4_3_HU "4:3 kijelzőarány"
#define OPTION_VAL_NTSC_HU NULL
#define OPTION_VAL_PAL_HU NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_HU "Függőleges overscan levágása"
#define BSNES_PPU_OVERSCAN_V_INFO_0_HU "N sor levágása a képernyő aljáról és tetejéről, az SNES korabeli televíziók kávájának szimulálásához."
#define OPTION_VAL_0_HU "0 sor"
#define OPTION_VAL_8_HU "8 sor"
#define OPTION_VAL_12_HU "12 sor"
#define OPTION_VAL_16_HU "16 sor"
#define BSNES_BLUR_EMULATION_LABEL_HU "Elmosás emulálása"
#define BSNES_BLUR_EMULATION_INFO_0_HU "Az SDTV korlátozott vízszintes felbontásának szimulálása a vízszintesen szomszédos képpontok összemosásával. Néhány játék hagyatkozik erre átlátszósági effektek céljából."
#define BSNES_VIDEO_FILTER_LABEL_HU "Szűrő"
#define BSNES_VIDEO_FILTER_INFO_0_HU "blargg NTSC szűrője RF modulált, kompozit, S-Video, vagy RGB módban, vagy szűrés nélkül"
#define OPTION_VAL_NONE_HU "Nincs"
#define OPTION_VAL_NTSC_RF_HU "NTSC (RF modulált)"
#define OPTION_VAL_NTSC_COMPOSITE_HU "NTSC (Kompozit)"
#define OPTION_VAL_NTSC_S_VIDEO_HU NULL
#define OPTION_VAL_NTSC_RGB_HU NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_HU "Színbeállítás - Fényerő"
#define BSNES_VIDEO_LUMINANCE_INFO_0_HU "Fényerő beállítása"
#define OPTION_VAL_0_O4_HU NULL
#define OPTION_VAL_10_HU NULL
#define OPTION_VAL_20_HU NULL
#define OPTION_VAL_30_HU NULL
#define OPTION_VAL_40_HU NULL
#define OPTION_VAL_50_HU NULL
#define OPTION_VAL_60_HU NULL
#define OPTION_VAL_70_HU NULL
#define OPTION_VAL_80_HU NULL
#define OPTION_VAL_90_HU NULL
#define OPTION_VAL_100_HU "100% (alapértelmezett)"
#define BSNES_VIDEO_SATURATION_LABEL_HU "Színbeállítás - Színtelítettség"
#define BSNES_VIDEO_SATURATION_INFO_0_HU "Színtelítettség beállítása"
#define OPTION_VAL_110_HU NULL
#define OPTION_VAL_120_HU NULL
#define OPTION_VAL_130_HU NULL
#define OPTION_VAL_140_HU NULL
#define OPTION_VAL_150_HU NULL
#define OPTION_VAL_160_HU NULL
#define OPTION_VAL_170_HU NULL
#define OPTION_VAL_180_HU NULL
#define OPTION_VAL_190_HU NULL
#define OPTION_VAL_200_HU NULL
#define BSNES_VIDEO_GAMMA_LABEL_HU "Színbeállítás - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_HU "Gamma érték beállítása"
#define OPTION_VAL_100_O6_HU NULL
#define OPTION_VAL_150_O6_HU "150% (alapértelmezett)"
#define BSNES_PPU_FAST_LABEL_HU "PPU (Video) - gyors mód"
#define BSNES_PPU_FAST_LABEL_CAT_HU "PPU - gyors mód"
#define BSNES_PPU_FAST_INFO_0_HU "A PPU gyorsabb emulációja, a pontosság kis csökkenése árán. Ajánlott bekapcsolva hagyni. Figyelem: ez a beállítás szükséges a deinterlace, sprite limit eltávolítása, és a HD Mode 7 opciókhoz."
#define BSNES_PPU_DEINTERLACE_LABEL_HU NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_HU NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_HU "Deinterlace, 480p módú belső képelőállítás minden játékhoz. A teljesítménycsökkenés majdhogynem észrevehetetlen, ajánlott bekapcsolva hagyni."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HU "PPU (Video) - sprite limit eltávolítás"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HU "PPU - sprite limit eltávolítás"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HU "A képernyőre egyidőben kirajzolható sprite-ok száma nem korlátozott. Néhány játéknál gondot okozhat."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HU "PPU (Video) - nincs VRAM blokkolás"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HU "PPU - nincs VRAM blokkolás"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HU "Egy, régebbi ZSNES és Snes9x emulátorokban jelen levő programhiba emulálása, ahol a VRAM blokkolás nem volt kezelve. Néhány régi ROM hack hagyatkozik erre és nem jól állítja elő a grafikát enélkül. Ez a beállítás nagyon pontatlan és rossz hatással van a PPU sebességre, így ajánlott kikapcsolva hagyni, hacsak a játék amúgy nem inkompatibilis ezzel a maggal."
#define BSNES_DSP_FAST_LABEL_HU "DSP (Audio) - gyors mód"
#define BSNES_DSP_FAST_LABEL_CAT_HU "DSP - gyors mód"
#define BSNES_DSP_FAST_INFO_0_HU "A DSP gyorsabb emulálása, cserébe a pontosság kismértékű csökkenéséért. Ajánlott bekapcsolva hagyni."
#define BSNES_DSP_CUBIC_LABEL_HU "DSP (Audio) - köbös interpoláció"
#define BSNES_DSP_CUBIC_LABEL_CAT_HU "DSP - köbös interpoláció"
#define BSNES_DSP_CUBIC_INFO_0_HU "A hang köbös interpolálása, amely jobban megőrzi a magastartományt."
#define BSNES_DSP_ECHO_SHADOW_LABEL_HU NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HU NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_HU "A ZSNES egy hibájának emulálása, ahol az echo RAM külön volt kezelve az APU RAM-tól. A Super Mario World sok régebbi ROM hack-je hagyatkozik erre a viselkedésre, és összeomlik nélküle. Ez az opció igen pontatlan és nem ajánlott engedélyezni, hacsak nem muszáj."
#define BSNES_MODE7_SCALE_LABEL_HU "HD Mode 7 - méretezés"
#define BSNES_MODE7_SCALE_LABEL_CAT_HU "Méretezés"
#define BSNES_MODE7_SCALE_INFO_0_HU "A bizonyos játékokban használt Mode 7 grafika vízszintes és függőleges felbontásának megnövelése."
#define OPTION_VAL_1X_HU NULL
#define OPTION_VAL_2X_HU NULL
#define OPTION_VAL_3X_HU NULL
#define OPTION_VAL_4X_HU NULL
#define OPTION_VAL_5X_HU NULL
#define OPTION_VAL_6X_HU NULL
#define OPTION_VAL_7X_HU NULL
#define OPTION_VAL_8X_HU NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_HU "HD Mode 7 - perspektíva korrekció"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HU "Perspektíva korrekció"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_HU "A bizonyos játékok által használt Mode 7 grafika perspektívájának javítása, az SNES néhány egészértékes műveleti korlátjának megkerülésével."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_HU "HD mode 7 - felülmintavételezés"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HU "Felülmintavételezés"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_HU "A bizonyos játékokban használt Mode 7 grafika felülmintavételezése. A Mode 7 nagyobb méreteivel együtt élsimításhoz hasonló effektet ad."
#define BSNES_MODE7_MOSAIC_LABEL_HU "HD Mode 7 - HD->SD mozaik"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_HU "HD->SD mozaik"
#define BSNES_MODE7_MOSAIC_INFO_0_HU "A Mode 7 grafika mozaik effektjének megjelenítése akkor is, ha felméretezés történik."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_HU "Belső run-ahead"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_HU "A rendszer idő előtti szimulálása, majd visszagörgetése, a bemeneti késleltetés csökkentéséhez. Nagyon magas a rendszerigénye."
#define OPTION_VAL_1_HU "1 képkocka"
#define OPTION_VAL_2_HU "2 képkocka"
#define OPTION_VAL_3_HU "3 képkocka"
#define OPTION_VAL_4_HU "4 képkocka"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HU "Koprocesszorok - gyors mód"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HU "A koprocesszorok gyorsabb emulálása, cserébe a pontosság kismértékű csökkenéséért. Ajánlott bekapcsolva hagyni."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_HU "Koprocesszorok - HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HU "Ha ez a beállítás be van kapcsolva, a kevésbé pontos HLE emuláció lesz használatban, amikor csak van rá lehetőség. Kikapcsolva csak akkor, ha hiányzik az LLE firmware."
#define BSNES_HOTFIXES_LABEL_HU "Gyorsjavítások"
#define BSNES_HOTFIXES_INFO_0_HU "Néha még a kereskedelmi forgalomba került játékok is tartalmaznak hibát. Ez a beállítás kijavít néhány problémát, ami a valós hardveren jelentkezett."
#define BSNES_ENTROPY_LABEL_HU "Entrópia (véletlenszerűség)"
#define BSNES_ENTROPY_INFO_0_HU "A memória és regiszterek véletlenszerűségének szintje. Nincs esetén minden memória és regiszter konstans értéket kap indításkor. Az alacsony véletlenszerűség hasonlít legjobban a valódi rendszerre. A magas véletlenszerűség a lehető legtöbb véletlen értéket generálja."
#define OPTION_VAL_LOW_HU "Alacsony"
#define OPTION_VAL_HIGH_HU "Magas"
#define BSNES_CPU_FASTMATH_LABEL_HU "CPU gyors matematikai műveletek"
#define BSNES_CPU_FASTMATH_INFO_0_HU "A számítási műveletek eredménye azonnal rendelkezésre áll. A CPU alapú szorzás és osztás egy valódi SNES-en időt vesz igénybe. Régebbi emulátorok ezeket a késleltetéseket nem emulálták, így néhány régebbi ROM hack nem vár ezekre és szükséges hozzájuk ez a trükk."
#define BSNES_CPU_OVERCLOCK_LABEL_HU "Túlhajtás - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_HU NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_HU "A CPU túlhajtása vagy alulhajtása. A 100% fölötti értékek csökkenthetik a töltési időket és a lassulást. Ajánlott óvatosan használni, mert néhány játék összeomolhat vagy más problémákat produkálhat."
#define OPTION_VAL_210_HU NULL
#define OPTION_VAL_220_HU NULL
#define OPTION_VAL_230_HU NULL
#define OPTION_VAL_240_HU NULL
#define OPTION_VAL_250_HU NULL
#define OPTION_VAL_260_HU NULL
#define OPTION_VAL_270_HU NULL
#define OPTION_VAL_280_HU NULL
#define OPTION_VAL_290_HU NULL
#define OPTION_VAL_300_HU NULL
#define OPTION_VAL_310_HU NULL
#define OPTION_VAL_320_HU NULL
#define OPTION_VAL_330_HU NULL
#define OPTION_VAL_340_HU NULL
#define OPTION_VAL_350_HU NULL
#define OPTION_VAL_360_HU NULL
#define OPTION_VAL_370_HU NULL
#define OPTION_VAL_380_HU NULL
#define OPTION_VAL_390_HU NULL
#define OPTION_VAL_400_HU NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_HU "Túlhajtás - SA-1 koprocesszor"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HU "SA-1 koprocesszor"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_HU "A Super Accelerator (SA-1) chip túlhajtása vagy alulhajtása. A 100% fölötti értékek javíthatják a teljesítményt az SA-1 chipet támogató játékoknál. Ajánlott óvatosan használni, mivel néhány játék összeomolhat vagy más problémákat produkálhat."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_HU "Túlhajtás - SuperFX koprocesszor"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HU "SuperFX koprocesszor"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_HU "A SuperFX chip túlhajtása vagy alulhajtása. A 100% fölötti értékek javíthatják a teljesítményt a SuperFX chipet támogató játékoknál. Ajánlott óvatosan használni, mivel néhány játék összeomolhat vagy más problémákat produkálhat."
#define OPTION_VAL_410_HU NULL
#define OPTION_VAL_420_HU NULL
#define OPTION_VAL_430_HU NULL
#define OPTION_VAL_440_HU NULL
#define OPTION_VAL_450_HU NULL
#define OPTION_VAL_460_HU NULL
#define OPTION_VAL_470_HU NULL
#define OPTION_VAL_480_HU NULL
#define OPTION_VAL_490_HU NULL
#define OPTION_VAL_500_HU NULL
#define OPTION_VAL_510_HU NULL
#define OPTION_VAL_520_HU NULL
#define OPTION_VAL_530_HU NULL
#define OPTION_VAL_540_HU NULL
#define OPTION_VAL_550_HU NULL
#define OPTION_VAL_560_HU NULL
#define OPTION_VAL_570_HU NULL
#define OPTION_VAL_580_HU NULL
#define OPTION_VAL_590_HU NULL
#define OPTION_VAL_600_HU NULL
#define OPTION_VAL_610_HU NULL
#define OPTION_VAL_620_HU NULL
#define OPTION_VAL_630_HU NULL
#define OPTION_VAL_640_HU NULL
#define OPTION_VAL_650_HU NULL
#define OPTION_VAL_660_HU NULL
#define OPTION_VAL_670_HU NULL
#define OPTION_VAL_680_HU NULL
#define OPTION_VAL_690_HU NULL
#define OPTION_VAL_700_HU NULL
#define OPTION_VAL_710_HU NULL
#define OPTION_VAL_720_HU NULL
#define OPTION_VAL_730_HU NULL
#define OPTION_VAL_740_HU NULL
#define OPTION_VAL_750_HU NULL
#define OPTION_VAL_760_HU NULL
#define OPTION_VAL_770_HU NULL
#define OPTION_VAL_780_HU NULL
#define OPTION_VAL_790_HU NULL
#define OPTION_VAL_800_HU NULL
#define BSNES_SGB_BIOS_LABEL_HU "Super Game Boy BIOS (újraindítás szükséges)"
#define BSNES_SGB_BIOS_INFO_0_HU "A kompatibilis címekhez használandó Super Game Boy BIOS."
#define OPTION_VAL_SGB1_SFC_HU NULL
#define OPTION_VAL_SGB2_SFC_HU NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_HU "SGB keret elrejtése"
#define BSNES_HIDE_SGB_BORDER_INFO_0_HU "A keret elrejtése Super Game Boy játékok esetén."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HU "Érintőképernyős fénypisztoly"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HU "A Super Scope bemenet engedélyezése érintőképernyős eszközökön."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HU "Super Scope ravaszgombok megfordítása"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HU "A Super Scope ravasz és kurzor gombok megcserélése az érintőképernyős fénypisztolynál."

struct retro_core_option_v2_category option_cats_hu[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_HU,
      CATEGORY_VIDEO_INFO_0_HU
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_HU,
      CATEGORY_AUDIO_INFO_0_HU
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_HU,
      CATEGORY_MODE7_INFO_0_HU
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_HU,
      CATEGORY_HACK_INFO_0_HU
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_HU,
      CATEGORY_OVERCLOCK_INFO_0_HU
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_HU,
      CATEGORY_SGB_INFO_0_HU
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_HU,
      CATEGORY_LIGHTGUN_INFO_0_HU
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_hu[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_HU,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_HU,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_HU },
         { "1:1",  OPTION_VAL_1_1_HU },
         { "4:3",  OPTION_VAL_4_3_HU },
         { "NTSC", OPTION_VAL_NTSC_HU },
         { "PAL",  OPTION_VAL_PAL_HU },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_HU,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_HU,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_HU },
         { "8",  OPTION_VAL_8_HU },
         { "12", OPTION_VAL_12_HU },
         { "16", OPTION_VAL_16_HU },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_HU,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_HU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_HU,
      BSNES_VIDEO_FILTER_LABEL_HU,
      BSNES_VIDEO_FILTER_INFO_0_HU,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_HU },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_HU },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_HU },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_HU },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_HU },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_HU,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_HU,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HU },
         { "10", OPTION_VAL_10_HU },
         { "20", OPTION_VAL_20_HU },
         { "30", OPTION_VAL_30_HU },
         { "40", OPTION_VAL_40_HU },
         { "50", OPTION_VAL_50_HU },
         { "60", OPTION_VAL_60_HU },
         { "70", OPTION_VAL_70_HU },
         { "80", OPTION_VAL_80_HU },
         { "90", OPTION_VAL_90_HU },
         { "100", OPTION_VAL_100_HU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_HU,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_HU,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_HU },
         { "10", OPTION_VAL_10_HU },
         { "20", OPTION_VAL_20_HU },
         { "30", OPTION_VAL_30_HU },
         { "40", OPTION_VAL_40_HU },
         { "50", OPTION_VAL_50_HU },
         { "60", OPTION_VAL_60_HU },
         { "70", OPTION_VAL_70_HU },
         { "80", OPTION_VAL_80_HU },
         { "90", OPTION_VAL_90_HU },
         { "100", OPTION_VAL_100_HU },
         { "110", OPTION_VAL_110_HU },
         { "120", OPTION_VAL_120_HU },
         { "130", OPTION_VAL_130_HU },
         { "140", OPTION_VAL_140_HU },
         { "150", OPTION_VAL_150_HU },
         { "160", OPTION_VAL_160_HU },
         { "170", OPTION_VAL_170_HU },
         { "180", OPTION_VAL_180_HU },
         { "190", OPTION_VAL_190_HU },
         { "200", OPTION_VAL_200_HU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_HU,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_HU,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_HU },
         { "110", OPTION_VAL_110_HU },
         { "120", OPTION_VAL_120_HU },
         { "130", OPTION_VAL_130_HU },
         { "140", OPTION_VAL_140_HU },
         { "150", OPTION_VAL_150_O6_HU },
         { "160", OPTION_VAL_160_HU },
         { "170", OPTION_VAL_170_HU },
         { "180", OPTION_VAL_180_HU },
         { "190", OPTION_VAL_190_HU },
         { "200", OPTION_VAL_200_HU },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_HU,
      BSNES_PPU_FAST_LABEL_CAT_HU,
      BSNES_PPU_FAST_INFO_0_HU,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_HU,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_HU,
      BSNES_PPU_DEINTERLACE_INFO_0_HU,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_HU,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_HU,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_HU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_HU,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_HU,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_HU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_HU,
      BSNES_DSP_FAST_LABEL_CAT_HU,
      BSNES_DSP_FAST_INFO_0_HU,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_HU,
      BSNES_DSP_CUBIC_LABEL_CAT_HU,
      BSNES_DSP_CUBIC_INFO_0_HU,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_HU,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_HU,
      BSNES_DSP_ECHO_SHADOW_INFO_0_HU,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_HU,
      BSNES_MODE7_SCALE_LABEL_CAT_HU,
      BSNES_MODE7_SCALE_INFO_0_HU,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_HU  },
         { "2x", OPTION_VAL_2X_HU  },
         { "3x", OPTION_VAL_3X_HU  },
         { "4x", OPTION_VAL_4X_HU  },
         { "5x", OPTION_VAL_5X_HU },
         { "6x", OPTION_VAL_6X_HU },
         { "7x", OPTION_VAL_7X_HU },
         { "8x", OPTION_VAL_8X_HU },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_HU,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_HU,
      BSNES_MODE7_PERSPECTIVE_INFO_0_HU,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_HU,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_HU,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_HU,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_HU,
      BSNES_MODE7_MOSAIC_LABEL_CAT_HU,
      BSNES_MODE7_MOSAIC_INFO_0_HU,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_HU,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_HU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_HU  },
         { "2",   OPTION_VAL_2_HU },
         { "3",   OPTION_VAL_3_HU },
         { "4",   OPTION_VAL_4_HU },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_HU,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_HU,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_HU,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_HU,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_HU,
      NULL,
      BSNES_HOTFIXES_INFO_0_HU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_HU,
      NULL,
      BSNES_ENTROPY_INFO_0_HU,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_HU },
         { "High", OPTION_VAL_HIGH_HU },
         { "None", OPTION_VAL_NONE_HU },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_HU,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_HU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_HU,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_HU,
      BSNES_CPU_OVERCLOCK_INFO_0_HU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HU  },
         { "20",  OPTION_VAL_20_HU  },
         { "30",  OPTION_VAL_30_HU  },
         { "40",  OPTION_VAL_40_HU  },
         { "50",  OPTION_VAL_50_HU  },
         { "60",  OPTION_VAL_60_HU  },
         { "70",  OPTION_VAL_70_HU  },
         { "80",  OPTION_VAL_80_HU  },
         { "90",  OPTION_VAL_90_HU  },
         { "100", OPTION_VAL_100_HU },
         { "110", OPTION_VAL_110_HU },
         { "120", OPTION_VAL_120_HU },
         { "130", OPTION_VAL_130_HU },
         { "140", OPTION_VAL_140_HU },
         { "150", OPTION_VAL_150_HU },
         { "160", OPTION_VAL_160_HU },
         { "170", OPTION_VAL_170_HU },
         { "180", OPTION_VAL_180_HU },
         { "190", OPTION_VAL_190_HU },
         { "200", OPTION_VAL_200_HU },
         { "210", OPTION_VAL_210_HU },
         { "220", OPTION_VAL_220_HU },
         { "230", OPTION_VAL_230_HU },
         { "240", OPTION_VAL_240_HU },
         { "250", OPTION_VAL_250_HU },
         { "260", OPTION_VAL_260_HU },
         { "270", OPTION_VAL_270_HU },
         { "280", OPTION_VAL_280_HU },
         { "290", OPTION_VAL_290_HU },
         { "300", OPTION_VAL_300_HU },
         { "310", OPTION_VAL_310_HU },
         { "320", OPTION_VAL_320_HU },
         { "330", OPTION_VAL_330_HU },
         { "340", OPTION_VAL_340_HU },
         { "350", OPTION_VAL_350_HU },
         { "360", OPTION_VAL_360_HU },
         { "370", OPTION_VAL_370_HU },
         { "380", OPTION_VAL_380_HU },
         { "390", OPTION_VAL_390_HU },
         { "400", OPTION_VAL_400_HU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_HU,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_HU,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_HU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HU  },
         { "20",  OPTION_VAL_20_HU  },
         { "30",  OPTION_VAL_30_HU  },
         { "40",  OPTION_VAL_40_HU  },
         { "50",  OPTION_VAL_50_HU  },
         { "60",  OPTION_VAL_60_HU  },
         { "70",  OPTION_VAL_70_HU  },
         { "80",  OPTION_VAL_80_HU  },
         { "90",  OPTION_VAL_90_HU  },
         { "100", OPTION_VAL_100_HU },
         { "110", OPTION_VAL_110_HU },
         { "120", OPTION_VAL_120_HU },
         { "130", OPTION_VAL_130_HU },
         { "140", OPTION_VAL_140_HU },
         { "150", OPTION_VAL_150_HU },
         { "160", OPTION_VAL_160_HU },
         { "170", OPTION_VAL_170_HU },
         { "180", OPTION_VAL_180_HU },
         { "190", OPTION_VAL_190_HU },
         { "200", OPTION_VAL_200_HU },
         { "210", OPTION_VAL_210_HU },
         { "220", OPTION_VAL_220_HU },
         { "230", OPTION_VAL_230_HU },
         { "240", OPTION_VAL_240_HU },
         { "250", OPTION_VAL_250_HU },
         { "260", OPTION_VAL_260_HU },
         { "270", OPTION_VAL_270_HU },
         { "280", OPTION_VAL_280_HU },
         { "290", OPTION_VAL_290_HU },
         { "300", OPTION_VAL_300_HU },
         { "310", OPTION_VAL_310_HU },
         { "320", OPTION_VAL_320_HU },
         { "330", OPTION_VAL_330_HU },
         { "340", OPTION_VAL_340_HU },
         { "350", OPTION_VAL_350_HU },
         { "360", OPTION_VAL_360_HU },
         { "370", OPTION_VAL_370_HU },
         { "380", OPTION_VAL_380_HU },
         { "390", OPTION_VAL_390_HU },
         { "400", OPTION_VAL_400_HU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_HU,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_HU,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_HU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_HU  },
         { "20",  OPTION_VAL_20_HU  },
         { "30",  OPTION_VAL_30_HU  },
         { "40",  OPTION_VAL_40_HU  },
         { "50",  OPTION_VAL_50_HU  },
         { "60",  OPTION_VAL_60_HU  },
         { "70",  OPTION_VAL_70_HU  },
         { "80",  OPTION_VAL_80_HU  },
         { "90",  OPTION_VAL_90_HU  },
         { "100", OPTION_VAL_100_HU },
         { "110", OPTION_VAL_110_HU },
         { "120", OPTION_VAL_120_HU },
         { "130", OPTION_VAL_130_HU },
         { "140", OPTION_VAL_140_HU },
         { "150", OPTION_VAL_150_HU },
         { "160", OPTION_VAL_160_HU },
         { "170", OPTION_VAL_170_HU },
         { "180", OPTION_VAL_180_HU },
         { "190", OPTION_VAL_190_HU },
         { "200", OPTION_VAL_200_HU },
         { "210", OPTION_VAL_210_HU },
         { "220", OPTION_VAL_220_HU },
         { "230", OPTION_VAL_230_HU },
         { "240", OPTION_VAL_240_HU },
         { "250", OPTION_VAL_250_HU },
         { "260", OPTION_VAL_260_HU },
         { "270", OPTION_VAL_270_HU },
         { "280", OPTION_VAL_280_HU },
         { "290", OPTION_VAL_290_HU },
         { "300", OPTION_VAL_300_HU },
         { "310", OPTION_VAL_310_HU },
         { "320", OPTION_VAL_320_HU },
         { "330", OPTION_VAL_330_HU },
         { "340", OPTION_VAL_340_HU },
         { "350", OPTION_VAL_350_HU },
         { "360", OPTION_VAL_360_HU },
         { "370", OPTION_VAL_370_HU },
         { "380", OPTION_VAL_380_HU },
         { "390", OPTION_VAL_390_HU },
         { "400", OPTION_VAL_400_HU },
         { "410", OPTION_VAL_410_HU },
         { "420", OPTION_VAL_420_HU },
         { "430", OPTION_VAL_430_HU },
         { "440", OPTION_VAL_440_HU },
         { "450", OPTION_VAL_450_HU },
         { "460", OPTION_VAL_460_HU },
         { "470", OPTION_VAL_470_HU },
         { "480", OPTION_VAL_480_HU },
         { "490", OPTION_VAL_490_HU },
         { "500", OPTION_VAL_500_HU },
         { "510", OPTION_VAL_510_HU },
         { "520", OPTION_VAL_520_HU },
         { "530", OPTION_VAL_530_HU },
         { "540", OPTION_VAL_540_HU },
         { "550", OPTION_VAL_550_HU },
         { "560", OPTION_VAL_560_HU },
         { "570", OPTION_VAL_570_HU },
         { "580", OPTION_VAL_580_HU },
         { "590", OPTION_VAL_590_HU },
         { "600", OPTION_VAL_600_HU },
         { "610", OPTION_VAL_610_HU },
         { "620", OPTION_VAL_620_HU },
         { "630", OPTION_VAL_630_HU },
         { "640", OPTION_VAL_640_HU },
         { "650", OPTION_VAL_650_HU },
         { "660", OPTION_VAL_660_HU },
         { "670", OPTION_VAL_670_HU },
         { "680", OPTION_VAL_680_HU },
         { "690", OPTION_VAL_690_HU },
         { "700", OPTION_VAL_700_HU },
         { "710", OPTION_VAL_710_HU },
         { "720", OPTION_VAL_720_HU },
         { "730", OPTION_VAL_730_HU },
         { "740", OPTION_VAL_740_HU },
         { "750", OPTION_VAL_750_HU },
         { "760", OPTION_VAL_760_HU },
         { "770", OPTION_VAL_770_HU },
         { "780", OPTION_VAL_780_HU },
         { "790", OPTION_VAL_790_HU },
         { "800", OPTION_VAL_800_HU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_HU,
      NULL,
      BSNES_SGB_BIOS_INFO_0_HU,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_HU   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_HU },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_HU,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_HU,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_HU,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_HU,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_HU,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_HU,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_hu = {
   option_cats_hu,
   option_defs_hu
};

/* RETRO_LANGUAGE_ID */

#define CATEGORY_VIDEO_LABEL_ID NULL
#define CATEGORY_VIDEO_INFO_0_ID "Ubah pengaturan keluaran video."
#define CATEGORY_AUDIO_LABEL_ID "Suara"
#define CATEGORY_AUDIO_INFO_0_ID "Ubah pengaturan keluaran audio."
#define CATEGORY_MODE7_LABEL_ID NULL
#define CATEGORY_MODE7_INFO_0_ID NULL
#define CATEGORY_HACK_LABEL_ID "Retasan dan Peningkatan Emulasi"
#define CATEGORY_HACK_INFO_0_ID NULL
#define CATEGORY_OVERCLOCK_LABEL_ID NULL
#define CATEGORY_OVERCLOCK_INFO_0_ID "Mengubah kecepatan emulasi peranti keras."
#define CATEGORY_SGB_LABEL_ID NULL
#define CATEGORY_SGB_INFO_0_ID NULL
#define CATEGORY_LIGHTGUN_LABEL_ID NULL
#define CATEGORY_LIGHTGUN_INFO_0_ID NULL
#define BSNES_ASPECT_RATIO_LABEL_ID NULL
#define BSNES_ASPECT_RATIO_INFO_0_ID NULL
#define OPTION_VAL_AUTO_ID "Otomatis"
#define OPTION_VAL_1_1_ID "1:1 PAR (Piksel Sempurna)"
#define OPTION_VAL_4_3_ID NULL
#define OPTION_VAL_NTSC_ID NULL
#define OPTION_VAL_PAL_ID NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_ID "Pangkas Lebihan Pindai Menegak"
#define BSNES_PPU_OVERSCAN_V_INFO_0_ID NULL
#define OPTION_VAL_0_ID "0 Garis"
#define OPTION_VAL_8_ID "8 Garis"
#define OPTION_VAL_12_ID "12 Garis"
#define OPTION_VAL_16_ID "16 Garis"
#define BSNES_BLUR_EMULATION_LABEL_ID NULL
#define BSNES_BLUR_EMULATION_INFO_0_ID NULL
#define BSNES_VIDEO_FILTER_LABEL_ID NULL
#define BSNES_VIDEO_FILTER_INFO_0_ID NULL
#define OPTION_VAL_NONE_ID "Tak ada"
#define OPTION_VAL_NTSC_RF_ID NULL
#define OPTION_VAL_NTSC_COMPOSITE_ID NULL
#define OPTION_VAL_NTSC_S_VIDEO_ID NULL
#define OPTION_VAL_NTSC_RGB_ID NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_ID "Penyesuaian Warna - Serian"
#define BSNES_VIDEO_LUMINANCE_INFO_0_ID "Sesuaikan Serian"
#define OPTION_VAL_0_O4_ID NULL
#define OPTION_VAL_10_ID NULL
#define OPTION_VAL_20_ID NULL
#define OPTION_VAL_30_ID NULL
#define OPTION_VAL_40_ID NULL
#define OPTION_VAL_50_ID NULL
#define OPTION_VAL_60_ID NULL
#define OPTION_VAL_70_ID NULL
#define OPTION_VAL_80_ID NULL
#define OPTION_VAL_90_ID NULL
#define OPTION_VAL_100_ID NULL
#define BSNES_VIDEO_SATURATION_LABEL_ID "Penyesuaian Warna - Saturasi"
#define BSNES_VIDEO_SATURATION_INFO_0_ID "Sesuaikan Saturasi"
#define OPTION_VAL_110_ID NULL
#define OPTION_VAL_120_ID NULL
#define OPTION_VAL_130_ID NULL
#define OPTION_VAL_140_ID NULL
#define OPTION_VAL_150_ID NULL
#define OPTION_VAL_160_ID NULL
#define OPTION_VAL_170_ID NULL
#define OPTION_VAL_180_ID NULL
#define OPTION_VAL_190_ID NULL
#define OPTION_VAL_200_ID NULL
#define BSNES_VIDEO_GAMMA_LABEL_ID "Penyesuaian Warna - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_ID "Sesuaikan Gamma"
#define OPTION_VAL_100_O6_ID NULL
#define OPTION_VAL_150_O6_ID "150% (Bawaan)"
#define BSNES_PPU_FAST_LABEL_ID NULL
#define BSNES_PPU_FAST_LABEL_CAT_ID NULL
#define BSNES_PPU_FAST_INFO_0_ID NULL
#define BSNES_PPU_DEINTERLACE_LABEL_ID NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_ID NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_ID NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_ID NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_ID NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_ID NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_ID NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_ID NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_ID NULL
#define BSNES_DSP_FAST_LABEL_ID NULL
#define BSNES_DSP_FAST_LABEL_CAT_ID NULL
#define BSNES_DSP_FAST_INFO_0_ID NULL
#define BSNES_DSP_CUBIC_LABEL_ID NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_ID NULL
#define BSNES_DSP_CUBIC_INFO_0_ID NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_ID NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_ID NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_ID NULL
#define BSNES_MODE7_SCALE_LABEL_ID NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_ID NULL
#define BSNES_MODE7_SCALE_INFO_0_ID NULL
#define OPTION_VAL_1X_ID NULL
#define OPTION_VAL_2X_ID NULL
#define OPTION_VAL_3X_ID NULL
#define OPTION_VAL_4X_ID NULL
#define OPTION_VAL_5X_ID NULL
#define OPTION_VAL_6X_ID NULL
#define OPTION_VAL_7X_ID NULL
#define OPTION_VAL_8X_ID NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_ID NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_ID "Betulkan Perspektif"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_ID NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_ID NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_ID NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_ID NULL
#define BSNES_MODE7_MOSAIC_LABEL_ID NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_ID NULL
#define BSNES_MODE7_MOSAIC_INFO_0_ID NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_ID NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_ID NULL
#define OPTION_VAL_1_ID NULL
#define OPTION_VAL_2_ID NULL
#define OPTION_VAL_3_ID NULL
#define OPTION_VAL_4_ID NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_ID NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_ID NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_ID NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_ID NULL
#define BSNES_HOTFIXES_LABEL_ID NULL
#define BSNES_HOTFIXES_INFO_0_ID NULL
#define BSNES_ENTROPY_LABEL_ID NULL
#define BSNES_ENTROPY_INFO_0_ID NULL
#define OPTION_VAL_LOW_ID NULL
#define OPTION_VAL_HIGH_ID NULL
#define BSNES_CPU_FASTMATH_LABEL_ID NULL
#define BSNES_CPU_FASTMATH_INFO_0_ID NULL
#define BSNES_CPU_OVERCLOCK_LABEL_ID NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_ID NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_ID NULL
#define OPTION_VAL_210_ID NULL
#define OPTION_VAL_220_ID NULL
#define OPTION_VAL_230_ID NULL
#define OPTION_VAL_240_ID NULL
#define OPTION_VAL_250_ID NULL
#define OPTION_VAL_260_ID NULL
#define OPTION_VAL_270_ID NULL
#define OPTION_VAL_280_ID NULL
#define OPTION_VAL_290_ID NULL
#define OPTION_VAL_300_ID NULL
#define OPTION_VAL_310_ID NULL
#define OPTION_VAL_320_ID NULL
#define OPTION_VAL_330_ID NULL
#define OPTION_VAL_340_ID NULL
#define OPTION_VAL_350_ID NULL
#define OPTION_VAL_360_ID NULL
#define OPTION_VAL_370_ID NULL
#define OPTION_VAL_380_ID NULL
#define OPTION_VAL_390_ID NULL
#define OPTION_VAL_400_ID NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_ID NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_ID NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_ID NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_ID NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_ID NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_ID NULL
#define OPTION_VAL_410_ID NULL
#define OPTION_VAL_420_ID NULL
#define OPTION_VAL_430_ID NULL
#define OPTION_VAL_440_ID NULL
#define OPTION_VAL_450_ID NULL
#define OPTION_VAL_460_ID NULL
#define OPTION_VAL_470_ID NULL
#define OPTION_VAL_480_ID NULL
#define OPTION_VAL_490_ID NULL
#define OPTION_VAL_500_ID NULL
#define OPTION_VAL_510_ID NULL
#define OPTION_VAL_520_ID NULL
#define OPTION_VAL_530_ID NULL
#define OPTION_VAL_540_ID NULL
#define OPTION_VAL_550_ID NULL
#define OPTION_VAL_560_ID NULL
#define OPTION_VAL_570_ID NULL
#define OPTION_VAL_580_ID NULL
#define OPTION_VAL_590_ID NULL
#define OPTION_VAL_600_ID NULL
#define OPTION_VAL_610_ID NULL
#define OPTION_VAL_620_ID NULL
#define OPTION_VAL_630_ID NULL
#define OPTION_VAL_640_ID NULL
#define OPTION_VAL_650_ID NULL
#define OPTION_VAL_660_ID NULL
#define OPTION_VAL_670_ID NULL
#define OPTION_VAL_680_ID NULL
#define OPTION_VAL_690_ID NULL
#define OPTION_VAL_700_ID NULL
#define OPTION_VAL_710_ID NULL
#define OPTION_VAL_720_ID NULL
#define OPTION_VAL_730_ID NULL
#define OPTION_VAL_740_ID NULL
#define OPTION_VAL_750_ID NULL
#define OPTION_VAL_760_ID NULL
#define OPTION_VAL_770_ID NULL
#define OPTION_VAL_780_ID NULL
#define OPTION_VAL_790_ID NULL
#define OPTION_VAL_800_ID NULL
#define BSNES_SGB_BIOS_LABEL_ID NULL
#define BSNES_SGB_BIOS_INFO_0_ID NULL
#define OPTION_VAL_SGB1_SFC_ID NULL
#define OPTION_VAL_SGB2_SFC_ID NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_ID NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_ID NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_ID NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_ID NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_ID NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_ID NULL

struct retro_core_option_v2_category option_cats_id[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_ID,
      CATEGORY_VIDEO_INFO_0_ID
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_ID,
      CATEGORY_AUDIO_INFO_0_ID
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_ID,
      CATEGORY_MODE7_INFO_0_ID
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_ID,
      CATEGORY_HACK_INFO_0_ID
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_ID,
      CATEGORY_OVERCLOCK_INFO_0_ID
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_ID,
      CATEGORY_SGB_INFO_0_ID
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_ID,
      CATEGORY_LIGHTGUN_INFO_0_ID
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_id[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_ID,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_ID,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_ID },
         { "1:1",  OPTION_VAL_1_1_ID },
         { "4:3",  OPTION_VAL_4_3_ID },
         { "NTSC", OPTION_VAL_NTSC_ID },
         { "PAL",  OPTION_VAL_PAL_ID },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_ID,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_ID,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_ID },
         { "8",  OPTION_VAL_8_ID },
         { "12", OPTION_VAL_12_ID },
         { "16", OPTION_VAL_16_ID },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_ID,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_ID,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_ID,
      BSNES_VIDEO_FILTER_LABEL_ID,
      BSNES_VIDEO_FILTER_INFO_0_ID,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_ID },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_ID },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_ID },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_ID },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_ID },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_ID,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_ID,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_ID },
         { "10", OPTION_VAL_10_ID },
         { "20", OPTION_VAL_20_ID },
         { "30", OPTION_VAL_30_ID },
         { "40", OPTION_VAL_40_ID },
         { "50", OPTION_VAL_50_ID },
         { "60", OPTION_VAL_60_ID },
         { "70", OPTION_VAL_70_ID },
         { "80", OPTION_VAL_80_ID },
         { "90", OPTION_VAL_90_ID },
         { "100", OPTION_VAL_100_ID },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_ID,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_ID,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_ID },
         { "10", OPTION_VAL_10_ID },
         { "20", OPTION_VAL_20_ID },
         { "30", OPTION_VAL_30_ID },
         { "40", OPTION_VAL_40_ID },
         { "50", OPTION_VAL_50_ID },
         { "60", OPTION_VAL_60_ID },
         { "70", OPTION_VAL_70_ID },
         { "80", OPTION_VAL_80_ID },
         { "90", OPTION_VAL_90_ID },
         { "100", OPTION_VAL_100_ID },
         { "110", OPTION_VAL_110_ID },
         { "120", OPTION_VAL_120_ID },
         { "130", OPTION_VAL_130_ID },
         { "140", OPTION_VAL_140_ID },
         { "150", OPTION_VAL_150_ID },
         { "160", OPTION_VAL_160_ID },
         { "170", OPTION_VAL_170_ID },
         { "180", OPTION_VAL_180_ID },
         { "190", OPTION_VAL_190_ID },
         { "200", OPTION_VAL_200_ID },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_ID,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_ID,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_ID },
         { "110", OPTION_VAL_110_ID },
         { "120", OPTION_VAL_120_ID },
         { "130", OPTION_VAL_130_ID },
         { "140", OPTION_VAL_140_ID },
         { "150", OPTION_VAL_150_O6_ID },
         { "160", OPTION_VAL_160_ID },
         { "170", OPTION_VAL_170_ID },
         { "180", OPTION_VAL_180_ID },
         { "190", OPTION_VAL_190_ID },
         { "200", OPTION_VAL_200_ID },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_ID,
      BSNES_PPU_FAST_LABEL_CAT_ID,
      BSNES_PPU_FAST_INFO_0_ID,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_ID,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_ID,
      BSNES_PPU_DEINTERLACE_INFO_0_ID,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_ID,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_ID,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_ID,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_ID,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_ID,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_ID,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_ID,
      BSNES_DSP_FAST_LABEL_CAT_ID,
      BSNES_DSP_FAST_INFO_0_ID,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_ID,
      BSNES_DSP_CUBIC_LABEL_CAT_ID,
      BSNES_DSP_CUBIC_INFO_0_ID,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_ID,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_ID,
      BSNES_DSP_ECHO_SHADOW_INFO_0_ID,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_ID,
      BSNES_MODE7_SCALE_LABEL_CAT_ID,
      BSNES_MODE7_SCALE_INFO_0_ID,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_ID  },
         { "2x", OPTION_VAL_2X_ID  },
         { "3x", OPTION_VAL_3X_ID  },
         { "4x", OPTION_VAL_4X_ID  },
         { "5x", OPTION_VAL_5X_ID },
         { "6x", OPTION_VAL_6X_ID },
         { "7x", OPTION_VAL_7X_ID },
         { "8x", OPTION_VAL_8X_ID },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_ID,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_ID,
      BSNES_MODE7_PERSPECTIVE_INFO_0_ID,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_ID,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_ID,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_ID,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_ID,
      BSNES_MODE7_MOSAIC_LABEL_CAT_ID,
      BSNES_MODE7_MOSAIC_INFO_0_ID,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_ID,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_ID,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_ID  },
         { "2",   OPTION_VAL_2_ID },
         { "3",   OPTION_VAL_3_ID },
         { "4",   OPTION_VAL_4_ID },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_ID,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_ID,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_ID,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_ID,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_ID,
      NULL,
      BSNES_HOTFIXES_INFO_0_ID,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_ID,
      NULL,
      BSNES_ENTROPY_INFO_0_ID,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_ID },
         { "High", OPTION_VAL_HIGH_ID },
         { "None", OPTION_VAL_NONE_ID },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_ID,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_ID,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_ID,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_ID,
      BSNES_CPU_OVERCLOCK_INFO_0_ID,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ID  },
         { "20",  OPTION_VAL_20_ID  },
         { "30",  OPTION_VAL_30_ID  },
         { "40",  OPTION_VAL_40_ID  },
         { "50",  OPTION_VAL_50_ID  },
         { "60",  OPTION_VAL_60_ID  },
         { "70",  OPTION_VAL_70_ID  },
         { "80",  OPTION_VAL_80_ID  },
         { "90",  OPTION_VAL_90_ID  },
         { "100", OPTION_VAL_100_ID },
         { "110", OPTION_VAL_110_ID },
         { "120", OPTION_VAL_120_ID },
         { "130", OPTION_VAL_130_ID },
         { "140", OPTION_VAL_140_ID },
         { "150", OPTION_VAL_150_ID },
         { "160", OPTION_VAL_160_ID },
         { "170", OPTION_VAL_170_ID },
         { "180", OPTION_VAL_180_ID },
         { "190", OPTION_VAL_190_ID },
         { "200", OPTION_VAL_200_ID },
         { "210", OPTION_VAL_210_ID },
         { "220", OPTION_VAL_220_ID },
         { "230", OPTION_VAL_230_ID },
         { "240", OPTION_VAL_240_ID },
         { "250", OPTION_VAL_250_ID },
         { "260", OPTION_VAL_260_ID },
         { "270", OPTION_VAL_270_ID },
         { "280", OPTION_VAL_280_ID },
         { "290", OPTION_VAL_290_ID },
         { "300", OPTION_VAL_300_ID },
         { "310", OPTION_VAL_310_ID },
         { "320", OPTION_VAL_320_ID },
         { "330", OPTION_VAL_330_ID },
         { "340", OPTION_VAL_340_ID },
         { "350", OPTION_VAL_350_ID },
         { "360", OPTION_VAL_360_ID },
         { "370", OPTION_VAL_370_ID },
         { "380", OPTION_VAL_380_ID },
         { "390", OPTION_VAL_390_ID },
         { "400", OPTION_VAL_400_ID },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_ID,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_ID,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_ID,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ID  },
         { "20",  OPTION_VAL_20_ID  },
         { "30",  OPTION_VAL_30_ID  },
         { "40",  OPTION_VAL_40_ID  },
         { "50",  OPTION_VAL_50_ID  },
         { "60",  OPTION_VAL_60_ID  },
         { "70",  OPTION_VAL_70_ID  },
         { "80",  OPTION_VAL_80_ID  },
         { "90",  OPTION_VAL_90_ID  },
         { "100", OPTION_VAL_100_ID },
         { "110", OPTION_VAL_110_ID },
         { "120", OPTION_VAL_120_ID },
         { "130", OPTION_VAL_130_ID },
         { "140", OPTION_VAL_140_ID },
         { "150", OPTION_VAL_150_ID },
         { "160", OPTION_VAL_160_ID },
         { "170", OPTION_VAL_170_ID },
         { "180", OPTION_VAL_180_ID },
         { "190", OPTION_VAL_190_ID },
         { "200", OPTION_VAL_200_ID },
         { "210", OPTION_VAL_210_ID },
         { "220", OPTION_VAL_220_ID },
         { "230", OPTION_VAL_230_ID },
         { "240", OPTION_VAL_240_ID },
         { "250", OPTION_VAL_250_ID },
         { "260", OPTION_VAL_260_ID },
         { "270", OPTION_VAL_270_ID },
         { "280", OPTION_VAL_280_ID },
         { "290", OPTION_VAL_290_ID },
         { "300", OPTION_VAL_300_ID },
         { "310", OPTION_VAL_310_ID },
         { "320", OPTION_VAL_320_ID },
         { "330", OPTION_VAL_330_ID },
         { "340", OPTION_VAL_340_ID },
         { "350", OPTION_VAL_350_ID },
         { "360", OPTION_VAL_360_ID },
         { "370", OPTION_VAL_370_ID },
         { "380", OPTION_VAL_380_ID },
         { "390", OPTION_VAL_390_ID },
         { "400", OPTION_VAL_400_ID },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_ID,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_ID,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_ID,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_ID  },
         { "20",  OPTION_VAL_20_ID  },
         { "30",  OPTION_VAL_30_ID  },
         { "40",  OPTION_VAL_40_ID  },
         { "50",  OPTION_VAL_50_ID  },
         { "60",  OPTION_VAL_60_ID  },
         { "70",  OPTION_VAL_70_ID  },
         { "80",  OPTION_VAL_80_ID  },
         { "90",  OPTION_VAL_90_ID  },
         { "100", OPTION_VAL_100_ID },
         { "110", OPTION_VAL_110_ID },
         { "120", OPTION_VAL_120_ID },
         { "130", OPTION_VAL_130_ID },
         { "140", OPTION_VAL_140_ID },
         { "150", OPTION_VAL_150_ID },
         { "160", OPTION_VAL_160_ID },
         { "170", OPTION_VAL_170_ID },
         { "180", OPTION_VAL_180_ID },
         { "190", OPTION_VAL_190_ID },
         { "200", OPTION_VAL_200_ID },
         { "210", OPTION_VAL_210_ID },
         { "220", OPTION_VAL_220_ID },
         { "230", OPTION_VAL_230_ID },
         { "240", OPTION_VAL_240_ID },
         { "250", OPTION_VAL_250_ID },
         { "260", OPTION_VAL_260_ID },
         { "270", OPTION_VAL_270_ID },
         { "280", OPTION_VAL_280_ID },
         { "290", OPTION_VAL_290_ID },
         { "300", OPTION_VAL_300_ID },
         { "310", OPTION_VAL_310_ID },
         { "320", OPTION_VAL_320_ID },
         { "330", OPTION_VAL_330_ID },
         { "340", OPTION_VAL_340_ID },
         { "350", OPTION_VAL_350_ID },
         { "360", OPTION_VAL_360_ID },
         { "370", OPTION_VAL_370_ID },
         { "380", OPTION_VAL_380_ID },
         { "390", OPTION_VAL_390_ID },
         { "400", OPTION_VAL_400_ID },
         { "410", OPTION_VAL_410_ID },
         { "420", OPTION_VAL_420_ID },
         { "430", OPTION_VAL_430_ID },
         { "440", OPTION_VAL_440_ID },
         { "450", OPTION_VAL_450_ID },
         { "460", OPTION_VAL_460_ID },
         { "470", OPTION_VAL_470_ID },
         { "480", OPTION_VAL_480_ID },
         { "490", OPTION_VAL_490_ID },
         { "500", OPTION_VAL_500_ID },
         { "510", OPTION_VAL_510_ID },
         { "520", OPTION_VAL_520_ID },
         { "530", OPTION_VAL_530_ID },
         { "540", OPTION_VAL_540_ID },
         { "550", OPTION_VAL_550_ID },
         { "560", OPTION_VAL_560_ID },
         { "570", OPTION_VAL_570_ID },
         { "580", OPTION_VAL_580_ID },
         { "590", OPTION_VAL_590_ID },
         { "600", OPTION_VAL_600_ID },
         { "610", OPTION_VAL_610_ID },
         { "620", OPTION_VAL_620_ID },
         { "630", OPTION_VAL_630_ID },
         { "640", OPTION_VAL_640_ID },
         { "650", OPTION_VAL_650_ID },
         { "660", OPTION_VAL_660_ID },
         { "670", OPTION_VAL_670_ID },
         { "680", OPTION_VAL_680_ID },
         { "690", OPTION_VAL_690_ID },
         { "700", OPTION_VAL_700_ID },
         { "710", OPTION_VAL_710_ID },
         { "720", OPTION_VAL_720_ID },
         { "730", OPTION_VAL_730_ID },
         { "740", OPTION_VAL_740_ID },
         { "750", OPTION_VAL_750_ID },
         { "760", OPTION_VAL_760_ID },
         { "770", OPTION_VAL_770_ID },
         { "780", OPTION_VAL_780_ID },
         { "790", OPTION_VAL_790_ID },
         { "800", OPTION_VAL_800_ID },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_ID,
      NULL,
      BSNES_SGB_BIOS_INFO_0_ID,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_ID   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_ID },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_ID,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_ID,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_ID,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_ID,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_ID,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_ID,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_id = {
   option_cats_id,
   option_defs_id
};

/* RETRO_LANGUAGE_IT */

#define CATEGORY_VIDEO_LABEL_IT NULL
#define CATEGORY_VIDEO_INFO_0_IT "Cambia le impostazioni di uscita video."
#define CATEGORY_AUDIO_LABEL_IT NULL
#define CATEGORY_AUDIO_INFO_0_IT "Cambia le impostazioni di uscita audio."
#define CATEGORY_MODE7_LABEL_IT "Modalità HD 7"
#define CATEGORY_MODE7_INFO_0_IT "Modificare le impostazioni relative all'emulazione grafica della Modalità 7."
#define CATEGORY_HACK_LABEL_IT "Emulazione Hack e miglioramenti"
#define CATEGORY_HACK_INFO_0_IT "Applica hack, miglioramenti e correzioni di emulazione."
#define CATEGORY_OVERCLOCK_LABEL_IT NULL
#define CATEGORY_OVERCLOCK_INFO_0_IT "Cambia la velocità dell'hardware emulato."
#define CATEGORY_SGB_LABEL_IT NULL
#define CATEGORY_SGB_INFO_0_IT "Modificare le impostazioni relative all'emulazione Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_IT "Cannone Leggero"
#define CATEGORY_LIGHTGUN_INFO_0_IT "Cambia le impostazioni (touchscreen) della pistola leggera."
#define BSNES_ASPECT_RATIO_LABEL_IT "Rapporto D'Aspetto (Aspect Ratio)"
#define BSNES_ASPECT_RATIO_INFO_0_IT "Definisce la proporzione scelta per il rapporto d'aspetto. Questo valore viene applicato correttamente solo se il rapporto d'aspetto nelle Impostazioni Video di RetroArch è configurato su 'Fornito dal Core'."
#define OPTION_VAL_AUTO_IT "Automatico"
#define OPTION_VAL_1_1_IT NULL
#define OPTION_VAL_4_3_IT NULL
#define OPTION_VAL_NTSC_IT NULL
#define OPTION_VAL_PAL_IT NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_IT "Ritaglia Overscan Verticale"
#define BSNES_PPU_OVERSCAN_V_INFO_0_IT "Rimuovere N linee dalla parte superiore e inferiore dello schermo per simulare la lunetta di un televisore dell'era SNES."
#define OPTION_VAL_0_IT "0 Linee"
#define OPTION_VAL_8_IT "8 Linee"
#define OPTION_VAL_12_IT "12 Linee"
#define OPTION_VAL_16_IT "16 Linee"
#define BSNES_BLUR_EMULATION_LABEL_IT "Emulazione della Sfocatura"
#define BSNES_BLUR_EMULATION_INFO_0_IT "Simula la risoluzione orizzontale limitata dei televisori a definizione standard, sfumando i pixel adiacenti. Alcuni giochi dipendono da questa opzione per poter riprodurre un effetto trasparenza."
#define BSNES_VIDEO_FILTER_LABEL_IT "Filtra"
#define BSNES_VIDEO_FILTER_INFO_0_IT "Scegli tra nessun filtro e il filtro NTSC di blargg con opzioni per RF, Composite, S-Video o RGB"
#define OPTION_VAL_NONE_IT "Nessuna"
#define OPTION_VAL_NTSC_RF_IT NULL
#define OPTION_VAL_NTSC_COMPOSITE_IT "NTSC Composito"
#define OPTION_VAL_NTSC_S_VIDEO_IT NULL
#define OPTION_VAL_NTSC_RGB_IT NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_IT "Regolazione Colore - Luminanza"
#define BSNES_VIDEO_LUMINANCE_INFO_0_IT "Regola Luminanza"
#define OPTION_VAL_0_O4_IT NULL
#define OPTION_VAL_10_IT NULL
#define OPTION_VAL_20_IT NULL
#define OPTION_VAL_30_IT NULL
#define OPTION_VAL_40_IT NULL
#define OPTION_VAL_50_IT NULL
#define OPTION_VAL_60_IT NULL
#define OPTION_VAL_70_IT NULL
#define OPTION_VAL_80_IT NULL
#define OPTION_VAL_90_IT NULL
#define OPTION_VAL_100_IT "100%"
#define BSNES_VIDEO_SATURATION_LABEL_IT "Regolazione Colore - Saturazione"
#define BSNES_VIDEO_SATURATION_INFO_0_IT "Regola Saturazione"
#define OPTION_VAL_110_IT NULL
#define OPTION_VAL_120_IT NULL
#define OPTION_VAL_130_IT NULL
#define OPTION_VAL_140_IT NULL
#define OPTION_VAL_150_IT NULL
#define OPTION_VAL_160_IT NULL
#define OPTION_VAL_170_IT NULL
#define OPTION_VAL_180_IT NULL
#define OPTION_VAL_190_IT NULL
#define OPTION_VAL_200_IT NULL
#define BSNES_VIDEO_GAMMA_LABEL_IT "Regolazione Colore - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_IT "Regola Gamma"
#define OPTION_VAL_100_O6_IT NULL
#define OPTION_VAL_150_O6_IT "150% (predefinito)"
#define BSNES_PPU_FAST_LABEL_IT "PPU (Video) - Modalità Rapida"
#define BSNES_PPU_FAST_LABEL_CAT_IT NULL
#define BSNES_PPU_FAST_INFO_0_IT "Abilita l'emulazione più veloce della PPU al costo di una minore riduzione di accuratezza. Si consiglia di lasciarla accesa. NOTA: questo deve essere abilitato per le opzioni 'Deinterlace', 'No Sprite Limit' e 'HD Mode 7' per funzionare."
#define BSNES_PPU_DEINTERLACE_LABEL_IT "PPU (Video) - Deinterlacciamento"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_IT NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_IT "Effettua un deinterlacciamento di tutti i giochi, utilizzando una riproduzione interna a 480p. La conseguente riduzione delle prestazioni è quasi nulla, pertanto si consiglia di mantenere l'opzione attiva."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_IT "PPU (Video) - Nessun Limite agli Sprite"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_IT "PPU - Nessun Limite Di Sprite"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_IT "Rimuove qualsiasi limite al numero di sprite che possono essere visualizzati a schermo simultaneamente. Potrebbe causare anomalie in alcuni giochi."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_IT "PPU (Video) - Nessun Blocco della VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_IT "PPU - Nessun Blocco VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_IT "Riproduce un bug presente in alcune vecchie versioni di ZSNES e Snes9x, che comportava la mancata emulazione del blocco della VRAM. Alcune vecchie ROM hack richiedono l'utilizzo di questo espediente e mostreranno errori grafici in caso di disattivazione. Questa opzione riduce sensibilmente l'accuratezza e la velocità della PPU, pertanto si consiglia di utilizzarla solo se si vuole avviare un gioco altrimenti incompatibile."
#define BSNES_DSP_FAST_LABEL_IT "DSP (Audio) - Modalità Rapida"
#define BSNES_DSP_FAST_LABEL_CAT_IT NULL
#define BSNES_DSP_FAST_INFO_0_IT "Permette un'emulazione più rapida del DSP al costo di una minima diminuzione dell'accuratezza. Si consiglia di mantenere quest'opzione attiva."
#define BSNES_DSP_CUBIC_LABEL_IT "DSP (Audio) - Interpolazione Cubica"
#define BSNES_DSP_CUBIC_LABEL_CAT_IT "DSP - Interpolazione Cubica"
#define BSNES_DSP_CUBIC_INFO_0_IT "Applica un'interpolazione cubica al suono, preservando maggiormente le alte frequenze."
#define BSNES_DSP_ECHO_SHADOW_LABEL_IT "DSP (Audio) - RAM dell'Eco Separata"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_IT "DSP - RAM Echo Shadow"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_IT "Riproduce un bug di ZSNES che interpretava la RAM dell'effetto 'eco' come separata dalla RAM dell'APU. Molte vecchie ROM hack di Super Mario World si affidavano a questa implementazione, pertanto non potranno essere riprodotte senza questo espediente. Si tratta di un'opzione che riduce sensibilmente l'accuratezza, quindi si consiglia di non attivarla a meno che non sia strettamente necessario."
#define BSNES_MODE7_SCALE_LABEL_IT "HD Mode 7 - Scala"
#define BSNES_MODE7_SCALE_LABEL_CAT_IT "Scala"
#define BSNES_MODE7_SCALE_INFO_0_IT "Permette di incrementare la risoluzione orizzontale e verticale della grafica in Mode 7 utilizzata in alcuni giochi."
#define OPTION_VAL_1X_IT NULL
#define OPTION_VAL_2X_IT NULL
#define OPTION_VAL_3X_IT NULL
#define OPTION_VAL_4X_IT NULL
#define OPTION_VAL_5X_IT NULL
#define OPTION_VAL_6X_IT NULL
#define OPTION_VAL_7X_IT NULL
#define OPTION_VAL_8X_IT NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_IT "HD Mode 7 - Correzione della Prospettiva"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_IT "Correzione Prospettiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_IT "Corregge la prospettiva nella grafica in Mode 7 utilizzata in alcuni giochi, aggirando alcune delle limitazioni relative al calcolo matematico degli interi utilizzato dallo SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_IT "Modalità HD 7 - Sovracampionamento"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_IT "Sovracampionamento"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_IT "Applica un effetto di 'supersampling' alla grafica in Mode 7 utilizzata in alcuni giochi. Se abbinata a fattori elevati di scala del Mode 7, smussa le scalettature creando un filtro simile all'anti-aliasing."
#define BSNES_MODE7_MOSAIC_LABEL_IT "HD Mode 7 - Effetto Mosaico HD->SD"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_IT "HD->SD Mosaico"
#define BSNES_MODE7_MOSAIC_INFO_0_IT "Consente di mostrare o meno l'effetto mosaico quando si incrementa la risoluzione della grafica in Mode 7 utilizzata in alcuni giochi."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_IT "Funzione Interna di Run-Ahead"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_IT "Anticipa l'emulazione del sistema e riavvolge la riproduzione per ridurre la latenza nei comandi. Ha requisiti di sistema molto alti."
#define OPTION_VAL_1_IT NULL
#define OPTION_VAL_2_IT "2 frame"
#define OPTION_VAL_3_IT "3 frame"
#define OPTION_VAL_4_IT "4 frame"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_IT "Coprocessori - Modalità Rapida"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_IT "Permette un'emulazione più rapida dei coprocessori al costo di una minima diminuzione dell'accuratezza. Si consiglia di mantenere quest'opzione attiva."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_IT "Coprocessori - Preferisci Emulazione ad Alto Livello (HLE)"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_IT "Quando quest'opzione è attiva, sarà favorito l'utilizzo dell'emulazione ad alto livello (HLE), meno accurata. Se l'opzione viene disattivata, l'emulazione ad alto livello (HLE) sarà utilizzata solo in caso di assenza del firmware relativo all'emulazione a basso livello (LLE)."
#define BSNES_HOTFIXES_LABEL_IT "Hotfix"
#define BSNES_HOTFIXES_INFO_0_IT "Anche i giochi rilasciati ufficialmente e commercializzati su licenza originale talvolta presentavano dei bug. Attivare questa opzione consente di correggere alcune di queste anomalie che si verificavano persino su hardware originale."
#define BSNES_ENTROPY_LABEL_IT "Entropia (Randomizzazione)"
#define BSNES_ENTROPY_INFO_0_IT "Determina il livello di randomizzazione della memoria e dei registri. Se impostata su 'Nessuna', memoria e registri saranno inizializzati con valori costanti all'avvio. Una bassa randomizzazione produce la rappresentazione più accurata del sistema originale. Se impostata su 'Alta', configura memorie e registri con valori quanto più possibile casuali."
#define OPTION_VAL_LOW_IT "Bassa"
#define OPTION_VAL_HIGH_IT "Alta"
#define BSNES_CPU_FASTMATH_LABEL_IT "Accelerazione del Calcolo Matematico della CPU"
#define BSNES_CPU_FASTMATH_INFO_0_IT "Le operazioni di moltiplicazione e divisione impongono un certo tempo di elaborazione alla CPU di un vero SNES. I vecchi emulatori non simulavano questo ritardo e restituivano immediatamente il risultato. Alcune ROM hack non attendono il completamento delle operazioni matematiche e pertanto richiedono l'utilizzo di questo espediente."
#define BSNES_CPU_OVERCLOCK_LABEL_IT NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_IT NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_IT "Applica un overclock o downclock alla CPU. Impostare questo valore oltre il 100% può diminuire tempi di attesa e rallentamenti. Da usare con cautela, in quanto potrebbe causare in alcuni giochi delle anomalie o un blocco totale."
#define OPTION_VAL_210_IT NULL
#define OPTION_VAL_220_IT NULL
#define OPTION_VAL_230_IT NULL
#define OPTION_VAL_240_IT NULL
#define OPTION_VAL_250_IT NULL
#define OPTION_VAL_260_IT NULL
#define OPTION_VAL_270_IT NULL
#define OPTION_VAL_280_IT NULL
#define OPTION_VAL_290_IT NULL
#define OPTION_VAL_300_IT NULL
#define OPTION_VAL_310_IT NULL
#define OPTION_VAL_320_IT NULL
#define OPTION_VAL_330_IT NULL
#define OPTION_VAL_340_IT NULL
#define OPTION_VAL_350_IT NULL
#define OPTION_VAL_360_IT NULL
#define OPTION_VAL_370_IT NULL
#define OPTION_VAL_380_IT NULL
#define OPTION_VAL_390_IT NULL
#define OPTION_VAL_400_IT NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_IT "Overclocking - Coprocessore SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_IT "Coprocessore SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_IT "Applica un overclock o downclock al chip Super Accelerator 1 (SA-1). Impostare questo valore oltre il 100% può incrementare le prestazioni nei giochi che supportano il chip SA-1. Da usare con cautela, in quanto potrebbe causare in alcuni giochi delle anomalie o un blocco totale."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_IT "Overclocking - Coprocessore SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_IT "Coprocessore SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_IT "Applica un overclock o downclock al coprocessore SuperFX. Impostare questo valore oltre il 100% può incrementare le prestazioni nei giochi che supportano il SuperFX. Da usare con cautela, in quanto potrebbe causare in alcuni giochi delle anomalie o un blocco totale."
#define OPTION_VAL_410_IT NULL
#define OPTION_VAL_420_IT NULL
#define OPTION_VAL_430_IT NULL
#define OPTION_VAL_440_IT NULL
#define OPTION_VAL_450_IT NULL
#define OPTION_VAL_460_IT NULL
#define OPTION_VAL_470_IT NULL
#define OPTION_VAL_480_IT NULL
#define OPTION_VAL_490_IT NULL
#define OPTION_VAL_500_IT NULL
#define OPTION_VAL_510_IT NULL
#define OPTION_VAL_520_IT NULL
#define OPTION_VAL_530_IT NULL
#define OPTION_VAL_540_IT NULL
#define OPTION_VAL_550_IT NULL
#define OPTION_VAL_560_IT NULL
#define OPTION_VAL_570_IT NULL
#define OPTION_VAL_580_IT NULL
#define OPTION_VAL_590_IT NULL
#define OPTION_VAL_600_IT NULL
#define OPTION_VAL_610_IT NULL
#define OPTION_VAL_620_IT NULL
#define OPTION_VAL_630_IT NULL
#define OPTION_VAL_640_IT NULL
#define OPTION_VAL_650_IT NULL
#define OPTION_VAL_660_IT NULL
#define OPTION_VAL_670_IT NULL
#define OPTION_VAL_680_IT NULL
#define OPTION_VAL_690_IT NULL
#define OPTION_VAL_700_IT NULL
#define OPTION_VAL_710_IT NULL
#define OPTION_VAL_720_IT NULL
#define OPTION_VAL_730_IT NULL
#define OPTION_VAL_740_IT NULL
#define OPTION_VAL_750_IT NULL
#define OPTION_VAL_760_IT NULL
#define OPTION_VAL_770_IT NULL
#define OPTION_VAL_780_IT NULL
#define OPTION_VAL_790_IT NULL
#define OPTION_VAL_800_IT NULL
#define BSNES_SGB_BIOS_LABEL_IT "BIOS del Super Game Boy (Richiede un Riavvio)"
#define BSNES_SGB_BIOS_INFO_0_IT "Consente di scegliere il BIOS del Super Game Boy da utilizzarsi con i relativi titoli compatibili. Richiede un riavvio per avere effetto."
#define OPTION_VAL_SGB1_SFC_IT NULL
#define OPTION_VAL_SGB2_SFC_IT NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_IT "Nascondi Bordo SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_IT "Nascondi il bordo durante la riproduzione dei giochi Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_IT "Emulazione Pistola su Touchscreen"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_IT "Consente il controllo della pistola Super Scope per dispositivi muniti di touchscreen."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_IT "Inverti Pulsanti di Grilletto e Cursore per la Pistola"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_IT "Permette di invertire i pulsanti del grilletto e del cursore della pistola Super Scope nell'utilizzo tramite touchscreen."

struct retro_core_option_v2_category option_cats_it[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_IT,
      CATEGORY_VIDEO_INFO_0_IT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_IT,
      CATEGORY_AUDIO_INFO_0_IT
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_IT,
      CATEGORY_MODE7_INFO_0_IT
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_IT,
      CATEGORY_HACK_INFO_0_IT
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_IT,
      CATEGORY_OVERCLOCK_INFO_0_IT
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_IT,
      CATEGORY_SGB_INFO_0_IT
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_IT,
      CATEGORY_LIGHTGUN_INFO_0_IT
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_it[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_IT,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_IT,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_IT },
         { "1:1",  OPTION_VAL_1_1_IT },
         { "4:3",  OPTION_VAL_4_3_IT },
         { "NTSC", OPTION_VAL_NTSC_IT },
         { "PAL",  OPTION_VAL_PAL_IT },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_IT,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_IT,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_IT },
         { "8",  OPTION_VAL_8_IT },
         { "12", OPTION_VAL_12_IT },
         { "16", OPTION_VAL_16_IT },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_IT,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_IT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_IT,
      BSNES_VIDEO_FILTER_LABEL_IT,
      BSNES_VIDEO_FILTER_INFO_0_IT,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_IT },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_IT },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_IT },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_IT },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_IT },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_IT,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_IT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_IT },
         { "10", OPTION_VAL_10_IT },
         { "20", OPTION_VAL_20_IT },
         { "30", OPTION_VAL_30_IT },
         { "40", OPTION_VAL_40_IT },
         { "50", OPTION_VAL_50_IT },
         { "60", OPTION_VAL_60_IT },
         { "70", OPTION_VAL_70_IT },
         { "80", OPTION_VAL_80_IT },
         { "90", OPTION_VAL_90_IT },
         { "100", OPTION_VAL_100_IT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_IT,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_IT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_IT },
         { "10", OPTION_VAL_10_IT },
         { "20", OPTION_VAL_20_IT },
         { "30", OPTION_VAL_30_IT },
         { "40", OPTION_VAL_40_IT },
         { "50", OPTION_VAL_50_IT },
         { "60", OPTION_VAL_60_IT },
         { "70", OPTION_VAL_70_IT },
         { "80", OPTION_VAL_80_IT },
         { "90", OPTION_VAL_90_IT },
         { "100", OPTION_VAL_100_IT },
         { "110", OPTION_VAL_110_IT },
         { "120", OPTION_VAL_120_IT },
         { "130", OPTION_VAL_130_IT },
         { "140", OPTION_VAL_140_IT },
         { "150", OPTION_VAL_150_IT },
         { "160", OPTION_VAL_160_IT },
         { "170", OPTION_VAL_170_IT },
         { "180", OPTION_VAL_180_IT },
         { "190", OPTION_VAL_190_IT },
         { "200", OPTION_VAL_200_IT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_IT,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_IT,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_IT },
         { "110", OPTION_VAL_110_IT },
         { "120", OPTION_VAL_120_IT },
         { "130", OPTION_VAL_130_IT },
         { "140", OPTION_VAL_140_IT },
         { "150", OPTION_VAL_150_O6_IT },
         { "160", OPTION_VAL_160_IT },
         { "170", OPTION_VAL_170_IT },
         { "180", OPTION_VAL_180_IT },
         { "190", OPTION_VAL_190_IT },
         { "200", OPTION_VAL_200_IT },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_IT,
      BSNES_PPU_FAST_LABEL_CAT_IT,
      BSNES_PPU_FAST_INFO_0_IT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_IT,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_IT,
      BSNES_PPU_DEINTERLACE_INFO_0_IT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_IT,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_IT,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_IT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_IT,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_IT,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_IT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_IT,
      BSNES_DSP_FAST_LABEL_CAT_IT,
      BSNES_DSP_FAST_INFO_0_IT,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_IT,
      BSNES_DSP_CUBIC_LABEL_CAT_IT,
      BSNES_DSP_CUBIC_INFO_0_IT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_IT,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_IT,
      BSNES_DSP_ECHO_SHADOW_INFO_0_IT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_IT,
      BSNES_MODE7_SCALE_LABEL_CAT_IT,
      BSNES_MODE7_SCALE_INFO_0_IT,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_IT  },
         { "2x", OPTION_VAL_2X_IT  },
         { "3x", OPTION_VAL_3X_IT  },
         { "4x", OPTION_VAL_4X_IT  },
         { "5x", OPTION_VAL_5X_IT },
         { "6x", OPTION_VAL_6X_IT },
         { "7x", OPTION_VAL_7X_IT },
         { "8x", OPTION_VAL_8X_IT },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_IT,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_IT,
      BSNES_MODE7_PERSPECTIVE_INFO_0_IT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_IT,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_IT,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_IT,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_IT,
      BSNES_MODE7_MOSAIC_LABEL_CAT_IT,
      BSNES_MODE7_MOSAIC_INFO_0_IT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_IT,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_IT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_IT  },
         { "2",   OPTION_VAL_2_IT },
         { "3",   OPTION_VAL_3_IT },
         { "4",   OPTION_VAL_4_IT },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_IT,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_IT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_IT,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_IT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_IT,
      NULL,
      BSNES_HOTFIXES_INFO_0_IT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_IT,
      NULL,
      BSNES_ENTROPY_INFO_0_IT,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_IT },
         { "High", OPTION_VAL_HIGH_IT },
         { "None", OPTION_VAL_NONE_IT },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_IT,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_IT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_IT,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_IT,
      BSNES_CPU_OVERCLOCK_INFO_0_IT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_IT  },
         { "20",  OPTION_VAL_20_IT  },
         { "30",  OPTION_VAL_30_IT  },
         { "40",  OPTION_VAL_40_IT  },
         { "50",  OPTION_VAL_50_IT  },
         { "60",  OPTION_VAL_60_IT  },
         { "70",  OPTION_VAL_70_IT  },
         { "80",  OPTION_VAL_80_IT  },
         { "90",  OPTION_VAL_90_IT  },
         { "100", OPTION_VAL_100_IT },
         { "110", OPTION_VAL_110_IT },
         { "120", OPTION_VAL_120_IT },
         { "130", OPTION_VAL_130_IT },
         { "140", OPTION_VAL_140_IT },
         { "150", OPTION_VAL_150_IT },
         { "160", OPTION_VAL_160_IT },
         { "170", OPTION_VAL_170_IT },
         { "180", OPTION_VAL_180_IT },
         { "190", OPTION_VAL_190_IT },
         { "200", OPTION_VAL_200_IT },
         { "210", OPTION_VAL_210_IT },
         { "220", OPTION_VAL_220_IT },
         { "230", OPTION_VAL_230_IT },
         { "240", OPTION_VAL_240_IT },
         { "250", OPTION_VAL_250_IT },
         { "260", OPTION_VAL_260_IT },
         { "270", OPTION_VAL_270_IT },
         { "280", OPTION_VAL_280_IT },
         { "290", OPTION_VAL_290_IT },
         { "300", OPTION_VAL_300_IT },
         { "310", OPTION_VAL_310_IT },
         { "320", OPTION_VAL_320_IT },
         { "330", OPTION_VAL_330_IT },
         { "340", OPTION_VAL_340_IT },
         { "350", OPTION_VAL_350_IT },
         { "360", OPTION_VAL_360_IT },
         { "370", OPTION_VAL_370_IT },
         { "380", OPTION_VAL_380_IT },
         { "390", OPTION_VAL_390_IT },
         { "400", OPTION_VAL_400_IT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_IT,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_IT,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_IT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_IT  },
         { "20",  OPTION_VAL_20_IT  },
         { "30",  OPTION_VAL_30_IT  },
         { "40",  OPTION_VAL_40_IT  },
         { "50",  OPTION_VAL_50_IT  },
         { "60",  OPTION_VAL_60_IT  },
         { "70",  OPTION_VAL_70_IT  },
         { "80",  OPTION_VAL_80_IT  },
         { "90",  OPTION_VAL_90_IT  },
         { "100", OPTION_VAL_100_IT },
         { "110", OPTION_VAL_110_IT },
         { "120", OPTION_VAL_120_IT },
         { "130", OPTION_VAL_130_IT },
         { "140", OPTION_VAL_140_IT },
         { "150", OPTION_VAL_150_IT },
         { "160", OPTION_VAL_160_IT },
         { "170", OPTION_VAL_170_IT },
         { "180", OPTION_VAL_180_IT },
         { "190", OPTION_VAL_190_IT },
         { "200", OPTION_VAL_200_IT },
         { "210", OPTION_VAL_210_IT },
         { "220", OPTION_VAL_220_IT },
         { "230", OPTION_VAL_230_IT },
         { "240", OPTION_VAL_240_IT },
         { "250", OPTION_VAL_250_IT },
         { "260", OPTION_VAL_260_IT },
         { "270", OPTION_VAL_270_IT },
         { "280", OPTION_VAL_280_IT },
         { "290", OPTION_VAL_290_IT },
         { "300", OPTION_VAL_300_IT },
         { "310", OPTION_VAL_310_IT },
         { "320", OPTION_VAL_320_IT },
         { "330", OPTION_VAL_330_IT },
         { "340", OPTION_VAL_340_IT },
         { "350", OPTION_VAL_350_IT },
         { "360", OPTION_VAL_360_IT },
         { "370", OPTION_VAL_370_IT },
         { "380", OPTION_VAL_380_IT },
         { "390", OPTION_VAL_390_IT },
         { "400", OPTION_VAL_400_IT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_IT,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_IT,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_IT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_IT  },
         { "20",  OPTION_VAL_20_IT  },
         { "30",  OPTION_VAL_30_IT  },
         { "40",  OPTION_VAL_40_IT  },
         { "50",  OPTION_VAL_50_IT  },
         { "60",  OPTION_VAL_60_IT  },
         { "70",  OPTION_VAL_70_IT  },
         { "80",  OPTION_VAL_80_IT  },
         { "90",  OPTION_VAL_90_IT  },
         { "100", OPTION_VAL_100_IT },
         { "110", OPTION_VAL_110_IT },
         { "120", OPTION_VAL_120_IT },
         { "130", OPTION_VAL_130_IT },
         { "140", OPTION_VAL_140_IT },
         { "150", OPTION_VAL_150_IT },
         { "160", OPTION_VAL_160_IT },
         { "170", OPTION_VAL_170_IT },
         { "180", OPTION_VAL_180_IT },
         { "190", OPTION_VAL_190_IT },
         { "200", OPTION_VAL_200_IT },
         { "210", OPTION_VAL_210_IT },
         { "220", OPTION_VAL_220_IT },
         { "230", OPTION_VAL_230_IT },
         { "240", OPTION_VAL_240_IT },
         { "250", OPTION_VAL_250_IT },
         { "260", OPTION_VAL_260_IT },
         { "270", OPTION_VAL_270_IT },
         { "280", OPTION_VAL_280_IT },
         { "290", OPTION_VAL_290_IT },
         { "300", OPTION_VAL_300_IT },
         { "310", OPTION_VAL_310_IT },
         { "320", OPTION_VAL_320_IT },
         { "330", OPTION_VAL_330_IT },
         { "340", OPTION_VAL_340_IT },
         { "350", OPTION_VAL_350_IT },
         { "360", OPTION_VAL_360_IT },
         { "370", OPTION_VAL_370_IT },
         { "380", OPTION_VAL_380_IT },
         { "390", OPTION_VAL_390_IT },
         { "400", OPTION_VAL_400_IT },
         { "410", OPTION_VAL_410_IT },
         { "420", OPTION_VAL_420_IT },
         { "430", OPTION_VAL_430_IT },
         { "440", OPTION_VAL_440_IT },
         { "450", OPTION_VAL_450_IT },
         { "460", OPTION_VAL_460_IT },
         { "470", OPTION_VAL_470_IT },
         { "480", OPTION_VAL_480_IT },
         { "490", OPTION_VAL_490_IT },
         { "500", OPTION_VAL_500_IT },
         { "510", OPTION_VAL_510_IT },
         { "520", OPTION_VAL_520_IT },
         { "530", OPTION_VAL_530_IT },
         { "540", OPTION_VAL_540_IT },
         { "550", OPTION_VAL_550_IT },
         { "560", OPTION_VAL_560_IT },
         { "570", OPTION_VAL_570_IT },
         { "580", OPTION_VAL_580_IT },
         { "590", OPTION_VAL_590_IT },
         { "600", OPTION_VAL_600_IT },
         { "610", OPTION_VAL_610_IT },
         { "620", OPTION_VAL_620_IT },
         { "630", OPTION_VAL_630_IT },
         { "640", OPTION_VAL_640_IT },
         { "650", OPTION_VAL_650_IT },
         { "660", OPTION_VAL_660_IT },
         { "670", OPTION_VAL_670_IT },
         { "680", OPTION_VAL_680_IT },
         { "690", OPTION_VAL_690_IT },
         { "700", OPTION_VAL_700_IT },
         { "710", OPTION_VAL_710_IT },
         { "720", OPTION_VAL_720_IT },
         { "730", OPTION_VAL_730_IT },
         { "740", OPTION_VAL_740_IT },
         { "750", OPTION_VAL_750_IT },
         { "760", OPTION_VAL_760_IT },
         { "770", OPTION_VAL_770_IT },
         { "780", OPTION_VAL_780_IT },
         { "790", OPTION_VAL_790_IT },
         { "800", OPTION_VAL_800_IT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_IT,
      NULL,
      BSNES_SGB_BIOS_INFO_0_IT,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_IT   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_IT },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_IT,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_IT,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_IT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_IT,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_IT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_IT,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_it = {
   option_cats_it,
   option_defs_it
};

/* RETRO_LANGUAGE_JA */

#define CATEGORY_VIDEO_LABEL_JA "ビデオ"
#define CATEGORY_VIDEO_INFO_0_JA "ビデオ出力の設定を変更します。"
#define CATEGORY_AUDIO_LABEL_JA "オーディオ"
#define CATEGORY_AUDIO_INFO_0_JA "オーディオ出力の設定を変更します。"
#define CATEGORY_MODE7_LABEL_JA "HD モード 7"
#define CATEGORY_MODE7_INFO_0_JA "モード 7 グラフィックエミュレーションに関する設定を変更します。"
#define CATEGORY_HACK_LABEL_JA "エミュレーションハックと拡張"
#define CATEGORY_HACK_INFO_0_JA "エミュレーションハック、拡張およびホットフィックスを適用します。"
#define CATEGORY_OVERCLOCK_LABEL_JA "オーバー/ダウンクロック"
#define CATEGORY_OVERCLOCK_INFO_0_JA "エミュレートされたハードウェアの速度を変更します。"
#define CATEGORY_SGB_LABEL_JA "スーパーゲームボーイ"
#define CATEGORY_SGB_INFO_0_JA "スーパーゲームボーイのエミュレーションに関する設定を変更します。"
#define CATEGORY_LIGHTGUN_LABEL_JA "ライトガン"
#define CATEGORY_LIGHTGUN_INFO_0_JA "(タッチスクリーン) ライトガンの設定を変更します。"
#define BSNES_ASPECT_RATIO_LABEL_JA "優先アスペクト比"
#define BSNES_ASPECT_RATIO_INFO_0_JA "コンテンツの優先アスペクト比を選択します。RetroArch のアスペクト比がビデオ設定で [コア提供] に設定されている場合にのみ適用されます。"
#define OPTION_VAL_AUTO_JA "自動"
#define OPTION_VAL_1_1_JA "1:1 PAR (ピクセルパーフェクト)"
#define OPTION_VAL_4_3_JA NULL
#define OPTION_VAL_NTSC_JA NULL
#define OPTION_VAL_PAL_JA NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_JA "垂直オーバースキャンをトリミング"
#define BSNES_PPU_OVERSCAN_V_INFO_0_JA "スーパーファミコン時代のテレビを再現するために、画面の上下から指定した行数を削除します。"
#define OPTION_VAL_0_JA "0 行"
#define OPTION_VAL_8_JA "8 行"
#define OPTION_VAL_12_JA "12 行"
#define OPTION_VAL_16_JA "16 行"
#define BSNES_BLUR_EMULATION_LABEL_JA "ぼかしエミュレーション"
#define BSNES_BLUR_EMULATION_INFO_0_JA "水平方向に隣接するピクセルをぼかすことで、標準画質テレビの限られた水平解像度をシミュレートします。ゲームによっては、透明効果をエミュレートするためにこのオプションを有効にする必要があります。"
#define BSNES_VIDEO_FILTER_LABEL_JA "フィルター"
#define BSNES_VIDEO_FILTER_INFO_0_JA "RF、コンポジット、S端子および RGB のオプションを含む Blargg NTSC フィルターの有効化と無効化を選択します。"
#define OPTION_VAL_NONE_JA "なし"
#define OPTION_VAL_NTSC_RF_JA NULL
#define OPTION_VAL_NTSC_COMPOSITE_JA "NTSC (コンポジット)"
#define OPTION_VAL_NTSC_S_VIDEO_JA "NTSC (S端子)"
#define OPTION_VAL_NTSC_RGB_JA NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_JA "色補正 - 輝度"
#define BSNES_VIDEO_LUMINANCE_INFO_0_JA "輝度を調整します。"
#define OPTION_VAL_0_O4_JA NULL
#define OPTION_VAL_10_JA NULL
#define OPTION_VAL_20_JA NULL
#define OPTION_VAL_30_JA NULL
#define OPTION_VAL_40_JA NULL
#define OPTION_VAL_50_JA NULL
#define OPTION_VAL_60_JA NULL
#define OPTION_VAL_70_JA NULL
#define OPTION_VAL_80_JA NULL
#define OPTION_VAL_90_JA NULL
#define OPTION_VAL_100_JA "100% (デフォルト)"
#define BSNES_VIDEO_SATURATION_LABEL_JA "色補正 - 彩度"
#define BSNES_VIDEO_SATURATION_INFO_0_JA "彩度を調整します。"
#define OPTION_VAL_110_JA NULL
#define OPTION_VAL_120_JA NULL
#define OPTION_VAL_130_JA NULL
#define OPTION_VAL_140_JA NULL
#define OPTION_VAL_150_JA NULL
#define OPTION_VAL_160_JA NULL
#define OPTION_VAL_170_JA NULL
#define OPTION_VAL_180_JA NULL
#define OPTION_VAL_190_JA NULL
#define OPTION_VAL_200_JA NULL
#define BSNES_VIDEO_GAMMA_LABEL_JA "色補正 - ガンマ"
#define BSNES_VIDEO_GAMMA_INFO_0_JA "ガンマ値を調整します。"
#define OPTION_VAL_100_O6_JA NULL
#define OPTION_VAL_150_O6_JA "150% (デフォルト)"
#define BSNES_PPU_FAST_LABEL_JA "PPU (ビデオ) - 高速モード"
#define BSNES_PPU_FAST_LABEL_CAT_JA "PPU - 高速モード"
#define BSNES_PPU_FAST_INFO_0_JA "精度をわずかに犠牲にして、PPU の高速エミュレーションを有効にします。オンのままにしておくことをお勧めします。注意: [インターレース解除]、[スプライト制限なし] および [HD モード7] を動作させるには、このオプションを有効にする必要があります。"
#define BSNES_PPU_DEINTERLACE_LABEL_JA "PPU (ビデオ) - インターレース解除"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_JA "PPU - インターレース解除"
#define BSNES_PPU_DEINTERLACE_INFO_0_JA "内部的に 480p でレンダリングすることで、すべてのゲームのインターレースを解除します。パフォーマンスへの影響はほぼ存在しないため、オンのままにしておくことを推奨します。"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_JA "PPU (Video) - スプライト制限なし"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_JA "PPU - スプライト制限なし"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_JA "画面上に同時に描画できるスプライトの数の制限を解除します。一部のゲームで問題が発生する可能性があります。"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_JA "PPU (ビデオ) - VRAM ブロックなし"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_JA "PPU - VRAM ブロックなし"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_JA "VRAM ブロックがエミュレートされていない古い ZSNES と Snes9X のバグをエミュレートします。一部の ROM ハックはこの動作に依存しており、有効にしない場合グラフィックが正しく描画されません。このオプションは非常に不正確であり、PPU 速度に悪影響を与えるため、必要な場合以外無効のままにしておくことをお勧めします。"
#define BSNES_DSP_FAST_LABEL_JA "DSP (オーディオ) - 高速モード"
#define BSNES_DSP_FAST_LABEL_CAT_JA "DSP - 高速モード"
#define BSNES_DSP_FAST_INFO_0_JA "精度をわずかに犠牲にして DSP の高速エミュレーションを有効にします。オンのままにしておくことをお勧めします。"
#define BSNES_DSP_CUBIC_LABEL_JA "DSP (オーディオ) - キュービック補間"
#define BSNES_DSP_CUBIC_LABEL_CAT_JA "DSP - キュービック補間"
#define BSNES_DSP_CUBIC_INFO_0_JA "サウンドにキュービック補完を適用し、より高い音域を維持します。"
#define BSNES_DSP_ECHO_SHADOW_LABEL_JA "DSP (オーディオ) - エコーシャドウ RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_JA "DSP - エコーシャドウ RAM"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_JA "エコー RAM が APU RAM とは別に扱われた ZSNES のバグをエミュレートします。スーパーマリオワールドの古い ROM ハックの多くはこの動作に依存しており、有効にしない場合ゲームがクラッシュします。このオプションは非常に不正確であり、必要がない限り有効にしないでください。"
#define BSNES_MODE7_SCALE_LABEL_JA "HD モード 7 - 倍率"
#define BSNES_MODE7_SCALE_LABEL_CAT_JA "倍率"
#define BSNES_MODE7_SCALE_INFO_0_JA "特定のゲームで使用されるモード 7 グラフィックスの水平および垂直解像度を向上させます。"
#define OPTION_VAL_1X_JA NULL
#define OPTION_VAL_2X_JA NULL
#define OPTION_VAL_3X_JA NULL
#define OPTION_VAL_4X_JA NULL
#define OPTION_VAL_5X_JA NULL
#define OPTION_VAL_6X_JA NULL
#define OPTION_VAL_7X_JA NULL
#define OPTION_VAL_8X_JA NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_JA "HD モード 7 - 視点補正"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_JA "視点補正"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_JA "特定のゲームで使用されるモード 7 グラフィックスの視点を、スーパーファミコンで使用される整数演算の制限を回避することで補正します。"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_JA "HD モード 7 - スーパーサンプリング"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_JA "スーパーサンプリング"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_JA "特定のゲームで使用されるモード 7 グラフィックをスーパーサンプリングします。より高い モード 7 表示倍率と組み合わせることで、アンチエイリアスと同様の効果を発揮します。"
#define BSNES_MODE7_MOSAIC_LABEL_JA "HD モード 7 - HD->SD モザイク"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_JA "HD->SD モザイク"
#define BSNES_MODE7_MOSAIC_INFO_0_JA "モード 7 グラフィックスのモザイク効果をアップスケーリング時にも表示します。"
#define BSNES_RUN_AHEAD_FRAMES_LABEL_JA "内部先行実行"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_JA "事前にシステムをシミュレートし、ロールバックすることで入力遅延を短縮します。非常に高いシステム要件を必要とします。"
#define OPTION_VAL_1_JA "1 フレーム"
#define OPTION_VAL_2_JA "2 フレーム"
#define OPTION_VAL_3_JA "3 フレーム"
#define OPTION_VAL_4_JA "4 フレーム"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_JA "コプロセッサ - 高速モード"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_JA "精度をわずかに犠牲にして、コプロセッサのエミュレーションを高速化します。有効のままにしておくことをお勧めします。"
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_JA "コプロセッサ - HLE 優先"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_JA "このオプションを有効にすると、精度の低い HLE エミュレーションが利用可能な場合に常に使用されます。無効にすると、HLE は LLE ファームウェアが不足している場合にのみ使用されます。"
#define BSNES_HOTFIXES_LABEL_JA "ホットフィックス"
#define BSNES_HOTFIXES_INFO_0_JA "商業的にライセンスされ、正式に発売されたソフトウェアであっても、バグを含んだまま出荷されることがあります。このオプションは、実機で発生する特定の問題を修正します。"
#define BSNES_ENTROPY_LABEL_JA "エントロピー (ランダム化)"
#define BSNES_ENTROPY_INFO_0_JA "メモリとレジスタのランダム化レベルを選択します。[なし] に設定すると、すべてのメモリとレジスタは起動時に一定の値に初期化されます。[低] に設定すると、実際のシステムを最も正確に再現し、[高] に設定すると、可能な限りランダム化します。"
#define OPTION_VAL_LOW_JA "低"
#define OPTION_VAL_HIGH_JA "高"
#define BSNES_CPU_FASTMATH_LABEL_JA "CPU 高速計算"
#define BSNES_CPU_FASTMATH_INFO_0_JA "計算結果を即座に提供します。スーパーファミコン実機では、CPU 乗算や除算を一瞬で完了することはできません。古いエミュレータはこれらの遅延をシミュレートしなかったため、古い ROM ハックの一部にこのハックを必要とするものがあります。"
#define BSNES_CPU_OVERCLOCK_LABEL_JA "オーバークロック - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_JA NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_JA "CPU をオーバークロックまたはダウンクロックします。この値を 100% 以上に設定すると、読み込み速度や実行速度の低下が軽減される場合があります。ゲームがクラッシュしたり、その他の問題が発生する可能性があるため、注意して使用してください。"
#define OPTION_VAL_210_JA NULL
#define OPTION_VAL_220_JA NULL
#define OPTION_VAL_230_JA NULL
#define OPTION_VAL_240_JA NULL
#define OPTION_VAL_250_JA NULL
#define OPTION_VAL_260_JA NULL
#define OPTION_VAL_270_JA NULL
#define OPTION_VAL_280_JA NULL
#define OPTION_VAL_290_JA NULL
#define OPTION_VAL_300_JA NULL
#define OPTION_VAL_310_JA NULL
#define OPTION_VAL_320_JA NULL
#define OPTION_VAL_330_JA NULL
#define OPTION_VAL_340_JA NULL
#define OPTION_VAL_350_JA NULL
#define OPTION_VAL_360_JA NULL
#define OPTION_VAL_370_JA NULL
#define OPTION_VAL_380_JA NULL
#define OPTION_VAL_390_JA NULL
#define OPTION_VAL_400_JA NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_JA "オーバークロック - SA-1 コプロセッサ"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_JA "SA-1 コプロセッサ"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_JA "SA-1 拡張チップをオーバークロックまたはダウンクロックします。この値を 100% 以上に設定すると、SA-1 チップをサポートするゲームで実行速度が向上する可能性があります。一部のゲームがクラッシュしたり、他の問題が発生する可能性があるため、注意して使用してください。"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_JA "オーバークロック - SuperFX コプロセッサ"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_JA "SuperFX コプロセッサ"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_JA "SuperFX コプロセッサをオーバークロックまたはダウンクロックします。この値を 100% 以上に設定すると、SuperFX をサポートするゲームで実行速度が改善される可能性があります。一部のゲームがクラッシュしたり、他の問題を引き起こす可能性があるため、注意して使用してください。"
#define OPTION_VAL_410_JA NULL
#define OPTION_VAL_420_JA NULL
#define OPTION_VAL_430_JA NULL
#define OPTION_VAL_440_JA NULL
#define OPTION_VAL_450_JA NULL
#define OPTION_VAL_460_JA NULL
#define OPTION_VAL_470_JA NULL
#define OPTION_VAL_480_JA NULL
#define OPTION_VAL_490_JA NULL
#define OPTION_VAL_500_JA NULL
#define OPTION_VAL_510_JA NULL
#define OPTION_VAL_520_JA NULL
#define OPTION_VAL_530_JA NULL
#define OPTION_VAL_540_JA NULL
#define OPTION_VAL_550_JA NULL
#define OPTION_VAL_560_JA NULL
#define OPTION_VAL_570_JA NULL
#define OPTION_VAL_580_JA NULL
#define OPTION_VAL_590_JA NULL
#define OPTION_VAL_600_JA NULL
#define OPTION_VAL_610_JA NULL
#define OPTION_VAL_620_JA NULL
#define OPTION_VAL_630_JA NULL
#define OPTION_VAL_640_JA NULL
#define OPTION_VAL_650_JA NULL
#define OPTION_VAL_660_JA NULL
#define OPTION_VAL_670_JA NULL
#define OPTION_VAL_680_JA NULL
#define OPTION_VAL_690_JA NULL
#define OPTION_VAL_700_JA NULL
#define OPTION_VAL_710_JA NULL
#define OPTION_VAL_720_JA NULL
#define OPTION_VAL_730_JA NULL
#define OPTION_VAL_740_JA NULL
#define OPTION_VAL_750_JA NULL
#define OPTION_VAL_760_JA NULL
#define OPTION_VAL_770_JA NULL
#define OPTION_VAL_780_JA NULL
#define OPTION_VAL_790_JA NULL
#define OPTION_VAL_800_JA NULL
#define BSNES_SGB_BIOS_LABEL_JA "優先スーパーゲームボーイ BIOS (再起動が必要)"
#define BSNES_SGB_BIOS_INFO_0_JA "互換性のあるタイトルで優先して使用するスーパーゲームボーイの BIOS を選択します。"
#define OPTION_VAL_SGB1_SFC_JA "スーパーゲームボーイ (SGB1.sfc)"
#define OPTION_VAL_SGB2_SFC_JA "スーパーゲームボーイ 2 (SGB2.sfc)"
#define BSNES_HIDE_SGB_BORDER_LABEL_JA "SGB 外枠を隠す"
#define BSNES_HIDE_SGB_BORDER_INFO_0_JA "スーパーゲームボーイ対応ゲームをプレイする際に外枠を非表示にします。"
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_JA "タッチスクリーンライトガン"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_JA "タッチスクリーンデバイスでスーパースコープ入力を有効にします。"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_JA "スーパースコープのトリガーボタンを反転"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_JA "タッチスクリーンライトガンでスーパースコープのトリガーとカーソルボタンを反転します。"

struct retro_core_option_v2_category option_cats_ja[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_JA,
      CATEGORY_VIDEO_INFO_0_JA
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_JA,
      CATEGORY_AUDIO_INFO_0_JA
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_JA,
      CATEGORY_MODE7_INFO_0_JA
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_JA,
      CATEGORY_HACK_INFO_0_JA
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_JA,
      CATEGORY_OVERCLOCK_INFO_0_JA
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_JA,
      CATEGORY_SGB_INFO_0_JA
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_JA,
      CATEGORY_LIGHTGUN_INFO_0_JA
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ja[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_JA,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_JA,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_JA },
         { "1:1",  OPTION_VAL_1_1_JA },
         { "4:3",  OPTION_VAL_4_3_JA },
         { "NTSC", OPTION_VAL_NTSC_JA },
         { "PAL",  OPTION_VAL_PAL_JA },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_JA,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_JA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_JA },
         { "8",  OPTION_VAL_8_JA },
         { "12", OPTION_VAL_12_JA },
         { "16", OPTION_VAL_16_JA },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_JA,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_JA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_JA,
      BSNES_VIDEO_FILTER_LABEL_JA,
      BSNES_VIDEO_FILTER_INFO_0_JA,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_JA },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_JA },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_JA },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_JA },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_JA },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_JA,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_JA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_JA },
         { "10", OPTION_VAL_10_JA },
         { "20", OPTION_VAL_20_JA },
         { "30", OPTION_VAL_30_JA },
         { "40", OPTION_VAL_40_JA },
         { "50", OPTION_VAL_50_JA },
         { "60", OPTION_VAL_60_JA },
         { "70", OPTION_VAL_70_JA },
         { "80", OPTION_VAL_80_JA },
         { "90", OPTION_VAL_90_JA },
         { "100", OPTION_VAL_100_JA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_JA,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_JA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_JA },
         { "10", OPTION_VAL_10_JA },
         { "20", OPTION_VAL_20_JA },
         { "30", OPTION_VAL_30_JA },
         { "40", OPTION_VAL_40_JA },
         { "50", OPTION_VAL_50_JA },
         { "60", OPTION_VAL_60_JA },
         { "70", OPTION_VAL_70_JA },
         { "80", OPTION_VAL_80_JA },
         { "90", OPTION_VAL_90_JA },
         { "100", OPTION_VAL_100_JA },
         { "110", OPTION_VAL_110_JA },
         { "120", OPTION_VAL_120_JA },
         { "130", OPTION_VAL_130_JA },
         { "140", OPTION_VAL_140_JA },
         { "150", OPTION_VAL_150_JA },
         { "160", OPTION_VAL_160_JA },
         { "170", OPTION_VAL_170_JA },
         { "180", OPTION_VAL_180_JA },
         { "190", OPTION_VAL_190_JA },
         { "200", OPTION_VAL_200_JA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_JA,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_JA,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_JA },
         { "110", OPTION_VAL_110_JA },
         { "120", OPTION_VAL_120_JA },
         { "130", OPTION_VAL_130_JA },
         { "140", OPTION_VAL_140_JA },
         { "150", OPTION_VAL_150_O6_JA },
         { "160", OPTION_VAL_160_JA },
         { "170", OPTION_VAL_170_JA },
         { "180", OPTION_VAL_180_JA },
         { "190", OPTION_VAL_190_JA },
         { "200", OPTION_VAL_200_JA },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_JA,
      BSNES_PPU_FAST_LABEL_CAT_JA,
      BSNES_PPU_FAST_INFO_0_JA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_JA,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_JA,
      BSNES_PPU_DEINTERLACE_INFO_0_JA,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_JA,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_JA,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_JA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_JA,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_JA,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_JA,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_JA,
      BSNES_DSP_FAST_LABEL_CAT_JA,
      BSNES_DSP_FAST_INFO_0_JA,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_JA,
      BSNES_DSP_CUBIC_LABEL_CAT_JA,
      BSNES_DSP_CUBIC_INFO_0_JA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_JA,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_JA,
      BSNES_DSP_ECHO_SHADOW_INFO_0_JA,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_JA,
      BSNES_MODE7_SCALE_LABEL_CAT_JA,
      BSNES_MODE7_SCALE_INFO_0_JA,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_JA  },
         { "2x", OPTION_VAL_2X_JA  },
         { "3x", OPTION_VAL_3X_JA  },
         { "4x", OPTION_VAL_4X_JA  },
         { "5x", OPTION_VAL_5X_JA },
         { "6x", OPTION_VAL_6X_JA },
         { "7x", OPTION_VAL_7X_JA },
         { "8x", OPTION_VAL_8X_JA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_JA,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_JA,
      BSNES_MODE7_PERSPECTIVE_INFO_0_JA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_JA,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_JA,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_JA,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_JA,
      BSNES_MODE7_MOSAIC_LABEL_CAT_JA,
      BSNES_MODE7_MOSAIC_INFO_0_JA,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_JA,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_JA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_JA  },
         { "2",   OPTION_VAL_2_JA },
         { "3",   OPTION_VAL_3_JA },
         { "4",   OPTION_VAL_4_JA },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_JA,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_JA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_JA,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_JA,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_JA,
      NULL,
      BSNES_HOTFIXES_INFO_0_JA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_JA,
      NULL,
      BSNES_ENTROPY_INFO_0_JA,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_JA },
         { "High", OPTION_VAL_HIGH_JA },
         { "None", OPTION_VAL_NONE_JA },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_JA,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_JA,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_JA,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_JA,
      BSNES_CPU_OVERCLOCK_INFO_0_JA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_JA  },
         { "20",  OPTION_VAL_20_JA  },
         { "30",  OPTION_VAL_30_JA  },
         { "40",  OPTION_VAL_40_JA  },
         { "50",  OPTION_VAL_50_JA  },
         { "60",  OPTION_VAL_60_JA  },
         { "70",  OPTION_VAL_70_JA  },
         { "80",  OPTION_VAL_80_JA  },
         { "90",  OPTION_VAL_90_JA  },
         { "100", OPTION_VAL_100_JA },
         { "110", OPTION_VAL_110_JA },
         { "120", OPTION_VAL_120_JA },
         { "130", OPTION_VAL_130_JA },
         { "140", OPTION_VAL_140_JA },
         { "150", OPTION_VAL_150_JA },
         { "160", OPTION_VAL_160_JA },
         { "170", OPTION_VAL_170_JA },
         { "180", OPTION_VAL_180_JA },
         { "190", OPTION_VAL_190_JA },
         { "200", OPTION_VAL_200_JA },
         { "210", OPTION_VAL_210_JA },
         { "220", OPTION_VAL_220_JA },
         { "230", OPTION_VAL_230_JA },
         { "240", OPTION_VAL_240_JA },
         { "250", OPTION_VAL_250_JA },
         { "260", OPTION_VAL_260_JA },
         { "270", OPTION_VAL_270_JA },
         { "280", OPTION_VAL_280_JA },
         { "290", OPTION_VAL_290_JA },
         { "300", OPTION_VAL_300_JA },
         { "310", OPTION_VAL_310_JA },
         { "320", OPTION_VAL_320_JA },
         { "330", OPTION_VAL_330_JA },
         { "340", OPTION_VAL_340_JA },
         { "350", OPTION_VAL_350_JA },
         { "360", OPTION_VAL_360_JA },
         { "370", OPTION_VAL_370_JA },
         { "380", OPTION_VAL_380_JA },
         { "390", OPTION_VAL_390_JA },
         { "400", OPTION_VAL_400_JA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_JA,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_JA,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_JA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_JA  },
         { "20",  OPTION_VAL_20_JA  },
         { "30",  OPTION_VAL_30_JA  },
         { "40",  OPTION_VAL_40_JA  },
         { "50",  OPTION_VAL_50_JA  },
         { "60",  OPTION_VAL_60_JA  },
         { "70",  OPTION_VAL_70_JA  },
         { "80",  OPTION_VAL_80_JA  },
         { "90",  OPTION_VAL_90_JA  },
         { "100", OPTION_VAL_100_JA },
         { "110", OPTION_VAL_110_JA },
         { "120", OPTION_VAL_120_JA },
         { "130", OPTION_VAL_130_JA },
         { "140", OPTION_VAL_140_JA },
         { "150", OPTION_VAL_150_JA },
         { "160", OPTION_VAL_160_JA },
         { "170", OPTION_VAL_170_JA },
         { "180", OPTION_VAL_180_JA },
         { "190", OPTION_VAL_190_JA },
         { "200", OPTION_VAL_200_JA },
         { "210", OPTION_VAL_210_JA },
         { "220", OPTION_VAL_220_JA },
         { "230", OPTION_VAL_230_JA },
         { "240", OPTION_VAL_240_JA },
         { "250", OPTION_VAL_250_JA },
         { "260", OPTION_VAL_260_JA },
         { "270", OPTION_VAL_270_JA },
         { "280", OPTION_VAL_280_JA },
         { "290", OPTION_VAL_290_JA },
         { "300", OPTION_VAL_300_JA },
         { "310", OPTION_VAL_310_JA },
         { "320", OPTION_VAL_320_JA },
         { "330", OPTION_VAL_330_JA },
         { "340", OPTION_VAL_340_JA },
         { "350", OPTION_VAL_350_JA },
         { "360", OPTION_VAL_360_JA },
         { "370", OPTION_VAL_370_JA },
         { "380", OPTION_VAL_380_JA },
         { "390", OPTION_VAL_390_JA },
         { "400", OPTION_VAL_400_JA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_JA,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_JA,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_JA,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_JA  },
         { "20",  OPTION_VAL_20_JA  },
         { "30",  OPTION_VAL_30_JA  },
         { "40",  OPTION_VAL_40_JA  },
         { "50",  OPTION_VAL_50_JA  },
         { "60",  OPTION_VAL_60_JA  },
         { "70",  OPTION_VAL_70_JA  },
         { "80",  OPTION_VAL_80_JA  },
         { "90",  OPTION_VAL_90_JA  },
         { "100", OPTION_VAL_100_JA },
         { "110", OPTION_VAL_110_JA },
         { "120", OPTION_VAL_120_JA },
         { "130", OPTION_VAL_130_JA },
         { "140", OPTION_VAL_140_JA },
         { "150", OPTION_VAL_150_JA },
         { "160", OPTION_VAL_160_JA },
         { "170", OPTION_VAL_170_JA },
         { "180", OPTION_VAL_180_JA },
         { "190", OPTION_VAL_190_JA },
         { "200", OPTION_VAL_200_JA },
         { "210", OPTION_VAL_210_JA },
         { "220", OPTION_VAL_220_JA },
         { "230", OPTION_VAL_230_JA },
         { "240", OPTION_VAL_240_JA },
         { "250", OPTION_VAL_250_JA },
         { "260", OPTION_VAL_260_JA },
         { "270", OPTION_VAL_270_JA },
         { "280", OPTION_VAL_280_JA },
         { "290", OPTION_VAL_290_JA },
         { "300", OPTION_VAL_300_JA },
         { "310", OPTION_VAL_310_JA },
         { "320", OPTION_VAL_320_JA },
         { "330", OPTION_VAL_330_JA },
         { "340", OPTION_VAL_340_JA },
         { "350", OPTION_VAL_350_JA },
         { "360", OPTION_VAL_360_JA },
         { "370", OPTION_VAL_370_JA },
         { "380", OPTION_VAL_380_JA },
         { "390", OPTION_VAL_390_JA },
         { "400", OPTION_VAL_400_JA },
         { "410", OPTION_VAL_410_JA },
         { "420", OPTION_VAL_420_JA },
         { "430", OPTION_VAL_430_JA },
         { "440", OPTION_VAL_440_JA },
         { "450", OPTION_VAL_450_JA },
         { "460", OPTION_VAL_460_JA },
         { "470", OPTION_VAL_470_JA },
         { "480", OPTION_VAL_480_JA },
         { "490", OPTION_VAL_490_JA },
         { "500", OPTION_VAL_500_JA },
         { "510", OPTION_VAL_510_JA },
         { "520", OPTION_VAL_520_JA },
         { "530", OPTION_VAL_530_JA },
         { "540", OPTION_VAL_540_JA },
         { "550", OPTION_VAL_550_JA },
         { "560", OPTION_VAL_560_JA },
         { "570", OPTION_VAL_570_JA },
         { "580", OPTION_VAL_580_JA },
         { "590", OPTION_VAL_590_JA },
         { "600", OPTION_VAL_600_JA },
         { "610", OPTION_VAL_610_JA },
         { "620", OPTION_VAL_620_JA },
         { "630", OPTION_VAL_630_JA },
         { "640", OPTION_VAL_640_JA },
         { "650", OPTION_VAL_650_JA },
         { "660", OPTION_VAL_660_JA },
         { "670", OPTION_VAL_670_JA },
         { "680", OPTION_VAL_680_JA },
         { "690", OPTION_VAL_690_JA },
         { "700", OPTION_VAL_700_JA },
         { "710", OPTION_VAL_710_JA },
         { "720", OPTION_VAL_720_JA },
         { "730", OPTION_VAL_730_JA },
         { "740", OPTION_VAL_740_JA },
         { "750", OPTION_VAL_750_JA },
         { "760", OPTION_VAL_760_JA },
         { "770", OPTION_VAL_770_JA },
         { "780", OPTION_VAL_780_JA },
         { "790", OPTION_VAL_790_JA },
         { "800", OPTION_VAL_800_JA },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_JA,
      NULL,
      BSNES_SGB_BIOS_INFO_0_JA,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_JA   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_JA },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_JA,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_JA,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_JA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_JA,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_JA,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_JA,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ja = {
   option_cats_ja,
   option_defs_ja
};

/* RETRO_LANGUAGE_KO */

#define CATEGORY_VIDEO_LABEL_KO "비디오"
#define CATEGORY_VIDEO_INFO_0_KO "비디오 출력 설정을 변경합니다."
#define CATEGORY_AUDIO_LABEL_KO "오디오"
#define CATEGORY_AUDIO_INFO_0_KO "오디오 출력 설정을 변경합니다."
#define CATEGORY_MODE7_LABEL_KO NULL
#define CATEGORY_MODE7_INFO_0_KO "Mode 7 그래픽 관련 설정을 변경합니다."
#define CATEGORY_HACK_LABEL_KO "에뮬레이션 핵 및 개선"
#define CATEGORY_HACK_INFO_0_KO "에뮬레이션 핵, 개선, 핫픽스 등을 적용합니다."
#define CATEGORY_OVERCLOCK_LABEL_KO "오버/다운클러킹"
#define CATEGORY_OVERCLOCK_INFO_0_KO "에뮬레이트하는 하드웨어의 속도를 변경합니다."
#define CATEGORY_SGB_LABEL_KO NULL
#define CATEGORY_SGB_INFO_0_KO "Super Game Boy 에뮬레이션 관련 설정을 변경합니다."
#define CATEGORY_LIGHTGUN_LABEL_KO "라이트 건"
#define CATEGORY_LIGHTGUN_INFO_0_KO "(터치스크린) 라이트 건 설정을 변경합니다."
#define BSNES_ASPECT_RATIO_LABEL_KO "선호하는 화면비"
#define BSNES_ASPECT_RATIO_INFO_0_KO "선호하는 컨텐츠 화면비를 선택합니다. RetroArch의 비디오 설정에서 화면비가 'Core provided'로 설정되어 있어야 적용됩니다."
#define OPTION_VAL_AUTO_KO "자동"
#define OPTION_VAL_1_1_KO "1:1 PAR (픽셀 퍼펙트)"
#define OPTION_VAL_4_3_KO NULL
#define OPTION_VAL_NTSC_KO NULL
#define OPTION_VAL_PAL_KO NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_KO "세로 오버스캔 잘라내기"
#define BSNES_PPU_OVERSCAN_V_INFO_0_KO "화면 위아래에서 N개의 줄을 가려 SNES 시절 TV의 베젤 효과를 흉내냅니다."
#define OPTION_VAL_0_KO "0줄"
#define OPTION_VAL_8_KO "8줄"
#define OPTION_VAL_12_KO "12줄"
#define OPTION_VAL_16_KO "16줄"
#define BSNES_BLUR_EMULATION_LABEL_KO "블러 에뮬레이션"
#define BSNES_BLUR_EMULATION_INFO_0_KO "오래된 TV의 낮은 가로 해상도로 인해 발생하는 가로로 인접한 픽셀들 사이의 흐림 효과를 흉내냅니다. 일부 게임은 이 기능을 활용해 반투명 효과를 구현합니다."
#define BSNES_VIDEO_FILTER_LABEL_KO "필터"
#define BSNES_VIDEO_FILTER_INFO_0_KO "필터링 없음과 RF, 컴포지트, S-Video 또는 RGB 옵션이 포함된 blargg의 NTSC 필터 중에서 선택"
#define OPTION_VAL_NONE_KO "없음"
#define OPTION_VAL_NTSC_RF_KO NULL
#define OPTION_VAL_NTSC_COMPOSITE_KO "NTSC (컴포지트)"
#define OPTION_VAL_NTSC_S_VIDEO_KO NULL
#define OPTION_VAL_NTSC_RGB_KO NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_KO "색상 조정 - 휘도"
#define BSNES_VIDEO_LUMINANCE_INFO_0_KO "휘도 조정"
#define OPTION_VAL_0_O4_KO NULL
#define OPTION_VAL_10_KO NULL
#define OPTION_VAL_20_KO NULL
#define OPTION_VAL_30_KO NULL
#define OPTION_VAL_40_KO NULL
#define OPTION_VAL_50_KO NULL
#define OPTION_VAL_60_KO NULL
#define OPTION_VAL_70_KO NULL
#define OPTION_VAL_80_KO NULL
#define OPTION_VAL_90_KO NULL
#define OPTION_VAL_100_KO "100% (기본)"
#define BSNES_VIDEO_SATURATION_LABEL_KO "색상 조정 - 채도"
#define BSNES_VIDEO_SATURATION_INFO_0_KO "채도 조정"
#define OPTION_VAL_110_KO NULL
#define OPTION_VAL_120_KO NULL
#define OPTION_VAL_130_KO NULL
#define OPTION_VAL_140_KO NULL
#define OPTION_VAL_150_KO NULL
#define OPTION_VAL_160_KO NULL
#define OPTION_VAL_170_KO NULL
#define OPTION_VAL_180_KO NULL
#define OPTION_VAL_190_KO NULL
#define OPTION_VAL_200_KO NULL
#define BSNES_VIDEO_GAMMA_LABEL_KO "색상 조정 - 감마"
#define BSNES_VIDEO_GAMMA_INFO_0_KO "감마 조정"
#define OPTION_VAL_100_O6_KO NULL
#define OPTION_VAL_150_O6_KO "150% (기본값)"
#define BSNES_PPU_FAST_LABEL_KO "PPU (비디오) - 빠르게"
#define BSNES_PPU_FAST_LABEL_CAT_KO "PPU - 빠르게"
#define BSNES_PPU_FAST_INFO_0_KO "약간의 정확도를 희생하여 PPU 에뮬레이션을 좀 더 빠르게 실행합니다. 이 옵션은 활성화해두는 것이 권장됩니다. 주의: '디인터레이스', '스프라이트 제한 해제', 'HD Mode 7'을 사용하려면 이 옵션이 활성화되어 있어야 합니다."
#define BSNES_PPU_DEINTERLACE_LABEL_KO "PPU (비디오) - 디인터레이스"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_KO "PPU - 디인터레이스"
#define BSNES_PPU_DEINTERLACE_INFO_0_KO "모든 게임을 내부적으로 480p로 렌더링하여 디인터레이싱을 합니다. 성능에는 거의 영향이 없으므로 이 옵션은 활성화해두는 것이 권장됩니다."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_KO "PPU (비디오) - 스프라이트 제한 해제"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_KO "PPU - 스프라이트 제한 해제"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_KO "화면에 한 번에 그려질 수 있는 스프라이트 수 제한을 해제합니다. 일부 게임에서는 문제를 일으킬 수 있습니다."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_KO "PPU (비디오) - VRAM 블로킹 없애기"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_KO "PPU - VRAM 블로킹 없애기"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_KO "오래된 버전의 ZSNES와 Snes9x의 버그였던 VRAM 블로킹 미구현을 흉내냅니다. 일부 오래된 ROM 핵들은 이러한 행동에 의존적이므로 이 옵션이 비활성화될 경우 그래픽 문제가 발생할 수 있습니다. 이 옵션은 에뮬레이션 정확도를 매우 크게 떨어트리고 PPU 속도를 크게 감소시키므로, 이 옵션이 필요한 게임을 플레이하는 경우가 아니라면 비활성화하는 것이 권장됩니다."
#define BSNES_DSP_FAST_LABEL_KO "DSP (오디오) - 빠르게"
#define BSNES_DSP_FAST_LABEL_CAT_KO "DSP - 빠르게"
#define BSNES_DSP_FAST_INFO_0_KO "약간의 정확도를 희생하여 DSP 에뮬레이션을 좀 더 빠르게 실행합니다. 이 옵션은 활성화해두는 것이 권장됩니다."
#define BSNES_DSP_CUBIC_LABEL_KO "DSP (오디오) - 입방형 보간"
#define BSNES_DSP_CUBIC_LABEL_CAT_KO "DSP - 입방형 보간"
#define BSNES_DSP_CUBIC_INFO_0_KO "소리에 입방형 보간을 적용하여 더 넓은 범위의 소리를 재생합니다."
#define BSNES_DSP_ECHO_SHADOW_LABEL_KO "DSP (오디오) - 에코 섀도 RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_KO "DSP - 에코 섀도 RAM"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_KO "ZSNES의 버그였던 APU RAM과 에코 RAM을 별개로 취급하는 행동을 흉내냅니다. 상당수의 오래 된 Super Mario World ROM 핵들이 이 행동에 의존적이며 이 옵션이 비활성화될 경우 크래시합니다. 이 옵션은 에뮬레이션 정확도를 매우 크게 떨어트리므로 필요한 경우가 아니면 비활성화되어야 합니다."
#define BSNES_MODE7_SCALE_LABEL_KO "HD Mode 7 - 배수"
#define BSNES_MODE7_SCALE_LABEL_CAT_KO "크기"
#define BSNES_MODE7_SCALE_INFO_0_KO "일부 게임에서 사용되는 Mode 7 그래픽의 가로 및 세로 해상도를 증가시킵니다."
#define OPTION_VAL_1X_KO NULL
#define OPTION_VAL_2X_KO NULL
#define OPTION_VAL_3X_KO NULL
#define OPTION_VAL_4X_KO NULL
#define OPTION_VAL_5X_KO NULL
#define OPTION_VAL_6X_KO NULL
#define OPTION_VAL_7X_KO NULL
#define OPTION_VAL_8X_KO NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_KO "HD Mode 7 - 원근 교정"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_KO "원근 교정"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_KO "SNES의 정수 연산으로 인해 생기는 한계를 우회하여 일부 게임의 Mode 7 그래픽의 원근 문제를 수정합니다."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_KO "HD Mode 7 - 슈퍼샘플링"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_KO "슈퍼샘플링"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_KO "일부 게임의 Mode 7 그래픽을 슈퍼샘플링합니다. 높은 Mode 7 배수와 함께 사용될 경우, 안티앨리어싱과 유사한 효과가 나타납니다."
#define BSNES_MODE7_MOSAIC_LABEL_KO "HD Mode 7 - HD->SD 모자이크"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_KO "HD->SD 모자이크"
#define BSNES_MODE7_MOSAIC_INFO_0_KO "Mode 7 그래픽을 업스케일링하고 있더라도 모자이크 효과를 표시합니다."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_KO "자체 미리 실행"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_KO "시스템의 앞 몇 프레임을 미리 실행하고 롤백하여 입력 지연을 줄입니다. 높은 성능이 필요합니다."
#define OPTION_VAL_1_KO "1 프레임"
#define OPTION_VAL_2_KO "2 프레임"
#define OPTION_VAL_3_KO "3 프레임"
#define OPTION_VAL_4_KO "4 프레임"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_KO "보조프로세서 - 빠르게"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_KO "약간의 정확도를 희생하여 보조 프로세서 에뮬레이션을 좀 더 빠르게 실행합니다. 이 옵션은 활성화해두는 것이 권장됩니다."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_KO "보조프로세서 - HLE 선호"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_KO "이 옵션을 활성화하면, 사용 가능한 경우 조금 더 부정확한 HLE 에뮬레이션이 사용됩니다. 비활성화할 경우, LLE 펌웨어가 없을 때만 HLE가 사용됩니다."
#define BSNES_HOTFIXES_LABEL_KO "핫픽스"
#define BSNES_HOTFIXES_INFO_0_KO "상용 라이센스를 받아 정식 배포된 게임에도 다양한 버그가 존재합니다. 이 옵션은 실제 하드웨어에서도 발생하는 그러한 버그들을 수정합니다."
#define BSNES_ENTROPY_LABEL_KO "엔트로피 (난수화)"
#define BSNES_ENTROPY_INFO_0_KO "메모리와 레지스터의 난수화 강도를 선택합니다. 없음으로 설정할 경우, 코어가 시작될 때 메모리와 레지스터의 모든 값이 특정한 상수값으로 초기화됩니다. 낮음은 실제 시스템을 가장 비슷하게 흉내냅니다. 높음은 난수화할 수 있는 모든 값을 난수화합니다."
#define OPTION_VAL_LOW_KO "낮음"
#define OPTION_VAL_HIGH_KO "높음"
#define BSNES_CPU_FASTMATH_LABEL_KO "CPU 빠른 수연산"
#define BSNES_CPU_FASTMATH_INFO_0_KO "연산 결과를 즉시 제공합니다. 실제 SNES에서 CPU 곱셈과 나눗셈은 연산에 꽤 긴 시간이 걸렸습니다. 오래된 에뮬레이터들은 이 지연을 무시하고 즉시 결과를 제공했으며 일부 오래된 ROM 핵들은 이 행동에 의존하여 수연산의 완료를 기다리지 않았으므로 이 핵을 필요로 합니다."
#define BSNES_CPU_OVERCLOCK_LABEL_KO "오버클러킹 - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_KO NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_KO "CPU를 오버클럭 또는 다운클럭합니다. 이 값을 100% 넘게 설정할 경우 로딩 시간이 줄어들고 느려짐 현상이 줄어들 수 있습니다. 일부 게임에선 크래시나 다른 문제 증상이 발생할 수도 있으므로 주의하며 사용하십시오."
#define OPTION_VAL_210_KO NULL
#define OPTION_VAL_220_KO NULL
#define OPTION_VAL_230_KO NULL
#define OPTION_VAL_240_KO NULL
#define OPTION_VAL_250_KO NULL
#define OPTION_VAL_260_KO NULL
#define OPTION_VAL_270_KO NULL
#define OPTION_VAL_280_KO NULL
#define OPTION_VAL_290_KO NULL
#define OPTION_VAL_300_KO NULL
#define OPTION_VAL_310_KO NULL
#define OPTION_VAL_320_KO NULL
#define OPTION_VAL_330_KO NULL
#define OPTION_VAL_340_KO NULL
#define OPTION_VAL_350_KO NULL
#define OPTION_VAL_360_KO NULL
#define OPTION_VAL_370_KO NULL
#define OPTION_VAL_380_KO NULL
#define OPTION_VAL_390_KO NULL
#define OPTION_VAL_400_KO NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_KO "오버클러킹 - SA-1 보조연산장치"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_KO "SA-1 보조연산장치"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_KO "Super Accelerator 1 (SA-1) 칩을 오버클럭 또는 다운클럭합니다. 이 값을 100% 넘게 설정할 경우 SA-1 칩을 사용하는 게임의 성능이 향상될 수 있습니다. 일부 게임에선 크래시나 다른 문제 증상이 발생할 수도 있으므로 주의하며 사용하십시오."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_KO "오버클러킹 - SuperFX 보조연산장치"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_KO "SuperFX 보조연산장치"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_KO "SuperFX 칩을 오버클럭 또는 다운클럭합니다. 이 값을 100% 넘게 설정할 경우 SuperFX 칩을 사용하는 게임의 성능이 향상될 수 있습니다. 일부 게임에선 크래시나 다른 문제 증상이 발생할 수도 있으므로 주의하며 사용하십시오."
#define OPTION_VAL_410_KO NULL
#define OPTION_VAL_420_KO NULL
#define OPTION_VAL_430_KO NULL
#define OPTION_VAL_440_KO NULL
#define OPTION_VAL_450_KO NULL
#define OPTION_VAL_460_KO NULL
#define OPTION_VAL_470_KO NULL
#define OPTION_VAL_480_KO NULL
#define OPTION_VAL_490_KO NULL
#define OPTION_VAL_500_KO NULL
#define OPTION_VAL_510_KO NULL
#define OPTION_VAL_520_KO NULL
#define OPTION_VAL_530_KO NULL
#define OPTION_VAL_540_KO NULL
#define OPTION_VAL_550_KO NULL
#define OPTION_VAL_560_KO NULL
#define OPTION_VAL_570_KO NULL
#define OPTION_VAL_580_KO NULL
#define OPTION_VAL_590_KO NULL
#define OPTION_VAL_600_KO NULL
#define OPTION_VAL_610_KO NULL
#define OPTION_VAL_620_KO NULL
#define OPTION_VAL_630_KO NULL
#define OPTION_VAL_640_KO NULL
#define OPTION_VAL_650_KO NULL
#define OPTION_VAL_660_KO NULL
#define OPTION_VAL_670_KO NULL
#define OPTION_VAL_680_KO NULL
#define OPTION_VAL_690_KO NULL
#define OPTION_VAL_700_KO NULL
#define OPTION_VAL_710_KO NULL
#define OPTION_VAL_720_KO NULL
#define OPTION_VAL_730_KO NULL
#define OPTION_VAL_740_KO NULL
#define OPTION_VAL_750_KO NULL
#define OPTION_VAL_760_KO NULL
#define OPTION_VAL_770_KO NULL
#define OPTION_VAL_780_KO NULL
#define OPTION_VAL_790_KO NULL
#define OPTION_VAL_800_KO NULL
#define BSNES_SGB_BIOS_LABEL_KO "선호 Super Game Boy BIOS (재시작 필요)"
#define BSNES_SGB_BIOS_INFO_0_KO "호환되는 타이틀을 실행할 때 사용할 Super Game Boy BIOS를 선택합니다."
#define OPTION_VAL_SGB1_SFC_KO NULL
#define OPTION_VAL_SGB2_SFC_KO NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_KO "SGB 보더 숨기기"
#define BSNES_HIDE_SGB_BORDER_INFO_0_KO "Super Game Boy 게임을 플레이할 때 보더를 숨깁니다."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_KO "터치스크린 라이트 건"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_KO "터치스크린 기기에서 Super Scope 입력을 활성화합니다."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_KO "Super Scope 트리거 버튼 전환"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_KO "터치스크린 라이트 건 사용 시 Super Scope의 트리거와 커서 버튼을 전환합니다."

struct retro_core_option_v2_category option_cats_ko[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_KO,
      CATEGORY_VIDEO_INFO_0_KO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_KO,
      CATEGORY_AUDIO_INFO_0_KO
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_KO,
      CATEGORY_MODE7_INFO_0_KO
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_KO,
      CATEGORY_HACK_INFO_0_KO
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_KO,
      CATEGORY_OVERCLOCK_INFO_0_KO
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_KO,
      CATEGORY_SGB_INFO_0_KO
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_KO,
      CATEGORY_LIGHTGUN_INFO_0_KO
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ko[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_KO,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_KO,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_KO },
         { "1:1",  OPTION_VAL_1_1_KO },
         { "4:3",  OPTION_VAL_4_3_KO },
         { "NTSC", OPTION_VAL_NTSC_KO },
         { "PAL",  OPTION_VAL_PAL_KO },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_KO,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_KO,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_KO },
         { "8",  OPTION_VAL_8_KO },
         { "12", OPTION_VAL_12_KO },
         { "16", OPTION_VAL_16_KO },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_KO,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_KO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_KO,
      BSNES_VIDEO_FILTER_LABEL_KO,
      BSNES_VIDEO_FILTER_INFO_0_KO,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_KO },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_KO },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_KO },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_KO },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_KO },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_KO,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_KO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_KO },
         { "10", OPTION_VAL_10_KO },
         { "20", OPTION_VAL_20_KO },
         { "30", OPTION_VAL_30_KO },
         { "40", OPTION_VAL_40_KO },
         { "50", OPTION_VAL_50_KO },
         { "60", OPTION_VAL_60_KO },
         { "70", OPTION_VAL_70_KO },
         { "80", OPTION_VAL_80_KO },
         { "90", OPTION_VAL_90_KO },
         { "100", OPTION_VAL_100_KO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_KO,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_KO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_KO },
         { "10", OPTION_VAL_10_KO },
         { "20", OPTION_VAL_20_KO },
         { "30", OPTION_VAL_30_KO },
         { "40", OPTION_VAL_40_KO },
         { "50", OPTION_VAL_50_KO },
         { "60", OPTION_VAL_60_KO },
         { "70", OPTION_VAL_70_KO },
         { "80", OPTION_VAL_80_KO },
         { "90", OPTION_VAL_90_KO },
         { "100", OPTION_VAL_100_KO },
         { "110", OPTION_VAL_110_KO },
         { "120", OPTION_VAL_120_KO },
         { "130", OPTION_VAL_130_KO },
         { "140", OPTION_VAL_140_KO },
         { "150", OPTION_VAL_150_KO },
         { "160", OPTION_VAL_160_KO },
         { "170", OPTION_VAL_170_KO },
         { "180", OPTION_VAL_180_KO },
         { "190", OPTION_VAL_190_KO },
         { "200", OPTION_VAL_200_KO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_KO,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_KO,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_KO },
         { "110", OPTION_VAL_110_KO },
         { "120", OPTION_VAL_120_KO },
         { "130", OPTION_VAL_130_KO },
         { "140", OPTION_VAL_140_KO },
         { "150", OPTION_VAL_150_O6_KO },
         { "160", OPTION_VAL_160_KO },
         { "170", OPTION_VAL_170_KO },
         { "180", OPTION_VAL_180_KO },
         { "190", OPTION_VAL_190_KO },
         { "200", OPTION_VAL_200_KO },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_KO,
      BSNES_PPU_FAST_LABEL_CAT_KO,
      BSNES_PPU_FAST_INFO_0_KO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_KO,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_KO,
      BSNES_PPU_DEINTERLACE_INFO_0_KO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_KO,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_KO,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_KO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_KO,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_KO,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_KO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_KO,
      BSNES_DSP_FAST_LABEL_CAT_KO,
      BSNES_DSP_FAST_INFO_0_KO,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_KO,
      BSNES_DSP_CUBIC_LABEL_CAT_KO,
      BSNES_DSP_CUBIC_INFO_0_KO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_KO,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_KO,
      BSNES_DSP_ECHO_SHADOW_INFO_0_KO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_KO,
      BSNES_MODE7_SCALE_LABEL_CAT_KO,
      BSNES_MODE7_SCALE_INFO_0_KO,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_KO  },
         { "2x", OPTION_VAL_2X_KO  },
         { "3x", OPTION_VAL_3X_KO  },
         { "4x", OPTION_VAL_4X_KO  },
         { "5x", OPTION_VAL_5X_KO },
         { "6x", OPTION_VAL_6X_KO },
         { "7x", OPTION_VAL_7X_KO },
         { "8x", OPTION_VAL_8X_KO },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_KO,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_KO,
      BSNES_MODE7_PERSPECTIVE_INFO_0_KO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_KO,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_KO,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_KO,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_KO,
      BSNES_MODE7_MOSAIC_LABEL_CAT_KO,
      BSNES_MODE7_MOSAIC_INFO_0_KO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_KO,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_KO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_KO  },
         { "2",   OPTION_VAL_2_KO },
         { "3",   OPTION_VAL_3_KO },
         { "4",   OPTION_VAL_4_KO },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_KO,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_KO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_KO,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_KO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_KO,
      NULL,
      BSNES_HOTFIXES_INFO_0_KO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_KO,
      NULL,
      BSNES_ENTROPY_INFO_0_KO,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_KO },
         { "High", OPTION_VAL_HIGH_KO },
         { "None", OPTION_VAL_NONE_KO },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_KO,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_KO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_KO,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_KO,
      BSNES_CPU_OVERCLOCK_INFO_0_KO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_KO  },
         { "20",  OPTION_VAL_20_KO  },
         { "30",  OPTION_VAL_30_KO  },
         { "40",  OPTION_VAL_40_KO  },
         { "50",  OPTION_VAL_50_KO  },
         { "60",  OPTION_VAL_60_KO  },
         { "70",  OPTION_VAL_70_KO  },
         { "80",  OPTION_VAL_80_KO  },
         { "90",  OPTION_VAL_90_KO  },
         { "100", OPTION_VAL_100_KO },
         { "110", OPTION_VAL_110_KO },
         { "120", OPTION_VAL_120_KO },
         { "130", OPTION_VAL_130_KO },
         { "140", OPTION_VAL_140_KO },
         { "150", OPTION_VAL_150_KO },
         { "160", OPTION_VAL_160_KO },
         { "170", OPTION_VAL_170_KO },
         { "180", OPTION_VAL_180_KO },
         { "190", OPTION_VAL_190_KO },
         { "200", OPTION_VAL_200_KO },
         { "210", OPTION_VAL_210_KO },
         { "220", OPTION_VAL_220_KO },
         { "230", OPTION_VAL_230_KO },
         { "240", OPTION_VAL_240_KO },
         { "250", OPTION_VAL_250_KO },
         { "260", OPTION_VAL_260_KO },
         { "270", OPTION_VAL_270_KO },
         { "280", OPTION_VAL_280_KO },
         { "290", OPTION_VAL_290_KO },
         { "300", OPTION_VAL_300_KO },
         { "310", OPTION_VAL_310_KO },
         { "320", OPTION_VAL_320_KO },
         { "330", OPTION_VAL_330_KO },
         { "340", OPTION_VAL_340_KO },
         { "350", OPTION_VAL_350_KO },
         { "360", OPTION_VAL_360_KO },
         { "370", OPTION_VAL_370_KO },
         { "380", OPTION_VAL_380_KO },
         { "390", OPTION_VAL_390_KO },
         { "400", OPTION_VAL_400_KO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_KO,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_KO,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_KO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_KO  },
         { "20",  OPTION_VAL_20_KO  },
         { "30",  OPTION_VAL_30_KO  },
         { "40",  OPTION_VAL_40_KO  },
         { "50",  OPTION_VAL_50_KO  },
         { "60",  OPTION_VAL_60_KO  },
         { "70",  OPTION_VAL_70_KO  },
         { "80",  OPTION_VAL_80_KO  },
         { "90",  OPTION_VAL_90_KO  },
         { "100", OPTION_VAL_100_KO },
         { "110", OPTION_VAL_110_KO },
         { "120", OPTION_VAL_120_KO },
         { "130", OPTION_VAL_130_KO },
         { "140", OPTION_VAL_140_KO },
         { "150", OPTION_VAL_150_KO },
         { "160", OPTION_VAL_160_KO },
         { "170", OPTION_VAL_170_KO },
         { "180", OPTION_VAL_180_KO },
         { "190", OPTION_VAL_190_KO },
         { "200", OPTION_VAL_200_KO },
         { "210", OPTION_VAL_210_KO },
         { "220", OPTION_VAL_220_KO },
         { "230", OPTION_VAL_230_KO },
         { "240", OPTION_VAL_240_KO },
         { "250", OPTION_VAL_250_KO },
         { "260", OPTION_VAL_260_KO },
         { "270", OPTION_VAL_270_KO },
         { "280", OPTION_VAL_280_KO },
         { "290", OPTION_VAL_290_KO },
         { "300", OPTION_VAL_300_KO },
         { "310", OPTION_VAL_310_KO },
         { "320", OPTION_VAL_320_KO },
         { "330", OPTION_VAL_330_KO },
         { "340", OPTION_VAL_340_KO },
         { "350", OPTION_VAL_350_KO },
         { "360", OPTION_VAL_360_KO },
         { "370", OPTION_VAL_370_KO },
         { "380", OPTION_VAL_380_KO },
         { "390", OPTION_VAL_390_KO },
         { "400", OPTION_VAL_400_KO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_KO,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_KO,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_KO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_KO  },
         { "20",  OPTION_VAL_20_KO  },
         { "30",  OPTION_VAL_30_KO  },
         { "40",  OPTION_VAL_40_KO  },
         { "50",  OPTION_VAL_50_KO  },
         { "60",  OPTION_VAL_60_KO  },
         { "70",  OPTION_VAL_70_KO  },
         { "80",  OPTION_VAL_80_KO  },
         { "90",  OPTION_VAL_90_KO  },
         { "100", OPTION_VAL_100_KO },
         { "110", OPTION_VAL_110_KO },
         { "120", OPTION_VAL_120_KO },
         { "130", OPTION_VAL_130_KO },
         { "140", OPTION_VAL_140_KO },
         { "150", OPTION_VAL_150_KO },
         { "160", OPTION_VAL_160_KO },
         { "170", OPTION_VAL_170_KO },
         { "180", OPTION_VAL_180_KO },
         { "190", OPTION_VAL_190_KO },
         { "200", OPTION_VAL_200_KO },
         { "210", OPTION_VAL_210_KO },
         { "220", OPTION_VAL_220_KO },
         { "230", OPTION_VAL_230_KO },
         { "240", OPTION_VAL_240_KO },
         { "250", OPTION_VAL_250_KO },
         { "260", OPTION_VAL_260_KO },
         { "270", OPTION_VAL_270_KO },
         { "280", OPTION_VAL_280_KO },
         { "290", OPTION_VAL_290_KO },
         { "300", OPTION_VAL_300_KO },
         { "310", OPTION_VAL_310_KO },
         { "320", OPTION_VAL_320_KO },
         { "330", OPTION_VAL_330_KO },
         { "340", OPTION_VAL_340_KO },
         { "350", OPTION_VAL_350_KO },
         { "360", OPTION_VAL_360_KO },
         { "370", OPTION_VAL_370_KO },
         { "380", OPTION_VAL_380_KO },
         { "390", OPTION_VAL_390_KO },
         { "400", OPTION_VAL_400_KO },
         { "410", OPTION_VAL_410_KO },
         { "420", OPTION_VAL_420_KO },
         { "430", OPTION_VAL_430_KO },
         { "440", OPTION_VAL_440_KO },
         { "450", OPTION_VAL_450_KO },
         { "460", OPTION_VAL_460_KO },
         { "470", OPTION_VAL_470_KO },
         { "480", OPTION_VAL_480_KO },
         { "490", OPTION_VAL_490_KO },
         { "500", OPTION_VAL_500_KO },
         { "510", OPTION_VAL_510_KO },
         { "520", OPTION_VAL_520_KO },
         { "530", OPTION_VAL_530_KO },
         { "540", OPTION_VAL_540_KO },
         { "550", OPTION_VAL_550_KO },
         { "560", OPTION_VAL_560_KO },
         { "570", OPTION_VAL_570_KO },
         { "580", OPTION_VAL_580_KO },
         { "590", OPTION_VAL_590_KO },
         { "600", OPTION_VAL_600_KO },
         { "610", OPTION_VAL_610_KO },
         { "620", OPTION_VAL_620_KO },
         { "630", OPTION_VAL_630_KO },
         { "640", OPTION_VAL_640_KO },
         { "650", OPTION_VAL_650_KO },
         { "660", OPTION_VAL_660_KO },
         { "670", OPTION_VAL_670_KO },
         { "680", OPTION_VAL_680_KO },
         { "690", OPTION_VAL_690_KO },
         { "700", OPTION_VAL_700_KO },
         { "710", OPTION_VAL_710_KO },
         { "720", OPTION_VAL_720_KO },
         { "730", OPTION_VAL_730_KO },
         { "740", OPTION_VAL_740_KO },
         { "750", OPTION_VAL_750_KO },
         { "760", OPTION_VAL_760_KO },
         { "770", OPTION_VAL_770_KO },
         { "780", OPTION_VAL_780_KO },
         { "790", OPTION_VAL_790_KO },
         { "800", OPTION_VAL_800_KO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_KO,
      NULL,
      BSNES_SGB_BIOS_INFO_0_KO,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_KO   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_KO },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_KO,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_KO,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_KO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_KO,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_KO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_KO,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ko = {
   option_cats_ko,
   option_defs_ko
};

/* RETRO_LANGUAGE_NL */

#define CATEGORY_VIDEO_LABEL_NL NULL
#define CATEGORY_VIDEO_INFO_0_NL "Instellingen voor video-uitvoer wijzigen."
#define CATEGORY_AUDIO_LABEL_NL "Geluid"
#define CATEGORY_AUDIO_INFO_0_NL "Instellingen voor audio-uitvoer wijzigen."
#define CATEGORY_MODE7_LABEL_NL NULL
#define CATEGORY_MODE7_INFO_0_NL NULL
#define CATEGORY_HACK_LABEL_NL NULL
#define CATEGORY_HACK_INFO_0_NL NULL
#define CATEGORY_OVERCLOCK_LABEL_NL NULL
#define CATEGORY_OVERCLOCK_INFO_0_NL NULL
#define CATEGORY_SGB_LABEL_NL NULL
#define CATEGORY_SGB_INFO_0_NL NULL
#define CATEGORY_LIGHTGUN_LABEL_NL NULL
#define CATEGORY_LIGHTGUN_INFO_0_NL NULL
#define BSNES_ASPECT_RATIO_LABEL_NL NULL
#define BSNES_ASPECT_RATIO_INFO_0_NL NULL
#define OPTION_VAL_AUTO_NL "Automatisch"
#define OPTION_VAL_1_1_NL NULL
#define OPTION_VAL_4_3_NL NULL
#define OPTION_VAL_NTSC_NL NULL
#define OPTION_VAL_PAL_NL NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_NL NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_NL NULL
#define OPTION_VAL_0_NL NULL
#define OPTION_VAL_8_NL NULL
#define OPTION_VAL_12_NL NULL
#define OPTION_VAL_16_NL NULL
#define BSNES_BLUR_EMULATION_LABEL_NL NULL
#define BSNES_BLUR_EMULATION_INFO_0_NL NULL
#define BSNES_VIDEO_FILTER_LABEL_NL NULL
#define BSNES_VIDEO_FILTER_INFO_0_NL NULL
#define OPTION_VAL_NONE_NL "Geen"
#define OPTION_VAL_NTSC_RF_NL NULL
#define OPTION_VAL_NTSC_COMPOSITE_NL NULL
#define OPTION_VAL_NTSC_S_VIDEO_NL NULL
#define OPTION_VAL_NTSC_RGB_NL NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_NL NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_NL NULL
#define OPTION_VAL_0_O4_NL NULL
#define OPTION_VAL_10_NL NULL
#define OPTION_VAL_20_NL NULL
#define OPTION_VAL_30_NL NULL
#define OPTION_VAL_40_NL NULL
#define OPTION_VAL_50_NL NULL
#define OPTION_VAL_60_NL NULL
#define OPTION_VAL_70_NL NULL
#define OPTION_VAL_80_NL NULL
#define OPTION_VAL_90_NL NULL
#define OPTION_VAL_100_NL NULL
#define BSNES_VIDEO_SATURATION_LABEL_NL NULL
#define BSNES_VIDEO_SATURATION_INFO_0_NL NULL
#define OPTION_VAL_110_NL NULL
#define OPTION_VAL_120_NL NULL
#define OPTION_VAL_130_NL NULL
#define OPTION_VAL_140_NL NULL
#define OPTION_VAL_150_NL NULL
#define OPTION_VAL_160_NL NULL
#define OPTION_VAL_170_NL NULL
#define OPTION_VAL_180_NL NULL
#define OPTION_VAL_190_NL NULL
#define OPTION_VAL_200_NL NULL
#define BSNES_VIDEO_GAMMA_LABEL_NL NULL
#define BSNES_VIDEO_GAMMA_INFO_0_NL NULL
#define OPTION_VAL_100_O6_NL NULL
#define OPTION_VAL_150_O6_NL NULL
#define BSNES_PPU_FAST_LABEL_NL NULL
#define BSNES_PPU_FAST_LABEL_CAT_NL NULL
#define BSNES_PPU_FAST_INFO_0_NL NULL
#define BSNES_PPU_DEINTERLACE_LABEL_NL NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_NL NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_NL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_NL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_NL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_NL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_NL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_NL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_NL NULL
#define BSNES_DSP_FAST_LABEL_NL NULL
#define BSNES_DSP_FAST_LABEL_CAT_NL NULL
#define BSNES_DSP_FAST_INFO_0_NL NULL
#define BSNES_DSP_CUBIC_LABEL_NL NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_NL NULL
#define BSNES_DSP_CUBIC_INFO_0_NL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_NL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_NL NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_NL NULL
#define BSNES_MODE7_SCALE_LABEL_NL NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_NL NULL
#define BSNES_MODE7_SCALE_INFO_0_NL NULL
#define OPTION_VAL_1X_NL NULL
#define OPTION_VAL_2X_NL NULL
#define OPTION_VAL_3X_NL NULL
#define OPTION_VAL_4X_NL NULL
#define OPTION_VAL_5X_NL NULL
#define OPTION_VAL_6X_NL NULL
#define OPTION_VAL_7X_NL NULL
#define OPTION_VAL_8X_NL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_NL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_NL NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_NL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_NL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_NL NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_NL NULL
#define BSNES_MODE7_MOSAIC_LABEL_NL NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_NL NULL
#define BSNES_MODE7_MOSAIC_INFO_0_NL NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_NL NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_NL NULL
#define OPTION_VAL_1_NL NULL
#define OPTION_VAL_2_NL NULL
#define OPTION_VAL_3_NL NULL
#define OPTION_VAL_4_NL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_NL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_NL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_NL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_NL NULL
#define BSNES_HOTFIXES_LABEL_NL NULL
#define BSNES_HOTFIXES_INFO_0_NL NULL
#define BSNES_ENTROPY_LABEL_NL NULL
#define BSNES_ENTROPY_INFO_0_NL NULL
#define OPTION_VAL_LOW_NL NULL
#define OPTION_VAL_HIGH_NL NULL
#define BSNES_CPU_FASTMATH_LABEL_NL NULL
#define BSNES_CPU_FASTMATH_INFO_0_NL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_NL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_NL NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_NL NULL
#define OPTION_VAL_210_NL NULL
#define OPTION_VAL_220_NL NULL
#define OPTION_VAL_230_NL NULL
#define OPTION_VAL_240_NL NULL
#define OPTION_VAL_250_NL NULL
#define OPTION_VAL_260_NL NULL
#define OPTION_VAL_270_NL NULL
#define OPTION_VAL_280_NL NULL
#define OPTION_VAL_290_NL NULL
#define OPTION_VAL_300_NL NULL
#define OPTION_VAL_310_NL NULL
#define OPTION_VAL_320_NL NULL
#define OPTION_VAL_330_NL NULL
#define OPTION_VAL_340_NL NULL
#define OPTION_VAL_350_NL NULL
#define OPTION_VAL_360_NL NULL
#define OPTION_VAL_370_NL NULL
#define OPTION_VAL_380_NL NULL
#define OPTION_VAL_390_NL NULL
#define OPTION_VAL_400_NL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_NL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_NL NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_NL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_NL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_NL NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_NL NULL
#define OPTION_VAL_410_NL NULL
#define OPTION_VAL_420_NL NULL
#define OPTION_VAL_430_NL NULL
#define OPTION_VAL_440_NL NULL
#define OPTION_VAL_450_NL NULL
#define OPTION_VAL_460_NL NULL
#define OPTION_VAL_470_NL NULL
#define OPTION_VAL_480_NL NULL
#define OPTION_VAL_490_NL NULL
#define OPTION_VAL_500_NL NULL
#define OPTION_VAL_510_NL NULL
#define OPTION_VAL_520_NL NULL
#define OPTION_VAL_530_NL NULL
#define OPTION_VAL_540_NL NULL
#define OPTION_VAL_550_NL NULL
#define OPTION_VAL_560_NL NULL
#define OPTION_VAL_570_NL NULL
#define OPTION_VAL_580_NL NULL
#define OPTION_VAL_590_NL NULL
#define OPTION_VAL_600_NL NULL
#define OPTION_VAL_610_NL NULL
#define OPTION_VAL_620_NL NULL
#define OPTION_VAL_630_NL NULL
#define OPTION_VAL_640_NL NULL
#define OPTION_VAL_650_NL NULL
#define OPTION_VAL_660_NL NULL
#define OPTION_VAL_670_NL NULL
#define OPTION_VAL_680_NL NULL
#define OPTION_VAL_690_NL NULL
#define OPTION_VAL_700_NL NULL
#define OPTION_VAL_710_NL NULL
#define OPTION_VAL_720_NL NULL
#define OPTION_VAL_730_NL NULL
#define OPTION_VAL_740_NL NULL
#define OPTION_VAL_750_NL NULL
#define OPTION_VAL_760_NL NULL
#define OPTION_VAL_770_NL NULL
#define OPTION_VAL_780_NL NULL
#define OPTION_VAL_790_NL NULL
#define OPTION_VAL_800_NL NULL
#define BSNES_SGB_BIOS_LABEL_NL NULL
#define BSNES_SGB_BIOS_INFO_0_NL NULL
#define OPTION_VAL_SGB1_SFC_NL NULL
#define OPTION_VAL_SGB2_SFC_NL NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_NL NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_NL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_NL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_NL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_NL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_NL NULL

struct retro_core_option_v2_category option_cats_nl[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_NL,
      CATEGORY_VIDEO_INFO_0_NL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_NL,
      CATEGORY_AUDIO_INFO_0_NL
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_NL,
      CATEGORY_MODE7_INFO_0_NL
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_NL,
      CATEGORY_HACK_INFO_0_NL
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_NL,
      CATEGORY_OVERCLOCK_INFO_0_NL
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_NL,
      CATEGORY_SGB_INFO_0_NL
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_NL,
      CATEGORY_LIGHTGUN_INFO_0_NL
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_nl[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_NL,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_NL,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_NL },
         { "1:1",  OPTION_VAL_1_1_NL },
         { "4:3",  OPTION_VAL_4_3_NL },
         { "NTSC", OPTION_VAL_NTSC_NL },
         { "PAL",  OPTION_VAL_PAL_NL },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_NL,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_NL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_NL },
         { "8",  OPTION_VAL_8_NL },
         { "12", OPTION_VAL_12_NL },
         { "16", OPTION_VAL_16_NL },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_NL,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_NL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_NL,
      BSNES_VIDEO_FILTER_LABEL_NL,
      BSNES_VIDEO_FILTER_INFO_0_NL,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_NL },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_NL },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_NL },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_NL },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_NL },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_NL,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_NL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_NL },
         { "10", OPTION_VAL_10_NL },
         { "20", OPTION_VAL_20_NL },
         { "30", OPTION_VAL_30_NL },
         { "40", OPTION_VAL_40_NL },
         { "50", OPTION_VAL_50_NL },
         { "60", OPTION_VAL_60_NL },
         { "70", OPTION_VAL_70_NL },
         { "80", OPTION_VAL_80_NL },
         { "90", OPTION_VAL_90_NL },
         { "100", OPTION_VAL_100_NL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_NL,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_NL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_NL },
         { "10", OPTION_VAL_10_NL },
         { "20", OPTION_VAL_20_NL },
         { "30", OPTION_VAL_30_NL },
         { "40", OPTION_VAL_40_NL },
         { "50", OPTION_VAL_50_NL },
         { "60", OPTION_VAL_60_NL },
         { "70", OPTION_VAL_70_NL },
         { "80", OPTION_VAL_80_NL },
         { "90", OPTION_VAL_90_NL },
         { "100", OPTION_VAL_100_NL },
         { "110", OPTION_VAL_110_NL },
         { "120", OPTION_VAL_120_NL },
         { "130", OPTION_VAL_130_NL },
         { "140", OPTION_VAL_140_NL },
         { "150", OPTION_VAL_150_NL },
         { "160", OPTION_VAL_160_NL },
         { "170", OPTION_VAL_170_NL },
         { "180", OPTION_VAL_180_NL },
         { "190", OPTION_VAL_190_NL },
         { "200", OPTION_VAL_200_NL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_NL,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_NL,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_NL },
         { "110", OPTION_VAL_110_NL },
         { "120", OPTION_VAL_120_NL },
         { "130", OPTION_VAL_130_NL },
         { "140", OPTION_VAL_140_NL },
         { "150", OPTION_VAL_150_O6_NL },
         { "160", OPTION_VAL_160_NL },
         { "170", OPTION_VAL_170_NL },
         { "180", OPTION_VAL_180_NL },
         { "190", OPTION_VAL_190_NL },
         { "200", OPTION_VAL_200_NL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_NL,
      BSNES_PPU_FAST_LABEL_CAT_NL,
      BSNES_PPU_FAST_INFO_0_NL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_NL,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_NL,
      BSNES_PPU_DEINTERLACE_INFO_0_NL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_NL,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_NL,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_NL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_NL,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_NL,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_NL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_NL,
      BSNES_DSP_FAST_LABEL_CAT_NL,
      BSNES_DSP_FAST_INFO_0_NL,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_NL,
      BSNES_DSP_CUBIC_LABEL_CAT_NL,
      BSNES_DSP_CUBIC_INFO_0_NL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_NL,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_NL,
      BSNES_DSP_ECHO_SHADOW_INFO_0_NL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_NL,
      BSNES_MODE7_SCALE_LABEL_CAT_NL,
      BSNES_MODE7_SCALE_INFO_0_NL,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_NL  },
         { "2x", OPTION_VAL_2X_NL  },
         { "3x", OPTION_VAL_3X_NL  },
         { "4x", OPTION_VAL_4X_NL  },
         { "5x", OPTION_VAL_5X_NL },
         { "6x", OPTION_VAL_6X_NL },
         { "7x", OPTION_VAL_7X_NL },
         { "8x", OPTION_VAL_8X_NL },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_NL,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_NL,
      BSNES_MODE7_PERSPECTIVE_INFO_0_NL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_NL,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_NL,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_NL,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_NL,
      BSNES_MODE7_MOSAIC_LABEL_CAT_NL,
      BSNES_MODE7_MOSAIC_INFO_0_NL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_NL,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_NL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_NL  },
         { "2",   OPTION_VAL_2_NL },
         { "3",   OPTION_VAL_3_NL },
         { "4",   OPTION_VAL_4_NL },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_NL,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_NL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_NL,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_NL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_NL,
      NULL,
      BSNES_HOTFIXES_INFO_0_NL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_NL,
      NULL,
      BSNES_ENTROPY_INFO_0_NL,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_NL },
         { "High", OPTION_VAL_HIGH_NL },
         { "None", OPTION_VAL_NONE_NL },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_NL,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_NL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_NL,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_NL,
      BSNES_CPU_OVERCLOCK_INFO_0_NL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NL  },
         { "20",  OPTION_VAL_20_NL  },
         { "30",  OPTION_VAL_30_NL  },
         { "40",  OPTION_VAL_40_NL  },
         { "50",  OPTION_VAL_50_NL  },
         { "60",  OPTION_VAL_60_NL  },
         { "70",  OPTION_VAL_70_NL  },
         { "80",  OPTION_VAL_80_NL  },
         { "90",  OPTION_VAL_90_NL  },
         { "100", OPTION_VAL_100_NL },
         { "110", OPTION_VAL_110_NL },
         { "120", OPTION_VAL_120_NL },
         { "130", OPTION_VAL_130_NL },
         { "140", OPTION_VAL_140_NL },
         { "150", OPTION_VAL_150_NL },
         { "160", OPTION_VAL_160_NL },
         { "170", OPTION_VAL_170_NL },
         { "180", OPTION_VAL_180_NL },
         { "190", OPTION_VAL_190_NL },
         { "200", OPTION_VAL_200_NL },
         { "210", OPTION_VAL_210_NL },
         { "220", OPTION_VAL_220_NL },
         { "230", OPTION_VAL_230_NL },
         { "240", OPTION_VAL_240_NL },
         { "250", OPTION_VAL_250_NL },
         { "260", OPTION_VAL_260_NL },
         { "270", OPTION_VAL_270_NL },
         { "280", OPTION_VAL_280_NL },
         { "290", OPTION_VAL_290_NL },
         { "300", OPTION_VAL_300_NL },
         { "310", OPTION_VAL_310_NL },
         { "320", OPTION_VAL_320_NL },
         { "330", OPTION_VAL_330_NL },
         { "340", OPTION_VAL_340_NL },
         { "350", OPTION_VAL_350_NL },
         { "360", OPTION_VAL_360_NL },
         { "370", OPTION_VAL_370_NL },
         { "380", OPTION_VAL_380_NL },
         { "390", OPTION_VAL_390_NL },
         { "400", OPTION_VAL_400_NL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_NL,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_NL,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_NL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NL  },
         { "20",  OPTION_VAL_20_NL  },
         { "30",  OPTION_VAL_30_NL  },
         { "40",  OPTION_VAL_40_NL  },
         { "50",  OPTION_VAL_50_NL  },
         { "60",  OPTION_VAL_60_NL  },
         { "70",  OPTION_VAL_70_NL  },
         { "80",  OPTION_VAL_80_NL  },
         { "90",  OPTION_VAL_90_NL  },
         { "100", OPTION_VAL_100_NL },
         { "110", OPTION_VAL_110_NL },
         { "120", OPTION_VAL_120_NL },
         { "130", OPTION_VAL_130_NL },
         { "140", OPTION_VAL_140_NL },
         { "150", OPTION_VAL_150_NL },
         { "160", OPTION_VAL_160_NL },
         { "170", OPTION_VAL_170_NL },
         { "180", OPTION_VAL_180_NL },
         { "190", OPTION_VAL_190_NL },
         { "200", OPTION_VAL_200_NL },
         { "210", OPTION_VAL_210_NL },
         { "220", OPTION_VAL_220_NL },
         { "230", OPTION_VAL_230_NL },
         { "240", OPTION_VAL_240_NL },
         { "250", OPTION_VAL_250_NL },
         { "260", OPTION_VAL_260_NL },
         { "270", OPTION_VAL_270_NL },
         { "280", OPTION_VAL_280_NL },
         { "290", OPTION_VAL_290_NL },
         { "300", OPTION_VAL_300_NL },
         { "310", OPTION_VAL_310_NL },
         { "320", OPTION_VAL_320_NL },
         { "330", OPTION_VAL_330_NL },
         { "340", OPTION_VAL_340_NL },
         { "350", OPTION_VAL_350_NL },
         { "360", OPTION_VAL_360_NL },
         { "370", OPTION_VAL_370_NL },
         { "380", OPTION_VAL_380_NL },
         { "390", OPTION_VAL_390_NL },
         { "400", OPTION_VAL_400_NL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_NL,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_NL,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_NL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NL  },
         { "20",  OPTION_VAL_20_NL  },
         { "30",  OPTION_VAL_30_NL  },
         { "40",  OPTION_VAL_40_NL  },
         { "50",  OPTION_VAL_50_NL  },
         { "60",  OPTION_VAL_60_NL  },
         { "70",  OPTION_VAL_70_NL  },
         { "80",  OPTION_VAL_80_NL  },
         { "90",  OPTION_VAL_90_NL  },
         { "100", OPTION_VAL_100_NL },
         { "110", OPTION_VAL_110_NL },
         { "120", OPTION_VAL_120_NL },
         { "130", OPTION_VAL_130_NL },
         { "140", OPTION_VAL_140_NL },
         { "150", OPTION_VAL_150_NL },
         { "160", OPTION_VAL_160_NL },
         { "170", OPTION_VAL_170_NL },
         { "180", OPTION_VAL_180_NL },
         { "190", OPTION_VAL_190_NL },
         { "200", OPTION_VAL_200_NL },
         { "210", OPTION_VAL_210_NL },
         { "220", OPTION_VAL_220_NL },
         { "230", OPTION_VAL_230_NL },
         { "240", OPTION_VAL_240_NL },
         { "250", OPTION_VAL_250_NL },
         { "260", OPTION_VAL_260_NL },
         { "270", OPTION_VAL_270_NL },
         { "280", OPTION_VAL_280_NL },
         { "290", OPTION_VAL_290_NL },
         { "300", OPTION_VAL_300_NL },
         { "310", OPTION_VAL_310_NL },
         { "320", OPTION_VAL_320_NL },
         { "330", OPTION_VAL_330_NL },
         { "340", OPTION_VAL_340_NL },
         { "350", OPTION_VAL_350_NL },
         { "360", OPTION_VAL_360_NL },
         { "370", OPTION_VAL_370_NL },
         { "380", OPTION_VAL_380_NL },
         { "390", OPTION_VAL_390_NL },
         { "400", OPTION_VAL_400_NL },
         { "410", OPTION_VAL_410_NL },
         { "420", OPTION_VAL_420_NL },
         { "430", OPTION_VAL_430_NL },
         { "440", OPTION_VAL_440_NL },
         { "450", OPTION_VAL_450_NL },
         { "460", OPTION_VAL_460_NL },
         { "470", OPTION_VAL_470_NL },
         { "480", OPTION_VAL_480_NL },
         { "490", OPTION_VAL_490_NL },
         { "500", OPTION_VAL_500_NL },
         { "510", OPTION_VAL_510_NL },
         { "520", OPTION_VAL_520_NL },
         { "530", OPTION_VAL_530_NL },
         { "540", OPTION_VAL_540_NL },
         { "550", OPTION_VAL_550_NL },
         { "560", OPTION_VAL_560_NL },
         { "570", OPTION_VAL_570_NL },
         { "580", OPTION_VAL_580_NL },
         { "590", OPTION_VAL_590_NL },
         { "600", OPTION_VAL_600_NL },
         { "610", OPTION_VAL_610_NL },
         { "620", OPTION_VAL_620_NL },
         { "630", OPTION_VAL_630_NL },
         { "640", OPTION_VAL_640_NL },
         { "650", OPTION_VAL_650_NL },
         { "660", OPTION_VAL_660_NL },
         { "670", OPTION_VAL_670_NL },
         { "680", OPTION_VAL_680_NL },
         { "690", OPTION_VAL_690_NL },
         { "700", OPTION_VAL_700_NL },
         { "710", OPTION_VAL_710_NL },
         { "720", OPTION_VAL_720_NL },
         { "730", OPTION_VAL_730_NL },
         { "740", OPTION_VAL_740_NL },
         { "750", OPTION_VAL_750_NL },
         { "760", OPTION_VAL_760_NL },
         { "770", OPTION_VAL_770_NL },
         { "780", OPTION_VAL_780_NL },
         { "790", OPTION_VAL_790_NL },
         { "800", OPTION_VAL_800_NL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_NL,
      NULL,
      BSNES_SGB_BIOS_INFO_0_NL,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_NL   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_NL },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_NL,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_NL,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_NL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_NL,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_NL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_NL,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_nl = {
   option_cats_nl,
   option_defs_nl
};

/* RETRO_LANGUAGE_NO */

#define CATEGORY_VIDEO_LABEL_NO NULL
#define CATEGORY_VIDEO_INFO_0_NO "Endre innstillinger for video utdata."
#define CATEGORY_AUDIO_LABEL_NO "Lyd"
#define CATEGORY_AUDIO_INFO_0_NO "Endre innstillinger for lydutgang."
#define CATEGORY_MODE7_LABEL_NO NULL
#define CATEGORY_MODE7_INFO_0_NO NULL
#define CATEGORY_HACK_LABEL_NO NULL
#define CATEGORY_HACK_INFO_0_NO NULL
#define CATEGORY_OVERCLOCK_LABEL_NO NULL
#define CATEGORY_OVERCLOCK_INFO_0_NO NULL
#define CATEGORY_SGB_LABEL_NO NULL
#define CATEGORY_SGB_INFO_0_NO NULL
#define CATEGORY_LIGHTGUN_LABEL_NO NULL
#define CATEGORY_LIGHTGUN_INFO_0_NO NULL
#define BSNES_ASPECT_RATIO_LABEL_NO NULL
#define BSNES_ASPECT_RATIO_INFO_0_NO NULL
#define OPTION_VAL_AUTO_NO NULL
#define OPTION_VAL_1_1_NO NULL
#define OPTION_VAL_4_3_NO NULL
#define OPTION_VAL_NTSC_NO NULL
#define OPTION_VAL_PAL_NO NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_NO NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_NO NULL
#define OPTION_VAL_0_NO NULL
#define OPTION_VAL_8_NO NULL
#define OPTION_VAL_12_NO NULL
#define OPTION_VAL_16_NO NULL
#define BSNES_BLUR_EMULATION_LABEL_NO NULL
#define BSNES_BLUR_EMULATION_INFO_0_NO NULL
#define BSNES_VIDEO_FILTER_LABEL_NO NULL
#define BSNES_VIDEO_FILTER_INFO_0_NO NULL
#define OPTION_VAL_NONE_NO "Ingen"
#define OPTION_VAL_NTSC_RF_NO NULL
#define OPTION_VAL_NTSC_COMPOSITE_NO NULL
#define OPTION_VAL_NTSC_S_VIDEO_NO NULL
#define OPTION_VAL_NTSC_RGB_NO NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_NO NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_NO NULL
#define OPTION_VAL_0_O4_NO NULL
#define OPTION_VAL_10_NO NULL
#define OPTION_VAL_20_NO NULL
#define OPTION_VAL_30_NO NULL
#define OPTION_VAL_40_NO NULL
#define OPTION_VAL_50_NO NULL
#define OPTION_VAL_60_NO NULL
#define OPTION_VAL_70_NO NULL
#define OPTION_VAL_80_NO NULL
#define OPTION_VAL_90_NO NULL
#define OPTION_VAL_100_NO NULL
#define BSNES_VIDEO_SATURATION_LABEL_NO NULL
#define BSNES_VIDEO_SATURATION_INFO_0_NO NULL
#define OPTION_VAL_110_NO NULL
#define OPTION_VAL_120_NO NULL
#define OPTION_VAL_130_NO NULL
#define OPTION_VAL_140_NO NULL
#define OPTION_VAL_150_NO NULL
#define OPTION_VAL_160_NO NULL
#define OPTION_VAL_170_NO NULL
#define OPTION_VAL_180_NO NULL
#define OPTION_VAL_190_NO NULL
#define OPTION_VAL_200_NO NULL
#define BSNES_VIDEO_GAMMA_LABEL_NO NULL
#define BSNES_VIDEO_GAMMA_INFO_0_NO NULL
#define OPTION_VAL_100_O6_NO NULL
#define OPTION_VAL_150_O6_NO NULL
#define BSNES_PPU_FAST_LABEL_NO NULL
#define BSNES_PPU_FAST_LABEL_CAT_NO NULL
#define BSNES_PPU_FAST_INFO_0_NO NULL
#define BSNES_PPU_DEINTERLACE_LABEL_NO NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_NO NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_NO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_NO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_NO NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_NO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_NO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_NO NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_NO NULL
#define BSNES_DSP_FAST_LABEL_NO NULL
#define BSNES_DSP_FAST_LABEL_CAT_NO NULL
#define BSNES_DSP_FAST_INFO_0_NO NULL
#define BSNES_DSP_CUBIC_LABEL_NO NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_NO NULL
#define BSNES_DSP_CUBIC_INFO_0_NO NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_NO NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_NO NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_NO NULL
#define BSNES_MODE7_SCALE_LABEL_NO NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_NO NULL
#define BSNES_MODE7_SCALE_INFO_0_NO NULL
#define OPTION_VAL_1X_NO NULL
#define OPTION_VAL_2X_NO NULL
#define OPTION_VAL_3X_NO NULL
#define OPTION_VAL_4X_NO NULL
#define OPTION_VAL_5X_NO NULL
#define OPTION_VAL_6X_NO NULL
#define OPTION_VAL_7X_NO NULL
#define OPTION_VAL_8X_NO NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_NO NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_NO NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_NO NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_NO NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_NO NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_NO NULL
#define BSNES_MODE7_MOSAIC_LABEL_NO NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_NO NULL
#define BSNES_MODE7_MOSAIC_INFO_0_NO NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_NO NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_NO NULL
#define OPTION_VAL_1_NO NULL
#define OPTION_VAL_2_NO NULL
#define OPTION_VAL_3_NO NULL
#define OPTION_VAL_4_NO NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_NO NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_NO NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_NO NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_NO NULL
#define BSNES_HOTFIXES_LABEL_NO NULL
#define BSNES_HOTFIXES_INFO_0_NO NULL
#define BSNES_ENTROPY_LABEL_NO NULL
#define BSNES_ENTROPY_INFO_0_NO NULL
#define OPTION_VAL_LOW_NO NULL
#define OPTION_VAL_HIGH_NO NULL
#define BSNES_CPU_FASTMATH_LABEL_NO NULL
#define BSNES_CPU_FASTMATH_INFO_0_NO NULL
#define BSNES_CPU_OVERCLOCK_LABEL_NO NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_NO NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_NO NULL
#define OPTION_VAL_210_NO NULL
#define OPTION_VAL_220_NO NULL
#define OPTION_VAL_230_NO NULL
#define OPTION_VAL_240_NO NULL
#define OPTION_VAL_250_NO NULL
#define OPTION_VAL_260_NO NULL
#define OPTION_VAL_270_NO NULL
#define OPTION_VAL_280_NO NULL
#define OPTION_VAL_290_NO NULL
#define OPTION_VAL_300_NO NULL
#define OPTION_VAL_310_NO NULL
#define OPTION_VAL_320_NO NULL
#define OPTION_VAL_330_NO NULL
#define OPTION_VAL_340_NO NULL
#define OPTION_VAL_350_NO NULL
#define OPTION_VAL_360_NO NULL
#define OPTION_VAL_370_NO NULL
#define OPTION_VAL_380_NO NULL
#define OPTION_VAL_390_NO NULL
#define OPTION_VAL_400_NO NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_NO NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_NO NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_NO NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_NO NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_NO NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_NO NULL
#define OPTION_VAL_410_NO NULL
#define OPTION_VAL_420_NO NULL
#define OPTION_VAL_430_NO NULL
#define OPTION_VAL_440_NO NULL
#define OPTION_VAL_450_NO NULL
#define OPTION_VAL_460_NO NULL
#define OPTION_VAL_470_NO NULL
#define OPTION_VAL_480_NO NULL
#define OPTION_VAL_490_NO NULL
#define OPTION_VAL_500_NO NULL
#define OPTION_VAL_510_NO NULL
#define OPTION_VAL_520_NO NULL
#define OPTION_VAL_530_NO NULL
#define OPTION_VAL_540_NO NULL
#define OPTION_VAL_550_NO NULL
#define OPTION_VAL_560_NO NULL
#define OPTION_VAL_570_NO NULL
#define OPTION_VAL_580_NO NULL
#define OPTION_VAL_590_NO NULL
#define OPTION_VAL_600_NO NULL
#define OPTION_VAL_610_NO NULL
#define OPTION_VAL_620_NO NULL
#define OPTION_VAL_630_NO NULL
#define OPTION_VAL_640_NO NULL
#define OPTION_VAL_650_NO NULL
#define OPTION_VAL_660_NO NULL
#define OPTION_VAL_670_NO NULL
#define OPTION_VAL_680_NO NULL
#define OPTION_VAL_690_NO NULL
#define OPTION_VAL_700_NO NULL
#define OPTION_VAL_710_NO NULL
#define OPTION_VAL_720_NO NULL
#define OPTION_VAL_730_NO NULL
#define OPTION_VAL_740_NO NULL
#define OPTION_VAL_750_NO NULL
#define OPTION_VAL_760_NO NULL
#define OPTION_VAL_770_NO NULL
#define OPTION_VAL_780_NO NULL
#define OPTION_VAL_790_NO NULL
#define OPTION_VAL_800_NO NULL
#define BSNES_SGB_BIOS_LABEL_NO NULL
#define BSNES_SGB_BIOS_INFO_0_NO NULL
#define OPTION_VAL_SGB1_SFC_NO NULL
#define OPTION_VAL_SGB2_SFC_NO NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_NO NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_NO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_NO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_NO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_NO NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_NO NULL

struct retro_core_option_v2_category option_cats_no[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_NO,
      CATEGORY_VIDEO_INFO_0_NO
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_NO,
      CATEGORY_AUDIO_INFO_0_NO
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_NO,
      CATEGORY_MODE7_INFO_0_NO
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_NO,
      CATEGORY_HACK_INFO_0_NO
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_NO,
      CATEGORY_OVERCLOCK_INFO_0_NO
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_NO,
      CATEGORY_SGB_INFO_0_NO
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_NO,
      CATEGORY_LIGHTGUN_INFO_0_NO
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_no[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_NO,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_NO,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_NO },
         { "1:1",  OPTION_VAL_1_1_NO },
         { "4:3",  OPTION_VAL_4_3_NO },
         { "NTSC", OPTION_VAL_NTSC_NO },
         { "PAL",  OPTION_VAL_PAL_NO },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_NO,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_NO,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_NO },
         { "8",  OPTION_VAL_8_NO },
         { "12", OPTION_VAL_12_NO },
         { "16", OPTION_VAL_16_NO },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_NO,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_NO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_NO,
      BSNES_VIDEO_FILTER_LABEL_NO,
      BSNES_VIDEO_FILTER_INFO_0_NO,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_NO },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_NO },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_NO },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_NO },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_NO },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_NO,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_NO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_NO },
         { "10", OPTION_VAL_10_NO },
         { "20", OPTION_VAL_20_NO },
         { "30", OPTION_VAL_30_NO },
         { "40", OPTION_VAL_40_NO },
         { "50", OPTION_VAL_50_NO },
         { "60", OPTION_VAL_60_NO },
         { "70", OPTION_VAL_70_NO },
         { "80", OPTION_VAL_80_NO },
         { "90", OPTION_VAL_90_NO },
         { "100", OPTION_VAL_100_NO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_NO,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_NO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_NO },
         { "10", OPTION_VAL_10_NO },
         { "20", OPTION_VAL_20_NO },
         { "30", OPTION_VAL_30_NO },
         { "40", OPTION_VAL_40_NO },
         { "50", OPTION_VAL_50_NO },
         { "60", OPTION_VAL_60_NO },
         { "70", OPTION_VAL_70_NO },
         { "80", OPTION_VAL_80_NO },
         { "90", OPTION_VAL_90_NO },
         { "100", OPTION_VAL_100_NO },
         { "110", OPTION_VAL_110_NO },
         { "120", OPTION_VAL_120_NO },
         { "130", OPTION_VAL_130_NO },
         { "140", OPTION_VAL_140_NO },
         { "150", OPTION_VAL_150_NO },
         { "160", OPTION_VAL_160_NO },
         { "170", OPTION_VAL_170_NO },
         { "180", OPTION_VAL_180_NO },
         { "190", OPTION_VAL_190_NO },
         { "200", OPTION_VAL_200_NO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_NO,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_NO,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_NO },
         { "110", OPTION_VAL_110_NO },
         { "120", OPTION_VAL_120_NO },
         { "130", OPTION_VAL_130_NO },
         { "140", OPTION_VAL_140_NO },
         { "150", OPTION_VAL_150_O6_NO },
         { "160", OPTION_VAL_160_NO },
         { "170", OPTION_VAL_170_NO },
         { "180", OPTION_VAL_180_NO },
         { "190", OPTION_VAL_190_NO },
         { "200", OPTION_VAL_200_NO },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_NO,
      BSNES_PPU_FAST_LABEL_CAT_NO,
      BSNES_PPU_FAST_INFO_0_NO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_NO,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_NO,
      BSNES_PPU_DEINTERLACE_INFO_0_NO,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_NO,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_NO,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_NO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_NO,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_NO,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_NO,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_NO,
      BSNES_DSP_FAST_LABEL_CAT_NO,
      BSNES_DSP_FAST_INFO_0_NO,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_NO,
      BSNES_DSP_CUBIC_LABEL_CAT_NO,
      BSNES_DSP_CUBIC_INFO_0_NO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_NO,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_NO,
      BSNES_DSP_ECHO_SHADOW_INFO_0_NO,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_NO,
      BSNES_MODE7_SCALE_LABEL_CAT_NO,
      BSNES_MODE7_SCALE_INFO_0_NO,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_NO  },
         { "2x", OPTION_VAL_2X_NO  },
         { "3x", OPTION_VAL_3X_NO  },
         { "4x", OPTION_VAL_4X_NO  },
         { "5x", OPTION_VAL_5X_NO },
         { "6x", OPTION_VAL_6X_NO },
         { "7x", OPTION_VAL_7X_NO },
         { "8x", OPTION_VAL_8X_NO },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_NO,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_NO,
      BSNES_MODE7_PERSPECTIVE_INFO_0_NO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_NO,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_NO,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_NO,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_NO,
      BSNES_MODE7_MOSAIC_LABEL_CAT_NO,
      BSNES_MODE7_MOSAIC_INFO_0_NO,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_NO,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_NO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_NO  },
         { "2",   OPTION_VAL_2_NO },
         { "3",   OPTION_VAL_3_NO },
         { "4",   OPTION_VAL_4_NO },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_NO,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_NO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_NO,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_NO,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_NO,
      NULL,
      BSNES_HOTFIXES_INFO_0_NO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_NO,
      NULL,
      BSNES_ENTROPY_INFO_0_NO,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_NO },
         { "High", OPTION_VAL_HIGH_NO },
         { "None", OPTION_VAL_NONE_NO },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_NO,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_NO,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_NO,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_NO,
      BSNES_CPU_OVERCLOCK_INFO_0_NO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NO  },
         { "20",  OPTION_VAL_20_NO  },
         { "30",  OPTION_VAL_30_NO  },
         { "40",  OPTION_VAL_40_NO  },
         { "50",  OPTION_VAL_50_NO  },
         { "60",  OPTION_VAL_60_NO  },
         { "70",  OPTION_VAL_70_NO  },
         { "80",  OPTION_VAL_80_NO  },
         { "90",  OPTION_VAL_90_NO  },
         { "100", OPTION_VAL_100_NO },
         { "110", OPTION_VAL_110_NO },
         { "120", OPTION_VAL_120_NO },
         { "130", OPTION_VAL_130_NO },
         { "140", OPTION_VAL_140_NO },
         { "150", OPTION_VAL_150_NO },
         { "160", OPTION_VAL_160_NO },
         { "170", OPTION_VAL_170_NO },
         { "180", OPTION_VAL_180_NO },
         { "190", OPTION_VAL_190_NO },
         { "200", OPTION_VAL_200_NO },
         { "210", OPTION_VAL_210_NO },
         { "220", OPTION_VAL_220_NO },
         { "230", OPTION_VAL_230_NO },
         { "240", OPTION_VAL_240_NO },
         { "250", OPTION_VAL_250_NO },
         { "260", OPTION_VAL_260_NO },
         { "270", OPTION_VAL_270_NO },
         { "280", OPTION_VAL_280_NO },
         { "290", OPTION_VAL_290_NO },
         { "300", OPTION_VAL_300_NO },
         { "310", OPTION_VAL_310_NO },
         { "320", OPTION_VAL_320_NO },
         { "330", OPTION_VAL_330_NO },
         { "340", OPTION_VAL_340_NO },
         { "350", OPTION_VAL_350_NO },
         { "360", OPTION_VAL_360_NO },
         { "370", OPTION_VAL_370_NO },
         { "380", OPTION_VAL_380_NO },
         { "390", OPTION_VAL_390_NO },
         { "400", OPTION_VAL_400_NO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_NO,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_NO,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_NO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NO  },
         { "20",  OPTION_VAL_20_NO  },
         { "30",  OPTION_VAL_30_NO  },
         { "40",  OPTION_VAL_40_NO  },
         { "50",  OPTION_VAL_50_NO  },
         { "60",  OPTION_VAL_60_NO  },
         { "70",  OPTION_VAL_70_NO  },
         { "80",  OPTION_VAL_80_NO  },
         { "90",  OPTION_VAL_90_NO  },
         { "100", OPTION_VAL_100_NO },
         { "110", OPTION_VAL_110_NO },
         { "120", OPTION_VAL_120_NO },
         { "130", OPTION_VAL_130_NO },
         { "140", OPTION_VAL_140_NO },
         { "150", OPTION_VAL_150_NO },
         { "160", OPTION_VAL_160_NO },
         { "170", OPTION_VAL_170_NO },
         { "180", OPTION_VAL_180_NO },
         { "190", OPTION_VAL_190_NO },
         { "200", OPTION_VAL_200_NO },
         { "210", OPTION_VAL_210_NO },
         { "220", OPTION_VAL_220_NO },
         { "230", OPTION_VAL_230_NO },
         { "240", OPTION_VAL_240_NO },
         { "250", OPTION_VAL_250_NO },
         { "260", OPTION_VAL_260_NO },
         { "270", OPTION_VAL_270_NO },
         { "280", OPTION_VAL_280_NO },
         { "290", OPTION_VAL_290_NO },
         { "300", OPTION_VAL_300_NO },
         { "310", OPTION_VAL_310_NO },
         { "320", OPTION_VAL_320_NO },
         { "330", OPTION_VAL_330_NO },
         { "340", OPTION_VAL_340_NO },
         { "350", OPTION_VAL_350_NO },
         { "360", OPTION_VAL_360_NO },
         { "370", OPTION_VAL_370_NO },
         { "380", OPTION_VAL_380_NO },
         { "390", OPTION_VAL_390_NO },
         { "400", OPTION_VAL_400_NO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_NO,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_NO,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_NO,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_NO  },
         { "20",  OPTION_VAL_20_NO  },
         { "30",  OPTION_VAL_30_NO  },
         { "40",  OPTION_VAL_40_NO  },
         { "50",  OPTION_VAL_50_NO  },
         { "60",  OPTION_VAL_60_NO  },
         { "70",  OPTION_VAL_70_NO  },
         { "80",  OPTION_VAL_80_NO  },
         { "90",  OPTION_VAL_90_NO  },
         { "100", OPTION_VAL_100_NO },
         { "110", OPTION_VAL_110_NO },
         { "120", OPTION_VAL_120_NO },
         { "130", OPTION_VAL_130_NO },
         { "140", OPTION_VAL_140_NO },
         { "150", OPTION_VAL_150_NO },
         { "160", OPTION_VAL_160_NO },
         { "170", OPTION_VAL_170_NO },
         { "180", OPTION_VAL_180_NO },
         { "190", OPTION_VAL_190_NO },
         { "200", OPTION_VAL_200_NO },
         { "210", OPTION_VAL_210_NO },
         { "220", OPTION_VAL_220_NO },
         { "230", OPTION_VAL_230_NO },
         { "240", OPTION_VAL_240_NO },
         { "250", OPTION_VAL_250_NO },
         { "260", OPTION_VAL_260_NO },
         { "270", OPTION_VAL_270_NO },
         { "280", OPTION_VAL_280_NO },
         { "290", OPTION_VAL_290_NO },
         { "300", OPTION_VAL_300_NO },
         { "310", OPTION_VAL_310_NO },
         { "320", OPTION_VAL_320_NO },
         { "330", OPTION_VAL_330_NO },
         { "340", OPTION_VAL_340_NO },
         { "350", OPTION_VAL_350_NO },
         { "360", OPTION_VAL_360_NO },
         { "370", OPTION_VAL_370_NO },
         { "380", OPTION_VAL_380_NO },
         { "390", OPTION_VAL_390_NO },
         { "400", OPTION_VAL_400_NO },
         { "410", OPTION_VAL_410_NO },
         { "420", OPTION_VAL_420_NO },
         { "430", OPTION_VAL_430_NO },
         { "440", OPTION_VAL_440_NO },
         { "450", OPTION_VAL_450_NO },
         { "460", OPTION_VAL_460_NO },
         { "470", OPTION_VAL_470_NO },
         { "480", OPTION_VAL_480_NO },
         { "490", OPTION_VAL_490_NO },
         { "500", OPTION_VAL_500_NO },
         { "510", OPTION_VAL_510_NO },
         { "520", OPTION_VAL_520_NO },
         { "530", OPTION_VAL_530_NO },
         { "540", OPTION_VAL_540_NO },
         { "550", OPTION_VAL_550_NO },
         { "560", OPTION_VAL_560_NO },
         { "570", OPTION_VAL_570_NO },
         { "580", OPTION_VAL_580_NO },
         { "590", OPTION_VAL_590_NO },
         { "600", OPTION_VAL_600_NO },
         { "610", OPTION_VAL_610_NO },
         { "620", OPTION_VAL_620_NO },
         { "630", OPTION_VAL_630_NO },
         { "640", OPTION_VAL_640_NO },
         { "650", OPTION_VAL_650_NO },
         { "660", OPTION_VAL_660_NO },
         { "670", OPTION_VAL_670_NO },
         { "680", OPTION_VAL_680_NO },
         { "690", OPTION_VAL_690_NO },
         { "700", OPTION_VAL_700_NO },
         { "710", OPTION_VAL_710_NO },
         { "720", OPTION_VAL_720_NO },
         { "730", OPTION_VAL_730_NO },
         { "740", OPTION_VAL_740_NO },
         { "750", OPTION_VAL_750_NO },
         { "760", OPTION_VAL_760_NO },
         { "770", OPTION_VAL_770_NO },
         { "780", OPTION_VAL_780_NO },
         { "790", OPTION_VAL_790_NO },
         { "800", OPTION_VAL_800_NO },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_NO,
      NULL,
      BSNES_SGB_BIOS_INFO_0_NO,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_NO   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_NO },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_NO,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_NO,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_NO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_NO,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_NO,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_NO,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_no = {
   option_cats_no,
   option_defs_no
};

/* RETRO_LANGUAGE_OR */

#define CATEGORY_VIDEO_LABEL_OR "ଵିଡ଼ିଓ"
#define CATEGORY_VIDEO_INFO_0_OR NULL
#define CATEGORY_AUDIO_LABEL_OR "ଅଡ଼ିଓ"
#define CATEGORY_AUDIO_INFO_0_OR NULL
#define CATEGORY_MODE7_LABEL_OR NULL
#define CATEGORY_MODE7_INFO_0_OR NULL
#define CATEGORY_HACK_LABEL_OR NULL
#define CATEGORY_HACK_INFO_0_OR NULL
#define CATEGORY_OVERCLOCK_LABEL_OR NULL
#define CATEGORY_OVERCLOCK_INFO_0_OR NULL
#define CATEGORY_SGB_LABEL_OR NULL
#define CATEGORY_SGB_INFO_0_OR NULL
#define CATEGORY_LIGHTGUN_LABEL_OR NULL
#define CATEGORY_LIGHTGUN_INFO_0_OR NULL
#define BSNES_ASPECT_RATIO_LABEL_OR NULL
#define BSNES_ASPECT_RATIO_INFO_0_OR NULL
#define OPTION_VAL_AUTO_OR NULL
#define OPTION_VAL_1_1_OR NULL
#define OPTION_VAL_4_3_OR NULL
#define OPTION_VAL_NTSC_OR NULL
#define OPTION_VAL_PAL_OR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_OR NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_OR NULL
#define OPTION_VAL_0_OR NULL
#define OPTION_VAL_8_OR NULL
#define OPTION_VAL_12_OR NULL
#define OPTION_VAL_16_OR NULL
#define BSNES_BLUR_EMULATION_LABEL_OR NULL
#define BSNES_BLUR_EMULATION_INFO_0_OR NULL
#define BSNES_VIDEO_FILTER_LABEL_OR NULL
#define BSNES_VIDEO_FILTER_INFO_0_OR NULL
#define OPTION_VAL_NONE_OR NULL
#define OPTION_VAL_NTSC_RF_OR NULL
#define OPTION_VAL_NTSC_COMPOSITE_OR NULL
#define OPTION_VAL_NTSC_S_VIDEO_OR NULL
#define OPTION_VAL_NTSC_RGB_OR NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_OR NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_OR NULL
#define OPTION_VAL_0_O4_OR NULL
#define OPTION_VAL_10_OR NULL
#define OPTION_VAL_20_OR NULL
#define OPTION_VAL_30_OR NULL
#define OPTION_VAL_40_OR NULL
#define OPTION_VAL_50_OR NULL
#define OPTION_VAL_60_OR NULL
#define OPTION_VAL_70_OR NULL
#define OPTION_VAL_80_OR NULL
#define OPTION_VAL_90_OR NULL
#define OPTION_VAL_100_OR NULL
#define BSNES_VIDEO_SATURATION_LABEL_OR NULL
#define BSNES_VIDEO_SATURATION_INFO_0_OR NULL
#define OPTION_VAL_110_OR NULL
#define OPTION_VAL_120_OR NULL
#define OPTION_VAL_130_OR NULL
#define OPTION_VAL_140_OR NULL
#define OPTION_VAL_150_OR NULL
#define OPTION_VAL_160_OR NULL
#define OPTION_VAL_170_OR NULL
#define OPTION_VAL_180_OR NULL
#define OPTION_VAL_190_OR NULL
#define OPTION_VAL_200_OR NULL
#define BSNES_VIDEO_GAMMA_LABEL_OR NULL
#define BSNES_VIDEO_GAMMA_INFO_0_OR NULL
#define OPTION_VAL_100_O6_OR NULL
#define OPTION_VAL_150_O6_OR NULL
#define BSNES_PPU_FAST_LABEL_OR NULL
#define BSNES_PPU_FAST_LABEL_CAT_OR NULL
#define BSNES_PPU_FAST_INFO_0_OR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_OR NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_OR NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_OR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_OR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_OR NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_OR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_OR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_OR NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_OR NULL
#define BSNES_DSP_FAST_LABEL_OR NULL
#define BSNES_DSP_FAST_LABEL_CAT_OR NULL
#define BSNES_DSP_FAST_INFO_0_OR NULL
#define BSNES_DSP_CUBIC_LABEL_OR NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_OR NULL
#define BSNES_DSP_CUBIC_INFO_0_OR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_OR NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_OR NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_OR NULL
#define BSNES_MODE7_SCALE_LABEL_OR NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_OR NULL
#define BSNES_MODE7_SCALE_INFO_0_OR NULL
#define OPTION_VAL_1X_OR NULL
#define OPTION_VAL_2X_OR NULL
#define OPTION_VAL_3X_OR NULL
#define OPTION_VAL_4X_OR NULL
#define OPTION_VAL_5X_OR NULL
#define OPTION_VAL_6X_OR NULL
#define OPTION_VAL_7X_OR NULL
#define OPTION_VAL_8X_OR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_OR NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_OR NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_OR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_OR NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_OR NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_OR NULL
#define BSNES_MODE7_MOSAIC_LABEL_OR NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_OR NULL
#define BSNES_MODE7_MOSAIC_INFO_0_OR NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_OR NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_OR NULL
#define OPTION_VAL_1_OR NULL
#define OPTION_VAL_2_OR NULL
#define OPTION_VAL_3_OR NULL
#define OPTION_VAL_4_OR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_OR NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_OR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_OR NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_OR NULL
#define BSNES_HOTFIXES_LABEL_OR NULL
#define BSNES_HOTFIXES_INFO_0_OR NULL
#define BSNES_ENTROPY_LABEL_OR NULL
#define BSNES_ENTROPY_INFO_0_OR NULL
#define OPTION_VAL_LOW_OR NULL
#define OPTION_VAL_HIGH_OR NULL
#define BSNES_CPU_FASTMATH_LABEL_OR NULL
#define BSNES_CPU_FASTMATH_INFO_0_OR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_OR NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_OR NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_OR NULL
#define OPTION_VAL_210_OR NULL
#define OPTION_VAL_220_OR NULL
#define OPTION_VAL_230_OR NULL
#define OPTION_VAL_240_OR NULL
#define OPTION_VAL_250_OR NULL
#define OPTION_VAL_260_OR NULL
#define OPTION_VAL_270_OR NULL
#define OPTION_VAL_280_OR NULL
#define OPTION_VAL_290_OR NULL
#define OPTION_VAL_300_OR NULL
#define OPTION_VAL_310_OR NULL
#define OPTION_VAL_320_OR NULL
#define OPTION_VAL_330_OR NULL
#define OPTION_VAL_340_OR NULL
#define OPTION_VAL_350_OR NULL
#define OPTION_VAL_360_OR NULL
#define OPTION_VAL_370_OR NULL
#define OPTION_VAL_380_OR NULL
#define OPTION_VAL_390_OR NULL
#define OPTION_VAL_400_OR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_OR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_OR NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_OR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_OR NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_OR NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_OR NULL
#define OPTION_VAL_410_OR NULL
#define OPTION_VAL_420_OR NULL
#define OPTION_VAL_430_OR NULL
#define OPTION_VAL_440_OR NULL
#define OPTION_VAL_450_OR NULL
#define OPTION_VAL_460_OR NULL
#define OPTION_VAL_470_OR NULL
#define OPTION_VAL_480_OR NULL
#define OPTION_VAL_490_OR NULL
#define OPTION_VAL_500_OR NULL
#define OPTION_VAL_510_OR NULL
#define OPTION_VAL_520_OR NULL
#define OPTION_VAL_530_OR NULL
#define OPTION_VAL_540_OR NULL
#define OPTION_VAL_550_OR NULL
#define OPTION_VAL_560_OR NULL
#define OPTION_VAL_570_OR NULL
#define OPTION_VAL_580_OR NULL
#define OPTION_VAL_590_OR NULL
#define OPTION_VAL_600_OR NULL
#define OPTION_VAL_610_OR NULL
#define OPTION_VAL_620_OR NULL
#define OPTION_VAL_630_OR NULL
#define OPTION_VAL_640_OR NULL
#define OPTION_VAL_650_OR NULL
#define OPTION_VAL_660_OR NULL
#define OPTION_VAL_670_OR NULL
#define OPTION_VAL_680_OR NULL
#define OPTION_VAL_690_OR NULL
#define OPTION_VAL_700_OR NULL
#define OPTION_VAL_710_OR NULL
#define OPTION_VAL_720_OR NULL
#define OPTION_VAL_730_OR NULL
#define OPTION_VAL_740_OR NULL
#define OPTION_VAL_750_OR NULL
#define OPTION_VAL_760_OR NULL
#define OPTION_VAL_770_OR NULL
#define OPTION_VAL_780_OR NULL
#define OPTION_VAL_790_OR NULL
#define OPTION_VAL_800_OR NULL
#define BSNES_SGB_BIOS_LABEL_OR NULL
#define BSNES_SGB_BIOS_INFO_0_OR NULL
#define OPTION_VAL_SGB1_SFC_OR NULL
#define OPTION_VAL_SGB2_SFC_OR NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_OR NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_OR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_OR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_OR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_OR NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_OR NULL

struct retro_core_option_v2_category option_cats_or[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_OR,
      CATEGORY_VIDEO_INFO_0_OR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_OR,
      CATEGORY_AUDIO_INFO_0_OR
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_OR,
      CATEGORY_MODE7_INFO_0_OR
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_OR,
      CATEGORY_HACK_INFO_0_OR
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_OR,
      CATEGORY_OVERCLOCK_INFO_0_OR
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_OR,
      CATEGORY_SGB_INFO_0_OR
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_OR,
      CATEGORY_LIGHTGUN_INFO_0_OR
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_or[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_OR,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_OR,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_OR },
         { "1:1",  OPTION_VAL_1_1_OR },
         { "4:3",  OPTION_VAL_4_3_OR },
         { "NTSC", OPTION_VAL_NTSC_OR },
         { "PAL",  OPTION_VAL_PAL_OR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_OR,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_OR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_OR },
         { "8",  OPTION_VAL_8_OR },
         { "12", OPTION_VAL_12_OR },
         { "16", OPTION_VAL_16_OR },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_OR,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_OR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_OR,
      BSNES_VIDEO_FILTER_LABEL_OR,
      BSNES_VIDEO_FILTER_INFO_0_OR,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_OR },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_OR },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_OR },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_OR },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_OR },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_OR,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_OR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_OR },
         { "10", OPTION_VAL_10_OR },
         { "20", OPTION_VAL_20_OR },
         { "30", OPTION_VAL_30_OR },
         { "40", OPTION_VAL_40_OR },
         { "50", OPTION_VAL_50_OR },
         { "60", OPTION_VAL_60_OR },
         { "70", OPTION_VAL_70_OR },
         { "80", OPTION_VAL_80_OR },
         { "90", OPTION_VAL_90_OR },
         { "100", OPTION_VAL_100_OR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_OR,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_OR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_OR },
         { "10", OPTION_VAL_10_OR },
         { "20", OPTION_VAL_20_OR },
         { "30", OPTION_VAL_30_OR },
         { "40", OPTION_VAL_40_OR },
         { "50", OPTION_VAL_50_OR },
         { "60", OPTION_VAL_60_OR },
         { "70", OPTION_VAL_70_OR },
         { "80", OPTION_VAL_80_OR },
         { "90", OPTION_VAL_90_OR },
         { "100", OPTION_VAL_100_OR },
         { "110", OPTION_VAL_110_OR },
         { "120", OPTION_VAL_120_OR },
         { "130", OPTION_VAL_130_OR },
         { "140", OPTION_VAL_140_OR },
         { "150", OPTION_VAL_150_OR },
         { "160", OPTION_VAL_160_OR },
         { "170", OPTION_VAL_170_OR },
         { "180", OPTION_VAL_180_OR },
         { "190", OPTION_VAL_190_OR },
         { "200", OPTION_VAL_200_OR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_OR,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_OR,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_OR },
         { "110", OPTION_VAL_110_OR },
         { "120", OPTION_VAL_120_OR },
         { "130", OPTION_VAL_130_OR },
         { "140", OPTION_VAL_140_OR },
         { "150", OPTION_VAL_150_O6_OR },
         { "160", OPTION_VAL_160_OR },
         { "170", OPTION_VAL_170_OR },
         { "180", OPTION_VAL_180_OR },
         { "190", OPTION_VAL_190_OR },
         { "200", OPTION_VAL_200_OR },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_OR,
      BSNES_PPU_FAST_LABEL_CAT_OR,
      BSNES_PPU_FAST_INFO_0_OR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_OR,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_OR,
      BSNES_PPU_DEINTERLACE_INFO_0_OR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_OR,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_OR,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_OR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_OR,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_OR,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_OR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_OR,
      BSNES_DSP_FAST_LABEL_CAT_OR,
      BSNES_DSP_FAST_INFO_0_OR,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_OR,
      BSNES_DSP_CUBIC_LABEL_CAT_OR,
      BSNES_DSP_CUBIC_INFO_0_OR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_OR,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_OR,
      BSNES_DSP_ECHO_SHADOW_INFO_0_OR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_OR,
      BSNES_MODE7_SCALE_LABEL_CAT_OR,
      BSNES_MODE7_SCALE_INFO_0_OR,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_OR  },
         { "2x", OPTION_VAL_2X_OR  },
         { "3x", OPTION_VAL_3X_OR  },
         { "4x", OPTION_VAL_4X_OR  },
         { "5x", OPTION_VAL_5X_OR },
         { "6x", OPTION_VAL_6X_OR },
         { "7x", OPTION_VAL_7X_OR },
         { "8x", OPTION_VAL_8X_OR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_OR,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_OR,
      BSNES_MODE7_PERSPECTIVE_INFO_0_OR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_OR,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_OR,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_OR,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_OR,
      BSNES_MODE7_MOSAIC_LABEL_CAT_OR,
      BSNES_MODE7_MOSAIC_INFO_0_OR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_OR,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_OR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_OR  },
         { "2",   OPTION_VAL_2_OR },
         { "3",   OPTION_VAL_3_OR },
         { "4",   OPTION_VAL_4_OR },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_OR,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_OR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_OR,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_OR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_OR,
      NULL,
      BSNES_HOTFIXES_INFO_0_OR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_OR,
      NULL,
      BSNES_ENTROPY_INFO_0_OR,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_OR },
         { "High", OPTION_VAL_HIGH_OR },
         { "None", OPTION_VAL_NONE_OR },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_OR,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_OR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_OR,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_OR,
      BSNES_CPU_OVERCLOCK_INFO_0_OR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_OR  },
         { "20",  OPTION_VAL_20_OR  },
         { "30",  OPTION_VAL_30_OR  },
         { "40",  OPTION_VAL_40_OR  },
         { "50",  OPTION_VAL_50_OR  },
         { "60",  OPTION_VAL_60_OR  },
         { "70",  OPTION_VAL_70_OR  },
         { "80",  OPTION_VAL_80_OR  },
         { "90",  OPTION_VAL_90_OR  },
         { "100", OPTION_VAL_100_OR },
         { "110", OPTION_VAL_110_OR },
         { "120", OPTION_VAL_120_OR },
         { "130", OPTION_VAL_130_OR },
         { "140", OPTION_VAL_140_OR },
         { "150", OPTION_VAL_150_OR },
         { "160", OPTION_VAL_160_OR },
         { "170", OPTION_VAL_170_OR },
         { "180", OPTION_VAL_180_OR },
         { "190", OPTION_VAL_190_OR },
         { "200", OPTION_VAL_200_OR },
         { "210", OPTION_VAL_210_OR },
         { "220", OPTION_VAL_220_OR },
         { "230", OPTION_VAL_230_OR },
         { "240", OPTION_VAL_240_OR },
         { "250", OPTION_VAL_250_OR },
         { "260", OPTION_VAL_260_OR },
         { "270", OPTION_VAL_270_OR },
         { "280", OPTION_VAL_280_OR },
         { "290", OPTION_VAL_290_OR },
         { "300", OPTION_VAL_300_OR },
         { "310", OPTION_VAL_310_OR },
         { "320", OPTION_VAL_320_OR },
         { "330", OPTION_VAL_330_OR },
         { "340", OPTION_VAL_340_OR },
         { "350", OPTION_VAL_350_OR },
         { "360", OPTION_VAL_360_OR },
         { "370", OPTION_VAL_370_OR },
         { "380", OPTION_VAL_380_OR },
         { "390", OPTION_VAL_390_OR },
         { "400", OPTION_VAL_400_OR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_OR,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_OR,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_OR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_OR  },
         { "20",  OPTION_VAL_20_OR  },
         { "30",  OPTION_VAL_30_OR  },
         { "40",  OPTION_VAL_40_OR  },
         { "50",  OPTION_VAL_50_OR  },
         { "60",  OPTION_VAL_60_OR  },
         { "70",  OPTION_VAL_70_OR  },
         { "80",  OPTION_VAL_80_OR  },
         { "90",  OPTION_VAL_90_OR  },
         { "100", OPTION_VAL_100_OR },
         { "110", OPTION_VAL_110_OR },
         { "120", OPTION_VAL_120_OR },
         { "130", OPTION_VAL_130_OR },
         { "140", OPTION_VAL_140_OR },
         { "150", OPTION_VAL_150_OR },
         { "160", OPTION_VAL_160_OR },
         { "170", OPTION_VAL_170_OR },
         { "180", OPTION_VAL_180_OR },
         { "190", OPTION_VAL_190_OR },
         { "200", OPTION_VAL_200_OR },
         { "210", OPTION_VAL_210_OR },
         { "220", OPTION_VAL_220_OR },
         { "230", OPTION_VAL_230_OR },
         { "240", OPTION_VAL_240_OR },
         { "250", OPTION_VAL_250_OR },
         { "260", OPTION_VAL_260_OR },
         { "270", OPTION_VAL_270_OR },
         { "280", OPTION_VAL_280_OR },
         { "290", OPTION_VAL_290_OR },
         { "300", OPTION_VAL_300_OR },
         { "310", OPTION_VAL_310_OR },
         { "320", OPTION_VAL_320_OR },
         { "330", OPTION_VAL_330_OR },
         { "340", OPTION_VAL_340_OR },
         { "350", OPTION_VAL_350_OR },
         { "360", OPTION_VAL_360_OR },
         { "370", OPTION_VAL_370_OR },
         { "380", OPTION_VAL_380_OR },
         { "390", OPTION_VAL_390_OR },
         { "400", OPTION_VAL_400_OR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_OR,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_OR,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_OR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_OR  },
         { "20",  OPTION_VAL_20_OR  },
         { "30",  OPTION_VAL_30_OR  },
         { "40",  OPTION_VAL_40_OR  },
         { "50",  OPTION_VAL_50_OR  },
         { "60",  OPTION_VAL_60_OR  },
         { "70",  OPTION_VAL_70_OR  },
         { "80",  OPTION_VAL_80_OR  },
         { "90",  OPTION_VAL_90_OR  },
         { "100", OPTION_VAL_100_OR },
         { "110", OPTION_VAL_110_OR },
         { "120", OPTION_VAL_120_OR },
         { "130", OPTION_VAL_130_OR },
         { "140", OPTION_VAL_140_OR },
         { "150", OPTION_VAL_150_OR },
         { "160", OPTION_VAL_160_OR },
         { "170", OPTION_VAL_170_OR },
         { "180", OPTION_VAL_180_OR },
         { "190", OPTION_VAL_190_OR },
         { "200", OPTION_VAL_200_OR },
         { "210", OPTION_VAL_210_OR },
         { "220", OPTION_VAL_220_OR },
         { "230", OPTION_VAL_230_OR },
         { "240", OPTION_VAL_240_OR },
         { "250", OPTION_VAL_250_OR },
         { "260", OPTION_VAL_260_OR },
         { "270", OPTION_VAL_270_OR },
         { "280", OPTION_VAL_280_OR },
         { "290", OPTION_VAL_290_OR },
         { "300", OPTION_VAL_300_OR },
         { "310", OPTION_VAL_310_OR },
         { "320", OPTION_VAL_320_OR },
         { "330", OPTION_VAL_330_OR },
         { "340", OPTION_VAL_340_OR },
         { "350", OPTION_VAL_350_OR },
         { "360", OPTION_VAL_360_OR },
         { "370", OPTION_VAL_370_OR },
         { "380", OPTION_VAL_380_OR },
         { "390", OPTION_VAL_390_OR },
         { "400", OPTION_VAL_400_OR },
         { "410", OPTION_VAL_410_OR },
         { "420", OPTION_VAL_420_OR },
         { "430", OPTION_VAL_430_OR },
         { "440", OPTION_VAL_440_OR },
         { "450", OPTION_VAL_450_OR },
         { "460", OPTION_VAL_460_OR },
         { "470", OPTION_VAL_470_OR },
         { "480", OPTION_VAL_480_OR },
         { "490", OPTION_VAL_490_OR },
         { "500", OPTION_VAL_500_OR },
         { "510", OPTION_VAL_510_OR },
         { "520", OPTION_VAL_520_OR },
         { "530", OPTION_VAL_530_OR },
         { "540", OPTION_VAL_540_OR },
         { "550", OPTION_VAL_550_OR },
         { "560", OPTION_VAL_560_OR },
         { "570", OPTION_VAL_570_OR },
         { "580", OPTION_VAL_580_OR },
         { "590", OPTION_VAL_590_OR },
         { "600", OPTION_VAL_600_OR },
         { "610", OPTION_VAL_610_OR },
         { "620", OPTION_VAL_620_OR },
         { "630", OPTION_VAL_630_OR },
         { "640", OPTION_VAL_640_OR },
         { "650", OPTION_VAL_650_OR },
         { "660", OPTION_VAL_660_OR },
         { "670", OPTION_VAL_670_OR },
         { "680", OPTION_VAL_680_OR },
         { "690", OPTION_VAL_690_OR },
         { "700", OPTION_VAL_700_OR },
         { "710", OPTION_VAL_710_OR },
         { "720", OPTION_VAL_720_OR },
         { "730", OPTION_VAL_730_OR },
         { "740", OPTION_VAL_740_OR },
         { "750", OPTION_VAL_750_OR },
         { "760", OPTION_VAL_760_OR },
         { "770", OPTION_VAL_770_OR },
         { "780", OPTION_VAL_780_OR },
         { "790", OPTION_VAL_790_OR },
         { "800", OPTION_VAL_800_OR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_OR,
      NULL,
      BSNES_SGB_BIOS_INFO_0_OR,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_OR   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_OR },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_OR,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_OR,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_OR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_OR,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_OR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_OR,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_or = {
   option_cats_or,
   option_defs_or
};

/* RETRO_LANGUAGE_PL */

#define CATEGORY_VIDEO_LABEL_PL "Wideo"
#define CATEGORY_VIDEO_INFO_0_PL "Zmień ustawienia wyglądu wideo."
#define CATEGORY_AUDIO_LABEL_PL NULL
#define CATEGORY_AUDIO_INFO_0_PL "Zmień ustawienia wyjścia dźwięku."
#define CATEGORY_MODE7_LABEL_PL NULL
#define CATEGORY_MODE7_INFO_0_PL NULL
#define CATEGORY_HACK_LABEL_PL "Hacki Emulacyjne i Ulepszenia"
#define CATEGORY_HACK_INFO_0_PL "Zastosuj hacki emulacyjne, ulepszenia i hotfiksy."
#define CATEGORY_OVERCLOCK_LABEL_PL NULL
#define CATEGORY_OVERCLOCK_INFO_0_PL NULL
#define CATEGORY_SGB_LABEL_PL NULL
#define CATEGORY_SGB_INFO_0_PL "Zmień ustawienia dotyczące emulsji Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_PL "Pistolet Świetlny"
#define CATEGORY_LIGHTGUN_INFO_0_PL "Zmień ustawienia broni świetlnej (ekran dotykowy)."
#define BSNES_ASPECT_RATIO_LABEL_PL NULL
#define BSNES_ASPECT_RATIO_INFO_0_PL NULL
#define OPTION_VAL_AUTO_PL NULL
#define OPTION_VAL_1_1_PL NULL
#define OPTION_VAL_4_3_PL NULL
#define OPTION_VAL_NTSC_PL NULL
#define OPTION_VAL_PAL_PL NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_PL "Przytnij pionowy overscan"
#define BSNES_PPU_OVERSCAN_V_INFO_0_PL NULL
#define OPTION_VAL_0_PL "0 linii"
#define OPTION_VAL_8_PL "8 linii"
#define OPTION_VAL_12_PL "12 linii"
#define OPTION_VAL_16_PL "16 Linii"
#define BSNES_BLUR_EMULATION_LABEL_PL NULL
#define BSNES_BLUR_EMULATION_INFO_0_PL NULL
#define BSNES_VIDEO_FILTER_LABEL_PL "Filtr"
#define BSNES_VIDEO_FILTER_INFO_0_PL "Wybierz między bez filtrowania a dużym filtrem NTSC z opcjami dla RF, Kompozytu, S-Video lub RGB"
#define OPTION_VAL_NONE_PL "Brak"
#define OPTION_VAL_NTSC_RF_PL NULL
#define OPTION_VAL_NTSC_COMPOSITE_PL "NTSC (kompozyt)"
#define OPTION_VAL_NTSC_S_VIDEO_PL "NTSC (S-wideo)"
#define OPTION_VAL_NTSC_RGB_PL NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_PL "Regulacja koloru - luminancja"
#define BSNES_VIDEO_LUMINANCE_INFO_0_PL "Dostosuj luminancję"
#define OPTION_VAL_0_O4_PL NULL
#define OPTION_VAL_10_PL NULL
#define OPTION_VAL_20_PL NULL
#define OPTION_VAL_30_PL "30 %"
#define OPTION_VAL_40_PL NULL
#define OPTION_VAL_50_PL "50 %"
#define OPTION_VAL_60_PL "60 %"
#define OPTION_VAL_70_PL NULL
#define OPTION_VAL_80_PL "80 %"
#define OPTION_VAL_90_PL NULL
#define OPTION_VAL_100_PL NULL
#define BSNES_VIDEO_SATURATION_LABEL_PL "Regulacja koloru - Nasycenie"
#define BSNES_VIDEO_SATURATION_INFO_0_PL "Dostosuj nasycenie"
#define OPTION_VAL_110_PL NULL
#define OPTION_VAL_120_PL NULL
#define OPTION_VAL_130_PL NULL
#define OPTION_VAL_140_PL NULL
#define OPTION_VAL_150_PL NULL
#define OPTION_VAL_160_PL NULL
#define OPTION_VAL_170_PL NULL
#define OPTION_VAL_180_PL NULL
#define OPTION_VAL_190_PL NULL
#define OPTION_VAL_200_PL NULL
#define BSNES_VIDEO_GAMMA_LABEL_PL "Regulacja koloru - Gamma"
#define BSNES_VIDEO_GAMMA_INFO_0_PL "Dostosuj Gamma"
#define OPTION_VAL_100_O6_PL NULL
#define OPTION_VAL_150_O6_PL "150% (domyślnie)"
#define BSNES_PPU_FAST_LABEL_PL NULL
#define BSNES_PPU_FAST_LABEL_CAT_PL NULL
#define BSNES_PPU_FAST_INFO_0_PL "Włącz szybszą emulację PPU kosztem niewielkiego zmniejszenia dokładności. Zaleca się, aby to zostawić. UWAGA: to musi być włączone dla opcji 'Deinterlace', 'No Sprite Limit' i 'HD Mode 7' do działania."
#define BSNES_PPU_DEINTERLACE_LABEL_PL NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_PL NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_PL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PL NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PL NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PL "PPU - bez blokowania VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PL NULL
#define BSNES_DSP_FAST_LABEL_PL NULL
#define BSNES_DSP_FAST_LABEL_CAT_PL NULL
#define BSNES_DSP_FAST_INFO_0_PL NULL
#define BSNES_DSP_CUBIC_LABEL_PL NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_PL NULL
#define BSNES_DSP_CUBIC_INFO_0_PL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_PL NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PL NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_PL NULL
#define BSNES_MODE7_SCALE_LABEL_PL NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_PL "Skala"
#define BSNES_MODE7_SCALE_INFO_0_PL NULL
#define OPTION_VAL_1X_PL NULL
#define OPTION_VAL_2X_PL NULL
#define OPTION_VAL_3X_PL NULL
#define OPTION_VAL_4X_PL NULL
#define OPTION_VAL_5X_PL NULL
#define OPTION_VAL_6X_PL NULL
#define OPTION_VAL_7X_PL NULL
#define OPTION_VAL_8X_PL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_PL NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PL NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_PL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_PL NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PL NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_PL NULL
#define BSNES_MODE7_MOSAIC_LABEL_PL NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_PL NULL
#define BSNES_MODE7_MOSAIC_INFO_0_PL NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_PL NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_PL NULL
#define OPTION_VAL_1_PL NULL
#define OPTION_VAL_2_PL NULL
#define OPTION_VAL_3_PL NULL
#define OPTION_VAL_4_PL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PL NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_PL NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PL NULL
#define BSNES_HOTFIXES_LABEL_PL NULL
#define BSNES_HOTFIXES_INFO_0_PL NULL
#define BSNES_ENTROPY_LABEL_PL NULL
#define BSNES_ENTROPY_INFO_0_PL NULL
#define OPTION_VAL_LOW_PL "Niski"
#define OPTION_VAL_HIGH_PL "Wysoki"
#define BSNES_CPU_FASTMATH_LABEL_PL NULL
#define BSNES_CPU_FASTMATH_INFO_0_PL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_PL NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_PL NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_PL NULL
#define OPTION_VAL_210_PL NULL
#define OPTION_VAL_220_PL NULL
#define OPTION_VAL_230_PL NULL
#define OPTION_VAL_240_PL NULL
#define OPTION_VAL_250_PL NULL
#define OPTION_VAL_260_PL NULL
#define OPTION_VAL_270_PL NULL
#define OPTION_VAL_280_PL NULL
#define OPTION_VAL_290_PL NULL
#define OPTION_VAL_300_PL NULL
#define OPTION_VAL_310_PL NULL
#define OPTION_VAL_320_PL NULL
#define OPTION_VAL_330_PL NULL
#define OPTION_VAL_340_PL NULL
#define OPTION_VAL_350_PL NULL
#define OPTION_VAL_360_PL NULL
#define OPTION_VAL_370_PL NULL
#define OPTION_VAL_380_PL NULL
#define OPTION_VAL_390_PL NULL
#define OPTION_VAL_400_PL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_PL NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PL NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_PL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_PL NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PL NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_PL NULL
#define OPTION_VAL_410_PL NULL
#define OPTION_VAL_420_PL NULL
#define OPTION_VAL_430_PL NULL
#define OPTION_VAL_440_PL NULL
#define OPTION_VAL_450_PL NULL
#define OPTION_VAL_460_PL NULL
#define OPTION_VAL_470_PL NULL
#define OPTION_VAL_480_PL NULL
#define OPTION_VAL_490_PL NULL
#define OPTION_VAL_500_PL NULL
#define OPTION_VAL_510_PL NULL
#define OPTION_VAL_520_PL NULL
#define OPTION_VAL_530_PL NULL
#define OPTION_VAL_540_PL NULL
#define OPTION_VAL_550_PL NULL
#define OPTION_VAL_560_PL NULL
#define OPTION_VAL_570_PL NULL
#define OPTION_VAL_580_PL NULL
#define OPTION_VAL_590_PL NULL
#define OPTION_VAL_600_PL NULL
#define OPTION_VAL_610_PL NULL
#define OPTION_VAL_620_PL NULL
#define OPTION_VAL_630_PL NULL
#define OPTION_VAL_640_PL NULL
#define OPTION_VAL_650_PL NULL
#define OPTION_VAL_660_PL NULL
#define OPTION_VAL_670_PL NULL
#define OPTION_VAL_680_PL NULL
#define OPTION_VAL_690_PL NULL
#define OPTION_VAL_700_PL NULL
#define OPTION_VAL_710_PL NULL
#define OPTION_VAL_720_PL NULL
#define OPTION_VAL_730_PL NULL
#define OPTION_VAL_740_PL NULL
#define OPTION_VAL_750_PL NULL
#define OPTION_VAL_760_PL NULL
#define OPTION_VAL_770_PL NULL
#define OPTION_VAL_780_PL NULL
#define OPTION_VAL_790_PL NULL
#define OPTION_VAL_800_PL NULL
#define BSNES_SGB_BIOS_LABEL_PL NULL
#define BSNES_SGB_BIOS_INFO_0_PL NULL
#define OPTION_VAL_SGB1_SFC_PL NULL
#define OPTION_VAL_SGB2_SFC_PL NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_PL NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_PL "Ukryj obramowanie podczas grania w Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PL NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PL NULL

struct retro_core_option_v2_category option_cats_pl[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_PL,
      CATEGORY_VIDEO_INFO_0_PL
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_PL,
      CATEGORY_AUDIO_INFO_0_PL
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_PL,
      CATEGORY_MODE7_INFO_0_PL
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_PL,
      CATEGORY_HACK_INFO_0_PL
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_PL,
      CATEGORY_OVERCLOCK_INFO_0_PL
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_PL,
      CATEGORY_SGB_INFO_0_PL
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_PL,
      CATEGORY_LIGHTGUN_INFO_0_PL
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_pl[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_PL,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_PL,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_PL },
         { "1:1",  OPTION_VAL_1_1_PL },
         { "4:3",  OPTION_VAL_4_3_PL },
         { "NTSC", OPTION_VAL_NTSC_PL },
         { "PAL",  OPTION_VAL_PAL_PL },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_PL,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_PL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_PL },
         { "8",  OPTION_VAL_8_PL },
         { "12", OPTION_VAL_12_PL },
         { "16", OPTION_VAL_16_PL },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_PL,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_PL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_PL,
      BSNES_VIDEO_FILTER_LABEL_PL,
      BSNES_VIDEO_FILTER_INFO_0_PL,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_PL },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_PL },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_PL },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_PL },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_PL },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_PL,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_PL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PL },
         { "10", OPTION_VAL_10_PL },
         { "20", OPTION_VAL_20_PL },
         { "30", OPTION_VAL_30_PL },
         { "40", OPTION_VAL_40_PL },
         { "50", OPTION_VAL_50_PL },
         { "60", OPTION_VAL_60_PL },
         { "70", OPTION_VAL_70_PL },
         { "80", OPTION_VAL_80_PL },
         { "90", OPTION_VAL_90_PL },
         { "100", OPTION_VAL_100_PL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_PL,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_PL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PL },
         { "10", OPTION_VAL_10_PL },
         { "20", OPTION_VAL_20_PL },
         { "30", OPTION_VAL_30_PL },
         { "40", OPTION_VAL_40_PL },
         { "50", OPTION_VAL_50_PL },
         { "60", OPTION_VAL_60_PL },
         { "70", OPTION_VAL_70_PL },
         { "80", OPTION_VAL_80_PL },
         { "90", OPTION_VAL_90_PL },
         { "100", OPTION_VAL_100_PL },
         { "110", OPTION_VAL_110_PL },
         { "120", OPTION_VAL_120_PL },
         { "130", OPTION_VAL_130_PL },
         { "140", OPTION_VAL_140_PL },
         { "150", OPTION_VAL_150_PL },
         { "160", OPTION_VAL_160_PL },
         { "170", OPTION_VAL_170_PL },
         { "180", OPTION_VAL_180_PL },
         { "190", OPTION_VAL_190_PL },
         { "200", OPTION_VAL_200_PL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_PL,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_PL,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_PL },
         { "110", OPTION_VAL_110_PL },
         { "120", OPTION_VAL_120_PL },
         { "130", OPTION_VAL_130_PL },
         { "140", OPTION_VAL_140_PL },
         { "150", OPTION_VAL_150_O6_PL },
         { "160", OPTION_VAL_160_PL },
         { "170", OPTION_VAL_170_PL },
         { "180", OPTION_VAL_180_PL },
         { "190", OPTION_VAL_190_PL },
         { "200", OPTION_VAL_200_PL },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_PL,
      BSNES_PPU_FAST_LABEL_CAT_PL,
      BSNES_PPU_FAST_INFO_0_PL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_PL,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_PL,
      BSNES_PPU_DEINTERLACE_INFO_0_PL,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PL,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PL,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PL,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PL,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PL,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_PL,
      BSNES_DSP_FAST_LABEL_CAT_PL,
      BSNES_DSP_FAST_INFO_0_PL,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_PL,
      BSNES_DSP_CUBIC_LABEL_CAT_PL,
      BSNES_DSP_CUBIC_INFO_0_PL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_PL,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PL,
      BSNES_DSP_ECHO_SHADOW_INFO_0_PL,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_PL,
      BSNES_MODE7_SCALE_LABEL_CAT_PL,
      BSNES_MODE7_SCALE_INFO_0_PL,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_PL  },
         { "2x", OPTION_VAL_2X_PL  },
         { "3x", OPTION_VAL_3X_PL  },
         { "4x", OPTION_VAL_4X_PL  },
         { "5x", OPTION_VAL_5X_PL },
         { "6x", OPTION_VAL_6X_PL },
         { "7x", OPTION_VAL_7X_PL },
         { "8x", OPTION_VAL_8X_PL },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_PL,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PL,
      BSNES_MODE7_PERSPECTIVE_INFO_0_PL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_PL,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PL,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_PL,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_PL,
      BSNES_MODE7_MOSAIC_LABEL_CAT_PL,
      BSNES_MODE7_MOSAIC_INFO_0_PL,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_PL,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_PL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_PL  },
         { "2",   OPTION_VAL_2_PL },
         { "3",   OPTION_VAL_3_PL },
         { "4",   OPTION_VAL_4_PL },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PL,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_PL,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PL,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_PL,
      NULL,
      BSNES_HOTFIXES_INFO_0_PL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_PL,
      NULL,
      BSNES_ENTROPY_INFO_0_PL,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_PL },
         { "High", OPTION_VAL_HIGH_PL },
         { "None", OPTION_VAL_NONE_PL },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_PL,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_PL,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_PL,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_PL,
      BSNES_CPU_OVERCLOCK_INFO_0_PL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PL  },
         { "20",  OPTION_VAL_20_PL  },
         { "30",  OPTION_VAL_30_PL  },
         { "40",  OPTION_VAL_40_PL  },
         { "50",  OPTION_VAL_50_PL  },
         { "60",  OPTION_VAL_60_PL  },
         { "70",  OPTION_VAL_70_PL  },
         { "80",  OPTION_VAL_80_PL  },
         { "90",  OPTION_VAL_90_PL  },
         { "100", OPTION_VAL_100_PL },
         { "110", OPTION_VAL_110_PL },
         { "120", OPTION_VAL_120_PL },
         { "130", OPTION_VAL_130_PL },
         { "140", OPTION_VAL_140_PL },
         { "150", OPTION_VAL_150_PL },
         { "160", OPTION_VAL_160_PL },
         { "170", OPTION_VAL_170_PL },
         { "180", OPTION_VAL_180_PL },
         { "190", OPTION_VAL_190_PL },
         { "200", OPTION_VAL_200_PL },
         { "210", OPTION_VAL_210_PL },
         { "220", OPTION_VAL_220_PL },
         { "230", OPTION_VAL_230_PL },
         { "240", OPTION_VAL_240_PL },
         { "250", OPTION_VAL_250_PL },
         { "260", OPTION_VAL_260_PL },
         { "270", OPTION_VAL_270_PL },
         { "280", OPTION_VAL_280_PL },
         { "290", OPTION_VAL_290_PL },
         { "300", OPTION_VAL_300_PL },
         { "310", OPTION_VAL_310_PL },
         { "320", OPTION_VAL_320_PL },
         { "330", OPTION_VAL_330_PL },
         { "340", OPTION_VAL_340_PL },
         { "350", OPTION_VAL_350_PL },
         { "360", OPTION_VAL_360_PL },
         { "370", OPTION_VAL_370_PL },
         { "380", OPTION_VAL_380_PL },
         { "390", OPTION_VAL_390_PL },
         { "400", OPTION_VAL_400_PL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_PL,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PL,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_PL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PL  },
         { "20",  OPTION_VAL_20_PL  },
         { "30",  OPTION_VAL_30_PL  },
         { "40",  OPTION_VAL_40_PL  },
         { "50",  OPTION_VAL_50_PL  },
         { "60",  OPTION_VAL_60_PL  },
         { "70",  OPTION_VAL_70_PL  },
         { "80",  OPTION_VAL_80_PL  },
         { "90",  OPTION_VAL_90_PL  },
         { "100", OPTION_VAL_100_PL },
         { "110", OPTION_VAL_110_PL },
         { "120", OPTION_VAL_120_PL },
         { "130", OPTION_VAL_130_PL },
         { "140", OPTION_VAL_140_PL },
         { "150", OPTION_VAL_150_PL },
         { "160", OPTION_VAL_160_PL },
         { "170", OPTION_VAL_170_PL },
         { "180", OPTION_VAL_180_PL },
         { "190", OPTION_VAL_190_PL },
         { "200", OPTION_VAL_200_PL },
         { "210", OPTION_VAL_210_PL },
         { "220", OPTION_VAL_220_PL },
         { "230", OPTION_VAL_230_PL },
         { "240", OPTION_VAL_240_PL },
         { "250", OPTION_VAL_250_PL },
         { "260", OPTION_VAL_260_PL },
         { "270", OPTION_VAL_270_PL },
         { "280", OPTION_VAL_280_PL },
         { "290", OPTION_VAL_290_PL },
         { "300", OPTION_VAL_300_PL },
         { "310", OPTION_VAL_310_PL },
         { "320", OPTION_VAL_320_PL },
         { "330", OPTION_VAL_330_PL },
         { "340", OPTION_VAL_340_PL },
         { "350", OPTION_VAL_350_PL },
         { "360", OPTION_VAL_360_PL },
         { "370", OPTION_VAL_370_PL },
         { "380", OPTION_VAL_380_PL },
         { "390", OPTION_VAL_390_PL },
         { "400", OPTION_VAL_400_PL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_PL,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PL,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_PL,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PL  },
         { "20",  OPTION_VAL_20_PL  },
         { "30",  OPTION_VAL_30_PL  },
         { "40",  OPTION_VAL_40_PL  },
         { "50",  OPTION_VAL_50_PL  },
         { "60",  OPTION_VAL_60_PL  },
         { "70",  OPTION_VAL_70_PL  },
         { "80",  OPTION_VAL_80_PL  },
         { "90",  OPTION_VAL_90_PL  },
         { "100", OPTION_VAL_100_PL },
         { "110", OPTION_VAL_110_PL },
         { "120", OPTION_VAL_120_PL },
         { "130", OPTION_VAL_130_PL },
         { "140", OPTION_VAL_140_PL },
         { "150", OPTION_VAL_150_PL },
         { "160", OPTION_VAL_160_PL },
         { "170", OPTION_VAL_170_PL },
         { "180", OPTION_VAL_180_PL },
         { "190", OPTION_VAL_190_PL },
         { "200", OPTION_VAL_200_PL },
         { "210", OPTION_VAL_210_PL },
         { "220", OPTION_VAL_220_PL },
         { "230", OPTION_VAL_230_PL },
         { "240", OPTION_VAL_240_PL },
         { "250", OPTION_VAL_250_PL },
         { "260", OPTION_VAL_260_PL },
         { "270", OPTION_VAL_270_PL },
         { "280", OPTION_VAL_280_PL },
         { "290", OPTION_VAL_290_PL },
         { "300", OPTION_VAL_300_PL },
         { "310", OPTION_VAL_310_PL },
         { "320", OPTION_VAL_320_PL },
         { "330", OPTION_VAL_330_PL },
         { "340", OPTION_VAL_340_PL },
         { "350", OPTION_VAL_350_PL },
         { "360", OPTION_VAL_360_PL },
         { "370", OPTION_VAL_370_PL },
         { "380", OPTION_VAL_380_PL },
         { "390", OPTION_VAL_390_PL },
         { "400", OPTION_VAL_400_PL },
         { "410", OPTION_VAL_410_PL },
         { "420", OPTION_VAL_420_PL },
         { "430", OPTION_VAL_430_PL },
         { "440", OPTION_VAL_440_PL },
         { "450", OPTION_VAL_450_PL },
         { "460", OPTION_VAL_460_PL },
         { "470", OPTION_VAL_470_PL },
         { "480", OPTION_VAL_480_PL },
         { "490", OPTION_VAL_490_PL },
         { "500", OPTION_VAL_500_PL },
         { "510", OPTION_VAL_510_PL },
         { "520", OPTION_VAL_520_PL },
         { "530", OPTION_VAL_530_PL },
         { "540", OPTION_VAL_540_PL },
         { "550", OPTION_VAL_550_PL },
         { "560", OPTION_VAL_560_PL },
         { "570", OPTION_VAL_570_PL },
         { "580", OPTION_VAL_580_PL },
         { "590", OPTION_VAL_590_PL },
         { "600", OPTION_VAL_600_PL },
         { "610", OPTION_VAL_610_PL },
         { "620", OPTION_VAL_620_PL },
         { "630", OPTION_VAL_630_PL },
         { "640", OPTION_VAL_640_PL },
         { "650", OPTION_VAL_650_PL },
         { "660", OPTION_VAL_660_PL },
         { "670", OPTION_VAL_670_PL },
         { "680", OPTION_VAL_680_PL },
         { "690", OPTION_VAL_690_PL },
         { "700", OPTION_VAL_700_PL },
         { "710", OPTION_VAL_710_PL },
         { "720", OPTION_VAL_720_PL },
         { "730", OPTION_VAL_730_PL },
         { "740", OPTION_VAL_740_PL },
         { "750", OPTION_VAL_750_PL },
         { "760", OPTION_VAL_760_PL },
         { "770", OPTION_VAL_770_PL },
         { "780", OPTION_VAL_780_PL },
         { "790", OPTION_VAL_790_PL },
         { "800", OPTION_VAL_800_PL },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_PL,
      NULL,
      BSNES_SGB_BIOS_INFO_0_PL,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_PL   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_PL },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_PL,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_PL,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PL,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PL,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PL,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_pl = {
   option_cats_pl,
   option_defs_pl
};

/* RETRO_LANGUAGE_PT_BR */

#define CATEGORY_VIDEO_LABEL_PT_BR "Vídeo"
#define CATEGORY_VIDEO_INFO_0_PT_BR "Altera as configurações de saída de vídeo."
#define CATEGORY_AUDIO_LABEL_PT_BR "Áudio"
#define CATEGORY_AUDIO_INFO_0_PT_BR "Altera as configurações de saída de áudio."
#define CATEGORY_MODE7_LABEL_PT_BR "Mode 7 HD"
#define CATEGORY_MODE7_INFO_0_PT_BR "Altera as configurações relativas à emulação gráfica do Mode 7."
#define CATEGORY_HACK_LABEL_PT_BR "Hacks de emulação e otimizações"
#define CATEGORY_HACK_INFO_0_PT_BR "Permite hacks de emulação, otimizações e correções."
#define CATEGORY_OVERCLOCK_LABEL_PT_BR "Velocidade da CPU"
#define CATEGORY_OVERCLOCK_INFO_0_PT_BR "Altera a velocidade do hardware emulado."
#define CATEGORY_SGB_LABEL_PT_BR NULL
#define CATEGORY_SGB_INFO_0_PT_BR "Altera as configurações relativas à emulação do Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_PT_BR "Pistola de luz"
#define CATEGORY_LIGHTGUN_INFO_0_PT_BR "Altera as configurações da pistola de luz (tela sensível ao toque)."
#define BSNES_ASPECT_RATIO_LABEL_PT_BR "Proporção de tela"
#define BSNES_ASPECT_RATIO_INFO_0_PT_BR "Define a proporção de tela do conteúdo.\nOBSERVAÇÃO: requer \"Fornecida pelo núcleo\" ativada nas configurações de vídeo."
#define OPTION_VAL_AUTO_PT_BR "Automática"
#define OPTION_VAL_1_1_PT_BR "PAR 1:1 (Pixel Perfect)"
#define OPTION_VAL_4_3_PT_BR "DAR 4:3"
#define OPTION_VAL_NTSC_PT_BR NULL
#define OPTION_VAL_PAL_PT_BR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_PT_BR "Cortar overscan vertical"
#define BSNES_PPU_OVERSCAN_V_INFO_0_PT_BR "Remove uma quantidade de linhas da parte superior e inferior da tela para simular a moldura de uma TV da época do Super Nintendo (SNES)."
#define OPTION_VAL_0_PT_BR "0 linhas"
#define OPTION_VAL_8_PT_BR "8 linhas"
#define OPTION_VAL_12_PT_BR "12 linhas"
#define OPTION_VAL_16_PT_BR "16 linhas"
#define BSNES_BLUR_EMULATION_LABEL_PT_BR "Emulação de desfoque"
#define BSNES_BLUR_EMULATION_INFO_0_PT_BR "Simula a resolução horizontal limitada de uma SDTV, desfocando os píxeis horizontalmente adjacentes. Alguns jogos dependem do desfoque para emular um efeito de transparência."
#define BSNES_VIDEO_FILTER_LABEL_PT_BR "Filtro"
#define BSNES_VIDEO_FILTER_INFO_0_PT_BR "Define entre não usar filtro ou usar filtro NTSC do blargg's, com opções de RF, composto, S-Video ou RGB."
#define OPTION_VAL_NONE_PT_BR "Nenhuma"
#define OPTION_VAL_NTSC_RF_PT_BR NULL
#define OPTION_VAL_NTSC_COMPOSITE_PT_BR "NTSC (composto)"
#define OPTION_VAL_NTSC_S_VIDEO_PT_BR NULL
#define OPTION_VAL_NTSC_RGB_PT_BR NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_PT_BR "Luminosidade"
#define BSNES_VIDEO_LUMINANCE_INFO_0_PT_BR "Ajusta a luminosidade."
#define OPTION_VAL_0_O4_PT_BR NULL
#define OPTION_VAL_10_PT_BR NULL
#define OPTION_VAL_20_PT_BR NULL
#define OPTION_VAL_30_PT_BR NULL
#define OPTION_VAL_40_PT_BR NULL
#define OPTION_VAL_50_PT_BR NULL
#define OPTION_VAL_60_PT_BR NULL
#define OPTION_VAL_70_PT_BR NULL
#define OPTION_VAL_80_PT_BR NULL
#define OPTION_VAL_90_PT_BR NULL
#define OPTION_VAL_100_PT_BR "100% (padrão)"
#define BSNES_VIDEO_SATURATION_LABEL_PT_BR "Saturação"
#define BSNES_VIDEO_SATURATION_INFO_0_PT_BR "Ajusta a saturação."
#define OPTION_VAL_110_PT_BR NULL
#define OPTION_VAL_120_PT_BR NULL
#define OPTION_VAL_130_PT_BR NULL
#define OPTION_VAL_140_PT_BR NULL
#define OPTION_VAL_150_PT_BR NULL
#define OPTION_VAL_160_PT_BR NULL
#define OPTION_VAL_170_PT_BR NULL
#define OPTION_VAL_180_PT_BR NULL
#define OPTION_VAL_190_PT_BR NULL
#define OPTION_VAL_200_PT_BR NULL
#define BSNES_VIDEO_GAMMA_LABEL_PT_BR "Gama de cores"
#define BSNES_VIDEO_GAMMA_INFO_0_PT_BR "Ajusta a gama de cores."
#define OPTION_VAL_100_O6_PT_BR NULL
#define OPTION_VAL_150_O6_PT_BR "150% (padrão)"
#define BSNES_PPU_FAST_LABEL_PT_BR "PPU (vídeo) — Modo rápido"
#define BSNES_PPU_FAST_LABEL_CAT_PT_BR "PPU — Modo rápido"
#define BSNES_PPU_FAST_INFO_0_PT_BR "Ativa uma emulação mais rápida do PPU ao custo de uma pequena redução de precisão.\nOBSERVAÇÃO: permite ativar \"Desentrelaçamento\", \"Sem limite de sprites\" e \"Mode 7 HD\"."
#define BSNES_PPU_DEINTERLACE_LABEL_PT_BR "PPU (vídeo) — Desentrelaçamento"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_PT_BR "PPU — Desentrelaçamento"
#define BSNES_PPU_DEINTERLACE_INFO_0_PT_BR "Desentrelaça todos os jogos ao renderizar internamente a 480p. A penalidade de desempenho é quase inexistente."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PT_BR "PPU (vídeo) — Sem limite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PT_BR "PPU — Sem limite de sprites"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PT_BR "Remove qualquer limite para a quantidade de sprites que podem ser desenhados simultaneamente na tela.\nOBSERVAÇÃO: pode causar problemas em alguns jogos."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PT_BR "PPU (vídeo) — Sem bloqueio de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PT_BR "PPU — Sem bloqueio de VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PT_BR "Emula um erro de versões antigas do ZSNES e Snes9x, onde o bloqueio de VRAM não era emulado. Algumas ROMs hacks mais antigas dependem deste comportamento e renderizarão gráficos incorretamente se isto não for ativado. Esta opção é extremamente imprecisa e prejudica a velocidade do PPU, portanto é recomendável deixá-la desativada, a menos que você precise jogar um jogo que seja incompatível com este núcleo."
#define BSNES_DSP_FAST_LABEL_PT_BR "DSP (áudio) — Modo rápido"
#define BSNES_DSP_FAST_LABEL_CAT_PT_BR "DSP — Modo rápido"
#define BSNES_DSP_FAST_INFO_0_PT_BR "Permite uma emulação mais rápida do DSP ao custo de uma pequena redução da precisão. É recomendável deixá-la ligada."
#define BSNES_DSP_CUBIC_LABEL_PT_BR "DSP (áudio) — Interpolação cúbica"
#define BSNES_DSP_CUBIC_LABEL_CAT_PT_BR "DSP — Interpolação cúbica"
#define BSNES_DSP_CUBIC_INFO_0_PT_BR "Aplica interpolação cúbica ao som, preservando mais a alta frequência."
#define BSNES_DSP_ECHO_SHADOW_LABEL_PT_BR "DSP (áudio) — Sombra da RAM ecoada"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PT_BR "DSP — Sombra da RAM ecoada"
#define BSNES_DSP_ECHO_SHADOW_INFO_0_PT_BR "Emula um erro do ZSNES, onde a RAM ecoada era separada da RAM do APU. Muitas ROMs hacks mais antigas de Super Mario World dependem deste comportamento e travarão sem isto. Esta opção é extremamente imprecisa e não deve ser usada, a menos que seja necessária."
#define BSNES_MODE7_SCALE_LABEL_PT_BR "Mode 7 HD — Escala"
#define BSNES_MODE7_SCALE_LABEL_CAT_PT_BR "Escala"
#define BSNES_MODE7_SCALE_INFO_0_PT_BR "Aumenta a resolução horizontal e vertical dos gráficos do Mode 7 usado em alguns jogos."
#define OPTION_VAL_1X_PT_BR "240p (padrão)"
#define OPTION_VAL_2X_PT_BR "480p (200%)"
#define OPTION_VAL_3X_PT_BR "720p (300%)"
#define OPTION_VAL_4X_PT_BR "960p (400%)"
#define OPTION_VAL_5X_PT_BR "1200p (500%)"
#define OPTION_VAL_6X_PT_BR "1440p (600%)"
#define OPTION_VAL_7X_PT_BR "1680p (700%)"
#define OPTION_VAL_8X_PT_BR "1920p (800%)"
#define BSNES_MODE7_PERSPECTIVE_LABEL_PT_BR "Mode 7 HD — Correção de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PT_BR "Correção de perspectiva"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_PT_BR "Corrige a perspectiva dos gráficos do Mode 7 usado em alguns jogos, trabalhando em torno de algumas limitações dos números inteiros usados pelo SNES."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_PT_BR "Mode 7 HD — Superamostragem"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PT_BR "Superamostragem"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_PT_BR "Redimensiona os gráficos do Mode 7, usado em alguns jogos. Combinado com fatores de escala superiores ao Mode 7, produz um efeito semelhante ao antisserrilhamento."
#define BSNES_MODE7_MOSAIC_LABEL_PT_BR "Mode 7 HD — Mosaico (HD → SD)"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_PT_BR "Mosaico (HD → SD)"
#define BSNES_MODE7_MOSAIC_INFO_0_PT_BR "Exibe o efeito mosaico dos gráficos do Mode 7 até mesmo ao mudar a escala."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_PT_BR "Execução antecipada interna"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_PT_BR "Simula o sistema antecipadamente e retrocede para reduzir a latência da entrada.\nOBSERVAÇÃO: requisitos de sistema muito altos."
#define OPTION_VAL_1_PT_BR "1 quadro"
#define OPTION_VAL_2_PT_BR "2 quadros"
#define OPTION_VAL_3_PT_BR "3 quadros"
#define OPTION_VAL_4_PT_BR "4 quadros"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PT_BR "Coprocessadores — Modo rápido"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PT_BR "Permite uma emulação mais rápida dos coprocessadores ao custo de uma pequena redução da precisão."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_PT_BR "Coprocessadores — HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PT_BR "Usa uma emulação HLE menos precisa quando disponível. Ao ser desligado, o HLE apenas será usado quando o firmware LLE estiver faltando."
#define BSNES_HOTFIXES_LABEL_PT_BR "Correções"
#define BSNES_HOTFIXES_INFO_0_PT_BR "Corrige alguns problemas que ocorrem até mesmo no hardware original."
#define BSNES_ENTROPY_LABEL_PT_BR "Entropia (aleatoriedade)"
#define BSNES_ENTROPY_INFO_0_PT_BR "Define o nível de aleatoriedade da memória e registros.\n\"Nenhuma\": os valores são definidos como constantes na inicialização.\n\"Baixa\": aleatoriedade mais precisa do sistema original.\n\"Alta\": máximo de aleatoriedade possível."
#define OPTION_VAL_LOW_PT_BR "Baixa"
#define OPTION_VAL_HIGH_PT_BR "Alta"
#define BSNES_CPU_FASTMATH_LABEL_PT_BR "Acelerar matemática da CPU"
#define BSNES_CPU_FASTMATH_INFO_0_PT_BR "Proporciona resultados de computação de imediato. A multiplicação e a divisão pela CPU leva tempo para ser completada em um SNES real. Os emuladores mais antigos não simulavam estes atrasos e, portanto, alguns hacks mais antigos de ROMs não esperam por operações matemáticas para completar e precisam deste hack."
#define BSNES_CPU_OVERCLOCK_LABEL_PT_BR "Overclock (CPU)"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_PT_BR NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_PT_BR "Faça o overclock ou o downclock da CPU. A definição deste valor acima de 100% pode reduzir os tempos de carregamento e remover a lentidão. Use com cautela, pois também pode causar o travamento de alguns jogos ou apresentar outros problemas."
#define OPTION_VAL_210_PT_BR NULL
#define OPTION_VAL_220_PT_BR NULL
#define OPTION_VAL_230_PT_BR NULL
#define OPTION_VAL_240_PT_BR NULL
#define OPTION_VAL_250_PT_BR NULL
#define OPTION_VAL_260_PT_BR NULL
#define OPTION_VAL_270_PT_BR NULL
#define OPTION_VAL_280_PT_BR NULL
#define OPTION_VAL_290_PT_BR NULL
#define OPTION_VAL_300_PT_BR NULL
#define OPTION_VAL_310_PT_BR NULL
#define OPTION_VAL_320_PT_BR NULL
#define OPTION_VAL_330_PT_BR NULL
#define OPTION_VAL_340_PT_BR NULL
#define OPTION_VAL_350_PT_BR NULL
#define OPTION_VAL_360_PT_BR NULL
#define OPTION_VAL_370_PT_BR NULL
#define OPTION_VAL_380_PT_BR NULL
#define OPTION_VAL_390_PT_BR NULL
#define OPTION_VAL_400_PT_BR NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_PT_BR "Overclock (coprocessador SA-1)"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PT_BR "Coprocessador SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_PT_BR "Faça o overclock ou o downclock do chip do 'Super Accelerator 1' (SA-1). A definição deste valor acima de 100% pode melhorar o desempenho em jogos que suportam o chip SA-1. Use com cautela, pois pode também causar o travamento de alguns jogos ou apresentar outros problemas."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_PT_BR "Overclock (coprocessador SuperFX)"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PT_BR "Coprocessador Super FX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_PT_BR "Faça o overclock ou o downclock do coprocessador SuperFX. A definição deste valor acima de 100% pode melhorar o desempenho em jogos que suportam o SuperFX. Use com cautela, pois pode também causar o travamento de alguns jogos ou apresentar outros problemas."
#define OPTION_VAL_410_PT_BR NULL
#define OPTION_VAL_420_PT_BR NULL
#define OPTION_VAL_430_PT_BR NULL
#define OPTION_VAL_440_PT_BR NULL
#define OPTION_VAL_450_PT_BR NULL
#define OPTION_VAL_460_PT_BR NULL
#define OPTION_VAL_470_PT_BR NULL
#define OPTION_VAL_480_PT_BR NULL
#define OPTION_VAL_490_PT_BR NULL
#define OPTION_VAL_500_PT_BR NULL
#define OPTION_VAL_510_PT_BR NULL
#define OPTION_VAL_520_PT_BR NULL
#define OPTION_VAL_530_PT_BR NULL
#define OPTION_VAL_540_PT_BR NULL
#define OPTION_VAL_550_PT_BR NULL
#define OPTION_VAL_560_PT_BR NULL
#define OPTION_VAL_570_PT_BR NULL
#define OPTION_VAL_580_PT_BR NULL
#define OPTION_VAL_590_PT_BR NULL
#define OPTION_VAL_600_PT_BR NULL
#define OPTION_VAL_610_PT_BR NULL
#define OPTION_VAL_620_PT_BR NULL
#define OPTION_VAL_630_PT_BR NULL
#define OPTION_VAL_640_PT_BR NULL
#define OPTION_VAL_650_PT_BR NULL
#define OPTION_VAL_660_PT_BR NULL
#define OPTION_VAL_670_PT_BR NULL
#define OPTION_VAL_680_PT_BR NULL
#define OPTION_VAL_690_PT_BR NULL
#define OPTION_VAL_700_PT_BR NULL
#define OPTION_VAL_710_PT_BR NULL
#define OPTION_VAL_720_PT_BR NULL
#define OPTION_VAL_730_PT_BR NULL
#define OPTION_VAL_740_PT_BR NULL
#define OPTION_VAL_750_PT_BR NULL
#define OPTION_VAL_760_PT_BR NULL
#define OPTION_VAL_770_PT_BR NULL
#define OPTION_VAL_780_PT_BR NULL
#define OPTION_VAL_790_PT_BR NULL
#define OPTION_VAL_800_PT_BR NULL
#define BSNES_SGB_BIOS_LABEL_PT_BR "BIOS do Super Game Boy (requer reinício)"
#define BSNES_SGB_BIOS_INFO_0_PT_BR "Define a BIOS de Super Game Boy que será usada nos jogos compatíveis."
#define OPTION_VAL_SGB1_SFC_PT_BR NULL
#define OPTION_VAL_SGB2_SFC_PT_BR NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_PT_BR "Ocultar bordas"
#define BSNES_HIDE_SGB_BORDER_INFO_0_PT_BR "Oculta as bordas em jogos de Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PT_BR "Tela sensível ao toque"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PT_BR "Ativa a entrada do Super Scope em dispositivos com tela sensível ao toque."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PT_BR "Inverter botões do Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PT_BR "Inverte os botões de gatilho e cursor na tela sensível ao toque."

struct retro_core_option_v2_category option_cats_pt_br[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_PT_BR,
      CATEGORY_VIDEO_INFO_0_PT_BR
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_PT_BR,
      CATEGORY_AUDIO_INFO_0_PT_BR
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_PT_BR,
      CATEGORY_MODE7_INFO_0_PT_BR
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_PT_BR,
      CATEGORY_HACK_INFO_0_PT_BR
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_PT_BR,
      CATEGORY_OVERCLOCK_INFO_0_PT_BR
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_PT_BR,
      CATEGORY_SGB_INFO_0_PT_BR
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_PT_BR,
      CATEGORY_LIGHTGUN_INFO_0_PT_BR
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_pt_br[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_PT_BR,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_PT_BR },
         { "1:1",  OPTION_VAL_1_1_PT_BR },
         { "4:3",  OPTION_VAL_4_3_PT_BR },
         { "NTSC", OPTION_VAL_NTSC_PT_BR },
         { "PAL",  OPTION_VAL_PAL_PT_BR },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_PT_BR,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_PT_BR },
         { "8",  OPTION_VAL_8_PT_BR },
         { "12", OPTION_VAL_12_PT_BR },
         { "16", OPTION_VAL_16_PT_BR },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_PT_BR,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_PT_BR,
      BSNES_VIDEO_FILTER_LABEL_PT_BR,
      BSNES_VIDEO_FILTER_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_PT_BR },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_PT_BR },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_PT_BR },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_PT_BR },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_PT_BR },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_PT_BR,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PT_BR },
         { "10", OPTION_VAL_10_PT_BR },
         { "20", OPTION_VAL_20_PT_BR },
         { "30", OPTION_VAL_30_PT_BR },
         { "40", OPTION_VAL_40_PT_BR },
         { "50", OPTION_VAL_50_PT_BR },
         { "60", OPTION_VAL_60_PT_BR },
         { "70", OPTION_VAL_70_PT_BR },
         { "80", OPTION_VAL_80_PT_BR },
         { "90", OPTION_VAL_90_PT_BR },
         { "100", OPTION_VAL_100_PT_BR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_PT_BR,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PT_BR },
         { "10", OPTION_VAL_10_PT_BR },
         { "20", OPTION_VAL_20_PT_BR },
         { "30", OPTION_VAL_30_PT_BR },
         { "40", OPTION_VAL_40_PT_BR },
         { "50", OPTION_VAL_50_PT_BR },
         { "60", OPTION_VAL_60_PT_BR },
         { "70", OPTION_VAL_70_PT_BR },
         { "80", OPTION_VAL_80_PT_BR },
         { "90", OPTION_VAL_90_PT_BR },
         { "100", OPTION_VAL_100_PT_BR },
         { "110", OPTION_VAL_110_PT_BR },
         { "120", OPTION_VAL_120_PT_BR },
         { "130", OPTION_VAL_130_PT_BR },
         { "140", OPTION_VAL_140_PT_BR },
         { "150", OPTION_VAL_150_PT_BR },
         { "160", OPTION_VAL_160_PT_BR },
         { "170", OPTION_VAL_170_PT_BR },
         { "180", OPTION_VAL_180_PT_BR },
         { "190", OPTION_VAL_190_PT_BR },
         { "200", OPTION_VAL_200_PT_BR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_PT_BR,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_PT_BR },
         { "110", OPTION_VAL_110_PT_BR },
         { "120", OPTION_VAL_120_PT_BR },
         { "130", OPTION_VAL_130_PT_BR },
         { "140", OPTION_VAL_140_PT_BR },
         { "150", OPTION_VAL_150_O6_PT_BR },
         { "160", OPTION_VAL_160_PT_BR },
         { "170", OPTION_VAL_170_PT_BR },
         { "180", OPTION_VAL_180_PT_BR },
         { "190", OPTION_VAL_190_PT_BR },
         { "200", OPTION_VAL_200_PT_BR },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_PT_BR,
      BSNES_PPU_FAST_LABEL_CAT_PT_BR,
      BSNES_PPU_FAST_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_PT_BR,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_PT_BR,
      BSNES_PPU_DEINTERLACE_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PT_BR,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PT_BR,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PT_BR,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PT_BR,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PT_BR,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_PT_BR,
      BSNES_DSP_FAST_LABEL_CAT_PT_BR,
      BSNES_DSP_FAST_INFO_0_PT_BR,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_PT_BR,
      BSNES_DSP_CUBIC_LABEL_CAT_PT_BR,
      BSNES_DSP_CUBIC_INFO_0_PT_BR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_PT_BR,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PT_BR,
      BSNES_DSP_ECHO_SHADOW_INFO_0_PT_BR,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_PT_BR,
      BSNES_MODE7_SCALE_LABEL_CAT_PT_BR,
      BSNES_MODE7_SCALE_INFO_0_PT_BR,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_PT_BR  },
         { "2x", OPTION_VAL_2X_PT_BR  },
         { "3x", OPTION_VAL_3X_PT_BR  },
         { "4x", OPTION_VAL_4X_PT_BR  },
         { "5x", OPTION_VAL_5X_PT_BR },
         { "6x", OPTION_VAL_6X_PT_BR },
         { "7x", OPTION_VAL_7X_PT_BR },
         { "8x", OPTION_VAL_8X_PT_BR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_PT_BR,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PT_BR,
      BSNES_MODE7_PERSPECTIVE_INFO_0_PT_BR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_PT_BR,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PT_BR,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_PT_BR,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_PT_BR,
      BSNES_MODE7_MOSAIC_LABEL_CAT_PT_BR,
      BSNES_MODE7_MOSAIC_INFO_0_PT_BR,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_PT_BR,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_PT_BR  },
         { "2",   OPTION_VAL_2_PT_BR },
         { "3",   OPTION_VAL_3_PT_BR },
         { "4",   OPTION_VAL_4_PT_BR },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PT_BR,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_PT_BR,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_PT_BR,
      NULL,
      BSNES_HOTFIXES_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_PT_BR,
      NULL,
      BSNES_ENTROPY_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_PT_BR },
         { "High", OPTION_VAL_HIGH_PT_BR },
         { "None", OPTION_VAL_NONE_PT_BR },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_PT_BR,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_PT_BR,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_PT_BR,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_PT_BR,
      BSNES_CPU_OVERCLOCK_INFO_0_PT_BR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_BR  },
         { "20",  OPTION_VAL_20_PT_BR  },
         { "30",  OPTION_VAL_30_PT_BR  },
         { "40",  OPTION_VAL_40_PT_BR  },
         { "50",  OPTION_VAL_50_PT_BR  },
         { "60",  OPTION_VAL_60_PT_BR  },
         { "70",  OPTION_VAL_70_PT_BR  },
         { "80",  OPTION_VAL_80_PT_BR  },
         { "90",  OPTION_VAL_90_PT_BR  },
         { "100", OPTION_VAL_100_PT_BR },
         { "110", OPTION_VAL_110_PT_BR },
         { "120", OPTION_VAL_120_PT_BR },
         { "130", OPTION_VAL_130_PT_BR },
         { "140", OPTION_VAL_140_PT_BR },
         { "150", OPTION_VAL_150_PT_BR },
         { "160", OPTION_VAL_160_PT_BR },
         { "170", OPTION_VAL_170_PT_BR },
         { "180", OPTION_VAL_180_PT_BR },
         { "190", OPTION_VAL_190_PT_BR },
         { "200", OPTION_VAL_200_PT_BR },
         { "210", OPTION_VAL_210_PT_BR },
         { "220", OPTION_VAL_220_PT_BR },
         { "230", OPTION_VAL_230_PT_BR },
         { "240", OPTION_VAL_240_PT_BR },
         { "250", OPTION_VAL_250_PT_BR },
         { "260", OPTION_VAL_260_PT_BR },
         { "270", OPTION_VAL_270_PT_BR },
         { "280", OPTION_VAL_280_PT_BR },
         { "290", OPTION_VAL_290_PT_BR },
         { "300", OPTION_VAL_300_PT_BR },
         { "310", OPTION_VAL_310_PT_BR },
         { "320", OPTION_VAL_320_PT_BR },
         { "330", OPTION_VAL_330_PT_BR },
         { "340", OPTION_VAL_340_PT_BR },
         { "350", OPTION_VAL_350_PT_BR },
         { "360", OPTION_VAL_360_PT_BR },
         { "370", OPTION_VAL_370_PT_BR },
         { "380", OPTION_VAL_380_PT_BR },
         { "390", OPTION_VAL_390_PT_BR },
         { "400", OPTION_VAL_400_PT_BR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_PT_BR,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PT_BR,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_PT_BR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_BR  },
         { "20",  OPTION_VAL_20_PT_BR  },
         { "30",  OPTION_VAL_30_PT_BR  },
         { "40",  OPTION_VAL_40_PT_BR  },
         { "50",  OPTION_VAL_50_PT_BR  },
         { "60",  OPTION_VAL_60_PT_BR  },
         { "70",  OPTION_VAL_70_PT_BR  },
         { "80",  OPTION_VAL_80_PT_BR  },
         { "90",  OPTION_VAL_90_PT_BR  },
         { "100", OPTION_VAL_100_PT_BR },
         { "110", OPTION_VAL_110_PT_BR },
         { "120", OPTION_VAL_120_PT_BR },
         { "130", OPTION_VAL_130_PT_BR },
         { "140", OPTION_VAL_140_PT_BR },
         { "150", OPTION_VAL_150_PT_BR },
         { "160", OPTION_VAL_160_PT_BR },
         { "170", OPTION_VAL_170_PT_BR },
         { "180", OPTION_VAL_180_PT_BR },
         { "190", OPTION_VAL_190_PT_BR },
         { "200", OPTION_VAL_200_PT_BR },
         { "210", OPTION_VAL_210_PT_BR },
         { "220", OPTION_VAL_220_PT_BR },
         { "230", OPTION_VAL_230_PT_BR },
         { "240", OPTION_VAL_240_PT_BR },
         { "250", OPTION_VAL_250_PT_BR },
         { "260", OPTION_VAL_260_PT_BR },
         { "270", OPTION_VAL_270_PT_BR },
         { "280", OPTION_VAL_280_PT_BR },
         { "290", OPTION_VAL_290_PT_BR },
         { "300", OPTION_VAL_300_PT_BR },
         { "310", OPTION_VAL_310_PT_BR },
         { "320", OPTION_VAL_320_PT_BR },
         { "330", OPTION_VAL_330_PT_BR },
         { "340", OPTION_VAL_340_PT_BR },
         { "350", OPTION_VAL_350_PT_BR },
         { "360", OPTION_VAL_360_PT_BR },
         { "370", OPTION_VAL_370_PT_BR },
         { "380", OPTION_VAL_380_PT_BR },
         { "390", OPTION_VAL_390_PT_BR },
         { "400", OPTION_VAL_400_PT_BR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_PT_BR,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PT_BR,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_PT_BR,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_BR  },
         { "20",  OPTION_VAL_20_PT_BR  },
         { "30",  OPTION_VAL_30_PT_BR  },
         { "40",  OPTION_VAL_40_PT_BR  },
         { "50",  OPTION_VAL_50_PT_BR  },
         { "60",  OPTION_VAL_60_PT_BR  },
         { "70",  OPTION_VAL_70_PT_BR  },
         { "80",  OPTION_VAL_80_PT_BR  },
         { "90",  OPTION_VAL_90_PT_BR  },
         { "100", OPTION_VAL_100_PT_BR },
         { "110", OPTION_VAL_110_PT_BR },
         { "120", OPTION_VAL_120_PT_BR },
         { "130", OPTION_VAL_130_PT_BR },
         { "140", OPTION_VAL_140_PT_BR },
         { "150", OPTION_VAL_150_PT_BR },
         { "160", OPTION_VAL_160_PT_BR },
         { "170", OPTION_VAL_170_PT_BR },
         { "180", OPTION_VAL_180_PT_BR },
         { "190", OPTION_VAL_190_PT_BR },
         { "200", OPTION_VAL_200_PT_BR },
         { "210", OPTION_VAL_210_PT_BR },
         { "220", OPTION_VAL_220_PT_BR },
         { "230", OPTION_VAL_230_PT_BR },
         { "240", OPTION_VAL_240_PT_BR },
         { "250", OPTION_VAL_250_PT_BR },
         { "260", OPTION_VAL_260_PT_BR },
         { "270", OPTION_VAL_270_PT_BR },
         { "280", OPTION_VAL_280_PT_BR },
         { "290", OPTION_VAL_290_PT_BR },
         { "300", OPTION_VAL_300_PT_BR },
         { "310", OPTION_VAL_310_PT_BR },
         { "320", OPTION_VAL_320_PT_BR },
         { "330", OPTION_VAL_330_PT_BR },
         { "340", OPTION_VAL_340_PT_BR },
         { "350", OPTION_VAL_350_PT_BR },
         { "360", OPTION_VAL_360_PT_BR },
         { "370", OPTION_VAL_370_PT_BR },
         { "380", OPTION_VAL_380_PT_BR },
         { "390", OPTION_VAL_390_PT_BR },
         { "400", OPTION_VAL_400_PT_BR },
         { "410", OPTION_VAL_410_PT_BR },
         { "420", OPTION_VAL_420_PT_BR },
         { "430", OPTION_VAL_430_PT_BR },
         { "440", OPTION_VAL_440_PT_BR },
         { "450", OPTION_VAL_450_PT_BR },
         { "460", OPTION_VAL_460_PT_BR },
         { "470", OPTION_VAL_470_PT_BR },
         { "480", OPTION_VAL_480_PT_BR },
         { "490", OPTION_VAL_490_PT_BR },
         { "500", OPTION_VAL_500_PT_BR },
         { "510", OPTION_VAL_510_PT_BR },
         { "520", OPTION_VAL_520_PT_BR },
         { "530", OPTION_VAL_530_PT_BR },
         { "540", OPTION_VAL_540_PT_BR },
         { "550", OPTION_VAL_550_PT_BR },
         { "560", OPTION_VAL_560_PT_BR },
         { "570", OPTION_VAL_570_PT_BR },
         { "580", OPTION_VAL_580_PT_BR },
         { "590", OPTION_VAL_590_PT_BR },
         { "600", OPTION_VAL_600_PT_BR },
         { "610", OPTION_VAL_610_PT_BR },
         { "620", OPTION_VAL_620_PT_BR },
         { "630", OPTION_VAL_630_PT_BR },
         { "640", OPTION_VAL_640_PT_BR },
         { "650", OPTION_VAL_650_PT_BR },
         { "660", OPTION_VAL_660_PT_BR },
         { "670", OPTION_VAL_670_PT_BR },
         { "680", OPTION_VAL_680_PT_BR },
         { "690", OPTION_VAL_690_PT_BR },
         { "700", OPTION_VAL_700_PT_BR },
         { "710", OPTION_VAL_710_PT_BR },
         { "720", OPTION_VAL_720_PT_BR },
         { "730", OPTION_VAL_730_PT_BR },
         { "740", OPTION_VAL_740_PT_BR },
         { "750", OPTION_VAL_750_PT_BR },
         { "760", OPTION_VAL_760_PT_BR },
         { "770", OPTION_VAL_770_PT_BR },
         { "780", OPTION_VAL_780_PT_BR },
         { "790", OPTION_VAL_790_PT_BR },
         { "800", OPTION_VAL_800_PT_BR },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_PT_BR,
      NULL,
      BSNES_SGB_BIOS_INFO_0_PT_BR,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_PT_BR   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_PT_BR },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_PT_BR,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_PT_BR,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PT_BR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PT_BR,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PT_BR,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PT_BR,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_pt_br = {
   option_cats_pt_br,
   option_defs_pt_br
};

/* RETRO_LANGUAGE_PT_PT */

#define CATEGORY_VIDEO_LABEL_PT_PT "Vídeo"
#define CATEGORY_VIDEO_INFO_0_PT_PT "Alterar as definições da saída de vídeo."
#define CATEGORY_AUDIO_LABEL_PT_PT "Áudio"
#define CATEGORY_AUDIO_INFO_0_PT_PT "Modificar as definições de saída de som."
#define CATEGORY_MODE7_LABEL_PT_PT NULL
#define CATEGORY_MODE7_INFO_0_PT_PT NULL
#define CATEGORY_HACK_LABEL_PT_PT NULL
#define CATEGORY_HACK_INFO_0_PT_PT NULL
#define CATEGORY_OVERCLOCK_LABEL_PT_PT NULL
#define CATEGORY_OVERCLOCK_INFO_0_PT_PT NULL
#define CATEGORY_SGB_LABEL_PT_PT NULL
#define CATEGORY_SGB_INFO_0_PT_PT NULL
#define CATEGORY_LIGHTGUN_LABEL_PT_PT NULL
#define CATEGORY_LIGHTGUN_INFO_0_PT_PT NULL
#define BSNES_ASPECT_RATIO_LABEL_PT_PT NULL
#define BSNES_ASPECT_RATIO_INFO_0_PT_PT NULL
#define OPTION_VAL_AUTO_PT_PT "Automático"
#define OPTION_VAL_1_1_PT_PT NULL
#define OPTION_VAL_4_3_PT_PT NULL
#define OPTION_VAL_NTSC_PT_PT NULL
#define OPTION_VAL_PAL_PT_PT NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_PT_PT NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_PT_PT NULL
#define OPTION_VAL_0_PT_PT NULL
#define OPTION_VAL_8_PT_PT NULL
#define OPTION_VAL_12_PT_PT NULL
#define OPTION_VAL_16_PT_PT NULL
#define BSNES_BLUR_EMULATION_LABEL_PT_PT NULL
#define BSNES_BLUR_EMULATION_INFO_0_PT_PT NULL
#define BSNES_VIDEO_FILTER_LABEL_PT_PT "Filtro"
#define BSNES_VIDEO_FILTER_INFO_0_PT_PT NULL
#define OPTION_VAL_NONE_PT_PT "Nenhum"
#define OPTION_VAL_NTSC_RF_PT_PT NULL
#define OPTION_VAL_NTSC_COMPOSITE_PT_PT NULL
#define OPTION_VAL_NTSC_S_VIDEO_PT_PT NULL
#define OPTION_VAL_NTSC_RGB_PT_PT NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_PT_PT NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_PT_PT NULL
#define OPTION_VAL_0_O4_PT_PT NULL
#define OPTION_VAL_10_PT_PT NULL
#define OPTION_VAL_20_PT_PT NULL
#define OPTION_VAL_30_PT_PT NULL
#define OPTION_VAL_40_PT_PT NULL
#define OPTION_VAL_50_PT_PT NULL
#define OPTION_VAL_60_PT_PT NULL
#define OPTION_VAL_70_PT_PT NULL
#define OPTION_VAL_80_PT_PT NULL
#define OPTION_VAL_90_PT_PT NULL
#define OPTION_VAL_100_PT_PT NULL
#define BSNES_VIDEO_SATURATION_LABEL_PT_PT NULL
#define BSNES_VIDEO_SATURATION_INFO_0_PT_PT NULL
#define OPTION_VAL_110_PT_PT NULL
#define OPTION_VAL_120_PT_PT NULL
#define OPTION_VAL_130_PT_PT NULL
#define OPTION_VAL_140_PT_PT NULL
#define OPTION_VAL_150_PT_PT NULL
#define OPTION_VAL_160_PT_PT NULL
#define OPTION_VAL_170_PT_PT NULL
#define OPTION_VAL_180_PT_PT NULL
#define OPTION_VAL_190_PT_PT NULL
#define OPTION_VAL_200_PT_PT NULL
#define BSNES_VIDEO_GAMMA_LABEL_PT_PT NULL
#define BSNES_VIDEO_GAMMA_INFO_0_PT_PT NULL
#define OPTION_VAL_100_O6_PT_PT NULL
#define OPTION_VAL_150_O6_PT_PT NULL
#define BSNES_PPU_FAST_LABEL_PT_PT NULL
#define BSNES_PPU_FAST_LABEL_CAT_PT_PT NULL
#define BSNES_PPU_FAST_INFO_0_PT_PT NULL
#define BSNES_PPU_DEINTERLACE_LABEL_PT_PT NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_PT_PT NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_PT_PT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PT_PT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PT_PT NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PT_PT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PT_PT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PT_PT NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PT_PT NULL
#define BSNES_DSP_FAST_LABEL_PT_PT NULL
#define BSNES_DSP_FAST_LABEL_CAT_PT_PT NULL
#define BSNES_DSP_FAST_INFO_0_PT_PT NULL
#define BSNES_DSP_CUBIC_LABEL_PT_PT NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_PT_PT NULL
#define BSNES_DSP_CUBIC_INFO_0_PT_PT NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_PT_PT NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PT_PT NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_PT_PT NULL
#define BSNES_MODE7_SCALE_LABEL_PT_PT NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_PT_PT "Escala"
#define BSNES_MODE7_SCALE_INFO_0_PT_PT NULL
#define OPTION_VAL_1X_PT_PT NULL
#define OPTION_VAL_2X_PT_PT NULL
#define OPTION_VAL_3X_PT_PT NULL
#define OPTION_VAL_4X_PT_PT NULL
#define OPTION_VAL_5X_PT_PT NULL
#define OPTION_VAL_6X_PT_PT NULL
#define OPTION_VAL_7X_PT_PT NULL
#define OPTION_VAL_8X_PT_PT NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_PT_PT NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PT_PT NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_PT_PT NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_PT_PT NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PT_PT NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_PT_PT NULL
#define BSNES_MODE7_MOSAIC_LABEL_PT_PT NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_PT_PT NULL
#define BSNES_MODE7_MOSAIC_INFO_0_PT_PT NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_PT_PT NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_PT_PT NULL
#define OPTION_VAL_1_PT_PT NULL
#define OPTION_VAL_2_PT_PT NULL
#define OPTION_VAL_3_PT_PT NULL
#define OPTION_VAL_4_PT_PT NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PT_PT NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PT_PT NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_PT_PT NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PT_PT NULL
#define BSNES_HOTFIXES_LABEL_PT_PT NULL
#define BSNES_HOTFIXES_INFO_0_PT_PT NULL
#define BSNES_ENTROPY_LABEL_PT_PT NULL
#define BSNES_ENTROPY_INFO_0_PT_PT "Escolha o nível de randomização da memória e dos registos. Se definido como Nenhum, toda a memória e registos são inicializados com valores constantes no arranque. A randomização baixa fornece a representação mais precisa de um sistema real. Elevada randomiza o máximo possível."
#define OPTION_VAL_LOW_PT_PT NULL
#define OPTION_VAL_HIGH_PT_PT NULL
#define BSNES_CPU_FASTMATH_LABEL_PT_PT NULL
#define BSNES_CPU_FASTMATH_INFO_0_PT_PT NULL
#define BSNES_CPU_OVERCLOCK_LABEL_PT_PT NULL
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_PT_PT NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_PT_PT NULL
#define OPTION_VAL_210_PT_PT NULL
#define OPTION_VAL_220_PT_PT NULL
#define OPTION_VAL_230_PT_PT NULL
#define OPTION_VAL_240_PT_PT NULL
#define OPTION_VAL_250_PT_PT NULL
#define OPTION_VAL_260_PT_PT NULL
#define OPTION_VAL_270_PT_PT NULL
#define OPTION_VAL_280_PT_PT NULL
#define OPTION_VAL_290_PT_PT NULL
#define OPTION_VAL_300_PT_PT NULL
#define OPTION_VAL_310_PT_PT NULL
#define OPTION_VAL_320_PT_PT NULL
#define OPTION_VAL_330_PT_PT NULL
#define OPTION_VAL_340_PT_PT NULL
#define OPTION_VAL_350_PT_PT NULL
#define OPTION_VAL_360_PT_PT NULL
#define OPTION_VAL_370_PT_PT NULL
#define OPTION_VAL_380_PT_PT NULL
#define OPTION_VAL_390_PT_PT NULL
#define OPTION_VAL_400_PT_PT NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_PT_PT NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PT_PT NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_PT_PT NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_PT_PT NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PT_PT NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_PT_PT NULL
#define OPTION_VAL_410_PT_PT NULL
#define OPTION_VAL_420_PT_PT NULL
#define OPTION_VAL_430_PT_PT NULL
#define OPTION_VAL_440_PT_PT NULL
#define OPTION_VAL_450_PT_PT NULL
#define OPTION_VAL_460_PT_PT NULL
#define OPTION_VAL_470_PT_PT NULL
#define OPTION_VAL_480_PT_PT NULL
#define OPTION_VAL_490_PT_PT NULL
#define OPTION_VAL_500_PT_PT NULL
#define OPTION_VAL_510_PT_PT NULL
#define OPTION_VAL_520_PT_PT NULL
#define OPTION_VAL_530_PT_PT NULL
#define OPTION_VAL_540_PT_PT NULL
#define OPTION_VAL_550_PT_PT NULL
#define OPTION_VAL_560_PT_PT NULL
#define OPTION_VAL_570_PT_PT NULL
#define OPTION_VAL_580_PT_PT NULL
#define OPTION_VAL_590_PT_PT NULL
#define OPTION_VAL_600_PT_PT NULL
#define OPTION_VAL_610_PT_PT NULL
#define OPTION_VAL_620_PT_PT NULL
#define OPTION_VAL_630_PT_PT NULL
#define OPTION_VAL_640_PT_PT NULL
#define OPTION_VAL_650_PT_PT NULL
#define OPTION_VAL_660_PT_PT NULL
#define OPTION_VAL_670_PT_PT NULL
#define OPTION_VAL_680_PT_PT NULL
#define OPTION_VAL_690_PT_PT NULL
#define OPTION_VAL_700_PT_PT NULL
#define OPTION_VAL_710_PT_PT NULL
#define OPTION_VAL_720_PT_PT NULL
#define OPTION_VAL_730_PT_PT NULL
#define OPTION_VAL_740_PT_PT NULL
#define OPTION_VAL_750_PT_PT NULL
#define OPTION_VAL_760_PT_PT NULL
#define OPTION_VAL_770_PT_PT NULL
#define OPTION_VAL_780_PT_PT NULL
#define OPTION_VAL_790_PT_PT NULL
#define OPTION_VAL_800_PT_PT NULL
#define BSNES_SGB_BIOS_LABEL_PT_PT NULL
#define BSNES_SGB_BIOS_INFO_0_PT_PT NULL
#define OPTION_VAL_SGB1_SFC_PT_PT NULL
#define OPTION_VAL_SGB2_SFC_PT_PT NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_PT_PT NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_PT_PT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PT_PT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PT_PT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PT_PT NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PT_PT NULL

struct retro_core_option_v2_category option_cats_pt_pt[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_PT_PT,
      CATEGORY_VIDEO_INFO_0_PT_PT
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_PT_PT,
      CATEGORY_AUDIO_INFO_0_PT_PT
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_PT_PT,
      CATEGORY_MODE7_INFO_0_PT_PT
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_PT_PT,
      CATEGORY_HACK_INFO_0_PT_PT
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_PT_PT,
      CATEGORY_OVERCLOCK_INFO_0_PT_PT
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_PT_PT,
      CATEGORY_SGB_INFO_0_PT_PT
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_PT_PT,
      CATEGORY_LIGHTGUN_INFO_0_PT_PT
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_pt_pt[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_PT_PT,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_PT_PT },
         { "1:1",  OPTION_VAL_1_1_PT_PT },
         { "4:3",  OPTION_VAL_4_3_PT_PT },
         { "NTSC", OPTION_VAL_NTSC_PT_PT },
         { "PAL",  OPTION_VAL_PAL_PT_PT },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_PT_PT,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_PT_PT },
         { "8",  OPTION_VAL_8_PT_PT },
         { "12", OPTION_VAL_12_PT_PT },
         { "16", OPTION_VAL_16_PT_PT },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_PT_PT,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_PT_PT,
      BSNES_VIDEO_FILTER_LABEL_PT_PT,
      BSNES_VIDEO_FILTER_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_PT_PT },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_PT_PT },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_PT_PT },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_PT_PT },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_PT_PT },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_PT_PT,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PT_PT },
         { "10", OPTION_VAL_10_PT_PT },
         { "20", OPTION_VAL_20_PT_PT },
         { "30", OPTION_VAL_30_PT_PT },
         { "40", OPTION_VAL_40_PT_PT },
         { "50", OPTION_VAL_50_PT_PT },
         { "60", OPTION_VAL_60_PT_PT },
         { "70", OPTION_VAL_70_PT_PT },
         { "80", OPTION_VAL_80_PT_PT },
         { "90", OPTION_VAL_90_PT_PT },
         { "100", OPTION_VAL_100_PT_PT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_PT_PT,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_PT_PT },
         { "10", OPTION_VAL_10_PT_PT },
         { "20", OPTION_VAL_20_PT_PT },
         { "30", OPTION_VAL_30_PT_PT },
         { "40", OPTION_VAL_40_PT_PT },
         { "50", OPTION_VAL_50_PT_PT },
         { "60", OPTION_VAL_60_PT_PT },
         { "70", OPTION_VAL_70_PT_PT },
         { "80", OPTION_VAL_80_PT_PT },
         { "90", OPTION_VAL_90_PT_PT },
         { "100", OPTION_VAL_100_PT_PT },
         { "110", OPTION_VAL_110_PT_PT },
         { "120", OPTION_VAL_120_PT_PT },
         { "130", OPTION_VAL_130_PT_PT },
         { "140", OPTION_VAL_140_PT_PT },
         { "150", OPTION_VAL_150_PT_PT },
         { "160", OPTION_VAL_160_PT_PT },
         { "170", OPTION_VAL_170_PT_PT },
         { "180", OPTION_VAL_180_PT_PT },
         { "190", OPTION_VAL_190_PT_PT },
         { "200", OPTION_VAL_200_PT_PT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_PT_PT,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_PT_PT },
         { "110", OPTION_VAL_110_PT_PT },
         { "120", OPTION_VAL_120_PT_PT },
         { "130", OPTION_VAL_130_PT_PT },
         { "140", OPTION_VAL_140_PT_PT },
         { "150", OPTION_VAL_150_O6_PT_PT },
         { "160", OPTION_VAL_160_PT_PT },
         { "170", OPTION_VAL_170_PT_PT },
         { "180", OPTION_VAL_180_PT_PT },
         { "190", OPTION_VAL_190_PT_PT },
         { "200", OPTION_VAL_200_PT_PT },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_PT_PT,
      BSNES_PPU_FAST_LABEL_CAT_PT_PT,
      BSNES_PPU_FAST_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_PT_PT,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_PT_PT,
      BSNES_PPU_DEINTERLACE_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_PT_PT,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_PT_PT,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_PT_PT,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_PT_PT,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_PT_PT,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_PT_PT,
      BSNES_DSP_FAST_LABEL_CAT_PT_PT,
      BSNES_DSP_FAST_INFO_0_PT_PT,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_PT_PT,
      BSNES_DSP_CUBIC_LABEL_CAT_PT_PT,
      BSNES_DSP_CUBIC_INFO_0_PT_PT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_PT_PT,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_PT_PT,
      BSNES_DSP_ECHO_SHADOW_INFO_0_PT_PT,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_PT_PT,
      BSNES_MODE7_SCALE_LABEL_CAT_PT_PT,
      BSNES_MODE7_SCALE_INFO_0_PT_PT,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_PT_PT  },
         { "2x", OPTION_VAL_2X_PT_PT  },
         { "3x", OPTION_VAL_3X_PT_PT  },
         { "4x", OPTION_VAL_4X_PT_PT  },
         { "5x", OPTION_VAL_5X_PT_PT },
         { "6x", OPTION_VAL_6X_PT_PT },
         { "7x", OPTION_VAL_7X_PT_PT },
         { "8x", OPTION_VAL_8X_PT_PT },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_PT_PT,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_PT_PT,
      BSNES_MODE7_PERSPECTIVE_INFO_0_PT_PT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_PT_PT,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_PT_PT,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_PT_PT,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_PT_PT,
      BSNES_MODE7_MOSAIC_LABEL_CAT_PT_PT,
      BSNES_MODE7_MOSAIC_INFO_0_PT_PT,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_PT_PT,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_PT_PT  },
         { "2",   OPTION_VAL_2_PT_PT },
         { "3",   OPTION_VAL_3_PT_PT },
         { "4",   OPTION_VAL_4_PT_PT },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_PT_PT,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_PT_PT,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_PT_PT,
      NULL,
      BSNES_HOTFIXES_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_PT_PT,
      NULL,
      BSNES_ENTROPY_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_PT_PT },
         { "High", OPTION_VAL_HIGH_PT_PT },
         { "None", OPTION_VAL_NONE_PT_PT },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_PT_PT,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_PT_PT,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_PT_PT,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_PT_PT,
      BSNES_CPU_OVERCLOCK_INFO_0_PT_PT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_PT  },
         { "20",  OPTION_VAL_20_PT_PT  },
         { "30",  OPTION_VAL_30_PT_PT  },
         { "40",  OPTION_VAL_40_PT_PT  },
         { "50",  OPTION_VAL_50_PT_PT  },
         { "60",  OPTION_VAL_60_PT_PT  },
         { "70",  OPTION_VAL_70_PT_PT  },
         { "80",  OPTION_VAL_80_PT_PT  },
         { "90",  OPTION_VAL_90_PT_PT  },
         { "100", OPTION_VAL_100_PT_PT },
         { "110", OPTION_VAL_110_PT_PT },
         { "120", OPTION_VAL_120_PT_PT },
         { "130", OPTION_VAL_130_PT_PT },
         { "140", OPTION_VAL_140_PT_PT },
         { "150", OPTION_VAL_150_PT_PT },
         { "160", OPTION_VAL_160_PT_PT },
         { "170", OPTION_VAL_170_PT_PT },
         { "180", OPTION_VAL_180_PT_PT },
         { "190", OPTION_VAL_190_PT_PT },
         { "200", OPTION_VAL_200_PT_PT },
         { "210", OPTION_VAL_210_PT_PT },
         { "220", OPTION_VAL_220_PT_PT },
         { "230", OPTION_VAL_230_PT_PT },
         { "240", OPTION_VAL_240_PT_PT },
         { "250", OPTION_VAL_250_PT_PT },
         { "260", OPTION_VAL_260_PT_PT },
         { "270", OPTION_VAL_270_PT_PT },
         { "280", OPTION_VAL_280_PT_PT },
         { "290", OPTION_VAL_290_PT_PT },
         { "300", OPTION_VAL_300_PT_PT },
         { "310", OPTION_VAL_310_PT_PT },
         { "320", OPTION_VAL_320_PT_PT },
         { "330", OPTION_VAL_330_PT_PT },
         { "340", OPTION_VAL_340_PT_PT },
         { "350", OPTION_VAL_350_PT_PT },
         { "360", OPTION_VAL_360_PT_PT },
         { "370", OPTION_VAL_370_PT_PT },
         { "380", OPTION_VAL_380_PT_PT },
         { "390", OPTION_VAL_390_PT_PT },
         { "400", OPTION_VAL_400_PT_PT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_PT_PT,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_PT_PT,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_PT_PT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_PT  },
         { "20",  OPTION_VAL_20_PT_PT  },
         { "30",  OPTION_VAL_30_PT_PT  },
         { "40",  OPTION_VAL_40_PT_PT  },
         { "50",  OPTION_VAL_50_PT_PT  },
         { "60",  OPTION_VAL_60_PT_PT  },
         { "70",  OPTION_VAL_70_PT_PT  },
         { "80",  OPTION_VAL_80_PT_PT  },
         { "90",  OPTION_VAL_90_PT_PT  },
         { "100", OPTION_VAL_100_PT_PT },
         { "110", OPTION_VAL_110_PT_PT },
         { "120", OPTION_VAL_120_PT_PT },
         { "130", OPTION_VAL_130_PT_PT },
         { "140", OPTION_VAL_140_PT_PT },
         { "150", OPTION_VAL_150_PT_PT },
         { "160", OPTION_VAL_160_PT_PT },
         { "170", OPTION_VAL_170_PT_PT },
         { "180", OPTION_VAL_180_PT_PT },
         { "190", OPTION_VAL_190_PT_PT },
         { "200", OPTION_VAL_200_PT_PT },
         { "210", OPTION_VAL_210_PT_PT },
         { "220", OPTION_VAL_220_PT_PT },
         { "230", OPTION_VAL_230_PT_PT },
         { "240", OPTION_VAL_240_PT_PT },
         { "250", OPTION_VAL_250_PT_PT },
         { "260", OPTION_VAL_260_PT_PT },
         { "270", OPTION_VAL_270_PT_PT },
         { "280", OPTION_VAL_280_PT_PT },
         { "290", OPTION_VAL_290_PT_PT },
         { "300", OPTION_VAL_300_PT_PT },
         { "310", OPTION_VAL_310_PT_PT },
         { "320", OPTION_VAL_320_PT_PT },
         { "330", OPTION_VAL_330_PT_PT },
         { "340", OPTION_VAL_340_PT_PT },
         { "350", OPTION_VAL_350_PT_PT },
         { "360", OPTION_VAL_360_PT_PT },
         { "370", OPTION_VAL_370_PT_PT },
         { "380", OPTION_VAL_380_PT_PT },
         { "390", OPTION_VAL_390_PT_PT },
         { "400", OPTION_VAL_400_PT_PT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_PT_PT,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_PT_PT,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_PT_PT,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_PT_PT  },
         { "20",  OPTION_VAL_20_PT_PT  },
         { "30",  OPTION_VAL_30_PT_PT  },
         { "40",  OPTION_VAL_40_PT_PT  },
         { "50",  OPTION_VAL_50_PT_PT  },
         { "60",  OPTION_VAL_60_PT_PT  },
         { "70",  OPTION_VAL_70_PT_PT  },
         { "80",  OPTION_VAL_80_PT_PT  },
         { "90",  OPTION_VAL_90_PT_PT  },
         { "100", OPTION_VAL_100_PT_PT },
         { "110", OPTION_VAL_110_PT_PT },
         { "120", OPTION_VAL_120_PT_PT },
         { "130", OPTION_VAL_130_PT_PT },
         { "140", OPTION_VAL_140_PT_PT },
         { "150", OPTION_VAL_150_PT_PT },
         { "160", OPTION_VAL_160_PT_PT },
         { "170", OPTION_VAL_170_PT_PT },
         { "180", OPTION_VAL_180_PT_PT },
         { "190", OPTION_VAL_190_PT_PT },
         { "200", OPTION_VAL_200_PT_PT },
         { "210", OPTION_VAL_210_PT_PT },
         { "220", OPTION_VAL_220_PT_PT },
         { "230", OPTION_VAL_230_PT_PT },
         { "240", OPTION_VAL_240_PT_PT },
         { "250", OPTION_VAL_250_PT_PT },
         { "260", OPTION_VAL_260_PT_PT },
         { "270", OPTION_VAL_270_PT_PT },
         { "280", OPTION_VAL_280_PT_PT },
         { "290", OPTION_VAL_290_PT_PT },
         { "300", OPTION_VAL_300_PT_PT },
         { "310", OPTION_VAL_310_PT_PT },
         { "320", OPTION_VAL_320_PT_PT },
         { "330", OPTION_VAL_330_PT_PT },
         { "340", OPTION_VAL_340_PT_PT },
         { "350", OPTION_VAL_350_PT_PT },
         { "360", OPTION_VAL_360_PT_PT },
         { "370", OPTION_VAL_370_PT_PT },
         { "380", OPTION_VAL_380_PT_PT },
         { "390", OPTION_VAL_390_PT_PT },
         { "400", OPTION_VAL_400_PT_PT },
         { "410", OPTION_VAL_410_PT_PT },
         { "420", OPTION_VAL_420_PT_PT },
         { "430", OPTION_VAL_430_PT_PT },
         { "440", OPTION_VAL_440_PT_PT },
         { "450", OPTION_VAL_450_PT_PT },
         { "460", OPTION_VAL_460_PT_PT },
         { "470", OPTION_VAL_470_PT_PT },
         { "480", OPTION_VAL_480_PT_PT },
         { "490", OPTION_VAL_490_PT_PT },
         { "500", OPTION_VAL_500_PT_PT },
         { "510", OPTION_VAL_510_PT_PT },
         { "520", OPTION_VAL_520_PT_PT },
         { "530", OPTION_VAL_530_PT_PT },
         { "540", OPTION_VAL_540_PT_PT },
         { "550", OPTION_VAL_550_PT_PT },
         { "560", OPTION_VAL_560_PT_PT },
         { "570", OPTION_VAL_570_PT_PT },
         { "580", OPTION_VAL_580_PT_PT },
         { "590", OPTION_VAL_590_PT_PT },
         { "600", OPTION_VAL_600_PT_PT },
         { "610", OPTION_VAL_610_PT_PT },
         { "620", OPTION_VAL_620_PT_PT },
         { "630", OPTION_VAL_630_PT_PT },
         { "640", OPTION_VAL_640_PT_PT },
         { "650", OPTION_VAL_650_PT_PT },
         { "660", OPTION_VAL_660_PT_PT },
         { "670", OPTION_VAL_670_PT_PT },
         { "680", OPTION_VAL_680_PT_PT },
         { "690", OPTION_VAL_690_PT_PT },
         { "700", OPTION_VAL_700_PT_PT },
         { "710", OPTION_VAL_710_PT_PT },
         { "720", OPTION_VAL_720_PT_PT },
         { "730", OPTION_VAL_730_PT_PT },
         { "740", OPTION_VAL_740_PT_PT },
         { "750", OPTION_VAL_750_PT_PT },
         { "760", OPTION_VAL_760_PT_PT },
         { "770", OPTION_VAL_770_PT_PT },
         { "780", OPTION_VAL_780_PT_PT },
         { "790", OPTION_VAL_790_PT_PT },
         { "800", OPTION_VAL_800_PT_PT },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_PT_PT,
      NULL,
      BSNES_SGB_BIOS_INFO_0_PT_PT,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_PT_PT   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_PT_PT },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_PT_PT,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_PT_PT,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_PT_PT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_PT_PT,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_PT_PT,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_PT_PT,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_pt_pt = {
   option_cats_pt_pt,
   option_defs_pt_pt
};

/* RETRO_LANGUAGE_RU */

#define CATEGORY_VIDEO_LABEL_RU "Видео"
#define CATEGORY_VIDEO_INFO_0_RU "Настройки вывода изображения."
#define CATEGORY_AUDIO_LABEL_RU "Аудио"
#define CATEGORY_AUDIO_INFO_0_RU "Настройки вывода звука."
#define CATEGORY_MODE7_LABEL_RU NULL
#define CATEGORY_MODE7_INFO_0_RU "Настройки эмуляции графического режима Mode 7."
#define CATEGORY_HACK_LABEL_RU "Улучшения и хаки эмуляции"
#define CATEGORY_HACK_INFO_0_RU "Включение исправлений, улучшений и хаков эмуляции."
#define CATEGORY_OVERCLOCK_LABEL_RU "Разгон/замедление"
#define CATEGORY_OVERCLOCK_INFO_0_RU "Настройка скорости эмулируемого оборудования."
#define CATEGORY_SGB_LABEL_RU NULL
#define CATEGORY_SGB_INFO_0_RU "Настройки эмуляции Super Game Boy."
#define CATEGORY_LIGHTGUN_LABEL_RU "Световой пистолет"
#define CATEGORY_LIGHTGUN_INFO_0_RU "Настройки (сенсорного) светового пистолета."
#define BSNES_ASPECT_RATIO_LABEL_RU "Предпочтительное соотношение сторон"
#define BSNES_ASPECT_RATIO_INFO_0_RU "Предпочтительное соотношение сторон. Учитывается, только если для соотношения сторон RetroArch в настройках видео задано значение 'По выбору ядра'."
#define OPTION_VAL_AUTO_RU "Авто"
#define OPTION_VAL_1_1_RU "1:1 PAR (пиксель в пиксель)"
#define OPTION_VAL_4_3_RU NULL
#define OPTION_VAL_NTSC_RU NULL
#define OPTION_VAL_PAL_RU NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_RU "Кадрирование по вертикали"
#define BSNES_PPU_OVERSCAN_V_INFO_0_RU "Убирает N строк сверху и снизу экрана для имитации телевизионной рамки эпохи SNES."
#define OPTION_VAL_0_RU "0 строк"
#define OPTION_VAL_8_RU "8 строк"
#define OPTION_VAL_12_RU "12 строк"
#define OPTION_VAL_16_RU "16 строк"
#define BSNES_BLUR_EMULATION_LABEL_RU "Эмуляция размытия"
#define BSNES_BLUR_EMULATION_INFO_0_RU "Имитирует ограниченное по горизонтали разрешение стандартных ТВ, размывая горизонтально примыкающие пиксели. Требуется для эмуляции эффекта прозрачности в некоторых играх."
#define BSNES_VIDEO_FILTER_LABEL_RU "Фильтр"
#define BSNES_VIDEO_FILTER_INFO_0_RU "Выбор между отсутствием фильтрации и NTSC-фильтрами Blargg'а, имитирующими видеосигналы по RF, композиту, S-Video или RGB."
#define OPTION_VAL_NONE_RU "Нет"
#define OPTION_VAL_NTSC_RF_RU NULL
#define OPTION_VAL_NTSC_COMPOSITE_RU "NTSC (композитный)"
#define OPTION_VAL_NTSC_S_VIDEO_RU NULL
#define OPTION_VAL_NTSC_RGB_RU NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_RU "Регулировка цвета - яркость"
#define BSNES_VIDEO_LUMINANCE_INFO_0_RU "Подстройка яркости"
#define OPTION_VAL_0_O4_RU NULL
#define OPTION_VAL_10_RU NULL
#define OPTION_VAL_20_RU NULL
#define OPTION_VAL_30_RU NULL
#define OPTION_VAL_40_RU NULL
#define OPTION_VAL_50_RU NULL
#define OPTION_VAL_60_RU NULL
#define OPTION_VAL_70_RU NULL
#define OPTION_VAL_80_RU NULL
#define OPTION_VAL_90_RU NULL
#define OPTION_VAL_100_RU "100% (по умолчанию)"
#define BSNES_VIDEO_SATURATION_LABEL_RU "Регулировка цвета - насыщенность"
#define BSNES_VIDEO_SATURATION_INFO_0_RU "Подстройка насыщенности"
#define OPTION_VAL_110_RU NULL
#define OPTION_VAL_120_RU NULL
#define OPTION_VAL_130_RU NULL
#define OPTION_VAL_140_RU NULL
#define OPTION_VAL_150_RU NULL
#define OPTION_VAL_160_RU NULL
#define OPTION_VAL_170_RU NULL
#define OPTION_VAL_180_RU NULL
#define OPTION_VAL_190_RU NULL
#define OPTION_VAL_200_RU NULL
#define BSNES_VIDEO_GAMMA_LABEL_RU "Регулировка цвета - гамма"
#define BSNES_VIDEO_GAMMA_INFO_0_RU "Подстройка гаммы"
#define OPTION_VAL_100_O6_RU NULL
#define OPTION_VAL_150_O6_RU "150% (по умолчанию)"
#define BSNES_PPU_FAST_LABEL_RU "PPU (Видео) - Быстрый режим"
#define BSNES_PPU_FAST_LABEL_CAT_RU "PPU - Быстрый режим"
#define BSNES_PPU_FAST_INFO_0_RU "Ускоряет эмуляцию PPU, но незначительно снижает точность. Рекомендуется оставлять опцию включенной. Требуется для работы настроек 'Деинтерлейсинг', 'Без ограничения спрайтов' и 'HD Mode 7'."
#define BSNES_PPU_DEINTERLACE_LABEL_RU "PPU (Видео) - Деинтерлейсинг"
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_RU "PPU - Деинтерлейсинг"
#define BSNES_PPU_DEINTERLACE_INFO_0_RU "Убирает чересстрочность в играх, запуская рендеринг в 480p. Рекомендуется оставлять вкл., т.к. практически не влияет на производительность."
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_RU "PPU (Видео) - Без ограничения спрайтов"
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_RU "PPU - Без ограничения спрайтов"
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_RU "Убирает любые ограничения на количество одновременно отображаемых на экране спрайтов. Может вызывать ошибки в некоторых играх."
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_RU "PPU (Видео) - Без блокировки VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_RU "PPU - Без блокировки VRAM"
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_RU "Имитация ошибки старых версий ZSNES и Snes9x при которой не эмулировалась блокировка VRAM. Данная ошибка требуется для правильной отрисовки графики в некоторых ранних ромхаках. Включение настройки крайне ухудшает точность и снижает скорость PPU, поэтому это рекомендуется делать только при запуске игр, несовместимых с данным ядром."
#define BSNES_DSP_FAST_LABEL_RU "DSP (Аудио) - Быстрый режим"
#define BSNES_DSP_FAST_LABEL_CAT_RU "DSP - Быстрый режим"
#define BSNES_DSP_FAST_INFO_0_RU "Включает ускорение эмуляции DSP, но незначительно снижает точность. Рекомендуется оставлять настройку включенной."
#define BSNES_DSP_CUBIC_LABEL_RU "DSP (Аудио) - Кубическая интерполяция"
#define BSNES_DSP_CUBIC_LABEL_CAT_RU "DSP - Кубическая интерполяция"
#define BSNES_DSP_CUBIC_INFO_0_RU "Применять к звуку кубическую интерполяцию для более выраженных верхних частот."
#define BSNES_DSP_ECHO_SHADOW_LABEL_RU "DSP (Аудио) - Echo Shadow RAM"
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_RU NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_RU "Эмулирует ошибку ZSNES при которой echo RAM обрабатывалась независимо от APU RAM. Необходимо для правильной работы многих ранних ромхаков Super Mario World. Настройка очень сильно снижает точность и должна включаться только по необходимости."
#define BSNES_MODE7_SCALE_LABEL_RU "HD Mode 7 - Масштаб"
#define BSNES_MODE7_SCALE_LABEL_CAT_RU "Масштаб"
#define BSNES_MODE7_SCALE_INFO_0_RU "Повышает горизонтальное и вертикальное разрешение графики Mode 7 в играх с поддержкой данного режима."
#define OPTION_VAL_1X_RU NULL
#define OPTION_VAL_2X_RU NULL
#define OPTION_VAL_3X_RU NULL
#define OPTION_VAL_4X_RU NULL
#define OPTION_VAL_5X_RU NULL
#define OPTION_VAL_6X_RU NULL
#define OPTION_VAL_7X_RU NULL
#define OPTION_VAL_8X_RU NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_RU "HD Mode 7 - Коррекция перспективы"
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_RU "Коррекция перспективы"
#define BSNES_MODE7_PERSPECTIVE_INFO_0_RU "Исправляет перспективу в играх, использующих Mode 7 путём обхода ограничений при операциях SNES с целыми числами."
#define BSNES_MODE7_SUPERSAMPLE_LABEL_RU "HD Mode 7 - Суперсэмплинг"
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_RU "Суперсэмплинг"
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_RU "Включает суперсэмплинг графики Mode 7 в играх с поддержкой данного режима. В комбинации с изменением масштаба Mode 7 обеспечивает эффект, схожий со сглаживанием."
#define BSNES_MODE7_MOSAIC_LABEL_RU "HD Mode 7 - HD->SD Мозаика"
#define BSNES_MODE7_MOSAIC_LABEL_CAT_RU "HD->SD Мозаика"
#define BSNES_MODE7_MOSAIC_INFO_0_RU "Отображать эффект мозаики даже при апскейлинге графики в Mode 7."
#define BSNES_RUN_AHEAD_FRAMES_LABEL_RU "Встроенное забегание"
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_RU "Эмуляция системы с опережением и последующим откатом для уменьшения задержки ввода. Высокие системные требования."
#define OPTION_VAL_1_RU "1 кадр"
#define OPTION_VAL_2_RU "2 кадра"
#define OPTION_VAL_3_RU "3 кадра"
#define OPTION_VAL_4_RU "4 кадра"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_RU "Сопроцессор - Быстрый режим"
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_RU "Включает ускорение эмуляции сопроцессоров, но незначительно снижает точность. Рекомендуется оставить настройку включенной."
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_RU "Сопроцессоры - Предпочитать HLE"
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_RU "При включении настройки используется менее точная HLE-эмуляция. Если отключено, HLE будет использоваться только при отсутствии LLE-прошивки."
#define BSNES_HOTFIXES_LABEL_RU "Исправления"
#define BSNES_HOTFIXES_INFO_0_RU "Даже коммерческое программное обеспечение может иметь ошибки. Данная опция исправляет некоторые критические баги, имеющие место на реальном оборудовании."
#define BSNES_ENTROPY_LABEL_RU "Энтропия (рандомизация)"
#define BSNES_ENTROPY_INFO_0_RU "Степень рандомизации памяти и регистров. Если откл., при запуске память и регистры принимают постоянные значения. Низкая рандомизация наиболее точно воспроизводит поведение реальной системы. Высокая рандомизирует максимально."
#define OPTION_VAL_LOW_RU "Низкая"
#define OPTION_VAL_HIGH_RU "Высокая"
#define BSNES_CPU_FASTMATH_LABEL_RU "Ускорение вычислений CPU"
#define BSNES_CPU_FASTMATH_INFO_0_RU "Обеспечивает немедленные результаты вычислений. Операции сложения и деления на реальной SNES занимают определённое время. Устаревшие эмуляторы не имитировали эти задержки и поэтому ранние ромхаки не ждут завершения мат. операций и требуют включения данной настройки."
#define BSNES_CPU_OVERCLOCK_LABEL_RU "Разгон - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_RU NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_RU "Разгон или замедление CPU. Установка значения выше 100% позволяет снизить время загрузок и устранить замедления в играх. Используйте с осторожностью из-за возможных ошибок и сбоев."
#define OPTION_VAL_210_RU NULL
#define OPTION_VAL_220_RU NULL
#define OPTION_VAL_230_RU NULL
#define OPTION_VAL_240_RU NULL
#define OPTION_VAL_250_RU NULL
#define OPTION_VAL_260_RU NULL
#define OPTION_VAL_270_RU NULL
#define OPTION_VAL_280_RU NULL
#define OPTION_VAL_290_RU NULL
#define OPTION_VAL_300_RU NULL
#define OPTION_VAL_310_RU NULL
#define OPTION_VAL_320_RU NULL
#define OPTION_VAL_330_RU NULL
#define OPTION_VAL_340_RU NULL
#define OPTION_VAL_350_RU NULL
#define OPTION_VAL_360_RU NULL
#define OPTION_VAL_370_RU NULL
#define OPTION_VAL_380_RU NULL
#define OPTION_VAL_390_RU NULL
#define OPTION_VAL_400_RU NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_RU "Разгон - Сопроцессор SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_RU "Сопроцессор SA-1"
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_RU "Разгон или замедление чипа Super Accelerator (SA-1). Установка значения выше 100% улучшает производительность в играх с поддержкой чипа SA-1. Используйте с осторожностью из-за возможных ошибок и сбоев."
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_RU "Разгон - Сопроцессор SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_RU "Сопроцессор SuperFX"
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_RU "Разгон или замедление сопроцессора SuperFX. Установка значения выше 100% улучшает производительность в играх с поддержкой SuperFX. Используйте с осторожностью из-за возможных сбоев и проблем с играми."
#define OPTION_VAL_410_RU NULL
#define OPTION_VAL_420_RU NULL
#define OPTION_VAL_430_RU NULL
#define OPTION_VAL_440_RU NULL
#define OPTION_VAL_450_RU NULL
#define OPTION_VAL_460_RU NULL
#define OPTION_VAL_470_RU NULL
#define OPTION_VAL_480_RU NULL
#define OPTION_VAL_490_RU NULL
#define OPTION_VAL_500_RU NULL
#define OPTION_VAL_510_RU NULL
#define OPTION_VAL_520_RU NULL
#define OPTION_VAL_530_RU NULL
#define OPTION_VAL_540_RU NULL
#define OPTION_VAL_550_RU NULL
#define OPTION_VAL_560_RU NULL
#define OPTION_VAL_570_RU NULL
#define OPTION_VAL_580_RU NULL
#define OPTION_VAL_590_RU NULL
#define OPTION_VAL_600_RU NULL
#define OPTION_VAL_610_RU NULL
#define OPTION_VAL_620_RU NULL
#define OPTION_VAL_630_RU NULL
#define OPTION_VAL_640_RU NULL
#define OPTION_VAL_650_RU NULL
#define OPTION_VAL_660_RU NULL
#define OPTION_VAL_670_RU NULL
#define OPTION_VAL_680_RU NULL
#define OPTION_VAL_690_RU NULL
#define OPTION_VAL_700_RU NULL
#define OPTION_VAL_710_RU NULL
#define OPTION_VAL_720_RU NULL
#define OPTION_VAL_730_RU NULL
#define OPTION_VAL_740_RU NULL
#define OPTION_VAL_750_RU NULL
#define OPTION_VAL_760_RU NULL
#define OPTION_VAL_770_RU NULL
#define OPTION_VAL_780_RU NULL
#define OPTION_VAL_790_RU NULL
#define OPTION_VAL_800_RU NULL
#define BSNES_SGB_BIOS_LABEL_RU "Выбор BIOS Super Game Boy (требуется перезапуск)"
#define BSNES_SGB_BIOS_INFO_0_RU "Установка BIOS, используемого для совместимых игр Super Game Boy."
#define OPTION_VAL_SGB1_SFC_RU NULL
#define OPTION_VAL_SGB2_SFC_RU NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_RU "Скрывать рамку SGB"
#define BSNES_HIDE_SGB_BORDER_INFO_0_RU "Скрывать рамку при запуске игр Super Game Boy."
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_RU "Сенсорный световой пистолет"
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_RU "Вкл. эмуляцию Super Scope с помощью сенсорного экрана устройства."
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_RU "Поменять кнопки курков Super Scope"
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_RU "Меняет местами кнопки курка и указателя Super Scope для сенсорного светового пистолета."

struct retro_core_option_v2_category option_cats_ru[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_RU,
      CATEGORY_VIDEO_INFO_0_RU
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_RU,
      CATEGORY_AUDIO_INFO_0_RU
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_RU,
      CATEGORY_MODE7_INFO_0_RU
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_RU,
      CATEGORY_HACK_INFO_0_RU
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_RU,
      CATEGORY_OVERCLOCK_INFO_0_RU
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_RU,
      CATEGORY_SGB_INFO_0_RU
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_RU,
      CATEGORY_LIGHTGUN_INFO_0_RU
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ru[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_RU,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_RU,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_RU },
         { "1:1",  OPTION_VAL_1_1_RU },
         { "4:3",  OPTION_VAL_4_3_RU },
         { "NTSC", OPTION_VAL_NTSC_RU },
         { "PAL",  OPTION_VAL_PAL_RU },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_RU,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_RU,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_RU },
         { "8",  OPTION_VAL_8_RU },
         { "12", OPTION_VAL_12_RU },
         { "16", OPTION_VAL_16_RU },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_RU,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_RU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_RU,
      BSNES_VIDEO_FILTER_LABEL_RU,
      BSNES_VIDEO_FILTER_INFO_0_RU,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_RU },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_RU },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_RU },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_RU },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_RU },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_RU,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_RU,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_RU },
         { "10", OPTION_VAL_10_RU },
         { "20", OPTION_VAL_20_RU },
         { "30", OPTION_VAL_30_RU },
         { "40", OPTION_VAL_40_RU },
         { "50", OPTION_VAL_50_RU },
         { "60", OPTION_VAL_60_RU },
         { "70", OPTION_VAL_70_RU },
         { "80", OPTION_VAL_80_RU },
         { "90", OPTION_VAL_90_RU },
         { "100", OPTION_VAL_100_RU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_RU,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_RU,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_RU },
         { "10", OPTION_VAL_10_RU },
         { "20", OPTION_VAL_20_RU },
         { "30", OPTION_VAL_30_RU },
         { "40", OPTION_VAL_40_RU },
         { "50", OPTION_VAL_50_RU },
         { "60", OPTION_VAL_60_RU },
         { "70", OPTION_VAL_70_RU },
         { "80", OPTION_VAL_80_RU },
         { "90", OPTION_VAL_90_RU },
         { "100", OPTION_VAL_100_RU },
         { "110", OPTION_VAL_110_RU },
         { "120", OPTION_VAL_120_RU },
         { "130", OPTION_VAL_130_RU },
         { "140", OPTION_VAL_140_RU },
         { "150", OPTION_VAL_150_RU },
         { "160", OPTION_VAL_160_RU },
         { "170", OPTION_VAL_170_RU },
         { "180", OPTION_VAL_180_RU },
         { "190", OPTION_VAL_190_RU },
         { "200", OPTION_VAL_200_RU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_RU,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_RU,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_RU },
         { "110", OPTION_VAL_110_RU },
         { "120", OPTION_VAL_120_RU },
         { "130", OPTION_VAL_130_RU },
         { "140", OPTION_VAL_140_RU },
         { "150", OPTION_VAL_150_O6_RU },
         { "160", OPTION_VAL_160_RU },
         { "170", OPTION_VAL_170_RU },
         { "180", OPTION_VAL_180_RU },
         { "190", OPTION_VAL_190_RU },
         { "200", OPTION_VAL_200_RU },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_RU,
      BSNES_PPU_FAST_LABEL_CAT_RU,
      BSNES_PPU_FAST_INFO_0_RU,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_RU,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_RU,
      BSNES_PPU_DEINTERLACE_INFO_0_RU,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_RU,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_RU,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_RU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_RU,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_RU,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_RU,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_RU,
      BSNES_DSP_FAST_LABEL_CAT_RU,
      BSNES_DSP_FAST_INFO_0_RU,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_RU,
      BSNES_DSP_CUBIC_LABEL_CAT_RU,
      BSNES_DSP_CUBIC_INFO_0_RU,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_RU,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_RU,
      BSNES_DSP_ECHO_SHADOW_INFO_0_RU,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_RU,
      BSNES_MODE7_SCALE_LABEL_CAT_RU,
      BSNES_MODE7_SCALE_INFO_0_RU,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_RU  },
         { "2x", OPTION_VAL_2X_RU  },
         { "3x", OPTION_VAL_3X_RU  },
         { "4x", OPTION_VAL_4X_RU  },
         { "5x", OPTION_VAL_5X_RU },
         { "6x", OPTION_VAL_6X_RU },
         { "7x", OPTION_VAL_7X_RU },
         { "8x", OPTION_VAL_8X_RU },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_RU,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_RU,
      BSNES_MODE7_PERSPECTIVE_INFO_0_RU,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_RU,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_RU,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_RU,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_RU,
      BSNES_MODE7_MOSAIC_LABEL_CAT_RU,
      BSNES_MODE7_MOSAIC_INFO_0_RU,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_RU,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_RU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_RU  },
         { "2",   OPTION_VAL_2_RU },
         { "3",   OPTION_VAL_3_RU },
         { "4",   OPTION_VAL_4_RU },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_RU,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_RU,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_RU,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_RU,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_RU,
      NULL,
      BSNES_HOTFIXES_INFO_0_RU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_RU,
      NULL,
      BSNES_ENTROPY_INFO_0_RU,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_RU },
         { "High", OPTION_VAL_HIGH_RU },
         { "None", OPTION_VAL_NONE_RU },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_RU,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_RU,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_RU,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_RU,
      BSNES_CPU_OVERCLOCK_INFO_0_RU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_RU  },
         { "20",  OPTION_VAL_20_RU  },
         { "30",  OPTION_VAL_30_RU  },
         { "40",  OPTION_VAL_40_RU  },
         { "50",  OPTION_VAL_50_RU  },
         { "60",  OPTION_VAL_60_RU  },
         { "70",  OPTION_VAL_70_RU  },
         { "80",  OPTION_VAL_80_RU  },
         { "90",  OPTION_VAL_90_RU  },
         { "100", OPTION_VAL_100_RU },
         { "110", OPTION_VAL_110_RU },
         { "120", OPTION_VAL_120_RU },
         { "130", OPTION_VAL_130_RU },
         { "140", OPTION_VAL_140_RU },
         { "150", OPTION_VAL_150_RU },
         { "160", OPTION_VAL_160_RU },
         { "170", OPTION_VAL_170_RU },
         { "180", OPTION_VAL_180_RU },
         { "190", OPTION_VAL_190_RU },
         { "200", OPTION_VAL_200_RU },
         { "210", OPTION_VAL_210_RU },
         { "220", OPTION_VAL_220_RU },
         { "230", OPTION_VAL_230_RU },
         { "240", OPTION_VAL_240_RU },
         { "250", OPTION_VAL_250_RU },
         { "260", OPTION_VAL_260_RU },
         { "270", OPTION_VAL_270_RU },
         { "280", OPTION_VAL_280_RU },
         { "290", OPTION_VAL_290_RU },
         { "300", OPTION_VAL_300_RU },
         { "310", OPTION_VAL_310_RU },
         { "320", OPTION_VAL_320_RU },
         { "330", OPTION_VAL_330_RU },
         { "340", OPTION_VAL_340_RU },
         { "350", OPTION_VAL_350_RU },
         { "360", OPTION_VAL_360_RU },
         { "370", OPTION_VAL_370_RU },
         { "380", OPTION_VAL_380_RU },
         { "390", OPTION_VAL_390_RU },
         { "400", OPTION_VAL_400_RU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_RU,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_RU,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_RU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_RU  },
         { "20",  OPTION_VAL_20_RU  },
         { "30",  OPTION_VAL_30_RU  },
         { "40",  OPTION_VAL_40_RU  },
         { "50",  OPTION_VAL_50_RU  },
         { "60",  OPTION_VAL_60_RU  },
         { "70",  OPTION_VAL_70_RU  },
         { "80",  OPTION_VAL_80_RU  },
         { "90",  OPTION_VAL_90_RU  },
         { "100", OPTION_VAL_100_RU },
         { "110", OPTION_VAL_110_RU },
         { "120", OPTION_VAL_120_RU },
         { "130", OPTION_VAL_130_RU },
         { "140", OPTION_VAL_140_RU },
         { "150", OPTION_VAL_150_RU },
         { "160", OPTION_VAL_160_RU },
         { "170", OPTION_VAL_170_RU },
         { "180", OPTION_VAL_180_RU },
         { "190", OPTION_VAL_190_RU },
         { "200", OPTION_VAL_200_RU },
         { "210", OPTION_VAL_210_RU },
         { "220", OPTION_VAL_220_RU },
         { "230", OPTION_VAL_230_RU },
         { "240", OPTION_VAL_240_RU },
         { "250", OPTION_VAL_250_RU },
         { "260", OPTION_VAL_260_RU },
         { "270", OPTION_VAL_270_RU },
         { "280", OPTION_VAL_280_RU },
         { "290", OPTION_VAL_290_RU },
         { "300", OPTION_VAL_300_RU },
         { "310", OPTION_VAL_310_RU },
         { "320", OPTION_VAL_320_RU },
         { "330", OPTION_VAL_330_RU },
         { "340", OPTION_VAL_340_RU },
         { "350", OPTION_VAL_350_RU },
         { "360", OPTION_VAL_360_RU },
         { "370", OPTION_VAL_370_RU },
         { "380", OPTION_VAL_380_RU },
         { "390", OPTION_VAL_390_RU },
         { "400", OPTION_VAL_400_RU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_RU,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_RU,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_RU,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_RU  },
         { "20",  OPTION_VAL_20_RU  },
         { "30",  OPTION_VAL_30_RU  },
         { "40",  OPTION_VAL_40_RU  },
         { "50",  OPTION_VAL_50_RU  },
         { "60",  OPTION_VAL_60_RU  },
         { "70",  OPTION_VAL_70_RU  },
         { "80",  OPTION_VAL_80_RU  },
         { "90",  OPTION_VAL_90_RU  },
         { "100", OPTION_VAL_100_RU },
         { "110", OPTION_VAL_110_RU },
         { "120", OPTION_VAL_120_RU },
         { "130", OPTION_VAL_130_RU },
         { "140", OPTION_VAL_140_RU },
         { "150", OPTION_VAL_150_RU },
         { "160", OPTION_VAL_160_RU },
         { "170", OPTION_VAL_170_RU },
         { "180", OPTION_VAL_180_RU },
         { "190", OPTION_VAL_190_RU },
         { "200", OPTION_VAL_200_RU },
         { "210", OPTION_VAL_210_RU },
         { "220", OPTION_VAL_220_RU },
         { "230", OPTION_VAL_230_RU },
         { "240", OPTION_VAL_240_RU },
         { "250", OPTION_VAL_250_RU },
         { "260", OPTION_VAL_260_RU },
         { "270", OPTION_VAL_270_RU },
         { "280", OPTION_VAL_280_RU },
         { "290", OPTION_VAL_290_RU },
         { "300", OPTION_VAL_300_RU },
         { "310", OPTION_VAL_310_RU },
         { "320", OPTION_VAL_320_RU },
         { "330", OPTION_VAL_330_RU },
         { "340", OPTION_VAL_340_RU },
         { "350", OPTION_VAL_350_RU },
         { "360", OPTION_VAL_360_RU },
         { "370", OPTION_VAL_370_RU },
         { "380", OPTION_VAL_380_RU },
         { "390", OPTION_VAL_390_RU },
         { "400", OPTION_VAL_400_RU },
         { "410", OPTION_VAL_410_RU },
         { "420", OPTION_VAL_420_RU },
         { "430", OPTION_VAL_430_RU },
         { "440", OPTION_VAL_440_RU },
         { "450", OPTION_VAL_450_RU },
         { "460", OPTION_VAL_460_RU },
         { "470", OPTION_VAL_470_RU },
         { "480", OPTION_VAL_480_RU },
         { "490", OPTION_VAL_490_RU },
         { "500", OPTION_VAL_500_RU },
         { "510", OPTION_VAL_510_RU },
         { "520", OPTION_VAL_520_RU },
         { "530", OPTION_VAL_530_RU },
         { "540", OPTION_VAL_540_RU },
         { "550", OPTION_VAL_550_RU },
         { "560", OPTION_VAL_560_RU },
         { "570", OPTION_VAL_570_RU },
         { "580", OPTION_VAL_580_RU },
         { "590", OPTION_VAL_590_RU },
         { "600", OPTION_VAL_600_RU },
         { "610", OPTION_VAL_610_RU },
         { "620", OPTION_VAL_620_RU },
         { "630", OPTION_VAL_630_RU },
         { "640", OPTION_VAL_640_RU },
         { "650", OPTION_VAL_650_RU },
         { "660", OPTION_VAL_660_RU },
         { "670", OPTION_VAL_670_RU },
         { "680", OPTION_VAL_680_RU },
         { "690", OPTION_VAL_690_RU },
         { "700", OPTION_VAL_700_RU },
         { "710", OPTION_VAL_710_RU },
         { "720", OPTION_VAL_720_RU },
         { "730", OPTION_VAL_730_RU },
         { "740", OPTION_VAL_740_RU },
         { "750", OPTION_VAL_750_RU },
         { "760", OPTION_VAL_760_RU },
         { "770", OPTION_VAL_770_RU },
         { "780", OPTION_VAL_780_RU },
         { "790", OPTION_VAL_790_RU },
         { "800", OPTION_VAL_800_RU },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_RU,
      NULL,
      BSNES_SGB_BIOS_INFO_0_RU,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_RU   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_RU },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_RU,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_RU,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_RU,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_RU,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_RU,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_RU,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ru = {
   option_cats_ru,
   option_defs_ru
};

/* RETRO_LANGUAGE_SK */

#define CATEGORY_VIDEO_LABEL_SK NULL
#define CATEGORY_VIDEO_INFO_0_SK "Zmena nastavení video výstupu."
#define CATEGORY_AUDIO_LABEL_SK "Zvuk"
#define CATEGORY_AUDIO_INFO_0_SK "Zmena nastavení audio výstupu."
#define CATEGORY_MODE7_LABEL_SK NULL
#define CATEGORY_MODE7_INFO_0_SK NULL
#define CATEGORY_HACK_LABEL_SK NULL
#define CATEGORY_HACK_INFO_0_SK NULL
#define CATEGORY_OVERCLOCK_LABEL_SK NULL
#define CATEGORY_OVERCLOCK_INFO_0_SK NULL
#define CATEGORY_SGB_LABEL_SK NULL
#define CATEGORY_SGB_INFO_0_SK NULL
#define CATEGORY_LIGHTGUN_LABEL_SK "Svetelná pištoľ"
#define CATEGORY_LIGHTGUN_INFO_0_SK NULL
#define BSNES_ASPECT_RATIO_LABEL_SK NULL
#define BSNES_ASPECT_RATIO_INFO_0_SK NULL
#define OPTION_VAL_AUTO_SK NULL
#define OPTION_VAL_1_1_SK NULL
#define OPTION_VAL_4_3_SK NULL
#define OPTION_VAL_NTSC_SK NULL
#define OPTION_VAL_PAL_SK NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_SK NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_SK NULL
#define OPTION_VAL_0_SK NULL
#define OPTION_VAL_8_SK NULL
#define OPTION_VAL_12_SK NULL
#define OPTION_VAL_16_SK NULL
#define BSNES_BLUR_EMULATION_LABEL_SK NULL
#define BSNES_BLUR_EMULATION_INFO_0_SK NULL
#define BSNES_VIDEO_FILTER_LABEL_SK "Filtrovať"
#define BSNES_VIDEO_FILTER_INFO_0_SK NULL
#define OPTION_VAL_NONE_SK "Žiadne"
#define OPTION_VAL_NTSC_RF_SK NULL
#define OPTION_VAL_NTSC_COMPOSITE_SK "NTSC (kompozitné)"
#define OPTION_VAL_NTSC_S_VIDEO_SK NULL
#define OPTION_VAL_NTSC_RGB_SK NULL
#define BSNES_VIDEO_LUMINANCE_LABEL_SK NULL
#define BSNES_VIDEO_LUMINANCE_INFO_0_SK NULL
#define OPTION_VAL_0_O4_SK NULL
#define OPTION_VAL_10_SK NULL
#define OPTION_VAL_20_SK NULL
#define OPTION_VAL_30_SK NULL
#define OPTION_VAL_40_SK NULL
#define OPTION_VAL_50_SK NULL
#define OPTION_VAL_60_SK NULL
#define OPTION_VAL_70_SK NULL
#define OPTION_VAL_80_SK NULL
#define OPTION_VAL_90_SK NULL
#define OPTION_VAL_100_SK "100% (predvolené)"
#define BSNES_VIDEO_SATURATION_LABEL_SK NULL
#define BSNES_VIDEO_SATURATION_INFO_0_SK NULL
#define OPTION_VAL_110_SK NULL
#define OPTION_VAL_120_SK NULL
#define OPTION_VAL_130_SK NULL
#define OPTION_VAL_140_SK NULL
#define OPTION_VAL_150_SK NULL
#define OPTION_VAL_160_SK NULL
#define OPTION_VAL_170_SK NULL
#define OPTION_VAL_180_SK NULL
#define OPTION_VAL_190_SK NULL
#define OPTION_VAL_200_SK NULL
#define BSNES_VIDEO_GAMMA_LABEL_SK NULL
#define BSNES_VIDEO_GAMMA_INFO_0_SK NULL
#define OPTION_VAL_100_O6_SK NULL
#define OPTION_VAL_150_O6_SK NULL
#define BSNES_PPU_FAST_LABEL_SK NULL
#define BSNES_PPU_FAST_LABEL_CAT_SK NULL
#define BSNES_PPU_FAST_INFO_0_SK NULL
#define BSNES_PPU_DEINTERLACE_LABEL_SK NULL
#define BSNES_PPU_DEINTERLACE_LABEL_CAT_SK NULL
#define BSNES_PPU_DEINTERLACE_INFO_0_SK NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_SK NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_SK NULL
#define BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_SK NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_SK NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_SK NULL
#define BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_SK NULL
#define BSNES_DSP_FAST_LABEL_SK NULL
#define BSNES_DSP_FAST_LABEL_CAT_SK NULL
#define BSNES_DSP_FAST_INFO_0_SK NULL
#define BSNES_DSP_CUBIC_LABEL_SK NULL
#define BSNES_DSP_CUBIC_LABEL_CAT_SK NULL
#define BSNES_DSP_CUBIC_INFO_0_SK NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_SK NULL
#define BSNES_DSP_ECHO_SHADOW_LABEL_CAT_SK NULL
#define BSNES_DSP_ECHO_SHADOW_INFO_0_SK NULL
#define BSNES_MODE7_SCALE_LABEL_SK NULL
#define BSNES_MODE7_SCALE_LABEL_CAT_SK "Škálovať"
#define BSNES_MODE7_SCALE_INFO_0_SK NULL
#define OPTION_VAL_1X_SK NULL
#define OPTION_VAL_2X_SK NULL
#define OPTION_VAL_3X_SK NULL
#define OPTION_VAL_4X_SK NULL
#define OPTION_VAL_5X_SK NULL
#define OPTION_VAL_6X_SK NULL
#define OPTION_VAL_7X_SK NULL
#define OPTION_VAL_8X_SK NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_SK NULL
#define BSNES_MODE7_PERSPECTIVE_LABEL_CAT_SK NULL
#define BSNES_MODE7_PERSPECTIVE_INFO_0_SK NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_SK NULL
#define BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_SK NULL
#define BSNES_MODE7_SUPERSAMPLE_INFO_0_SK NULL
#define BSNES_MODE7_MOSAIC_LABEL_SK NULL
#define BSNES_MODE7_MOSAIC_LABEL_CAT_SK NULL
#define BSNES_MODE7_MOSAIC_INFO_0_SK NULL
#define BSNES_RUN_AHEAD_FRAMES_LABEL_SK NULL
#define BSNES_RUN_AHEAD_FRAMES_INFO_0_SK NULL
#define OPTION_VAL_1_SK "1 snímka"
#define OPTION_VAL_2_SK "2 snímky"
#define OPTION_VAL_3_SK "3 snímky"
#define OPTION_VAL_4_SK "4 snímky"
#define BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_SK NULL
#define BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_SK NULL
#define BSNES_COPROCESSOR_PREFER_HLE_LABEL_SK NULL
#define BSNES_COPROCESSOR_PREFER_HLE_INFO_0_SK NULL
#define BSNES_HOTFIXES_LABEL_SK "Záplaty"
#define BSNES_HOTFIXES_INFO_0_SK NULL
#define BSNES_ENTROPY_LABEL_SK NULL
#define BSNES_ENTROPY_INFO_0_SK NULL
#define OPTION_VAL_LOW_SK "Nízke"
#define OPTION_VAL_HIGH_SK "Vysoké"
#define BSNES_CPU_FASTMATH_LABEL_SK NULL
#define BSNES_CPU_FASTMATH_INFO_0_SK NULL
#define BSNES_CPU_OVERCLOCK_LABEL_SK "Pretaktovanie - CPU"
#define BSNES_CPU_OVERCLOCK_LABEL_CAT_SK NULL
#define BSNES_CPU_OVERCLOCK_INFO_0_SK NULL
#define OPTION_VAL_210_SK NULL
#define OPTION_VAL_220_SK NULL
#define OPTION_VAL_230_SK NULL
#define OPTION_VAL_240_SK NULL
#define OPTION_VAL_250_SK NULL
#define OPTION_VAL_260_SK NULL
#define OPTION_VAL_270_SK NULL
#define OPTION_VAL_280_SK NULL
#define OPTION_VAL_290_SK NULL
#define OPTION_VAL_300_SK NULL
#define OPTION_VAL_310_SK NULL
#define OPTION_VAL_320_SK NULL
#define OPTION_VAL_330_SK NULL
#define OPTION_VAL_340_SK NULL
#define OPTION_VAL_350_SK NULL
#define OPTION_VAL_360_SK NULL
#define OPTION_VAL_370_SK NULL
#define OPTION_VAL_380_SK NULL
#define OPTION_VAL_390_SK NULL
#define OPTION_VAL_400_SK NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_SK NULL
#define BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_SK NULL
#define BSNES_CPU_SA1_OVERCLOCK_INFO_0_SK NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_SK NULL
#define BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_SK NULL
#define BSNES_CPU_SFX_OVERCLOCK_INFO_0_SK NULL
#define OPTION_VAL_410_SK NULL
#define OPTION_VAL_420_SK NULL
#define OPTION_VAL_430_SK NULL
#define OPTION_VAL_440_SK NULL
#define OPTION_VAL_450_SK NULL
#define OPTION_VAL_460_SK NULL
#define OPTION_VAL_470_SK NULL
#define OPTION_VAL_480_SK NULL
#define OPTION_VAL_490_SK NULL
#define OPTION_VAL_500_SK NULL
#define OPTION_VAL_510_SK NULL
#define OPTION_VAL_520_SK NULL
#define OPTION_VAL_530_SK NULL
#define OPTION_VAL_540_SK NULL
#define OPTION_VAL_550_SK NULL
#define OPTION_VAL_560_SK NULL
#define OPTION_VAL_570_SK NULL
#define OPTION_VAL_580_SK NULL
#define OPTION_VAL_590_SK NULL
#define OPTION_VAL_600_SK NULL
#define OPTION_VAL_610_SK NULL
#define OPTION_VAL_620_SK NULL
#define OPTION_VAL_630_SK NULL
#define OPTION_VAL_640_SK NULL
#define OPTION_VAL_650_SK NULL
#define OPTION_VAL_660_SK NULL
#define OPTION_VAL_670_SK NULL
#define OPTION_VAL_680_SK NULL
#define OPTION_VAL_690_SK NULL
#define OPTION_VAL_700_SK NULL
#define OPTION_VAL_710_SK NULL
#define OPTION_VAL_720_SK NULL
#define OPTION_VAL_730_SK NULL
#define OPTION_VAL_740_SK NULL
#define OPTION_VAL_750_SK NULL
#define OPTION_VAL_760_SK NULL
#define OPTION_VAL_770_SK NULL
#define OPTION_VAL_780_SK NULL
#define OPTION_VAL_790_SK NULL
#define OPTION_VAL_800_SK NULL
#define BSNES_SGB_BIOS_LABEL_SK NULL
#define BSNES_SGB_BIOS_INFO_0_SK NULL
#define OPTION_VAL_SGB1_SFC_SK NULL
#define OPTION_VAL_SGB2_SFC_SK NULL
#define BSNES_HIDE_SGB_BORDER_LABEL_SK NULL
#define BSNES_HIDE_SGB_BORDER_INFO_0_SK NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_SK NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_SK NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_SK NULL
#define BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_SK NULL

struct retro_core_option_v2_category option_cats_sk[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_SK,
      CATEGORY_VIDEO_INFO_0_SK
   },
   {
      "audio",
      CATEGORY_AUDIO_LABEL_SK,
      CATEGORY_AUDIO_INFO_0_SK
   },
   {
      "mode7",
      CATEGORY_MODE7_LABEL_SK,
      CATEGORY_MODE7_INFO_0_SK
   },
   {
      "hack",
      CATEGORY_HACK_LABEL_SK,
      CATEGORY_HACK_INFO_0_SK
   },
   {
      "overclock",
      CATEGORY_OVERCLOCK_LABEL_SK,
      CATEGORY_OVERCLOCK_INFO_0_SK
   },
   {
      "sgb",
      CATEGORY_SGB_LABEL_SK,
      CATEGORY_SGB_INFO_0_SK
   },
   {
      "lightgun",
      CATEGORY_LIGHTGUN_LABEL_SK,
      CATEGORY_LIGHTGUN_INFO_0_SK
   },

   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_sk[] = {
   {
      "bsnes_aspect_ratio",
      BSNES_ASPECT_RATIO_LABEL_SK,
      NULL,
      BSNES_ASPECT_RATIO_INFO_0_SK,
      NULL,
      "video",
      {
         { "Auto", OPTION_VAL_AUTO_SK },
         { "1:1",  OPTION_VAL_1_1_SK },
         { "4:3",  OPTION_VAL_4_3_SK },
         { "NTSC", OPTION_VAL_NTSC_SK },
         { "PAL",  OPTION_VAL_PAL_SK },
         { NULL, NULL },
      },
      "Auto"
   },
   {
      "bsnes_ppu_overscan_v",
      BSNES_PPU_OVERSCAN_V_LABEL_SK,
      NULL,
      BSNES_PPU_OVERSCAN_V_INFO_0_SK,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_SK },
         { "8",  OPTION_VAL_8_SK },
         { "12", OPTION_VAL_12_SK },
         { "16", OPTION_VAL_16_SK },
         { NULL, NULL },
      },
      "8"
   },
   {
      "bsnes_blur_emulation",
      BSNES_BLUR_EMULATION_LABEL_SK,
      NULL,
      BSNES_BLUR_EMULATION_INFO_0_SK,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_video_filter",
      BSNES_VIDEO_FILTER_LABEL_SK,
      BSNES_VIDEO_FILTER_LABEL_SK,
      BSNES_VIDEO_FILTER_INFO_0_SK,
      NULL,
      "video",
      {
         { "None", OPTION_VAL_NONE_SK },
         { "NTSC (RF)", OPTION_VAL_NTSC_RF_SK },
         { "NTSC (Composite)", OPTION_VAL_NTSC_COMPOSITE_SK },
         { "NTSC (S-Video)", OPTION_VAL_NTSC_S_VIDEO_SK },
         { "NTSC (RGB)", OPTION_VAL_NTSC_RGB_SK },
         { NULL, NULL },
      },
      "None"
   },
   {
      "bsnes_video_luminance",
      BSNES_VIDEO_LUMINANCE_LABEL_SK,
      NULL,
      BSNES_VIDEO_LUMINANCE_INFO_0_SK,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_SK },
         { "10", OPTION_VAL_10_SK },
         { "20", OPTION_VAL_20_SK },
         { "30", OPTION_VAL_30_SK },
         { "40", OPTION_VAL_40_SK },
         { "50", OPTION_VAL_50_SK },
         { "60", OPTION_VAL_60_SK },
         { "70", OPTION_VAL_70_SK },
         { "80", OPTION_VAL_80_SK },
         { "90", OPTION_VAL_90_SK },
         { "100", OPTION_VAL_100_SK },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_saturation",
      BSNES_VIDEO_SATURATION_LABEL_SK,
      NULL,
      BSNES_VIDEO_SATURATION_INFO_0_SK,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_0_O4_SK },
         { "10", OPTION_VAL_10_SK },
         { "20", OPTION_VAL_20_SK },
         { "30", OPTION_VAL_30_SK },
         { "40", OPTION_VAL_40_SK },
         { "50", OPTION_VAL_50_SK },
         { "60", OPTION_VAL_60_SK },
         { "70", OPTION_VAL_70_SK },
         { "80", OPTION_VAL_80_SK },
         { "90", OPTION_VAL_90_SK },
         { "100", OPTION_VAL_100_SK },
         { "110", OPTION_VAL_110_SK },
         { "120", OPTION_VAL_120_SK },
         { "130", OPTION_VAL_130_SK },
         { "140", OPTION_VAL_140_SK },
         { "150", OPTION_VAL_150_SK },
         { "160", OPTION_VAL_160_SK },
         { "170", OPTION_VAL_170_SK },
         { "180", OPTION_VAL_180_SK },
         { "190", OPTION_VAL_190_SK },
         { "200", OPTION_VAL_200_SK },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_video_gamma",
      BSNES_VIDEO_GAMMA_LABEL_SK,
      NULL,
      BSNES_VIDEO_GAMMA_INFO_0_SK,
      NULL,
      "video",
      {
         { "100", OPTION_VAL_100_O6_SK },
         { "110", OPTION_VAL_110_SK },
         { "120", OPTION_VAL_120_SK },
         { "130", OPTION_VAL_130_SK },
         { "140", OPTION_VAL_140_SK },
         { "150", OPTION_VAL_150_O6_SK },
         { "160", OPTION_VAL_160_SK },
         { "170", OPTION_VAL_170_SK },
         { "180", OPTION_VAL_180_SK },
         { "190", OPTION_VAL_190_SK },
         { "200", OPTION_VAL_200_SK },
         { NULL, NULL },
      },
      "150"
   },
   {
      "bsnes_ppu_fast",
      BSNES_PPU_FAST_LABEL_SK,
      BSNES_PPU_FAST_LABEL_CAT_SK,
      BSNES_PPU_FAST_INFO_0_SK,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_deinterlace",
      BSNES_PPU_DEINTERLACE_LABEL_SK,
      BSNES_PPU_DEINTERLACE_LABEL_CAT_SK,
      BSNES_PPU_DEINTERLACE_INFO_0_SK,
      NULL,
      "video",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_ppu_no_sprite_limit",
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_SK,
      BSNES_PPU_NO_SPRITE_LIMIT_LABEL_CAT_SK,
      BSNES_PPU_NO_SPRITE_LIMIT_INFO_0_SK,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_ppu_no_vram_blocking",
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_SK,
      BSNES_PPU_NO_VRAM_BLOCKING_LABEL_CAT_SK,
      BSNES_PPU_NO_VRAM_BLOCKING_INFO_0_SK,
      NULL,
      "video",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_fast",
      BSNES_DSP_FAST_LABEL_SK,
      BSNES_DSP_FAST_LABEL_CAT_SK,
      BSNES_DSP_FAST_INFO_0_SK,
      NULL,
      "audio",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_dsp_cubic",
      BSNES_DSP_CUBIC_LABEL_SK,
      BSNES_DSP_CUBIC_LABEL_CAT_SK,
      BSNES_DSP_CUBIC_INFO_0_SK,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_dsp_echo_shadow",
      BSNES_DSP_ECHO_SHADOW_LABEL_SK,
      BSNES_DSP_ECHO_SHADOW_LABEL_CAT_SK,
      BSNES_DSP_ECHO_SHADOW_INFO_0_SK,
      NULL,
      "audio",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_scale",
      BSNES_MODE7_SCALE_LABEL_SK,
      BSNES_MODE7_SCALE_LABEL_CAT_SK,
      BSNES_MODE7_SCALE_INFO_0_SK,
      NULL,
      "mode7",
      {
         { "1x", OPTION_VAL_1X_SK  },
         { "2x", OPTION_VAL_2X_SK  },
         { "3x", OPTION_VAL_3X_SK  },
         { "4x", OPTION_VAL_4X_SK  },
         { "5x", OPTION_VAL_5X_SK },
         { "6x", OPTION_VAL_6X_SK },
         { "7x", OPTION_VAL_7X_SK },
         { "8x", OPTION_VAL_8X_SK },
         { NULL, NULL },
      },
      "1x"
   },
   {
      "bsnes_mode7_perspective",
      BSNES_MODE7_PERSPECTIVE_LABEL_SK,
      BSNES_MODE7_PERSPECTIVE_LABEL_CAT_SK,
      BSNES_MODE7_PERSPECTIVE_INFO_0_SK,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_mode7_supersample",
      BSNES_MODE7_SUPERSAMPLE_LABEL_SK,
      BSNES_MODE7_SUPERSAMPLE_LABEL_CAT_SK,
      BSNES_MODE7_SUPERSAMPLE_INFO_0_SK,
      NULL,
      "mode7",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_mode7_mosaic",
      BSNES_MODE7_MOSAIC_LABEL_SK,
      BSNES_MODE7_MOSAIC_LABEL_CAT_SK,
      BSNES_MODE7_MOSAIC_INFO_0_SK,
      NULL,
      "mode7",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_run_ahead_frames",
      BSNES_RUN_AHEAD_FRAMES_LABEL_SK,
      NULL,
      BSNES_RUN_AHEAD_FRAMES_INFO_0_SK,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "1",   OPTION_VAL_1_SK  },
         { "2",   OPTION_VAL_2_SK },
         { "3",   OPTION_VAL_3_SK },
         { "4",   OPTION_VAL_4_SK },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_coprocessor_delayed_sync",
      BSNES_COPROCESSOR_DELAYED_SYNC_LABEL_SK,
      NULL,
      BSNES_COPROCESSOR_DELAYED_SYNC_INFO_0_SK,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_coprocessor_prefer_hle",
      BSNES_COPROCESSOR_PREFER_HLE_LABEL_SK,
      NULL,
      BSNES_COPROCESSOR_PREFER_HLE_INFO_0_SK,
      NULL,
      "hack",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_hotfixes",
      BSNES_HOTFIXES_LABEL_SK,
      NULL,
      BSNES_HOTFIXES_INFO_0_SK,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_entropy",
      BSNES_ENTROPY_LABEL_SK,
      NULL,
      BSNES_ENTROPY_INFO_0_SK,
      NULL,
      "hack",
      {
         { "Low",  OPTION_VAL_LOW_SK },
         { "High", OPTION_VAL_HIGH_SK },
         { "None", OPTION_VAL_NONE_SK },
         { NULL, NULL },
      },
      "Low"
   },
   {
      "bsnes_cpu_fastmath",
      BSNES_CPU_FASTMATH_LABEL_SK,
      NULL,
      BSNES_CPU_FASTMATH_INFO_0_SK,
      NULL,
      "hack",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_cpu_overclock",
      BSNES_CPU_OVERCLOCK_LABEL_SK,
      BSNES_CPU_OVERCLOCK_LABEL_CAT_SK,
      BSNES_CPU_OVERCLOCK_INFO_0_SK,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_SK  },
         { "20",  OPTION_VAL_20_SK  },
         { "30",  OPTION_VAL_30_SK  },
         { "40",  OPTION_VAL_40_SK  },
         { "50",  OPTION_VAL_50_SK  },
         { "60",  OPTION_VAL_60_SK  },
         { "70",  OPTION_VAL_70_SK  },
         { "80",  OPTION_VAL_80_SK  },
         { "90",  OPTION_VAL_90_SK  },
         { "100", OPTION_VAL_100_SK },
         { "110", OPTION_VAL_110_SK },
         { "120", OPTION_VAL_120_SK },
         { "130", OPTION_VAL_130_SK },
         { "140", OPTION_VAL_140_SK },
         { "150", OPTION_VAL_150_SK },
         { "160", OPTION_VAL_160_SK },
         { "170", OPTION_VAL_170_SK },
         { "180", OPTION_VAL_180_SK },
         { "190", OPTION_VAL_190_SK },
         { "200", OPTION_VAL_200_SK },
         { "210", OPTION_VAL_210_SK },
         { "220", OPTION_VAL_220_SK },
         { "230", OPTION_VAL_230_SK },
         { "240", OPTION_VAL_240_SK },
         { "250", OPTION_VAL_250_SK },
         { "260", OPTION_VAL_260_SK },
         { "270", OPTION_VAL_270_SK },
         { "280", OPTION_VAL_280_SK },
         { "290", OPTION_VAL_290_SK },
         { "300", OPTION_VAL_300_SK },
         { "310", OPTION_VAL_310_SK },
         { "320", OPTION_VAL_320_SK },
         { "330", OPTION_VAL_330_SK },
         { "340", OPTION_VAL_340_SK },
         { "350", OPTION_VAL_350_SK },
         { "360", OPTION_VAL_360_SK },
         { "370", OPTION_VAL_370_SK },
         { "380", OPTION_VAL_380_SK },
         { "390", OPTION_VAL_390_SK },
         { "400", OPTION_VAL_400_SK },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sa1_overclock",
      BSNES_CPU_SA1_OVERCLOCK_LABEL_SK,
      BSNES_CPU_SA1_OVERCLOCK_LABEL_CAT_SK,
      BSNES_CPU_SA1_OVERCLOCK_INFO_0_SK,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_SK  },
         { "20",  OPTION_VAL_20_SK  },
         { "30",  OPTION_VAL_30_SK  },
         { "40",  OPTION_VAL_40_SK  },
         { "50",  OPTION_VAL_50_SK  },
         { "60",  OPTION_VAL_60_SK  },
         { "70",  OPTION_VAL_70_SK  },
         { "80",  OPTION_VAL_80_SK  },
         { "90",  OPTION_VAL_90_SK  },
         { "100", OPTION_VAL_100_SK },
         { "110", OPTION_VAL_110_SK },
         { "120", OPTION_VAL_120_SK },
         { "130", OPTION_VAL_130_SK },
         { "140", OPTION_VAL_140_SK },
         { "150", OPTION_VAL_150_SK },
         { "160", OPTION_VAL_160_SK },
         { "170", OPTION_VAL_170_SK },
         { "180", OPTION_VAL_180_SK },
         { "190", OPTION_VAL_190_SK },
         { "200", OPTION_VAL_200_SK },
         { "210", OPTION_VAL_210_SK },
         { "220", OPTION_VAL_220_SK },
         { "230", OPTION_VAL_230_SK },
         { "240", OPTION_VAL_240_SK },
         { "250", OPTION_VAL_250_SK },
         { "260", OPTION_VAL_260_SK },
         { "270", OPTION_VAL_270_SK },
         { "280", OPTION_VAL_280_SK },
         { "290", OPTION_VAL_290_SK },
         { "300", OPTION_VAL_300_SK },
         { "310", OPTION_VAL_310_SK },
         { "320", OPTION_VAL_320_SK },
         { "330", OPTION_VAL_330_SK },
         { "340", OPTION_VAL_340_SK },
         { "350", OPTION_VAL_350_SK },
         { "360", OPTION_VAL_360_SK },
         { "370", OPTION_VAL_370_SK },
         { "380", OPTION_VAL_380_SK },
         { "390", OPTION_VAL_390_SK },
         { "400", OPTION_VAL_400_SK },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_cpu_sfx_overclock",
      BSNES_CPU_SFX_OVERCLOCK_LABEL_SK,
      BSNES_CPU_SFX_OVERCLOCK_LABEL_CAT_SK,
      BSNES_CPU_SFX_OVERCLOCK_INFO_0_SK,
      NULL,
      "overclock",
      {
         { "10",  OPTION_VAL_10_SK  },
         { "20",  OPTION_VAL_20_SK  },
         { "30",  OPTION_VAL_30_SK  },
         { "40",  OPTION_VAL_40_SK  },
         { "50",  OPTION_VAL_50_SK  },
         { "60",  OPTION_VAL_60_SK  },
         { "70",  OPTION_VAL_70_SK  },
         { "80",  OPTION_VAL_80_SK  },
         { "90",  OPTION_VAL_90_SK  },
         { "100", OPTION_VAL_100_SK },
         { "110", OPTION_VAL_110_SK },
         { "120", OPTION_VAL_120_SK },
         { "130", OPTION_VAL_130_SK },
         { "140", OPTION_VAL_140_SK },
         { "150", OPTION_VAL_150_SK },
         { "160", OPTION_VAL_160_SK },
         { "170", OPTION_VAL_170_SK },
         { "180", OPTION_VAL_180_SK },
         { "190", OPTION_VAL_190_SK },
         { "200", OPTION_VAL_200_SK },
         { "210", OPTION_VAL_210_SK },
         { "220", OPTION_VAL_220_SK },
         { "230", OPTION_VAL_230_SK },
         { "240", OPTION_VAL_240_SK },
         { "250", OPTION_VAL_250_SK },
         { "260", OPTION_VAL_260_SK },
         { "270", OPTION_VAL_270_SK },
         { "280", OPTION_VAL_280_SK },
         { "290", OPTION_VAL_290_SK },
         { "300", OPTION_VAL_300_SK },
         { "310", OPTION_VAL_310_SK },
         { "320", OPTION_VAL_320_SK },
         { "330", OPTION_VAL_330_SK },
         { "340", OPTION_VAL_340_SK },
         { "350", OPTION_VAL_350_SK },
         { "360", OPTION_VAL_360_SK },
         { "370", OPTION_VAL_370_SK },
         { "380", OPTION_VAL_380_SK },
         { "390", OPTION_VAL_390_SK },
         { "400", OPTION_VAL_400_SK },
         { "410", OPTION_VAL_410_SK },
         { "420", OPTION_VAL_420_SK },
         { "430", OPTION_VAL_430_SK },
         { "440", OPTION_VAL_440_SK },
         { "450", OPTION_VAL_450_SK },
         { "460", OPTION_VAL_460_SK },
         { "470", OPTION_VAL_470_SK },
         { "480", OPTION_VAL_480_SK },
         { "490", OPTION_VAL_490_SK },
         { "500", OPTION_VAL_500_SK },
         { "510", OPTION_VAL_510_SK },
         { "520", OPTION_VAL_520_SK },
         { "530", OPTION_VAL_530_SK },
         { "540", OPTION_VAL_540_SK },
         { "550", OPTION_VAL_550_SK },
         { "560", OPTION_VAL_560_SK },
         { "570", OPTION_VAL_570_SK },
         { "580", OPTION_VAL_580_SK },
         { "590", OPTION_VAL_590_SK },
         { "600", OPTION_VAL_600_SK },
         { "610", OPTION_VAL_610_SK },
         { "620", OPTION_VAL_620_SK },
         { "630", OPTION_VAL_630_SK },
         { "640", OPTION_VAL_640_SK },
         { "650", OPTION_VAL_650_SK },
         { "660", OPTION_VAL_660_SK },
         { "670", OPTION_VAL_670_SK },
         { "680", OPTION_VAL_680_SK },
         { "690", OPTION_VAL_690_SK },
         { "700", OPTION_VAL_700_SK },
         { "710", OPTION_VAL_710_SK },
         { "720", OPTION_VAL_720_SK },
         { "730", OPTION_VAL_730_SK },
         { "740", OPTION_VAL_740_SK },
         { "750", OPTION_VAL_750_SK },
         { "760", OPTION_VAL_760_SK },
         { "770", OPTION_VAL_770_SK },
         { "780", OPTION_VAL_780_SK },
         { "790", OPTION_VAL_790_SK },
         { "800", OPTION_VAL_800_SK },
         { NULL, NULL },
      },
      "100"
   },
   {
      "bsnes_sgb_bios",
      BSNES_SGB_BIOS_LABEL_SK,
      NULL,
      BSNES_SGB_BIOS_INFO_0_SK,
      NULL,
      "sgb",
      {
         { "SGB1.sfc", OPTION_VAL_SGB1_SFC_SK   },
         { "SGB2.sfc", OPTION_VAL_SGB2_SFC_SK },
         { NULL, NULL },
      },
      "SGB1.sfc"
   },
   {
      "bsnes_hide_sgb_border",
      BSNES_HIDE_SGB_BORDER_LABEL_SK,
      NULL,
      BSNES_HIDE_SGB_BORDER_INFO_0_SK,
      NULL,
      "sgb",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },
   {
      "bsnes_touchscreen_lightgun",
      BSNES_TOUCHSCREEN_LIGHTGUN_LABEL_SK,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_INFO_0_SK,
      NULL,
      "lightgun",
      {
         { "ON",  "enabled"  },
         { "OFF", "disabled" },
         { NULL, NULL },
      },
      "ON"
   },
   {
      "bsnes_touchscreen_lightgun_superscope_reverse",
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_LABEL_SK,
      NULL,
      BSNES_TOUCHSCREEN_LIGHTGUN_SUPERSCOPE_REVERSE_INFO_0_SK,
      NULL,
      "lightgun",
      {
         { "OFF", "disabled" },
         { "ON",  "enabled"  },
         { NULL, NULL },
      },
      "OFF"
   },

   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_sk = {
   option_cats_sk,
   option_defs_sk
};

/* RETRO_LANGUAGE_SR */

#define CATEGORY_VIDEO_LABEL_SR NULL
#define CATEGORY_VIDEO_INFO_0_SR "Izmeni podešavanja video izlaza."
#define CATEGORY_AUDIO_LABEL_SR "Zvuk"
#define CATEGORY_AUDIO_INFO_0_SR "Izmeni podešavanja zvuka."
#define CATEGORY_MODE7_LABEL_SR NULL
#define CATEGORY_MODE7_INFO_0_SR NULL
#define CATEGORY_HACK_LABEL_SR NULL
#define CATEGORY_HACK_INFO_0_SR NULL
#define CATEGORY_OVERCLOCK_LABEL_SR NULL
#define CATEGORY_OVERCLOCK_INFO_0_SR NULL
#define CATEGORY_SGB_LABEL_SR NULL
#define CATEGORY_SGB_INFO_0_SR NULL
#define CATEGORY_LIGHTGUN_LABEL_SR NULL
#define CATEGORY_LIGHTGUN_INFO_0_SR NULL
#define BSNES_ASPECT_RATIO_LABEL_SR NULL
#define BSNES_ASPECT_RATIO_INFO_0_SR NULL
#define OPTION_VAL_AUTO_SR NULL
#define OPTION_VAL_1_1_SR NULL
#define OPTION_VAL_4_3_SR NULL
#define OPTION_VAL_NTSC_SR NULL
#define OPTION_VAL_PAL_SR NULL
#define BSNES_PPU_OVERSCAN_V_LABEL_SR NULL
#define BSNES_PPU_OVERSCAN_V_INFO_0_SR NULL
#define OPTION_VAL_0_SR NULL
#define OPTION_VAL_8_SR NULL
#define OPTION_VAL_12_SR NULL
#define OPTION_VAL_16_SR NULL
#define BSNES_BLUR_EMULATION_LABEL_SR NULL
#define BSNES_BLUR_EMULATION_INFO_0_SR NULL
#define BSNES_VIDEO_FILTER_LABEL_SR NULL
#define BSNES_VIDEO_FILTER_INFO_0_SR NULL
#define OPTION_VAL_NONE_SR NULL
#define OPTION_VAL_NTSC_RF_SR NULL
#define OPTION_VAL_NTSC_COMPOSITE_SR NULL
#define OPTION_VAL_NTSC_S_VIDEO_SR NULL
#define