/* Generated by wayland-scanner 1.24.0 */

#ifndef XX_PIP_V1_SERVER_PROTOCOL_H
#define XX_PIP_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xx_pip_v1 The xx_pip_v1 protocol
 * @section page_ifaces_xx_pip_v1 Interfaces
 * - @subpage page_iface_xx_pip_shell_v1 - create picture-in-picture surfaces
 * - @subpage page_iface_xx_pip_v1 - picture-in-picture surface
 * @section page_copyright_xx_pip_v1 Copyright
 * <pre>
 *
 * Copyright © 2025 Vlad Zahorodnii
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct wl_surface;
struct xdg_surface;
struct xx_pip_shell_v1;
struct xx_pip_v1;

#ifndef XX_PIP_SHELL_V1_INTERFACE
#define XX_PIP_SHELL_V1_INTERFACE
/**
 * @page page_iface_xx_pip_shell_v1 xx_pip_shell_v1
 * @section page_iface_xx_pip_shell_v1_desc Description
 *
 * The xx_pip_shell_v1 interface provides a way to create picture-in-picture
 * windows.
 *
 * Use cases are for example playing a video in a separate floating window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_xx_pip_shell_v1_api API
 * See @ref iface_xx_pip_shell_v1.
 */
/**
 * @defgroup iface_xx_pip_shell_v1 The xx_pip_shell_v1 interface
 *
 * The xx_pip_shell_v1 interface provides a way to create picture-in-picture
 * windows.
 *
 * Use cases are for example playing a video in a separate floating window.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface xx_pip_shell_v1_interface;
#endif
#ifndef XX_PIP_V1_INTERFACE
#define XX_PIP_V1_INTERFACE
/**
 * @page page_iface_xx_pip_v1 xx_pip_v1
 * @section page_iface_xx_pip_v1_desc Description
 *
 * This interface defines an xdg_surface role which represents a floating
 * window with some miniature contents, for example a video.
 *
 * The picture-in-picture window will be placed above all other windows.
 * Compositor-specific policies may override or customize the behavior
 * and the placement of the xx_pip_v1. For example, the compositor may
 * choose to put the xx_pip_v1 in a screen corner, etc.
 *
 * Unmapping an xx_pip_v1 means that the surface cannot be shown
 * by the compositor until it is explicitly mapped again.
 * All active operations (e.g., move, resize) are canceled and all
 * attributes (e.g. title, state, stacking, ...) are discarded for
 * an xx_pip_v1 surface when it is unmapped. The xx_pip_v1 returns to
 * the state it had right after xx_pip_shell_v1.get_pip. The client
 * can re-map the pip by performing a commit without any buffer
 * attached, waiting for a configure event and handling it as usual (see
 * xdg_surface description).
 *
 * Attaching a null buffer to a picture-in-picture unmaps the surface.
 * @section page_iface_xx_pip_v1_api API
 * See @ref iface_xx_pip_v1.
 */
/**
 * @defgroup iface_xx_pip_v1 The xx_pip_v1 interface
 *
 * This interface defines an xdg_surface role which represents a floating
 * window with some miniature contents, for example a video.
 *
 * The picture-in-picture window will be placed above all other windows.
 * Compositor-specific policies may override or customize the behavior
 * and the placement of the xx_pip_v1. For example, the compositor may
 * choose to put the xx_pip_v1 in a screen corner, etc.
 *
 * Unmapping an xx_pip_v1 means that the surface cannot be shown
 * by the compositor until it is explicitly mapped again.
 * All active operations (e.g., move, resize) are canceled and all
 * attributes (e.g. title, state, stacking, ...) are discarded for
 * an xx_pip_v1 surface when it is unmapped. The xx_pip_v1 returns to
 * the state it had right after xx_pip_shell_v1.get_pip. The client
 * can re-map the pip by performing a commit without any buffer
 * attached, waiting for a configure event and handling it as usual (see
 * xdg_surface description).
 *
 * Attaching a null buffer to a picture-in-picture unmaps the surface.
 */
extern const struct wl_interface xx_pip_v1_interface;
#endif

#ifndef XX_PIP_SHELL_V1_ERROR_ENUM
#define XX_PIP_SHELL_V1_ERROR_ENUM
enum xx_pip_shell_v1_error {
	/**
	 * given wl_surface has another role
	 */
	XX_PIP_SHELL_V1_ERROR_ROLE = 0,
	/**
	 * wl_surface has a buffer attached or committed
	 */
	XX_PIP_SHELL_V1_ERROR_ALREADY_CONSTRUCTED = 1,
};
#endif /* XX_PIP_SHELL_V1_ERROR_ENUM */

#ifndef XX_PIP_SHELL_V1_ERROR_ENUM_IS_VALID
#define XX_PIP_SHELL_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_pip_shell_v1
 * Validate a xx_pip_shell_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_pip_shell_v1_error
 */
static inline bool
xx_pip_shell_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_PIP_SHELL_V1_ERROR_ROLE:
		return version >= 1;
	case XX_PIP_SHELL_V1_ERROR_ALREADY_CONSTRUCTED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_PIP_SHELL_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_pip_shell_v1
 * @struct xx_pip_shell_v1_interface
 */
struct xx_pip_shell_v1_interface {
	/**
	 * destroy xx_pip_shell_v1
	 *
	 * Destroy this xx_pip_shell_v1 object. Objects that have been
	 * created through this instance are unaffected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create picture-in-picture surface from a surface
	 *
	 * This creates an xx_pip_v1 for the given xdg_surface and gives
	 * the associated wl_surface the xx_pip_v1 role.
	 *
	 * If the wl_surface already has a role assigned, a role protocol
	 * error will be raised.
	 *
	 * Creating a picture-in-picture surface from a wl_surface which
	 * has a buffer attached or committed is a client error, and any
	 * attempts by a client to attach or manipulate a buffer prior to
	 * the first xx_pip_v1.configure event must also be treated as
	 * errors.
	 *
	 * After creating an xx_pip_v1 object and setting it up, the client
	 * must perform an initial commit without any buffer attached. The
	 * compositor will reply with a xx_pip_v1.configure event. The
	 * client must acknowledge it and is then allowed to attach a
	 * buffer to map the surface.
	 *
	 * The compositor may deny showing the picture-in-picture surface,
	 * in which case it will send the closed event before the first
	 * configure event.
	 *
	 * See the documentation of xdg_surface for more details about what
	 * an xdg_surface is and how it is used.
	 */
	void (*get_pip)(struct wl_client *client,
			struct wl_resource *resource,
			uint32_t id,
			struct wl_resource *xdg_surface);
};


/**
 * @ingroup iface_xx_pip_shell_v1
 */
#define XX_PIP_SHELL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_shell_v1
 */
#define XX_PIP_SHELL_V1_GET_PIP_SINCE_VERSION 1

#ifndef XX_PIP_V1_ERROR_ENUM
#define XX_PIP_V1_ERROR_ENUM
enum xx_pip_v1_error {
	/**
	 * invalid surface size provided
	 */
	XX_PIP_V1_ERROR_INVALID_SIZE = 0,
	/**
	 * invalid origin
	 */
	XX_PIP_V1_ERROR_INVALID_ORIGIN = 1,
	/**
	 * invalid resize edge
	 */
	XX_PIP_V1_ERROR_INVALID_RESIZE_EDGE = 2,
};
#endif /* XX_PIP_V1_ERROR_ENUM */

#ifndef XX_PIP_V1_ERROR_ENUM_IS_VALID
#define XX_PIP_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_xx_pip_v1
 * Validate a xx_pip_v1 error value.
 *
 * @return true on success, false on error.
 * @ref xx_pip_v1_error
 */
static inline bool
xx_pip_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_PIP_V1_ERROR_INVALID_SIZE:
		return version >= 1;
	case XX_PIP_V1_ERROR_INVALID_ORIGIN:
		return version >= 1;
	case XX_PIP_V1_ERROR_INVALID_RESIZE_EDGE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_PIP_V1_ERROR_ENUM_IS_VALID */

#ifndef XX_PIP_V1_RESIZE_EDGE_ENUM
#define XX_PIP_V1_RESIZE_EDGE_ENUM
/**
 * @ingroup iface_xx_pip_v1
 * edge values for resizing
 *
 * These values are used to indicate which edge of a surface
 * is being dragged in a resize operation.
 */
enum xx_pip_v1_resize_edge {
	XX_PIP_V1_RESIZE_EDGE_NONE = 0,
	XX_PIP_V1_RESIZE_EDGE_TOP = 1,
	XX_PIP_V1_RESIZE_EDGE_BOTTOM = 2,
	XX_PIP_V1_RESIZE_EDGE_LEFT = 4,
	XX_PIP_V1_RESIZE_EDGE_TOP_LEFT = 5,
	XX_PIP_V1_RESIZE_EDGE_BOTTOM_LEFT = 6,
	XX_PIP_V1_RESIZE_EDGE_RIGHT = 8,
	XX_PIP_V1_RESIZE_EDGE_TOP_RIGHT = 9,
	XX_PIP_V1_RESIZE_EDGE_BOTTOM_RIGHT = 10,
};
#endif /* XX_PIP_V1_RESIZE_EDGE_ENUM */

#ifndef XX_PIP_V1_RESIZE_EDGE_ENUM_IS_VALID
#define XX_PIP_V1_RESIZE_EDGE_ENUM_IS_VALID
/**
 * @ingroup iface_xx_pip_v1
 * Validate a xx_pip_v1 resize_edge value.
 *
 * @return true on success, false on error.
 * @ref xx_pip_v1_resize_edge
 */
static inline bool
xx_pip_v1_resize_edge_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case XX_PIP_V1_RESIZE_EDGE_NONE:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_TOP:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_BOTTOM:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_LEFT:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_TOP_LEFT:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_BOTTOM_LEFT:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_RIGHT:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_TOP_RIGHT:
		return version >= 1;
	case XX_PIP_V1_RESIZE_EDGE_BOTTOM_RIGHT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* XX_PIP_V1_RESIZE_EDGE_ENUM_IS_VALID */

/**
 * @ingroup iface_xx_pip_v1
 * @struct xx_pip_v1_interface
 */
struct xx_pip_v1_interface {
	/**
	 * destroy the xx_pip_v1
	 *
	 * This request destroys the role surface and unmaps the surface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set application ID
	 *
	 * Set an application identifier for the surface.
	 *
	 * The app ID identifies the general class of applications to which
	 * the surface belongs. The compositor can use this to group
	 * multiple surfaces together, or to determine how to launch a new
	 * application.
	 *
	 * For D-Bus activatable applications, the app ID is used as the
	 * D-Bus service name.
	 *
	 * The compositor shell will try to group application surfaces
	 * together by their app ID. As a best practice, it is suggested to
	 * select app ID's that match the basename of the application's
	 * .desktop file. For example, "org.freedesktop.FooViewer" where
	 * the .desktop file is "org.freedesktop.FooViewer.desktop".
	 *
	 * Like other properties, a set_app_id request can be sent after
	 * the xx_pip_v1 has been mapped to update the property.
	 *
	 * See the desktop-entry specification [0] for more details on
	 * application identifiers and how they relate to well-known D-Bus
	 * names and .desktop files.
	 *
	 * [0] http://standards.freedesktop.org/desktop-entry-spec/
	 */
	void (*set_app_id)(struct wl_client *client,
			   struct wl_resource *resource,
			   const char *app_id);
	/**
	 * set origin surface
	 *
	 * Set the origin surface for the picture-in-picture surface.
	 *
	 * The origin surface is an optional property that specifies a
	 * surface from which the picture-in-picture surface has been
	 * launched. If set, the compositor may use this hint to play an
	 * animation when the picture-in-picture surface is mapped or
	 * unmapped. For example, smoothly move the surface from the origin
	 * to a screen corner.
	 *
	 * If the specified origin surface is the same as the
	 * picture-in-picture surface, the invalid_origin protocol error
	 * will be posted.
	 *
	 * The origin surface is double-buffered state, see
	 * wl_surface.commit.
	 */
	void (*set_origin)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *origin);
	/**
	 * set origin rect
	 *
	 * Set the origin rect within the origin surface for the
	 * picture-in-picture surface.
	 *
	 * The origin rect is an optional property that specifies the
	 * launch rectangle within the origin surface. The compositor may
	 * use this hint to play an animation when the picture-in-picture
	 * surface is mapped or unmapped. For example, smoothly move the
	 * surface from the origin rect to a screen corner.
	 *
	 * The origin rect is specified in the surface-local coordinate
	 * space.
	 *
	 * The compositor ignores the parts of the origin rect that fall
	 * outside of the origin surface.
	 *
	 * The origin rect is double-buffered state, see wl_surface.commit.
	 */
	void (*set_origin_rect)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t x,
				int32_t y,
				uint32_t width,
				uint32_t height);
	/**
	 * start an interactive move
	 *
	 * Start an interactive, user-driven move of the surface.
	 *
	 * This request must be used in response to some sort of user
	 * action like a button press, key press, or touch down event. The
	 * passed serial is used to determine the type of interactive move
	 * (touch, pointer, etc).
	 *
	 * The server may ignore move requests depending on the state of
	 * the surface, or if the passed serial is no longer valid.
	 *
	 * If triggered, the surface will lose the focus of the device
	 * (wl_pointer, wl_touch, etc) used for the move. It is up to the
	 * compositor to visually indicate that the move is taking place,
	 * such as updating a pointer cursor, during the move. There is no
	 * guarantee that the device focus will return when the move is
	 * completed.
	 * @param seat the wl_seat of the user event
	 * @param serial the serial of the user event
	 */
	void (*move)(struct wl_client *client,
		     struct wl_resource *resource,
		     struct wl_resource *seat,
		     uint32_t serial);
	/**
	 * start an interactive resize
	 *
	 * Start a user-driven, interactive resize of the surface.
	 *
	 * This request must be used in response to some sort of user
	 * action like a button press, key press, or touch down event. The
	 * passed serial is used to determine the type of interactive
	 * resize (touch, pointer, etc).
	 *
	 * The server may ignore resize requests depending on the state of
	 * the surface, or if the passed serial is no longer valid.
	 *
	 * If triggered, the surface also will lose the focus of the device
	 * (wl_pointer, wl_touch, etc) used for the resize. It is up to the
	 * compositor to visually indicate that the resize is taking place,
	 * such as updating a pointer cursor, during the resize. There is
	 * no guarantee that the device focus will return when the resize
	 * is completed.
	 *
	 * The edges parameter specifies how the surface should be resized,
	 * and is one of the values of the resize_edge enum. The compositor
	 * may use this information to update the surface position for
	 * example when dragging the top left corner. The compositor may
	 * also use this information to adapt its behavior, e.g. choose an
	 * appropriate cursor image.
	 * @param seat the wl_seat of the user event
	 * @param serial the serial of the user event
	 * @param edges which edge or corner is being dragged
	 */
	void (*resize)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *seat,
		       uint32_t serial,
		       uint32_t edges);
};

#define XX_PIP_V1_CLOSED 0
#define XX_PIP_V1_CONFIGURE_BOUNDS 1
#define XX_PIP_V1_CONFIGURE_SIZE 2

/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_CONFIGURE_BOUNDS_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_CONFIGURE_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_SET_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_SET_ORIGIN_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_SET_ORIGIN_RECT_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_MOVE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_pip_v1
 */
#define XX_PIP_V1_RESIZE_SINCE_VERSION 1

/**
 * @ingroup iface_xx_pip_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_pip_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, XX_PIP_V1_CLOSED);
}

/**
 * @ingroup iface_xx_pip_v1
 * Sends an configure_bounds event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_pip_v1_send_configure_bounds(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, XX_PIP_V1_CONFIGURE_BOUNDS, width, height);
}

/**
 * @ingroup iface_xx_pip_v1
 * Sends an configure_size event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
xx_pip_v1_send_configure_size(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, XX_PIP_V1_CONFIGURE_SIZE, width, height);
}

#ifdef  __cplusplus
}
#endif

#endif
