/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

//
//Copyright 2024 The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/dra/v1beta1/api.proto

package v1beta1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type NodePrepareResourcesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The list of ResourceClaims that are to be prepared.
	Claims        []*Claim `protobuf:"bytes,1,rep,name=claims,proto3" json:"claims,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodePrepareResourcesRequest) Reset() {
	*x = NodePrepareResourcesRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePrepareResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePrepareResourcesRequest) ProtoMessage() {}

func (x *NodePrepareResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePrepareResourcesRequest.ProtoReflect.Descriptor instead.
func (*NodePrepareResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{0}
}

func (x *NodePrepareResourcesRequest) GetClaims() []*Claim {
	if x != nil {
		return x.Claims
	}
	return nil
}

type NodePrepareResourcesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The ResourceClaims for which preparation was done
	// or attempted, with claim_uid as key.
	//
	// It is an error if some claim listed in NodePrepareResourcesRequest
	// does not get prepared. NodePrepareResources
	// will be called again for those that are missing.
	Claims        map[string]*NodePrepareResourceResponse `protobuf:"bytes,1,rep,name=claims,proto3" json:"claims,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodePrepareResourcesResponse) Reset() {
	*x = NodePrepareResourcesResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePrepareResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePrepareResourcesResponse) ProtoMessage() {}

func (x *NodePrepareResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePrepareResourcesResponse.ProtoReflect.Descriptor instead.
func (*NodePrepareResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{1}
}

func (x *NodePrepareResourcesResponse) GetClaims() map[string]*NodePrepareResourceResponse {
	if x != nil {
		return x.Claims
	}
	return nil
}

type NodePrepareResourceResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// These are the additional devices that kubelet must
	// make available via the container runtime. A claim
	// may have zero or more requests and each request
	// may have zero or more devices.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// If non-empty, preparing the ResourceClaim failed.
	// Devices are ignored in that case.
	Error         string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodePrepareResourceResponse) Reset() {
	*x = NodePrepareResourceResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePrepareResourceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePrepareResourceResponse) ProtoMessage() {}

func (x *NodePrepareResourceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePrepareResourceResponse.ProtoReflect.Descriptor instead.
func (*NodePrepareResourceResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{2}
}

func (x *NodePrepareResourceResponse) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *NodePrepareResourceResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type Device struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The requests in the claim that this device is associated with.
	// Optional. If empty, the device is associated with all requests.
	RequestNames []string `protobuf:"bytes,1,rep,name=request_names,json=requestNames,proto3" json:"request_names,omitempty"`
	// The pool which contains the device. Required.
	PoolName string `protobuf:"bytes,2,opt,name=pool_name,json=poolName,proto3" json:"pool_name,omitempty"`
	// The device itself. Required.
	DeviceName string `protobuf:"bytes,3,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// A single device instance may map to several CDI device IDs.
	// None is also valid.
	CdiDeviceIds  []string `protobuf:"bytes,4,rep,name=cdi_device_ids,json=cdiDeviceIds,proto3" json:"cdi_device_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Device) Reset() {
	*x = Device{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{3}
}

func (x *Device) GetRequestNames() []string {
	if x != nil {
		return x.RequestNames
	}
	return nil
}

func (x *Device) GetPoolName() string {
	if x != nil {
		return x.PoolName
	}
	return ""
}

func (x *Device) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

func (x *Device) GetCdiDeviceIds() []string {
	if x != nil {
		return x.CdiDeviceIds
	}
	return nil
}

type NodeUnprepareResourcesRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The list of ResourceClaims that are to be unprepared.
	Claims        []*Claim `protobuf:"bytes,1,rep,name=claims,proto3" json:"claims,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodeUnprepareResourcesRequest) Reset() {
	*x = NodeUnprepareResourcesRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeUnprepareResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeUnprepareResourcesRequest) ProtoMessage() {}

func (x *NodeUnprepareResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeUnprepareResourcesRequest.ProtoReflect.Descriptor instead.
func (*NodeUnprepareResourcesRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{4}
}

func (x *NodeUnprepareResourcesRequest) GetClaims() []*Claim {
	if x != nil {
		return x.Claims
	}
	return nil
}

type NodeUnprepareResourcesResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The ResourceClaims for which preparation was reverted.
	// The same rules as for NodePrepareResourcesResponse.claims
	// apply. In particular, all claims in the request must
	// have an entry in the response, even if that entry is nil.
	Claims        map[string]*NodeUnprepareResourceResponse `protobuf:"bytes,1,rep,name=claims,proto3" json:"claims,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodeUnprepareResourcesResponse) Reset() {
	*x = NodeUnprepareResourcesResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeUnprepareResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeUnprepareResourcesResponse) ProtoMessage() {}

func (x *NodeUnprepareResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeUnprepareResourcesResponse.ProtoReflect.Descriptor instead.
func (*NodeUnprepareResourcesResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{5}
}

func (x *NodeUnprepareResourcesResponse) GetClaims() map[string]*NodeUnprepareResourceResponse {
	if x != nil {
		return x.Claims
	}
	return nil
}

type NodeUnprepareResourceResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If non-empty, unpreparing the ResourceClaim failed.
	Error         string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodeUnprepareResourceResponse) Reset() {
	*x = NodeUnprepareResourceResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeUnprepareResourceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeUnprepareResourceResponse) ProtoMessage() {}

func (x *NodeUnprepareResourceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeUnprepareResourceResponse.ProtoReflect.Descriptor instead.
func (*NodeUnprepareResourceResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{6}
}

func (x *NodeUnprepareResourceResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

type Claim struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The ResourceClaim namespace (ResourceClaim.meta.Namespace).
	// This field is REQUIRED.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// The UID of the Resource claim (ResourceClaim.meta.UUID).
	// This field is REQUIRED.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// The name of the Resource claim (ResourceClaim.meta.Name)
	// This field is REQUIRED.
	Name          string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Claim) Reset() {
	*x = Claim{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Claim) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Claim) ProtoMessage() {}

func (x *Claim) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Claim.ProtoReflect.Descriptor instead.
func (*Claim) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP(), []int{7}
}

func (x *Claim) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Claim) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Claim) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDesc = string([]byte{
	0x0a, 0x39, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x72, 0x61, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x6b, 0x38, 0x73,
	0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x22, 0x61, 0x0a, 0x1b, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74,
	0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x52, 0x06, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x22, 0x82, 0x02, 0x0a, 0x1c, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x65, 0x70,
	0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75,
	0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x64,
	0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x1a, 0x7b, 0x0a, 0x0b, 0x43,
	0x6c, 0x61, 0x69, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x56, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67,
	0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a, 0x0a, 0x1b, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69,
	0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x22, 0x91, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x63, 0x64, 0x69, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x64, 0x69, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0x63, 0x0a, 0x1d, 0x4e, 0x6f, 0x64, 0x65,
	0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6b, 0x38, 0x73, 0x2e,
	0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6c, 0x61, 0x69, 0x6d, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x22, 0x88, 0x02,
	0x0a, 0x1e, 0x4e, 0x6f, 0x64, 0x65, 0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x67, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4f, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65,
	0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x55, 0x6e, 0x70, 0x72, 0x65,
	0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x1a, 0x7d, 0x0a, 0x0b, 0x43, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x58, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x6b, 0x38, 0x73, 0x2e,
	0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x35, 0x0a, 0x1d, 0x4e, 0x6f, 0x64, 0x65,
	0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22,
	0x4b, 0x0a, 0x05, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xd1, 0x02, 0x0a,
	0x09, 0x44, 0x52, 0x41, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x9d, 0x01, 0x0a, 0x14, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x40, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62,
	0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x64, 0x72,
	0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b,
	0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0xa3, 0x01, 0x0a, 0x16, 0x4e,
	0x6f, 0x64, 0x65, 0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x42, 0x2e, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2e, 0x6b,
	0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x6b, 0x38, 0x73, 0x2e,
	0x69, 0x6f, 0x2e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x64, 0x72, 0x61, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x55, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x42, 0x25, 0x5a, 0x23, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c,
	0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x72, 0x61, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDescData
}

var file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_goTypes = []any{
	(*NodePrepareResourcesRequest)(nil),    // 0: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesRequest
	(*NodePrepareResourcesResponse)(nil),   // 1: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse
	(*NodePrepareResourceResponse)(nil),    // 2: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourceResponse
	(*Device)(nil),                         // 3: k8s.io.kubelet.pkg.apis.dra.v1beta1.Device
	(*NodeUnprepareResourcesRequest)(nil),  // 4: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesRequest
	(*NodeUnprepareResourcesResponse)(nil), // 5: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse
	(*NodeUnprepareResourceResponse)(nil),  // 6: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourceResponse
	(*Claim)(nil),                          // 7: k8s.io.kubelet.pkg.apis.dra.v1beta1.Claim
	nil,                                    // 8: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse.ClaimsEntry
	nil,                                    // 9: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse.ClaimsEntry
}
var file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_depIdxs = []int32{
	7, // 0: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesRequest.claims:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.Claim
	8, // 1: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse.claims:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse.ClaimsEntry
	3, // 2: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourceResponse.devices:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.Device
	7, // 3: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesRequest.claims:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.Claim
	9, // 4: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse.claims:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse.ClaimsEntry
	2, // 5: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse.ClaimsEntry.value:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourceResponse
	6, // 6: k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse.ClaimsEntry.value:type_name -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourceResponse
	0, // 7: k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin.NodePrepareResources:input_type -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesRequest
	4, // 8: k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin.NodeUnprepareResources:input_type -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesRequest
	1, // 9: k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin.NodePrepareResources:output_type -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodePrepareResourcesResponse
	5, // 10: k8s.io.kubelet.pkg.apis.dra.v1beta1.DRAPlugin.NodeUnprepareResources:output_type -> k8s.io.kubelet.pkg.apis.dra.v1beta1.NodeUnprepareResourcesResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_init() }
func file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_init() {
	if File_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto = out.File
	file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_goTypes = nil
	file_staging_src_k8s_io_kubelet_pkg_apis_dra_v1beta1_api_proto_depIdxs = nil
}
