/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// FrontendTLSConfigApplyConfiguration represents a declarative configuration of the FrontendTLSConfig type for use
// with apply.
type FrontendTLSConfigApplyConfiguration struct {
	Default *TLSConfigApplyConfiguration      `json:"default,omitempty"`
	PerPort []TLSPortConfigApplyConfiguration `json:"perPort,omitempty"`
}

// FrontendTLSConfigApplyConfiguration constructs a declarative configuration of the FrontendTLSConfig type for use with
// apply.
func FrontendTLSConfig() *FrontendTLSConfigApplyConfiguration {
	return &FrontendTLSConfigApplyConfiguration{}
}

// WithDefault sets the Default field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Default field is set to the value of the last call.
func (b *FrontendTLSConfigApplyConfiguration) WithDefault(value *TLSConfigApplyConfiguration) *FrontendTLSConfigApplyConfiguration {
	b.Default = value
	return b
}

// WithPerPort adds the given value to the PerPort field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PerPort field.
func (b *FrontendTLSConfigApplyConfiguration) WithPerPort(values ...*TLSPortConfigApplyConfiguration) *FrontendTLSConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPerPort")
		}
		b.PerPort = append(b.PerPort, *values[i])
	}
	return b
}
