/* Generated by wayland-scanner 1.24.0 */

#ifndef XX_SESSION_MANAGEMENT_V1_CLIENT_PROTOCOL_H
#define XX_SESSION_MANAGEMENT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xx_session_management_v1 The xx_session_management_v1 protocol
 * Protocol for managing application sessions
 *
 * @section page_desc_xx_session_management_v1 Description
 *
 * This description provides a high-level overview of the interplay between
 * the interfaces defined this protocol. For details, see the protocol
 * specification.
 *
 * The xx_session_manager protocol declares interfaces necessary to
 * allow clients to restore toplevel state from previous executions. The
 * xx_session_manager_v1.get_session request can be used to obtain a
 * xx_session_v1 resource representing the state of a set of toplevels.
 *
 * Clients may obtain the session string to use in future calls through
 * the xx_session_v1.created event. Compositors will use this string
 * as an identifiable token for future runs, possibly storing data about
 * the related toplevels in persistent storage.
 *
 * Toplevels are managed through the xx_session_v1.add_toplevel and
 * xx_session_toplevel_v1.remove pair of requests. Clients will explicitly
 * request a toplevel to be restored according to prior state through the
 * xx_session_v1.restore_toplevel request before the toplevel is mapped.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_xx_session_management_v1 Interfaces
 * - @subpage page_iface_xx_session_manager_v1 - manage sessions for applications
 * - @subpage page_iface_xx_session_v1 - A session for an application
 * - @subpage page_iface_xx_toplevel_session_v1 - 
 * @section page_copyright_xx_session_management_v1 Copyright
 * <pre>
 *
 * Copyright 2018 Mike Blumenkrantz
 * Copyright 2018 Samsung Electronics Co., Ltd
 * Copyright 2018 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct xdg_toplevel;
struct xx_session_manager_v1;
struct xx_session_v1;
struct xx_toplevel_session_v1;

#ifndef XX_SESSION_MANAGER_V1_INTERFACE
#define XX_SESSION_MANAGER_V1_INTERFACE
/**
 * @page page_iface_xx_session_manager_v1 xx_session_manager_v1
 * @section page_iface_xx_session_manager_v1_desc Description
 *
 * The xx_session_manager interface defines base requests for creating and
 * managing a session for an application. Sessions persist across application
 * and compositor restarts unless explicitly destroyed. A session is created
 * for the purpose of maintaining an application's xdg_toplevel surfaces
 * across compositor or application restarts. The compositor should remember
 * as many states as possible for surfaces in a given session, but there is
 * no requirement for which states must be remembered.
 * @section page_iface_xx_session_manager_v1_api API
 * See @ref iface_xx_session_manager_v1.
 */
/**
 * @defgroup iface_xx_session_manager_v1 The xx_session_manager_v1 interface
 *
 * The xx_session_manager interface defines base requests for creating and
 * managing a session for an application. Sessions persist across application
 * and compositor restarts unless explicitly destroyed. A session is created
 * for the purpose of maintaining an application's xdg_toplevel surfaces
 * across compositor or application restarts. The compositor should remember
 * as many states as possible for surfaces in a given session, but there is
 * no requirement for which states must be remembered.
 */
extern const struct wl_interface xx_session_manager_v1_interface;
#endif
#ifndef XX_SESSION_V1_INTERFACE
#define XX_SESSION_V1_INTERFACE
/**
 * @page page_iface_xx_session_v1 xx_session_v1
 * @section page_iface_xx_session_v1_desc Description
 *
 * A xx_session_v1 object represents a session for an application. While the
 * object exists, all surfaces which have been added to the session will
 * have states stored by the compositor which can be reapplied at a later
 * time. Two sessions cannot exist for the same identifier string.
 *
 * States for surfaces added to a session are automatically updated by the
 * compositor when they are changed.
 *
 * Surfaces which have been added to a session are automatically removed from
 * the session if xdg_toplevel.destroy is called for the surface.
 * @section page_iface_xx_session_v1_api API
 * See @ref iface_xx_session_v1.
 */
/**
 * @defgroup iface_xx_session_v1 The xx_session_v1 interface
 *
 * A xx_session_v1 object represents a session for an application. While the
 * object exists, all surfaces which have been added to the session will
 * have states stored by the compositor which can be reapplied at a later
 * time. Two sessions cannot exist for the same identifier string.
 *
 * States for surfaces added to a session are automatically updated by the
 * compositor when they are changed.
 *
 * Surfaces which have been added to a session are automatically removed from
 * the session if xdg_toplevel.destroy is called for the surface.
 */
extern const struct wl_interface xx_session_v1_interface;
#endif
#ifndef XX_TOPLEVEL_SESSION_V1_INTERFACE
#define XX_TOPLEVEL_SESSION_V1_INTERFACE
/**
 * @page page_iface_xx_toplevel_session_v1 xx_toplevel_session_v1
 * @section page_iface_xx_toplevel_session_v1_api API
 * See @ref iface_xx_toplevel_session_v1.
 */
/**
 * @defgroup iface_xx_toplevel_session_v1 The xx_toplevel_session_v1 interface
 */
extern const struct wl_interface xx_toplevel_session_v1_interface;
#endif

#ifndef XX_SESSION_MANAGER_V1_ERROR_ENUM
#define XX_SESSION_MANAGER_V1_ERROR_ENUM
enum xx_session_manager_v1_error {
	/**
	 * a requested session is already in use
	 */
	XX_SESSION_MANAGER_V1_ERROR_IN_USE = 1,
};
#endif /* XX_SESSION_MANAGER_V1_ERROR_ENUM */

#ifndef XX_SESSION_MANAGER_V1_REASON_ENUM
#define XX_SESSION_MANAGER_V1_REASON_ENUM
/**
 * @ingroup iface_xx_session_manager_v1
 * reason for getting a session
 *
 * The reason may determine in what way a session restores the window
 * management state of associated toplevels.
 *
 * For example newly launched applications might be launched on the active
 * workspace with restored size and position, while a recovered
 * applications might restore additional state such as active workspace and
 * stacking order.
 */
enum xx_session_manager_v1_reason {
	/**
	 * an app is newly launched
	 *
	 * A new app instance is launched, for example from an app
	 * launcher.
	 */
	XX_SESSION_MANAGER_V1_REASON_LAUNCH = 1,
	/**
	 * an app recovered
	 *
	 * A app instance is recovering from for example a compositor or
	 * app crash.
	 */
	XX_SESSION_MANAGER_V1_REASON_RECOVER = 2,
	/**
	 * an app restored
	 *
	 * A app instance is restored, for example part of a restored
	 * session, or restored from having been temporarily terminated due
	 * to resource constraints.
	 */
	XX_SESSION_MANAGER_V1_REASON_SESSION_RESTORE = 3,
};
#endif /* XX_SESSION_MANAGER_V1_REASON_ENUM */

#define XX_SESSION_MANAGER_V1_DESTROY 0
#define XX_SESSION_MANAGER_V1_GET_SESSION 1


/**
 * @ingroup iface_xx_session_manager_v1
 */
#define XX_SESSION_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_manager_v1
 */
#define XX_SESSION_MANAGER_V1_GET_SESSION_SINCE_VERSION 1

/** @ingroup iface_xx_session_manager_v1 */
static inline void
xx_session_manager_v1_set_user_data(struct xx_session_manager_v1 *xx_session_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xx_session_manager_v1, user_data);
}

/** @ingroup iface_xx_session_manager_v1 */
static inline void *
xx_session_manager_v1_get_user_data(struct xx_session_manager_v1 *xx_session_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xx_session_manager_v1);
}

static inline uint32_t
xx_session_manager_v1_get_version(struct xx_session_manager_v1 *xx_session_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xx_session_manager_v1);
}

/**
 * @ingroup iface_xx_session_manager_v1
 *
 * This has no effect other than to destroy the xx_session_manager object.
 */
static inline void
xx_session_manager_v1_destroy(struct xx_session_manager_v1 *xx_session_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xx_session_manager_v1,
			 XX_SESSION_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xx_session_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xx_session_manager_v1
 *
 * Create a session object corresponding to either an existing session
 * identified by the given session identifier string or a new session.
 * While the session object exists, the session is considered to be "in
 * use".
 *
 * If a identifier string represents a session that is currently actively
 * in use by the the same client, an 'in_use' error is raised. If some
 * other client is currently using the same session, the new session will
 * replace managing the associated state.
 *
 * NULL is passed to initiate a new session. If an id is passed which does
 * not represent a valid session, the compositor treats it as if NULL had
 * been passed.
 *
 * A client is allowed to have any number of in use sessions at the same
 * time.
 */
static inline struct xx_session_v1 *
xx_session_manager_v1_get_session(struct xx_session_manager_v1 *xx_session_manager_v1, uint32_t reason, const char *session)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) xx_session_manager_v1,
			 XX_SESSION_MANAGER_V1_GET_SESSION, &xx_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) xx_session_manager_v1), 0, NULL, reason, session);

	return (struct xx_session_v1 *) id;
}

#ifndef XX_SESSION_V1_ERROR_ENUM
#define XX_SESSION_V1_ERROR_ENUM
enum xx_session_v1_error {
	/**
	 * restore cannot be performed after initial toplevel commit
	 */
	XX_SESSION_V1_ERROR_INVALID_RESTORE = 1,
	/**
	 * toplevel name is already in used
	 */
	XX_SESSION_V1_ERROR_NAME_IN_USE = 2,
	/**
	 * toplevel was already mapped when restored
	 */
	XX_SESSION_V1_ERROR_ALREADY_MAPPED = 3,
};
#endif /* XX_SESSION_V1_ERROR_ENUM */

/**
 * @ingroup iface_xx_session_v1
 * @struct xx_session_v1_listener
 */
struct xx_session_v1_listener {
	/**
	 * newly-created session id
	 *
	 * Emitted at most once some time after getting a new session
	 * object. It means that no previous state was restored, and a new
	 * session was created. The passed id can be used to restore
	 * previous sessions.
	 */
	void (*created)(void *data,
			struct xx_session_v1 *xx_session_v1,
			const char *id);
	/**
	 * the session has been restored
	 *
	 * Emitted at most once some time after getting a new session
	 * object. It means that previous state was at least partially
	 * restored. The same id can again be used to restore previous
	 * sessions.
	 */
	void (*restored)(void *data,
			 struct xx_session_v1 *xx_session_v1);
	/**
	 * the session has been restored
	 *
	 * Emitted at most once, if the session was taken over by some
	 * other client. When this happens, the session and all its
	 * toplevel session objects become inert, and should be destroyed.
	 */
	void (*replaced)(void *data,
			 struct xx_session_v1 *xx_session_v1);
};

/**
 * @ingroup iface_xx_session_v1
 */
static inline int
xx_session_v1_add_listener(struct xx_session_v1 *xx_session_v1,
			   const struct xx_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) xx_session_v1,
				     (void (**)(void)) listener, data);
}

#define XX_SESSION_V1_DESTROY 0
#define XX_SESSION_V1_REMOVE 1
#define XX_SESSION_V1_ADD_TOPLEVEL 2
#define XX_SESSION_V1_RESTORE_TOPLEVEL 3

/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_RESTORED_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_REPLACED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_REMOVE_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_ADD_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_xx_session_v1
 */
#define XX_SESSION_V1_RESTORE_TOPLEVEL_SINCE_VERSION 1

/** @ingroup iface_xx_session_v1 */
static inline void
xx_session_v1_set_user_data(struct xx_session_v1 *xx_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xx_session_v1, user_data);
}

/** @ingroup iface_xx_session_v1 */
static inline void *
xx_session_v1_get_user_data(struct xx_session_v1 *xx_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xx_session_v1);
}

static inline uint32_t
xx_session_v1_get_version(struct xx_session_v1 *xx_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xx_session_v1);
}

/**
 * @ingroup iface_xx_session_v1
 *
 * Destroy a session object, preserving the current state but not continuing
 * to make further updates if state changes occur. This makes the associated
 * xx_toplevel_session_v1 objects inert.
 */
static inline void
xx_session_v1_destroy(struct xx_session_v1 *xx_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xx_session_v1,
			 XX_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xx_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xx_session_v1
 *
 * Remove the session, making it no longer available for restoration. A
 * compositor should in response to this request remove the data related to
 * this session from its storage.
 */
static inline void
xx_session_v1_remove(struct xx_session_v1 *xx_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xx_session_v1,
			 XX_SESSION_V1_REMOVE, NULL, wl_proxy_get_version((struct wl_proxy *) xx_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xx_session_v1
 *
 * Attempt to add a given surface to the session. The passed name is used
 * to identify what window is being restored, and may be used store window
 * specific state within the session.
 *
 * Calling this with a toplevel that is already managed by the session with
 * the same associated will raise an in_use error.
 */
static inline struct xx_toplevel_session_v1 *
xx_session_v1_add_toplevel(struct xx_session_v1 *xx_session_v1, struct xdg_toplevel *toplevel, const char *name)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) xx_session_v1,
			 XX_SESSION_V1_ADD_TOPLEVEL, &xx_toplevel_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) xx_session_v1), 0, NULL, toplevel, name);

	return (struct xx_toplevel_session_v1 *) id;
}

/**
 * @ingroup iface_xx_session_v1
 *
 * Inform the compositor that the toplevel associated with the passed name
 * should have its window management state restored.
 *
 * Calling this with a toplevel that is already managed by the session with
 * the same associated will raise an in_use error.
 *
 * This request must be called prior to the first commit on the associated
 * wl_surface, otherwise an already_mapped error is raised.
 *
 * As part of the initial configure sequence, if the toplevel was
 * successfully restored, a xx_toplevel_session_v1.restored event is
 * emitted. See the xx_toplevel_session_v1.restored event for further
 * details.
 */
static inline struct xx_toplevel_session_v1 *
xx_session_v1_restore_toplevel(struct xx_session_v1 *xx_session_v1, struct xdg_toplevel *toplevel, const char *name)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) xx_session_v1,
			 XX_SESSION_V1_RESTORE_TOPLEVEL, &xx_toplevel_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) xx_session_v1), 0, NULL, toplevel, name);

	return (struct xx_toplevel_session_v1 *) id;
}

/**
 * @ingroup iface_xx_toplevel_session_v1
 * @struct xx_toplevel_session_v1_listener
 */
struct xx_toplevel_session_v1_listener {
	/**
	 * a toplevel's session has been restored
	 *
	 * The "restored" event is emitted prior to the first
	 * xdg_toplevel.configure for the toplevel. It will only be emitted
	 * after xx_session_v1.restore_toplevel, and the initial empty
	 * surface state has been applied, and it indicates that the
	 * surface's session is being restored with this configure event.
	 */
	void (*restored)(void *data,
			 struct xx_toplevel_session_v1 *xx_toplevel_session_v1,
			 struct xdg_toplevel *surface);
};

/**
 * @ingroup iface_xx_toplevel_session_v1
 */
static inline int
xx_toplevel_session_v1_add_listener(struct xx_toplevel_session_v1 *xx_toplevel_session_v1,
				    const struct xx_toplevel_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) xx_toplevel_session_v1,
				     (void (**)(void)) listener, data);
}

#define XX_TOPLEVEL_SESSION_V1_DESTROY 0
#define XX_TOPLEVEL_SESSION_V1_REMOVE 1

/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_RESTORED_SINCE_VERSION 1

/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xx_toplevel_session_v1
 */
#define XX_TOPLEVEL_SESSION_V1_REMOVE_SINCE_VERSION 1

/** @ingroup iface_xx_toplevel_session_v1 */
static inline void
xx_toplevel_session_v1_set_user_data(struct xx_toplevel_session_v1 *xx_toplevel_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xx_toplevel_session_v1, user_data);
}

/** @ingroup iface_xx_toplevel_session_v1 */
static inline void *
xx_toplevel_session_v1_get_user_data(struct xx_toplevel_session_v1 *xx_toplevel_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xx_toplevel_session_v1);
}

static inline uint32_t
xx_toplevel_session_v1_get_version(struct xx_toplevel_session_v1 *xx_toplevel_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xx_toplevel_session_v1);
}

/**
 * @ingroup iface_xx_toplevel_session_v1
 *
 * Destroy the object. This has no effect window management of the
 * associated toplevel.
 */
static inline void
xx_toplevel_session_v1_destroy(struct xx_toplevel_session_v1 *xx_toplevel_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xx_toplevel_session_v1,
			 XX_TOPLEVEL_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xx_toplevel_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xx_toplevel_session_v1
 *
 * Remove a specified surface from the session and render any corresponding
 * xx_toplevel_session_v1 object inert. The compositor should remove any
 * data related to the toplevel in the corresponding session from its internal
 * storage.
 */
static inline void
xx_toplevel_session_v1_remove(struct xx_toplevel_session_v1 *xx_toplevel_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xx_toplevel_session_v1,
			 XX_TOPLEVEL_SESSION_V1_REMOVE, NULL, wl_proxy_get_version((struct wl_proxy *) xx_toplevel_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
