/* puzzle-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2010-2013 Robert Ancell
   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define PUZZLE_VIEW_minimum_size 80
#define PUZZLE_VIEW_animation_duration 0.25
#define PUZZLE_VIEW_final_animation_duration ((guint) 250)
#define PUZZLE_VIEW_half_animation_duration 0.15
#define PUZZLE_VIEW_gap_factor 0.5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
enum  {
	THEME_0_PROPERTY,
	THEME_OVERDRAW_TOP_PROPERTY,
	THEME_OVERDRAW_LEFT_PROPERTY,
	THEME_OVERDRAW_RIGHT_PROPERTY,
	THEME_OVERDRAW_BOTTOM_PROPERTY,
	THEME_NUM_PROPERTIES
};
static GParamSpec* theme_properties[THEME_NUM_PROPERTIES];

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;

#define PUZZLE_VIEW_TYPE_TILE_IMAGE (puzzle_view_tile_image_get_type ())
#define PUZZLE_VIEW_TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage))
#define PUZZLE_VIEW_TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImageClass))
#define PUZZLE_VIEW_IS_TILE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUZZLE_VIEW_TYPE_TILE_IMAGE))
#define PUZZLE_VIEW_IS_TILE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUZZLE_VIEW_TYPE_TILE_IMAGE))
#define PUZZLE_VIEW_TILE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImageClass))

typedef struct _PuzzleViewTileImage PuzzleViewTileImage;
typedef struct _PuzzleViewTileImageClass PuzzleViewTileImageClass;
enum  {
	PUZZLE_VIEW_0_PROPERTY,
	PUZZLE_VIEW_PUZZLE_PROPERTY,
	PUZZLE_VIEW_THEME_ID_PROPERTY,
	PUZZLE_VIEW_TILE_SELECTED_PROPERTY,
	PUZZLE_VIEW_BOARDSIZE_PROPERTY,
	PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY,
	PUZZLE_VIEW_Y_OFFSET_PROPERTY,
	PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY,
	PUZZLE_VIEW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY,
	PUZZLE_VIEW_MOUSE_BACK_BUTTON_PROPERTY,
	PUZZLE_VIEW_MOUSE_FORWARD_BUTTON_PROPERTY,
	PUZZLE_VIEW_NUM_PROPERTIES
};
static GParamSpec* puzzle_view_properties[PUZZLE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _PuzzleViewTileImagePrivate PuzzleViewTileImagePrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NEO_RETRO_THEME (neo_retro_theme_get_type ())
#define NEO_RETRO_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEO_RETRO_THEME, NeoRetroTheme))
#define NEO_RETRO_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEO_RETRO_THEME, NeoRetroThemeClass))
#define IS_NEO_RETRO_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEO_RETRO_THEME))
#define IS_NEO_RETRO_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEO_RETRO_THEME))
#define NEO_RETRO_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEO_RETRO_THEME, NeoRetroThemeClass))

typedef struct _NeoRetroTheme NeoRetroTheme;
typedef struct _NeoRetroThemeClass NeoRetroThemeClass;

#define TYPE_NOSTALGIA_THEME (nostalgia_theme_get_type ())
#define NOSTALGIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOSTALGIA_THEME, NostalgiaTheme))
#define NOSTALGIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOSTALGIA_THEME, NostalgiaThemeClass))
#define IS_NOSTALGIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOSTALGIA_THEME))
#define IS_NOSTALGIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOSTALGIA_THEME))
#define NOSTALGIA_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOSTALGIA_THEME, NostalgiaThemeClass))

typedef struct _NostalgiaTheme NostalgiaTheme;
typedef struct _NostalgiaThemeClass NostalgiaThemeClass;

#define TYPE_SYNESTHESIA_THEME (synesthesia_theme_get_type ())
#define SYNESTHESIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYNESTHESIA_THEME, SynesthesiaTheme))
#define SYNESTHESIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYNESTHESIA_THEME, SynesthesiaThemeClass))
#define IS_SYNESTHESIA_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYNESTHESIA_THEME))
#define IS_SYNESTHESIA_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYNESTHESIA_THEME))
#define SYNESTHESIA_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYNESTHESIA_THEME, SynesthesiaThemeClass))

typedef struct _SynesthesiaTheme SynesthesiaTheme;
typedef struct _SynesthesiaThemeClass SynesthesiaThemeClass;

#define TYPE_EXTRUSION_THEME (extrusion_theme_get_type ())
#define EXTRUSION_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTRUSION_THEME, ExtrusionTheme))
#define EXTRUSION_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTRUSION_THEME, ExtrusionThemeClass))
#define IS_EXTRUSION_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTRUSION_THEME))
#define IS_EXTRUSION_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTRUSION_THEME))
#define EXTRUSION_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTRUSION_THEME, ExtrusionThemeClass))

typedef struct _ExtrusionTheme ExtrusionTheme;
typedef struct _ExtrusionThemeClass ExtrusionThemeClass;
enum  {
	PUZZLE_VIEW_TILE_IMAGE_0_PROPERTY,
	PUZZLE_VIEW_TILE_IMAGE_NUM_PROPERTIES
};
static GParamSpec* puzzle_view_tile_image_properties[PUZZLE_VIEW_TILE_IMAGE_NUM_PROPERTIES];

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GObjectClass parent_class;
	void (*configure) (Theme* self, guint size);
	void (*draw_arrow) (Theme* self, cairo_t* context);
	void (*draw_socket) (Theme* self, cairo_t* context);
	void (*draw_highlight) (Theme* self, cairo_t* context, gboolean has_tile);
	void (*draw_paused_tile) (Theme* self, cairo_t* context);
	void (*draw_tile) (Theme* self, cairo_t* context, Tile* tile, gboolean highlight);
	void (*set_animation_level) (Theme* self, guint8 animation_level);
};

struct _ThemePrivate {
	gint _overdraw_top;
	gint _overdraw_left;
	gint _overdraw_right;
	gint _overdraw_bottom;
};

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	Puzzle* _puzzle;
	gboolean puzzle_init_done;
	Theme* theme;
	PuzzleViewTileImage* selected_tile;
	PuzzleViewTileImage* last_selected_tile;
	gboolean _tile_selected;
	guint selection_timeout;
	gdouble selected_x_offset;
	gdouble selected_y_offset;
	GHashTable* tiles;
	GTimer* animation_timer;
	guint animation_timeout;
	guint _boardsize;
	gdouble _x_offset_right;
	gdouble _y_offset;
	gdouble _right_margin;
	gdouble x_offset;
	guint tilesize;
	guint gap;
	gdouble arrow_x;
	gdouble arrow_local_y;
	gdouble* sockets_xs;
	gint sockets_xs_length1;
	gint sockets_xs_length2;
	gdouble* sockets_ys;
	gint sockets_ys_length1;
	gint sockets_ys_length2;
	gint board_x_maxi;
	gint board_y_maxi;
	gdouble snap_distance;
	guint render_size;
	cairo_pattern_t* arrow_pattern;
	cairo_pattern_t* socket_pattern;
	GtkEventControllerMotion* motion_controller;
	GtkGestureMultiPress* click_controller;
	gboolean _mouse_use_extra_buttons;
	gint _mouse_back_button;
	gint _mouse_forward_button;
	guint8 socket_animation_level;
	guint socket_timeout_id;
	GtkEventControllerKey* key_controller;
	gboolean show_highlight;
	gboolean highlight_set;
	guint8 highlight_x;
	guint8 highlight_y;
	guint8 old_highlight_x;
	guint8 old_highlight_y;
	gboolean tile_selection;
	guint8 kbd_selected_x;
	guint8 kbd_selected_y;
};

struct _PuzzleViewTileImage {
	GObject parent_instance;
	PuzzleViewTileImagePrivate * priv;
	Tile* tile;
	gdouble x;
	gdouble y;
	gdouble source_x;
	gdouble source_y;
	gdouble source_time;
	gdouble target_x;
	gdouble target_y;
	gdouble duration;
	gboolean snap_to_cursor;
};

struct _PuzzleViewTileImageClass {
	GObjectClass parent_class;
};

static gint Theme_private_offset;
static gpointer theme_parent_class = NULL;
static gint PuzzleView_private_offset;
static gpointer puzzle_view_parent_class = NULL;
static gpointer puzzle_view_tile_image_parent_class = NULL;

VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN void theme_configure (Theme* self,
                      guint size);
VALA_EXTERN void theme_draw_arrow (Theme* self,
                       cairo_t* context);
VALA_EXTERN void theme_draw_socket (Theme* self,
                        cairo_t* context);
VALA_EXTERN void theme_draw_highlight (Theme* self,
                           cairo_t* context,
                           gboolean has_tile);
VALA_EXTERN void theme_draw_paused_tile (Theme* self,
                             cairo_t* context);
VALA_EXTERN void theme_draw_tile (Theme* self,
                      cairo_t* context,
                      Tile* tile,
                      gboolean highlight);
VALA_EXTERN void theme_set_animation_level (Theme* self,
                                guint8 animation_level);
static void theme_real_configure (Theme* self,
                           guint size);
static void theme_real_draw_arrow (Theme* self,
                            cairo_t* context);
static void theme_real_draw_socket (Theme* self,
                             cairo_t* context);
static void theme_real_draw_highlight (Theme* self,
                                cairo_t* context,
                                gboolean has_tile);
static void theme_real_draw_paused_tile (Theme* self,
                                  cairo_t* context);
static void theme_real_draw_tile (Theme* self,
                           cairo_t* context,
                           Tile* tile,
                           gboolean highlight);
static void theme_real_set_animation_level (Theme* self,
                                     guint8 animation_level);
VALA_EXTERN Theme* theme_construct (GType object_type);
VALA_EXTERN gint theme_get_overdraw_top (Theme* self);
VALA_EXTERN void theme_set_overdraw_top (Theme* self,
                             gint value);
VALA_EXTERN gint theme_get_overdraw_left (Theme* self);
VALA_EXTERN void theme_set_overdraw_left (Theme* self,
                              gint value);
VALA_EXTERN gint theme_get_overdraw_right (Theme* self);
VALA_EXTERN void theme_set_overdraw_right (Theme* self,
                               gint value);
VALA_EXTERN gint theme_get_overdraw_bottom (Theme* self);
VALA_EXTERN void theme_set_overdraw_bottom (Theme* self,
                                gint value);
static void theme_finalize (GObject * obj);
static GType theme_get_type_once (void);
static void _vala_theme_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_theme_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
VALA_EXTERN GType puzzle_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleView, g_object_unref)
VALA_EXTERN GType puzzle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Puzzle, g_object_unref)
static GType puzzle_view_tile_image_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleViewTileImage, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static void puzzle_view_redraw_tile (PuzzleView* self,
                              PuzzleViewTileImage* image);
static void puzzle_view_queue_draw_tile (PuzzleView* self,
                                  guint8 x,
                                  guint8 y);
static void puzzle_view_move_tile_to_location (PuzzleView* self,
                                        PuzzleViewTileImage* image,
                                        guint x,
                                        guint y,
                                        gdouble duration);
static Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
VALA_EXTERN guint8 puzzle_get_size (Puzzle* self);
VALA_EXTERN gdouble puzzle_view_get_y_offset (PuzzleView* self);
static void puzzle_view_move_tile (PuzzleView* self,
                            PuzzleViewTileImage* image,
                            gdouble x,
                            gdouble y,
                            gdouble duration);
static gboolean puzzle_view_animate_cb (PuzzleView* self);
static gboolean _puzzle_view_animate_cb_gsource_func (gpointer self);
static void puzzle_view_real_get_preferred_width (GtkWidget* base,
                                           gint* minimum,
                                           gint* natural);
static void puzzle_view_real_get_preferred_height (GtkWidget* base,
                                            gint* minimum,
                                            gint* natural);
static void puzzle_view_tile_moved_cb (PuzzleView* self,
                                Puzzle* puzzle,
                                Tile* tile,
                                guint8 x,
                                guint8 y);
static gboolean puzzle_view_real_configure_event (GtkWidget* base,
                                           GdkEventConfigure* event);
static void puzzle_view_set_boardsize (PuzzleView* self,
                                guint value);
VALA_EXTERN guint puzzle_view_get_boardsize (PuzzleView* self);
static void puzzle_view_set_y_offset (PuzzleView* self,
                               gdouble value);
static void puzzle_view_set_x_offset_right (PuzzleView* self,
                                     gdouble value);
VALA_EXTERN gdouble puzzle_view_get_x_offset_right (PuzzleView* self);
static void puzzle_view_set_right_margin (PuzzleView* self,
                                   gdouble value);
VALA_EXTERN void puzzle_get_tile_location (Puzzle* self,
                               Tile* tile,
                               guint8* x,
                               guint8* y);
static void puzzle_view_set_tile_selected (PuzzleView* self,
                                    gboolean value);
static inline void puzzle_view_init_patterns (PuzzleView* self,
                                cairo_t* context);
static gboolean puzzle_view_real_draw (GtkWidget* base,
                                cairo_t* context);
static void puzzle_view_draw_image (PuzzleView* self,
                             cairo_t* context,
                             PuzzleViewTileImage* image);
VALA_EXTERN gboolean puzzle_get_is_solved (Puzzle* self);
VALA_EXTERN Tile* puzzle_get_tile (Puzzle* self,
                       guint8 x,
                       guint8 y);
VALA_EXTERN gboolean puzzle_get_paused (Puzzle* self);
static inline void puzzle_view_draw_pause_overlay (PuzzleView* self,
                                     cairo_t* context);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void puzzle_view_pick_tile (PuzzleView* self,
                            gdouble x,
                            gdouble y);
static gboolean puzzle_view_selection_timeout_cb (PuzzleView* self);
static gboolean _puzzle_view_selection_timeout_cb_gsource_func (gpointer self);
VALA_EXTERN gboolean puzzle_view_get_tile_selected (PuzzleView* self);
static inline gboolean puzzle_view_get_tile_coords (PuzzleView* self,
                                      gdouble event_x,
                                      gdouble event_y,
                                      guint8* tile_x,
                                      guint8* tile_y);
VALA_EXTERN void puzzle_try_move (Puzzle* self,
                      guint8 x,
                      guint8 y);
static inline gboolean puzzle_view_get_tile_coord_x (PuzzleView* self,
                                       gdouble event_x,
                                       guint8* tile_x);
static inline gboolean puzzle_view_get_tile_coord_y (PuzzleView* self,
                                       gdouble event_y,
                                       guint8* tile_y);
static gboolean puzzle_view_on_right_half (PuzzleView* self,
                                    gdouble x);
static void puzzle_view_drop_tile (PuzzleView* self,
                            gdouble x,
                            gdouble y);
VALA_EXTERN gboolean puzzle_can_switch (Puzzle* self,
                            guint8 x0,
                            guint8 y0,
                            guint8 x1,
                            guint8 y1);
VALA_EXTERN void puzzle_switch_tiles (Puzzle* self,
                          guint8 x0,
                          guint8 y0,
                          guint8 x1,
                          guint8 y1,
                          guint delay_if_finished);
static void puzzle_view_move_tile_to_right_half (PuzzleView* self,
                                          Tile* tile);
static void puzzle_view_init_mouse (PuzzleView* self);
static inline void puzzle_view_on_motion (PuzzleView* self,
                            GtkEventControllerMotion* _motion_controller,
                            gdouble event_x,
                            gdouble event_y);
static void _puzzle_view_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static inline void puzzle_view_on_click (PuzzleView* self,
                           GtkGestureMultiPress* _click_controller,
                           gint n_press,
                           gdouble event_x,
                           gdouble event_y);
static void _puzzle_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                            gint n_press,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self);
static inline void puzzle_view_on_release (PuzzleView* self,
                             GtkGestureMultiPress* _click_controller,
                             gint n_press,
                             gdouble event_x,
                             gdouble event_y);
static void _puzzle_view_on_release_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                               gint n_press,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self);
static void puzzle_view_clear_keyboard_highlight (PuzzleView* self,
                                           gboolean only_selection);
static inline void puzzle_view_main_button_pressed (PuzzleView* self,
                                      gint n_press,
                                      gdouble event_x,
                                      gdouble event_y);
static gboolean puzzle_view_get_mouse_use_extra_buttons (PuzzleView* self);
static gint puzzle_view_get_mouse_back_button (PuzzleView* self);
VALA_EXTERN void puzzle_view_undo (PuzzleView* self);
static gint puzzle_view_get_mouse_forward_button (PuzzleView* self);
VALA_EXTERN void puzzle_view_redo (PuzzleView* self);
VALA_EXTERN gboolean puzzle_only_one_remaining_tile (Puzzle* self,
                                         guint8* empty_x,
                                         guint8* empty_y);
static gboolean puzzle_view_real_leave_notify_event (GtkWidget* base,
                                              GdkEventCrossing* event);
static gboolean puzzle_view_real_enter_notify_event (GtkWidget* base,
                                              GdkEventCrossing* event);
VALA_EXTERN void puzzle_view_finish (PuzzleView* self);
VALA_EXTERN void puzzle_finish (Puzzle* self,
                    guint duration);
VALA_EXTERN void puzzle_view_release_selected_tile (PuzzleView* self);
VALA_EXTERN void puzzle_undo (Puzzle* self);
VALA_EXTERN void puzzle_redo (Puzzle* self);
VALA_EXTERN void puzzle_view_reload (PuzzleView* self);
VALA_EXTERN void puzzle_reload (Puzzle* self);
VALA_EXTERN void puzzle_view_hide_right_sockets (PuzzleView* self);
static gboolean __lambda6_ (PuzzleView* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static inline void puzzle_view_show_right_sockets (PuzzleView* self);
static void puzzle_view_init_keyboard (PuzzleView* self);
static inline gboolean puzzle_view_on_key_pressed (PuzzleView* self,
                                     GtkEventControllerKey* _key_controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType state);
static gboolean _puzzle_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
static void puzzle_view_set_highlight_position_if_needed (PuzzleView* self);
static void puzzle_view_set_highlight_position (PuzzleView* self);
VALA_EXTERN void puzzle_view_disable_highlight (PuzzleView* self);
VALA_EXTERN void puzzle_view_move_up (PuzzleView* self,
                          gboolean left_board);
VALA_EXTERN gboolean puzzle_move_up (Puzzle* self,
                         gboolean left_board);
VALA_EXTERN void puzzle_view_move_down (PuzzleView* self,
                            gboolean left_board);
VALA_EXTERN gboolean puzzle_move_down (Puzzle* self,
                           gboolean left_board);
VALA_EXTERN void puzzle_view_move_left (PuzzleView* self,
                            gboolean left_board);
VALA_EXTERN gboolean puzzle_move_left (Puzzle* self,
                           gboolean left_board);
VALA_EXTERN void puzzle_view_move_right (PuzzleView* self,
                             gboolean left_board);
VALA_EXTERN gboolean puzzle_move_right (Puzzle* self,
                            gboolean left_board);
VALA_EXTERN PuzzleView* puzzle_view_new (void);
VALA_EXTERN PuzzleView* puzzle_view_construct (GType object_type);
VALA_EXTERN void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
static PuzzleViewTileImage* puzzle_view_tile_image_new (Tile* tile);
static PuzzleViewTileImage* puzzle_view_tile_image_construct (GType object_type,
                                                       Tile* tile);
static void _puzzle_view_puzzle___lambda5_ (PuzzleView* self);
static void __puzzle_view_puzzle___lambda5__puzzle_solved (Puzzle* _sender,
                                                    gpointer self);
static void _puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender,
                                                   Tile* tile,
                                                   guint8 x,
                                                   guint8 y,
                                                   gpointer self);
static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self);
VALA_EXTERN void puzzle_view_set_theme_id (PuzzleView* self,
                               const gchar* value);
VALA_EXTERN NeoRetroTheme* neo_retro_theme_new (void);
VALA_EXTERN NeoRetroTheme* neo_retro_theme_construct (GType object_type);
VALA_EXTERN GType neo_retro_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NeoRetroTheme, g_object_unref)
VALA_EXTERN NostalgiaTheme* nostalgia_theme_new (void);
VALA_EXTERN NostalgiaTheme* nostalgia_theme_construct (GType object_type);
VALA_EXTERN GType nostalgia_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NostalgiaTheme, g_object_unref)
VALA_EXTERN SynesthesiaTheme* synesthesia_theme_new (void);
VALA_EXTERN SynesthesiaTheme* synesthesia_theme_construct (GType object_type);
VALA_EXTERN GType synesthesia_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SynesthesiaTheme, g_object_unref)
VALA_EXTERN ExtrusionTheme* extrusion_theme_new (void);
VALA_EXTERN ExtrusionTheme* extrusion_theme_construct (GType object_type);
VALA_EXTERN GType extrusion_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExtrusionTheme, g_object_unref)
VALA_EXTERN gdouble puzzle_view_get_right_margin (PuzzleView* self);
VALA_EXTERN void puzzle_view_set_mouse_use_extra_buttons (PuzzleView* self,
                                              gboolean value);
VALA_EXTERN void puzzle_view_set_mouse_back_button (PuzzleView* self,
                                        gint value);
VALA_EXTERN void puzzle_view_set_mouse_forward_button (PuzzleView* self,
                                           gint value);
static void puzzle_view_tile_image_finalize (GObject * obj);
static GType puzzle_view_tile_image_get_type_once (void);
static GObject * puzzle_view_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void puzzle_view_finalize (GObject * obj);
static GType puzzle_view_get_type_once (void);
static void _vala_puzzle_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
theme_get_instance_private (Theme* self)
{
	return G_STRUCT_MEMBER_P (self, Theme_private_offset);
}

static void
theme_real_configure (Theme* self,
                      guint size)
{
	g_critical ("Type `%s' does not implement abstract method `theme_configure'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_configure (Theme* self,
                 guint size)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->configure) {
		_klass_->configure (self, size);
	}
}

static void
theme_real_draw_arrow (Theme* self,
                       cairo_t* context)
{
	g_critical ("Type `%s' does not implement abstract method `theme_draw_arrow'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_draw_arrow (Theme* self,
                  cairo_t* context)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->draw_arrow) {
		_klass_->draw_arrow (self, context);
	}
}

static void
theme_real_draw_socket (Theme* self,
                        cairo_t* context)
{
	g_critical ("Type `%s' does not implement abstract method `theme_draw_socket'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_draw_socket (Theme* self,
                   cairo_t* context)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->draw_socket) {
		_klass_->draw_socket (self, context);
	}
}

static void
theme_real_draw_highlight (Theme* self,
                           cairo_t* context,
                           gboolean has_tile)
{
	g_critical ("Type `%s' does not implement abstract method `theme_draw_highlight'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_draw_highlight (Theme* self,
                      cairo_t* context,
                      gboolean has_tile)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->draw_highlight) {
		_klass_->draw_highlight (self, context, has_tile);
	}
}

static void
theme_real_draw_paused_tile (Theme* self,
                             cairo_t* context)
{
	g_critical ("Type `%s' does not implement abstract method `theme_draw_paused_tile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_draw_paused_tile (Theme* self,
                        cairo_t* context)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->draw_paused_tile) {
		_klass_->draw_paused_tile (self, context);
	}
}

static void
theme_real_draw_tile (Theme* self,
                      cairo_t* context,
                      Tile* tile,
                      gboolean highlight)
{
	g_critical ("Type `%s' does not implement abstract method `theme_draw_tile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_draw_tile (Theme* self,
                 cairo_t* context,
                 Tile* tile,
                 gboolean highlight)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->draw_tile) {
		_klass_->draw_tile (self, context, tile, highlight);
	}
}

static void
theme_real_set_animation_level (Theme* self,
                                guint8 animation_level)
{
	g_critical ("Type `%s' does not implement abstract method `theme_set_animation_level'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
theme_set_animation_level (Theme* self,
                           guint8 animation_level)
{
	ThemeClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = THEME_GET_CLASS (self);
	if (_klass_->set_animation_level) {
		_klass_->set_animation_level (self, animation_level);
	}
}

Theme*
theme_construct (GType object_type)
{
	Theme * self = NULL;
	self = (Theme*) g_object_new (object_type, NULL);
	return self;
}

gint
theme_get_overdraw_top (Theme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_overdraw_top;
	return result;
}

void
theme_set_overdraw_top (Theme* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_overdraw_top (self);
	if (old_value != value) {
		self->priv->_overdraw_top = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_OVERDRAW_TOP_PROPERTY]);
	}
}

gint
theme_get_overdraw_left (Theme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_overdraw_left;
	return result;
}

void
theme_set_overdraw_left (Theme* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_overdraw_left (self);
	if (old_value != value) {
		self->priv->_overdraw_left = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_OVERDRAW_LEFT_PROPERTY]);
	}
}

gint
theme_get_overdraw_right (Theme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_overdraw_right;
	return result;
}

void
theme_set_overdraw_right (Theme* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_overdraw_right (self);
	if (old_value != value) {
		self->priv->_overdraw_right = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_OVERDRAW_RIGHT_PROPERTY]);
	}
}

gint
theme_get_overdraw_bottom (Theme* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_overdraw_bottom;
	return result;
}

void
theme_set_overdraw_bottom (Theme* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = theme_get_overdraw_bottom (self);
	if (old_value != value) {
		self->priv->_overdraw_bottom = value;
		g_object_notify_by_pspec ((GObject *) self, theme_properties[THEME_OVERDRAW_BOTTOM_PROPERTY]);
	}
}

static void
theme_class_init (ThemeClass * klass,
                  gpointer klass_data)
{
	theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Theme_private_offset);
	((ThemeClass *) klass)->configure = (void (*) (Theme*, guint)) theme_real_configure;
	((ThemeClass *) klass)->draw_arrow = (void (*) (Theme*, cairo_t*)) theme_real_draw_arrow;
	((ThemeClass *) klass)->draw_socket = (void (*) (Theme*, cairo_t*)) theme_real_draw_socket;
	((ThemeClass *) klass)->draw_highlight = (void (*) (Theme*, cairo_t*, gboolean)) theme_real_draw_highlight;
	((ThemeClass *) klass)->draw_paused_tile = (void (*) (Theme*, cairo_t*)) theme_real_draw_paused_tile;
	((ThemeClass *) klass)->draw_tile = (void (*) (Theme*, cairo_t*, Tile*, gboolean)) theme_real_draw_tile;
	((ThemeClass *) klass)->set_animation_level = (void (*) (Theme*, guint8)) theme_real_set_animation_level;
	G_OBJECT_CLASS (klass)->get_property = _vala_theme_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_theme_set_property;
	G_OBJECT_CLASS (klass)->finalize = theme_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_OVERDRAW_TOP_PROPERTY, theme_properties[THEME_OVERDRAW_TOP_PROPERTY] = g_param_spec_int ("overdraw-top", "overdraw-top", "overdraw-top", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_OVERDRAW_LEFT_PROPERTY, theme_properties[THEME_OVERDRAW_LEFT_PROPERTY] = g_param_spec_int ("overdraw-left", "overdraw-left", "overdraw-left", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_OVERDRAW_RIGHT_PROPERTY, theme_properties[THEME_OVERDRAW_RIGHT_PROPERTY] = g_param_spec_int ("overdraw-right", "overdraw-right", "overdraw-right", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_OVERDRAW_BOTTOM_PROPERTY, theme_properties[THEME_OVERDRAW_BOTTOM_PROPERTY] = g_param_spec_int ("overdraw-bottom", "overdraw-bottom", "overdraw-bottom", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
theme_instance_init (Theme * self,
                     gpointer klass)
{
	self->priv = theme_get_instance_private (self);
	self->priv->_overdraw_top = 0;
	self->priv->_overdraw_left = 0;
	self->priv->_overdraw_right = 0;
	self->priv->_overdraw_bottom = 0;
}

static void
theme_finalize (GObject * obj)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	G_OBJECT_CLASS (theme_parent_class)->finalize (obj);
}

static GType
theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, NULL };
	GType theme_type_id;
	theme_type_id = g_type_register_static (G_TYPE_OBJECT, "Theme", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	Theme_private_offset = g_type_add_instance_private (theme_type_id, sizeof (ThemePrivate));
	return theme_type_id;
}

GType
theme_get_type (void)
{
	static volatile gsize theme_type_id__once = 0;
	if (g_once_init_enter (&theme_type_id__once)) {
		GType theme_type_id;
		theme_type_id = theme_get_type_once ();
		g_once_init_leave (&theme_type_id__once, theme_type_id);
	}
	return theme_type_id__once;
}

static void
_vala_theme_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME, Theme);
	switch (property_id) {
		case THEME_OVERDRAW_TOP_PROPERTY:
		g_value_set_int (value, theme_get_overdraw_top (self));
		break;
		case THEME_OVERDRAW_LEFT_PROPERTY:
		g_value_set_int (value, theme_get_overdraw_left (self));
		break;
		case THEME_OVERDRAW_RIGHT_PROPERTY:
		g_value_set_int (value, theme_get_overdraw_right (self));
		break;
		case THEME_OVERDRAW_BOTTOM_PROPERTY:
		g_value_set_int (value, theme_get_overdraw_bottom (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_theme_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME, Theme);
	switch (property_id) {
		case THEME_OVERDRAW_TOP_PROPERTY:
		theme_set_overdraw_top (self, g_value_get_int (value));
		break;
		case THEME_OVERDRAW_LEFT_PROPERTY:
		theme_set_overdraw_left (self, g_value_get_int (value));
		break;
		case THEME_OVERDRAW_RIGHT_PROPERTY:
		theme_set_overdraw_right (self, g_value_get_int (value));
		break;
		case THEME_OVERDRAW_BOTTOM_PROPERTY:
		theme_set_overdraw_bottom (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
puzzle_view_get_instance_private (PuzzleView* self)
{
	return G_STRUCT_MEMBER_P (self, PuzzleView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
puzzle_view_redraw_tile (PuzzleView* self,
                         PuzzleViewTileImage* image)
{
	Theme* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Theme* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Theme* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Theme* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	Theme* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	Theme* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = self->priv->theme;
	_tmp1_ = theme_get_overdraw_left (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->theme;
	_tmp4_ = theme_get_overdraw_top (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->theme;
	_tmp7_ = theme_get_overdraw_left (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->theme;
	_tmp10_ = theme_get_overdraw_right (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->theme;
	_tmp13_ = theme_get_overdraw_top (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->theme;
	_tmp16_ = theme_get_overdraw_bottom (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, ((gint) image->x) - _tmp2_, ((gint) image->y) - _tmp5_, (((gint) self->priv->tilesize) + _tmp8_) + _tmp11_, (((gint) self->priv->tilesize) + _tmp14_) + _tmp17_);
}

static void
puzzle_view_queue_draw_tile (PuzzleView* self,
                             guint8 x,
                             guint8 y)
{
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gdouble _tmp1_;
	Theme* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gdouble _tmp6_;
	Theme* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Theme* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Theme* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	Theme* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	Theme* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sockets_xs;
	_tmp0__length1 = self->priv->sockets_xs_length1;
	_tmp0__length2 = self->priv->sockets_xs_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	_tmp2_ = self->priv->theme;
	_tmp3_ = theme_get_overdraw_left (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->sockets_ys;
	_tmp5__length1 = self->priv->sockets_ys_length1;
	_tmp5__length2 = self->priv->sockets_ys_length2;
	_tmp6_ = _tmp5_[(x * _tmp5__length2) + y];
	_tmp7_ = self->priv->theme;
	_tmp8_ = theme_get_overdraw_top (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->theme;
	_tmp11_ = theme_get_overdraw_left (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->theme;
	_tmp14_ = theme_get_overdraw_right (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->theme;
	_tmp17_ = theme_get_overdraw_top (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->theme;
	_tmp20_ = theme_get_overdraw_bottom (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, ((gint) _tmp1_) - _tmp4_, ((gint) _tmp6_) - _tmp9_, (((gint) self->priv->tilesize) + _tmp12_) + _tmp15_, (((gint) self->priv->tilesize) + _tmp18_) + _tmp21_);
}

static void
puzzle_view_move_tile_to_location (PuzzleView* self,
                                   PuzzleViewTileImage* image,
                                   guint x,
                                   guint y,
                                   gdouble duration)
{
	gdouble target_x = 0.0;
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	gdouble target_y = 0.0;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	target_x = self->priv->x_offset + ((gdouble) (x * self->priv->tilesize));
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (x >= ((guint) _tmp3_)) {
		target_x += (gdouble) self->priv->gap;
	}
	_tmp4_ = self->priv->_y_offset;
	target_y = _tmp4_ + ((gdouble) (y * self->priv->tilesize));
	puzzle_view_move_tile (self, image, target_x, target_y, duration);
}

static gboolean
_puzzle_view_animate_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = puzzle_view_animate_cb ((PuzzleView*) self);
	return result;
}

static void
puzzle_view_move_tile (PuzzleView* self,
                       PuzzleViewTileImage* image,
                       gdouble x,
                       gdouble y,
                       gdouble duration)
{
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	if (image->x == x) {
		_tmp0_ = image->y == y;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	image->source_x = image->x;
	image->source_y = image->y;
	_tmp1_ = self->priv->animation_timer;
	image->source_time = g_timer_elapsed (_tmp1_, NULL);
	image->target_x = x;
	image->target_y = y;
	image->duration = duration;
	if (duration == ((gdouble) 0)) {
		puzzle_view_redraw_tile (self, image);
		image->x = image->target_x;
		image->y = image->target_y;
		image->snap_to_cursor = TRUE;
		puzzle_view_redraw_tile (self, image);
		return;
	}
	if (self->priv->animation_timeout == ((guint) 0)) {
		self->priv->animation_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, _puzzle_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
puzzle_view_animate_cb (PuzzleView* self)
{
	gdouble t = 0.0;
	GTimer* _tmp0_;
	gboolean animating = FALSE;
	GHashTableIter iter = {0};
	GHashTable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->animation_timer;
	t = g_timer_elapsed (_tmp0_, NULL);
	animating = FALSE;
	_tmp1_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp1_);
	while (TRUE) {
		Tile* tile = NULL;
		PuzzleViewTileImage* image = NULL;
		gconstpointer _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		gboolean _tmp4_;
		Tile* _tmp5_;
		PuzzleViewTileImage* _tmp6_;
		gboolean _tmp7_ = FALSE;
		PuzzleViewTileImage* _tmp8_;
		PuzzleViewTileImage* _tmp9_;
		PuzzleViewTileImage* _tmp12_;
		PuzzleViewTileImage* _tmp13_;
		PuzzleViewTileImage* _tmp14_;
		PuzzleViewTileImage* _tmp29_;
		PuzzleViewTileImage* _tmp35_;
		_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp2_), (gpointer*) (&_tmp3_));
		_g_object_unref0 (tile);
		_tmp5_ = _g_object_ref0 ((Tile*) _tmp2_);
		tile = _tmp5_;
		_g_object_unref0 (image);
		_tmp6_ = _g_object_ref0 ((PuzzleViewTileImage*) _tmp3_);
		image = _tmp6_;
		if (!_tmp4_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			break;
		}
		_tmp8_ = image;
		_tmp9_ = image;
		if (_tmp8_->x == _tmp9_->target_x) {
			PuzzleViewTileImage* _tmp10_;
			PuzzleViewTileImage* _tmp11_;
			_tmp10_ = image;
			_tmp11_ = image;
			_tmp7_ = _tmp10_->y == _tmp11_->target_y;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			continue;
		}
		_tmp12_ = image;
		puzzle_view_redraw_tile (self, _tmp12_);
		_tmp13_ = image;
		_tmp14_ = image;
		if (t >= (_tmp13_->source_time + _tmp14_->duration)) {
			PuzzleViewTileImage* _tmp15_;
			PuzzleViewTileImage* _tmp16_;
			PuzzleViewTileImage* _tmp17_;
			PuzzleViewTileImage* _tmp18_;
			_tmp15_ = image;
			_tmp16_ = image;
			_tmp15_->x = _tmp16_->target_x;
			_tmp17_ = image;
			_tmp18_ = image;
			_tmp17_->y = _tmp18_->target_y;
		} else {
			gdouble d = 0.0;
			PuzzleViewTileImage* _tmp19_;
			PuzzleViewTileImage* _tmp20_;
			PuzzleViewTileImage* _tmp21_;
			PuzzleViewTileImage* _tmp22_;
			PuzzleViewTileImage* _tmp23_;
			PuzzleViewTileImage* _tmp24_;
			PuzzleViewTileImage* _tmp25_;
			PuzzleViewTileImage* _tmp26_;
			PuzzleViewTileImage* _tmp27_;
			PuzzleViewTileImage* _tmp28_;
			_tmp19_ = image;
			_tmp20_ = image;
			d = (t - _tmp19_->source_time) / _tmp20_->duration;
			_tmp21_ = image;
			_tmp22_ = image;
			_tmp23_ = image;
			_tmp24_ = image;
			_tmp21_->x = _tmp22_->source_x + ((_tmp23_->target_x - _tmp24_->source_x) * d);
			_tmp25_ = image;
			_tmp26_ = image;
			_tmp27_ = image;
			_tmp28_ = image;
			_tmp25_->y = _tmp26_->source_y + ((_tmp27_->target_y - _tmp28_->source_y) * d);
			animating = TRUE;
		}
		_tmp29_ = image;
		if (!_tmp29_->snap_to_cursor) {
			gdouble distance = 0.0;
			PuzzleViewTileImage* _tmp30_;
			PuzzleViewTileImage* _tmp31_;
			PuzzleViewTileImage* _tmp32_;
			PuzzleViewTileImage* _tmp33_;
			_tmp30_ = image;
			_tmp31_ = image;
			_tmp32_ = image;
			_tmp33_ = image;
			distance = sqrt (pow (_tmp30_->x - _tmp31_->target_x, (gdouble) 2) + pow (_tmp32_->y - _tmp33_->target_y, (gdouble) 2));
			if (distance < self->priv->snap_distance) {
				PuzzleViewTileImage* _tmp34_;
				_tmp34_ = image;
				_tmp34_->snap_to_cursor = TRUE;
			}
		}
		_tmp35_ = image;
		puzzle_view_redraw_tile (self, _tmp35_);
		_g_object_unref0 (image);
		_g_object_unref0 (tile);
	}
	if (animating) {
		result = TRUE;
		return result;
	}
	self->priv->animation_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static void
puzzle_view_real_get_preferred_width (GtkWidget* base,
                                      gint* minimum,
                                      gint* natural)
{
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	self = (PuzzleView*) base;
	size = 0;
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp0_;
		Puzzle* _tmp1_;
		guint8 _tmp2_;
		guint8 _tmp3_;
		_tmp0_ = puzzle_view_get_puzzle (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = puzzle_get_size (_tmp1_);
		_tmp3_ = _tmp2_;
		size = (gint) ((((_tmp3_ * 2) + 1.0) + PUZZLE_VIEW_gap_factor) * PUZZLE_VIEW_minimum_size);
	}
	_vala_natural = MAX (size, 500);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}

static void
puzzle_view_real_get_preferred_height (GtkWidget* base,
                                       gint* minimum,
                                       gint* natural)
{
	PuzzleView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint size = 0;
	self = (PuzzleView*) base;
	size = 0;
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp0_;
		Puzzle* _tmp1_;
		guint8 _tmp2_;
		guint8 _tmp3_;
		_tmp0_ = puzzle_view_get_puzzle (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = puzzle_get_size (_tmp1_);
		_tmp3_ = _tmp2_;
		size = (gint) ((_tmp3_ + 1.0) * PUZZLE_VIEW_minimum_size);
	}
	_vala_natural = MAX (size, 300);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}

static void
puzzle_view_tile_moved_cb (PuzzleView* self,
                           Puzzle* puzzle,
                           Tile* tile,
                           guint8 x,
                           guint8 y)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (puzzle != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp1_ = g_hash_table_lookup (_tmp0_, tile);
	puzzle_view_move_tile_to_location (self, G_TYPE_CHECK_INSTANCE_CAST ((PuzzleViewTileImage*) _tmp1_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage), (guint) x, (guint) y, PUZZLE_VIEW_animation_duration);
}

static gboolean
puzzle_view_real_configure_event (GtkWidget* base,
                                  GdkEventConfigure* event)
{
	PuzzleView * self;
	GHashTableIter iter = {0};
	GHashTable* _tmp40_;
	PuzzleViewTileImage* _tmp52_;
	gboolean result;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->puzzle_init_done) {
		gint allocated_width = 0;
		gint allocated_height = 0;
		guint width = 0U;
		Puzzle* _tmp0_;
		Puzzle* _tmp1_;
		guint8 _tmp2_;
		guint8 _tmp3_;
		guint height = 0U;
		Puzzle* _tmp4_;
		Puzzle* _tmp5_;
		guint8 _tmp6_;
		guint8 _tmp7_;
		Puzzle* _tmp8_;
		Puzzle* _tmp9_;
		guint8 _tmp10_;
		guint8 _tmp11_;
		Theme* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		gdouble _tmp18_;
		guint _tmp19_;
		allocated_width = gtk_widget_get_allocated_width ((GtkWidget*) self);
		allocated_height = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp0_ = puzzle_view_get_puzzle (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = puzzle_get_size (_tmp1_);
		_tmp3_ = _tmp2_;
		width = (guint) (allocated_width / (((2 * _tmp3_) + 1.0) + PUZZLE_VIEW_gap_factor));
		_tmp4_ = puzzle_view_get_puzzle (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = puzzle_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		height = (guint) (allocated_height / (_tmp7_ + 1.0));
		self->priv->tilesize = MIN (width, height);
		_tmp8_ = puzzle_view_get_puzzle (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = puzzle_get_size (_tmp9_);
		_tmp11_ = _tmp10_;
		puzzle_view_set_boardsize (self, (guint) ((gint) (self->priv->tilesize * _tmp11_)));
		self->priv->gap = (guint) (self->priv->tilesize * PUZZLE_VIEW_gap_factor);
		_tmp12_ = self->priv->theme;
		theme_configure (_tmp12_, self->priv->tilesize);
		_tmp13_ = self->priv->_boardsize;
		self->priv->x_offset = ((gdouble) ((allocated_width - (2 * _tmp13_)) - self->priv->gap)) / 2.0;
		_tmp14_ = self->priv->_boardsize;
		puzzle_view_set_y_offset (self, ((gdouble) (allocated_height - _tmp14_)) / 2.0);
		self->priv->board_x_maxi = allocated_width - ((gint) self->priv->tilesize);
		self->priv->board_y_maxi = allocated_height - ((gint) self->priv->tilesize);
		_tmp15_ = self->priv->_boardsize;
		self->priv->snap_distance = _tmp15_ / 40.0;
		_tmp16_ = self->priv->_boardsize;
		self->priv->arrow_x = self->priv->x_offset + _tmp16_;
		_tmp17_ = self->priv->_boardsize;
		self->priv->arrow_local_y = _tmp17_ * 0.5;
		puzzle_view_set_x_offset_right (self, self->priv->arrow_x + self->priv->gap);
		_tmp18_ = self->priv->_x_offset_right;
		_tmp19_ = self->priv->_boardsize;
		puzzle_view_set_right_margin (self, (allocated_width - _tmp18_) - _tmp19_);
		{
			guint8 y = 0U;
			y = (guint8) 0;
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					Puzzle* _tmp22_;
					Puzzle* _tmp23_;
					guint8 _tmp24_;
					guint8 _tmp25_;
					if (!_tmp20_) {
						guint8 _tmp21_;
						_tmp21_ = y;
						y = _tmp21_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp22_ = puzzle_view_get_puzzle (self);
					_tmp23_ = _tmp22_;
					_tmp24_ = puzzle_get_size (_tmp23_);
					_tmp25_ = _tmp24_;
					if (!(y < _tmp25_)) {
						break;
					}
					{
						guint8 x = 0U;
						x = (guint8) 0;
						{
							gboolean _tmp26_ = FALSE;
							_tmp26_ = TRUE;
							while (TRUE) {
								Puzzle* _tmp28_;
								Puzzle* _tmp29_;
								guint8 _tmp30_;
								guint8 _tmp31_;
								Puzzle* _tmp32_;
								Puzzle* _tmp33_;
								guint8 _tmp34_;
								guint8 _tmp35_;
								gdouble* _tmp38_;
								gint _tmp38__length1;
								gint _tmp38__length2;
								gdouble _tmp39_;
								if (!_tmp26_) {
									guint8 _tmp27_;
									_tmp27_ = x;
									x = _tmp27_ + 1;
								}
								_tmp26_ = FALSE;
								_tmp28_ = puzzle_view_get_puzzle (self);
								_tmp29_ = _tmp28_;
								_tmp30_ = puzzle_get_size (_tmp29_);
								_tmp31_ = _tmp30_;
								if (!(((gint) x) < (_tmp31_ * 2))) {
									break;
								}
								_tmp32_ = puzzle_view_get_puzzle (self);
								_tmp33_ = _tmp32_;
								_tmp34_ = puzzle_get_size (_tmp33_);
								_tmp35_ = _tmp34_;
								if (x >= _tmp35_) {
									gdouble* _tmp36_;
									gint _tmp36__length1;
									gint _tmp36__length2;
									_tmp36_ = self->priv->sockets_xs;
									_tmp36__length1 = self->priv->sockets_xs_length1;
									_tmp36__length2 = self->priv->sockets_xs_length2;
									_tmp36_[(x * _tmp36__length2) + y] = (self->priv->x_offset + (x * self->priv->tilesize)) + self->priv->gap;
								} else {
									gdouble* _tmp37_;
									gint _tmp37__length1;
									gint _tmp37__length2;
									_tmp37_ = self->priv->sockets_xs;
									_tmp37__length1 = self->priv->sockets_xs_length1;
									_tmp37__length2 = self->priv->sockets_xs_length2;
									_tmp37_[(x * _tmp37__length2) + y] = self->priv->x_offset + (x * self->priv->tilesize);
								}
								_tmp38_ = self->priv->sockets_ys;
								_tmp38__length1 = self->priv->sockets_ys_length1;
								_tmp38__length2 = self->priv->sockets_ys_length2;
								_tmp39_ = self->priv->_y_offset;
								_tmp38_[(x * _tmp38__length2) + y] = _tmp39_ + (y * self->priv->tilesize);
							}
						}
					}
				}
			}
		}
	}
	_tmp40_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp40_);
	while (TRUE) {
		Tile* tile = NULL;
		PuzzleViewTileImage* image = NULL;
		gconstpointer _tmp41_ = NULL;
		gconstpointer _tmp42_ = NULL;
		gboolean _tmp43_;
		Tile* _tmp44_;
		PuzzleViewTileImage* _tmp45_;
		guint8 x = 0U;
		guint8 y = 0U;
		Puzzle* _tmp46_;
		Puzzle* _tmp47_;
		Tile* _tmp48_;
		guint8 _tmp49_ = 0U;
		guint8 _tmp50_ = 0U;
		PuzzleViewTileImage* _tmp51_;
		_tmp43_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp41_), (gpointer*) (&_tmp42_));
		_g_object_unref0 (tile);
		_tmp44_ = _g_object_ref0 ((Tile*) _tmp41_);
		tile = _tmp44_;
		_g_object_unref0 (image);
		_tmp45_ = _g_object_ref0 ((PuzzleViewTileImage*) _tmp42_);
		image = _tmp45_;
		if (!_tmp43_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			break;
		}
		_tmp46_ = puzzle_view_get_puzzle (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = tile;
		puzzle_get_tile_location (_tmp47_, _tmp48_, &_tmp49_, &_tmp50_);
		x = _tmp49_;
		y = _tmp50_;
		_tmp51_ = image;
		puzzle_view_move_tile_to_location (self, _tmp51_, (guint) x, (guint) y, (gdouble) 0);
		_g_object_unref0 (image);
		_g_object_unref0 (tile);
	}
	_tmp52_ = self->priv->selected_tile;
	if (_tmp52_ != NULL) {
		PuzzleViewTileImage* _tmp53_;
		_tmp53_ = self->priv->selected_tile;
		G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = TRUE;
	}
	_g_object_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
	puzzle_view_set_tile_selected (self, FALSE);
	result = FALSE;
	return result;
}

static inline void
puzzle_view_init_patterns (PuzzleView* self,
                           cairo_t* context)
{
	cairo_surface_t* tmp_surface = NULL;
	cairo_t* tmp_context = NULL;
	cairo_surface_t* _tmp0_;
	guint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	Theme* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_surface_t* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	Theme* _tmp16_;
	cairo_t* _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_pattern_t* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	self->priv->render_size = self->priv->tilesize;
	_tmp0_ = cairo_get_target (context);
	_tmp1_ = self->priv->_boardsize;
	_tmp2_ = cairo_surface_create_similar (_tmp0_, CAIRO_CONTENT_COLOR_ALPHA, (gint) self->priv->gap, (gint) _tmp1_);
	_cairo_surface_destroy0 (tmp_surface);
	tmp_surface = _tmp2_;
	_tmp3_ = tmp_surface;
	_tmp4_ = cairo_create (_tmp3_);
	_cairo_destroy0 (tmp_context);
	tmp_context = _tmp4_;
	_tmp5_ = tmp_context;
	cairo_save (_tmp5_);
	_tmp6_ = tmp_context;
	cairo_translate (_tmp6_, 0.0, self->priv->arrow_local_y);
	_tmp7_ = self->priv->theme;
	_tmp8_ = tmp_context;
	theme_draw_arrow (_tmp7_, _tmp8_);
	_tmp9_ = tmp_context;
	cairo_restore (_tmp9_);
	_tmp10_ = tmp_surface;
	_tmp11_ = cairo_pattern_create_for_surface (_tmp10_);
	_cairo_pattern_destroy0 (self->priv->arrow_pattern);
	self->priv->arrow_pattern = _tmp11_;
	_tmp12_ = cairo_get_target (context);
	_tmp13_ = cairo_surface_create_similar (_tmp12_, CAIRO_CONTENT_COLOR_ALPHA, (gint) self->priv->tilesize, (gint) self->priv->tilesize);
	_cairo_surface_destroy0 (tmp_surface);
	tmp_surface = _tmp13_;
	_tmp14_ = tmp_surface;
	_tmp15_ = cairo_create (_tmp14_);
	_cairo_destroy0 (tmp_context);
	tmp_context = _tmp15_;
	_tmp16_ = self->priv->theme;
	_tmp17_ = tmp_context;
	theme_draw_socket (_tmp16_, _tmp17_);
	_tmp18_ = tmp_surface;
	_tmp19_ = cairo_pattern_create_for_surface (_tmp18_);
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = _tmp19_;
	_cairo_destroy0 (tmp_context);
	_cairo_surface_destroy0 (tmp_surface);
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
puzzle_view_real_draw (GtkWidget* base,
                       cairo_t* context)
{
	PuzzleView * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_pattern_t* _tmp2_;
	gdouble _tmp4_;
	cairo_pattern_t* _tmp5_;
	guint _tmp6_;
	GSList* moving_tiles = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp24_;
	GSList* _tmp48_;
	PuzzleViewTileImage* _tmp50_;
	gboolean _tmp54_ = FALSE;
	Puzzle* _tmp68_;
	Puzzle* _tmp69_;
	gboolean _tmp70_;
	gboolean _tmp71_;
	gboolean result;
	self = (PuzzleView*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	if (!self->priv->puzzle_init_done) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->arrow_pattern;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		cairo_pattern_t* _tmp3_;
		_tmp3_ = self->priv->socket_pattern;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->render_size != self->priv->tilesize;
	}
	if (_tmp0_) {
		puzzle_view_init_patterns (self, context);
	}
	cairo_save (context);
	_tmp4_ = self->priv->_y_offset;
	cairo_translate (context, self->priv->arrow_x, _tmp4_);
	_tmp5_ = self->priv->arrow_pattern;
	cairo_set_source (context, (cairo_pattern_t*) _tmp5_);
	_tmp6_ = self->priv->_boardsize;
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->gap, (gdouble) _tmp6_);
	cairo_fill (context);
	cairo_restore (context);
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				Puzzle* _tmp9_;
				Puzzle* _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				if (!_tmp7_) {
					guint8 _tmp8_;
					_tmp8_ = y;
					y = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = puzzle_view_get_puzzle (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = puzzle_get_size (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(y < _tmp12_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							Puzzle* _tmp15_;
							Puzzle* _tmp16_;
							guint8 _tmp17_;
							guint8 _tmp18_;
							gdouble* _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							gdouble _tmp20_;
							gdouble* _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							gdouble _tmp22_;
							cairo_pattern_t* _tmp23_;
							if (!_tmp13_) {
								guint8 _tmp14_;
								_tmp14_ = x;
								x = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = puzzle_view_get_puzzle (self);
							_tmp16_ = _tmp15_;
							_tmp17_ = puzzle_get_size (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(((gint) x) < (_tmp18_ * 2))) {
								break;
							}
							cairo_save (context);
							_tmp19_ = self->priv->sockets_xs;
							_tmp19__length1 = self->priv->sockets_xs_length1;
							_tmp19__length2 = self->priv->sockets_xs_length2;
							_tmp20_ = _tmp19_[(x * _tmp19__length2) + y];
							_tmp21_ = self->priv->sockets_ys;
							_tmp21__length1 = self->priv->sockets_ys_length1;
							_tmp21__length2 = self->priv->sockets_ys_length2;
							_tmp22_ = _tmp21_[(x * _tmp21__length2) + y];
							cairo_translate (context, _tmp20_, _tmp22_);
							_tmp23_ = self->priv->socket_pattern;
							cairo_set_source (context, (cairo_pattern_t*) _tmp23_);
							cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->tilesize, (gdouble) self->priv->tilesize);
							cairo_fill (context);
							cairo_restore (context);
						}
					}
				}
			}
		}
	}
	moving_tiles = NULL;
	_tmp24_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp24_);
	while (TRUE) {
		Tile* tile = NULL;
		PuzzleViewTileImage* image = NULL;
		gconstpointer _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_;
		Tile* _tmp28_;
		PuzzleViewTileImage* _tmp29_;
		gboolean _tmp30_ = FALSE;
		PuzzleViewTileImage* _tmp31_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		PuzzleViewTileImage* _tmp36_;
		gboolean _tmp40_ = FALSE;
		PuzzleViewTileImage* _tmp41_;
		PuzzleViewTileImage* _tmp42_;
		PuzzleViewTileImage* _tmp47_;
		_tmp27_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp25_), (gpointer*) (&_tmp26_));
		_g_object_unref0 (tile);
		_tmp28_ = _g_object_ref0 ((Tile*) _tmp25_);
		tile = _tmp28_;
		_g_object_unref0 (image);
		_tmp29_ = _g_object_ref0 ((PuzzleViewTileImage*) _tmp26_);
		image = _tmp29_;
		if (!_tmp27_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			break;
		}
		_tmp31_ = self->priv->selected_tile;
		if (_tmp31_ != NULL) {
			PuzzleViewTileImage* _tmp32_;
			PuzzleViewTileImage* _tmp33_;
			_tmp32_ = image;
			_tmp33_ = self->priv->selected_tile;
			_tmp30_ = _tmp32_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			continue;
		}
		_tmp36_ = self->priv->selected_tile;
		if (_tmp36_ == NULL) {
			PuzzleViewTileImage* _tmp37_;
			_tmp37_ = self->priv->last_selected_tile;
			_tmp35_ = _tmp37_ != NULL;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			PuzzleViewTileImage* _tmp38_;
			PuzzleViewTileImage* _tmp39_;
			_tmp38_ = image;
			_tmp39_ = self->priv->last_selected_tile;
			_tmp34_ = _tmp38_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			continue;
		}
		_tmp41_ = image;
		_tmp42_ = image;
		if (_tmp41_->x != _tmp42_->target_x) {
			_tmp40_ = TRUE;
		} else {
			PuzzleViewTileImage* _tmp43_;
			PuzzleViewTileImage* _tmp44_;
			_tmp43_ = image;
			_tmp44_ = image;
			_tmp40_ = _tmp43_->y != _tmp44_->target_y;
		}
		if (_tmp40_) {
			PuzzleViewTileImage* _tmp45_;
			PuzzleViewTileImage* _tmp46_;
			_tmp45_ = image;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			moving_tiles = g_slist_prepend (moving_tiles, _tmp46_);
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			continue;
		}
		_tmp47_ = image;
		puzzle_view_draw_image (self, context, _tmp47_);
		_g_object_unref0 (image);
		_g_object_unref0 (tile);
	}
	_tmp48_ = moving_tiles;
	{
		GSList* image_collection = NULL;
		GSList* image_it = NULL;
		image_collection = _tmp48_;
		for (image_it = image_collection; image_it != NULL; image_it = image_it->next) {
			PuzzleViewTileImage* image = NULL;
			image = (PuzzleViewTileImage*) image_it->data;
			{
				PuzzleViewTileImage* _tmp49_;
				_tmp49_ = image;
				puzzle_view_draw_image (self, context, _tmp49_);
			}
		}
	}
	_tmp50_ = self->priv->selected_tile;
	if (_tmp50_ != NULL) {
		PuzzleViewTileImage* _tmp51_;
		_tmp51_ = self->priv->selected_tile;
		puzzle_view_draw_image (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage));
	} else {
		PuzzleViewTileImage* _tmp52_;
		_tmp52_ = self->priv->last_selected_tile;
		if (_tmp52_ != NULL) {
			PuzzleViewTileImage* _tmp53_;
			_tmp53_ = self->priv->last_selected_tile;
			puzzle_view_draw_image (self, context, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage));
		}
	}
	if (self->priv->show_highlight) {
		Puzzle* _tmp55_;
		Puzzle* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		_tmp55_ = puzzle_view_get_puzzle (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = puzzle_get_is_solved (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp54_ = !_tmp58_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		gdouble* _tmp59_;
		gint _tmp59__length1;
		gint _tmp59__length2;
		gdouble _tmp60_;
		gdouble* _tmp61_;
		gint _tmp61__length1;
		gint _tmp61__length2;
		gdouble _tmp62_;
		Theme* _tmp63_;
		Puzzle* _tmp64_;
		Puzzle* _tmp65_;
		Tile* _tmp66_;
		Tile* _tmp67_;
		cairo_save (context);
		_tmp59_ = self->priv->sockets_xs;
		_tmp59__length1 = self->priv->sockets_xs_length1;
		_tmp59__length2 = self->priv->sockets_xs_length2;
		_tmp60_ = _tmp59_[(self->priv->highlight_x * _tmp59__length2) + self->priv->highlight_y];
		_tmp61_ = self->priv->sockets_ys;
		_tmp61__length1 = self->priv->sockets_ys_length1;
		_tmp61__length2 = self->priv->sockets_ys_length2;
		_tmp62_ = _tmp61_[(self->priv->highlight_x * _tmp61__length2) + self->priv->highlight_y];
		cairo_translate (context, _tmp60_, _tmp62_);
		_tmp63_ = self->priv->theme;
		_tmp64_ = puzzle_view_get_puzzle (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = puzzle_get_tile (_tmp65_, self->priv->highlight_x, self->priv->highlight_y);
		_tmp67_ = _tmp66_;
		theme_draw_highlight (_tmp63_, context, _tmp67_ != NULL);
		_g_object_unref0 (_tmp67_);
		cairo_restore (context);
	}
	_tmp68_ = puzzle_view_get_puzzle (self);
	_tmp69_ = _tmp68_;
	_tmp70_ = puzzle_get_paused (_tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_) {
		puzzle_view_draw_pause_overlay (self, context);
	}
	result = FALSE;
	(moving_tiles == NULL) ? NULL : (moving_tiles = (_g_slist_free__g_object_unref0_ (moving_tiles), NULL));
	return result;
}

static void
puzzle_view_draw_image (PuzzleView* self,
                        cairo_t* context,
                        PuzzleViewTileImage* image)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (image != NULL);
	cairo_save (context);
	cairo_translate (context, (gdouble) ((gint) image->x), (gdouble) ((gint) image->y));
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Theme* _tmp4_;
		_tmp4_ = self->priv->theme;
		theme_draw_paused_tile (_tmp4_, context);
	} else {
		guint8 tile_x = 0U;
		guint8 tile_y = 0U;
		Puzzle* _tmp5_;
		Puzzle* _tmp6_;
		Tile* _tmp7_;
		guint8 _tmp8_ = 0U;
		guint8 _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean highlight = FALSE;
		Theme* _tmp13_;
		Tile* _tmp14_;
		_tmp5_ = puzzle_view_get_puzzle (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = image->tile;
		puzzle_get_tile_location (_tmp6_, _tmp7_, &_tmp8_, &_tmp9_);
		tile_x = _tmp8_;
		tile_y = _tmp9_;
		if (self->priv->show_highlight) {
			_tmp12_ = self->priv->tile_selection;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = self->priv->kbd_selected_x == tile_x;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = self->priv->kbd_selected_y == tile_y;
		} else {
			_tmp10_ = FALSE;
		}
		highlight = _tmp10_;
		_tmp13_ = self->priv->theme;
		_tmp14_ = image->tile;
		theme_draw_tile (_tmp13_, context, _tmp14_, highlight);
	}
	cairo_restore (context);
}

static inline void
puzzle_view_draw_pause_overlay (PuzzleView* self,
                                cairo_t* context)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	cairo_set_source_rgba (context, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
	cairo_paint (context);
	cairo_select_font_face (context, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, gtk_widget_get_allocated_width ((GtkWidget*) self) * 0.125);
	_tmp0_ = g_strdup (_ ("Paused"));
	text = _tmp0_;
	cairo_text_extents (context, text, &_tmp1_);
	extents = _tmp1_;
	_tmp2_ = extents;
	_tmp3_ = extents;
	cairo_move_to (context, (gtk_widget_get_allocated_width ((GtkWidget*) self) - _tmp2_.width) / 2.0, (gtk_widget_get_allocated_height ((GtkWidget*) self) + _tmp3_.height) / 2.0);
	cairo_set_source_rgb (context, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_show_text (context, text);
	_g_free0 (text);
}

static gboolean
_puzzle_view_selection_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = puzzle_view_selection_timeout_cb ((PuzzleView*) self);
	return result;
}

static void
puzzle_view_pick_tile (PuzzleView* self,
                       gdouble x,
                       gdouble y)
{
	PuzzleViewTileImage* _tmp0_;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GHashTableIter iter = {0};
	GHashTable* _tmp5_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_is_solved (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->tiles;
	g_hash_table_iter_init (&iter, _tmp5_);
	while (TRUE) {
		Tile* tile = NULL;
		PuzzleViewTileImage* image = NULL;
		gconstpointer _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gboolean _tmp8_;
		Tile* _tmp9_;
		PuzzleViewTileImage* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		PuzzleViewTileImage* _tmp14_;
		_tmp8_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp6_), (gpointer*) (&_tmp7_));
		_g_object_unref0 (tile);
		_tmp9_ = _g_object_ref0 ((Tile*) _tmp6_);
		tile = _tmp9_;
		_g_object_unref0 (image);
		_tmp10_ = _g_object_ref0 ((PuzzleViewTileImage*) _tmp7_);
		image = _tmp10_;
		if (!_tmp8_) {
			_g_object_unref0 (image);
			_g_object_unref0 (tile);
			break;
		}
		_tmp14_ = image;
		if (x >= _tmp14_->x) {
			PuzzleViewTileImage* _tmp15_;
			_tmp15_ = image;
			_tmp13_ = x <= (_tmp15_->x + self->priv->tilesize);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			PuzzleViewTileImage* _tmp16_;
			_tmp16_ = image;
			_tmp12_ = y >= _tmp16_->y;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			PuzzleViewTileImage* _tmp17_;
			_tmp17_ = image;
			_tmp11_ = y <= (_tmp17_->y + self->priv->tilesize);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			PuzzleViewTileImage* _tmp18_;
			PuzzleViewTileImage* _tmp19_;
			PuzzleViewTileImage* _tmp20_;
			PuzzleViewTileImage* _tmp21_;
			PuzzleViewTileImage* _tmp22_;
			PuzzleViewTileImage* _tmp23_;
			_tmp18_ = image;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (self->priv->selected_tile);
			self->priv->selected_tile = _tmp19_;
			_tmp20_ = image;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			_g_object_unref0 (self->priv->last_selected_tile);
			self->priv->last_selected_tile = _tmp21_;
			puzzle_view_set_tile_selected (self, TRUE);
			_tmp22_ = image;
			self->priv->selected_x_offset = x - _tmp22_->x;
			_tmp23_ = image;
			self->priv->selected_y_offset = y - _tmp23_->y;
			if (self->priv->selection_timeout != ((guint) 0)) {
				g_source_remove (self->priv->selection_timeout);
			}
			self->priv->selection_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _puzzle_view_selection_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
		_g_object_unref0 (image);
		_g_object_unref0 (tile);
	}
	_tmp24_ = self->priv->_tile_selected;
	if (!_tmp24_) {
		guint8 tile_x = 0U;
		guint8 tile_y = 0U;
		guint8 _tmp25_ = 0U;
		guint8 _tmp26_ = 0U;
		gboolean _tmp27_;
		_tmp27_ = puzzle_view_get_tile_coords (self, x, y, &_tmp25_, &_tmp26_);
		tile_x = _tmp25_;
		tile_y = _tmp26_;
		if (_tmp27_) {
			Puzzle* _tmp28_;
			Puzzle* _tmp29_;
			_tmp28_ = puzzle_view_get_puzzle (self);
			_tmp29_ = _tmp28_;
			puzzle_try_move (_tmp29_, tile_x, tile_y);
		}
	}
}

static inline gboolean
puzzle_view_get_tile_coords (PuzzleView* self,
                             gdouble event_x,
                             gdouble event_y,
                             guint8* tile_x,
                             guint8* tile_y)
{
	guint8 _vala_tile_x = 0U;
	guint8 _vala_tile_y = 0U;
	guint8 _tmp0_ = 0U;
	gboolean _tmp1_;
	guint8 _tmp2_ = 0U;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = puzzle_view_get_tile_coord_x (self, event_x, &_tmp0_);
	_vala_tile_x = _tmp0_;
	if (!_tmp1_) {
		_vala_tile_y = (guint8) 0;
		result = FALSE;
		if (tile_x) {
			*tile_x = _vala_tile_x;
		}
		if (tile_y) {
			*tile_y = _vala_tile_y;
		}
		return result;
	}
	_tmp3_ = puzzle_view_get_tile_coord_y (self, event_y, &_tmp2_);
	_vala_tile_y = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		if (tile_x) {
			*tile_x = _vala_tile_x;
		}
		if (tile_y) {
			*tile_y = _vala_tile_y;
		}
		return result;
	}
	result = TRUE;
	if (tile_x) {
		*tile_x = _vala_tile_x;
	}
	if (tile_y) {
		*tile_y = _vala_tile_y;
	}
	return result;
}

static inline gboolean
puzzle_view_get_tile_coord_x (PuzzleView* self,
                              gdouble event_x,
                              guint8* tile_x)
{
	guint8 _vala_tile_x = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_vala_tile_x = (guint8) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			Puzzle* _tmp2_;
			Puzzle* _tmp3_;
			guint8 _tmp4_;
			guint8 _tmp5_;
			gboolean _tmp6_ = FALSE;
			gdouble* _tmp7_;
			gint _tmp7__length1;
			gint _tmp7__length2;
			gdouble _tmp8_;
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = _vala_tile_x;
				_vala_tile_x = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = puzzle_view_get_puzzle (self);
			_tmp3_ = _tmp2_;
			_tmp4_ = puzzle_get_size (_tmp3_);
			_tmp5_ = _tmp4_;
			if (!(((gint) _vala_tile_x) < (2 * _tmp5_))) {
				break;
			}
			_tmp7_ = self->priv->sockets_xs;
			_tmp7__length1 = self->priv->sockets_xs_length1;
			_tmp7__length2 = self->priv->sockets_xs_length2;
			_tmp8_ = _tmp7_[(_vala_tile_x * _tmp7__length2) + 0];
			if (event_x > _tmp8_) {
				gdouble* _tmp9_;
				gint _tmp9__length1;
				gint _tmp9__length2;
				gdouble _tmp10_;
				_tmp9_ = self->priv->sockets_xs;
				_tmp9__length1 = self->priv->sockets_xs_length1;
				_tmp9__length2 = self->priv->sockets_xs_length2;
				_tmp10_ = _tmp9_[(_vala_tile_x * _tmp9__length2) + 0];
				_tmp6_ = event_x < (_tmp10_ + self->priv->tilesize);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = TRUE;
				if (tile_x) {
					*tile_x = _vala_tile_x;
				}
				return result;
			}
		}
	}
	result = FALSE;
	if (tile_x) {
		*tile_x = _vala_tile_x;
	}
	return result;
}

static inline gboolean
puzzle_view_get_tile_coord_y (PuzzleView* self,
                              gdouble event_y,
                              guint8* tile_y)
{
	guint8 _vala_tile_y = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_vala_tile_y = (guint8) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			Puzzle* _tmp2_;
			Puzzle* _tmp3_;
			guint8 _tmp4_;
			guint8 _tmp5_;
			gboolean _tmp6_ = FALSE;
			gdouble* _tmp7_;
			gint _tmp7__length1;
			gint _tmp7__length2;
			gdouble _tmp8_;
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = _vala_tile_y;
				_vala_tile_y = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = puzzle_view_get_puzzle (self);
			_tmp3_ = _tmp2_;
			_tmp4_ = puzzle_get_size (_tmp3_);
			_tmp5_ = _tmp4_;
			if (!(_vala_tile_y < _tmp5_)) {
				break;
			}
			_tmp7_ = self->priv->sockets_ys;
			_tmp7__length1 = self->priv->sockets_ys_length1;
			_tmp7__length2 = self->priv->sockets_ys_length2;
			_tmp8_ = _tmp7_[(0 * _tmp7__length2) + _vala_tile_y];
			if (event_y > _tmp8_) {
				gdouble* _tmp9_;
				gint _tmp9__length1;
				gint _tmp9__length2;
				gdouble _tmp10_;
				_tmp9_ = self->priv->sockets_ys;
				_tmp9__length1 = self->priv->sockets_ys_length1;
				_tmp9__length2 = self->priv->sockets_ys_length2;
				_tmp10_ = _tmp9_[(0 * _tmp9__length2) + _vala_tile_y];
				_tmp6_ = event_y < (_tmp10_ + self->priv->tilesize);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = TRUE;
				if (tile_y) {
					*tile_y = _vala_tile_y;
				}
				return result;
			}
		}
	}
	result = FALSE;
	if (tile_y) {
		*tile_y = _vala_tile_y;
	}
	return result;
}

static gboolean
puzzle_view_selection_timeout_cb (PuzzleView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->selection_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
puzzle_view_on_right_half (PuzzleView* self,
                           gdouble x)
{
	gdouble _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_x_offset_right;
	result = x > (_tmp0_ - (self->priv->gap * 0.5));
	return result;
}

static void
puzzle_view_drop_tile (PuzzleView* self,
                       gdouble x,
                       gdouble y)
{
	PuzzleViewTileImage* _tmp0_;
	gint16 tile_y = 0;
	gdouble _tmp1_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	gint16 tile_x = 0;
	guint8 selected_x = 0U;
	guint8 selected_y = 0U;
	Puzzle* _tmp23_;
	Puzzle* _tmp24_;
	PuzzleViewTileImage* _tmp25_;
	Tile* _tmp26_;
	guint8 _tmp27_ = 0U;
	guint8 _tmp28_ = 0U;
	Puzzle* _tmp29_;
	Puzzle* _tmp30_;
	PuzzleViewTileImage* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		return;
	}
	x = x + ((self->priv->tilesize * 0.5) - self->priv->selected_x_offset);
	y = y + ((self->priv->tilesize * 0.5) - self->priv->selected_y_offset);
	_tmp1_ = self->priv->_y_offset;
	tile_y = (gint16) floor ((y - _tmp1_) / self->priv->tilesize);
	_tmp2_ = puzzle_view_get_puzzle (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = puzzle_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	tile_y = CLAMP (tile_y, (gint16) 0, (gint16) (((gint16) _tmp5_) - 1));
	if (puzzle_view_on_right_half (self, x)) {
		Puzzle* _tmp6_;
		Puzzle* _tmp7_;
		guint8 _tmp8_;
		guint8 _tmp9_;
		gdouble _tmp10_;
		Puzzle* _tmp11_;
		Puzzle* _tmp12_;
		guint8 _tmp13_;
		guint8 _tmp14_;
		Puzzle* _tmp15_;
		Puzzle* _tmp16_;
		guint8 _tmp17_;
		guint8 _tmp18_;
		_tmp6_ = puzzle_view_get_puzzle (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = puzzle_get_size (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_x_offset_right;
		tile_x = ((gint16) _tmp9_) + ((gint16) floor ((x - _tmp10_) / self->priv->tilesize));
		_tmp11_ = puzzle_view_get_puzzle (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = puzzle_get_size (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = puzzle_view_get_puzzle (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = puzzle_get_size (_tmp16_);
		_tmp18_ = _tmp17_;
		tile_x = CLAMP (tile_x, (gint16) _tmp14_, (gint16) ((2 * ((gint16) _tmp18_)) - 1));
	} else {
		Puzzle* _tmp19_;
		Puzzle* _tmp20_;
		guint8 _tmp21_;
		guint8 _tmp22_;
		tile_x = (gint16) floor ((x - self->priv->x_offset) / self->priv->tilesize);
		_tmp19_ = puzzle_view_get_puzzle (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = puzzle_get_size (_tmp20_);
		_tmp22_ = _tmp21_;
		tile_x = CLAMP (tile_x, (gint16) 0, (gint16) (((gint16) _tmp22_) - 1));
	}
	_tmp23_ = puzzle_view_get_puzzle (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->selected_tile;
	_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->tile;
	puzzle_get_tile_location (_tmp24_, _tmp26_, &_tmp27_, &_tmp28_);
	selected_x = _tmp27_;
	selected_y = _tmp28_;
	_tmp29_ = puzzle_view_get_puzzle (self);
	_tmp30_ = _tmp29_;
	if (puzzle_can_switch (_tmp30_, selected_x, selected_y, (guint8) tile_x, (guint8) tile_y)) {
		Puzzle* _tmp31_;
		Puzzle* _tmp32_;
		_tmp31_ = puzzle_view_get_puzzle (self);
		_tmp32_ = _tmp31_;
		puzzle_switch_tiles (_tmp32_, selected_x, selected_y, (guint8) tile_x, (guint8) tile_y, (guint) 0);
	} else {
		PuzzleViewTileImage* _tmp33_;
		_tmp33_ = self->priv->selected_tile;
		puzzle_view_move_tile_to_location (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage), (guint) selected_x, (guint) selected_y, PUZZLE_VIEW_animation_duration);
	}
	_tmp34_ = self->priv->selected_tile;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = TRUE;
	_g_object_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
	puzzle_view_set_tile_selected (self, FALSE);
}

static void
puzzle_view_move_tile_to_right_half (PuzzleView* self,
                                     Tile* tile)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Puzzle* _tmp2_;
				Puzzle* _tmp3_;
				guint8 _tmp4_;
				guint8 _tmp5_;
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = puzzle_view_get_puzzle (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = puzzle_get_size (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(y < _tmp5_)) {
					break;
				}
				{
					guint8 x = 0U;
					Puzzle* _tmp6_;
					Puzzle* _tmp7_;
					guint8 _tmp8_;
					guint8 _tmp9_;
					_tmp6_ = puzzle_view_get_puzzle (self);
					_tmp7_ = _tmp6_;
					_tmp8_ = puzzle_get_size (_tmp7_);
					_tmp9_ = _tmp8_;
					x = _tmp9_;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							Puzzle* _tmp12_;
							Puzzle* _tmp13_;
							guint8 _tmp14_;
							guint8 _tmp15_;
							Puzzle* _tmp16_;
							Puzzle* _tmp17_;
							Tile* _tmp18_;
							Tile* _tmp19_;
							gboolean _tmp20_;
							if (!_tmp10_) {
								guint8 _tmp11_;
								_tmp11_ = x;
								x = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = puzzle_view_get_puzzle (self);
							_tmp13_ = _tmp12_;
							_tmp14_ = puzzle_get_size (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(((gint) x) < (_tmp15_ * 2))) {
								break;
							}
							_tmp16_ = puzzle_view_get_puzzle (self);
							_tmp17_ = _tmp16_;
							_tmp18_ = puzzle_get_tile (_tmp17_, x, y);
							_tmp19_ = _tmp18_;
							_tmp20_ = _tmp19_ == NULL;
							_g_object_unref0 (_tmp19_);
							if (_tmp20_) {
								guint8 source_x = 0U;
								guint8 source_y = 0U;
								Puzzle* _tmp21_;
								Puzzle* _tmp22_;
								guint8 _tmp23_ = 0U;
								guint8 _tmp24_ = 0U;
								Puzzle* _tmp25_;
								Puzzle* _tmp26_;
								_tmp21_ = puzzle_view_get_puzzle (self);
								_tmp22_ = _tmp21_;
								puzzle_get_tile_location (_tmp22_, tile, &_tmp23_, &_tmp24_);
								source_x = _tmp23_;
								source_y = _tmp24_;
								_tmp25_ = puzzle_view_get_puzzle (self);
								_tmp26_ = _tmp25_;
								puzzle_switch_tiles (_tmp26_, source_x, source_y, x, y, (guint) 0);
								return;
							}
						}
					}
				}
			}
		}
	}
	g_assert_not_reached ();
}

static void
_puzzle_view_on_motion_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	puzzle_view_on_motion ((PuzzleView*) self, _sender, x, y);
}

static void
_puzzle_view_on_click_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                       gint n_press,
                                                       gdouble x,
                                                       gdouble y,
                                                       gpointer self)
{
	puzzle_view_on_click ((PuzzleView*) self, _sender, n_press, x, y);
}

static void
_puzzle_view_on_release_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                          gint n_press,
                                                          gdouble x,
                                                          gdouble y,
                                                          gpointer self)
{
	puzzle_view_on_release ((PuzzleView*) self, _sender, n_press, x, y);
}

static void
puzzle_view_init_mouse (PuzzleView* self)
{
	GtkEventControllerMotion* _tmp0_;
	GtkEventControllerMotion* _tmp1_;
	GtkGestureMultiPress* _tmp2_;
	GtkGestureMultiPress* _tmp3_;
	GtkGestureMultiPress* _tmp4_;
	GtkGestureMultiPress* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp0_;
	_tmp1_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp1_, "motion", (GCallback) _puzzle_view_on_motion_gtk_event_controller_motion_motion, self, 0);
	_tmp2_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp2_;
	_tmp3_ = self->priv->click_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp3_, (guint) 0);
	_tmp4_ = self->priv->click_controller;
	g_signal_connect_object (_tmp4_, "pressed", (GCallback) _puzzle_view_on_click_gtk_gesture_multi_press_pressed, self, 0);
	_tmp5_ = self->priv->click_controller;
	g_signal_connect_object (_tmp5_, "released", (GCallback) _puzzle_view_on_release_gtk_gesture_multi_press_released, self, 0);
}

static inline void
puzzle_view_on_click (PuzzleView* self,
                      GtkGestureMultiPress* _click_controller,
                      gint n_press,
                      gdouble event_x,
                      gdouble event_y)
{
	gboolean _tmp0_ = FALSE;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	guint button = 0U;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Puzzle* _tmp5_;
		Puzzle* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = puzzle_view_get_puzzle (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = puzzle_get_is_solved (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	puzzle_view_clear_keyboard_highlight (self, FALSE);
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _click_controller);
	if (button == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = button == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp9_) {
		puzzle_view_main_button_pressed (self, n_press, event_x, event_y);
		return;
	}
	_tmp10_ = self->priv->_mouse_use_extra_buttons;
	if (!_tmp10_) {
		return;
	}
	_tmp11_ = self->priv->_mouse_back_button;
	if (button == ((guint) _tmp11_)) {
		puzzle_view_undo (self);
	} else {
		gint _tmp12_;
		_tmp12_ = self->priv->_mouse_forward_button;
		if (button == ((guint) _tmp12_)) {
			puzzle_view_redo (self);
		}
	}
}

static inline void
puzzle_view_main_button_pressed (PuzzleView* self,
                                 gint n_press,
                                 gdouble event_x,
                                 gdouble event_y)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_is_solved (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	if (n_press == 1) {
		PuzzleViewTileImage* _tmp4_;
		_tmp4_ = self->priv->selected_tile;
		if (_tmp4_ == NULL) {
			puzzle_view_pick_tile (self, event_x, event_y);
		} else {
			puzzle_view_drop_tile (self, event_x, event_y);
		}
	} else {
		gboolean had_selected_tile = FALSE;
		PuzzleViewTileImage* _tmp5_;
		PuzzleViewTileImage* _tmp6_;
		PuzzleViewTileImage* _tmp7_;
		PuzzleViewTileImage* _tmp25_;
		_tmp5_ = self->priv->selected_tile;
		had_selected_tile = _tmp5_ != NULL;
		puzzle_view_pick_tile (self, event_x, event_y);
		_tmp6_ = self->priv->selected_tile;
		if (_tmp6_ == NULL) {
			return;
		}
		_tmp7_ = self->priv->selected_tile;
		if (puzzle_view_on_right_half (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->x)) {
			guint8 x = 0U;
			guint8 y = 0U;
			Puzzle* _tmp8_;
			Puzzle* _tmp9_;
			guint8 _tmp10_ = 0U;
			guint8 _tmp11_ = 0U;
			gboolean _tmp12_;
			_tmp8_ = puzzle_view_get_puzzle (self);
			_tmp9_ = _tmp8_;
			_tmp12_ = puzzle_only_one_remaining_tile (_tmp9_, &_tmp10_, &_tmp11_);
			x = _tmp10_;
			y = _tmp11_;
			if (_tmp12_) {
				guint8 selected_x = 0U;
				guint8 selected_y = 0U;
				Puzzle* _tmp13_;
				Puzzle* _tmp14_;
				PuzzleViewTileImage* _tmp15_;
				Tile* _tmp16_;
				guint8 _tmp17_ = 0U;
				guint8 _tmp18_ = 0U;
				Puzzle* _tmp19_;
				Puzzle* _tmp20_;
				_tmp13_ = puzzle_view_get_puzzle (self);
				_tmp14_ = _tmp13_;
				_tmp15_ = self->priv->selected_tile;
				_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->tile;
				puzzle_get_tile_location (_tmp14_, _tmp16_, &_tmp17_, &_tmp18_);
				selected_x = _tmp17_;
				selected_y = _tmp18_;
				_tmp19_ = puzzle_view_get_puzzle (self);
				_tmp20_ = _tmp19_;
				if (puzzle_can_switch (_tmp20_, selected_x, selected_y, x, y)) {
					Puzzle* _tmp21_;
					Puzzle* _tmp22_;
					_tmp21_ = puzzle_view_get_puzzle (self);
					_tmp22_ = _tmp21_;
					puzzle_switch_tiles (_tmp22_, selected_x, selected_y, x, y, PUZZLE_VIEW_final_animation_duration);
				} else {
					if (had_selected_tile) {
						puzzle_view_drop_tile (self, event_x, event_y);
					}
					return;
				}
			} else {
				if (had_selected_tile) {
					puzzle_view_drop_tile (self, event_x, event_y);
				}
				return;
			}
		} else {
			if (!had_selected_tile) {
				PuzzleViewTileImage* _tmp23_;
				Tile* _tmp24_;
				_tmp23_ = self->priv->selected_tile;
				_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->tile;
				puzzle_view_move_tile_to_right_half (self, _tmp24_);
			}
		}
		_tmp25_ = self->priv->selected_tile;
		G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = TRUE;
		_g_object_unref0 (self->priv->selected_tile);
		self->priv->selected_tile = NULL;
		puzzle_view_set_tile_selected (self, FALSE);
	}
}

static inline void
puzzle_view_on_release (PuzzleView* self,
                        GtkGestureMultiPress* _click_controller,
                        gint n_press,
                        gdouble event_x,
                        gdouble event_y)
{
	gboolean _tmp0_ = FALSE;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	guint button = 0U;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Puzzle* _tmp5_;
		Puzzle* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = puzzle_view_get_puzzle (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = puzzle_get_is_solved (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	puzzle_view_clear_keyboard_highlight (self, FALSE);
	button = gtk_gesture_single_get_current_button ((GtkGestureSingle*) _click_controller);
	if (button == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = button == ((guint) GDK_BUTTON_SECONDARY);
	}
	if (_tmp11_) {
		PuzzleViewTileImage* _tmp12_;
		_tmp12_ = self->priv->selected_tile;
		_tmp10_ = _tmp12_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = self->priv->selection_timeout == ((guint) 0);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		puzzle_view_drop_tile (self, event_x, event_y);
	}
	if (self->priv->selection_timeout != ((guint) 0)) {
		g_source_remove (self->priv->selection_timeout);
	}
	self->priv->selection_timeout = (guint) 0;
}

static inline void
puzzle_view_on_motion (PuzzleView* self,
                       GtkEventControllerMotion* _motion_controller,
                       gdouble event_x,
                       gdouble event_y)
{
	PuzzleViewTileImage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_motion_controller != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		gint new_x = 0;
		gint new_y = 0;
		gdouble duration = 0.0;
		PuzzleViewTileImage* _tmp1_;
		PuzzleViewTileImage* _tmp3_;
		new_x = CLAMP ((gint) (event_x - self->priv->selected_x_offset), 0, self->priv->board_x_maxi);
		new_y = CLAMP ((gint) (event_y - self->priv->selected_y_offset), 0, self->priv->board_y_maxi);
		_tmp1_ = self->priv->selected_tile;
		if (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor) {
			duration = 0.0;
		} else {
			PuzzleViewTileImage* _tmp2_;
			_tmp2_ = self->priv->selected_tile;
			duration = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->duration;
		}
		_tmp3_ = self->priv->selected_tile;
		puzzle_view_move_tile (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage), (gdouble) new_x, (gdouble) new_y, duration);
	}
}

static gboolean
puzzle_view_real_leave_notify_event (GtkWidget* base,
                                     GdkEventCrossing* event)
{
	PuzzleView * self;
	PuzzleViewTileImage* _tmp0_;
	gboolean result;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		PuzzleViewTileImage* _tmp1_;
		_tmp1_ = self->priv->selected_tile;
		G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = FALSE;
	}
	result = FALSE;
	return result;
}

static gboolean
puzzle_view_real_enter_notify_event (GtkWidget* base,
                                     GdkEventCrossing* event)
{
	PuzzleView * self;
	PuzzleViewTileImage* _tmp0_;
	gboolean result;
	self = (PuzzleView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ != NULL) {
		PuzzleViewTileImage* _tmp1_;
		PuzzleViewTileImage* _tmp2_;
		_tmp1_ = self->priv->selected_tile;
		G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = FALSE;
		_tmp2_ = self->priv->selected_tile;
		G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->duration = PUZZLE_VIEW_half_animation_duration;
	}
	result = FALSE;
	return result;
}

void
puzzle_view_finish (PuzzleView* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	puzzle_finish (_tmp1_, PUZZLE_VIEW_final_animation_duration);
}

void
puzzle_view_release_selected_tile (PuzzleView* self)
{
	PuzzleViewTileImage* _tmp0_;
	guint8 selected_x = 0U;
	guint8 selected_y = 0U;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	PuzzleViewTileImage* _tmp3_;
	Tile* _tmp4_;
	guint8 _tmp5_ = 0U;
	guint8 _tmp6_ = 0U;
	PuzzleViewTileImage* _tmp7_;
	PuzzleViewTileImage* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->selected_tile;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->tile;
	puzzle_get_tile_location (_tmp2_, _tmp4_, &_tmp5_, &_tmp6_);
	selected_x = _tmp5_;
	selected_y = _tmp6_;
	_tmp7_ = self->priv->selected_tile;
	puzzle_view_move_tile_to_location (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage), (guint) selected_x, (guint) selected_y, PUZZLE_VIEW_animation_duration);
	_tmp8_ = self->priv->selected_tile;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage)->snap_to_cursor = TRUE;
	_g_object_unref0 (self->priv->selected_tile);
	self->priv->selected_tile = NULL;
	puzzle_view_set_tile_selected (self, FALSE);
}

void
puzzle_view_undo (PuzzleView* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->last_selected_tile);
	self->priv->last_selected_tile = NULL;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	puzzle_undo (_tmp1_);
}

void
puzzle_view_redo (PuzzleView* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->last_selected_tile);
	self->priv->last_selected_tile = NULL;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	puzzle_redo (_tmp1_);
}

void
puzzle_view_reload (PuzzleView* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->last_selected_tile);
	self->priv->last_selected_tile = NULL;
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	puzzle_reload (_tmp1_);
}

static gboolean
__lambda6_ (PuzzleView* self)
{
	guint8 _tmp0_;
	Theme* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->socket_animation_level;
	self->priv->socket_animation_level = _tmp0_ + 1;
	_tmp1_ = self->priv->theme;
	theme_set_animation_level (_tmp1_, self->priv->socket_animation_level);
	_cairo_pattern_destroy0 (self->priv->arrow_pattern);
	self->priv->arrow_pattern = NULL;
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = NULL;
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (((gint) self->priv->socket_animation_level) < 17) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		self->priv->socket_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((PuzzleView*) self);
	return result;
}

void
puzzle_view_hide_right_sockets (PuzzleView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->socket_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 75, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

static inline void
puzzle_view_show_right_sockets (PuzzleView* self)
{
	Theme* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->socket_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->socket_timeout_id);
		self->priv->socket_timeout_id = (guint) 0;
	}
	self->priv->socket_animation_level = (guint8) 0;
	_tmp0_ = self->priv->theme;
	theme_set_animation_level (_tmp0_, (guint8) 0);
	_cairo_pattern_destroy0 (self->priv->arrow_pattern);
	self->priv->arrow_pattern = NULL;
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = NULL;
}

static gboolean
_puzzle_view_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = puzzle_view_on_key_pressed ((PuzzleView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
puzzle_view_init_keyboard (PuzzleView* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _puzzle_view_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
puzzle_view_on_key_pressed (PuzzleView* self,
                            GtkEventControllerKey* _key_controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	gchar* key = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	Puzzle* _tmp63_;
	Puzzle* _tmp64_;
	guint8 _tmp65_;
	guint8 _tmp66_;
	const gchar* _tmp158_;
	const gchar* _tmp159_;
	GQuark _tmp161_ = 0U;
	static GQuark _tmp160_label0 = 0;
	static GQuark _tmp160_label1 = 0;
	static GQuark _tmp160_label2 = 0;
	static GQuark _tmp160_label3 = 0;
	static GQuark _tmp160_label4 = 0;
	static GQuark _tmp160_label5 = 0;
	static GQuark _tmp160_label6 = 0;
	static GQuark _tmp160_label7 = 0;
	static GQuark _tmp160_label8 = 0;
	static GQuark _tmp160_label9 = 0;
	static GQuark _tmp160_label10 = 0;
	static GQuark _tmp160_label11 = 0;
	static GQuark _tmp160_label12 = 0;
	static GQuark _tmp160_label13 = 0;
	static GQuark _tmp160_label14 = 0;
	static GQuark _tmp160_label15 = 0;
	static GQuark _tmp160_label16 = 0;
	static GQuark _tmp160_label17 = 0;
	static GQuark _tmp160_label18 = 0;
	static GQuark _tmp160_label19 = 0;
	static GQuark _tmp160_label20 = 0;
	static GQuark _tmp160_label21 = 0;
	static GQuark _tmp160_label22 = 0;
	static GQuark _tmp160_label23 = 0;
	static GQuark _tmp160_label24 = 0;
	static GQuark _tmp160_label25 = 0;
	static GQuark _tmp160_label26 = 0;
	static GQuark _tmp160_label27 = 0;
	static GQuark _tmp160_label28 = 0;
	static GQuark _tmp160_label29 = 0;
	static GQuark _tmp160_label30 = 0;
	static GQuark _tmp160_label31 = 0;
	static GQuark _tmp160_label32 = 0;
	static GQuark _tmp160_label33 = 0;
	static GQuark _tmp160_label34 = 0;
	static GQuark _tmp160_label35 = 0;
	static GQuark _tmp160_label36 = 0;
	static GQuark _tmp160_label37 = 0;
	static GQuark _tmp160_label38 = 0;
	static GQuark _tmp160_label39 = 0;
	static GQuark _tmp160_label40 = 0;
	static GQuark _tmp160_label41 = 0;
	static GQuark _tmp160_label42 = 0;
	static GQuark _tmp160_label43 = 0;
	const gchar* _tmp206_;
	gboolean _tmp207_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	if (!self->priv->puzzle_init_done) {
		result = FALSE;
		return result;
	}
	_tmp1_ = puzzle_view_get_puzzle (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = puzzle_get_is_solved (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Puzzle* _tmp5_;
		Puzzle* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = puzzle_view_get_puzzle (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = puzzle_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->_tile_selected;
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = gdk_keyval_name (keyval);
	_tmp10_ = _tmp11_;
	if (_tmp10_ == NULL) {
		_tmp10_ = "";
	}
	_tmp12_ = g_strdup ((const gchar*) _tmp10_);
	key = _tmp12_;
	_tmp13_ = key;
	if (g_strcmp0 (_tmp13_, "") == 0) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	if (self->priv->highlight_set) {
		_tmp15_ = self->priv->show_highlight;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		_tmp18_ = key;
		if (g_strcmp0 (_tmp18_, "space") == 0) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = key;
			_tmp17_ = g_strcmp0 (_tmp19_, "Return") == 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = key;
			_tmp16_ = g_strcmp0 (_tmp20_, "KP_Enter") == 0;
		}
		_tmp14_ = _tmp16_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		if (self->priv->tile_selection) {
			gboolean _tmp21_ = FALSE;
			Puzzle* _tmp22_;
			Puzzle* _tmp23_;
			Puzzle* _tmp26_;
			Puzzle* _tmp27_;
			Tile* _tmp28_;
			Tile* _tmp29_;
			gboolean _tmp30_;
			if (self->priv->highlight_x == self->priv->kbd_selected_x) {
				_tmp21_ = self->priv->highlight_y == self->priv->kbd_selected_y;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				puzzle_view_clear_keyboard_highlight (self, TRUE);
				result = TRUE;
				_g_free0 (key);
				return result;
			}
			_tmp22_ = puzzle_view_get_puzzle (self);
			_tmp23_ = _tmp22_;
			if (puzzle_can_switch (_tmp23_, self->priv->highlight_x, self->priv->highlight_y, self->priv->kbd_selected_x, self->priv->kbd_selected_y)) {
				Puzzle* _tmp24_;
				Puzzle* _tmp25_;
				_tmp24_ = puzzle_view_get_puzzle (self);
				_tmp25_ = _tmp24_;
				puzzle_switch_tiles (_tmp25_, self->priv->highlight_x, self->priv->highlight_y, self->priv->kbd_selected_x, self->priv->kbd_selected_y, (guint) 0);
				puzzle_view_clear_keyboard_highlight (self, TRUE);
				result = TRUE;
				_g_free0 (key);
				return result;
			}
			_tmp26_ = puzzle_view_get_puzzle (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = puzzle_get_tile (_tmp27_, self->priv->highlight_x, self->priv->highlight_y);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_ != NULL;
			_g_object_unref0 (_tmp29_);
			if (_tmp30_) {
				self->priv->tile_selection = FALSE;
				puzzle_view_queue_draw_tile (self, self->priv->kbd_selected_x, self->priv->kbd_selected_y);
				self->priv->kbd_selected_x = self->priv->highlight_x;
				self->priv->kbd_selected_y = self->priv->highlight_y;
				self->priv->tile_selection = TRUE;
				puzzle_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		} else {
			Tile* tile = NULL;
			Puzzle* _tmp31_;
			Puzzle* _tmp32_;
			Tile* _tmp33_;
			Tile* _tmp34_;
			Puzzle* _tmp37_;
			Puzzle* _tmp38_;
			guint8 _tmp39_;
			guint8 _tmp40_;
			_tmp31_ = puzzle_view_get_puzzle (self);
			_tmp32_ = _tmp31_;
			_tmp33_ = puzzle_get_tile (_tmp32_, self->priv->highlight_x, self->priv->highlight_y);
			tile = _tmp33_;
			_tmp34_ = tile;
			if (_tmp34_ == NULL) {
				Puzzle* _tmp35_;
				Puzzle* _tmp36_;
				_tmp35_ = puzzle_view_get_puzzle (self);
				_tmp36_ = _tmp35_;
				puzzle_try_move (_tmp36_, self->priv->highlight_x, self->priv->highlight_y);
				result = TRUE;
				_g_object_unref0 (tile);
				_g_free0 (key);
				return result;
			}
			_tmp37_ = puzzle_view_get_puzzle (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = puzzle_get_size (_tmp38_);
			_tmp40_ = _tmp39_;
			if (self->priv->highlight_x >= _tmp40_) {
				guint8 x = 0U;
				guint8 y = 0U;
				Puzzle* _tmp41_;
				Puzzle* _tmp42_;
				guint8 _tmp43_ = 0U;
				guint8 _tmp44_ = 0U;
				gboolean _tmp45_;
				_tmp41_ = puzzle_view_get_puzzle (self);
				_tmp42_ = _tmp41_;
				_tmp45_ = puzzle_only_one_remaining_tile (_tmp42_, &_tmp43_, &_tmp44_);
				x = _tmp43_;
				y = _tmp44_;
				if (_tmp45_) {
					guint8 selected_x = 0U;
					guint8 selected_y = 0U;
					Puzzle* _tmp46_;
					Puzzle* _tmp47_;
					Tile* _tmp48_;
					guint8 _tmp49_ = 0U;
					guint8 _tmp50_ = 0U;
					Puzzle* _tmp51_;
					Puzzle* _tmp52_;
					_tmp46_ = puzzle_view_get_puzzle (self);
					_tmp47_ = _tmp46_;
					_tmp48_ = tile;
					puzzle_get_tile_location (_tmp47_, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_TILE, Tile), &_tmp49_, &_tmp50_);
					selected_x = _tmp49_;
					selected_y = _tmp50_;
					_tmp51_ = puzzle_view_get_puzzle (self);
					_tmp52_ = _tmp51_;
					if (puzzle_can_switch (_tmp52_, selected_x, selected_y, x, y)) {
						Puzzle* _tmp53_;
						Puzzle* _tmp54_;
						_tmp53_ = puzzle_view_get_puzzle (self);
						_tmp54_ = _tmp53_;
						puzzle_switch_tiles (_tmp54_, selected_x, selected_y, x, y, PUZZLE_VIEW_final_animation_duration);
						result = TRUE;
						_g_object_unref0 (tile);
						_g_free0 (key);
						return result;
					}
				}
			}
			self->priv->tile_selection = TRUE;
			self->priv->kbd_selected_x = self->priv->highlight_x;
			self->priv->kbd_selected_y = self->priv->highlight_y;
			puzzle_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
			_g_object_unref0 (tile);
		}
		result = TRUE;
		_g_free0 (key);
		return result;
	}
	_tmp63_ = puzzle_view_get_puzzle (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = puzzle_get_size (_tmp64_);
	_tmp66_ = _tmp65_;
	if (((gint) _tmp66_) <= 2) {
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		const gchar* _tmp70_;
		_tmp70_ = key;
		if (g_strcmp0 (_tmp70_, "c") == 0) {
			_tmp69_ = TRUE;
		} else {
			const gchar* _tmp71_;
			_tmp71_ = key;
			_tmp69_ = g_strcmp0 (_tmp71_, "C") == 0;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp72_;
			_tmp72_ = key;
			_tmp68_ = g_strcmp0 (_tmp72_, "3") == 0;
		}
		if (_tmp68_) {
			_tmp67_ = TRUE;
		} else {
			const gchar* _tmp73_;
			_tmp73_ = key;
			_tmp67_ = g_strcmp0 (_tmp73_, "KP_3") == 0;
		}
		_tmp62_ = _tmp67_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		gboolean _tmp74_ = FALSE;
		Puzzle* _tmp75_;
		Puzzle* _tmp76_;
		guint8 _tmp77_;
		guint8 _tmp78_;
		_tmp75_ = puzzle_view_get_puzzle (self);
		_tmp76_ = _tmp75_;
		_tmp77_ = puzzle_get_size (_tmp76_);
		_tmp78_ = _tmp77_;
		if (((gint) _tmp78_) <= 3) {
			gboolean _tmp79_ = FALSE;
			gboolean _tmp80_ = FALSE;
			gboolean _tmp81_ = FALSE;
			const gchar* _tmp82_;
			_tmp82_ = key;
			if (g_strcmp0 (_tmp82_, "d") == 0) {
				_tmp81_ = TRUE;
			} else {
				const gchar* _tmp83_;
				_tmp83_ = key;
				_tmp81_ = g_strcmp0 (_tmp83_, "D") == 0;
			}
			if (_tmp81_) {
				_tmp80_ = TRUE;
			} else {
				const gchar* _tmp84_;
				_tmp84_ = key;
				_tmp80_ = g_strcmp0 (_tmp84_, "4") == 0;
			}
			if (_tmp80_) {
				_tmp79_ = TRUE;
			} else {
				const gchar* _tmp85_;
				_tmp85_ = key;
				_tmp79_ = g_strcmp0 (_tmp85_, "KP_4") == 0;
			}
			_tmp74_ = _tmp79_;
		} else {
			_tmp74_ = FALSE;
		}
		_tmp61_ = _tmp74_;
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		gboolean _tmp86_ = FALSE;
		Puzzle* _tmp87_;
		Puzzle* _tmp88_;
		guint8 _tmp89_;
		guint8 _tmp90_;
		_tmp87_ = puzzle_view_get_puzzle (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = puzzle_get_size (_tmp88_);
		_tmp90_ = _tmp89_;
		if (((gint) _tmp90_) <= 4) {
			gboolean _tmp91_ = FALSE;
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_ = FALSE;
			const gchar* _tmp94_;
			_tmp94_ = key;
			if (g_strcmp0 (_tmp94_, "e") == 0) {
				_tmp93_ = TRUE;
			} else {
				const gchar* _tmp95_;
				_tmp95_ = key;
				_tmp93_ = g_strcmp0 (_tmp95_, "E") == 0;
			}
			if (_tmp93_) {
				_tmp92_ = TRUE;
			} else {
				const gchar* _tmp96_;
				_tmp96_ = key;
				_tmp92_ = g_strcmp0 (_tmp96_, "5") == 0;
			}
			if (_tmp92_) {
				_tmp91_ = TRUE;
			} else {
				const gchar* _tmp97_;
				_tmp97_ = key;
				_tmp91_ = g_strcmp0 (_tmp97_, "KP_5") == 0;
			}
			_tmp86_ = _tmp91_;
		} else {
			_tmp86_ = FALSE;
		}
		_tmp60_ = _tmp86_;
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp98_ = FALSE;
		Puzzle* _tmp99_;
		Puzzle* _tmp100_;
		guint8 _tmp101_;
		guint8 _tmp102_;
		_tmp99_ = puzzle_view_get_puzzle (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = puzzle_get_size (_tmp100_);
		_tmp102_ = _tmp101_;
		if (((gint) _tmp102_) <= 5) {
			gboolean _tmp103_ = FALSE;
			gboolean _tmp104_ = FALSE;
			gboolean _tmp105_ = FALSE;
			const gchar* _tmp106_;
			_tmp106_ = key;
			if (g_strcmp0 (_tmp106_, "f") == 0) {
				_tmp105_ = TRUE;
			} else {
				const gchar* _tmp107_;
				_tmp107_ = key;
				_tmp105_ = g_strcmp0 (_tmp107_, "F") == 0;
			}
			if (_tmp105_) {
				_tmp104_ = TRUE;
			} else {
				const gchar* _tmp108_;
				_tmp108_ = key;
				_tmp104_ = g_strcmp0 (_tmp108_, "6") == 0;
			}
			if (_tmp104_) {
				_tmp103_ = TRUE;
			} else {
				const gchar* _tmp109_;
				_tmp109_ = key;
				_tmp103_ = g_strcmp0 (_tmp109_, "KP_6") == 0;
			}
			_tmp98_ = _tmp103_;
		} else {
			_tmp98_ = FALSE;
		}
		_tmp59_ = _tmp98_;
	}
	if (_tmp59_) {
		_tmp58_ = TRUE;
	} else {
		gboolean _tmp110_ = FALSE;
		Puzzle* _tmp111_;
		Puzzle* _tmp112_;
		guint8 _tmp113_;
		guint8 _tmp114_;
		_tmp111_ = puzzle_view_get_puzzle (self);
		_tmp112_ = _tmp111_;
		_tmp113_ = puzzle_get_size (_tmp112_);
		_tmp114_ = _tmp113_;
		if (((gint) _tmp114_) <= 6) {
			gboolean _tmp115_ = FALSE;
			gboolean _tmp116_ = FALSE;
			gboolean _tmp117_ = FALSE;
			const gchar* _tmp118_;
			_tmp118_ = key;
			if (g_strcmp0 (_tmp118_, "g") == 0) {
				_tmp117_ = TRUE;
			} else {
				const gchar* _tmp119_;
				_tmp119_ = key;
				_tmp117_ = g_strcmp0 (_tmp119_, "G") == 0;
			}
			if (_tmp117_) {
				_tmp116_ = TRUE;
			} else {
				const gchar* _tmp120_;
				_tmp120_ = key;
				_tmp116_ = g_strcmp0 (_tmp120_, "7") == 0;
			}
			if (_tmp116_) {
				_tmp115_ = TRUE;
			} else {
				const gchar* _tmp121_;
				_tmp121_ = key;
				_tmp115_ = g_strcmp0 (_tmp121_, "KP_7") == 0;
			}
			_tmp110_ = _tmp115_;
		} else {
			_tmp110_ = FALSE;
		}
		_tmp58_ = _tmp110_;
	}
	if (_tmp58_) {
		_tmp57_ = TRUE;
	} else {
		gboolean _tmp122_ = FALSE;
		Puzzle* _tmp123_;
		Puzzle* _tmp124_;
		guint8 _tmp125_;
		guint8 _tmp126_;
		_tmp123_ = puzzle_view_get_puzzle (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = puzzle_get_size (_tmp124_);
		_tmp126_ = _tmp125_;
		if (((gint) _tmp126_) <= 7) {
			gboolean _tmp127_ = FALSE;
			gboolean _tmp128_ = FALSE;
			gboolean _tmp129_ = FALSE;
			const gchar* _tmp130_;
			_tmp130_ = key;
			if (g_strcmp0 (_tmp130_, "h") == 0) {
				_tmp129_ = TRUE;
			} else {
				const gchar* _tmp131_;
				_tmp131_ = key;
				_tmp129_ = g_strcmp0 (_tmp131_, "H") == 0;
			}
			if (_tmp129_) {
				_tmp128_ = TRUE;
			} else {
				const gchar* _tmp132_;
				_tmp132_ = key;
				_tmp128_ = g_strcmp0 (_tmp132_, "8") == 0;
			}
			if (_tmp128_) {
				_tmp127_ = TRUE;
			} else {
				const gchar* _tmp133_;
				_tmp133_ = key;
				_tmp127_ = g_strcmp0 (_tmp133_, "KP_8") == 0;
			}
			_tmp122_ = _tmp127_;
		} else {
			_tmp122_ = FALSE;
		}
		_tmp57_ = _tmp122_;
	}
	if (_tmp57_) {
		_tmp56_ = TRUE;
	} else {
		gboolean _tmp134_ = FALSE;
		Puzzle* _tmp135_;
		Puzzle* _tmp136_;
		guint8 _tmp137_;
		guint8 _tmp138_;
		_tmp135_ = puzzle_view_get_puzzle (self);
		_tmp136_ = _tmp135_;
		_tmp137_ = puzzle_get_size (_tmp136_);
		_tmp138_ = _tmp137_;
		if (((gint) _tmp138_) <= 8) {
			gboolean _tmp139_ = FALSE;
			gboolean _tmp140_ = FALSE;
			gboolean _tmp141_ = FALSE;
			const gchar* _tmp142_;
			_tmp142_ = key;
			if (g_strcmp0 (_tmp142_, "i") == 0) {
				_tmp141_ = TRUE;
			} else {
				const gchar* _tmp143_;
				_tmp143_ = key;
				_tmp141_ = g_strcmp0 (_tmp143_, "I") == 0;
			}
			if (_tmp141_) {
				_tmp140_ = TRUE;
			} else {
				const gchar* _tmp144_;
				_tmp144_ = key;
				_tmp140_ = g_strcmp0 (_tmp144_, "9") == 0;
			}
			if (_tmp140_) {
				_tmp139_ = TRUE;
			} else {
				const gchar* _tmp145_;
				_tmp145_ = key;
				_tmp139_ = g_strcmp0 (_tmp145_, "KP_9") == 0;
			}
			_tmp134_ = _tmp139_;
		} else {
			_tmp134_ = FALSE;
		}
		_tmp56_ = _tmp134_;
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		gboolean _tmp146_ = FALSE;
		Puzzle* _tmp147_;
		Puzzle* _tmp148_;
		guint8 _tmp149_;
		guint8 _tmp150_;
		_tmp147_ = puzzle_view_get_puzzle (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = puzzle_get_size (_tmp148_);
		_tmp150_ = _tmp149_;
		if (((gint) _tmp150_) <= 9) {
			gboolean _tmp151_ = FALSE;
			gboolean _tmp152_ = FALSE;
			gboolean _tmp153_ = FALSE;
			const gchar* _tmp154_;
			_tmp154_ = key;
			if (g_strcmp0 (_tmp154_, "j") == 0) {
				_tmp153_ = TRUE;
			} else {
				const gchar* _tmp155_;
				_tmp155_ = key;
				_tmp153_ = g_strcmp0 (_tmp155_, "J") == 0;
			}
			if (_tmp153_) {
				_tmp152_ = TRUE;
			} else {
				const gchar* _tmp156_;
				_tmp156_ = key;
				_tmp152_ = g_strcmp0 (_tmp156_, "0") == 0;
			}
			if (_tmp152_) {
				_tmp151_ = TRUE;
			} else {
				const gchar* _tmp157_;
				_tmp157_ = key;
				_tmp151_ = g_strcmp0 (_tmp157_, "KP_0") == 0;
			}
			_tmp146_ = _tmp151_;
		} else {
			_tmp146_ = FALSE;
		}
		_tmp55_ = _tmp146_;
	}
	if (_tmp55_) {
		result = FALSE;
		_g_free0 (key);
		return result;
	}
	self->priv->old_highlight_x = self->priv->highlight_x;
	self->priv->old_highlight_y = self->priv->highlight_y;
	_tmp158_ = key;
	_tmp159_ = _tmp158_;
	_tmp161_ = (NULL == _tmp159_) ? 0 : g_quark_from_string (_tmp159_);
	if ((_tmp161_ == ((0 != _tmp160_label0) ? _tmp160_label0 : (_tmp160_label0 = g_quark_from_static_string ("Up")))) || (_tmp161_ == ((0 != _tmp160_label1) ? _tmp160_label1 : (_tmp160_label1 = g_quark_from_static_string ("KP_Up"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				if (((gint) self->priv->highlight_y) > 0) {
					guint8 _tmp162_;
					_tmp162_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp162_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label2) ? _tmp160_label2 : (_tmp160_label2 = g_quark_from_static_string ("Left")))) || (_tmp161_ == ((0 != _tmp160_label3) ? _tmp160_label3 : (_tmp160_label3 = g_quark_from_static_string ("KP_Left"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				if (((gint) self->priv->highlight_x) > 0) {
					guint8 _tmp163_;
					_tmp163_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp163_ - 1;
				}
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label4) ? _tmp160_label4 : (_tmp160_label4 = g_quark_from_static_string ("Right")))) || (_tmp161_ == ((0 != _tmp160_label5) ? _tmp160_label5 : (_tmp160_label5 = g_quark_from_static_string ("KP_Right"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp164_;
				Puzzle* _tmp165_;
				guint8 _tmp166_;
				guint8 _tmp167_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp164_ = puzzle_view_get_puzzle (self);
				_tmp165_ = _tmp164_;
				_tmp166_ = puzzle_get_size (_tmp165_);
				_tmp167_ = _tmp166_;
				if (((gint) self->priv->highlight_x) < ((_tmp167_ * 2) - 1)) {
					guint8 _tmp168_;
					_tmp168_ = self->priv->highlight_x;
					self->priv->highlight_x = _tmp168_ + 1;
				}
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label6) ? _tmp160_label6 : (_tmp160_label6 = g_quark_from_static_string ("Down")))) || (_tmp161_ == ((0 != _tmp160_label7) ? _tmp160_label7 : (_tmp160_label7 = g_quark_from_static_string ("KP_Down"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp169_;
				Puzzle* _tmp170_;
				guint8 _tmp171_;
				guint8 _tmp172_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp169_ = puzzle_view_get_puzzle (self);
				_tmp170_ = _tmp169_;
				_tmp171_ = puzzle_get_size (_tmp170_);
				_tmp172_ = _tmp171_;
				if (((gint) self->priv->highlight_y) < (_tmp172_ - 1)) {
					guint8 _tmp173_;
					_tmp173_ = self->priv->highlight_y;
					self->priv->highlight_y = _tmp173_ + 1;
				}
				break;
			}
		}
	} else if (((_tmp161_ == ((0 != _tmp160_label8) ? _tmp160_label8 : (_tmp160_label8 = g_quark_from_static_string ("space")))) || (_tmp161_ == ((0 != _tmp160_label9) ? _tmp160_label9 : (_tmp160_label9 = g_quark_from_static_string ("Return"))))) || (_tmp161_ == ((0 != _tmp160_label10) ? _tmp160_label10 : (_tmp160_label10 = g_quark_from_static_string ("KP_Enter"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label11) ? _tmp160_label11 : (_tmp160_label11 = g_quark_from_static_string ("Escape")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label12) ? _tmp160_label12 : (_tmp160_label12 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 0;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label13) ? _tmp160_label13 : (_tmp160_label13 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 1;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label14) ? _tmp160_label14 : (_tmp160_label14 = g_quark_from_static_string ("c")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 2;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label15) ? _tmp160_label15 : (_tmp160_label15 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 3;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label16) ? _tmp160_label16 : (_tmp160_label16 = g_quark_from_static_string ("e")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 4;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label17) ? _tmp160_label17 : (_tmp160_label17 = g_quark_from_static_string ("f")))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 5;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label18) ? _tmp160_label18 : (_tmp160_label18 = g_quark_from_static_string ("A")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp174_;
				Puzzle* _tmp175_;
				guint8 _tmp176_;
				guint8 _tmp177_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp174_ = puzzle_view_get_puzzle (self);
				_tmp175_ = _tmp174_;
				_tmp176_ = puzzle_get_size (_tmp175_);
				_tmp177_ = _tmp176_;
				self->priv->highlight_x = _tmp177_;
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label19) ? _tmp160_label19 : (_tmp160_label19 = g_quark_from_static_string ("B")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp178_;
				Puzzle* _tmp179_;
				guint8 _tmp180_;
				guint8 _tmp181_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp178_ = puzzle_view_get_puzzle (self);
				_tmp179_ = _tmp178_;
				_tmp180_ = puzzle_get_size (_tmp179_);
				_tmp181_ = _tmp180_;
				self->priv->highlight_x = (guint8) (_tmp181_ + 1);
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label20) ? _tmp160_label20 : (_tmp160_label20 = g_quark_from_static_string ("C")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp182_;
				Puzzle* _tmp183_;
				guint8 _tmp184_;
				guint8 _tmp185_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp182_ = puzzle_view_get_puzzle (self);
				_tmp183_ = _tmp182_;
				_tmp184_ = puzzle_get_size (_tmp183_);
				_tmp185_ = _tmp184_;
				self->priv->highlight_x = (guint8) (_tmp185_ + 2);
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label21) ? _tmp160_label21 : (_tmp160_label21 = g_quark_from_static_string ("D")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp186_;
				Puzzle* _tmp187_;
				guint8 _tmp188_;
				guint8 _tmp189_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp186_ = puzzle_view_get_puzzle (self);
				_tmp187_ = _tmp186_;
				_tmp188_ = puzzle_get_size (_tmp187_);
				_tmp189_ = _tmp188_;
				self->priv->highlight_x = (guint8) (_tmp189_ + 3);
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label22) ? _tmp160_label22 : (_tmp160_label22 = g_quark_from_static_string ("E")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp190_;
				Puzzle* _tmp191_;
				guint8 _tmp192_;
				guint8 _tmp193_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp190_ = puzzle_view_get_puzzle (self);
				_tmp191_ = _tmp190_;
				_tmp192_ = puzzle_get_size (_tmp191_);
				_tmp193_ = _tmp192_;
				self->priv->highlight_x = (guint8) (_tmp193_ + 4);
				break;
			}
		}
	} else if (_tmp161_ == ((0 != _tmp160_label23) ? _tmp160_label23 : (_tmp160_label23 = g_quark_from_static_string ("F")))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp194_;
				Puzzle* _tmp195_;
				guint8 _tmp196_;
				guint8 _tmp197_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp194_ = puzzle_view_get_puzzle (self);
				_tmp195_ = _tmp194_;
				_tmp196_ = puzzle_get_size (_tmp195_);
				_tmp197_ = _tmp196_;
				self->priv->highlight_x = (guint8) (_tmp197_ + 5);
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label24) ? _tmp160_label24 : (_tmp160_label24 = g_quark_from_static_string ("1")))) || (_tmp161_ == ((0 != _tmp160_label25) ? _tmp160_label25 : (_tmp160_label25 = g_quark_from_static_string ("KP_1"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label26) ? _tmp160_label26 : (_tmp160_label26 = g_quark_from_static_string ("2")))) || (_tmp161_ == ((0 != _tmp160_label27) ? _tmp160_label27 : (_tmp160_label27 = g_quark_from_static_string ("KP_2"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 1;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label28) ? _tmp160_label28 : (_tmp160_label28 = g_quark_from_static_string ("3")))) || (_tmp161_ == ((0 != _tmp160_label29) ? _tmp160_label29 : (_tmp160_label29 = g_quark_from_static_string ("KP_3"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 2;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label30) ? _tmp160_label30 : (_tmp160_label30 = g_quark_from_static_string ("4")))) || (_tmp161_ == ((0 != _tmp160_label31) ? _tmp160_label31 : (_tmp160_label31 = g_quark_from_static_string ("KP_4"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 3;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label32) ? _tmp160_label32 : (_tmp160_label32 = g_quark_from_static_string ("5")))) || (_tmp161_ == ((0 != _tmp160_label33) ? _tmp160_label33 : (_tmp160_label33 = g_quark_from_static_string ("KP_5"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 4;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label34) ? _tmp160_label34 : (_tmp160_label34 = g_quark_from_static_string ("6")))) || (_tmp161_ == ((0 != _tmp160_label35) ? _tmp160_label35 : (_tmp160_label35 = g_quark_from_static_string ("KP_6"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 5;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label36) ? _tmp160_label36 : (_tmp160_label36 = g_quark_from_static_string ("Home")))) || (_tmp161_ == ((0 != _tmp160_label37) ? _tmp160_label37 : (_tmp160_label37 = g_quark_from_static_string ("KP_Home"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_x = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label38) ? _tmp160_label38 : (_tmp160_label38 = g_quark_from_static_string ("End")))) || (_tmp161_ == ((0 != _tmp160_label39) ? _tmp160_label39 : (_tmp160_label39 = g_quark_from_static_string ("KP_End"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp198_;
				Puzzle* _tmp199_;
				guint8 _tmp200_;
				guint8 _tmp201_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp198_ = puzzle_view_get_puzzle (self);
				_tmp199_ = _tmp198_;
				_tmp200_ = puzzle_get_size (_tmp199_);
				_tmp201_ = _tmp200_;
				self->priv->highlight_x = (guint8) ((_tmp201_ * 2) - 1);
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label40) ? _tmp160_label40 : (_tmp160_label40 = g_quark_from_static_string ("Page_Up")))) || (_tmp161_ == ((0 != _tmp160_label41) ? _tmp160_label41 : (_tmp160_label41 = g_quark_from_static_string ("KP_Page_Up"))))) {
		switch (0) {
			default:
			{
				puzzle_view_set_highlight_position_if_needed (self);
				self->priv->highlight_y = (guint8) 0;
				break;
			}
		}
	} else if ((_tmp161_ == ((0 != _tmp160_label42) ? _tmp160_label42 : (_tmp160_label42 = g_quark_from_static_string ("Page_Down")))) || (_tmp161_ == ((0 != _tmp160_label43) ? _tmp160_label43 : (_tmp160_label43 = g_quark_from_static_string ("KP_Next"))))) {
		switch (0) {
			default:
			{
				Puzzle* _tmp202_;
				Puzzle* _tmp203_;
				guint8 _tmp204_;
				guint8 _tmp205_;
				puzzle_view_set_highlight_position_if_needed (self);
				_tmp202_ = puzzle_view_get_puzzle (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = puzzle_get_size (_tmp203_);
				_tmp205_ = _tmp204_;
				self->priv->highlight_y = (guint8) (_tmp205_ - 1);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (key);
				return result;
			}
		}
	}
	self->priv->highlight_set = TRUE;
	_tmp206_ = key;
	if (g_strcmp0 (_tmp206_, "Escape") == 0) {
		if (self->priv->tile_selection) {
			puzzle_view_clear_keyboard_highlight (self, TRUE);
		} else {
			puzzle_view_clear_keyboard_highlight (self, FALSE);
		}
	} else {
		self->priv->show_highlight = TRUE;
	}
	puzzle_view_queue_draw_tile (self, self->priv->old_highlight_x, self->priv->old_highlight_y);
	if (self->priv->old_highlight_x != self->priv->highlight_x) {
		_tmp207_ = TRUE;
	} else {
		_tmp207_ = self->priv->old_highlight_y != self->priv->highlight_y;
	}
	if (_tmp207_) {
		puzzle_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
	}
	result = TRUE;
	_g_free0 (key);
	return result;
}

static void
puzzle_view_set_highlight_position_if_needed (PuzzleView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->highlight_set) {
		return;
	}
	puzzle_view_set_highlight_position (self);
}

static void
puzzle_view_set_highlight_position (PuzzleView* self)
{
	Puzzle* _tmp0_;
	Puzzle* _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = puzzle_view_get_puzzle (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = puzzle_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->highlight_x = _tmp3_;
	self->priv->highlight_y = (guint8) 0;
}

static void
puzzle_view_clear_keyboard_highlight (PuzzleView* self,
                                      gboolean only_selection)
{
	g_return_if_fail (self != NULL);
	if (!only_selection) {
		self->priv->show_highlight = FALSE;
		puzzle_view_queue_draw_tile (self, self->priv->highlight_x, self->priv->highlight_y);
		self->priv->highlight_set = FALSE;
		self->priv->highlight_x = G_MAXUINT8;
		self->priv->highlight_y = G_MAXUINT8;
		self->priv->old_highlight_x = G_MAXUINT8;
		self->priv->old_highlight_y = G_MAXUINT8;
	}
	if (self->priv->tile_selection) {
		self->priv->tile_selection = FALSE;
		puzzle_view_queue_draw_tile (self, self->priv->kbd_selected_x, self->priv->kbd_selected_y);
		self->priv->kbd_selected_x = G_MAXUINT8;
		self->priv->kbd_selected_y = G_MAXUINT8;
	}
}

void
puzzle_view_disable_highlight (PuzzleView* self)
{
	g_return_if_fail (self != NULL);
	puzzle_view_clear_keyboard_highlight (self, FALSE);
}

void
puzzle_view_move_up (PuzzleView* self,
                     gboolean left_board)
{
	PuzzleViewTileImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		_tmp1_ = puzzle_view_get_puzzle (self);
		_tmp2_ = _tmp1_;
		puzzle_move_up (_tmp2_, left_board);
	}
}

void
puzzle_view_move_down (PuzzleView* self,
                       gboolean left_board)
{
	PuzzleViewTileImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		_tmp1_ = puzzle_view_get_puzzle (self);
		_tmp2_ = _tmp1_;
		puzzle_move_down (_tmp2_, left_board);
	}
}

void
puzzle_view_move_left (PuzzleView* self,
                       gboolean left_board)
{
	PuzzleViewTileImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		_tmp1_ = puzzle_view_get_puzzle (self);
		_tmp2_ = _tmp1_;
		puzzle_move_left (_tmp2_, left_board);
	}
}

void
puzzle_view_move_right (PuzzleView* self,
                        gboolean left_board)
{
	PuzzleViewTileImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_tile;
	if (_tmp0_ == NULL) {
		Puzzle* _tmp1_;
		Puzzle* _tmp2_;
		_tmp1_ = puzzle_view_get_puzzle (self);
		_tmp2_ = _tmp1_;
		puzzle_move_right (_tmp2_, left_board);
	}
}

PuzzleView*
puzzle_view_construct (GType object_type)
{
	PuzzleView * self = NULL;
	self = (PuzzleView*) g_object_new (object_type, NULL);
	return self;
}

PuzzleView*
puzzle_view_new (void)
{
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
}

static Puzzle*
puzzle_view_get_puzzle (PuzzleView* self)
{
	Puzzle* result;
	Puzzle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->puzzle_init_done) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_puzzle;
	result = _tmp0_;
	return result;
}

static void
_puzzle_view_puzzle___lambda5_ (PuzzleView* self)
{
	puzzle_view_clear_keyboard_highlight (self, TRUE);
}

static void
__puzzle_view_puzzle___lambda5__puzzle_solved (Puzzle* _sender,
                                               gpointer self)
{
	_puzzle_view_puzzle___lambda5_ ((PuzzleView*) self);
}

static void
_puzzle_view_tile_moved_cb_puzzle_tile_moved (Puzzle* _sender,
                                              Tile* tile,
                                              guint8 x,
                                              guint8 y,
                                              gpointer self)
{
	puzzle_view_tile_moved_cb ((PuzzleView*) self, _sender, tile, x, y);
}

static void
_gtk_widget_queue_draw_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
puzzle_view_set_puzzle (PuzzleView* self,
                        Puzzle* value)
{
	guint8 old_puzzle_size = 0U;
	Puzzle* _tmp4_;
	GHashTable* _tmp5_;
	Puzzle* _tmp27_;
	guint8 _tmp28_;
	guint8 _tmp29_;
	Puzzle* _tmp44_;
	Puzzle* _tmp45_;
	Puzzle* _tmp46_;
	g_return_if_fail (self != NULL);
	puzzle_view_show_right_sockets (self);
	old_puzzle_size = (guint8) 0;
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp0_;
		guint8 _tmp1_;
		guint8 _tmp2_;
		Puzzle* _tmp3_;
		_tmp0_ = self->priv->_puzzle;
		_tmp1_ = puzzle_get_size (_tmp0_);
		_tmp2_ = _tmp1_;
		old_puzzle_size = _tmp2_;
		_tmp3_ = self->priv->_puzzle;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_tmp4_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_puzzle);
	self->priv->_puzzle = _tmp4_;
	self->priv->puzzle_init_done = TRUE;
	_g_object_unref0 (self->priv->last_selected_tile);
	self->priv->last_selected_tile = NULL;
	_tmp5_ = self->priv->tiles;
	g_hash_table_remove_all (_tmp5_);
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				Puzzle* _tmp8_;
				guint8 _tmp9_;
				guint8 _tmp10_;
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = y;
					y = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->_puzzle;
				_tmp9_ = puzzle_get_size (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(y < _tmp10_)) {
					break;
				}
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							Puzzle* _tmp13_;
							guint8 _tmp14_;
							guint8 _tmp15_;
							Tile* tile = NULL;
							Puzzle* _tmp16_;
							Tile* _tmp17_;
							Tile* _tmp18_;
							PuzzleViewTileImage* image = NULL;
							Tile* _tmp19_;
							PuzzleViewTileImage* _tmp20_;
							PuzzleViewTileImage* _tmp21_;
							GHashTable* _tmp22_;
							Tile* _tmp23_;
							Tile* _tmp24_;
							PuzzleViewTileImage* _tmp25_;
							PuzzleViewTileImage* _tmp26_;
							if (!_tmp11_) {
								guint8 _tmp12_;
								_tmp12_ = x;
								x = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							_tmp13_ = self->priv->_puzzle;
							_tmp14_ = puzzle_get_size (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(((gint) x) < (_tmp15_ * 2))) {
								break;
							}
							_tmp16_ = self->priv->_puzzle;
							_tmp17_ = puzzle_get_tile (_tmp16_, x, y);
							tile = _tmp17_;
							_tmp18_ = tile;
							if (_tmp18_ == NULL) {
								_g_object_unref0 (tile);
								continue;
							}
							_tmp19_ = tile;
							_tmp20_ = puzzle_view_tile_image_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_TILE, Tile));
							image = _tmp20_;
							_tmp21_ = image;
							puzzle_view_move_tile_to_location (self, _tmp21_, (guint) x, (guint) y, (gdouble) 0);
							_tmp22_ = self->priv->tiles;
							_tmp23_ = tile;
							_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_TILE, Tile));
							_tmp25_ = image;
							_tmp26_ = _g_object_ref0 (_tmp25_);
							g_hash_table_insert (_tmp22_, _tmp24_, _tmp26_);
							_g_object_unref0 (image);
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp27_ = self->priv->_puzzle;
	_tmp28_ = puzzle_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	if (old_puzzle_size != _tmp29_) {
		Puzzle* _tmp30_;
		guint8 _tmp31_;
		guint8 _tmp32_;
		Puzzle* _tmp33_;
		guint8 _tmp34_;
		guint8 _tmp35_;
		gdouble* _tmp36_;
		Puzzle* _tmp37_;
		guint8 _tmp38_;
		guint8 _tmp39_;
		Puzzle* _tmp40_;
		guint8 _tmp41_;
		guint8 _tmp42_;
		gdouble* _tmp43_;
		_cairo_pattern_destroy0 (self->priv->arrow_pattern);
		self->priv->arrow_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->socket_pattern);
		self->priv->socket_pattern = NULL;
		_tmp30_ = self->priv->_puzzle;
		_tmp31_ = puzzle_get_size (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->_puzzle;
		_tmp34_ = puzzle_get_size (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_new0 (gdouble, (2 * _tmp32_) * _tmp35_);
		self->priv->sockets_xs = (g_free (self->priv->sockets_xs), NULL);
		self->priv->sockets_xs = _tmp36_;
		self->priv->sockets_xs_length1 = 2 * _tmp32_;
		self->priv->sockets_xs_length2 = _tmp35_;
		_tmp37_ = self->priv->_puzzle;
		_tmp38_ = puzzle_get_size (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->_puzzle;
		_tmp41_ = puzzle_get_size (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_new0 (gdouble, (2 * _tmp39_) * _tmp42_);
		self->priv->sockets_ys = (g_free (self->priv->sockets_ys), NULL);
		self->priv->sockets_ys = _tmp43_;
		self->priv->sockets_ys_length1 = 2 * _tmp39_;
		self->priv->sockets_ys_length2 = _tmp42_;
	}
	puzzle_view_set_highlight_position (self);
	_tmp44_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp44_, "solved", (GCallback) __puzzle_view_puzzle___lambda5__puzzle_solved, self, 0);
	_tmp45_ = self->priv->_puzzle;
	g_signal_connect_object (_tmp45_, "tile-moved", (GCallback) _puzzle_view_tile_moved_cb_puzzle_tile_moved, self, 0);
	_tmp46_ = self->priv->_puzzle;
	g_signal_connect_object ((GObject*) _tmp46_, "notify::paused", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

void
puzzle_view_set_theme_id (PuzzleView* self,
                          const gchar* value)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	Theme* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("neoretro")))) {
		switch (0) {
			default:
			{
				NeoRetroTheme* _tmp3_;
				_tmp3_ = neo_retro_theme_new ();
				_g_object_unref0 (self->priv->theme);
				self->priv->theme = (Theme*) _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("nostalgia")))) {
		switch (0) {
			default:
			{
				NostalgiaTheme* _tmp4_;
				_tmp4_ = nostalgia_theme_new ();
				_g_object_unref0 (self->priv->theme);
				self->priv->theme = (Theme*) _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("synesthesia")))) {
		switch (0) {
			default:
			{
				SynesthesiaTheme* _tmp5_;
				_tmp5_ = synesthesia_theme_new ();
				_g_object_unref0 (self->priv->theme);
				self->priv->theme = (Theme*) _tmp5_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				ExtrusionTheme* _tmp6_;
				_tmp6_ = extrusion_theme_new ();
				_g_object_unref0 (self->priv->theme);
				self->priv->theme = (Theme*) _tmp6_;
				break;
			}
		}
	}
	if (self->priv->tilesize != ((guint) 0)) {
		Theme* _tmp7_;
		_tmp7_ = self->priv->theme;
		theme_configure (_tmp7_, self->priv->tilesize);
	}
	_cairo_pattern_destroy0 (self->priv->arrow_pattern);
	self->priv->arrow_pattern = NULL;
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = NULL;
	_tmp8_ = self->priv->theme;
	theme_set_animation_level (_tmp8_, self->priv->socket_animation_level);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_THEME_ID_PROPERTY]);
}

gboolean
puzzle_view_get_tile_selected (PuzzleView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tile_selected;
	return result;
}

static void
puzzle_view_set_tile_selected (PuzzleView* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = puzzle_view_get_tile_selected (self);
	if (old_value != value) {
		self->priv->_tile_selected = value;
		g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_TILE_SELECTED_PROPERTY]);
	}
}

guint
puzzle_view_get_boardsize (PuzzleView* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_boardsize;
	return result;
}

static void
puzzle_view_set_boardsize (PuzzleView* self,
                           guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = puzzle_view_get_boardsize (self);
	if (old_value != value) {
		self->priv->_boardsize = value;
		g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_BOARDSIZE_PROPERTY]);
	}
}

gdouble
puzzle_view_get_x_offset_right (PuzzleView* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_x_offset_right;
	return result;
}

static void
puzzle_view_set_x_offset_right (PuzzleView* self,
                                gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = puzzle_view_get_x_offset_right (self);
	if (old_value != value) {
		self->priv->_x_offset_right = value;
		g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY]);
	}
}

gdouble
puzzle_view_get_y_offset (PuzzleView* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_y_offset;
	return result;
}

static void
puzzle_view_set_y_offset (PuzzleView* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = puzzle_view_get_y_offset (self);
	if (old_value != value) {
		self->priv->_y_offset = value;
		g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_Y_OFFSET_PROPERTY]);
	}
}

gdouble
puzzle_view_get_right_margin (PuzzleView* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_right_margin;
	return result;
}

static void
puzzle_view_set_right_margin (PuzzleView* self,
                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = puzzle_view_get_right_margin (self);
	if (old_value != value) {
		self->priv->_right_margin = value;
		g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY]);
	}
}

static gboolean
puzzle_view_get_mouse_use_extra_buttons (PuzzleView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mouse_use_extra_buttons;
	return result;
}

void
puzzle_view_set_mouse_use_extra_buttons (PuzzleView* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_use_extra_buttons = value;
}

static gint
puzzle_view_get_mouse_back_button (PuzzleView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mouse_back_button;
	return result;
}

void
puzzle_view_set_mouse_back_button (PuzzleView* self,
                                   gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_back_button = value;
}

static gint
puzzle_view_get_mouse_forward_button (PuzzleView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mouse_forward_button;
	return result;
}

void
puzzle_view_set_mouse_forward_button (PuzzleView* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mouse_forward_button = value;
}

static PuzzleViewTileImage*
puzzle_view_tile_image_construct (GType object_type,
                                  Tile* tile)
{
	PuzzleViewTileImage * self = NULL;
	Tile* _tmp0_;
	g_return_val_if_fail (tile != NULL, NULL);
	self = (PuzzleViewTileImage*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (tile);
	_g_object_unref0 (self->tile);
	self->tile = _tmp0_;
	return self;
}

static PuzzleViewTileImage*
puzzle_view_tile_image_new (Tile* tile)
{
	return puzzle_view_tile_image_construct (PUZZLE_VIEW_TYPE_TILE_IMAGE, tile);
}

static void
puzzle_view_tile_image_class_init (PuzzleViewTileImageClass * klass,
                                   gpointer klass_data)
{
	puzzle_view_tile_image_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_tile_image_finalize;
}

static void
puzzle_view_tile_image_instance_init (PuzzleViewTileImage * self,
                                      gpointer klass)
{
	self->x = 0.0;
	self->y = 0.0;
	self->source_x = 0.0;
	self->source_y = 0.0;
	self->source_time = 0.0;
	self->target_x = 0.0;
	self->target_y = 0.0;
	self->duration = 0.0;
	self->snap_to_cursor = TRUE;
}

static void
puzzle_view_tile_image_finalize (GObject * obj)
{
	PuzzleViewTileImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUZZLE_VIEW_TYPE_TILE_IMAGE, PuzzleViewTileImage);
	_g_object_unref0 (self->tile);
	G_OBJECT_CLASS (puzzle_view_tile_image_parent_class)->finalize (obj);
}

static GType
puzzle_view_tile_image_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewTileImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_tile_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleViewTileImage), 0, (GInstanceInitFunc) puzzle_view_tile_image_instance_init, NULL };
	GType puzzle_view_tile_image_type_id;
	puzzle_view_tile_image_type_id = g_type_register_static (G_TYPE_OBJECT, "PuzzleViewTileImage", &g_define_type_info, 0);
	return puzzle_view_tile_image_type_id;
}

static GType
puzzle_view_tile_image_get_type (void)
{
	static volatile gsize puzzle_view_tile_image_type_id__once = 0;
	if (g_once_init_enter (&puzzle_view_tile_image_type_id__once)) {
		GType puzzle_view_tile_image_type_id;
		puzzle_view_tile_image_type_id = puzzle_view_tile_image_get_type_once ();
		g_once_init_leave (&puzzle_view_tile_image_type_id__once, puzzle_view_tile_image_type_id);
	}
	return puzzle_view_tile_image_type_id__once;
}

static GObject *
puzzle_view_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PuzzleView * self;
	GTimer* _tmp0_;
	parent_class = G_OBJECT_CLASS (puzzle_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	puzzle_view_init_mouse (self);
	puzzle_view_init_keyboard (self);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK));
	_tmp0_ = self->priv->animation_timer;
	g_timer_start (_tmp0_);
	return obj;
}

static void
puzzle_view_class_init (PuzzleViewClass * klass,
                        gpointer klass_data)
{
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PuzzleView_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) puzzle_view_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) puzzle_view_real_get_preferred_height;
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) puzzle_view_real_configure_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) puzzle_view_real_draw;
	((GtkWidgetClass *) klass)->leave_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) puzzle_view_real_leave_notify_event;
	((GtkWidgetClass *) klass)->enter_notify_event = (gboolean (*) (GtkWidget*, GdkEventCrossing*)) puzzle_view_real_enter_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = puzzle_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY] = g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_THEME_ID_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_THEME_ID_PROPERTY] = g_param_spec_string ("theme-id", "theme-id", "theme-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_TILE_SELECTED_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_TILE_SELECTED_PROPERTY] = g_param_spec_boolean ("tile-selected", "tile-selected", "tile-selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_BOARDSIZE_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_BOARDSIZE_PROPERTY] = g_param_spec_uint ("boardsize", "boardsize", "boardsize", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY] = g_param_spec_double ("x-offset-right", "x-offset-right", "x-offset-right", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_Y_OFFSET_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_Y_OFFSET_PROPERTY] = g_param_spec_double ("y-offset", "y-offset", "y-offset", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY] = g_param_spec_double ("right-margin", "right-margin", "right-margin", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY] = g_param_spec_boolean ("mouse-use-extra-buttons", "mouse-use-extra-buttons", "mouse-use-extra-buttons", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_MOUSE_BACK_BUTTON_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_MOUSE_BACK_BUTTON_PROPERTY] = g_param_spec_int ("mouse-back-button", "mouse-back-button", "mouse-back-button", G_MININT, G_MAXINT, 8, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_MOUSE_FORWARD_BUTTON_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_MOUSE_FORWARD_BUTTON_PROPERTY] = g_param_spec_int ("mouse-forward-button", "mouse-forward-button", "mouse-forward-button", G_MININT, G_MAXINT, 9, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
puzzle_view_instance_init (PuzzleView * self,
                           gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GTimer* _tmp3_;
	self->priv = puzzle_view_get_instance_private (self);
	self->priv->puzzle_init_done = FALSE;
	self->priv->selected_tile = NULL;
	self->priv->last_selected_tile = NULL;
	self->priv->_tile_selected = FALSE;
	self->priv->selection_timeout = (guint) 0;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_object_unref0_);
	self->priv->tiles = _tmp2_;
	_tmp3_ = g_timer_new ();
	self->priv->animation_timer = _tmp3_;
	self->priv->animation_timeout = (guint) 0;
	self->priv->_boardsize = (guint) 0;
	self->priv->_x_offset_right = (gdouble) 0;
	self->priv->_y_offset = (gdouble) 0;
	self->priv->_right_margin = (gdouble) 0;
	self->priv->x_offset = 0.0;
	self->priv->tilesize = (guint) 0;
	self->priv->gap = (guint) 0;
	self->priv->arrow_x = 0.0;
	self->priv->arrow_local_y = 0.0;
	self->priv->board_x_maxi = 0;
	self->priv->board_y_maxi = 0;
	self->priv->snap_distance = 0.0;
	self->priv->render_size = (guint) 0;
	self->priv->arrow_pattern = NULL;
	self->priv->socket_pattern = NULL;
	self->priv->_mouse_use_extra_buttons = TRUE;
	self->priv->_mouse_back_button = 8;
	self->priv->_mouse_forward_button = 9;
	self->priv->socket_animation_level = (guint8) 0;
	self->priv->socket_timeout_id = (guint) 0;
	self->priv->show_highlight = FALSE;
	self->priv->highlight_set = FALSE;
	self->priv->highlight_x = G_MAXUINT8;
	self->priv->highlight_y = G_MAXUINT8;
	self->priv->old_highlight_x = G_MAXUINT8;
	self->priv->old_highlight_y = G_MAXUINT8;
	self->priv->tile_selection = FALSE;
	self->priv->kbd_selected_x = G_MAXUINT8;
	self->priv->kbd_selected_y = G_MAXUINT8;
}

static void
puzzle_view_finalize (GObject * obj)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
	_g_object_unref0 (self->priv->_puzzle);
	_g_object_unref0 (self->priv->theme);
	_g_object_unref0 (self->priv->selected_tile);
	_g_object_unref0 (self->priv->last_selected_tile);
	_g_hash_table_unref0 (self->priv->tiles);
	_g_timer_destroy0 (self->priv->animation_timer);
	self->priv->sockets_xs = (g_free (self->priv->sockets_xs), NULL);
	self->priv->sockets_ys = (g_free (self->priv->sockets_ys), NULL);
	_cairo_pattern_destroy0 (self->priv->arrow_pattern);
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	_g_object_unref0 (self->priv->motion_controller);
	_g_object_unref0 (self->priv->click_controller);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
}

static GType
puzzle_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
	GType puzzle_view_type_id;
	puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
	PuzzleView_private_offset = g_type_add_instance_private (puzzle_view_type_id, sizeof (PuzzleViewPrivate));
	return puzzle_view_type_id;
}

GType
puzzle_view_get_type (void)
{
	static volatile gsize puzzle_view_type_id__once = 0;
	if (g_once_init_enter (&puzzle_view_type_id__once)) {
		GType puzzle_view_type_id;
		puzzle_view_type_id = puzzle_view_get_type_once ();
		g_once_init_leave (&puzzle_view_type_id__once, puzzle_view_type_id);
	}
	return puzzle_view_type_id__once;
}

static void
_vala_puzzle_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
		g_value_set_object (value, puzzle_view_get_puzzle (self));
		break;
		case PUZZLE_VIEW_TILE_SELECTED_PROPERTY:
		g_value_set_boolean (value, puzzle_view_get_tile_selected (self));
		break;
		case PUZZLE_VIEW_BOARDSIZE_PROPERTY:
		g_value_set_uint (value, puzzle_view_get_boardsize (self));
		break;
		case PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY:
		g_value_set_double (value, puzzle_view_get_x_offset_right (self));
		break;
		case PUZZLE_VIEW_Y_OFFSET_PROPERTY:
		g_value_set_double (value, puzzle_view_get_y_offset (self));
		break;
		case PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY:
		g_value_set_double (value, puzzle_view_get_right_margin (self));
		break;
		case PUZZLE_VIEW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY:
		g_value_set_boolean (value, puzzle_view_get_mouse_use_extra_buttons (self));
		break;
		case PUZZLE_VIEW_MOUSE_BACK_BUTTON_PROPERTY:
		g_value_set_int (value, puzzle_view_get_mouse_back_button (self));
		break;
		case PUZZLE_VIEW_MOUSE_FORWARD_BUTTON_PROPERTY:
		g_value_set_int (value, puzzle_view_get_mouse_forward_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_puzzle_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
	switch (property_id) {
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
		puzzle_view_set_puzzle (self, g_value_get_object (value));
		break;
		case PUZZLE_VIEW_THEME_ID_PROPERTY:
		puzzle_view_set_theme_id (self, g_value_get_string (value));
		break;
		case PUZZLE_VIEW_TILE_SELECTED_PROPERTY:
		puzzle_view_set_tile_selected (self, g_value_get_boolean (value));
		break;
		case PUZZLE_VIEW_BOARDSIZE_PROPERTY:
		puzzle_view_set_boardsize (self, g_value_get_uint (value));
		break;
		case PUZZLE_VIEW_X_OFFSET_RIGHT_PROPERTY:
		puzzle_view_set_x_offset_right (self, g_value_get_double (value));
		break;
		case PUZZLE_VIEW_Y_OFFSET_PROPERTY:
		puzzle_view_set_y_offset (self, g_value_get_double (value));
		break;
		case PUZZLE_VIEW_RIGHT_MARGIN_PROPERTY:
		puzzle_view_set_right_margin (self, g_value_get_double (value));
		break;
		case PUZZLE_VIEW_MOUSE_USE_EXTRA_BUTTONS_PROPERTY:
		puzzle_view_set_mouse_use_extra_buttons (self, g_value_get_boolean (value));
		break;
		case PUZZLE_VIEW_MOUSE_BACK_BUTTON_PROPERTY:
		puzzle_view_set_mouse_back_button (self, g_value_get_int (value));
		break;
		case PUZZLE_VIEW_MOUSE_FORWARD_BUTTON_PROPERTY:
		puzzle_view_set_mouse_forward_button (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

