/* trigger.c generated by valac 0.56.18, the Vala compiler
 * generated from trigger.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_TRIGGER (gnome_pie_trigger_get_type ())
#define GNOME_PIE_TRIGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_TRIGGER, GnomePieTrigger))
#define GNOME_PIE_TRIGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_TRIGGER, GnomePieTriggerClass))
#define GNOME_PIE_IS_TRIGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_TRIGGER))
#define GNOME_PIE_IS_TRIGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_TRIGGER))
#define GNOME_PIE_TRIGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_TRIGGER, GnomePieTriggerClass))

typedef struct _GnomePieTrigger GnomePieTrigger;
typedef struct _GnomePieTriggerClass GnomePieTriggerClass;
typedef struct _GnomePieTriggerPrivate GnomePieTriggerPrivate;
enum  {
	GNOME_PIE_TRIGGER_0_PROPERTY,
	GNOME_PIE_TRIGGER_LABEL_PROPERTY,
	GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY,
	GNOME_PIE_TRIGGER_NAME_PROPERTY,
	GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY,
	GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY,
	GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY,
	GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY,
	GNOME_PIE_TRIGGER_TURBO_PROPERTY,
	GNOME_PIE_TRIGGER_DELAYED_PROPERTY,
	GNOME_PIE_TRIGGER_CENTERED_PROPERTY,
	GNOME_PIE_TRIGGER_WARP_PROPERTY,
	GNOME_PIE_TRIGGER_SHAPE_PROPERTY,
	GNOME_PIE_TRIGGER_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _XCloseDisplay0(var) ((var == NULL) ? NULL : (var = (XCloseDisplay (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _GnomePieTrigger {
	GObject parent_instance;
	GnomePieTriggerPrivate * priv;
};

struct _GnomePieTriggerClass {
	GObjectClass parent_class;
};

struct _GnomePieTriggerPrivate {
	gchar* _label;
	gchar* _label_with_specials;
	gchar* _name;
	gint _key_code;
	guint _key_sym;
	GdkModifierType _modifiers;
	gboolean _with_mouse;
	gboolean _turbo;
	gboolean _delayed;
	gboolean _centered;
	gboolean _warp;
	gint _shape;
};

static gint GnomePieTrigger_private_offset;
static gpointer gnome_pie_trigger_parent_class = NULL;

VALA_EXTERN GType gnome_pie_trigger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieTrigger, g_object_unref)
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_new (void);
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_construct (GType object_type);
static void gnome_pie_trigger_set_unbound (GnomePieTrigger* self);
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_new_from_string (const gchar* trigger);
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_construct_from_string (GType object_type,
                                                          const gchar* trigger);
VALA_EXTERN void gnome_pie_trigger_parse_string (GnomePieTrigger* self,
                                     const gchar* trigger);
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_new_from_values (guint key_sym,
                                                    GdkModifierType modifiers,
                                                    gboolean with_mouse,
                                                    gboolean turbo,
                                                    gboolean delayed,
                                                    gboolean centered,
                                                    gboolean warp,
                                                    gint shape);
VALA_EXTERN GnomePieTrigger* gnome_pie_trigger_construct_from_values (GType object_type,
                                                          guint key_sym,
                                                          GdkModifierType modifiers,
                                                          gboolean with_mouse,
                                                          gboolean turbo,
                                                          gboolean delayed,
                                                          gboolean centered,
                                                          gboolean warp,
                                                          gint shape);
static gboolean gnome_pie_trigger_is_valid (GnomePieTrigger* self,
                                     const gchar* trigger);
static void gnome_pie_trigger_set_name (GnomePieTrigger* self,
                                 const gchar* value);
static void gnome_pie_trigger_set_turbo (GnomePieTrigger* self,
                                  gboolean value);
static void gnome_pie_trigger_set_delayed (GnomePieTrigger* self,
                                    gboolean value);
static void gnome_pie_trigger_set_centered (GnomePieTrigger* self,
                                     gboolean value);
static void gnome_pie_trigger_set_warp (GnomePieTrigger* self,
                                 gboolean value);
static gint gnome_pie_trigger_parse_shape (GnomePieTrigger* self,
                                    const gchar* trigger);
static void gnome_pie_trigger_set_shape (GnomePieTrigger* self,
                                  gint value);
VALA_EXTERN gchar* gnome_pie_trigger_remove_optional (const gchar* trigger);
static gint gnome_pie_trigger_get_mouse_button (GnomePieTrigger* self,
                                         const gchar* trigger);
static void gnome_pie_trigger_set_with_mouse (GnomePieTrigger* self,
                                       gboolean value);
static void gnome_pie_trigger_set_key_code (GnomePieTrigger* self,
                                     gint value);
static void gnome_pie_trigger_set_key_sym (GnomePieTrigger* self,
                                    guint value);
VALA_EXTERN GdkModifierType gnome_pie_trigger_get_modifiers (GnomePieTrigger* self);
static void gnome_pie_trigger_set_label (GnomePieTrigger* self,
                                  const gchar* value);
VALA_EXTERN const gchar* gnome_pie_trigger_get_label (GnomePieTrigger* self);
VALA_EXTERN gint gnome_pie_trigger_get_key_code (GnomePieTrigger* self);
static void gnome_pie_trigger_set_modifiers (GnomePieTrigger* self,
                                      GdkModifierType value);
static void gnome_pie_trigger_set_label_with_specials (GnomePieTrigger* self,
                                                const gchar* value);
VALA_EXTERN gboolean gnome_pie_trigger_get_turbo (GnomePieTrigger* self);
VALA_EXTERN gboolean gnome_pie_trigger_get_delayed (GnomePieTrigger* self);
VALA_EXTERN gboolean gnome_pie_trigger_get_centered (GnomePieTrigger* self);
VALA_EXTERN gboolean gnome_pie_trigger_get_warp (GnomePieTrigger* self);
VALA_EXTERN gint gnome_pie_trigger_get_shape (GnomePieTrigger* self);
VALA_EXTERN const gchar* gnome_pie_trigger_get_label_with_specials (GnomePieTrigger* self);
VALA_EXTERN const gchar* gnome_pie_trigger_get_name (GnomePieTrigger* self);
VALA_EXTERN guint gnome_pie_trigger_get_key_sym (GnomePieTrigger* self);
VALA_EXTERN gboolean gnome_pie_trigger_get_with_mouse (GnomePieTrigger* self);
static void gnome_pie_trigger_finalize (GObject * obj);
static GType gnome_pie_trigger_get_type_once (void);
static void _vala_gnome_pie_trigger_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gnome_pie_trigger_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gnome_pie_trigger_get_instance_private (GnomePieTrigger* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieTrigger_private_offset);
}

GnomePieTrigger*
gnome_pie_trigger_construct (GType object_type)
{
	GnomePieTrigger * self = NULL;
	self = (GnomePieTrigger*) g_object_new (object_type, NULL);
	gnome_pie_trigger_set_unbound (self);
	return self;
}

GnomePieTrigger*
gnome_pie_trigger_new (void)
{
	return gnome_pie_trigger_construct (GNOME_PIE_TYPE_TRIGGER);
}

GnomePieTrigger*
gnome_pie_trigger_construct_from_string (GType object_type,
                                         const gchar* trigger)
{
	GnomePieTrigger * self = NULL;
	g_return_val_if_fail (trigger != NULL, NULL);
	self = (GnomePieTrigger*) g_object_new (object_type, NULL);
	gnome_pie_trigger_parse_string (self, trigger);
	return self;
}

GnomePieTrigger*
gnome_pie_trigger_new_from_string (const gchar* trigger)
{
	return gnome_pie_trigger_construct_from_string (GNOME_PIE_TYPE_TRIGGER, trigger);
}

GnomePieTrigger*
gnome_pie_trigger_construct_from_values (GType object_type,
                                         guint key_sym,
                                         GdkModifierType modifiers,
                                         gboolean with_mouse,
                                         gboolean turbo,
                                         gboolean delayed,
                                         gboolean centered,
                                         gboolean warp,
                                         gint shape)
{
	GnomePieTrigger * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* trigger = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp27_;
	self = (GnomePieTrigger*) g_object_new (object_type, NULL);
	if (turbo) {
		_tmp0_ = "[turbo]";
	} else {
		_tmp0_ = "";
	}
	if (delayed) {
		_tmp1_ = "[delayed]";
	} else {
		_tmp1_ = "";
	}
	if (centered) {
		_tmp2_ = "[centered]";
	} else {
		_tmp2_ = "";
	}
	if (warp) {
		_tmp3_ = "[warp]";
	} else {
		_tmp3_ = "";
	}
	if (shape != 5) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("[shape%d]", shape);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, _tmp2_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, _tmp3_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, _tmp4_, NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	trigger = _tmp14_;
	if (with_mouse) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp15_ = trigger;
		_tmp16_ = gtk_accelerator_name ((guint) 0, modifiers);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("button%u", key_sym);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp15_, _tmp21_, NULL);
		_g_free0 (trigger);
		trigger = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	} else {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp23_ = trigger;
		_tmp24_ = gtk_accelerator_name (key_sym, modifiers);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
		_g_free0 (trigger);
		trigger = _tmp26_;
		_g_free0 (_tmp25_);
	}
	_tmp27_ = trigger;
	gnome_pie_trigger_parse_string (self, _tmp27_);
	_g_free0 (trigger);
	_g_free0 (_tmp4_);
	return self;
}

GnomePieTrigger*
gnome_pie_trigger_new_from_values (guint key_sym,
                                   GdkModifierType modifiers,
                                   gboolean with_mouse,
                                   gboolean turbo,
                                   gboolean delayed,
                                   gboolean centered,
                                   gboolean warp,
                                   gint shape)
{
	return gnome_pie_trigger_construct_from_values (GNOME_PIE_TYPE_TRIGGER, key_sym, modifiers, with_mouse, turbo, delayed, centered, warp, shape);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
gnome_pie_trigger_parse_string (GnomePieTrigger* self,
                                const gchar* trigger)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (trigger != NULL);
	if (gnome_pie_trigger_is_valid (self, trigger)) {
		gchar* check_string = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gint button = 0;
		const gchar* _tmp9_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* msg = NULL;
		gchar* _tmp46_;
		gboolean _tmp47_;
		gboolean _tmp49_;
		gboolean _tmp56_;
		gboolean _tmp63_;
		gint _tmp70_;
		const gchar* _tmp103_;
		_tmp0_ = g_strdup (trigger);
		check_string = _tmp0_;
		_tmp1_ = check_string;
		gnome_pie_trigger_set_name (self, _tmp1_);
		_tmp2_ = check_string;
		gnome_pie_trigger_set_turbo (self, string_contains (_tmp2_, "[turbo]"));
		_tmp3_ = check_string;
		gnome_pie_trigger_set_delayed (self, string_contains (_tmp3_, "[delayed]"));
		_tmp4_ = check_string;
		gnome_pie_trigger_set_centered (self, string_contains (_tmp4_, "[centered]"));
		_tmp5_ = check_string;
		gnome_pie_trigger_set_warp (self, string_contains (_tmp5_, "[warp]"));
		_tmp6_ = check_string;
		gnome_pie_trigger_set_shape (self, gnome_pie_trigger_parse_shape (self, _tmp6_));
		_tmp7_ = check_string;
		_tmp8_ = gnome_pie_trigger_remove_optional (_tmp7_);
		_g_free0 (check_string);
		check_string = _tmp8_;
		_tmp9_ = check_string;
		button = gnome_pie_trigger_get_mouse_button (self, _tmp9_);
		if (button > 0) {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			GdkModifierType _tmp14_ = 0U;
			GdkModifierType _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* button_text = NULL;
			gint _tmp22_;
			gchar* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp10_ = check_string;
			_tmp11_ = check_string;
			_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) string_index_of (_tmp11_, "button", 0));
			_g_free0 (check_string);
			check_string = _tmp12_;
			gnome_pie_trigger_set_with_mouse (self, TRUE);
			gnome_pie_trigger_set_key_code (self, button);
			gnome_pie_trigger_set_key_sym (self, (guint) button);
			_tmp13_ = check_string;
			gtk_accelerator_parse (_tmp13_, NULL, &_tmp14_);
			self->priv->_modifiers = _tmp14_;
			_tmp15_ = self->priv->_modifiers;
			_tmp16_ = gtk_accelerator_get_label ((guint) 0, _tmp15_);
			_tmp17_ = _tmp16_;
			gnome_pie_trigger_set_label (self, _tmp17_);
			_g_free0 (_tmp17_);
			_tmp18_ = self->priv->_label;
			if (g_strcmp0 (_tmp18_, "") != 0) {
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp19_ = self->priv->_label;
				_tmp20_ = g_strconcat (_tmp19_, "+", NULL);
				_tmp21_ = _tmp20_;
				gnome_pie_trigger_set_label (self, _tmp21_);
				_g_free0 (_tmp21_);
			}
			_tmp22_ = self->priv->_key_code;
			_tmp23_ = g_strdup_printf (_ ("Button %i"), _tmp22_);
			button_text = _tmp23_;
			_tmp24_ = self->priv->_key_code;
			if (_tmp24_ == 1) {
				gchar* _tmp25_;
				_tmp25_ = g_strdup (_ ("LeftButton"));
				_g_free0 (button_text);
				button_text = _tmp25_;
			} else {
				gint _tmp26_;
				_tmp26_ = self->priv->_key_code;
				if (_tmp26_ == 3) {
					gchar* _tmp27_;
					_tmp27_ = g_strdup (_ ("RightButton"));
					_g_free0 (button_text);
					button_text = _tmp27_;
				} else {
					gint _tmp28_;
					_tmp28_ = self->priv->_key_code;
					if (_tmp28_ == 2) {
						gchar* _tmp29_;
						_tmp29_ = g_strdup (_ ("MiddleButton"));
						_g_free0 (button_text);
						button_text = _tmp29_;
					}
				}
			}
			_tmp30_ = self->priv->_label;
			_tmp31_ = button_text;
			_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
			_tmp33_ = _tmp32_;
			gnome_pie_trigger_set_label (self, _tmp33_);
			_g_free0 (_tmp33_);
			_g_free0 (button_text);
		} else {
			const gchar* _tmp34_;
			_tmp34_ = check_string;
			if (g_strcmp0 (_tmp34_, "") == 0) {
				gnome_pie_trigger_set_label (self, _ ("Not bound"));
				gnome_pie_trigger_set_key_code (self, 0);
				gnome_pie_trigger_set_key_sym (self, (guint) 0);
				gnome_pie_trigger_set_modifiers (self, 0);
			} else {
				Display* display = NULL;
				Display* _tmp35_;
				guint keysym = 0U;
				const gchar* _tmp36_;
				guint _tmp37_ = 0U;
				GdkModifierType _tmp38_ = 0U;
				Display* _tmp39_;
				GdkModifierType _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gnome_pie_trigger_set_with_mouse (self, FALSE);
				_tmp35_ = XOpenDisplay (NULL);
				display = _tmp35_;
				keysym = (guint) 0;
				_tmp36_ = check_string;
				gtk_accelerator_parse (_tmp36_, &_tmp37_, &_tmp38_);
				keysym = _tmp37_;
				self->priv->_modifiers = _tmp38_;
				_tmp39_ = display;
				gnome_pie_trigger_set_key_code (self, (gint) XKeysymToKeycode (_tmp39_, (gulong) keysym));
				gnome_pie_trigger_set_key_sym (self, keysym);
				_tmp40_ = self->priv->_modifiers;
				_tmp41_ = gtk_accelerator_get_label (keysym, _tmp40_);
				_tmp42_ = _tmp41_;
				gnome_pie_trigger_set_label (self, _tmp42_);
				_g_free0 (_tmp42_);
				_XCloseDisplay0 (display);
			}
		}
		_tmp43_ = self->priv->_label;
		_tmp44_ = g_markup_escape_text (_tmp43_, (gssize) -1);
		_tmp45_ = _tmp44_;
		gnome_pie_trigger_set_label_with_specials (self, _tmp45_);
		_g_free0 (_tmp45_);
		_tmp46_ = g_strdup ("");
		msg = _tmp46_;
		_tmp47_ = self->priv->_turbo;
		if (_tmp47_) {
			gchar* _tmp48_;
			_tmp48_ = g_strdup (_ ("Turbo"));
			_g_free0 (msg);
			msg = _tmp48_;
		}
		_tmp49_ = self->priv->_delayed;
		if (_tmp49_) {
			const gchar* _tmp50_;
			_tmp50_ = msg;
			if (g_strcmp0 (_tmp50_, "") == 0) {
				gchar* _tmp51_;
				_tmp51_ = g_strdup (_ ("Delayed"));
				_g_free0 (msg);
				msg = _tmp51_;
			} else {
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp52_ = msg;
				_tmp53_ = g_strconcat (" | ", _ ("Delayed"), NULL);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strconcat (_tmp52_, _tmp54_, NULL);
				_g_free0 (msg);
				msg = _tmp55_;
				_g_free0 (_tmp54_);
			}
		}
		_tmp56_ = self->priv->_centered;
		if (_tmp56_) {
			const gchar* _tmp57_;
			_tmp57_ = msg;
			if (g_strcmp0 (_tmp57_, "") == 0) {
				gchar* _tmp58_;
				_tmp58_ = g_strdup (_ ("Centered"));
				_g_free0 (msg);
				msg = _tmp58_;
			} else {
				const gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp59_ = msg;
				_tmp60_ = g_strconcat (" | ", _ ("Centered"), NULL);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strconcat (_tmp59_, _tmp61_, NULL);
				_g_free0 (msg);
				msg = _tmp62_;
				_g_free0 (_tmp61_);
			}
		}
		_tmp63_ = self->priv->_warp;
		if (_tmp63_) {
			const gchar* _tmp64_;
			_tmp64_ = msg;
			if (g_strcmp0 (_tmp64_, "") == 0) {
				gchar* _tmp65_;
				_tmp65_ = g_strdup (_ ("Warp"));
				_g_free0 (msg);
				msg = _tmp65_;
			} else {
				const gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				_tmp66_ = msg;
				_tmp67_ = g_strconcat (" | ", _ ("Warp"), NULL);
				_tmp68_ = _tmp67_;
				_tmp69_ = g_strconcat (_tmp66_, _tmp68_, NULL);
				_g_free0 (msg);
				msg = _tmp69_;
				_g_free0 (_tmp68_);
			}
		}
		_tmp70_ = self->priv->_shape;
		if (_tmp70_ == 0) {
			const gchar* _tmp71_;
			_tmp71_ = msg;
			if (g_strcmp0 (_tmp71_, "") == 0) {
				gchar* _tmp72_;
				_tmp72_ = g_strdup (_ ("Auto-shaped"));
				_g_free0 (msg);
				msg = _tmp72_;
			} else {
				const gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				_tmp73_ = msg;
				_tmp74_ = g_strconcat (" | ", _ ("Auto-shaped"), NULL);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat (_tmp73_, _tmp75_, NULL);
				_g_free0 (msg);
				msg = _tmp76_;
				_g_free0 (_tmp75_);
			}
		} else {
			gboolean _tmp77_ = FALSE;
			gboolean _tmp78_ = FALSE;
			gboolean _tmp79_ = FALSE;
			gint _tmp80_;
			_tmp80_ = self->priv->_shape;
			if (_tmp80_ == 1) {
				_tmp79_ = TRUE;
			} else {
				gint _tmp81_;
				_tmp81_ = self->priv->_shape;
				_tmp79_ = _tmp81_ == 3;
			}
			if (_tmp79_) {
				_tmp78_ = TRUE;
			} else {
				gint _tmp82_;
				_tmp82_ = self->priv->_shape;
				_tmp78_ = _tmp82_ == 7;
			}
			if (_tmp78_) {
				_tmp77_ = TRUE;
			} else {
				gint _tmp83_;
				_tmp83_ = self->priv->_shape;
				_tmp77_ = _tmp83_ == 9;
			}
			if (_tmp77_) {
				const gchar* _tmp84_;
				_tmp84_ = msg;
				if (g_strcmp0 (_tmp84_, "") == 0) {
					gchar* _tmp85_;
					_tmp85_ = g_strdup (_ ("Quarter pie"));
					_g_free0 (msg);
					msg = _tmp85_;
				} else {
					const gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					_tmp86_ = msg;
					_tmp87_ = g_strconcat (" | ", _ ("Quarter pie"), NULL);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strconcat (_tmp86_, _tmp88_, NULL);
					_g_free0 (msg);
					msg = _tmp89_;
					_g_free0 (_tmp88_);
				}
			} else {
				gboolean _tmp90_ = FALSE;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gint _tmp93_;
				_tmp93_ = self->priv->_shape;
				if (_tmp93_ == 2) {
					_tmp92_ = TRUE;
				} else {
					gint _tmp94_;
					_tmp94_ = self->priv->_shape;
					_tmp92_ = _tmp94_ == 4;
				}
				if (_tmp92_) {
					_tmp91_ = TRUE;
				} else {
					gint _tmp95_;
					_tmp95_ = self->priv->_shape;
					_tmp91_ = _tmp95_ == 6;
				}
				if (_tmp91_) {
					_tmp90_ = TRUE;
				} else {
					gint _tmp96_;
					_tmp96_ = self->priv->_shape;
					_tmp90_ = _tmp96_ == 8;
				}
				if (_tmp90_) {
					const gchar* _tmp97_;
					_tmp97_ = msg;
					if (g_strcmp0 (_tmp97_, "") == 0) {
						gchar* _tmp98_;
						_tmp98_ = g_strdup (_ ("Half pie"));
						_g_free0 (msg);
						msg = _tmp98_;
					} else {
						const gchar* _tmp99_;
						gchar* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						_tmp99_ = msg;
						_tmp100_ = g_strconcat (" | ", _ ("Half pie"), NULL);
						_tmp101_ = _tmp100_;
						_tmp102_ = g_strconcat (_tmp99_, _tmp101_, NULL);
						_g_free0 (msg);
						msg = _tmp102_;
						_g_free0 (_tmp101_);
					}
				}
			}
		}
		_tmp103_ = msg;
		if (g_strcmp0 (_tmp103_, "") != 0) {
			const gchar* _tmp104_;
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			_tmp104_ = self->priv->_label_with_specials;
			_tmp105_ = msg;
			_tmp106_ = g_strconcat ("  [ ", _tmp105_, NULL);
			_tmp107_ = _tmp106_;
			_tmp108_ = g_strconcat (_tmp107_, " ]", NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = g_strconcat (_tmp104_, _tmp109_, NULL);
			_tmp111_ = _tmp110_;
			gnome_pie_trigger_set_label_with_specials (self, _tmp111_);
			_g_free0 (_tmp111_);
			_g_free0 (_tmp109_);
			_g_free0 (_tmp107_);
		}
		_g_free0 (msg);
		_g_free0 (check_string);
	} else {
		gnome_pie_trigger_set_unbound (self);
	}
}

static gint
gnome_pie_trigger_parse_shape (GnomePieTrigger* self,
                               const gchar* trigger)
{
	gint rs = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (trigger != NULL, 0);
	{
		gboolean _tmp0_ = FALSE;
		rs = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			gboolean _tmp4_;
			if (!_tmp0_) {
				gint _tmp1_;
				_tmp1_ = rs;
				rs = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(rs < 10)) {
				break;
			}
			_tmp2_ = g_strdup_printf ("[shape%d]", rs);
			_tmp3_ = _tmp2_;
			_tmp4_ = string_contains (trigger, _tmp3_);
			_g_free0 (_tmp3_);
			if (_tmp4_) {
				result = rs;
				return result;
			}
		}
	}
	result = 5;
	return result;
}

static void
gnome_pie_trigger_set_unbound (GnomePieTrigger* self)
{
	g_return_if_fail (self != NULL);
	gnome_pie_trigger_set_label (self, _ ("Not bound"));
	gnome_pie_trigger_set_label_with_specials (self, _ ("Not bound"));
	gnome_pie_trigger_set_name (self, "");
	gnome_pie_trigger_set_key_code (self, 0);
	gnome_pie_trigger_set_key_sym (self, (guint) 0);
	gnome_pie_trigger_set_modifiers (self, 0);
	gnome_pie_trigger_set_turbo (self, FALSE);
	gnome_pie_trigger_set_delayed (self, FALSE);
	gnome_pie_trigger_set_centered (self, FALSE);
	gnome_pie_trigger_set_warp (self, FALSE);
	gnome_pie_trigger_set_shape (self, 5);
	gnome_pie_trigger_set_with_mouse (self, FALSE);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
gnome_pie_trigger_remove_optional (const gchar* trigger)
{
	gchar* trg = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (trigger != NULL, NULL);
	_tmp0_ = g_strdup (trigger);
	trg = _tmp0_;
	_tmp1_ = trg;
	_tmp2_ = string_replace (_tmp1_, "[turbo]", "");
	_g_free0 (trg);
	trg = _tmp2_;
	_tmp3_ = trg;
	_tmp4_ = string_replace (_tmp3_, "[delayed]", "");
	_g_free0 (trg);
	trg = _tmp4_;
	_tmp5_ = trg;
	_tmp6_ = string_replace (_tmp5_, "[centered]", "");
	_g_free0 (trg);
	trg = _tmp6_;
	_tmp7_ = trg;
	_tmp8_ = string_replace (_tmp7_, "[warp]", "");
	_g_free0 (trg);
	trg = _tmp8_;
	{
		gint rs = 0;
		rs = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = rs;
					rs = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(rs < 10)) {
					break;
				}
				_tmp11_ = trg;
				_tmp12_ = g_strdup_printf ("[shape%d]", rs);
				_tmp13_ = _tmp12_;
				_tmp14_ = string_replace (_tmp11_, _tmp13_, "");
				_g_free0 (trg);
				trg = _tmp14_;
				_g_free0 (_tmp13_);
			}
		}
	}
	result = trg;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
gnome_pie_trigger_is_valid (GnomePieTrigger* self,
                            const gchar* trigger)
{
	gchar* check_string = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	guint keysym = 0U;
	GdkModifierType modifiers = 0U;
	const gchar* _tmp8_;
	guint _tmp9_ = 0U;
	GdkModifierType _tmp10_ = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (trigger != NULL, FALSE);
	_tmp0_ = gnome_pie_trigger_remove_optional (trigger);
	check_string = _tmp0_;
	_tmp1_ = check_string;
	if (gnome_pie_trigger_get_mouse_button (self, _tmp1_) > 0) {
		gint button_index = 0;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = check_string;
		button_index = string_index_of (_tmp2_, "button", 0);
		_tmp3_ = check_string;
		_tmp4_ = string_slice (_tmp3_, (glong) 0, (glong) button_index);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "a", NULL);
		_g_free0 (check_string);
		check_string = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = check_string;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		result = TRUE;
		_g_free0 (check_string);
		return result;
	}
	keysym = (guint) 0;
	modifiers = 0;
	_tmp8_ = check_string;
	gtk_accelerator_parse (_tmp8_, &_tmp9_, &_tmp10_);
	keysym = _tmp9_;
	modifiers = _tmp10_;
	if (keysym == ((guint) 0)) {
		result = FALSE;
		_g_free0 (check_string);
		return result;
	}
	result = TRUE;
	_g_free0 (check_string);
	return result;
}

static gint
gnome_pie_trigger_get_mouse_button (GnomePieTrigger* self,
                                    const gchar* trigger)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (trigger != NULL, 0);
	if (string_contains (trigger, "button")) {
		gint button_index = 0;
		gint number = 0;
		gint _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gint _tmp4_;
		button_index = string_index_of (trigger, "button", 0);
		_tmp0_ = strlen (trigger);
		_tmp1_ = _tmp0_;
		_tmp2_ = string_slice (trigger, (glong) (button_index + 6), (glong) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = atoi (_tmp3_);
		_g_free0 (_tmp3_);
		number = _tmp4_;
		if (number > 0) {
			result = number;
			return result;
		}
	}
	result = -1;
	return result;
}

const gchar*
gnome_pie_trigger_get_label (GnomePieTrigger* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_trigger_set_label (GnomePieTrigger* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_LABEL_PROPERTY]);
	}
}

const gchar*
gnome_pie_trigger_get_label_with_specials (GnomePieTrigger* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_with_specials;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_trigger_set_label_with_specials (GnomePieTrigger* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_label_with_specials (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_with_specials);
		self->priv->_label_with_specials = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY]);
	}
}

const gchar*
gnome_pie_trigger_get_name (GnomePieTrigger* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
gnome_pie_trigger_set_name (GnomePieTrigger* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_NAME_PROPERTY]);
	}
}

gint
gnome_pie_trigger_get_key_code (GnomePieTrigger* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_key_code;
	return result;
}

static void
gnome_pie_trigger_set_key_code (GnomePieTrigger* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_key_code (self);
	if (old_value != value) {
		self->priv->_key_code = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY]);
	}
}

guint
gnome_pie_trigger_get_key_sym (GnomePieTrigger* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_key_sym;
	return result;
}

static void
gnome_pie_trigger_set_key_sym (GnomePieTrigger* self,
                               guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_key_sym (self);
	if (old_value != value) {
		self->priv->_key_sym = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY]);
	}
}

GdkModifierType
gnome_pie_trigger_get_modifiers (GnomePieTrigger* self)
{
	GdkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_modifiers;
	return result;
}

static void
gnome_pie_trigger_set_modifiers (GnomePieTrigger* self,
                                 GdkModifierType value)
{
	GdkModifierType old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_modifiers (self);
	if (old_value != value) {
		self->priv->_modifiers = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY]);
	}
}

gboolean
gnome_pie_trigger_get_with_mouse (GnomePieTrigger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_with_mouse;
	return result;
}

static void
gnome_pie_trigger_set_with_mouse (GnomePieTrigger* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_with_mouse (self);
	if (old_value != value) {
		self->priv->_with_mouse = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY]);
	}
}

gboolean
gnome_pie_trigger_get_turbo (GnomePieTrigger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_turbo;
	return result;
}

static void
gnome_pie_trigger_set_turbo (GnomePieTrigger* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_turbo (self);
	if (old_value != value) {
		self->priv->_turbo = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_TURBO_PROPERTY]);
	}
}

gboolean
gnome_pie_trigger_get_delayed (GnomePieTrigger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_delayed;
	return result;
}

static void
gnome_pie_trigger_set_delayed (GnomePieTrigger* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_delayed (self);
	if (old_value != value) {
		self->priv->_delayed = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_DELAYED_PROPERTY]);
	}
}

gboolean
gnome_pie_trigger_get_centered (GnomePieTrigger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_centered;
	return result;
}

static void
gnome_pie_trigger_set_centered (GnomePieTrigger* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_centered (self);
	if (old_value != value) {
		self->priv->_centered = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_CENTERED_PROPERTY]);
	}
}

gboolean
gnome_pie_trigger_get_warp (GnomePieTrigger* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_warp;
	return result;
}

static void
gnome_pie_trigger_set_warp (GnomePieTrigger* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_warp (self);
	if (old_value != value) {
		self->priv->_warp = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_WARP_PROPERTY]);
	}
}

gint
gnome_pie_trigger_get_shape (GnomePieTrigger* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shape;
	return result;
}

static void
gnome_pie_trigger_set_shape (GnomePieTrigger* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gnome_pie_trigger_get_shape (self);
	if (old_value != value) {
		self->priv->_shape = value;
		g_object_notify_by_pspec ((GObject *) self, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_SHAPE_PROPERTY]);
	}
}

static void
gnome_pie_trigger_class_init (GnomePieTriggerClass * klass,
                              gpointer klass_data)
{
	gnome_pie_trigger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieTrigger_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_trigger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_trigger_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_trigger_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_LABEL_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY] = g_param_spec_string ("label-with-specials", "label-with-specials", "label-with-specials", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_NAME_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY] = g_param_spec_int ("key-code", "key-code", "key-code", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY] = g_param_spec_uint ("key-sym", "key-sym", "key-sym", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", gdk_modifier_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY] = g_param_spec_boolean ("with-mouse", "with-mouse", "with-mouse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_TURBO_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_TURBO_PROPERTY] = g_param_spec_boolean ("turbo", "turbo", "turbo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_DELAYED_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_DELAYED_PROPERTY] = g_param_spec_boolean ("delayed", "delayed", "delayed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_CENTERED_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_CENTERED_PROPERTY] = g_param_spec_boolean ("centered", "centered", "centered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_WARP_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_WARP_PROPERTY] = g_param_spec_boolean ("warp", "warp", "warp", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_TRIGGER_SHAPE_PROPERTY, gnome_pie_trigger_properties[GNOME_PIE_TRIGGER_SHAPE_PROPERTY] = g_param_spec_int ("shape", "shape", "shape", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gnome_pie_trigger_instance_init (GnomePieTrigger * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self->priv = gnome_pie_trigger_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_label = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_label_with_specials = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_name = _tmp2_;
	self->priv->_key_code = 0;
	self->priv->_key_sym = (guint) 0;
	self->priv->_modifiers = 0;
	self->priv->_with_mouse = FALSE;
	self->priv->_turbo = FALSE;
	self->priv->_delayed = FALSE;
	self->priv->_centered = FALSE;
	self->priv->_warp = FALSE;
	self->priv->_shape = 5;
}

static void
gnome_pie_trigger_finalize (GObject * obj)
{
	GnomePieTrigger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_TRIGGER, GnomePieTrigger);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_label_with_specials);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (gnome_pie_trigger_parent_class)->finalize (obj);
}

static GType
gnome_pie_trigger_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieTriggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_trigger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieTrigger), 0, (GInstanceInitFunc) gnome_pie_trigger_instance_init, NULL };
	GType gnome_pie_trigger_type_id;
	gnome_pie_trigger_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieTrigger", &g_define_type_info, 0);
	GnomePieTrigger_private_offset = g_type_add_instance_private (gnome_pie_trigger_type_id, sizeof (GnomePieTriggerPrivate));
	return gnome_pie_trigger_type_id;
}

GType
gnome_pie_trigger_get_type (void)
{
	static volatile gsize gnome_pie_trigger_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_trigger_type_id__once)) {
		GType gnome_pie_trigger_type_id;
		gnome_pie_trigger_type_id = gnome_pie_trigger_get_type_once ();
		g_once_init_leave (&gnome_pie_trigger_type_id__once, gnome_pie_trigger_type_id);
	}
	return gnome_pie_trigger_type_id__once;
}

static void
_vala_gnome_pie_trigger_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GnomePieTrigger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_TRIGGER, GnomePieTrigger);
	switch (property_id) {
		case GNOME_PIE_TRIGGER_LABEL_PROPERTY:
		g_value_set_string (value, gnome_pie_trigger_get_label (self));
		break;
		case GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY:
		g_value_set_string (value, gnome_pie_trigger_get_label_with_specials (self));
		break;
		case GNOME_PIE_TRIGGER_NAME_PROPERTY:
		g_value_set_string (value, gnome_pie_trigger_get_name (self));
		break;
		case GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY:
		g_value_set_int (value, gnome_pie_trigger_get_key_code (self));
		break;
		case GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY:
		g_value_set_uint (value, gnome_pie_trigger_get_key_sym (self));
		break;
		case GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY:
		g_value_set_flags (value, gnome_pie_trigger_get_modifiers (self));
		break;
		case GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY:
		g_value_set_boolean (value, gnome_pie_trigger_get_with_mouse (self));
		break;
		case GNOME_PIE_TRIGGER_TURBO_PROPERTY:
		g_value_set_boolean (value, gnome_pie_trigger_get_turbo (self));
		break;
		case GNOME_PIE_TRIGGER_DELAYED_PROPERTY:
		g_value_set_boolean (value, gnome_pie_trigger_get_delayed (self));
		break;
		case GNOME_PIE_TRIGGER_CENTERED_PROPERTY:
		g_value_set_boolean (value, gnome_pie_trigger_get_centered (self));
		break;
		case GNOME_PIE_TRIGGER_WARP_PROPERTY:
		g_value_set_boolean (value, gnome_pie_trigger_get_warp (self));
		break;
		case GNOME_PIE_TRIGGER_SHAPE_PROPERTY:
		g_value_set_int (value, gnome_pie_trigger_get_shape (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_trigger_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GnomePieTrigger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_TRIGGER, GnomePieTrigger);
	switch (property_id) {
		case GNOME_PIE_TRIGGER_LABEL_PROPERTY:
		gnome_pie_trigger_set_label (self, g_value_get_string (value));
		break;
		case GNOME_PIE_TRIGGER_LABEL_WITH_SPECIALS_PROPERTY:
		gnome_pie_trigger_set_label_with_specials (self, g_value_get_string (value));
		break;
		case GNOME_PIE_TRIGGER_NAME_PROPERTY:
		gnome_pie_trigger_set_name (self, g_value_get_string (value));
		break;
		case GNOME_PIE_TRIGGER_KEY_CODE_PROPERTY:
		gnome_pie_trigger_set_key_code (self, g_value_get_int (value));
		break;
		case GNOME_PIE_TRIGGER_KEY_SYM_PROPERTY:
		gnome_pie_trigger_set_key_sym (self, g_value_get_uint (value));
		break;
		case GNOME_PIE_TRIGGER_MODIFIERS_PROPERTY:
		gnome_pie_trigger_set_modifiers (self, g_value_get_flags (value));
		break;
		case GNOME_PIE_TRIGGER_WITH_MOUSE_PROPERTY:
		gnome_pie_trigger_set_with_mouse (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_TRIGGER_TURBO_PROPERTY:
		gnome_pie_trigger_set_turbo (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_TRIGGER_DELAYED_PROPERTY:
		gnome_pie_trigger_set_delayed (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_TRIGGER_CENTERED_PROPERTY:
		gnome_pie_trigger_set_centered (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_TRIGGER_WARP_PROPERTY:
		gnome_pie_trigger_set_warp (self, g_value_get_boolean (value));
		break;
		case GNOME_PIE_TRIGGER_SHAPE_PROPERTY:
		gnome_pie_trigger_set_shape (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

