/* promotion-type-selector-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from promotion-type-selector-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2020 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <librsvg/rsvg.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROMOTION_TYPE_SELECTOR_DIALOG (promotion_type_selector_dialog_get_type ())
#define PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog))
#define PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define IS_PROMOTION_TYPE_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG))
#define PROMOTION_TYPE_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialogClass))

typedef struct _PromotionTypeSelectorDialog PromotionTypeSelectorDialog;
typedef struct _PromotionTypeSelectorDialogClass PromotionTypeSelectorDialogClass;
typedef struct _PromotionTypeSelectorDialogPrivate PromotionTypeSelectorDialogPrivate;
enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_0_PROPERTY,
	PROMOTION_TYPE_SELECTOR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* promotion_type_selector_dialog_properties[PROMOTION_TYPE_SELECTOR_DIALOG_NUM_PROPERTIES];
typedef enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK,
	PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP
} PromotionTypeSelectorDialogSelectedType;

#define PROMOTION_TYPE_SELECTOR_DIALOG_TYPE_SELECTED_TYPE (promotion_type_selector_dialog_selected_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL,
	PROMOTION_TYPE_SELECTOR_DIALOG_NUM_SIGNALS
};
static guint promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PromotionTypeSelectorDialog {
	AdwDialog parent_instance;
	PromotionTypeSelectorDialogPrivate * priv;
};

struct _PromotionTypeSelectorDialogClass {
	AdwDialogClass parent_class;
};

struct _PromotionTypeSelectorDialogPrivate {
	GtkImage* queen_image;
	GtkImage* knight_image;
	GtkImage* rook_image;
	GtkImage* bishop_image;
};

static gint PromotionTypeSelectorDialog_private_offset;
static gpointer promotion_type_selector_dialog_parent_class = NULL;

VALA_EXTERN GType promotion_type_selector_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromotionTypeSelectorDialog, g_object_unref)
VALA_EXTERN GType promotion_type_selector_dialog_selected_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_new (Color color,
                                                                 const gchar* theme);
VALA_EXTERN PromotionTypeSelectorDialog* promotion_type_selector_dialog_construct (GType object_type,
                                                                       Color color,
                                                                       const gchar* theme);
static void promotion_type_selector_dialog_set_piece_image (PromotionTypeSelectorDialog* self,
                                                     GtkImage* image,
                                                     const gchar* resource_path);
static GdkTexture* promotion_type_selector_dialog_create_texture_for_surface (cairo_surface_t* surface);
static void promotion_type_selector_dialog_queen_selected_cb (PromotionTypeSelectorDialog* self,
                                                       GtkButton* button);
static void _promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
static void promotion_type_selector_dialog_knight_selected_cb (PromotionTypeSelectorDialog* self,
                                                        GtkButton* button);
static void _promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void promotion_type_selector_dialog_rook_selected_cb (PromotionTypeSelectorDialog* self,
                                                      GtkButton* button);
static void _promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self);
static void promotion_type_selector_dialog_bishop_selected_cb (PromotionTypeSelectorDialog* self,
                                                        GtkButton* button);
static void _promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void promotion_type_selector_dialog_finalize (GObject * obj);
static GType promotion_type_selector_dialog_get_type_once (void);

static inline gpointer
promotion_type_selector_dialog_get_instance_private (PromotionTypeSelectorDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PromotionTypeSelectorDialog_private_offset);
}

static GType
promotion_type_selector_dialog_selected_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN", "queen"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT", "knight"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK", "rook"}, {PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP, "PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP", "bishop"}, {0, NULL, NULL}};
	GType promotion_type_selector_dialog_selected_type_type_id;
	promotion_type_selector_dialog_selected_type_type_id = g_enum_register_static ("PromotionTypeSelectorDialogSelectedType", values);
	return promotion_type_selector_dialog_selected_type_type_id;
}

GType
promotion_type_selector_dialog_selected_type_get_type (void)
{
	static volatile gsize promotion_type_selector_dialog_selected_type_type_id__once = 0;
	if (g_once_init_enter (&promotion_type_selector_dialog_selected_type_type_id__once)) {
		GType promotion_type_selector_dialog_selected_type_type_id;
		promotion_type_selector_dialog_selected_type_type_id = promotion_type_selector_dialog_selected_type_get_type_once ();
		g_once_init_leave (&promotion_type_selector_dialog_selected_type_type_id__once, promotion_type_selector_dialog_selected_type_type_id);
	}
	return promotion_type_selector_dialog_selected_type_type_id__once;
}

PromotionTypeSelectorDialog*
promotion_type_selector_dialog_construct (GType object_type,
                                          Color color,
                                          const gchar* theme)
{
	PromotionTypeSelectorDialog * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* color_string = NULL;
	gchar* _tmp1_;
	gchar* resource_path = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkImage* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkImage* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkImage* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkImage* _tmp21_;
	const gchar* _tmp22_;
	g_return_val_if_fail (theme != NULL, NULL);
	self = (PromotionTypeSelectorDialog*) g_object_new (object_type, NULL);
	if (color == COLOR_WHITE) {
		_tmp0_ = "white";
	} else {
		_tmp0_ = "black";
	}
	_tmp1_ = g_strdup (_tmp0_);
	color_string = _tmp1_;
	_tmp2_ = g_strdup_printf ("%sQueen.svg", color_string);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	resource_path = _tmp5_;
	_tmp6_ = self->priv->queen_image;
	_tmp7_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp6_, _tmp7_);
	_tmp8_ = g_strdup_printf ("%sKnight.svg", color_string);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp9_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = self->priv->knight_image;
	_tmp12_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp11_, _tmp12_);
	_tmp13_ = g_strdup_printf ("%sRook.svg", color_string);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp14_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = self->priv->rook_image;
	_tmp17_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp16_, _tmp17_);
	_tmp18_ = g_strdup_printf ("%sBishop.svg", color_string);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_build_path ("/", "/org/gnome/Chess/pieces", theme, _tmp19_, NULL);
	_g_free0 (resource_path);
	resource_path = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = self->priv->bishop_image;
	_tmp22_ = resource_path;
	promotion_type_selector_dialog_set_piece_image (self, _tmp21_, _tmp22_);
	_g_free0 (resource_path);
	_g_free0 (color_string);
	return self;
}

PromotionTypeSelectorDialog*
promotion_type_selector_dialog_new (Color color,
                                    const gchar* theme)
{
	return promotion_type_selector_dialog_construct (TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, color, theme);
}

static void
promotion_type_selector_dialog_set_piece_image (PromotionTypeSelectorDialog* self,
                                                GtkImage* image,
                                                const gchar* resource_path)
{
	static const gint size = 48;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (resource_path != NULL);
	{
		GInputStream* stream = NULL;
		GInputStream* _tmp0_;
		RsvgHandle* h = NULL;
		GInputStream* _tmp1_;
		RsvgHandle* _tmp2_;
		cairo_surface_t* s = NULL;
		cairo_surface_t* _tmp3_;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp4_;
		cairo_t* _tmp5_;
		RsvgHandle* _tmp6_;
		cairo_t* _tmp7_;
		RsvgRectangle _tmp8_ = {0};
		GdkTexture* p = NULL;
		cairo_surface_t* _tmp9_;
		GdkTexture* _tmp10_;
		GdkTexture* _tmp11_;
		_tmp0_ = g_resources_open_stream (resource_path, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		stream = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = stream;
		_tmp2_ = rsvg_handle_new_from_stream_sync (_tmp1_, NULL, RSVG_HANDLE_FLAGS_NONE, NULL, &_inner_error0_);
		h = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
		s = _tmp3_;
		_tmp4_ = s;
		_tmp5_ = cairo_create (_tmp4_);
		c = _tmp5_;
		_tmp6_ = h;
		_tmp7_ = c;
		memset (&_tmp8_, 0, sizeof (RsvgRectangle));
		_tmp8_.width = (gdouble) size;
		_tmp8_.height = (gdouble) size;
		_tmp8_.x = (gdouble) 0;
		_tmp8_.y = (gdouble) 0;
		rsvg_handle_render_document (_tmp6_, _tmp7_, &_tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_cairo_destroy0 (c);
			_cairo_surface_destroy0 (s);
			_g_object_unref0 (h);
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp9_ = s;
		_tmp10_ = promotion_type_selector_dialog_create_texture_for_surface (_tmp9_);
		p = _tmp10_;
		_tmp11_ = p;
		gtk_image_set_from_paintable (image, (GdkPaintable*) _tmp11_);
		g_object_set ((GtkWidget*) image, "height-request", size, NULL);
		_g_object_unref0 (p);
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (s);
		_g_object_unref0 (h);
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("promotion-type-selector-dialog.vala:71: Failed to load piece image %s:" \
" %s", resource_path, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static GdkTexture*
promotion_type_selector_dialog_create_texture_for_surface (cairo_surface_t* surface)
{
	guchar* data = NULL;
	guchar* _tmp0_;
	gint data_length1;
	gint _data_size_;
	GdkMemoryFormat _tmp1_ = 0;
	guchar* _tmp2_;
	gint _tmp2__length1;
	GBytes* _tmp3_;
	GBytes* _tmp4_;
	GdkMemoryTexture* _tmp5_;
	GdkTexture* _tmp6_;
	GdkTexture* result;
	g_return_val_if_fail (surface != NULL, NULL);
	_vala_return_val_if_fail (cairo_surface_get_type (surface) == CAIRO_SURFACE_TYPE_IMAGE, "surface.get_type () == Cairo.SurfaceType.IMAGE", NULL);
	_vala_return_val_if_fail (cairo_image_surface_get_width (surface) > 0, "surface.get_width () > 0", NULL);
	_vala_return_val_if_fail (cairo_image_surface_get_height (surface) > 0, "surface.get_height () > 0", NULL);
	_vala_return_val_if_fail ((G_BYTE_ORDER == G_LITTLE_ENDIAN) || (G_BYTE_ORDER == G_BIG_ENDIAN), "BYTE_ORDER == ByteOrder.LITTLE_ENDIAN || BYTE_ORDER == ByteOrder.BIG_ENDIAN", NULL);
	_tmp0_ = cairo_image_surface_get_data (surface);
	data = _tmp0_;
	data_length1 = -1;
	_data_size_ = data_length1;
	data_length1 = cairo_image_surface_get_height (surface) * cairo_image_surface_get_stride (surface);
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		_tmp1_ = GDK_MEMORY_B8G8R8A8_PREMULTIPLIED;
	} else {
		_tmp1_ = GDK_MEMORY_A8R8G8B8_PREMULTIPLIED;
	}
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = g_bytes_new (_tmp2_, _tmp2__length1);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GdkMemoryTexture*) gdk_memory_texture_new (cairo_image_surface_get_width (surface), cairo_image_surface_get_height (surface), _tmp1_, _tmp4_, (gsize) cairo_image_surface_get_stride (surface));
	_tmp6_ = (GdkTexture*) _tmp5_;
	_g_bytes_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static void
promotion_type_selector_dialog_queen_selected_cb (PromotionTypeSelectorDialog* self,
                                                  GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit (self, promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL], 0, PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_QUEEN);
}

static void
_promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	promotion_type_selector_dialog_queen_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_knight_selected_cb (PromotionTypeSelectorDialog* self,
                                                   GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit (self, promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL], 0, PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_KNIGHT);
}

static void
_promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	promotion_type_selector_dialog_knight_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_rook_selected_cb (PromotionTypeSelectorDialog* self,
                                                 GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit (self, promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL], 0, PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_ROOK);
}

static void
_promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self)
{
	promotion_type_selector_dialog_rook_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_bishop_selected_cb (PromotionTypeSelectorDialog* self,
                                                   GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_signal_emit (self, promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL], 0, PROMOTION_TYPE_SELECTOR_DIALOG_SELECTED_TYPE_BISHOP);
}

static void
_promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	promotion_type_selector_dialog_bishop_selected_cb ((PromotionTypeSelectorDialog*) self, _sender);
}

static void
promotion_type_selector_dialog_class_init (PromotionTypeSelectorDialogClass * klass,
                                           gpointer klass_data)
{
	promotion_type_selector_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PromotionTypeSelectorDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = promotion_type_selector_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Chess/ui/promotion-type-selector.ui");
	promotion_type_selector_dialog_signals[PROMOTION_TYPE_SELECTOR_DIALOG_PIECE_SELECTED_SIGNAL] = g_signal_new ("piece-selected", TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, PROMOTION_TYPE_SELECTOR_DIALOG_TYPE_SELECTED_TYPE);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "queen_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, queen_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "knight_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, knight_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rook_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, rook_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bishop_image", FALSE, PromotionTypeSelectorDialog_private_offset + G_STRUCT_OFFSET (PromotionTypeSelectorDialogPrivate, bishop_image));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "queen_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_queen_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "knight_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_knight_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "rook_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_rook_selected_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "bishop_selected_cb", G_CALLBACK(_promotion_type_selector_dialog_bishop_selected_cb_gtk_button_clicked));
}

static void
promotion_type_selector_dialog_instance_init (PromotionTypeSelectorDialog * self,
                                              gpointer klass)
{
	self->priv = promotion_type_selector_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
promotion_type_selector_dialog_finalize (GObject * obj)
{
	PromotionTypeSelectorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROMOTION_TYPE_SELECTOR_DIALOG, PromotionTypeSelectorDialog);
	G_OBJECT_CLASS (promotion_type_selector_dialog_parent_class)->finalize (obj);
}

static GType
promotion_type_selector_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PromotionTypeSelectorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) promotion_type_selector_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PromotionTypeSelectorDialog), 0, (GInstanceInitFunc) promotion_type_selector_dialog_instance_init, NULL };
	GType promotion_type_selector_dialog_type_id;
	promotion_type_selector_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "PromotionTypeSelectorDialog", &g_define_type_info, 0);
	PromotionTypeSelectorDialog_private_offset = g_type_add_instance_private (promotion_type_selector_dialog_type_id, sizeof (PromotionTypeSelectorDialogPrivate));
	return promotion_type_selector_dialog_type_id;
}

GType
promotion_type_selector_dialog_get_type (void)
{
	static volatile gsize promotion_type_selector_dialog_type_id__once = 0;
	if (g_once_init_enter (&promotion_type_selector_dialog_type_id__once)) {
		GType promotion_type_selector_dialog_type_id;
		promotion_type_selector_dialog_type_id = promotion_type_selector_dialog_get_type_once ();
		g_once_init_leave (&promotion_type_selector_dialog_type_id__once, promotion_type_selector_dialog_type_id);
	}
	return promotion_type_selector_dialog_type_id__once;
}

