static const char* colors_cl_source =
"/* This file is part of GEGL                                                  \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <https://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright 2012 Victor Oliveira (victormatheus@gmail.com)                   \n"
" */                                                                           \n"
"                                                                              \n"
"/* This is almost a copy-paste from babl/base color conversion functions      \n"
"                                                                              \n"
"   XXX: This code is very hard to maintain and keep in sync with BABL, we should\n"
"        think in something better                                             \n"
"*/                                                                            \n"
"                                                                              \n"
"/* Alpha threshold used in the reference implementation for                   \n"
" * un-pre-multiplication of color data:                                       \n"
" *                                                                            \n"
" * 0.01 / (2^16 - 1)                                                          \n"
" */                                                                           \n"
"#define BABL_ALPHA_THRESHOLD 0.0f                                             \n"
"                                                                              \n"
"float linear_to_gamma_2_2 (float value);                                      \n"
"float gamma_2_2_to_linear (float value);                                      \n"
"                                                                              \n"
"/* babl reference file: babl/base/util.h */                                   \n"
"float linear_to_gamma_2_2 (float value)                                       \n"
"{                                                                             \n"
"  if (value > 0.003130804954f)                                                \n"
"    return 1.055f * native_powr (value, (1.0f/2.4f)) - 0.055f;                \n"
"  return 12.92f * value;                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"float gamma_2_2_to_linear (float value)                                       \n"
"{                                                                             \n"
"  if (value > 0.04045f)                                                       \n"
"    return native_powr ((value + 0.055f) / 1.055f, 2.4f);                     \n"
"  return value / 12.92f;                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- RGBA float/u8 -- */                                                     \n"
"                                                                              \n"
"/* RGBA u8 -> RGBA float */                                                   \n"
"__kernel void rgbau8_to_rgbaf (__global const uchar4 * in,                    \n"
"                               __global       float4 * out)                   \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = convert_float4(in[gid]) / 255.0f;                            \n"
"  float4 out_v = in_v;                                                        \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* RGBA float -> RGBA u8 */                                                   \n"
"__kernel void rgbaf_to_rgbau8 (__global const float4 * in,                    \n"
"                               __global       uchar4 * out)                   \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v = in_v;                                                        \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* RGBA float -> RGB float */                                                 \n"
"__kernel void rgbaf_to_rgbf (__global const float4 * in,                      \n"
"                             __global       float  * out)                     \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"                                                                              \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  vstore3 (in_v.xyz, gid, out);                                               \n"
"#else                                                                         \n"
"  out[3 * gid]     = in_v.x;                                                  \n"
"  out[3 * gid + 1] = in_v.y;                                                  \n"
"  out[3 * gid + 2] = in_v.z;                                                  \n"
"#endif                                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- RaGaBaA float -- */                                                     \n"
"                                                                              \n"
"/* RGBA float -> RaGaBaA float */                                             \n"
"__kernel void rgbaf_to_ragabaf (__global const float4 * in,                   \n"
"                                __global       float4 * out)                  \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v = in[gid];                                                      \n"
"  float4 out_v;                                                               \n"
"  out_v   = in_v * in_v.w;                                                    \n"
"  out_v.w = in_v.w;                                                           \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* RaGaBaA float -> RGBA float */                                             \n"
"__kernel void ragabaf_to_rgbaf (__global const float4 * in,                   \n"
"                                __global       float4 * out)                  \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (in_v.w > BABL_ALPHA_THRESHOLD)? in_v / in_v.w : (float4)(0.0f);    \n"
"  out_v.w = in_v.w;                                                           \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* RGBA u8 -> RaGaBaA float */                                                \n"
"__kernel void rgbau8_to_ragabaf (__global const uchar4 * in,                  \n"
"                                 __global       float4 * out)                 \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = convert_float4(in[gid]) / 255.0f;                            \n"
"  float4 out_v;                                                               \n"
"  out_v   = in_v * in_v.w;                                                    \n"
"  out_v.w = in_v.w;                                                           \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/* RaGaBaA float -> RGBA u8 */                                                \n"
"__kernel void ragabaf_to_rgbau8 (__global const float4 * in,                  \n"
"                                 __global       uchar4 * out)                 \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (in_v.w > BABL_ALPHA_THRESHOLD)? in_v / in_v.w : (float4)(0.0f);    \n"
"  out_v.w = in_v.w;                                                           \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* RaGaBaA float -> RGBA_GAMMA_U8 */                                          \n"
"__kernel void ragabaf_to_rgba_gamma_u8 (__global const float4 * in,           \n"
"                                        __global       uchar4 * out)          \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 tmp_v;                                                               \n"
"  tmp_v = (in_v.w > BABL_ALPHA_THRESHOLD)? in_v / in_v.w : (float4)(0.0f);    \n"
"  tmp_v.w = in_v.w;                                                           \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(tmp_v.x),                              \n"
"                   linear_to_gamma_2_2(tmp_v.y),                              \n"
"                   linear_to_gamma_2_2(tmp_v.z),                              \n"
"                   tmp_v.w);                                                  \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* RaGaBaA float -> RGB_GAMMA_U8 */                                           \n"
"__kernel void ragabaf_to_rgb_gamma_u8 (__global const float4 * in,            \n"
"                                       __global       uchar  * out)           \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 tmp_v;                                                               \n"
"  tmp_v = (in_v.w > BABL_ALPHA_THRESHOLD)? in_v / in_v.w : (float4)(0.0f);    \n"
"  tmp_v.w = in_v.w;                                                           \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(tmp_v.x),                              \n"
"                   linear_to_gamma_2_2(tmp_v.y),                              \n"
"                   linear_to_gamma_2_2(tmp_v.z),                              \n"
"                   tmp_v.w);                                                  \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  vstore3 (convert_uchar3_sat_rte(255.0f * out_v.xyz), gid, out);             \n"
"#else                                                                         \n"
"  uchar4 sat = convert_uchar4_sat_rte (255.0f * out_v);                       \n"
"  out[3 * gid]     = sat.x;                                                   \n"
"  out[3 * gid + 1] = sat.y;                                                   \n"
"  out[3 * gid + 2] = sat.z;                                                   \n"
"#endif                                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- R'G'B' float -- */                                                      \n"
"                                                                              \n"
"/* R'G'B' float -> RGBA float */                                              \n"
"__kernel void rgb_gamma_f_to_rgbaf (__global const float * in,                \n"
"                                    __global       float4 * out)              \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  float3 in_v;                                                                \n"
"  in_v = vload3 (gid, in);                                                    \n"
"  out_v = (float4)(gamma_2_2_to_linear(in_v.x),                               \n"
"                   gamma_2_2_to_linear(in_v.y),                               \n"
"                   gamma_2_2_to_linear(in_v.z),                               \n"
"                   1.0f);                                                     \n"
"#else                                                                         \n"
"  float r = in[3 * gid + 0];                                                  \n"
"  float g = in[3 * gid + 1];                                                  \n"
"  float b = in[3 * gid + 2];                                                  \n"
"  out_v = (float4)(gamma_2_2_to_linear(r),                                    \n"
"                   gamma_2_2_to_linear(g),                                    \n"
"                   gamma_2_2_to_linear(b),                                    \n"
"                   1.0f);                                                     \n"
"#endif                                                                        \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- R'G'B'A float -- */                                                     \n"
"                                                                              \n"
"/* rgba float -> r'g'b'a float */                                             \n"
"__kernel void rgbaf_to_rgba_gamma_f (__global const float4 * in,              \n"
"                                     __global       float4 * out)             \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(in_v.x),                               \n"
"                   linear_to_gamma_2_2(in_v.y),                               \n"
"                   linear_to_gamma_2_2(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* r'g'b'a float -> rgba float */                                             \n"
"__kernel void rgba_gamma_f_to_rgbaf (__global const float4 * in,              \n"
"                                     __global       float4 * out)             \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(gamma_2_2_to_linear(in_v.x),                               \n"
"                   gamma_2_2_to_linear(in_v.y),                               \n"
"                   gamma_2_2_to_linear(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* rgba u8 -> r'g'b'a float */                                                \n"
"__kernel void rgbau8_to_rgba_gamma_f (__global const uchar4 * in,             \n"
"                                      __global       float4 * out)            \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = convert_float4(in[gid]) / 255.0f;                            \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(in_v.x),                               \n"
"                   linear_to_gamma_2_2(in_v.y),                               \n"
"                   linear_to_gamma_2_2(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* r'g'b'a float -> rgba u8 */                                                \n"
"__kernel void rgba_gamma_f_to_rgbau8 (__global const float4 * in,             \n"
"                                      __global       uchar4 * out)            \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(gamma_2_2_to_linear(in_v.x),                               \n"
"                   gamma_2_2_to_linear(in_v.y),                               \n"
"                   gamma_2_2_to_linear(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- Y'CbCrA float -- */                                                     \n"
"                                                                              \n"
"/* RGBA float -> Y'CbCrA float */                                             \n"
"__kernel void rgbaf_to_ycbcraf (__global const float4 * in,                   \n"
"                                __global       float4 * out)                  \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  float3 rgb = (float3)(linear_to_gamma_2_2(in_v.x),                          \n"
"                        linear_to_gamma_2_2(in_v.y),                          \n"
"                        linear_to_gamma_2_2(in_v.z));                         \n"
"#else                                                                         \n"
"  float4 rgb = (float4)(linear_to_gamma_2_2(in_v.x),                          \n"
"                        linear_to_gamma_2_2(in_v.y),                          \n"
"                        linear_to_gamma_2_2(in_v.z), 1.0f);                   \n"
"#endif                                                                        \n"
"                                                                              \n"
"  out_v = (float4)( 0.299f    * rgb.x + 0.587f    * rgb.y + 0.114f    * rgb.z,\n"
"                   -0.168736f * rgb.x - 0.331264f * rgb.y + 0.5f      * rgb.z,\n"
"                    0.5f      * rgb.x - 0.418688f * rgb.y - 0.081312f * rgb.z,\n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* Y'CbCrA float -> RGBA float */                                             \n"
"__kernel void ycbcraf_to_rgbaf (__global const float4 * in,                   \n"
"                                __global       float4 * out)                  \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  float4 rgb = (float4)(1.0f * in_v.x + 0.0f      * in_v.y + 1.40200f    * in_v.z,\n"
"                        1.0f * in_v.x - 0.344136f * in_v.y - 0.71414136f * in_v.z,\n"
"                        1.0f * in_v.x + 1.772f    * in_v.y + 0.0f        * in_v.z,\n"
"                        0.0f);                                                \n"
"                                                                              \n"
"  out_v = (float4)(gamma_2_2_to_linear(rgb.x),                                \n"
"                   gamma_2_2_to_linear(rgb.y),                                \n"
"                   gamma_2_2_to_linear(rgb.z),                                \n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* RGBA u8 -> Y'CbCrA float */                                                \n"
"__kernel void rgbau8_to_ycbcraf (__global const uchar4 * in,                  \n"
"                                 __global       float4 * out)                 \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = convert_float4(in[gid]) / 255.0f;                            \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  float4 rgb = (float4)(linear_to_gamma_2_2(in_v.x),                          \n"
"                        linear_to_gamma_2_2(in_v.y),                          \n"
"                        linear_to_gamma_2_2(in_v.z),                          \n"
"                        0.0f);                                                \n"
"                                                                              \n"
"  out_v = (float4)( 0.299f    * rgb.x + 0.587f    * rgb.y + 0.114f    * rgb.z,\n"
"                   -0.168736f * rgb.x - 0.331264f * rgb.y + 0.5f      * rgb.z,\n"
"                    0.5f      * rgb.x - 0.418688f * rgb.y - 0.081312f * rgb.z,\n"
"                   in_v.w);                                                   \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* Y'CbCrA float -> RGBA u8 */                                                \n"
"__kernel void ycbcraf_to_rgbau8 (__global const float4 * in,                  \n"
"                                 __global       uchar4 * out)                 \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  float4 rgb = (float4)(1.0f * in_v.x + 0.0f      * in_v.y + 1.40200f    * in_v.z,\n"
"                        1.0f * in_v.x - 0.344136f * in_v.y - 0.71414136f * in_v.z,\n"
"                        1.0f * in_v.x + 1.772f    * in_v.y + 0.0f        * in_v.z,\n"
"                        0.0f);                                                \n"
"                                                                              \n"
"  out_v = (float4)(gamma_2_2_to_linear(rgb.x),                                \n"
"                   gamma_2_2_to_linear(rgb.y),                                \n"
"                   gamma_2_2_to_linear(rgb.z),                                \n"
"                   in_v.w);                                                   \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- RGB u8 -- */                                                            \n"
"                                                                              \n"
"/* RGB u8 -> RGBA float */                                                    \n"
"__kernel void rgbu8_to_rgbaf (__global const uchar  * in,                     \n"
"                              __global       float4 * out)                    \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  uchar3 in_v;                                                                \n"
"  float4 out_v;                                                               \n"
"  in_v = vload3 (gid, in);                                                    \n"
"  out_v.xyz = convert_float3(in_v) / 255.0f;                                  \n"
"  out_v.w   = 1.0f;                                                           \n"
"#else                                                                         \n"
"  float4 in_v = (float4) (in[3 * gid], in[3 * gid + 1], in[3 * gid + 2], 255.0f);\n"
"  float4 out_v = in_v / (float4) (255.0f);                                    \n"
"#endif                                                                        \n"
"  out[gid]  = out_v;                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* RGBA float -> RGB u8 */                                                    \n"
"__kernel void rgbaf_to_rgbu8 (__global const float4 * in,                     \n"
"                              __global       uchar  * out)                    \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  uchar3 out_v = convert_uchar3_sat_rte(255.0f * in_v.xyz);                   \n"
"  vstore3 (out_v, gid, out);                                                  \n"
"#else                                                                         \n"
"  uchar4 out_v = convert_uchar4_sat_rte(255.0f * in_v);                       \n"
"  out[3 * gid]     = out_v.x;                                                 \n"
"  out[3 * gid + 1] = out_v.y;                                                 \n"
"  out[3 * gid + 2] = out_v.z;                                                 \n"
"#endif                                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- Y u8 -- */                                                              \n"
"                                                                              \n"
"/* Y u8 -> Y float */                                                         \n"
"__kernel void yu8_to_yf (__global const uchar * in,                           \n"
"                         __global       float * out)                          \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float in_v  = convert_float (in[gid]) / 255.0f;                             \n"
"  float out_v;                                                                \n"
"  out_v = in_v;                                                               \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- Y float -- */                                                           \n"
"                                                                              \n"
"/* Y float -> RaGaBaA float */                                                \n"
"__kernel void yf_to_ragabaf (__global const float * in,                       \n"
"                              __global       float4 * out)                    \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float  y  = in[gid];                                                        \n"
"  float4 out_v = (float4) (y, y, y, 1.0f);                                    \n"
"                                                                              \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* -- YA float -- */                                                          \n"
"                                                                              \n"
"/* babl reference file: babl/base/rgb-constants.h */                          \n"
"#define RGB_LUMINANCE_RED    (0.22248840f)                                    \n"
"#define RGB_LUMINANCE_GREEN  (0.71690369f)                                    \n"
"#define RGB_LUMINANCE_BLUE   (0.06060791f)                                    \n"
"                                                                              \n"
"/* RGBA float -> YA float */                                                  \n"
"__kernel void rgbaf_to_yaf (__global const float4 * in,                       \n"
"                            __global       float2 * out)                      \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float2 out_v;                                                               \n"
"                                                                              \n"
"  float luminance = in_v.x * RGB_LUMINANCE_RED +                              \n"
"                    in_v.y * RGB_LUMINANCE_GREEN +                            \n"
"                    in_v.z * RGB_LUMINANCE_BLUE;                              \n"
"                                                                              \n"
"  out_v.x = luminance;                                                        \n"
"  out_v.y = in_v.w;                                                           \n"
"                                                                              \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* RaGaBaA float -> YA float */                                               \n"
"__kernel void ragabaf_to_yaf (__global const float4 * in,                     \n"
"                              __global       float2 * out)                    \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 tmp_v = in_v / (float4) (in_v.w);                                    \n"
"                                                                              \n"
"  float luminance = tmp_v.x * RGB_LUMINANCE_RED +                             \n"
"                    tmp_v.y * RGB_LUMINANCE_GREEN +                           \n"
"                    tmp_v.z * RGB_LUMINANCE_BLUE;                             \n"
"                                                                              \n"
"  out[gid] = (float2) (luminance, in_v.w);                                    \n"
"}                                                                             \n"
"                                                                              \n"
"/* YA float -> RGBA float */                                                  \n"
"__kernel void yaf_to_rgbaf (__global const float2 * in,                       \n"
"                            __global       float4 * out)                      \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in[gid];                                                     \n"
"  float4 out_v = (float4) (in_v.x, in_v.x, in_v.x, in_v.y);                   \n"
"                                                                              \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* YA float -> RaGaBaA float */                                               \n"
"__kernel void yaf_to_ragabaf (__global const float2 * in,                     \n"
"                              __global       float4 * out)                    \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in[gid];                                                     \n"
"  float4 out_v = (float4) (in_v.x * in_v.y,                                   \n"
"                           in_v.x * in_v.y,                                   \n"
"                           in_v.x * in_v.y,                                   \n"
"                           in_v.y);                                           \n"
"                                                                              \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* RGBA u8 -> YA float */                                                     \n"
"__kernel void rgbau8_to_yaf (__global const uchar4 * in,                      \n"
"                             __global       float2 * out)                     \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = convert_float4(in[gid]) / 255.0f;                            \n"
"  float2 out_v;                                                               \n"
"                                                                              \n"
"  float luminance = in_v.x * RGB_LUMINANCE_RED +                              \n"
"                    in_v.y * RGB_LUMINANCE_GREEN +                            \n"
"                    in_v.z * RGB_LUMINANCE_BLUE;                              \n"
"                                                                              \n"
"  out_v.x = luminance;                                                        \n"
"  out_v.y = in_v.w;                                                           \n"
"                                                                              \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"/* YA float -> RGBA u8 */                                                     \n"
"__kernel void yaf_to_rgbau8 (__global const float2 * in,                      \n"
"                             __global       uchar4 * out)                     \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in[gid];                                                     \n"
"  float4 out_v = (float4) (in_v.x, in_v.x, in_v.x, in_v.y);                   \n"
"                                                                              \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* YA float -> R'G'B'A u8 */                                                  \n"
"__kernel void yaf_to_rgba_gamma_u8 (__global const float2 * in,               \n"
"                                    __global       uchar4 * out)              \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in[gid];                                                     \n"
"  float4 tmp_v = (float4) (in_v.x, in_v.x, in_v.x, in_v.y);                   \n"
"                                                                              \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(tmp_v.x),                              \n"
"                   linear_to_gamma_2_2(tmp_v.y),                              \n"
"                   linear_to_gamma_2_2(tmp_v.z),                              \n"
"                   tmp_v.w);                                                  \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* YA float -> R'G'B' u8 */                                                   \n"
"__kernel void yaf_to_rgb_gamma_u8 (__global const float2 * in,                \n"
"                                   __global       uchar  * out)               \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float2 in_v  = in[gid];                                                     \n"
"  uchar  tmp = convert_uchar_sat_rte (255.0f * linear_to_gamma_2_2 (in_v.x)); \n"
"                                                                              \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  vstore3 ((uchar3)tmp, gid, out);                                            \n"
"#else                                                                         \n"
"  out[3 * gid] = out[3 * gid + 1] = out[3 * gid + 2] = tmp;                   \n"
"#endif                                                                        \n"
"}                                                                             \n"
"                                                                              \n"
"/* R'G'B'A u8 */                                                              \n"
"                                                                              \n"
"/* rgba float -> r'g'b'a u8 */                                                \n"
"__kernel void rgbaf_to_rgba_gamma_u8 (__global const float4 * in,             \n"
"                                      __global       uchar4 * out)            \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 out_v;                                                               \n"
"  out_v = (float4)(linear_to_gamma_2_2(in_v.x),                               \n"
"                   linear_to_gamma_2_2(in_v.y),                               \n"
"                   linear_to_gamma_2_2(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"  out[gid] = convert_uchar4_sat_rte(255.0f * out_v);                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* R'G'B' u8 */                                                               \n"
"                                                                              \n"
"/* rgba float -> r'g'b' u8 */                                                 \n"
"__kernel void rgbaf_to_rgb_gamma_u8 (__global const float4 * in,              \n"
"                                     __global       uchar  * out)             \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v  = in[gid];                                                     \n"
"  float4 tmp_v;                                                               \n"
"  tmp_v = (float4)(linear_to_gamma_2_2(in_v.x),                               \n"
"                   linear_to_gamma_2_2(in_v.y),                               \n"
"                   linear_to_gamma_2_2(in_v.z),                               \n"
"                   in_v.w);                                                   \n"
"#if (__OPENCL_VERSION__ != CL_VERSION_1_0)                                    \n"
"  uchar3 out_v;                                                               \n"
"  out_v = convert_uchar3_sat_rte(255.0f * tmp_v.xyz);                         \n"
"  vstore3 (out_v, gid, out);                                                  \n"
"#else                                                                         \n"
"  uchar4 out_v = convert_uchar4_sat_rte (255.0f * tmp_v);                     \n"
"  out[3 * gid]     = out_v.x;                                                 \n"
"  out[3 * gid + 1] = out_v.y;                                                 \n"
"  out[3 * gid + 2] = out_v.z;                                                 \n"
"#endif                                                                        \n"
"}                                                                             \n"
;
