/* imap-mailbox-attributes.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-mailbox-attributes.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_MAILBOX_ATTRIBUTES_0_PROPERTY,
	GEARY_IMAP_MAILBOX_ATTRIBUTES_IS_NO_SELECT_PROPERTY,
	GEARY_IMAP_MAILBOX_ATTRIBUTES_NUM_PROPERTIES
};
static GParamSpec* geary_imap_mailbox_attributes_properties[GEARY_IMAP_MAILBOX_ATTRIBUTES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_imap_mailbox_attributes_parent_class = NULL;

static GType geary_imap_mailbox_attributes_get_type_once (void);
static void _vala_geary_imap_mailbox_attributes_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gboolean
geary_imap_mailbox_attributes_get_is_no_select (GearyImapMailboxAttributes* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GearyImapMailboxAttribute* _tmp1_;
	GearyImapMailboxAttribute* _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (self), FALSE);
	_tmp1_ = geary_imap_mailbox_attribute_get_NO_SELECT ();
	_tmp2_ = _tmp1_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		_tmp0_ = TRUE;
	} else {
		GearyImapMailboxAttribute* _tmp3_;
		GearyImapMailboxAttribute* _tmp4_;
		_tmp3_ = geary_imap_mailbox_attribute_get_NONEXISTENT ();
		_tmp4_ = _tmp3_;
		_tmp0_ = geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag));
	}
	result = _tmp0_;
	return result;
}

GearyImapMailboxAttributes*
geary_imap_mailbox_attributes_construct (GType object_type,
                                         GeeCollection* attrs)
{
	GearyImapMailboxAttributes * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attrs, GEE_TYPE_COLLECTION), NULL);
	self = (GearyImapMailboxAttributes*) geary_imap_flags_construct (object_type, attrs);
	return self;
}

GearyImapMailboxAttributes*
geary_imap_mailbox_attributes_new (GeeCollection* attrs)
{
	return geary_imap_mailbox_attributes_construct (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTES, attrs);
}

/**
     * Create {@link MailboxAttributes} from a {@link ListParameter} of attribute strings.
     */
GearyImapMailboxAttributes*
geary_imap_mailbox_attributes_from_list (GearyImapListParameter* listp,
                                         GError** error)
{
	GeeCollection* list = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp12_;
	GearyImapMailboxAttributes* _tmp13_;
	GError* _inner_error0_ = NULL;
	GearyImapMailboxAttributes* result;
	g_return_val_if_fail (GEARY_IMAP_IS_LIST_PARAMETER (listp), NULL);
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				GearyImapStringParameter* _tmp5_ = NULL;
				GearyImapStringParameter* _tmp6_;
				GeeCollection* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GearyImapMailboxAttribute* _tmp10_;
				GearyImapMailboxAttribute* _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = ctr;
					ctr = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = geary_imap_list_parameter_get_size (listp);
				_tmp4_ = _tmp3_;
				if (!(ctr < _tmp4_)) {
					break;
				}
				_tmp6_ = geary_imap_list_parameter_get_as_string (listp, ctr, &_inner_error0_);
				_tmp5_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (list);
						return NULL;
					} else {
						_g_object_unref0 (list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp7_ = list;
				_tmp8_ = geary_imap_string_parameter_get_ascii (_tmp5_);
				_tmp9_ = _tmp8_;
				_tmp10_ = geary_imap_mailbox_attribute_new (_tmp9_);
				_tmp11_ = _tmp10_;
				gee_collection_add (_tmp7_, _tmp11_);
				_g_object_unref0 (_tmp11_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	_tmp12_ = list;
	_tmp13_ = geary_imap_mailbox_attributes_new (_tmp12_);
	result = _tmp13_;
	_g_object_unref0 (list);
	return result;
}

/**
     * Create {@link MailboxAttributes} from a flat string of space-delimited attributes.
     */
GearyImapMailboxAttributes*
geary_imap_mailbox_attributes_deserialize (const gchar* str)
{
	gchar** tokens = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint tokens_length1;
	gint _tokens_size_;
	GeeCollection* attrs = NULL;
	GeeArrayList* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GeeCollection* _tmp13_;
	GearyImapMailboxAttributes* _tmp14_;
	GearyImapMailboxAttributes* result;
	if (geary_string_is_empty (str)) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GearyImapMailboxAttributes* _tmp2_;
		GearyImapMailboxAttributes* _tmp3_;
		_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = geary_imap_mailbox_attributes_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		result = _tmp3_;
		return result;
	}
	_tmp5_ = _tmp4_ = g_strsplit (str, " ", 0);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	_tmp6_ = gee_array_list_new (GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	attrs = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp7_;
		token_collection_length1 = _tmp7__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp8_;
			gchar* token = NULL;
			_tmp8_ = g_strdup (token_collection[token_it]);
			token = _tmp8_;
			{
				GeeCollection* _tmp9_;
				const gchar* _tmp10_;
				GearyImapMailboxAttribute* _tmp11_;
				GearyImapMailboxAttribute* _tmp12_;
				_tmp9_ = attrs;
				_tmp10_ = token;
				_tmp11_ = geary_imap_mailbox_attribute_new (_tmp10_);
				_tmp12_ = _tmp11_;
				gee_collection_add (_tmp9_, _tmp12_);
				_g_object_unref0 (_tmp12_);
				_g_free0 (token);
			}
		}
	}
	_tmp13_ = attrs;
	_tmp14_ = geary_imap_mailbox_attributes_new (_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (attrs);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * Returns the special use specified for the mailbox.
     *
     * If no special use is set, returns {@link
     * Geary.Folder.SpecialUse.NONE}.
     */
GearyFolderSpecialUse
geary_imap_mailbox_attributes_get_special_use (GearyImapMailboxAttributes* self)
{
	GearyImapMailboxAttribute* _tmp0_;
	GearyImapMailboxAttribute* _tmp1_;
	GearyImapMailboxAttribute* _tmp2_;
	GearyImapMailboxAttribute* _tmp3_;
	GearyImapMailboxAttribute* _tmp4_;
	GearyImapMailboxAttribute* _tmp5_;
	GearyImapMailboxAttribute* _tmp6_;
	GearyImapMailboxAttribute* _tmp7_;
	GearyImapMailboxAttribute* _tmp8_;
	GearyImapMailboxAttribute* _tmp9_;
	GearyImapMailboxAttribute* _tmp10_;
	GearyImapMailboxAttribute* _tmp11_;
	GearyImapMailboxAttribute* _tmp12_;
	GearyImapMailboxAttribute* _tmp13_;
	GearyImapMailboxAttribute* _tmp14_;
	GearyImapMailboxAttribute* _tmp15_;
	GearyImapMailboxAttribute* _tmp16_;
	GearyImapMailboxAttribute* _tmp17_;
	GearyImapMailboxAttribute* _tmp18_;
	GearyImapMailboxAttribute* _tmp19_;
	GearyImapMailboxAttribute* _tmp20_;
	GearyImapMailboxAttribute* _tmp21_;
	GearyImapMailboxAttribute* _tmp22_;
	GearyImapMailboxAttribute* _tmp23_;
	GearyFolderSpecialUse result;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_ATTRIBUTES (self), 0);
	_tmp0_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_ALL ();
	_tmp1_ = _tmp0_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_ALL_MAIL;
		return result;
	}
	_tmp2_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_ARCHIVE ();
	_tmp3_ = _tmp2_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_ARCHIVE;
		return result;
	}
	_tmp4_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_DRAFTS ();
	_tmp5_ = _tmp4_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_DRAFTS;
		return result;
	}
	_tmp6_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_FLAGGED ();
	_tmp7_ = _tmp6_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_FLAGGED;
		return result;
	}
	_tmp8_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_IMPORTANT ();
	_tmp9_ = _tmp8_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_IMPORTANT;
		return result;
	}
	_tmp10_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_JUNK ();
	_tmp11_ = _tmp10_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_JUNK;
		return result;
	}
	_tmp12_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_SENT ();
	_tmp13_ = _tmp12_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_SENT;
		return result;
	}
	_tmp14_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_TRASH ();
	_tmp15_ = _tmp14_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_TRASH;
		return result;
	}
	_tmp16_ = geary_imap_mailbox_attribute_get_XLIST_ALL_MAIL ();
	_tmp17_ = _tmp16_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_ALL_MAIL;
		return result;
	}
	_tmp18_ = geary_imap_mailbox_attribute_get_XLIST_INBOX ();
	_tmp19_ = _tmp18_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_INBOX;
		return result;
	}
	_tmp20_ = geary_imap_mailbox_attribute_get_XLIST_SPAM ();
	_tmp21_ = _tmp20_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_JUNK;
		return result;
	}
	_tmp22_ = geary_imap_mailbox_attribute_get_XLIST_STARRED ();
	_tmp23_ = _tmp22_;
	if (geary_imap_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags), G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag))) {
		result = GEARY_FOLDER_SPECIAL_USE_FLAGGED;
		return result;
	}
	result = GEARY_FOLDER_SPECIAL_USE_NONE;
	return result;
}

static void
geary_imap_mailbox_attributes_class_init (GearyImapMailboxAttributesClass * klass,
                                          gpointer klass_data)
{
	geary_imap_mailbox_attributes_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_mailbox_attributes_get_property;
	/**
	     * True if the mailbox should not be accessed via SELECT, EXAMINE, or STATUS, i.e. is a
	     * "no-select" mailbox.
	     *
	     * See [[http://tools.ietf.org/html/rfc3501#section-7.2.2]] and
	     * [[http://tools.ietf.org/html/rfc5258#section-3]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MAILBOX_ATTRIBUTES_IS_NO_SELECT_PROPERTY, geary_imap_mailbox_attributes_properties[GEARY_IMAP_MAILBOX_ATTRIBUTES_IS_NO_SELECT_PROPERTY] = g_param_spec_boolean ("is-no-select", "is-no-select", "is-no-select", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_mailbox_attributes_instance_init (GearyImapMailboxAttributes * self,
                                             gpointer klass)
{
}

/**
 * A collection of {@link MailboxAttribute}s.
 *
 * @see ListCommand
 * @see MailboxInformation
 */
 G_GNUC_NO_INLINE static GType
geary_imap_mailbox_attributes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMailboxAttributesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_mailbox_attributes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMailboxAttributes), 0, (GInstanceInitFunc) geary_imap_mailbox_attributes_instance_init, NULL };
	GType geary_imap_mailbox_attributes_type_id;
	geary_imap_mailbox_attributes_type_id = g_type_register_static (GEARY_IMAP_TYPE_FLAGS, "GearyImapMailboxAttributes", &g_define_type_info, 0);
	return geary_imap_mailbox_attributes_type_id;
}

GType
geary_imap_mailbox_attributes_get_type (void)
{
	static gsize geary_imap_mailbox_attributes_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_mailbox_attributes_type_id__once)) {
		GType geary_imap_mailbox_attributes_type_id;
		geary_imap_mailbox_attributes_type_id = geary_imap_mailbox_attributes_get_type_once ();
		g_once_init_leave (&geary_imap_mailbox_attributes_type_id__once, geary_imap_mailbox_attributes_type_id);
	}
	return geary_imap_mailbox_attributes_type_id__once;
}

static void
_vala_geary_imap_mailbox_attributes_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GearyImapMailboxAttributes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MAILBOX_ATTRIBUTES, GearyImapMailboxAttributes);
	switch (property_id) {
		case GEARY_IMAP_MAILBOX_ATTRIBUTES_IS_NO_SELECT_PROPERTY:
		g_value_set_boolean (value, geary_imap_mailbox_attributes_get_is_no_select (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

