/* MainWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/* MainWindow.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "font-manager.h"
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include "vala-common.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	FONT_MANAGER_MODE_MANAGE,
	FONT_MANAGER_MODE_BROWSE,
	FONT_MANAGER_MODE_COMPARE,
	FONT_MANAGER_MODE_GOOGLE_FONTS,
	FONT_MANAGER_MODE_N_MODES
} FontManagerMode;

#define FONT_MANAGER_TYPE_MODE (font_manager_mode_get_type ())

#define FONT_MANAGER_TYPE_MAIN_WINDOW (font_manager_main_window_get_type ())
#define FONT_MANAGER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindow))
#define FONT_MANAGER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindowClass))
#define FONT_MANAGER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindowClass))

typedef struct _FontManagerMainWindow FontManagerMainWindow;
typedef struct _FontManagerMainWindowClass FontManagerMainWindowClass;
typedef struct _FontManagerMainWindowPrivate FontManagerMainWindowPrivate;

#define FONT_MANAGER_TYPE_DUAL_PANED (font_manager_dual_paned_get_type ())
#define FONT_MANAGER_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPaned))
#define FONT_MANAGER_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))
#define FONT_MANAGER_IS_DUAL_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_IS_DUAL_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_DUAL_PANED))
#define FONT_MANAGER_DUAL_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_DUAL_PANED, FontManagerDualPanedClass))

typedef struct _FontManagerDualPaned FontManagerDualPaned;
typedef struct _FontManagerDualPanedClass FontManagerDualPanedClass;

#define FONT_MANAGER_TYPE_MAIN_PANE (font_manager_main_pane_get_type ())
#define FONT_MANAGER_MAIN_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_MAIN_PANE, FontManagerMainPane))
#define FONT_MANAGER_MAIN_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_MAIN_PANE, FontManagerMainPaneClass))
#define FONT_MANAGER_IS_MAIN_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_MAIN_PANE))
#define FONT_MANAGER_IS_MAIN_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_MAIN_PANE))
#define FONT_MANAGER_MAIN_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_MAIN_PANE, FontManagerMainPaneClass))

typedef struct _FontManagerMainPane FontManagerMainPane;
typedef struct _FontManagerMainPaneClass FontManagerMainPaneClass;

#define FONT_MANAGER_TYPE_BROWSE_PANE (font_manager_browse_pane_get_type ())
#define FONT_MANAGER_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePane))
#define FONT_MANAGER_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))
#define FONT_MANAGER_IS_BROWSE_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_IS_BROWSE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_PANE))
#define FONT_MANAGER_BROWSE_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_PANE, FontManagerBrowsePaneClass))

typedef struct _FontManagerBrowsePane FontManagerBrowsePane;
typedef struct _FontManagerBrowsePaneClass FontManagerBrowsePaneClass;

#define FONT_MANAGER_TYPE_PANED (font_manager_paned_get_type ())
#define FONT_MANAGER_PANED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPaned))
#define FONT_MANAGER_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))
#define FONT_MANAGER_IS_PANED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_IS_PANED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PANED))
#define FONT_MANAGER_PANED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PANED, FontManagerPanedClass))

typedef struct _FontManagerPaned FontManagerPaned;
typedef struct _FontManagerPanedClass FontManagerPanedClass;

#define FONT_MANAGER_TYPE_PREFERENCE_PANE (font_manager_preference_pane_get_type ())
#define FONT_MANAGER_PREFERENCE_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_PANE, FontManagerPreferencePane))
#define FONT_MANAGER_PREFERENCE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_PANE, FontManagerPreferencePaneClass))
#define FONT_MANAGER_IS_PREFERENCE_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_PANE))
#define FONT_MANAGER_IS_PREFERENCE_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_PANE))
#define FONT_MANAGER_PREFERENCE_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_PANE, FontManagerPreferencePaneClass))

typedef struct _FontManagerPreferencePane FontManagerPreferencePane;
typedef struct _FontManagerPreferencePaneClass FontManagerPreferencePaneClass;

#define FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS (font_manager_header_bar_widgets_get_type ())
#define FONT_MANAGER_HEADER_BAR_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgets))
#define FONT_MANAGER_HEADER_BAR_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgetsClass))
#define FONT_MANAGER_IS_HEADER_BAR_WIDGETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS))
#define FONT_MANAGER_IS_HEADER_BAR_WIDGETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS))
#define FONT_MANAGER_HEADER_BAR_WIDGETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_HEADER_BAR_WIDGETS, FontManagerHeaderBarWidgetsClass))

typedef struct _FontManagerHeaderBarWidgets FontManagerHeaderBarWidgets;
typedef struct _FontManagerHeaderBarWidgetsClass FontManagerHeaderBarWidgetsClass;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG (font_manager_google_fonts_catalog_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalog))
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalogClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG))
#define FONT_MANAGER_GOOGLE_FONTS_IS_CATALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG))
#define FONT_MANAGER_GOOGLE_FONTS_CATALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_CATALOG, FontManagerGoogleFontsCatalogClass))

typedef struct _FontManagerGoogleFontsCatalog FontManagerGoogleFontsCatalog;
typedef struct _FontManagerGoogleFontsCatalogClass FontManagerGoogleFontsCatalogClass;
enum  {
	FONT_MANAGER_MAIN_WINDOW_0_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_CATEGORY_MODEL_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_COLLECTION_MODEL_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY,
	FONT_MANAGER_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block12Data Block12Data;

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;

#define FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES (font_manager_user_interface_preferences_get_type ())
#define FONT_MANAGER_USER_INTERFACE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES, FontManagerUserInterfacePreferences))
#define FONT_MANAGER_USER_INTERFACE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES, FontManagerUserInterfacePreferencesClass))
#define FONT_MANAGER_IS_USER_INTERFACE_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES))
#define FONT_MANAGER_IS_USER_INTERFACE_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES))
#define FONT_MANAGER_USER_INTERFACE_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_INTERFACE_PREFERENCES, FontManagerUserInterfacePreferencesClass))

typedef struct _FontManagerUserInterfacePreferences FontManagerUserInterfacePreferences;
typedef struct _FontManagerUserInterfacePreferencesClass FontManagerUserInterfacePreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_BROWSE_CONTROLS (font_manager_browse_controls_get_type ())
#define FONT_MANAGER_BROWSE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControls))
#define FONT_MANAGER_BROWSE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControlsClass))
#define FONT_MANAGER_IS_BROWSE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS))
#define FONT_MANAGER_IS_BROWSE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BROWSE_CONTROLS))
#define FONT_MANAGER_BROWSE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BROWSE_CONTROLS, FontManagerBrowseControlsClass))

typedef struct _FontManagerBrowseControls FontManagerBrowseControls;
typedef struct _FontManagerBrowseControlsClass FontManagerBrowseControlsClass;
typedef enum  {
	FONT_MANAGER_BROWSE_MODE_GRID,
	FONT_MANAGER_BROWSE_MODE_LIST,
	FONT_MANAGER_BROWSE_MODE_N_MODES
} FontManagerBrowseMode;

#define FONT_MANAGER_TYPE_BROWSE_MODE (font_manager_browse_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_LIBRARY_TYPE_INSTALLER (font_manager_library_installer_get_type ())
#define FONT_MANAGER_LIBRARY_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstaller))
#define FONT_MANAGER_LIBRARY_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_LIBRARY_TYPE_INSTALLER))
#define FONT_MANAGER_LIBRARY_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_LIBRARY_TYPE_INSTALLER, FontManagerLibraryInstallerClass))

typedef struct _FontManagerLibraryInstaller FontManagerLibraryInstaller;
typedef struct _FontManagerLibraryInstallerClass FontManagerLibraryInstallerClass;

#define FONT_MANAGER_TYPE_APPLICATION (font_manager_application_get_type ())
#define FONT_MANAGER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication))
#define FONT_MANAGER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))
#define FONT_MANAGER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))

typedef struct _FontManagerApplication FontManagerApplication;
typedef struct _FontManagerApplicationClass FontManagerApplicationClass;

#define FONT_MANAGER_TYPE_REMOVE_DIALOG (font_manager_remove_dialog_get_type ())
#define FONT_MANAGER_REMOVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog))
#define FONT_MANAGER_REMOVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialogClass))
#define FONT_MANAGER_IS_REMOVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG))
#define FONT_MANAGER_IS_REMOVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_REMOVE_DIALOG))
#define FONT_MANAGER_REMOVE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialogClass))

typedef struct _FontManagerRemoveDialog FontManagerRemoveDialog;
typedef struct _FontManagerRemoveDialogClass FontManagerRemoveDialogClass;

#define FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG (font_manager_user_data_import_dialog_get_type ())
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialog))
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialogClass))
#define FONT_MANAGER_USER_DATA_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialogClass))

typedef struct _FontManagerUserDataImportDialog FontManagerUserDataImportDialog;
typedef struct _FontManagerUserDataImportDialogClass FontManagerUserDataImportDialogClass;

#define FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG (font_manager_user_data_export_dialog_get_type ())
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialog))
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialogClass))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialogClass))

typedef struct _FontManagerUserDataExportDialog FontManagerUserDataExportDialog;
typedef struct _FontManagerUserDataExportDialogClass FontManagerUserDataExportDialogClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL (font_manager_font_list_filter_model_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModel))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL))
#define FONT_MANAGER_FONT_LIST_FILTER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER_MODEL, FontManagerFontListFilterModelClass))

typedef struct _FontManagerFontListFilterModel FontManagerFontListFilterModel;
typedef struct _FontManagerFontListFilterModelClass FontManagerFontListFilterModelClass;

#define FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL (font_manager_category_list_model_get_type ())
#define FONT_MANAGER_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModel))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_IS_CATEGORY_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL))
#define FONT_MANAGER_CATEGORY_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, FontManagerCategoryListModelClass))

typedef struct _FontManagerCategoryListModel FontManagerCategoryListModel;
typedef struct _FontManagerCategoryListModelClass FontManagerCategoryListModelClass;

#define FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL (font_manager_collection_list_model_get_type ())
#define FONT_MANAGER_COLLECTION_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL, FontManagerCollectionListModel))
#define FONT_MANAGER_COLLECTION_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL, FontManagerCollectionListModelClass))
#define FONT_MANAGER_IS_COLLECTION_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL))
#define FONT_MANAGER_IS_COLLECTION_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL))
#define FONT_MANAGER_COLLECTION_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL, FontManagerCollectionListModelClass))

typedef struct _FontManagerCollectionListModel FontManagerCollectionListModel;
typedef struct _FontManagerCollectionListModelClass FontManagerCollectionListModelClass;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _FontManagerMainWindow {
	FontManagerApplicationWindow parent_instance;
	FontManagerMainWindowPrivate * priv;
};

struct _FontManagerMainWindowClass {
	FontManagerApplicationWindowClass parent_class;
};

struct _FontManagerMainWindowPrivate {
	gboolean _show_preferences;
	GtkProgressBar* _progress;
	JsonArray* _available_fonts;
	FontManagerReject* _disabled_families;
	GtkStack* main_stack;
	FontManagerMainPane* main_pane;
	FontManagerBrowsePane* _browse_pane;
	FontManagerPreferencePane* prefs_pane;
	FontManagerHeaderBarWidgets* header_widgets;
	FontManagerMode _mode;
	FontManagerGoogleFontsCatalog* google_fonts;
};

struct _Block12Data {
	int _ref_count_;
	FontManagerMainWindow* self;
	GSettings* settings;
};

static gint FontManagerMainWindow_private_offset;
static gpointer font_manager_main_window_parent_class = NULL;

VALA_EXTERN GType font_manager_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerMode font_manager_mode_parse (const gchar* mode);
VALA_EXTERN gchar* font_manager_mode_to_string (FontManagerMode self);
VALA_EXTERN gchar* font_manager_mode_to_translatable_string (FontManagerMode self);
VALA_EXTERN GType font_manager_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerMainWindow, g_object_unref)
VALA_EXTERN GType font_manager_dual_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerDualPaned, g_object_unref)
VALA_EXTERN GType font_manager_main_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerMainPane, g_object_unref)
VALA_EXTERN GType font_manager_browse_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowsePane, g_object_unref)
VALA_EXTERN GType font_manager_paned_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPaned, g_object_unref)
VALA_EXTERN GType font_manager_preference_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferencePane, g_object_unref)
VALA_EXTERN GType font_manager_header_bar_widgets_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerHeaderBarWidgets, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_catalog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsCatalog, g_object_unref)
VALA_EXTERN FontManagerMainWindow* font_manager_main_window_new (GSettings* settings);
VALA_EXTERN FontManagerMainWindow* font_manager_main_window_construct (GType object_type,
                                                           GSettings* settings);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void font_manager_main_window_set_progress (FontManagerMainWindow* self,
                                            GtkProgressBar* value);
VALA_EXTERN GtkProgressBar* font_manager_main_window_get_progress (FontManagerMainWindow* self);
VALA_EXTERN FontManagerHeaderBarWidgets* font_manager_header_bar_widgets_new (GSettings* settings);
VALA_EXTERN FontManagerHeaderBarWidgets* font_manager_header_bar_widgets_construct (GType object_type,
                                                                        GSettings* settings);
VALA_EXTERN GtkButton* font_manager_header_bar_widgets_get_back_button (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkMenuButton* font_manager_header_bar_widgets_get_main_menu (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkRevealer* font_manager_header_bar_widgets_get_revealer (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkMenuButton* font_manager_header_bar_widgets_get_app_menu (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkLabel* font_manager_header_bar_widgets_get_title_label (FontManagerHeaderBarWidgets* self);
VALA_EXTERN FontManagerMainPane* font_manager_main_pane_new (GSettings* settings);
VALA_EXTERN FontManagerMainPane* font_manager_main_pane_construct (GType object_type,
                                                       GSettings* settings);
VALA_EXTERN FontManagerBrowsePane* font_manager_browse_pane_new (void);
VALA_EXTERN FontManagerBrowsePane* font_manager_browse_pane_construct (GType object_type);
VALA_EXTERN void font_manager_main_window_set_browse_pane (FontManagerMainWindow* self,
                                               FontManagerBrowsePane* value);
VALA_EXTERN FontManagerPreferencePane* font_manager_preference_pane_new (GSettings* settings);
VALA_EXTERN FontManagerPreferencePane* font_manager_preference_pane_construct (GType object_type,
                                                                   GSettings* settings);
VALA_EXTERN void font_manager_main_pane_set_waterfall_settings (FontManagerMainPane* self,
                                                    FontManagerWaterfallSettings* value);
VALA_EXTERN FontManagerBrowsePane* font_manager_main_window_get_browse_pane (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_browse_pane_set_waterfall_settings (FontManagerBrowsePane* self,
                                                      FontManagerWaterfallSettings* value);
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_user_interface_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserInterfacePreferences, g_object_unref)
VALA_EXTERN FontManagerUserInterfacePreferences* font_manager_preference_pane_get_interface_preferences (FontManagerPreferencePane* self);
VALA_EXTERN void font_manager_user_interface_preferences_set_waterfall_settings (FontManagerUserInterfacePreferences* self,
                                                                     FontManagerWaterfallSettings* value);
VALA_EXTERN FontManagerGoogleFontsCatalog* font_manager_google_fonts_catalog_new (GSettings* settings);
VALA_EXTERN FontManagerGoogleFontsCatalog* font_manager_google_fonts_catalog_construct (GType object_type,
                                                                            GSettings* settings);
VALA_EXTERN void font_manager_google_fonts_catalog_set_waterfall_settings (FontManagerGoogleFontsCatalog* self,
                                                               FontManagerWaterfallSettings* value);
VALA_EXTERN GType font_manager_browse_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBrowseControls, g_object_unref)
VALA_EXTERN FontManagerBrowseControls* font_manager_header_bar_widgets_get_browse_controls (FontManagerHeaderBarWidgets* self);
VALA_EXTERN GtkStack* font_manager_browse_pane_get_stack (FontManagerBrowsePane* self);
static gboolean __lambda192_ (FontManagerMainWindow* self,
                       GBinding* b,
                       GValue* val,
                       GValue* v);
VALA_EXTERN GType font_manager_browse_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FontManagerBrowseMode font_manager_browse_mode_from_string (const gchar* mode);
static gboolean ___lambda192__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean __lambda193_ (FontManagerMainWindow* self,
                       GBinding* b,
                       GValue* val,
                       GValue* v);
VALA_EXTERN gchar* font_manager_browse_mode_to_string (FontManagerBrowseMode self);
static gboolean ___lambda193__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static void font_manager_main_window_bind_settings (FontManagerMainWindow* self);
static void font_manager_main_window_connect_signals (FontManagerMainWindow* self);
static void font_manager_main_window_update_layout_orientation (FontManagerMainWindow* self);
static void __lambda197_ (Block12Data* _data12_);
VALA_EXTERN void font_manager_main_window_set_mode (FontManagerMainWindow* self,
                                        FontManagerMode value);
static gboolean __lambda198_ (FontManagerMainWindow* self);
VALA_EXTERN FontManagerMode font_manager_main_window_get_mode (FontManagerMainWindow* self);
static gboolean ___lambda198__gsource_func (gpointer self);
static void ___lambda197__gtk_widget_map (GtkWidget* _sender,
                                   gpointer self);
static void __lambda199_ (Block12Data* _data12_);
VALA_EXTERN void font_manager_browse_pane_restore_state (FontManagerBrowsePane* self,
                                             GSettings* settings);
static void ___lambda199__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
static gboolean font_manager_main_window_on_drag_data_received (FontManagerMainWindow* self,
                                                         GValue* value,
                                                         gdouble x,
                                                         gdouble y);
static gboolean _font_manager_main_window_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                               GValue* value,
                                                                               gdouble x,
                                                                               gdouble y,
                                                                               gpointer self);
VALA_EXTERN void font_manager_main_window_focus_search (FontManagerMainWindow* self,
                                            GtkWidget* widget,
                                            const gchar* action,
                                            GVariant* parameter);
VALA_EXTERN void font_manager_main_pane_focus_search_entry (FontManagerMainPane* self);
VALA_EXTERN void font_manager_browse_pane_toggle_search (FontManagerBrowsePane* self);
VALA_EXTERN void font_manager_main_window_search (FontManagerMainWindow* self,
                                      const gchar* needle);
VALA_EXTERN void font_manager_main_pane_search (FontManagerMainPane* self,
                                    const gchar* needle);
VALA_EXTERN void font_manager_browse_pane_search (FontManagerBrowsePane* self,
                                      const gchar* needle);
VALA_EXTERN gboolean font_manager_main_window_progress_update (FontManagerMainWindow* self,
                                                   FontManagerProgressData* data);
VALA_EXTERN void font_manager_main_window_select_first_category (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_main_pane_select_first_category (FontManagerMainPane* self);
VALA_EXTERN void font_manager_main_window_select_first_font (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_main_pane_select_first_font (FontManagerMainPane* self);
static void __lambda194_ (FontManagerMainWindow* self,
                   const gchar* key);
static void ___lambda194__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void font_manager_main_window_on_mode_changed (FontManagerMainWindow* self,
                                               GParamSpec* pspec);
static void _font_manager_main_window_on_mode_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void font_manager_main_window_on_stack_page_changed (FontManagerMainWindow* self,
                                                     GParamSpec* pspec);
static void _font_manager_main_window_on_stack_page_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void __lambda196_ (FontManagerMainWindow* self);
static void ___lambda196__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static FontManagerStringSet* font_manager_main_window_get_file_selections (FontManagerMainWindow* self,
                                                                    GObject* object,
                                                                    GAsyncResult* _result_);
VALA_EXTERN void font_manager_main_window_install_selections (FontManagerMainWindow* self,
                                                  FontManagerStringSet* selections);
VALA_EXTERN void font_manager_header_bar_widgets_set_installing_files (FontManagerHeaderBarWidgets* self,
                                                           gboolean value);
VALA_EXTERN GType font_manager_library_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLibraryInstaller, g_object_unref)
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_new (void);
VALA_EXTERN FontManagerLibraryInstaller* font_manager_library_installer_construct (GType object_type);
VALA_EXTERN void font_manager_library_installer_process (FontManagerLibraryInstaller* self,
                                             FontManagerStringSet* filelist,
                                             GAsyncReadyCallback callback,
                                             gpointer callback_target);
static void __lambda200_ (FontManagerMainWindow* self,
                   GObject* object,
                   GTask* task);
static gboolean __lambda201_ (FontManagerMainWindow* self);
VALA_EXTERN GType font_manager_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerApplication, g_object_unref)
VALA_EXTERN guint font_manager_application_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN FontManagerApplication* font_manager_get_default_application (void);
VALA_EXTERN void font_manager_application_reload (FontManagerApplication* self);
static gboolean ___lambda201__gsource_func (gpointer self);
static void ___lambda200__gasync_ready_callback (GObject* source_object,
                                          GTask* task,
                                          gpointer self);
static void font_manager_main_window_install_selected_files (FontManagerMainWindow* self,
                                                      GObject* object,
                                                      GAsyncResult* _result_);
static void font_manager_main_window_reload (FontManagerMainWindow* self,
                                      GtkWidget* widget,
                                      const gchar* action,
                                      GVariant* parameter);
static void font_manager_main_window_install (FontManagerMainWindow* self,
                                       GtkWidget* widget,
                                       const gchar* action,
                                       GVariant* parameter);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_selections (void);
static void _font_manager_main_window_install_selected_files_gasync_ready_callback (GObject* source_object,
                                                                             GAsyncResult* res,
                                                                             gpointer self);
static void font_manager_main_window_remove (FontManagerMainWindow* self,
                                      GtkWidget* widget,
                                      const gchar* action,
                                      GVariant* parameter);
VALA_EXTERN GType font_manager_remove_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerRemoveDialog, g_object_unref)
VALA_EXTERN FontManagerRemoveDialog* font_manager_remove_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerRemoveDialog* font_manager_remove_dialog_construct (GType object_type,
                                                               GtkWindow* parent);
static void __lambda209_ (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_header_bar_widgets_set_removing_files (FontManagerHeaderBarWidgets* self,
                                                         gboolean value);
static void ___lambda209__font_manager_remove_dialog_start_removal (FontManagerRemoveDialog* _sender,
                                                             gpointer self);
static void __lambda210_ (FontManagerMainWindow* self);
static void ___lambda210__font_manager_remove_dialog_end_removal (FontManagerRemoveDialog* _sender,
                                                           gpointer self);
static void font_manager_main_window_import (FontManagerMainWindow* self,
                                      GtkWidget* widget,
                                      const gchar* action,
                                      GVariant* parameter);
VALA_EXTERN GType font_manager_user_data_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserDataImportDialog, g_object_unref)
VALA_EXTERN FontManagerUserDataImportDialog* font_manager_user_data_import_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerUserDataImportDialog* font_manager_user_data_import_dialog_construct (GType object_type,
                                                                                 GtkWindow* parent);
VALA_EXTERN void font_manager_user_data_import_dialog_present (FontManagerUserDataImportDialog* self);
static void font_manager_main_window_export (FontManagerMainWindow* self,
                                      GtkWidget* widget,
                                      const gchar* action,
                                      GVariant* parameter);
VALA_EXTERN GType font_manager_user_data_export_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserDataExportDialog, g_object_unref)
VALA_EXTERN FontManagerUserDataExportDialog* font_manager_user_data_export_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerUserDataExportDialog* font_manager_user_data_export_dialog_construct (GType object_type,
                                                                                 GtkWindow* parent);
VALA_EXTERN GtkLabel* font_manager_header_bar_widgets_get_main_menu_label (FontManagerHeaderBarWidgets* self);
VALA_EXTERN void font_manager_header_bar_widgets_reveal_controls (FontManagerHeaderBarWidgets* self,
                                                      FontManagerMode mode);
VALA_EXTERN void font_manager_browse_pane_select_first_font (FontManagerBrowsePane* self);
static gboolean _____lambda195_ (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_google_fonts_catalog_select_first_font (FontManagerGoogleFontsCatalog* self);
static gboolean ______lambda195__gsource_func (gpointer self);
VALA_EXTERN gboolean font_manager_main_window_get_show_preferences (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_dual_paned_set_orientation (FontManagerDualPaned* self,
                                              GtkOrientation value);
static gboolean ___lambda202_ (FontManagerMainWindow* self);
static gboolean ____lambda202__gsource_func (gpointer self);
VALA_EXTERN void font_manager_main_window_set_show_preferences (FontManagerMainWindow* self,
                                                    gboolean value);
VALA_EXTERN GType font_manager_font_list_filter_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilterModel, g_object_unref)
VALA_EXTERN GType font_manager_category_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCategoryListModel, g_object_unref)
VALA_EXTERN FontManagerCategoryListModel* font_manager_main_window_get_category_model (FontManagerMainWindow* self);
VALA_EXTERN FontManagerCategoryListModel* font_manager_main_pane_get_category_model (FontManagerMainPane* self);
VALA_EXTERN GType font_manager_collection_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCollectionListModel, g_object_unref)
VALA_EXTERN FontManagerCollectionListModel* font_manager_main_window_get_collection_model (FontManagerMainWindow* self);
VALA_EXTERN FontManagerCollectionListModel* font_manager_main_pane_get_collection_model (FontManagerMainPane* self);
VALA_EXTERN JsonArray* font_manager_main_window_get_available_fonts (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_main_window_set_available_fonts (FontManagerMainWindow* self,
                                                   JsonArray* value);
VALA_EXTERN FontManagerReject* font_manager_main_window_get_disabled_families (FontManagerMainWindow* self);
VALA_EXTERN void font_manager_main_window_set_disabled_families (FontManagerMainWindow* self,
                                                     FontManagerReject* value);
static void font_manager_main_window_finalize (GObject * obj);
static GType font_manager_main_window_get_type_once (void);
static void _vala_font_manager_main_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_font_manager_main_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

FontManagerMode
font_manager_mode_parse (const gchar* mode)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	FontManagerMode result;
	g_return_val_if_fail (mode != NULL, 0);
	_tmp0_ = g_utf8_strdown (mode, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("browse")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("1"))))) {
		switch (0) {
			default:
			{
				result = FONT_MANAGER_MODE_BROWSE;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("compare")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("2"))))) {
		switch (0) {
			default:
			{
				result = FONT_MANAGER_MODE_COMPARE;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("googlefonts")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("3"))))) {
		switch (0) {
			default:
			{
				result = FONT_MANAGER_MODE_GOOGLE_FONTS;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FONT_MANAGER_MODE_MANAGE;
				return result;
			}
		}
	}
}

gchar*
font_manager_mode_to_string (FontManagerMode self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_MODE_BROWSE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Browse");
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_MODE_COMPARE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Compare");
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_MODE_GOOGLE_FONTS:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("GoogleFonts");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Default");
			result = _tmp3_;
			return result;
		}
	}
}

gchar*
font_manager_mode_to_translatable_string (FontManagerMode self)
{
	gchar* result;
	switch (self) {
		case FONT_MANAGER_MODE_BROWSE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Browse"));
			result = _tmp0_;
			return result;
		}
		case FONT_MANAGER_MODE_COMPARE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Compare"));
			result = _tmp1_;
			return result;
		}
		case FONT_MANAGER_MODE_GOOGLE_FONTS:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Google Fonts"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Manage"));
			result = _tmp3_;
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
font_manager_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_MODE_MANAGE, "FONT_MANAGER_MODE_MANAGE", "manage"}, {FONT_MANAGER_MODE_BROWSE, "FONT_MANAGER_MODE_BROWSE", "browse"}, {FONT_MANAGER_MODE_COMPARE, "FONT_MANAGER_MODE_COMPARE", "compare"}, {FONT_MANAGER_MODE_GOOGLE_FONTS, "FONT_MANAGER_MODE_GOOGLE_FONTS", "google-fonts"}, {FONT_MANAGER_MODE_N_MODES, "FONT_MANAGER_MODE_N_MODES", "n-modes"}, {0, NULL, NULL}};
	GType font_manager_mode_type_id;
	font_manager_mode_type_id = g_enum_register_static ("FontManagerMode", values);
	return font_manager_mode_type_id;
}

GType
font_manager_mode_get_type (void)
{
	static volatile gsize font_manager_mode_type_id__once = 0;
	if (g_once_init_enter (&font_manager_mode_type_id__once)) {
		GType font_manager_mode_type_id;
		font_manager_mode_type_id = font_manager_mode_get_type_once ();
		g_once_init_leave (&font_manager_mode_type_id__once, font_manager_mode_type_id);
	}
	return font_manager_mode_type_id__once;
}

static inline gpointer
font_manager_main_window_get_instance_private (FontManagerMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerMainWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		FontManagerMainWindow* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda192_ (FontManagerMainWindow* self,
              GBinding* b,
              GValue* val,
              GValue* v)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (v != NULL, FALSE);
	_tmp0_ = g_value_get_string (val);
	g_value_set_enum (v, (gint) font_manager_browse_mode_from_string (_tmp0_));
	result = TRUE;
	return result;
}

static gboolean
___lambda192__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = __lambda192_ ((FontManagerMainWindow*) self, binding, from_value, to_value);
	return result;
}

static gboolean
__lambda193_ (FontManagerMainWindow* self,
              GBinding* b,
              GValue* val,
              GValue* v)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (v != NULL, FALSE);
	_tmp0_ = font_manager_browse_mode_to_string ((FontManagerBrowseMode) g_value_get_enum (val));
	_tmp1_ = _tmp0_;
	g_value_set_string (v, _tmp1_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
___lambda193__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = __lambda193_ ((FontManagerMainWindow*) self, binding, from_value, to_value);
	return result;
}

static gboolean
__lambda198_ (FontManagerMainWindow* self)
{
	FontManagerMode _tmp0_;
	FontManagerMode _tmp1_;
	gboolean result;
	_tmp0_ = font_manager_main_window_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FONT_MANAGER_MODE_BROWSE) {
		font_manager_main_window_set_mode (self, FONT_MANAGER_MODE_MANAGE);
		font_manager_main_window_set_mode (self, FONT_MANAGER_MODE_BROWSE);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda198__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda198_ ((FontManagerMainWindow*) self);
	return result;
}

static void
__lambda197_ (Block12Data* _data12_)
{
	FontManagerMainWindow* self;
	self = _data12_->self;
	if (_data12_->settings != NULL) {
		font_manager_main_window_set_mode (self, (FontManagerMode) g_settings_get_enum (_data12_->settings, "mode"));
	} else {
		font_manager_main_window_set_mode (self, FONT_MANAGER_MODE_BROWSE);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda198__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda197__gtk_widget_map (GtkWidget* _sender,
                              gpointer self)
{
	__lambda197_ (self);
}

static void
__lambda199_ (Block12Data* _data12_)
{
	FontManagerMainWindow* self;
	FontManagerBrowsePane* _tmp0_;
	self = _data12_->self;
	_tmp0_ = self->priv->_browse_pane;
	font_manager_browse_pane_restore_state (_tmp0_, _data12_->settings);
}

static void
___lambda199__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda199_ (self);
}

static gboolean
_font_manager_main_window_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                      GValue* value,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self)
{
	gboolean result;
	result = font_manager_main_window_on_drag_data_received ((FontManagerMainWindow*) self, value, x, y);
	return result;
}

FontManagerMainWindow*
font_manager_main_window_construct (GType object_type,
                                    GSettings* settings)
{
	FontManagerMainWindow * self = NULL;
	Block12Data* _data12_;
	GSettings* _tmp0_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp1_;
	GtkProgressBar* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkStack* _tmp5_;
	GtkStack* _tmp6_;
	GtkProgressBar* _tmp7_;
	GtkHeaderBar* header = NULL;
	GtkHeaderBar* _tmp8_;
	FontManagerHeaderBarWidgets* _tmp9_;
	FontManagerHeaderBarWidgets* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	FontManagerHeaderBarWidgets* _tmp13_;
	GtkMenuButton* _tmp14_;
	GtkMenuButton* _tmp15_;
	FontManagerHeaderBarWidgets* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkRevealer* _tmp18_;
	FontManagerHeaderBarWidgets* _tmp19_;
	GtkMenuButton* _tmp20_;
	GtkMenuButton* _tmp21_;
	FontManagerHeaderBarWidgets* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkStack* _tmp25_;
	GtkStack* _tmp26_;
	FontManagerMainPane* _tmp27_;
	FontManagerBrowsePane* _tmp28_;
	FontManagerBrowsePane* _tmp29_;
	FontManagerPreferencePane* _tmp30_;
	FontManagerWaterfallSettings* waterfall_settings = NULL;
	FontManagerWaterfallSettings* _tmp31_;
	FontManagerMainPane* _tmp32_;
	FontManagerBrowsePane* _tmp33_;
	FontManagerPreferencePane* _tmp34_;
	FontManagerUserInterfacePreferences* _tmp35_;
	FontManagerUserInterfacePreferences* _tmp36_;
	gchar* symbolic_icon = NULL;
	gchar* _tmp37_;
	FontManagerPlaceHolder* blank = NULL;
	FontManagerPlaceHolder* _tmp38_ = NULL;
	GtkStack* _tmp39_;
	GtkStack* _tmp40_;
	FontManagerMainPane* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkStack* _tmp44_;
	FontManagerBrowsePane* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	FontManagerGoogleFontsCatalog* _tmp48_;
	FontManagerGoogleFontsCatalog* _tmp49_;
	GtkStack* _tmp50_;
	FontManagerGoogleFontsCatalog* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GtkStack* _tmp54_;
	FontManagerPreferencePane* _tmp55_;
	GBindingFlags flags = 0U;
	FontManagerMainPane* _tmp56_;
	FontManagerMainPane* _tmp57_;
	FontManagerMainPane* _tmp58_;
	FontManagerBrowsePane* _tmp59_;
	FontManagerBrowsePane* _tmp60_;
	FontManagerPreferencePane* _tmp61_;
	FontManagerMainPane* _tmp62_;
	FontManagerPreferencePane* _tmp63_;
	FontManagerMainPane* _tmp64_;
	FontManagerMainPane* _tmp65_;
	FontManagerPreferencePane* _tmp66_;
	FontManagerHeaderBarWidgets* _tmp67_;
	FontManagerBrowseControls* _tmp68_;
	FontManagerBrowseControls* _tmp69_;
	FontManagerBrowsePane* _tmp70_;
	FontManagerBrowsePane* _tmp71_;
	GtkStack* _tmp72_;
	GtkStack* _tmp73_;
	FontManagerHeaderBarWidgets* _tmp74_;
	FontManagerBrowseControls* _tmp75_;
	FontManagerBrowseControls* _tmp76_;
	FontManagerMainPane* _tmp77_;
	FontManagerGoogleFontsCatalog* _tmp78_;
	FontManagerMainPane* _tmp79_;
	FontManagerGoogleFontsCatalog* _tmp80_;
	FontManagerBrowsePane* _tmp81_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp82_;
	GtkEventController* _tmp83_;
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data12_->settings);
	_data12_->settings = _tmp0_;
	self = (FontManagerMainWindow*) g_object_new (object_type, "settings", _data12_->settings, NULL);
	_data12_->self = g_object_ref (self);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp1_);
	overlay = _tmp1_;
	_tmp2_ = (GtkProgressBar*) gtk_progress_bar_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_FILL);
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, FALSE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	font_manager_main_window_set_progress (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_progress;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "osd");
	_tmp5_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp5_;
	_tmp6_ = self->priv->main_stack;
	gtk_overlay_set_child (overlay, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->_progress;
	gtk_overlay_add_overlay (overlay, (GtkWidget*) _tmp7_);
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) overlay);
	_tmp8_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp8_);
	header = _tmp8_;
	_tmp9_ = font_manager_header_bar_widgets_new (_data12_->settings);
	_g_object_unref0 (self->priv->header_widgets);
	self->priv->header_widgets = _tmp9_;
	_tmp10_ = self->priv->header_widgets;
	_tmp11_ = font_manager_header_bar_widgets_get_back_button (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_header_bar_pack_start (header, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->header_widgets;
	_tmp14_ = font_manager_header_bar_widgets_get_main_menu (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_header_bar_pack_start (header, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->header_widgets;
	_tmp17_ = font_manager_header_bar_widgets_get_revealer (_tmp16_);
	_tmp18_ = _tmp17_;
	gtk_header_bar_pack_start (header, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->header_widgets;
	_tmp20_ = font_manager_header_bar_widgets_get_app_menu (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_header_bar_pack_end (header, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->header_widgets;
	_tmp23_ = font_manager_header_bar_widgets_get_title_label (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_header_bar_set_title_widget (header, (GtkWidget*) _tmp24_);
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp25_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp25_, GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP);
	_tmp26_ = self->priv->main_stack;
	gtk_stack_set_transition_duration (_tmp26_, (guint) 500);
	_tmp27_ = font_manager_main_pane_new (_data12_->settings);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->main_pane);
	self->priv->main_pane = _tmp27_;
	_tmp28_ = font_manager_browse_pane_new ();
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	font_manager_main_window_set_browse_pane (self, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = font_manager_preference_pane_new (_data12_->settings);
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->prefs_pane);
	self->priv->prefs_pane = _tmp30_;
	_tmp31_ = font_manager_waterfall_settings_new (_data12_->settings);
	waterfall_settings = _tmp31_;
	_tmp32_ = self->priv->main_pane;
	font_manager_main_pane_set_waterfall_settings (_tmp32_, waterfall_settings);
	_tmp33_ = self->priv->_browse_pane;
	font_manager_browse_pane_set_waterfall_settings (_tmp33_, waterfall_settings);
	_tmp34_ = self->priv->prefs_pane;
	_tmp35_ = font_manager_preference_pane_get_interface_preferences (_tmp34_);
	_tmp36_ = _tmp35_;
	font_manager_user_interface_preferences_set_waterfall_settings (_tmp36_, waterfall_settings);
	_tmp37_ = g_strdup ("com.github.FontManager.FontManager-symbolic");
	symbolic_icon = _tmp37_;
	_tmp38_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (NULL, NULL, NULL, symbolic_icon);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp38_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp38_, TRUE);
	g_object_ref_sink (_tmp38_);
	blank = _tmp38_;
	_tmp39_ = self->priv->main_stack;
	gtk_stack_add_named (_tmp39_, (GtkWidget*) blank, "Blank");
	_tmp40_ = self->priv->main_stack;
	_tmp41_ = self->priv->main_pane;
	_tmp42_ = font_manager_mode_to_string (FONT_MANAGER_MODE_MANAGE);
	_tmp43_ = _tmp42_;
	gtk_stack_add_named (_tmp40_, (GtkWidget*) _tmp41_, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->main_stack;
	_tmp45_ = self->priv->_browse_pane;
	_tmp46_ = font_manager_mode_to_string (FONT_MANAGER_MODE_BROWSE);
	_tmp47_ = _tmp46_;
	gtk_stack_add_named (_tmp44_, (GtkWidget*) _tmp45_, _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = font_manager_google_fonts_catalog_new (_data12_->settings);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->google_fonts);
	self->priv->google_fonts = _tmp48_;
	_tmp49_ = self->priv->google_fonts;
	font_manager_google_fonts_catalog_set_waterfall_settings (_tmp49_, waterfall_settings);
	_tmp50_ = self->priv->main_stack;
	_tmp51_ = self->priv->google_fonts;
	_tmp52_ = font_manager_mode_to_string (FONT_MANAGER_MODE_GOOGLE_FONTS);
	_tmp53_ = _tmp52_;
	gtk_stack_add_named (_tmp50_, (GtkWidget*) _tmp51_, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = self->priv->main_stack;
	_tmp55_ = self->priv->prefs_pane;
	gtk_stack_add_named (_tmp54_, (GtkWidget*) _tmp55_, "Preferences");
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	_tmp56_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp56_, "mode", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp57_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) self, "available-fonts", (GObject*) _tmp57_, "available-fonts", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp58_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp58_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp59_ = self->priv->_browse_pane;
	g_object_bind_property_with_closures ((GObject*) self, "available-fonts", (GObject*) _tmp59_, "available-fonts", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp60_ = self->priv->_browse_pane;
	g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp60_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp61_ = self->priv->prefs_pane;
	_tmp62_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) _tmp61_, "user-actions", (GObject*) _tmp62_, "user-actions", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp63_ = self->priv->prefs_pane;
	_tmp64_ = self->priv->main_pane;
	g_object_bind_property_with_closures ((GObject*) _tmp63_, "user-sources", (GObject*) _tmp64_, "user-sources", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp65_ = self->priv->main_pane;
	_tmp66_ = self->priv->prefs_pane;
	g_object_bind_property_with_closures ((GObject*) _tmp65_, "sidebar-position", (GObject*) _tmp66_, "position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp67_ = self->priv->header_widgets;
	_tmp68_ = font_manager_header_bar_widgets_get_browse_controls (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = self->priv->_browse_pane;
	g_object_bind_property_with_closures ((GObject*) _tmp69_, "mode", (GObject*) _tmp70_, "mode", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp71_ = self->priv->_browse_pane;
	_tmp72_ = font_manager_browse_pane_get_stack (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = self->priv->header_widgets;
	_tmp75_ = font_manager_header_bar_widgets_get_browse_controls (_tmp74_);
	_tmp76_ = _tmp75_;
	g_object_bind_property_with_closures ((GObject*) _tmp73_, "visible-child-name", (GObject*) _tmp76_, "mode", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((___lambda192__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda192__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda193__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda193__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp77_ = self->priv->main_pane;
	_tmp78_ = self->priv->google_fonts;
	g_object_bind_property_with_closures ((GObject*) _tmp77_, "content-position", (GObject*) _tmp78_, "content-position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp79_ = self->priv->main_pane;
	_tmp80_ = self->priv->google_fonts;
	g_object_bind_property_with_closures ((GObject*) _tmp79_, "sidebar-position", (GObject*) _tmp80_, "sidebar-position", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	font_manager_main_window_bind_settings (self);
	font_manager_main_window_connect_signals (self);
	font_manager_application_window_restore_state ((FontManagerApplicationWindow*) self);
	font_manager_main_window_update_layout_orientation (self);
	g_signal_connect_data ((GtkWidget*) self, "map", (GCallback) ___lambda197__gtk_widget_map, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, G_CONNECT_AFTER);
	_tmp81_ = self->priv->_browse_pane;
	g_signal_connect_data ((GtkWidget*) _tmp81_, "realize", (GCallback) ___lambda199__gtk_widget_realize, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, G_CONNECT_AFTER);
	_tmp82_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp82_;
	_tmp83_ = _g_object_ref0 ((GtkEventController*) drop_target);
	gtk_widget_add_controller ((GtkWidget*) overlay, _tmp83_);
	g_signal_connect_object (drop_target, "drop", (GCallback) _font_manager_main_window_on_drag_data_received_gtk_drop_target_drop, self, 0);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (blank);
	_g_free0 (symbolic_icon);
	_g_object_unref0 (waterfall_settings);
	_g_object_unref0 (header);
	_g_object_unref0 (overlay);
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return self;
}

FontManagerMainWindow*
font_manager_main_window_new (GSettings* settings)
{
	return font_manager_main_window_construct (FONT_MANAGER_TYPE_MAIN_WINDOW, settings);
}

void
font_manager_main_window_focus_search (FontManagerMainWindow* self,
                                       GtkWidget* widget,
                                       const gchar* action,
                                       GVariant* parameter)
{
	FontManagerMode _tmp0_;
	FontManagerMode _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_main_window_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == FONT_MANAGER_MODE_MANAGE) {
		FontManagerMainPane* _tmp2_;
		_tmp2_ = self->priv->main_pane;
		font_manager_main_pane_focus_search_entry (_tmp2_);
	} else {
		FontManagerMode _tmp3_;
		FontManagerMode _tmp4_;
		_tmp3_ = font_manager_main_window_get_mode (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == FONT_MANAGER_MODE_BROWSE) {
			FontManagerBrowsePane* _tmp5_;
			_tmp5_ = self->priv->_browse_pane;
			font_manager_browse_pane_toggle_search (_tmp5_);
		}
	}
	return;
}

void
font_manager_main_window_search (FontManagerMainWindow* self,
                                 const gchar* needle)
{
	FontManagerMainPane* _tmp0_;
	FontManagerBrowsePane* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (needle != NULL);
	font_manager_main_window_focus_search (self, (GtkWidget*) self, NULL, NULL);
	_tmp0_ = self->priv->main_pane;
	font_manager_main_pane_search (_tmp0_, needle);
	_tmp1_ = self->priv->_browse_pane;
	font_manager_browse_pane_search (_tmp1_, needle);
	return;
}

gboolean
font_manager_main_window_progress_update (FontManagerMainWindow* self,
                                          FontManagerProgressData* data)
{
	GtkProgressBar* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = self->priv->_progress;
	g_object_get (data, "progress", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	gtk_progress_bar_set_fraction (_tmp0_, _tmp2_);
	result = G_SOURCE_REMOVE;
	return result;
}

void
font_manager_main_window_select_first_category (FontManagerMainWindow* self)
{
	FontManagerMainPane* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_pane;
	font_manager_main_pane_select_first_category (_tmp0_);
	return;
}

void
font_manager_main_window_select_first_font (FontManagerMainWindow* self)
{
	FontManagerMainPane* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_pane;
	font_manager_main_pane_select_first_font (_tmp0_);
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda194_ (FontManagerMainWindow* self,
              const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (string_contains (key, "wide-layout")) {
		font_manager_main_window_update_layout_orientation (self);
	}
}

static void
___lambda194__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	__lambda194_ ((FontManagerMainWindow*) self, key);
}

static void
font_manager_main_window_bind_settings (FontManagerMainWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	FontManagerHeaderBarWidgets* _tmp13_;
	FontManagerBrowseControls* _tmp14_;
	FontManagerBrowseControls* _tmp15_;
	g_return_if_fail (self != NULL);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) ___lambda194__g_settings_changed, self, G_CONNECT_AFTER);
	_g_object_unref0 (_tmp6_);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	g_settings_bind (_tmp9_, "mode", (GObject*) self, "mode", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp9_);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->header_widgets;
	_tmp14_ = font_manager_header_bar_widgets_get_browse_controls (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_bind (_tmp12_, "browse-mode", (GObject*) _tmp15_, "mode", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp12_);
	return;
}

static void
_font_manager_main_window_on_mode_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	font_manager_main_window_on_mode_changed ((FontManagerMainWindow*) self, pspec);
}

static void
_font_manager_main_window_on_stack_page_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	font_manager_main_window_on_stack_page_changed ((FontManagerMainWindow*) self, pspec);
}

static void
__lambda196_ (FontManagerMainWindow* self)
{
	font_manager_main_window_update_layout_orientation (self);
}

static void
___lambda196__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda196_ ((FontManagerMainWindow*) self);
}

static void
font_manager_main_window_connect_signals (FontManagerMainWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GObject*) self, "notify::mode", (GCallback) _font_manager_main_window_on_mode_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-preferences", (GCallback) _font_manager_main_window_on_stack_page_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::maximized", (GCallback) ___lambda196__g_object_notify, self, 0);
	return;
}

static FontManagerStringSet*
font_manager_main_window_get_file_selections (FontManagerMainWindow* self,
                                              GObject* object,
                                              GAsyncResult* _result_)
{
	FontManagerStringSet* selections = NULL;
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	GError* _inner_error0_ = NULL;
	FontManagerStringSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_result_ != NULL, NULL);
	_tmp0_ = font_manager_string_set_new ();
	selections = _tmp0_;
	_tmp1_ = selections;
	g_return_val_if_fail (object != NULL, _tmp1_);
	{
		GtkFileDialog* dialog = NULL;
		GtkFileDialog* _tmp2_;
		GListModel* files = NULL;
		GtkFileDialog* _tmp3_;
		GListModel* _tmp4_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, gtk_file_dialog_get_type (), GtkFileDialog));
		dialog = _tmp2_;
		_tmp3_ = dialog;
		_tmp4_ = gtk_file_dialog_open_multiple_finish (_tmp3_, _result_, &_inner_error0_);
		files = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			goto __catch0_g_error;
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GListModel* _tmp7_;
					GFile* file = NULL;
					GListModel* _tmp8_;
					GObject* _tmp9_;
					FontManagerStringSet* _tmp10_;
					GFile* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					if (!_tmp5_) {
						guint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = files;
					if (!(i < g_list_model_get_n_items (_tmp7_))) {
						break;
					}
					_tmp8_ = files;
					_tmp9_ = g_list_model_get_item (_tmp8_, i);
					file = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_file_get_type (), GFile);
					_tmp10_ = selections;
					_tmp11_ = file;
					_tmp12_ = g_file_get_path (_tmp11_);
					_tmp13_ = _tmp12_;
					font_manager_string_set_add (_tmp10_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_object_unref0 (file);
				}
			}
		}
		_g_object_unref0 (files);
		_g_object_unref0 (dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		if (_tmp14_->code == GTK_DIALOG_ERROR_FAILED) {
			GError* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("MainWindow.vala:302: FileDialog : %s", _tmp16_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (selections);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = selections;
	return result;
}

static gboolean
__lambda201_ (FontManagerMainWindow* self)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	gboolean result;
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	font_manager_application_reload (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda201__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda201_ ((FontManagerMainWindow*) self);
	return result;
}

static void
__lambda200_ (FontManagerMainWindow* self,
              GObject* object,
              GTask* task)
{
	FontManagerHeaderBarWidgets* _tmp0_;
	g_return_if_fail (task != NULL);
	_tmp0_ = self->priv->header_widgets;
	font_manager_header_bar_widgets_set_installing_files (_tmp0_, FALSE);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, ___lambda201__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda200__gasync_ready_callback (GObject* source_object,
                                     GTask* task,
                                     gpointer self)
{
	__lambda200_ ((FontManagerMainWindow*) self, source_object, task);
}

void
font_manager_main_window_install_selections (FontManagerMainWindow* self,
                                             FontManagerStringSet* selections)
{
	FontManagerHeaderBarWidgets* _tmp0_;
	FontManagerLibraryInstaller* installer = NULL;
	FontManagerLibraryInstaller* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selections != NULL);
	_tmp0_ = self->priv->header_widgets;
	font_manager_header_bar_widgets_set_installing_files (_tmp0_, TRUE);
	_tmp1_ = font_manager_library_installer_new ();
	installer = _tmp1_;
	font_manager_library_installer_process (installer, selections, ___lambda200__gasync_ready_callback, self);
	_g_object_unref0 (installer);
	return;
}

static void
font_manager_main_window_install_selected_files (FontManagerMainWindow* self,
                                                 GObject* object,
                                                 GAsyncResult* _result_)
{
	FontManagerStringSet* selections = NULL;
	FontManagerStringSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = font_manager_main_window_get_file_selections (self, object, _result_);
	selections = _tmp0_;
	font_manager_main_window_install_selections (self, selections);
	_g_object_unref0 (selections);
	return;
}

static void
font_manager_main_window_reload (FontManagerMainWindow* self,
                                 GtkWidget* widget,
                                 const gchar* action,
                                 GVariant* parameter)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	font_manager_application_reload (_tmp1_);
	_g_object_unref0 (_tmp1_);
	return;
}

static void
_font_manager_main_window_install_selected_files_gasync_ready_callback (GObject* source_object,
                                                                        GAsyncResult* res,
                                                                        gpointer self)
{
	font_manager_main_window_install_selected_files ((FontManagerMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_main_window_install (FontManagerMainWindow* self,
                                  GtkWidget* widget,
                                  const gchar* action,
                                  GVariant* parameter)
{
	GtkFileDialog* dialog = NULL;
	GtkFileDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_file_selector_get_selections ();
	dialog = _tmp0_;
	gtk_file_dialog_open_multiple (dialog, (GtkWindow*) self, NULL, _font_manager_main_window_install_selected_files_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (dialog);
	return;
}

static void
__lambda209_ (FontManagerMainWindow* self)
{
	FontManagerHeaderBarWidgets* _tmp0_;
	_tmp0_ = self->priv->header_widgets;
	font_manager_header_bar_widgets_set_removing_files (_tmp0_, TRUE);
}

static void
___lambda209__font_manager_remove_dialog_start_removal (FontManagerRemoveDialog* _sender,
                                                        gpointer self)
{
	__lambda209_ ((FontManagerMainWindow*) self);
}

static void
__lambda210_ (FontManagerMainWindow* self)
{
	FontManagerHeaderBarWidgets* _tmp0_;
	_tmp0_ = self->priv->header_widgets;
	font_manager_header_bar_widgets_set_removing_files (_tmp0_, FALSE);
}

static void
___lambda210__font_manager_remove_dialog_end_removal (FontManagerRemoveDialog* _sender,
                                                      gpointer self)
{
	__lambda210_ ((FontManagerMainWindow*) self);
}

static void
font_manager_main_window_remove (FontManagerMainWindow* self,
                                 GtkWidget* widget,
                                 const gchar* action,
                                 GVariant* parameter)
{
	FontManagerRemoveDialog* dialog = NULL;
	FontManagerRemoveDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_remove_dialog_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	g_signal_connect_object (dialog, "start-removal", (GCallback) ___lambda209__font_manager_remove_dialog_start_removal, self, 0);
	g_signal_connect_object (dialog, "end-removal", (GCallback) ___lambda210__font_manager_remove_dialog_end_removal, self, 0);
	gtk_window_present ((GtkWindow*) dialog);
	_g_object_unref0 (dialog);
	return;
}

static void
font_manager_main_window_import (FontManagerMainWindow* self,
                                 GtkWidget* widget,
                                 const gchar* action,
                                 GVariant* parameter)
{
	FontManagerUserDataImportDialog* dialog = NULL;
	FontManagerUserDataImportDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_user_data_import_dialog_new ((GtkWindow*) self);
	dialog = _tmp0_;
	font_manager_user_data_import_dialog_present (dialog);
	_g_object_unref0 (dialog);
	return;
}

static void
font_manager_main_window_export (FontManagerMainWindow* self,
                                 GtkWidget* widget,
                                 const gchar* action,
                                 GVariant* parameter)
{
	FontManagerUserDataExportDialog* dialog = NULL;
	FontManagerUserDataExportDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = font_manager_user_data_export_dialog_new ((GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_window_present ((GtkWindow*) dialog);
	_g_object_unref0 (dialog);
	return;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_____lambda195_ (FontManagerMainWindow* self)
{
	FontManagerGoogleFontsCatalog* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->google_fonts;
	font_manager_google_fonts_catalog_select_first_font (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
______lambda195__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda195_ ((FontManagerMainWindow*) self);
	return result;
}

static void
font_manager_main_window_on_mode_changed (FontManagerMainWindow* self,
                                          GParamSpec* pspec)
{
	gchar* mode_label = NULL;
	FontManagerMode _tmp0_;
	FontManagerMode _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FontManagerHeaderBarWidgets* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FontManagerHeaderBarWidgets* _tmp13_;
	FontManagerMode _tmp14_;
	FontManagerMode _tmp15_;
	gchar* _tmp16_ = NULL;
	FontManagerMode _tmp17_;
	FontManagerMode _tmp18_;
	gchar* visible_child = NULL;
	gchar* _tmp23_;
	GtkStack* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	FontManagerMode _tmp27_;
	FontManagerMode _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = font_manager_main_window_get_mode (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = font_manager_mode_to_translatable_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	mode_label = _tmp5_;
	_tmp6_ = self->priv->header_widgets;
	_tmp7_ = font_manager_header_bar_widgets_get_main_menu_label (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = mode_label;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("<b>", _tmp10_, "</b>", NULL);
	_tmp12_ = _tmp11_;
	gtk_label_set_markup (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->header_widgets;
	_tmp14_ = font_manager_main_window_get_mode (self);
	_tmp15_ = _tmp14_;
	font_manager_header_bar_widgets_reveal_controls (_tmp13_, _tmp15_);
	_tmp17_ = font_manager_main_window_get_mode (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == FONT_MANAGER_MODE_COMPARE) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("Default");
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp19_;
	} else {
		FontManagerMode _tmp20_;
		FontManagerMode _tmp21_;
		gchar* _tmp22_;
		_tmp20_ = font_manager_main_window_get_mode (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = font_manager_mode_to_string (_tmp21_);
		_g_free0 (_tmp16_);
		_tmp16_ = _tmp22_;
	}
	_tmp23_ = g_strdup (_tmp16_);
	visible_child = _tmp23_;
	_tmp24_ = self->priv->main_stack;
	_tmp25_ = visible_child;
	gtk_stack_set_visible_child_name (_tmp24_, _tmp25_);
	_tmp27_ = font_manager_main_window_get_mode (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == FONT_MANAGER_MODE_MANAGE) {
		_tmp26_ = TRUE;
	} else {
		FontManagerMode _tmp29_;
		FontManagerMode _tmp30_;
		_tmp29_ = font_manager_main_window_get_mode (self);
		_tmp30_ = _tmp29_;
		_tmp26_ = _tmp30_ == FONT_MANAGER_MODE_COMPARE;
	}
	if (_tmp26_) {
		FontManagerMainPane* _tmp31_;
		_tmp31_ = self->priv->main_pane;
		font_manager_main_pane_select_first_font (_tmp31_);
	} else {
		FontManagerMode _tmp32_;
		FontManagerMode _tmp33_;
		_tmp32_ = font_manager_main_window_get_mode (self);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == FONT_MANAGER_MODE_BROWSE) {
			FontManagerBrowsePane* _tmp34_;
			_tmp34_ = self->priv->_browse_pane;
			font_manager_browse_pane_select_first_font (_tmp34_);
		} else {
			FontManagerMode _tmp35_;
			FontManagerMode _tmp36_;
			_tmp35_ = font_manager_main_window_get_mode (self);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == FONT_MANAGER_MODE_GOOGLE_FONTS) {
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ______lambda195__gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
	_g_free0 (visible_child);
	_g_free0 (_tmp16_);
	_g_free0 (mode_label);
	return;
}

static void
font_manager_main_window_on_stack_page_changed (FontManagerMainWindow* self,
                                                GParamSpec* pspec)
{
	gboolean _tmp0_;
	FontManagerHeaderBarWidgets* _tmp10_;
	GtkMenuButton* _tmp11_;
	GtkMenuButton* _tmp12_;
	gboolean _tmp13_;
	FontManagerHeaderBarWidgets* _tmp14_;
	GtkRevealer* _tmp15_;
	GtkRevealer* _tmp16_;
	gboolean _tmp17_;
	FontManagerHeaderBarWidgets* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_show_preferences;
	if (_tmp0_) {
		GtkStack* _tmp1_;
		_tmp1_ = self->priv->main_stack;
		gtk_stack_set_visible_child_name (_tmp1_, "Preferences");
	} else {
		FontManagerMode _tmp2_;
		FontManagerMode _tmp3_;
		_tmp2_ = font_manager_main_window_get_mode (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == FONT_MANAGER_MODE_COMPARE) {
			GtkStack* _tmp4_;
			_tmp4_ = self->priv->main_stack;
			gtk_stack_set_visible_child_name (_tmp4_, "Default");
		} else {
			GtkStack* _tmp5_;
			FontManagerMode _tmp6_;
			FontManagerMode _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = self->priv->main_stack;
			_tmp6_ = font_manager_main_window_get_mode (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = font_manager_mode_to_string (_tmp7_);
			_tmp9_ = _tmp8_;
			gtk_stack_set_visible_child_name (_tmp5_, _tmp9_);
			_g_free0 (_tmp9_);
		}
	}
	_tmp10_ = self->priv->header_widgets;
	_tmp11_ = font_manager_header_bar_widgets_get_main_menu (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_show_preferences;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, !_tmp13_);
	_tmp14_ = self->priv->header_widgets;
	_tmp15_ = font_manager_header_bar_widgets_get_revealer (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_show_preferences;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, !_tmp17_);
	_tmp18_ = self->priv->header_widgets;
	_tmp19_ = font_manager_header_bar_widgets_get_back_button (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->_show_preferences;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, _tmp21_);
	return;
}

static void
font_manager_main_window_update_layout_orientation (FontManagerMainWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	GtkOrientation orientation = 0;
	gboolean wide_layout = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	gboolean only_on_maximize = FALSE;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	FontManagerMainPane* _tmp18_;
	FontManagerGoogleFontsCatalog* _tmp19_;
	g_return_if_fail (self != NULL);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	orientation = GTK_ORIENTATION_VERTICAL;
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_settings_get_boolean (_tmp6_, "wide-layout");
	_g_object_unref0 (_tmp6_);
	wide_layout = _tmp7_;
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = g_settings_get_boolean (_tmp10_, "wide-layout-on-maximize");
	_g_object_unref0 (_tmp10_);
	only_on_maximize = _tmp11_;
	if (wide_layout) {
		_tmp14_ = only_on_maximize;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gboolean _tmp15_;
		gboolean _tmp16_;
		g_object_get ((GtkWindow*) self, "maximized", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp13_ = _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp17_ = FALSE;
		if (wide_layout) {
			_tmp17_ = !only_on_maximize;
		} else {
			_tmp17_ = FALSE;
		}
		_tmp12_ = _tmp17_;
	}
	if (_tmp12_) {
		orientation = GTK_ORIENTATION_HORIZONTAL;
	}
	_tmp18_ = self->priv->main_pane;
	font_manager_dual_paned_set_orientation ((FontManagerDualPaned*) _tmp18_, orientation);
	_tmp19_ = self->priv->google_fonts;
	font_manager_dual_paned_set_orientation ((FontManagerDualPaned*) _tmp19_, orientation);
	return;
}

static gboolean
___lambda202_ (FontManagerMainWindow* self)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	gboolean result;
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	font_manager_application_reload (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda202__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda202_ ((FontManagerMainWindow*) self);
	return result;
}

static gboolean
font_manager_main_window_on_drag_data_received (FontManagerMainWindow* self,
                                                GValue* value,
                                                gdouble x,
                                                gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_HOLDS (value, gdk_file_list_get_type ())) {
		FontManagerStringSet* selections = NULL;
		FontManagerStringSet* _tmp0_;
		GSList* filelist = NULL;
		void* _tmp1_;
		FontManagerStringSet* _tmp13_;
		guint _tmp14_;
		guint _tmp15_;
		_tmp0_ = font_manager_string_set_new ();
		selections = _tmp0_;
		_tmp1_ = g_value_get_boxed (value);
		filelist = _tmp1_;
		{
			GSList* files = NULL;
			GSList* _tmp2_;
			_tmp2_ = filelist;
			files = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GSList* _tmp6_;
					GFile* file = NULL;
					GSList* _tmp7_;
					gconstpointer _tmp8_;
					FontManagerStringSet* _tmp9_;
					GFile* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					if (!_tmp3_) {
						GSList* _tmp4_;
						GSList* _tmp5_;
						_tmp4_ = files;
						_tmp5_ = _tmp4_->next;
						files = _tmp5_;
					}
					_tmp3_ = FALSE;
					_tmp6_ = files;
					if (!(_tmp6_ != NULL)) {
						break;
					}
					_tmp7_ = files;
					_tmp8_ = _tmp7_->data;
					file = (GFile*) _tmp8_;
					_tmp9_ = selections;
					_tmp10_ = file;
					_tmp11_ = g_file_get_path (_tmp10_);
					_tmp12_ = _tmp11_;
					font_manager_string_set_add (_tmp9_, _tmp12_);
					_g_free0 (_tmp12_);
				}
			}
		}
		_tmp13_ = selections;
		g_object_get (_tmp13_, "size", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > ((guint) 0)) {
			FontManagerStringSet* _tmp16_;
			_tmp16_ = selections;
			font_manager_main_window_install_selections (self, _tmp16_);
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda202__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (selections);
	}
	result = TRUE;
	return result;
}

gboolean
font_manager_main_window_get_show_preferences (FontManagerMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_preferences;
	return result;
}

void
font_manager_main_window_set_show_preferences (FontManagerMainWindow* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_main_window_get_show_preferences (self);
	if (old_value != value) {
		self->priv->_show_preferences = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY]);
	}
}

GtkProgressBar*
font_manager_main_window_get_progress (FontManagerMainWindow* self)
{
	GtkProgressBar* result;
	GtkProgressBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_progress;
	result = _tmp0_;
	return result;
}

static void
font_manager_main_window_set_progress (FontManagerMainWindow* self,
                                       GtkProgressBar* value)
{
	GtkProgressBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_main_window_get_progress (self);
	if (old_value != value) {
		GtkProgressBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_progress);
		self->priv->_progress = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY]);
	}
}

FontManagerMode
font_manager_main_window_get_mode (FontManagerMainWindow* self)
{
	FontManagerMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
font_manager_main_window_set_mode (FontManagerMainWindow* self,
                                   FontManagerMode value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject*) self, "mode");
	g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY]);
}

FontManagerCategoryListModel*
font_manager_main_window_get_category_model (FontManagerMainWindow* self)
{
	FontManagerCategoryListModel* result;
	FontManagerMainPane* _tmp0_;
	FontManagerCategoryListModel* _tmp1_;
	FontManagerCategoryListModel* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->main_pane;
	_tmp1_ = font_manager_main_pane_get_category_model (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

FontManagerCollectionListModel*
font_manager_main_window_get_collection_model (FontManagerMainWindow* self)
{
	FontManagerCollectionListModel* result;
	FontManagerMainPane* _tmp0_;
	FontManagerCollectionListModel* _tmp1_;
	FontManagerCollectionListModel* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->main_pane;
	_tmp1_ = font_manager_main_pane_get_collection_model (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

JsonArray*
font_manager_main_window_get_available_fonts (FontManagerMainWindow* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_fonts;
	result = _tmp0_;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

void
font_manager_main_window_set_available_fonts (FontManagerMainWindow* self,
                                              JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_main_window_get_available_fonts (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_available_fonts);
		self->priv->_available_fonts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY]);
	}
}

FontManagerReject*
font_manager_main_window_get_disabled_families (FontManagerMainWindow* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

void
font_manager_main_window_set_disabled_families (FontManagerMainWindow* self,
                                                FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_main_window_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY]);
	}
}

FontManagerBrowsePane*
font_manager_main_window_get_browse_pane (FontManagerMainWindow* self)
{
	FontManagerBrowsePane* result;
	FontManagerBrowsePane* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_browse_pane;
	result = _tmp0_;
	return result;
}

void
font_manager_main_window_set_browse_pane (FontManagerMainWindow* self,
                                          FontManagerBrowsePane* value)
{
	FontManagerBrowsePane* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_main_window_get_browse_pane (self);
	if (old_value != value) {
		FontManagerBrowsePane* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_browse_pane);
		self->priv->_browse_pane = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY]);
	}
}

static void
font_manager_main_window_class_init (FontManagerMainWindowClass * klass,
                                     gpointer klass_data)
{
	guint* mode_accels = NULL;
	guint* _tmp0_;
	gint mode_accels_length1;
	gint _mode_accels_size_;
	GdkModifierType mode_mask = 0U;
	GEnumClass* mode_class = NULL;
	GTypeClass* _tmp1_;
	font_manager_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY] = g_param_spec_boolean ("show-preferences", "show-preferences", "show-preferences", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY] = g_param_spec_object ("progress", "progress", "progress", gtk_progress_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FONT_MANAGER_TYPE_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_CATEGORY_MODEL_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_CATEGORY_MODEL_PROPERTY] = g_param_spec_object ("category-model", "category-model", "category-model", FONT_MANAGER_TYPE_CATEGORY_LIST_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_COLLECTION_MODEL_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_COLLECTION_MODEL_PROPERTY] = g_param_spec_object ("collection-model", "collection-model", "collection-model", FONT_MANAGER_TYPE_COLLECTION_LIST_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY] = g_param_spec_boxed ("available-fonts", "available-fonts", "available-fonts", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY, font_manager_main_window_properties[FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY] = g_param_spec_object ("browse-pane", "browse-pane", "browse-pane", FONT_MANAGER_TYPE_BROWSE_PANE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "install", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_install);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "remove", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_remove);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "import", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_import);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "export", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_export);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "reload", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_reload);
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "focus-search", NULL, (GtkWidgetActionActivateFunc) font_manager_main_window_focus_search);
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "mode", "mode");
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "show-preferences", "show-preferences");
	_tmp0_ = g_new0 (guint, 4);
	_tmp0_[0] = GDK_KEY_1;
	_tmp0_[1] = GDK_KEY_2;
	_tmp0_[2] = GDK_KEY_3;
	_tmp0_[3] = GDK_KEY_4;
	mode_accels = _tmp0_;
	mode_accels_length1 = 4;
	_mode_accels_size_ = mode_accels_length1;
	mode_mask = GDK_CONTROL_MASK;
	_tmp1_ = g_type_class_ref (FONT_MANAGER_TYPE_MODE);
	mode_class = (GEnumClass*) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar* nick = NULL;
				GEnumClass* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				guint* _tmp7_;
				gint _tmp7__length1;
				guint _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < ((gint) FONT_MANAGER_MODE_N_MODES))) {
					break;
				}
				_tmp4_ = mode_class;
				_tmp5_ = (*g_enum_get_value (_tmp4_, i)).value_nick;
				_tmp6_ = g_strdup (_tmp5_);
				nick = _tmp6_;
				_tmp7_ = mode_accels;
				_tmp7__length1 = mode_accels_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = nick;
				gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), _tmp8_, mode_mask, "mode", "s", _tmp9_, NULL);
				_g_free0 (nick);
			}
		}
	}
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_F, mode_mask, "focus-search", NULL, NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_R, mode_mask, "reload", NULL, NULL);
	gtk_widget_class_add_binding_action (GTK_WIDGET_CLASS (klass), GDK_KEY_comma, mode_mask, "show-preferences", NULL, NULL);
	_g_type_class_unref0 (mode_class);
	mode_accels = (g_free (mode_accels), NULL);
}

static void
font_manager_main_window_instance_init (FontManagerMainWindow * self,
                                        gpointer klass)
{
	self->priv = font_manager_main_window_get_instance_private (self);
	self->priv->_show_preferences = FALSE;
	self->priv->_available_fonts = NULL;
	self->priv->_disabled_families = NULL;
	self->priv->_browse_pane = NULL;
	self->priv->_mode = FONT_MANAGER_MODE_MANAGE;
}

static void
font_manager_main_window_finalize (GObject * obj)
{
	FontManagerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindow);
	_g_object_unref0 (self->priv->_progress);
	_json_array_unref0 (self->priv->_available_fonts);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->main_pane);
	_g_object_unref0 (self->priv->_browse_pane);
	_g_object_unref0 (self->priv->prefs_pane);
	_g_object_unref0 (self->priv->header_widgets);
	_g_object_unref0 (self->priv->google_fonts);
	G_OBJECT_CLASS (font_manager_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerMainWindow), 0, (GInstanceInitFunc) font_manager_main_window_instance_init, NULL };
	GType font_manager_main_window_type_id;
	font_manager_main_window_type_id = g_type_register_static (font_manager_application_window_get_type (), "FontManagerMainWindow", &g_define_type_info, 0);
	FontManagerMainWindow_private_offset = g_type_add_instance_private (font_manager_main_window_type_id, sizeof (FontManagerMainWindowPrivate));
	return font_manager_main_window_type_id;
}

GType
font_manager_main_window_get_type (void)
{
	static volatile gsize font_manager_main_window_type_id__once = 0;
	if (g_once_init_enter (&font_manager_main_window_type_id__once)) {
		GType font_manager_main_window_type_id;
		font_manager_main_window_type_id = font_manager_main_window_get_type_once ();
		g_once_init_leave (&font_manager_main_window_type_id__once, font_manager_main_window_type_id);
	}
	return font_manager_main_window_type_id__once;
}

static void
_vala_font_manager_main_window_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindow);
	switch (property_id) {
		case FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY:
		g_value_set_boolean (value, font_manager_main_window_get_show_preferences (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY:
		g_value_set_object (value, font_manager_main_window_get_progress (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY:
		g_value_set_enum (value, font_manager_main_window_get_mode (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_CATEGORY_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_main_window_get_category_model (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_COLLECTION_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_main_window_get_collection_model (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY:
		g_value_set_boxed (value, font_manager_main_window_get_available_fonts (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_main_window_get_disabled_families (self));
		break;
		case FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY:
		g_value_set_object (value, font_manager_main_window_get_browse_pane (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_main_window_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_MAIN_WINDOW, FontManagerMainWindow);
	switch (property_id) {
		case FONT_MANAGER_MAIN_WINDOW_SHOW_PREFERENCES_PROPERTY:
		font_manager_main_window_set_show_preferences (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_MAIN_WINDOW_PROGRESS_PROPERTY:
		font_manager_main_window_set_progress (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_MAIN_WINDOW_MODE_PROPERTY:
		font_manager_main_window_set_mode (self, g_value_get_enum (value));
		break;
		case FONT_MANAGER_MAIN_WINDOW_AVAILABLE_FONTS_PROPERTY:
		font_manager_main_window_set_available_fonts (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_MAIN_WINDOW_DISABLED_FAMILIES_PROPERTY:
		font_manager_main_window_set_disabled_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_MAIN_WINDOW_BROWSE_PANE_PROPERTY:
		font_manager_main_window_set_browse_pane (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

