/* export-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from export-view.vala, do not modify */

/* This file is part of Elastic. License: GPL-3.0+.*/

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <tmpl-glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ELASTIC_TYPE_EXPORT_VIEW (elastic_export_view_get_type ())
#define ELASTIC_EXPORT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView))
#define ELASTIC_EXPORT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_EXPORT_VIEW, ElasticExportViewClass))
#define ELASTIC_IS_EXPORT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_EXPORT_VIEW))
#define ELASTIC_IS_EXPORT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_EXPORT_VIEW))
#define ELASTIC_EXPORT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_EXPORT_VIEW, ElasticExportViewClass))

typedef struct _ElasticExportView ElasticExportView;
typedef struct _ElasticExportViewClass ElasticExportViewClass;
typedef struct _ElasticExportViewPrivate ElasticExportViewPrivate;

#define ELASTIC_TYPE_SPRING_PARAMS (elastic_spring_params_get_type ())
#define ELASTIC_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParams))
#define ELASTIC_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))
#define ELASTIC_IS_SPRING_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_IS_SPRING_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_SPRING_PARAMS))
#define ELASTIC_SPRING_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_SPRING_PARAMS, ElasticSpringParamsClass))

typedef struct _ElasticSpringParams ElasticSpringParams;
typedef struct _ElasticSpringParamsClass ElasticSpringParamsClass;
enum  {
	ELASTIC_EXPORT_VIEW_0_PROPERTY,
	ELASTIC_EXPORT_VIEW_SPRING_PROPERTY,
	ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY,
	ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY,
	ELASTIC_EXPORT_VIEW_NUM_PROPERTIES
};
static GParamSpec* elastic_export_view_properties[ELASTIC_EXPORT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _tmpl_scope_unref0(var) ((var == NULL) ? NULL : (var = (tmpl_scope_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ELASTIC_TYPE_WINDOW (elastic_window_get_type ())
#define ELASTIC_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ELASTIC_TYPE_WINDOW, ElasticWindow))
#define ELASTIC_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ELASTIC_TYPE_WINDOW, ElasticWindowClass))
#define ELASTIC_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ELASTIC_TYPE_WINDOW))
#define ELASTIC_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ELASTIC_TYPE_WINDOW))
#define ELASTIC_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ELASTIC_TYPE_WINDOW, ElasticWindowClass))

typedef struct _ElasticWindow ElasticWindow;
typedef struct _ElasticWindowClass ElasticWindowClass;

struct _ElasticExportView {
	AdwBin parent_instance;
	ElasticExportViewPrivate * priv;
};

struct _ElasticExportViewClass {
	AdwBinClass parent_class;
};

struct _ElasticExportViewPrivate {
	ElasticSpringParams* _spring;
	gboolean _use_damping;
	gboolean _compact;
	AdwInlineViewSwitcher* switcher;
	AdwViewStack* stack;
	GtkSourceBuffer* c_buffer;
	GtkSourceBuffer* js_buffer;
	GtkSourceBuffer* python_buffer;
	GtkSourceBuffer* rust_buffer;
	GtkSourceBuffer* vala_buffer;
	GSettings* settings;
};

static gint ElasticExportView_private_offset;
static gpointer elastic_export_view_parent_class = NULL;

VALA_EXTERN GType elastic_export_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticExportView, g_object_unref)
VALA_EXTERN GType elastic_spring_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticSpringParams, g_object_unref)
static void elastic_export_view_update_style_scheme (ElasticExportView* self);
static inline gchar* elastic_export_view_format_double (ElasticExportView* self,
                                          gdouble value,
                                          gint digits);
static gchar* elastic_export_view_create_code (ElasticExportView* self,
                                        const gchar* language);
VALA_EXTERN ElasticSpringParams* elastic_export_view_get_spring (ElasticExportView* self);
VALA_EXTERN gdouble elastic_spring_params_get_damping (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_damping_ratio (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_mass (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_stiffness (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_epsilon (ElasticSpringParams* self);
VALA_EXTERN gdouble elastic_spring_params_get_velocity (ElasticSpringParams* self);
VALA_EXTERN gboolean elastic_export_view_get_use_damping (ElasticExportView* self);
VALA_EXTERN gboolean elastic_spring_params_is_epsilon_modified (ElasticSpringParams* self);
VALA_EXTERN gboolean elastic_spring_params_is_velocity_modified (ElasticSpringParams* self);
static void elastic_export_view_update_code (ElasticExportView* self);
static void elastic_export_view_copy_snippet (ElasticExportView* self);
VALA_EXTERN GType elastic_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ElasticWindow, g_object_unref)
VALA_EXTERN void elastic_window_show_copy_toast (ElasticWindow* self);
VALA_EXTERN ElasticExportView* elastic_export_view_new (void);
VALA_EXTERN ElasticExportView* elastic_export_view_construct (GType object_type);
VALA_EXTERN void elastic_export_view_set_spring (ElasticExportView* self,
                                     ElasticSpringParams* value);
static void _elastic_export_view_update_code_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                                     gpointer self);
VALA_EXTERN void elastic_export_view_set_use_damping (ElasticExportView* self,
                                          gboolean value);
VALA_EXTERN gboolean elastic_export_view_get_compact (ElasticExportView* self);
VALA_EXTERN void elastic_export_view_set_compact (ElasticExportView* self,
                                      gboolean value);
static GObject * elastic_export_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _elastic_export_view_update_style_scheme_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void _elastic_export_view_update_code_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _elastic_export_view___lambda13_ (GtkWidget* widget);
static void __elastic_export_view___lambda13__gtk_widget_action_activate_func (GtkWidget* widget,
                                                                        const gchar* action_name,
                                                                        GVariant* parameter);
static void elastic_export_view_finalize (GObject * obj);
static GType elastic_export_view_get_type_once (void);
static void _vala_elastic_export_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_elastic_export_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
elastic_export_view_get_instance_private (ElasticExportView* self)
{
	return G_STRUCT_MEMBER_P (self, ElasticExportView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
elastic_export_view_update_style_scheme (ElasticExportView* self)
{
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp0_;
	AdwStyleManager* _tmp1_;
	const gchar* _tmp2_ = NULL;
	AdwStyleManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gchar* name = NULL;
	gchar* _tmp6_;
	GtkSourceStyleSchemeManager* scheme_manager = NULL;
	GtkSourceStyleSchemeManager* _tmp7_;
	GtkSourceStyleSchemeManager* _tmp8_;
	GtkSourceBuffer* _tmp9_;
	GtkSourceStyleScheme* _tmp10_;
	GtkSourceBuffer* _tmp11_;
	GtkSourceStyleScheme* _tmp12_;
	GtkSourceBuffer* _tmp13_;
	GtkSourceStyleScheme* _tmp14_;
	GtkSourceBuffer* _tmp15_;
	GtkSourceStyleScheme* _tmp16_;
	GtkSourceBuffer* _tmp17_;
	GtkSourceStyleScheme* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = adw_style_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_manager = _tmp1_;
	_tmp3_ = style_manager;
	_tmp4_ = adw_style_manager_get_dark (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "Adwaita-dark";
	} else {
		_tmp2_ = "Adwaita";
	}
	_tmp6_ = g_strdup (_tmp2_);
	name = _tmp6_;
	_tmp7_ = gtk_source_style_scheme_manager_get_default ();
	_tmp8_ = _g_object_ref0 (_tmp7_);
	scheme_manager = _tmp8_;
	_tmp9_ = self->priv->c_buffer;
	_tmp10_ = gtk_source_style_scheme_manager_get_scheme (scheme_manager, name);
	gtk_source_buffer_set_style_scheme (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->js_buffer;
	_tmp12_ = gtk_source_style_scheme_manager_get_scheme (scheme_manager, name);
	gtk_source_buffer_set_style_scheme (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->python_buffer;
	_tmp14_ = gtk_source_style_scheme_manager_get_scheme (scheme_manager, name);
	gtk_source_buffer_set_style_scheme (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->rust_buffer;
	_tmp16_ = gtk_source_style_scheme_manager_get_scheme (scheme_manager, name);
	gtk_source_buffer_set_style_scheme (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->vala_buffer;
	_tmp18_ = gtk_source_style_scheme_manager_get_scheme (scheme_manager, name);
	gtk_source_buffer_set_style_scheme (_tmp17_, _tmp18_);
	_g_object_unref0 (scheme_manager);
	_g_free0 (name);
	_g_object_unref0 (style_manager);
}

static inline gchar*
elastic_export_view_format_double (ElasticExportView* self,
                                   gdouble value,
                                   gint digits)
{
	gchar* format = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* ret = NULL;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", digits);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("%.", _tmp1_, "lf", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	format = _tmp3_;
	setlocale (LC_NUMERIC, "C");
	_tmp4_ = g_strdup_printf (format, value);
	ret = _tmp4_;
	setlocale (LC_NUMERIC, "");
	result = ret;
	_g_free0 (format);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
elastic_export_view_create_code (ElasticExportView* self,
                                 const gchar* language)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (language != NULL, NULL);
	{
		gchar* template_path = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		TmplTemplate* template = NULL;
		TmplTemplate* _tmp2_;
		TmplTemplate* _tmp3_;
		const gchar* _tmp4_;
		TmplScope* scope = NULL;
		TmplScope* _tmp5_;
		TmplScope* _tmp6_;
		ElasticSpringParams* _tmp7_;
		ElasticSpringParams* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		TmplScope* _tmp13_;
		ElasticSpringParams* _tmp14_;
		ElasticSpringParams* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		TmplScope* _tmp20_;
		ElasticSpringParams* _tmp21_;
		ElasticSpringParams* _tmp22_;
		gdouble _tmp23_;
		gdouble _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		TmplScope* _tmp27_;
		ElasticSpringParams* _tmp28_;
		ElasticSpringParams* _tmp29_;
		gdouble _tmp30_;
		gdouble _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		TmplScope* _tmp34_;
		ElasticSpringParams* _tmp35_;
		ElasticSpringParams* _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		TmplScope* _tmp41_;
		ElasticSpringParams* _tmp42_;
		ElasticSpringParams* _tmp43_;
		gdouble _tmp44_;
		gdouble _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		TmplScope* _tmp48_;
		gboolean _tmp49_;
		TmplScope* _tmp50_;
		ElasticSpringParams* _tmp51_;
		ElasticSpringParams* _tmp52_;
		TmplScope* _tmp53_;
		ElasticSpringParams* _tmp54_;
		ElasticSpringParams* _tmp55_;
		gchar* _tmp56_ = NULL;
		TmplTemplate* _tmp57_;
		TmplScope* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp0_ = string_to_string (language);
		_tmp1_ = g_strconcat ("/app/drey/Elastic/templates/", _tmp0_, ".tmpl", NULL);
		template_path = _tmp1_;
		_tmp2_ = tmpl_template_new (NULL);
		template = _tmp2_;
		_tmp3_ = template;
		_tmp4_ = template_path;
		tmpl_template_parse_resource (_tmp3_, _tmp4_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (template);
			_g_free0 (template_path);
			goto __catch0_g_error;
		}
		_tmp5_ = tmpl_scope_new ();
		scope = _tmp5_;
		_tmp6_ = scope;
		_tmp7_ = elastic_export_view_get_spring (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = elastic_spring_params_get_damping (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = elastic_export_view_format_double (self, _tmp10_, 1);
		_tmp12_ = _tmp11_;
		tmpl_scope_set_string (_tmp6_, "damping", _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = scope;
		_tmp14_ = elastic_export_view_get_spring (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = elastic_spring_params_get_damping_ratio (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = elastic_export_view_format_double (self, _tmp17_, 2);
		_tmp19_ = _tmp18_;
		tmpl_scope_set_string (_tmp13_, "damping_ratio", _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = scope;
		_tmp21_ = elastic_export_view_get_spring (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = elastic_spring_params_get_mass (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = elastic_export_view_format_double (self, _tmp24_, 1);
		_tmp26_ = _tmp25_;
		tmpl_scope_set_string (_tmp20_, "mass", _tmp26_);
		_g_free0 (_tmp26_);
		_tmp27_ = scope;
		_tmp28_ = elastic_export_view_get_spring (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = elastic_spring_params_get_stiffness (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = elastic_export_view_format_double (self, _tmp31_, 1);
		_tmp33_ = _tmp32_;
		tmpl_scope_set_string (_tmp27_, "stiffness", _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = scope;
		_tmp35_ = elastic_export_view_get_spring (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = elastic_spring_params_get_epsilon (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = elastic_export_view_format_double (self, _tmp38_, 5);
		_tmp40_ = _tmp39_;
		tmpl_scope_set_string (_tmp34_, "epsilon", _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = scope;
		_tmp42_ = elastic_export_view_get_spring (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = elastic_spring_params_get_velocity (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = elastic_export_view_format_double (self, _tmp45_, 1);
		_tmp47_ = _tmp46_;
		tmpl_scope_set_string (_tmp41_, "velocity", _tmp47_);
		_g_free0 (_tmp47_);
		_tmp48_ = scope;
		_tmp49_ = self->priv->_use_damping;
		tmpl_scope_set_boolean (_tmp48_, "use_damping", _tmp49_);
		_tmp50_ = scope;
		_tmp51_ = elastic_export_view_get_spring (self);
		_tmp52_ = _tmp51_;
		tmpl_scope_set_boolean (_tmp50_, "has_epsilon", elastic_spring_params_is_epsilon_modified (_tmp52_));
		_tmp53_ = scope;
		_tmp54_ = elastic_export_view_get_spring (self);
		_tmp55_ = _tmp54_;
		tmpl_scope_set_boolean (_tmp53_, "has_velocity", elastic_spring_params_is_velocity_modified (_tmp55_));
		_tmp57_ = template;
		_tmp58_ = scope;
		_tmp59_ = tmpl_template_expand_string (_tmp57_, _tmp58_, &_inner_error0_);
		_tmp56_ = _tmp59_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_tmpl_scope_unref0 (scope);
			_g_object_unref0 (template);
			_g_free0 (template_path);
			goto __catch0_g_error;
		}
		_tmp60_ = string_chomp (_tmp56_);
		result = _tmp60_;
		_g_free0 (_tmp56_);
		_tmpl_scope_unref0 (scope);
		_g_object_unref0 (template);
		_g_free0 (template_path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp61_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e->message;
		g_error ("export-view.vala:135: Error parsing %s template: %s", language, _tmp61_);
		_g_error_free0 (e);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
elastic_export_view_update_code (ElasticExportView* self)
{
	GtkSourceBuffer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkSourceBuffer* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkSourceBuffer* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->c_buffer;
	_tmp1_ = elastic_export_view_create_code (self, "c");
	_tmp2_ = _tmp1_;
	g_object_set ((GtkTextBuffer*) _tmp0_, "text", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->js_buffer;
	_tmp4_ = elastic_export_view_create_code (self, "javascript");
	_tmp5_ = _tmp4_;
	g_object_set ((GtkTextBuffer*) _tmp3_, "text", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->python_buffer;
	_tmp7_ = elastic_export_view_create_code (self, "python");
	_tmp8_ = _tmp7_;
	g_object_set ((GtkTextBuffer*) _tmp6_, "text", _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->rust_buffer;
	_tmp10_ = elastic_export_view_create_code (self, "rust");
	_tmp11_ = _tmp10_;
	g_object_set ((GtkTextBuffer*) _tmp9_, "text", _tmp11_, NULL);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->vala_buffer;
	_tmp13_ = elastic_export_view_create_code (self, "vala");
	_tmp14_ = _tmp13_;
	g_object_set ((GtkTextBuffer*) _tmp12_, "text", _tmp14_, NULL);
	_g_free0 (_tmp14_);
}

static void
elastic_export_view_copy_snippet (ElasticExportView* self)
{
	GtkSourceBuffer* buffer = NULL;
	AdwViewStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GdkClipboard* clipboard = NULL;
	GdkClipboard* _tmp25_;
	GdkClipboard* _tmp26_;
	GtkSourceBuffer* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkRoot* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "cc") == 0) {
		GtkSourceBuffer* _tmp3_;
		GtkSourceBuffer* _tmp4_;
		_tmp3_ = self->priv->c_buffer;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (buffer);
		buffer = _tmp4_;
	} else {
		AdwViewStack* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = adw_view_stack_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		if (g_strcmp0 (_tmp7_, "javascript") == 0) {
			GtkSourceBuffer* _tmp8_;
			GtkSourceBuffer* _tmp9_;
			_tmp8_ = self->priv->js_buffer;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (buffer);
			buffer = _tmp9_;
		} else {
			AdwViewStack* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = self->priv->stack;
			_tmp11_ = adw_view_stack_get_visible_child_name (_tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, "python") == 0) {
				GtkSourceBuffer* _tmp13_;
				GtkSourceBuffer* _tmp14_;
				_tmp13_ = self->priv->python_buffer;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (buffer);
				buffer = _tmp14_;
			} else {
				AdwViewStack* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = self->priv->stack;
				_tmp16_ = adw_view_stack_get_visible_child_name (_tmp15_);
				_tmp17_ = _tmp16_;
				if (g_strcmp0 (_tmp17_, "rust") == 0) {
					GtkSourceBuffer* _tmp18_;
					GtkSourceBuffer* _tmp19_;
					_tmp18_ = self->priv->rust_buffer;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (buffer);
					buffer = _tmp19_;
				} else {
					AdwViewStack* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp20_ = self->priv->stack;
					_tmp21_ = adw_view_stack_get_visible_child_name (_tmp20_);
					_tmp22_ = _tmp21_;
					if (g_strcmp0 (_tmp22_, "vala") == 0) {
						GtkSourceBuffer* _tmp23_;
						GtkSourceBuffer* _tmp24_;
						_tmp23_ = self->priv->vala_buffer;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (buffer);
						buffer = _tmp24_;
					} else {
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp25_ = gtk_widget_get_clipboard ((GtkWidget*) self);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	clipboard = _tmp26_;
	_tmp27_ = buffer;
	g_object_get ((GtkTextBuffer*) _tmp27_, "text", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_;
	gdk_clipboard_set_text (clipboard, _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = gtk_widget_get_root ((GtkWidget*) self);
	elastic_window_show_copy_toast (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, ELASTIC_TYPE_WINDOW, ElasticWindow));
	_g_object_unref0 (clipboard);
	_g_object_unref0 (buffer);
}

ElasticExportView*
elastic_export_view_construct (GType object_type)
{
	ElasticExportView * self = NULL;
	self = (ElasticExportView*) g_object_new (object_type, NULL);
	return self;
}

ElasticExportView*
elastic_export_view_new (void)
{
	return elastic_export_view_construct (ELASTIC_TYPE_EXPORT_VIEW);
}

ElasticSpringParams*
elastic_export_view_get_spring (ElasticExportView* self)
{
	ElasticSpringParams* result;
	ElasticSpringParams* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spring;
	result = _tmp0_;
	return result;
}

static void
_elastic_export_view_update_code_elastic_spring_params_changed (ElasticSpringParams* _sender,
                                                                gpointer self)
{
	elastic_export_view_update_code ((ElasticExportView*) self);
}

void
elastic_export_view_set_spring (ElasticExportView* self,
                                ElasticSpringParams* value)
{
	ElasticSpringParams* _tmp0_;
	ElasticSpringParams* _tmp1_;
	ElasticSpringParams* _tmp2_;
	ElasticSpringParams* _tmp3_;
	ElasticSpringParams* _tmp7_;
	ElasticSpringParams* _tmp8_;
	ElasticSpringParams* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_export_view_get_spring (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = elastic_export_view_get_spring (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ElasticSpringParams* _tmp4_;
		ElasticSpringParams* _tmp5_;
		guint _tmp6_;
		_tmp4_ = elastic_export_view_get_spring (self);
		_tmp5_ = _tmp4_;
		g_signal_parse_name ("changed", ELASTIC_TYPE_SPRING_PARAMS, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _elastic_export_view_update_code_elastic_spring_params_changed, self);
	}
	_tmp7_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spring);
	self->priv->_spring = _tmp7_;
	_tmp8_ = elastic_export_view_get_spring (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ElasticSpringParams* _tmp10_;
		ElasticSpringParams* _tmp11_;
		_tmp10_ = elastic_export_view_get_spring (self);
		_tmp11_ = _tmp10_;
		g_signal_connect_object (_tmp11_, "changed", (GCallback) _elastic_export_view_update_code_elastic_spring_params_changed, self, 0);
	}
	elastic_export_view_update_code (self);
	g_object_notify_by_pspec ((GObject *) self, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_SPRING_PROPERTY]);
}

gboolean
elastic_export_view_get_use_damping (ElasticExportView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_damping;
	return result;
}

void
elastic_export_view_set_use_damping (ElasticExportView* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = elastic_export_view_get_use_damping (self);
	if (old_value != value) {
		self->priv->_use_damping = value;
		g_object_notify_by_pspec ((GObject *) self, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY]);
	}
}

gboolean
elastic_export_view_get_compact (ElasticExportView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compact;
	return result;
}

void
elastic_export_view_set_compact (ElasticExportView* self,
                                 gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = elastic_export_view_get_compact (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_compact = value;
	_tmp2_ = elastic_export_view_get_compact (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		AdwInlineViewSwitcher* _tmp4_;
		AdwInlineViewSwitcher* _tmp5_;
		_tmp4_ = self->priv->switcher;
		adw_inline_view_switcher_set_display_mode (_tmp4_, ADW_INLINE_VIEW_SWITCHER_ICONS);
		_tmp5_ = self->priv->switcher;
		gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_FILL);
	} else {
		AdwInlineViewSwitcher* _tmp6_;
		AdwInlineViewSwitcher* _tmp7_;
		_tmp6_ = self->priv->switcher;
		adw_inline_view_switcher_set_display_mode (_tmp6_, ADW_INLINE_VIEW_SWITCHER_LABELS);
		_tmp7_ = self->priv->switcher;
		gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	}
	g_object_notify_by_pspec ((GObject *) self, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY]);
}

static void
_elastic_export_view_update_style_scheme_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	elastic_export_view_update_style_scheme ((ElasticExportView*) self);
}

static void
_elastic_export_view_update_code_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	elastic_export_view_update_code ((ElasticExportView*) self);
}

static GObject *
elastic_export_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ElasticExportView * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	AdwViewStack* _tmp3_;
	GtkSourceLanguageManager* lang_manager = NULL;
	GtkSourceLanguageManager* _tmp4_;
	GtkSourceLanguageManager* _tmp5_;
	GtkSourceBuffer* _tmp6_;
	GtkSourceLanguageManager* _tmp7_;
	GtkSourceLanguage* _tmp8_;
	GtkSourceBuffer* _tmp9_;
	GtkSourceLanguageManager* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceBuffer* _tmp12_;
	GtkSourceLanguageManager* _tmp13_;
	GtkSourceLanguage* _tmp14_;
	GtkSourceBuffer* _tmp15_;
	GtkSourceLanguageManager* _tmp16_;
	GtkSourceLanguage* _tmp17_;
	GtkSourceBuffer* _tmp18_;
	GtkSourceLanguageManager* _tmp19_;
	GtkSourceLanguage* _tmp20_;
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp21_;
	AdwStyleManager* _tmp22_;
	AdwStyleManager* _tmp23_;
	parent_class = G_OBJECT_CLASS (elastic_export_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView);
	_tmp0_ = g_settings_new ("app.drey.Elastic");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_bind (_tmp1_, "use-damping", (GObject*) self, "use-damping", G_SETTINGS_BIND_GET);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->stack;
	g_settings_bind (_tmp2_, "last-language", (GObject*) _tmp3_, "visible-child-name", G_SETTINGS_BIND_DEFAULT);
	_tmp4_ = gtk_source_language_manager_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	lang_manager = _tmp5_;
	_tmp6_ = self->priv->c_buffer;
	_tmp7_ = lang_manager;
	_tmp8_ = gtk_source_language_manager_get_language (_tmp7_, "c");
	gtk_source_buffer_set_language (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->js_buffer;
	_tmp10_ = lang_manager;
	_tmp11_ = gtk_source_language_manager_get_language (_tmp10_, "js");
	gtk_source_buffer_set_language (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->python_buffer;
	_tmp13_ = lang_manager;
	_tmp14_ = gtk_source_language_manager_get_language (_tmp13_, "python");
	gtk_source_buffer_set_language (_tmp12_, _tmp14_);
	_tmp15_ = self->priv->rust_buffer;
	_tmp16_ = lang_manager;
	_tmp17_ = gtk_source_language_manager_get_language (_tmp16_, "rust");
	gtk_source_buffer_set_language (_tmp15_, _tmp17_);
	_tmp18_ = self->priv->vala_buffer;
	_tmp19_ = lang_manager;
	_tmp20_ = gtk_source_language_manager_get_language (_tmp19_, "vala");
	gtk_source_buffer_set_language (_tmp18_, _tmp20_);
	_tmp21_ = adw_style_manager_get_default ();
	_tmp22_ = _g_object_ref0 (_tmp21_);
	style_manager = _tmp22_;
	_tmp23_ = style_manager;
	g_signal_connect_object ((GObject*) _tmp23_, "notify::dark", (GCallback) _elastic_export_view_update_style_scheme_g_object_notify, self, 0);
	elastic_export_view_update_style_scheme (self);
	g_signal_connect_object ((GObject*) self, "notify::use-damping", (GCallback) _elastic_export_view_update_code_g_object_notify, self, 0);
	_g_object_unref0 (style_manager);
	_g_object_unref0 (lang_manager);
	return obj;
}

static void
_elastic_export_view___lambda13_ (GtkWidget* widget)
{
	g_return_if_fail (widget != NULL);
	elastic_export_view_copy_snippet (G_TYPE_CHECK_INSTANCE_CAST (widget, ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView));
}

static void
__elastic_export_view___lambda13__gtk_widget_action_activate_func (GtkWidget* widget,
                                                                   const gchar* action_name,
                                                                   GVariant* parameter)
{
	_elastic_export_view___lambda13_ (widget);
}

static void
elastic_export_view_class_init (ElasticExportViewClass * klass,
                                gpointer klass_data)
{
	elastic_export_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ElasticExportView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_elastic_export_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_elastic_export_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = elastic_export_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = elastic_export_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_EXPORT_VIEW_SPRING_PROPERTY, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_SPRING_PROPERTY] = g_param_spec_object ("spring", "spring", "spring", ELASTIC_TYPE_SPRING_PARAMS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY] = g_param_spec_boolean ("use-damping", "use-damping", "use-damping", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY, elastic_export_view_properties[ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY] = g_param_spec_boolean ("compact", "compact", "compact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/app/drey/Elastic/export-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switcher", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "c_buffer", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, c_buffer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "js_buffer", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, js_buffer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "python_buffer", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, python_buffer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rust_buffer", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, rust_buffer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "vala_buffer", FALSE, ElasticExportView_private_offset + G_STRUCT_OFFSET (ElasticExportViewPrivate, vala_buffer));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "editor.copy-snippet", NULL, __elastic_export_view___lambda13__gtk_widget_action_activate_func);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "export-view");
}

static void
elastic_export_view_instance_init (ElasticExportView * self,
                                   gpointer klass)
{
	self->priv = elastic_export_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
elastic_export_view_finalize (GObject * obj)
{
	ElasticExportView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView);
	_g_object_unref0 (self->priv->_spring);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (elastic_export_view_parent_class)->finalize (obj);
}

static GType
elastic_export_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ElasticExportViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) elastic_export_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ElasticExportView), 0, (GInstanceInitFunc) elastic_export_view_instance_init, NULL };
	GType elastic_export_view_type_id;
	elastic_export_view_type_id = g_type_register_static (adw_bin_get_type (), "ElasticExportView", &g_define_type_info, 0);
	ElasticExportView_private_offset = g_type_add_instance_private (elastic_export_view_type_id, sizeof (ElasticExportViewPrivate));
	return elastic_export_view_type_id;
}

GType
elastic_export_view_get_type (void)
{
	static volatile gsize elastic_export_view_type_id__once = 0;
	if (g_once_init_enter (&elastic_export_view_type_id__once)) {
		GType elastic_export_view_type_id;
		elastic_export_view_type_id = elastic_export_view_get_type_once ();
		g_once_init_leave (&elastic_export_view_type_id__once, elastic_export_view_type_id);
	}
	return elastic_export_view_type_id__once;
}

static void
_vala_elastic_export_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ElasticExportView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView);
	switch (property_id) {
		case ELASTIC_EXPORT_VIEW_SPRING_PROPERTY:
		g_value_set_object (value, elastic_export_view_get_spring (self));
		break;
		case ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY:
		g_value_set_boolean (value, elastic_export_view_get_use_damping (self));
		break;
		case ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY:
		g_value_set_boolean (value, elastic_export_view_get_compact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_elastic_export_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ElasticExportView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ELASTIC_TYPE_EXPORT_VIEW, ElasticExportView);
	switch (property_id) {
		case ELASTIC_EXPORT_VIEW_SPRING_PROPERTY:
		elastic_export_view_set_spring (self, g_value_get_object (value));
		break;
		case ELASTIC_EXPORT_VIEW_USE_DAMPING_PROPERTY:
		elastic_export_view_set_use_damping (self, g_value_get_boolean (value));
		break;
		case ELASTIC_EXPORT_VIEW_COMPACT_PROPERTY:
		elastic_export_view_set_compact (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

