#ifndef _ECTOR_RENDERER_GL_EO_H_
#define _ECTOR_RENDERER_GL_EO_H_

#ifndef _ECTOR_RENDERER_GL_EO_CLASS_TYPE
#define _ECTOR_RENDERER_GL_EO_CLASS_TYPE

typedef Eo Ector_Renderer_GL;

#endif

#ifndef _ECTOR_RENDERER_GL_EO_TYPES
#define _ECTOR_RENDERER_GL_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Ector GL renderer abstract class
 *
 * @ingroup Ector_Renderer_GL
 */
#define ECTOR_RENDERER_GL_CLASS ector_renderer_gl_class_get()

ECTOR_API ECTOR_API_WEAK const Efl_Class *ector_renderer_gl_class_get(void) EINA_CONST;

/**
 * @brief Fill operation
 *
 * @param[in] obj The object.
 * @param[in] flags GL flags
 * @param[in] vertex GL vertex
 * @param[in] vertex_count GL vertex count
 * @param[in] mul_col Premultiplied color
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Ector_Renderer_GL
 */
ECTOR_API ECTOR_API_WEAK Eina_Bool ector_renderer_gl_op_fill(Eo *obj, uint64_t flags, GLshort *vertex, unsigned int vertex_count, unsigned int mul_col);
#endif /* EFL_BETA_API_SUPPORT */

#endif
