/*      Compiler: ECL 24.5.10                                         */
/*      Source: /build/ecl/src/ecl-24.5.10/src/cmp/cmpenv-optimize.lsp */
#include <ecl/ecl-cmp.h>
#include "cmp/cmpenv-optimize.eclh"
/*      function definition for DEFAULT-POLICY                        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3233default_policy()
{
 cl_object T0, T1, T2, T3, T4, T5;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = cl_list(2, ECL_SYM("SPACE",790), ecl_symbol_value(VV[0]));
  T1 = cl_list(2, ECL_SYM("SAFETY",736), ecl_symbol_value(VV[1]));
  T2 = cl_list(2, ECL_SYM("DEBUG",272), ecl_symbol_value(VV[2]));
  T3 = cl_list(2, ECL_SYM("SPEED",793), ecl_symbol_value(VV[3]));
  T4 = cl_list(2, ECL_SYM("COMPILATION-SPEED",234), ecl_symbol_value(VV[4]));
  T5 = cl_list(5, T0, T1, T2, T3, T4);
  value0 = ecl_function_dispatch(cl_env_copy,VV[39])(2, T5, ecl_make_fixnum(0)) /*  COMPUTE-POLICY */;
  return value0;
 }
}
/*      function definition for CMP-ENV-POLICY                        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3234cmp_env_policy(cl_object v1env)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = ecl_function_dispatch(cl_env_copy,VV[41])(2, VV[6], v1env) /*  CMP-ENV-SEARCH-DECLARATION */;
  value0 = ecl_car(T0);
  if ((value0)!=ECL_NIL) { goto L2; }
  value0 = L3233default_policy();
  return value0;
L2:;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for ADD-DEFAULT-OPTIMIZATIONS             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3235add_default_optimizations(cl_object v1env)
{
 cl_object T0, T1;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (Null(ecl_function_dispatch(cl_env_copy,VV[41])(2, VV[6], v1env) /*  CMP-ENV-SEARCH-DECLARATION */)) { goto L1; }
  value0 = v1env;
  cl_env_copy->nvalues = 1;
  return value0;
L1:;
  T0 = L3233default_policy();
  T1 = ecl_list1(T0);
  value0 = ecl_function_dispatch(cl_env_copy,VV[43])(3, VV[6], T1, v1env) /*  CMP-ENV-ADD-DECLARATION */;
  return value0;
 }
}
/*      function definition for CMP-ENV-ADD-OPTIMIZATIONS             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3236cmp_env_add_optimizations(cl_narg narg, cl_object v1decl, ...)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2env;
  va_list args; va_start(args,v1decl);
  {
   int i = 1;
   if (i >= narg) {
    v2env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v2env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v3old;
   cl_object v4new;
   v3old = L3234cmp_env_policy(v2env);
   v4new = ecl_function_dispatch(cl_env_copy,VV[39])(2, v1decl, v3old) /*  COMPUTE-POLICY */;
   T0 = ecl_list1(v4new);
   value0 = ecl_function_dispatch(cl_env_copy,VV[43])(3, VV[6], T0, v2env) /*  CMP-ENV-ADD-DECLARATION */;
   return value0;
  }
 }
}
/*      function definition for MAYBE-ADD-POLICY                      */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3237maybe_add_policy(cl_narg narg, cl_object v1decl, ...)
{
 cl_object T0, T1;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2env;
  va_list args; va_start(args,v1decl);
  {
   int i = 1;
   if (i >= narg) {
    v2env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v2env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  if (!(ECL_CONSP(v1decl))) { goto L2; }
  T0 = cl_list_length(v1decl);
  if (!(ecl_lowereq(T0,ecl_make_fixnum(2)))) { goto L2; }
  T0 = ecl_car(v1decl);
  if (Null(ecl_gethash_safe(T0,ecl_symbol_value(VV[11]),ECL_NIL))) { goto L2; }
  {
   cl_object v3name;
   cl_fixnum v4value;
   cl_object v5old_policy;
   cl_object v6new_policy;
   v3name = ecl_car(v1decl);
   T0 = ecl_cdr(v1decl);
   if (ecl_endp(T0)) { goto L10; }
   if (Null(ecl_cadr(v1decl))) { goto L8; }
   goto L9;
L10:;
L9:;
   if (Null(ecl_function_dispatch(cl_env_copy,VV[46])(1, v3name) /*  STANDARD-OPTIMIZATION-QUALITY-P */)) { goto L12; }
   v4value = 3;
   goto L7;
L12:;
   v4value = 1;
   goto L7;
L8:;
   v4value = 0;
L7:;
   v5old_policy = L3234cmp_env_policy(v2env);
   T0 = cl_list(2, v3name, ecl_make_fixnum(v4value));
   T1 = ecl_list1(T0);
   v6new_policy = ecl_function_dispatch(cl_env_copy,VV[39])(2, T1, v5old_policy) /*  COMPUTE-POLICY */;
   T0 = ecl_list1(v6new_policy);
   value0 = ecl_function_dispatch(cl_env_copy,VV[43])(3, VV[6], T0, v2env) /*  CMP-ENV-ADD-DECLARATION */;
   return value0;
  }
L2:;
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for CMP-ENV-ALL-OPTIMIZATIONS             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3238cmp_env_all_optimizations(cl_narg narg, ...)
{
 cl_object T0, T1, T2, T3;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2o;
   v2o = L3234cmp_env_policy(v1env);
   T0 = ecl_function_dispatch(cl_env_copy,VV[48])(1, v2o) /*  POLICY-TO-DEBUG-LEVEL */;
   T1 = ecl_function_dispatch(cl_env_copy,VV[49])(1, v2o) /*  POLICY-TO-SAFETY-LEVEL */;
   T2 = ecl_function_dispatch(cl_env_copy,VV[50])(1, v2o) /*  POLICY-TO-SPACE-LEVEL */;
   T3 = ecl_function_dispatch(cl_env_copy,VV[51])(1, v2o) /*  POLICY-TO-SPEED-LEVEL */;
   value0 = cl_list(4, T0, T1, T2, T3);
   return value0;
  }
 }
}
/*      function definition for CMP-ENV-OPTIMIZATION                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3239cmp_env_optimization(cl_narg narg, cl_object v1property, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2env;
  va_list args; va_start(args,v1property);
  {
   int i = 1;
   if (i >= narg) {
    v2env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v2env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v3o;
   v3o = L3234cmp_env_policy(v2env);
   if (!((v1property)==(ECL_SYM("DEBUG",272)))) { goto L3; }
   value0 = ecl_function_dispatch(cl_env_copy,VV[48])(1, v3o) /*  POLICY-TO-DEBUG-LEVEL */;
   return value0;
L3:;
   if (!((v1property)==(ECL_SYM("SAFETY",736)))) { goto L5; }
   value0 = ecl_function_dispatch(cl_env_copy,VV[49])(1, v3o) /*  POLICY-TO-SAFETY-LEVEL */;
   return value0;
L5:;
   if (!((v1property)==(ECL_SYM("SPACE",790)))) { goto L7; }
   value0 = ecl_function_dispatch(cl_env_copy,VV[50])(1, v3o) /*  POLICY-TO-SPACE-LEVEL */;
   return value0;
L7:;
   if (!((v1property)==(ECL_SYM("SPEED",793)))) { goto L9; }
   value0 = ecl_function_dispatch(cl_env_copy,VV[51])(1, v3o) /*  POLICY-TO-SPEED-LEVEL */;
   return value0;
L9:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for SAFE-COMPILE                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3240safe_compile()
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = L3239cmp_env_optimization(1, ECL_SYM("SAFETY",736));
  value0 = ecl_make_bool(ecl_greatereq(T0,ecl_make_fixnum(2)));
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for COMPILER-PUSH-EVENTS                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3241compiler_push_events()
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = L3239cmp_env_optimization(1, ECL_SYM("SAFETY",736));
  value0 = ecl_make_bool(ecl_greatereq(T0,ecl_make_fixnum(3)));
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for POLICY-ASSUME-NO-ERRORS               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3242policy_assume_no_errors(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(2097152));
   return value0;
  }
 }
}
/*      function definition for POLICY-ASSUME-RIGHT-TYPE              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3243policy_assume_right_type(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L3242policy_assume_no_errors(1, v1env);
  return value0;
 }
}
/*      function definition for POLICY-TYPE-ASSERTIONS                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3244policy_type_assertions(cl_narg narg, ...)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  T0 = L3242policy_assume_no_errors(1, v1env);
  value0 = Null(T0)?ECL_T:ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for POLICY-CHECK-STACK-OVERFLOW           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3245policy_check_stack_overflow(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(4194304));
   return value0;
  }
 }
}
/*      function definition for POLICY-CHECK-ARGUMENTS-TYPE           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3246policy_check_arguments_type(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(8388608));
   return value0;
  }
 }
}
/*      function definition for POLICY-ARRAY-BOUNDS-CHECK             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3247policy_array_bounds_check(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(16777216));
   return value0;
  }
 }
}
/*      function definition for POLICY-GLOBAL-VAR-CHECKING            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3248policy_global_var_checking(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(33554432));
   return value0;
  }
 }
}
/*      function definition for POLICY-GLOBAL-FUNCTION-CHECKING       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3249policy_global_function_checking(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(67108864));
   return value0;
  }
 }
}
/*      function definition for POLICY-CHECK-NARGS                    */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3250policy_check_nargs(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(134217728));
   return value0;
  }
 }
}
/*      function definition for POLICY-THE-IS-CHECKED                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3251policy_the_is_checked(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(268435456));
   return value0;
  }
 }
}
/*      function definition for POLICY-ASSUME-TYPES-DONT-CHANGE       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3252policy_assume_types_dont_change(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(536870912));
   return value0;
  }
 }
}
/*      function definition for POLICY-INLINE-SLOT-ACCESS             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3253policy_inline_slot_access(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(1073741824));
   return value0;
  }
 }
}
/*      function definition for POLICY-INLINE-ACCESSORS               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3254policy_inline_accessors(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(2147483648));
   return value0;
  }
 }
}
/*      function definition for POLICY-INLINE-BIT-OPERATIONS          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3255policy_inline_bit_operations(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(4294967296));
   return value0;
  }
 }
}
/*      function definition for POLICY-OPEN-CODE-AREF/ASET            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3256policy_open_code_aref_aset(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L3254policy_inline_accessors(1, v1env);
  return value0;
 }
}
/*      function definition for POLICY-EVALUATE-FORMS                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3257policy_evaluate_forms(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(8589934592));
   return value0;
  }
 }
}
/*      function definition for POLICY-USE-DIRECT-C-CALL              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3258policy_use_direct_c_call(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(17179869184));
   return value0;
  }
 }
}
/*      function definition for POLICY-INLINE-TYPE-CHECKS             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3259policy_inline_type_checks(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(34359738368));
   return value0;
  }
 }
}
/*      function definition for POLICY-INLINE-SEQUENCE-FUNCTIONS      */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3260policy_inline_sequence_functions(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(68719476736));
   return value0;
  }
 }
}
/*      function definition for POLICY-DEBUG-VARIABLE-BINDINGS        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3261policy_debug_variable_bindings(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   if (Null(cl_logtest(v2bits, ecl_make_fixnum(137438953472)))) { goto L4; }
   value0 = L3262policy_debug_ihs_frame(1, v1env);
   return value0;
L4:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      function definition for POLICY-DEBUG-IHS-FRAME                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L3262policy_debug_ihs_frame(cl_narg narg, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg>1)) FEwrong_num_arguments_anonym();
 {
  cl_object v1env;
  va_list args; va_start(args,narg);
  {
   int i = 0;
   if (i >= narg) {
    v1env = ecl_symbol_value(VV[9]);
   } else {
    i++;
    v1env = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v2bits;
   v2bits = L3234cmp_env_policy(v1env);
   value0 = cl_logtest(v2bits, ecl_make_fixnum(274877906944));
   return value0;
  }
 }
}

#include "cmp/cmpenv-optimize.data"
#ifdef __cplusplus
extern "C"
#endif
ECL_DLLEXPORT void _eclXzYDHfioD7fj9_eK74ud71(cl_object flag)
{
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 cl_object *VVtemp;
 if (flag != OBJNULL){
 Cblock = flag;
 #ifndef ECL_DYNAMIC_VV
 flag->cblock.data = VV;
 #endif
 flag->cblock.data_size = VM;
 flag->cblock.temp_data_size = VMtemp;
 flag->cblock.data_text = compiler_data_text;
 flag->cblock.cfuns_size = compiler_cfuns_size;
 flag->cblock.cfuns = compiler_cfuns;
 flag->cblock.source = ecl_make_constant_base_string("SRC:CMP;CMPENV-OPTIMIZE.LSP.NEWEST",-1);
 return;}
 #ifdef ECL_DYNAMIC_VV
 VV = Cblock->cblock.data;
 #endif
 Cblock->cblock.data_text = (const cl_object *)"@EcLtAg:_eclXzYDHfioD7fj9_eK74ud71@";
 VVtemp = Cblock->cblock.temp_data;
 ECL_DEFINE_SETF_FUNCTIONS
  si_select_package(_ecl_static_0);
  ecl_cmp_defun(VV[38]);                          /*  DEFAULT-POLICY  */
  ecl_cmp_defun(VV[40]);                          /*  CMP-ENV-POLICY  */
  ecl_cmp_defun(VV[42]);                          /*  ADD-DEFAULT-OPTIMIZATIONS */
  ecl_cmp_defun(VV[44]);                          /*  CMP-ENV-ADD-OPTIMIZATIONS */
  ecl_cmp_defun(VV[45]);                          /*  MAYBE-ADD-POLICY */
  ecl_cmp_defun(VV[47]);                          /*  CMP-ENV-ALL-OPTIMIZATIONS */
  ecl_cmp_defun(VV[52]);                          /*  CMP-ENV-OPTIMIZATION */
  ecl_cmp_defun(VV[53]);                          /*  SAFE-COMPILE    */
  ecl_cmp_defun(VV[54]);                          /*  COMPILER-PUSH-EVENTS */
  ecl_cmp_defun(VV[55]);                          /*  POLICY-ASSUME-NO-ERRORS */
  ecl_cmp_defun(VV[56]);                          /*  POLICY-ASSUME-RIGHT-TYPE */
  ecl_cmp_defun(VV[57]);                          /*  POLICY-TYPE-ASSERTIONS */
  ecl_cmp_defun(VV[58]);                          /*  POLICY-CHECK-STACK-OVERFLOW */
  ecl_cmp_defun(VV[59]);                          /*  POLICY-CHECK-ARGUMENTS-TYPE */
  ecl_cmp_defun(VV[60]);                          /*  POLICY-ARRAY-BOUNDS-CHECK */
  ecl_cmp_defun(VV[61]);                          /*  POLICY-GLOBAL-VAR-CHECKING */
  ecl_cmp_defun(VV[62]);                          /*  POLICY-GLOBAL-FUNCTION-CHECKING */
  ecl_cmp_defun(VV[63]);                          /*  POLICY-CHECK-NARGS */
  ecl_cmp_defun(VV[64]);                          /*  POLICY-THE-IS-CHECKED */
  ecl_cmp_defun(VV[65]);                          /*  POLICY-ASSUME-TYPES-DONT-CHANGE */
  ecl_cmp_defun(VV[66]);                          /*  POLICY-INLINE-SLOT-ACCESS */
  ecl_cmp_defun(VV[67]);                          /*  POLICY-INLINE-ACCESSORS */
  ecl_cmp_defun(VV[68]);                          /*  POLICY-INLINE-BIT-OPERATIONS */
  ecl_cmp_defun(VV[69]);                          /*  POLICY-OPEN-CODE-AREF/ASET */
  ecl_cmp_defun(VV[70]);                          /*  POLICY-EVALUATE-FORMS */
  ecl_cmp_defun(VV[71]);                          /*  POLICY-USE-DIRECT-C-CALL */
  ecl_cmp_defun(VV[72]);                          /*  POLICY-INLINE-TYPE-CHECKS */
  ecl_cmp_defun(VV[73]);                          /*  POLICY-INLINE-SEQUENCE-FUNCTIONS */
  ecl_cmp_defun(VV[74]);                          /*  POLICY-DEBUG-VARIABLE-BINDINGS */
  ecl_cmp_defun(VV[75]);                          /*  POLICY-DEBUG-IHS-FRAME */
}
