/*
 * Cppcheck - A tool for static C/C++ code analysis
 * Copyright (C) 2007-2025 Cppcheck team.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// This file is auto-generated by tools/get_checkers.py:
// python3 tools/get_checkers.py > lib/checkers.cpp

#include "checkers.h"

namespace checkers {
    const std::map<std::string, std::string> allCheckers{
        {"Check64BitPortability::pointerassignment","portability"},
        {"CheckAssert::assertWithSideEffects","warning"},
        {"CheckAutoVariables::assignFunctionArg","style,warning"},
        {"CheckAutoVariables::autoVariables",""},
        {"CheckAutoVariables::checkVarLifetime",""},
        {"CheckBool::checkAssignBoolToFloat","style,c++"},
        {"CheckBool::checkAssignBoolToPointer",""},
        {"CheckBool::checkBitwiseOnBoolean","style,inconclusive"},
        {"CheckBool::checkComparisonOfBoolExpressionWithInt","warning"},
        {"CheckBool::checkComparisonOfBoolWithBool","style,c++"},
        {"CheckBool::checkComparisonOfBoolWithInt","warning,c++"},
        {"CheckBool::checkComparisonOfFuncReturningBool","style,c++"},
        {"CheckBool::checkIncrementBoolean","style"},
        {"CheckBool::pointerArithBool",""},
        {"CheckBool::returnValueOfFunctionReturningBool","style"},
        {"CheckBufferOverrun::analyseWholeProgram",""},
        {"CheckBufferOverrun::argumentSize","warning"},
        {"CheckBufferOverrun::arrayIndex",""},
        {"CheckBufferOverrun::arrayIndexThenCheck",""},
        {"CheckBufferOverrun::bufferOverflow",""},
        {"CheckBufferOverrun::negativeArraySize",""},
        {"CheckBufferOverrun::objectIndex",""},
        {"CheckBufferOverrun::pointerArithmetic","portability"},
        {"CheckBufferOverrun::stringNotZeroTerminated","warning,inconclusive"},
        {"CheckClass::analyseWholeProgram",""},
        {"CheckClass::checkConst","style,inconclusive"},
        {"CheckClass::checkConstructors","style,warning"},
        {"CheckClass::checkCopyConstructors","warning"},
        {"CheckClass::checkDuplInheritedMembers","warning"},
        {"CheckClass::checkExplicitConstructors","style"},
        {"CheckClass::checkMemset",""},
        {"CheckClass::checkMissingOverride","style,c++03"},
        {"CheckClass::checkReturnByReference","performance"},
        {"CheckClass::checkSelfInitialization",""},
        {"CheckClass::checkThisUseAfterFree","warning"},
        {"CheckClass::checkUnsafeClassRefMember","warning,safeChecks"},
        {"CheckClass::checkUselessOverride","style"},
        {"CheckClass::checkVirtualFunctionCallInConstructor","warning"},
        {"CheckClass::initializationListUsage","performance"},
        {"CheckClass::initializerListOrder","style,inconclusive"},
        {"CheckClass::operatorEqRetRefThis","style"},
        {"CheckClass::operatorEqToSelf","warning"},
        {"CheckClass::privateFunctions","style"},
        {"CheckClass::thisSubtraction","warning"},
        {"CheckClass::virtualDestructor",""},
        {"CheckCondition::alwaysTrueFalse","style"},
        {"CheckCondition::assignIf","style"},
        {"CheckCondition::checkAssignmentInCondition","style"},
        {"CheckCondition::checkBadBitmaskCheck","style"},
        {"CheckCondition::checkCompareValueOutOfTypeRange","style,platform"},
        {"CheckCondition::checkDuplicateConditionalAssign","style"},
        {"CheckCondition::checkIncorrectLogicOperator","style,warning"},
        {"CheckCondition::checkInvalidTestForOverflow","warning"},
        {"CheckCondition::checkModuloAlwaysTrueFalse","warning"},
        {"CheckCondition::checkPointerAdditionResultNotNull","warning"},
        {"CheckCondition::clarifyCondition","style"},
        {"CheckCondition::comparison","style"},
        {"CheckCondition::duplicateCondition","style"},
        {"CheckCondition::multiCondition","style"},
        {"CheckCondition::multiCondition2","warning"},
        {"CheckExceptionSafety::checkCatchExceptionByValue","style"},
        {"CheckExceptionSafety::checkRethrowCopy","style"},
        {"CheckExceptionSafety::deallocThrow","warning"},
        {"CheckExceptionSafety::destructors","warning"},
        {"CheckExceptionSafety::nothrowThrows",""},
        {"CheckExceptionSafety::rethrowNoCurrentException",""},
        {"CheckExceptionSafety::unhandledExceptionSpecification","style,inconclusive"},
        {"CheckFunctions::checkIgnoredReturnValue","style,warning"},
        {"CheckFunctions::checkMathFunctions","style,warning,c99,c++11"},
        {"CheckFunctions::checkMissingReturn",""},
        {"CheckFunctions::checkProhibitedFunctions",""},
        {"CheckFunctions::invalidFunctionUsage",""},
        {"CheckFunctions::memsetInvalid2ndParam","warning,portability"},
        {"CheckFunctions::memsetZeroBytes","warning"},
        {"CheckFunctions::returnLocalStdMove","performance,c++11"},
        {"CheckFunctions::useStandardLibrary","style"},
        {"CheckIO::checkCoutCerrMisusage","c"},
        {"CheckIO::checkFileUsage",""},
        {"CheckIO::checkWrongPrintfScanfArguments",""},
        {"CheckIO::invalidScanf",""},
        {"CheckLeakAutoVar::check","notclang"},
        {"CheckMemoryLeakInClass::check",""},
        {"CheckMemoryLeakInFunction::checkReallocUsage",""},
        {"CheckMemoryLeakNoVar::check",""},
        {"CheckMemoryLeakNoVar::checkForUnsafeArgAlloc",""},
        {"CheckMemoryLeakStructMember::check",""},
        {"CheckNullPointer::analyseWholeProgram","unusedfunctions"},
        {"CheckNullPointer::arithmetic",""},
        {"CheckNullPointer::nullConstantDereference",""},
        {"CheckNullPointer::nullPointer",""},
        {"CheckOther::checkAccessOfMovedVariable","c++11,warning"},
        {"CheckOther::checkCastIntToCharAndBack","warning"},
        {"CheckOther::checkCharVariable","warning,portability"},
        {"CheckOther::checkComparePointers",""},
        {"CheckOther::checkComparisonFunctionIsAlwaysTrueOrFalse","warning"},
        {"CheckOther::checkConstPointer","style"},
        {"CheckOther::checkConstVariable","style,c++"},
        {"CheckOther::checkDuplicateBranch","style,inconclusive"},
        {"CheckOther::checkDuplicateExpression","style,warning"},
        {"CheckOther::checkEvaluationOrder",""},
        {"CheckOther::checkFuncArgNamesDifferent","style,warning,inconclusive"},
        {"CheckOther::checkIncompleteArrayFill","warning,portability,inconclusive"},
        {"CheckOther::checkIncompleteStatement","warning"},
        {"CheckOther::checkInterlockedDecrement","windows-platform"},
        {"CheckOther::checkInvalidFree",""},
        {"CheckOther::checkKnownArgument","style"},
        {"CheckOther::checkKnownPointerToBool","style"},
        {"CheckOther::checkMisusedScopedObject","style,c++"},
        {"CheckOther::checkModuloOfOne","style"},
        {"CheckOther::checkNanInArithmeticExpression","style"},
        {"CheckOther::checkNegativeBitwiseShift",""},
        {"CheckOther::checkOverlappingWrite",""},
        {"CheckOther::checkPassByReference","performance,c++"},
        {"CheckOther::checkRedundantAssignment","style"},
        {"CheckOther::checkRedundantCopy","c++,performance,inconclusive"},
        {"CheckOther::checkRedundantPointerOp","style"},
        {"CheckOther::checkShadowVariables","style"},
        {"CheckOther::checkSignOfUnsignedVariable","style"},
        {"CheckOther::checkSuspiciousCaseInSwitch","warning,inconclusive"},
        {"CheckOther::checkSuspiciousSemicolon","warning,inconclusive"},
        {"CheckOther::checkUnionZeroInit","portability"},
        {"CheckOther::checkUnreachableCode","style"},
        {"CheckOther::checkUnusedLabel","style,warning"},
        {"CheckOther::checkVarFuncNullUB","portability"},
        {"CheckOther::checkVariableScope","style,notclang"},
        {"CheckOther::checkZeroDivision",""},
        {"CheckOther::clarifyCalculation","style"},
        {"CheckOther::clarifyStatement","warning"},
        {"CheckOther::invalidPointerCast","portability"},
        {"CheckOther::redundantBitwiseOperationInSwitch","warning"},
        {"CheckOther::suspiciousFloatingPointCast","style"},
        {"CheckOther::warningDangerousTypeCast","warning,c++"},
        {"CheckOther::warningIntToPointerCast","portability"},
        {"CheckOther::warningOldStylePointerCast","style,c++"},
        {"CheckPostfixOperator::postfixOperator","performance"},
        {"CheckSizeof::checkSizeofForArrayParameter","warning"},
        {"CheckSizeof::checkSizeofForNumericParameter","warning"},
        {"CheckSizeof::checkSizeofForPointerSize","warning"},
        {"CheckSizeof::sizeofCalculation","warning"},
        {"CheckSizeof::sizeofFunction","warning"},
        {"CheckSizeof::sizeofVoid","portability"},
        {"CheckSizeof::sizeofsizeof","warning"},
        {"CheckSizeof::suspiciousSizeofCalculation","warning,inconclusive"},
        {"CheckStl::checkDereferenceInvalidIterator","warning"},
        {"CheckStl::checkDereferenceInvalidIterator2",""},
        {"CheckStl::checkFindInsert","performance"},
        {"CheckStl::checkMutexes","warning"},
        {"CheckStl::erase",""},
        {"CheckStl::eraseIteratorOutOfBounds",""},
        {"CheckStl::if_find","warning,performance"},
        {"CheckStl::invalidContainer",""},
        {"CheckStl::iterators",""},
        {"CheckStl::knownEmptyContainer","style"},
        {"CheckStl::misMatchingContainerIterator",""},
        {"CheckStl::misMatchingContainers",""},
        {"CheckStl::missingComparison","warning"},
        {"CheckStl::negativeIndex",""},
        {"CheckStl::outOfBounds",""},
        {"CheckStl::outOfBoundsIndexExpression",""},
        {"CheckStl::redundantCondition","style"},
        {"CheckStl::size","performance,c++03"},
        {"CheckStl::stlBoundaries",""},
        {"CheckStl::stlOutOfBounds",""},
        {"CheckStl::string_c_str",""},
        {"CheckStl::useStlAlgorithm","style"},
        {"CheckStl::uselessCalls","performance,warning"},
        {"CheckString::checkAlwaysTrueOrFalseStringCompare","warning"},
        {"CheckString::checkIncorrectStringCompare","warning"},
        {"CheckString::checkSuspiciousStringCompare","warning"},
        {"CheckString::overlappingStrcmp","warning"},
        {"CheckString::sprintfOverlappingData",""},
        {"CheckString::strPlusChar",""},
        {"CheckString::stringLiteralWrite",""},
        {"CheckType::checkFloatToIntegerOverflow",""},
        {"CheckType::checkIntegerOverflow","platform"},
        {"CheckType::checkLongCast","style"},
        {"CheckType::checkSignConversion","warning"},
        {"CheckType::checkTooBigBitwiseShift","platform"},
        {"CheckUninitVar::analyseWholeProgram",""},
        {"CheckUninitVar::check",""},
        {"CheckUninitVar::valueFlowUninit",""},
        {"CheckUnusedFunctions::check","unusedFunction"},
        {"CheckUnusedVar::checkFunctionVariableUsage","style"},
        {"CheckUnusedVar::checkStructMemberUsage","style"},
        {"CheckVaarg::va_list_usage","notclang"},
        {"CheckVaarg::va_start_argument",""},
    };

    const std::map<std::string, std::string> premiumCheckers{
        {"Autosar: A0-1-3",""},
        {"Autosar: A0-1-4",""},
        {"Autosar: A0-1-5",""},
        {"Autosar: A0-1-6",""},
        {"Autosar: A0-4-2",""},
        {"Autosar: A0-4-4",""},
        {"Autosar: A10-1-1",""},
        {"Autosar: A11-0-2",""},
        {"Autosar: A11-3-1",""},
        {"Autosar: A13-2-1",""},
        {"Autosar: A13-2-3",""},
        {"Autosar: A13-5-2",""},
        {"Autosar: A13-5-5",""},
        {"Autosar: A15-1-2",""},
        {"Autosar: A15-3-5",""},
        {"Autosar: A16-6-1",""},
        {"Autosar: A16-7-1",""},
        {"Autosar: A18-0-3",""},
        {"Autosar: A18-1-1",""},
        {"Autosar: A18-1-2",""},
        {"Autosar: A18-1-3",""},
        {"Autosar: A18-5-1",""},
        {"Autosar: A18-9-1",""},
        {"Autosar: A2-11-1",""},
        {"Autosar: A2-13-1",""},
        {"Autosar: A2-13-3",""},
        {"Autosar: A2-13-5",""},
        {"Autosar: A2-5-2",""},
        {"Autosar: A2-7-1",""},
        {"Autosar: A20-8-2","warning"},
        {"Autosar: A20-8-3","warning"},
        {"Autosar: A20-8-4",""},
        {"Autosar: A20-8-5",""},
        {"Autosar: A20-8-6",""},
        {"Autosar: A21-8-1","warning"},
        {"Autosar: A23-0-1",""},
        {"Autosar: A25-1-1","warning"},
        {"Autosar: A25-4-1","warning"},
        {"Autosar: A26-5-1",""},
        {"Autosar: A26-5-2",""},
        {"Autosar: A27-0-1","warning"},
        {"Autosar: A27-0-2",""},
        {"Autosar: A27-0-4",""},
        {"Autosar: A3-1-3",""},
        {"Autosar: A3-1-4",""},
        {"Autosar: A3-3-1",""},
        {"Autosar: A3-9-1",""},
        {"Autosar: A4-10-1",""},
        {"Autosar: A4-7-1",""},
        {"Autosar: A5-0-2",""},
        {"Autosar: A5-0-3",""},
        {"Autosar: A5-0-4",""},
        {"Autosar: A5-1-1",""},
        {"Autosar: A5-1-2",""},
        {"Autosar: A5-1-3",""},
        {"Autosar: A5-1-6",""},
        {"Autosar: A5-1-7",""},
        {"Autosar: A5-16-1",""},
        {"Autosar: A5-2-1",""},
        {"Autosar: A5-2-3",""},
        {"Autosar: A5-2-4",""},
        {"Autosar: A5-3-3",""},
        {"Autosar: A6-5-3",""},
        {"Autosar: A7-1-4",""},
        {"Autosar: A7-1-6",""},
        {"Autosar: A7-1-7",""},
        {"Autosar: A7-2-1",""},
        {"Autosar: A7-2-2",""},
        {"Autosar: A7-6-1",""},
        {"Autosar: A8-4-1",""},
        {"Autosar: A8-5-3",""},
        {"Autosar: A9-3-1",""},
        {"Cert C++: CON50-CPP",""},
        {"Cert C++: CON51-CPP",""},
        {"Cert C++: CON52-CPP",""},
        {"Cert C++: CON53-CPP",""},
        {"Cert C++: CON54-CPP",""},
        {"Cert C++: CON55-CPP",""},
        {"Cert C++: CON56-CPP",""},
        {"Cert C++: CTR50-CPP",""},
        {"Cert C++: CTR52-CPP",""},
        {"Cert C++: CTR53-CPP",""},
        {"Cert C++: CTR56-CPP",""},
        {"Cert C++: CTR57-CPP","warning"},
        {"Cert C++: CTR58-CPP","warning"},
        {"Cert C++: DCL50-CPP",""},
        {"Cert C++: DCL51-CPP",""},
        {"Cert C++: DCL52-CPP",""},
        {"Cert C++: DCL53-CPP",""},
        {"Cert C++: DCL54-CPP",""},
        {"Cert C++: DCL56-CPP",""},
        {"Cert C++: DCL58-CPP",""},
        {"Cert C++: DCL59-CPP",""},
        {"Cert C++: ERR50-CPP",""},
        {"Cert C++: ERR51-CPP",""},
        {"Cert C++: ERR52-CPP",""},
        {"Cert C++: ERR53-CPP",""},
        {"Cert C++: ERR54-CPP",""},
        {"Cert C++: ERR55-CPP",""},
        {"Cert C++: ERR56-CPP",""},
        {"Cert C++: ERR58-CPP",""},
        {"Cert C++: ERR59-CPP","warning"},
        {"Cert C++: ERR60-CPP","warning"},
        {"Cert C++: ERR61-CPP",""},
        {"Cert C++: ERR62-CPP",""},
        {"Cert C++: EXP50-CPP",""},
        {"Cert C++: EXP51-CPP",""},
        {"Cert C++: EXP54-CPP",""},
        {"Cert C++: EXP55-CPP",""},
        {"Cert C++: EXP56-CPP",""},
        {"Cert C++: EXP57-CPP",""},
        {"Cert C++: EXP58-CPP",""},
        {"Cert C++: EXP59-CPP",""},
        {"Cert C++: EXP60-CPP",""},
        {"Cert C++: FIO51-CPP",""},
        {"Cert C++: INT50-CPP",""},
        {"Cert C++: MEM51-CPP",""},
        {"Cert C++: MEM52-CPP",""},
        {"Cert C++: MEM53-CPP",""},
        {"Cert C++: MEM54-CPP",""},
        {"Cert C++: MEM55-CPP",""},
        {"Cert C++: MEM57-CPP",""},
        {"Cert C++: MSC50-CPP",""},
        {"Cert C++: MSC51-CPP",""},
        {"Cert C++: MSC53-CPP",""},
        {"Cert C++: MSC54-CPP",""},
        {"Cert C++: OOP51-CPP",""},
        {"Cert C++: OOP55-CPP",""},
        {"Cert C++: OOP56-CPP",""},
        {"Cert C++: OOP57-CPP",""},
        {"Cert C++: OOP58-CPP",""},
        {"Cert C++: STR50-CPP",""},
        {"Cert C++: STR53-CPP",""},
        {"Cert C: ARR30-C",""},
        {"Cert C: ARR32-C",""},
        {"Cert C: ARR37-C",""},
        {"Cert C: ARR38-C",""},
        {"Cert C: ARR39-C",""},
        {"Cert C: CON30-C",""},
        {"Cert C: CON31-C",""},
        {"Cert C: CON32-C",""},
        {"Cert C: CON33-C",""},
        {"Cert C: CON34-C",""},
        {"Cert C: CON35-C",""},
        {"Cert C: CON36-C",""},
        {"Cert C: CON37-C",""},
        {"Cert C: CON38-C",""},
        {"Cert C: CON39-C",""},
        {"Cert C: CON40-C",""},
        {"Cert C: CON41-C",""},
        {"Cert C: DCL03-C",""},
        {"Cert C: DCL04-C",""},
        {"Cert C: DCL05-C",""},
        {"Cert C: DCL06-C",""},
        {"Cert C: DCL20-C",""},
        {"Cert C: DCL31-C",""},
        {"Cert C: DCL36-C",""},
        {"Cert C: DCL37-C",""},
        {"Cert C: DCL38-C",""},
        {"Cert C: DCL39-C",""},
        {"Cert C: DCL40-C",""},
        {"Cert C: DCL41-C",""},
        {"Cert C: ENV30-C",""},
        {"Cert C: ENV31-C",""},
        {"Cert C: ENV32-C",""},
        {"Cert C: ENV33-C",""},
        {"Cert C: ENV34-C",""},
        {"Cert C: ERR30-C",""},
        {"Cert C: ERR32-C",""},
        {"Cert C: ERR33-C",""},
        {"Cert C: ERR34-C",""},
        {"Cert C: EXP03-C",""},
        {"Cert C: EXP05-C",""},
        {"Cert C: EXP09-C",""},
        {"Cert C: EXP13-C",""},
        {"Cert C: EXP15-C",""},
        {"Cert C: EXP19-C",""},
        {"Cert C: EXP20-C",""},
        {"Cert C: EXP30-C",""},
        {"Cert C: EXP32-C",""},
        {"Cert C: EXP34-C",""},
        {"Cert C: EXP35-C",""},
        {"Cert C: EXP36-C",""},
        {"Cert C: EXP37-C",""},
        {"Cert C: EXP39-C",""},
        {"Cert C: EXP40-C",""},
        {"Cert C: EXP42-C",""},
        {"Cert C: EXP43-C",""},
        {"Cert C: EXP44-C",""},
        {"Cert C: EXP45-C",""},
        {"Cert C: FIO30-C",""},
        {"Cert C: FIO32-C",""},
        {"Cert C: FIO34-C",""},
        {"Cert C: FIO37-C",""},
        {"Cert C: FIO38-C",""},
        {"Cert C: FIO40-C",""},
        {"Cert C: FIO41-C",""},
        {"Cert C: FIO44-C",""},
        {"Cert C: FIO45-C",""},
        {"Cert C: FLP30-C",""},
        {"Cert C: FLP36-C","portability"},
        {"Cert C: FLP37-C",""},
        {"Cert C: INT17-C",""},
        {"Cert C: INT30-C",""},
        {"Cert C: INT31-C",""},
        {"Cert C: INT32-C",""},
        {"Cert C: INT33-C",""},
        {"Cert C: INT34-C",""},
        {"Cert C: INT35-C",""},
        {"Cert C: INT36-C",""},
        {"Cert C: MEM33-C",""},
        {"Cert C: MEM35-C",""},
        {"Cert C: MEM36-C",""},
        {"Cert C: MSC30-C",""},
        {"Cert C: MSC32-C",""},
        {"Cert C: MSC33-C",""},
        {"Cert C: MSC38-C",""},
        {"Cert C: MSC39-C",""},
        {"Cert C: MSC40-C",""},
        {"Cert C: MSC41-C",""},
        {"Cert C: PRE00-C",""},
        {"Cert C: PRE01-C",""},
        {"Cert C: PRE02-C",""},
        {"Cert C: PRE04-C",""},
        {"Cert C: PRE05-C",""},
        {"Cert C: PRE06-C",""},
        {"Cert C: PRE07-C",""},
        {"Cert C: PRE08-C",""},
        {"Cert C: PRE09-C",""},
        {"Cert C: PRE10-C",""},
        {"Cert C: PRE11-C",""},
        {"Cert C: PRE12-C",""},
        {"Cert C: PRE31-C",""},
        {"Cert C: SIG30-C",""},
        {"Cert C: SIG31-C",""},
        {"Cert C: SIG34-C",""},
        {"Cert C: SIG35-C",""},
        {"Cert C: STR30-C",""},
        {"Cert C: STR31-C",""},
        {"Cert C: STR32-C",""},
        {"Cert C: STR34-C",""},
        {"Cert C: STR38-C",""},
        {"Misra C++ 2008: 3-2-3",""},
        {"Misra C++ 2008: 3-2-4",""},
        {"Misra C++ 2008: 7-5-4",""},
        {"Misra C++ 2008: M0-1-11",""},
        {"Misra C++ 2008: M0-1-12",""},
        {"Misra C++ 2008: M0-1-4",""},
        {"Misra C++ 2008: M0-1-5",""},
        {"Misra C++ 2008: M0-1-7",""},
        {"Misra C++ 2008: M0-1-8",""},
        {"Misra C++ 2008: M0-3-2",""},
        {"Misra C++ 2008: M1-0-1","portability"},
        {"Misra C++ 2008: M10-1-1",""},
        {"Misra C++ 2008: M10-1-2",""},
        {"Misra C++ 2008: M10-1-3",""},
        {"Misra C++ 2008: M10-2-1",""},
        {"Misra C++ 2008: M10-3-1",""},
        {"Misra C++ 2008: M10-3-2",""},
        {"Misra C++ 2008: M10-3-3",""},
        {"Misra C++ 2008: M11-0-1",""},
        {"Misra C++ 2008: M12-1-2",""},
        {"Misra C++ 2008: M12-8-1",""},
        {"Misra C++ 2008: M12-8-2",""},
        {"Misra C++ 2008: M14-5-1","warning"},
        {"Misra C++ 2008: M14-5-2","warning"},
        {"Misra C++ 2008: M14-5-3","warning"},
        {"Misra C++ 2008: M14-6-1","warning"},
        {"Misra C++ 2008: M14-6-2","warning"},
        {"Misra C++ 2008: M14-7-1",""},
        {"Misra C++ 2008: M14-7-2",""},
        {"Misra C++ 2008: M14-7-3",""},
        {"Misra C++ 2008: M14-8-1",""},
        {"Misra C++ 2008: M14-8-2",""},
        {"Misra C++ 2008: M15-0-3",""},
        {"Misra C++ 2008: M15-1-1",""},
        {"Misra C++ 2008: M15-1-2",""},
        {"Misra C++ 2008: M15-1-3",""},
        {"Misra C++ 2008: M15-3-2","warning"},
        {"Misra C++ 2008: M15-3-3",""},
        {"Misra C++ 2008: M15-3-4",""},
        {"Misra C++ 2008: M15-3-6",""},
        {"Misra C++ 2008: M15-3-7",""},
        {"Misra C++ 2008: M15-4-1",""},
        {"Misra C++ 2008: M15-5-2",""},
        {"Misra C++ 2008: M16-0-1",""},
        {"Misra C++ 2008: M16-0-2",""},
        {"Misra C++ 2008: M16-0-3",""},
        {"Misra C++ 2008: M16-0-4",""},
        {"Misra C++ 2008: M16-0-6",""},
        {"Misra C++ 2008: M16-0-7",""},
        {"Misra C++ 2008: M16-0-8",""},
        {"Misra C++ 2008: M16-1-1",""},
        {"Misra C++ 2008: M16-1-2",""},
        {"Misra C++ 2008: M16-2-1",""},
        {"Misra C++ 2008: M16-2-2",""},
        {"Misra C++ 2008: M16-2-3",""},
        {"Misra C++ 2008: M16-2-4",""},
        {"Misra C++ 2008: M16-2-5",""},
        {"Misra C++ 2008: M16-2-6",""},
        {"Misra C++ 2008: M16-3-1",""},
        {"Misra C++ 2008: M16-3-2",""},
        {"Misra C++ 2008: M17-0-1",""},
        {"Misra C++ 2008: M17-0-2",""},
        {"Misra C++ 2008: M17-0-3",""},
        {"Misra C++ 2008: M17-0-5",""},
        {"Misra C++ 2008: M18-0-1",""},
        {"Misra C++ 2008: M18-0-2",""},
        {"Misra C++ 2008: M18-0-3",""},
        {"Misra C++ 2008: M18-0-4",""},
        {"Misra C++ 2008: M18-0-5",""},
        {"Misra C++ 2008: M18-2-1",""},
        {"Misra C++ 2008: M18-4-1",""},
        {"Misra C++ 2008: M18-7-1",""},
        {"Misra C++ 2008: M19-3-1",""},
        {"Misra C++ 2008: M2-10-1",""},
        {"Misra C++ 2008: M2-10-3",""},
        {"Misra C++ 2008: M2-10-4",""},
        {"Misra C++ 2008: M2-10-5",""},
        {"Misra C++ 2008: M2-10-6",""},
        {"Misra C++ 2008: M2-13-2",""},
        {"Misra C++ 2008: M2-13-3",""},
        {"Misra C++ 2008: M2-13-4",""},
        {"Misra C++ 2008: M2-13-5",""},
        {"Misra C++ 2008: M2-3-1",""},
        {"Misra C++ 2008: M2-7-1",""},
        {"Misra C++ 2008: M2-7-2",""},
        {"Misra C++ 2008: M2-7-3",""},
        {"Misra C++ 2008: M27-0-1",""},
        {"Misra C++ 2008: M3-1-1",""},
        {"Misra C++ 2008: M3-1-2",""},
        {"Misra C++ 2008: M3-1-3",""},
        {"Misra C++ 2008: M3-2-1",""},
        {"Misra C++ 2008: M3-3-1",""},
        {"Misra C++ 2008: M3-3-2",""},
        {"Misra C++ 2008: M3-9-1",""},
        {"Misra C++ 2008: M3-9-2",""},
        {"Misra C++ 2008: M3-9-3",""},
        {"Misra C++ 2008: M4-10-1",""},
        {"Misra C++ 2008: M4-10-2",""},
        {"Misra C++ 2008: M4-5-1",""},
        {"Misra C++ 2008: M4-5-2",""},
        {"Misra C++ 2008: M4-5-3",""},
        {"Misra C++ 2008: M5-0-10",""},
        {"Misra C++ 2008: M5-0-11",""},
        {"Misra C++ 2008: M5-0-12",""},
        {"Misra C++ 2008: M5-0-14",""},
        {"Misra C++ 2008: M5-0-15",""},
        {"Misra C++ 2008: M5-0-2",""},
        {"Misra C++ 2008: M5-0-20",""},
        {"Misra C++ 2008: M5-0-21",""},
        {"Misra C++ 2008: M5-0-3",""},
        {"Misra C++ 2008: M5-0-4",""},
        {"Misra C++ 2008: M5-0-5",""},
        {"Misra C++ 2008: M5-0-6",""},
        {"Misra C++ 2008: M5-0-7",""},
        {"Misra C++ 2008: M5-0-8",""},
        {"Misra C++ 2008: M5-0-9",""},
        {"Misra C++ 2008: M5-14-1",""},
        {"Misra C++ 2008: M5-17-1",""},
        {"Misra C++ 2008: M5-18-1",""},
        {"Misra C++ 2008: M5-19-1",""},
        {"Misra C++ 2008: M5-2-1",""},
        {"Misra C++ 2008: M5-2-10",""},
        {"Misra C++ 2008: M5-2-11",""},
        {"Misra C++ 2008: M5-2-12",""},
        {"Misra C++ 2008: M5-2-2",""},
        {"Misra C++ 2008: M5-2-3",""},
        {"Misra C++ 2008: M5-2-5",""},
        {"Misra C++ 2008: M5-2-6",""},
        {"Misra C++ 2008: M5-2-7",""},
        {"Misra C++ 2008: M5-2-8",""},
        {"Misra C++ 2008: M5-2-9",""},
        {"Misra C++ 2008: M5-3-1",""},
        {"Misra C++ 2008: M5-3-2",""},
        {"Misra C++ 2008: M5-3-3",""},
        {"Misra C++ 2008: M6-2-1",""},
        {"Misra C++ 2008: M6-2-2",""},
        {"Misra C++ 2008: M6-2-3",""},
        {"Misra C++ 2008: M6-3-1",""},
        {"Misra C++ 2008: M6-4-1",""},
        {"Misra C++ 2008: M6-4-2",""},
        {"Misra C++ 2008: M6-4-3",""},
        {"Misra C++ 2008: M6-4-4",""},
        {"Misra C++ 2008: M6-4-5",""},
        {"Misra C++ 2008: M6-4-6",""},
        {"Misra C++ 2008: M6-4-7",""},
        {"Misra C++ 2008: M6-4-8",""},
        {"Misra C++ 2008: M6-5-1",""},
        {"Misra C++ 2008: M6-5-2",""},
        {"Misra C++ 2008: M6-5-3",""},
        {"Misra C++ 2008: M6-5-4",""},
        {"Misra C++ 2008: M6-5-5",""},
        {"Misra C++ 2008: M6-5-6",""},
        {"Misra C++ 2008: M6-6-1",""},
        {"Misra C++ 2008: M6-6-2",""},
        {"Misra C++ 2008: M6-6-3",""},
        {"Misra C++ 2008: M6-6-4",""},
        {"Misra C++ 2008: M6-6-5",""},
        {"Misra C++ 2008: M7-2-1",""},
        {"Misra C++ 2008: M7-3-1",""},
        {"Misra C++ 2008: M7-3-2",""},
        {"Misra C++ 2008: M7-3-3",""},
        {"Misra C++ 2008: M7-3-4",""},
        {"Misra C++ 2008: M7-3-5",""},
        {"Misra C++ 2008: M7-3-6",""},
        {"Misra C++ 2008: M7-4-2",""},
        {"Misra C++ 2008: M7-4-3",""},
        {"Misra C++ 2008: M7-5-3",""},
        {"Misra C++ 2008: M8-0-1",""},
        {"Misra C++ 2008: M8-3-1",""},
        {"Misra C++ 2008: M8-4-4",""},
        {"Misra C++ 2008: M8-5-2",""},
        {"Misra C++ 2008: M8-5-3",""},
        {"Misra C++ 2008: M9-3-1",""},
        {"Misra C++ 2008: M9-5-1",""},
        {"Misra C++ 2008: M9-6-2",""},
        {"Misra C++ 2008: M9-6-3",""},
        {"Misra C++ 2008: M9-6-4",""},
        {"Misra C++ 2023: 0.1.2",""},
        {"Misra C++ 2023: 0.2.1",""},
        {"Misra C++ 2023: 0.2.2",""},
        {"Misra C++ 2023: 0.2.3",""},
        {"Misra C++ 2023: 0.2.4",""},
        {"Misra C++ 2023: 10.0.1",""},
        {"Misra C++ 2023: 10.1.2",""},
        {"Misra C++ 2023: 10.2.1",""},
        {"Misra C++ 2023: 10.2.2",""},
        {"Misra C++ 2023: 10.2.3",""},
        {"Misra C++ 2023: 10.3.1",""},
        {"Misra C++ 2023: 10.4.1",""},
        {"Misra C++ 2023: 11.3.1",""},
        {"Misra C++ 2023: 11.3.2",""},
        {"Misra C++ 2023: 11.6.1",""},
        {"Misra C++ 2023: 11.6.3",""},
        {"Misra C++ 2023: 12.2.1",""},
        {"Misra C++ 2023: 12.2.2",""},
        {"Misra C++ 2023: 12.2.3",""},
        {"Misra C++ 2023: 12.3.1",""},
        {"Misra C++ 2023: 13.1.1",""},
        {"Misra C++ 2023: 13.1.2",""},
        {"Misra C++ 2023: 13.3.1",""},
        {"Misra C++ 2023: 13.3.2",""},
        {"Misra C++ 2023: 13.3.3",""},
        {"Misra C++ 2023: 13.3.4",""},
        {"Misra C++ 2023: 14.1.1",""},
        {"Misra C++ 2023: 15.0.1",""},
        {"Misra C++ 2023: 15.0.2",""},
        {"Misra C++ 2023: 15.1.2",""},
        {"Misra C++ 2023: 15.1.3",""},
        {"Misra C++ 2023: 15.1.5",""},
        {"Misra C++ 2023: 16.5.1",""},
        {"Misra C++ 2023: 16.5.2",""},
        {"Misra C++ 2023: 16.6.1",""},
        {"Misra C++ 2023: 17.8.1",""},
        {"Misra C++ 2023: 18.1.1",""},
        {"Misra C++ 2023: 18.1.2",""},
        {"Misra C++ 2023: 18.3.1",""},
        {"Misra C++ 2023: 18.3.2",""},
        {"Misra C++ 2023: 18.3.3",""},
        {"Misra C++ 2023: 18.4.1",""},
        {"Misra C++ 2023: 18.5.1",""},
        {"Misra C++ 2023: 18.5.2",""},
        {"Misra C++ 2023: 19.0.1",""},
        {"Misra C++ 2023: 19.0.2",""},
        {"Misra C++ 2023: 19.0.3",""},
        {"Misra C++ 2023: 19.0.4",""},
        {"Misra C++ 2023: 19.1.1",""},
        {"Misra C++ 2023: 19.1.2",""},
        {"Misra C++ 2023: 19.1.3",""},
        {"Misra C++ 2023: 19.2.1",""},
        {"Misra C++ 2023: 19.2.2",""},
        {"Misra C++ 2023: 19.2.3",""},
        {"Misra C++ 2023: 19.3.1",""},
        {"Misra C++ 2023: 19.3.2",""},
        {"Misra C++ 2023: 19.3.3",""},
        {"Misra C++ 2023: 19.3.4",""},
        {"Misra C++ 2023: 19.6.1",""},
        {"Misra C++ 2023: 21.10.1",""},
        {"Misra C++ 2023: 21.10.2",""},
        {"Misra C++ 2023: 21.10.3",""},
        {"Misra C++ 2023: 21.2.1",""},
        {"Misra C++ 2023: 21.2.2",""},
        {"Misra C++ 2023: 21.2.3",""},
        {"Misra C++ 2023: 21.2.4",""},
        {"Misra C++ 2023: 21.6.1",""},
        {"Misra C++ 2023: 21.6.2",""},
        {"Misra C++ 2023: 21.6.3",""},
        {"Misra C++ 2023: 21.6.4",""},
        {"Misra C++ 2023: 21.6.5",""},
        {"Misra C++ 2023: 22.3.1",""},
        {"Misra C++ 2023: 22.4.1",""},
        {"Misra C++ 2023: 23.11.1",""},
        {"Misra C++ 2023: 24.5.1",""},
        {"Misra C++ 2023: 24.5.2",""},
        {"Misra C++ 2023: 25.5.1",""},
        {"Misra C++ 2023: 25.5.2",""},
        {"Misra C++ 2023: 25.5.3",""},
        {"Misra C++ 2023: 26.3.1",""},
        {"Misra C++ 2023: 28.3.1",""},
        {"Misra C++ 2023: 28.6.1",""},
        {"Misra C++ 2023: 28.6.2",""},
        {"Misra C++ 2023: 30.0.1",""},
        {"Misra C++ 2023: 30.0.2",""},
        {"Misra C++ 2023: 4.1.1",""},
        {"Misra C++ 2023: 4.1.2",""},
        {"Misra C++ 2023: 5.0.1",""},
        {"Misra C++ 2023: 5.10.1",""},
        {"Misra C++ 2023: 5.13.1",""},
        {"Misra C++ 2023: 5.13.2",""},
        {"Misra C++ 2023: 5.13.3",""},
        {"Misra C++ 2023: 5.13.4",""},
        {"Misra C++ 2023: 5.13.5",""},
        {"Misra C++ 2023: 5.13.6",""},
        {"Misra C++ 2023: 5.13.7",""},
        {"Misra C++ 2023: 5.7.1",""},
        {"Misra C++ 2023: 5.7.2",""},
        {"Misra C++ 2023: 5.7.3",""},
        {"Misra C++ 2023: 6.0.1",""},
        {"Misra C++ 2023: 6.0.2",""},
        {"Misra C++ 2023: 6.0.3",""},
        {"Misra C++ 2023: 6.0.4",""},
        {"Misra C++ 2023: 6.2.2",""},
        {"Misra C++ 2023: 6.2.3",""},
        {"Misra C++ 2023: 6.2.4",""},
        {"Misra C++ 2023: 6.4.2",""},
        {"Misra C++ 2023: 6.4.3",""},
        {"Misra C++ 2023: 6.5.1",""},
        {"Misra C++ 2023: 6.5.2",""},
        {"Misra C++ 2023: 6.7.1",""},
        {"Misra C++ 2023: 6.7.2",""},
        {"Misra C++ 2023: 6.8.3",""},
        {"Misra C++ 2023: 6.8.4",""},
        {"Misra C++ 2023: 6.9.1",""},
        {"Misra C++ 2023: 6.9.2",""},
        {"Misra C++ 2023: 7.0.1",""},
        {"Misra C++ 2023: 7.0.2",""},
        {"Misra C++ 2023: 7.0.3",""},
        {"Misra C++ 2023: 7.0.4",""},
        {"Misra C++ 2023: 7.0.5",""},
        {"Misra C++ 2023: 7.0.6",""},
        {"Misra C++ 2023: 7.11.1",""},
        {"Misra C++ 2023: 7.11.2",""},
        {"Misra C++ 2023: 7.11.3",""},
        {"Misra C++ 2023: 8.0.1",""},
        {"Misra C++ 2023: 8.1.1",""},
        {"Misra C++ 2023: 8.1.2",""},
        {"Misra C++ 2023: 8.14.1",""},
        {"Misra C++ 2023: 8.18.2",""},
        {"Misra C++ 2023: 8.19.1",""},
        {"Misra C++ 2023: 8.2.1",""},
        {"Misra C++ 2023: 8.2.10",""},
        {"Misra C++ 2023: 8.2.11",""},
        {"Misra C++ 2023: 8.2.2",""},
        {"Misra C++ 2023: 8.2.3",""},
        {"Misra C++ 2023: 8.2.4",""},
        {"Misra C++ 2023: 8.2.5",""},
        {"Misra C++ 2023: 8.2.6",""},
        {"Misra C++ 2023: 8.2.7",""},
        {"Misra C++ 2023: 8.2.8",""},
        {"Misra C++ 2023: 8.2.9",""},
        {"Misra C++ 2023: 8.20.1",""},
        {"Misra C++ 2023: 8.3.1",""},
        {"Misra C++ 2023: 8.3.2",""},
        {"Misra C++ 2023: 9.2.1",""},
        {"Misra C++ 2023: 9.3.1",""},
        {"Misra C++ 2023: 9.4.1",""},
        {"Misra C++ 2023: 9.4.2",""},
        {"Misra C++ 2023: 9.5.1",""},
        {"Misra C++ 2023: 9.5.2",""},
        {"Misra C++ 2023: 9.6.1",""},
        {"Misra C++ 2023: 9.6.2",""},
        {"Misra C++ 2023: 9.6.3",""},
        {"Misra C++ 2023: 9.6.4",""},
        {"Misra C: 1.2",""},
        {"Misra C: 1.4",""},
        {"Misra C: 1.5",""},
        {"Misra C: 10.1",""},
        {"Misra C: 10.2",""},
        {"Misra C: 10.3",""},
        {"Misra C: 10.4",""},
        {"Misra C: 10.5",""},
        {"Misra C: 10.6",""},
        {"Misra C: 10.7",""},
        {"Misra C: 10.8",""},
        {"Misra C: 11.1",""},
        {"Misra C: 11.10",""},
        {"Misra C: 11.11",""},
        {"Misra C: 11.2",""},
        {"Misra C: 11.3",""},
        {"Misra C: 11.4",""},
        {"Misra C: 11.5",""},
        {"Misra C: 11.6",""},
        {"Misra C: 11.7",""},
        {"Misra C: 11.8",""},
        {"Misra C: 11.9",""},
        {"Misra C: 12.1",""},
        {"Misra C: 12.2",""},
        {"Misra C: 12.3",""},
        {"Misra C: 12.4",""},
        {"Misra C: 12.6",""},
        {"Misra C: 13.1",""},
        {"Misra C: 13.2",""},
        {"Misra C: 13.3",""},
        {"Misra C: 13.4",""},
        {"Misra C: 13.5",""},
        {"Misra C: 13.6",""},
        {"Misra C: 14.1",""},
        {"Misra C: 14.2",""},
        {"Misra C: 14.4",""},
        {"Misra C: 15.1",""},
        {"Misra C: 15.2",""},
        {"Misra C: 15.3",""},
        {"Misra C: 15.4",""},
        {"Misra C: 15.5",""},
        {"Misra C: 15.6",""},
        {"Misra C: 15.7",""},
        {"Misra C: 16.1",""},
        {"Misra C: 16.2",""},
        {"Misra C: 16.3",""},
        {"Misra C: 16.4",""},
        {"Misra C: 16.5",""},
        {"Misra C: 16.6",""},
        {"Misra C: 16.7",""},
        {"Misra C: 17.1",""},
        {"Misra C: 17.10",""},
        {"Misra C: 17.11",""},
        {"Misra C: 17.12",""},
        {"Misra C: 17.13",""},
        {"Misra C: 17.2",""},
        {"Misra C: 17.3",""},
        {"Misra C: 17.4",""},
        {"Misra C: 17.6",""},
        {"Misra C: 17.7",""},
        {"Misra C: 17.8",""},
        {"Misra C: 17.9",""},
        {"Misra C: 18.10",""},
        {"Misra C: 18.4",""},
        {"Misra C: 18.5",""},
        {"Misra C: 18.7",""},
        {"Misra C: 18.8",""},
        {"Misra C: 18.9",""},
        {"Misra C: 19.2",""},
        {"Misra C: 19.3",""},
        {"Misra C: 2.2",""},
        {"Misra C: 2.7",""},
        {"Misra C: 20.1",""},
        {"Misra C: 20.10",""},
        {"Misra C: 20.11",""},
        {"Misra C: 20.12",""},
        {"Misra C: 20.13",""},
        {"Misra C: 20.14",""},
        {"Misra C: 20.15",""},
        {"Misra C: 20.2",""},
        {"Misra C: 20.3",""},
        {"Misra C: 20.4",""},
        {"Misra C: 20.5",""},
        {"Misra C: 20.7",""},
        {"Misra C: 20.8",""},
        {"Misra C: 20.9",""},
        {"Misra C: 21.1",""},
        {"Misra C: 21.10",""},
        {"Misra C: 21.11",""},
        {"Misra C: 21.12",""},
        {"Misra C: 21.14",""},
        {"Misra C: 21.15",""},
        {"Misra C: 21.16",""},
        {"Misra C: 21.18",""},
        {"Misra C: 21.19",""},
        {"Misra C: 21.2",""},
        {"Misra C: 21.20",""},
        {"Misra C: 21.21",""},
        {"Misra C: 21.22",""},
        {"Misra C: 21.23",""},
        {"Misra C: 21.24",""},
        {"Misra C: 21.25","warning"},
        {"Misra C: 21.26","warning"},
        {"Misra C: 21.3",""},
        {"Misra C: 21.4",""},
        {"Misra C: 21.5",""},
        {"Misra C: 21.6",""},
        {"Misra C: 21.7",""},
        {"Misra C: 21.8",""},
        {"Misra C: 21.9",""},
        {"Misra C: 22.10",""},
        {"Misra C: 22.11",""},
        {"Misra C: 22.12",""},
        {"Misra C: 22.13",""},
        {"Misra C: 22.14",""},
        {"Misra C: 22.15",""},
        {"Misra C: 22.16","warning"},
        {"Misra C: 22.17","warning"},
        {"Misra C: 22.18","warning"},
        {"Misra C: 22.19","warning"},
        {"Misra C: 22.20",""},
        {"Misra C: 22.5",""},
        {"Misra C: 22.7",""},
        {"Misra C: 22.8",""},
        {"Misra C: 22.9",""},
        {"Misra C: 23.1",""},
        {"Misra C: 23.2",""},
        {"Misra C: 23.3",""},
        {"Misra C: 23.4",""},
        {"Misra C: 23.5",""},
        {"Misra C: 23.6",""},
        {"Misra C: 23.7",""},
        {"Misra C: 23.8",""},
        {"Misra C: 3.1",""},
        {"Misra C: 3.2",""},
        {"Misra C: 4.1",""},
        {"Misra C: 4.2",""},
        {"Misra C: 5.1",""},
        {"Misra C: 5.10",""},
        {"Misra C: 5.2",""},
        {"Misra C: 5.3",""},
        {"Misra C: 5.4",""},
        {"Misra C: 5.5",""},
        {"Misra C: 5.6",""},
        {"Misra C: 5.7",""},
        {"Misra C: 6.1",""},
        {"Misra C: 6.2",""},
        {"Misra C: 6.3",""},
        {"Misra C: 7.1",""},
        {"Misra C: 7.2",""},
        {"Misra C: 7.3",""},
        {"Misra C: 7.4","style"},
        {"Misra C: 7.5",""},
        {"Misra C: 7.6",""},
        {"Misra C: 8.1",""},
        {"Misra C: 8.10",""},
        {"Misra C: 8.11",""},
        {"Misra C: 8.12",""},
        {"Misra C: 8.14",""},
        {"Misra C: 8.15",""},
        {"Misra C: 8.16",""},
        {"Misra C: 8.17",""},
        {"Misra C: 8.18",""},
        {"Misra C: 8.19",""},
        {"Misra C: 8.2",""},
        {"Misra C: 8.3",""},
        {"Misra C: 8.4",""},
        {"Misra C: 8.5",""},
        {"Misra C: 8.6",""},
        {"Misra C: 8.7",""},
        {"Misra C: 8.8",""},
        {"Misra C: 8.9",""},
        {"Misra C: 9.2",""},
        {"Misra C: 9.3",""},
        {"Misra C: 9.4",""},
        {"Misra C: 9.5",""},
        {"Misra C: 9.6",""},
        {"Misra C: 9.7",""},
        {"Misra C: Dir 1.2",""},
        {"Misra C: Dir 4.12",""},
        {"Misra C: Dir 4.3",""},
        {"Misra C: Dir 4.4",""},
        {"Misra C: Dir 4.5",""},
        {"Misra C: Dir 4.6",""},
        {"Misra C: Dir 4.7",""},
        {"Misra C: Dir 4.9",""},
        {"PremiumCheckBufferOverrun::addressOfPointerArithmetic","warning"},
        {"PremiumCheckBufferOverrun::negativeBufferSizeCheckedNonZero","warning"},
        {"PremiumCheckHang::infiniteLoop",""},
        {"PremiumCheckHang::infiniteLoopContinue",""},
        {"PremiumCheckOther::arrayPointerComparison","style"},
        {"PremiumCheckOther::invalidPointerLiteral",""},
        {"PremiumCheckOther::knownResult","style"},
        {"PremiumCheckOther::lossOfPrecision","style"},
        {"PremiumCheckOther::pointerCast","style"},
        {"PremiumCheckOther::reassignInLoop","style"},
        {"PremiumCheckOther::unreachableCode","style"},
        {"PremiumCheckOther::useAfterFree",""},
        {"PremiumCheckStrictAlias::strictAliasCondition","warning"},
        {"PremiumCheckUninitVar::uninitmember",""},
        {"PremiumCheckUninitVar::uninitvar",""},
        {"PremiumCheckUnusedVar::unreadVariable","style"},
        {"PremiumCheckUnusedVar::unusedPrivateMember","style"},
        {"PremiumMetrics::HIS::Call",""},
        {"PremiumMetrics::HIS::Calling",""},
        {"PremiumMetrics::HIS::Comment",""},
        {"PremiumMetrics::HIS::Goto",""},
        {"PremiumMetrics::HIS::Level",""},
        {"PremiumMetrics::HIS::Param",""},
        {"PremiumMetrics::HIS::Path",""},
        {"PremiumMetrics::HIS::Stmt",""},
        {"PremiumMetrics::HIS::StmtFile",""},
        {"PremiumMetrics::HIS::VOCF",""},
        {"PremiumMetrics::HIS::return",""},
        {"PremiumMetrics::cyclomaticComplexity",""},
    };

    const char Req[] = "Required";
    const char Adv[] = "Advisory";
    const char Man[] = "Mandatory";
    const char Doc[] = "Document";
    const char Dis[] = "Disapplied";
    const std::vector<MisraInfo> misraC2012Directives{
        {1,1,Req,0},
        {2,1,Req,0},
        {3,1,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {4,3,Req,0},
        {4,4,Adv,0},
        {4,5,Adv,0},
        {4,6,Adv,3},
        {4,7,Req,0},
        {4,8,Adv,0},
        {4,9,Adv,3},
        {4,10,Req,0},
        {4,11,Req,3},
        {4,12,Req,0},
        {4,13,Adv,0},
        {4,14,Req,2},
        {4,15,Req,3},
        {5,1,Req,4},
        {5,2,Req,4},
        {5,3,Req,4},
    };
    const std::vector<MisraInfo> misraC2012Rules{
        {1,1,Req,0},
        {1,2,Adv,0},
        {1,3,Req,0},
        {1,4,Req,2}, // Amendment 2
        {1,5,Req,3}, // Amendment 3
        {2,1,Req,0},
        {2,2,Req,0},
        {2,3,Adv,0},
        {2,4,Adv,0},
        {2,5,Adv,0},
        {2,6,Adv,0},
        {2,7,Adv,0},
        {2,8,Adv,0},
        {3,1,Req,0},
        {3,2,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {5,1,Req,0},
        {5,2,Req,0},
        {5,3,Req,0},
        {5,4,Req,0},
        {5,5,Req,0},
        {5,6,Req,0},
        {5,7,Req,0},
        {5,8,Req,0},
        {5,9,Adv,0},
        {6,1,Req,0},
        {6,2,Req,0},
        {6,3,Req,0},
        {7,1,Req,0},
        {7,2,Req,0},
        {7,3,Req,0},
        {7,4,Req,0},
        {7,5,Man,0},
        {7,6,Req,0},
        {8,1,Req,0},
        {8,2,Req,0},
        {8,3,Req,0},
        {8,4,Req,0},
        {8,5,Req,0},
        {8,6,Req,0},
        {8,7,Adv,0},
        {8,8,Req,0},
        {8,9,Adv,0},
        {8,10,Req,0},
        {8,11,Adv,0},
        {8,12,Req,0},
        {8,13,Adv,0},
        {8,14,Req,0},
        {8,15,Req,0},
        {8,16,Adv,0},
        {8,17,Adv,0},
        {9,1,Man,0},
        {9,2,Req,0},
        {9,3,Req,0},
        {9,4,Req,0},
        {9,5,Req,0},
        {9,6,Req,0},
        {9,7,Man,0},
        {10,1,Req,0},
        {10,2,Req,0},
        {10,3,Req,0},
        {10,4,Req,0},
        {10,5,Adv,0},
        {10,6,Req,0},
        {10,7,Req,0},
        {10,8,Req,0},
        {11,1,Req,0},
        {11,2,Req,0},
        {11,3,Req,0},
        {11,4,Adv,0},
        {11,5,Adv,0},
        {11,6,Req,0},
        {11,7,Req,0},
        {11,8,Req,0},
        {11,9,Req,0},
        {11,10,Req,0},
        {12,1,Adv,0},
        {12,2,Req,0},
        {12,3,Adv,0},
        {12,4,Adv,0},
        {12,5,Man,1}, // Amendment 1
        {12,6,Req,4}, // Amendment 4
        {13,1,Req,0},
        {13,2,Req,0},
        {13,3,Adv,0},
        {13,4,Adv,0},
        {13,5,Req,0},
        {13,6,Req,0},
        {14,1,Req,0},
        {14,2,Req,0},
        {14,3,Req,0},
        {14,4,Req,0},
        {15,1,Adv,0},
        {15,2,Req,0},
        {15,3,Req,0},
        {15,4,Adv,0},
        {15,5,Adv,0},
        {15,6,Req,0},
        {15,7,Req,0},
        {16,1,Req,0},
        {16,2,Req,0},
        {16,3,Req,0},
        {16,4,Req,0},
        {16,5,Req,0},
        {16,6,Req,0},
        {16,7,Req,0},
        {17,1,Req,0},
        {17,2,Req,0},
        {17,3,Man,0},
        {17,4,Man,0},
        {17,5,Req,0},
        {17,6,Man,0},
        {17,7,Req,0},
        {17,8,Adv,0},
        {17,9,Man,0},
        {17,10,Req,0},
        {17,11,Adv,0},
        {17,12,Adv,0},
        {17,13,Req,0},
        {18,1,Req,0},
        {18,2,Req,0},
        {18,3,Req,0},
        {18,4,Adv,0},
        {18,5,Adv,0},
        {18,6,Req,0},
        {18,7,Req,0},
        {18,8,Req,0},
        {18,9,Req,0},
        {18,10,Man,0},
        {19,1,Man,0},
        {19,2,Adv,0},
        {20,1,Adv,0},
        {20,2,Req,0},
        {20,3,Req,0},
        {20,4,Req,0},
        {20,5,Adv,0},
        {20,6,Req,0},
        {20,7,Req,0},
        {20,8,Req,0},
        {20,9,Req,0},
        {20,10,Adv,0},
        {20,11,Req,0},
        {20,12,Req,0},
        {20,13,Req,0},
        {20,14,Req,0},
        {21,1,Req,0},
        {21,2,Req,0},
        {21,3,Req,0},
        {21,4,Req,0},
        {21,5,Req,0},
        {21,6,Req,0},
        {21,7,Req,0},
        {21,8,Req,0},
        {21,9,Req,0},
        {21,10,Req,0},
        {21,11,Adv,0},
        {21,12,Req,0},
        {21,13,Man,1}, // Amendment 1
        {21,14,Req,1}, // Amendment 1
        {21,15,Req,1}, // Amendment 1
        {21,16,Req,1}, // Amendment 1
        {21,17,Man,1}, // Amendment 1
        {21,18,Man,1}, // Amendment 1
        {21,19,Man,1}, // Amendment 1
        {21,20,Man,1}, // Amendment 1
        {21,21,Req,3}, // Amendment 3
        {21,22,Man,3}, // Amendment 3
        {21,23,Req,3}, // Amendment 3
        {21,24,Req,3}, // Amendment 3
        {21,25,Req,4}, // Amendment 4
        {21,26,Req,4}, // Amendment 4
        {22,1,Req,0},
        {22,2,Man,0},
        {22,3,Req,0},
        {22,4,Man,0},
        {22,5,Man,0},
        {22,6,Man,0},
        {22,7,Req,1}, // Amendment 1
        {22,8,Req,1}, // Amendment 1
        {22,9,Req,1}, // Amendment 1
        {22,10,Req,1}, // Amendment 1
        {22,11,Req,4}, // Amendment 4
        {22,12,Man,4}, // Amendment 4
        {22,13,Req,4}, // Amendment 4
        {22,14,Req,4}, // Amendment 4
        {22,15,Req,4}, // Amendment 4
        {22,16,Req,4}, // Amendment 4
        {22,17,Req,4}, // Amendment 4
        {22,18,Req,4}, // Amendment 4
        {22,19,Req,4}, // Amendment 4
        {22,20,Man,4}, // Amendment 4
        {23,1,Adv,3}, // Amendment 3
        {23,2,Req,3}, // Amendment 3
        {23,3,Adv,3}, // Amendment 3
        {23,4,Req,3}, // Amendment 3
        {23,5,Adv,3}, // Amendment 3
        {23,6,Req,3}, // Amendment 3
        {23,7,Adv,3}, // Amendment 3
        {23,8,Req,3}, // Amendment 3
    };
    const std::vector<MisraInfo> misraC2023Directives{
        {1,1,Req,0},
        {2,1,Req,0},
        {3,1,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {4,3,Req,0},
        {4,4,Adv,0},
        {4,5,Adv,0},
        {4,6,Adv,0},
        {4,7,Req,0},
        {4,8,Adv,0},
        {4,9,Adv,0},
        {4,10,Req,0},
        {4,11,Req,0},
        {4,12,Req,0},
        {4,13,Adv,0},
        {4,14,Req,0},
        {4,15,Req,0},
        {5,1,Req,0},
        {5,2,Req,0},
        {5,3,Req,0},
    };
    const std::vector<MisraInfo> misraC2023Rules{
        {1,1,Req,0},
        {1,2,Adv,0},
        {1,3,Req,0},
        {1,4,Req,0},
        {1,5,Req,0},
        {2,1,Req,0},
        {2,2,Req,0},
        {2,3,Adv,0},
        {2,4,Adv,0},
        {2,5,Adv,0},
        {2,6,Adv,0},
        {2,7,Adv,0},
        {2,8,Adv,0},
        {3,1,Req,0},
        {3,2,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {5,1,Req,0},
        {5,2,Req,0},
        {5,3,Req,0},
        {5,4,Req,0},
        {5,5,Req,0},
        {5,6,Req,0},
        {5,7,Req,0},
        {5,8,Req,0},
        {5,9,Adv,0},
        {6,1,Req,0},
        {6,2,Req,0},
        {6,3,Req,0},
        {7,1,Req,0},
        {7,2,Req,0},
        {7,3,Req,0},
        {7,4,Req,0},
        {7,5,Man,0},
        {7,6,Req,0},
        {8,1,Req,0},
        {8,2,Req,0},
        {8,3,Req,0},
        {8,4,Req,0},
        {8,5,Req,0},
        {8,6,Req,0},
        {8,7,Adv,0},
        {8,8,Req,0},
        {8,9,Adv,0},
        {8,10,Req,0},
        {8,11,Adv,0},
        {8,12,Req,0},
        {8,13,Adv,0},
        {8,14,Req,0},
        {8,15,Req,0},
        {8,16,Adv,0},
        {8,17,Adv,0},
        {9,1,Man,0},
        {9,2,Req,0},
        {9,3,Req,0},
        {9,4,Req,0},
        {9,5,Req,0},
        {9,6,Req,0},
        {9,7,Man,0},
        {10,1,Req,0},
        {10,2,Req,0},
        {10,3,Req,0},
        {10,4,Req,0},
        {10,5,Adv,0},
        {10,6,Req,0},
        {10,7,Req,0},
        {10,8,Req,0},
        {11,1,Req,0},
        {11,2,Req,0},
        {11,3,Req,0},
        {11,4,Adv,0},
        {11,5,Adv,0},
        {11,6,Req,0},
        {11,7,Req,0},
        {11,8,Req,0},
        {11,9,Req,0},
        {11,10,Req,0},
        {12,1,Adv,0},
        {12,2,Req,0},
        {12,3,Adv,0},
        {12,4,Adv,0},
        {12,5,Man,0},
        {12,6,Req,0},
        {13,1,Req,0},
        {13,2,Req,0},
        {13,3,Adv,0},
        {13,4,Adv,0},
        {13,5,Req,0},
        {13,6,Req,0},
        {14,1,Req,0},
        {14,2,Req,0},
        {14,3,Req,0},
        {14,4,Req,0},
        {15,1,Adv,0},
        {15,2,Req,0},
        {15,3,Req,0},
        {15,4,Adv,0},
        {15,5,Adv,0},
        {15,6,Req,0},
        {15,7,Req,0},
        {16,1,Req,0},
        {16,2,Req,0},
        {16,3,Req,0},
        {16,4,Req,0},
        {16,5,Req,0},
        {16,6,Req,0},
        {16,7,Req,0},
        {17,1,Req,0},
        {17,2,Req,0},
        {17,3,Man,0},
        {17,4,Man,0},
        {17,5,Req,0},
        {17,6,Man,0},
        {17,7,Req,0},
        {17,8,Adv,0},
        {17,9,Man,0},
        {17,10,Req,0},
        {17,11,Adv,0},
        {17,12,Adv,0},
        {17,13,Req,0},
        {18,1,Req,0},
        {18,2,Req,0},
        {18,3,Req,0},
        {18,4,Adv,0},
        {18,5,Adv,0},
        {18,6,Req,0},
        {18,7,Req,0},
        {18,8,Req,0},
        {18,9,Req,0},
        {18,10,Man,0},
        {19,1,Man,0},
        {19,2,Adv,0},
        {20,1,Adv,0},
        {20,2,Req,0},
        {20,3,Req,0},
        {20,4,Req,0},
        {20,5,Adv,0},
        {20,6,Req,0},
        {20,7,Req,0},
        {20,8,Req,0},
        {20,9,Req,0},
        {20,10,Adv,0},
        {20,11,Req,0},
        {20,12,Req,0},
        {20,13,Req,0},
        {20,14,Req,0},
        {21,1,Req,0},
        {21,2,Req,0},
        {21,3,Req,0},
        {21,4,Req,0},
        {21,5,Req,0},
        {21,6,Req,0},
        {21,7,Req,0},
        {21,8,Req,0},
        {21,9,Req,0},
        {21,10,Req,0},
        {21,11,Adv,0},
        {21,12,Req,0},
        {21,13,Man,0},
        {21,14,Req,0},
        {21,15,Req,0},
        {21,16,Req,0},
        {21,17,Man,0},
        {21,18,Man,0},
        {21,19,Man,0},
        {21,20,Man,0},
        {21,21,Req,0},
        {21,22,Man,0},
        {21,23,Req,0},
        {21,24,Req,0},
        {21,25,Req,0},
        {21,26,Req,0},
        {22,1,Req,0},
        {22,2,Man,0},
        {22,3,Req,0},
        {22,4,Man,0},
        {22,5,Man,0},
        {22,6,Man,0},
        {22,7,Req,0},
        {22,8,Req,0},
        {22,9,Req,0},
        {22,10,Req,0},
        {22,11,Req,0},
        {22,12,Man,0},
        {22,13,Req,0},
        {22,14,Man,0},
        {22,15,Req,0},
        {22,16,Req,0},
        {22,17,Req,0},
        {22,18,Req,0},
        {22,19,Req,0},
        {22,20,Man,0},
        {23,1,Adv,0},
        {23,2,Req,0},
        {23,3,Adv,0},
        {23,4,Req,0},
        {23,5,Adv,0},
        {23,6,Req,0},
        {23,7,Adv,0},
        {23,8,Req,0},
    };
    const std::vector<MisraInfo> misraC2025Directives{
        {1,1,Req,0},
        {1,2,Adv,0},
        {2,1,Req,0},
        {3,1,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {4,3,Req,0},
        {4,4,Adv,0},
        {4,5,Adv,0},
        {4,6,Adv,0},
        {4,7,Req,0},
        {4,8,Adv,0},
        {4,9,Adv,0},
        {4,10,Req,0},
        {4,11,Req,0},
        {4,12,Req,0},
        {4,13,Adv,0},
        {4,14,Req,0},
        {4,15,Req,0},
        {5,1,Req,0},
        {5,2,Req,0},
        {5,3,Req,0},
    };
    const std::vector<MisraInfo> misraC2025Rules{
        {1,1,Req,0},
        {1,3,Req,0},
        {1,4,Req,0},
        {1,5,Req,0},
        {2,1,Req,0},
        {2,2,Req,0},
        {2,3,Adv,0},
        {2,4,Adv,0},
        {2,5,Adv,0},
        {2,6,Adv,0},
        {2,7,Adv,0},
        {2,8,Adv,0},
        {3,1,Req,0},
        {3,2,Req,0},
        {4,1,Req,0},
        {4,2,Adv,0},
        {5,1,Req,0},
        {5,2,Req,0},
        {5,3,Req,0},
        {5,4,Req,0},
        {5,5,Req,0},
        {5,6,Req,0},
        {5,7,Req,0},
        {5,8,Req,0},
        {5,9,Adv,0},
        {5,10,Req,0},
        {6,1,Req,0},
        {6,2,Req,0},
        {6,3,Req,0},
        {7,1,Req,0},
        {7,2,Req,0},
        {7,3,Req,0},
        {7,4,Req,0},
        {7,5,Man,0},
        {7,6,Req,0},
        {8,1,Req,0},
        {8,2,Req,0},
        {8,3,Req,0},
        {8,4,Req,0},
        {8,5,Req,0},
        {8,6,Req,0},
        {8,7,Adv,0},
        {8,8,Req,0},
        {8,9,Adv,0},
        {8,10,Req,0},
        {8,11,Adv,0},
        {8,12,Req,0},
        {8,13,Adv,0},
        {8,14,Req,0},
        {8,15,Req,0},
        {8,16,Adv,0},
        {8,17,Adv,0},
        {8,18,Req,0},
        {8,19,Adv,0},
        {9,1,Man,0},
        {9,2,Req,0},
        {9,3,Req,0},
        {9,4,Req,0},
        {9,5,Req,0},
        {9,6,Req,0},
        {9,7,Man,0},
        {10,1,Req,0},
        {10,2,Req,0},
        {10,3,Req,0},
        {10,4,Req,0},
        {10,5,Adv,0},
        {10,6,Req,0},
        {10,7,Req,0},
        {10,8,Req,0},
        {11,1,Req,0},
        {11,2,Req,0},
        {11,3,Req,0},
        {11,4,Req,0},
        {11,5,Adv,0},
        {11,6,Req,0},
        {11,8,Req,0},
        {11,9,Req,0},
        {11,10,Req,0},
        {11,11,Req,0},
        {12,1,Adv,0},
        {12,2,Req,0},
        {12,3,Adv,0},
        {12,4,Adv,0},
        {12,5,Man,0},
        {12,6,Req,0},
        {13,1,Req,0},
        {13,2,Req,0},
        {13,3,Adv,0},
        {13,4,Adv,0},
        {13,5,Req,0},
        {13,6,Req,0},
        {14,1,Req,0},
        {14,2,Req,0},
        {14,3,Req,0},
        {14,4,Req,0},
        {15,1,Adv,0},
        {15,2,Req,0},
        {15,3,Req,0},
        {15,4,Adv,0},
        {15,5,Dis,0},
        {15,6,Req,0},
        {15,7,Req,0},
        {16,1,Req,0},
        {16,2,Req,0},
        {16,3,Req,0},
        {16,4,Req,0},
        {16,5,Req,0},
        {16,6,Req,0},
        {16,7,Req,0},
        {17,1,Req,0},
        {17,2,Req,0},
        {17,3,Man,0},
        {17,4,Man,0},
        {17,5,Req,0},
        {17,7,Req,0},
        {17,8,Adv,0},
        {17,9,Man,0},
        {17,10,Req,0},
        {17,11,Adv,0},
        {17,12,Adv,0},
        {17,13,Req,0},
        {18,1,Req,0},
        {18,2,Req,0},
        {18,3,Req,0},
        {18,4,Adv,0},
        {18,5,Adv,0},
        {18,6,Req,0},
        {18,7,Req,0},
        {18,8,Req,0},
        {18,9,Req,0},
        {18,10,Man,0},
        {19,1,Man,0},
        {19,2,Adv,0},
        {19,3,Req,0},
        {20,1,Adv,0},
        {20,2,Req,0},
        {20,3,Req,0},
        {20,4,Req,0},
        {20,5,Adv,0},
        {20,6,Req,0},
        {20,7,Req,0},
        {20,8,Req,0},
        {20,9,Req,0},
        {20,10,Adv,0},
        {20,11,Req,0},
        {20,12,Req,0},
        {20,13,Req,0},
        {20,14,Req,0},
        {20,15,Req,0},
        {21,3,Req,0},
        {21,4,Req,0},
        {21,5,Req,0},
        {21,6,Req,0},
        {21,7,Req,0},
        {21,8,Req,0},
        {21,9,Req,0},
        {21,10,Req,0},
        {21,11,Adv,0},
        {21,12,Req,0},
        {21,13,Man,0},
        {21,14,Req,0},
        {21,15,Req,0},
        {21,16,Req,0},
        {21,17,Man,0},
        {21,18,Man,0},
        {21,19,Man,0},
        {21,20,Man,0},
        {21,21,Req,0},
        {21,22,Man,0},
        {21,23,Req,0},
        {21,24,Req,0},
        {21,25,Req,0},
        {21,26,Req,0},
        {22,1,Req,0},
        {22,2,Man,0},
        {22,3,Req,0},
        {22,4,Man,0},
        {22,5,Man,0},
        {22,6,Man,0},
        {22,7,Req,0},
        {22,8,Req,0},
        {22,9,Req,0},
        {22,10,Req,0},
        {22,11,Req,0},
        {22,12,Man,0},
        {22,13,Req,0},
        {22,14,Man,0},
        {22,15,Req,0},
        {22,16,Req,0},
        {22,17,Req,0},
        {22,18,Req,0},
        {22,19,Req,0},
        {22,20,Man,0},
        {23,1,Adv,0},
        {23,2,Req,0},
        {23,3,Adv,0},
        {23,4,Req,0},
        {23,5,Adv,0},
        {23,6,Req,0},
        {23,7,Adv,0},
        {23,8,Req,0},
    };

    const std::vector<MisraCppInfo> misraCpp2008Rules =
    {
        {0,1,1,Req},
        {0,1,2,Req},
        {0,1,3,Req},
        {0,1,4,Req},
        {0,1,5,Req},
        {0,1,6,Req},
        {0,1,7,Req},
        {0,1,8,Req},
        {0,1,9,Req},
        {0,1,10,Req},
        {0,1,11,Req},
        {0,1,12,Req},
        {0,2,1,Req},
        {0,3,1,Doc},
        {0,3,2,Req},
        {0,4,1,Doc},
        {0,4,2,Doc},
        {0,4,3,Doc},
        {1,0,1,Req},
        {1,0,2,Doc},
        {1,0,3,Doc},
        {2,2,1,Doc},
        {2,3,1,Req},
        {2,5,1,Adv},
        {2,7,1,Req},
        {2,7,2,Req},
        {2,7,3,Adv},
        {2,10,1,Req},
        {2,10,2,Req},
        {2,10,3,Req},
        {2,10,4,Req},
        {2,10,5,Adv},
        {2,10,6,Req},
        {2,13,1,Req},
        {2,13,2,Req},
        {2,13,3,Req},
        {2,13,4,Req},
        {2,13,5,Req},
        {3,1,1,Req},
        {3,1,2,Req},
        {3,1,3,Req},
        {3,2,1,Req},
        {3,2,2,Req},
        {3,2,3,Req},
        {3,2,4,Req},
        {3,3,1,Req},
        {3,3,2,Req},
        {3,4,1,Req},
        {3,9,1,Req},
        {3,9,2,Adv},
        {3,9,3,Req},
        {4,5,1,Req},
        {4,5,2,Req},
        {4,5,3,Req},
        {4,10,1,Req},
        {4,10,2,Req},
        {5,0,1,Req},
        {5,0,2,Adv},
        {5,0,3,Req},
        {5,0,4,Req},
        {5,0,5,Req},
        {5,0,6,Req},
        {5,0,7,Req},
        {5,0,8,Req},
        {5,0,9,Req},
        {5,0,10,Req},
        {5,0,11,Req},
        {5,0,12,Req},
        {5,0,13,Req},
        {5,0,14,Req},
        {5,0,15,Req},
        {5,0,16,Req},
        {5,0,17,Req},
        {5,0,18,Req},
        {5,0,19,Req},
        {5,0,20,Req},
        {5,0,21,Req},
        {5,2,1,Req},
        {5,2,2,Req},
        {5,2,3,Adv},
        {5,2,4,Req},
        {5,2,5,Req},
        {5,2,6,Req},
        {5,2,7,Req},
        {5,2,8,Req},
        {5,2,9,Adv},
        {5,2,10,Adv},
        {5,2,11,Req},
        {5,2,12,Req},
        {5,3,1,Req},
        {5,3,2,Req},
        {5,3,3,Req},
        {5,3,4,Req},
        {5,8,1,Req},
        {5,14,1,Req},
        {5,17,1,Req},
        {5,18,1,Req},
        {5,19,1,Adv},
        {6,2,1,Req},
        {6,2,2,Req},
        {6,2,3,Req},
        {6,3,1,Req},
        {6,4,1,Req},
        {6,4,2,Req},
        {6,4,3,Req},
        {6,4,4,Req},
        {6,4,5,Req},
        {6,4,6,Req},
        {6,4,7,Req},
        {6,4,8,Req},
        {6,5,1,Req},
        {6,5,2,Req},
        {6,5,3,Req},
        {6,5,4,Req},
        {6,5,5,Req},
        {6,5,6,Req},
        {6,6,1,Req},
        {6,6,2,Req},
        {6,6,3,Req},
        {6,6,4,Req},
        {6,6,5,Req},
        {7,1,1,Req},
        {7,1,2,Req},
        {7,2,1,Req},
        {7,3,1,Req},
        {7,3,2,Req},
        {7,3,3,Req},
        {7,3,4,Req},
        {7,3,5,Req},
        {7,3,6,Req},
        {7,4,1,Doc},
        {7,4,2,Req},
        {7,4,3,Req},
        {7,5,1,Req},
        {7,5,2,Req},
        {7,5,3,Req},
        {7,5,4,Adv},
        {8,4,1,Req},
        {8,4,2,Req},
        {8,4,3,Req},
        {8,4,4,Req},
        {8,5,1,Req},
        {8,5,2,Req},
        {8,5,3,Req},
        {9,3,1,Req},
        {9,3,2,Req},
        {9,3,3,Req},
        {9,5,1,Req},
        {9,6,1,Doc},
        {9,6,2,Req},
        {9,6,3,Req},
        {9,6,4,Req},
        {10,1,1,Adv},
        {10,1,2,Req},
        {10,1,3,Req},
        {10,2,1,Adv},
        {10,3,1,Req},
        {10,3,2,Req},
        {10,3,3,Req},
        {11,0,1,Req},
        {12,1,1,Req},
        {12,1,2,Adv},
        {12,1,3,Req},
        {12,8,1,Req},
        {12,8,2,Req},
        {14,5,1,Req},
        {14,5,2,Req},
        {14,5,3,Req},
        {14,6,1,Req},
        {14,6,2,Req},
        {14,7,1,Req},
        {14,7,2,Req},
        {14,7,3,Req},
        {14,8,1,Req},
        {14,8,2,Req},
        {15,0,1,Req},
        {15,0,2,Req},
        {15,0,3,Req},
        {15,1,1,Req},
        {15,1,2,Req},
        {15,1,3,Req},
        {15,3,1,Req},
        {15,3,2,Adv},
        {15,3,3,Req},
        {15,3,4,Req},
        {15,3,5,Req},
        {15,3,6,Req},
        {15,3,7,Req},
        {15,4,1,Req},
        {15,5,1,Req},
        {15,5,2,Req},
        {15,5,3,Req},
        {16,0,1,Req},
        {16,0,2,Req},
        {16,0,3,Req},
        {16,0,4,Req},
        {16,0,5,Req},
        {16,0,6,Req},
        {16,0,7,Req},
        {16,0,8,Req},
        {16,1,1,Req},
        {16,1,2,Req},
        {16,2,1,Req},
        {16,2,2,Req},
        {16,2,3,Req},
        {16,2,4,Req},
        {16,2,5,Adv},
        {16,2,6,Req},
        {16,3,1,Req},
        {16,3,2,Adv},
        {16,6,1,Doc},
        {17,0,1,Req},
        {17,0,2,Req},
        {17,0,3,Req},
        {17,0,4,Doc},
        {17,0,5,Req},
        {18,0,1,Req},
        {18,0,2,Req},
        {18,0,3,Req},
        {18,0,4,Req},
        {18,0,5,Req},
        {18,2,1,Req},
        {18,4,1,Req},
        {18,7,1,Req},
        {19,3,1,Req},
        {27,0,1,Req}
    };

    const std::vector<MisraCppInfo> misraCpp2023Directives =
    {
        {0,3,1,Adv},
        {0,3,2,Req},
        {5,7,2,Adv},
        {15,8,1,Req},
    };

    const std::vector<MisraCppInfo> misraCpp2023Rules =
    {
        {0,0,1,Req},
        {0,0,2,Adv},
        {0,1,1,Adv},
        {0,1,2,Req},
        {0,2,1,Adv},
        {0,2,2,Req},
        {0,2,3,Adv},
        {0,2,4,Adv},
        {4,1,1,Req},
        {4,1,2,Adv},
        {4,1,3,Req},
        {4,6,1,Req},
        {5,0,1,Adv},
        {5,7,1,Req},
        {5,7,3,Req},
        {5,10,1,Req},
        {5,13,1,Req},
        {5,13,2,Req},
        {5,13,3,Req},
        {5,13,4,Req},
        {5,13,5,Req},
        {5,13,6,Req},
        {5,13,7,Req},
        {6,0,1,Req},
        {6,0,2,Adv},
        {6,0,3,Adv},
        {6,0,4,Req},
        {6,2,1,Req},
        {6,2,2,Req},
        {6,2,3,Req},
        {6,2,4,Req},
        {6,4,1,Req},
        {6,4,2,Req},
        {6,4,3,Req},
        {6,5,1,Adv},
        {6,5,2,Adv},
        {6,7,1,Req},
        {6,7,2,Req},
        {6,8,1,Req},
        {6,8,2,Man},
        {6,8,3,Req},
        {6,8,4,Adv},
        {6,9,1,Req},
        {6,9,2,Adv},
        {7,0,1,Req},
        {7,0,2,Req},
        {7,0,3,Req},
        {7,0,4,Req},
        {7,0,5,Req},
        {7,0,6,Req},
        {7,11,1,Req},
        {7,11,2,Req},
        {7,11,3,Req},
        {8,0,1,Adv},
        {8,1,1,Req},
        {8,1,2,Adv},
        {8,2,1,Req},
        {8,2,2,Req},
        {8,2,3,Req},
        {8,2,4,Req},
        {8,2,5,Req},
        {8,2,6,Req},
        {8,2,7,Adv},
        {8,2,8,Req},
        {8,2,9,Req},
        {8,2,10,Req},
        {8,2,11,Req},
        {8,3,1,Adv},
        {8,3,2,Adv},
        {8,7,1,Req},
        {8,7,2,Req},
        {8,9,1,Req},
        {8,14,1,Adv},
        {8,18,1,Man},
        {8,18,2,Adv},
        {8,19,1,Adv},
        {8,20,1,Adv},
        {9,2,1,Req},
        {9,3,1,Req},
        {9,4,1,Req},
        {9,4,2,Req},
        {9,5,2,Adv},
        {9,5,3,Req},
        {9,6,1,Adv},
        {9,6,2,Req},
        {9,6,3,Req},
        {9,6,4,Req},
        {9,6,5,Req},
        {10,0,1,Adv},
        {10,1,1,Adv},
        {10,1,2,Req},
        {10,2,1,Req},
        {10,2,2,Adv},
        {10,2,3,Req},
        {10,3,1,Adv},
        {10,4,1,Req},
        {11,3,1,Adv},
        {11,3,2,Adv},
        {11,6,1,Adv},
        {11,6,2,Man},
        {11,6,3,Req},
        {12,2,1,Adv},
        {12,2,2,Req},
        {12,2,3,Req},
        {12,3,1,Req},
        {13,1,1,Adv},
        {13,1,2,Req},
        {13,3,1,Req},
        {13,3,2,Req},
        {13,3,3,Req},
        {13,3,4,Req},
        {14,1,1,Adv},
        {15,0,1,Req},
        {15,0,2,Adv},
        {15,1,1,Req},
        {15,1,2,Adv},
        {15,1,3,Req},
        {15,1,4,Adv},
        {15,1,5,Req},
        {16,5,2,Req},
        {16,6,1,Adv},
        {17,8,1,Req},
        {18,1,1,Req},
        {18,1,2,Req},
        {18,3,1,Adv},
        {18,3,2,Req},
        {18,3,3,Req},
        {18,4,1,Req},
        {18,5,1,Adv},
        {18,5,2,Adv},
        {19,0,1,Req},
        {19,0,2,Req},
        {19,0,3,Adv},
        {19,0,4,Adv},
        {19,1,1,Req},
        {19,1,2,Req},
        {19,1,3,Req},
        {19,2,1,Req},
        {19,2,2,Req},
        {19,2,3,Req},
        {19,3,1,Adv},
        {19,3,2,Req},
        {19,3,3,Req},
        {19,3,4,Req},
        {19,3,5,Req},
        {19,6,1,Adv},
        {21,2,1,Req},
        {21,2,2,Req},
        {21,2,3,Req},
        {21,2,4,Req},
        {21,6,1,Adv},
        {21,6,2,Req},
        {21,6,3,Req},
        {21,6,4,Req},
        {21,6,5,Req},
        {21,10,1,Req},
        {21,10,2,Req},
        {21,10,3,Req},
        {22,3,1,Req},
        {22,4,1,Req},
        {23,11,1,Adv},
        {24,5,1,Req},
        {24,5,2,Req},
        {25,5,1,Req},
        {25,5,2,Man},
        {25,5,3,Man},
        {26,3,1,Adv},
        {28,3,1,Req},
        {28,6,1,Req},
        {28,6,2,Req},
        {28,6,3,Req},
        {28,6,4,Req},
        {30,0,1,Req},
        {30,0,2,Req}
    };
}

std::vector<checkers::Info> checkers::autosarInfo{
    {"m0-1-1", checkers::Req},
    {"m0-1-2", checkers::Req},
    {"m0-1-3", checkers::Req},
    {"m0-1-4", checkers::Req},
    {"a0-1-1", checkers::Req},
    {"a0-1-2", checkers::Req},
    {"m0-1-8", checkers::Req},
    {"m0-1-9", checkers::Req},
    {"m0-1-10", checkers::Adv},
    {"a0-1-3", checkers::Req},
    {"a0-1-4", checkers::Req},
    {"a0-1-5", checkers::Req},
    {"a0-1-6", checkers::Adv},
    {"m0-2-1", checkers::Req},
    {"a0-4-2", checkers::Req},
    {"a0-4-3", checkers::Req},
    {"a0-4-4", checkers::Req},
    {"a1-1-1", checkers::Req},
    {"a1-4-3", checkers::Adv},
    {"a2-3-1", checkers::Req},
    {"a2-5-1", checkers::Req},
    {"a2-5-2", checkers::Req},
    {"m2-7-1", checkers::Req},
    {"a2-7-1", checkers::Req},
    {"a2-7-3", checkers::Req},
    {"a2-8-2", checkers::Adv},
    {"m2-10-1", checkers::Req},
    {"a2-10-1", checkers::Req},
    {"a2-10-6", checkers::Req},
    {"a2-10-4", checkers::Req},
    {"a2-10-5", checkers::Adv},
    {"a2-11-1", checkers::Req},
    {"a2-13-1", checkers::Req},
    {"a2-13-6", checkers::Req},
    {"a2-13-5", checkers::Adv},
    {"m2-13-2", checkers::Req},
    {"m2-13-3", checkers::Req},
    {"m2-13-4", checkers::Req},
    {"a2-13-2", checkers::Req},
    {"a2-13-3", checkers::Req},
    {"a2-13-4", checkers::Req},
    {"a3-1-1", checkers::Req},
    {"a3-1-2", checkers::Req},
    {"a3-1-3", checkers::Adv},
    {"m3-1-2", checkers::Req},
    {"a3-1-4", checkers::Req},
    {"a3-1-6", checkers::Adv},
    {"m3-2-1", checkers::Req},
    {"m3-2-2", checkers::Req},
    {"m3-2-3", checkers::Req},
    {"m3-2-4", checkers::Req},
    {"a3-3-1", checkers::Req},
    {"a3-3-2", checkers::Req},
    {"m3-3-2", checkers::Req},
    {"m3-4-1", checkers::Req},
    {"m3-9-1", checkers::Req},
    {"a3-9-1", checkers::Req},
    {"m3-9-3", checkers::Req},
    {"m4-5-1", checkers::Req},
    {"a4-5-1", checkers::Req},
    {"m4-5-3", checkers::Req},
    {"a4-7-1", checkers::Req},
    {"m4-10-1", checkers::Req},
    {"a4-10-1", checkers::Req},
    {"m4-10-2", checkers::Req},
    {"a5-0-1", checkers::Req},
    {"m5-0-2", checkers::Adv},
    {"m5-0-3", checkers::Req},
    {"m5-0-4", checkers::Req},
    {"m5-0-5", checkers::Req},
    {"m5-0-6", checkers::Req},
    {"m5-0-7", checkers::Req},
    {"m5-0-8", checkers::Req},
    {"m5-0-9", checkers::Req},
    {"m5-0-10", checkers::Req},
    {"m5-0-11", checkers::Req},
    {"m5-0-12", checkers::Req},
    {"a5-0-2", checkers::Req},
    {"m5-0-14", checkers::Req},
    {"m5-0-15", checkers::Req},
    {"m5-0-16", checkers::Req},
    {"m5-0-17", checkers::Req},
    {"a5-0-4", checkers::Req},
    {"m5-0-18", checkers::Req},
    {"a5-0-3", checkers::Req},
    {"m5-0-20", checkers::Req},
    {"m5-0-21", checkers::Req},
    {"a5-1-1", checkers::Req},
    {"a5-1-2", checkers::Req},
    {"a5-1-3", checkers::Req},
    {"a5-1-4", checkers::Req},
    {"a5-1-6", checkers::Adv},
    {"a5-1-7", checkers::Req},
    {"a5-1-8", checkers::Adv},
    {"a5-1-9", checkers::Adv},
    {"m5-2-2", checkers::Req},
    {"m5-2-3", checkers::Adv},
    {"a5-2-1", checkers::Adv},
    {"a5-2-2", checkers::Req},
    {"a5-2-3", checkers::Req},
    {"m5-2-6", checkers::Req},
    {"a5-2-4", checkers::Req},
    {"a5-2-6", checkers::Req},
    {"m5-2-8", checkers::Req},
    {"m5-2-9", checkers::Req},
    {"m5-2-10", checkers::Req},
    {"m5-2-11", checkers::Req},
    {"a5-2-5", checkers::Req},
    {"m5-2-12", checkers::Req},
    {"m5-3-1", checkers::Req},
    {"m5-3-2", checkers::Req},
    {"m5-3-3", checkers::Req},
    {"m5-3-4", checkers::Req},
    {"a5-3-1", checkers::Req},
    {"a5-3-2", checkers::Req},
    {"a5-3-3", checkers::Req},
    {"a5-5-1", checkers::Req},
    {"a5-6-1", checkers::Req},
    {"m5-8-1", checkers::Req},
    {"a5-10-1", checkers::Req},
    {"m5-14-1", checkers::Req},
    {"a5-16-1", checkers::Req},
    {"m5-18-1", checkers::Req},
    {"m5-19-1", checkers::Req},
    {"m6-2-1", checkers::Req},
    {"a6-2-1", checkers::Req},
    {"a6-2-2", checkers::Req},
    {"m6-2-2", checkers::Req},
    {"m6-2-3", checkers::Req},
    {"m6-3-1", checkers::Req},
    {"m6-4-1", checkers::Req},
    {"m6-4-2", checkers::Req},
    {"m6-4-3", checkers::Req},
    {"m6-4-4", checkers::Req},
    {"m6-4-5", checkers::Req},
    {"m6-4-6", checkers::Req},
    {"m6-4-7", checkers::Req},
    {"a6-4-1", checkers::Req},
    {"a6-5-1", checkers::Req},
    {"a6-5-2", checkers::Req},
    {"m6-5-2", checkers::Req},
    {"m6-5-3", checkers::Req},
    {"m6-5-4", checkers::Req},
    {"m6-5-5", checkers::Req},
    {"m6-5-6", checkers::Req},
    {"a6-5-3", checkers::Adv},
    {"a6-5-4", checkers::Adv},
    {"a6-6-1", checkers::Req},
    {"m6-6-1", checkers::Req},
    {"m6-6-2", checkers::Req},
    {"m6-6-3", checkers::Req},
    {"a7-1-1", checkers::Req},
    {"a7-1-2", checkers::Req},
    {"m7-1-2", checkers::Req},
    {"a7-1-3", checkers::Req},
    {"a7-1-4", checkers::Req},
    {"a7-1-5", checkers::Req},
    {"a7-1-6", checkers::Req},
    {"a7-1-7", checkers::Req},
    {"a7-1-8", checkers::Req},
    {"a7-1-9", checkers::Req},
    {"a7-2-1", checkers::Req},
    {"a7-2-2", checkers::Req},
    {"a7-2-3", checkers::Req},
    {"a7-2-4", checkers::Req},
    {"m7-3-1", checkers::Req},
    {"m7-3-2", checkers::Req},
    {"m7-3-3", checkers::Req},
    {"m7-3-4", checkers::Req},
    {"a7-3-1", checkers::Req},
    {"m7-3-6", checkers::Req},
    {"a7-4-1", checkers::Req},
    {"m7-4-2", checkers::Req},
    {"m7-4-3", checkers::Req},
    {"a7-5-1", checkers::Req},
    {"a7-5-2", checkers::Req},
    {"a7-6-1", checkers::Req},
    {"m8-0-1", checkers::Req},
    {"a8-2-1", checkers::Req},
    {"m8-3-1", checkers::Req},
    {"a8-4-1", checkers::Req},
    {"m8-4-2", checkers::Req},
    {"a8-4-2", checkers::Req},
    {"m8-4-4", checkers::Req},
    {"a8-4-4", checkers::Adv},
    {"a8-4-5", checkers::Req},
    {"a8-4-6", checkers::Req},
    {"a8-4-7", checkers::Req},
    {"a8-4-8", checkers::Req},
    {"a8-4-9", checkers::Req},
    {"a8-4-10", checkers::Req},
    {"a8-4-11", checkers::Req},
    {"a8-4-12", checkers::Req},
    {"a8-4-13", checkers::Req},
    {"a8-4-14", checkers::Req},
    {"a8-5-0", checkers::Req},
    {"a8-5-1", checkers::Req},
    {"m8-5-2", checkers::Req},
    {"a8-5-2", checkers::Req},
    {"a8-5-3", checkers::Req},
    {"a8-5-4", checkers::Adv},
    {"m9-3-1", checkers::Req},
    {"a9-3-1", checkers::Req},
    {"m9-3-3", checkers::Req},
    {"a9-5-1", checkers::Req},
    {"a9-6-1", checkers::Req},
    {"m9-6-4", checkers::Req},
    {"a10-1-1", checkers::Req},
    {"m10-1-1", checkers::Adv},
    {"m10-1-2", checkers::Req},
    {"m10-1-3", checkers::Req},
    {"m10-2-1", checkers::Adv},
    {"a10-2-1", checkers::Req},
    {"a10-3-1", checkers::Req},
    {"a10-3-2", checkers::Req},
    {"a10-3-3", checkers::Req},
    {"a10-3-5", checkers::Req},
    {"m10-3-3", checkers::Req},
    {"a10-4-1", checkers::Req},
    {"m11-0-1", checkers::Req},
    {"a11-0-1", checkers::Adv},
    {"a11-0-2", checkers::Req},
    {"a11-3-1", checkers::Req},
    {"a12-0-1", checkers::Req},
    {"a12-0-2", checkers::Req},
    {"a12-1-1", checkers::Req},
    {"m12-1-1", checkers::Req},
    {"a12-1-2", checkers::Req},
    {"a12-1-3", checkers::Req},
    {"a12-1-4", checkers::Req},
    {"a12-1-5", checkers::Req},
    {"a12-1-6", checkers::Req},
    {"a12-4-1", checkers::Req},
    {"a12-4-2", checkers::Adv},
    {"a12-6-1", checkers::Req},
    {"a12-7-1", checkers::Req},
    {"a12-8-1", checkers::Req},
    {"a12-8-2", checkers::Adv},
    {"a12-8-3", checkers::Req},
    {"a12-8-4", checkers::Req},
    {"a12-8-5", checkers::Req},
    {"a12-8-6", checkers::Req},
    {"a12-8-7", checkers::Adv},
    {"a13-1-2", checkers::Req},
    {"a13-1-3", checkers::Req},
    {"a13-2-1", checkers::Req},
    {"a13-2-2", checkers::Req},
    {"a13-2-3", checkers::Req},
    {"a13-3-1", checkers::Req},
    {"a13-5-1", checkers::Req},
    {"a13-5-2", checkers::Req},
    {"a13-5-3", checkers::Adv},
    {"a13-5-4", checkers::Req},
    {"a13-5-5", checkers::Req},
    {"a13-6-1", checkers::Req},
    {"a14-1-1", checkers::Adv},
    {"a14-5-1", checkers::Req},
    {"a14-5-2", checkers::Req},
    {"a14-5-3", checkers::Req},
    {"m14-5-3", checkers::Req},
    {"m14-6-1", checkers::Req},
    {"a14-7-1", checkers::Req},
    {"a14-7-2", checkers::Req},
    {"a14-8-2", checkers::Req},
    {"a15-0-2", checkers::Req},
    {"a15-1-2", checkers::Req},
    {"m15-0-3", checkers::Req},
    {"m15-1-1", checkers::Req},
    {"m15-1-2", checkers::Req},
    {"m15-1-3", checkers::Req},
    {"a15-1-3", checkers::Adv},
    {"a15-1-4", checkers::Req},
    {"a15-2-1", checkers::Req},
    {"a15-2-2", checkers::Req},
    {"m15-3-1", checkers::Req},
    {"a15-3-2", checkers::Req},
    {"a15-3-3", checkers::Req},
    {"m15-3-3", checkers::Req},
    {"m15-3-4", checkers::Req},
    {"a15-3-5", checkers::Req},
    {"m15-3-6", checkers::Req},
    {"m15-3-7", checkers::Req},
    {"a15-4-1", checkers::Req},
    {"a15-4-2", checkers::Req},
    {"a15-4-3", checkers::Req},
    {"a15-4-4", checkers::Req},
    {"a15-4-5", checkers::Req},
    {"a15-5-1", checkers::Req},
    {"a15-5-2", checkers::Req},
    {"a15-5-3", checkers::Req},
    {"a16-0-1", checkers::Req},
    {"m16-0-1", checkers::Req},
    {"m16-0-2", checkers::Req},
    {"m16-0-5", checkers::Req},
    {"m16-0-6", checkers::Req},
    {"m16-0-7", checkers::Req},
    {"m16-0-8", checkers::Req},
    {"m16-1-1", checkers::Req},
    {"m16-1-2", checkers::Req},
    {"m16-2-3", checkers::Req},
    {"a16-2-1", checkers::Req},
    {"a16-2-2", checkers::Req},
    {"a16-2-3", checkers::Req},
    {"m16-3-1", checkers::Req},
    {"m16-3-2", checkers::Adv},
    {"a16-6-1", checkers::Req},
    {"a16-7-1", checkers::Req},
    {"a17-0-1", checkers::Req},
    {"m17-0-2", checkers::Req},
    {"m17-0-3", checkers::Req},
    {"m17-0-5", checkers::Req},
    {"a17-1-1", checkers::Req},
    {"a17-6-1", checkers::Req},
    {"a18-0-1", checkers::Req},
    {"a18-0-2", checkers::Req},
    {"m18-0-3", checkers::Req},
    {"m18-0-4", checkers::Req},
    {"m18-0-5", checkers::Req},
    {"a18-0-3", checkers::Req},
    {"a18-1-1", checkers::Req},
    {"a18-1-2", checkers::Req},
    {"a18-1-3", checkers::Req},
    {"a18-1-4", checkers::Req},
    {"a18-1-6", checkers::Req},
    {"m18-2-1", checkers::Req},
    {"a18-5-1", checkers::Req},
    {"a18-5-2", checkers::Req},
    {"a18-5-3", checkers::Req},
    {"a18-5-4", checkers::Req},
    {"a18-5-5", checkers::Req},
    {"a18-5-6", checkers::Req},
    {"a18-5-7", checkers::Req},
    {"a18-5-8", checkers::Req},
    {"a18-5-9", checkers::Req},
    {"a18-5-10", checkers::Req},
    {"a18-5-11", checkers::Req},
    {"m18-7-1", checkers::Req},
    {"a18-9-1", checkers::Req},
    {"a18-9-2", checkers::Req},
    {"a18-9-3", checkers::Req},
    {"a18-9-4", checkers::Req},
    {"m19-3-1", checkers::Req},
    {"a20-8-1", checkers::Req},
    {"a20-8-2", checkers::Req},
    {"a20-8-3", checkers::Req},
    {"a20-8-4", checkers::Req},
    {"a20-8-5", checkers::Req},
    {"a20-8-6", checkers::Req},
    {"a20-8-7", checkers::Req},
    {"a21-8-1", checkers::Req},
    {"a23-0-1", checkers::Req},
    {"a23-0-2", checkers::Req},
    {"a25-1-1", checkers::Req},
    {"a25-4-1", checkers::Req},
    {"a26-5-1", checkers::Req},
    {"a26-5-2", checkers::Req},
    {"m27-0-1", checkers::Req},
    {"a27-0-1", checkers::Req},
    {"a27-0-4", checkers::Req},
    {"a27-0-2", checkers::Adv},
    {"a27-0-3", checkers::Req},
};

std::vector<checkers::Info> checkers::certCInfo{
    {"PRE30-C", "L3"},
    {"PRE31-C", "L3"},
    {"PRE32-C", "L3"},
    {"DCL30-C", "L2"},
    {"DCL31-C", "L3"},
    {"DCL36-C", "L2"},
    {"DCL37-C", "L3"},
    {"DCL38-C", "L3"},
    {"DCL39-C", "L3"},
    {"DCL40-C", "L3"},
    {"DCL41-C", "L2"},
    {"EXP30-C", "L2"},
    {"EXP32-C", "L2"},
    {"EXP33-C", "L1"},
    {"EXP34-C", "L1"},
    {"EXP35-C", "L2"},
    {"EXP36-C", "L3"},
    {"EXP37-C", "L3"},
    {"EXP39-C", "L2"},
    {"EXP40-C", "L3"},
    {"EXP42-C", "L1"},
    {"EXP43-C", "L3"},
    {"EXP44-C", "L3"},
    {"EXP45-C", "L2"},
    {"EXP46-C", "L2"},
    {"EXP47-C", "L2"},
    {"INT30-C", "L2"},
    {"INT31-C", "L1"},
    {"INT32-C", "L1"},
    {"INT33-C", "L2"},
    {"INT34-C", "L3"},
    {"INT35-C", "L3"},
    {"INT36-C", "L3"},
    {"FLP30-C", "L2"},
    {"FLP32-C", "L1"},
    {"FLP34-C", "L3"},
    {"FLP36-C", "L3"},
    {"FLP37-C", "L3"},
    {"ARR30-C", "L2"},
    {"ARR32-C", "L2"},
    {"ARR36-C", "L3"},
    {"ARR37-C", "L2"},
    {"ARR38-C", "L2"},
    {"ARR39-C", "L2"},
    {"STR30-C", "L2"},
    {"STR31-C", "L2"},
    {"STR32-C", "L1"},
    {"STR34-C", "L2"},
    {"STR37-C", "L3"},
    {"STR38-C", "L1"},
    {"MEM30-C", "L2"},
    {"MEM31-C", "L3"},
    {"MEM33-C", "L3"},
    {"MEM34-C", "L2"},
    {"MEM35-C", "L2"},
    {"MEM36-C", "L3"},
    {"FIO30-C", "L1"},
    {"FIO32-C", "L3"},
    {"FIO34-C", "L1"},
    {"FIO37-C", "L1"},
    {"FIO38-C", "L3"},
    {"FIO39-C", "L2"},
    {"FIO40-C", "L2"},
    {"FIO41-C", "L3"},
    {"FIO42-C", "L3"},
    {"FIO44-C", "L3"},
    {"FIO45-C", "L2"},
    {"FIO46-C", "L3"},
    {"FIO47-C", "L2"},
    {"ENV30-C", "L3"},
    {"ENV31-C", "L3"},
    {"ENV32-C", "L1"},
    {"ENV33-C", "L1"},
    {"ENV34-C", "L3"},
    {"SIG30-C", "L1"},
    {"SIG31-C", "L1"},
    {"SIG34-C", "L3"},
    {"SIG35-C", "L3"},
    {"ERR30-C", "L1"},
    {"ERR32-C", "L3"},
    {"ERR33-C", "L1"},
    {"ERR34-C", "L2"},
    {"CON30-C", "L3"},
    {"CON31-C", "L3"},
    {"CON32-C", "L3"},
    {"CON33-C", "L3"},
    {"CON34-C", "L3"},
    {"CON35-C", "L3"},
    {"CON36-C", "L3"},
    {"CON37-C", "L3"},
    {"CON38-C", "L3"},
    {"CON39-C", "L3"},
    {"CON40-C", "L2"},
    {"CON41-C", "L3"},
    {"CON43-C", "L3"},
    {"MSC30-C", "L3"},
    {"MSC32-C", "L1"},
    {"MSC33-C", "L2"},
    {"MSC37-C", "L2"},
    {"MSC38-C", "L3"},
    {"MSC39-C", "L3"},
    {"MSC40-C", "L3"},
    {"MSC41-C", "L2"},
    {"POS30-C", "L1"},
    {"POS34-C", "L2"},
    {"POS35-C", "L2"},
    {"POS36-C", "L1"},
    {"POS37-C", "L1"},
    {"POS38-C", "L3"},
    {"POS39-C", "L1"},
    {"POS44-C", "L3"},
    {"POS47-C", "L3"},
    {"POS48-C", "L3"},
    {"POS49-C", "L3"},
    {"POS50-C", "L3"},
    {"POS51-C", "L3"},
    {"POS52-C", "L3"},
    {"POS53-C", "L2"},
    {"POS54-C", "L1"},
    {"WIN30-C", "L3"},
    // Recommendations
    {"PRE00-C", "L3"},
    {"PRE01-C", "L1"},
    {"PRE02-C", "L1"},
    {"PRE04-C", "L3"},
    {"PRE05-C", "L3"},
    {"PRE06-C", "L3"},
    {"PRE07-C", "L3"},
    {"PRE08-C", "L3"},
    {"PRE09-C", "L1"},
    {"PRE10-C", "L1"},
    {"PRE11-C", "L2"},
    {"PRE12-C", "L3"},
    {"PRE13-C", "L3"},
    {"DCL00-C", "L3"},
    {"DCL01-C", "L3"},
    {"DCL02-C", "L3"},
    {"DCL03-C", "L3"},
    {"DCL04-C", "L3"},
    {"DCL05-C", "L3"},
    {"DCL06-C", "L3"},
    {"DCL07-C", "L3"},
    {"DCL08-C", "L3"},
    {"DCL09-C", "L3"},
    {"DCL10-C", "L2"},
    {"DCL11-C", "L1"},
    {"DCL12-C", "L3"},
    {"DCL13-C", "L3"},
    {"DCL15-C", "L3"},
    {"DCL16-C", "L3"},
    {"DCL17-C", "L3"},
    {"DCL18-C", "L3"},
    {"DCL19-C", "L3"},
    {"DCL20-C", "L1"},
    {"DCL21-C", "L3"},
    {"DCL22-C", "L3"},
    {"DCL23-C", "L2"},
    {"EXP00-C", "L2"},
    {"EXP02-C", "L3"},
    {"EXP03-C", "L3"},
    {"EXP05-C", "L3"},
    {"EXP07-C", "L3"},
    {"EXP08-C", "L2"},
    {"EXP09-C", "L2"},
    {"EXP10-C", "L2"},
    {"EXP11-C", "L3"},
    {"EXP12-C", "L3"},
    {"EXP13-C", "L3"},
    {"EXP14-C", "L3"},
    {"EXP15-C", "L1"},
    {"EXP16-C", "L2"},
    {"EXP19-C", "L1"},
    {"EXP20-C", "L1"},
    {"INT00-C", "L3"},
    {"INT01-C", "L2"},
    {"INT02-C", "L3"},
    {"INT04-C", "L1"},
    {"INT05-C", "L2"},
    {"INT07-C", "L1"},
    {"INT08-C", "L3"},
    {"INT09-C", "L3"},
    {"INT10-C", "L3"},
    {"INT12-C", "L3"},
    {"INT13-C", "L2"},
    {"INT14-C", "L3"},
    {"INT15-C", "L2"},
    {"INT16-C", "L3"},
    {"INT17-C", "L3"},
    {"INT18-C", "L1"},
    {"FLP00-C", "L3"},
    {"FLP01-C", "L3"},
    {"FLP02-C", "L3"},
    {"FLP03-C", "L3"},
    {"FLP04-C", "L3"},
    {"FLP05-C", "L3"},
    {"FLP06-C", "L3"},
    {"FLP07-C", "L3"},
    {"ARR00-C", "L2"},
    {"ARR01-C", "L1"},
    {"ARR02-C", "L2"},
    {"STR00-C", "L3"},
    {"STR01-C", "L3"},
    {"STR02-C", "L2"},
    {"STR03-C", "L3"},
    {"STR04-C", "L3"},
    {"STR05-C", "L3"},
    {"STR06-C", "L2"},
    {"STR08-C", "L2"},
    {"STR09-C", "L3"},
    {"STR10-C", "L3"},
    {"STR11-C", "L2"},
    {"FIO01-C", "L1"},
    {"FIO02-C", "L3"},
    {"FIO03-C", "L3"},
    {"FIO05-C", "L3"},
    {"FIO06-C", "L3"},
    {"FIO08-C", "L3"},
    {"FIO09-C", "L3"},
    {"FIO10-C", "L3"},
    {"FIO11-C", "L3"},
    {"FIO13-C", "L3"},
    {"FIO14-C", "L3"},
    {"FIO15-C", "L3"},
    {"FIO17-C", "L2"},
    {"FIO18-C", "L3"},
    {"FIO19-C", "L3"},
    {"FIO20-C", "L1"},
    {"FIO21-C", "L3"},
    {"FIO22-C", "L3"},
    {"FIO23-C", "L3"},
    {"FIO24-C", "L3"},
    {"ENV01-C", "L2"},
    {"ENV02-C", "L3"},
    {"ENV03-C", "L2"},
    {"SIG00-C", "L2"},
    {"SIG01-C", "L3"},
    {"SIG02-C", "L2"},
    {"ERR00-C", "L3"},
    {"ERR01-C", "L2"},
    {"ERR02-C", "L3"},
    {"ERR04-C", "L3"},
    {"ERR05-C", "L2"},
    {"ERR06-C", "L3"},
    {"ERR07-C", "L1"},
    {"API00-C", "L3"},
    {"API01-C", "L1"},
    {"API02-C", "L1"},
    {"API03-C", "L3"},
    {"API04-C", "L3"},
    {"API05-C", "L1"},
    {"API07-C", "L3"},
    {"API09-C", "L3"},
    {"API10-C", "L3"},
    {"CON01-C", "L3"},
    {"CON02-C", "L3"},
    {"CON04-C", "L3"},
    {"CON05-C", "L3"},
    {"CON06-C", "L3"},
    {"CON07-C", "L2"},
    {"CON08-C", "L3"},
    {"CON09-C", "L3"},
    {"MSC00-C", "L3"},
    {"MSC01-C", "L3"},
    {"MSC04-C", "L3"},
    {"MSC05-C", "L3"},
    {"MSC06-C", "L1"},
    {"MSC07-C", "L3"},
    {"MSC09-C", "L3"},
    {"MSC10-C", "L3"},
    {"MSC11-C", "L3"},
    {"MSC12-C", "L3"},
    {"MSC13-C", "L3"},
    {"MSC14-C", "L3"},
    {"MSC15-C", "L2"},
    {"MSC17-C", "L1"},
    {"MSC18-C", "L3"},
    {"MSC19-C", "L3"},
    {"MSC20-C", "L2"},
    {"MSC21-C", "L3"},
    {"MSC22-C", "L3"},
    {"MSC23-C", "L3"},
    {"MSC24-C", "L1"},
    {"MSC25-C", "L3"},
    {"POS01-C", "L2"},
    {"POS02-C", "L2"},
    {"POS04-C", "L3"},
    {"POS05-C", "L3"},
    {"WIN00-C", "L2"},
    {"WIN01-C", "L1"},
    {"WIN02-C", "L1"},
    {"WIN03-C", "L3"},
    {"WIN04-C", "L3"},
};

std::vector<checkers::Info> checkers::certCppInfo{
    {"DCL50-CPP", "L1"},
    {"DCL51-CPP", "L3"},
    {"DCL52-CPP", "L3"},
    {"DCL53-CPP", "L3"},
    {"DCL54-CPP", "L3"},
    {"DCL55-CPP", "L3"},
    {"DCL56-CPP", "L3"},
    {"DCL57-CPP", "L2"},
    {"DCL58-CPP", "L2"},
    {"DCL59-CPP", "L3"},
    {"DCL60-CPP", "L2"},
    {"EXP50-CPP", "L2"},
    {"EXP51-CPP", "L3"},
    {"EXP52-CPP", "L3"},
    {"EXP53-CPP", "L1"},
    {"EXP54-CPP", "L2"},
    {"EXP55-CPP", "L3"},
    {"EXP56-CPP", "L3"},
    {"EXP57-CPP", "L3"},
    {"EXP58-CPP", "L3"},
    {"EXP59-CPP", "L3"},
    {"EXP60-CPP", "L2"},
    {"EXP61-CPP", "L2"},
    {"EXP62-CPP", "L1"},
    {"EXP63-CPP", "L2"},
    {"INT50-CPP", "L3"},
    {"CTR50-CPP", "L2"},
    {"CTR51-CPP", "L2"},
    {"CTR52-CPP", "L2"},
    {"CTR53-CPP", "L2"},
    {"CTR54-CPP", "L3"},
    {"CTR55-CPP", "L2"},
    {"CTR56-CPP", "L2"},
    {"CTR57-CPP", "L3"},
    {"CTR58-CPP", "L2"},
    {"STR50-CPP", "L2"},
    {"STR51-CPP", "L1"},
    {"STR52-CPP", "L2"},
    {"STR53-CPP", "L3"},
    {"MEM50-CPP", "L2"},
    {"MEM51-CPP", "L2"},
    {"MEM52-CPP", "L1"},
    {"MEM53-CPP", "L2"},
    {"MEM54-CPP", "L2"},
    {"MEM55-CPP", "L2"},
    {"MEM56-CPP", "L2"},
    {"MEM57-CPP", "L3"},
    {"FIO50-CPP", "L2"},
    {"FIO51-CPP", "L3"},
    {"ERR50-CPP", "L3"},
    {"ERR51-CPP", "L2"},
    {"ERR52-CPP", "L3"},
    {"ERR53-CPP", "L3"},
    {"ERR54-CPP", "L1"},
    {"ERR55-CPP", "L2"},
    {"ERR56-CPP", "L2"},
    {"ERR57-CPP", "L3"},
    {"ERR58-CPP", "L2"},
    {"ERR59-CPP", "L2"},
    {"ERR60-CPP", "L3"},
    {"ERR61-CPP", "L3"},
    {"ERR62-CPP", "L3"},
    {"OOP50-CPP", "L3"},
    {"OOP51-CPP", "L3"},
    {"OOP52-CPP", "L3"},
    {"OOP53-CPP", "L2"},
    {"OOP54-CPP", "L3"},
    {"OOP55-CPP", "L2"},
    {"OOP56-CPP", "L3"},
    {"OOP57-CPP", "L1"},
    {"OOP58-CPP", "L2"},
    {"CON50-CPP", "L3"},
    {"CON51-CPP", "L2"},
    {"CON52-CPP", "L3"},
    {"CON53-CPP", "L3"},
    {"CON54-CPP", "L3"},
    {"CON55-CPP", "L3"},
    {"CON56-CPP", "L3"},
    {"MSC50-CPP", "L3"},
    {"MSC51-CPP", "L1"},
    {"MSC52-CPP", "L2"},
    {"MSC53-CPP", "L3"},
    {"MSC54-CPP", "L2"},
};

