/* Category.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Category.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-appindexer.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_CATEGORY_0_PROPERTY,
	BUDGIE_CATEGORY_NAME_PROPERTY,
	BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY,
	BUDGIE_CATEGORY_APPS_PROPERTY,
	BUDGIE_CATEGORY_NUM_PROPERTIES
};
static GParamSpec* budgie_category_properties[BUDGIE_CATEGORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BudgieCategoryPrivate {
	gchar* _name;
	gboolean _misc_category;
	GeeArrayList* _apps;
};

static gint BudgieCategory_private_offset;
static gpointer budgie_category_parent_class = NULL;

static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void budgie_category_set_apps (BudgieCategory* self,
                               GeeArrayList* value);
static void budgie_category_finalize (GObject * obj);
static GType budgie_category_get_type_once (void);
static void _vala_budgie_category_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_budgie_category_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_category_get_instance_private (BudgieCategory* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieCategory_private_offset);
}

/**
* Create a new category with a name.
*
* Optionally mark this category as a miscellaneous catch-all category
* by passing in `true` for the `misc` parameter.
*/
BudgieCategory*
budgie_category_construct (GType object_type,
                           const gchar* name,
                           gboolean misc)
{
	BudgieCategory * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BudgieCategory*) g_object_new (object_type, "name", name, "misc-category", misc, NULL);
	return self;
}

BudgieCategory*
budgie_category_new (const gchar* name,
                     gboolean misc)
{
	return budgie_category_construct (BUDGIE_TYPE_CATEGORY, name, misc);
}

/**
 * Create a new category from a file.
 *
 * Errors are thrown if the file doesn't exist or is a directory,
 * or if the input stream is closed while reading the file.
 */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

BudgieCategory*
budgie_category_new_for_file (GFile* file,
                              GError** error)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	GFileInputStream* input_stream = NULL;
	GFileInputStream* _tmp1_;
	GDataInputStream* data_stream = NULL;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	gchar* line = NULL;
	gchar* filename_without_ext = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	BudgieCategory* _tmp24_ = NULL;
	GError* _inner_error0_ = NULL;
	BudgieCategory* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_strdup (_ ("New Category"));
	name = _tmp0_;
	_tmp1_ = g_file_read (file, NULL, &_inner_error0_);
	input_stream = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (name);
		return NULL;
	}
	_tmp2_ = input_stream;
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
	data_stream = _tmp3_;
	line = NULL;
	while (TRUE) {
		gchar* _tmp4_ = NULL;
		GDataInputStream* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = data_stream;
		_tmp6_ = g_data_input_stream_read_line (_tmp5_, NULL, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (line);
			_g_object_unref0 (data_stream);
			_g_object_unref0 (input_stream);
			_g_free0 (name);
			return NULL;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_free0 (line);
		line = _tmp7_;
		_tmp8_ = line;
		if (!(_tmp8_ != NULL)) {
			_g_free0 (_tmp4_);
			break;
		}
		_tmp9_ = line;
		if (g_str_has_prefix (_tmp9_, "Name=")) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = line;
			_tmp11_ = string_substring (_tmp10_, (glong) 5, (glong) -1);
			_tmp12_ = _tmp11_;
			_tmp13_ = string_strip (_tmp12_);
			_g_free0 (name);
			name = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp4_);
			break;
		}
		_g_free0 (_tmp4_);
	}
	_tmp14_ = g_file_get_basename (file);
	_tmp15_ = _tmp14_;
	_tmp16_ = string_replace (_tmp15_, ".directory", "");
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	filename_without_ext = _tmp17_;
	_tmp18_ = name;
	_tmp19_ = name;
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = filename_without_ext;
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = g_new0 (gchar*, 2 + 1);
	_tmp23_[0] = _tmp20_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = budgie_category_new (_tmp18_, FALSE);
	_tmp24_->included_categories = (_vala_array_free (_tmp24_->included_categories, _tmp24_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp24_->included_categories = _tmp23_;
	_tmp24_->included_categories_length1 = 2;
	result = _tmp24_;
	_g_free0 (filename_without_ext);
	_g_free0 (line);
	_g_object_unref0 (data_stream);
	_g_object_unref0 (input_stream);
	_g_free0 (name);
	return result;
}

/**
* Add an application to this category if the app belongs in
* this category.
*
* Returns `true` if the application should be in this category,
* otherwise `false`.
*/
static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
budgie_category_maybe_add_app (BudgieCategory* self,
                               BudgieApplication* app)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* categories = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean found_category = FALSE;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gboolean _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (app != NULL, FALSE);
	_tmp0_ = budgie_application_get_desktop_id (app);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->excluded_applications;
	_tmp2__length1 = self->excluded_applications_length1;
	if (_vala_string_array_contains (_tmp2_, _tmp2__length1, _tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = budgie_application_get_categories (app);
	_tmp4_ = _tmp3_;
	categories = _tmp4_;
	_tmp5_ = categories;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		GeeArrayList* _tmp7_;
		_tmp6_ = self->priv->_misc_category;
		if (!_tmp6_) {
			result = FALSE;
			return result;
		}
		_tmp7_ = self->priv->_apps;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, app);
		result = TRUE;
		return result;
	}
	found_category = FALSE;
	_tmp8_ = categories;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, ";", 0);
	{
		gchar** category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp10_;
		category_collection_length1 = _vala_array_length (_tmp9_);
		for (category_it = 0; category_it < category_collection_length1; category_it = category_it + 1) {
			const gchar* category = NULL;
			category = category_collection[category_it];
			{
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				_tmp11_ = category;
				_tmp12_ = self->excluded_categories;
				_tmp12__length1 = self->excluded_categories_length1;
				if (_vala_string_array_contains (_tmp12_, _tmp12__length1, _tmp11_)) {
					result = FALSE;
					category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp13_ = category;
				_tmp14_ = self->included_categories;
				_tmp14__length1 = self->included_categories_length1;
				if (_vala_string_array_contains (_tmp14_, _tmp14__length1, _tmp13_)) {
					found_category = TRUE;
				}
			}
		}
		category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (found_category) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GeeArrayList* _tmp18_;
		_tmp15_ = budgie_application_get_name (app);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->_name;
		g_debug ("Category.vala:115: Adding '%s' to category '%s'", _tmp16_, _tmp17_);
		_tmp18_ = self->priv->_apps;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, app);
		result = TRUE;
		return result;
	}
	_tmp19_ = self->priv->_misc_category;
	if (_tmp19_) {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GeeArrayList* _tmp23_;
		_tmp20_ = budgie_application_get_name (app);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_name;
		g_debug ("Category.vala:123: Adding '%s' to category '%s'", _tmp21_, _tmp22_);
		_tmp23_ = self->priv->_apps;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, app);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

const gchar*
budgie_category_get_name (BudgieCategory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
budgie_category_set_name (BudgieCategory* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_category_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_category_properties[BUDGIE_CATEGORY_NAME_PROPERTY]);
	}
}

gboolean
budgie_category_get_misc_category (BudgieCategory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_misc_category;
	return result;
}

static void
budgie_category_set_misc_category (BudgieCategory* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_category_get_misc_category (self);
	if (old_value != value) {
		self->priv->_misc_category = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_category_properties[BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY]);
	}
}

GeeArrayList*
budgie_category_get_apps (BudgieCategory* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_category_set_apps (BudgieCategory* self,
                          GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_category_get_apps (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_category_properties[BUDGIE_CATEGORY_APPS_PROPERTY]);
	}
}

static void
budgie_category_class_init (BudgieCategoryClass * klass,
                            gpointer klass_data)
{
	budgie_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieCategory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_category_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_category_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_category_finalize;
	/** The name of this category. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_CATEGORY_NAME_PROPERTY, budgie_category_properties[BUDGIE_CATEGORY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	* True if this category should be a catch-all for applicatiosn that
	* that don't go in any other category.
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY, budgie_category_properties[BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY] = g_param_spec_boolean ("misc-category", "misc-category", "misc-category", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/** The list of applications in this category. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_CATEGORY_APPS_PROPERTY, budgie_category_properties[BUDGIE_CATEGORY_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
budgie_category_instance_init (BudgieCategory * self,
                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = budgie_category_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BUDGIE_TYPE_APPLICATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_apps = _tmp0_;
}

static void
budgie_category_finalize (GObject * obj)
{
	BudgieCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_CATEGORY, BudgieCategory);
	_g_free0 (self->priv->_name);
	self->included_categories = (_vala_array_free (self->included_categories, self->included_categories_length1, (GDestroyNotify) g_free), NULL);
	self->excluded_categories = (_vala_array_free (self->excluded_categories, self->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	self->excluded_applications = (_vala_array_free (self->excluded_applications, self->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_apps);
	G_OBJECT_CLASS (budgie_category_parent_class)->finalize (obj);
}

/**
* Represents a category of applications.
*/
static GType
budgie_category_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieCategory), 0, (GInstanceInitFunc) budgie_category_instance_init, NULL };
	GType budgie_category_type_id;
	budgie_category_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieCategory", &g_define_type_info, 0);
	BudgieCategory_private_offset = g_type_add_instance_private (budgie_category_type_id, sizeof (BudgieCategoryPrivate));
	return budgie_category_type_id;
}

GType
budgie_category_get_type (void)
{
	static volatile gsize budgie_category_type_id__once = 0;
	if (g_once_init_enter (&budgie_category_type_id__once)) {
		GType budgie_category_type_id;
		budgie_category_type_id = budgie_category_get_type_once ();
		g_once_init_leave (&budgie_category_type_id__once, budgie_category_type_id);
	}
	return budgie_category_type_id__once;
}

static void
_vala_budgie_category_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	BudgieCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_CATEGORY, BudgieCategory);
	switch (property_id) {
		case BUDGIE_CATEGORY_NAME_PROPERTY:
		g_value_set_string (value, budgie_category_get_name (self));
		break;
		case BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY:
		g_value_set_boolean (value, budgie_category_get_misc_category (self));
		break;
		case BUDGIE_CATEGORY_APPS_PROPERTY:
		g_value_set_object (value, budgie_category_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_category_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	BudgieCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_CATEGORY, BudgieCategory);
	switch (property_id) {
		case BUDGIE_CATEGORY_NAME_PROPERTY:
		budgie_category_set_name (self, g_value_get_string (value));
		break;
		case BUDGIE_CATEGORY_MISC_CATEGORY_PROPERTY:
		budgie_category_set_misc_category (self, g_value_get_boolean (value));
		break;
		case BUDGIE_CATEGORY_APPS_PROPERTY:
		budgie_category_set_apps (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

