/* pdfReader.c generated by valac 0.56.18, the Vala compiler
 * generated from pdfReader.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for parsing PDF file formats
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <granite.h>
#include <gio/gio.h>
#include <poppler.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_PDF_READER (bookworm_app_pdf_reader_get_type ())
#define BOOKWORM_APP_PDF_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_PDF_READER, BookwormApppdfReader))
#define BOOKWORM_APP_PDF_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_PDF_READER, BookwormApppdfReaderClass))
#define BOOKWORM_APP_IS_PDF_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_PDF_READER))
#define BOOKWORM_APP_IS_PDF_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_PDF_READER))
#define BOOKWORM_APP_PDF_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_PDF_READER, BookwormApppdfReaderClass))

typedef struct _BookwormApppdfReader BookwormApppdfReader;
typedef struct _BookwormApppdfReaderClass BookwormApppdfReaderClass;
typedef struct _BookwormApppdfReaderPrivate BookwormApppdfReaderPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BookwormAppParamSpecpdfReader BookwormAppParamSpecpdfReader;

struct _BookwormApppdfReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormApppdfReaderPrivate * priv;
};

struct _BookwormApppdfReaderClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormApppdfReader *self);
};

struct _BookwormAppParamSpecpdfReader {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_pdf_reader_parent_class = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;
VALA_EXTERN GString* bookworm_app_utils_spawn_async_with_pipes_output;

VALA_EXTERN gpointer bookworm_app_pdf_reader_ref (gpointer instance);
VALA_EXTERN void bookworm_app_pdf_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_pdf_reader (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_pdf_reader (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_pdf_reader (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_pdf_reader (const GValue* value);
VALA_EXTERN GType bookworm_app_pdf_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormApppdfReader, bookworm_app_pdf_reader_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_pdf_reader_parsePDFBook (BookwormAppBook* aBook,
                                                       GError** error);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_pdf_reader_extractEBook (const gchar* eBookLocation);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN BookwormAppBook* bookworm_app_pdf_reader_getContentList (BookwormAppBook* aBook,
                                                         const gchar* extractionLocation);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_pdf_reader_setCoverImage (BookwormAppBook* aBook);
VALA_EXTERN BookwormAppBook* bookworm_app_pdf_reader_setBookMetaData (BookwormAppBook* aBook);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gint bookworm_app_utils_execute_async_multiarg_command_pipes (gchar** spawn_args,
                                                              gint spawn_args_length1);
VALA_EXTERN void bookworm_app_book_clearBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN BookwormApppdfReader* bookworm_app_pdf_reader_new (void);
VALA_EXTERN BookwormApppdfReader* bookworm_app_pdf_reader_construct (GType object_type);
static void bookworm_app_pdf_reader_finalize (BookwormApppdfReader * obj);
static GType bookworm_app_pdf_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 32 "../src/pdfReader.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 194 "pdfReader.c"
}

BookwormAppBook*
bookworm_app_pdf_reader_parsePDFBook (BookwormAppBook* aBook,
                                      GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	BookwormAppBook* _tmp32_;
	BookwormAppBook* result;
#line 22 "../src/pdfReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 23 "../src/pdfReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 23 "../src/pdfReader.vala"
	_tmp1_ = _tmp0_;
#line 23 "../src/pdfReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:parsePDFBook] book.location=", _tmp1_, NULL);
#line 23 "../src/pdfReader.vala"
	_tmp3_ = _tmp2_;
#line 23 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:23: %s", _tmp3_);
#line 23 "../src/pdfReader.vala"
	_g_free0 (_tmp3_);
#line 23 "../src/pdfReader.vala"
	_g_free0 (_tmp1_);
#line 25 "../src/pdfReader.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 229 "pdfReader.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* extractionLocation = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		BookwormAppBook* _tmp15_;
		const gchar* _tmp16_;
		BookwormAppBook* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gboolean _tmp22_;
		BookwormAppBook* _tmp26_;
		BookwormAppBook* _tmp27_;
#line 26 "../src/pdfReader.vala"
		_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 26 "../src/pdfReader.vala"
		_tmp5_ = _tmp4_;
#line 26 "../src/pdfReader.vala"
		_tmp6_ = g_strconcat ("Initiated process for parsing of PDF Book located at:", _tmp5_, NULL);
#line 26 "../src/pdfReader.vala"
		_tmp7_ = _tmp6_;
#line 26 "../src/pdfReader.vala"
		g_debug ("pdfReader.vala:26: %s", _tmp7_);
#line 26 "../src/pdfReader.vala"
		_g_free0 (_tmp7_);
#line 26 "../src/pdfReader.vala"
		_g_free0 (_tmp5_);
#line 28 "../src/pdfReader.vala"
		_tmp8_ = bookworm_app_book_getBookLocation (aBook);
#line 28 "../src/pdfReader.vala"
		_tmp9_ = _tmp8_;
#line 28 "../src/pdfReader.vala"
		_tmp10_ = bookworm_app_pdf_reader_extractEBook (_tmp9_);
#line 28 "../src/pdfReader.vala"
		_tmp11_ = _tmp10_;
#line 28 "../src/pdfReader.vala"
		_g_free0 (_tmp9_);
#line 28 "../src/pdfReader.vala"
		extractionLocation = _tmp11_;
#line 29 "../src/pdfReader.vala"
		_tmp12_ = extractionLocation;
#line 29 "../src/pdfReader.vala"
		if (g_strcmp0 ("false", _tmp12_) == 0) {
#line 280 "pdfReader.c"
			BookwormAppBook* _tmp13_;
#line 30 "../src/pdfReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 31 "../src/pdfReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 32 "../src/pdfReader.vala"
			_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 32 "../src/pdfReader.vala"
			result = _tmp13_;
#line 32 "../src/pdfReader.vala"
			_g_free0 (extractionLocation);
#line 32 "../src/pdfReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 32 "../src/pdfReader.vala"
			return result;
#line 296 "pdfReader.c"
		} else {
			const gchar* _tmp14_;
#line 34 "../src/pdfReader.vala"
			_tmp14_ = extractionLocation;
#line 34 "../src/pdfReader.vala"
			bookworm_app_book_setBookExtractionLocation (aBook, _tmp14_);
#line 303 "pdfReader.c"
		}
#line 38 "../src/pdfReader.vala"
		_tmp15_ = _bookworm_app_book_ref0 (aBook);
#line 38 "../src/pdfReader.vala"
		_tmp16_ = extractionLocation;
#line 38 "../src/pdfReader.vala"
		_tmp17_ = bookworm_app_pdf_reader_getContentList (_tmp15_, _tmp16_);
#line 38 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 38 "../src/pdfReader.vala"
		aBook = _tmp17_;
#line 39 "../src/pdfReader.vala"
		_tmp18_ = bookworm_app_book_getBookContentList (aBook);
#line 39 "../src/pdfReader.vala"
		_tmp19_ = _tmp18_;
#line 39 "../src/pdfReader.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
#line 39 "../src/pdfReader.vala"
		_tmp21_ = _tmp20_;
#line 39 "../src/pdfReader.vala"
		_tmp22_ = _tmp21_ < 1;
#line 39 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp19_);
#line 39 "../src/pdfReader.vala"
		if (_tmp22_) {
#line 329 "pdfReader.c"
			BookwormAppBook* _tmp23_;
#line 41 "../src/pdfReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 42 "../src/pdfReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 43 "../src/pdfReader.vala"
			_tmp23_ = _bookworm_app_book_ref0 (aBook);
#line 43 "../src/pdfReader.vala"
			result = _tmp23_;
#line 43 "../src/pdfReader.vala"
			_g_free0 (extractionLocation);
#line 43 "../src/pdfReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 43 "../src/pdfReader.vala"
			return result;
#line 345 "pdfReader.c"
		}
#line 47 "../src/pdfReader.vala"
		if (!bookworm_app_book_getIsBookCoverImagePresent (aBook)) {
#line 349 "pdfReader.c"
			BookwormAppBook* _tmp24_;
			BookwormAppBook* _tmp25_;
#line 48 "../src/pdfReader.vala"
			_tmp24_ = _bookworm_app_book_ref0 (aBook);
#line 48 "../src/pdfReader.vala"
			_tmp25_ = bookworm_app_pdf_reader_setCoverImage (_tmp24_);
#line 48 "../src/pdfReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 48 "../src/pdfReader.vala"
			aBook = _tmp25_;
#line 360 "pdfReader.c"
		}
#line 52 "../src/pdfReader.vala"
		_tmp26_ = _bookworm_app_book_ref0 (aBook);
#line 52 "../src/pdfReader.vala"
		_tmp27_ = bookworm_app_pdf_reader_setBookMetaData (_tmp26_);
#line 52 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 52 "../src/pdfReader.vala"
		aBook = _tmp27_;
#line 54 "../src/pdfReader.vala"
		bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 25 "../src/pdfReader.vala"
		_g_free0 (extractionLocation);
#line 374 "pdfReader.c"
	}
#line 56 "../src/pdfReader.vala"
	_tmp28_ = bookworm_app_book_getBookLocation (aBook);
#line 56 "../src/pdfReader.vala"
	_tmp29_ = _tmp28_;
#line 56 "../src/pdfReader.vala"
	_tmp30_ = g_strconcat ("[END] [FUNCTION:parsePDFBook] book.location=", _tmp29_, NULL);
#line 56 "../src/pdfReader.vala"
	_tmp31_ = _tmp30_;
#line 56 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:56: %s", _tmp31_);
#line 56 "../src/pdfReader.vala"
	_g_free0 (_tmp31_);
#line 56 "../src/pdfReader.vala"
	_g_free0 (_tmp29_);
#line 57 "../src/pdfReader.vala"
	_tmp32_ = _bookworm_app_book_ref0 (aBook);
#line 57 "../src/pdfReader.vala"
	result = _tmp32_;
#line 57 "../src/pdfReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 57 "../src/pdfReader.vala"
	return result;
#line 398 "pdfReader.c"
}

gchar*
bookworm_app_pdf_reader_extractEBook (const gchar* eBookLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* extractionLocation = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BookwormAppSettings* _tmp5_;
	BookwormAppSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	GString* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* result;
#line 60 "../src/pdfReader.vala"
	g_return_val_if_fail (eBookLocation != NULL, NULL);
#line 61 "../src/pdfReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:extractEBook] eBookLocation=", eBookLocation, NULL);
#line 61 "../src/pdfReader.vala"
	_tmp1_ = _tmp0_;
#line 61 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:61: %s", _tmp1_);
#line 61 "../src/pdfReader.vala"
	_g_free0 (_tmp1_);
#line 62 "../src/pdfReader.vala"
	_tmp2_ = g_strdup ("false");
#line 62 "../src/pdfReader.vala"
	extractionLocation = _tmp2_;
#line 63 "../src/pdfReader.vala"
	_tmp3_ = g_strconcat ("Initiated process for content extraction of PDF Book located at:", eBookLocation, NULL);
#line 63 "../src/pdfReader.vala"
	_tmp4_ = _tmp3_;
#line 63 "../src/pdfReader.vala"
	g_debug ("pdfReader.vala:63: %s", _tmp4_);
#line 63 "../src/pdfReader.vala"
	_g_free0 (_tmp4_);
#line 64 "../src/pdfReader.vala"
	_tmp5_ = bookworm_app_bookworm_settings;
#line 64 "../src/pdfReader.vala"
	if (_tmp5_ == NULL) {
#line 472 "pdfReader.c"
		BookwormAppSettings* _tmp6_;
#line 65 "../src/pdfReader.vala"
		_tmp6_ = bookworm_app_settings_get_instance ();
#line 65 "../src/pdfReader.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 65 "../src/pdfReader.vala"
		bookworm_app_bookworm_settings = _tmp6_;
#line 480 "pdfReader.c"
	}
#line 68 "../src/pdfReader.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 68 "../src/pdfReader.vala"
	_tmp8_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp7_);
#line 68 "../src/pdfReader.vala"
	_tmp9_ = _tmp8_;
#line 68 "../src/pdfReader.vala"
	if (_tmp9_) {
#line 490 "pdfReader.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 69 "../src/pdfReader.vala"
		_tmp10_ = bookworm_app_bookworm_bookworm_config_path;
#line 69 "../src/pdfReader.vala"
		_tmp11_ = g_strconcat (_tmp10_, "/books/", NULL);
#line 69 "../src/pdfReader.vala"
		_tmp12_ = _tmp11_;
#line 69 "../src/pdfReader.vala"
		_tmp13_ = g_file_new_for_path (eBookLocation);
#line 69 "../src/pdfReader.vala"
		_tmp14_ = _tmp13_;
#line 69 "../src/pdfReader.vala"
		_tmp15_ = g_file_get_basename (_tmp14_);
#line 69 "../src/pdfReader.vala"
		_tmp16_ = _tmp15_;
#line 69 "../src/pdfReader.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 69 "../src/pdfReader.vala"
		_g_free0 (extractionLocation);
#line 69 "../src/pdfReader.vala"
		extractionLocation = _tmp17_;
#line 69 "../src/pdfReader.vala"
		_g_free0 (_tmp16_);
#line 69 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp14_);
#line 69 "../src/pdfReader.vala"
		_g_free0 (_tmp12_);
#line 525 "pdfReader.c"
	} else {
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 71 "../src/pdfReader.vala"
		_tmp18_ = g_file_new_for_path (eBookLocation);
#line 71 "../src/pdfReader.vala"
		_tmp19_ = _tmp18_;
#line 71 "../src/pdfReader.vala"
		_tmp20_ = g_file_get_basename (_tmp19_);
#line 71 "../src/pdfReader.vala"
		_tmp21_ = _tmp20_;
#line 71 "../src/pdfReader.vala"
		_tmp22_ = g_strconcat (BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, _tmp21_, NULL);
#line 71 "../src/pdfReader.vala"
		_g_free0 (extractionLocation);
#line 71 "../src/pdfReader.vala"
		extractionLocation = _tmp22_;
#line 71 "../src/pdfReader.vala"
		_g_free0 (_tmp21_);
#line 71 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp19_);
#line 550 "pdfReader.c"
	}
#line 74 "../src/pdfReader.vala"
	_tmp23_ = extractionLocation;
#line 74 "../src/pdfReader.vala"
	_tmp24_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp23_, "", "");
#line 74 "../src/pdfReader.vala"
	_tmp25_ = _tmp24_;
#line 74 "../src/pdfReader.vala"
	_g_free0 (_tmp25_);
#line 76 "../src/pdfReader.vala"
	_tmp26_ = g_strdup ("pdftohtml");
#line 76 "../src/pdfReader.vala"
	_tmp27_ = g_strdup ("-noframes");
#line 76 "../src/pdfReader.vala"
	_tmp28_ = g_strdup ("-zoom");
#line 76 "../src/pdfReader.vala"
	_tmp29_ = g_strdup ("2.0");
#line 76 "../src/pdfReader.vala"
	_tmp30_ = g_strdup ("-wbt");
#line 76 "../src/pdfReader.vala"
	_tmp31_ = g_strdup ("20.0");
#line 76 "../src/pdfReader.vala"
	_tmp32_ = g_strdup ("-nomerge");
#line 76 "../src/pdfReader.vala"
	_tmp33_ = g_strdup (eBookLocation);
#line 76 "../src/pdfReader.vala"
	_tmp34_ = extractionLocation;
#line 76 "../src/pdfReader.vala"
	_tmp35_ = g_strconcat (_tmp34_, "/", NULL);
#line 76 "../src/pdfReader.vala"
	_tmp36_ = _tmp35_;
#line 76 "../src/pdfReader.vala"
	_tmp37_ = g_file_new_for_path (eBookLocation);
#line 76 "../src/pdfReader.vala"
	_tmp38_ = _tmp37_;
#line 76 "../src/pdfReader.vala"
	_tmp39_ = g_file_get_basename (_tmp38_);
#line 76 "../src/pdfReader.vala"
	_tmp40_ = _tmp39_;
#line 76 "../src/pdfReader.vala"
	_tmp41_ = g_strconcat (_tmp36_, _tmp40_, NULL);
#line 76 "../src/pdfReader.vala"
	_tmp42_ = _tmp41_;
#line 76 "../src/pdfReader.vala"
	_tmp43_ = g_strconcat (_tmp42_, ".html", NULL);
#line 76 "../src/pdfReader.vala"
	_tmp44_ = g_new0 (gchar*, 9 + 1);
#line 76 "../src/pdfReader.vala"
	_tmp44_[0] = _tmp26_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[1] = _tmp27_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[2] = _tmp28_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[3] = _tmp29_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[4] = _tmp30_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[5] = _tmp31_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[6] = _tmp32_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[7] = _tmp33_;
#line 76 "../src/pdfReader.vala"
	_tmp44_[8] = _tmp43_;
#line 76 "../src/pdfReader.vala"
	_tmp45_ = _tmp44_;
#line 76 "../src/pdfReader.vala"
	_tmp45__length1 = 9;
#line 76 "../src/pdfReader.vala"
	bookworm_app_utils_execute_async_multiarg_command_pipes (_tmp45_, (gint) 9);
#line 76 "../src/pdfReader.vala"
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
#line 76 "../src/pdfReader.vala"
	_g_free0 (_tmp42_);
#line 76 "../src/pdfReader.vala"
	_g_free0 (_tmp40_);
#line 76 "../src/pdfReader.vala"
	_g_object_unref0 (_tmp38_);
#line 76 "../src/pdfReader.vala"
	_g_free0 (_tmp36_);
#line 85 "../src/pdfReader.vala"
	_tmp46_ = bookworm_app_utils_spawn_async_with_pipes_output;
#line 85 "../src/pdfReader.vala"
	_tmp47_ = _tmp46_->str;
#line 85 "../src/pdfReader.vala"
	_tmp48_ = g_strconcat ("Output of pdftohtml command:", _tmp47_, NULL);
#line 85 "../src/pdfReader.vala"
	_tmp49_ = _tmp48_;
#line 85 "../src/pdfReader.vala"
	g_debug ("pdfReader.vala:85: %s", _tmp49_);
#line 85 "../src/pdfReader.vala"
	_g_free0 (_tmp49_);
#line 86 "../src/pdfReader.vala"
	_tmp50_ = extractionLocation;
#line 86 "../src/pdfReader.vala"
	_tmp51_ = g_strconcat ("[END] [FUNCTION:extractEBook] extractionLocation=", _tmp50_, NULL);
#line 86 "../src/pdfReader.vala"
	_tmp52_ = _tmp51_;
#line 86 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:86: %s", _tmp52_);
#line 86 "../src/pdfReader.vala"
	_g_free0 (_tmp52_);
#line 87 "../src/pdfReader.vala"
	result = extractionLocation;
#line 87 "../src/pdfReader.vala"
	return result;
#line 658 "pdfReader.c"
}

BookwormAppBook*
bookworm_app_pdf_reader_getContentList (BookwormAppBook* aBook,
                                        const gchar* extractionLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* extractedHTMLFilePath = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* htmlFile = NULL;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	BookwormAppBook* _tmp94_;
	GError* _inner_error0_ = NULL;
	BookwormAppBook* result;
#line 90 "../src/pdfReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 90 "../src/pdfReader.vala"
	g_return_val_if_fail (extractionLocation != NULL, NULL);
#line 91 "../src/pdfReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getContentList] extractionLocation=", extractionLocation, NULL);
#line 91 "../src/pdfReader.vala"
	_tmp1_ = _tmp0_;
#line 91 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:91: %s", _tmp1_);
#line 91 "../src/pdfReader.vala"
	_g_free0 (_tmp1_);
#line 92 "../src/pdfReader.vala"
	_tmp2_ = g_strconcat (extractionLocation, "/", NULL);
#line 92 "../src/pdfReader.vala"
	_tmp3_ = _tmp2_;
#line 92 "../src/pdfReader.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 92 "../src/pdfReader.vala"
	_tmp5_ = _tmp4_;
#line 92 "../src/pdfReader.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 92 "../src/pdfReader.vala"
	_tmp7_ = _tmp6_;
#line 92 "../src/pdfReader.vala"
	_tmp8_ = g_file_get_basename (_tmp7_);
#line 92 "../src/pdfReader.vala"
	_tmp9_ = _tmp8_;
#line 92 "../src/pdfReader.vala"
	_tmp10_ = g_strconcat (_tmp3_, _tmp9_, NULL);
#line 92 "../src/pdfReader.vala"
	_tmp11_ = _tmp10_;
#line 92 "../src/pdfReader.vala"
	_tmp12_ = g_strconcat (_tmp11_, ".html", NULL);
#line 92 "../src/pdfReader.vala"
	_tmp13_ = _tmp12_;
#line 92 "../src/pdfReader.vala"
	_g_free0 (_tmp11_);
#line 92 "../src/pdfReader.vala"
	_g_free0 (_tmp9_);
#line 92 "../src/pdfReader.vala"
	_g_object_unref0 (_tmp7_);
#line 92 "../src/pdfReader.vala"
	_g_free0 (_tmp5_);
#line 92 "../src/pdfReader.vala"
	_g_free0 (_tmp3_);
#line 92 "../src/pdfReader.vala"
	extractedHTMLFilePath = _tmp13_;
#line 93 "../src/pdfReader.vala"
	_tmp14_ = extractedHTMLFilePath;
#line 93 "../src/pdfReader.vala"
	_tmp15_ = g_file_new_for_path (_tmp14_);
#line 93 "../src/pdfReader.vala"
	htmlFile = _tmp15_;
#line 95 "../src/pdfReader.vala"
	_tmp16_ = htmlFile;
#line 95 "../src/pdfReader.vala"
	if (!g_file_query_exists (_tmp16_, NULL)) {
#line 747 "pdfReader.c"
		BookwormAppBook* _tmp17_;
#line 96 "../src/pdfReader.vala"
		bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 97 "../src/pdfReader.vala"
		bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 98 "../src/pdfReader.vala"
		_tmp17_ = _bookworm_app_book_ref0 (aBook);
#line 98 "../src/pdfReader.vala"
		result = _tmp17_;
#line 98 "../src/pdfReader.vala"
		_g_object_unref0 (htmlFile);
#line 98 "../src/pdfReader.vala"
		_g_free0 (extractedHTMLFilePath);
#line 98 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 98 "../src/pdfReader.vala"
		return result;
#line 765 "pdfReader.c"
	}
	{
		GFileInputStream* _tmp18_ = NULL;
		GFile* _tmp19_;
		GFileInputStream* _tmp20_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp21_;
		gchar* line = NULL;
		gchar* _tmp22_;
		gint countOfSections = 0;
		gchar* htmlStartContent = NULL;
		gchar* _tmp23_;
		GString* htmlSection = NULL;
		const gchar* _tmp24_;
		GString* _tmp25_;
#line 103 "../src/pdfReader.vala"
		bookworm_app_book_clearBookContentList (aBook);
#line 106 "../src/pdfReader.vala"
		_tmp19_ = htmlFile;
#line 106 "../src/pdfReader.vala"
		_tmp20_ = g_file_read (_tmp19_, NULL, &_inner_error0_);
#line 106 "../src/pdfReader.vala"
		_tmp18_ = _tmp20_;
#line 106 "../src/pdfReader.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 791 "pdfReader.c"
			goto __catch0_g_error;
		}
#line 106 "../src/pdfReader.vala"
		_tmp21_ = g_data_input_stream_new ((GInputStream*) _tmp18_);
#line 106 "../src/pdfReader.vala"
		dis = _tmp21_;
#line 107 "../src/pdfReader.vala"
		_tmp22_ = g_strdup ("");
#line 107 "../src/pdfReader.vala"
		line = _tmp22_;
#line 108 "../src/pdfReader.vala"
		countOfSections = 1;
#line 109 "../src/pdfReader.vala"
		_tmp23_ = g_strdup ("<html><body>");
#line 109 "../src/pdfReader.vala"
		htmlStartContent = _tmp23_;
#line 110 "../src/pdfReader.vala"
		_tmp24_ = htmlStartContent;
#line 110 "../src/pdfReader.vala"
		_tmp25_ = g_string_new (_tmp24_);
#line 110 "../src/pdfReader.vala"
		htmlSection = _tmp25_;
#line 112 "../src/pdfReader.vala"
		while (TRUE) {
#line 816 "pdfReader.c"
			gchar* _tmp26_ = NULL;
			GDataInputStream* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gboolean _tmp36_;
#line 112 "../src/pdfReader.vala"
			_tmp27_ = dis;
#line 112 "../src/pdfReader.vala"
			_tmp28_ = g_data_input_stream_read_line (_tmp27_, NULL, NULL, &_inner_error0_);
#line 112 "../src/pdfReader.vala"
			_tmp26_ = _tmp28_;
#line 112 "../src/pdfReader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 112 "../src/pdfReader.vala"
				_g_string_free0 (htmlSection);
#line 112 "../src/pdfReader.vala"
				_g_free0 (htmlStartContent);
#line 112 "../src/pdfReader.vala"
				_g_free0 (line);
#line 112 "../src/pdfReader.vala"
				_g_object_unref0 (dis);
#line 112 "../src/pdfReader.vala"
				_g_object_unref0 (_tmp18_);
#line 846 "pdfReader.c"
				goto __catch0_g_error;
			}
#line 112 "../src/pdfReader.vala"
			_tmp29_ = _tmp26_;
#line 112 "../src/pdfReader.vala"
			_tmp26_ = NULL;
#line 112 "../src/pdfReader.vala"
			_g_free0 (line);
#line 112 "../src/pdfReader.vala"
			line = _tmp29_;
#line 112 "../src/pdfReader.vala"
			_tmp30_ = line;
#line 112 "../src/pdfReader.vala"
			if (!(_tmp30_ != NULL)) {
#line 112 "../src/pdfReader.vala"
				_g_free0 (_tmp26_);
#line 112 "../src/pdfReader.vala"
				break;
#line 865 "pdfReader.c"
			}
#line 114 "../src/pdfReader.vala"
			_tmp31_ = g_utf8_strup ("<hr/>", (gssize) -1);
#line 114 "../src/pdfReader.vala"
			_tmp32_ = _tmp31_;
#line 114 "../src/pdfReader.vala"
			_tmp33_ = line;
#line 114 "../src/pdfReader.vala"
			_tmp34_ = g_utf8_strup (_tmp33_, (gssize) -1);
#line 114 "../src/pdfReader.vala"
			_tmp35_ = _tmp34_;
#line 114 "../src/pdfReader.vala"
			_tmp36_ = g_strcmp0 (_tmp32_, _tmp35_) == 0;
#line 114 "../src/pdfReader.vala"
			_g_free0 (_tmp35_);
#line 114 "../src/pdfReader.vala"
			_g_free0 (_tmp32_);
#line 114 "../src/pdfReader.vala"
			if (_tmp36_) {
#line 885 "pdfReader.c"
				GString* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				GFile* _tmp40_;
				GFile* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				GString* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				GFile* _tmp60_;
				GFile* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gint _tmp74_;
				GString* _tmp75_;
				const gchar* _tmp76_;
#line 115 "../src/pdfReader.vala"
				_tmp37_ = htmlSection;
#line 115 "../src/pdfReader.vala"
				g_string_append (_tmp37_, "</body></html>");
#line 116 "../src/pdfReader.vala"
				_tmp38_ = bookworm_app_book_getBookLocation (aBook);
#line 116 "../src/pdfReader.vala"
				_tmp39_ = _tmp38_;
#line 116 "../src/pdfReader.vala"
				_tmp40_ = g_file_new_for_path (_tmp39_);
#line 116 "../src/pdfReader.vala"
				_tmp41_ = _tmp40_;
#line 116 "../src/pdfReader.vala"
				_tmp42_ = g_file_get_basename (_tmp41_);
#line 116 "../src/pdfReader.vala"
				_tmp43_ = _tmp42_;
#line 116 "../src/pdfReader.vala"
				_tmp44_ = g_strconcat (_tmp43_, "_", NULL);
#line 116 "../src/pdfReader.vala"
				_tmp45_ = _tmp44_;
#line 116 "../src/pdfReader.vala"
				_tmp46_ = g_strdup_printf ("%i", countOfSections);
#line 116 "../src/pdfReader.vala"
				_tmp47_ = _tmp46_;
#line 116 "../src/pdfReader.vala"
				_tmp48_ = g_strconcat (_tmp45_, _tmp47_, NULL);
#line 116 "../src/pdfReader.vala"
				_tmp49_ = _tmp48_;
#line 116 "../src/pdfReader.vala"
				_tmp50_ = g_strconcat (_tmp49_, ".html", NULL);
#line 116 "../src/pdfReader.vala"
				_tmp51_ = _tmp50_;
#line 116 "../src/pdfReader.vala"
				_tmp52_ = htmlSection;
#line 116 "../src/pdfReader.vala"
				_tmp53_ = _tmp52_->str;
#line 116 "../src/pdfReader.vala"
				_tmp54_ = bookworm_app_utils_fileOperations ("WRITE", extractionLocation, _tmp51_, _tmp53_);
#line 116 "../src/pdfReader.vala"
				_tmp55_ = _tmp54_;
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp55_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp51_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp49_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp47_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp45_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp43_);
#line 116 "../src/pdfReader.vala"
				_g_object_unref0 (_tmp41_);
#line 116 "../src/pdfReader.vala"
				_g_free0 (_tmp39_);
#line 119 "../src/pdfReader.vala"
				_tmp56_ = g_strconcat (extractionLocation, "/", NULL);
#line 119 "../src/pdfReader.vala"
				_tmp57_ = _tmp56_;
#line 119 "../src/pdfReader.vala"
				_tmp58_ = bookworm_app_book_getBookLocation (aBook);
#line 119 "../src/pdfReader.vala"
				_tmp59_ = _tmp58_;
#line 119 "../src/pdfReader.vala"
				_tmp60_ = g_file_new_for_path (_tmp59_);
#line 119 "../src/pdfReader.vala"
				_tmp61_ = _tmp60_;
#line 119 "../src/pdfReader.vala"
				_tmp62_ = g_file_get_basename (_tmp61_);
#line 119 "../src/pdfReader.vala"
				_tmp63_ = _tmp62_;
#line 119 "../src/pdfReader.vala"
				_tmp64_ = g_strconcat (_tmp57_, _tmp63_, NULL);
#line 119 "../src/pdfReader.vala"
				_tmp65_ = _tmp64_;
#line 119 "../src/pdfReader.vala"
				_tmp66_ = g_strconcat (_tmp65_, "_", NULL);
#line 119 "../src/pdfReader.vala"
				_tmp67_ = _tmp66_;
#line 119 "../src/pdfReader.vala"
				_tmp68_ = g_strdup_printf ("%i", countOfSections);
#line 119 "../src/pdfReader.vala"
				_tmp69_ = _tmp68_;
#line 119 "../src/pdfReader.vala"
				_tmp70_ = g_strconcat (_tmp67_, _tmp69_, NULL);
#line 119 "../src/pdfReader.vala"
				_tmp71_ = _tmp70_;
#line 119 "../src/pdfReader.vala"
				_tmp72_ = g_strconcat (_tmp71_, ".html", NULL);
#line 119 "../src/pdfReader.vala"
				_tmp73_ = _tmp72_;
#line 119 "../src/pdfReader.vala"
				bookworm_app_book_setBookContentList (aBook, _tmp73_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp73_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp71_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp69_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp67_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp65_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp63_);
#line 119 "../src/pdfReader.vala"
				_g_object_unref0 (_tmp61_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp59_);
#line 119 "../src/pdfReader.vala"
				_g_free0 (_tmp57_);
#line 120 "../src/pdfReader.vala"
				_tmp74_ = countOfSections;
#line 120 "../src/pdfReader.vala"
				countOfSections = _tmp74_ + 1;
#line 121 "../src/pdfReader.vala"
				_tmp75_ = htmlSection;
#line 121 "../src/pdfReader.vala"
				_tmp76_ = htmlStartContent;
#line 121 "../src/pdfReader.vala"
				g_string_assign (_tmp75_, _tmp76_);
#line 1048 "pdfReader.c"
			} else {
				GString* _tmp77_;
				const gchar* _tmp78_;
#line 124 "../src/pdfReader.vala"
				_tmp77_ = htmlSection;
#line 124 "../src/pdfReader.vala"
				_tmp78_ = line;
#line 124 "../src/pdfReader.vala"
				g_string_append (_tmp77_, _tmp78_);
#line 1058 "pdfReader.c"
			}
#line 112 "../src/pdfReader.vala"
			_g_free0 (_tmp26_);
#line 1062 "pdfReader.c"
		}
#line 101 "../src/pdfReader.vala"
		_g_string_free0 (htmlSection);
#line 101 "../src/pdfReader.vala"
		_g_free0 (htmlStartContent);
#line 101 "../src/pdfReader.vala"
		_g_free0 (line);
#line 101 "../src/pdfReader.vala"
		_g_object_unref0 (dis);
#line 101 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp18_);
#line 1074 "pdfReader.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		GError* _tmp87_;
		const gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		BookwormAppBook* _tmp91_;
#line 101 "../src/pdfReader.vala"
		e = _inner_error0_;
#line 101 "../src/pdfReader.vala"
		_inner_error0_ = NULL;
#line 128 "../src/pdfReader.vala"
		_tmp79_ = e;
#line 128 "../src/pdfReader.vala"
		_tmp80_ = _tmp79_->message;
#line 128 "../src/pdfReader.vala"
		g_info ("pdfReader.vala:128: %s", _tmp80_);
#line 129 "../src/pdfReader.vala"
		_tmp81_ = bookworm_app_book_getBookLocation (aBook);
#line 129 "../src/pdfReader.vala"
		_tmp82_ = _tmp81_;
#line 129 "../src/pdfReader.vala"
		_tmp83_ = g_strconcat ("Problem in Content splitting for PDF Book [", _tmp82_, NULL);
#line 129 "../src/pdfReader.vala"
		_tmp84_ = _tmp83_;
#line 129 "../src/pdfReader.vala"
		_tmp85_ = g_strconcat (_tmp84_, "]:%s", NULL);
#line 129 "../src/pdfReader.vala"
		_tmp86_ = _tmp85_;
#line 129 "../src/pdfReader.vala"
		_tmp87_ = e;
#line 129 "../src/pdfReader.vala"
		_tmp88_ = _tmp87_->message;
#line 129 "../src/pdfReader.vala"
		_tmp89_ = g_strconcat (_tmp86_, _tmp88_, NULL);
#line 129 "../src/pdfReader.vala"
		_tmp90_ = _tmp89_;
#line 129 "../src/pdfReader.vala"
		g_warning ("pdfReader.vala:129: %s", _tmp90_);
#line 129 "../src/pdfReader.vala"
		_g_free0 (_tmp90_);
#line 129 "../src/pdfReader.vala"
		_g_free0 (_tmp86_);
#line 129 "../src/pdfReader.vala"
		_g_free0 (_tmp84_);
#line 129 "../src/pdfReader.vala"
		_g_free0 (_tmp82_);
#line 130 "../src/pdfReader.vala"
		bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 131 "../src/pdfReader.vala"
		bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 132 "../src/pdfReader.vala"
		_tmp91_ = _bookworm_app_book_ref0 (aBook);
#line 132 "../src/pdfReader.vala"
		result = _tmp91_;
#line 132 "../src/pdfReader.vala"
		_g_error_free0 (e);
#line 132 "../src/pdfReader.vala"
		_g_object_unref0 (htmlFile);
#line 132 "../src/pdfReader.vala"
		_g_free0 (extractedHTMLFilePath);
#line 132 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 132 "../src/pdfReader.vala"
		return result;
#line 1151 "pdfReader.c"
	}
	__finally0:
#line 101 "../src/pdfReader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 101 "../src/pdfReader.vala"
		_g_object_unref0 (htmlFile);
#line 101 "../src/pdfReader.vala"
		_g_free0 (extractedHTMLFilePath);
#line 101 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 101 "../src/pdfReader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 101 "../src/pdfReader.vala"
		g_clear_error (&_inner_error0_);
#line 101 "../src/pdfReader.vala"
		return NULL;
#line 1168 "pdfReader.c"
	}
#line 134 "../src/pdfReader.vala"
	_tmp92_ = g_strconcat ("[END] [FUNCTION:getContentList] extractionLocation=", extractionLocation, NULL);
#line 134 "../src/pdfReader.vala"
	_tmp93_ = _tmp92_;
#line 134 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:134: %s", _tmp93_);
#line 134 "../src/pdfReader.vala"
	_g_free0 (_tmp93_);
#line 135 "../src/pdfReader.vala"
	_tmp94_ = _bookworm_app_book_ref0 (aBook);
#line 135 "../src/pdfReader.vala"
	result = _tmp94_;
#line 135 "../src/pdfReader.vala"
	_g_object_unref0 (htmlFile);
#line 135 "../src/pdfReader.vala"
	_g_free0 (extractedHTMLFilePath);
#line 135 "../src/pdfReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 135 "../src/pdfReader.vala"
	return result;
#line 1190 "pdfReader.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1214 "pdfReader.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1222 "pdfReader.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1228 "pdfReader.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1256 "pdfReader.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1262 "pdfReader.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1268 "pdfReader.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1272 "pdfReader.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1280 "pdfReader.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1284 "pdfReader.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1296 "pdfReader.c"
}

BookwormAppBook*
bookworm_app_pdf_reader_setCoverImage (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* bookCoverLocation = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	BookwormAppBook* _tmp47_;
	BookwormAppBook* result;
#line 138 "../src/pdfReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 139 "../src/pdfReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 139 "../src/pdfReader.vala"
	_tmp1_ = _tmp0_;
#line 139 "../src/pdfReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setCoverImage] book.location=", _tmp1_, NULL);
#line 139 "../src/pdfReader.vala"
	_tmp3_ = _tmp2_;
#line 139 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:139: %s", _tmp3_);
#line 139 "../src/pdfReader.vala"
	_g_free0 (_tmp3_);
#line 139 "../src/pdfReader.vala"
	_g_free0 (_tmp1_);
#line 140 "../src/pdfReader.vala"
	_tmp4_ = g_strdup ("");
#line 140 "../src/pdfReader.vala"
	bookCoverLocation = _tmp4_;
#line 142 "../src/pdfReader.vala"
	_tmp6_ = bookworm_app_book_getBookContentList (aBook);
#line 142 "../src/pdfReader.vala"
	_tmp7_ = _tmp6_;
#line 142 "../src/pdfReader.vala"
	_tmp8_ = _tmp7_ != NULL;
#line 142 "../src/pdfReader.vala"
	_g_object_unref0 (_tmp7_);
#line 142 "../src/pdfReader.vala"
	if (_tmp8_) {
#line 1347 "pdfReader.c"
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 142 "../src/pdfReader.vala"
		_tmp9_ = bookworm_app_book_getBookContentList (aBook);
#line 142 "../src/pdfReader.vala"
		_tmp10_ = _tmp9_;
#line 142 "../src/pdfReader.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 142 "../src/pdfReader.vala"
		_tmp12_ = _tmp11_;
#line 142 "../src/pdfReader.vala"
		_tmp5_ = _tmp12_ > 0;
#line 142 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp10_);
#line 1364 "pdfReader.c"
	} else {
#line 142 "../src/pdfReader.vala"
		_tmp5_ = FALSE;
#line 1368 "pdfReader.c"
	}
#line 142 "../src/pdfReader.vala"
	if (_tmp5_) {
#line 1372 "pdfReader.c"
		gchar* htmlForCover = NULL;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
#line 143 "../src/pdfReader.vala"
		_tmp13_ = bookworm_app_book_getBookContentList (aBook);
#line 143 "../src/pdfReader.vala"
		_tmp14_ = _tmp13_;
#line 143 "../src/pdfReader.vala"
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
#line 143 "../src/pdfReader.vala"
		_tmp16_ = (gchar*) _tmp15_;
#line 143 "../src/pdfReader.vala"
		_tmp17_ = bookworm_app_utils_fileOperations ("READ_FILE", _tmp16_, "", "");
#line 143 "../src/pdfReader.vala"
		_tmp18_ = _tmp17_;
#line 143 "../src/pdfReader.vala"
		_g_free0 (_tmp16_);
#line 143 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp14_);
#line 143 "../src/pdfReader.vala"
		htmlForCover = _tmp18_;
#line 144 "../src/pdfReader.vala"
		_tmp19_ = htmlForCover;
#line 144 "../src/pdfReader.vala"
		if (string_index_of (_tmp19_, "<img src=\"", 0) != -1) {
#line 1403 "pdfReader.c"
			gint startPosOfCoverImage = 0;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint endPosOfCoverImage = 0;
			const gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp28_ = FALSE;
			const gchar* _tmp29_;
#line 145 "../src/pdfReader.vala"
			_tmp20_ = htmlForCover;
#line 145 "../src/pdfReader.vala"
			_tmp21_ = strlen ("<img src=\"");
#line 145 "../src/pdfReader.vala"
			_tmp22_ = _tmp21_;
#line 145 "../src/pdfReader.vala"
			startPosOfCoverImage = string_index_of (_tmp20_, "<img src=\"", 0) + _tmp22_;
#line 146 "../src/pdfReader.vala"
			_tmp23_ = htmlForCover;
#line 146 "../src/pdfReader.vala"
			endPosOfCoverImage = string_index_of (_tmp23_, "\"/>", startPosOfCoverImage);
#line 147 "../src/pdfReader.vala"
			if (startPosOfCoverImage != -1) {
#line 147 "../src/pdfReader.vala"
				_tmp25_ = endPosOfCoverImage != -1;
#line 1430 "pdfReader.c"
			} else {
#line 147 "../src/pdfReader.vala"
				_tmp25_ = FALSE;
#line 1434 "pdfReader.c"
			}
#line 147 "../src/pdfReader.vala"
			if (_tmp25_) {
#line 147 "../src/pdfReader.vala"
				_tmp24_ = endPosOfCoverImage > startPosOfCoverImage;
#line 1440 "pdfReader.c"
			} else {
#line 147 "../src/pdfReader.vala"
				_tmp24_ = FALSE;
#line 1444 "pdfReader.c"
			}
#line 147 "../src/pdfReader.vala"
			if (_tmp24_) {
#line 1448 "pdfReader.c"
				const gchar* _tmp26_;
				gchar* _tmp27_;
#line 148 "../src/pdfReader.vala"
				_tmp26_ = htmlForCover;
#line 148 "../src/pdfReader.vala"
				_tmp27_ = string_slice (_tmp26_, (glong) startPosOfCoverImage, (glong) endPosOfCoverImage);
#line 148 "../src/pdfReader.vala"
				_g_free0 (bookCoverLocation);
#line 148 "../src/pdfReader.vala"
				bookCoverLocation = _tmp27_;
#line 1459 "pdfReader.c"
			}
#line 150 "../src/pdfReader.vala"
			_tmp29_ = bookCoverLocation;
#line 150 "../src/pdfReader.vala"
			if (_tmp29_ == NULL) {
#line 150 "../src/pdfReader.vala"
				_tmp28_ = TRUE;
#line 1467 "pdfReader.c"
			} else {
				const gchar* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
#line 150 "../src/pdfReader.vala"
				_tmp30_ = bookCoverLocation;
#line 150 "../src/pdfReader.vala"
				_tmp31_ = strlen (_tmp30_);
#line 150 "../src/pdfReader.vala"
				_tmp32_ = _tmp31_;
#line 150 "../src/pdfReader.vala"
				_tmp28_ = _tmp32_ < 1;
#line 1480 "pdfReader.c"
			}
#line 150 "../src/pdfReader.vala"
			if (_tmp28_) {
#line 1484 "pdfReader.c"
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
#line 151 "../src/pdfReader.vala"
				bookworm_app_book_setIsBookCoverImagePresent (aBook, FALSE);
#line 152 "../src/pdfReader.vala"
				_tmp33_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 152 "../src/pdfReader.vala"
				_tmp34_ = _tmp33_;
#line 152 "../src/pdfReader.vala"
				_tmp35_ = g_strconcat ("Cover image not found for book located at:", _tmp34_, NULL);
#line 152 "../src/pdfReader.vala"
				_tmp36_ = _tmp35_;
#line 152 "../src/pdfReader.vala"
				g_debug ("pdfReader.vala:152: %s", _tmp36_);
#line 152 "../src/pdfReader.vala"
				_g_free0 (_tmp36_);
#line 152 "../src/pdfReader.vala"
				_g_free0 (_tmp34_);
#line 1505 "pdfReader.c"
			} else {
				BookwormAppBook* _tmp37_;
				const gchar* _tmp38_;
				BookwormAppBook* _tmp39_;
#line 155 "../src/pdfReader.vala"
				_tmp37_ = _bookworm_app_book_ref0 (aBook);
#line 155 "../src/pdfReader.vala"
				_tmp38_ = bookCoverLocation;
#line 155 "../src/pdfReader.vala"
				_tmp39_ = bookworm_app_utils_setBookCoverImage (_tmp37_, _tmp38_);
#line 155 "../src/pdfReader.vala"
				_bookworm_app_book_unref0 (aBook);
#line 155 "../src/pdfReader.vala"
				aBook = _tmp39_;
#line 1520 "pdfReader.c"
			}
		}
#line 142 "../src/pdfReader.vala"
		_g_free0 (htmlForCover);
#line 1525 "pdfReader.c"
	} else {
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
#line 159 "../src/pdfReader.vala"
		bookworm_app_book_setIsBookCoverImagePresent (aBook, FALSE);
#line 160 "../src/pdfReader.vala"
		_tmp40_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 160 "../src/pdfReader.vala"
		_tmp41_ = _tmp40_;
#line 160 "../src/pdfReader.vala"
		_tmp42_ = g_strconcat ("Cover image not found for book located at:", _tmp41_, NULL);
#line 160 "../src/pdfReader.vala"
		_tmp43_ = _tmp42_;
#line 160 "../src/pdfReader.vala"
		g_debug ("pdfReader.vala:160: %s", _tmp43_);
#line 160 "../src/pdfReader.vala"
		_g_free0 (_tmp43_);
#line 160 "../src/pdfReader.vala"
		_g_free0 (_tmp41_);
#line 1547 "pdfReader.c"
	}
#line 162 "../src/pdfReader.vala"
	_tmp44_ = bookCoverLocation;
#line 162 "../src/pdfReader.vala"
	_tmp45_ = g_strconcat ("[END] [FUNCTION:setCoverImage] bookCoverLocation=", _tmp44_, NULL);
#line 162 "../src/pdfReader.vala"
	_tmp46_ = _tmp45_;
#line 162 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:162: %s", _tmp46_);
#line 162 "../src/pdfReader.vala"
	_g_free0 (_tmp46_);
#line 163 "../src/pdfReader.vala"
	_tmp47_ = _bookworm_app_book_ref0 (aBook);
#line 163 "../src/pdfReader.vala"
	result = _tmp47_;
#line 163 "../src/pdfReader.vala"
	_g_free0 (bookCoverLocation);
#line 163 "../src/pdfReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 163 "../src/pdfReader.vala"
	return result;
#line 1569 "pdfReader.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1593 "pdfReader.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 1601 "pdfReader.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 1607 "pdfReader.c"
	}
}

BookwormAppBook*
bookworm_app_pdf_reader_setBookMetaData (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* bookTitle = NULL;
	gchar* _tmp4_;
	PopplerDocument* pdfDocument = NULL;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	BookwormAppBook* _tmp68_;
	GError* _inner_error0_ = NULL;
	BookwormAppBook* result;
#line 166 "../src/pdfReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 167 "../src/pdfReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 167 "../src/pdfReader.vala"
	_tmp1_ = _tmp0_;
#line 167 "../src/pdfReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setBookMetaData] book.location=", _tmp1_, NULL);
#line 167 "../src/pdfReader.vala"
	_tmp3_ = _tmp2_;
#line 167 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:167: %s", _tmp3_);
#line 167 "../src/pdfReader.vala"
	_g_free0 (_tmp3_);
#line 167 "../src/pdfReader.vala"
	_g_free0 (_tmp1_);
#line 168 "../src/pdfReader.vala"
	_tmp4_ = g_strdup ("");
#line 168 "../src/pdfReader.vala"
	bookTitle = _tmp4_;
#line 169 "../src/pdfReader.vala"
	pdfDocument = NULL;
#line 1650 "pdfReader.c"
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gboolean _tmp12_;
#line 172 "../src/pdfReader.vala"
		_tmp5_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 172 "../src/pdfReader.vala"
		_tmp6_ = _tmp5_;
#line 172 "../src/pdfReader.vala"
		_tmp7_ = g_strconcat ("Initiated process for title of eBook located at:", _tmp6_, NULL);
#line 172 "../src/pdfReader.vala"
		_tmp8_ = _tmp7_;
#line 172 "../src/pdfReader.vala"
		g_debug ("pdfReader.vala:172: %s", _tmp8_);
#line 172 "../src/pdfReader.vala"
		_g_free0 (_tmp8_);
#line 172 "../src/pdfReader.vala"
		_g_free0 (_tmp6_);
#line 173 "../src/pdfReader.vala"
		_tmp10_ = bookworm_app_book_getBookTitle (aBook);
#line 173 "../src/pdfReader.vala"
		_tmp11_ = _tmp10_;
#line 173 "../src/pdfReader.vala"
		_tmp12_ = _tmp11_ != NULL;
#line 173 "../src/pdfReader.vala"
		_g_free0 (_tmp11_);
#line 173 "../src/pdfReader.vala"
		if (_tmp12_) {
#line 1684 "pdfReader.c"
			gchar* _tmp13_;
			gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 173 "../src/pdfReader.vala"
			_tmp13_ = bookworm_app_book_getBookTitle (aBook);
#line 173 "../src/pdfReader.vala"
			_tmp14_ = _tmp13_;
#line 173 "../src/pdfReader.vala"
			_tmp15_ = strlen (_tmp14_);
#line 173 "../src/pdfReader.vala"
			_tmp16_ = _tmp15_;
#line 173 "../src/pdfReader.vala"
			_tmp9_ = _tmp16_ < 1;
#line 173 "../src/pdfReader.vala"
			_g_free0 (_tmp14_);
#line 1701 "pdfReader.c"
		} else {
#line 173 "../src/pdfReader.vala"
			_tmp9_ = FALSE;
#line 1705 "pdfReader.c"
		}
#line 173 "../src/pdfReader.vala"
		if (_tmp9_) {
#line 1709 "pdfReader.c"
			PopplerDocument* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			PopplerDocument* _tmp22_;
			PopplerDocument* _tmp23_;
			PopplerDocument* _tmp24_;
			PopplerDocument* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
#line 174 "../src/pdfReader.vala"
			_tmp18_ = bookworm_app_book_getBookLocation (aBook);
#line 174 "../src/pdfReader.vala"
			_tmp19_ = _tmp18_;
#line 174 "../src/pdfReader.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 174 "../src/pdfReader.vala"
			_tmp21_ = _tmp20_;
#line 174 "../src/pdfReader.vala"
			_tmp22_ = poppler_document_new_from_gfile (_tmp21_, NULL, NULL, &_inner_error0_);
#line 174 "../src/pdfReader.vala"
			_tmp23_ = _tmp22_;
#line 174 "../src/pdfReader.vala"
			_g_object_unref0 (_tmp21_);
#line 174 "../src/pdfReader.vala"
			_g_free0 (_tmp19_);
#line 174 "../src/pdfReader.vala"
			_tmp17_ = _tmp23_;
#line 174 "../src/pdfReader.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1742 "pdfReader.c"
				goto __catch0_g_error;
			}
#line 174 "../src/pdfReader.vala"
			_tmp24_ = _tmp17_;
#line 174 "../src/pdfReader.vala"
			_tmp17_ = NULL;
#line 174 "../src/pdfReader.vala"
			_g_object_unref0 (pdfDocument);
#line 174 "../src/pdfReader.vala"
			pdfDocument = _tmp24_;
#line 175 "../src/pdfReader.vala"
			_tmp25_ = pdfDocument;
#line 175 "../src/pdfReader.vala"
			_tmp26_ = poppler_document_get_title (_tmp25_);
#line 175 "../src/pdfReader.vala"
			_g_free0 (bookTitle);
#line 175 "../src/pdfReader.vala"
			bookTitle = _tmp26_;
#line 176 "../src/pdfReader.vala"
			_tmp28_ = bookTitle;
#line 176 "../src/pdfReader.vala"
			if (_tmp28_ != NULL) {
#line 1765 "pdfReader.c"
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 176 "../src/pdfReader.vala"
				_tmp29_ = bookTitle;
#line 176 "../src/pdfReader.vala"
				_tmp30_ = strlen (_tmp29_);
#line 176 "../src/pdfReader.vala"
				_tmp31_ = _tmp30_;
#line 176 "../src/pdfReader.vala"
				_tmp27_ = _tmp31_ > 0;
#line 1777 "pdfReader.c"
			} else {
#line 176 "../src/pdfReader.vala"
				_tmp27_ = FALSE;
#line 1781 "pdfReader.c"
			}
#line 176 "../src/pdfReader.vala"
			if (_tmp27_) {
#line 1785 "pdfReader.c"
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
#line 177 "../src/pdfReader.vala"
				_tmp32_ = bookTitle;
#line 177 "../src/pdfReader.vala"
				bookworm_app_book_setBookTitle (aBook, _tmp32_);
#line 178 "../src/pdfReader.vala"
				_tmp33_ = bookTitle;
#line 178 "../src/pdfReader.vala"
				_tmp34_ = g_strconcat ("Determined Title as:", _tmp33_, NULL);
#line 178 "../src/pdfReader.vala"
				_tmp35_ = _tmp34_;
#line 178 "../src/pdfReader.vala"
				_tmp36_ = g_strconcat (_tmp35_, " for book located at:", NULL);
#line 178 "../src/pdfReader.vala"
				_tmp37_ = _tmp36_;
#line 178 "../src/pdfReader.vala"
				_tmp38_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 178 "../src/pdfReader.vala"
				_tmp39_ = _tmp38_;
#line 178 "../src/pdfReader.vala"
				_tmp40_ = g_strconcat (_tmp37_, _tmp39_, NULL);
#line 178 "../src/pdfReader.vala"
				_tmp41_ = _tmp40_;
#line 178 "../src/pdfReader.vala"
				g_debug ("pdfReader.vala:178: %s", _tmp41_);
#line 178 "../src/pdfReader.vala"
				_g_free0 (_tmp41_);
#line 178 "../src/pdfReader.vala"
				_g_free0 (_tmp39_);
#line 178 "../src/pdfReader.vala"
				_g_free0 (_tmp37_);
#line 178 "../src/pdfReader.vala"
				_g_free0 (_tmp35_);
#line 1828 "pdfReader.c"
			} else {
				gchar* _tmp42_;
				gchar* _tmp43_;
				GFile* _tmp44_;
				GFile* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp51_;
#line 181 "../src/pdfReader.vala"
				_tmp42_ = bookworm_app_book_getBookLocation (aBook);
#line 181 "../src/pdfReader.vala"
				_tmp43_ = _tmp42_;
#line 181 "../src/pdfReader.vala"
				_tmp44_ = g_file_new_for_path (_tmp43_);
#line 181 "../src/pdfReader.vala"
				_tmp45_ = _tmp44_;
#line 181 "../src/pdfReader.vala"
				_tmp46_ = g_file_get_basename (_tmp45_);
#line 181 "../src/pdfReader.vala"
				_g_free0 (bookTitle);
#line 181 "../src/pdfReader.vala"
				bookTitle = _tmp46_;
#line 181 "../src/pdfReader.vala"
				_g_object_unref0 (_tmp45_);
#line 181 "../src/pdfReader.vala"
				_g_free0 (_tmp43_);
#line 182 "../src/pdfReader.vala"
				_tmp47_ = bookTitle;
#line 182 "../src/pdfReader.vala"
				if (string_last_index_of (_tmp47_, ".", 0) != -1) {
#line 1859 "pdfReader.c"
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gchar* _tmp50_;
#line 183 "../src/pdfReader.vala"
					_tmp48_ = bookTitle;
#line 183 "../src/pdfReader.vala"
					_tmp49_ = bookTitle;
#line 183 "../src/pdfReader.vala"
					_tmp50_ = string_slice (_tmp48_, (glong) 0, (glong) string_last_index_of (_tmp49_, ".", 0));
#line 183 "../src/pdfReader.vala"
					_g_free0 (bookTitle);
#line 183 "../src/pdfReader.vala"
					bookTitle = _tmp50_;
#line 1873 "pdfReader.c"
				}
#line 185 "../src/pdfReader.vala"
				_tmp51_ = bookTitle;
#line 185 "../src/pdfReader.vala"
				bookworm_app_book_setBookTitle (aBook, _tmp51_);
#line 1879 "pdfReader.c"
			}
#line 173 "../src/pdfReader.vala"
			_g_object_unref0 (_tmp17_);
#line 1883 "pdfReader.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GFile* _tmp56_;
		GFile* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp63_;
#line 170 "../src/pdfReader.vala"
		e = _inner_error0_;
#line 170 "../src/pdfReader.vala"
		_inner_error0_ = NULL;
#line 189 "../src/pdfReader.vala"
		_tmp52_ = e;
#line 189 "../src/pdfReader.vala"
		_tmp53_ = _tmp52_->message;
#line 189 "../src/pdfReader.vala"
		g_info ("pdfReader.vala:189: Error while checking title in PDF book: %s\n", _tmp53_);
#line 191 "../src/pdfReader.vala"
		_tmp54_ = bookworm_app_book_getBookLocation (aBook);
#line 191 "../src/pdfReader.vala"
		_tmp55_ = _tmp54_;
#line 191 "../src/pdfReader.vala"
		_tmp56_ = g_file_new_for_path (_tmp55_);
#line 191 "../src/pdfReader.vala"
		_tmp57_ = _tmp56_;
#line 191 "../src/pdfReader.vala"
		_tmp58_ = g_file_get_basename (_tmp57_);
#line 191 "../src/pdfReader.vala"
		_g_free0 (bookTitle);
#line 191 "../src/pdfReader.vala"
		bookTitle = _tmp58_;
#line 191 "../src/pdfReader.vala"
		_g_object_unref0 (_tmp57_);
#line 191 "../src/pdfReader.vala"
		_g_free0 (_tmp55_);
#line 192 "../src/pdfReader.vala"
		_tmp59_ = bookTitle;
#line 192 "../src/pdfReader.vala"
		if (string_last_index_of (_tmp59_, ".", 0) != -1) {
#line 1931 "pdfReader.c"
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			gchar* _tmp62_;
#line 193 "../src/pdfReader.vala"
			_tmp60_ = bookTitle;
#line 193 "../src/pdfReader.vala"
			_tmp61_ = bookTitle;
#line 193 "../src/pdfReader.vala"
			_tmp62_ = string_slice (_tmp60_, (glong) 0, (glong) string_last_index_of (_tmp61_, ".", 0));
#line 193 "../src/pdfReader.vala"
			_g_free0 (bookTitle);
#line 193 "../src/pdfReader.vala"
			bookTitle = _tmp62_;
#line 1945 "pdfReader.c"
		}
#line 195 "../src/pdfReader.vala"
		_tmp63_ = bookTitle;
#line 195 "../src/pdfReader.vala"
		bookworm_app_book_setBookTitle (aBook, _tmp63_);
#line 170 "../src/pdfReader.vala"
		_g_error_free0 (e);
#line 1953 "pdfReader.c"
	}
	__finally0:
#line 170 "../src/pdfReader.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 170 "../src/pdfReader.vala"
		_g_object_unref0 (pdfDocument);
#line 170 "../src/pdfReader.vala"
		_g_free0 (bookTitle);
#line 170 "../src/pdfReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 170 "../src/pdfReader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 170 "../src/pdfReader.vala"
		g_clear_error (&_inner_error0_);
#line 170 "../src/pdfReader.vala"
		return NULL;
#line 1970 "pdfReader.c"
	}
#line 220 "../src/pdfReader.vala"
	_tmp64_ = bookworm_app_book_getBookLocation (aBook);
#line 220 "../src/pdfReader.vala"
	_tmp65_ = _tmp64_;
#line 220 "../src/pdfReader.vala"
	_tmp66_ = g_strconcat ("[END] [FUNCTION:setBookMetaData] book.location=", _tmp65_, NULL);
#line 220 "../src/pdfReader.vala"
	_tmp67_ = _tmp66_;
#line 220 "../src/pdfReader.vala"
	g_info ("pdfReader.vala:220: %s", _tmp67_);
#line 220 "../src/pdfReader.vala"
	_g_free0 (_tmp67_);
#line 220 "../src/pdfReader.vala"
	_g_free0 (_tmp65_);
#line 221 "../src/pdfReader.vala"
	_tmp68_ = _bookworm_app_book_ref0 (aBook);
#line 221 "../src/pdfReader.vala"
	result = _tmp68_;
#line 221 "../src/pdfReader.vala"
	_g_object_unref0 (pdfDocument);
#line 221 "../src/pdfReader.vala"
	_g_free0 (bookTitle);
#line 221 "../src/pdfReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 221 "../src/pdfReader.vala"
	return result;
#line 1998 "pdfReader.c"
}

BookwormApppdfReader*
bookworm_app_pdf_reader_construct (GType object_type)
{
	BookwormApppdfReader* self = NULL;
#line 20 "../src/pdfReader.vala"
	self = (BookwormApppdfReader*) g_type_create_instance (object_type);
#line 20 "../src/pdfReader.vala"
	return self;
#line 2009 "pdfReader.c"
}

BookwormApppdfReader*
bookworm_app_pdf_reader_new (void)
{
#line 20 "../src/pdfReader.vala"
	return bookworm_app_pdf_reader_construct (BOOKWORM_APP_TYPE_PDF_READER);
#line 2017 "pdfReader.c"
}

static void
bookworm_app_value_pdf_reader_init (GValue* value)
{
#line 20 "../src/pdfReader.vala"
	value->data[0].v_pointer = NULL;
#line 2025 "pdfReader.c"
}

static void
bookworm_app_value_pdf_reader_free_value (GValue* value)
{
#line 20 "../src/pdfReader.vala"
	if (value->data[0].v_pointer) {
#line 20 "../src/pdfReader.vala"
		bookworm_app_pdf_reader_unref (value->data[0].v_pointer);
#line 2035 "pdfReader.c"
	}
}

static void
bookworm_app_value_pdf_reader_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 20 "../src/pdfReader.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "../src/pdfReader.vala"
		dest_value->data[0].v_pointer = bookworm_app_pdf_reader_ref (src_value->data[0].v_pointer);
#line 2047 "pdfReader.c"
	} else {
#line 20 "../src/pdfReader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2051 "pdfReader.c"
	}
}

static gpointer
bookworm_app_value_pdf_reader_peek_pointer (const GValue* value)
{
#line 20 "../src/pdfReader.vala"
	return value->data[0].v_pointer;
#line 2060 "pdfReader.c"
}

static gchar*
bookworm_app_value_pdf_reader_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 20 "../src/pdfReader.vala"
	if (collect_values[0].v_pointer) {
#line 2071 "pdfReader.c"
		BookwormApppdfReader * object;
		object = collect_values[0].v_pointer;
#line 20 "../src/pdfReader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "../src/pdfReader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2078 "pdfReader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "../src/pdfReader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2082 "pdfReader.c"
		}
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = bookworm_app_pdf_reader_ref (object);
#line 2086 "pdfReader.c"
	} else {
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = NULL;
#line 2090 "pdfReader.c"
	}
#line 20 "../src/pdfReader.vala"
	return NULL;
#line 2094 "pdfReader.c"
}

static gchar*
bookworm_app_value_pdf_reader_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BookwormApppdfReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "../src/pdfReader.vala"
	if (!object_p) {
#line 20 "../src/pdfReader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2109 "pdfReader.c"
	}
#line 20 "../src/pdfReader.vala"
	if (!value->data[0].v_pointer) {
#line 20 "../src/pdfReader.vala"
		*object_p = NULL;
#line 2115 "pdfReader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "../src/pdfReader.vala"
		*object_p = value->data[0].v_pointer;
#line 2119 "pdfReader.c"
	} else {
#line 20 "../src/pdfReader.vala"
		*object_p = bookworm_app_pdf_reader_ref (value->data[0].v_pointer);
#line 2123 "pdfReader.c"
	}
#line 20 "../src/pdfReader.vala"
	return NULL;
#line 2127 "pdfReader.c"
}

GParamSpec*
bookworm_app_param_spec_pdf_reader (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BookwormAppParamSpecpdfReader* spec;
#line 20 "../src/pdfReader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_PDF_READER), NULL);
#line 20 "../src/pdfReader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "../src/pdfReader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "../src/pdfReader.vala"
	return G_PARAM_SPEC (spec);
#line 2146 "pdfReader.c"
}

gpointer
bookworm_app_value_get_pdf_reader (const GValue* value)
{
#line 20 "../src/pdfReader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_PDF_READER), NULL);
#line 20 "../src/pdfReader.vala"
	return value->data[0].v_pointer;
#line 2156 "pdfReader.c"
}

void
bookworm_app_value_set_pdf_reader (GValue* value,
                                   gpointer v_object)
{
	BookwormApppdfReader * old;
#line 20 "../src/pdfReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_PDF_READER));
#line 20 "../src/pdfReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/pdfReader.vala"
	if (v_object) {
#line 20 "../src/pdfReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_PDF_READER));
#line 20 "../src/pdfReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = v_object;
#line 20 "../src/pdfReader.vala"
		bookworm_app_pdf_reader_ref (value->data[0].v_pointer);
#line 2178 "pdfReader.c"
	} else {
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = NULL;
#line 2182 "pdfReader.c"
	}
#line 20 "../src/pdfReader.vala"
	if (old) {
#line 20 "../src/pdfReader.vala"
		bookworm_app_pdf_reader_unref (old);
#line 2188 "pdfReader.c"
	}
}

void
bookworm_app_value_take_pdf_reader (GValue* value,
                                    gpointer v_object)
{
	BookwormApppdfReader * old;
#line 20 "../src/pdfReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_PDF_READER));
#line 20 "../src/pdfReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/pdfReader.vala"
	if (v_object) {
#line 20 "../src/pdfReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_PDF_READER));
#line 20 "../src/pdfReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = v_object;
#line 2209 "pdfReader.c"
	} else {
#line 20 "../src/pdfReader.vala"
		value->data[0].v_pointer = NULL;
#line 2213 "pdfReader.c"
	}
#line 20 "../src/pdfReader.vala"
	if (old) {
#line 20 "../src/pdfReader.vala"
		bookworm_app_pdf_reader_unref (old);
#line 2219 "pdfReader.c"
	}
}

static void
bookworm_app_pdf_reader_class_init (BookwormApppdfReaderClass * klass,
                                    gpointer klass_data)
{
#line 20 "../src/pdfReader.vala"
	bookworm_app_pdf_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/pdfReader.vala"
	((BookwormApppdfReaderClass *) klass)->finalize = bookworm_app_pdf_reader_finalize;
#line 2231 "pdfReader.c"
}

static void
bookworm_app_pdf_reader_instance_init (BookwormApppdfReader * self,
                                       gpointer klass)
{
#line 20 "../src/pdfReader.vala"
	self->ref_count = 1;
#line 2240 "pdfReader.c"
}

static void
bookworm_app_pdf_reader_finalize (BookwormApppdfReader * obj)
{
	BookwormApppdfReader * self;
#line 20 "../src/pdfReader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_PDF_READER, BookwormApppdfReader);
#line 20 "../src/pdfReader.vala"
	g_signal_handlers_destroy (self);
#line 2251 "pdfReader.c"
}

static GType
bookworm_app_pdf_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_pdf_reader_init, bookworm_app_value_pdf_reader_free_value, bookworm_app_value_pdf_reader_copy_value, bookworm_app_value_pdf_reader_peek_pointer, "p", bookworm_app_value_pdf_reader_collect_value, "p", bookworm_app_value_pdf_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormApppdfReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_pdf_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormApppdfReader), 0, (GInstanceInitFunc) bookworm_app_pdf_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_pdf_reader_type_id;
	bookworm_app_pdf_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormApppdfReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_pdf_reader_type_id;
}

GType
bookworm_app_pdf_reader_get_type (void)
{
	static volatile gsize bookworm_app_pdf_reader_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_pdf_reader_type_id__once)) {
		GType bookworm_app_pdf_reader_type_id;
		bookworm_app_pdf_reader_type_id = bookworm_app_pdf_reader_get_type_once ();
		g_once_init_leave (&bookworm_app_pdf_reader_type_id__once, bookworm_app_pdf_reader_type_id);
	}
	return bookworm_app_pdf_reader_type_id__once;
}

gpointer
bookworm_app_pdf_reader_ref (gpointer instance)
{
	BookwormApppdfReader * self;
	self = instance;
#line 20 "../src/pdfReader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "../src/pdfReader.vala"
	return instance;
#line 2286 "pdfReader.c"
}

void
bookworm_app_pdf_reader_unref (gpointer instance)
{
	BookwormApppdfReader * self;
	self = instance;
#line 20 "../src/pdfReader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "../src/pdfReader.vala"
		BOOKWORM_APP_PDF_READER_GET_CLASS (self)->finalize (self);
#line 20 "../src/pdfReader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2300 "pdfReader.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

