/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_getPathSegAtLength);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegClosePath);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegArcAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegArcRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothRel);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothAbs);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothRel);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathElement_pathSegList);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathElement_animatedPathSegList);

class JSSVGPathElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathElementPrototype>(vm)) JSSVGPathElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathElementPrototype, JSSVGPathElementPrototype::Base);

using JSSVGPathElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathElement>;

template<> const ClassInfo JSSVGPathElementDOMConstructor::s_info = { "SVGPathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathElementDOMConstructor) };

template<> JSValue JSSVGPathElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGeometryElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 23> JSSVGPathElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathElementConstructor, 0 } },
    HashTableValue { "pathSegList"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathElement_pathSegList, 0 } },
    HashTableValue { "animatedPathSegList"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathElement_animatedPathSegList, 0 } },
    HashTableValue { "getPathSegAtLength"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_getPathSegAtLength, 0 } },
    HashTableValue { "createSVGPathSegClosePath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegClosePath, 0 } },
    HashTableValue { "createSVGPathSegMovetoAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoAbs, 0 } },
    HashTableValue { "createSVGPathSegMovetoRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoRel, 0 } },
    HashTableValue { "createSVGPathSegLinetoAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoAbs, 0 } },
    HashTableValue { "createSVGPathSegLinetoRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoRel, 0 } },
    HashTableValue { "createSVGPathSegCurvetoCubicAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicAbs, 0 } },
    HashTableValue { "createSVGPathSegCurvetoCubicRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicRel, 0 } },
    HashTableValue { "createSVGPathSegCurvetoQuadraticAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticAbs, 0 } },
    HashTableValue { "createSVGPathSegCurvetoQuadraticRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticRel, 0 } },
    HashTableValue { "createSVGPathSegArcAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegArcAbs, 0 } },
    HashTableValue { "createSVGPathSegArcRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegArcRel, 0 } },
    HashTableValue { "createSVGPathSegLinetoHorizontalAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalAbs, 0 } },
    HashTableValue { "createSVGPathSegLinetoHorizontalRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalRel, 0 } },
    HashTableValue { "createSVGPathSegLinetoVerticalAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalAbs, 0 } },
    HashTableValue { "createSVGPathSegLinetoVerticalRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalRel, 0 } },
    HashTableValue { "createSVGPathSegCurvetoCubicSmoothAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothAbs, 0 } },
    HashTableValue { "createSVGPathSegCurvetoCubicSmoothRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothRel, 0 } },
    HashTableValue { "createSVGPathSegCurvetoQuadraticSmoothAbs"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothAbs, 0 } },
    HashTableValue { "createSVGPathSegCurvetoQuadraticSmoothRel"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothRel, 0 } },
};

const ClassInfo JSSVGPathElementPrototype::s_info = { "SVGPathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathElementPrototype) };

void JSSVGPathElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathElement::info(), JSSVGPathElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathElement::s_info = { "SVGPathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathElement) };

JSSVGPathElement::JSSVGPathElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathElement>&& impl)
    : JSSVGGeometryElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGPathElement> JSSVGPathElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGPathElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathElementPrototype::createStructure(vm, &globalObject, JSSVGGeometryElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGPathElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathElement>(vm, globalObject);
}

JSValue JSSVGPathElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathElementDOMConstructor, DOMConstructorID::SVGPathElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPathElement_pathSegListGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGPathSegList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pathSegList())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathElement_pathSegList, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathElement>::get<jsSVGPathElement_pathSegListGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGPathElement_animatedPathSegListGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGPathSegList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.animatedPathSegList())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathElement_animatedPathSegList, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathElement>::get<jsSVGPathElement_animatedPathSegListGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_getPathSegAtLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto distanceConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (distanceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.getPathSegAtLength(distanceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_getPathSegAtLength, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_getPathSegAtLengthBody>(*lexicalGlobalObject, *callFrame, "getPathSegAtLength");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegClosePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegClosePath>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegClosePath())));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegClosePath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegClosePathBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegClosePath");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegMovetoAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegMovetoAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegMovetoAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegMovetoRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegMovetoRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegMovetoRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegMovetoRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto x2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto y2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument5.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoCubicAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoCubicAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoCubicAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto x2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto y2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument5.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoCubicRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoCubicRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoCubicRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoQuadraticAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoQuadraticAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoQuadraticAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoQuadraticRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoQuadraticRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoQuadraticRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegArcAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto r1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (r1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto r2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (r2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto angleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto largeArcFlagConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument5.value());
    if (largeArcFlagConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto sweepFlagConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument6.value());
    if (sweepFlagConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegArcAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegArcAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), r1ConversionResult.releaseReturnValue(), r2ConversionResult.releaseReturnValue(), angleConversionResult.releaseReturnValue(), largeArcFlagConversionResult.releaseReturnValue(), sweepFlagConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegArcAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegArcAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegArcAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegArcRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto r1ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (r1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto r2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (r2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto angleConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument4.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto largeArcFlagConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument5.value());
    if (largeArcFlagConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto sweepFlagConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument6.value());
    if (sweepFlagConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegArcRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegArcRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), r1ConversionResult.releaseReturnValue(), r2ConversionResult.releaseReturnValue(), angleConversionResult.releaseReturnValue(), largeArcFlagConversionResult.releaseReturnValue(), sweepFlagConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegArcRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegArcRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegArcRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoHorizontalAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoHorizontalAbs(xConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoHorizontalAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoHorizontalRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoHorizontalRel(xConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoHorizontalRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoHorizontalRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoVerticalAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoVerticalAbs(yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoVerticalAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegLinetoVerticalRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegLinetoVerticalRel(yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegLinetoVerticalRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegLinetoVerticalRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoCubicSmoothAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoCubicSmoothAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoCubicSmoothAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto x2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument2.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto y2ConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument3.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoCubicSmoothRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoCubicSmoothRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoCubicSmoothRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoCubicSmoothRel");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothAbsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoQuadraticSmoothAbs>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoQuadraticSmoothAbs(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothAbs, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothAbsBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoQuadraticSmoothAbs");
}

static inline JSC::EncodedJSValue jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothRelBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPathElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPathSegCurvetoQuadraticSmoothRel>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSVGPathSegCurvetoQuadraticSmoothRel(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothRel, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPathElement>::call<jsSVGPathElementPrototypeFunction_createSVGPathSegCurvetoQuadraticSmoothRelBody>(*lexicalGlobalObject, *callFrame, "createSVGPathSegCurvetoQuadraticSmoothRel");
}

JSC::GCClient::IsoSubspace* JSSVGPathElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathElement, UseCustomHeapCellType::No>(vm, "JSSVGPathElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
