/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRsaKeyGenParams.h"

#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CryptoAlgorithmRsaKeyGenParams>> convertDictionary<CryptoAlgorithmRsaKeyGenParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CryptoAlgorithmRsaKeyGenParams result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "RsaKeyGenParams"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue modulusLengthValue;
    if (isNullOrUndefined)
        modulusLengthValue = jsUndefined();
    else {
        modulusLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modulusLength"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (modulusLengthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "modulusLength"_s, "RsaKeyGenParams"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto modulusLengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, modulusLengthValue);
    if (modulusLengthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.modulusLength = modulusLengthConversionResult.releaseReturnValue();
    JSValue publicExponentValue;
    if (isNullOrUndefined)
        publicExponentValue = jsUndefined();
    else {
        publicExponentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicExponent"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (publicExponentValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "publicExponent"_s, "RsaKeyGenParams"_s, "Uint8Array"_s);
        return ConversionResultException { };
    }
    auto publicExponentConversionResult = convert<IDLUint8Array>(lexicalGlobalObject, publicExponentValue);
    if (publicExponentConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.publicExponent = publicExponentConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

