/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSOscillatorNode.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioParam.h"
#include "JSBaseAudioContext.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSOscillatorOptions.h"
#include "JSOscillatorType.h"
#include "JSPeriodicWave.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOscillatorNodePrototypeFunction_setPeriodicWave);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsOscillatorNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsOscillatorNode_type);
static JSC_DECLARE_CUSTOM_SETTER(setJSOscillatorNode_type);
static JSC_DECLARE_CUSTOM_GETTER(jsOscillatorNode_frequency);
static JSC_DECLARE_CUSTOM_GETTER(jsOscillatorNode_detune);

class JSOscillatorNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOscillatorNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOscillatorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSOscillatorNodePrototype>(vm)) JSOscillatorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOscillatorNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOscillatorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOscillatorNodePrototype, JSOscillatorNodePrototype::Base);

using JSOscillatorNodeDOMConstructor = JSDOMConstructor<JSOscillatorNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSOscillatorNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSOscillatorNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().webAudioEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextConversionResult = convert<IDLInterface<BaseAudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context"_s, "OscillatorNode"_s, nullptr, "BaseAudioContext"_s); });
    if (contextConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<OscillatorOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = OscillatorNode::create(*contextConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<OscillatorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<OscillatorNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSOscillatorNodeDOMConstructorConstruct, JSOscillatorNodeDOMConstructor::construct);

template<> const ClassInfo JSOscillatorNodeDOMConstructor::s_info = { "OscillatorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNodeDOMConstructor) };

template<> JSValue JSOscillatorNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioScheduledSourceNode::getConstructor(vm, &globalObject);
}

template<> void JSOscillatorNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "OscillatorNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSOscillatorNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSOscillatorNodePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsOscillatorNodeConstructor, 0 } },
    HashTableValue { "type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOscillatorNode_type, setJSOscillatorNode_type } },
    HashTableValue { "frequency"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOscillatorNode_frequency, 0 } },
    HashTableValue { "detune"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOscillatorNode_detune, 0 } },
    HashTableValue { "setPeriodicWave"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOscillatorNodePrototypeFunction_setPeriodicWave, 1 } },
};

const ClassInfo JSOscillatorNodePrototype::s_info = { "OscillatorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNodePrototype) };

void JSOscillatorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOscillatorNode::info(), JSOscillatorNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOscillatorNode::s_info = { "OscillatorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOscillatorNode) };

JSOscillatorNode::JSOscillatorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OscillatorNode>&& impl)
    : JSAudioScheduledSourceNode(structure, globalObject, WTFMove(impl))
{
}

Ref<OscillatorNode> JSOscillatorNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, OscillatorNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSOscillatorNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOscillatorNodePrototype::createStructure(vm, &globalObject, JSAudioScheduledSourceNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSOscillatorNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSOscillatorNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOscillatorNode>(vm, globalObject);
}

JSValue JSOscillatorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOscillatorNodeDOMConstructor, DOMConstructorID::OscillatorNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsOscillatorNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOscillatorNodePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOscillatorNode::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsOscillatorNode_typeGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<OscillatorType>>(lexicalGlobalObject, throwScope, impl.typeForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOscillatorNode_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNode_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOscillatorNode_typeSetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<OscillatorType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTypeForBindings(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOscillatorNode_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOscillatorNode>::set<setJSOscillatorNode_typeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOscillatorNode_frequencyGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.frequency())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOscillatorNode_frequency, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNode_frequencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsOscillatorNode_detuneGetter(JSGlobalObject& lexicalGlobalObject, JSOscillatorNode& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.detune())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOscillatorNode_detune, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOscillatorNode>::get<jsOscillatorNode_detuneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsOscillatorNodePrototypeFunction_setPeriodicWaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOscillatorNode>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto waveConversionResult = convert<IDLInterface<PeriodicWave>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "wave"_s, "OscillatorNode"_s, "setPeriodicWave"_s, "PeriodicWave"_s); });
    if (waveConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPeriodicWave(*waveConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOscillatorNodePrototypeFunction_setPeriodicWave, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOscillatorNode>::call<jsOscillatorNodePrototypeFunction_setPeriodicWaveBody>(*lexicalGlobalObject, *callFrame, "setPeriodicWave");
}

JSC::GCClient::IsoSubspace* JSOscillatorNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOscillatorNode, UseCustomHeapCellType::No>(vm, "JSOscillatorNode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOscillatorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOscillatorNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOscillatorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOscillatorNode = std::forward<decltype(space)>(space); }
    );
}

void JSOscillatorNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOscillatorNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOscillatorNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsOscillatorNode = jsCast<JSOscillatorNode*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsOscillatorNode->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSOscillatorNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOscillatorNode = static_cast<JSOscillatorNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOscillatorNode->protectedWrapped().ptr(), jsOscillatorNode);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OscillatorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14OscillatorNodeE[]; }
#endif
template<std::same_as<OscillatorNode> T>
static inline void verifyVTable(OscillatorNode* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OscillatorNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14OscillatorNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OscillatorNode has subclasses. If OscillatorNode has subclasses that get passed
        // to toJS() we currently require OscillatorNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OscillatorNode>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OscillatorNode>(impl.ptr());
#endif
    return createWrapper<OscillatorNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OscillatorNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
