#pragma once
/*
 * This file is generated by uxsdcxx 0.1.0.
 * https://github.com/duck2/uxsdcxx
 * Modify only if your build process doesn't involve regenerating this file.
 *
 * Cmdline: uxsdcxx/uxsdcxx.py /home/mohagh18/vtr-verilog-to-routing/libs/librrgraph/src/io/rr_graph.xsd
 * Input file: /home/mohagh18/vtr-verilog-to-routing/libs/librrgraph/src/io/rr_graph.xsd

 * md5sum of input file: 65eddcc840064bbb91d7f4cf0b8bf821
 */

#include <functional>


#include <bitset>
#include <cassert>
#include <cstring>
#include <iostream>
#include <sstream>
#include <memory>
#include <string>
#include <vector>

#include <stddef.h>
#include <stdint.h>
#include "pugixml.hpp"

#include "rr_graph_uxsdcxx_interface.h"
/* All uxsdcxx functions and structs live in this namespace. */
namespace uxsd {

/**
 * Internal function for getting line and column number from file based on
 * byte offset.
 */
inline void get_line_number(const char *filename, std::ptrdiff_t offset, int * line, int * col);

[[noreturn]] inline void noreturn_report(const std::function<void(const char *)> * report_error, const char *msg) {
    (*report_error)(msg);
    throw std::runtime_error("Unreachable!");
}

/* Declarations for internal load functions for the complex types. */
template <class T, typename Context>
inline void load_channel(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_channel_required_attributes(const pugi::xml_node &root, int * chan_width_max, int * x_max, int * x_min, int * y_max, int * y_min, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_x_list(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_x_list_required_attributes(const pugi::xml_node &root, unsigned int * index, int * info, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_y_list(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_y_list_required_attributes(const pugi::xml_node &root, unsigned int * index, int * info, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_channels(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_sizing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_sizing_required_attributes(const pugi::xml_node &root, float * buf_size, float * mux_trans_size, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_switch(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_switch_required_attributes(const pugi::xml_node &root, int * id, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_switches(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_segment_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_segment(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_segment_required_attributes(const pugi::xml_node &root, int * id, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_segments(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_pin(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_pin_required_attributes(const pugi::xml_node &root, int * ptc, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_pin_class(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_pin_class_required_attributes(const pugi::xml_node &root, enum_pin_type * type, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_block_type(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_block_type_required_attributes(const pugi::xml_node &root, int * height, int * id, int * width, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_block_types(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_grid_loc(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_grid_loc_required_attributes(const pugi::xml_node &root, int * block_type_id, int * height_offset, int * width_offset, int * x, int * y, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_grid_locs(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_node_loc(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_node_loc_required_attributes(const pugi::xml_node &root, int * ptc, int * xhigh, int * xlow, int * yhigh, int * ylow, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_node_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_node_timing_required_attributes(const pugi::xml_node &root, float * C, float * R, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_node_segment(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_node_segment_required_attributes(const pugi::xml_node &root, int * segment_id, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_meta(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_metadata(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_node(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_node_required_attributes(const pugi::xml_node &root, unsigned int * capacity, unsigned int * id, enum_node_type * type, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_rr_nodes(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_edge(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
inline void load_edge_required_attributes(const pugi::xml_node &root, unsigned int * sink_node, unsigned int * src_node, unsigned int * switch_id, const std::function<void(const char*)> * report_error);
template <class T, typename Context>
inline void load_rr_edges(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);
template <class T, typename Context>
inline void load_rr_graph(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug);

/* Declarations for internal write functions for the complex types. */
template <class T>
inline void write_channels(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_switch(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_switches(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_segment(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_segments(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_pin(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_pin_class(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_block_type(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_block_types(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_grid_locs(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_meta(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_metadata(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_node(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_rr_nodes(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_edge(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_rr_edges(T &in, std::ostream &os, const void *data, void *iter);
template <class T>
inline void write_rr_graph(T &in, std::ostream &os, const void *data, void *iter);

/* Load function for the root element. */
template <class T, typename Context>
inline void load_rr_graph_xml(T &out, Context &context, const char * filename, std::istream &is){
	pugi::xml_document doc;
	pugi::xml_parse_result result = doc.load(is);
	if(!result) {
		int line, col;
		get_line_number(filename, result.offset, &line, &col);
		std::stringstream msg;
		msg << "Unable to load XML file '" << filename << "', ";
		msg << result.description() << " (line: " << line;
		msg << " col: " << col << ")";		out.error_encountered(filename, line, msg.str().c_str());
	}
	ptrdiff_t offset_debug = 0;
	std::function<void(const char *)> report_error = [filename, &out, &offset_debug](const char * message) {
		int line, col;
		get_line_number(filename, offset_debug, &line, &col);
		out.error_encountered(filename, line, message);
		// If error_encountered didn't throw, throw now to unwind.
		throw std::runtime_error(message);
	};
	out.start_load(&report_error);
	
	for(pugi::xml_node node= doc.first_child(); node; node = node.next_sibling()){
		if(std::strcmp(node.name(), "rr_graph") == 0){
			/* If errno is set up to this point, it messes with strtol errno checking. */
			errno = 0;
			load_rr_graph(node, out, context, &report_error, &offset_debug);
		} else {
			offset_debug = node.offset_debug();
			report_error(("Invalid root-level element " + std::string(node.name())).c_str());
		}
	}
	out.finish_load();
}

/* Write function for the root element. */
template <class T, typename Context>
inline void write_rr_graph_xml(T &in, Context &context, std::ostream &os){
	in.start_write();
	os << "<rr_graph";
	if((bool)in.get_rr_graph_tool_comment(context))
		os << " tool_comment=\"" << in.get_rr_graph_tool_comment(context) << "\"";
	if((bool)in.get_rr_graph_tool_name(context))
		os << " tool_name=\"" << in.get_rr_graph_tool_name(context) << "\"";
	if((bool)in.get_rr_graph_tool_version(context))
		os << " tool_version=\"" << in.get_rr_graph_tool_version(context) << "\"";
	os << ">\n";
	write_rr_graph(in, os, context);
	os << "</rr_graph>\n";
	in.finish_write();
}


#if defined(_MSC_VER)
typedef const uint32_t __declspec(align(1)) triehash_uu32;
typedef const uint64_t __declspec(align(1)) triehash_uu64;
#else
typedef const uint32_t __attribute__((aligned(1))) triehash_uu32;
typedef const uint64_t __attribute__((aligned(1))) triehash_uu64;
static_assert(alignof(triehash_uu32) == 1, "Unaligned 32-bit access not found.");
static_assert(alignof(triehash_uu64) == 1, "Unaligned 64-bit access not found.");
#endif
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define onechar(c, s, l) (((uint64_t)(c)) << (s))
#else
#define onechar(c, s, l) (((uint64_t)(c)) << (l-8-s))
#endif

/* Tokens for attribute and node names. */

enum class atok_t_channel {CHAN_WIDTH_MAX, X_MAX, X_MIN, Y_MAX, Y_MIN};
constexpr const char *atok_lookup_t_channel[] = {"chan_width_max", "x_max", "x_min", "y_max", "y_min"};


enum class atok_t_x_list {INDEX, INFO};
constexpr const char *atok_lookup_t_x_list[] = {"index", "info"};


enum class atok_t_y_list {INDEX, INFO};
constexpr const char *atok_lookup_t_y_list[] = {"index", "info"};

enum class gtok_t_channels {CHANNEL, X_LIST, Y_LIST};
constexpr const char *gtok_lookup_t_channels[] = {"channel", "x_list", "y_list"};

enum class atok_t_timing {CIN, CINTERNAL, COUT, R, TDEL};
constexpr const char *atok_lookup_t_timing[] = {"Cin", "Cinternal", "Cout", "R", "Tdel"};


enum class atok_t_sizing {BUF_SIZE, MUX_TRANS_SIZE};
constexpr const char *atok_lookup_t_sizing[] = {"buf_size", "mux_trans_size"};

enum class gtok_t_switch {TIMING, SIZING};
constexpr const char *gtok_lookup_t_switch[] = {"timing", "sizing"};
enum class atok_t_switch {ID, NAME, TYPE};
constexpr const char *atok_lookup_t_switch[] = {"id", "name", "type"};

enum class gtok_t_switches {SWITCH};
constexpr const char *gtok_lookup_t_switches[] = {"switch"};

enum class atok_t_segment_timing {C_PER_METER, R_PER_METER};
constexpr const char *atok_lookup_t_segment_timing[] = {"C_per_meter", "R_per_meter"};

enum class gtok_t_segment {TIMING};
constexpr const char *gtok_lookup_t_segment[] = {"timing"};
enum class atok_t_segment {ID, LENGTH, NAME, RES_TYPE};
constexpr const char *atok_lookup_t_segment[] = {"id", "length", "name", "res_type"};

enum class gtok_t_segments {SEGMENT};
constexpr const char *gtok_lookup_t_segments[] = {"segment"};

enum class atok_t_pin {PTC};
constexpr const char *atok_lookup_t_pin[] = {"ptc"};

enum class gtok_t_pin_class {PIN};
constexpr const char *gtok_lookup_t_pin_class[] = {"pin"};
enum class atok_t_pin_class {TYPE};
constexpr const char *atok_lookup_t_pin_class[] = {"type"};

enum class gtok_t_block_type {PIN_CLASS};
constexpr const char *gtok_lookup_t_block_type[] = {"pin_class"};
enum class atok_t_block_type {HEIGHT, ID, NAME, WIDTH};
constexpr const char *atok_lookup_t_block_type[] = {"height", "id", "name", "width"};

enum class gtok_t_block_types {BLOCK_TYPE};
constexpr const char *gtok_lookup_t_block_types[] = {"block_type"};

enum class atok_t_grid_loc {BLOCK_TYPE_ID, HEIGHT_OFFSET, LAYER, WIDTH_OFFSET, X, Y};
constexpr const char *atok_lookup_t_grid_loc[] = {"block_type_id", "height_offset", "layer", "width_offset", "x", "y"};

enum class gtok_t_grid_locs {GRID_LOC};
constexpr const char *gtok_lookup_t_grid_locs[] = {"grid_loc"};

enum class atok_t_node_loc {LAYER, PTC, SIDE, TWIST, XHIGH, XLOW, YHIGH, YLOW};
constexpr const char *atok_lookup_t_node_loc[] = {"layer", "ptc", "side", "twist", "xhigh", "xlow", "yhigh", "ylow"};


enum class atok_t_node_timing {C, R};
constexpr const char *atok_lookup_t_node_timing[] = {"C", "R"};


enum class atok_t_node_segment {SEGMENT_ID};
constexpr const char *atok_lookup_t_node_segment[] = {"segment_id"};


enum class atok_t_meta {NAME};
constexpr const char *atok_lookup_t_meta[] = {"name"};

enum class gtok_t_metadata {META};
constexpr const char *gtok_lookup_t_metadata[] = {"meta"};
enum class gtok_t_node {LOC, TIMING, SEGMENT, METADATA};
constexpr const char *gtok_lookup_t_node[] = {"loc", "timing", "segment", "metadata"};
enum class atok_t_node {CAPACITY, CLK_RES_TYPE, DIRECTION, ID, NAME, TYPE};
constexpr const char *atok_lookup_t_node[] = {"capacity", "clk_res_type", "direction", "id", "name", "type"};

enum class gtok_t_rr_nodes {NODE};
constexpr const char *gtok_lookup_t_rr_nodes[] = {"node"};
enum class gtok_t_edge {METADATA};
constexpr const char *gtok_lookup_t_edge[] = {"metadata"};
enum class atok_t_edge {SINK_NODE, SRC_NODE, SWITCH_ID};
constexpr const char *atok_lookup_t_edge[] = {"sink_node", "src_node", "switch_id"};

enum class gtok_t_rr_edges {EDGE};
constexpr const char *gtok_lookup_t_rr_edges[] = {"edge"};
enum class gtok_t_rr_graph {CHANNELS, SWITCHES, SEGMENTS, BLOCK_TYPES, GRID, RR_NODES, RR_EDGES};
constexpr const char *gtok_lookup_t_rr_graph[] = {"channels", "switches", "segments", "block_types", "grid", "rr_nodes", "rr_edges"};
enum class atok_t_rr_graph {TOOL_COMMENT, TOOL_NAME, TOOL_VERSION};
constexpr const char *atok_lookup_t_rr_graph[] = {"tool_comment", "tool_name", "tool_version"};


/* Internal lexers. These convert the PugiXML node names to input tokens. */
inline atok_t_channel lex_attr_t_channel(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('x', 0, 32) | onechar('_', 8, 32) | onechar('m', 16, 32) | onechar('a', 24, 32):
			switch(in[4]){
			case onechar('x', 0, 8):
				return atok_t_channel::X_MAX;
			break;
			default: break;
			}
		break;
		case onechar('x', 0, 32) | onechar('_', 8, 32) | onechar('m', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				return atok_t_channel::X_MIN;
			break;
			default: break;
			}
		break;
		case onechar('y', 0, 32) | onechar('_', 8, 32) | onechar('m', 16, 32) | onechar('a', 24, 32):
			switch(in[4]){
			case onechar('x', 0, 8):
				return atok_t_channel::Y_MAX;
			break;
			default: break;
			}
		break;
		case onechar('y', 0, 32) | onechar('_', 8, 32) | onechar('m', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				return atok_t_channel::Y_MIN;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 14:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('c', 0, 64) | onechar('h', 8, 64) | onechar('a', 16, 64) | onechar('n', 24, 64) | onechar('_', 32, 64) | onechar('w', 40, 64) | onechar('i', 48, 64) | onechar('d', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('t', 0, 32) | onechar('h', 8, 32) | onechar('_', 16, 32) | onechar('m', 24, 32):
				switch(in[12]){
				case onechar('a', 0, 8):
					switch(in[13]){
					case onechar('x', 0, 8):
						return atok_t_channel::CHAN_WIDTH_MAX;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <channel>.").c_str());
}

inline atok_t_x_list lex_attr_t_x_list(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('i', 0, 32) | onechar('n', 8, 32) | onechar('f', 16, 32) | onechar('o', 24, 32):
			return atok_t_x_list::INFO;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('i', 0, 32) | onechar('n', 8, 32) | onechar('d', 16, 32) | onechar('e', 24, 32):
			switch(in[4]){
			case onechar('x', 0, 8):
				return atok_t_x_list::INDEX;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <x_list>.").c_str());
}

inline atok_t_y_list lex_attr_t_y_list(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('i', 0, 32) | onechar('n', 8, 32) | onechar('f', 16, 32) | onechar('o', 24, 32):
			return atok_t_y_list::INFO;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('i', 0, 32) | onechar('n', 8, 32) | onechar('d', 16, 32) | onechar('e', 24, 32):
			switch(in[4]){
			case onechar('x', 0, 8):
				return atok_t_y_list::INDEX;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <y_list>.").c_str());
}

inline gtok_t_channels lex_node_t_channels(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('x', 0, 32) | onechar('_', 8, 32) | onechar('l', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('s', 0, 8):
				switch(in[5]){
				case onechar('t', 0, 8):
					return gtok_t_channels::X_LIST;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('y', 0, 32) | onechar('_', 8, 32) | onechar('l', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('s', 0, 8):
				switch(in[5]){
				case onechar('t', 0, 8):
					return gtok_t_channels::Y_LIST;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 7:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('c', 0, 32) | onechar('h', 8, 32) | onechar('a', 16, 32) | onechar('n', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				switch(in[5]){
				case onechar('e', 0, 8):
					switch(in[6]){
					case onechar('l', 0, 8):
						return gtok_t_channels::CHANNEL;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <channels>.").c_str());
}

inline atok_t_timing lex_attr_t_timing(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 1:
		switch(in[0]){
		case onechar('R', 0, 8):
			return atok_t_timing::R;
		break;
		default: break;
		}
		break;
	case 3:
		switch(in[0]){
		case onechar('C', 0, 8):
			switch(in[1]){
			case onechar('i', 0, 8):
				switch(in[2]){
				case onechar('n', 0, 8):
					return atok_t_timing::CIN;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('C', 0, 32) | onechar('o', 8, 32) | onechar('u', 16, 32) | onechar('t', 24, 32):
			return atok_t_timing::COUT;
		break;
		case onechar('T', 0, 32) | onechar('d', 8, 32) | onechar('e', 16, 32) | onechar('l', 24, 32):
			return atok_t_timing::TDEL;
		break;
		default: break;
		}
		break;
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('C', 0, 64) | onechar('i', 8, 64) | onechar('n', 16, 64) | onechar('t', 24, 64) | onechar('e', 32, 64) | onechar('r', 40, 64) | onechar('n', 48, 64) | onechar('a', 56, 64):
			switch(in[8]){
			case onechar('l', 0, 8):
				return atok_t_timing::CINTERNAL;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <timing>.").c_str());
}

inline atok_t_sizing lex_attr_t_sizing(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('b', 0, 64) | onechar('u', 8, 64) | onechar('f', 16, 64) | onechar('_', 24, 64) | onechar('s', 32, 64) | onechar('i', 40, 64) | onechar('z', 48, 64) | onechar('e', 56, 64):
			return atok_t_sizing::BUF_SIZE;
		break;
		default: break;
		}
		break;
	case 14:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('m', 0, 64) | onechar('u', 8, 64) | onechar('x', 16, 64) | onechar('_', 24, 64) | onechar('t', 32, 64) | onechar('r', 40, 64) | onechar('a', 48, 64) | onechar('n', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('s', 0, 32) | onechar('_', 8, 32) | onechar('s', 16, 32) | onechar('i', 24, 32):
				switch(in[12]){
				case onechar('z', 0, 8):
					switch(in[13]){
					case onechar('e', 0, 8):
						return atok_t_sizing::MUX_TRANS_SIZE;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <sizing>.").c_str());
}

inline gtok_t_switch lex_node_t_switch(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('i', 8, 32) | onechar('z', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				switch(in[5]){
				case onechar('g', 0, 8):
					return gtok_t_switch::SIZING;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('t', 0, 32) | onechar('i', 8, 32) | onechar('m', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				switch(in[5]){
				case onechar('g', 0, 8):
					return gtok_t_switch::TIMING;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <switch>.").c_str());
}
inline atok_t_switch lex_attr_t_switch(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 2:
		switch(in[0]){
		case onechar('i', 0, 8):
			switch(in[1]){
			case onechar('d', 0, 8):
				return atok_t_switch::ID;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('a', 8, 32) | onechar('m', 16, 32) | onechar('e', 24, 32):
			return atok_t_switch::NAME;
		break;
		case onechar('t', 0, 32) | onechar('y', 8, 32) | onechar('p', 16, 32) | onechar('e', 24, 32):
			return atok_t_switch::TYPE;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <switch>.").c_str());
}

inline gtok_t_switches lex_node_t_switches(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('w', 8, 32) | onechar('i', 16, 32) | onechar('t', 24, 32):
			switch(in[4]){
			case onechar('c', 0, 8):
				switch(in[5]){
				case onechar('h', 0, 8):
					return gtok_t_switches::SWITCH;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <switches>.").c_str());
}

inline atok_t_segment_timing lex_attr_t_segment_timing(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 11:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('C', 0, 64) | onechar('_', 8, 64) | onechar('p', 16, 64) | onechar('e', 24, 64) | onechar('r', 32, 64) | onechar('_', 40, 64) | onechar('m', 48, 64) | onechar('e', 56, 64):
			switch(in[8]){
			case onechar('t', 0, 8):
				switch(in[9]){
				case onechar('e', 0, 8):
					switch(in[10]){
					case onechar('r', 0, 8):
						return atok_t_segment_timing::C_PER_METER;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('R', 0, 64) | onechar('_', 8, 64) | onechar('p', 16, 64) | onechar('e', 24, 64) | onechar('r', 32, 64) | onechar('_', 40, 64) | onechar('m', 48, 64) | onechar('e', 56, 64):
			switch(in[8]){
			case onechar('t', 0, 8):
				switch(in[9]){
				case onechar('e', 0, 8):
					switch(in[10]){
					case onechar('r', 0, 8):
						return atok_t_segment_timing::R_PER_METER;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <segment_timing>.").c_str());
}

inline gtok_t_segment lex_node_t_segment(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('t', 0, 32) | onechar('i', 8, 32) | onechar('m', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				switch(in[5]){
				case onechar('g', 0, 8):
					return gtok_t_segment::TIMING;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <segment>.").c_str());
}
inline atok_t_segment lex_attr_t_segment(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 2:
		switch(in[0]){
		case onechar('i', 0, 8):
			switch(in[1]){
			case onechar('d', 0, 8):
				return atok_t_segment::ID;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('a', 8, 32) | onechar('m', 16, 32) | onechar('e', 24, 32):
			return atok_t_segment::NAME;
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('l', 0, 32) | onechar('e', 8, 32) | onechar('n', 16, 32) | onechar('g', 24, 32):
			switch(in[4]){
			case onechar('t', 0, 8):
				switch(in[5]){
				case onechar('h', 0, 8):
					return atok_t_segment::LENGTH;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('r', 0, 64) | onechar('e', 8, 64) | onechar('s', 16, 64) | onechar('_', 24, 64) | onechar('t', 32, 64) | onechar('y', 40, 64) | onechar('p', 48, 64) | onechar('e', 56, 64):
			return atok_t_segment::RES_TYPE;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <segment>.").c_str());
}

inline gtok_t_segments lex_node_t_segments(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 7:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('e', 8, 32) | onechar('g', 16, 32) | onechar('m', 24, 32):
			switch(in[4]){
			case onechar('e', 0, 8):
				switch(in[5]){
				case onechar('n', 0, 8):
					switch(in[6]){
					case onechar('t', 0, 8):
						return gtok_t_segments::SEGMENT;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <segments>.").c_str());
}

inline atok_t_pin lex_attr_t_pin(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('p', 0, 8):
			switch(in[1]){
			case onechar('t', 0, 8):
				switch(in[2]){
				case onechar('c', 0, 8):
					return atok_t_pin::PTC;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <pin>.").c_str());
}

inline gtok_t_pin_class lex_node_t_pin_class(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('p', 0, 8):
			switch(in[1]){
			case onechar('i', 0, 8):
				switch(in[2]){
				case onechar('n', 0, 8):
					return gtok_t_pin_class::PIN;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <pin_class>.").c_str());
}
inline atok_t_pin_class lex_attr_t_pin_class(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('t', 0, 32) | onechar('y', 8, 32) | onechar('p', 16, 32) | onechar('e', 24, 32):
			return atok_t_pin_class::TYPE;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <pin_class>.").c_str());
}

inline gtok_t_block_type lex_node_t_block_type(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('p', 0, 64) | onechar('i', 8, 64) | onechar('n', 16, 64) | onechar('_', 24, 64) | onechar('c', 32, 64) | onechar('l', 40, 64) | onechar('a', 48, 64) | onechar('s', 56, 64):
			switch(in[8]){
			case onechar('s', 0, 8):
				return gtok_t_block_type::PIN_CLASS;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <block_type>.").c_str());
}
inline atok_t_block_type lex_attr_t_block_type(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 2:
		switch(in[0]){
		case onechar('i', 0, 8):
			switch(in[1]){
			case onechar('d', 0, 8):
				return atok_t_block_type::ID;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('a', 8, 32) | onechar('m', 16, 32) | onechar('e', 24, 32):
			return atok_t_block_type::NAME;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('w', 0, 32) | onechar('i', 8, 32) | onechar('d', 16, 32) | onechar('t', 24, 32):
			switch(in[4]){
			case onechar('h', 0, 8):
				return atok_t_block_type::WIDTH;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('h', 0, 32) | onechar('e', 8, 32) | onechar('i', 16, 32) | onechar('g', 24, 32):
			switch(in[4]){
			case onechar('h', 0, 8):
				switch(in[5]){
				case onechar('t', 0, 8):
					return atok_t_block_type::HEIGHT;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <block_type>.").c_str());
}

inline gtok_t_block_types lex_node_t_block_types(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 10:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('b', 0, 64) | onechar('l', 8, 64) | onechar('o', 16, 64) | onechar('c', 24, 64) | onechar('k', 32, 64) | onechar('_', 40, 64) | onechar('t', 48, 64) | onechar('y', 56, 64):
			switch(in[8]){
			case onechar('p', 0, 8):
				switch(in[9]){
				case onechar('e', 0, 8):
					return gtok_t_block_types::BLOCK_TYPE;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <block_types>.").c_str());
}

inline atok_t_grid_loc lex_attr_t_grid_loc(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 1:
		switch(in[0]){
		case onechar('x', 0, 8):
			return atok_t_grid_loc::X;
		break;
		case onechar('y', 0, 8):
			return atok_t_grid_loc::Y;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('l', 0, 32) | onechar('a', 8, 32) | onechar('y', 16, 32) | onechar('e', 24, 32):
			switch(in[4]){
			case onechar('r', 0, 8):
				return atok_t_grid_loc::LAYER;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 12:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('w', 0, 64) | onechar('i', 8, 64) | onechar('d', 16, 64) | onechar('t', 24, 64) | onechar('h', 32, 64) | onechar('_', 40, 64) | onechar('o', 48, 64) | onechar('f', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('f', 0, 32) | onechar('s', 8, 32) | onechar('e', 16, 32) | onechar('t', 24, 32):
				return atok_t_grid_loc::WIDTH_OFFSET;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 13:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('b', 0, 64) | onechar('l', 8, 64) | onechar('o', 16, 64) | onechar('c', 24, 64) | onechar('k', 32, 64) | onechar('_', 40, 64) | onechar('t', 48, 64) | onechar('y', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('p', 0, 32) | onechar('e', 8, 32) | onechar('_', 16, 32) | onechar('i', 24, 32):
				switch(in[12]){
				case onechar('d', 0, 8):
					return atok_t_grid_loc::BLOCK_TYPE_ID;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('h', 0, 64) | onechar('e', 8, 64) | onechar('i', 16, 64) | onechar('g', 24, 64) | onechar('h', 32, 64) | onechar('t', 40, 64) | onechar('_', 48, 64) | onechar('o', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('f', 0, 32) | onechar('f', 8, 32) | onechar('s', 16, 32) | onechar('e', 24, 32):
				switch(in[12]){
				case onechar('t', 0, 8):
					return atok_t_grid_loc::HEIGHT_OFFSET;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <grid_loc>.").c_str());
}

inline gtok_t_grid_locs lex_node_t_grid_locs(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('g', 0, 64) | onechar('r', 8, 64) | onechar('i', 16, 64) | onechar('d', 24, 64) | onechar('_', 32, 64) | onechar('l', 40, 64) | onechar('o', 48, 64) | onechar('c', 56, 64):
			return gtok_t_grid_locs::GRID_LOC;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <grid_locs>.").c_str());
}

inline atok_t_node_loc lex_attr_t_node_loc(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('p', 0, 8):
			switch(in[1]){
			case onechar('t', 0, 8):
				switch(in[2]){
				case onechar('c', 0, 8):
					return atok_t_node_loc::PTC;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('i', 8, 32) | onechar('d', 16, 32) | onechar('e', 24, 32):
			return atok_t_node_loc::SIDE;
		break;
		case onechar('x', 0, 32) | onechar('l', 8, 32) | onechar('o', 16, 32) | onechar('w', 24, 32):
			return atok_t_node_loc::XLOW;
		break;
		case onechar('y', 0, 32) | onechar('l', 8, 32) | onechar('o', 16, 32) | onechar('w', 24, 32):
			return atok_t_node_loc::YLOW;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('l', 0, 32) | onechar('a', 8, 32) | onechar('y', 16, 32) | onechar('e', 24, 32):
			switch(in[4]){
			case onechar('r', 0, 8):
				return atok_t_node_loc::LAYER;
			break;
			default: break;
			}
		break;
		case onechar('t', 0, 32) | onechar('w', 8, 32) | onechar('i', 16, 32) | onechar('s', 24, 32):
			switch(in[4]){
			case onechar('t', 0, 8):
				return atok_t_node_loc::TWIST;
			break;
			default: break;
			}
		break;
		case onechar('x', 0, 32) | onechar('h', 8, 32) | onechar('i', 16, 32) | onechar('g', 24, 32):
			switch(in[4]){
			case onechar('h', 0, 8):
				return atok_t_node_loc::XHIGH;
			break;
			default: break;
			}
		break;
		case onechar('y', 0, 32) | onechar('h', 8, 32) | onechar('i', 16, 32) | onechar('g', 24, 32):
			switch(in[4]){
			case onechar('h', 0, 8):
				return atok_t_node_loc::YHIGH;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <node_loc>.").c_str());
}

inline atok_t_node_timing lex_attr_t_node_timing(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 1:
		switch(in[0]){
		case onechar('C', 0, 8):
			return atok_t_node_timing::C;
		break;
		case onechar('R', 0, 8):
			return atok_t_node_timing::R;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <node_timing>.").c_str());
}

inline atok_t_node_segment lex_attr_t_node_segment(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 10:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('s', 0, 64) | onechar('e', 8, 64) | onechar('g', 16, 64) | onechar('m', 24, 64) | onechar('e', 32, 64) | onechar('n', 40, 64) | onechar('t', 48, 64) | onechar('_', 56, 64):
			switch(in[8]){
			case onechar('i', 0, 8):
				switch(in[9]){
				case onechar('d', 0, 8):
					return atok_t_node_segment::SEGMENT_ID;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <node_segment>.").c_str());
}

inline atok_t_meta lex_attr_t_meta(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('a', 8, 32) | onechar('m', 16, 32) | onechar('e', 24, 32):
			return atok_t_meta::NAME;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <meta>.").c_str());
}

inline gtok_t_metadata lex_node_t_metadata(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('m', 0, 32) | onechar('e', 8, 32) | onechar('t', 16, 32) | onechar('a', 24, 32):
			return gtok_t_metadata::META;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <metadata>.").c_str());
}

inline gtok_t_node lex_node_t_node(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('l', 0, 8):
			switch(in[1]){
			case onechar('o', 0, 8):
				switch(in[2]){
				case onechar('c', 0, 8):
					return gtok_t_node::LOC;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('t', 0, 32) | onechar('i', 8, 32) | onechar('m', 16, 32) | onechar('i', 24, 32):
			switch(in[4]){
			case onechar('n', 0, 8):
				switch(in[5]){
				case onechar('g', 0, 8):
					return gtok_t_node::TIMING;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 7:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('e', 8, 32) | onechar('g', 16, 32) | onechar('m', 24, 32):
			switch(in[4]){
			case onechar('e', 0, 8):
				switch(in[5]){
				case onechar('n', 0, 8):
					switch(in[6]){
					case onechar('t', 0, 8):
						return gtok_t_node::SEGMENT;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('m', 0, 64) | onechar('e', 8, 64) | onechar('t', 16, 64) | onechar('a', 24, 64) | onechar('d', 32, 64) | onechar('a', 40, 64) | onechar('t', 48, 64) | onechar('a', 56, 64):
			return gtok_t_node::METADATA;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <node>.").c_str());
}
inline atok_t_node lex_attr_t_node(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 2:
		switch(in[0]){
		case onechar('i', 0, 8):
			switch(in[1]){
			case onechar('d', 0, 8):
				return atok_t_node::ID;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('a', 8, 32) | onechar('m', 16, 32) | onechar('e', 24, 32):
			return atok_t_node::NAME;
		break;
		case onechar('t', 0, 32) | onechar('y', 8, 32) | onechar('p', 16, 32) | onechar('e', 24, 32):
			return atok_t_node::TYPE;
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('c', 0, 64) | onechar('a', 8, 64) | onechar('p', 16, 64) | onechar('a', 24, 64) | onechar('c', 32, 64) | onechar('i', 40, 64) | onechar('t', 48, 64) | onechar('y', 56, 64):
			return atok_t_node::CAPACITY;
		break;
		default: break;
		}
		break;
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('d', 0, 64) | onechar('i', 8, 64) | onechar('r', 16, 64) | onechar('e', 24, 64) | onechar('c', 32, 64) | onechar('t', 40, 64) | onechar('i', 48, 64) | onechar('o', 56, 64):
			switch(in[8]){
			case onechar('n', 0, 8):
				return atok_t_node::DIRECTION;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 12:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('c', 0, 64) | onechar('l', 8, 64) | onechar('k', 16, 64) | onechar('_', 24, 64) | onechar('r', 32, 64) | onechar('e', 40, 64) | onechar('s', 48, 64) | onechar('_', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('t', 0, 32) | onechar('y', 8, 32) | onechar('p', 16, 32) | onechar('e', 24, 32):
				return atok_t_node::CLK_RES_TYPE;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <node>.").c_str());
}

inline gtok_t_rr_nodes lex_node_t_rr_nodes(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('n', 0, 32) | onechar('o', 8, 32) | onechar('d', 16, 32) | onechar('e', 24, 32):
			return gtok_t_rr_nodes::NODE;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <rr_nodes>.").c_str());
}

inline gtok_t_edge lex_node_t_edge(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('m', 0, 64) | onechar('e', 8, 64) | onechar('t', 16, 64) | onechar('a', 24, 64) | onechar('d', 32, 64) | onechar('a', 40, 64) | onechar('t', 48, 64) | onechar('a', 56, 64):
			return gtok_t_edge::METADATA;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <edge>.").c_str());
}
inline atok_t_edge lex_attr_t_edge(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('s', 0, 64) | onechar('r', 8, 64) | onechar('c', 16, 64) | onechar('_', 24, 64) | onechar('n', 32, 64) | onechar('o', 40, 64) | onechar('d', 48, 64) | onechar('e', 56, 64):
			return atok_t_edge::SRC_NODE;
		break;
		default: break;
		}
		break;
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('s', 0, 64) | onechar('i', 8, 64) | onechar('n', 16, 64) | onechar('k', 24, 64) | onechar('_', 32, 64) | onechar('n', 40, 64) | onechar('o', 48, 64) | onechar('d', 56, 64):
			switch(in[8]){
			case onechar('e', 0, 8):
				return atok_t_edge::SINK_NODE;
			break;
			default: break;
			}
		break;
		case onechar('s', 0, 64) | onechar('w', 8, 64) | onechar('i', 16, 64) | onechar('t', 24, 64) | onechar('c', 32, 64) | onechar('h', 40, 64) | onechar('_', 48, 64) | onechar('i', 56, 64):
			switch(in[8]){
			case onechar('d', 0, 8):
				return atok_t_edge::SWITCH_ID;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <edge>.").c_str());
}

inline gtok_t_rr_edges lex_node_t_rr_edges(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('e', 0, 32) | onechar('d', 8, 32) | onechar('g', 16, 32) | onechar('e', 24, 32):
			return gtok_t_rr_edges::EDGE;
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <rr_edges>.").c_str());
}

inline gtok_t_rr_graph lex_node_t_rr_graph(const char *in, const std::function<void(const char *)> *report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('g', 0, 32) | onechar('r', 8, 32) | onechar('i', 16, 32) | onechar('d', 24, 32):
			return gtok_t_rr_graph::GRID;
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('c', 0, 64) | onechar('h', 8, 64) | onechar('a', 16, 64) | onechar('n', 24, 64) | onechar('n', 32, 64) | onechar('e', 40, 64) | onechar('l', 48, 64) | onechar('s', 56, 64):
			return gtok_t_rr_graph::CHANNELS;
		break;
		case onechar('r', 0, 64) | onechar('r', 8, 64) | onechar('_', 16, 64) | onechar('e', 24, 64) | onechar('d', 32, 64) | onechar('g', 40, 64) | onechar('e', 48, 64) | onechar('s', 56, 64):
			return gtok_t_rr_graph::RR_EDGES;
		break;
		case onechar('r', 0, 64) | onechar('r', 8, 64) | onechar('_', 16, 64) | onechar('n', 24, 64) | onechar('o', 32, 64) | onechar('d', 40, 64) | onechar('e', 48, 64) | onechar('s', 56, 64):
			return gtok_t_rr_graph::RR_NODES;
		break;
		case onechar('s', 0, 64) | onechar('e', 8, 64) | onechar('g', 16, 64) | onechar('m', 24, 64) | onechar('e', 32, 64) | onechar('n', 40, 64) | onechar('t', 48, 64) | onechar('s', 56, 64):
			return gtok_t_rr_graph::SEGMENTS;
		break;
		case onechar('s', 0, 64) | onechar('w', 8, 64) | onechar('i', 16, 64) | onechar('t', 24, 64) | onechar('c', 32, 64) | onechar('h', 40, 64) | onechar('e', 48, 64) | onechar('s', 56, 64):
			return gtok_t_rr_graph::SWITCHES;
		break;
		default: break;
		}
		break;
	case 11:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('b', 0, 64) | onechar('l', 8, 64) | onechar('o', 16, 64) | onechar('c', 24, 64) | onechar('k', 32, 64) | onechar('_', 40, 64) | onechar('t', 48, 64) | onechar('y', 56, 64):
			switch(in[8]){
			case onechar('p', 0, 8):
				switch(in[9]){
				case onechar('e', 0, 8):
					switch(in[10]){
					case onechar('s', 0, 8):
						return gtok_t_rr_graph::BLOCK_TYPES;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized child " + std::string(in) + " of <rr_graph>.").c_str());
}
inline atok_t_rr_graph lex_attr_t_rr_graph(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('t', 0, 64) | onechar('o', 8, 64) | onechar('o', 16, 64) | onechar('l', 24, 64) | onechar('_', 32, 64) | onechar('n', 40, 64) | onechar('a', 48, 64) | onechar('m', 56, 64):
			switch(in[8]){
			case onechar('e', 0, 8):
				return atok_t_rr_graph::TOOL_NAME;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 12:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('t', 0, 64) | onechar('o', 8, 64) | onechar('o', 16, 64) | onechar('l', 24, 64) | onechar('_', 32, 64) | onechar('c', 40, 64) | onechar('o', 48, 64) | onechar('m', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('m', 0, 32) | onechar('e', 8, 32) | onechar('n', 16, 32) | onechar('t', 24, 32):
				return atok_t_rr_graph::TOOL_COMMENT;
			break;
			default: break;
			}
		break;
		case onechar('t', 0, 64) | onechar('o', 8, 64) | onechar('o', 16, 64) | onechar('l', 24, 64) | onechar('_', 32, 64) | onechar('v', 40, 64) | onechar('e', 48, 64) | onechar('r', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('s', 0, 32) | onechar('i', 8, 32) | onechar('o', 16, 32) | onechar('n', 24, 32):
				return atok_t_rr_graph::TOOL_VERSION;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	noreturn_report(report_error, ("Found unrecognized attribute " + std::string(in) + " of <rr_graph>.").c_str());
}

/**
 * Internal error function for xs:choice and xs:sequence validators.
 */
[[noreturn]] inline void dfa_error(const char *wrong, const int *states, const char * const *lookup, int len, const std::function<void(const char *)> * report_error);

/**
 * Internal error function for xs:all validators.
 */
template<std::size_t N>
[[noreturn]] inline void all_error(std::bitset<N> gstate, const char * const *lookup, const std::function<void(const char *)> * report_error);

/**
 * Internal error function for attribute validators.
 */
template<std::size_t N>
[[noreturn]] inline void attr_error(std::bitset<N> astate, const char * const *lookup, const std::function<void(const char *)> * report_error);


/* Lookup tables for enums. */
constexpr const char *lookup_switch_type[] = {"UXSD_INVALID", "mux", "tristate", "pass_gate", "short", "buffer"};
constexpr const char *lookup_segment_res_type[] = {"UXSD_INVALID", "GENERAL", "GCLK"};
constexpr const char *lookup_pin_type[] = {"UXSD_INVALID", "OPEN", "OUTPUT", "INPUT"};
constexpr const char *lookup_node_type[] = {"UXSD_INVALID", "CHANX", "CHANY", "SOURCE", "SINK", "OPIN", "IPIN"};
constexpr const char *lookup_node_direction[] = {"UXSD_INVALID", "INC_DIR", "DEC_DIR", "BI_DIR", "NONE"};
constexpr const char *lookup_node_clk_res_type[] = {"UXSD_INVALID", "VIRTUAL_SINK"};
constexpr const char *lookup_loc_side[] = {"UXSD_INVALID", "LEFT", "RIGHT", "TOP", "BOTTOM", "RIGHT_LEFT", "RIGHT_BOTTOM", "RIGHT_BOTTOM_LEFT", "TOP_RIGHT", "TOP_BOTTOM", "TOP_LEFT", "TOP_RIGHT_BOTTOM", "TOP_RIGHT_LEFT", "TOP_BOTTOM_LEFT", "TOP_RIGHT_BOTTOM_LEFT", "BOTTOM_LEFT"};

/* Lexers(string->token functions) for enums. */
inline enum_switch_type lex_enum_switch_type(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('m', 0, 8):
			switch(in[1]){
			case onechar('u', 0, 8):
				switch(in[2]){
				case onechar('x', 0, 8):
					return enum_switch_type::MUX;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('s', 0, 32) | onechar('h', 8, 32) | onechar('o', 16, 32) | onechar('r', 24, 32):
			switch(in[4]){
			case onechar('t', 0, 8):
				return enum_switch_type::SHORT;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('b', 0, 32) | onechar('u', 8, 32) | onechar('f', 16, 32) | onechar('f', 24, 32):
			switch(in[4]){
			case onechar('e', 0, 8):
				switch(in[5]){
				case onechar('r', 0, 8):
					return enum_switch_type::BUFFER;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('t', 0, 64) | onechar('r', 8, 64) | onechar('i', 16, 64) | onechar('s', 24, 64) | onechar('t', 32, 64) | onechar('a', 40, 64) | onechar('t', 48, 64) | onechar('e', 56, 64):
			return enum_switch_type::TRISTATE;
		break;
		default: break;
		}
		break;
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('p', 0, 64) | onechar('a', 8, 64) | onechar('s', 16, 64) | onechar('s', 24, 64) | onechar('_', 32, 64) | onechar('g', 40, 64) | onechar('a', 48, 64) | onechar('t', 56, 64):
			switch(in[8]){
			case onechar('e', 0, 8):
				return enum_switch_type::PASS_GATE;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_switch_type.").c_str());
	return enum_switch_type::UXSD_INVALID;
}

inline enum_segment_res_type lex_enum_segment_res_type(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('G', 0, 32) | onechar('C', 8, 32) | onechar('L', 16, 32) | onechar('K', 24, 32):
			return enum_segment_res_type::GCLK;
		break;
		default: break;
		}
		break;
	case 7:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('G', 0, 32) | onechar('E', 8, 32) | onechar('N', 16, 32) | onechar('E', 24, 32):
			switch(in[4]){
			case onechar('R', 0, 8):
				switch(in[5]){
				case onechar('A', 0, 8):
					switch(in[6]){
					case onechar('L', 0, 8):
						return enum_segment_res_type::GENERAL;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_segment_res_type.").c_str());
	return enum_segment_res_type::UXSD_INVALID;
}

inline enum_pin_type lex_enum_pin_type(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('O', 0, 32) | onechar('P', 8, 32) | onechar('E', 16, 32) | onechar('N', 24, 32):
			return enum_pin_type::OPEN;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('I', 0, 32) | onechar('N', 8, 32) | onechar('P', 16, 32) | onechar('U', 24, 32):
			switch(in[4]){
			case onechar('T', 0, 8):
				return enum_pin_type::INPUT;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('O', 0, 32) | onechar('U', 8, 32) | onechar('T', 16, 32) | onechar('P', 24, 32):
			switch(in[4]){
			case onechar('U', 0, 8):
				switch(in[5]){
				case onechar('T', 0, 8):
					return enum_pin_type::OUTPUT;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_pin_type.").c_str());
	return enum_pin_type::UXSD_INVALID;
}

inline enum_node_type lex_enum_node_type(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('I', 0, 32) | onechar('P', 8, 32) | onechar('I', 16, 32) | onechar('N', 24, 32):
			return enum_node_type::IPIN;
		break;
		case onechar('O', 0, 32) | onechar('P', 8, 32) | onechar('I', 16, 32) | onechar('N', 24, 32):
			return enum_node_type::OPIN;
		break;
		case onechar('S', 0, 32) | onechar('I', 8, 32) | onechar('N', 16, 32) | onechar('K', 24, 32):
			return enum_node_type::SINK;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('C', 0, 32) | onechar('H', 8, 32) | onechar('A', 16, 32) | onechar('N', 24, 32):
			switch(in[4]){
			case onechar('X', 0, 8):
				return enum_node_type::CHANX;
			break;
			case onechar('Y', 0, 8):
				return enum_node_type::CHANY;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('S', 0, 32) | onechar('O', 8, 32) | onechar('U', 16, 32) | onechar('R', 24, 32):
			switch(in[4]){
			case onechar('C', 0, 8):
				switch(in[5]){
				case onechar('E', 0, 8):
					return enum_node_type::SOURCE;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_node_type.").c_str());
	return enum_node_type::UXSD_INVALID;
}

inline enum_node_direction lex_enum_node_direction(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('N', 0, 32) | onechar('O', 8, 32) | onechar('N', 16, 32) | onechar('E', 24, 32):
			return enum_node_direction::NONE;
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('B', 0, 32) | onechar('I', 8, 32) | onechar('_', 16, 32) | onechar('D', 24, 32):
			switch(in[4]){
			case onechar('I', 0, 8):
				switch(in[5]){
				case onechar('R', 0, 8):
					return enum_node_direction::BI_DIR;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 7:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('D', 0, 32) | onechar('E', 8, 32) | onechar('C', 16, 32) | onechar('_', 24, 32):
			switch(in[4]){
			case onechar('D', 0, 8):
				switch(in[5]){
				case onechar('I', 0, 8):
					switch(in[6]){
					case onechar('R', 0, 8):
						return enum_node_direction::DEC_DIR;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('I', 0, 32) | onechar('N', 8, 32) | onechar('C', 16, 32) | onechar('_', 24, 32):
			switch(in[4]){
			case onechar('D', 0, 8):
				switch(in[5]){
				case onechar('I', 0, 8):
					switch(in[6]){
					case onechar('R', 0, 8):
						return enum_node_direction::INC_DIR;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_node_direction.").c_str());
	return enum_node_direction::UXSD_INVALID;
}

inline enum_node_clk_res_type lex_enum_node_clk_res_type(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 12:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('V', 0, 64) | onechar('I', 8, 64) | onechar('R', 16, 64) | onechar('T', 24, 64) | onechar('U', 32, 64) | onechar('A', 40, 64) | onechar('L', 48, 64) | onechar('_', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('S', 0, 32) | onechar('I', 8, 32) | onechar('N', 16, 32) | onechar('K', 24, 32):
				return enum_node_clk_res_type::VIRTUAL_SINK;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_node_clk_res_type.").c_str());
	return enum_node_clk_res_type::UXSD_INVALID;
}

inline enum_loc_side lex_enum_loc_side(const char *in, bool throw_on_invalid, const std::function<void(const char *)> * report_error){
	unsigned int len = strlen(in);
	switch(len){
	case 3:
		switch(in[0]){
		case onechar('T', 0, 8):
			switch(in[1]){
			case onechar('O', 0, 8):
				switch(in[2]){
				case onechar('P', 0, 8):
					return enum_loc_side::TOP;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 4:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('L', 0, 32) | onechar('E', 8, 32) | onechar('F', 16, 32) | onechar('T', 24, 32):
			return enum_loc_side::LEFT;
		break;
		default: break;
		}
		break;
	case 5:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('R', 0, 32) | onechar('I', 8, 32) | onechar('G', 16, 32) | onechar('H', 24, 32):
			switch(in[4]){
			case onechar('T', 0, 8):
				return enum_loc_side::RIGHT;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 6:
		switch(*((triehash_uu32*)&in[0])){
		case onechar('B', 0, 32) | onechar('O', 8, 32) | onechar('T', 16, 32) | onechar('T', 24, 32):
			switch(in[4]){
			case onechar('O', 0, 8):
				switch(in[5]){
				case onechar('M', 0, 8):
					return enum_loc_side::BOTTOM;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 8:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('L', 32, 64) | onechar('E', 40, 64) | onechar('F', 48, 64) | onechar('T', 56, 64):
			return enum_loc_side::TOP_LEFT;
		break;
		default: break;
		}
		break;
	case 9:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('R', 32, 64) | onechar('I', 40, 64) | onechar('G', 48, 64) | onechar('H', 56, 64):
			switch(in[8]){
			case onechar('T', 0, 8):
				return enum_loc_side::TOP_RIGHT;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 10:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('R', 0, 64) | onechar('I', 8, 64) | onechar('G', 16, 64) | onechar('H', 24, 64) | onechar('T', 32, 64) | onechar('_', 40, 64) | onechar('L', 48, 64) | onechar('E', 56, 64):
			switch(in[8]){
			case onechar('F', 0, 8):
				switch(in[9]){
				case onechar('T', 0, 8):
					return enum_loc_side::RIGHT_LEFT;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('B', 32, 64) | onechar('O', 40, 64) | onechar('T', 48, 64) | onechar('T', 56, 64):
			switch(in[8]){
			case onechar('O', 0, 8):
				switch(in[9]){
				case onechar('M', 0, 8):
					return enum_loc_side::TOP_BOTTOM;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 11:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('B', 0, 64) | onechar('O', 8, 64) | onechar('T', 16, 64) | onechar('T', 24, 64) | onechar('O', 32, 64) | onechar('M', 40, 64) | onechar('_', 48, 64) | onechar('L', 56, 64):
			switch(in[8]){
			case onechar('E', 0, 8):
				switch(in[9]){
				case onechar('F', 0, 8):
					switch(in[10]){
					case onechar('T', 0, 8):
						return enum_loc_side::BOTTOM_LEFT;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 12:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('R', 0, 64) | onechar('I', 8, 64) | onechar('G', 16, 64) | onechar('H', 24, 64) | onechar('T', 32, 64) | onechar('_', 40, 64) | onechar('B', 48, 64) | onechar('O', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('T', 0, 32) | onechar('T', 8, 32) | onechar('O', 16, 32) | onechar('M', 24, 32):
				return enum_loc_side::RIGHT_BOTTOM;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 14:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('R', 32, 64) | onechar('I', 40, 64) | onechar('G', 48, 64) | onechar('H', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('T', 0, 32) | onechar('_', 8, 32) | onechar('L', 16, 32) | onechar('E', 24, 32):
				switch(in[12]){
				case onechar('F', 0, 8):
					switch(in[13]){
					case onechar('T', 0, 8):
						return enum_loc_side::TOP_RIGHT_LEFT;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 15:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('B', 32, 64) | onechar('O', 40, 64) | onechar('T', 48, 64) | onechar('T', 56, 64):
			switch(*((triehash_uu32*)&in[8])){
			case onechar('O', 0, 32) | onechar('M', 8, 32) | onechar('_', 16, 32) | onechar('L', 24, 32):
				switch(in[12]){
				case onechar('E', 0, 8):
					switch(in[13]){
					case onechar('F', 0, 8):
						switch(in[14]){
						case onechar('T', 0, 8):
							return enum_loc_side::TOP_BOTTOM_LEFT;
						break;
						default: break;
						}
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 16:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('R', 32, 64) | onechar('I', 40, 64) | onechar('G', 48, 64) | onechar('H', 56, 64):
			switch(*((triehash_uu64*)&in[8])){
			case onechar('T', 0, 64) | onechar('_', 8, 64) | onechar('B', 16, 64) | onechar('O', 24, 64) | onechar('T', 32, 64) | onechar('T', 40, 64) | onechar('O', 48, 64) | onechar('M', 56, 64):
				return enum_loc_side::TOP_RIGHT_BOTTOM;
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 17:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('R', 0, 64) | onechar('I', 8, 64) | onechar('G', 16, 64) | onechar('H', 24, 64) | onechar('T', 32, 64) | onechar('_', 40, 64) | onechar('B', 48, 64) | onechar('O', 56, 64):
			switch(*((triehash_uu64*)&in[8])){
			case onechar('T', 0, 64) | onechar('T', 8, 64) | onechar('O', 16, 64) | onechar('M', 24, 64) | onechar('_', 32, 64) | onechar('L', 40, 64) | onechar('E', 48, 64) | onechar('F', 56, 64):
				switch(in[16]){
				case onechar('T', 0, 8):
					return enum_loc_side::RIGHT_BOTTOM_LEFT;
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	case 21:
		switch(*((triehash_uu64*)&in[0])){
		case onechar('T', 0, 64) | onechar('O', 8, 64) | onechar('P', 16, 64) | onechar('_', 24, 64) | onechar('R', 32, 64) | onechar('I', 40, 64) | onechar('G', 48, 64) | onechar('H', 56, 64):
			switch(*((triehash_uu64*)&in[8])){
			case onechar('T', 0, 64) | onechar('_', 8, 64) | onechar('B', 16, 64) | onechar('O', 24, 64) | onechar('T', 32, 64) | onechar('T', 40, 64) | onechar('O', 48, 64) | onechar('M', 56, 64):
				switch(*((triehash_uu32*)&in[16])){
				case onechar('_', 0, 32) | onechar('L', 8, 32) | onechar('E', 16, 32) | onechar('F', 24, 32):
					switch(in[20]){
					case onechar('T', 0, 8):
						return enum_loc_side::TOP_RIGHT_BOTTOM_LEFT;
					break;
					default: break;
					}
				break;
				default: break;
				}
			break;
			default: break;
			}
		break;
		default: break;
		}
		break;
	default: break;
	}
	if(throw_on_invalid)
		noreturn_report(report_error, ("Found unrecognized enum value " + std::string(in) + " of enum_loc_side.").c_str());
	return enum_loc_side::UXSD_INVALID;
}


/* Internal loading functions, which validate and load a PugiXML DOM tree into memory. */
inline int load_int(const char *in, const std::function<void(const char *)> * report_error){
	int out;
	out = std::strtol(in, NULL, 10);
	if(errno != 0)
		noreturn_report(report_error, ("Invalid value `" + std::string(in) + "` when loading into a int.").c_str());
	return out;
}

inline unsigned int load_unsigned_int(const char *in, const std::function<void(const char *)> * report_error){
	unsigned int out;
	out = std::strtoul(in, NULL, 10);
	if(errno != 0)
		noreturn_report(report_error, ("Invalid value `" + std::string(in) + "` when loading into a unsigned int.").c_str());
	return out;
}

inline float load_float(const char *in, const std::function<void(const char *)> * report_error){
	float out;
	out = std::strtof(in, NULL);
	if(errno != 0)
		noreturn_report(report_error, ("Invalid value `" + std::string(in) + "` when loading into a float.").c_str());
	return out;
}
inline void load_channel_required_attributes(const pugi::xml_node &root, int * chan_width_max, int * x_max, int * x_min, int * y_max, int * y_min, const std::function<void(const char *)> * report_error){
	std::bitset<5> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_channel in = lex_attr_t_channel(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <channel>.").c_str());
		switch(in){
		case atok_t_channel::CHAN_WIDTH_MAX:
			*chan_width_max = load_int(attr.value(), report_error);
			break;
		case atok_t_channel::X_MAX:
			*x_max = load_int(attr.value(), report_error);
			break;
		case atok_t_channel::X_MIN:
			*x_min = load_int(attr.value(), report_error);
			break;
		case atok_t_channel::Y_MAX:
			*y_max = load_int(attr.value(), report_error);
			break;
		case atok_t_channel::Y_MIN:
			*y_min = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<5> test_astate = astate | std::bitset<5>(0b00000);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_channel, report_error);
}

inline void load_x_list_required_attributes(const pugi::xml_node &root, unsigned int * index, int * info, const std::function<void(const char *)> * report_error){
	std::bitset<2> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_x_list in = lex_attr_t_x_list(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <x_list>.").c_str());
		switch(in){
		case atok_t_x_list::INDEX:
			*index = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_x_list::INFO:
			*info = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<2> test_astate = astate | std::bitset<2>(0b00);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_x_list, report_error);
}

inline void load_y_list_required_attributes(const pugi::xml_node &root, unsigned int * index, int * info, const std::function<void(const char *)> * report_error){
	std::bitset<2> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_y_list in = lex_attr_t_y_list(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <y_list>.").c_str());
		switch(in){
		case atok_t_y_list::INDEX:
			*index = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_y_list::INFO:
			*info = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<2> test_astate = astate | std::bitset<2>(0b00);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_y_list, report_error);
}

inline void load_sizing_required_attributes(const pugi::xml_node &root, float * buf_size, float * mux_trans_size, const std::function<void(const char *)> * report_error){
	std::bitset<2> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_sizing in = lex_attr_t_sizing(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <sizing>.").c_str());
		switch(in){
		case atok_t_sizing::BUF_SIZE:
			*buf_size = load_float(attr.value(), report_error);
			break;
		case atok_t_sizing::MUX_TRANS_SIZE:
			*mux_trans_size = load_float(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<2> test_astate = astate | std::bitset<2>(0b00);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_sizing, report_error);
}

inline void load_switch_required_attributes(const pugi::xml_node &root, int * id, const std::function<void(const char *)> * report_error){
	std::bitset<3> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_switch in = lex_attr_t_switch(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <switch>.").c_str());
		switch(in){
		case atok_t_switch::ID:
			*id = load_int(attr.value(), report_error);
			break;
		case atok_t_switch::NAME:
			/* Attribute name set after element init */
			break;
		case atok_t_switch::TYPE:
			/* Attribute type set after element init */
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<3> test_astate = astate | std::bitset<3>(0b100);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_switch, report_error);
}

inline void load_segment_required_attributes(const pugi::xml_node &root, int * id, const std::function<void(const char *)> * report_error){
	std::bitset<4> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_segment in = lex_attr_t_segment(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <segment>.").c_str());
		switch(in){
		case atok_t_segment::ID:
			*id = load_int(attr.value(), report_error);
			break;
		case atok_t_segment::LENGTH:
			/* Attribute length set after element init */
			break;
		case atok_t_segment::NAME:
			/* Attribute name set after element init */
			break;
		case atok_t_segment::RES_TYPE:
			/* Attribute res_type set after element init */
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<4> test_astate = astate | std::bitset<4>(0b1010);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_segment, report_error);
}

inline void load_pin_required_attributes(const pugi::xml_node &root, int * ptc, const std::function<void(const char *)> * report_error){
	std::bitset<1> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_pin in = lex_attr_t_pin(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <pin>.").c_str());
		switch(in){
		case atok_t_pin::PTC:
			*ptc = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<1> test_astate = astate | std::bitset<1>(0b0);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_pin, report_error);
}

inline void load_pin_class_required_attributes(const pugi::xml_node &root, enum_pin_type * type, const std::function<void(const char *)> * report_error){
	std::bitset<1> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_pin_class in = lex_attr_t_pin_class(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <pin_class>.").c_str());
		switch(in){
		case atok_t_pin_class::TYPE:
			*type = lex_enum_pin_type(attr.value(), true, report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<1> test_astate = astate | std::bitset<1>(0b0);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_pin_class, report_error);
}

inline void load_block_type_required_attributes(const pugi::xml_node &root, int * height, int * id, int * width, const std::function<void(const char *)> * report_error){
	std::bitset<4> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_block_type in = lex_attr_t_block_type(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <block_type>.").c_str());
		switch(in){
		case atok_t_block_type::HEIGHT:
			*height = load_int(attr.value(), report_error);
			break;
		case atok_t_block_type::ID:
			*id = load_int(attr.value(), report_error);
			break;
		case atok_t_block_type::NAME:
			/* Attribute name set after element init */
			break;
		case atok_t_block_type::WIDTH:
			*width = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<4> test_astate = astate | std::bitset<4>(0b0000);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_block_type, report_error);
}

inline void load_grid_loc_required_attributes(const pugi::xml_node &root, int * block_type_id, int * height_offset, int * width_offset, int * x, int * y, const std::function<void(const char *)> * report_error){
	std::bitset<6> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_grid_loc in = lex_attr_t_grid_loc(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <grid_loc>.").c_str());
		switch(in){
		case atok_t_grid_loc::BLOCK_TYPE_ID:
			*block_type_id = load_int(attr.value(), report_error);
			break;
		case atok_t_grid_loc::HEIGHT_OFFSET:
			*height_offset = load_int(attr.value(), report_error);
			break;
		case atok_t_grid_loc::LAYER:
			/* Attribute layer set after element init */
			break;
		case atok_t_grid_loc::WIDTH_OFFSET:
			*width_offset = load_int(attr.value(), report_error);
			break;
		case atok_t_grid_loc::X:
			*x = load_int(attr.value(), report_error);
			break;
		case atok_t_grid_loc::Y:
			*y = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<6> test_astate = astate | std::bitset<6>(0b000100);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_grid_loc, report_error);
}

inline void load_node_loc_required_attributes(const pugi::xml_node &root, int * ptc, int * xhigh, int * xlow, int * yhigh, int * ylow, const std::function<void(const char *)> * report_error){
	std::bitset<8> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node_loc in = lex_attr_t_node_loc(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <node_loc>.").c_str());
		switch(in){
		case atok_t_node_loc::LAYER:
			/* Attribute layer set after element init */
			break;
		case atok_t_node_loc::PTC:
			*ptc = load_int(attr.value(), report_error);
			break;
		case atok_t_node_loc::SIDE:
			/* Attribute side set after element init */
			break;
		case atok_t_node_loc::TWIST:
			/* Attribute twist set after element init */
			break;
		case atok_t_node_loc::XHIGH:
			*xhigh = load_int(attr.value(), report_error);
			break;
		case atok_t_node_loc::XLOW:
			*xlow = load_int(attr.value(), report_error);
			break;
		case atok_t_node_loc::YHIGH:
			*yhigh = load_int(attr.value(), report_error);
			break;
		case atok_t_node_loc::YLOW:
			*ylow = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<8> test_astate = astate | std::bitset<8>(0b00001101);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_node_loc, report_error);
}

inline void load_node_timing_required_attributes(const pugi::xml_node &root, float * C, float * R, const std::function<void(const char *)> * report_error){
	std::bitset<2> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node_timing in = lex_attr_t_node_timing(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <node_timing>.").c_str());
		switch(in){
		case atok_t_node_timing::C:
			*C = load_float(attr.value(), report_error);
			break;
		case atok_t_node_timing::R:
			*R = load_float(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<2> test_astate = astate | std::bitset<2>(0b00);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_node_timing, report_error);
}

inline void load_node_segment_required_attributes(const pugi::xml_node &root, int * segment_id, const std::function<void(const char *)> * report_error){
	std::bitset<1> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node_segment in = lex_attr_t_node_segment(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <node_segment>.").c_str());
		switch(in){
		case atok_t_node_segment::SEGMENT_ID:
			*segment_id = load_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<1> test_astate = astate | std::bitset<1>(0b0);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_node_segment, report_error);
}

inline void load_node_required_attributes(const pugi::xml_node &root, unsigned int * capacity, unsigned int * id, enum_node_type * type, const std::function<void(const char *)> * report_error){
	std::bitset<6> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node in = lex_attr_t_node(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <node>.").c_str());
		switch(in){
		case atok_t_node::CAPACITY:
			*capacity = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_node::CLK_RES_TYPE:
			/* Attribute clk_res_type set after element init */
			break;
		case atok_t_node::DIRECTION:
			/* Attribute direction set after element init */
			break;
		case atok_t_node::ID:
			*id = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_node::NAME:
			/* Attribute name set after element init */
			break;
		case atok_t_node::TYPE:
			*type = lex_enum_node_type(attr.value(), true, report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<6> test_astate = astate | std::bitset<6>(0b010110);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_node, report_error);
}

inline void load_edge_required_attributes(const pugi::xml_node &root, unsigned int * sink_node, unsigned int * src_node, unsigned int * switch_id, const std::function<void(const char *)> * report_error){
	std::bitset<3> astate = 0;
	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_edge in = lex_attr_t_edge(attr.name(), report_error);
		if(astate[(int)in] == 0) astate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate attribute " + std::string(attr.name()) + " in <edge>.").c_str());
		switch(in){
		case atok_t_edge::SINK_NODE:
			*sink_node = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_edge::SRC_NODE:
			*src_node = load_unsigned_int(attr.value(), report_error);
			break;
		case atok_t_edge::SWITCH_ID:
			*switch_id = load_unsigned_int(attr.value(), report_error);
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<3> test_astate = astate | std::bitset<3>(0b000);
	if(!test_astate.all()) attr_error(test_astate, atok_lookup_t_edge, report_error);
}
template<class T, typename Context>
inline void load_channel(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <channel>.");

}

template<class T, typename Context>
inline void load_x_list(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <x_list>.");

}

template<class T, typename Context>
inline void load_y_list(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <y_list>.");

}

constexpr int NUM_T_CHANNELS_STATES = 4;
constexpr const int NUM_T_CHANNELS_INPUTS = 3;
constexpr int gstate_t_channels[NUM_T_CHANNELS_STATES][NUM_T_CHANNELS_INPUTS] = {
	{-1, -1, 0},
	{-1, 1, 0},
	{-1, 1, -1},
	{2, -1, -1},
};
template<class T, typename Context>
inline void load_channels(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <channels>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t x_list_count = 0;
	size_t y_list_count = 0;
	{
		int next, state=3;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_channels in = lex_node_t_channels(node.name(), report_error);
			next = gstate_t_channels[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_channels[(int)in], gstate_t_channels[state], gtok_lookup_t_channels, 3, report_error);
			state = next;
			switch(in) {
			case gtok_t_channels::CHANNEL:
				break;
			case gtok_t_channels::X_LIST:
				x_list_count += 1;
				break;
			case gtok_t_channels::Y_LIST:
				y_list_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_channels_x_list(context, x_list_count);
		out.preallocate_channels_y_list(context, y_list_count);
	}
	int next, state=3;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_channels in = lex_node_t_channels(node.name(), report_error);
		next = gstate_t_channels[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_channels[(int)in], gstate_t_channels[state], gtok_lookup_t_channels, 3, report_error);
		state = next;
		switch(in){
		case gtok_t_channels::CHANNEL:
			{
				int channel_chan_width_max;
				memset(&channel_chan_width_max, 0, sizeof(channel_chan_width_max));
				int channel_x_max;
				memset(&channel_x_max, 0, sizeof(channel_x_max));
				int channel_x_min;
				memset(&channel_x_min, 0, sizeof(channel_x_min));
				int channel_y_max;
				memset(&channel_y_max, 0, sizeof(channel_y_max));
				int channel_y_min;
				memset(&channel_y_min, 0, sizeof(channel_y_min));
				load_channel_required_attributes(node, &channel_chan_width_max, &channel_x_max, &channel_x_min, &channel_y_max, &channel_y_min, report_error);
				auto child_context = out.init_channels_channel(context, channel_chan_width_max, channel_x_max, channel_x_min, channel_y_max, channel_y_min);
				load_channel(node, out, child_context, report_error, offset_debug);
				out.finish_channels_channel(child_context);
			}
			break;
		case gtok_t_channels::X_LIST:
			{
				unsigned int x_list_index;
				memset(&x_list_index, 0, sizeof(x_list_index));
				int x_list_info;
				memset(&x_list_info, 0, sizeof(x_list_info));
				load_x_list_required_attributes(node, &x_list_index, &x_list_info, report_error);
				auto child_context = out.add_channels_x_list(context, x_list_index, x_list_info);
				load_x_list(node, out, child_context, report_error, offset_debug);
				out.finish_channels_x_list(child_context);
			}
			break;
		case gtok_t_channels::Y_LIST:
			{
				unsigned int y_list_index;
				memset(&y_list_index, 0, sizeof(y_list_index));
				int y_list_info;
				memset(&y_list_info, 0, sizeof(y_list_info));
				load_y_list_required_attributes(node, &y_list_index, &y_list_info, report_error);
				auto child_context = out.add_channels_y_list(context, y_list_index, y_list_info);
				load_y_list(node, out, child_context, report_error, offset_debug);
				out.finish_channels_y_list(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_channels[state], gtok_lookup_t_channels, 3, report_error);

}

template<class T, typename Context>
inline void load_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_timing in = lex_attr_t_timing(attr.name(), report_error);
		switch(in){
		case atok_t_timing::CIN:
			out.set_timing_Cin(load_float(attr.value(), report_error), context);
			break;
		case atok_t_timing::CINTERNAL:
			out.set_timing_Cinternal(load_float(attr.value(), report_error), context);
			break;
		case atok_t_timing::COUT:
			out.set_timing_Cout(load_float(attr.value(), report_error), context);
			break;
		case atok_t_timing::R:
			out.set_timing_R(load_float(attr.value(), report_error), context);
			break;
		case atok_t_timing::TDEL:
			out.set_timing_Tdel(load_float(attr.value(), report_error), context);
			break;
		default: break; /* Not possible. */
		}
	}

	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <timing>.");

}

template<class T, typename Context>
inline void load_sizing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <sizing>.");

}

template<class T, typename Context>
inline void load_switch(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_switch in = lex_attr_t_switch(attr.name(), report_error);
		switch(in){
		case atok_t_switch::ID:
			/* Attribute id is already set */
			break;
		case atok_t_switch::NAME:
			out.set_switch_name(attr.value(), context);
			break;
		case atok_t_switch::TYPE:
			out.set_switch_type(lex_enum_switch_type(attr.value(), true, report_error), context);
			break;
		default: break; /* Not possible. */
		}
	}

	std::bitset<2> gstate = 0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_switch in = lex_node_t_switch(node.name(), report_error);
		if(gstate[(int)in] == 0) gstate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate element " + std::string(node.name()) + " in <switch>.").c_str());
		switch(in){
		case gtok_t_switch::TIMING:
			{
				auto child_context = out.init_switch_timing(context);
				load_timing(node, out, child_context, report_error, offset_debug);
				out.finish_switch_timing(child_context);
			}
			break;
		case gtok_t_switch::SIZING:
			{
				float sizing_buf_size;
				memset(&sizing_buf_size, 0, sizeof(sizing_buf_size));
				float sizing_mux_trans_size;
				memset(&sizing_mux_trans_size, 0, sizeof(sizing_mux_trans_size));
				load_sizing_required_attributes(node, &sizing_buf_size, &sizing_mux_trans_size, report_error);
				auto child_context = out.init_switch_sizing(context, sizing_buf_size, sizing_mux_trans_size);
				load_sizing(node, out, child_context, report_error, offset_debug);
				out.finish_switch_sizing(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<2> test_gstate = gstate | std::bitset<2>(0b01);
	if(!test_gstate.all()) all_error(test_gstate, gtok_lookup_t_switch, report_error);

}

constexpr int NUM_T_SWITCHES_STATES = 2;
constexpr const int NUM_T_SWITCHES_INPUTS = 1;
constexpr int gstate_t_switches[NUM_T_SWITCHES_STATES][NUM_T_SWITCHES_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_switches(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <switches>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t switch_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_switches in = lex_node_t_switches(node.name(), report_error);
			next = gstate_t_switches[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_switches[(int)in], gstate_t_switches[state], gtok_lookup_t_switches, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_switches::SWITCH:
				switch_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_switches_switch(context, switch_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_switches in = lex_node_t_switches(node.name(), report_error);
		next = gstate_t_switches[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_switches[(int)in], gstate_t_switches[state], gtok_lookup_t_switches, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_switches::SWITCH:
			{
				int switch_id;
				memset(&switch_id, 0, sizeof(switch_id));
				load_switch_required_attributes(node, &switch_id, report_error);
				auto child_context = out.add_switches_switch(context, switch_id);
				load_switch(node, out, child_context, report_error, offset_debug);
				out.finish_switches_switch(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_switches[state], gtok_lookup_t_switches, 1, report_error);

}

template<class T, typename Context>
inline void load_segment_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_segment_timing in = lex_attr_t_segment_timing(attr.name(), report_error);
		switch(in){
		case atok_t_segment_timing::C_PER_METER:
			out.set_segment_timing_C_per_meter(load_float(attr.value(), report_error), context);
			break;
		case atok_t_segment_timing::R_PER_METER:
			out.set_segment_timing_R_per_meter(load_float(attr.value(), report_error), context);
			break;
		default: break; /* Not possible. */
		}
	}

	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <segment_timing>.");

}

template<class T, typename Context>
inline void load_segment(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_segment in = lex_attr_t_segment(attr.name(), report_error);
		switch(in){
		case atok_t_segment::ID:
			/* Attribute id is already set */
			break;
		case atok_t_segment::LENGTH:
			out.set_segment_length(load_int(attr.value(), report_error), context);
			break;
		case atok_t_segment::NAME:
			out.set_segment_name(attr.value(), context);
			break;
		case atok_t_segment::RES_TYPE:
			out.set_segment_res_type(lex_enum_segment_res_type(attr.value(), true, report_error), context);
			break;
		default: break; /* Not possible. */
		}
	}

	std::bitset<1> gstate = 0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_segment in = lex_node_t_segment(node.name(), report_error);
		if(gstate[(int)in] == 0) gstate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate element " + std::string(node.name()) + " in <segment>.").c_str());
		switch(in){
		case gtok_t_segment::TIMING:
			{
				auto child_context = out.init_segment_timing(context);
				load_segment_timing(node, out, child_context, report_error, offset_debug);
				out.finish_segment_timing(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<1> test_gstate = gstate | std::bitset<1>(0b1);
	if(!test_gstate.all()) all_error(test_gstate, gtok_lookup_t_segment, report_error);

}

constexpr int NUM_T_SEGMENTS_STATES = 2;
constexpr const int NUM_T_SEGMENTS_INPUTS = 1;
constexpr int gstate_t_segments[NUM_T_SEGMENTS_STATES][NUM_T_SEGMENTS_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_segments(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <segments>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t segment_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_segments in = lex_node_t_segments(node.name(), report_error);
			next = gstate_t_segments[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_segments[(int)in], gstate_t_segments[state], gtok_lookup_t_segments, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_segments::SEGMENT:
				segment_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_segments_segment(context, segment_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_segments in = lex_node_t_segments(node.name(), report_error);
		next = gstate_t_segments[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_segments[(int)in], gstate_t_segments[state], gtok_lookup_t_segments, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_segments::SEGMENT:
			{
				int segment_id;
				memset(&segment_id, 0, sizeof(segment_id));
				load_segment_required_attributes(node, &segment_id, report_error);
				auto child_context = out.add_segments_segment(context, segment_id);
				load_segment(node, out, child_context, report_error, offset_debug);
				out.finish_segments_segment(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_segments[state], gtok_lookup_t_segments, 1, report_error);

}

template<class T, typename Context>
inline void load_pin(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	out.set_pin_value(root.child_value(), context);
	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <pin>.");

}

constexpr int NUM_T_PIN_CLASS_STATES = 2;
constexpr const int NUM_T_PIN_CLASS_INPUTS = 1;
constexpr int gstate_t_pin_class[NUM_T_PIN_CLASS_STATES][NUM_T_PIN_CLASS_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_pin_class(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	// Preallocate arrays by counting child nodes (if any)
	size_t pin_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_pin_class in = lex_node_t_pin_class(node.name(), report_error);
			next = gstate_t_pin_class[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_pin_class[(int)in], gstate_t_pin_class[state], gtok_lookup_t_pin_class, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_pin_class::PIN:
				pin_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_pin_class_pin(context, pin_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_pin_class in = lex_node_t_pin_class(node.name(), report_error);
		next = gstate_t_pin_class[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_pin_class[(int)in], gstate_t_pin_class[state], gtok_lookup_t_pin_class, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_pin_class::PIN:
			{
				int pin_ptc;
				memset(&pin_ptc, 0, sizeof(pin_ptc));
				load_pin_required_attributes(node, &pin_ptc, report_error);
				auto child_context = out.add_pin_class_pin(context, pin_ptc);
				load_pin(node, out, child_context, report_error, offset_debug);
				out.finish_pin_class_pin(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_pin_class[state], gtok_lookup_t_pin_class, 1, report_error);

}

constexpr int NUM_T_BLOCK_TYPE_STATES = 1;
constexpr const int NUM_T_BLOCK_TYPE_INPUTS = 1;
constexpr int gstate_t_block_type[NUM_T_BLOCK_TYPE_STATES][NUM_T_BLOCK_TYPE_INPUTS] = {
	{0},
};
template<class T, typename Context>
inline void load_block_type(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_block_type in = lex_attr_t_block_type(attr.name(), report_error);
		switch(in){
		case atok_t_block_type::HEIGHT:
			/* Attribute height is already set */
			break;
		case atok_t_block_type::ID:
			/* Attribute id is already set */
			break;
		case atok_t_block_type::NAME:
			out.set_block_type_name(attr.value(), context);
			break;
		case atok_t_block_type::WIDTH:
			/* Attribute width is already set */
			break;
		default: break; /* Not possible. */
		}
	}

	// Preallocate arrays by counting child nodes (if any)
	size_t pin_class_count = 0;
	{
		int next, state=0;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_block_type in = lex_node_t_block_type(node.name(), report_error);
			next = gstate_t_block_type[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_block_type[(int)in], gstate_t_block_type[state], gtok_lookup_t_block_type, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_block_type::PIN_CLASS:
				pin_class_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_block_type_pin_class(context, pin_class_count);
	}
	int next, state=0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_block_type in = lex_node_t_block_type(node.name(), report_error);
		next = gstate_t_block_type[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_block_type[(int)in], gstate_t_block_type[state], gtok_lookup_t_block_type, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_block_type::PIN_CLASS:
			{
				enum_pin_type pin_class_type;
				memset(&pin_class_type, 0, sizeof(pin_class_type));
				load_pin_class_required_attributes(node, &pin_class_type, report_error);
				auto child_context = out.add_block_type_pin_class(context, pin_class_type);
				load_pin_class(node, out, child_context, report_error, offset_debug);
				out.finish_block_type_pin_class(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_block_type[state], gtok_lookup_t_block_type, 1, report_error);

}

constexpr int NUM_T_BLOCK_TYPES_STATES = 2;
constexpr const int NUM_T_BLOCK_TYPES_INPUTS = 1;
constexpr int gstate_t_block_types[NUM_T_BLOCK_TYPES_STATES][NUM_T_BLOCK_TYPES_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_block_types(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <block_types>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t block_type_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_block_types in = lex_node_t_block_types(node.name(), report_error);
			next = gstate_t_block_types[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_block_types[(int)in], gstate_t_block_types[state], gtok_lookup_t_block_types, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_block_types::BLOCK_TYPE:
				block_type_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_block_types_block_type(context, block_type_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_block_types in = lex_node_t_block_types(node.name(), report_error);
		next = gstate_t_block_types[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_block_types[(int)in], gstate_t_block_types[state], gtok_lookup_t_block_types, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_block_types::BLOCK_TYPE:
			{
				int block_type_height;
				memset(&block_type_height, 0, sizeof(block_type_height));
				int block_type_id;
				memset(&block_type_id, 0, sizeof(block_type_id));
				int block_type_width;
				memset(&block_type_width, 0, sizeof(block_type_width));
				load_block_type_required_attributes(node, &block_type_height, &block_type_id, &block_type_width, report_error);
				auto child_context = out.add_block_types_block_type(context, block_type_height, block_type_id, block_type_width);
				load_block_type(node, out, child_context, report_error, offset_debug);
				out.finish_block_types_block_type(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_block_types[state], gtok_lookup_t_block_types, 1, report_error);

}

template<class T, typename Context>
inline void load_grid_loc(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_grid_loc in = lex_attr_t_grid_loc(attr.name(), report_error);
		switch(in){
		case atok_t_grid_loc::BLOCK_TYPE_ID:
			/* Attribute block_type_id is already set */
			break;
		case atok_t_grid_loc::HEIGHT_OFFSET:
			/* Attribute height_offset is already set */
			break;
		case atok_t_grid_loc::LAYER:
			out.set_grid_loc_layer(load_int(attr.value(), report_error), context);
			break;
		case atok_t_grid_loc::WIDTH_OFFSET:
			/* Attribute width_offset is already set */
			break;
		case atok_t_grid_loc::X:
			/* Attribute x is already set */
			break;
		case atok_t_grid_loc::Y:
			/* Attribute y is already set */
			break;
		default: break; /* Not possible. */
		}
	}

	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <grid_loc>.");

}

constexpr int NUM_T_GRID_LOCS_STATES = 2;
constexpr const int NUM_T_GRID_LOCS_INPUTS = 1;
constexpr int gstate_t_grid_locs[NUM_T_GRID_LOCS_STATES][NUM_T_GRID_LOCS_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_grid_locs(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <grid_locs>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t grid_loc_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_grid_locs in = lex_node_t_grid_locs(node.name(), report_error);
			next = gstate_t_grid_locs[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_grid_locs[(int)in], gstate_t_grid_locs[state], gtok_lookup_t_grid_locs, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_grid_locs::GRID_LOC:
				grid_loc_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_grid_locs_grid_loc(context, grid_loc_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_grid_locs in = lex_node_t_grid_locs(node.name(), report_error);
		next = gstate_t_grid_locs[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_grid_locs[(int)in], gstate_t_grid_locs[state], gtok_lookup_t_grid_locs, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_grid_locs::GRID_LOC:
			{
				int grid_loc_block_type_id;
				memset(&grid_loc_block_type_id, 0, sizeof(grid_loc_block_type_id));
				int grid_loc_height_offset;
				memset(&grid_loc_height_offset, 0, sizeof(grid_loc_height_offset));
				int grid_loc_width_offset;
				memset(&grid_loc_width_offset, 0, sizeof(grid_loc_width_offset));
				int grid_loc_x;
				memset(&grid_loc_x, 0, sizeof(grid_loc_x));
				int grid_loc_y;
				memset(&grid_loc_y, 0, sizeof(grid_loc_y));
				load_grid_loc_required_attributes(node, &grid_loc_block_type_id, &grid_loc_height_offset, &grid_loc_width_offset, &grid_loc_x, &grid_loc_y, report_error);
				auto child_context = out.add_grid_locs_grid_loc(context, grid_loc_block_type_id, grid_loc_height_offset, grid_loc_width_offset, grid_loc_x, grid_loc_y);
				load_grid_loc(node, out, child_context, report_error, offset_debug);
				out.finish_grid_locs_grid_loc(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_grid_locs[state], gtok_lookup_t_grid_locs, 1, report_error);

}

template<class T, typename Context>
inline void load_node_loc(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node_loc in = lex_attr_t_node_loc(attr.name(), report_error);
		switch(in){
		case atok_t_node_loc::LAYER:
			out.set_node_loc_layer(load_int(attr.value(), report_error), context);
			break;
		case atok_t_node_loc::PTC:
			/* Attribute ptc is already set */
			break;
		case atok_t_node_loc::SIDE:
			out.set_node_loc_side(lex_enum_loc_side(attr.value(), true, report_error), context);
			break;
		case atok_t_node_loc::TWIST:
			out.set_node_loc_twist(load_int(attr.value(), report_error), context);
			break;
		case atok_t_node_loc::XHIGH:
			/* Attribute xhigh is already set */
			break;
		case atok_t_node_loc::XLOW:
			/* Attribute xlow is already set */
			break;
		case atok_t_node_loc::YHIGH:
			/* Attribute yhigh is already set */
			break;
		case atok_t_node_loc::YLOW:
			/* Attribute ylow is already set */
			break;
		default: break; /* Not possible. */
		}
	}

	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <node_loc>.");

}

template<class T, typename Context>
inline void load_node_timing(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <node_timing>.");

}

template<class T, typename Context>
inline void load_node_segment(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <node_segment>.");

}

template<class T, typename Context>
inline void load_meta(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_meta in = lex_attr_t_meta(attr.name(), report_error);
		switch(in){
		case atok_t_meta::NAME:
			out.set_meta_name(attr.value(), context);
			break;
		default: break; /* Not possible. */
		}
	}

	out.set_meta_value(root.child_value(), context);
	if(root.first_child().type() == pugi::node_element)
		noreturn_report(report_error, "Unexpected child element in <meta>.");

}

constexpr int NUM_T_METADATA_STATES = 2;
constexpr const int NUM_T_METADATA_INPUTS = 1;
constexpr int gstate_t_metadata[NUM_T_METADATA_STATES][NUM_T_METADATA_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_metadata(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <metadata>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t meta_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_metadata in = lex_node_t_metadata(node.name(), report_error);
			next = gstate_t_metadata[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_metadata[(int)in], gstate_t_metadata[state], gtok_lookup_t_metadata, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_metadata::META:
				meta_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_metadata_meta(context, meta_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_metadata in = lex_node_t_metadata(node.name(), report_error);
		next = gstate_t_metadata[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_metadata[(int)in], gstate_t_metadata[state], gtok_lookup_t_metadata, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_metadata::META:
			{
				auto child_context = out.add_metadata_meta(context);
				load_meta(node, out, child_context, report_error, offset_debug);
				out.finish_metadata_meta(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_metadata[state], gtok_lookup_t_metadata, 1, report_error);

}

template<class T, typename Context>
inline void load_node(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_node in = lex_attr_t_node(attr.name(), report_error);
		switch(in){
		case atok_t_node::CAPACITY:
			/* Attribute capacity is already set */
			break;
		case atok_t_node::CLK_RES_TYPE:
			out.set_node_clk_res_type(lex_enum_node_clk_res_type(attr.value(), true, report_error), context);
			break;
		case atok_t_node::DIRECTION:
			out.set_node_direction(lex_enum_node_direction(attr.value(), true, report_error), context);
			break;
		case atok_t_node::ID:
			/* Attribute id is already set */
			break;
		case atok_t_node::NAME:
			out.set_node_name(attr.value(), context);
			break;
		case atok_t_node::TYPE:
			/* Attribute type is already set */
			break;
		default: break; /* Not possible. */
		}
	}

	std::bitset<4> gstate = 0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_node in = lex_node_t_node(node.name(), report_error);
		if(gstate[(int)in] == 0) gstate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate element " + std::string(node.name()) + " in <node>.").c_str());
		switch(in){
		case gtok_t_node::LOC:
			{
				int node_loc_ptc;
				memset(&node_loc_ptc, 0, sizeof(node_loc_ptc));
				int node_loc_xhigh;
				memset(&node_loc_xhigh, 0, sizeof(node_loc_xhigh));
				int node_loc_xlow;
				memset(&node_loc_xlow, 0, sizeof(node_loc_xlow));
				int node_loc_yhigh;
				memset(&node_loc_yhigh, 0, sizeof(node_loc_yhigh));
				int node_loc_ylow;
				memset(&node_loc_ylow, 0, sizeof(node_loc_ylow));
				load_node_loc_required_attributes(node, &node_loc_ptc, &node_loc_xhigh, &node_loc_xlow, &node_loc_yhigh, &node_loc_ylow, report_error);
				auto child_context = out.init_node_loc(context, node_loc_ptc, node_loc_xhigh, node_loc_xlow, node_loc_yhigh, node_loc_ylow);
				load_node_loc(node, out, child_context, report_error, offset_debug);
				out.finish_node_loc(child_context);
			}
			break;
		case gtok_t_node::TIMING:
			{
				float node_timing_C;
				memset(&node_timing_C, 0, sizeof(node_timing_C));
				float node_timing_R;
				memset(&node_timing_R, 0, sizeof(node_timing_R));
				load_node_timing_required_attributes(node, &node_timing_C, &node_timing_R, report_error);
				auto child_context = out.init_node_timing(context, node_timing_C, node_timing_R);
				load_node_timing(node, out, child_context, report_error, offset_debug);
				out.finish_node_timing(child_context);
			}
			break;
		case gtok_t_node::SEGMENT:
			{
				int node_segment_segment_id;
				memset(&node_segment_segment_id, 0, sizeof(node_segment_segment_id));
				load_node_segment_required_attributes(node, &node_segment_segment_id, report_error);
				auto child_context = out.init_node_segment(context, node_segment_segment_id);
				load_node_segment(node, out, child_context, report_error, offset_debug);
				out.finish_node_segment(child_context);
			}
			break;
		case gtok_t_node::METADATA:
			{
				auto child_context = out.init_node_metadata(context);
				load_metadata(node, out, child_context, report_error, offset_debug);
				out.finish_node_metadata(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<4> test_gstate = gstate | std::bitset<4>(0b1110);
	if(!test_gstate.all()) all_error(test_gstate, gtok_lookup_t_node, report_error);

}

constexpr int NUM_T_RR_NODES_STATES = 2;
constexpr const int NUM_T_RR_NODES_INPUTS = 1;
constexpr int gstate_t_rr_nodes[NUM_T_RR_NODES_STATES][NUM_T_RR_NODES_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_rr_nodes(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <rr_nodes>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t node_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_rr_nodes in = lex_node_t_rr_nodes(node.name(), report_error);
			next = gstate_t_rr_nodes[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_rr_nodes[(int)in], gstate_t_rr_nodes[state], gtok_lookup_t_rr_nodes, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_rr_nodes::NODE:
				node_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_rr_nodes_node(context, node_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_rr_nodes in = lex_node_t_rr_nodes(node.name(), report_error);
		next = gstate_t_rr_nodes[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_rr_nodes[(int)in], gstate_t_rr_nodes[state], gtok_lookup_t_rr_nodes, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_rr_nodes::NODE:
			{
				unsigned int node_capacity;
				memset(&node_capacity, 0, sizeof(node_capacity));
				unsigned int node_id;
				memset(&node_id, 0, sizeof(node_id));
				enum_node_type node_type;
				memset(&node_type, 0, sizeof(node_type));
				load_node_required_attributes(node, &node_capacity, &node_id, &node_type, report_error);
				auto child_context = out.add_rr_nodes_node(context, node_capacity, node_id, node_type);
				load_node(node, out, child_context, report_error, offset_debug);
				out.finish_rr_nodes_node(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_rr_nodes[state], gtok_lookup_t_rr_nodes, 1, report_error);

}

template<class T, typename Context>
inline void load_edge(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();


	std::bitset<1> gstate = 0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_edge in = lex_node_t_edge(node.name(), report_error);
		if(gstate[(int)in] == 0) gstate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate element " + std::string(node.name()) + " in <edge>.").c_str());
		switch(in){
		case gtok_t_edge::METADATA:
			{
				auto child_context = out.init_edge_metadata(context);
				load_metadata(node, out, child_context, report_error, offset_debug);
				out.finish_edge_metadata(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<1> test_gstate = gstate | std::bitset<1>(0b1);
	if(!test_gstate.all()) all_error(test_gstate, gtok_lookup_t_edge, report_error);

}

constexpr int NUM_T_RR_EDGES_STATES = 2;
constexpr const int NUM_T_RR_EDGES_INPUTS = 1;
constexpr int gstate_t_rr_edges[NUM_T_RR_EDGES_STATES][NUM_T_RR_EDGES_INPUTS] = {
	{0},
	{0},
};
template<class T, typename Context>
inline void load_rr_edges(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	if(root.first_attribute())
		noreturn_report(report_error, "Unexpected attribute in <rr_edges>.");

	// Preallocate arrays by counting child nodes (if any)
	size_t edge_count = 0;
	{
		int next, state=1;
		for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()) {
			*offset_debug = node.offset_debug();
			gtok_t_rr_edges in = lex_node_t_rr_edges(node.name(), report_error);
			next = gstate_t_rr_edges[state][(int)in];
			if(next == -1)
				dfa_error(gtok_lookup_t_rr_edges[(int)in], gstate_t_rr_edges[state], gtok_lookup_t_rr_edges, 1, report_error);
			state = next;
			switch(in) {
			case gtok_t_rr_edges::EDGE:
				edge_count += 1;
				break;
			default: break; /* Not possible. */
			}
		}
		
		out.preallocate_rr_edges_edge(context, edge_count);
	}
	int next, state=1;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_rr_edges in = lex_node_t_rr_edges(node.name(), report_error);
		next = gstate_t_rr_edges[state][(int)in];
		if(next == -1)
			dfa_error(gtok_lookup_t_rr_edges[(int)in], gstate_t_rr_edges[state], gtok_lookup_t_rr_edges, 1, report_error);
		state = next;
		switch(in){
		case gtok_t_rr_edges::EDGE:
			{
				unsigned int edge_sink_node;
				memset(&edge_sink_node, 0, sizeof(edge_sink_node));
				unsigned int edge_src_node;
				memset(&edge_src_node, 0, sizeof(edge_src_node));
				unsigned int edge_switch_id;
				memset(&edge_switch_id, 0, sizeof(edge_switch_id));
				load_edge_required_attributes(node, &edge_sink_node, &edge_src_node, &edge_switch_id, report_error);
				auto child_context = out.add_rr_edges_edge(context, edge_sink_node, edge_src_node, edge_switch_id);
				load_edge(node, out, child_context, report_error, offset_debug);
				out.finish_rr_edges_edge(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	if(state != 0) dfa_error("end of input", gstate_t_rr_edges[state], gtok_lookup_t_rr_edges, 1, report_error);

}

template<class T, typename Context>
inline void load_rr_graph(const pugi::xml_node &root, T &out, Context &context, const std::function<void(const char*)> *report_error, ptrdiff_t *offset_debug){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	// Update current file offset in case an error is encountered.
	*offset_debug = root.offset_debug();

	for(pugi::xml_attribute attr = root.first_attribute(); attr; attr = attr.next_attribute()){
		atok_t_rr_graph in = lex_attr_t_rr_graph(attr.name(), report_error);
		switch(in){
		case atok_t_rr_graph::TOOL_COMMENT:
			out.set_rr_graph_tool_comment(attr.value(), context);
			break;
		case atok_t_rr_graph::TOOL_NAME:
			out.set_rr_graph_tool_name(attr.value(), context);
			break;
		case atok_t_rr_graph::TOOL_VERSION:
			out.set_rr_graph_tool_version(attr.value(), context);
			break;
		default: break; /* Not possible. */
		}
	}

	std::bitset<7> gstate = 0;
	for(pugi::xml_node node = root.first_child(); node; node = node.next_sibling()){
		*offset_debug = node.offset_debug();
		gtok_t_rr_graph in = lex_node_t_rr_graph(node.name(), report_error);
		if(gstate[(int)in] == 0) gstate[(int)in] = 1;
		else noreturn_report(report_error, ("Duplicate element " + std::string(node.name()) + " in <rr_graph>.").c_str());
		switch(in){
		case gtok_t_rr_graph::CHANNELS:
			{
				auto child_context = out.init_rr_graph_channels(context);
				load_channels(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_channels(child_context);
			}
			break;
		case gtok_t_rr_graph::SWITCHES:
			{
				auto child_context = out.init_rr_graph_switches(context);
				load_switches(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_switches(child_context);
			}
			break;
		case gtok_t_rr_graph::SEGMENTS:
			{
				auto child_context = out.init_rr_graph_segments(context);
				load_segments(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_segments(child_context);
			}
			break;
		case gtok_t_rr_graph::BLOCK_TYPES:
			{
				auto child_context = out.init_rr_graph_block_types(context);
				load_block_types(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_block_types(child_context);
			}
			break;
		case gtok_t_rr_graph::GRID:
			{
				auto child_context = out.init_rr_graph_grid(context);
				load_grid_locs(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_grid(child_context);
			}
			break;
		case gtok_t_rr_graph::RR_NODES:
			{
				auto child_context = out.init_rr_graph_rr_nodes(context);
				load_rr_nodes(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_rr_nodes(child_context);
			}
			break;
		case gtok_t_rr_graph::RR_EDGES:
			{
				auto child_context = out.init_rr_graph_rr_edges(context);
				load_rr_edges(node, out, child_context, report_error, offset_debug);
				out.finish_rr_graph_rr_edges(child_context);
			}
			break;
		default: break; /* Not possible. */
		}
	}
	std::bitset<7> test_gstate = gstate | std::bitset<7>(0b0000000);
	if(!test_gstate.all()) all_error(test_gstate, gtok_lookup_t_rr_graph, report_error);

}


/* Internal writing functions, which uxsdcxx uses to write out a class. */
template<class T, typename Context>
inline void write_channels(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		auto child_context = in.get_channels_channel(context);
		os << "<channel";
		os << " chan_width_max=\"" << in.get_channel_chan_width_max(child_context) << "\"";
		os << " x_max=\"" << in.get_channel_x_max(child_context) << "\"";
		os << " x_min=\"" << in.get_channel_x_min(child_context) << "\"";
		os << " y_max=\"" << in.get_channel_y_max(child_context) << "\"";
		os << " y_min=\"" << in.get_channel_y_min(child_context) << "\"";
		os << "/>\n";
	}
	{
		for(size_t i=0, n=in.num_channels_x_list(context); i<n; i++){
			auto child_context = in.get_channels_x_list(i, context);
			os << "<x_list";
			os << " index=\"" << in.get_x_list_index(child_context) << "\"";
			os << " info=\"" << in.get_x_list_info(child_context) << "\"";
			os << "/>\n";
		}
	}
	{
		for(size_t i=0, n=in.num_channels_y_list(context); i<n; i++){
			auto child_context = in.get_channels_y_list(i, context);
			os << "<y_list";
			os << " index=\"" << in.get_y_list_index(child_context) << "\"";
			os << " info=\"" << in.get_y_list_info(child_context) << "\"";
			os << "/>\n";
		}
	}
}

template<class T, typename Context>
inline void write_switch(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		if(in.has_switch_timing(context)){
			auto child_context = in.get_switch_timing(context);
			os << "<timing";
			if((bool)in.get_timing_Cin(child_context))
				os << " Cin=\"" << in.get_timing_Cin(child_context) << "\"";
			if((bool)in.get_timing_Cinternal(child_context))
				os << " Cinternal=\"" << in.get_timing_Cinternal(child_context) << "\"";
			if((bool)in.get_timing_Cout(child_context))
				os << " Cout=\"" << in.get_timing_Cout(child_context) << "\"";
			if((bool)in.get_timing_R(child_context))
				os << " R=\"" << in.get_timing_R(child_context) << "\"";
			if((bool)in.get_timing_Tdel(child_context))
				os << " Tdel=\"" << in.get_timing_Tdel(child_context) << "\"";
			os << "/>\n";
		}
	}
	{
		auto child_context = in.get_switch_sizing(context);
		os << "<sizing";
		os << " buf_size=\"" << in.get_sizing_buf_size(child_context) << "\"";
		os << " mux_trans_size=\"" << in.get_sizing_mux_trans_size(child_context) << "\"";
		os << "/>\n";
	}
}

template<class T, typename Context>
inline void write_switches(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_switches_switch(context); i<n; i++){
			auto child_context = in.get_switches_switch(i, context);
			os << "<switch";
			os << " id=\"" << in.get_switch_id(child_context) << "\"";
			os << " name=\"" << in.get_switch_name(child_context) << "\"";
			if((bool)in.get_switch_type(child_context))
				os << " type=\"" << lookup_switch_type[(int)in.get_switch_type(child_context)] << "\"";
			os << ">";
			write_switch(in, os, child_context);
			os << "</switch>\n";
		}
	}
}

template<class T, typename Context>
inline void write_segment(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		if(in.has_segment_timing(context)){
			auto child_context = in.get_segment_timing(context);
			os << "<timing";
			if((bool)in.get_segment_timing_C_per_meter(child_context))
				os << " C_per_meter=\"" << in.get_segment_timing_C_per_meter(child_context) << "\"";
			if((bool)in.get_segment_timing_R_per_meter(child_context))
				os << " R_per_meter=\"" << in.get_segment_timing_R_per_meter(child_context) << "\"";
			os << "/>\n";
		}
	}
}

template<class T, typename Context>
inline void write_segments(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_segments_segment(context); i<n; i++){
			auto child_context = in.get_segments_segment(i, context);
			os << "<segment";
			os << " id=\"" << in.get_segment_id(child_context) << "\"";
			if((bool)in.get_segment_length(child_context))
				os << " length=\"" << in.get_segment_length(child_context) << "\"";
			os << " name=\"" << in.get_segment_name(child_context) << "\"";
			if((bool)in.get_segment_res_type(child_context))
				os << " res_type=\"" << lookup_segment_res_type[(int)in.get_segment_res_type(child_context)] << "\"";
			os << ">";
			write_segment(in, os, child_context);
			os << "</segment>\n";
		}
	}
}

template<class T, typename Context>
inline void write_pin(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	os << in.get_pin_value(context);
}

template<class T, typename Context>
inline void write_pin_class(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_pin_class_pin(context); i<n; i++){
			auto child_context = in.get_pin_class_pin(i, context);
			os << "<pin";
			os << " ptc=\"" << in.get_pin_ptc(child_context) << "\"";
			os << ">";
			write_pin(in, os, child_context);
			os << "</pin>\n";
		}
	}
}

template<class T, typename Context>
inline void write_block_type(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_block_type_pin_class(context); i<n; i++){
			auto child_context = in.get_block_type_pin_class(i, context);
			os << "<pin_class";
			os << " type=\"" << lookup_pin_type[(int)in.get_pin_class_type(child_context)] << "\"";
			os << ">";
			write_pin_class(in, os, child_context);
			os << "</pin_class>\n";
		}
	}
}

template<class T, typename Context>
inline void write_block_types(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_block_types_block_type(context); i<n; i++){
			auto child_context = in.get_block_types_block_type(i, context);
			os << "<block_type";
			os << " height=\"" << in.get_block_type_height(child_context) << "\"";
			os << " id=\"" << in.get_block_type_id(child_context) << "\"";
			os << " name=\"" << in.get_block_type_name(child_context) << "\"";
			os << " width=\"" << in.get_block_type_width(child_context) << "\"";
			os << ">";
			write_block_type(in, os, child_context);
			os << "</block_type>\n";
		}
	}
}

template<class T, typename Context>
inline void write_grid_locs(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_grid_locs_grid_loc(context); i<n; i++){
			auto child_context = in.get_grid_locs_grid_loc(i, context);
			os << "<grid_loc";
			os << " block_type_id=\"" << in.get_grid_loc_block_type_id(child_context) << "\"";
			os << " height_offset=\"" << in.get_grid_loc_height_offset(child_context) << "\"";
			os << " layer=\"" << in.get_grid_loc_layer(child_context) << "\"";
			os << " width_offset=\"" << in.get_grid_loc_width_offset(child_context) << "\"";
			os << " x=\"" << in.get_grid_loc_x(child_context) << "\"";
			os << " y=\"" << in.get_grid_loc_y(child_context) << "\"";
			os << "/>\n";
		}
	}
}

template<class T, typename Context>
inline void write_meta(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	os << in.get_meta_value(context);
}

template<class T, typename Context>
inline void write_metadata(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_metadata_meta(context); i<n; i++){
			auto child_context = in.get_metadata_meta(i, context);
			os << "<meta";
			os << " name=\"" << in.get_meta_name(child_context) << "\"";
			os << ">";
			write_meta(in, os, child_context);
			os << "</meta>\n";
		}
	}
}

template<class T, typename Context>
inline void write_node(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		auto child_context = in.get_node_loc(context);
		os << "<loc";
		os << " layer=\"" << in.get_node_loc_layer(child_context) << "\"";
		os << " ptc=\"" << in.get_node_loc_ptc(child_context) << "\"";
		if((bool)in.get_node_loc_side(child_context))
			os << " side=\"" << lookup_loc_side[(int)in.get_node_loc_side(child_context)] << "\"";
		if((bool)in.get_node_loc_twist(child_context))
			os << " twist=\"" << in.get_node_loc_twist(child_context) << "\"";
		os << " xhigh=\"" << in.get_node_loc_xhigh(child_context) << "\"";
		os << " xlow=\"" << in.get_node_loc_xlow(child_context) << "\"";
		os << " yhigh=\"" << in.get_node_loc_yhigh(child_context) << "\"";
		os << " ylow=\"" << in.get_node_loc_ylow(child_context) << "\"";
		os << "/>\n";
	}
	{
		if(in.has_node_timing(context)){
			auto child_context = in.get_node_timing(context);
			os << "<timing";
			os << " C=\"" << in.get_node_timing_C(child_context) << "\"";
			os << " R=\"" << in.get_node_timing_R(child_context) << "\"";
			os << "/>\n";
		}
	}
	{
		if(in.has_node_segment(context)){
			auto child_context = in.get_node_segment(context);
			os << "<segment";
			os << " segment_id=\"" << in.get_node_segment_segment_id(child_context) << "\"";
			os << "/>\n";
		}
	}
	{
		if(in.has_node_metadata(context)){
			auto child_context = in.get_node_metadata(context);
			os << "<metadata>\n";
			write_metadata(in, os, child_context);
			os << "</metadata>\n";
		}
	}
}

template<class T, typename Context>
inline void write_rr_nodes(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_rr_nodes_node(context); i<n; i++){
			auto child_context = in.get_rr_nodes_node(i, context);
			os << "<node";
			os << " capacity=\"" << in.get_node_capacity(child_context) << "\"";
			if((bool)in.get_node_clk_res_type(child_context))
				os << " clk_res_type=\"" << lookup_node_clk_res_type[(int)in.get_node_clk_res_type(child_context)] << "\"";
			if((bool)in.get_node_direction(child_context))
				os << " direction=\"" << lookup_node_direction[(int)in.get_node_direction(child_context)] << "\"";
			os << " id=\"" << in.get_node_id(child_context) << "\"";
			if((bool)in.get_node_name(child_context))
				os << " name=\"" << in.get_node_name(child_context) << "\"";
			os << " type=\"" << lookup_node_type[(int)in.get_node_type(child_context)] << "\"";
			os << ">";
			write_node(in, os, child_context);
			os << "</node>\n";
		}
	}
}

template<class T, typename Context>
inline void write_edge(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		if(in.has_edge_metadata(context)){
			auto child_context = in.get_edge_metadata(context);
			os << "<metadata>\n";
			write_metadata(in, os, child_context);
			os << "</metadata>\n";
		}
	}
}

template<class T, typename Context>
inline void write_rr_edges(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		for(size_t i=0, n=in.num_rr_edges_edge(context); i<n; i++){
			auto child_context = in.get_rr_edges_edge(i, context);
			os << "<edge";
			os << " sink_node=\"" << in.get_edge_sink_node(child_context) << "\"";
			os << " src_node=\"" << in.get_edge_src_node(child_context) << "\"";
			os << " switch_id=\"" << in.get_edge_switch_id(child_context) << "\"";
			os << ">";
			write_edge(in, os, child_context);
			os << "</edge>\n";
		}
	}
}

template<class T, typename Context>
inline void write_rr_graph(T &in, std::ostream &os, Context &context){
	(void)in;
	(void)os;
	(void)context;
	{
		auto child_context = in.get_rr_graph_channels(context);
		os << "<channels>\n";
		write_channels(in, os, child_context);
		os << "</channels>\n";
	}
	{
		auto child_context = in.get_rr_graph_switches(context);
		os << "<switches>\n";
		write_switches(in, os, child_context);
		os << "</switches>\n";
	}
	{
		auto child_context = in.get_rr_graph_segments(context);
		os << "<segments>\n";
		write_segments(in, os, child_context);
		os << "</segments>\n";
	}
	{
		auto child_context = in.get_rr_graph_block_types(context);
		os << "<block_types>\n";
		write_block_types(in, os, child_context);
		os << "</block_types>\n";
	}
	{
		auto child_context = in.get_rr_graph_grid(context);
		os << "<grid>\n";
		write_grid_locs(in, os, child_context);
		os << "</grid>\n";
	}
	{
		auto child_context = in.get_rr_graph_rr_nodes(context);
		os << "<rr_nodes>\n";
		write_rr_nodes(in, os, child_context);
		os << "</rr_nodes>\n";
	}
	{
		auto child_context = in.get_rr_graph_rr_edges(context);
		os << "<rr_edges>\n";
		write_rr_edges(in, os, child_context);
		os << "</rr_edges>\n";
	}
}

inline void dfa_error(const char *wrong, const int *states, const char * const *lookup, int len, const std::function<void(const char *)> * report_error){
	std::vector<std::string> expected;
	for(int i=0; i<len; i++){
		if(states[i] != -1) expected.push_back(lookup[i]);
	}

	std::string expected_or = expected[0];
	for(unsigned int i=1; i<expected.size(); i++)
		expected_or += std::string(" or ") + expected[i];

	noreturn_report(report_error, ("Expected " + expected_or + ", found " + std::string(wrong)).c_str());
}

template<std::size_t N>
inline void all_error(std::bitset<N> gstate, const char * const *lookup, const std::function<void(const char *)> * report_error){
	std::vector<std::string> missing;
	for(unsigned int i=0; i<N; i++){
		if(gstate[i] == 0) missing.push_back(lookup[i]);
	}

	std::string missing_and = missing[0];
	for(unsigned int i=1; i<missing.size(); i++)
		missing_and += std::string(", ") + missing[i];

	noreturn_report(report_error, ("Didn't find required elements " + missing_and + ".").c_str());
}

template<std::size_t N>
inline void attr_error(std::bitset<N> astate, const char * const *lookup, const std::function<void(const char *)> * report_error){
	std::vector<std::string> missing;
	for(unsigned int i=0; i<N; i++){
		if(astate[i] == 0) missing.push_back(lookup[i]);
	}

	std::string missing_and = missing[0];
	for(unsigned int i=1; i<missing.size(); i++)
		missing_and += std::string(", ") + missing[i];

	noreturn_report(report_error, ("Didn't find required attributes " + missing_and + ".").c_str());
}

inline void get_line_number(const char *filename, std::ptrdiff_t target_offset, int * line, int * col) {
	std::unique_ptr<FILE,decltype(&fclose)> f(fopen(filename, "rb"), fclose);

	if (!f) {
		throw std::runtime_error(std::string("Failed to open file") + filename);
	}

	int current_line = 1;
	std::ptrdiff_t offset = 0;
	std::ptrdiff_t last_line_offset = 0;
	std::ptrdiff_t current_line_offset = 0;

	char buffer[1024];
	std::size_t size;

	while ((size = fread(buffer, 1, sizeof(buffer), f.get())) > 0) {
		for (std::size_t i = 0; i < size; ++i) {
			if (buffer[i] == '\n') {
				current_line += 1;
				last_line_offset = current_line_offset;
				current_line_offset = offset + i;

				if(target_offset < current_line_offset) {
					if(target_offset < last_line_offset) {
						throw std::runtime_error("Assertion violation");
					}

					*line = current_line - 1;
					*col = target_offset - last_line_offset;
					return;
				}
			}
		}

		offset += size;
	}

	*line = current_line;
	*col = target_offset - current_line_offset;
}


} /* namespace uxsd */
