/* calculator-plugin.c generated by valac 0.56.17, the Vala compiler
 * generated from calculator-plugin.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Magnus Kulke <mkulke@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_CALCULATOR_PLUGIN_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT (synapse_calculator_plugin_result_get_type ())
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CALCULATOR_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResultClass))

typedef struct _SynapseCalculatorPluginResult SynapseCalculatorPluginResult;
typedef struct _SynapseCalculatorPluginResultClass SynapseCalculatorPluginResultClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseCalculatorPluginSearchData SynapseCalculatorPluginSearchData;
typedef struct _SynapseCalculatorPluginResultPrivate SynapseCalculatorPluginResultPrivate;
enum  {
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_NUM_PROPERTIES];

struct _SynapseCalculatorPluginPrivate {
	gboolean _enabled;
	GRegex* regex;
};

struct _SynapseCalculatorPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCalculatorPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	gchar* input;
	SynapseQuery _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean matched;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	GRegex* _tmp17_;
	const gchar* _tmp18_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	gchar** argv;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint argv_length1;
	gint _argv_size_;
	gchar* solution;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GPid _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp26_;
	GDataInputStream* bc_output;
	GUnixInputStream* _tmp27_;
	GDataInputStream* _tmp28_;
	GUnixOutputStream* write_stream;
	GUnixOutputStream* _tmp29_;
	GDataOutputStream* bc_input;
	GUnixOutputStream* _tmp30_;
	GDataOutputStream* _tmp31_;
	GDataOutputStream* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	SynapseQuery _tmp36_;
	GCancellable* _tmp37_;
	GDataOutputStream* _tmp38_;
	SynapseQuery _tmp39_;
	GCancellable* _tmp40_;
	gchar* _tmp41_;
	GDataInputStream* _tmp42_;
	SynapseQuery _tmp43_;
	GCancellable* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gdouble d;
	const gchar* _tmp48_;
	SynapseCalculatorPluginResult* _result_;
	SynapseQuery _tmp49_;
	const gchar* _tmp50_;
	SynapseCalculatorPluginResult* _tmp51_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp52_;
	SynapseResultSet* _tmp53_;
	SynapseCalculatorPluginResult* _tmp54_;
	GError* err;
	GError* _tmp55_;
	const gchar* _tmp56_;
	GError* _inner_error0_;
};

struct _SynapseCalculatorPluginResult {
	SynapseTextMatch parent_instance;
	SynapseCalculatorPluginResultPrivate * priv;
};

struct _SynapseCalculatorPluginResultClass {
	SynapseTextMatchClass parent_class;
};

struct _SynapseCalculatorPluginResultPrivate {
	gint _default_relevancy;
};

static gint SynapseCalculatorPlugin_private_offset;
static gpointer synapse_calculator_plugin_parent_class = NULL;
static gint SynapseCalculatorPluginResult_private_offset;
static gpointer synapse_calculator_plugin_result_parent_class = NULL;
static SynapseActivatableIface * synapse_calculator_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_calculator_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_calculator_plugin_real_activate (SynapseActivatable* base);
static void synapse_calculator_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_calculator_plugin_register_plugin (void);
static void _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                                       SynapseQuery* query);
static void synapse_calculator_plugin_real_search_data_free (gpointer _data);
static void synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                            SynapseQuery* query,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_);
static void synapse_calculator_plugin_search_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static GType synapse_calculator_plugin_result_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_new (gdouble _result_,
                                                                     const gchar* match_string);
static SynapseCalculatorPluginResult* synapse_calculator_plugin_result_construct (GType object_type,
                                                                           gdouble _result_,
                                                                           const gchar* match_string);
static gchar* synapse_calculator_plugin_result_real_get_text (SynapseTextMatch* base);
static gint synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self);
static void synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                             gint value);
static void synapse_calculator_plugin_result_finalize (GObject * obj);
static GType synapse_calculator_plugin_result_get_type_once (void);
static void _vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static GObject * synapse_calculator_plugin_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void synapse_calculator_plugin_finalize (GObject * obj);
static GType synapse_calculator_plugin_get_type_once (void);
static void _vala_synapse_calculator_plugin_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_calculator_plugin_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_calculator_plugin_get_instance_private (SynapseCalculatorPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPlugin_private_offset);
}

static void
synapse_calculator_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
#line 28 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 255 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCalculatorPlugin * self;
#line 33 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 264 "calculator-plugin.c"
}

static void
_synapse_calculator_plugin_register_plugin_synapse_plugin_register_func (void)
{
#line 57 "calculator-plugin.vala"
	synapse_calculator_plugin_register_plugin ();
#line 272 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 57 "calculator-plugin.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 57 "calculator-plugin.vala"
	_tmp1_ = _tmp0_;
#line 57 "calculator-plugin.vala"
	_tmp2_ = g_find_program_in_path ("bc");
#line 57 "calculator-plugin.vala"
	_tmp3_ = _tmp2_;
#line 57 "calculator-plugin.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_CALCULATOR_PLUGIN, _ ("Calculator"), _ ("Calculate basic expressions."), "accessories-calculator", _synapse_calculator_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL, _ ("bc is not installed"));
#line 57 "calculator-plugin.vala"
	_g_free0 (_tmp3_);
#line 57 "calculator-plugin.vala"
	_g_object_unref0 (_tmp1_);
#line 296 "calculator-plugin.c"
}

static gboolean
synapse_calculator_plugin_real_handles_query (SynapseItemProvider* base,
                                              SynapseQuery* query)
{
	SynapseCalculatorPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
#line 91 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 91 "calculator-plugin.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 93 "calculator-plugin.vala"
	_tmp0_ = *query;
#line 93 "calculator-plugin.vala"
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
#line 93 "calculator-plugin.vala"
	return result;
#line 316 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_real_search_data_free (gpointer _data)
{
	SynapseCalculatorPluginSearchData* _data_;
	_data_ = _data;
#line 24 "calculator-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "calculator-plugin.vala"
	_g_object_unref0 (_data_->result);
#line 24 "calculator-plugin.vala"
	_g_object_unref0 (_data_->self);
#line 24 "calculator-plugin.vala"
	g_slice_free (SynapseCalculatorPluginSearchData, _data_);
#line 332 "calculator-plugin.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "calculator-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 340 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_real_search (SynapseItemProvider* base,
                                       SynapseQuery* query,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SynapseCalculatorPlugin * self;
	SynapseCalculatorPluginSearchData* _data_;
	SynapseCalculatorPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
#line 24 "calculator-plugin.vala"
	g_return_if_fail (query != NULL);
#line 24 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 24 "calculator-plugin.vala"
	_data_ = g_slice_new0 (SynapseCalculatorPluginSearchData);
#line 24 "calculator-plugin.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "calculator-plugin.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_calculator_plugin_real_search_data_free);
#line 24 "calculator-plugin.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "calculator-plugin.vala"
	_data_->self = _tmp0_;
#line 24 "calculator-plugin.vala"
	_tmp1_ = *query;
#line 24 "calculator-plugin.vala"
	_tmp2_ = _tmp1_;
#line 24 "calculator-plugin.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "calculator-plugin.vala"
	synapse_query_destroy (&_data_->query);
#line 24 "calculator-plugin.vala"
	_data_->query = _tmp3_;
#line 24 "calculator-plugin.vala"
	synapse_calculator_plugin_real_search_co (_data_);
#line 381 "calculator-plugin.c"
}

static SynapseResultSet*
synapse_calculator_plugin_search_finish (SynapseItemProvider* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	SynapseResultSet* result;
	SynapseCalculatorPluginSearchData* _data_;
#line 24 "calculator-plugin.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "calculator-plugin.vala"
	if (NULL == _data_) {
#line 24 "calculator-plugin.vala"
		return NULL;
#line 397 "calculator-plugin.c"
	}
#line 24 "calculator-plugin.vala"
	result = _data_->result;
#line 24 "calculator-plugin.vala"
	_data_->result = NULL;
#line 24 "calculator-plugin.vala"
	return result;
#line 405 "calculator-plugin.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 427 "calculator-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 431 "calculator-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 437 "calculator-plugin.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 441 "calculator-plugin.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 445 "calculator-plugin.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 453 "calculator-plugin.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 481 "calculator-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 490 "calculator-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 504 "calculator-plugin.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 513 "calculator-plugin.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 527 "calculator-plugin.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 536 "calculator-plugin.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 545 "calculator-plugin.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 572 "calculator-plugin.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 578 "calculator-plugin.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 584 "calculator-plugin.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 588 "calculator-plugin.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 596 "calculator-plugin.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 600 "calculator-plugin.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 612 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_search_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SynapseCalculatorPluginSearchData* _data_;
#line 124 "calculator-plugin.vala"
	_data_ = _user_data_;
#line 124 "calculator-plugin.vala"
	_data_->_source_object_ = source_object;
#line 124 "calculator-plugin.vala"
	_data_->_res_ = _res_;
#line 124 "calculator-plugin.vala"
	synapse_calculator_plugin_real_search_co (_data_);
#line 629 "calculator-plugin.c"
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
#line 1003 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 1004 "glib-2.0.vapi"
	result = g_ascii_strtod (str, NULL);
#line 1004 "glib-2.0.vapi"
	return result;
#line 642 "calculator-plugin.c"
}

static gboolean
synapse_calculator_plugin_real_search_co (SynapseCalculatorPluginSearchData* _data_)
{
#line 96 "calculator-plugin.vala"
	switch (_data_->_state_) {
#line 96 "calculator-plugin.vala"
		case 0:
#line 652 "calculator-plugin.c"
		goto _state_0;
#line 96 "calculator-plugin.vala"
		case 1:
#line 656 "calculator-plugin.c"
		goto _state_1;
#line 96 "calculator-plugin.vala"
		case 2:
#line 660 "calculator-plugin.c"
		goto _state_2;
		default:
#line 96 "calculator-plugin.vala"
		g_assert_not_reached ();
#line 665 "calculator-plugin.c"
	}
	_state_0:
#line 98 "calculator-plugin.vala"
	_data_->_tmp0_ = _data_->query;
#line 98 "calculator-plugin.vala"
	_data_->_tmp1_ = _data_->_tmp0_.query_string;
#line 98 "calculator-plugin.vala"
	_data_->_tmp2_ = string_replace (_data_->_tmp1_, " ", "");
#line 98 "calculator-plugin.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 98 "calculator-plugin.vala"
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, ",", ".");
#line 98 "calculator-plugin.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 98 "calculator-plugin.vala"
	_g_free0 (_data_->_tmp3_);
#line 98 "calculator-plugin.vala"
	_data_->input = _data_->_tmp5_;
#line 99 "calculator-plugin.vala"
	_data_->_tmp6_ = _data_->self->priv->regex;
#line 99 "calculator-plugin.vala"
	_data_->_tmp7_ = _data_->input;
#line 99 "calculator-plugin.vala"
	_data_->matched = g_regex_match (_data_->_tmp6_, _data_->_tmp7_, 0, NULL);
#line 100 "calculator-plugin.vala"
	if (!_data_->matched) {
#line 100 "calculator-plugin.vala"
		_data_->_tmp9_ = _data_->input;
#line 100 "calculator-plugin.vala"
		_data_->_tmp10_ = strlen (_data_->_tmp9_);
#line 100 "calculator-plugin.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 100 "calculator-plugin.vala"
		_data_->_tmp8_ = _data_->_tmp11_ > 1;
#line 700 "calculator-plugin.c"
	} else {
#line 100 "calculator-plugin.vala"
		_data_->_tmp8_ = FALSE;
#line 704 "calculator-plugin.c"
	}
#line 100 "calculator-plugin.vala"
	if (_data_->_tmp8_) {
#line 102 "calculator-plugin.vala"
		_data_->_tmp12_ = _data_->input;
#line 102 "calculator-plugin.vala"
		_data_->_tmp13_ = _data_->input;
#line 102 "calculator-plugin.vala"
		_data_->_tmp14_ = strlen (_data_->_tmp13_);
#line 102 "calculator-plugin.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 102 "calculator-plugin.vala"
		_data_->_tmp16_ = string_slice (_data_->_tmp12_, (glong) 0, (glong) (_data_->_tmp15_ - 1));
#line 102 "calculator-plugin.vala"
		_g_free0 (_data_->input);
#line 102 "calculator-plugin.vala"
		_data_->input = _data_->_tmp16_;
#line 103 "calculator-plugin.vala"
		_data_->_tmp17_ = _data_->self->priv->regex;
#line 103 "calculator-plugin.vala"
		_data_->_tmp18_ = _data_->input;
#line 103 "calculator-plugin.vala"
		_data_->matched = g_regex_match (_data_->_tmp17_, _data_->_tmp18_, 0, NULL);
#line 728 "calculator-plugin.c"
	}
#line 105 "calculator-plugin.vala"
	if (_data_->matched) {
#line 109 "calculator-plugin.vala"
		_data_->_tmp19_ = g_strdup ("bc");
#line 109 "calculator-plugin.vala"
		_data_->_tmp20_ = g_strdup ("-l");
#line 109 "calculator-plugin.vala"
		_data_->_tmp21_ = g_new0 (gchar*, 2 + 1);
#line 109 "calculator-plugin.vala"
		_data_->_tmp21_[0] = _data_->_tmp19_;
#line 109 "calculator-plugin.vala"
		_data_->_tmp21_[1] = _data_->_tmp20_;
#line 109 "calculator-plugin.vala"
		_data_->argv = _data_->_tmp21_;
#line 109 "calculator-plugin.vala"
		_data_->argv_length1 = 2;
#line 109 "calculator-plugin.vala"
		_data_->_argv_size_ = _data_->argv_length1;
#line 110 "calculator-plugin.vala"
		_data_->solution = NULL;
#line 750 "calculator-plugin.c"
		{
#line 114 "calculator-plugin.vala"
			_data_->_tmp22_ = _data_->argv;
#line 114 "calculator-plugin.vala"
			_data_->_tmp22__length1 = _data_->argv_length1;
#line 114 "calculator-plugin.vala"
			_data_->_tmp23_ = 0;
#line 114 "calculator-plugin.vala"
			_data_->_tmp24_ = 0;
#line 114 "calculator-plugin.vala"
			_data_->_tmp25_ = 0;
#line 114 "calculator-plugin.vala"
			g_spawn_async_with_pipes (NULL, _data_->_tmp22_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp23_, &_data_->_tmp24_, &_data_->_tmp25_, NULL, &_data_->_inner_error0_);
#line 114 "calculator-plugin.vala"
			_data_->pid = _data_->_tmp23_;
#line 114 "calculator-plugin.vala"
			_data_->write_fd = _data_->_tmp24_;
#line 114 "calculator-plugin.vala"
			_data_->read_fd = _data_->_tmp25_;
#line 114 "calculator-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 772 "calculator-plugin.c"
				goto __catch0_g_error;
			}
#line 117 "calculator-plugin.vala"
			_data_->_tmp26_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
#line 117 "calculator-plugin.vala"
			_data_->read_stream = _data_->_tmp26_;
#line 118 "calculator-plugin.vala"
			_data_->_tmp27_ = _data_->read_stream;
#line 118 "calculator-plugin.vala"
			_data_->_tmp28_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp27_);
#line 118 "calculator-plugin.vala"
			_data_->bc_output = _data_->_tmp28_;
#line 120 "calculator-plugin.vala"
			_data_->_tmp29_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->write_fd, TRUE);
#line 120 "calculator-plugin.vala"
			_data_->write_stream = _data_->_tmp29_;
#line 121 "calculator-plugin.vala"
			_data_->_tmp30_ = _data_->write_stream;
#line 121 "calculator-plugin.vala"
			_data_->_tmp31_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp30_);
#line 121 "calculator-plugin.vala"
			_data_->bc_input = _data_->_tmp31_;
#line 123 "calculator-plugin.vala"
			_data_->_tmp32_ = _data_->bc_input;
#line 123 "calculator-plugin.vala"
			_data_->_tmp33_ = _data_->input;
#line 123 "calculator-plugin.vala"
			_data_->_tmp34_ = g_strconcat (_data_->_tmp33_, "\n", NULL);
#line 123 "calculator-plugin.vala"
			_data_->_tmp35_ = _data_->_tmp34_;
#line 123 "calculator-plugin.vala"
			_data_->_tmp36_ = _data_->query;
#line 123 "calculator-plugin.vala"
			_data_->_tmp37_ = _data_->_tmp36_.cancellable;
#line 123 "calculator-plugin.vala"
			g_data_output_stream_put_string (_data_->_tmp32_, _data_->_tmp35_, _data_->_tmp37_, &_data_->_inner_error0_);
#line 123 "calculator-plugin.vala"
			_g_free0 (_data_->_tmp35_);
#line 123 "calculator-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 123 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_input);
#line 123 "calculator-plugin.vala"
				_g_object_unref0 (_data_->write_stream);
#line 123 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_output);
#line 123 "calculator-plugin.vala"
				_g_object_unref0 (_data_->read_stream);
#line 821 "calculator-plugin.c"
				goto __catch0_g_error;
			}
#line 124 "calculator-plugin.vala"
			_data_->_tmp38_ = _data_->bc_input;
#line 124 "calculator-plugin.vala"
			_data_->_tmp39_ = _data_->query;
#line 124 "calculator-plugin.vala"
			_data_->_tmp40_ = _data_->_tmp39_.cancellable;
#line 124 "calculator-plugin.vala"
			_data_->_state_ = 1;
#line 124 "calculator-plugin.vala"
			g_output_stream_close_async ((GOutputStream*) _data_->_tmp38_, G_PRIORITY_DEFAULT, _data_->_tmp40_, synapse_calculator_plugin_search_ready, _data_);
#line 124 "calculator-plugin.vala"
			return FALSE;
#line 836 "calculator-plugin.c"
			_state_1:
#line 124 "calculator-plugin.vala"
			g_output_stream_close_finish ((GOutputStream*) _data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
#line 124 "calculator-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 124 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_input);
#line 124 "calculator-plugin.vala"
				_g_object_unref0 (_data_->write_stream);
#line 124 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_output);
#line 124 "calculator-plugin.vala"
				_g_object_unref0 (_data_->read_stream);
#line 850 "calculator-plugin.c"
				goto __catch0_g_error;
			}
#line 125 "calculator-plugin.vala"
			_data_->_tmp42_ = _data_->bc_output;
#line 125 "calculator-plugin.vala"
			_data_->_tmp43_ = _data_->query;
#line 125 "calculator-plugin.vala"
			_data_->_tmp44_ = _data_->_tmp43_.cancellable;
#line 125 "calculator-plugin.vala"
			_data_->_state_ = 2;
#line 125 "calculator-plugin.vala"
			g_data_input_stream_read_line_async (_data_->_tmp42_, G_PRIORITY_DEFAULT_IDLE, _data_->_tmp44_, synapse_calculator_plugin_search_ready, _data_);
#line 125 "calculator-plugin.vala"
			return FALSE;
#line 865 "calculator-plugin.c"
			_state_2:
#line 125 "calculator-plugin.vala"
			_data_->_tmp45_ = g_data_input_stream_read_line_finish (_data_->_tmp42_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 125 "calculator-plugin.vala"
			_data_->_tmp41_ = _data_->_tmp45_;
#line 125 "calculator-plugin.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 125 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_input);
#line 125 "calculator-plugin.vala"
				_g_object_unref0 (_data_->write_stream);
#line 125 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_output);
#line 125 "calculator-plugin.vala"
				_g_object_unref0 (_data_->read_stream);
#line 881 "calculator-plugin.c"
				goto __catch0_g_error;
			}
#line 125 "calculator-plugin.vala"
			_data_->_tmp46_ = _data_->_tmp41_;
#line 125 "calculator-plugin.vala"
			_data_->_tmp41_ = NULL;
#line 125 "calculator-plugin.vala"
			_g_free0 (_data_->solution);
#line 125 "calculator-plugin.vala"
			_data_->solution = _data_->_tmp46_;
#line 127 "calculator-plugin.vala"
			_data_->_tmp47_ = _data_->solution;
#line 127 "calculator-plugin.vala"
			if (_data_->_tmp47_ != NULL) {
#line 129 "calculator-plugin.vala"
				_data_->_tmp48_ = _data_->solution;
#line 129 "calculator-plugin.vala"
				_data_->d = double_parse (_data_->_tmp48_);
#line 130 "calculator-plugin.vala"
				_data_->_tmp49_ = _data_->query;
#line 130 "calculator-plugin.vala"
				_data_->_tmp50_ = _data_->_tmp49_.query_string;
#line 130 "calculator-plugin.vala"
				_data_->_tmp51_ = synapse_calculator_plugin_result_new (_data_->d, _data_->_tmp50_);
#line 130 "calculator-plugin.vala"
				_data_->_result_ = _data_->_tmp51_;
#line 131 "calculator-plugin.vala"
				_data_->_tmp52_ = synapse_result_set_new ();
#line 131 "calculator-plugin.vala"
				_data_->results = _data_->_tmp52_;
#line 132 "calculator-plugin.vala"
				_data_->_tmp53_ = _data_->results;
#line 132 "calculator-plugin.vala"
				_data_->_tmp54_ = _data_->_result_;
#line 132 "calculator-plugin.vala"
				synapse_result_set_add (_data_->_tmp53_, (SynapseMatch*) _data_->_tmp54_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
#line 133 "calculator-plugin.vala"
				synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 133 "calculator-plugin.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->results);
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->_result_);
#line 133 "calculator-plugin.vala"
					_g_free0 (_data_->_tmp41_);
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->bc_input);
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->write_stream);
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->bc_output);
#line 133 "calculator-plugin.vala"
					_g_object_unref0 (_data_->read_stream);
#line 936 "calculator-plugin.c"
					goto __catch0_g_error;
				}
#line 134 "calculator-plugin.vala"
				_data_->result = _data_->results;
#line 134 "calculator-plugin.vala"
				_g_object_unref0 (_data_->_result_);
#line 134 "calculator-plugin.vala"
				_g_free0 (_data_->_tmp41_);
#line 134 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_input);
#line 134 "calculator-plugin.vala"
				_g_object_unref0 (_data_->write_stream);
#line 134 "calculator-plugin.vala"
				_g_object_unref0 (_data_->bc_output);
#line 134 "calculator-plugin.vala"
				_g_object_unref0 (_data_->read_stream);
#line 134 "calculator-plugin.vala"
				_g_free0 (_data_->solution);
#line 134 "calculator-plugin.vala"
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 134 "calculator-plugin.vala"
				_g_free0 (_data_->input);
#line 134 "calculator-plugin.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 134 "calculator-plugin.vala"
				if (_data_->_state_ != 0) {
#line 134 "calculator-plugin.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 134 "calculator-plugin.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 967 "calculator-plugin.c"
					}
				}
#line 134 "calculator-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 134 "calculator-plugin.vala"
				return FALSE;
#line 974 "calculator-plugin.c"
			}
#line 112 "calculator-plugin.vala"
			_g_free0 (_data_->_tmp41_);
#line 112 "calculator-plugin.vala"
			_g_object_unref0 (_data_->bc_input);
#line 112 "calculator-plugin.vala"
			_g_object_unref0 (_data_->write_stream);
#line 112 "calculator-plugin.vala"
			_g_object_unref0 (_data_->bc_output);
#line 112 "calculator-plugin.vala"
			_g_object_unref0 (_data_->read_stream);
#line 986 "calculator-plugin.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
#line 112 "calculator-plugin.vala"
			_data_->err = _data_->_inner_error0_;
#line 112 "calculator-plugin.vala"
			_data_->_inner_error0_ = NULL;
#line 139 "calculator-plugin.vala"
			if (!synapse_query_is_cancelled (&_data_->query)) {
#line 139 "calculator-plugin.vala"
				_data_->_tmp55_ = _data_->err;
#line 139 "calculator-plugin.vala"
				_data_->_tmp56_ = _data_->_tmp55_->message;
#line 139 "calculator-plugin.vala"
				g_warning ("calculator-plugin.vala:139: %s", _data_->_tmp56_);
#line 1003 "calculator-plugin.c"
			}
#line 112 "calculator-plugin.vala"
			_g_error_free0 (_data_->err);
#line 1007 "calculator-plugin.c"
		}
		__finally0:
#line 112 "calculator-plugin.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 112 "calculator-plugin.vala"
			if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 112 "calculator-plugin.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 112 "calculator-plugin.vala"
				_g_free0 (_data_->solution);
#line 112 "calculator-plugin.vala"
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 112 "calculator-plugin.vala"
				_g_free0 (_data_->input);
#line 112 "calculator-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 112 "calculator-plugin.vala"
				return FALSE;
#line 1026 "calculator-plugin.c"
			} else {
#line 112 "calculator-plugin.vala"
				_g_free0 (_data_->solution);
#line 112 "calculator-plugin.vala"
				_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 112 "calculator-plugin.vala"
				_g_free0 (_data_->input);
#line 112 "calculator-plugin.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 112 "calculator-plugin.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 112 "calculator-plugin.vala"
				g_object_unref (_data_->_async_result);
#line 112 "calculator-plugin.vala"
				return FALSE;
#line 1042 "calculator-plugin.c"
			}
		}
#line 105 "calculator-plugin.vala"
		_g_free0 (_data_->solution);
#line 105 "calculator-plugin.vala"
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
#line 1049 "calculator-plugin.c"
	}
#line 143 "calculator-plugin.vala"
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
#line 143 "calculator-plugin.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 143 "calculator-plugin.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 143 "calculator-plugin.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 143 "calculator-plugin.vala"
			_g_free0 (_data_->input);
#line 143 "calculator-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 143 "calculator-plugin.vala"
			return FALSE;
#line 1065 "calculator-plugin.c"
		} else {
#line 143 "calculator-plugin.vala"
			_g_free0 (_data_->input);
#line 143 "calculator-plugin.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 143 "calculator-plugin.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 143 "calculator-plugin.vala"
			g_object_unref (_data_->_async_result);
#line 143 "calculator-plugin.vala"
			return FALSE;
#line 1077 "calculator-plugin.c"
		}
	}
#line 144 "calculator-plugin.vala"
	_data_->result = NULL;
#line 144 "calculator-plugin.vala"
	_g_free0 (_data_->input);
#line 144 "calculator-plugin.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 144 "calculator-plugin.vala"
	if (_data_->_state_ != 0) {
#line 144 "calculator-plugin.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 144 "calculator-plugin.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1092 "calculator-plugin.c"
		}
	}
#line 144 "calculator-plugin.vala"
	g_object_unref (_data_->_async_result);
#line 144 "calculator-plugin.vala"
	return FALSE;
#line 1099 "calculator-plugin.c"
}

SynapseCalculatorPlugin*
synapse_calculator_plugin_construct (GType object_type)
{
	SynapseCalculatorPlugin * self = NULL;
#line 24 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) g_object_new (object_type, NULL);
#line 24 "calculator-plugin.vala"
	return self;
#line 1110 "calculator-plugin.c"
}

SynapseCalculatorPlugin*
synapse_calculator_plugin_new (void)
{
#line 24 "calculator-plugin.vala"
	return synapse_calculator_plugin_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN);
#line 1118 "calculator-plugin.c"
}

static gboolean
synapse_calculator_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCalculatorPlugin* self;
#line 26 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 26 "calculator-plugin.vala"
	result = self->priv->_enabled;
#line 26 "calculator-plugin.vala"
	return result;
#line 1132 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_real_set_enabled (SynapseActivatable* base,
                                            gboolean value)
{
	SynapseCalculatorPlugin* self;
	gboolean old_value;
#line 26 "calculator-plugin.vala"
	self = (SynapseCalculatorPlugin*) base;
#line 26 "calculator-plugin.vala"
	old_value = synapse_calculator_plugin_real_get_enabled (base);
#line 26 "calculator-plugin.vala"
	if (old_value != value) {
#line 26 "calculator-plugin.vala"
		self->priv->_enabled = value;
#line 26 "calculator-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY]);
#line 1151 "calculator-plugin.c"
	}
}

static inline gpointer
synapse_calculator_plugin_result_get_instance_private (SynapseCalculatorPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPluginResult_private_offset);
}

static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_construct (GType object_type,
                                            gdouble _result_,
                                            const gchar* match_string)
{
	SynapseCalculatorPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 42 "calculator-plugin.vala"
	g_return_val_if_fail (match_string != NULL, NULL);
#line 44 "calculator-plugin.vala"
	_tmp0_ = g_strdup_printf ("%g", _result_);
#line 44 "calculator-plugin.vala"
	_tmp1_ = _tmp0_;
#line 44 "calculator-plugin.vala"
	_tmp2_ = g_strdup_printf ("%s = %g", match_string, _result_);
#line 44 "calculator-plugin.vala"
	_tmp3_ = _tmp2_;
#line 44 "calculator-plugin.vala"
	self = (SynapseCalculatorPluginResult*) g_object_new (object_type, "title", _tmp1_, "description", _tmp3_, "has-thumbnail", FALSE, "icon-name", "accessories-calculator", NULL);
#line 44 "calculator-plugin.vala"
	_g_free0 (_tmp3_);
#line 44 "calculator-plugin.vala"
	_g_free0 (_tmp1_);
#line 42 "calculator-plugin.vala"
	return self;
#line 1189 "calculator-plugin.c"
}

static SynapseCalculatorPluginResult*
synapse_calculator_plugin_result_new (gdouble _result_,
                                      const gchar* match_string)
{
#line 42 "calculator-plugin.vala"
	return synapse_calculator_plugin_result_construct (SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, _result_, match_string);
#line 1198 "calculator-plugin.c"
}

static gchar*
synapse_calculator_plugin_result_real_get_text (SynapseTextMatch* base)
{
	SynapseCalculatorPluginResult * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 49 "calculator-plugin.vala"
	self = (SynapseCalculatorPluginResult*) base;
#line 51 "calculator-plugin.vala"
	_tmp0_ = synapse_match_get_title ((SynapseMatch*) self);
#line 51 "calculator-plugin.vala"
	_tmp1_ = _tmp0_;
#line 51 "calculator-plugin.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 51 "calculator-plugin.vala"
	result = _tmp2_;
#line 51 "calculator-plugin.vala"
	return result;
#line 1221 "calculator-plugin.c"
}

static gint
synapse_calculator_plugin_result_get_default_relevancy (SynapseCalculatorPluginResult* self)
{
	gint result;
#line 40 "calculator-plugin.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "calculator-plugin.vala"
	result = self->priv->_default_relevancy;
#line 40 "calculator-plugin.vala"
	return result;
#line 1234 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_result_set_default_relevancy (SynapseCalculatorPluginResult* self,
                                                        gint value)
{
	gint old_value;
#line 40 "calculator-plugin.vala"
	g_return_if_fail (self != NULL);
#line 40 "calculator-plugin.vala"
	old_value = synapse_calculator_plugin_result_get_default_relevancy (self);
#line 40 "calculator-plugin.vala"
	if (old_value != value) {
#line 40 "calculator-plugin.vala"
		self->priv->_default_relevancy = value;
#line 40 "calculator-plugin.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
#line 1252 "calculator-plugin.c"
	}
}

static void
synapse_calculator_plugin_result_class_init (SynapseCalculatorPluginResultClass * klass,
                                             gpointer klass_data)
{
#line 38 "calculator-plugin.vala"
	synapse_calculator_plugin_result_parent_class = g_type_class_peek_parent (klass);
#line 38 "calculator-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPluginResult_private_offset);
#line 38 "calculator-plugin.vala"
	((SynapseTextMatchClass *) klass)->get_text = (gchar* (*) (SynapseTextMatch*)) synapse_calculator_plugin_result_real_get_text;
#line 38 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_result_get_property;
#line 38 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_result_set_property;
#line 38 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_result_finalize;
#line 38 "calculator-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_calculator_plugin_result_properties[SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1274 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_result_instance_init (SynapseCalculatorPluginResult * self,
                                                gpointer klass)
{
#line 38 "calculator-plugin.vala"
	self->priv = synapse_calculator_plugin_result_get_instance_private (self);
#line 40 "calculator-plugin.vala"
	self->priv->_default_relevancy = 0;
#line 1285 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_result_finalize (GObject * obj)
{
	SynapseCalculatorPluginResult * self;
#line 38 "calculator-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
#line 38 "calculator-plugin.vala"
	G_OBJECT_CLASS (synapse_calculator_plugin_result_parent_class)->finalize (obj);
#line 1296 "calculator-plugin.c"
}

static GType
synapse_calculator_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginResult), 0, (GInstanceInitFunc) synapse_calculator_plugin_result_instance_init, NULL };
	GType synapse_calculator_plugin_result_type_id;
	synapse_calculator_plugin_result_type_id = g_type_register_static (SYNAPSE_TYPE_TEXT_MATCH, "SynapseCalculatorPluginResult", &g_define_type_info, 0);
	SynapseCalculatorPluginResult_private_offset = g_type_add_instance_private (synapse_calculator_plugin_result_type_id, sizeof (SynapseCalculatorPluginResultPrivate));
	return synapse_calculator_plugin_result_type_id;
}

static GType
synapse_calculator_plugin_result_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_result_type_id__once = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_result_type_id__once)) {
		GType synapse_calculator_plugin_result_type_id;
		synapse_calculator_plugin_result_type_id = synapse_calculator_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_calculator_plugin_result_type_id__once, synapse_calculator_plugin_result_type_id);
	}
	return synapse_calculator_plugin_result_type_id__once;
}

static void
_vala_synapse_calculator_plugin_result_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
#line 38 "calculator-plugin.vala"
	switch (property_id) {
#line 38 "calculator-plugin.vala"
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "calculator-plugin.vala"
		g_value_set_int (value, synapse_calculator_plugin_result_get_default_relevancy (self));
#line 38 "calculator-plugin.vala"
		break;
#line 1337 "calculator-plugin.c"
		default:
#line 38 "calculator-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "calculator-plugin.vala"
		break;
#line 1343 "calculator-plugin.c"
	}
}

static void
_vala_synapse_calculator_plugin_result_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	SynapseCalculatorPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CALCULATOR_PLUGIN_TYPE_RESULT, SynapseCalculatorPluginResult);
#line 38 "calculator-plugin.vala"
	switch (property_id) {
#line 38 "calculator-plugin.vala"
		case SYNAPSE_CALCULATOR_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "calculator-plugin.vala"
		synapse_calculator_plugin_result_set_default_relevancy (self, g_value_get_int (value));
#line 38 "calculator-plugin.vala"
		break;
#line 1363 "calculator-plugin.c"
		default:
#line 38 "calculator-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "calculator-plugin.vala"
		break;
#line 1369 "calculator-plugin.c"
	}
}

static GObject *
synapse_calculator_plugin_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCalculatorPlugin * self;
	GError* _inner_error0_ = NULL;
#line 75 "calculator-plugin.vala"
	parent_class = G_OBJECT_CLASS (synapse_calculator_plugin_parent_class);
#line 75 "calculator-plugin.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 75 "calculator-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
#line 1388 "calculator-plugin.c"
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
#line 84 "calculator-plugin.vala"
		_tmp1_ = g_regex_new ("^\\(*(-?\\d+([.,]\\d+)?)([*/+-^]\\(*(-?\\d+([.,]\\d+)?)\\)*)+$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 84 "calculator-plugin.vala"
		_tmp0_ = _tmp1_;
#line 84 "calculator-plugin.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1399 "calculator-plugin.c"
			goto __catch0_g_error;
		}
#line 84 "calculator-plugin.vala"
		_tmp2_ = _tmp0_;
#line 84 "calculator-plugin.vala"
		_tmp0_ = NULL;
#line 84 "calculator-plugin.vala"
		_g_regex_unref0 (self->priv->regex);
#line 84 "calculator-plugin.vala"
		self->priv->regex = _tmp2_;
#line 82 "calculator-plugin.vala"
		_g_regex_unref0 (_tmp0_);
#line 1412 "calculator-plugin.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 82 "calculator-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 87 "calculator-plugin.vala"
		g_critical ("calculator-plugin.vala:87: Error creating regexp.");
#line 1421 "calculator-plugin.c"
	}
	__finally0:
#line 82 "calculator-plugin.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 82 "calculator-plugin.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 82 "calculator-plugin.vala"
		g_clear_error (&_inner_error0_);
#line 1430 "calculator-plugin.c"
	}
#line 75 "calculator-plugin.vala"
	return obj;
#line 1434 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_class_init (SynapseCalculatorPluginClass * klass,
                                      gpointer klass_data)
{
#line 24 "calculator-plugin.vala"
	synapse_calculator_plugin_parent_class = g_type_class_peek_parent (klass);
#line 24 "calculator-plugin.vala"
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPlugin_private_offset);
#line 24 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_calculator_plugin_get_property;
#line 24 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_calculator_plugin_set_property;
#line 24 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_calculator_plugin_constructor;
#line 24 "calculator-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_finalize;
#line 24 "calculator-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY, synapse_calculator_plugin_properties[SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 70 "calculator-plugin.vala"
	synapse_calculator_plugin_register_plugin ();
#line 1457 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                              gpointer iface_data)
{
#line 24 "calculator-plugin.vala"
	synapse_calculator_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "calculator-plugin.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_activate;
#line 24 "calculator-plugin.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_calculator_plugin_real_deactivate;
#line 24 "calculator-plugin.vala"
	iface->get_enabled = synapse_calculator_plugin_real_get_enabled;
#line 24 "calculator-plugin.vala"
	iface->set_enabled = synapse_calculator_plugin_real_set_enabled;
#line 1474 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                                gpointer iface_data)
{
#line 24 "calculator-plugin.vala"
	synapse_calculator_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "calculator-plugin.vala"
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_calculator_plugin_real_handles_query;
#line 24 "calculator-plugin.vala"
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_calculator_plugin_real_search;
#line 24 "calculator-plugin.vala"
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_calculator_plugin_search_finish;
#line 1489 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_instance_init (SynapseCalculatorPlugin * self,
                                         gpointer klass)
{
#line 24 "calculator-plugin.vala"
	self->priv = synapse_calculator_plugin_get_instance_private (self);
#line 26 "calculator-plugin.vala"
	self->priv->_enabled = TRUE;
#line 1500 "calculator-plugin.c"
}

static void
synapse_calculator_plugin_finalize (GObject * obj)
{
	SynapseCalculatorPlugin * self;
#line 24 "calculator-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
#line 73 "calculator-plugin.vala"
	_g_regex_unref0 (self->priv->regex);
#line 24 "calculator-plugin.vala"
	G_OBJECT_CLASS (synapse_calculator_plugin_parent_class)->finalize (obj);
#line 1513 "calculator-plugin.c"
}

static GType
synapse_calculator_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPlugin), 0, (GInstanceInitFunc) synapse_calculator_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_calculator_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_calculator_plugin_type_id;
	synapse_calculator_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_calculator_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCalculatorPlugin_private_offset = g_type_add_instance_private (synapse_calculator_plugin_type_id, sizeof (SynapseCalculatorPluginPrivate));
	return synapse_calculator_plugin_type_id;
}

GType
synapse_calculator_plugin_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_type_id__once)) {
		GType synapse_calculator_plugin_type_id;
		synapse_calculator_plugin_type_id = synapse_calculator_plugin_get_type_once ();
		g_once_init_leave (&synapse_calculator_plugin_type_id__once, synapse_calculator_plugin_type_id);
	}
	return synapse_calculator_plugin_type_id__once;
}

static void
_vala_synapse_calculator_plugin_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
#line 24 "calculator-plugin.vala"
	switch (property_id) {
#line 24 "calculator-plugin.vala"
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
#line 24 "calculator-plugin.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "calculator-plugin.vala"
		break;
#line 1558 "calculator-plugin.c"
		default:
#line 24 "calculator-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "calculator-plugin.vala"
		break;
#line 1564 "calculator-plugin.c"
	}
}

static void
_vala_synapse_calculator_plugin_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseCalculatorPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CALCULATOR_PLUGIN, SynapseCalculatorPlugin);
#line 24 "calculator-plugin.vala"
	switch (property_id) {
#line 24 "calculator-plugin.vala"
		case SYNAPSE_CALCULATOR_PLUGIN_ENABLED_PROPERTY:
#line 24 "calculator-plugin.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "calculator-plugin.vala"
		break;
#line 1584 "calculator-plugin.c"
		default:
#line 24 "calculator-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "calculator-plugin.vala"
		break;
#line 1590 "calculator-plugin.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

