/* match.c generated by valac 0.56.17, the Vala compiler
 * generated from match.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 */

#include "synapse-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_MATCH_0_PROPERTY,
	SYNAPSE_MATCH_TITLE_PROPERTY,
	SYNAPSE_MATCH_DESCRIPTION_PROPERTY,
	SYNAPSE_MATCH_ICON_NAME_PROPERTY,
	SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY,
	SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY,
	SYNAPSE_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_match_properties[SYNAPSE_MATCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SYNAPSE_MATCH_EXECUTED_SIGNAL,
	SYNAPSE_MATCH_NUM_SIGNALS
};
static guint synapse_match_signals[SYNAPSE_MATCH_NUM_SIGNALS] = {0};
enum  {
	SYNAPSE_ACTION_MATCH_0_PROPERTY,
	SYNAPSE_ACTION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_action_match_properties[SYNAPSE_ACTION_MATCH_NUM_PROPERTIES];
enum  {
	SYNAPSE_APPLICATION_MATCH_0_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY,
	SYNAPSE_APPLICATION_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SYNAPSE_URI_MATCH_0_PROPERTY,
	SYNAPSE_URI_MATCH_URI_PROPERTY,
	SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY,
	SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY,
	SYNAPSE_URI_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_uri_match_properties[SYNAPSE_URI_MATCH_NUM_PROPERTIES];
enum  {
	SYNAPSE_CONTACT_MATCH_0_PROPERTY,
	SYNAPSE_CONTACT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_contact_match_properties[SYNAPSE_CONTACT_MATCH_NUM_PROPERTIES];
enum  {
	SYNAPSE_TEXT_MATCH_0_PROPERTY,
	SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY,
	SYNAPSE_TEXT_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_text_match_properties[SYNAPSE_TEXT_MATCH_NUM_PROPERTIES];
enum  {
	SYNAPSE_SEARCH_MATCH_0_PROPERTY,
	SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY,
	SYNAPSE_SEARCH_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_NUM_PROPERTIES];
enum  {
	SYNAPSE_UNKNOWN_MATCH_0_PROPERTY,
	SYNAPSE_UNKNOWN_MATCH_NUM_PROPERTIES
};
static GParamSpec* synapse_unknown_match_properties[SYNAPSE_UNKNOWN_MATCH_NUM_PROPERTIES];

struct _SynapseMatchPrivate {
	gchar* _title;
	gchar* _description;
	gchar* _icon_name;
	gboolean _has_thumbnail;
	gchar* _thumbnail_path;
};

struct _SynapseApplicationMatchPrivate {
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
};

struct _SynapseUriMatchPrivate {
	gchar* _uri;
	SynapseQueryFlags _file_type;
	gchar* _mime_type;
};

struct _SynapseTextMatchPrivate {
	SynapseTextOrigin _text_origin;
};

struct _SynapseSearchMatchPrivate {
	SynapseMatch* _search_source;
};

static gint SynapseMatch_private_offset;
static gpointer synapse_match_parent_class = NULL;
static gpointer synapse_action_match_parent_class = NULL;
static gint SynapseApplicationMatch_private_offset;
static gpointer synapse_application_match_parent_class = NULL;
static gint SynapseUriMatch_private_offset;
static gpointer synapse_uri_match_parent_class = NULL;
static gpointer synapse_contact_match_parent_class = NULL;
static gint SynapseTextMatch_private_offset;
static gpointer synapse_text_match_parent_class = NULL;
static gint SynapseSearchMatch_private_offset;
static gpointer synapse_search_match_parent_class = NULL;
static SynapseSearchProviderIface * synapse_search_match_synapse_search_provider_parent_iface = NULL;
static gpointer synapse_unknown_match_parent_class = NULL;

static void synapse_match_real_execute (SynapseMatch* self,
                                 SynapseMatch* match);
static void synapse_match_real_execute_with_target (SynapseMatch* self,
                                             SynapseMatch* source,
                                             SynapseMatch* target);
static gboolean synapse_match_real_needs_target (SynapseMatch* self);
static SynapseQueryFlags synapse_match_real_target_flags (SynapseMatch* self);
static void synapse_match_finalize (GObject * obj);
static GType synapse_match_get_type_once (void);
static void _vala_synapse_match_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_synapse_match_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void synapse_action_match_real_do_action (SynapseActionMatch* self);
static GType synapse_action_match_get_type_once (void);
static void synapse_application_match_finalize (GObject * obj);
static GType synapse_application_match_get_type_once (void);
static void _vala_synapse_application_match_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_application_match_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void synapse_uri_match_finalize (GObject * obj);
static GType synapse_uri_match_get_type_once (void);
static void _vala_synapse_uri_match_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_synapse_uri_match_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void synapse_contact_match_real_send_message (SynapseContactMatch* self,
                                              const gchar* message,
                                              gboolean present);
static void synapse_contact_match_real_open_chat (SynapseContactMatch* self);
static GType synapse_contact_match_get_type_once (void);
static GType synapse_extended_info_get_type_once (void);
static gchar* synapse_text_match_real_get_text (SynapseTextMatch* self);
static void synapse_text_match_finalize (GObject * obj);
static GType synapse_text_match_get_type_once (void);
static void _vala_synapse_text_match_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_synapse_text_match_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void synapse_search_match_finalize (GObject * obj);
static GType synapse_search_match_get_type_once (void);
static void _vala_synapse_search_match_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_synapse_search_match_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static GType synapse_unknown_match_get_type_once (void);

static GType
synapse_match_score_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_MATCH_SCORE_INCREMENT_MINOR, "SYNAPSE_MATCH_SCORE_INCREMENT_MINOR", "increment-minor"}, {SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, "SYNAPSE_MATCH_SCORE_INCREMENT_SMALL", "increment-small"}, {SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM, "SYNAPSE_MATCH_SCORE_INCREMENT_MEDIUM", "increment-medium"}, {SYNAPSE_MATCH_SCORE_INCREMENT_LARGE, "SYNAPSE_MATCH_SCORE_INCREMENT_LARGE", "increment-large"}, {SYNAPSE_MATCH_SCORE_URI_PENALTY, "SYNAPSE_MATCH_SCORE_URI_PENALTY", "uri-penalty"}, {SYNAPSE_MATCH_SCORE_POOR, "SYNAPSE_MATCH_SCORE_POOR", "poor"}, {SYNAPSE_MATCH_SCORE_BELOW_AVERAGE, "SYNAPSE_MATCH_SCORE_BELOW_AVERAGE", "below-average"}, {SYNAPSE_MATCH_SCORE_AVERAGE, "SYNAPSE_MATCH_SCORE_AVERAGE", "average"}, {SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE, "SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE", "above-average"}, {SYNAPSE_MATCH_SCORE_GOOD, "SYNAPSE_MATCH_SCORE_GOOD", "good"}, {SYNAPSE_MATCH_SCORE_VERY_GOOD, "SYNAPSE_MATCH_SCORE_VERY_GOOD", "very-good"}, {SYNAPSE_MATCH_SCORE_EXCELLENT, "SYNAPSE_MATCH_SCORE_EXCELLENT", "excellent"}, {SYNAPSE_MATCH_SCORE_HIGHEST, "SYNAPSE_MATCH_SCORE_HIGHEST", "highest"}, {0, NULL, NULL}};
	GType synapse_match_score_type_id;
	synapse_match_score_type_id = g_enum_register_static ("SynapseMatchScore", values);
	return synapse_match_score_type_id;
}

GType
synapse_match_score_get_type (void)
{
	static volatile gsize synapse_match_score_type_id__once = 0;
	if (g_once_init_enter (&synapse_match_score_type_id__once)) {
		GType synapse_match_score_type_id;
		synapse_match_score_type_id = synapse_match_score_get_type_once ();
		g_once_init_leave (&synapse_match_score_type_id__once, synapse_match_score_type_id);
	}
	return synapse_match_score_type_id__once;
}

static inline gpointer
synapse_match_get_instance_private (SynapseMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseMatch_private_offset);
}

static void
synapse_match_real_execute (SynapseMatch* self,
                            SynapseMatch* match)
{
#line 53 "match.vala"
	g_return_if_fail (match != NULL);
#line 55 "match.vala"
	g_critical ("match.vala:55: execute () is not implemented");
#line 249 "match.c"
}

void
synapse_match_execute (SynapseMatch* self,
                       SynapseMatch* match)
{
	SynapseMatchClass* _klass_;
#line 53 "match.vala"
	g_return_if_fail (self != NULL);
#line 53 "match.vala"
	_klass_ = SYNAPSE_MATCH_GET_CLASS (self);
#line 53 "match.vala"
	if (_klass_->execute) {
#line 53 "match.vala"
		_klass_->execute (self, match);
#line 265 "match.c"
	}
}

static void
synapse_match_real_execute_with_target (SynapseMatch* self,
                                        SynapseMatch* source,
                                        SynapseMatch* target)
{
#line 58 "match.vala"
	g_return_if_fail (source != NULL);
#line 60 "match.vala"
	if (target == NULL) {
#line 61 "match.vala"
		synapse_match_execute (self, source);
#line 280 "match.c"
	} else {
#line 63 "match.vala"
		g_critical ("match.vala:63: execute_with_target () is not implemented");
#line 284 "match.c"
	}
}

void
synapse_match_execute_with_target (SynapseMatch* self,
                                   SynapseMatch* source,
                                   SynapseMatch* target)
{
	SynapseMatchClass* _klass_;
#line 58 "match.vala"
	g_return_if_fail (self != NULL);
#line 58 "match.vala"
	_klass_ = SYNAPSE_MATCH_GET_CLASS (self);
#line 58 "match.vala"
	if (_klass_->execute_with_target) {
#line 58 "match.vala"
		_klass_->execute_with_target (self, source, target);
#line 302 "match.c"
	}
}

static gboolean
synapse_match_real_needs_target (SynapseMatch* self)
{
	gboolean result;
#line 68 "match.vala"
	result = FALSE;
#line 68 "match.vala"
	return result;
#line 314 "match.c"
}

gboolean
synapse_match_needs_target (SynapseMatch* self)
{
	SynapseMatchClass* _klass_;
#line 66 "match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 66 "match.vala"
	_klass_ = SYNAPSE_MATCH_GET_CLASS (self);
#line 66 "match.vala"
	if (_klass_->needs_target) {
#line 66 "match.vala"
		return _klass_->needs_target (self);
#line 329 "match.c"
	}
#line 66 "match.vala"
	return FALSE;
#line 333 "match.c"
}

static SynapseQueryFlags
synapse_match_real_target_flags (SynapseMatch* self)
{
	SynapseQueryFlags result;
#line 73 "match.vala"
	result = SYNAPSE_QUERY_FLAGS_ALL;
#line 73 "match.vala"
	return result;
#line 344 "match.c"
}

SynapseQueryFlags
synapse_match_target_flags (SynapseMatch* self)
{
	SynapseMatchClass* _klass_;
#line 71 "match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 71 "match.vala"
	_klass_ = SYNAPSE_MATCH_GET_CLASS (self);
#line 71 "match.vala"
	if (_klass_->target_flags) {
#line 71 "match.vala"
		return _klass_->target_flags (self);
#line 359 "match.c"
	}
#line 71 "match.vala"
	return 0U;
#line 363 "match.c"
}

SynapseMatch*
synapse_match_construct (GType object_type)
{
	SynapseMatch * self = NULL;
#line 42 "match.vala"
	self = (SynapseMatch*) g_object_new (object_type, NULL);
#line 42 "match.vala"
	return self;
#line 374 "match.c"
}

const gchar*
synapse_match_get_title (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 47 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "match.vala"
	_tmp0_ = self->priv->_title;
#line 47 "match.vala"
	result = _tmp0_;
#line 47 "match.vala"
	return result;
#line 390 "match.c"
}

void
synapse_match_set_title (SynapseMatch* self,
                         const gchar* value)
{
	gchar* old_value;
#line 47 "match.vala"
	g_return_if_fail (self != NULL);
#line 47 "match.vala"
	old_value = synapse_match_get_title (self);
#line 47 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 404 "match.c"
		gchar* _tmp0_;
#line 47 "match.vala"
		_tmp0_ = g_strdup (value);
#line 47 "match.vala"
		_g_free0 (self->priv->_title);
#line 47 "match.vala"
		self->priv->_title = _tmp0_;
#line 47 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_TITLE_PROPERTY]);
#line 414 "match.c"
	}
}

const gchar*
synapse_match_get_description (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 48 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "match.vala"
	_tmp0_ = self->priv->_description;
#line 48 "match.vala"
	result = _tmp0_;
#line 48 "match.vala"
	return result;
#line 431 "match.c"
}

void
synapse_match_set_description (SynapseMatch* self,
                               const gchar* value)
{
	gchar* old_value;
#line 48 "match.vala"
	g_return_if_fail (self != NULL);
#line 48 "match.vala"
	old_value = synapse_match_get_description (self);
#line 48 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 445 "match.c"
		gchar* _tmp0_;
#line 48 "match.vala"
		_tmp0_ = g_strdup (value);
#line 48 "match.vala"
		_g_free0 (self->priv->_description);
#line 48 "match.vala"
		self->priv->_description = _tmp0_;
#line 48 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_DESCRIPTION_PROPERTY]);
#line 455 "match.c"
	}
}

const gchar*
synapse_match_get_icon_name (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 49 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 49 "match.vala"
	_tmp0_ = self->priv->_icon_name;
#line 49 "match.vala"
	result = _tmp0_;
#line 49 "match.vala"
	return result;
#line 472 "match.c"
}

void
synapse_match_set_icon_name (SynapseMatch* self,
                             const gchar* value)
{
	gchar* old_value;
#line 49 "match.vala"
	g_return_if_fail (self != NULL);
#line 49 "match.vala"
	old_value = synapse_match_get_icon_name (self);
#line 49 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 486 "match.c"
		gchar* _tmp0_;
#line 49 "match.vala"
		_tmp0_ = g_strdup (value);
#line 49 "match.vala"
		_g_free0 (self->priv->_icon_name);
#line 49 "match.vala"
		self->priv->_icon_name = _tmp0_;
#line 49 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_ICON_NAME_PROPERTY]);
#line 496 "match.c"
	}
}

gboolean
synapse_match_get_has_thumbnail (SynapseMatch* self)
{
	gboolean result;
#line 50 "match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 50 "match.vala"
	result = self->priv->_has_thumbnail;
#line 50 "match.vala"
	return result;
#line 510 "match.c"
}

void
synapse_match_set_has_thumbnail (SynapseMatch* self,
                                 gboolean value)
{
	gboolean old_value;
#line 50 "match.vala"
	g_return_if_fail (self != NULL);
#line 50 "match.vala"
	old_value = synapse_match_get_has_thumbnail (self);
#line 50 "match.vala"
	if (old_value != value) {
#line 50 "match.vala"
		self->priv->_has_thumbnail = value;
#line 50 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY]);
#line 528 "match.c"
	}
}

const gchar*
synapse_match_get_thumbnail_path (SynapseMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "match.vala"
	_tmp0_ = self->priv->_thumbnail_path;
#line 51 "match.vala"
	result = _tmp0_;
#line 51 "match.vala"
	return result;
#line 545 "match.c"
}

void
synapse_match_set_thumbnail_path (SynapseMatch* self,
                                  const gchar* value)
{
	gchar* old_value;
#line 51 "match.vala"
	g_return_if_fail (self != NULL);
#line 51 "match.vala"
	old_value = synapse_match_get_thumbnail_path (self);
#line 51 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 559 "match.c"
		gchar* _tmp0_;
#line 51 "match.vala"
		_tmp0_ = g_strdup (value);
#line 51 "match.vala"
		_g_free0 (self->priv->_thumbnail_path);
#line 51 "match.vala"
		self->priv->_thumbnail_path = _tmp0_;
#line 51 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_match_properties[SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY]);
#line 569 "match.c"
	}
}

static void
synapse_match_class_init (SynapseMatchClass * klass,
                          gpointer klass_data)
{
#line 42 "match.vala"
	synapse_match_parent_class = g_type_class_peek_parent (klass);
#line 42 "match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseMatch_private_offset);
#line 42 "match.vala"
	((SynapseMatchClass *) klass)->execute = (void (*) (SynapseMatch*, SynapseMatch*)) synapse_match_real_execute;
#line 42 "match.vala"
	((SynapseMatchClass *) klass)->execute_with_target = (void (*) (SynapseMatch*, SynapseMatch*, SynapseMatch*)) synapse_match_real_execute_with_target;
#line 42 "match.vala"
	((SynapseMatchClass *) klass)->needs_target = (gboolean (*) (SynapseMatch*)) synapse_match_real_needs_target;
#line 42 "match.vala"
	((SynapseMatchClass *) klass)->target_flags = (SynapseQueryFlags (*) (SynapseMatch*)) synapse_match_real_target_flags;
#line 42 "match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_match_get_property;
#line 42 "match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_match_set_property;
#line 42 "match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_match_finalize;
#line 42 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_TITLE_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_DESCRIPTION_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_ICON_NAME_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY] = g_param_spec_boolean ("has-thumbnail", "has-thumbnail", "has-thumbnail", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY, synapse_match_properties[SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 42 "match.vala"
	synapse_match_signals[SYNAPSE_MATCH_EXECUTED_SIGNAL] = g_signal_new ("executed", SYNAPSE_TYPE_MATCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 607 "match.c"
}

static void
synapse_match_instance_init (SynapseMatch * self,
                             gpointer klass)
{
#line 42 "match.vala"
	self->priv = synapse_match_get_instance_private (self);
#line 616 "match.c"
}

static void
synapse_match_finalize (GObject * obj)
{
	SynapseMatch * self;
#line 42 "match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 47 "match.vala"
	_g_free0 (self->priv->_title);
#line 48 "match.vala"
	_g_free0 (self->priv->_description);
#line 49 "match.vala"
	_g_free0 (self->priv->_icon_name);
#line 51 "match.vala"
	_g_free0 (self->priv->_thumbnail_path);
#line 42 "match.vala"
	G_OBJECT_CLASS (synapse_match_parent_class)->finalize (obj);
#line 635 "match.c"
}

static GType
synapse_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseMatch), 0, (GInstanceInitFunc) synapse_match_instance_init, NULL };
	GType synapse_match_type_id;
	synapse_match_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseMatch_private_offset = g_type_add_instance_private (synapse_match_type_id, sizeof (SynapseMatchPrivate));
	return synapse_match_type_id;
}

GType
synapse_match_get_type (void)
{
	static volatile gsize synapse_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_match_type_id__once)) {
		GType synapse_match_type_id;
		synapse_match_type_id = synapse_match_get_type_once ();
		g_once_init_leave (&synapse_match_type_id__once, synapse_match_type_id);
	}
	return synapse_match_type_id__once;
}

static void
_vala_synapse_match_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SynapseMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 42 "match.vala"
	switch (property_id) {
#line 42 "match.vala"
		case SYNAPSE_MATCH_TITLE_PROPERTY:
#line 42 "match.vala"
		g_value_set_string (value, synapse_match_get_title (self));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_DESCRIPTION_PROPERTY:
#line 42 "match.vala"
		g_value_set_string (value, synapse_match_get_description (self));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_ICON_NAME_PROPERTY:
#line 42 "match.vala"
		g_value_set_string (value, synapse_match_get_icon_name (self));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 42 "match.vala"
		g_value_set_boolean (value, synapse_match_get_has_thumbnail (self));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 42 "match.vala"
		g_value_set_string (value, synapse_match_get_thumbnail_path (self));
#line 42 "match.vala"
		break;
#line 700 "match.c"
		default:
#line 42 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "match.vala"
		break;
#line 706 "match.c"
	}
}

static void
_vala_synapse_match_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SynapseMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_MATCH, SynapseMatch);
#line 42 "match.vala"
	switch (property_id) {
#line 42 "match.vala"
		case SYNAPSE_MATCH_TITLE_PROPERTY:
#line 42 "match.vala"
		synapse_match_set_title (self, g_value_get_string (value));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_DESCRIPTION_PROPERTY:
#line 42 "match.vala"
		synapse_match_set_description (self, g_value_get_string (value));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_ICON_NAME_PROPERTY:
#line 42 "match.vala"
		synapse_match_set_icon_name (self, g_value_get_string (value));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_HAS_THUMBNAIL_PROPERTY:
#line 42 "match.vala"
		synapse_match_set_has_thumbnail (self, g_value_get_boolean (value));
#line 42 "match.vala"
		break;
#line 42 "match.vala"
		case SYNAPSE_MATCH_THUMBNAIL_PATH_PROPERTY:
#line 42 "match.vala"
		synapse_match_set_thumbnail_path (self, g_value_get_string (value));
#line 42 "match.vala"
		break;
#line 750 "match.c"
		default:
#line 42 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "match.vala"
		break;
#line 756 "match.c"
	}
}

static void
synapse_action_match_real_do_action (SynapseActionMatch* self)
{
#line 79 "match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_action_match_do_action'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 79 "match.vala"
	return;
#line 767 "match.c"
}

void
synapse_action_match_do_action (SynapseActionMatch* self)
{
	SynapseActionMatchClass* _klass_;
#line 79 "match.vala"
	g_return_if_fail (self != NULL);
#line 79 "match.vala"
	_klass_ = SYNAPSE_ACTION_MATCH_GET_CLASS (self);
#line 79 "match.vala"
	if (_klass_->do_action) {
#line 79 "match.vala"
		_klass_->do_action (self);
#line 782 "match.c"
	}
}

SynapseActionMatch*
synapse_action_match_construct (GType object_type)
{
	SynapseActionMatch * self = NULL;
#line 77 "match.vala"
	self = (SynapseActionMatch*) synapse_match_construct (object_type);
#line 77 "match.vala"
	return self;
#line 794 "match.c"
}

static void
synapse_action_match_class_init (SynapseActionMatchClass * klass,
                                 gpointer klass_data)
{
#line 77 "match.vala"
	synapse_action_match_parent_class = g_type_class_peek_parent (klass);
#line 77 "match.vala"
	((SynapseActionMatchClass *) klass)->do_action = (void (*) (SynapseActionMatch*)) synapse_action_match_real_do_action;
#line 805 "match.c"
}

static void
synapse_action_match_instance_init (SynapseActionMatch * self,
                                    gpointer klass)
{
}

static GType
synapse_action_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseActionMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_action_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseActionMatch), 0, (GInstanceInitFunc) synapse_action_match_instance_init, NULL };
	GType synapse_action_match_type_id;
	synapse_action_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseActionMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_action_match_type_id;
}

GType
synapse_action_match_get_type (void)
{
	static volatile gsize synapse_action_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_action_match_type_id__once)) {
		GType synapse_action_match_type_id;
		synapse_action_match_type_id = synapse_action_match_get_type_once ();
		g_once_init_leave (&synapse_action_match_type_id__once, synapse_action_match_type_id);
	}
	return synapse_action_match_type_id__once;
}

static inline gpointer
synapse_application_match_get_instance_private (SynapseApplicationMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseApplicationMatch_private_offset);
}

SynapseApplicationMatch*
synapse_application_match_construct (GType object_type)
{
	SynapseApplicationMatch * self = NULL;
#line 90 "match.vala"
	self = (SynapseApplicationMatch*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "", "thumbnail-path", "", NULL);
#line 88 "match.vala"
	return self;
#line 849 "match.c"
}

SynapseApplicationMatch*
synapse_application_match_new (void)
{
#line 88 "match.vala"
	return synapse_application_match_construct (SYNAPSE_TYPE_APPLICATION_MATCH);
#line 857 "match.c"
}

GAppInfo*
synapse_application_match_get_app_info (SynapseApplicationMatch* self)
{
	GAppInfo* result;
	GAppInfo* _tmp0_;
#line 84 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "match.vala"
	_tmp0_ = self->priv->_app_info;
#line 84 "match.vala"
	result = _tmp0_;
#line 84 "match.vala"
	return result;
#line 873 "match.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 84 "match.vala"
	return self ? g_object_ref (self) : NULL;
#line 881 "match.c"
}

void
synapse_application_match_set_app_info (SynapseApplicationMatch* self,
                                        GAppInfo* value)
{
	GAppInfo* old_value;
#line 84 "match.vala"
	g_return_if_fail (self != NULL);
#line 84 "match.vala"
	old_value = synapse_application_match_get_app_info (self);
#line 84 "match.vala"
	if (old_value != value) {
#line 895 "match.c"
		GAppInfo* _tmp0_;
#line 84 "match.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 84 "match.vala"
		_g_object_unref0 (self->priv->_app_info);
#line 84 "match.vala"
		self->priv->_app_info = _tmp0_;
#line 84 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY]);
#line 905 "match.c"
	}
}

gboolean
synapse_application_match_get_needs_terminal (SynapseApplicationMatch* self)
{
	gboolean result;
#line 85 "match.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 85 "match.vala"
	result = self->priv->_needs_terminal;
#line 85 "match.vala"
	return result;
#line 919 "match.c"
}

void
synapse_application_match_set_needs_terminal (SynapseApplicationMatch* self,
                                              gboolean value)
{
	gboolean old_value;
#line 85 "match.vala"
	g_return_if_fail (self != NULL);
#line 85 "match.vala"
	old_value = synapse_application_match_get_needs_terminal (self);
#line 85 "match.vala"
	if (old_value != value) {
#line 85 "match.vala"
		self->priv->_needs_terminal = value;
#line 85 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY]);
#line 937 "match.c"
	}
}

const gchar*
synapse_application_match_get_filename (SynapseApplicationMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 86 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "match.vala"
	_tmp0_ = self->priv->_filename;
#line 86 "match.vala"
	result = _tmp0_;
#line 86 "match.vala"
	return result;
#line 954 "match.c"
}

void
synapse_application_match_set_filename (SynapseApplicationMatch* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 86 "match.vala"
	g_return_if_fail (self != NULL);
#line 86 "match.vala"
	old_value = synapse_application_match_get_filename (self);
#line 86 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 968 "match.c"
		gchar* _tmp0_;
#line 86 "match.vala"
		_tmp0_ = g_strdup (value);
#line 86 "match.vala"
		_g_free0 (self->priv->_filename);
#line 86 "match.vala"
		self->priv->_filename = _tmp0_;
#line 86 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY]);
#line 978 "match.c"
	}
}

static void
synapse_application_match_class_init (SynapseApplicationMatchClass * klass,
                                      gpointer klass_data)
{
#line 82 "match.vala"
	synapse_application_match_parent_class = g_type_class_peek_parent (klass);
#line 82 "match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseApplicationMatch_private_offset);
#line 82 "match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_application_match_get_property;
#line 82 "match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_application_match_set_property;
#line 82 "match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_application_match_finalize;
#line 82 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 82 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 82 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY, synapse_application_match_properties[SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1002 "match.c"
}

static void
synapse_application_match_instance_init (SynapseApplicationMatch * self,
                                         gpointer klass)
{
#line 82 "match.vala"
	self->priv = synapse_application_match_get_instance_private (self);
#line 1011 "match.c"
}

static void
synapse_application_match_finalize (GObject * obj)
{
	SynapseApplicationMatch * self;
#line 82 "match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 84 "match.vala"
	_g_object_unref0 (self->priv->_app_info);
#line 86 "match.vala"
	_g_free0 (self->priv->_filename);
#line 82 "match.vala"
	G_OBJECT_CLASS (synapse_application_match_parent_class)->finalize (obj);
#line 1026 "match.c"
}

static GType
synapse_application_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseApplicationMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_application_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseApplicationMatch), 0, (GInstanceInitFunc) synapse_application_match_instance_init, NULL };
	GType synapse_application_match_type_id;
	synapse_application_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseApplicationMatch", &g_define_type_info, 0);
	SynapseApplicationMatch_private_offset = g_type_add_instance_private (synapse_application_match_type_id, sizeof (SynapseApplicationMatchPrivate));
	return synapse_application_match_type_id;
}

GType
synapse_application_match_get_type (void)
{
	static volatile gsize synapse_application_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_application_match_type_id__once)) {
		GType synapse_application_match_type_id;
		synapse_application_match_type_id = synapse_application_match_get_type_once ();
		g_once_init_leave (&synapse_application_match_type_id__once, synapse_application_match_type_id);
	}
	return synapse_application_match_type_id__once;
}

static void
_vala_synapse_application_match_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 82 "match.vala"
	switch (property_id) {
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY:
#line 82 "match.vala"
		g_value_set_object (value, synapse_application_match_get_app_info (self));
#line 82 "match.vala"
		break;
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 82 "match.vala"
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal (self));
#line 82 "match.vala"
		break;
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY:
#line 82 "match.vala"
		g_value_set_string (value, synapse_application_match_get_filename (self));
#line 82 "match.vala"
		break;
#line 1079 "match.c"
		default:
#line 82 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 82 "match.vala"
		break;
#line 1085 "match.c"
	}
}

static void
_vala_synapse_application_match_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseApplicationMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 82 "match.vala"
	switch (property_id) {
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_APP_INFO_PROPERTY:
#line 82 "match.vala"
		synapse_application_match_set_app_info (self, g_value_get_object (value));
#line 82 "match.vala"
		break;
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_NEEDS_TERMINAL_PROPERTY:
#line 82 "match.vala"
		synapse_application_match_set_needs_terminal (self, g_value_get_boolean (value));
#line 82 "match.vala"
		break;
#line 82 "match.vala"
		case SYNAPSE_APPLICATION_MATCH_FILENAME_PROPERTY:
#line 82 "match.vala"
		synapse_application_match_set_filename (self, g_value_get_string (value));
#line 82 "match.vala"
		break;
#line 1117 "match.c"
		default:
#line 82 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 82 "match.vala"
		break;
#line 1123 "match.c"
	}
}

static inline gpointer
synapse_uri_match_get_instance_private (SynapseUriMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseUriMatch_private_offset);
}

SynapseUriMatch*
synapse_uri_match_construct (GType object_type)
{
	SynapseUriMatch * self = NULL;
#line 104 "match.vala"
	self = (SynapseUriMatch*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "", "thumbnail-path", "", NULL);
#line 102 "match.vala"
	return self;
#line 1141 "match.c"
}

SynapseUriMatch*
synapse_uri_match_new (void)
{
#line 102 "match.vala"
	return synapse_uri_match_construct (SYNAPSE_TYPE_URI_MATCH);
#line 1149 "match.c"
}

const gchar*
synapse_uri_match_get_uri (SynapseUriMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 98 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "match.vala"
	_tmp0_ = self->priv->_uri;
#line 98 "match.vala"
	result = _tmp0_;
#line 98 "match.vala"
	return result;
#line 1165 "match.c"
}

void
synapse_uri_match_set_uri (SynapseUriMatch* self,
                           const gchar* value)
{
	gchar* old_value;
#line 98 "match.vala"
	g_return_if_fail (self != NULL);
#line 98 "match.vala"
	old_value = synapse_uri_match_get_uri (self);
#line 98 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1179 "match.c"
		gchar* _tmp0_;
#line 98 "match.vala"
		_tmp0_ = g_strdup (value);
#line 98 "match.vala"
		_g_free0 (self->priv->_uri);
#line 98 "match.vala"
		self->priv->_uri = _tmp0_;
#line 98 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_URI_PROPERTY]);
#line 1189 "match.c"
	}
}

SynapseQueryFlags
synapse_uri_match_get_file_type (SynapseUriMatch* self)
{
	SynapseQueryFlags result;
#line 99 "match.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 99 "match.vala"
	result = self->priv->_file_type;
#line 99 "match.vala"
	return result;
#line 1203 "match.c"
}

void
synapse_uri_match_set_file_type (SynapseUriMatch* self,
                                 SynapseQueryFlags value)
{
	SynapseQueryFlags old_value;
#line 99 "match.vala"
	g_return_if_fail (self != NULL);
#line 99 "match.vala"
	old_value = synapse_uri_match_get_file_type (self);
#line 99 "match.vala"
	if (old_value != value) {
#line 99 "match.vala"
		self->priv->_file_type = value;
#line 99 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY]);
#line 1221 "match.c"
	}
}

const gchar*
synapse_uri_match_get_mime_type (SynapseUriMatch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 100 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "match.vala"
	_tmp0_ = self->priv->_mime_type;
#line 100 "match.vala"
	result = _tmp0_;
#line 100 "match.vala"
	return result;
#line 1238 "match.c"
}

void
synapse_uri_match_set_mime_type (SynapseUriMatch* self,
                                 const gchar* value)
{
	gchar* old_value;
#line 100 "match.vala"
	g_return_if_fail (self != NULL);
#line 100 "match.vala"
	old_value = synapse_uri_match_get_mime_type (self);
#line 100 "match.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1252 "match.c"
		gchar* _tmp0_;
#line 100 "match.vala"
		_tmp0_ = g_strdup (value);
#line 100 "match.vala"
		_g_free0 (self->priv->_mime_type);
#line 100 "match.vala"
		self->priv->_mime_type = _tmp0_;
#line 100 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_uri_match_properties[SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY]);
#line 1262 "match.c"
	}
}

static void
synapse_uri_match_class_init (SynapseUriMatchClass * klass,
                              gpointer klass_data)
{
#line 96 "match.vala"
	synapse_uri_match_parent_class = g_type_class_peek_parent (klass);
#line 96 "match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseUriMatch_private_offset);
#line 96 "match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_uri_match_get_property;
#line 96 "match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_uri_match_set_property;
#line 96 "match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_uri_match_finalize;
#line 96 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_URI_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 96 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY] = g_param_spec_flags ("file-type", "file-type", "file-type", SYNAPSE_TYPE_QUERY_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 96 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY, synapse_uri_match_properties[SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1286 "match.c"
}

static void
synapse_uri_match_instance_init (SynapseUriMatch * self,
                                 gpointer klass)
{
#line 96 "match.vala"
	self->priv = synapse_uri_match_get_instance_private (self);
#line 1295 "match.c"
}

static void
synapse_uri_match_finalize (GObject * obj)
{
	SynapseUriMatch * self;
#line 96 "match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 98 "match.vala"
	_g_free0 (self->priv->_uri);
#line 100 "match.vala"
	_g_free0 (self->priv->_mime_type);
#line 96 "match.vala"
	G_OBJECT_CLASS (synapse_uri_match_parent_class)->finalize (obj);
#line 1310 "match.c"
}

static GType
synapse_uri_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUriMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_uri_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUriMatch), 0, (GInstanceInitFunc) synapse_uri_match_instance_init, NULL };
	GType synapse_uri_match_type_id;
	synapse_uri_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseUriMatch", &g_define_type_info, 0);
	SynapseUriMatch_private_offset = g_type_add_instance_private (synapse_uri_match_type_id, sizeof (SynapseUriMatchPrivate));
	return synapse_uri_match_type_id;
}

GType
synapse_uri_match_get_type (void)
{
	static volatile gsize synapse_uri_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_uri_match_type_id__once)) {
		GType synapse_uri_match_type_id;
		synapse_uri_match_type_id = synapse_uri_match_get_type_once ();
		g_once_init_leave (&synapse_uri_match_type_id__once, synapse_uri_match_type_id);
	}
	return synapse_uri_match_type_id__once;
}

static void
_vala_synapse_uri_match_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	SynapseUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 96 "match.vala"
	switch (property_id) {
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_URI_PROPERTY:
#line 96 "match.vala"
		g_value_set_string (value, synapse_uri_match_get_uri (self));
#line 96 "match.vala"
		break;
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY:
#line 96 "match.vala"
		g_value_set_flags (value, synapse_uri_match_get_file_type (self));
#line 96 "match.vala"
		break;
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY:
#line 96 "match.vala"
		g_value_set_string (value, synapse_uri_match_get_mime_type (self));
#line 96 "match.vala"
		break;
#line 1363 "match.c"
		default:
#line 96 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 96 "match.vala"
		break;
#line 1369 "match.c"
	}
}

static void
_vala_synapse_uri_match_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	SynapseUriMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 96 "match.vala"
	switch (property_id) {
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_URI_PROPERTY:
#line 96 "match.vala"
		synapse_uri_match_set_uri (self, g_value_get_string (value));
#line 96 "match.vala"
		break;
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_FILE_TYPE_PROPERTY:
#line 96 "match.vala"
		synapse_uri_match_set_file_type (self, g_value_get_flags (value));
#line 96 "match.vala"
		break;
#line 96 "match.vala"
		case SYNAPSE_URI_MATCH_MIME_TYPE_PROPERTY:
#line 96 "match.vala"
		synapse_uri_match_set_mime_type (self, g_value_get_string (value));
#line 96 "match.vala"
		break;
#line 1401 "match.c"
		default:
#line 96 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 96 "match.vala"
		break;
#line 1407 "match.c"
	}
}

static void
synapse_contact_match_real_send_message (SynapseContactMatch* self,
                                         const gchar* message,
                                         gboolean present)
{
#line 112 "match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_contact_match_send_message'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 112 "match.vala"
	return;
#line 1420 "match.c"
}

void
synapse_contact_match_send_message (SynapseContactMatch* self,
                                    const gchar* message,
                                    gboolean present)
{
	SynapseContactMatchClass* _klass_;
#line 112 "match.vala"
	g_return_if_fail (self != NULL);
#line 112 "match.vala"
	_klass_ = SYNAPSE_CONTACT_MATCH_GET_CLASS (self);
#line 112 "match.vala"
	if (_klass_->send_message) {
#line 112 "match.vala"
		_klass_->send_message (self, message, present);
#line 1437 "match.c"
	}
}

static void
synapse_contact_match_real_open_chat (SynapseContactMatch* self)
{
#line 113 "match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_contact_match_open_chat'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 113 "match.vala"
	return;
#line 1448 "match.c"
}

void
synapse_contact_match_open_chat (SynapseContactMatch* self)
{
	SynapseContactMatchClass* _klass_;
#line 113 "match.vala"
	g_return_if_fail (self != NULL);
#line 113 "match.vala"
	_klass_ = SYNAPSE_CONTACT_MATCH_GET_CLASS (self);
#line 113 "match.vala"
	if (_klass_->open_chat) {
#line 113 "match.vala"
		_klass_->open_chat (self);
#line 1463 "match.c"
	}
}

SynapseContactMatch*
synapse_contact_match_construct (GType object_type)
{
	SynapseContactMatch * self = NULL;
#line 110 "match.vala"
	self = (SynapseContactMatch*) synapse_match_construct (object_type);
#line 110 "match.vala"
	return self;
#line 1475 "match.c"
}

static void
synapse_contact_match_class_init (SynapseContactMatchClass * klass,
                                  gpointer klass_data)
{
#line 110 "match.vala"
	synapse_contact_match_parent_class = g_type_class_peek_parent (klass);
#line 110 "match.vala"
	((SynapseContactMatchClass *) klass)->send_message = (void (*) (SynapseContactMatch*, const gchar*, gboolean)) synapse_contact_match_real_send_message;
#line 110 "match.vala"
	((SynapseContactMatchClass *) klass)->open_chat = (void (*) (SynapseContactMatch*)) synapse_contact_match_real_open_chat;
#line 1488 "match.c"
}

static void
synapse_contact_match_instance_init (SynapseContactMatch * self,
                                     gpointer klass)
{
}

static GType
synapse_contact_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseContactMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_contact_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseContactMatch), 0, (GInstanceInitFunc) synapse_contact_match_instance_init, NULL };
	GType synapse_contact_match_type_id;
	synapse_contact_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseContactMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_contact_match_type_id;
}

GType
synapse_contact_match_get_type (void)
{
	static volatile gsize synapse_contact_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_contact_match_type_id__once)) {
		GType synapse_contact_match_type_id;
		synapse_contact_match_type_id = synapse_contact_match_get_type_once ();
		g_once_init_leave (&synapse_contact_match_type_id__once, synapse_contact_match_type_id);
	}
	return synapse_contact_match_type_id__once;
}

const gchar*
synapse_extended_info_get_extended_info (SynapseExtendedInfo* self)
{
	SynapseExtendedInfoIface* _iface_;
#line 118 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "match.vala"
	_iface_ = SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self);
#line 118 "match.vala"
	if (_iface_->get_extended_info) {
#line 118 "match.vala"
		return _iface_->get_extended_info (self);
#line 1530 "match.c"
	}
#line 118 "match.vala"
	return NULL;
#line 1534 "match.c"
}

void
synapse_extended_info_set_extended_info (SynapseExtendedInfo* self,
                                         const gchar* value)
{
	SynapseExtendedInfoIface* _iface_;
#line 118 "match.vala"
	g_return_if_fail (self != NULL);
#line 118 "match.vala"
	_iface_ = SYNAPSE_EXTENDED_INFO_GET_INTERFACE (self);
#line 118 "match.vala"
	if (_iface_->set_extended_info) {
#line 118 "match.vala"
		_iface_->set_extended_info (self, value);
#line 1550 "match.c"
	}
}

static void
synapse_extended_info_default_init (SynapseExtendedInfoIface * iface,
                                    gpointer iface_data)
{
}

static GType
synapse_extended_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseExtendedInfoIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_extended_info_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType synapse_extended_info_type_id;
	synapse_extended_info_type_id = g_type_register_static (G_TYPE_INTERFACE, "SynapseExtendedInfo", &g_define_type_info, 0);
	return synapse_extended_info_type_id;
}

GType
synapse_extended_info_get_type (void)
{
	static volatile gsize synapse_extended_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_extended_info_type_id__once)) {
		GType synapse_extended_info_type_id;
		synapse_extended_info_type_id = synapse_extended_info_get_type_once ();
		g_once_init_leave (&synapse_extended_info_type_id__once, synapse_extended_info_type_id);
	}
	return synapse_extended_info_type_id__once;
}

static GType
synapse_text_origin_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_TEXT_ORIGIN_UNKNOWN, "SYNAPSE_TEXT_ORIGIN_UNKNOWN", "unknown"}, {SYNAPSE_TEXT_ORIGIN_CLIPBOARD, "SYNAPSE_TEXT_ORIGIN_CLIPBOARD", "clipboard"}, {0, NULL, NULL}};
	GType synapse_text_origin_type_id;
	synapse_text_origin_type_id = g_enum_register_static ("SynapseTextOrigin", values);
	return synapse_text_origin_type_id;
}

GType
synapse_text_origin_get_type (void)
{
	static volatile gsize synapse_text_origin_type_id__once = 0;
	if (g_once_init_enter (&synapse_text_origin_type_id__once)) {
		GType synapse_text_origin_type_id;
		synapse_text_origin_type_id = synapse_text_origin_get_type_once ();
		g_once_init_leave (&synapse_text_origin_type_id__once, synapse_text_origin_type_id);
	}
	return synapse_text_origin_type_id__once;
}

static inline gpointer
synapse_text_match_get_instance_private (SynapseTextMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseTextMatch_private_offset);
}

static gchar*
synapse_text_match_real_get_text (SynapseTextMatch* self)
{
#line 131 "match.vala"
	g_critical ("Type `%s' does not implement abstract method `synapse_text_match_get_text'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 131 "match.vala"
	return NULL;
#line 1615 "match.c"
}

gchar*
synapse_text_match_get_text (SynapseTextMatch* self)
{
	SynapseTextMatchClass* _klass_;
#line 131 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "match.vala"
	_klass_ = SYNAPSE_TEXT_MATCH_GET_CLASS (self);
#line 131 "match.vala"
	if (_klass_->get_text) {
#line 131 "match.vala"
		return _klass_->get_text (self);
#line 1630 "match.c"
	}
#line 131 "match.vala"
	return NULL;
#line 1634 "match.c"
}

SynapseTextMatch*
synapse_text_match_construct (GType object_type)
{
	SynapseTextMatch * self = NULL;
#line 127 "match.vala"
	self = (SynapseTextMatch*) synapse_match_construct (object_type);
#line 127 "match.vala"
	return self;
#line 1645 "match.c"
}

SynapseTextOrigin
synapse_text_match_get_text_origin (SynapseTextMatch* self)
{
	SynapseTextOrigin result;
#line 129 "match.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 129 "match.vala"
	result = self->priv->_text_origin;
#line 129 "match.vala"
	return result;
#line 1658 "match.c"
}

static void
synapse_text_match_set_text_origin (SynapseTextMatch* self,
                                    SynapseTextOrigin value)
{
	SynapseTextOrigin old_value;
#line 129 "match.vala"
	g_return_if_fail (self != NULL);
#line 129 "match.vala"
	old_value = synapse_text_match_get_text_origin (self);
#line 129 "match.vala"
	if (old_value != value) {
#line 129 "match.vala"
		self->priv->_text_origin = value;
#line 129 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_text_match_properties[SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY]);
#line 1676 "match.c"
	}
}

static void
synapse_text_match_class_init (SynapseTextMatchClass * klass,
                               gpointer klass_data)
{
#line 127 "match.vala"
	synapse_text_match_parent_class = g_type_class_peek_parent (klass);
#line 127 "match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseTextMatch_private_offset);
#line 127 "match.vala"
	((SynapseTextMatchClass *) klass)->get_text = (gchar* (*) (SynapseTextMatch*)) synapse_text_match_real_get_text;
#line 127 "match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_text_match_get_property;
#line 127 "match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_text_match_set_property;
#line 127 "match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_text_match_finalize;
#line 127 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY, synapse_text_match_properties[SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY] = g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1698 "match.c"
}

static void
synapse_text_match_instance_init (SynapseTextMatch * self,
                                  gpointer klass)
{
#line 127 "match.vala"
	self->priv = synapse_text_match_get_instance_private (self);
#line 1707 "match.c"
}

static void
synapse_text_match_finalize (GObject * obj)
{
	SynapseTextMatch * self;
#line 127 "match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "match.vala"
	G_OBJECT_CLASS (synapse_text_match_parent_class)->finalize (obj);
#line 1718 "match.c"
}

static GType
synapse_text_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseTextMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_text_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseTextMatch), 0, (GInstanceInitFunc) synapse_text_match_instance_init, NULL };
	GType synapse_text_match_type_id;
	synapse_text_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseTextMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SynapseTextMatch_private_offset = g_type_add_instance_private (synapse_text_match_type_id, sizeof (SynapseTextMatchPrivate));
	return synapse_text_match_type_id;
}

GType
synapse_text_match_get_type (void)
{
	static volatile gsize synapse_text_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_text_match_type_id__once)) {
		GType synapse_text_match_type_id;
		synapse_text_match_type_id = synapse_text_match_get_type_once ();
		g_once_init_leave (&synapse_text_match_type_id__once, synapse_text_match_type_id);
	}
	return synapse_text_match_type_id__once;
}

static void
_vala_synapse_text_match_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	SynapseTextMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "match.vala"
	switch (property_id) {
#line 127 "match.vala"
		case SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY:
#line 127 "match.vala"
		g_value_set_enum (value, synapse_text_match_get_text_origin (self));
#line 127 "match.vala"
		break;
#line 1759 "match.c"
		default:
#line 127 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 127 "match.vala"
		break;
#line 1765 "match.c"
	}
}

static void
_vala_synapse_text_match_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SynapseTextMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_TEXT_MATCH, SynapseTextMatch);
#line 127 "match.vala"
	switch (property_id) {
#line 127 "match.vala"
		case SYNAPSE_TEXT_MATCH_TEXT_ORIGIN_PROPERTY:
#line 127 "match.vala"
		synapse_text_match_set_text_origin (self, g_value_get_enum (value));
#line 127 "match.vala"
		break;
#line 1785 "match.c"
		default:
#line 127 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 127 "match.vala"
		break;
#line 1791 "match.c"
	}
}

static inline gpointer
synapse_search_match_get_instance_private (SynapseSearchMatch* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseSearchMatch_private_offset);
}

void
synapse_search_match_search (SynapseSearchMatch* self,
                             const gchar* query,
                             SynapseQueryFlags flags,
                             SynapseResultSet* dest_result_set,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	SynapseSearchMatchClass* _klass_;
#line 134 "match.vala"
	_klass_ = SYNAPSE_SEARCH_MATCH_GET_CLASS (self);
#line 134 "match.vala"
	if (_klass_->search) {
#line 134 "match.vala"
		_klass_->search (self, query, flags, dest_result_set, cancellable, _callback_, _user_data_);
#line 1817 "match.c"
	}
}

GeeList*
synapse_search_match_search_finish (SynapseSearchMatch* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	SynapseSearchMatchClass* _klass_;
#line 134 "match.vala"
	_klass_ = SYNAPSE_SEARCH_MATCH_GET_CLASS (self);
#line 134 "match.vala"
	if (_klass_->search_finish) {
#line 134 "match.vala"
		return _klass_->search_finish (self, _res_, error);
#line 1833 "match.c"
	}
#line 134 "match.vala"
	return NULL;
#line 1837 "match.c"
}

SynapseSearchMatch*
synapse_search_match_construct (GType object_type)
{
	SynapseSearchMatch * self = NULL;
#line 134 "match.vala"
	self = (SynapseSearchMatch*) synapse_match_construct (object_type);
#line 134 "match.vala"
	return self;
#line 1848 "match.c"
}

SynapseMatch*
synapse_search_match_get_search_source (SynapseSearchMatch* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
#line 136 "match.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "match.vala"
	_tmp0_ = self->priv->_search_source;
#line 136 "match.vala"
	result = _tmp0_;
#line 136 "match.vala"
	return result;
#line 1864 "match.c"
}

void
synapse_search_match_set_search_source (SynapseSearchMatch* self,
                                        SynapseMatch* value)
{
	SynapseMatch* old_value;
#line 136 "match.vala"
	g_return_if_fail (self != NULL);
#line 136 "match.vala"
	old_value = synapse_search_match_get_search_source (self);
#line 136 "match.vala"
	if (old_value != value) {
#line 1878 "match.c"
		SynapseMatch* _tmp0_;
#line 136 "match.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 136 "match.vala"
		_g_object_unref0 (self->priv->_search_source);
#line 136 "match.vala"
		self->priv->_search_source = _tmp0_;
#line 136 "match.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY]);
#line 1888 "match.c"
	}
}

static void
synapse_search_match_class_init (SynapseSearchMatchClass * klass,
                                 gpointer klass_data)
{
#line 134 "match.vala"
	synapse_search_match_parent_class = g_type_class_peek_parent (klass);
#line 134 "match.vala"
	g_type_class_adjust_private_offset (klass, &SynapseSearchMatch_private_offset);
#line 134 "match.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_search_match_get_property;
#line 134 "match.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_search_match_set_property;
#line 134 "match.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_search_match_finalize;
#line 134 "match.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY, synapse_search_match_properties[SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY] = g_param_spec_object ("search-source", "search-source", "search-source", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1908 "match.c"
}

static void
synapse_search_match_synapse_search_provider_interface_init (SynapseSearchProviderIface * iface,
                                                             gpointer iface_data)
{
#line 134 "match.vala"
	synapse_search_match_synapse_search_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 134 "match.vala"
	iface->search = (void (*) (SynapseSearchProvider*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_search_match_search;
#line 134 "match.vala"
	iface->search_finish = (GeeList* (*) (SynapseSearchProvider*, GAsyncResult*, GError**)) synapse_search_match_search_finish;
#line 1921 "match.c"
}

static void
synapse_search_match_instance_init (SynapseSearchMatch * self,
                                    gpointer klass)
{
#line 134 "match.vala"
	self->priv = synapse_search_match_get_instance_private (self);
#line 1930 "match.c"
}

static void
synapse_search_match_finalize (GObject * obj)
{
	SynapseSearchMatch * self;
#line 134 "match.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 136 "match.vala"
	_g_object_unref0 (self->priv->_search_source);
#line 134 "match.vala"
	G_OBJECT_CLASS (synapse_search_match_parent_class)->finalize (obj);
#line 1943 "match.c"
}

static GType
synapse_search_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseSearchMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_search_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseSearchMatch), 0, (GInstanceInitFunc) synapse_search_match_instance_init, NULL };
	static const GInterfaceInfo synapse_search_provider_info = { (GInterfaceInitFunc) synapse_search_match_synapse_search_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_search_match_type_id;
	synapse_search_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseSearchMatch", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (synapse_search_match_type_id, SYNAPSE_TYPE_SEARCH_PROVIDER, &synapse_search_provider_info);
	SynapseSearchMatch_private_offset = g_type_add_instance_private (synapse_search_match_type_id, sizeof (SynapseSearchMatchPrivate));
	return synapse_search_match_type_id;
}

GType
synapse_search_match_get_type (void)
{
	static volatile gsize synapse_search_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_search_match_type_id__once)) {
		GType synapse_search_match_type_id;
		synapse_search_match_type_id = synapse_search_match_get_type_once ();
		g_once_init_leave (&synapse_search_match_type_id__once, synapse_search_match_type_id);
	}
	return synapse_search_match_type_id__once;
}

static void
_vala_synapse_search_match_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SynapseSearchMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 134 "match.vala"
	switch (property_id) {
#line 134 "match.vala"
		case SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY:
#line 134 "match.vala"
		g_value_set_object (value, synapse_search_match_get_search_source (self));
#line 134 "match.vala"
		break;
#line 1986 "match.c"
		default:
#line 134 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 134 "match.vala"
		break;
#line 1992 "match.c"
	}
}

static void
_vala_synapse_search_match_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SynapseSearchMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_SEARCH_MATCH, SynapseSearchMatch);
#line 134 "match.vala"
	switch (property_id) {
#line 134 "match.vala"
		case SYNAPSE_SEARCH_MATCH_SEARCH_SOURCE_PROPERTY:
#line 134 "match.vala"
		synapse_search_match_set_search_source (self, g_value_get_object (value));
#line 134 "match.vala"
		break;
#line 2012 "match.c"
		default:
#line 134 "match.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 134 "match.vala"
		break;
#line 2018 "match.c"
	}
}

SynapseUnknownMatch*
synapse_unknown_match_construct (GType object_type,
                                 const gchar* query_string)
{
	SynapseUnknownMatch * self = NULL;
#line 143 "match.vala"
	g_return_val_if_fail (query_string != NULL, NULL);
#line 145 "match.vala"
	self = (SynapseUnknownMatch*) g_object_new (object_type, "title", query_string, "description", "", "has-thumbnail", FALSE, "icon-name", "unknown", NULL);
#line 143 "match.vala"
	return self;
#line 2033 "match.c"
}

SynapseUnknownMatch*
synapse_unknown_match_new (const gchar* query_string)
{
#line 143 "match.vala"
	return synapse_unknown_match_construct (SYNAPSE_TYPE_UNKNOWN_MATCH, query_string);
#line 2041 "match.c"
}

static void
synapse_unknown_match_class_init (SynapseUnknownMatchClass * klass,
                                  gpointer klass_data)
{
#line 141 "match.vala"
	synapse_unknown_match_parent_class = g_type_class_peek_parent (klass);
#line 2050 "match.c"
}

static void
synapse_unknown_match_instance_init (SynapseUnknownMatch * self,
                                     gpointer klass)
{
}

static GType
synapse_unknown_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseUnknownMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_unknown_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseUnknownMatch), 0, (GInstanceInitFunc) synapse_unknown_match_instance_init, NULL };
	GType synapse_unknown_match_type_id;
	synapse_unknown_match_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseUnknownMatch", &g_define_type_info, 0);
	return synapse_unknown_match_type_id;
}

GType
synapse_unknown_match_get_type (void)
{
	static volatile gsize synapse_unknown_match_type_id__once = 0;
	if (g_once_init_enter (&synapse_unknown_match_type_id__once)) {
		GType synapse_unknown_match_type_id;
		synapse_unknown_match_type_id = synapse_unknown_match_get_type_once ();
		g_once_init_leave (&synapse_unknown_match_type_id__once, synapse_unknown_match_type_id);
	}
	return synapse_unknown_match_type_id__once;
}

