/* ControlPage.c generated by valac 0.56.17, the Vala compiler
 * generated from ControlPage.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2015 Adam Bieńkowski
 */

#include "screentime-limits.h"
#include <act/act.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PC_WIDGETS_CONTROL_PAGE_0_PROPERTY,
	PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY,
	PC_WIDGETS_CONTROL_PAGE_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_control_page_properties[PC_WIDGETS_CONTROL_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PcWidgetsControlPageGetActiveData PcWidgetsControlPageGetActiveData;

struct _PCWidgetsControlPagePrivate {
	ActUser* _user;
	PCWidgetsTimeLimitView* time_limit_view;
	PCWidgetsAppsBox* apps_box;
};

struct _PcWidgetsControlPageGetActiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PCWidgetsControlPage* self;
	gboolean result;
	gboolean _tmp0_;
	PCIParentalControls* _tmp1_;
	ActUser* _tmp2_;
	const gchar* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

static gint PCWidgetsControlPage_private_offset;
static gpointer pc_widgets_control_page_parent_class = NULL;

static void pc_widgets_control_page_set_active (PCWidgetsControlPage* self,
                                         gboolean active);
static void pc_widgets_control_page_get_active_data_free (gpointer _data);
static void pc_widgets_control_page_get_active (PCWidgetsControlPage* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean pc_widgets_control_page_get_active_finish (PCWidgetsControlPage* self,
                                                    GAsyncResult* _res_);
static gboolean pc_widgets_control_page_get_active_co (PcWidgetsControlPageGetActiveData* _data_);
static void pc_widgets_control_page_get_active_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static GObject * pc_widgets_control_page_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _pc_widgets_control_page___lambda18_ (PCWidgetsControlPage* self);
static void __pc_widgets_control_page___lambda18__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _pc_widgets_control_page___lambda19_ (PCWidgetsControlPage* self,
                                           GObject* obj,
                                           GAsyncResult* res);
static void __pc_widgets_control_page___lambda19__gasync_ready_callback (GObject* source_object,
                                                                  GAsyncResult* res,
                                                                  gpointer self);
static void _pc_widgets_control_page___lambda20_ (PCWidgetsControlPage* self);
static void __lambda21_ (PCWidgetsControlPage* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda21__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __pc_widgets_control_page___lambda20__act_user_changed (ActUser* _sender,
                                                             gpointer self);
static void pc_widgets_control_page_finalize (GObject * obj);
static GType pc_widgets_control_page_get_type_once (void);
static void _vala_pc_widgets_control_page_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_pc_widgets_control_page_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
pc_widgets_control_page_get_instance_private (PCWidgetsControlPage* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsControlPage_private_offset);
}

PCWidgetsControlPage*
pc_widgets_control_page_construct (GType object_type,
                                   ActUser* user)
{
	PCWidgetsControlPage * self = NULL;
	gchar* header = NULL;
	gchar* _tmp0_;
	gchar* description = NULL;
	gchar* _tmp1_;
	ActUser* _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_val_if_fail (user != NULL, NULL);
	_tmp0_ = g_strdup (_ ("Other Accounts"));
	header = _tmp0_;
	_tmp1_ = g_strdup (_ ("Supervise and manage device usage with limits on Screen Time, websites" \
", and apps. Some limits may be bypassed with an administrator's permis" \
"sion."));
	description = _tmp1_;
	_tmp2_ = pc_utils_get_current_user ();
	if (_tmp2_ == user) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup (_ ("My Account"));
		_g_free0 (header);
		header = _tmp3_;
		_tmp4_ = g_strdup (_ ("Manage your own device usage by setting limits on Screen Time, website" \
"s, and apps."));
		_g_free0 (description);
		description = _tmp4_;
	}
	_tmp5_ = description;
	_tmp6_ = header;
	_tmp7_ = act_user_get_real_name (user);
	self = (PCWidgetsControlPage*) g_object_new (object_type, "activatable", TRUE, "description", _tmp5_, "header", _tmp6_, "title", _tmp7_, "with-avatar", TRUE, "user", user, NULL);
	_g_free0 (description);
	_g_free0 (header);
	return self;
}

PCWidgetsControlPage*
pc_widgets_control_page_new (ActUser* user)
{
	return pc_widgets_control_page_construct (PC_WIDGETS_TYPE_CONTROL_PAGE, user);
}

static void
pc_widgets_control_page_set_active (PCWidgetsControlPage* self,
                                    gboolean active)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_utils_get_permission ();
	permission = _tmp0_;
	_tmp1_ = permission;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		PCIParentalControls* _tmp4_;
		ActUser* _tmp5_;
		const gchar* _tmp6_;
		PCWidgetsAppsBox* _tmp7_;
		PCWidgetsTimeLimitView* _tmp8_;
		_tmp4_ = pc_utils_get_api ();
		_tmp5_ = self->priv->_user;
		_tmp6_ = act_user_get_user_name (_tmp5_);
		pc_iparental_controls_set_user_daemon_active (_tmp4_, _tmp6_, active, NULL, NULL);
		_tmp7_ = self->priv->apps_box;
		pc_widgets_apps_box_set_restrictions_active (_tmp7_, active);
		_tmp8_ = self->priv->time_limit_view;
		pc_widgets_time_limit_view_update_pam (_tmp8_, active);
	}
}

static void
pc_widgets_control_page_get_active_data_free (gpointer _data)
{
	PcWidgetsControlPageGetActiveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PcWidgetsControlPageGetActiveData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pc_widgets_control_page_get_active (PCWidgetsControlPage* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	PcWidgetsControlPageGetActiveData* _data_;
	PCWidgetsControlPage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PcWidgetsControlPageGetActiveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pc_widgets_control_page_get_active_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pc_widgets_control_page_get_active_co (_data_);
}

static gboolean
pc_widgets_control_page_get_active_finish (PCWidgetsControlPage* self,
                                           GAsyncResult* _res_)
{
	gboolean result;
	PcWidgetsControlPageGetActiveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
pc_widgets_control_page_get_active_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	PcWidgetsControlPageGetActiveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pc_widgets_control_page_get_active_co (_data_);
}

static gboolean
pc_widgets_control_page_get_active_co (PcWidgetsControlPageGetActiveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = pc_utils_get_api ();
		_data_->_tmp2_ = _data_->self->priv->_user;
		_data_->_tmp3_ = act_user_get_user_name (_data_->_tmp2_);
		_data_->_state_ = 1;
		pc_iparental_controls_get_user_daemon_active (_data_->_tmp1_, _data_->_tmp3_, pc_widgets_control_page_get_active_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = pc_iparental_controls_get_user_daemon_active_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = _data_->_tmp0_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("ControlPage.vala:114: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
pc_widgets_control_page_update_user (PCWidgetsControlPage* self)
{
	ActUser* _tmp0_;
	const gchar* _tmp1_;
	ActUser* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = act_user_get_real_name (_tmp0_);
	switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp1_);
	_tmp2_ = self->priv->_user;
	_tmp3_ = act_user_get_user_name (_tmp2_);
	switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp3_);
	{
		GdkTexture* _tmp4_ = NULL;
		ActUser* _tmp5_;
		const gchar* _tmp6_;
		GdkTexture* _tmp7_;
		_tmp5_ = self->priv->_user;
		_tmp6_ = act_user_get_icon_file (_tmp5_);
		_tmp7_ = gdk_texture_new_from_filename (_tmp6_, &_inner_error0_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		switchboard_settings_page_set_avatar_paintable ((SwitchboardSettingsPage*) self, (GdkPaintable*) _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("ControlPage.vala:127: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

ActUser*
pc_widgets_control_page_get_user (PCWidgetsControlPage* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_control_page_set_user (PCWidgetsControlPage* self,
                                  ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_control_page_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_control_page_properties[PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY]);
	}
}

static void
_pc_widgets_control_page___lambda18_ (PCWidgetsControlPage* self)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	pc_widgets_control_page_set_active (self, _tmp3_);
}

static void
__pc_widgets_control_page___lambda18__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_pc_widgets_control_page___lambda18_ ((PCWidgetsControlPage*) self);
}

static void
_pc_widgets_control_page___lambda19_ (PCWidgetsControlPage* self,
                                      GObject* obj,
                                      GAsyncResult* res)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	gtk_switch_set_active (_tmp1_, pc_widgets_control_page_get_active_finish (self, res));
}

static void
__pc_widgets_control_page___lambda19__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self)
{
	_pc_widgets_control_page___lambda19_ ((PCWidgetsControlPage*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda21_ (PCWidgetsControlPage* self,
             GObject* obj,
             GAsyncResult* res)
{
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	gtk_switch_set_active (_tmp1_, pc_widgets_control_page_get_active_finish (self, res));
}

static void
___lambda21__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda21_ ((PCWidgetsControlPage*) self, source_object, res);
	g_object_unref (self);
}

static void
_pc_widgets_control_page___lambda20_ (PCWidgetsControlPage* self)
{
	pc_widgets_control_page_get_active (self, ___lambda21__gasync_ready_callback, g_object_ref (self));
}

static void
__pc_widgets_control_page___lambda20__act_user_changed (ActUser* _sender,
                                                        gpointer self)
{
	_pc_widgets_control_page___lambda20_ ((PCWidgetsControlPage*) self);
}

static GObject *
pc_widgets_control_page_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsControlPage * self;
	ActUser* _tmp0_;
	PCWidgetsTimeLimitView* _tmp1_;
	PCWidgetsInternetBox* internet_box = NULL;
	ActUser* _tmp2_;
	PCWidgetsInternetBox* _tmp3_;
	ActUser* _tmp4_;
	PCWidgetsAppsBox* _tmp5_;
	GtkStack* _tmp6_;
	GtkStack* _tmp7_;
	PCWidgetsTimeLimitView* _tmp8_;
	GtkStack* _tmp9_;
	PCWidgetsInternetBox* _tmp10_;
	GtkStack* _tmp11_;
	PCWidgetsAppsBox* _tmp12_;
	GtkStackSwitcher* switcher = NULL;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GtkStackSwitcher* _tmp15_ = NULL;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp16_;
	GtkWidget* switcher_child = NULL;
	GtkStackSwitcher* _tmp17_;
	GtkWidget* _tmp18_;
	GtkLockButton* lock_button = NULL;
	PolkitPermission* _tmp24_;
	GtkLockButton* _tmp25_;
	GtkLabel* infobar_label = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkInfoBar* infobar = NULL;
	GtkInfoBar* _tmp27_ = NULL;
	GtkInfoBar* _tmp28_;
	GtkInfoBar* _tmp29_;
	GtkLabel* _tmp30_;
	GtkInfoBar* _tmp31_;
	GtkLockButton* _tmp32_;
	GtkBox* box = NULL;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkInfoBar* _tmp35_;
	GtkBox* _tmp36_;
	GtkStackSwitcher* _tmp37_;
	GtkBox* _tmp38_;
	GtkStack* _tmp39_;
	GtkBox* _tmp40_;
	GtkSwitch* _tmp41_;
	GtkSwitch* _tmp42_;
	GtkStack* _tmp43_;
	GtkSwitch* _tmp44_;
	GtkSwitch* _tmp45_;
	ActUser* _tmp46_;
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp47_;
	PolkitPermission* _tmp48_;
	PCWidgetsAppsBox* _tmp49_;
	PolkitPermission* _tmp50_;
	GtkInfoBar* _tmp51_;
	PolkitPermission* _tmp52_;
	PCWidgetsInternetBox* _tmp53_;
	PolkitPermission* _tmp54_;
	GtkSwitch* _tmp55_;
	GtkSwitch* _tmp56_;
	PolkitPermission* _tmp57_;
	PCWidgetsTimeLimitView* _tmp58_;
	parent_class = G_OBJECT_CLASS (pc_widgets_control_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_CONTROL_PAGE, PCWidgetsControlPage);
	_tmp0_ = self->priv->_user;
	_tmp1_ = pc_widgets_time_limit_view_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->time_limit_view);
	self->priv->time_limit_view = _tmp1_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = pc_widgets_internet_box_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	internet_box = _tmp3_;
	_tmp4_ = self->priv->_user;
	_tmp5_ = pc_widgets_apps_box_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->apps_box);
	self->priv->apps_box = _tmp5_;
	_tmp6_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->stack);
	self->stack = _tmp6_;
	_tmp7_ = self->stack;
	_tmp8_ = self->priv->time_limit_view;
	gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, "general", _ ("Screen Time"));
	_tmp9_ = self->stack;
	_tmp10_ = internet_box;
	gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, "internet", _ ("Internet"));
	_tmp11_ = self->stack;
	_tmp12_ = self->priv->apps_box;
	gtk_stack_add_titled (_tmp11_, (GtkWidget*) _tmp12_, "apps", _ ("Applications"));
	_tmp13_ = self->stack;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp15_, 12);
	gtk_stack_switcher_set_stack (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	switcher = _tmp15_;
	_tmp16_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp16_;
	_tmp17_ = switcher;
	_tmp18_ = gtk_widget_get_first_child ((GtkWidget*) _tmp17_);
	switcher_child = _tmp18_;
	while (TRUE) {
		GtkWidget* _tmp19_;
		GtkSizeGroup* _tmp20_;
		GtkWidget* _tmp21_;
		GtkWidget* _tmp22_;
		GtkWidget* _tmp23_;
		_tmp19_ = switcher_child;
		if (!(_tmp19_ != NULL)) {
			break;
		}
		_tmp20_ = size_group;
		_tmp21_ = switcher_child;
		gtk_size_group_add_widget (_tmp20_, _tmp21_);
		_tmp22_ = switcher_child;
		_tmp23_ = gtk_widget_get_next_sibling (_tmp22_);
		switcher_child = _tmp23_;
	}
	_tmp24_ = pc_utils_get_permission ();
	_tmp25_ = (GtkLockButton*) gtk_lock_button_new ((GPermission*) _tmp24_);
	g_object_ref_sink (_tmp25_);
	lock_button = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Some settings require administrator rights to be changed"));
	gtk_label_set_wrap (_tmp26_, TRUE);
	g_object_ref_sink (_tmp26_);
	infobar_label = _tmp26_;
	_tmp27_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp27_, 9);
	g_object_ref_sink (_tmp27_);
	infobar = _tmp27_;
	_tmp28_ = infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, GRANITE_STYLE_CLASS_FRAME);
	_tmp29_ = infobar;
	_tmp30_ = infobar_label;
	gtk_info_bar_add_child (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = infobar;
	_tmp32_ = lock_button;
	gtk_info_bar_add_action_widget (_tmp31_, (GtkWidget*) _tmp32_, 1);
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp33_);
	box = _tmp33_;
	_tmp34_ = box;
	_tmp35_ = infobar;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = box;
	_tmp37_ = switcher;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = box;
	_tmp39_ = self->stack;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp40_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp41_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->stack;
	g_object_bind_property_with_closures ((GObject*) _tmp42_, "active", (GObject*) _tmp43_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp44_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp45_ = _tmp44_;
	g_signal_connect_object ((GObject*) _tmp45_, "notify::active", (GCallback) __pc_widgets_control_page___lambda18__g_object_notify, self, 0);
	pc_widgets_control_page_get_active (self, __pc_widgets_control_page___lambda19__gasync_ready_callback, g_object_ref (self));
	_tmp46_ = self->priv->_user;
	g_signal_connect_object (_tmp46_, "changed", (GCallback) __pc_widgets_control_page___lambda20__act_user_changed, self, 0);
	_tmp47_ = pc_utils_get_permission ();
	permission = _tmp47_;
	_tmp48_ = permission;
	_tmp49_ = self->priv->apps_box;
	g_object_bind_property_with_closures ((GObject*) _tmp48_, "allowed", (GObject*) _tmp49_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp50_ = permission;
	_tmp51_ = infobar;
	g_object_bind_property_with_closures ((GObject*) _tmp50_, "allowed", (GObject*) _tmp51_, "revealed", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp52_ = permission;
	_tmp53_ = internet_box;
	g_object_bind_property_with_closures ((GObject*) _tmp52_, "allowed", (GObject*) _tmp53_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp54_ = permission;
	_tmp55_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp56_ = _tmp55_;
	g_object_bind_property_with_closures ((GObject*) _tmp54_, "allowed", (GObject*) _tmp56_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp57_ = permission;
	_tmp58_ = self->priv->time_limit_view;
	g_object_bind_property_with_closures ((GObject*) _tmp57_, "allowed", (GObject*) _tmp58_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	pc_widgets_control_page_update_user (self);
	_g_object_unref0 (box);
	_g_object_unref0 (infobar);
	_g_object_unref0 (infobar_label);
	_g_object_unref0 (lock_button);
	_g_object_unref0 (size_group);
	_g_object_unref0 (switcher);
	_g_object_unref0 (internet_box);
	return obj;
}

static void
pc_widgets_control_page_class_init (PCWidgetsControlPageClass * klass,
                                    gpointer klass_data)
{
	pc_widgets_control_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsControlPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_control_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_control_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_control_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_control_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY, pc_widgets_control_page_properties[PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pc_widgets_control_page_instance_init (PCWidgetsControlPage * self,
                                       gpointer klass)
{
	self->priv = pc_widgets_control_page_get_instance_private (self);
}

static void
pc_widgets_control_page_finalize (GObject * obj)
{
	PCWidgetsControlPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_CONTROL_PAGE, PCWidgetsControlPage);
	_g_object_unref0 (self->stack);
	_g_object_unref0 (self->priv->time_limit_view);
	_g_object_unref0 (self->priv->apps_box);
	G_OBJECT_CLASS (pc_widgets_control_page_parent_class)->finalize (obj);
}

static GType
pc_widgets_control_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsControlPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_control_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsControlPage), 0, (GInstanceInitFunc) pc_widgets_control_page_instance_init, NULL };
	GType pc_widgets_control_page_type_id;
	pc_widgets_control_page_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PCWidgetsControlPage", &g_define_type_info, 0);
	PCWidgetsControlPage_private_offset = g_type_add_instance_private (pc_widgets_control_page_type_id, sizeof (PCWidgetsControlPagePrivate));
	return pc_widgets_control_page_type_id;
}

GType
pc_widgets_control_page_get_type (void)
{
	static volatile gsize pc_widgets_control_page_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_control_page_type_id__once)) {
		GType pc_widgets_control_page_type_id;
		pc_widgets_control_page_type_id = pc_widgets_control_page_get_type_once ();
		g_once_init_leave (&pc_widgets_control_page_type_id__once, pc_widgets_control_page_type_id);
	}
	return pc_widgets_control_page_type_id__once;
}

static void
_vala_pc_widgets_control_page_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	PCWidgetsControlPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_CONTROL_PAGE, PCWidgetsControlPage);
	switch (property_id) {
		case PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY:
		g_value_set_object (value, pc_widgets_control_page_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_control_page_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	PCWidgetsControlPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_CONTROL_PAGE, PCWidgetsControlPage);
	switch (property_id) {
		case PC_WIDGETS_CONTROL_PAGE_USER_PROPERTY:
		pc_widgets_control_page_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

