/* AppsView.c generated by valac 0.56.17, the Vala compiler
 * generated from AppsView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2015 Adam Bieńkowski
 */

#include "screentime-limits.h"
#include <glib.h>
#include <act/act.h>
#include <gtk/gtk.h>
#include <libmalcontent/malcontent.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <polkit/polkit.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PC_WIDGETS_APPS_BOX_0_PROPERTY,
	PC_WIDGETS_APPS_BOX_USER_PROPERTY,
	PC_WIDGETS_APPS_BOX_NUM_PROPERTIES
};
static GParamSpec* pc_widgets_apps_box_properties[PC_WIDGETS_APPS_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _mct_app_filter_unref0(var) ((var == NULL) ? NULL : (var = (mct_app_filter_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_MctAppFilterBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_MctAppFilterBuilder_free (var), NULL)))
typedef struct _PcWidgetsAppsBoxLoadExistingData PcWidgetsAppsBoxLoadExistingData;

struct _PCWidgetsAppsBoxPrivate {
	GList* entries;
	ActUser* _user;
	GtkListBox* list_box;
	PCWidgetsAppChooser* apps_dialog;
	GtkSwitch* admin_switch_btn;
	GtkButton* clear_button;
	MctManager* malcontent;
};

struct _Block2Data {
	int _ref_count_;
	PCWidgetsAppsBox* self;
	PCWidgetsAppRow* entry;
};

struct _PcWidgetsAppsBoxLoadExistingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PCWidgetsAppsBox* self;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	MctManager* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	MctAppFilter* app_filter;
	MctManager* _tmp5_;
	MctAppFilter* _tmp6_;
	MctManager* _tmp7_;
	ActUser* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	MctAppFilter* _tmp11_;
	MctAppFilter* _tmp12_;
	GError* _vala1_e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	gchar** targets;
	PCIParentalControls* _tmp15_;
	ActUser* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gchar** _tmp19_;
	gint targets_length1;
	gint _targets_size_;
	gboolean admin;
	PCIParentalControls* _tmp20_;
	ActUser* _tmp21_;
	const gchar* _tmp22_;
	GtkSwitch* _tmp23_;
	GList* infos;
	GList* _tmp24_;
	GList* _tmp25_;
	GList* info_collection;
	GList* info_it;
	GAppInfo* info;
	GDesktopAppInfo* desktop_app;
	GAppInfo* _tmp26_;
	GDesktopAppInfo* _tmp27_;
	gboolean _tmp28_;
	MctAppFilter* _tmp29_;
	MctAppFilter* _tmp30_;
	GDesktopAppInfo* _tmp31_;
	GAppInfo* _tmp32_;
	gboolean _tmp33_;
	GAppInfo* _tmp34_;
	GAppInfo* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	GAppInfo* _tmp39_;
	GError* _vala2_e;
	GError* _tmp40_;
	const gchar* _tmp41_;
	GError* _inner_error0_;
};

static gint PCWidgetsAppsBox_private_offset;
static gpointer pc_widgets_apps_box_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void pc_widgets_apps_box_on_clear_button_clicked (PCWidgetsAppsBox* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ____lambda13_ (Block2Data* _data2_);
static gboolean _____lambda13__gsource_func (gpointer self);
static void pc_widgets_apps_box_load_info (PCWidgetsAppsBox* self,
                                    GAppInfo* info);
static gboolean pc_widgets_apps_box_get_info_loaded (PCWidgetsAppsBox* self,
                                              GAppInfo* info);
static void pc_widgets_apps_box_on_deleted (PCWidgetsAppsBox* self,
                                     PCWidgetsAppRow* row);
static void _pc_widgets_apps_box_on_deleted_pc_widgets_app_row_deleted (PCWidgetsAppRow* _sender,
                                                                 gpointer self);
static void pc_widgets_apps_box_update_targets (PCWidgetsAppsBox* self);
static void pc_widgets_apps_box_update_admin (PCWidgetsAppsBox* self);
static void pc_widgets_apps_box_update_sensitivity (PCWidgetsAppsBox* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_MctAppFilterBuilder_free (MctAppFilterBuilder* self);
static void pc_widgets_apps_box_load_existing_data_free (gpointer _data);
static void pc_widgets_apps_box_load_existing (PCWidgetsAppsBox* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void pc_widgets_apps_box_load_existing_finish (PCWidgetsAppsBox* self,
                                               GAsyncResult* _res_);
static gboolean pc_widgets_apps_box_load_existing_co (PcWidgetsAppsBoxLoadExistingData* _data_);
static void pc_widgets_apps_box_load_existing_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static GObject * pc_widgets_apps_box_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _pc_widgets_apps_box_on_clear_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _pc_widgets_apps_box_load_info_pc_widgets_app_chooser_app_chosen (PCWidgetsAppChooser* _sender,
                                                                       GAppInfo* info,
                                                                       gpointer self);
static void _pc_widgets_apps_box_update_admin_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _gtk_window_present_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self);
static void pc_widgets_apps_box_finalize (GObject * obj);
static GType pc_widgets_apps_box_get_type_once (void);
static void _vala_pc_widgets_apps_box_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_pc_widgets_apps_box_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pc_widgets_apps_box_get_instance_private (PCWidgetsAppsBox* self)
{
	return G_STRUCT_MEMBER_P (self, PCWidgetsAppsBox_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

PCWidgetsAppsBox*
pc_widgets_apps_box_construct (GType object_type,
                               ActUser* user)
{
	PCWidgetsAppsBox * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (PCWidgetsAppsBox*) g_object_new (object_type, "user", user, NULL);
	return self;
}

PCWidgetsAppsBox*
pc_widgets_apps_box_new (ActUser* user)
{
	return pc_widgets_apps_box_construct (PC_WIDGETS_TYPE_APPS_BOX, user);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PCWidgetsAppsBox* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
____lambda13_ (Block2Data* _data2_)
{
	PCWidgetsAppsBox* self;
	PCWidgetsAppRow* _tmp0_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = _data2_->entry;
	g_signal_emit_by_name (_tmp0_, "deleted");
	result = FALSE;
	return result;
}

static gboolean
_____lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda13_ (self);
	return result;
}

static void
pc_widgets_apps_box_on_clear_button_clicked (PCWidgetsAppsBox* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PCWidgetsAppRow* entry = NULL;
			entry = (PCWidgetsAppRow*) entry_it->data;
			{
				Block2Data* _data2_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				_data2_->entry = entry;
				g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda13__gsource_func, block2_data_ref (_data2_), block2_data_unref);
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
}

static void
_pc_widgets_apps_box_on_deleted_pc_widgets_app_row_deleted (PCWidgetsAppRow* _sender,
                                                            gpointer self)
{
	pc_widgets_apps_box_on_deleted ((PCWidgetsAppsBox*) self, _sender);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pc_widgets_apps_box_load_info (PCWidgetsAppsBox* self,
                               GAppInfo* info)
{
	PCWidgetsAppRow* row = NULL;
	PCWidgetsAppRow* _tmp0_;
	PCWidgetsAppRow* _tmp1_;
	PCWidgetsAppRow* _tmp2_;
	PCWidgetsAppRow* _tmp3_;
	GtkListBox* _tmp4_;
	PCWidgetsAppRow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	if (pc_widgets_apps_box_get_info_loaded (self, info)) {
		return;
	}
	_tmp0_ = pc_widgets_app_row_new_with_delete_button (info);
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	_tmp1_ = row;
	g_signal_connect_object (_tmp1_, "deleted", (GCallback) _pc_widgets_apps_box_on_deleted_pc_widgets_app_row_deleted, self, 0);
	_tmp2_ = row;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	self->priv->entries = g_list_append (self->priv->entries, _tmp3_);
	_tmp4_ = self->priv->list_box;
	_tmp5_ = row;
	gtk_list_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	pc_widgets_apps_box_update_targets (self);
	_g_object_unref0 (row);
}

static gboolean
pc_widgets_apps_box_get_info_loaded (PCWidgetsAppsBox* self,
                                     GAppInfo* info)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp0_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PCWidgetsAppRow* _tmp1_;
			PCWidgetsAppRow* entry = NULL;
			_tmp1_ = _g_object_ref0 ((PCWidgetsAppRow*) entry_it->data);
			entry = _tmp1_;
			{
				PCWidgetsAppRow* _tmp2_;
				GAppInfo* _tmp3_;
				GAppInfo* _tmp4_;
				_tmp2_ = entry;
				_tmp3_ = pc_widgets_app_row_get_app_info (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_app_info_equal (_tmp4_, info)) {
					result = TRUE;
					_g_object_unref0 (entry);
					return result;
				}
				_g_object_unref0 (entry);
			}
		}
	}
	result = FALSE;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
pc_widgets_apps_box_on_deleted (PCWidgetsAppsBox* self,
                                PCWidgetsAppRow* row)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	self->priv->entries = vala_g_list_remove_full (self->priv->entries, row, _g_object_unref0_);
	_tmp0_ = self->priv->list_box;
	gtk_list_box_remove (_tmp0_, (GtkWidget*) row);
	g_signal_emit_by_name ((GtkWidget*) row, "destroy");
	pc_widgets_apps_box_update_targets (self);
}

static void
pc_widgets_apps_box_update_admin (PCWidgetsAppsBox* self)
{
	PolkitPermission* _tmp0_;
	g_return_if_fail (self != NULL);
	pc_widgets_apps_box_update_sensitivity (self);
	_tmp0_ = pc_utils_get_permission ();
	if (g_permission_get_allowed ((GPermission*) _tmp0_)) {
		PCIParentalControls* _tmp1_;
		ActUser* _tmp2_;
		const gchar* _tmp3_;
		GtkSwitch* _tmp4_;
		_tmp1_ = pc_utils_get_api ();
		_tmp2_ = self->priv->_user;
		_tmp3_ = act_user_get_user_name (_tmp2_);
		_tmp4_ = self->priv->admin_switch_btn;
		pc_iparental_controls_set_user_daemon_admin (_tmp1_, _tmp3_, gtk_switch_get_active (_tmp4_), NULL, NULL);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_MctAppFilterBuilder_free (MctAppFilterBuilder* self)
{
	g_boxed_free (mct_app_filter_builder_get_type (), self);
}

static void
pc_widgets_apps_box_update_targets (PCWidgetsAppsBox* self)
{
	PolkitPermission* _tmp0_;
	gchar** targets = NULL;
	gchar** _tmp1_;
	gint targets_length1;
	gint _targets_size_;
	MctAppFilterBuilder* app_filter_builder = NULL;
	MctAppFilterBuilder* _tmp2_;
	GList* _tmp3_;
	MctManager* _tmp18_;
	PCIParentalControls* _tmp28_;
	ActUser* _tmp29_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	pc_widgets_apps_box_update_sensitivity (self);
	_tmp0_ = pc_utils_get_permission ();
	if (!g_permission_get_allowed ((GPermission*) _tmp0_)) {
		return;
	}
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	targets = _tmp1_;
	targets_length1 = 0;
	_targets_size_ = targets_length1;
	_tmp2_ = mct_app_filter_builder_new ();
	app_filter_builder = _tmp2_;
	_tmp3_ = self->priv->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp3_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			PCWidgetsAppRow* _tmp4_;
			PCWidgetsAppRow* entry = NULL;
			_tmp4_ = _g_object_ref0 ((PCWidgetsAppRow*) entry_it->data);
			entry = _tmp4_;
			{
				PCWidgetsAppRow* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				_tmp5_ = entry;
				_tmp6_ = pc_widgets_app_row_get_is_flatpak (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_) {
					gchar* flatpak_ref = NULL;
					PCWidgetsAppRow* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp8_ = entry;
					_tmp9_ = pc_widgets_app_row_get_flatpak_ref (_tmp8_);
					_tmp10_ = _tmp9_;
					flatpak_ref = _tmp10_;
					_tmp11_ = flatpak_ref;
					if (_tmp11_ != NULL) {
						MctAppFilterBuilder* _tmp12_;
						const gchar* _tmp13_;
						_tmp12_ = app_filter_builder;
						_tmp13_ = flatpak_ref;
						mct_app_filter_builder_blocklist_flatpak_ref (_tmp12_, _tmp13_);
					}
					_g_free0 (flatpak_ref);
				} else {
					PCWidgetsAppRow* _tmp14_;
					GAppInfo* _tmp15_;
					GAppInfo* _tmp16_;
					gchar* _tmp17_;
					_tmp14_ = entry;
					_tmp15_ = pc_widgets_app_row_get_app_info (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = pc_utils_info_to_exec_path (_tmp16_, NULL, (gint) 0);
					_vala_array_add1 (&targets, &targets_length1, &_targets_size_, _tmp17_);
				}
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp18_ = self->priv->malcontent;
	if (_tmp18_ != NULL) {
		{
			MctManager* _tmp19_;
			ActUser* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			MctAppFilterBuilder* _tmp23_;
			MctAppFilter* _tmp24_;
			MctAppFilter* _tmp25_;
			_tmp19_ = self->priv->malcontent;
			_tmp20_ = self->priv->_user;
			_tmp21_ = act_user_get_uid (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = app_filter_builder;
			_tmp24_ = mct_app_filter_builder_end (_tmp23_);
			_tmp25_ = _tmp24_;
			mct_manager_set_app_filter (_tmp19_, (guint) _tmp22_, _tmp25_, MCT_MANAGER_SET_VALUE_FLAGS_NONE, NULL, &_inner_error0_);
			_mct_app_filter_unref0 (_tmp25_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("AppsView.vala:170: Failed to set malcontent app filter: %s", _tmp27_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_MctAppFilterBuilder_free0 (app_filter_builder);
			targets = (_vala_array_free (targets, targets_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp28_ = pc_utils_get_api ();
	_tmp29_ = self->priv->_user;
	_tmp30_ = act_user_get_user_name (_tmp29_);
	_tmp31_ = targets;
	_tmp31__length1 = targets_length1;
	pc_iparental_controls_set_user_daemon_targets (_tmp28_, _tmp30_, _tmp31_, (gint) _tmp31__length1, NULL, NULL);
	__vala_MctAppFilterBuilder_free0 (app_filter_builder);
	targets = (_vala_array_free (targets, targets_length1, (GDestroyNotify) g_free), NULL);
}

static void
pc_widgets_apps_box_update_sensitivity (PCWidgetsAppsBox* self)
{
	GtkButton* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clear_button;
	_tmp1_ = self->priv->entries;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, g_list_length (_tmp1_) > ((guint) 0));
}

void
pc_widgets_apps_box_set_restrictions_active (PCWidgetsAppsBox* self,
                                             gboolean active)
{
	MctManager* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->malcontent;
	if (_tmp0_ == NULL) {
		return;
	}
	if (!active) {
		MctAppFilterBuilder* app_filter_builder = NULL;
		MctAppFilterBuilder* _tmp1_;
		_tmp1_ = mct_app_filter_builder_new ();
		app_filter_builder = _tmp1_;
		{
			MctManager* _tmp2_;
			ActUser* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			MctAppFilterBuilder* _tmp6_;
			MctAppFilter* _tmp7_;
			MctAppFilter* _tmp8_;
			_tmp2_ = self->priv->malcontent;
			_tmp3_ = self->priv->_user;
			_tmp4_ = act_user_get_uid (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = app_filter_builder;
			_tmp7_ = mct_app_filter_builder_end (_tmp6_);
			_tmp8_ = _tmp7_;
			mct_manager_set_app_filter (_tmp2_, (guint) _tmp5_, _tmp8_, MCT_MANAGER_SET_VALUE_FLAGS_NONE, NULL, &_inner_error0_);
			_mct_app_filter_unref0 (_tmp8_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("AppsView.vala:192: Failed to set malcontent app filter: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_MctAppFilterBuilder_free0 (app_filter_builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		__vala_MctAppFilterBuilder_free0 (app_filter_builder);
	} else {
		pc_widgets_apps_box_update_targets (self);
	}
}

static void
pc_widgets_apps_box_load_existing_data_free (gpointer _data)
{
	PcWidgetsAppsBoxLoadExistingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PcWidgetsAppsBoxLoadExistingData, _data_);
}

static void
pc_widgets_apps_box_load_existing (PCWidgetsAppsBox* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PcWidgetsAppsBoxLoadExistingData* _data_;
	PCWidgetsAppsBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PcWidgetsAppsBoxLoadExistingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pc_widgets_apps_box_load_existing_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pc_widgets_apps_box_load_existing_co (_data_);
}

static void
pc_widgets_apps_box_load_existing_finish (PCWidgetsAppsBox* self,
                                          GAsyncResult* _res_)
{
	PcWidgetsAppsBoxLoadExistingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pc_widgets_apps_box_load_existing_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PcWidgetsAppsBoxLoadExistingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pc_widgets_apps_box_load_existing_co (_data_);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
pc_widgets_apps_box_load_existing_co (PcWidgetsAppsBoxLoadExistingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SYSTEM, NULL, pc_widgets_apps_box_load_existing_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = mct_manager_new (_data_->_tmp0_);
		_g_object_unref0 (_data_->self->priv->malcontent);
		_data_->self->priv->malcontent = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("AppsView.vala:203: Unable to init malcontent support: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->app_filter = NULL;
	_data_->_tmp5_ = _data_->self->priv->malcontent;
	if (_data_->_tmp5_ != NULL) {
		{
			_data_->_tmp7_ = _data_->self->priv->malcontent;
			_data_->_tmp8_ = _data_->self->priv->_user;
			_data_->_tmp9_ = act_user_get_uid (_data_->_tmp8_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_data_->_state_ = 2;
			mct_manager_get_app_filter_async (_data_->_tmp7_, (guint) _data_->_tmp10_, MCT_MANAGER_GET_VALUE_FLAGS_NONE, NULL, pc_widgets_apps_box_load_existing_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp11_ = mct_manager_get_app_filter_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp6_ = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp12_ = _data_->_tmp6_;
			_data_->_tmp6_ = NULL;
			_mct_app_filter_unref0 (_data_->app_filter);
			_data_->app_filter = _data_->_tmp12_;
			_mct_app_filter_unref0 (_data_->_tmp6_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp13_ = _data_->_vala1_e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			g_warning ("AppsView.vala:212: Unable to get malcontent app filter: %s", _data_->_tmp14_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_mct_app_filter_unref0 (_data_->app_filter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp15_ = pc_utils_get_api ();
		_data_->_tmp16_ = _data_->self->priv->_user;
		_data_->_tmp17_ = act_user_get_user_name (_data_->_tmp16_);
		_data_->_tmp18_ = 0;
		_data_->_state_ = 3;
		pc_iparental_controls_get_user_daemon_targets (_data_->_tmp15_, _data_->_tmp17_, pc_widgets_apps_box_load_existing_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp19_ = pc_iparental_controls_get_user_daemon_targets_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp18_, &_data_->_inner_error0_);
		_data_->targets = _data_->_tmp19_;
		_data_->targets_length1 = _data_->_tmp18_;
		_data_->_targets_size_ = _data_->targets_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp20_ = pc_utils_get_api ();
		_data_->_tmp21_ = _data_->self->priv->_user;
		_data_->_tmp22_ = act_user_get_user_name (_data_->_tmp21_);
		_data_->_state_ = 4;
		pc_iparental_controls_get_user_daemon_admin (_data_->_tmp20_, _data_->_tmp22_, pc_widgets_apps_box_load_existing_ready, _data_);
		return FALSE;
		_state_4:
		_data_->admin = pc_iparental_controls_get_user_daemon_admin_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->targets = (_vala_array_free (_data_->targets, _data_->targets_length1, (GDestroyNotify) g_free), NULL);
			goto __catch2_g_error;
		}
		_data_->_tmp23_ = _data_->self->priv->admin_switch_btn;
		gtk_switch_set_active (_data_->_tmp23_, _data_->admin);
		_data_->_tmp24_ = g_app_info_get_all ();
		_data_->infos = _data_->_tmp24_;
		_data_->_tmp25_ = _data_->infos;
		{
			_data_->info_collection = _data_->_tmp25_;
			for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
				_data_->info = (GAppInfo*) _data_->info_it->data;
				{
					_data_->_tmp26_ = _data_->info;
					_data_->desktop_app = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo);
					_data_->_tmp27_ = _data_->desktop_app;
					if (g_desktop_app_info_has_key (_data_->_tmp27_, "X-Flatpak")) {
						_data_->_tmp29_ = _data_->app_filter;
						if (_data_->_tmp29_ != NULL) {
							_data_->_tmp30_ = _data_->app_filter;
							_data_->_tmp31_ = _data_->desktop_app;
							_data_->_tmp28_ = !mct_app_filter_is_appinfo_allowed (_data_->_tmp30_, (GAppInfo*) _data_->_tmp31_);
						} else {
							_data_->_tmp28_ = FALSE;
						}
						if (_data_->_tmp28_) {
							_data_->_tmp32_ = _data_->info;
							pc_widgets_apps_box_load_info (_data_->self, _data_->_tmp32_);
						}
						continue;
					}
					_data_->_tmp34_ = _data_->info;
					if (g_app_info_should_show (_data_->_tmp34_)) {
						_data_->_tmp35_ = _data_->info;
						_data_->_tmp36_ = pc_utils_info_to_exec_path (_data_->_tmp35_, NULL, (gint) 0);
						_data_->_tmp37_ = _data_->_tmp36_;
						_data_->_tmp38_ = _data_->targets;
						_data_->_tmp38__length1 = _data_->targets_length1;
						_data_->_tmp33_ = _vala_string_array_contains (_data_->_tmp38_, _data_->_tmp38__length1, _data_->_tmp37_);
						_g_free0 (_data_->_tmp37_);
					} else {
						_data_->_tmp33_ = FALSE;
					}
					if (_data_->_tmp33_) {
						_data_->_tmp39_ = _data_->info;
						pc_widgets_apps_box_load_info (_data_->self, _data_->_tmp39_);
					}
				}
			}
		}
		(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		_data_->targets = (_vala_array_free (_data_->targets, _data_->targets_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp40_ = _data_->_vala2_e;
		_data_->_tmp41_ = _data_->_tmp40_->message;
		g_warning ("AppsView.vala:238: %s", _data_->_tmp41_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_mct_app_filter_unref0 (_data_->app_filter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_mct_app_filter_unref0 (_data_->app_filter);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ActUser*
pc_widgets_apps_box_get_user (PCWidgetsAppsBox* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
pc_widgets_apps_box_set_user (PCWidgetsAppsBox* self,
                              ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = pc_widgets_apps_box_get_user (self);
	if (old_value != value) {
		ActUser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pc_widgets_apps_box_properties[PC_WIDGETS_APPS_BOX_USER_PROPERTY]);
	}
}

static void
_pc_widgets_apps_box_on_clear_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	pc_widgets_apps_box_on_clear_button_clicked ((PCWidgetsAppsBox*) self);
}

static void
_pc_widgets_apps_box_load_info_pc_widgets_app_chooser_app_chosen (PCWidgetsAppChooser* _sender,
                                                                  GAppInfo* info,
                                                                  gpointer self)
{
	pc_widgets_apps_box_load_info ((PCWidgetsAppsBox*) self, info);
}

static void
_pc_widgets_apps_box_update_admin_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	pc_widgets_apps_box_update_admin ((PCWidgetsAppsBox*) self);
}

static void
_gtk_window_present_gtk_button_clicked (GtkButton* _sender,
                                        gpointer self)
{
	gtk_window_present ((GtkWindow*) self);
}

static GObject *
pc_widgets_apps_box_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PCWidgetsAppsBox * self;
	GraniteHeaderLabel* header_label = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkScrolledWindow* scrolled = NULL;
	GtkListBox* _tmp3_;
	GtkWidget* _tmp4_;
	GtkScrolledWindow* _tmp5_ = NULL;
	GtkLabel* add_label = NULL;
	GtkLabel* _tmp6_;
	GtkImage* add_image = NULL;
	GtkImage* _tmp7_;
	GtkBox* add_button_box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkButton* add_button = NULL;
	GtkBox* _tmp13_;
	GtkWidget* _tmp14_;
	GtkButton* _tmp15_ = NULL;
	GtkLabel* _tmp16_;
	GtkButton* _tmp17_;
	gchar* _tmp18_;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_;
	GApplication* _tmp21_;
	GtkWindow* _tmp22_;
	GtkWindow* _tmp23_;
	GtkWindow* _tmp24_;
	PCWidgetsAppChooser* _tmp25_ = NULL;
	PCWidgetsAppChooser* _tmp26_;
	GtkActionBar* toolbar = NULL;
	GtkActionBar* _tmp27_;
	GtkActionBar* _tmp28_;
	GtkActionBar* _tmp29_;
	GtkButton* _tmp30_;
	GtkActionBar* _tmp31_;
	GtkButton* _tmp32_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkScrolledWindow* _tmp35_;
	GtkBox* _tmp36_;
	GtkActionBar* _tmp37_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkFrame* _tmp40_ = NULL;
	GtkFrame* _tmp41_;
	GtkLabel* admin_label = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkSwitch* _tmp43_ = NULL;
	GtkSwitch* _tmp44_;
	GraniteHeaderLabel* _tmp45_;
	GtkFrame* _tmp46_;
	GtkLabel* _tmp47_;
	GtkSwitch* _tmp48_;
	GtkButton* _tmp49_;
	PCWidgetsAppChooser* _tmp50_;
	parent_class = G_OBJECT_CLASS (pc_widgets_apps_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_APPS_BOX, PCWidgetsAppsBox);
	(self->priv->entries == NULL) ? NULL : (self->priv->entries = (_g_list_free__g_object_unref0_ (self->priv->entries), NULL));
	self->priv->entries = NULL;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp0_ = granite_header_label_new (_ ("Blocked Apps"));
	g_object_ref_sink (_tmp0_);
	header_label = _tmp0_;
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->list_box);
	self->priv->list_box = _tmp1_;
	_tmp2_ = self->priv->list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp3_ = self->priv->list_box;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	scrolled = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Add Blocked App…"));
	g_object_ref_sink (_tmp6_);
	add_label = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("application-add-symbolic");
	g_object_ref_sink (_tmp7_);
	add_image = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp8_);
	add_button_box = _tmp8_;
	_tmp9_ = add_button_box;
	_tmp10_ = add_image;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = add_button_box;
	_tmp12_ = add_label;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = add_button_box;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	_tmp15_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	gtk_button_set_has_frame (_tmp15_, FALSE);
	g_object_ref_sink (_tmp15_);
	add_button = _tmp15_;
	_tmp16_ = add_label;
	_tmp17_ = add_button;
	gtk_label_set_mnemonic_widget (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = g_strdup (_ ("Clear All"));
	_tmp19_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-clear-all-symbolic");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->clear_button = _tmp19_;
	_tmp20_ = self->priv->clear_button;
	g_signal_connect_object (_tmp20_, "clicked", (GCallback) _pc_widgets_apps_box_on_clear_button_clicked_gtk_button_clicked, self, 0);
	_tmp21_ = g_application_get_default ();
	_tmp22_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_application_get_type (), GtkApplication));
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_tmp25_ = pc_widgets_app_chooser_new ();
	gtk_window_set_transient_for ((GtkWindow*) _tmp25_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->apps_dialog);
	self->priv->apps_dialog = _tmp25_;
	_tmp26_ = self->priv->apps_dialog;
	g_signal_connect_object (_tmp26_, "app-chosen", (GCallback) _pc_widgets_apps_box_load_info_pc_widgets_app_chooser_app_chosen, self, 0);
	_tmp27_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp27_);
	toolbar = _tmp27_;
	_tmp28_ = toolbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, GRANITE_STYLE_CLASS_FLAT);
	_tmp29_ = toolbar;
	_tmp30_ = add_button;
	gtk_action_bar_pack_start (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = toolbar;
	_tmp32_ = self->priv->clear_button;
	gtk_action_bar_pack_end (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp33_);
	main_box = _tmp33_;
	_tmp34_ = main_box;
	_tmp35_ = scrolled;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = main_box;
	_tmp37_ = toolbar;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = main_box;
	_tmp39_ = _g_object_ref0 ((GtkWidget*) _tmp38_);
	_tmp40_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp40_, _tmp39_);
	_g_object_unref0 (_tmp39_);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp40_, 6);
	g_object_ref_sink (_tmp40_);
	frame = _tmp40_;
	_tmp41_ = frame;
	gtk_widget_add_css_class ((GtkWidget*) _tmp41_, GRANITE_STYLE_CLASS_VIEW);
	_tmp42_ = (GtkLabel*) gtk_label_new (_ ("Allow access to these apps with admin permission:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp42_);
	admin_label = _tmp42_;
	_tmp43_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp43_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->admin_switch_btn);
	self->priv->admin_switch_btn = _tmp43_;
	_tmp44_ = self->priv->admin_switch_btn;
	g_signal_connect_object ((GObject*) _tmp44_, "notify::active", (GCallback) _pc_widgets_apps_box_update_admin_g_object_notify, self, 0);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	_tmp45_ = header_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp45_, 0, 0, 2, 1);
	_tmp46_ = frame;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp46_, 0, 1, 2, 1);
	_tmp47_ = admin_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp47_, 0, 2, 1, 1);
	_tmp48_ = self->priv->admin_switch_btn;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp48_, 1, 2, 1, 1);
	pc_widgets_apps_box_load_existing (self, NULL, NULL);
	_tmp49_ = add_button;
	_tmp50_ = self->priv->apps_dialog;
	g_signal_connect_object (_tmp49_, "clicked", (GCallback) _gtk_window_present_gtk_button_clicked, (GtkWindow*) _tmp50_, 0);
	_g_object_unref0 (admin_label);
	_g_object_unref0 (frame);
	_g_object_unref0 (main_box);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (add_button_box);
	_g_object_unref0 (add_image);
	_g_object_unref0 (add_label);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (header_label);
	return obj;
}

static void
pc_widgets_apps_box_class_init (PCWidgetsAppsBoxClass * klass,
                                gpointer klass_data)
{
	pc_widgets_apps_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCWidgetsAppsBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pc_widgets_apps_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pc_widgets_apps_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = pc_widgets_apps_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = pc_widgets_apps_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PC_WIDGETS_APPS_BOX_USER_PROPERTY, pc_widgets_apps_box_properties[PC_WIDGETS_APPS_BOX_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pc_widgets_apps_box_instance_init (PCWidgetsAppsBox * self,
                                   gpointer klass)
{
	self->priv = pc_widgets_apps_box_get_instance_private (self);
}

static void
pc_widgets_apps_box_finalize (GObject * obj)
{
	PCWidgetsAppsBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_WIDGETS_TYPE_APPS_BOX, PCWidgetsAppsBox);
	(self->priv->entries == NULL) ? NULL : (self->priv->entries = (_g_list_free__g_object_unref0_ (self->priv->entries), NULL));
	_g_object_unref0 (self->priv->_user);
	_g_object_unref0 (self->priv->list_box);
	_g_object_unref0 (self->priv->apps_dialog);
	_g_object_unref0 (self->priv->admin_switch_btn);
	_g_object_unref0 (self->priv->clear_button);
	_g_object_unref0 (self->priv->malcontent);
	G_OBJECT_CLASS (pc_widgets_apps_box_parent_class)->finalize (obj);
}

static GType
pc_widgets_apps_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCWidgetsAppsBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_widgets_apps_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCWidgetsAppsBox), 0, (GInstanceInitFunc) pc_widgets_apps_box_instance_init, NULL };
	GType pc_widgets_apps_box_type_id;
	pc_widgets_apps_box_type_id = g_type_register_static (gtk_grid_get_type (), "PCWidgetsAppsBox", &g_define_type_info, 0);
	PCWidgetsAppsBox_private_offset = g_type_add_instance_private (pc_widgets_apps_box_type_id, sizeof (PCWidgetsAppsBoxPrivate));
	return pc_widgets_apps_box_type_id;
}

GType
pc_widgets_apps_box_get_type (void)
{
	static volatile gsize pc_widgets_apps_box_type_id__once = 0;
	if (g_once_init_enter (&pc_widgets_apps_box_type_id__once)) {
		GType pc_widgets_apps_box_type_id;
		pc_widgets_apps_box_type_id = pc_widgets_apps_box_get_type_once ();
		g_once_init_leave (&pc_widgets_apps_box_type_id__once, pc_widgets_apps_box_type_id);
	}
	return pc_widgets_apps_box_type_id__once;
}

static void
_vala_pc_widgets_apps_box_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PCWidgetsAppsBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_APPS_BOX, PCWidgetsAppsBox);
	switch (property_id) {
		case PC_WIDGETS_APPS_BOX_USER_PROPERTY:
		g_value_set_object (value, pc_widgets_apps_box_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pc_widgets_apps_box_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PCWidgetsAppsBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PC_WIDGETS_TYPE_APPS_BOX, PCWidgetsAppsBox);
	switch (property_id) {
		case PC_WIDGETS_APPS_BOX_USER_PROPERTY:
		pc_widgets_apps_box_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

