/* SessionManager.c generated by valac 0.56.17, the Vala compiler
 * generated from SessionManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define PC_CONSTANTS_LOGIN_IFACE "org.freedesktop.login1"
#define PC_CONSTANTS_LOGIN_OBJECT_PATH "/org/freedesktop/login1"
#define PC_CONSTANTS_DBUS_PROPERTIES_IFACE "org.freedesktop.DBus.Properties"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_SESSION_MANAGER (pc_daemon_session_manager_get_type ())
#define PC_DAEMON_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManager))
#define PC_DAEMON_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManagerClass))
#define PC_DAEMON_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SESSION_MANAGER))
#define PC_DAEMON_IS_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SESSION_MANAGER))
#define PC_DAEMON_SESSION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManagerClass))

typedef struct _PCDaemonSessionManager PCDaemonSessionManager;
typedef struct _PCDaemonSessionManagerClass PCDaemonSessionManagerClass;
typedef struct _PCDaemonSessionManagerPrivate PCDaemonSessionManagerPrivate;

#define PC_DAEMON_TYPE_SESSION_HANDLER (pc_daemon_session_handler_get_type ())
#define PC_DAEMON_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandler))
#define PC_DAEMON_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandlerClass))
#define PC_DAEMON_IS_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SESSION_HANDLER))
#define PC_DAEMON_IS_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SESSION_HANDLER))
#define PC_DAEMON_SESSION_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandlerClass))

typedef struct _PCDaemonSessionHandler PCDaemonSessionHandler;
typedef struct _PCDaemonSessionHandlerClass PCDaemonSessionHandlerClass;

#define PC_DAEMON_TYPE_IMANAGER (pc_daemon_imanager_get_type ())
#define PC_DAEMON_IMANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_IMANAGER, PCDaemonIManager))
#define PC_DAEMON_IS_IMANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_IMANAGER))
#define PC_DAEMON_IMANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_DAEMON_TYPE_IMANAGER, PCDaemonIManagerIface))

typedef struct _PCDaemonIManager PCDaemonIManager;
typedef struct _PCDaemonIManagerIface PCDaemonIManagerIface;

#define PC_DAEMON_TYPE_IMANAGER_PROXY (pc_daemon_imanager_proxy_get_type ())

#define PC_DAEMON_TYPE_SESSION_STRUCT (pc_daemon_session_struct_get_type ())
typedef struct _PCDaemonSessionStruct PCDaemonSessionStruct;

#define PC_DAEMON_TYPE_SEAT_STRUCT (pc_daemon_seat_struct_get_type ())
typedef struct _PCDaemonSeatStruct PCDaemonSeatStruct;
enum  {
	PC_DAEMON_SESSION_MANAGER_0_PROPERTY,
	PC_DAEMON_SESSION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* pc_daemon_session_manager_properties[PC_DAEMON_SESSION_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PC_DAEMON_TYPE_ISESSION (pc_daemon_isession_get_type ())
#define PC_DAEMON_ISESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_ISESSION, PCDaemonISession))
#define PC_DAEMON_IS_ISESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_ISESSION))
#define PC_DAEMON_ISESSION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_DAEMON_TYPE_ISESSION, PCDaemonISessionIface))

typedef struct _PCDaemonISession PCDaemonISession;
typedef struct _PCDaemonISessionIface PCDaemonISessionIface;

#define PC_DAEMON_TYPE_ISESSION_PROXY (pc_daemon_isession_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PCDaemonSessionManager {
	GObject parent_instance;
	PCDaemonSessionManagerPrivate * priv;
	PCDaemonSessionHandler* current_handler;
};

struct _PCDaemonSessionManagerClass {
	GObjectClass parent_class;
};

struct _PCDaemonSessionStruct {
	gchar* name;
	guint32 uid;
	gchar* user;
	gchar* seat;
	char* object_path;
};

struct _PCDaemonSeatStruct {
	gchar* seat_id;
	char* object_path;
};

struct _PCDaemonIManagerIface {
	GTypeInterface parent_iface;
	PCDaemonSessionStruct* (*list_sessions) (PCDaemonIManager* self, gint* result_length1, GError** error);
	PCDaemonSeatStruct* (*list_seats) (PCDaemonIManager* self, gint* result_length1, GError** error);
	char* (*get_seat) (PCDaemonIManager* self, const gchar* seat, GError** error);
};

struct _PCDaemonSessionManagerPrivate {
	PCDaemonIManager* manager;
	GDBusConnection* conn;
	guint* signal_ids;
	gint signal_ids_length1;
	gint _signal_ids_size_;
};

struct _PCDaemonISessionIface {
	GTypeInterface parent_iface;
	void (*terminate) (PCDaemonISession* self, GError** error);
	gboolean (*get_active) (PCDaemonISession* self);
	gchar* (*get_name) (PCDaemonISession* self);
	gchar* (*get_id) (PCDaemonISession* self);
};

static gint PCDaemonSessionManager_private_offset;
static gpointer pc_daemon_session_manager_parent_class = NULL;
static PCDaemonSessionManager* pc_daemon_session_manager_instance;
static PCDaemonSessionManager* pc_daemon_session_manager_instance = NULL;

VALA_EXTERN GType pc_daemon_session_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonSessionManager, g_object_unref)
VALA_EXTERN GType pc_daemon_session_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonSessionHandler, g_object_unref)
VALA_EXTERN GType pc_daemon_imanager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_daemon_imanager_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType pc_daemon_session_struct_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PCDaemonSessionStruct* pc_daemon_session_struct_dup (const PCDaemonSessionStruct* self);
VALA_EXTERN void pc_daemon_session_struct_free (PCDaemonSessionStruct* self);
VALA_EXTERN void pc_daemon_session_struct_copy (const PCDaemonSessionStruct* self,
                                    PCDaemonSessionStruct* dest);
VALA_EXTERN void pc_daemon_session_struct_destroy (PCDaemonSessionStruct* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PCDaemonSessionStruct, pc_daemon_session_struct_destroy)
VALA_EXTERN GType pc_daemon_seat_struct_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PCDaemonSeatStruct* pc_daemon_seat_struct_dup (const PCDaemonSeatStruct* self);
VALA_EXTERN void pc_daemon_seat_struct_free (PCDaemonSeatStruct* self);
VALA_EXTERN void pc_daemon_seat_struct_copy (const PCDaemonSeatStruct* self,
                                 PCDaemonSeatStruct* dest);
VALA_EXTERN void pc_daemon_seat_struct_destroy (PCDaemonSeatStruct* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PCDaemonSeatStruct, pc_daemon_seat_struct_destroy)
VALA_EXTERN GType pc_daemon_imanager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonIManager, g_object_unref)
VALA_EXTERN PCDaemonSessionManager* pc_daemon_session_manager_get_default (void);
VALA_EXTERN PCDaemonSessionManager* pc_daemon_session_manager_new (void);
VALA_EXTERN PCDaemonSessionManager* pc_daemon_session_manager_construct (GType object_type);
VALA_EXTERN void pc_daemon_session_manager_start (PCDaemonSessionManager* self);
static void __lambda9_ (PCDaemonSessionManager* self);
static void pc_daemon_session_manager_update_session (PCDaemonSessionManager* self);
static void ___lambda9__pc_daemon_imanager_session_new (PCDaemonIManager* _sender,
                                                 const gchar* session,
                                                 const char* object_path,
                                                 gpointer self);
static void __lambda10_ (PCDaemonSessionManager* self);
static void ___lambda10__pc_daemon_imanager_session_removed (PCDaemonIManager* _sender,
                                                      const gchar* session,
                                                      const char* object_path,
                                                      gpointer self);
VALA_EXTERN PCDaemonSeatStruct* pc_daemon_imanager_list_seats (PCDaemonIManager* self,
                                                   gint* result_length1,
                                                   GError** error);
static void _____lambda11_ (PCDaemonSessionManager* self);
static void ______lambda11__gd_bus_signal_callback (GDBusConnection* connection,
                                             const gchar* sender_name,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* signal_name,
                                             GVariant* parameters,
                                             gpointer self);
static void _vala_array_add1 (guint* * array,
                       gint* length,
                       gint* size,
                       guint value);
static void _vala_PCDaemonSeatStruct_array_free (PCDaemonSeatStruct * array,
                                          gssize array_length);
VALA_EXTERN void pc_daemon_session_manager_stop (PCDaemonSessionManager* self);
static void pc_daemon_session_manager_stop_current_handler (PCDaemonSessionManager* self);
VALA_EXTERN GType pc_daemon_isession_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_daemon_isession_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType pc_daemon_isession_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonISession, g_object_unref)
static PCDaemonISession* pc_daemon_session_manager_get_current_session (PCDaemonSessionManager* self);
VALA_EXTERN PCDaemonSessionStruct* pc_daemon_imanager_list_sessions (PCDaemonIManager* self,
                                                         gint* result_length1,
                                                         GError** error);
static void _vala_PCDaemonSessionStruct_array_free (PCDaemonSessionStruct * array,
                                             gssize array_length);
VALA_EXTERN gboolean pc_daemon_isession_get_active (PCDaemonISession* self);
VALA_EXTERN gchar* pc_daemon_isession_get_id (PCDaemonISession* self);
VALA_EXTERN gchar* pc_daemon_session_handler_get_id (PCDaemonSessionHandler* self);
VALA_EXTERN gchar* pc_daemon_isession_get_name (PCDaemonISession* self);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
VALA_EXTERN PCDaemonSessionHandler* pc_daemon_session_handler_new (PCDaemonISession* session);
VALA_EXTERN PCDaemonSessionHandler* pc_daemon_session_handler_construct (GType object_type,
                                                             PCDaemonISession* session);
VALA_EXTERN void pc_daemon_session_handler_update (PCDaemonSessionHandler* self);
VALA_EXTERN void pc_daemon_session_handler_stop (PCDaemonSessionHandler* self);
static void pc_daemon_session_manager_finalize (GObject * obj);
static GType pc_daemon_session_manager_get_type_once (void);

VALA_EXTERN const gchar* PC_CONSTANTS_DAEMON_IGNORED_USERS[1];

static inline gpointer
pc_daemon_session_manager_get_instance_private (PCDaemonSessionManager* self)
{
	return G_STRUCT_MEMBER_P (self, PCDaemonSessionManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PCDaemonSessionManager*
pc_daemon_session_manager_get_default (void)
{
	PCDaemonSessionManager* _tmp0_;
	PCDaemonSessionManager* _tmp2_;
	PCDaemonSessionManager* _tmp3_;
	PCDaemonSessionManager* result;
	_tmp0_ = pc_daemon_session_manager_instance;
	if (_tmp0_ == NULL) {
		PCDaemonSessionManager* _tmp1_;
		_tmp1_ = pc_daemon_session_manager_new ();
		_g_object_unref0 (pc_daemon_session_manager_instance);
		pc_daemon_session_manager_instance = _tmp1_;
	}
	_tmp2_ = pc_daemon_session_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

PCDaemonSessionManager*
pc_daemon_session_manager_construct (GType object_type)
{
	PCDaemonSessionManager * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (PCDaemonSessionManager*) g_object_new (object_type, NULL);
	{
		PCDaemonIManager* _tmp0_ = NULL;
		PCDaemonIManager* _tmp1_;
		PCDaemonIManager* _tmp2_;
		GDBusConnection* _tmp3_ = NULL;
		GDBusConnection* _tmp4_;
		GDBusConnection* _tmp5_;
		_tmp1_ = (PCDaemonIManager*) g_initable_new (PC_DAEMON_TYPE_IMANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", PC_CONSTANTS_LOGIN_IFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", PC_CONSTANTS_LOGIN_OBJECT_PATH, "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		_tmp0_ = (PCDaemonIManager*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->manager);
		self->priv->manager = _tmp2_;
		_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->conn);
		self->priv->conn = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("SessionManager.vala:45: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

PCDaemonSessionManager*
pc_daemon_session_manager_new (void)
{
	return pc_daemon_session_manager_construct (PC_DAEMON_TYPE_SESSION_MANAGER);
}

static void
__lambda9_ (PCDaemonSessionManager* self)
{
	pc_daemon_session_manager_update_session (self);
}

static void
___lambda9__pc_daemon_imanager_session_new (PCDaemonIManager* _sender,
                                            const gchar* session,
                                            const char* object_path,
                                            gpointer self)
{
	__lambda9_ ((PCDaemonSessionManager*) self);
}

static void
__lambda10_ (PCDaemonSessionManager* self)
{
	pc_daemon_session_manager_update_session (self);
}

static void
___lambda10__pc_daemon_imanager_session_removed (PCDaemonIManager* _sender,
                                                 const gchar* session,
                                                 const char* object_path,
                                                 gpointer self)
{
	__lambda10_ ((PCDaemonSessionManager*) self);
}

static void
_____lambda11_ (PCDaemonSessionManager* self)
{
	pc_daemon_session_manager_update_session (self);
}

static void
______lambda11__gd_bus_signal_callback (GDBusConnection* connection,
                                        const gchar* sender_name,
                                        const gchar* object_path,
                                        const gchar* interface_name,
                                        const gchar* signal_name,
                                        GVariant* parameters,
                                        gpointer self)
{
	_____lambda11_ ((PCDaemonSessionManager*) self);
}

static void
_vala_array_add1 (guint* * array,
                  gint* length,
                  gint* size,
                  guint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_PCDaemonSeatStruct_array_free (PCDaemonSeatStruct * array,
                                     gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pc_daemon_seat_struct_destroy (&array[i]);
		}
	}
	g_free (array);
}

void
pc_daemon_session_manager_start (PCDaemonSessionManager* self)
{
	gboolean _tmp0_ = FALSE;
	PCDaemonIManager* _tmp1_;
	PCDaemonIManager* _tmp3_;
	PCDaemonIManager* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->manager;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GDBusConnection* _tmp2_;
		_tmp2_ = self->priv->conn;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->manager;
	g_signal_connect_object (_tmp3_, "session-new", (GCallback) ___lambda9__pc_daemon_imanager_session_new, self, 0);
	_tmp4_ = self->priv->manager;
	g_signal_connect_object (_tmp4_, "session-removed", (GCallback) ___lambda10__pc_daemon_imanager_session_removed, self, 0);
	{
		PCDaemonSeatStruct* _tmp5_ = NULL;
		PCDaemonIManager* _tmp6_;
		gint _tmp7_ = 0;
		PCDaemonSeatStruct* _tmp8_;
		gint _tmp5__length1;
		gint __tmp5__size_;
		_tmp6_ = self->priv->manager;
		_tmp8_ = pc_daemon_imanager_list_seats (_tmp6_, &_tmp7_, &_inner_error0_);
		_tmp5_ = _tmp8_;
		_tmp5__length1 = _tmp7_;
		__tmp5__size_ = _tmp5__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			PCDaemonSeatStruct* seat_s_collection = NULL;
			gint seat_s_collection_length1 = 0;
			gint _seat_s_collection_size_ = 0;
			gint seat_s_it = 0;
			seat_s_collection = _tmp5_;
			seat_s_collection_length1 = _tmp5__length1;
			for (seat_s_it = 0; seat_s_it < seat_s_collection_length1; seat_s_it = seat_s_it + 1) {
				PCDaemonSeatStruct _tmp9_;
				PCDaemonSeatStruct _tmp10_ = {0};
				PCDaemonSeatStruct seat_s = {0};
				_tmp9_ = seat_s_collection[seat_s_it];
				pc_daemon_seat_struct_copy (&_tmp9_, &_tmp10_);
				seat_s = _tmp10_;
				{
					GDBusConnection* _tmp11_;
					PCDaemonSeatStruct _tmp12_;
					const char* _tmp13_;
					_tmp11_ = self->priv->conn;
					_tmp12_ = seat_s;
					_tmp13_ = _tmp12_.object_path;
					_vala_array_add1 (&self->priv->signal_ids, &self->priv->signal_ids_length1, &self->priv->_signal_ids_size_, g_dbus_connection_signal_subscribe (_tmp11_, NULL, PC_CONSTANTS_DBUS_PROPERTIES_IFACE, "PropertiesChanged", (const gchar*) _tmp13_, NULL, 0, ______lambda11__gd_bus_signal_callback, g_object_ref (self), g_object_unref));
					pc_daemon_seat_struct_destroy (&seat_s);
				}
			}
		}
		_tmp5_ = (_vala_PCDaemonSeatStruct_array_free (_tmp5_, _tmp5__length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("SessionManager.vala:68: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	pc_daemon_session_manager_update_session (self);
}

void
pc_daemon_session_manager_stop (PCDaemonSessionManager* self)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->signal_ids;
	_tmp0__length1 = self->priv->signal_ids_length1;
	{
		guint* signal_id_collection = NULL;
		gint signal_id_collection_length1 = 0;
		gint _signal_id_collection_size_ = 0;
		gint signal_id_it = 0;
		signal_id_collection = _tmp0_;
		signal_id_collection_length1 = _tmp0__length1;
		for (signal_id_it = 0; signal_id_it < signal_id_collection_length1; signal_id_it = signal_id_it + 1) {
			guint signal_id = 0U;
			signal_id = signal_id_collection[signal_id_it];
			{
				GDBusConnection* _tmp1_;
				_tmp1_ = self->priv->conn;
				g_dbus_connection_signal_unsubscribe (_tmp1_, signal_id);
			}
		}
	}
	pc_daemon_session_manager_stop_current_handler (self);
}

static void
_vala_PCDaemonSessionStruct_array_free (PCDaemonSessionStruct * array,
                                        gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pc_daemon_session_struct_destroy (&array[i]);
		}
	}
	g_free (array);
}

static PCDaemonISession*
pc_daemon_session_manager_get_current_session (PCDaemonSessionManager* self)
{
	GError* _inner_error0_ = NULL;
	PCDaemonISession* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		PCDaemonSessionStruct* structs = NULL;
		PCDaemonIManager* _tmp0_;
		gint _tmp1_ = 0;
		PCDaemonSessionStruct* _tmp2_;
		gint structs_length1;
		gint _structs_size_;
		PCDaemonSessionStruct* _tmp3_;
		gint _tmp3__length1;
		_tmp0_ = self->priv->manager;
		_tmp2_ = pc_daemon_imanager_list_sessions (_tmp0_, &_tmp1_, &_inner_error0_);
		structs = _tmp2_;
		structs_length1 = _tmp1_;
		_structs_size_ = structs_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = structs;
		_tmp3__length1 = structs_length1;
		{
			PCDaemonSessionStruct* session_s_collection = NULL;
			gint session_s_collection_length1 = 0;
			gint _session_s_collection_size_ = 0;
			gint session_s_it = 0;
			session_s_collection = _tmp3_;
			session_s_collection_length1 = _tmp3__length1;
			for (session_s_it = 0; session_s_it < session_s_collection_length1; session_s_it = session_s_it + 1) {
				PCDaemonSessionStruct _tmp4_;
				PCDaemonSessionStruct _tmp5_ = {0};
				PCDaemonSessionStruct session_s = {0};
				_tmp4_ = session_s_collection[session_s_it];
				pc_daemon_session_struct_copy (&_tmp4_, &_tmp5_);
				session_s = _tmp5_;
				{
					PCDaemonISession* session = NULL;
					PCDaemonSessionStruct _tmp6_;
					const char* _tmp7_;
					PCDaemonISession* _tmp8_;
					gboolean _tmp9_ = FALSE;
					PCDaemonISession* _tmp10_;
					_tmp6_ = session_s;
					_tmp7_ = _tmp6_.object_path;
					_tmp8_ = (PCDaemonISession*) g_initable_new (PC_DAEMON_TYPE_ISESSION_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", PC_CONSTANTS_LOGIN_IFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _tmp7_, "g-interface-name", "org.freedesktop.login1.Session", NULL);
					session = (PCDaemonISession*) _tmp8_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						pc_daemon_session_struct_destroy (&session_s);
						structs = (_vala_PCDaemonSessionStruct_array_free (structs, structs_length1), NULL);
						goto __catch0_g_error;
					}
					_tmp10_ = session;
					if (_tmp10_ != NULL) {
						PCDaemonISession* _tmp11_;
						gboolean _tmp12_;
						gboolean _tmp13_;
						_tmp11_ = session;
						_tmp12_ = pc_daemon_isession_get_active (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp9_ = _tmp13_;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						result = session;
						pc_daemon_session_struct_destroy (&session_s);
						structs = (_vala_PCDaemonSessionStruct_array_free (structs, structs_length1), NULL);
						return result;
					}
					_g_object_unref0 (session);
					pc_daemon_session_struct_destroy (&session_s);
				}
			}
		}
		structs = (_vala_PCDaemonSessionStruct_array_free (structs, structs_length1), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("SessionManager.vala:96: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
pc_daemon_session_manager_update_session (PCDaemonSessionManager* self)
{
	PCDaemonISession* session = NULL;
	PCDaemonISession* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PCDaemonISession* _tmp2_;
	gboolean _tmp12_ = FALSE;
	PCDaemonISession* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_;
	PCDaemonISession* _tmp22_;
	PCDaemonSessionHandler* _tmp23_;
	PCDaemonSessionHandler* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_session_manager_get_current_session (self);
	session = _tmp0_;
	_tmp2_ = session;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		PCDaemonSessionHandler* _tmp4_;
		_tmp4_ = self->current_handler;
		if (_tmp4_ != NULL) {
			PCDaemonISession* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			PCDaemonSessionHandler* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = session;
			_tmp6_ = pc_daemon_isession_get_id (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = self->current_handler;
			_tmp10_ = pc_daemon_session_handler_get_id (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp3_ = g_strcmp0 (_tmp8_, _tmp11_) == 0;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp8_);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_g_object_unref0 (session);
		return;
	}
	pc_daemon_session_manager_stop_current_handler (self);
	_tmp13_ = session;
	_tmp14_ = pc_daemon_isession_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_ == NULL;
	_g_free0 (_tmp16_);
	if (_tmp17_) {
		_tmp12_ = TRUE;
	} else {
		PCDaemonISession* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = session;
		_tmp19_ = pc_daemon_isession_get_name (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp12_ = _vala_string_array_contains (PC_CONSTANTS_DAEMON_IGNORED_USERS, G_N_ELEMENTS (PC_CONSTANTS_DAEMON_IGNORED_USERS), _tmp21_);
		_g_free0 (_tmp21_);
	}
	if (_tmp12_) {
		_g_object_unref0 (session);
		return;
	}
	_tmp22_ = session;
	_tmp23_ = pc_daemon_session_handler_new (_tmp22_);
	_g_object_unref0 (self->current_handler);
	self->current_handler = _tmp23_;
	_tmp24_ = self->current_handler;
	pc_daemon_session_handler_update (_tmp24_);
	_g_object_unref0 (session);
}

static void
pc_daemon_session_manager_stop_current_handler (PCDaemonSessionManager* self)
{
	PCDaemonSessionHandler* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->current_handler;
	if (_tmp0_ != NULL) {
		PCDaemonSessionHandler* _tmp1_;
		_tmp1_ = self->current_handler;
		pc_daemon_session_handler_stop (_tmp1_);
		_g_object_unref0 (self->current_handler);
		self->current_handler = NULL;
	}
}

static void
pc_daemon_session_manager_class_init (PCDaemonSessionManagerClass * klass,
                                      gpointer klass_data)
{
	pc_daemon_session_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCDaemonSessionManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pc_daemon_session_manager_finalize;
}

static void
pc_daemon_session_manager_instance_init (PCDaemonSessionManager * self,
                                         gpointer klass)
{
	self->priv = pc_daemon_session_manager_get_instance_private (self);
	self->current_handler = NULL;
	self->priv->manager = NULL;
	self->priv->conn = NULL;
}

static void
pc_daemon_session_manager_finalize (GObject * obj)
{
	PCDaemonSessionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManager);
	_g_object_unref0 (self->current_handler);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->conn);
	self->priv->signal_ids = (g_free (self->priv->signal_ids), NULL);
	G_OBJECT_CLASS (pc_daemon_session_manager_parent_class)->finalize (obj);
}

static GType
pc_daemon_session_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonSessionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_session_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCDaemonSessionManager), 0, (GInstanceInitFunc) pc_daemon_session_manager_instance_init, NULL };
	GType pc_daemon_session_manager_type_id;
	pc_daemon_session_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PCDaemonSessionManager", &g_define_type_info, 0);
	PCDaemonSessionManager_private_offset = g_type_add_instance_private (pc_daemon_session_manager_type_id, sizeof (PCDaemonSessionManagerPrivate));
	return pc_daemon_session_manager_type_id;
}

GType
pc_daemon_session_manager_get_type (void)
{
	static volatile gsize pc_daemon_session_manager_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_session_manager_type_id__once)) {
		GType pc_daemon_session_manager_type_id;
		pc_daemon_session_manager_type_id = pc_daemon_session_manager_get_type_once ();
		g_once_init_leave (&pc_daemon_session_manager_type_id__once, pc_daemon_session_manager_type_id);
	}
	return pc_daemon_session_manager_type_id__once;
}

