/* Server.c generated by valac 0.56.17, the Vala compiler
 * generated from Server.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <polkit/polkit.h>
#include <glib/gstdio.h>

#define PC_DAEMON_SERVER_CLIENT_LAUNCH_TIMEOUT ((guint) 5000)
#define PC_CONSTANTS_PARENTAL_CONTROLS_ACTION_ID "io.elementary.settings.screentime-limits.administration"
#define PC_ACCESS_CONTROL_LISTS_NO_EXEC_PERMISSIONS "---"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_DAEMON_TYPE_DBUS (pc_daemon_dbus_get_type ())
#define PC_DAEMON_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_DBUS, PCDaemonDBus))
#define PC_DAEMON_IS_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_DBUS))
#define PC_DAEMON_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_DAEMON_TYPE_DBUS, PCDaemonDBusIface))

typedef struct _PCDaemonDBus PCDaemonDBus;
typedef struct _PCDaemonDBusIface PCDaemonDBusIface;

#define PC_DAEMON_TYPE_DBUS_PROXY (pc_daemon_dbus_proxy_get_type ())
typedef GDBusProxy PCDaemonDBusProxy;
typedef GDBusProxyClass PCDaemonDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define PC_DAEMON_TYPE_PARENTAL_CONTROLS_ERROR (pc_daemon_parental_controls_error_get_type ())

#define PC_DAEMON_TYPE_SERVER (pc_daemon_server_get_type ())
#define PC_DAEMON_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServer))
#define PC_DAEMON_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))
#define PC_DAEMON_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SERVER))
#define PC_DAEMON_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SERVER, PCDaemonServerClass))

typedef struct _PCDaemonServer PCDaemonServer;
typedef struct _PCDaemonServerClass PCDaemonServerClass;
typedef struct _PCDaemonServerPrivate PCDaemonServerPrivate;
enum  {
	PC_DAEMON_SERVER_0_PROPERTY,
	PC_DAEMON_SERVER_NUM_PROPERTIES
};
static GParamSpec* pc_daemon_server_properties[PC_DAEMON_SERVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define PC_DAEMON_TYPE_USER_CONFIG (pc_daemon_user_config_get_type ())
#define PC_DAEMON_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfig))
#define PC_DAEMON_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))
#define PC_DAEMON_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_USER_CONFIG))
#define PC_DAEMON_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_USER_CONFIG, PCDaemonUserConfigClass))

typedef struct _PCDaemonUserConfig PCDaemonUserConfig;
typedef struct _PCDaemonUserConfigClass PCDaemonUserConfigClass;
typedef struct _Block3Data Block3Data;

#define PC_PAM_TYPE_WRITER (pc_pam_writer_get_type ())
#define PC_PAM_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_PAM_TYPE_WRITER, PCPAMWriter))
#define PC_PAM_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_PAM_TYPE_WRITER, PCPAMWriterClass))
#define PC_PAM_IS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_PAM_TYPE_WRITER))
#define PC_PAM_IS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_PAM_TYPE_WRITER))
#define PC_PAM_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_PAM_TYPE_WRITER, PCPAMWriterClass))

typedef struct _PCPAMWriter PCPAMWriter;
typedef struct _PCPAMWriterClass PCPAMWriterClass;

#define PC_DAEMON_TYPE_SESSION_HANDLER (pc_daemon_session_handler_get_type ())
#define PC_DAEMON_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandler))
#define PC_DAEMON_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandlerClass))
#define PC_DAEMON_IS_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SESSION_HANDLER))
#define PC_DAEMON_IS_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SESSION_HANDLER))
#define PC_DAEMON_SESSION_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SESSION_HANDLER, PCDaemonSessionHandlerClass))

typedef struct _PCDaemonSessionHandler PCDaemonSessionHandler;
typedef struct _PCDaemonSessionHandlerClass PCDaemonSessionHandlerClass;

#define PC_DAEMON_TYPE_SESSION_MANAGER (pc_daemon_session_manager_get_type ())
#define PC_DAEMON_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManager))
#define PC_DAEMON_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManagerClass))
#define PC_DAEMON_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_DAEMON_TYPE_SESSION_MANAGER))
#define PC_DAEMON_IS_SESSION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_DAEMON_TYPE_SESSION_MANAGER))
#define PC_DAEMON_SESSION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_DAEMON_TYPE_SESSION_MANAGER, PCDaemonSessionManagerClass))

typedef struct _PCDaemonSessionManager PCDaemonSessionManager;
typedef struct _PCDaemonSessionManagerClass PCDaemonSessionManagerClass;
typedef struct _PCDaemonSessionManagerPrivate PCDaemonSessionManagerPrivate;
enum  {
	PC_DAEMON_SERVER_LAUNCH_SIGNAL,
	PC_DAEMON_SERVER_SHOW_TIMEOUT_SIGNAL,
	PC_DAEMON_SERVER_CONFIG_CHANGED_SIGNAL,
	PC_DAEMON_SERVER_NUM_SIGNALS
};
static guint pc_daemon_server_signals[PC_DAEMON_SERVER_NUM_SIGNALS] = {0};

struct _PCDaemonDBusIface {
	GTypeInterface parent_iface;
	guint32 (*get_connection_unix_process_id) (PCDaemonDBus* self, const gchar* name, GError** error);
	guint32 (*get_connection_unix_user) (PCDaemonDBus* self, const gchar* name, GError** error);
};

typedef enum  {
	PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED,
	PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_IMPLEMENTED,
	PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD,
	PC_DAEMON_PARENTAL_CONTROLS_ERROR_DBUS_CONNECTION_FAILED
} PCDaemonParentalControlsError;
#define PC_DAEMON_PARENTAL_CONTROLS_ERROR pc_daemon_parental_controls_error_quark ()

struct _PCDaemonServer {
	GObject parent_instance;
	PCDaemonServerPrivate * priv;
};

struct _PCDaemonServerClass {
	GObjectClass parent_class;
};

struct _PCDaemonServerPrivate {
	PCDaemonDBus* bus_proxy;
};

struct _Block2Data {
	int _ref_count_;
	PCDaemonServer* self;
	gchar* username;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gchar* path;
	gulong launch_signal_id;
	guint timeout_signal_id;
};

struct _PCDaemonSessionManager {
	GObject parent_instance;
	PCDaemonSessionManagerPrivate * priv;
	PCDaemonSessionHandler* current_handler;
};

struct _PCDaemonSessionManagerClass {
	GObjectClass parent_class;
};

static gint PCDaemonServer_private_offset;
static gpointer pc_daemon_server_parent_class = NULL;
static PCDaemonServer* pc_daemon_server_instance;
static PCDaemonServer* pc_daemon_server_instance = NULL;

VALA_EXTERN GType pc_daemon_dbus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_daemon_dbus_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN GType pc_daemon_dbus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonDBus, g_object_unref)
VALA_EXTERN guint32 pc_daemon_dbus_get_connection_unix_process_id (PCDaemonDBus* self,
                                                       const gchar* name,
                                                       GError** error);
VALA_EXTERN guint32 pc_daemon_dbus_get_connection_unix_user (PCDaemonDBus* self,
                                                 const gchar* name,
                                                 GError** error);
static GType pc_daemon_dbus_get_type_once (void);
static void pc_daemon_dbus_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static guint32 pc_daemon_dbus_proxy_get_connection_unix_process_id (PCDaemonDBus* self,
                                                             const gchar* name,
                                                             GError** error);
static guint32 pc_daemon_dbus_proxy_get_connection_unix_user (PCDaemonDBus* self,
                                                       const gchar* name,
                                                       GError** error);
static void pc_daemon_dbus_proxy_pc_daemon_dbus_interface_init (PCDaemonDBusIface* iface);
static void _dbus_pc_daemon_dbus_get_connection_unix_process_id (PCDaemonDBus* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_dbus_get_connection_unix_user (PCDaemonDBus* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void pc_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* pc_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static gboolean pc_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _pc_daemon_dbus_unregister_object (gpointer user_data);
VALA_EXTERN GQuark pc_daemon_parental_controls_error_quark (void);
VALA_EXTERN GType pc_daemon_parental_controls_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pc_daemon_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonServer, g_object_unref)
VALA_EXTERN guint pc_daemon_server_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN PCDaemonServer* pc_daemon_server_get_default (void);
VALA_EXTERN PCDaemonServer* pc_daemon_server_new (void);
VALA_EXTERN PCDaemonServer* pc_daemon_server_construct (GType object_type);
VALA_EXTERN void pc_daemon_user_config_init (void);
static void pc_daemon_server_on_config_changed (PCDaemonServer* self);
static void _pc_daemon_server_on_config_changed_pc_daemon_server_config_changed (PCDaemonServer* _sender,
                                                                          gpointer self);
VALA_EXTERN void pc_daemon_server_finish_app_authorization (PCDaemonServer* self,
                                                const char* sender,
                                                const gchar* username,
                                                gchar** args,
                                                gint args_length1,
                                                GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN GType pc_daemon_user_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonUserConfig, g_object_unref)
VALA_EXTERN PCDaemonUserConfig* pc_daemon_user_config_get_for_username (const gchar* username,
                                                            gboolean create);
VALA_EXTERN gboolean pc_daemon_user_config_get_admin (PCDaemonUserConfig* self);
static guint32 pc_daemon_server_get_pid_from_sender (PCDaemonServer* self,
                                              const char* sender);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void pc_access_control_lists_setfacl (const gchar* username,
                                      const gchar* target,
                                      const gchar* permissions_str);
static void ____lambda12_ (Block3Data* _data3_,
                    gchar** args,
                    gint args_length1,
                    gboolean incoming);
static void _____lambda12__pc_daemon_server_launch (PCDaemonServer* _sender,
                                             gchar** args,
                                             gint args_length1,
                                             gboolean incoming,
                                             gpointer self);
static gboolean ____lambda13_ (Block3Data* _data3_);
static gboolean _____lambda13__gsource_func (gpointer self);
VALA_EXTERN void pc_daemon_server_add_restriction_for_user (PCDaemonServer* self,
                                                const gchar* input,
                                                gboolean clean,
                                                const char* sender,
                                                GError** error);
static gboolean pc_daemon_server_get_sender_is_authorized (PCDaemonServer* self,
                                                    const char* sender,
                                                    GError** error);
static void pc_daemon_server_ensure_pam_lightdm_enabled (PCDaemonServer* self);
VALA_EXTERN GType pc_pam_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCPAMWriter, g_object_unref)
VALA_EXTERN PCPAMWriter* pc_pam_writer_new_for_time (void);
VALA_EXTERN void pc_pam_writer_add_restriction_for_user (PCPAMWriter* self,
                                             const gchar* input,
                                             gboolean clean);
VALA_EXTERN void pc_daemon_server_remove_restriction_for_user (PCDaemonServer* self,
                                                   const gchar* username,
                                                   const char* sender,
                                                   GError** error);
VALA_EXTERN void pc_pam_writer_remove_restriction_for_user (PCPAMWriter* self,
                                                const gchar* username);
VALA_EXTERN void pc_daemon_server_lock_dock_icons_for_user (PCDaemonServer* self,
                                                const gchar* username,
                                                gboolean lock,
                                                const char* sender,
                                                GError** error);
VALA_EXTERN void pc_daemon_server_set_user_daemon_active (PCDaemonServer* self,
                                              const gchar* username,
                                              gboolean active,
                                              const char* sender,
                                              GError** error);
VALA_EXTERN void pc_daemon_user_config_set_active (PCDaemonUserConfig* self,
                                       gboolean value);
VALA_EXTERN void pc_daemon_server_set_user_daemon_targets (PCDaemonServer* self,
                                               const gchar* username,
                                               gchar** targets,
                                               gint targets_length1,
                                               const char* sender,
                                               GError** error);
VALA_EXTERN void pc_daemon_user_config_set_targets (PCDaemonUserConfig* self,
                                        gchar** value,
                                        gint value_length1);
VALA_EXTERN void pc_daemon_server_set_user_daemon_block_urls (PCDaemonServer* self,
                                                  const gchar* username,
                                                  gchar** block_urls,
                                                  gint block_urls_length1,
                                                  const char* sender,
                                                  GError** error);
VALA_EXTERN void pc_daemon_user_config_set_block_urls (PCDaemonUserConfig* self,
                                           gchar** value,
                                           gint value_length1);
VALA_EXTERN void pc_daemon_server_set_user_daemon_admin (PCDaemonServer* self,
                                             const gchar* username,
                                             gboolean admin,
                                             const char* sender,
                                             GError** error);
VALA_EXTERN void pc_daemon_user_config_set_admin (PCDaemonUserConfig* self,
                                      gboolean value);
VALA_EXTERN gboolean pc_daemon_server_get_user_daemon_active (PCDaemonServer* self,
                                                  const gchar* username,
                                                  GError** error);
VALA_EXTERN gboolean pc_daemon_user_config_get_active (PCDaemonUserConfig* self);
VALA_EXTERN gchar** pc_daemon_server_get_user_daemon_targets (PCDaemonServer* self,
                                                  const gchar* username,
                                                  gint* result_length1,
                                                  GError** error);
VALA_EXTERN gchar** pc_daemon_user_config_get_targets (PCDaemonUserConfig* self,
                                           gint* result_length1);
VALA_EXTERN gchar** pc_daemon_server_get_user_daemon_block_urls (PCDaemonServer* self,
                                                     const gchar* username,
                                                     gint* result_length1,
                                                     GError** error);
VALA_EXTERN gchar** pc_daemon_user_config_get_block_urls (PCDaemonUserConfig* self,
                                              gint* result_length1);
VALA_EXTERN gboolean pc_daemon_server_get_user_daemon_admin (PCDaemonServer* self,
                                                 const gchar* username,
                                                 GError** error);
VALA_EXTERN GType pc_daemon_session_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonSessionHandler, g_object_unref)
VALA_EXTERN GType pc_daemon_session_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCDaemonSessionManager, g_object_unref)
VALA_EXTERN PCDaemonSessionManager* pc_daemon_session_manager_get_default (void);
VALA_EXTERN void pc_daemon_session_handler_update (PCDaemonSessionHandler* self);
static void _vala_array_add2 (const gchar** * array,
                       gint* length,
                       gint* size,
                       const gchar* value);
static void g_cclosure_user_marshal_VOID__BOXED_INT_BOOLEAN (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void pc_daemon_server_finalize (GObject * obj);
static GType pc_daemon_server_get_type_once (void);
static void _dbus_pc_daemon_server_finish_app_authorization (PCDaemonServer* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_add_restriction_for_user (PCDaemonServer* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_remove_restriction_for_user (PCDaemonServer* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_lock_dock_icons_for_user (PCDaemonServer* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_set_user_daemon_active (PCDaemonServer* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_set_user_daemon_targets (PCDaemonServer* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_set_user_daemon_block_urls (PCDaemonServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_set_user_daemon_admin (PCDaemonServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_get_user_daemon_active (PCDaemonServer* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_get_user_daemon_targets (PCDaemonServer* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_get_user_daemon_block_urls (PCDaemonServer* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_pc_daemon_server_get_user_daemon_admin (PCDaemonServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void pc_daemon_server_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* pc_daemon_server_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean pc_daemon_server_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _dbus_pc_daemon_server_launch (GObject* _sender,
                                    gchar** args,
                                    gint args_length1,
                                    gboolean incoming,
                                    gpointer* _data);
static void _dbus_pc_daemon_server_show_timeout (GObject* _sender,
                                          gint hours,
                                          gint minutes,
                                          gpointer* _data);
static void _dbus_pc_daemon_server_config_changed (GObject* _sender,
                                            gpointer* _data);
static void _pc_daemon_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_in[] = {&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_name, NULL};
static const GDBusArgInfo * const _pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_out[] = {&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_result, NULL};
static const GDBusMethodInfo _pc_daemon_dbus_dbus_method_info_get_connection_unix_process_id = {-1, "GetConnectionUnixProcessID", (GDBusArgInfo **) (&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_in), (GDBusArgInfo **) (&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_process_id_out), NULL};
static const GDBusArgInfo _pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_in[] = {&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_name, NULL};
static const GDBusArgInfo * const _pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_out[] = {&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_result, NULL};
static const GDBusMethodInfo _pc_daemon_dbus_dbus_method_info_get_connection_unix_user = {-1, "GetConnectionUnixUser", (GDBusArgInfo **) (&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_in), (GDBusArgInfo **) (&_pc_daemon_dbus_dbus_arg_info_get_connection_unix_user_out), NULL};
static const GDBusMethodInfo * const _pc_daemon_dbus_dbus_method_info[] = {&_pc_daemon_dbus_dbus_method_info_get_connection_unix_process_id, &_pc_daemon_dbus_dbus_method_info_get_connection_unix_user, NULL};
static const GDBusSignalInfo * const _pc_daemon_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _pc_daemon_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pc_daemon_dbus_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_pc_daemon_dbus_dbus_method_info), (GDBusSignalInfo **) (&_pc_daemon_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_pc_daemon_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pc_daemon_dbus_dbus_interface_vtable = {pc_daemon_dbus_dbus_interface_method_call, pc_daemon_dbus_dbus_interface_get_property, pc_daemon_dbus_dbus_interface_set_property};
static const GDBusErrorEntry pc_daemon_parental_controls_error_entries[] = {{PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "org.pantheon.ParentalControls.NotAuthorized"}, {PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_IMPLEMENTED, "org.pantheon.ParentalControls.NotImplemented"}, {PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "org.pantheon.ParentalControls.UserConfigNotVaild"}, {PC_DAEMON_PARENTAL_CONTROLS_ERROR_DBUS_CONNECTION_FAILED, "org.pantheon.ParentalControls.DbusConnectionFailed"}};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_finish_app_authorization_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_finish_app_authorization_args = {-1, "args", "as", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_finish_app_authorization_in[] = {&_pc_daemon_server_dbus_arg_info_finish_app_authorization_username, &_pc_daemon_server_dbus_arg_info_finish_app_authorization_args, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_finish_app_authorization_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_finish_app_authorization = {-1, "FinishAppAuthorization", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_finish_app_authorization_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_finish_app_authorization_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_add_restriction_for_user_input = {-1, "input", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_add_restriction_for_user_clean = {-1, "clean", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_add_restriction_for_user_in[] = {&_pc_daemon_server_dbus_arg_info_add_restriction_for_user_input, &_pc_daemon_server_dbus_arg_info_add_restriction_for_user_clean, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_add_restriction_for_user_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_add_restriction_for_user = {-1, "AddRestrictionForUser", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_add_restriction_for_user_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_add_restriction_for_user_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_remove_restriction_for_user_username = {-1, "username", "s", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_remove_restriction_for_user_in[] = {&_pc_daemon_server_dbus_arg_info_remove_restriction_for_user_username, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_remove_restriction_for_user_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_remove_restriction_for_user = {-1, "RemoveRestrictionForUser", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_remove_restriction_for_user_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_remove_restriction_for_user_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_lock = {-1, "lock", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_in[] = {&_pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_username, &_pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_lock, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_lock_dock_icons_for_user = {-1, "LockDockIconsForUser", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_lock_dock_icons_for_user_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_active_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_active_active = {-1, "active", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_active_in[] = {&_pc_daemon_server_dbus_arg_info_set_user_daemon_active_username, &_pc_daemon_server_dbus_arg_info_set_user_daemon_active_active, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_active_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_set_user_daemon_active = {-1, "SetUserDaemonActive", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_active_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_active_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_targets_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_targets_targets = {-1, "targets", "as", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_targets_in[] = {&_pc_daemon_server_dbus_arg_info_set_user_daemon_targets_username, &_pc_daemon_server_dbus_arg_info_set_user_daemon_targets_targets, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_targets_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_set_user_daemon_targets = {-1, "SetUserDaemonTargets", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_targets_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_targets_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_block_urls = {-1, "block_urls", "as", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_in[] = {&_pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_username, &_pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_block_urls, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_set_user_daemon_block_urls = {-1, "SetUserDaemonBlockUrls", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_block_urls_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_admin_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_set_user_daemon_admin_admin = {-1, "admin", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_admin_in[] = {&_pc_daemon_server_dbus_arg_info_set_user_daemon_admin_username, &_pc_daemon_server_dbus_arg_info_set_user_daemon_admin_admin, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_set_user_daemon_admin_out[] = {NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_set_user_daemon_admin = {-1, "SetUserDaemonAdmin", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_admin_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_set_user_daemon_admin_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_active_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_active_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_active_in[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_active_username, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_active_out[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_active_result, NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_get_user_daemon_active = {-1, "GetUserDaemonActive", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_active_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_active_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_targets_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_targets_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_targets_in[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_targets_username, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_targets_out[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_targets_result, NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_get_user_daemon_targets = {-1, "GetUserDaemonTargets", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_targets_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_targets_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_in[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_username, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_out[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_result, NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_get_user_daemon_block_urls = {-1, "GetUserDaemonBlockUrls", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_block_urls_out), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_admin_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_get_user_daemon_admin_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_admin_in[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_admin_username, NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_get_user_daemon_admin_out[] = {&_pc_daemon_server_dbus_arg_info_get_user_daemon_admin_result, NULL};
static const GDBusMethodInfo _pc_daemon_server_dbus_method_info_get_user_daemon_admin = {-1, "GetUserDaemonAdmin", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_admin_in), (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_get_user_daemon_admin_out), NULL};
static const GDBusMethodInfo * const _pc_daemon_server_dbus_method_info[] = {&_pc_daemon_server_dbus_method_info_finish_app_authorization, &_pc_daemon_server_dbus_method_info_add_restriction_for_user, &_pc_daemon_server_dbus_method_info_remove_restriction_for_user, &_pc_daemon_server_dbus_method_info_lock_dock_icons_for_user, &_pc_daemon_server_dbus_method_info_set_user_daemon_active, &_pc_daemon_server_dbus_method_info_set_user_daemon_targets, &_pc_daemon_server_dbus_method_info_set_user_daemon_block_urls, &_pc_daemon_server_dbus_method_info_set_user_daemon_admin, &_pc_daemon_server_dbus_method_info_get_user_daemon_active, &_pc_daemon_server_dbus_method_info_get_user_daemon_targets, &_pc_daemon_server_dbus_method_info_get_user_daemon_block_urls, &_pc_daemon_server_dbus_method_info_get_user_daemon_admin, NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_launch_args = {-1, "args", "as", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_launch_incoming = {-1, "incoming", "b", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_launch[] = {&_pc_daemon_server_dbus_arg_info_launch_args, &_pc_daemon_server_dbus_arg_info_launch_incoming, NULL};
static const GDBusSignalInfo _pc_daemon_server_dbus_signal_info_launch = {-1, "Launch", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_launch), NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_show_timeout_hours = {-1, "hours", "i", NULL};
static const GDBusArgInfo _pc_daemon_server_dbus_arg_info_show_timeout_minutes = {-1, "minutes", "i", NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_show_timeout[] = {&_pc_daemon_server_dbus_arg_info_show_timeout_hours, &_pc_daemon_server_dbus_arg_info_show_timeout_minutes, NULL};
static const GDBusSignalInfo _pc_daemon_server_dbus_signal_info_show_timeout = {-1, "ShowTimeout", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_show_timeout), NULL};
static const GDBusArgInfo * const _pc_daemon_server_dbus_arg_info_config_changed[] = {NULL};
static const GDBusSignalInfo _pc_daemon_server_dbus_signal_info_config_changed = {-1, "ConfigChanged", (GDBusArgInfo **) (&_pc_daemon_server_dbus_arg_info_config_changed), NULL};
static const GDBusSignalInfo * const _pc_daemon_server_dbus_signal_info[] = {&_pc_daemon_server_dbus_signal_info_launch, &_pc_daemon_server_dbus_signal_info_show_timeout, &_pc_daemon_server_dbus_signal_info_config_changed, NULL};
static const GDBusPropertyInfo * const _pc_daemon_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pc_daemon_server_dbus_interface_info = {-1, "org.pantheon.ParentalControls", (GDBusMethodInfo **) (&_pc_daemon_server_dbus_method_info), (GDBusSignalInfo **) (&_pc_daemon_server_dbus_signal_info), (GDBusPropertyInfo **) (&_pc_daemon_server_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pc_daemon_server_dbus_interface_vtable = {pc_daemon_server_dbus_interface_method_call, pc_daemon_server_dbus_interface_get_property, pc_daemon_server_dbus_interface_set_property};

guint32
pc_daemon_dbus_get_connection_unix_process_id (PCDaemonDBus* self,
                                               const gchar* name,
                                               GError** error)
{
	PCDaemonDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = PC_DAEMON_DBUS_GET_INTERFACE (self);
	if (_iface_->get_connection_unix_process_id) {
		return _iface_->get_connection_unix_process_id (self, name, error);
	}
	return 0U;
}

guint32
pc_daemon_dbus_get_connection_unix_user (PCDaemonDBus* self,
                                         const gchar* name,
                                         GError** error)
{
	PCDaemonDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = PC_DAEMON_DBUS_GET_INTERFACE (self);
	if (_iface_->get_connection_unix_user) {
		return _iface_->get_connection_unix_user (self, name, error);
	}
	return 0U;
}

static void
pc_daemon_dbus_default_init (PCDaemonDBusIface * iface,
                             gpointer iface_data)
{
}

static GType
pc_daemon_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pc_daemon_dbus_type_id;
	pc_daemon_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "PCDaemonDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pc_daemon_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pc_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pc_daemon_dbus_proxy_get_type);
	g_type_set_qdata (pc_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (pc_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pc_daemon_dbus_dbus_interface_info));
	g_type_set_qdata (pc_daemon_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pc_daemon_dbus_register_object);
	return pc_daemon_dbus_type_id;
}

GType
pc_daemon_dbus_get_type (void)
{
	static volatile gsize pc_daemon_dbus_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_dbus_type_id__once)) {
		GType pc_daemon_dbus_type_id;
		pc_daemon_dbus_type_id = pc_daemon_dbus_get_type_once ();
		g_once_init_leave (&pc_daemon_dbus_type_id__once, pc_daemon_dbus_type_id);
	}
	return pc_daemon_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PCDaemonDBusProxy, pc_daemon_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PC_DAEMON_TYPE_DBUS, pc_daemon_dbus_proxy_pc_daemon_dbus_interface_init) )
static void
pc_daemon_dbus_proxy_class_init (PCDaemonDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pc_daemon_dbus_proxy_g_signal;
}

static void
pc_daemon_dbus_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
}

static void
pc_daemon_dbus_proxy_init (PCDaemonDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pc_daemon_dbus_dbus_interface_info));
}

static guint32
pc_daemon_dbus_proxy_get_connection_unix_process_id (PCDaemonDBus* self,
                                                     const gchar* name,
                                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp2_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetConnectionUnixProcessID");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		guint32 _tmp0_ = 0U;
		return _tmp0_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp1_ = 0U;
		g_object_unref (_reply_message);
		return _tmp1_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp2_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	g_object_unref (_reply_message);
	return _result;
}

static guint32
pc_daemon_dbus_proxy_get_connection_unix_user (PCDaemonDBus* self,
                                               const gchar* name,
                                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp5_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "GetConnectionUnixUser");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		guint32 _tmp3_ = 0U;
		return _tmp3_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp4_ = 0U;
		g_object_unref (_reply_message);
		return _tmp4_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp5_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	g_object_unref (_reply_message);
	return _result;
}

static void
pc_daemon_dbus_proxy_pc_daemon_dbus_interface_init (PCDaemonDBusIface* iface)
{
	iface->get_connection_unix_process_id = pc_daemon_dbus_proxy_get_connection_unix_process_id;
	iface->get_connection_unix_user = pc_daemon_dbus_proxy_get_connection_unix_user;
}

static void
_dbus_pc_daemon_dbus_get_connection_unix_process_id (PCDaemonDBus* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	result = pc_daemon_dbus_get_connection_unix_process_id (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
_dbus_pc_daemon_dbus_get_connection_unix_user (PCDaemonDBus* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp7_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	result = pc_daemon_dbus_get_connection_unix_user (self, name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
pc_daemon_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetConnectionUnixProcessID") == 0) {
		_dbus_pc_daemon_dbus_get_connection_unix_process_id (object, parameters, invocation);
	} else if (strcmp (method_name, "GetConnectionUnixUser") == 0) {
		_dbus_pc_daemon_dbus_get_connection_unix_user (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pc_daemon_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pc_daemon_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
pc_daemon_dbus_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pc_daemon_dbus_dbus_interface_info), &_pc_daemon_dbus_dbus_interface_vtable, data, _pc_daemon_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_pc_daemon_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GQuark
pc_daemon_parental_controls_error_quark (void)
{
	static volatile gsize pc_daemon_parental_controls_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("pc-daemon-parental-controls-error-quark", &pc_daemon_parental_controls_error_quark_volatile, pc_daemon_parental_controls_error_entries, G_N_ELEMENTS (pc_daemon_parental_controls_error_entries));
	return (GQuark) pc_daemon_parental_controls_error_quark_volatile;
}

static inline gpointer
pc_daemon_server_get_instance_private (PCDaemonServer* self)
{
	return G_STRUCT_MEMBER_P (self, PCDaemonServer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PCDaemonServer*
pc_daemon_server_get_default (void)
{
	PCDaemonServer* _tmp0_;
	PCDaemonServer* _tmp2_;
	PCDaemonServer* _tmp3_;
	PCDaemonServer* result;
	_tmp0_ = pc_daemon_server_instance;
	if (_tmp0_ == NULL) {
		PCDaemonServer* _tmp1_;
		_tmp1_ = pc_daemon_server_new ();
		_g_object_unref0 (pc_daemon_server_instance);
		pc_daemon_server_instance = _tmp1_;
	}
	_tmp2_ = pc_daemon_server_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_pc_daemon_server_on_config_changed_pc_daemon_server_config_changed (PCDaemonServer* _sender,
                                                                     gpointer self)
{
	pc_daemon_server_on_config_changed ((PCDaemonServer*) self);
}

PCDaemonServer*
pc_daemon_server_construct (GType object_type)
{
	PCDaemonServer * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (PCDaemonServer*) g_object_new (object_type, NULL);
	{
		PCDaemonDBus* _tmp0_ = NULL;
		PCDaemonDBus* _tmp1_;
		PCDaemonDBus* _tmp2_;
		_tmp1_ = (PCDaemonDBus*) g_initable_new (PC_DAEMON_TYPE_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.freedesktop.DBus", NULL);
		_tmp0_ = (PCDaemonDBus*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->bus_proxy);
		self->priv->bus_proxy = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Server.vala:59: %s", _tmp4_);
		_g_object_unref0 (self->priv->bus_proxy);
		self->priv->bus_proxy = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	pc_daemon_user_config_init ();
	g_signal_connect_object (self, "config-changed", (GCallback) _pc_daemon_server_on_config_changed_pc_daemon_server_config_changed, self, 0);
	return self;
}

PCDaemonServer*
pc_daemon_server_new (void)
{
	return pc_daemon_server_construct (PC_DAEMON_TYPE_SERVER);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PCDaemonServer* self;
		self = _data2_->self;
		_g_free0 (_data2_->username);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PCDaemonServer* self;
		self = _data3_->_data2_->self;
		_g_free0 (_data3_->path);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
____lambda12_ (Block3Data* _data3_,
               gchar** args,
               gint args_length1,
               gboolean incoming)
{
	Block2Data* _data2_;
	PCDaemonServer* self;
	const gchar* _tmp0_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	if (incoming) {
		return;
	}
	g_signal_handler_disconnect ((GObject*) self, _data3_->launch_signal_id);
	if (_data3_->timeout_signal_id != 0U) {
		g_source_remove (_data3_->timeout_signal_id);
	}
	_tmp0_ = _data3_->path;
	pc_access_control_lists_setfacl (_data2_->username, _tmp0_, PC_ACCESS_CONTROL_LISTS_NO_EXEC_PERMISSIONS);
}

static void
_____lambda12__pc_daemon_server_launch (PCDaemonServer* _sender,
                                        gchar** args,
                                        gint args_length1,
                                        gboolean incoming,
                                        gpointer self)
{
	____lambda12_ (self, args, args_length1, incoming);
}

static gboolean
____lambda13_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	PCDaemonServer* self;
	const gchar* _tmp0_;
	gboolean result;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_warning ("Server.vala:118: Max timeout reached (%u ms): client did not respond.", PC_DAEMON_SERVER_CLIENT_LAUNCH_TIMEOUT);
	if (_data3_->launch_signal_id != ((gulong) 0U)) {
		g_signal_handler_disconnect ((GObject*) self, _data3_->launch_signal_id);
	}
	_tmp0_ = _data3_->path;
	pc_access_control_lists_setfacl (_data2_->username, _tmp0_, PC_ACCESS_CONTROL_LISTS_NO_EXEC_PERMISSIONS);
	result = FALSE;
	return result;
}

static gboolean
_____lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda13_ (self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
pc_daemon_server_finish_app_authorization (PCDaemonServer* self,
                                           const char* sender,
                                           const gchar* username,
                                           gchar** args,
                                           gint args_length1,
                                           GError** error)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp1_;
	gboolean _tmp2_ = FALSE;
	PCDaemonUserConfig* _tmp3_;
	guint32 client_pid = 0U;
	PolkitAuthority* authority = NULL;
	PolkitAuthority* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (username != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (username);
	_g_free0 (_data2_->username);
	_data2_->username = _tmp0_;
	_tmp1_ = pc_daemon_user_config_get_for_username (_data2_->username, FALSE);
	config = _tmp1_;
	_tmp3_ = config;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PCDaemonUserConfig* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = config;
		_tmp5_ = pc_daemon_user_config_get_admin (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	}
	if (_tmp2_) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp7_ = g_strdup_printf ("Error: config for %s is not valid or does not have an ability to autho" \
"rize", _data2_->username);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	client_pid = pc_daemon_server_get_pid_from_sender (self, sender);
	_tmp11_ = polkit_authority_get_sync (NULL, &_inner_error0_);
	authority = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	{
		PolkitUnixUser* unix_user = NULL;
		PolkitUnixUser* _tmp12_;
		PolkitAuthorizationResult* _result_ = NULL;
		PolkitAuthority* _tmp13_;
		PolkitUnixUser* _tmp14_;
		PolkitUnixProcess* _tmp15_;
		PolkitUnixProcess* _tmp16_;
		PolkitAuthorizationResult* _tmp17_;
		PolkitAuthorizationResult* _tmp18_;
		PolkitAuthorizationResult* _tmp19_;
		_tmp12_ = (PolkitUnixUser*) polkit_unix_user_new_for_name (_data2_->username, &_inner_error0_);
		unix_user = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = authority;
		_tmp14_ = unix_user;
		_tmp15_ = (PolkitUnixProcess*) polkit_unix_process_new_for_owner ((gint) client_pid, (guint64) 0, polkit_unix_user_get_uid (_tmp14_));
		_tmp16_ = _tmp15_;
		_tmp17_ = polkit_authority_check_authorization_sync (_tmp13_, (PolkitSubject*) _tmp16_, PC_CONSTANTS_PARENTAL_CONTROLS_ACTION_ID, NULL, POLKIT_CHECK_AUTHORIZATION_FLAGS_NONE, NULL, &_inner_error0_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_result_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (unix_user);
			goto __catch0_g_error;
		}
		_tmp19_ = _result_;
		if (polkit_authorization_result_get_is_authorized (_tmp19_)) {
			Block3Data* _data3_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp25_;
			gulong _tmp26_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->_data2_ = block2_data_ref (_data2_);
			_tmp20_ = args[0];
			_tmp21_ = g_find_program_in_path (_tmp20_);
			_data3_->path = _tmp21_;
			_tmp22_ = _data3_->path;
			if (_tmp22_ == NULL) {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = args[0];
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (_data3_->path);
				_data3_->path = _tmp24_;
			}
			_tmp25_ = _data3_->path;
			pc_access_control_lists_setfacl (_data2_->username, _tmp25_, "--x");
			_data3_->launch_signal_id = (gulong) 0U;
			_data3_->timeout_signal_id = 0U;
			_tmp26_ = g_signal_connect_data (self, "launch", (GCallback) _____lambda12__pc_daemon_server_launch, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
			_data3_->launch_signal_id = _tmp26_;
			_data3_->timeout_signal_id = g_timeout_add_full (G_PRIORITY_DEFAULT, PC_DAEMON_SERVER_CLIENT_LAUNCH_TIMEOUT, _____lambda13__gsource_func, block3_data_ref (_data3_), block3_data_unref);
			g_signal_emit (self, pc_daemon_server_signals[PC_DAEMON_SERVER_LAUNCH_SIGNAL], 0, args, (gint) args_length1, TRUE);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_g_object_unref0 (_result_);
		_g_object_unref0 (unix_user);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		GError* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _g_error_copy0 (_tmp27_);
		_inner_error0_ = _tmp28_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (authority);
		_g_object_unref0 (config);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_g_object_unref0 (authority);
	_g_object_unref0 (config);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
pc_daemon_server_add_restriction_for_user (PCDaemonServer* self,
                                           const gchar* input,
                                           gboolean clean,
                                           const char* sender,
                                           GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCPAMWriter* writer = NULL;
	PCPAMWriter* _tmp2_;
	PCPAMWriter* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	pc_daemon_server_ensure_pam_lightdm_enabled (self);
	_tmp2_ = pc_pam_writer_new_for_time ();
	writer = _tmp2_;
	_tmp3_ = writer;
	pc_pam_writer_add_restriction_for_user (_tmp3_, input, clean);
	_g_object_unref0 (writer);
}

void
pc_daemon_server_remove_restriction_for_user (PCDaemonServer* self,
                                              const gchar* username,
                                              const char* sender,
                                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCPAMWriter* writer = NULL;
	PCPAMWriter* _tmp2_;
	PCPAMWriter* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = pc_pam_writer_new_for_time ();
	writer = _tmp2_;
	_tmp3_ = writer;
	pc_pam_writer_remove_restriction_for_user (_tmp3_, username);
	_g_object_unref0 (writer);
}

void
pc_daemon_server_lock_dock_icons_for_user (PCDaemonServer* self,
                                           const gchar* username,
                                           gboolean lock,
                                           const char* sender,
                                           GError** error)
{
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_IMPLEMENTED, "Error: not implemented");
	_inner_error0_ = _tmp0_;
	g_propagate_error (error, _inner_error0_);
	return;
}

void
pc_daemon_server_set_user_daemon_active (PCDaemonServer* self,
                                         const gchar* username,
                                         gboolean active,
                                         const char* sender,
                                         GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp2_;
	PCDaemonUserConfig* _tmp3_;
	PCDaemonUserConfig* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = pc_daemon_user_config_get_for_username (username, TRUE);
	config = _tmp2_;
	_tmp3_ = config;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or could not be created", username);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return;
	}
	_tmp5_ = config;
	pc_daemon_user_config_set_active (_tmp5_, active);
	_g_object_unref0 (config);
}

void
pc_daemon_server_set_user_daemon_targets (PCDaemonServer* self,
                                          const gchar* username,
                                          gchar** targets,
                                          gint targets_length1,
                                          const char* sender,
                                          GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp2_;
	PCDaemonUserConfig* _tmp3_;
	PCDaemonUserConfig* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = pc_daemon_user_config_get_for_username (username, TRUE);
	config = _tmp2_;
	_tmp3_ = config;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or could not be created", username);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return;
	}
	_tmp5_ = config;
	pc_daemon_user_config_set_targets (_tmp5_, targets, targets_length1);
	_g_object_unref0 (config);
}

void
pc_daemon_server_set_user_daemon_block_urls (PCDaemonServer* self,
                                             const gchar* username,
                                             gchar** block_urls,
                                             gint block_urls_length1,
                                             const char* sender,
                                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp2_;
	PCDaemonUserConfig* _tmp3_;
	PCDaemonUserConfig* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = pc_daemon_user_config_get_for_username (username, TRUE);
	config = _tmp2_;
	_tmp3_ = config;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or could not be created", username);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return;
	}
	_tmp5_ = config;
	pc_daemon_user_config_set_block_urls (_tmp5_, block_urls, block_urls_length1);
	_g_object_unref0 (config);
}

void
pc_daemon_server_set_user_daemon_admin (PCDaemonServer* self,
                                        const gchar* username,
                                        gboolean admin,
                                        const char* sender,
                                        GError** error)
{
	gboolean _tmp0_ = FALSE;
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp2_;
	PCDaemonUserConfig* _tmp3_;
	PCDaemonUserConfig* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = pc_daemon_server_get_sender_is_authorized (self, sender, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!_tmp0_) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_NOT_AUTHORIZED, "Error: sender not authorized");
		_inner_error0_ = _tmp1_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = pc_daemon_user_config_get_for_username (username, TRUE);
	config = _tmp2_;
	_tmp3_ = config;
	if (_tmp3_ == NULL) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or could not be created", username);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return;
	}
	_tmp5_ = config;
	pc_daemon_user_config_set_admin (_tmp5_, admin);
	_g_object_unref0 (config);
}

gboolean
pc_daemon_server_get_user_daemon_active (PCDaemonServer* self,
                                         const gchar* username,
                                         GError** error)
{
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp0_;
	PCDaemonUserConfig* _tmp1_;
	PCDaemonUserConfig* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (username != NULL, FALSE);
	_tmp0_ = pc_daemon_user_config_get_for_username (username, FALSE);
	config = _tmp0_;
	_tmp1_ = config;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or does not exist", username);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return _tmp3_;
	}
	_tmp4_ = config;
	_tmp5_ = pc_daemon_user_config_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	_g_object_unref0 (config);
	return result;
}

gchar**
pc_daemon_server_get_user_daemon_targets (PCDaemonServer* self,
                                          const gchar* username,
                                          gint* result_length1,
                                          GError** error)
{
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp0_;
	PCDaemonUserConfig* _tmp1_;
	PCDaemonUserConfig* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = pc_daemon_user_config_get_for_username (username, FALSE);
	config = _tmp0_;
	_tmp1_ = config;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or does not exist", username);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp3_ = config;
	_tmp4_ = pc_daemon_user_config_get_targets (_tmp3_, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (config);
	return result;
}

gchar**
pc_daemon_server_get_user_daemon_block_urls (PCDaemonServer* self,
                                             const gchar* username,
                                             gint* result_length1,
                                             GError** error)
{
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp0_;
	PCDaemonUserConfig* _tmp1_;
	PCDaemonUserConfig* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (username != NULL, NULL);
	_tmp0_ = pc_daemon_user_config_get_for_username (username, FALSE);
	config = _tmp0_;
	_tmp1_ = config;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or does not exist", username);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return NULL;
	}
	_tmp3_ = config;
	_tmp4_ = pc_daemon_user_config_get_block_urls (_tmp3_, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (config);
	return result;
}

gboolean
pc_daemon_server_get_user_daemon_admin (PCDaemonServer* self,
                                        const gchar* username,
                                        GError** error)
{
	PCDaemonUserConfig* config = NULL;
	PCDaemonUserConfig* _tmp0_;
	PCDaemonUserConfig* _tmp1_;
	PCDaemonUserConfig* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (username != NULL, FALSE);
	_tmp0_ = pc_daemon_user_config_get_for_username (username, FALSE);
	config = _tmp0_;
	_tmp1_ = config;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = g_error_new (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_USER_CONFIG_NOT_VAILD, "Error: config for %s is not valid or does not exist", username);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (config);
		return _tmp3_;
	}
	_tmp4_ = config;
	_tmp5_ = pc_daemon_user_config_get_admin (_tmp4_);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	_g_object_unref0 (config);
	return result;
}

static void
pc_daemon_server_on_config_changed (PCDaemonServer* self)
{
	PCDaemonSessionHandler* current_handler = NULL;
	PCDaemonSessionManager* _tmp0_;
	PCDaemonSessionManager* _tmp1_;
	PCDaemonSessionHandler* _tmp2_;
	PCDaemonSessionHandler* _tmp3_;
	PCDaemonSessionHandler* _tmp4_;
	PCDaemonSessionHandler* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pc_daemon_session_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_handler;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	current_handler = _tmp4_;
	_tmp5_ = current_handler;
	if (_tmp5_ != NULL) {
		PCDaemonSessionHandler* _tmp6_;
		_tmp6_ = current_handler;
		pc_daemon_session_handler_update (_tmp6_);
	}
	_g_object_unref0 (current_handler);
}

static void
_vala_array_add2 (const gchar** * array,
                  gint* length,
                  gint* size,
                  const gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
pc_daemon_server_ensure_pam_lightdm_enabled (PCDaemonServer* self)
{
	const gchar** config_dirs = NULL;
	const gchar* _tmp0_;
	const gchar** _tmp1_;
	gint config_dirs_length1;
	gint _config_dirs_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar* path = NULL;
	const gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp11_;
	gchar* contents = NULL;
	gchar* conf_line = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_new0 (const gchar*, 0 + 1);
	_tmp1_[0] = _tmp0_;
	config_dirs = _tmp1_;
	config_dirs_length1 = 0;
	_config_dirs_size_ = config_dirs_length1;
	_tmp3_ = _tmp2_ = g_get_system_config_dirs ();
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp3_;
		dir_collection_length1 = _vala_array_length (_tmp2_);
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp4_;
				_tmp4_ = dir;
				_vala_array_add2 (&config_dirs, &config_dirs_length1, &_config_dirs_size_, _tmp4_);
			}
		}
	}
	path = NULL;
	_tmp5_ = config_dirs;
	_tmp5__length1 = config_dirs_length1;
	{
		const gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp5_;
		dir_collection_length1 = _tmp5__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* file_path = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp6_ = dir;
				_tmp7_ = g_build_filename (_tmp6_, "pam.d", "lightdm", NULL);
				file_path = _tmp7_;
				_tmp8_ = file_path;
				if (g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = file_path;
					_tmp10_ = g_strdup (_tmp9_);
					_g_free0 (path);
					path = _tmp10_;
					_g_free0 (file_path);
					break;
				}
				_g_free0 (file_path);
			}
		}
	}
	_tmp11_ = path;
	if (_tmp11_ == NULL) {
		g_critical ("Server.vala:313: No pam.d lightdm found");
		_g_free0 (path);
		config_dirs = (g_free (config_dirs), NULL);
		return;
	}
	{
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		_tmp12_ = path;
		g_file_get_contents (_tmp12_, &_tmp13_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			_g_free0 (path);
			config_dirs = (g_free (config_dirs), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("Server.vala:321: %s", _tmp15_);
		_g_error_free0 (e);
		_g_free0 (contents);
		_g_free0 (path);
		config_dirs = (g_free (config_dirs), NULL);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_free0 (path);
		config_dirs = (g_free (config_dirs), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = g_strdup ("\naccount required pam_time.so");
	conf_line = _tmp16_;
	_tmp17_ = contents;
	_tmp18_ = conf_line;
	if (string_contains (_tmp17_, _tmp18_)) {
		_g_free0 (conf_line);
		_g_free0 (contents);
		_g_free0 (path);
		config_dirs = (g_free (config_dirs), NULL);
		return;
	}
	_tmp19_ = contents;
	_tmp20_ = conf_line;
	_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
	_g_free0 (contents);
	contents = _tmp21_;
	{
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = path;
		_tmp23_ = contents;
		g_file_set_contents (_tmp22_, _tmp23_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (conf_line);
			_g_free0 (contents);
			_g_free0 (path);
			config_dirs = (g_free (config_dirs), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("Server.vala:335: %s\n", _tmp25_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (conf_line);
		_g_free0 (contents);
		_g_free0 (path);
		config_dirs = (g_free (config_dirs), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (conf_line);
	_g_free0 (contents);
	_g_free0 (path);
	config_dirs = (g_free (config_dirs), NULL);
}

static gboolean
pc_daemon_server_get_sender_is_authorized (PCDaemonServer* self,
                                           const char* sender,
                                           GError** error)
{
	PCDaemonDBus* _tmp0_;
	guint32 user = 0U;
	guint32 pid = 0U;
	PolkitUnixProcess* subject = NULL;
	PolkitUnixProcess* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = self->priv->bus_proxy;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (PC_DAEMON_PARENTAL_CONTROLS_ERROR, PC_DAEMON_PARENTAL_CONTROLS_ERROR_DBUS_CONNECTION_FAILED, "Error: connecting to org.freedesktop.DBus failed.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == PC_DAEMON_PARENTAL_CONTROLS_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	user = (guint32) 0;
	pid = (guint32) 0;
	{
		guint32 _tmp4_ = 0U;
		PCDaemonDBus* _tmp5_;
		pid = pc_daemon_server_get_pid_from_sender (self, sender);
		_tmp5_ = self->priv->bus_proxy;
		_tmp4_ = pc_daemon_dbus_get_connection_unix_user (_tmp5_, (const gchar*) sender, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		user = _tmp4_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("Server.vala:352: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PC_DAEMON_PARENTAL_CONTROLS_ERROR) {
			gboolean _tmp8_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp8_;
		} else {
			gboolean _tmp9_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	_tmp10_ = (PolkitUnixProcess*) polkit_unix_process_new_for_owner ((gint) pid, (guint64) 0, (gint) user);
	subject = _tmp10_;
	{
		PolkitAuthority* authority = NULL;
		PolkitAuthority* _tmp11_;
		PolkitAuthorizationResult* auth_result = NULL;
		PolkitAuthority* _tmp12_;
		PolkitUnixProcess* _tmp13_;
		PolkitAuthorizationResult* _tmp14_;
		PolkitAuthorizationResult* _tmp15_;
		_tmp11_ = polkit_authority_get_sync (NULL, &_inner_error0_);
		authority = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp12_ = authority;
		_tmp13_ = subject;
		_tmp14_ = polkit_authority_check_authorization_sync (_tmp12_, (PolkitSubject*) _tmp13_, PC_CONSTANTS_PARENTAL_CONTROLS_ACTION_ID, NULL, POLKIT_CHECK_AUTHORIZATION_FLAGS_NONE, NULL, &_inner_error0_);
		auth_result = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (authority);
			goto __catch1_g_error;
		}
		_tmp15_ = auth_result;
		result = polkit_authorization_result_get_is_authorized (_tmp15_);
		_g_object_unref0 (auth_result);
		_g_object_unref0 (authority);
		_g_object_unref0 (subject);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("Server.vala:367: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PC_DAEMON_PARENTAL_CONTROLS_ERROR) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (subject);
			return _tmp18_;
		} else {
			gboolean _tmp19_ = FALSE;
			_g_object_unref0 (subject);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp19_;
		}
	}
	result = FALSE;
	_g_object_unref0 (subject);
	return result;
}

static guint32
pc_daemon_server_get_pid_from_sender (PCDaemonServer* self,
                                      const char* sender)
{
	guint32 pid = 0U;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (sender != NULL, 0U);
	pid = (guint32) 0;
	{
		guint32 _tmp0_ = 0U;
		PCDaemonDBus* _tmp1_;
		_tmp1_ = self->priv->bus_proxy;
		_tmp0_ = pc_daemon_dbus_get_connection_unix_process_id (_tmp1_, (const gchar*) sender, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		pid = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Server.vala:379: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp4_ = 0U;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = pid;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOXED_INT_BOOLEAN (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_INT_BOOLEAN) (gpointer data1, gpointer arg_1, gint arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
pc_daemon_server_class_init (PCDaemonServerClass * klass,
                             gpointer klass_data)
{
	pc_daemon_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCDaemonServer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pc_daemon_server_finalize;
	pc_daemon_server_signals[PC_DAEMON_SERVER_LAUNCH_SIGNAL] = g_signal_new ("launch", PC_DAEMON_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_BOOLEAN, G_TYPE_NONE, 3, G_TYPE_STRV, G_TYPE_INT, G_TYPE_BOOLEAN);
	pc_daemon_server_signals[PC_DAEMON_SERVER_SHOW_TIMEOUT_SIGNAL] = g_signal_new ("show-timeout", PC_DAEMON_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	pc_daemon_server_signals[PC_DAEMON_SERVER_CONFIG_CHANGED_SIGNAL] = g_signal_new ("config-changed", PC_DAEMON_TYPE_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pc_daemon_server_instance_init (PCDaemonServer * self,
                                gpointer klass)
{
	self->priv = pc_daemon_server_get_instance_private (self);
	self->priv->bus_proxy = NULL;
}

static void
pc_daemon_server_finalize (GObject * obj)
{
	PCDaemonServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_DAEMON_TYPE_SERVER, PCDaemonServer);
	_g_object_unref0 (self->priv->bus_proxy);
	G_OBJECT_CLASS (pc_daemon_server_parent_class)->finalize (obj);
}

static GType
pc_daemon_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCDaemonServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_daemon_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCDaemonServer), 0, (GInstanceInitFunc) pc_daemon_server_instance_init, NULL };
	GType pc_daemon_server_type_id;
	pc_daemon_server_type_id = g_type_register_static (G_TYPE_OBJECT, "PCDaemonServer", &g_define_type_info, 0);
	g_type_set_qdata (pc_daemon_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pc_daemon_server_register_object);
	PCDaemonServer_private_offset = g_type_add_instance_private (pc_daemon_server_type_id, sizeof (PCDaemonServerPrivate));
	return pc_daemon_server_type_id;
}

GType
pc_daemon_server_get_type (void)
{
	static volatile gsize pc_daemon_server_type_id__once = 0;
	if (g_once_init_enter (&pc_daemon_server_type_id__once)) {
		GType pc_daemon_server_type_id;
		pc_daemon_server_type_id = pc_daemon_server_get_type_once ();
		g_once_init_leave (&pc_daemon_server_type_id__once, pc_daemon_server_type_id);
	}
	return pc_daemon_server_type_id__once;
}

static void
_dbus_pc_daemon_server_finish_app_authorization (PCDaemonServer* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp8_;
	gchar** args = NULL;
	gint args_length1 = 0;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length;
	gint _tmp10__size;
	gint _tmp10__length1;
	GVariantIter _tmp11_;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp10_ = g_new (gchar*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	g_variant_iter_init (&_tmp11_, _tmp9_);
	for (; (_tmp12_ = g_variant_iter_next_value (&_tmp11_)) != NULL; _tmp10__length1++) {
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (gchar*, _tmp10_, _tmp10__size + 1);
		}
		_tmp10_[_tmp10__length++] = g_variant_dup_string (_tmp12_, NULL);
		g_variant_unref (_tmp12_);
	}
	args_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	args = _tmp10_;
	g_variant_unref (_tmp9_);
	pc_daemon_server_finish_app_authorization (self, g_dbus_method_invocation_get_sender (invocation), username, args, args_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pc_daemon_server_add_restriction_for_user (PCDaemonServer* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* input = NULL;
	GVariant* _tmp13_;
	gboolean clean = FALSE;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	input = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	clean = g_variant_get_boolean (_tmp14_);
	g_variant_unref (_tmp14_);
	pc_daemon_server_add_restriction_for_user (self, input, clean, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (input);
	;
}

static void
_dbus_pc_daemon_server_remove_restriction_for_user (PCDaemonServer* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp15_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	pc_daemon_server_remove_restriction_for_user (self, username, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_lock_dock_icons_for_user (PCDaemonServer* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp16_;
	gboolean lock = FALSE;
	GVariant* _tmp17_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	lock = g_variant_get_boolean (_tmp17_);
	g_variant_unref (_tmp17_);
	pc_daemon_server_lock_dock_icons_for_user (self, username, lock, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_set_user_daemon_active (PCDaemonServer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp18_;
	gboolean active = FALSE;
	GVariant* _tmp19_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	active = g_variant_get_boolean (_tmp19_);
	g_variant_unref (_tmp19_);
	pc_daemon_server_set_user_daemon_active (self, username, active, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_set_user_daemon_targets (PCDaemonServer* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp20_;
	gchar** targets = NULL;
	gint targets_length1 = 0;
	GVariant* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length;
	gint _tmp22__size;
	gint _tmp22__length1;
	GVariantIter _tmp23_;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp22_ = g_new (gchar*, 5);
	_tmp22__length = 0;
	_tmp22__size = 4;
	_tmp22__length1 = 0;
	g_variant_iter_init (&_tmp23_, _tmp21_);
	for (; (_tmp24_ = g_variant_iter_next_value (&_tmp23_)) != NULL; _tmp22__length1++) {
		if (_tmp22__size == _tmp22__length) {
			_tmp22__size = 2 * _tmp22__size;
			_tmp22_ = g_renew (gchar*, _tmp22_, _tmp22__size + 1);
		}
		_tmp22_[_tmp22__length++] = g_variant_dup_string (_tmp24_, NULL);
		g_variant_unref (_tmp24_);
	}
	targets_length1 = _tmp22__length1;
	_tmp22_[_tmp22__length] = NULL;
	targets = _tmp22_;
	g_variant_unref (_tmp21_);
	pc_daemon_server_set_user_daemon_targets (self, username, targets, targets_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	targets = (_vala_array_free (targets, targets_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pc_daemon_server_set_user_daemon_block_urls (PCDaemonServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp25_;
	gchar** block_urls = NULL;
	gint block_urls_length1 = 0;
	GVariant* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length;
	gint _tmp27__size;
	gint _tmp27__length1;
	GVariantIter _tmp28_;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp27_ = g_new (gchar*, 5);
	_tmp27__length = 0;
	_tmp27__size = 4;
	_tmp27__length1 = 0;
	g_variant_iter_init (&_tmp28_, _tmp26_);
	for (; (_tmp29_ = g_variant_iter_next_value (&_tmp28_)) != NULL; _tmp27__length1++) {
		if (_tmp27__size == _tmp27__length) {
			_tmp27__size = 2 * _tmp27__size;
			_tmp27_ = g_renew (gchar*, _tmp27_, _tmp27__size + 1);
		}
		_tmp27_[_tmp27__length++] = g_variant_dup_string (_tmp29_, NULL);
		g_variant_unref (_tmp29_);
	}
	block_urls_length1 = _tmp27__length1;
	_tmp27_[_tmp27__length] = NULL;
	block_urls = _tmp27_;
	g_variant_unref (_tmp26_);
	pc_daemon_server_set_user_daemon_block_urls (self, username, block_urls, block_urls_length1, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	block_urls = (_vala_array_free (block_urls, block_urls_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pc_daemon_server_set_user_daemon_admin (PCDaemonServer* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp30_;
	gboolean admin = FALSE;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	admin = g_variant_get_boolean (_tmp31_);
	g_variant_unref (_tmp31_);
	pc_daemon_server_set_user_daemon_admin (self, username, admin, g_dbus_method_invocation_get_sender (invocation), &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_get_user_daemon_active (PCDaemonServer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp32_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	result = pc_daemon_server_get_user_daemon_active (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_get_user_daemon_targets (PCDaemonServer* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp33_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp34_;
	GVariantBuilder _tmp35_;
	gint _tmp36_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	result = pc_daemon_server_get_user_daemon_targets (self, username, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp34_ = result;
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE ("as"));
	for (_tmp36_ = 0; _tmp36_ < result_length1; _tmp36_++) {
		g_variant_builder_add_value (&_tmp35_, g_variant_new_string (*_tmp34_));
		_tmp34_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp35_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_get_user_daemon_block_urls (PCDaemonServer* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp37_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp38_;
	GVariantBuilder _tmp39_;
	gint _tmp40_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp37_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp37_, NULL);
	g_variant_unref (_tmp37_);
	result = pc_daemon_server_get_user_daemon_block_urls (self, username, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp38_ = result;
	g_variant_builder_init (&_tmp39_, G_VARIANT_TYPE ("as"));
	for (_tmp40_ = 0; _tmp40_ < result_length1; _tmp40_++) {
		g_variant_builder_add_value (&_tmp39_, g_variant_new_string (*_tmp38_));
		_tmp38_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp39_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
_dbus_pc_daemon_server_get_user_daemon_admin (PCDaemonServer* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp41_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp41_, NULL);
	g_variant_unref (_tmp41_);
	result = pc_daemon_server_get_user_daemon_admin (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
pc_daemon_server_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FinishAppAuthorization") == 0) {
		_dbus_pc_daemon_server_finish_app_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "AddRestrictionForUser") == 0) {
		_dbus_pc_daemon_server_add_restriction_for_user (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveRestrictionForUser") == 0) {
		_dbus_pc_daemon_server_remove_restriction_for_user (object, parameters, invocation);
	} else if (strcmp (method_name, "LockDockIconsForUser") == 0) {
		_dbus_pc_daemon_server_lock_dock_icons_for_user (object, parameters, invocation);
	} else if (strcmp (method_name, "SetUserDaemonActive") == 0) {
		_dbus_pc_daemon_server_set_user_daemon_active (object, parameters, invocation);
	} else if (strcmp (method_name, "SetUserDaemonTargets") == 0) {
		_dbus_pc_daemon_server_set_user_daemon_targets (object, parameters, invocation);
	} else if (strcmp (method_name, "SetUserDaemonBlockUrls") == 0) {
		_dbus_pc_daemon_server_set_user_daemon_block_urls (object, parameters, invocation);
	} else if (strcmp (method_name, "SetUserDaemonAdmin") == 0) {
		_dbus_pc_daemon_server_set_user_daemon_admin (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUserDaemonActive") == 0) {
		_dbus_pc_daemon_server_get_user_daemon_active (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUserDaemonTargets") == 0) {
		_dbus_pc_daemon_server_get_user_daemon_targets (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUserDaemonBlockUrls") == 0) {
		_dbus_pc_daemon_server_get_user_daemon_block_urls (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUserDaemonAdmin") == 0) {
		_dbus_pc_daemon_server_get_user_daemon_admin (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pc_daemon_server_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pc_daemon_server_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pc_daemon_server_launch (GObject* _sender,
                               gchar** args,
                               gint args_length1,
                               gboolean incoming,
                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp42_;
	GVariantBuilder _tmp43_;
	gint _tmp44_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp42_ = args;
	g_variant_builder_init (&_tmp43_, G_VARIANT_TYPE ("as"));
	for (_tmp44_ = 0; _tmp44_ < args_length1; _tmp44_++) {
		g_variant_builder_add_value (&_tmp43_, g_variant_new_string (*_tmp42_));
		_tmp42_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp43_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (incoming));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.ParentalControls", "Launch", _arguments, NULL);
}

static void
_dbus_pc_daemon_server_show_timeout (GObject* _sender,
                                     gint hours,
                                     gint minutes,
                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (hours));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (minutes));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.ParentalControls", "ShowTimeout", _arguments, NULL);
}

static void
_dbus_pc_daemon_server_config_changed (GObject* _sender,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.ParentalControls", "ConfigChanged", _arguments, NULL);
}

guint
pc_daemon_server_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pc_daemon_server_dbus_interface_info), &_pc_daemon_server_dbus_interface_vtable, data, _pc_daemon_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "launch", (GCallback) _dbus_pc_daemon_server_launch, data);
	g_signal_connect (object, "show-timeout", (GCallback) _dbus_pc_daemon_server_show_timeout, data);
	g_signal_connect (object, "config-changed", (GCallback) _dbus_pc_daemon_server_config_changed, data);
	return result;
}

static void
_pc_daemon_server_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pc_daemon_server_launch, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pc_daemon_server_show_timeout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pc_daemon_server_config_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

