/* MonitorMode.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MonitorMode.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "display.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_MONITOR_MODE_0_PROPERTY,
	DISPLAY_MONITOR_MODE_ID_PROPERTY,
	DISPLAY_MONITOR_MODE_WIDTH_PROPERTY,
	DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY,
	DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY,
	DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY,
	DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY,
	DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY,
	DISPLAY_MONITOR_MODE_NUM_PROPERTIES
};
static GParamSpec* display_monitor_mode_properties[DISPLAY_MONITOR_MODE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DisplayMonitorModePrivate {
	gchar* _id;
	gint _width;
	gint _height;
	gdouble _frequency;
	gdouble _preferred_scale;
	gboolean _is_preferred;
	gboolean _is_current;
	gchar* resolution_cache;
};

static gint DisplayMonitorMode_private_offset;
static gpointer display_monitor_mode_parent_class = NULL;

static gchar* display_monitor_mode_make_aspect_string (gint width,
                                                gint height);
static void display_monitor_mode_finalize (GObject * obj);
static GType display_monitor_mode_get_type_once (void);
static void _vala_display_monitor_mode_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_display_monitor_mode_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_monitor_mode_get_instance_private (DisplayMonitorMode* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayMonitorMode_private_offset);
}

gint
display_monitor_mode_resolution_compare_func (DisplayMonitorMode* a,
                                              DisplayMonitorMode* b)
{
	gint _tmp0_;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->priv->_width;
	_tmp1_ = b->priv->_width;
	if (_tmp0_ == _tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = a->priv->_height;
		_tmp3_ = b->priv->_height;
		if (_tmp2_ == _tmp3_) {
			result = 0;
			return result;
		} else {
			gint _tmp4_ = 0;
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = a->priv->_height;
			_tmp6_ = b->priv->_height;
			if (_tmp5_ > _tmp6_) {
				_tmp4_ = -1;
			} else {
				_tmp4_ = 1;
			}
			result = _tmp4_;
			return result;
		}
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = a->priv->_width;
		_tmp9_ = b->priv->_width;
		if (_tmp8_ > _tmp9_) {
			_tmp7_ = -1;
		} else {
			_tmp7_ = 1;
		}
		result = _tmp7_;
		return result;
	}
}

const gchar*
display_monitor_mode_get_resolution (DisplayMonitorMode* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->resolution_cache;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->_width;
		_tmp2_ = self->priv->_height;
		_tmp3_ = display_monitor_mode_get_resolution_string (_tmp1_, _tmp2_, TRUE);
		_g_free0 (self->priv->resolution_cache);
		self->priv->resolution_cache = _tmp3_;
	}
	_tmp4_ = self->priv->resolution_cache;
	result = _tmp4_;
	return result;
}

gchar*
display_monitor_mode_get_resolution_string (gint width,
                                            gint height,
                                            gboolean include_aspect)
{
	gchar* _tmp4_;
	gchar* result;
	if (include_aspect) {
		gchar* aspect = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = display_monitor_mode_make_aspect_string (width, height);
		aspect = _tmp0_;
		_tmp1_ = aspect;
		if (_tmp1_ != NULL) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = aspect;
			_tmp3_ = g_strdup_printf ("%u × %u (%s)", (guint) width, (guint) height, _tmp2_);
			result = _tmp3_;
			_g_free0 (aspect);
			return result;
		}
		_g_free0 (aspect);
	}
	_tmp4_ = g_strdup_printf ("%u × %u", (guint) width, (guint) height);
	result = _tmp4_;
	return result;
}

static gchar*
display_monitor_mode_make_aspect_string (gint width,
                                         gint height)
{
	gint ratio = 0;
	gchar* aspect = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* result;
	aspect = NULL;
	if (width == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height == 0;
	}
	if (_tmp0_) {
		result = NULL;
		_g_free0 (aspect);
		return result;
	}
	if (width > height) {
		ratio = (width * 10) / height;
	} else {
		ratio = (height * 10) / width;
	}
	switch (ratio) {
		case 13:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("4∶3");
			_g_free0 (aspect);
			aspect = _tmp1_;
			break;
		}
		case 16:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("16∶10");
			_g_free0 (aspect);
			aspect = _tmp2_;
			break;
		}
		case 17:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("16∶9");
			_g_free0 (aspect);
			aspect = _tmp3_;
			break;
		}
		case 23:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("21∶9");
			_g_free0 (aspect);
			aspect = _tmp4_;
			break;
		}
		case 12:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("5∶4");
			_g_free0 (aspect);
			aspect = _tmp5_;
			break;
		}
		case 15:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("3∶2");
			_g_free0 (aspect);
			aspect = _tmp6_;
			break;
		}
		case 18:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("9∶5");
			_g_free0 (aspect);
			aspect = _tmp7_;
			break;
		}
		case 10:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("1∶1");
			_g_free0 (aspect);
			aspect = _tmp8_;
			break;
		}
		default:
		break;
	}
	result = aspect;
	return result;
}

DisplayMonitorMode*
display_monitor_mode_construct (GType object_type)
{
	DisplayMonitorMode * self = NULL;
	self = (DisplayMonitorMode*) g_object_new (object_type, NULL);
	return self;
}

DisplayMonitorMode*
display_monitor_mode_new (void)
{
	return display_monitor_mode_construct (DISPLAY_TYPE_MONITOR_MODE);
}

const gchar*
display_monitor_mode_get_id (DisplayMonitorMode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
display_monitor_mode_set_id (DisplayMonitorMode* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_ID_PROPERTY]);
	}
}

gint
display_monitor_mode_get_width (DisplayMonitorMode* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

void
display_monitor_mode_set_width (DisplayMonitorMode* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_WIDTH_PROPERTY]);
	}
}

gint
display_monitor_mode_get_height (DisplayMonitorMode* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

void
display_monitor_mode_set_height (DisplayMonitorMode* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY]);
	}
}

gdouble
display_monitor_mode_get_frequency (DisplayMonitorMode* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_frequency;
	return result;
}

void
display_monitor_mode_set_frequency (DisplayMonitorMode* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_frequency (self);
	if (old_value != value) {
		self->priv->_frequency = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY]);
	}
}

gdouble
display_monitor_mode_get_preferred_scale (DisplayMonitorMode* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_preferred_scale;
	return result;
}

void
display_monitor_mode_set_preferred_scale (DisplayMonitorMode* self,
                                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_preferred_scale (self);
	if (old_value != value) {
		self->priv->_preferred_scale = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY]);
	}
}

gboolean
display_monitor_mode_get_is_preferred (DisplayMonitorMode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_preferred;
	return result;
}

void
display_monitor_mode_set_is_preferred (DisplayMonitorMode* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_is_preferred (self);
	if (old_value != value) {
		self->priv->_is_preferred = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY]);
	}
}

gboolean
display_monitor_mode_get_is_current (DisplayMonitorMode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_current;
	return result;
}

void
display_monitor_mode_set_is_current (DisplayMonitorMode* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_mode_get_is_current (self);
	if (old_value != value) {
		self->priv->_is_current = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY]);
	}
}

static void
display_monitor_mode_class_init (DisplayMonitorModeClass * klass,
                                 gpointer klass_data)
{
	display_monitor_mode_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayMonitorMode_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_monitor_mode_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_monitor_mode_set_property;
	G_OBJECT_CLASS (klass)->finalize = display_monitor_mode_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_ID_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_WIDTH_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY] = g_param_spec_double ("frequency", "frequency", "frequency", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY] = g_param_spec_double ("preferred-scale", "preferred-scale", "preferred-scale", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY] = g_param_spec_boolean ("is-preferred", "is-preferred", "is-preferred", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY, display_monitor_mode_properties[DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY] = g_param_spec_boolean ("is-current", "is-current", "is-current", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
display_monitor_mode_instance_init (DisplayMonitorMode * self,
                                    gpointer klass)
{
	self->priv = display_monitor_mode_get_instance_private (self);
	self->priv->resolution_cache = NULL;
}

static void
display_monitor_mode_finalize (GObject * obj)
{
	DisplayMonitorMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_MONITOR_MODE, DisplayMonitorMode);
	_g_free0 (self->priv->_id);
	self->supported_scales = (g_free (self->supported_scales), NULL);
	_g_free0 (self->priv->resolution_cache);
	G_OBJECT_CLASS (display_monitor_mode_parent_class)->finalize (obj);
}

static GType
display_monitor_mode_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayMonitorModeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_monitor_mode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayMonitorMode), 0, (GInstanceInitFunc) display_monitor_mode_instance_init, NULL };
	GType display_monitor_mode_type_id;
	display_monitor_mode_type_id = g_type_register_static (G_TYPE_OBJECT, "DisplayMonitorMode", &g_define_type_info, 0);
	DisplayMonitorMode_private_offset = g_type_add_instance_private (display_monitor_mode_type_id, sizeof (DisplayMonitorModePrivate));
	return display_monitor_mode_type_id;
}

GType
display_monitor_mode_get_type (void)
{
	static volatile gsize display_monitor_mode_type_id__once = 0;
	if (g_once_init_enter (&display_monitor_mode_type_id__once)) {
		GType display_monitor_mode_type_id;
		display_monitor_mode_type_id = display_monitor_mode_get_type_once ();
		g_once_init_leave (&display_monitor_mode_type_id__once, display_monitor_mode_type_id);
	}
	return display_monitor_mode_type_id__once;
}

static void
_vala_display_monitor_mode_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	DisplayMonitorMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR_MODE, DisplayMonitorMode);
	switch (property_id) {
		case DISPLAY_MONITOR_MODE_ID_PROPERTY:
		g_value_set_string (value, display_monitor_mode_get_id (self));
		break;
		case DISPLAY_MONITOR_MODE_WIDTH_PROPERTY:
		g_value_set_int (value, display_monitor_mode_get_width (self));
		break;
		case DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY:
		g_value_set_int (value, display_monitor_mode_get_height (self));
		break;
		case DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY:
		g_value_set_double (value, display_monitor_mode_get_frequency (self));
		break;
		case DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY:
		g_value_set_double (value, display_monitor_mode_get_preferred_scale (self));
		break;
		case DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY:
		g_value_set_boolean (value, display_monitor_mode_get_is_preferred (self));
		break;
		case DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY:
		g_value_set_boolean (value, display_monitor_mode_get_is_current (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_monitor_mode_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	DisplayMonitorMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR_MODE, DisplayMonitorMode);
	switch (property_id) {
		case DISPLAY_MONITOR_MODE_ID_PROPERTY:
		display_monitor_mode_set_id (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_MODE_WIDTH_PROPERTY:
		display_monitor_mode_set_width (self, g_value_get_int (value));
		break;
		case DISPLAY_MONITOR_MODE_HEIGHT_PROPERTY:
		display_monitor_mode_set_height (self, g_value_get_int (value));
		break;
		case DISPLAY_MONITOR_MODE_FREQUENCY_PROPERTY:
		display_monitor_mode_set_frequency (self, g_value_get_double (value));
		break;
		case DISPLAY_MONITOR_MODE_PREFERRED_SCALE_PROPERTY:
		display_monitor_mode_set_preferred_scale (self, g_value_get_double (value));
		break;
		case DISPLAY_MONITOR_MODE_IS_PREFERRED_PROPERTY:
		display_monitor_mode_set_is_preferred (self, g_value_get_boolean (value));
		break;
		case DISPLAY_MONITOR_MODE_IS_CURRENT_PROPERTY:
		display_monitor_mode_set_is_current (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

